/* KernList.c generated by valac 0.56.16, the Vala compiler
 * generated from KernList.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_KERN_LIST_0_PROPERTY,
	BIRD_FONT_KERN_LIST_NUM_PROPERTIES
};
static GParamSpec* bird_font_kern_list_properties[BIRD_FONT_KERN_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block79Data Block79Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Block79Data {
	int _ref_count_;
	BirdFontKernList* self;
	BirdFontPairFormat1* current_pairs;
};

static gpointer bird_font_kern_list_parent_class = NULL;

static Block79Data* block79_data_ref (Block79Data* _data79_);
static void block79_data_unref (void * _userdata_);
static void __lambda53_ (Block79Data* _data79_,
                  BirdFontKerningPair* kp);
static gint __lambda54_ (BirdFontKernList* self,
                  BirdFontKern* a,
                  BirdFontKern* b);
static gint ___lambda54__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void ___lambda53__bird_font_kerning_classes_kerning_iterator (BirdFontKerningPair* list,
                                                              gpointer self);
static gint __lambda55_ (BirdFontKernList* self,
                  BirdFontPairFormat1* a,
                  BirdFontPairFormat1* b);
static gint ___lambda55__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void bird_font_kern_list_finalize (GObject * obj);
static GType bird_font_kern_list_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontKernList*
bird_font_kern_list_construct (GType object_type,
                               BirdFontGlyfTable* glyf_table)
{
	BirdFontKernList * self = NULL;
	BirdFontGlyfTable* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_val_if_fail (glyf_table != NULL, NULL);
	self = (BirdFontKernList*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (glyf_table);
	_g_object_unref0 (self->glyf_table);
	self->glyf_table = _tmp0_;
	self->num_pairs = (guint) 0;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_PAIR_FORMAT1, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->pairs);
	self->pairs = _tmp1_;
	return self;
}

BirdFontKernList*
bird_font_kern_list_new (BirdFontGlyfTable* glyf_table)
{
	return bird_font_kern_list_construct (BIRD_FONT_TYPE_KERN_LIST, glyf_table);
}

/** @return number of pairs. */
static Block79Data*
block79_data_ref (Block79Data* _data79_)
{
	g_atomic_int_inc (&_data79_->_ref_count_);
	return _data79_;
}

static void
block79_data_unref (void * _userdata_)
{
	Block79Data* _data79_;
	_data79_ = (Block79Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data79_->_ref_count_)) {
		BirdFontKernList* self;
		self = _data79_->self;
		_g_object_unref0 (_data79_->current_pairs);
		_g_object_unref0 (self);
		g_slice_free (Block79Data, _data79_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gint
__lambda54_ (BirdFontKernList* self,
             BirdFontKern* a,
             BirdFontKern* b)
{
	BirdFontKern* first = NULL;
	BirdFontKern* _tmp0_;
	BirdFontKern* next = NULL;
	BirdFontKern* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_KERN, BirdFontKern));
	first = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_KERN, BirdFontKern));
	next = _tmp1_;
	result = (gint) (first->right - next->right);
	_g_object_unref0 (next);
	_g_object_unref0 (first);
	return result;
}

static gint
___lambda54__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda54_ ((BirdFontKernList*) self, (BirdFontKern*) a, (BirdFontKern*) b);
	return result;
}

static void
__lambda53_ (Block79Data* _data79_,
             BirdFontKerningPair* kp)
{
	BirdFontKernList* self;
	guint16 gid_left = 0U;
	guint16 gid_right = 0U;
	BirdFontKerningPair* kerning_pair = NULL;
	BirdFontKerningPair* _tmp0_;
	gint i = 0;
	BirdFontKerningPair* _tmp1_;
	BirdFontGlyph* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gchar* glyph_name = NULL;
	BirdFontKerningPair* _tmp6_;
	BirdFontGlyph* _tmp7_;
	gchar* _tmp8_;
	BirdFontPairFormat1* _tmp9_;
	BirdFontGlyfTable* _tmp10_;
	const gchar* _tmp11_;
	BirdFontPairFormat1* _tmp12_;
	GeeArrayList* _tmp13_;
	BirdFontPairFormat1* _tmp14_;
	BirdFontKerningPair* _tmp15_;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	BirdFontKerningPair* _tmp23_;
	GeeArrayList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	BirdFontPairFormat1* _tmp48_;
	GeeArrayList* _tmp49_;
	self = _data79_->self;
	g_return_if_fail (kp != NULL);
	_tmp0_ = _g_object_ref0 (kp);
	kerning_pair = _tmp0_;
	_tmp1_ = kerning_pair;
	_tmp2_ = _tmp1_->character;
	_tmp3_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = G_UNLIKELY (g_strcmp0 (_tmp4_, "") == 0);
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		g_warning ("KernList.vala:51: No name for glyph");
	}
	_tmp6_ = kerning_pair;
	_tmp7_ = _tmp6_->character;
	_tmp8_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp7_);
	glyph_name = _tmp8_;
	_tmp9_ = bird_font_pair_format1_new ();
	_g_object_unref0 (_data79_->current_pairs);
	_data79_->current_pairs = _tmp9_;
	_tmp10_ = self->glyf_table;
	_tmp11_ = glyph_name;
	gid_left = (guint16) bird_font_glyf_table_get_gid (_tmp10_, _tmp11_);
	if (G_UNLIKELY (((gint) gid_left) == -1)) {
		g_warning ("KernList.vala:60: Ignoring kerning for missing character: $(glyph_name" \
")");
		_g_free0 (glyph_name);
		_g_object_unref0 (kerning_pair);
		return;
	}
	_tmp12_ = _data79_->current_pairs;
	_tmp12_->left = gid_left;
	_tmp13_ = self->pairs;
	_tmp14_ = _data79_->current_pairs;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
	_tmp15_ = kerning_pair;
	_tmp16_ = _tmp15_->kerning;
	_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	if (G_UNLIKELY (_tmp18_ == 0)) {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp19_ = glyph_name;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat ("No kerning pairs for character (left): ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		g_warning ("KernList.vala:68: %s", _tmp22_);
		_g_free0 (_tmp22_);
	}
	i = 0;
	_tmp23_ = kerning_pair;
	_tmp24_ = _tmp23_->kerning;
	_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	self->num_pairs = self->num_pairs + _tmp26_;
	{
		GeeArrayList* _k_list = NULL;
		BirdFontKerningPair* _tmp27_;
		GeeArrayList* _tmp28_;
		gint _k_size = 0;
		GeeArrayList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _k_index = 0;
		_tmp27_ = kerning_pair;
		_tmp28_ = _tmp27_->kerning;
		_k_list = _tmp28_;
		_tmp29_ = _k_list;
		_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_k_size = _tmp31_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			BirdFontKerning* k = NULL;
			GeeArrayList* _tmp34_;
			gpointer _tmp35_;
			gchar* right_name = NULL;
			BirdFontKerning* _tmp36_;
			BirdFontGlyph* _tmp37_;
			BirdFontGlyph* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			BirdFontGlyfTable* _tmp41_;
			const gchar* _tmp42_;
			_k_index = _k_index + 1;
			_tmp32_ = _k_index;
			_tmp33_ = _k_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _k_list;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _k_index);
			k = (BirdFontKerning*) _tmp35_;
			_tmp36_ = k;
			_tmp37_ = bird_font_kerning_get_glyph (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp38_);
			_tmp40_ = _tmp39_;
			_g_object_unref0 (_tmp38_);
			right_name = _tmp40_;
			_tmp41_ = self->glyf_table;
			_tmp42_ = right_name;
			gid_right = (guint16) bird_font_glyf_table_get_gid (_tmp41_, _tmp42_);
			if (G_UNLIKELY (((gint) gid_right) == -1)) {
				g_warning ("KernList.vala:78: Ignoring kerning for missing character (right): $(ri" \
"ght_name)");
			} else {
				gint16 kerning_value = 0;
				BirdFontKerning* _tmp43_;
				BirdFontKern* kern = NULL;
				BirdFontKern* _tmp44_;
				BirdFontPairFormat1* _tmp45_;
				GeeArrayList* _tmp46_;
				BirdFontKern* _tmp47_;
				_tmp43_ = k;
				kerning_value = (gint16) rint (_tmp43_->val * bird_font_head_table_UNITS);
				_tmp44_ = bird_font_kern_new (gid_left, gid_right, kerning_value);
				kern = _tmp44_;
				_tmp45_ = _data79_->current_pairs;
				_tmp46_ = _tmp45_->pairs;
				_tmp47_ = kern;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp47_);
				_g_object_unref0 (kern);
			}
			_g_free0 (right_name);
			_g_object_unref0 (k);
		}
	}
	_tmp48_ = _data79_->current_pairs;
	_tmp49_ = _tmp48_->pairs;
	gee_list_sort ((GeeList*) _tmp49_, ___lambda54__gcompare_data_func, g_object_ref (self), g_object_unref);
	_g_free0 (glyph_name);
	_g_object_unref0 (kerning_pair);
}

static void
___lambda53__bird_font_kerning_classes_kerning_iterator (BirdFontKerningPair* list,
                                                         gpointer self)
{
	__lambda53_ (self, list);
}

static gint
__lambda55_ (BirdFontKernList* self,
             BirdFontPairFormat1* a,
             BirdFontPairFormat1* b)
{
	BirdFontPairFormat1* first = NULL;
	BirdFontPairFormat1* _tmp0_;
	BirdFontPairFormat1* next = NULL;
	BirdFontPairFormat1* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_PAIR_FORMAT1, BirdFontPairFormat1));
	first = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_PAIR_FORMAT1, BirdFontPairFormat1));
	next = _tmp1_;
	result = (gint) (first->left - next->left);
	_g_object_unref0 (next);
	_g_object_unref0 (first);
	return result;
}

static gint
___lambda55__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda55_ ((BirdFontKernList*) self, (BirdFontPairFormat1*) a, (BirdFontPairFormat1*) b);
	return result;
}

guint
bird_font_kern_list_fetch_all_pairs (BirdFontKernList* self)
{
	Block79Data* _data79_;
	BirdFontPairFormat1* _tmp0_;
	BirdFontKerningClasses* classes = NULL;
	gboolean _tmp1_ = FALSE;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	BirdFontFont* _tmp6_;
	BirdFontFont* _tmp7_;
	BirdFontKerningClasses* _tmp8_;
	GeeArrayList* _tmp9_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_data79_ = g_slice_new0 (Block79Data);
	_data79_->_ref_count_ = 1;
	_data79_->self = g_object_ref (self);
	_tmp0_ = bird_font_pair_format1_new ();
	_data79_->current_pairs = _tmp0_;
	_tmp2_ = self->pairs;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->num_pairs > ((guint) 0);
	}
	if (_tmp1_) {
		g_warning ("KernList.vala:38: Pairs already loaded.");
	}
	self->num_pairs = (guint) 0;
	_tmp5_ = self->pairs;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp5_);
	_tmp6_ = bird_font_bird_font_get_current_font ();
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_font_get_kerning_classes (_tmp7_);
	_g_object_unref0 (classes);
	classes = _tmp8_;
	_g_object_unref0 (_tmp7_);
	bird_font_kerning_classes_all_pairs (classes, ___lambda53__bird_font_kerning_classes_kerning_iterator, _data79_);
	_tmp9_ = self->pairs;
	gee_list_sort ((GeeList*) _tmp9_, ___lambda55__gcompare_data_func, g_object_ref (self), g_object_unref);
	result = self->num_pairs;
	_g_object_unref0 (classes);
	block79_data_unref (_data79_);
	_data79_ = NULL;
	return result;
}

/** @return the number of glyphs that is kerned on the left side in 
 * pair pos format 1.
 */
guint
bird_font_kern_list_get_length_left (BirdFontKernList* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->pairs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

/** @return the total number of pairs. */
guint
bird_font_kern_list_get_length (BirdFontKernList* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->num_pairs;
	return result;
}

void
bird_font_kern_list_all_kern (BirdFontKernList* self,
                              BirdFontKernListKernIterator iter,
                              gpointer iter_target,
                              gint limit)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = 0;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = self->pairs;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPairFormat1* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPairFormat1*) _tmp7_;
			{
				GeeArrayList* _k_list = NULL;
				BirdFontPairFormat1* _tmp8_;
				GeeArrayList* _tmp9_;
				gint _k_size = 0;
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _k_index = 0;
				_tmp8_ = p;
				_tmp9_ = _tmp8_->pairs;
				_k_list = _tmp9_;
				_tmp10_ = _k_list;
				_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_k_size = _tmp12_;
				_k_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					BirdFontKern* k = NULL;
					GeeArrayList* _tmp15_;
					gpointer _tmp16_;
					BirdFontKern* _tmp21_;
					gint _tmp22_;
					_k_index = _k_index + 1;
					_tmp13_ = _k_index;
					_tmp14_ = _k_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _k_list;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _k_index);
					k = (BirdFontKern*) _tmp16_;
					if (G_UNLIKELY (i >= limit)) {
						gchar* _tmp17_;
						gchar* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp20_;
						_tmp17_ = g_strdup_printf ("%i", limit);
						_tmp18_ = _tmp17_;
						_tmp19_ = g_strconcat ("Too many pairs. Limit: ", _tmp18_, NULL);
						_tmp20_ = _tmp19_;
						g_warning ("KernList.vala:119: %s", _tmp20_);
						_g_free0 (_tmp20_);
						_g_free0 (_tmp18_);
						_g_object_unref0 (k);
						_g_object_unref0 (p);
						return;
					}
					_tmp21_ = k;
					iter (_tmp21_, iter_target);
					_tmp22_ = i;
					i = _tmp22_ + 1;
					_g_object_unref0 (k);
				}
			}
			_g_object_unref0 (p);
		}
	}
}

void
bird_font_kern_list_all_pairs_format1 (BirdFontKernList* self,
                                       BirdFontKernListPairFormat1Iterator iter,
                                       gpointer iter_target,
                                       gint limit)
{
	guint i = 0U;
	g_return_if_fail (self != NULL);
	i = (guint) 0;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = self->pairs;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPairFormat1* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			BirdFontPairFormat1* _tmp13_;
			guint _tmp14_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPairFormat1*) _tmp7_;
			if (i >= ((guint) limit)) {
				_tmp8_ = limit != -1;
			} else {
				_tmp8_ = FALSE;
			}
			if (G_UNLIKELY (_tmp8_)) {
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = g_strdup_printf ("%i", limit);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat ("Too many pairs. Limit: ", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				g_warning ("KernList.vala:134: %s", _tmp12_);
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
				_g_object_unref0 (p);
				return;
			}
			_tmp13_ = p;
			iter (_tmp13_, iter_target);
			_tmp14_ = i;
			i = _tmp14_ + 1;
			_g_object_unref0 (p);
		}
	}
}

void
bird_font_kern_list_all_single_kern (BirdFontKernList* self,
                                     BirdFontKernListPairFormat1Iterator iter,
                                     gpointer iter_target)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = self->pairs;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPairFormat1* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPairFormat1*) _tmp7_;
			{
				GeeArrayList* _k_list = NULL;
				BirdFontPairFormat1* _tmp8_;
				GeeArrayList* _tmp9_;
				gint _k_size = 0;
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _k_index = 0;
				_tmp8_ = p;
				_tmp9_ = _tmp8_->pairs;
				_k_list = _tmp9_;
				_tmp10_ = _k_list;
				_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_k_size = _tmp12_;
				_k_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					BirdFontKern* k = NULL;
					GeeArrayList* _tmp15_;
					gpointer _tmp16_;
					BirdFontPairFormat1* single = NULL;
					BirdFontPairFormat1* _tmp17_;
					BirdFontPairFormat1* _tmp18_;
					BirdFontPairFormat1* _tmp19_;
					BirdFontPairFormat1* _tmp20_;
					GeeArrayList* _tmp21_;
					BirdFontKern* _tmp22_;
					BirdFontPairFormat1* _tmp23_;
					_k_index = _k_index + 1;
					_tmp13_ = _k_index;
					_tmp14_ = _k_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _k_list;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _k_index);
					k = (BirdFontKern*) _tmp16_;
					_tmp17_ = bird_font_pair_format1_new ();
					single = _tmp17_;
					_tmp18_ = single;
					_tmp19_ = p;
					_tmp18_->left = _tmp19_->left;
					_tmp20_ = single;
					_tmp21_ = _tmp20_->pairs;
					_tmp22_ = k;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
					_tmp23_ = single;
					iter (_tmp23_, iter_target);
					_g_object_unref0 (single);
					_g_object_unref0 (k);
				}
			}
			_g_object_unref0 (p);
		}
	}
}

static void
bird_font_kern_list_class_init (BirdFontKernListClass * klass,
                                gpointer klass_data)
{
	bird_font_kern_list_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_kern_list_finalize;
}

static void
bird_font_kern_list_instance_init (BirdFontKernList * self,
                                   gpointer klass)
{
}

static void
bird_font_kern_list_finalize (GObject * obj)
{
	BirdFontKernList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_KERN_LIST, BirdFontKernList);
	_g_object_unref0 (self->pairs);
	_g_object_unref0 (self->glyf_table);
	G_OBJECT_CLASS (bird_font_kern_list_parent_class)->finalize (obj);
}

static GType
bird_font_kern_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKernListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kern_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKernList), 0, (GInstanceInitFunc) bird_font_kern_list_instance_init, NULL };
	GType bird_font_kern_list_type_id;
	bird_font_kern_list_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontKernList", &g_define_type_info, 0);
	return bird_font_kern_list_type_id;
}

GType
bird_font_kern_list_get_type (void)
{
	static volatile gsize bird_font_kern_list_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kern_list_type_id__once)) {
		GType bird_font_kern_list_type_id;
		bird_font_kern_list_type_id = bird_font_kern_list_get_type_once ();
		g_once_init_leave (&bird_font_kern_list_type_id__once, bird_font_kern_list_type_id);
	}
	return bird_font_kern_list_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

