/* ImportUtils.c generated by valac 0.56.16, the Vala compiler
 * generated from ImportUtils.vala, do not modify */

/*
Copyright (C) 2012 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

VALA_EXTERN void bird_font_print_import_help (gchar** arg,
                                  gint arg_length1);
VALA_EXTERN gchar* bird_font_build_absoulute_path (const gchar* file_name);

void
bird_font_print_import_help (gchar** arg,
                             gint arg_length1)
{
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	const gchar* _tmp4_;
	FILE* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	FILE* _tmp18_;
	_tmp0_ = stdout;
	_tmp1_ = bird_font_t_ ("Usage:");
	_tmp2_ = _tmp1_;
	fprintf (_tmp0_, "%s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = stdout;
	_tmp4_ = arg[0];
	fprintf (_tmp3_, "%s", _tmp4_);
	_tmp5_ = stdout;
	_tmp6_ = bird_font_t_ ("BF-FILE");
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (" ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, " ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = bird_font_t_ ("SVG-FILES ...");
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
	_tmp17_ = _tmp16_;
	fprintf (_tmp5_, "%s", _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp18_ = stdout;
	fprintf (_tmp18_, "\n");
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gint
bird_font_run_import (gchar** arg,
                      gint arg_length1)
{
	gchar* bf_file = NULL;
	gchar* _tmp0_;
	GeeArrayList* svg_files = NULL;
	GeeArrayList* _tmp1_;
	GFile* bf = NULL;
	GFile* svg = NULL;
	BirdFontFont* font = NULL;
	gboolean imported = FALSE;
	BirdFontArgument* _tmp2_;
	BirdFontFont* _tmp3_;
	BirdFontGlyphCollection* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	BirdFontFont* _tmp35_;
	GFile* _tmp36_;
	BirdFontFont* _tmp92_;
	gint result;
	_tmp0_ = g_strdup ("");
	bf_file = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	svg_files = _tmp1_;
	bird_font_theme_set_default_colors ();
	bird_font_preferences_load ();
	_tmp2_ = bird_font_argument_new ("");
	_g_object_unref0 (bird_font_bird_font_args);
	bird_font_bird_font_args = _tmp2_;
	_tmp3_ = bird_font_font_new ();
	_g_object_unref0 (bird_font_bird_font_current_font);
	bird_font_bird_font_current_font = _tmp3_;
	_tmp4_ = bird_font_glyph_collection_new_with_glyph ((gunichar) '\0', "");
	_g_object_unref0 (bird_font_bird_font_current_glyph_collection);
	bird_font_bird_font_current_glyph_collection = _tmp4_;
	bird_font_main_window_init ();
	if (arg_length1 < 3) {
		bird_font_print_import_help (arg, (gint) arg_length1);
		result = -1;
		_g_object_unref0 (font);
		_g_object_unref0 (svg);
		_g_object_unref0 (bf);
		_g_object_unref0 (svg_files);
		_g_free0 (bf_file);
		return result;
	}
	_tmp5_ = arg[1];
	_tmp6_ = bird_font_build_absoulute_path (_tmp5_);
	_g_free0 (bf_file);
	bf_file = _tmp6_;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp9_;
				const gchar* _tmp10_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				if (!(i < arg_length1)) {
					break;
				}
				_tmp9_ = svg_files;
				_tmp10_ = arg[i];
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
			}
		}
	}
	_tmp11_ = bf_file;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_g_object_unref0 (bf);
	bf = _tmp12_;
	{
		GeeArrayList* _f_list = NULL;
		GeeArrayList* _tmp13_;
		gint _f_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _f_index = 0;
		_tmp13_ = svg_files;
		_f_list = _tmp13_;
		_tmp14_ = _f_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_f_size = _tmp16_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gchar* f = NULL;
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			const gchar* _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			_f_index = _f_index + 1;
			_tmp17_ = _f_index;
			_tmp18_ = _f_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _f_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _f_index);
			f = (gchar*) _tmp20_;
			_tmp21_ = f;
			_tmp22_ = g_file_new_for_path (_tmp21_);
			_g_object_unref0 (svg);
			svg = _tmp22_;
			_tmp23_ = svg;
			if (!g_file_query_exists (_tmp23_, NULL)) {
				FILE* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp24_ = stdout;
				_tmp25_ = f;
				_tmp26_ = string_to_string (_tmp25_);
				_tmp27_ = g_strconcat (_tmp26_, " ", NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = bird_font_t_ ("does not exist.");
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp32_, "\n", NULL);
				_tmp34_ = _tmp33_;
				fprintf (_tmp24_, "%s", _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				_g_free0 (_tmp28_);
				result = -1;
				_g_free0 (f);
				_g_object_unref0 (font);
				_g_object_unref0 (svg);
				_g_object_unref0 (bf);
				_g_object_unref0 (svg_files);
				_g_free0 (bf_file);
				return result;
			}
			_g_free0 (f);
		}
	}
	_tmp35_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp35_;
	_tmp36_ = bf;
	if (!g_file_query_exists (_tmp36_, NULL)) {
		FILE* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		FILE* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		BirdFontFont* _tmp53_;
		const gchar* _tmp54_;
		_tmp37_ = stdout;
		_tmp38_ = bf_file;
		_tmp39_ = string_to_string (_tmp38_);
		_tmp40_ = g_strconcat (_tmp39_, " ", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = bird_font_t_ ("does not exist.");
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat (_tmp41_, _tmp43_, NULL);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strconcat (_tmp45_, " ", NULL);
		_tmp47_ = _tmp46_;
		fprintf (_tmp37_, "%s", _tmp47_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_tmp48_ = stdout;
		_tmp49_ = bird_font_t_ ("A new font will be created.");
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat (_tmp50_, "\n", NULL);
		_tmp52_ = _tmp51_;
		fprintf (_tmp48_, "%s", _tmp52_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
		_tmp53_ = font;
		_tmp54_ = bf_file;
		bird_font_font_set_file (_tmp53_, _tmp54_);
	} else {
		BirdFontFont* _tmp55_;
		const gchar* _tmp56_;
		BirdFontFont* _tmp57_;
		_tmp55_ = font;
		_tmp56_ = bf_file;
		bird_font_font_set_file (_tmp55_, _tmp56_);
		_tmp57_ = font;
		if (!bird_font_font_load (_tmp57_)) {
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gboolean _tmp62_ = FALSE;
			const gchar* _tmp63_;
			_tmp58_ = bf_file;
			_tmp59_ = string_to_string (_tmp58_);
			_tmp60_ = g_strconcat ("Failed to load font ", _tmp59_, ".\n", NULL);
			_tmp61_ = _tmp60_;
			g_warning ("ImportUtils.vala:68: %s", _tmp61_);
			_g_free0 (_tmp61_);
			_tmp63_ = bf_file;
			if (!g_str_has_suffix (_tmp63_, ".bf")) {
				const gchar* _tmp64_;
				_tmp64_ = bf_file;
				_tmp62_ = !g_str_has_suffix (_tmp64_, ".birdfont");
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				g_warning ("ImportUtils.vala:71: %s", "Is it a .bf file?\n");
			}
			result = -1;
			_g_object_unref0 (font);
			_g_object_unref0 (svg);
			_g_object_unref0 (bf);
			_g_object_unref0 (svg_files);
			_g_free0 (bf_file);
			return result;
		}
	}
	{
		GeeArrayList* _f_list = NULL;
		GeeArrayList* _tmp65_;
		gint _f_size = 0;
		GeeArrayList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _f_index = 0;
		_tmp65_ = svg_files;
		_f_list = _tmp65_;
		_tmp66_ = _f_list;
		_tmp67_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_f_size = _tmp68_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp69_;
			gint _tmp70_;
			gchar* f = NULL;
			GeeArrayList* _tmp71_;
			gpointer _tmp72_;
			const gchar* _tmp73_;
			GFile* _tmp74_;
			BirdFontFont* _tmp75_;
			GFile* _tmp76_;
			_f_index = _f_index + 1;
			_tmp69_ = _f_index;
			_tmp70_ = _f_size;
			if (!(_tmp69_ < _tmp70_)) {
				break;
			}
			_tmp71_ = _f_list;
			_tmp72_ = gee_abstract_list_get ((GeeAbstractList*) _tmp71_, _f_index);
			f = (gchar*) _tmp72_;
			_tmp73_ = f;
			_tmp74_ = g_file_new_for_path (_tmp73_);
			_g_object_unref0 (svg);
			svg = _tmp74_;
			_tmp75_ = font;
			_tmp76_ = svg;
			imported = bird_font_import_svg_file (_tmp75_, _tmp76_);
			if (!imported) {
				FILE* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				const gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				FILE* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				_tmp77_ = stdout;
				_tmp78_ = bird_font_t_ ("Failed to import");
				_tmp79_ = _tmp78_;
				_tmp80_ = g_strconcat (_tmp79_, " ", NULL);
				_tmp81_ = _tmp80_;
				_tmp82_ = f;
				_tmp83_ = g_strconcat (_tmp81_, _tmp82_, NULL);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_strconcat (_tmp84_, "\n", NULL);
				_tmp86_ = _tmp85_;
				fprintf (_tmp77_, "%s", _tmp86_);
				_g_free0 (_tmp86_);
				_g_free0 (_tmp84_);
				_g_free0 (_tmp81_);
				_g_free0 (_tmp79_);
				_tmp87_ = stdout;
				_tmp88_ = bird_font_t_ ("Aborting");
				_tmp89_ = _tmp88_;
				_tmp90_ = g_strconcat (_tmp89_, "\n", NULL);
				_tmp91_ = _tmp90_;
				fprintf (_tmp87_, "%s", _tmp91_);
				_g_free0 (_tmp91_);
				_g_free0 (_tmp89_);
				result = -1;
				_g_free0 (f);
				_g_object_unref0 (font);
				_g_object_unref0 (svg);
				_g_object_unref0 (bf);
				_g_object_unref0 (svg_files);
				_g_free0 (bf_file);
				return result;
			}
			_g_free0 (f);
		}
	}
	_tmp92_ = font;
	bird_font_font_save (_tmp92_);
	result = 0;
	_g_object_unref0 (font);
	_g_object_unref0 (svg);
	_g_object_unref0 (bf);
	_g_object_unref0 (svg_files);
	_g_free0 (bf_file);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

gboolean
bird_font_import_svg_file (BirdFontFont* font,
                           GFile* svg_file)
{
	gchar* file_name = NULL;
	gchar* _tmp0_;
	gchar* glyph_name = NULL;
	GString* n = NULL;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* glyph_collection = NULL;
	gunichar character = 0U;
	BirdFontGlyphCanvas* canvas = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	BirdFontGlyphCollection* _tmp35_;
	BirdFontGlyphCanvas* _tmp56_;
	BirdFontGlyphCanvas* _tmp57_;
	BirdFontGlyphCollection* _tmp58_;
	FILE* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	FILE* _tmp62_;
	FILE* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	FILE* _tmp66_;
	FILE* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	FILE* _tmp70_;
	FILE* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	FILE* _tmp74_;
	FILE* _tmp75_;
	BirdFontGlyph* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	FILE* _tmp79_;
	FILE* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	FILE* _tmp83_;
	FILE* _tmp84_;
	BirdFontGlyph* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	FILE* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gboolean result;
	g_return_val_if_fail (font != NULL, FALSE);
	g_return_val_if_fail (svg_file != NULL, FALSE);
	_tmp0_ = g_file_get_basename (svg_file);
	file_name = (gchar*) _tmp0_;
	gc = NULL;
	_tmp1_ = file_name;
	_tmp2_ = string_replace (_tmp1_, ".svg", "");
	_g_free0 (glyph_name);
	glyph_name = _tmp2_;
	_tmp3_ = glyph_name;
	_tmp4_ = string_replace (_tmp3_, ".SVG", "");
	_g_free0 (glyph_name);
	glyph_name = _tmp4_;
	_tmp5_ = glyph_name;
	if (g_utf8_strlen (_tmp5_, (gssize) -1) > 1) {
		const gchar* _tmp6_;
		_tmp6_ = glyph_name;
		if (g_str_has_prefix (_tmp6_, "U+")) {
			GString* _tmp7_;
			GString* _tmp8_;
			const gchar* _tmp9_;
			GString* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			BirdFontGlyphCollection* _tmp14_;
			_tmp7_ = g_string_new ("");
			_g_string_free0 (n);
			n = _tmp7_;
			_tmp8_ = n;
			_tmp9_ = glyph_name;
			g_string_append_unichar (_tmp8_, bird_font_font_to_unichar (_tmp9_));
			_tmp10_ = n;
			_tmp11_ = _tmp10_->str;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (glyph_name);
			glyph_name = _tmp12_;
			_tmp13_ = glyph_name;
			_tmp14_ = bird_font_font_get_glyph_collection (font, _tmp13_);
			_g_object_unref0 (gc);
			gc = _tmp14_;
		} else {
			const gchar* _tmp15_;
			BirdFontGlyphCollection* _tmp16_;
			BirdFontGlyphCollection* _tmp17_;
			_tmp15_ = glyph_name;
			_tmp16_ = bird_font_font_get_glyph_collection_by_name (font, _tmp15_);
			_g_object_unref0 (gc);
			gc = _tmp16_;
			_tmp17_ = gc;
			if (_tmp17_ == NULL) {
				FILE* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				FILE* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp18_ = stdout;
				_tmp19_ = file_name;
				_tmp20_ = g_strconcat (_tmp19_, " ", NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = bird_font_t_ ("is not the name of a glyph or a Unicode value.");
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
				_tmp27_ = _tmp26_;
				fprintf (_tmp18_, "%s", _tmp27_);
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp23_);
				_g_free0 (_tmp21_);
				_tmp28_ = stdout;
				_tmp29_ = bird_font_t_ ("Unicode values must start with U+.");
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp30_, "\n", NULL);
				_tmp32_ = _tmp31_;
				fprintf (_tmp28_, "%s", _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_g_object_unref0 (canvas);
				_g_object_unref0 (glyph_collection);
				_g_object_unref0 (gc);
				_g_object_unref0 (glyph);
				_g_string_free0 (n);
				_g_free0 (glyph_name);
				_g_free0 (file_name);
				return result;
			}
		}
	} else {
		const gchar* _tmp33_;
		BirdFontGlyphCollection* _tmp34_;
		_tmp33_ = glyph_name;
		_tmp34_ = bird_font_font_get_glyph_collection (font, _tmp33_);
		_g_object_unref0 (gc);
		gc = _tmp34_;
	}
	_tmp35_ = gc;
	if (_tmp35_ != NULL) {
		BirdFontGlyphCollection* _tmp36_;
		BirdFontGlyphCollection* _tmp37_;
		BirdFontGlyphCollection* _tmp38_;
		BirdFontGlyphCollection* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		BirdFontGlyph* _tmp42_;
		BirdFontGlyph* _tmp43_;
		BirdFontGlyphCollection* _tmp44_;
		BirdFontGlyphCollection* _tmp45_;
		BirdFontGlyph* _tmp46_;
		_tmp36_ = gc;
		_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_g_object_unref0 (glyph_collection);
		glyph_collection = _tmp37_;
		_tmp38_ = glyph_collection;
		character = bird_font_glyph_collection_get_unicode_character (_tmp38_);
		_tmp39_ = glyph_collection;
		_tmp40_ = bird_font_glyph_collection_get_name (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = bird_font_glyph_new (_tmp41_, character);
		_g_object_unref0 (glyph);
		glyph = _tmp42_;
		_g_free0 (_tmp41_);
		_tmp43_ = glyph;
		_tmp44_ = glyph_collection;
		_tmp43_->version_id = bird_font_glyph_collection_get_last_id (_tmp44_) + 1;
		_tmp45_ = glyph_collection;
		_tmp46_ = glyph;
		bird_font_glyph_collection_insert_glyph (_tmp45_, _tmp46_, TRUE);
	} else {
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		BirdFontGlyphCollection* _tmp50_;
		const gchar* _tmp51_;
		BirdFontGlyph* _tmp52_;
		BirdFontGlyphCollection* _tmp53_;
		BirdFontGlyph* _tmp54_;
		BirdFontGlyphCollection* _tmp55_;
		_tmp47_ = glyph_name;
		g_return_val_if_fail (g_utf8_strlen (_tmp47_, (gssize) -1) == 1, FALSE);
		_tmp48_ = glyph_name;
		character = string_get_char (_tmp48_, (glong) 0);
		_tmp49_ = glyph_name;
		_tmp50_ = bird_font_glyph_collection_new (character, _tmp49_);
		_g_object_unref0 (glyph_collection);
		glyph_collection = _tmp50_;
		_tmp51_ = glyph_name;
		_tmp52_ = bird_font_glyph_new (_tmp51_, character);
		_g_object_unref0 (glyph);
		glyph = _tmp52_;
		_tmp53_ = glyph_collection;
		_tmp54_ = glyph;
		bird_font_glyph_collection_insert_glyph (_tmp53_, _tmp54_, TRUE);
		_tmp55_ = glyph_collection;
		bird_font_font_add_glyph_collection (font, _tmp55_);
	}
	_tmp56_ = bird_font_main_window_get_glyph_canvas ();
	_g_object_unref0 (canvas);
	canvas = _tmp56_;
	_tmp57_ = canvas;
	_tmp58_ = glyph_collection;
	bird_font_glyph_canvas_set_current_glyph_collection (_tmp57_, _tmp58_, TRUE);
	_tmp59_ = stdout;
	_tmp60_ = bird_font_t_ ("Adding");
	_tmp61_ = _tmp60_;
	fprintf (_tmp59_, "%s", _tmp61_);
	_g_free0 (_tmp61_);
	_tmp62_ = stdout;
	fprintf (_tmp62_, " ");
	_tmp63_ = stdout;
	_tmp64_ = g_file_get_basename (svg_file);
	_tmp65_ = (gchar*) _tmp64_;
	fprintf (_tmp63_, "%s", _tmp65_);
	_g_free0 (_tmp65_);
	_tmp66_ = stdout;
	fprintf (_tmp66_, " ");
	_tmp67_ = stdout;
	_tmp68_ = bird_font_t_ ("to");
	_tmp69_ = _tmp68_;
	fprintf (_tmp67_, "%s", _tmp69_);
	_g_free0 (_tmp69_);
	_tmp70_ = stdout;
	fprintf (_tmp70_, " ");
	_tmp71_ = stdout;
	_tmp72_ = bird_font_t_ ("Glyph");
	_tmp73_ = _tmp72_;
	fprintf (_tmp71_, "%s", _tmp73_);
	_g_free0 (_tmp73_);
	_tmp74_ = stdout;
	fprintf (_tmp74_, ": ");
	_tmp75_ = stdout;
	_tmp76_ = glyph;
	_tmp77_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp76_);
	_tmp78_ = _tmp77_;
	fprintf (_tmp75_, "%s", _tmp78_);
	_g_free0 (_tmp78_);
	_tmp79_ = stdout;
	fprintf (_tmp79_, " ");
	_tmp80_ = stdout;
	_tmp81_ = bird_font_t_ ("Version");
	_tmp82_ = _tmp81_;
	fprintf (_tmp80_, "%s", _tmp82_);
	_g_free0 (_tmp82_);
	_tmp83_ = stdout;
	fprintf (_tmp83_, ": ");
	_tmp84_ = stdout;
	_tmp85_ = glyph;
	_tmp86_ = g_strdup_printf ("%i", _tmp85_->version_id);
	_tmp87_ = _tmp86_;
	fprintf (_tmp84_, "%s", _tmp87_);
	_g_free0 (_tmp87_);
	_tmp88_ = stdout;
	fprintf (_tmp88_, "\n");
	_tmp89_ = g_file_get_path (svg_file);
	_tmp90_ = (gchar*) _tmp89_;
	bird_font_svg_parser_import_svg (_tmp90_);
	_g_free0 (_tmp90_);
	result = TRUE;
	_g_object_unref0 (canvas);
	_g_object_unref0 (glyph_collection);
	_g_object_unref0 (gc);
	_g_object_unref0 (glyph);
	_g_string_free0 (n);
	_g_free0 (glyph_name);
	_g_free0 (file_name);
	return result;
}

