/* HeadTable.c generated by valac 0.56.16, the Vala compiler
 * generated from HeadTable.vala, do not modify */

/*
Copyright (C) 2012, 2013, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define BIRD_FONT_HEAD_TABLE_BASELINE_AT_ZERO ((guint8) (1 << 0))
#define BIRD_FONT_HEAD_TABLE_LSB_AT_ZERO ((guint8) (1 << 1))
#define BIRD_FONT_HEAD_TABLE_SIZE_SPECIFIC_INSTRUCTIONS ((guint8) (1 << 2))
#define BIRD_FONT_HEAD_TABLE_FORCE_PPEM_INTEGER_VALUES ((guint8) (1 << 3))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_HEAD_TABLE_0_PROPERTY,
	BIRD_FONT_HEAD_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_head_table_properties[BIRD_FONT_HEAD_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontHeadTablePrivate {
	guint32 adjusted_checksum;
	guint16 mac_style;
	guint16 lowest_PPEM;
	gint16 font_direction_hint;
	gint16 glyph_data_format;
	BirdFontFixed version;
	BirdFontFixed font_revision;
	guint32 magic_number;
	guint16 flags;
	guint64 created;
	guint64 modified;
	BirdFontGlyfTable* glyf_table;
};

static gint BirdFontHeadTable_private_offset;
static gpointer bird_font_head_table_parent_class = NULL;
guint16 bird_font_head_table_units_per_em = 0U;
gdouble bird_font_head_table_UNITS = 0.0;

static void bird_font_head_table_real_parse (BirdFontOtfTable* base,
                                      BirdFontFontData* dis,
                                      GError** error);
static void bird_font_head_table_finalize (GObject * obj);
static GType bird_font_head_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_head_table_get_instance_private (BirdFontHeadTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontHeadTable_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontHeadTable*
bird_font_head_table_construct (GType object_type,
                                BirdFontGlyfTable* gt)
{
	BirdFontHeadTable * self = NULL;
	BirdFontGlyfTable* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (gt != NULL, NULL);
	self = (BirdFontHeadTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = _g_object_ref0 (gt);
	_g_object_unref0 (self->priv->glyf_table);
	self->priv->glyf_table = _tmp0_;
	_tmp1_ = g_strdup ("head");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp1_;
	return self;
}

BirdFontHeadTable*
bird_font_head_table_new (BirdFontGlyfTable* gt)
{
	return bird_font_head_table_construct (BIRD_FONT_TYPE_HEAD_TABLE, gt);
}

/** Set default value for unit. */
void
bird_font_head_table_init (gint units_per_em)
{
	gboolean _tmp0_ = FALSE;
	if (units_per_em <= 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = units_per_em > ((gint) G_MAXUINT16);
	}
	if (_tmp0_) {
		bird_font_head_table_units_per_em = (guint16) 1024;
	} else {
		bird_font_head_table_units_per_em = (guint16) units_per_em;
	}
	bird_font_head_table_UNITS = 10 * (bird_font_head_table_units_per_em / 1000.0);
}

guint32
bird_font_head_table_get_adjusted_checksum (BirdFontHeadTable* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->adjusted_checksum;
	return result;
}

/** Get the units per em for generated fonts, not for fonts parsed 
 * with this library.
 */
gdouble
bird_font_head_table_get_units_per_em (BirdFontHeadTable* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = (gdouble) (bird_font_head_table_units_per_em * 10);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_head_table_real_parse (BirdFontOtfTable* base,
                                 BirdFontFontData* dis,
                                 GError** error)
{
	BirdFontHeadTable * self;
	gboolean _tmp0_ = FALSE;
	BirdFontFontData* _tmp1_;
	guint64 _tmp11_ = 0ULL;
	guint64 _tmp12_ = 0ULL;
	gint16 _tmp13_ = 0;
	gint16 _tmp14_ = 0;
	gint16 _tmp15_ = 0;
	gint16 _tmp16_ = 0;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gint16 _tmp33_ = 0;
	gint16 _tmp34_ = 0;
	gint16 _tmp35_ = 0;
	gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	GError* _inner_error0_ = NULL;
	self = (BirdFontHeadTable*) base;
	g_return_if_fail (dis != NULL);
	if (((BirdFontOtfTable*) self)->offset > ((guint32) 0)) {
		_tmp0_ = ((BirdFontOtfTable*) self)->length > ((guint32) 0);
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	bird_font_font_data_seek (dis, (guint) ((BirdFontOtfTable*) self)->offset);
	_tmp1_ = bird_font_font_data_new ((guint32) 1024);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp1_;
	self->priv->version = bird_font_font_data_read_fixed (dis);
	if (!bird_font_fixed_equals (self->priv->version, (guint16) 1, (guint16) 0)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = bird_font_fixed_get_string (self->priv->version);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("Expecting head version 1.0 got ", _tmp4_, "\n", NULL);
		_tmp6_ = _tmp5_;
		g_warning ("HeadTable.vala:90: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp3_);
	}
	self->priv->font_revision = bird_font_font_data_read_fixed (dis);
	self->priv->adjusted_checksum = bird_font_font_data_read_ulong (dis);
	self->priv->magic_number = bird_font_font_data_read_ulong (dis);
	if (self->priv->magic_number != ((guint32) 0x5F0F3CF5)) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = g_strdup_printf ("%u", self->priv->magic_number);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat ("Magic number is invalid (", _tmp8_, ").", NULL);
		_tmp10_ = _tmp9_;
		g_warning ("HeadTable.vala:98: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		return;
	}
	self->priv->flags = bird_font_font_data_read_ushort (dis);
	if (((gint) (self->priv->flags & BIRD_FONT_HEAD_TABLE_BASELINE_AT_ZERO)) > 0) {
		bird_font_printd ("Flag BASELINE_AT_ZERO has been set.\n");
	}
	if (((gint) (self->priv->flags & BIRD_FONT_HEAD_TABLE_LSB_AT_ZERO)) > 0) {
		bird_font_printd ("Flags LSB_AT_ZERO has been set.\n");
	}
	bird_font_head_table_units_per_em = bird_font_font_data_read_ushort (dis);
	_tmp11_ = bird_font_font_data_read_udate (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->created = _tmp11_;
	_tmp12_ = bird_font_font_data_read_udate (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->modified = _tmp12_;
	_tmp13_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->xmin = _tmp13_;
	_tmp14_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->ymin = _tmp14_;
	_tmp15_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->xmax = _tmp15_;
	_tmp16_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->ymax = _tmp16_;
	bird_font_printd ("font boundaries:\n");
	_tmp17_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->xmin);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("xmin: ", _tmp18_, "\n", NULL);
	_tmp20_ = _tmp19_;
	bird_font_printd (_tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_tmp21_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->ymin);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat ("ymin: ", _tmp22_, "\n", NULL);
	_tmp24_ = _tmp23_;
	bird_font_printd (_tmp24_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_tmp25_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->xmax);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("xmax: ", _tmp26_, "\n", NULL);
	_tmp28_ = _tmp27_;
	bird_font_printd (_tmp28_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp29_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->ymax);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat ("ymax: ", _tmp30_, "\n", NULL);
	_tmp32_ = _tmp31_;
	bird_font_printd (_tmp32_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	self->priv->mac_style = bird_font_font_data_read_ushort (dis);
	self->priv->lowest_PPEM = bird_font_font_data_read_ushort (dis);
	_tmp33_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->font_direction_hint = _tmp33_;
	_tmp34_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->loca_offset_size = _tmp34_;
	_tmp35_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->glyph_data_format = _tmp35_;
	if (((gint) self->priv->glyph_data_format) != 0) {
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp36_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->priv->glyph_data_format);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat ("Unknown glyph data format. Expecting 0 got ", _tmp37_, ".", NULL);
		_tmp39_ = _tmp38_;
		g_warning ("HeadTable.vala:137: %s", _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
	}
	_tmp40_ = bird_font_fixed_get_string (self->priv->version);
	_tmp41_ = _tmp40_;
	_tmp42_ = string_to_string (_tmp41_);
	_tmp43_ = g_strconcat ("Version: ", _tmp42_, "\n", NULL);
	_tmp44_ = _tmp43_;
	bird_font_printd (_tmp44_);
	_g_free0 (_tmp44_);
	_g_free0 (_tmp41_);
	_tmp45_ = g_strdup_printf ("%hu", self->priv->flags);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_strconcat ("flags: ", _tmp46_, "\n", NULL);
	_tmp48_ = _tmp47_;
	bird_font_printd (_tmp48_);
	_g_free0 (_tmp48_);
	_g_free0 (_tmp46_);
	_tmp49_ = bird_font_fixed_get_string (self->priv->font_revision);
	_tmp50_ = _tmp49_;
	_tmp51_ = string_to_string (_tmp50_);
	_tmp52_ = g_strconcat ("font_revision: ", _tmp51_, "\n", NULL);
	_tmp53_ = _tmp52_;
	bird_font_printd (_tmp53_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp50_);
	_tmp54_ = g_strdup_printf ("%hu", self->priv->flags);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat ("flags: ", _tmp55_, "\n", NULL);
	_tmp57_ = _tmp56_;
	bird_font_printd (_tmp57_);
	_g_free0 (_tmp57_);
	_g_free0 (_tmp55_);
	_tmp58_ = g_strdup_printf ("%hu", bird_font_head_table_units_per_em);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_strconcat ("Units per em: ", _tmp59_, "\n", NULL);
	_tmp61_ = _tmp60_;
	bird_font_printd (_tmp61_);
	_g_free0 (_tmp61_);
	_g_free0 (_tmp59_);
	_tmp62_ = g_strdup_printf ("%hu", self->priv->lowest_PPEM);
	_tmp63_ = _tmp62_;
	_tmp64_ = g_strconcat ("lowest_PPEM: ", _tmp63_, "\n", NULL);
	_tmp65_ = _tmp64_;
	bird_font_printd (_tmp65_);
	_g_free0 (_tmp65_);
	_g_free0 (_tmp63_);
	_tmp66_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->priv->font_direction_hint);
	_tmp67_ = _tmp66_;
	_tmp68_ = g_strconcat ("font_direction_hint: ", _tmp67_, "\n", NULL);
	_tmp69_ = _tmp68_;
	bird_font_printd (_tmp69_);
	_g_free0 (_tmp69_);
	_g_free0 (_tmp67_);
	_tmp70_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->loca_offset_size);
	_tmp71_ = _tmp70_;
	_tmp72_ = g_strconcat ("loca_offset_size: ", _tmp71_, "\n", NULL);
	_tmp73_ = _tmp72_;
	bird_font_printd (_tmp73_);
	_g_free0 (_tmp73_);
	_g_free0 (_tmp71_);
	_tmp74_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->priv->glyph_data_format);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_strconcat ("glyph_data_format: ", _tmp75_, "\n", NULL);
	_tmp77_ = _tmp76_;
	bird_font_printd (_tmp77_);
	_g_free0 (_tmp77_);
	_g_free0 (_tmp75_);
}

guint32
bird_font_head_table_get_font_checksum (BirdFontHeadTable* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->adjusted_checksum;
	return result;
}

void
bird_font_head_table_set_checksum_adjustment (BirdFontHeadTable* self,
                                              guint32 csa)
{
	g_return_if_fail (self != NULL);
	self->priv->adjusted_checksum = csa;
}

guint32
bird_font_head_table_get_checksum_position (BirdFontHeadTable* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint32) 8;
	return result;
}

void
bird_font_head_table_process (BirdFontHeadTable* self,
                              GError** error)
{
	BirdFontFontData* font_data = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontFixed version = 0U;
	BirdFontFixed font_revision = 0U;
	guint64 time = 0ULL;
	static const guint64 time_diff = (guint64) (((60 * 60) * 24) * ((365 * (1970 - 1904)) + 17));
	BirdFontFontData* _tmp1_;
	BirdFontFontData* _tmp2_;
	BirdFontFontData* _tmp3_;
	BirdFontFontData* _tmp4_;
	BirdFontFontData* _tmp5_;
	BirdFontFontData* _tmp6_;
	BirdFontFontData* _tmp7_;
	BirdFontFontData* _tmp8_;
	BirdFontGlyfTable* _tmp9_;
	BirdFontGlyfTable* _tmp10_;
	BirdFontGlyfTable* _tmp11_;
	BirdFontGlyfTable* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	BirdFontFontData* _tmp29_;
	BirdFontFontData* _tmp30_;
	BirdFontFontData* _tmp31_;
	BirdFontFontData* _tmp32_;
	BirdFontFontData* _tmp33_;
	BirdFontFontData* _tmp34_;
	BirdFontFontData* _tmp35_;
	BirdFontFontData* _tmp36_;
	BirdFontFontData* _tmp37_;
	BirdFontFontData* _tmp38_;
	BirdFontFontData* _tmp39_;
	BirdFontFontData* _tmp40_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	font_data = _tmp0_;
	version = (BirdFontFixed) (1 << 16);
	font_revision = (BirdFontFixed) (1 << 16);
	time = (guint64) rint (g_get_real_time () / 1000000.0);
	_tmp1_ = font_data;
	bird_font_font_data_add_fixed (_tmp1_, version, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (font_data);
		return;
	}
	_tmp2_ = font_data;
	bird_font_font_data_add_fixed (_tmp2_, font_revision, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (font_data);
		return;
	}
	_tmp3_ = font_data;
	bird_font_font_data_add_u32 (_tmp3_, self->priv->adjusted_checksum);
	_tmp4_ = font_data;
	bird_font_font_data_add_u32 (_tmp4_, (guint32) 0x5F0F3CF5);
	_tmp5_ = font_data;
	bird_font_font_data_add_u16 (_tmp5_, (guint16) ((BIRD_FONT_HEAD_TABLE_BASELINE_AT_ZERO | BIRD_FONT_HEAD_TABLE_LSB_AT_ZERO) | BIRD_FONT_HEAD_TABLE_FORCE_PPEM_INTEGER_VALUES));
	_tmp6_ = font_data;
	bird_font_font_data_add_u16 (_tmp6_, bird_font_head_table_units_per_em);
	_tmp7_ = font_data;
	bird_font_font_data_add_u64 (_tmp7_, time + time_diff);
	_tmp8_ = font_data;
	bird_font_font_data_add_u64 (_tmp8_, time + time_diff);
	_tmp9_ = self->priv->glyf_table;
	self->xmin = _tmp9_->xmin;
	_tmp10_ = self->priv->glyf_table;
	self->ymin = _tmp10_->ymin;
	_tmp11_ = self->priv->glyf_table;
	self->xmax = _tmp11_->xmax;
	_tmp12_ = self->priv->glyf_table;
	self->ymax = _tmp12_->ymax;
	bird_font_printd ("font boundaries:\n");
	_tmp13_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->xmin);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat ("xmin: ", _tmp14_, "\n", NULL);
	_tmp16_ = _tmp15_;
	bird_font_printd (_tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->ymin);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("ymin: ", _tmp18_, "\n", NULL);
	_tmp20_ = _tmp19_;
	bird_font_printd (_tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_tmp21_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->xmax);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat ("xmax: ", _tmp22_, "\n", NULL);
	_tmp24_ = _tmp23_;
	bird_font_printd (_tmp24_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_tmp25_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->ymax);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("ymax: ", _tmp26_, "\n", NULL);
	_tmp28_ = _tmp27_;
	bird_font_printd (_tmp28_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp29_ = font_data;
	bird_font_font_data_add_short (_tmp29_, self->xmin, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (font_data);
		return;
	}
	_tmp30_ = font_data;
	bird_font_font_data_add_short (_tmp30_, self->ymin, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (font_data);
		return;
	}
	_tmp31_ = font_data;
	bird_font_font_data_add_short (_tmp31_, self->xmax, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (font_data);
		return;
	}
	_tmp32_ = font_data;
	bird_font_font_data_add_short (_tmp32_, self->ymax, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (font_data);
		return;
	}
	_tmp33_ = font_data;
	bird_font_font_data_add_u16 (_tmp33_, (guint16) 0);
	_tmp34_ = font_data;
	bird_font_font_data_add_u16 (_tmp34_, (guint16) 7);
	_tmp35_ = font_data;
	bird_font_font_data_add_16 (_tmp35_, (gint16) 2);
	_tmp36_ = font_data;
	bird_font_font_data_add_16 (_tmp36_, self->loca_offset_size);
	_tmp37_ = font_data;
	bird_font_font_data_add_16 (_tmp37_, (gint16) 0);
	_tmp38_ = font_data;
	bird_font_font_data_pad (_tmp38_);
	_tmp39_ = font_data;
	_tmp40_ = _g_object_ref0 (_tmp39_);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp40_;
	_g_object_unref0 (font_data);
}

static void
bird_font_head_table_class_init (BirdFontHeadTableClass * klass,
                                 gpointer klass_data)
{
	bird_font_head_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontHeadTable_private_offset);
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_head_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_head_table_finalize;
}

static void
bird_font_head_table_instance_init (BirdFontHeadTable * self,
                                    gpointer klass)
{
	self->priv = bird_font_head_table_get_instance_private (self);
	self->xmin = G_MININT16;
	self->ymin = G_MININT16;
	self->xmax = G_MAXINT16;
	self->ymax = G_MAXINT16;
	self->priv->adjusted_checksum = (guint32) 0;
	self->loca_offset_size = (gint16) 1;
}

static void
bird_font_head_table_finalize (GObject * obj)
{
	BirdFontHeadTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_HEAD_TABLE, BirdFontHeadTable);
	_g_object_unref0 (self->priv->glyf_table);
	G_OBJECT_CLASS (bird_font_head_table_parent_class)->finalize (obj);
}

static GType
bird_font_head_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontHeadTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_head_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontHeadTable), 0, (GInstanceInitFunc) bird_font_head_table_instance_init, NULL };
	GType bird_font_head_table_type_id;
	bird_font_head_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontHeadTable", &g_define_type_info, 0);
	BirdFontHeadTable_private_offset = g_type_add_instance_private (bird_font_head_table_type_id, sizeof (BirdFontHeadTablePrivate));
	return bird_font_head_table_type_id;
}

GType
bird_font_head_table_get_type (void)
{
	static volatile gsize bird_font_head_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_head_table_type_id__once)) {
		GType bird_font_head_table_type_id;
		bird_font_head_table_type_id = bird_font_head_table_get_type_once ();
		g_once_init_leave (&bird_font_head_table_type_id__once, bird_font_head_table_type_id);
	}
	return bird_font_head_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

