/* GposTable.c generated by valac 0.56.16, the Vala compiler
 * generated from GposTable.vala, do not modify */

/*
Copyright (C) 2012 2013 2014 2017 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_GPOS_TABLE_0_PROPERTY,
	BIRD_FONT_GPOS_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_gpos_table_properties[BIRD_FONT_GPOS_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block77Data Block77Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block78Data Block78Data;

struct _BirdFontGposTablePrivate {
	BirdFontGlyfTable* glyf_table;
	BirdFontKernList* pairs;
};

struct _Block77Data {
	int _ref_count_;
	BirdFontGposTable* self;
	BirdFontFontData* fd;
	gint i;
	guint pair_set_offset;
	guint written;
	guint written_pairs;
	guint last_gid_left;
	guint last_gid_right;
};

struct _Block78Data {
	int _ref_count_;
	guint len;
};

static gint BirdFontGposTable_private_offset;
static gpointer bird_font_gpos_table_parent_class = NULL;

static void bird_font_gpos_table_real_parse (BirdFontOtfTable* base,
                                      BirdFontFontData* dis,
                                      GError** error);
static BirdFontFontData* bird_font_gpos_table_get_pair_pos_format1 (BirdFontGposTable* self,
                                                             BirdFontKernList* pairs_subset,
                                                             GError** error);
static Block77Data* block77_data_ref (Block77Data* _data77_);
static void block77_data_unref (void * _userdata_);
static void __lambda62_ (Block77Data* _data77_,
                  BirdFontPairFormat1* k);
static void ___lambda62__bird_font_kern_list_pair_format1_iterator (BirdFontPairFormat1* k,
                                                             gpointer self);
static void __lambda63_ (Block77Data* _data77_,
                  BirdFontPairFormat1* pn);
static void ___lambda63__bird_font_kern_list_pair_format1_iterator (BirdFontPairFormat1* k,
                                                             gpointer self);
static void __lambda64_ (Block77Data* _data77_,
                  BirdFontPairFormat1* p);
static void ___lambda64__bird_font_kern_list_pair_format1_iterator (BirdFontPairFormat1* k,
                                                             gpointer self);
static Block78Data* block78_data_ref (Block78Data* _data78_);
static void block78_data_unref (void * _userdata_);
static void __lambda61_ (Block78Data* _data78_,
                  BirdFontPairFormat1* p);
static void ___lambda61__bird_font_kern_list_pair_format1_iterator (BirdFontPairFormat1* k,
                                                             gpointer self);
static void bird_font_gpos_table_finalize (GObject * obj);
static GType bird_font_gpos_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_gpos_table_get_instance_private (BirdFontGposTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontGposTable_private_offset);
}

BirdFontGposTable*
bird_font_gpos_table_construct (GType object_type)
{
	BirdFontGposTable * self = NULL;
	gchar* _tmp0_;
	self = (BirdFontGposTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = g_strdup ("GPOS");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp0_;
	return self;
}

BirdFontGposTable*
bird_font_gpos_table_new (void)
{
	return bird_font_gpos_table_construct (BIRD_FONT_TYPE_GPOS_TABLE);
}

static void
bird_font_gpos_table_real_parse (BirdFontOtfTable* base,
                                 BirdFontFontData* dis,
                                 GError** error)
{
	BirdFontGposTable * self;
	self = (BirdFontGposTable*) base;
	g_return_if_fail (dis != NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_gpos_table_process (BirdFontGposTable* self,
                              BirdFontGlyfTable* glyf_table,
                              GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontGlyfTable* _tmp1_;
	BirdFontKernList* _tmp2_;
	BirdFontFontData* _tmp3_;
	BirdFontFontData* _tmp4_;
	BirdFontFontData* _tmp5_;
	BirdFontFontData* _tmp6_;
	BirdFontFontData* _tmp7_;
	BirdFontFontData* _tmp8_;
	BirdFontFontData* _tmp9_;
	BirdFontFontData* _tmp10_;
	BirdFontFontData* _tmp11_;
	BirdFontFontData* _tmp12_;
	BirdFontFontData* _tmp13_;
	BirdFontFontData* _tmp14_;
	BirdFontFontData* _tmp15_;
	BirdFontFontData* _tmp16_;
	BirdFontFontData* _tmp17_;
	BirdFontFontData* _tmp18_;
	BirdFontFontData* _tmp19_;
	BirdFontFontData* _tmp20_;
	BirdFontFontData* _tmp21_;
	GeeArrayList* pair_set_data = NULL;
	GeeArrayList* _tmp22_;
	BirdFontKernList* _tmp23_;
	BirdFontKernSplitter* kern_splitter = NULL;
	BirdFontKernList* _tmp24_;
	BirdFontKernSplitter* _tmp25_;
	BirdFontFontData* _tmp34_;
	BirdFontFontData* _tmp35_;
	gint16 extention_pos = 0;
	GeeArrayList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint64 pair_set_data_length = 0LL;
	gint64 extension_length = 0LL;
	GeeArrayList* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	BirdFontFontData* _tmp73_;
	BirdFontFontData* _tmp74_;
	BirdFontFontData* _tmp75_;
	GeeArrayList* _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	GeeArrayList* _tmp79_;
	gint _tmp80_;
	gint _tmp81_;
	BirdFontFontData* _tmp112_;
	BirdFontFontData* _tmp113_;
	BirdFontFontData* _tmp114_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyf_table != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	_tmp1_ = _g_object_ref0 (glyf_table);
	_g_object_unref0 (self->priv->glyf_table);
	self->priv->glyf_table = _tmp1_;
	_tmp2_ = bird_font_kern_list_new (glyf_table);
	_g_object_unref0 (self->priv->pairs);
	self->priv->pairs = _tmp2_;
	bird_font_printd ("Processing GPOS\n");
	_tmp3_ = fd;
	bird_font_font_data_add_ulong (_tmp3_, (guint32) 0x00010000, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp4_ = fd;
	bird_font_font_data_add_ushort (_tmp4_, (guint16) 10, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp5_ = fd;
	bird_font_font_data_add_ushort (_tmp5_, (guint16) 30, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp6_ = fd;
	bird_font_font_data_add_ushort (_tmp6_, (guint16) 44, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp7_ = fd;
	bird_font_font_data_add_ushort (_tmp7_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp8_ = fd;
	bird_font_font_data_add_tag (_tmp8_, "DFLT");
	_tmp9_ = fd;
	bird_font_font_data_add_ushort (_tmp9_, (guint16) 8, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp10_ = fd;
	bird_font_font_data_add_ushort (_tmp10_, (guint16) 4, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp11_ = fd;
	bird_font_font_data_add_ushort (_tmp11_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp12_ = fd;
	bird_font_font_data_add_ushort (_tmp12_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp13_ = fd;
	bird_font_font_data_add_ushort (_tmp13_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp14_ = fd;
	bird_font_font_data_add_ushort (_tmp14_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp15_ = fd;
	bird_font_font_data_add_ushort (_tmp15_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp16_ = fd;
	bird_font_font_data_add_ushort (_tmp16_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp17_ = fd;
	bird_font_font_data_add_tag (_tmp17_, "kern");
	_tmp18_ = fd;
	bird_font_font_data_add_ushort (_tmp18_, (guint16) 8, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp19_ = fd;
	bird_font_font_data_add_ushort (_tmp19_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp20_ = fd;
	bird_font_font_data_add_ushort (_tmp20_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp21_ = fd;
	bird_font_font_data_add_ushort (_tmp21_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	_tmp22_ = gee_array_list_new (BIRD_FONT_TYPE_FONT_DATA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	pair_set_data = _tmp22_;
	_tmp23_ = self->priv->pairs;
	bird_font_kern_list_fetch_all_pairs (_tmp23_);
	_tmp24_ = self->priv->pairs;
	_tmp25_ = bird_font_kern_splitter_new (_tmp24_);
	kern_splitter = _tmp25_;
	while (TRUE) {
		BirdFontKernList* pairs_subset = NULL;
		BirdFontKernSplitter* _tmp26_;
		BirdFontKernList* _tmp27_;
		BirdFontKernList* _tmp28_;
		BirdFontFontData* pairs = NULL;
		BirdFontKernList* _tmp29_;
		BirdFontFontData* _tmp30_;
		GeeArrayList* _tmp31_;
		BirdFontFontData* _tmp32_;
		BirdFontKernList* _tmp33_;
		if (((BirdFontOtfTable*) self)->offset < ((guint32) 0)) {
			break;
		}
		_tmp26_ = kern_splitter;
		_tmp27_ = bird_font_kern_splitter_get_subset (_tmp26_, (guint) ((BirdFontOtfTable*) self)->offset);
		pairs_subset = _tmp27_;
		_tmp28_ = pairs_subset;
		if (bird_font_kern_list_get_length (_tmp28_) == ((guint) 0)) {
			_g_object_unref0 (pairs_subset);
			break;
		}
		_tmp29_ = pairs_subset;
		_tmp30_ = bird_font_gpos_table_get_pair_pos_format1 (self, _tmp29_, &_inner_error0_);
		pairs = _tmp30_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (pairs_subset);
			_g_object_unref0 (kern_splitter);
			_g_object_unref0 (pair_set_data);
			_g_object_unref0 (fd);
			return;
		}
		_tmp31_ = pair_set_data;
		_tmp32_ = pairs;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp32_);
		_tmp33_ = pairs_subset;
		((BirdFontOtfTable*) self)->offset = ((BirdFontOtfTable*) self)->offset + bird_font_kern_list_get_length (_tmp33_);
		_g_object_unref0 (pairs);
		_g_object_unref0 (pairs_subset);
	}
	_tmp34_ = fd;
	bird_font_font_data_add_ushort (_tmp34_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (kern_splitter);
		_g_object_unref0 (pair_set_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp35_ = fd;
	bird_font_font_data_add_ushort (_tmp35_, (guint16) 4, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (kern_splitter);
		_g_object_unref0 (pair_set_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp36_ = pair_set_data;
	_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	extention_pos = (gint16) (_tmp38_ * 2);
	{
		gint16 index = 0;
		index = (gint16) 0;
		{
			gboolean _tmp39_ = FALSE;
			_tmp39_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				if (!_tmp39_) {
					gint16 _tmp40_;
					_tmp40_ = index;
					index = _tmp40_ + 1;
				}
				_tmp39_ = FALSE;
				_tmp41_ = pair_set_data;
				_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
				_tmp43_ = _tmp42_;
				if (!(((gint) index) < _tmp43_)) {
					break;
				}
				extention_pos += (gint16) (index * 8);
			}
		}
	}
	pair_set_data_length = (gint64) 0;
	extension_length = (gint64) 8;
	{
		GeeArrayList* _pair_set_list = NULL;
		GeeArrayList* _tmp44_;
		gint _pair_set_size = 0;
		GeeArrayList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _pair_set_index = 0;
		_tmp44_ = pair_set_data;
		_pair_set_list = _tmp44_;
		_tmp45_ = _pair_set_list;
		_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_pair_set_size = _tmp47_;
		_pair_set_index = -1;
		while (TRUE) {
			gint _tmp48_;
			gint _tmp49_;
			BirdFontFontData* pair_set = NULL;
			GeeArrayList* _tmp50_;
			gpointer _tmp51_;
			BirdFontFontData* _tmp52_;
			_pair_set_index = _pair_set_index + 1;
			_tmp48_ = _pair_set_index;
			_tmp49_ = _pair_set_size;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp50_ = _pair_set_list;
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _pair_set_index);
			pair_set = (BirdFontFontData*) _tmp51_;
			_tmp52_ = pair_set;
			pair_set_data_length += (gint64) bird_font_font_data_length_with_padding (_tmp52_);
			extension_length += (gint64) 8;
			_g_object_unref0 (pair_set);
		}
	}
	_tmp53_ = pair_set_data;
	_tmp54_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_ > 0) {
		BirdFontFontData* last_pair_set = NULL;
		GeeArrayList* _tmp56_;
		GeeArrayList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gpointer _tmp60_;
		guint64 last_externsion_offset = 0ULL;
		BirdFontFontData* _tmp61_;
		_tmp56_ = pair_set_data;
		_tmp57_ = pair_set_data;
		_tmp58_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, _tmp59_ - 1);
		last_pair_set = (BirdFontFontData*) _tmp60_;
		last_externsion_offset = (guint64) (extension_length + pair_set_data_length);
		last_externsion_offset -= (guint64) 8;
		_tmp61_ = last_pair_set;
		last_externsion_offset -= (guint64) bird_font_font_data_length (_tmp61_);
		if (last_externsion_offset > ((guint64) G_MAXUINT32)) {
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			GeeArrayList* _tmp72_;
			_tmp62_ = g_strdup_printf ("%" G_GUINT64_FORMAT, last_externsion_offset);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_strconcat ("last_externsion_offset: ", _tmp63_, " > ", NULL);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strconcat ("Too manu kerning pairs for the extension positioning table.", _tmp65_, NULL);
			_tmp67_ = _tmp66_;
			_tmp68_ = g_strdup_printf ("%u", G_MAXUINT32);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strconcat (_tmp67_, _tmp69_, NULL);
			_tmp71_ = _tmp70_;
			g_warning ("GposTable.vala:117: %s", _tmp71_);
			_g_free0 (_tmp71_);
			_g_free0 (_tmp69_);
			_g_free0 (_tmp67_);
			_g_free0 (_tmp65_);
			_g_free0 (_tmp63_);
			_tmp72_ = pair_set_data;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp72_);
		}
		_g_object_unref0 (last_pair_set);
	}
	_tmp73_ = fd;
	bird_font_font_data_add_ushort (_tmp73_, (guint16) 9, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (kern_splitter);
		_g_object_unref0 (pair_set_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp74_ = fd;
	bird_font_font_data_add_ushort (_tmp74_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (kern_splitter);
		_g_object_unref0 (pair_set_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp75_ = fd;
	_tmp76_ = pair_set_data;
	_tmp77_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp76_);
	_tmp78_ = _tmp77_;
	bird_font_font_data_add_ushort (_tmp75_, (guint16) _tmp78_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (kern_splitter);
		_g_object_unref0 (pair_set_data);
		_g_object_unref0 (fd);
		return;
	}
	_tmp79_ = pair_set_data;
	_tmp80_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp79_);
	_tmp81_ = _tmp80_;
	if (_tmp81_ > 0) {
		gint k = 0;
		GeeArrayList* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		{
			gint j = 0;
			j = 0;
			{
				gboolean _tmp82_ = FALSE;
				_tmp82_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp84_;
					gint _tmp85_;
					gint _tmp86_;
					guint16 lookup_size = 0U;
					GeeArrayList* _tmp87_;
					gint _tmp88_;
					gint _tmp89_;
					guint16 offset_to_extension = 0U;
					BirdFontFontData* _tmp90_;
					if (!_tmp82_) {
						gint _tmp83_;
						_tmp83_ = j;
						j = _tmp83_ + 1;
					}
					_tmp82_ = FALSE;
					_tmp84_ = pair_set_data;
					_tmp85_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp84_);
					_tmp86_ = _tmp85_;
					if (!(j < _tmp86_)) {
						break;
					}
					_tmp87_ = pair_set_data;
					_tmp88_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp87_);
					_tmp89_ = _tmp88_;
					lookup_size = (guint16) (((guint16) _tmp89_) * 2);
					offset_to_extension = (guint16) ((6 + lookup_size) + (j * 8));
					_tmp90_ = fd;
					bird_font_font_data_add_ushort (_tmp90_, offset_to_extension, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (kern_splitter);
						_g_object_unref0 (pair_set_data);
						_g_object_unref0 (fd);
						return;
					}
				}
			}
		}
		_tmp91_ = pair_set_data;
		_tmp92_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		k = _tmp93_ - 1;
		while (TRUE) {
			gboolean _tmp94_ = FALSE;
			BirdFontFontData* pair_set = NULL;
			GeeArrayList* _tmp95_;
			gpointer _tmp96_;
			BirdFontFontData* _tmp97_;
			guint64 externsion_offset = 0ULL;
			BirdFontFontData* _tmp98_;
			BirdFontFontData* _tmp99_;
			BirdFontFontData* _tmp100_;
			gint _tmp101_;
			if (extension_length > ((gint64) 0)) {
				_tmp94_ = k >= 0;
			} else {
				_tmp94_ = FALSE;
			}
			if (!_tmp94_) {
				break;
			}
			_tmp95_ = pair_set_data;
			_tmp96_ = gee_abstract_list_get ((GeeAbstractList*) _tmp95_, k);
			pair_set = (BirdFontFontData*) _tmp96_;
			_tmp97_ = pair_set;
			pair_set_data_length -= (gint64) bird_font_font_data_length (_tmp97_);
			extension_length -= (gint64) 8;
			externsion_offset = (guint64) (extension_length + pair_set_data_length);
			if (externsion_offset > ((guint64) G_MAXUINT32)) {
				g_warning ("GposTable.vala:145: Too manu kerning pairs for extension positioning t" \
"able.");
			}
			_tmp98_ = fd;
			bird_font_font_data_add_ushort (_tmp98_, (guint16) 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (pair_set);
				_g_object_unref0 (kern_splitter);
				_g_object_unref0 (pair_set_data);
				_g_object_unref0 (fd);
				return;
			}
			_tmp99_ = fd;
			bird_font_font_data_add_ushort (_tmp99_, (guint16) 2, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (pair_set);
				_g_object_unref0 (kern_splitter);
				_g_object_unref0 (pair_set_data);
				_g_object_unref0 (fd);
				return;
			}
			_tmp100_ = fd;
			bird_font_font_data_add_ulong (_tmp100_, (guint32) externsion_offset, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (pair_set);
				_g_object_unref0 (kern_splitter);
				_g_object_unref0 (pair_set_data);
				_g_object_unref0 (fd);
				return;
			}
			_tmp101_ = k;
			k = _tmp101_ - 1;
			_g_object_unref0 (pair_set);
		}
		{
			GeeArrayList* _pair_set_list = NULL;
			GeeArrayList* _tmp102_;
			gint _pair_set_size = 0;
			GeeArrayList* _tmp103_;
			gint _tmp104_;
			gint _tmp105_;
			gint _pair_set_index = 0;
			_tmp102_ = pair_set_data;
			_pair_set_list = _tmp102_;
			_tmp103_ = _pair_set_list;
			_tmp104_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp103_);
			_tmp105_ = _tmp104_;
			_pair_set_size = _tmp105_;
			_pair_set_index = -1;
			while (TRUE) {
				gint _tmp106_;
				gint _tmp107_;
				BirdFontFontData* pair_set = NULL;
				GeeArrayList* _tmp108_;
				gpointer _tmp109_;
				BirdFontFontData* _tmp110_;
				BirdFontFontData* _tmp111_;
				_pair_set_index = _pair_set_index + 1;
				_tmp106_ = _pair_set_index;
				_tmp107_ = _pair_set_size;
				if (!(_tmp106_ < _tmp107_)) {
					break;
				}
				_tmp108_ = _pair_set_list;
				_tmp109_ = gee_abstract_list_get ((GeeAbstractList*) _tmp108_, _pair_set_index);
				pair_set = (BirdFontFontData*) _tmp109_;
				_tmp110_ = fd;
				_tmp111_ = pair_set;
				bird_font_font_data_append (_tmp110_, _tmp111_);
				_g_object_unref0 (pair_set);
			}
		}
	}
	_tmp112_ = fd;
	bird_font_font_data_pad (_tmp112_);
	_tmp113_ = fd;
	_tmp114_ = _g_object_ref0 (_tmp113_);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp114_;
	_g_object_unref0 (kern_splitter);
	_g_object_unref0 (pair_set_data);
	_g_object_unref0 (fd);
}

static Block77Data*
block77_data_ref (Block77Data* _data77_)
{
	g_atomic_int_inc (&_data77_->_ref_count_);
	return _data77_;
}

static void
block77_data_unref (void * _userdata_)
{
	Block77Data* _data77_;
	_data77_ = (Block77Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data77_->_ref_count_)) {
		BirdFontGposTable* self;
		self = _data77_->self;
		_g_object_unref0 (_data77_->fd);
		_g_object_unref0 (self);
		g_slice_free (Block77Data, _data77_);
	}
}

static void
__lambda62_ (Block77Data* _data77_,
             BirdFontPairFormat1* k)
{
	BirdFontGposTable* self;
	GError* _inner_error0_ = NULL;
	self = _data77_->self;
	g_return_if_fail (k != NULL);
	{
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		BirdFontFontData* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		if (_data77_->pair_set_offset > ((guint) G_MAXUINT16)) {
			g_warning ("GposTable.vala:209: Invalid offset.");
			return;
		}
		_tmp0_ = k->pairs;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_ == 0) {
			g_warning ("GposTable.vala:214: No pairs.");
		}
		_tmp3_ = _data77_->fd;
		bird_font_font_data_add_ushort (_tmp3_, (guint16) _data77_->pair_set_offset, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data77_->pair_set_offset += (guint) 2;
		_tmp4_ = k->pairs;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_data77_->pair_set_offset += (guint) (4 * _tmp6_);
		_data77_->written += (guint) 2;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("GposTable.vala:222: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda62__bird_font_kern_list_pair_format1_iterator (BirdFontPairFormat1* k,
                                                        gpointer self)
{
	__lambda62_ (self, k);
}

static void
__lambda63_ (Block77Data* _data77_,
             BirdFontPairFormat1* pn)
{
	BirdFontGposTable* self;
	GError* _inner_error0_ = NULL;
	self = _data77_->self;
	g_return_if_fail (pn != NULL);
	{
		BirdFontPairFormat1* p = NULL;
		BirdFontPairFormat1* _tmp0_;
		guint pairset_length = 0U;
		BirdFontPairFormat1* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		BirdFontPairFormat1* _tmp5_;
		BirdFontPairFormat1* _tmp13_;
		BirdFontFontData* _tmp14_;
		BirdFontPairFormat1* _tmp47_;
		GeeArrayList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _tmp60_;
		_tmp0_ = _g_object_ref0 (pn);
		p = _tmp0_;
		_tmp1_ = p;
		_tmp2_ = _tmp1_->pairs;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		pairset_length = (guint) _tmp4_;
		if (pairset_length > ((guint) G_MAXUINT16)) {
			g_warning ("GposTable.vala:241: Too many pairs");
			pairset_length = (guint) G_MAXUINT16;
		}
		_tmp5_ = p;
		if (G_UNLIKELY (((guint) _tmp5_->left) < _data77_->last_gid_left)) {
			BirdFontPairFormat1* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp6_ = p;
			_tmp7_ = g_strdup_printf ("%hu", _tmp6_->left);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("%u", _data77_->last_gid_left);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat ("Kerning table is not sorted ", _tmp8_, " < ", _tmp10_, ".", NULL);
			_tmp12_ = _tmp11_;
			g_warning ("GposTable.vala:246: %s", _tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
		}
		_tmp13_ = p;
		_data77_->last_gid_left = (guint) _tmp13_->left;
		_tmp14_ = _data77_->fd;
		bird_font_font_data_add_ushort (_tmp14_, (guint16) pairset_length, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (p);
			goto __catch0_g_error;
		}
		_data77_->written += (guint) 2;
		_data77_->last_gid_right = (guint) 0;
		_data77_->written_pairs = (guint) 0;
		{
			GeeArrayList* _k_list = NULL;
			BirdFontPairFormat1* _tmp15_;
			GeeArrayList* _tmp16_;
			gint _k_size = 0;
			GeeArrayList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _k_index = 0;
			_tmp15_ = p;
			_tmp16_ = _tmp15_->pairs;
			_k_list = _tmp16_;
			_tmp17_ = _k_list;
			_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_k_size = _tmp19_;
			_k_index = -1;
			while (TRUE) {
				gint _tmp20_;
				gint _tmp21_;
				BirdFontKern* k = NULL;
				GeeArrayList* _tmp22_;
				gpointer _tmp23_;
				BirdFontKern* _tmp24_;
				BirdFontFontData* _tmp33_;
				BirdFontKern* _tmp34_;
				BirdFontFontData* _tmp35_;
				BirdFontKern* _tmp36_;
				BirdFontKern* _tmp37_;
				BirdFontKern* _tmp45_;
				guint _tmp46_;
				_k_index = _k_index + 1;
				_tmp20_ = _k_index;
				_tmp21_ = _k_size;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = _k_list;
				_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _k_index);
				k = (BirdFontKern*) _tmp23_;
				_tmp24_ = k;
				if (((gint) _tmp24_->right) == 0) {
					BirdFontPairFormat1* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					BirdFontKern* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp25_ = p;
					_tmp26_ = g_strdup_printf ("%hu", _tmp25_->left);
					_tmp27_ = _tmp26_;
					_tmp28_ = k;
					_tmp29_ = g_strdup_printf ("%hu", _tmp28_->right);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strconcat ("GID ", _tmp27_, " is kerned zero units to ", _tmp30_, ".", NULL);
					_tmp32_ = _tmp31_;
					g_warning ("GposTable.vala:258: %s", _tmp32_);
					_g_free0 (_tmp32_);
					_g_free0 (_tmp30_);
					_g_free0 (_tmp27_);
				}
				_tmp33_ = _data77_->fd;
				_tmp34_ = k;
				bird_font_font_data_add_ushort (_tmp33_, _tmp34_->right, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (k);
					_g_object_unref0 (p);
					goto __catch0_g_error;
				}
				_tmp35_ = _data77_->fd;
				_tmp36_ = k;
				bird_font_font_data_add_short (_tmp35_, _tmp36_->kerning, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (k);
					_g_object_unref0 (p);
					goto __catch0_g_error;
				}
				_tmp37_ = k;
				if (G_UNLIKELY (((guint) _tmp37_->right) < _data77_->last_gid_right)) {
					BirdFontKern* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					_tmp38_ = k;
					_tmp39_ = g_strdup_printf ("%hu", _tmp38_->right);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_strdup_printf ("%u", _data77_->last_gid_right);
					_tmp42_ = _tmp41_;
					_tmp43_ = g_strconcat ("Kerning table is not sorted ", _tmp40_, " < ", _tmp42_, ").", NULL);
					_tmp44_ = _tmp43_;
					g_warning ("GposTable.vala:267: %s", _tmp44_);
					_g_free0 (_tmp44_);
					_g_free0 (_tmp42_);
					_g_free0 (_tmp40_);
				}
				_tmp45_ = k;
				_data77_->last_gid_right = (guint) _tmp45_->right;
				_data77_->written += (guint) 4;
				_tmp46_ = _data77_->written_pairs;
				_data77_->written_pairs = _tmp46_ + 1;
				_g_object_unref0 (k);
			}
		}
		_tmp47_ = p;
		_tmp48_ = _tmp47_->pairs;
		_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		if (G_UNLIKELY (_data77_->written_pairs != ((guint) _tmp50_))) {
			gchar* _tmp51_;
			gchar* _tmp52_;
			BirdFontKernList* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			_tmp51_ = g_strdup_printf ("%u", _data77_->written_pairs);
			_tmp52_ = _tmp51_;
			_tmp53_ = self->priv->pairs;
			_tmp54_ = g_strdup_printf ("%u", bird_font_kern_list_get_length (_tmp53_));
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strdup_printf ("%u", pairset_length);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strconcat ("written_pairs != p.pairs.length () ", _tmp52_, " != ", _tmp55_, "   pairset_length: ", _tmp57_, NULL);
			_tmp59_ = _tmp58_;
			g_warning ("GposTable.vala:277: %s", _tmp59_);
			_g_free0 (_tmp59_);
			_g_free0 (_tmp57_);
			_g_free0 (_tmp55_);
			_g_free0 (_tmp52_);
		}
		_tmp60_ = _data77_->i;
		_data77_->i = _tmp60_ + 1;
		_g_object_unref0 (p);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp61_;
		const gchar* _tmp62_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp61_ = e;
		_tmp62_ = _tmp61_->message;
		g_warning ("GposTable.vala:282: %s", _tmp62_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda63__bird_font_kern_list_pair_format1_iterator (BirdFontPairFormat1* k,
                                                        gpointer self)
{
	__lambda63_ (self, k);
}

static void
__lambda64_ (Block77Data* _data77_,
             BirdFontPairFormat1* p)
{
	BirdFontGposTable* self;
	GError* _inner_error0_ = NULL;
	self = _data77_->self;
	g_return_if_fail (p != NULL);
	{
		BirdFontFontData* _tmp0_;
		_tmp0_ = _data77_->fd;
		bird_font_font_data_add_ushort (_tmp0_, p->left, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data77_->written += (guint) 2;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("GposTable.vala:305: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda64__bird_font_kern_list_pair_format1_iterator (BirdFontPairFormat1* k,
                                                        gpointer self)
{
	__lambda64_ (self, k);
}

static BirdFontFontData*
bird_font_gpos_table_get_pair_pos_format1 (BirdFontGposTable* self,
                                           BirdFontKernList* pairs_subset,
                                           GError** error)
{
	Block77Data* _data77_;
	BirdFontFontData* _tmp0_;
	guint coverage_offset = 0U;
	guint16 num_pairs = 0U;
	guint16 pair_set_count = 0U;
	BirdFontFontData* _tmp20_;
	BirdFontFontData* _tmp21_;
	BirdFontFontData* _tmp22_;
	BirdFontFontData* _tmp23_;
	BirdFontFontData* _tmp24_;
	guint16 _tmp31_;
	BirdFontFontData* _tmp38_;
	BirdFontFontData* _tmp52_;
	BirdFontFontData* _tmp53_;
	BirdFontFontData* _tmp60_;
	BirdFontFontData* _tmp61_;
	GError* _inner_error0_ = NULL;
	BirdFontFontData* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pairs_subset != NULL, NULL);
	_data77_ = g_slice_new0 (Block77Data);
	_data77_->_ref_count_ = 1;
	_data77_->self = g_object_ref (self);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	_data77_->fd = _tmp0_;
	num_pairs = (guint16) bird_font_kern_list_get_length (pairs_subset);
	pair_set_count = (guint16) bird_font_kern_list_get_length_left (pairs_subset);
	coverage_offset = (10 + bird_font_gpos_table_pairs_offset_length (pairs_subset)) + bird_font_gpos_table_pairs_set_length (pairs_subset);
	if (coverage_offset > ((guint) G_MAXUINT16)) {
		BirdFontKernList* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp1_ = self->priv->pairs;
		_tmp2_ = g_strdup_printf ("%u", bird_font_kern_list_get_length (_tmp1_));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("Total: ", _tmp3_, ", ", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("Invalid coverage offset.", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%u", bird_font_kern_list_get_length (pairs_subset));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("subset: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp7_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("%u", coverage_offset);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat ("coverage_offset: ", _tmp15_, " > 65535", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp13_, _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		g_warning ("GposTable.vala:185: %s", _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		num_pairs = (guint16) 0;
		coverage_offset = (guint) 10;
	}
	_tmp20_ = _data77_->fd;
	bird_font_font_data_add_ushort (_tmp20_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block77_data_unref (_data77_);
		_data77_ = NULL;
		return NULL;
	}
	_tmp21_ = _data77_->fd;
	bird_font_font_data_add_ushort (_tmp21_, (guint16) coverage_offset, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block77_data_unref (_data77_);
		_data77_ = NULL;
		return NULL;
	}
	_tmp22_ = _data77_->fd;
	bird_font_font_data_add_ushort (_tmp22_, (guint16) 0x0004, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block77_data_unref (_data77_);
		_data77_ = NULL;
		return NULL;
	}
	_tmp23_ = _data77_->fd;
	bird_font_font_data_add_ushort (_tmp23_, (guint16) 0x0000, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block77_data_unref (_data77_);
		_data77_ = NULL;
		return NULL;
	}
	_tmp24_ = _data77_->fd;
	bird_font_font_data_add_ushort (_tmp24_, pair_set_count, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block77_data_unref (_data77_);
		_data77_ = NULL;
		return NULL;
	}
	_data77_->pair_set_offset = 10 + bird_font_gpos_table_pairs_offset_length (pairs_subset);
	_data77_->written = (guint) 0;
	_data77_->written_pairs = (guint) 0;
	bird_font_kern_list_all_pairs_format1 (pairs_subset, ___lambda62__bird_font_kern_list_pair_format1_iterator, _data77_, (gint) num_pairs);
	if (G_UNLIKELY (_data77_->written != bird_font_gpos_table_pairs_offset_length (pairs_subset))) {
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp25_ = g_strdup_printf ("%u", bird_font_gpos_table_pairs_offset_length (pairs_subset));
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strdup_printf ("%u", _data77_->written);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat ("Bad pairs_offset_length () calculated: ", _tmp26_, ", real length ", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		g_warning ("GposTable.vala:227: %s", _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
	}
	_data77_->i = 0;
	_data77_->written = (guint) 0;
	_data77_->last_gid_left = (guint) 0;
	_data77_->last_gid_right = (guint) 0;
	_tmp31_ = num_pairs;
	bird_font_kern_list_all_pairs_format1 (pairs_subset, ___lambda63__bird_font_kern_list_pair_format1_iterator, _data77_, (gint) _tmp31_);
	if (G_UNLIKELY (bird_font_gpos_table_pairs_set_length (pairs_subset) != _data77_->written)) {
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp32_ = g_strdup_printf ("%u", bird_font_gpos_table_pairs_set_length (pairs_subset));
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strdup_printf ("%u", _data77_->written);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("Bad pair set length: ", _tmp33_, ", real length: ", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		g_warning ("GposTable.vala:287: %s", _tmp37_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
	}
	_tmp38_ = _data77_->fd;
	if (G_UNLIKELY (bird_font_font_data_length (_tmp38_) != coverage_offset)) {
		gchar* _tmp39_;
		gchar* _tmp40_;
		BirdFontFontData* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp39_ = g_strdup_printf ("%u", coverage_offset);
		_tmp40_ = _tmp39_;
		_tmp41_ = _data77_->fd;
		_tmp42_ = g_strdup_printf ("%u", bird_font_font_data_length (_tmp41_));
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat ("Bad coverage offset, coverage_offset: ", _tmp40_, ", real length: ", _tmp43_, NULL);
		_tmp45_ = _tmp44_;
		g_warning ("GposTable.vala:291: %s", _tmp45_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp40_);
		_tmp46_ = g_strdup_printf ("%u", bird_font_gpos_table_pairs_offset_length (pairs_subset));
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strdup_printf ("%u", bird_font_gpos_table_pairs_set_length (pairs_subset));
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strconcat ("pairs_offset_length: ", _tmp47_, " pairs_set_length: ", _tmp49_, NULL);
		_tmp51_ = _tmp50_;
		g_warning ("GposTable.vala:292: %s", _tmp51_);
		_g_free0 (_tmp51_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
	}
	_tmp52_ = _data77_->fd;
	bird_font_font_data_add_ushort (_tmp52_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block77_data_unref (_data77_);
		_data77_ = NULL;
		return NULL;
	}
	_tmp53_ = _data77_->fd;
	bird_font_font_data_add_ushort (_tmp53_, pair_set_count, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block77_data_unref (_data77_);
		_data77_ = NULL;
		return NULL;
	}
	_data77_->written = (guint) 0;
	bird_font_kern_list_all_pairs_format1 (pairs_subset, ___lambda64__bird_font_kern_list_pair_format1_iterator, _data77_, (gint) num_pairs);
	if (G_UNLIKELY (_data77_->written != ((guint) (2 * pair_set_count)))) {
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp54_ = g_strdup_printf ("%u", _data77_->written);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strdup_printf ("%hu", pair_set_count);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat ("written != 2 * pair_set_count: ", _tmp55_, " != 2 * ", _tmp57_, NULL);
		_tmp59_ = _tmp58_;
		g_warning ("GposTable.vala:310: %s", _tmp59_);
		_g_free0 (_tmp59_);
		_g_free0 (_tmp57_);
		_g_free0 (_tmp55_);
	}
	_tmp60_ = _data77_->fd;
	_tmp61_ = _g_object_ref0 (_tmp60_);
	result = _tmp61_;
	block77_data_unref (_data77_);
	_data77_ = NULL;
	return result;
}

static Block78Data*
block78_data_ref (Block78Data* _data78_)
{
	g_atomic_int_inc (&_data78_->_ref_count_);
	return _data78_;
}

static void
block78_data_unref (void * _userdata_)
{
	Block78Data* _data78_;
	_data78_ = (Block78Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data78_->_ref_count_)) {
		g_slice_free (Block78Data, _data78_);
	}
}

static void
__lambda61_ (Block78Data* _data78_,
             BirdFontPairFormat1* p)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (p != NULL);
	_tmp0_ = p->pairs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_data78_->len += (guint) (2 + (4 * _tmp2_));
}

static void
___lambda61__bird_font_kern_list_pair_format1_iterator (BirdFontPairFormat1* k,
                                                        gpointer self)
{
	__lambda61_ (self, k);
}

guint
bird_font_gpos_table_pairs_set_length (BirdFontKernList* kerning_list)
{
	Block78Data* _data78_;
	guint result;
	g_return_val_if_fail (kerning_list != NULL, 0U);
	_data78_ = g_slice_new0 (Block78Data);
	_data78_->_ref_count_ = 1;
	_data78_->len = (guint) 0;
	bird_font_kern_list_all_pairs_format1 (kerning_list, ___lambda61__bird_font_kern_list_pair_format1_iterator, _data78_, -1);
	result = _data78_->len;
	block78_data_unref (_data78_);
	_data78_ = NULL;
	return result;
}

guint
bird_font_gpos_table_pairs_offset_length (BirdFontKernList* kerning_list)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	g_return_val_if_fail (kerning_list != NULL, 0U);
	_tmp0_ = kerning_list->pairs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) (2 * _tmp2_);
	return result;
}

static void
bird_font_gpos_table_class_init (BirdFontGposTableClass * klass,
                                 gpointer klass_data)
{
	bird_font_gpos_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontGposTable_private_offset);
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_gpos_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_gpos_table_finalize;
}

static void
bird_font_gpos_table_instance_init (BirdFontGposTable * self,
                                    gpointer klass)
{
	self->priv = bird_font_gpos_table_get_instance_private (self);
}

static void
bird_font_gpos_table_finalize (GObject * obj)
{
	BirdFontGposTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_GPOS_TABLE, BirdFontGposTable);
	_g_object_unref0 (self->priv->glyf_table);
	_g_object_unref0 (self->priv->pairs);
	G_OBJECT_CLASS (bird_font_gpos_table_parent_class)->finalize (obj);
}

static GType
bird_font_gpos_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontGposTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_gpos_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontGposTable), 0, (GInstanceInitFunc) bird_font_gpos_table_instance_init, NULL };
	GType bird_font_gpos_table_type_id;
	bird_font_gpos_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontGposTable", &g_define_type_info, 0);
	BirdFontGposTable_private_offset = g_type_add_instance_private (bird_font_gpos_table_type_id, sizeof (BirdFontGposTablePrivate));
	return bird_font_gpos_table_type_id;
}

GType
bird_font_gpos_table_get_type (void)
{
	static volatile gsize bird_font_gpos_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_gpos_table_type_id__once)) {
		GType bird_font_gpos_table_type_id;
		bird_font_gpos_table_type_id = bird_font_gpos_table_get_type_once ();
		g_once_init_leave (&bird_font_gpos_table_type_id__once, bird_font_gpos_table_type_id);
	}
	return bird_font_gpos_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

