/* GlyphRange.c generated by valac 0.56.16, the Vala compiler
 * generated from GlyphRange.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _BirdFontParamSpecGlyphRange BirdFontParamSpecGlyphRange;

struct _BirdFontGlyphRangePrivate {
	gchar* _name;
	guint32 len;
	gboolean range_is_class;
	guint32* range_index;
	gint index_size;
};

struct _BirdFontParamSpecGlyphRange {
	GParamSpec parent_instance;
};

static gint BirdFontGlyphRange_private_offset;
static gpointer bird_font_glyph_range_parent_class = NULL;

static void bird_font_glyph_range_generate_unirange_index (BirdFontGlyphRange* self);
static gint __lambda4_ (BirdFontGlyphRange* self,
                 BirdFontUniRange* a,
                 BirdFontUniRange* b);
static gint ___lambda4__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gboolean bird_font_glyph_range_unique (BirdFontGlyphRange* self,
                                       gunichar start,
                                       gunichar stop);
static void bird_font_glyph_range_append_range (BirdFontGlyphRange* self,
                                         gunichar start,
                                         gunichar stop);
static void bird_font_glyph_range_parse_range_string (BirdFontGlyphRange* self,
                                               const gchar* ranges,
                                               GError** error);
static void bird_font_glyph_range_parse_range (BirdFontGlyphRange* self,
                                        const gchar* s,
                                        GError** error);
static BirdFontUniRange* bird_font_glyph_range_insert_range (BirdFontGlyphRange* self,
                                                      gunichar start,
                                                      gunichar stop);
static void bird_font_glyph_range_merge_range (BirdFontGlyphRange* self,
                                        BirdFontUniRange* r);
static void bird_font_glyph_range_get_unirange_index (BirdFontGlyphRange* self,
                                               guint32 index,
                                               BirdFontUniRange** range,
                                               guint32* range_start_index);
static gboolean bird_font_glyph_range_inside (gunichar start,
                                       gunichar u_start,
                                       gunichar u_stop);
static void bird_font_glyph_range_finalize (BirdFontGlyphRange * obj);
static GType bird_font_glyph_range_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bird_font_glyph_range_get_instance_private (BirdFontGlyphRange* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontGlyphRange_private_offset);
}

BirdFontGlyphRange*
bird_font_glyph_range_construct (GType object_type)
{
	BirdFontGlyphRange* self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (BirdFontGlyphRange*) g_type_create_instance (object_type);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_UNI_RANGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->ranges);
	self->ranges = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->unassigned);
	self->unassigned = _tmp1_;
	bird_font_glyph_range_set_name (self, "No name");
	return self;
}

BirdFontGlyphRange*
bird_font_glyph_range_new (void)
{
	return bird_font_glyph_range_construct (BIRD_FONT_TYPE_GLYPH_RANGE);
}

static void
bird_font_glyph_range_generate_unirange_index (BirdFontGlyphRange* self)
{
	guint32* _tmp0_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	guint32* _tmp5_;
	gint i = 0;
	guint32 next_index = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->range_index;
	if (_tmp0_ != NULL) {
		guint32* _tmp1_;
		_tmp1_ = self->priv->range_index;
		_g_free0 (_tmp1_);
	}
	_tmp2_ = self->ranges;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->index_size = _tmp4_;
	_tmp5_ = g_new0 (guint32, self->priv->index_size);
	self->priv->range_index = _tmp5_;
	i = 0;
	next_index = (guint32) 0;
	{
		GeeArrayList* _range_list = NULL;
		GeeArrayList* _tmp6_;
		gint _range_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _range_index = 0;
		_tmp6_ = self->ranges;
		_range_list = _tmp6_;
		_tmp7_ = _range_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_range_size = _tmp9_;
		_range_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontUniRange* range = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			guint32* _tmp14_;
			BirdFontUniRange* _tmp15_;
			gint _tmp16_;
			_range_index = _range_index + 1;
			_tmp10_ = _range_index;
			_tmp11_ = _range_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _range_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _range_index);
			range = (BirdFontUniRange*) _tmp13_;
			_tmp14_ = self->priv->range_index;
			_tmp14_[i] = next_index;
			_tmp15_ = range;
			next_index += (guint32) bird_font_uni_range_length (_tmp15_);
			_tmp16_ = i;
			i = _tmp16_ + 1;
			_g_object_unref0 (range);
		}
	}
}

void
bird_font_glyph_range_add_unassigned (BirdFontGlyphRange* self,
                                      const gchar* glyph_name)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyph_name != NULL);
	_tmp0_ = self->unassigned;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, glyph_name);
}

gboolean
bird_font_glyph_range_is_class (BirdFontGlyphRange* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->range_is_class) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->len > ((guint32) 1);
	}
	result = _tmp0_;
	return result;
}

void
bird_font_glyph_range_set_class (BirdFontGlyphRange* self,
                                 gboolean c)
{
	g_return_if_fail (self != NULL);
	self->priv->range_is_class = TRUE;
}

gboolean
bird_font_glyph_range_is_empty (BirdFontGlyphRange* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->len == ((guint32) 0);
	return result;
}

void
bird_font_glyph_range_empty (BirdFontGlyphRange* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->unassigned;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->ranges;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	self->priv->len = (guint32) 0;
	bird_font_glyph_range_generate_unirange_index (self);
}

GeeArrayList*
bird_font_glyph_range_get_ranges (BirdFontGlyphRange* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->ranges;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
__lambda4_ (BirdFontGlyphRange* self,
            BirdFontUniRange* a,
            BirdFontUniRange* b)
{
	BirdFontUniRange* first = NULL;
	BirdFontUniRange* next = NULL;
	gboolean r = FALSE;
	BirdFontUniRange* _tmp0_;
	BirdFontUniRange* _tmp1_;
	BirdFontUniRange* _tmp2_;
	BirdFontUniRange* _tmp3_;
	BirdFontUniRange* _tmp4_;
	BirdFontUniRange* _tmp5_;
	gint _tmp6_ = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_UNI_RANGE, BirdFontUniRange));
	_g_object_unref0 (first);
	first = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_UNI_RANGE, BirdFontUniRange));
	_g_object_unref0 (next);
	next = _tmp1_;
	_tmp2_ = first;
	_tmp3_ = next;
	r = _tmp2_->start > _tmp3_->start;
	_tmp4_ = first;
	_tmp5_ = next;
	g_return_val_if_fail (_tmp4_->start != _tmp5_->start, 0);
	if (r) {
		_tmp6_ = 1;
	} else {
		_tmp6_ = -1;
	}
	result = _tmp6_;
	_g_object_unref0 (next);
	_g_object_unref0 (first);
	return result;
}

static gint
___lambda4__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda4_ ((BirdFontGlyphRange*) self, (BirdFontUniRange*) a, (BirdFontUniRange*) b);
	return result;
}

void
bird_font_glyph_range_sort (BirdFontGlyphRange* self)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->ranges;
	gee_list_sort ((GeeList*) _tmp0_, ___lambda4__gcompare_data_func, bird_font_glyph_range_ref (self), bird_font_glyph_range_unref);
	bird_font_glyph_range_generate_unirange_index (self);
}

void
bird_font_glyph_range_add_single (BirdFontGlyphRange* self,
                                  gunichar c)
{
	g_return_if_fail (self != NULL);
	bird_font_glyph_range_add_range (self, c, c);
}

guint32
bird_font_glyph_range_get_length (BirdFontGlyphRange* self)
{
	guint32 l = 0U;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	l = self->priv->len;
	_tmp0_ = self->unassigned;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	l += (guint32) _tmp2_;
	result = l;
	return result;
}

void
bird_font_glyph_range_add_range (BirdFontGlyphRange* self,
                                 gunichar start,
                                 gunichar stop)
{
	gunichar b = 0U;
	gunichar s = 0U;
	g_return_if_fail (self != NULL);
	if (bird_font_glyph_range_unique (self, start, stop)) {
		bird_font_glyph_range_append_range (self, start, stop);
	} else {
		b = start;
		s = b;
		if (!bird_font_glyph_range_unique (self, b, b)) {
			while (TRUE) {
				if (!(b < stop)) {
					break;
				}
				if (!bird_font_glyph_range_unique (self, b, b)) {
					gunichar _tmp0_;
					_tmp0_ = b;
					b = _tmp0_ + 1;
				} else {
					gunichar _tmp1_;
					if (s != b) {
						bird_font_glyph_range_add_range (self, b, stop);
					}
					_tmp1_ = b;
					b = _tmp1_ + 1;
					s = b;
				}
			}
		} else {
			while (TRUE) {
				if (!(b < stop)) {
					break;
				}
				if (bird_font_glyph_range_unique (self, b, b)) {
					gunichar _tmp2_;
					_tmp2_ = b;
					b = _tmp2_ + 1;
				} else {
					gunichar _tmp3_;
					if (s != b) {
						bird_font_glyph_range_add_range (self, start, b - 1);
					}
					_tmp3_ = b;
					b = _tmp3_ + 1;
					s = b;
				}
			}
		}
	}
	bird_font_glyph_range_generate_unirange_index (self);
}

/** Parse ranges on the form a-z. Single characters can be added as well as 
 * multiple ranges separated by space. The word "space" is used to kern against 
 * the space character and the word "divis" is used to kern against "-".
 * @param ranges unicode ranges
 */
void
bird_font_glyph_range_parse_ranges (BirdFontGlyphRange* self,
                                    const gchar* ranges,
                                    GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ranges != NULL);
	bird_font_glyph_range_parse_range_string (self, ranges, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_MARKUP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	bird_font_glyph_range_generate_unirange_index (self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
bird_font_glyph_range_parse_range_string (BirdFontGlyphRange* self,
                                          const gchar* ranges,
                                          GError** error)
{
	gchar** r = NULL;
	gint r_length1 = 0;
	gint _r_size_ = 0;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ranges != NULL);
	if (g_strcmp0 (ranges, " ") == 0) {
		bird_font_glyph_range_add_single (self, (gunichar) ' ');
	}
	_tmp1_ = _tmp0_ = g_strsplit (ranges, " ", 0);
	r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
	r = _tmp1_;
	r_length1 = _vala_array_length (_tmp0_);
	_r_size_ = r_length1;
	_tmp2_ = r;
	_tmp2__length1 = r_length1;
	{
		gchar** w_collection = NULL;
		gint w_collection_length1 = 0;
		gint _w_collection_size_ = 0;
		gint w_it = 0;
		w_collection = _tmp2_;
		w_collection_length1 = _tmp2__length1;
		for (w_it = 0; w_it < w_collection_length1; w_it = w_it + 1) {
			gchar* _tmp3_;
			gchar* w = NULL;
			_tmp3_ = g_strdup (w_collection[w_it]);
			w = _tmp3_;
			{
				const gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp4_ = w;
				_tmp5_ = string_replace (_tmp4_, " ", "");
				_g_free0 (w);
				w = _tmp5_;
				_tmp6_ = w;
				if (g_strcmp0 (_tmp6_, "") == 0) {
					_g_free0 (w);
					continue;
				}
				_tmp7_ = w;
				if (g_utf8_strlen (_tmp7_, (gssize) -1) == 1) {
					gunichar c = 0U;
					const gchar* _tmp8_;
					_tmp8_ = w;
					c = g_utf8_get_char_validated (_tmp8_, (gssize) -1);
					if (c > ((gunichar) 0)) {
						bird_font_glyph_range_add_single (self, c);
					}
				} else {
					const gchar* _tmp9_;
					_tmp9_ = w;
					if (g_strcmp0 (_tmp9_, "space") == 0) {
						bird_font_glyph_range_add_single (self, (gunichar) ' ');
					} else {
						const gchar* _tmp10_;
						_tmp10_ = w;
						if (g_strcmp0 (_tmp10_, "divis") == 0) {
							bird_font_glyph_range_add_single (self, (gunichar) '-');
						} else {
							const gchar* _tmp11_;
							_tmp11_ = w;
							if (g_strcmp0 (_tmp11_, "null") == 0) {
								bird_font_glyph_range_add_single (self, (gunichar) '\0');
							} else {
								const gchar* _tmp12_;
								_tmp12_ = w;
								if (string_index_of (_tmp12_, "-", 0) > -1) {
									const gchar* _tmp13_;
									_tmp13_ = w;
									bird_font_glyph_range_parse_range (self, _tmp13_, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										if (_inner_error0_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error0_);
											_g_free0 (w);
											r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
											return;
										} else {
											_g_free0 (w);
											r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
									}
								} else {
									const gchar* _tmp14_;
									_tmp14_ = w;
									if (g_strcmp0 (_tmp14_, "quote") == 0) {
										bird_font_glyph_range_add_single (self, (gunichar) '"');
									} else {
										const gchar* _tmp15_;
										_tmp15_ = w;
										if (g_strcmp0 (_tmp15_, "ampersand") == 0) {
											bird_font_glyph_range_add_single (self, (gunichar) '&');
										} else {
											GeeArrayList* _tmp16_;
											const gchar* _tmp17_;
											_tmp16_ = self->unassigned;
											_tmp17_ = w;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
										}
									}
								}
							}
						}
					}
				}
				_g_free0 (w);
			}
		}
	}
	r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
}

/** A readable representation of ranges, see parse_ranges for parsing 
 * this string. This function is used for storing ranges in th .bf format.
 */
gchar*
bird_font_glyph_range_get_all_ranges (BirdFontGlyphRange* self)
{
	gboolean first = FALSE;
	GString* s = NULL;
	GString* _tmp0_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	first = TRUE;
	_tmp0_ = g_string_new ("");
	s = _tmp0_;
	{
		GeeArrayList* _u_list = NULL;
		GeeArrayList* _tmp1_;
		gint _u_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _u_index = 0;
		_tmp1_ = self->ranges;
		_u_list = _tmp1_;
		_tmp2_ = _u_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_u_size = _tmp4_;
		_u_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontUniRange* u = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontUniRange* _tmp10_;
			BirdFontUniRange* _tmp11_;
			_u_index = _u_index + 1;
			_tmp5_ = _u_index;
			_tmp6_ = _u_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _u_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _u_index);
			u = (BirdFontUniRange*) _tmp8_;
			if (!first) {
				GString* _tmp9_;
				_tmp9_ = s;
				g_string_append (_tmp9_, " ");
			}
			_tmp10_ = u;
			_tmp11_ = u;
			if (_tmp10_->start == _tmp11_->stop) {
				GString* _tmp12_;
				BirdFontUniRange* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = s;
				_tmp13_ = u;
				_tmp14_ = bird_font_glyph_range_get_serialized_char (_tmp13_->start);
				_tmp15_ = _tmp14_;
				g_string_append (_tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
			} else {
				GString* _tmp16_;
				BirdFontUniRange* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				GString* _tmp20_;
				GString* _tmp21_;
				BirdFontUniRange* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp16_ = s;
				_tmp17_ = u;
				_tmp18_ = bird_font_glyph_range_get_serialized_char (_tmp17_->start);
				_tmp19_ = _tmp18_;
				g_string_append (_tmp16_, _tmp19_);
				_g_free0 (_tmp19_);
				_tmp20_ = s;
				g_string_append (_tmp20_, "-");
				_tmp21_ = s;
				_tmp22_ = u;
				_tmp23_ = bird_font_glyph_range_get_serialized_char (_tmp22_->stop);
				_tmp24_ = _tmp23_;
				g_string_append (_tmp21_, _tmp24_);
				_g_free0 (_tmp24_);
			}
			first = FALSE;
			_g_object_unref0 (u);
		}
	}
	{
		GeeArrayList* _ur_list = NULL;
		GeeArrayList* _tmp25_;
		gint _ur_size = 0;
		GeeArrayList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _ur_index = 0;
		_tmp25_ = self->unassigned;
		_ur_list = _tmp25_;
		_tmp26_ = _ur_list;
		_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_ur_size = _tmp28_;
		_ur_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			gchar* ur = NULL;
			GeeArrayList* _tmp31_;
			gpointer _tmp32_;
			GString* _tmp34_;
			const gchar* _tmp35_;
			_ur_index = _ur_index + 1;
			_tmp29_ = _ur_index;
			_tmp30_ = _ur_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _ur_list;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _ur_index);
			ur = (gchar*) _tmp32_;
			if (!first) {
				GString* _tmp33_;
				_tmp33_ = s;
				g_string_append (_tmp33_, " ");
			}
			_tmp34_ = s;
			_tmp35_ = ur;
			g_string_append (_tmp34_, _tmp35_);
			first = FALSE;
			_g_free0 (ur);
		}
	}
	_tmp36_ = s;
	_tmp37_ = _tmp36_->str;
	_tmp38_ = g_strdup (_tmp37_);
	result = _tmp38_;
	_g_string_free0 (s);
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

gchar*
bird_font_glyph_range_serialize (const gchar* s)
{
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	if (g_strcmp0 (s, "space") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (s);
		result = _tmp0_;
		return result;
	}
	if (g_strcmp0 (s, "divis") == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (s);
		result = _tmp1_;
		return result;
	}
	if (g_strcmp0 (s, "null") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (s);
		result = _tmp2_;
		return result;
	}
	if (g_strcmp0 (s, "quote") == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (s);
		result = _tmp3_;
		return result;
	}
	if (g_strcmp0 (s, "ampersand") == 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (s);
		result = _tmp4_;
		return result;
	}
	if (g_strcmp0 (s, "&quot;") == 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (s);
		result = _tmp5_;
		return result;
	}
	if (g_strcmp0 (s, "&amp;") == 0) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (s);
		result = _tmp6_;
		return result;
	}
	if (g_strcmp0 (s, "&lt;") == 0) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (s);
		result = _tmp7_;
		return result;
	}
	if (g_strcmp0 (s, "&gt;") == 0) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup (s);
		result = _tmp8_;
		return result;
	}
	if (g_utf8_strlen (s, (gssize) -1) > 1) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (s);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = bird_font_glyph_range_get_serialized_char (string_get_char (s, (glong) 0));
	result = _tmp10_;
	return result;
}

gchar*
bird_font_glyph_range_get_serialized_char (gunichar c)
{
	GString* s = NULL;
	GString* _tmp0_;
	GString* _tmp9_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	_tmp0_ = g_string_new ("");
	s = _tmp0_;
	if (c == ((gunichar) '&')) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("&amp;");
		result = _tmp1_;
		_g_string_free0 (s);
		return result;
	}
	if (c == ((gunichar) '<')) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("&lt;");
		result = _tmp2_;
		_g_string_free0 (s);
		return result;
	}
	if (c == ((gunichar) '>')) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("&gt;");
		result = _tmp3_;
		_g_string_free0 (s);
		return result;
	}
	if (c == ((gunichar) ' ')) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("space");
		result = _tmp4_;
		_g_string_free0 (s);
		return result;
	}
	if (c == ((gunichar) '-')) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("divis");
		result = _tmp5_;
		_g_string_free0 (s);
		return result;
	}
	if (c == ((gunichar) '\0')) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("null");
		result = _tmp6_;
		_g_string_free0 (s);
		return result;
	}
	if (c == ((gunichar) '"')) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("quote");
		result = _tmp7_;
		_g_string_free0 (s);
		return result;
	}
	if (c == ((gunichar) '&')) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("ampersand");
		result = _tmp8_;
		_g_string_free0 (s);
		return result;
	}
	_tmp9_ = s;
	g_string_append_unichar (_tmp9_, c);
	_tmp10_ = s;
	_tmp11_ = _tmp10_->str;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_string_free0 (s);
	return result;
}

gchar*
bird_font_glyph_range_unserialize (const gchar* c)
{
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (c != NULL, NULL);
	if (g_strcmp0 (c, "&quot;") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("\"");
		result = _tmp0_;
		return result;
	}
	if (g_strcmp0 (c, "&amp;") == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("&");
		result = _tmp1_;
		return result;
	}
	if (g_strcmp0 (c, "&lt;") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("<");
		result = _tmp2_;
		return result;
	}
	if (g_strcmp0 (c, "&gt;") == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (">");
		result = _tmp3_;
		return result;
	}
	if (g_strcmp0 (c, "space") == 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (" ");
		result = _tmp4_;
		return result;
	}
	if (g_strcmp0 (c, "divis") == 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("-");
		result = _tmp5_;
		return result;
	}
	if (g_strcmp0 (c, "null") == 0) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("\0");
		result = _tmp6_;
		return result;
	}
	if (g_strcmp0 (c, "quote") == 0) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("\"");
		result = _tmp7_;
		return result;
	}
	if (g_strcmp0 (c, "ampersand") == 0) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("&");
		result = _tmp8_;
		return result;
	}
	_tmp9_ = g_strdup (c);
	result = _tmp9_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_glyph_range_parse_range (BirdFontGlyphRange* self,
                                   const gchar* s,
                                   GError** error)
{
	gchar** r = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint r_length1;
	gint _r_size_;
	gboolean null_range = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp34_;
	gint _tmp34__length1;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (s, "-", 0);
	r = _tmp1_;
	r_length1 = _vala_array_length (_tmp0_);
	_r_size_ = r_length1;
	null_range = FALSE;
	_tmp4_ = r;
	_tmp4__length1 = r_length1;
	if (_tmp4__length1 == 2) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		_tmp5_ = r;
		_tmp5__length1 = r_length1;
		_tmp6_ = _tmp5_[0];
		_tmp3_ = g_strcmp0 (_tmp6_, "null") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		_tmp7_ = r;
		_tmp7__length1 = r_length1;
		_tmp8_ = _tmp7_[1];
		_tmp2_ = g_strcmp0 (_tmp8_, "null") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		null_range = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp11_ = r;
		_tmp11__length1 = r_length1;
		if (_tmp11__length1 == 2) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			_tmp12_ = r;
			_tmp12__length1 = r_length1;
			_tmp13_ = _tmp12_[0];
			_tmp10_ = g_strcmp0 (_tmp13_, "null") == 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp14_ = r;
			_tmp14__length1 = r_length1;
			_tmp15_ = _tmp14_[1];
			_tmp16_ = bird_font_glyph_range_unserialize (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp9_ = g_utf8_strlen (_tmp17_, (gssize) -1) == 1;
			_g_free0 (_tmp17_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			null_range = TRUE;
		}
	}
	if (!null_range) {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gchar** _tmp20_;
		gint _tmp20__length1;
		_tmp20_ = r;
		_tmp20__length1 = r_length1;
		if (_tmp20__length1 != 2) {
			_tmp19_ = TRUE;
		} else {
			gchar** _tmp21_;
			gint _tmp21__length1;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp21_ = r;
			_tmp21__length1 = r_length1;
			_tmp22_ = _tmp21_[0];
			_tmp23_ = bird_font_glyph_range_unserialize (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp19_ = g_utf8_strlen (_tmp24_, (gssize) -1) != 1;
			_g_free0 (_tmp24_);
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gchar** _tmp25_;
			gint _tmp25__length1;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp25_ = r;
			_tmp25__length1 = r_length1;
			_tmp26_ = _tmp25_[1];
			_tmp27_ = bird_font_glyph_range_unserialize (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp18_ = g_utf8_strlen (_tmp28_, (gssize) -1) != 1;
			_g_free0 (_tmp28_);
		}
		if (_tmp18_) {
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			GError* _tmp32_;
			GError* _tmp33_;
			_tmp29_ = string_to_string (s);
			_tmp30_ = g_strconcat (_tmp29_, " is not a valid range, it should be on the form A-Z.", NULL);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_PARSE, _tmp31_);
			_tmp33_ = _tmp32_;
			_g_free0 (_tmp31_);
			_inner_error0_ = _tmp33_;
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
				return;
			} else {
				r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp34_ = r;
	_tmp34__length1 = r_length1;
	_tmp35_ = _tmp34_[0];
	_tmp36_ = bird_font_glyph_range_unserialize (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = r;
	_tmp38__length1 = r_length1;
	_tmp39_ = _tmp38_[1];
	_tmp40_ = bird_font_glyph_range_unserialize (_tmp39_);
	_tmp41_ = _tmp40_;
	bird_font_glyph_range_append_range (self, string_get_char (_tmp37_, (glong) 0), string_get_char (_tmp41_, (glong) 0));
	_g_free0 (_tmp41_);
	_g_free0 (_tmp37_);
	r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
}

static void
bird_font_glyph_range_append_range (BirdFontGlyphRange* self,
                                    gunichar start,
                                    gunichar stop)
{
	BirdFontUniRange* r = NULL;
	BirdFontUniRange* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_glyph_range_insert_range (self, start, stop);
	_g_object_unref0 (r);
	r = _tmp0_;
	bird_font_glyph_range_merge_range (self, r);
	_g_object_unref0 (r);
}

static void
bird_font_glyph_range_merge_range (BirdFontGlyphRange* self,
                                   BirdFontUniRange* r)
{
	GeeArrayList* deleted = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* merged = NULL;
	GeeArrayList* _tmp1_;
	gboolean updated = FALSE;
	GeeArrayList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_UNI_RANGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	deleted = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_UNI_RANGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	merged = _tmp1_;
	updated = FALSE;
	{
		GeeArrayList* _u_list = NULL;
		GeeArrayList* _tmp2_;
		gint _u_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _u_index = 0;
		_tmp2_ = self->ranges;
		_u_list = _tmp2_;
		_tmp3_ = _u_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_u_size = _tmp5_;
		_u_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontUniRange* u = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontUniRange* _tmp10_;
			BirdFontUniRange* _tmp11_;
			BirdFontUniRange* _tmp16_;
			_u_index = _u_index + 1;
			_tmp6_ = _u_index;
			_tmp7_ = _u_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _u_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _u_index);
			u = (BirdFontUniRange*) _tmp9_;
			_tmp10_ = u;
			if (_tmp10_ == r) {
				_g_object_unref0 (u);
				continue;
			}
			_tmp11_ = u;
			if (_tmp11_->start == (r->stop + 1)) {
				BirdFontUniRange* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp14_;
				BirdFontUniRange* _tmp15_;
				_tmp12_ = u;
				_tmp12_->start = r->start;
				_tmp13_ = deleted;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, r);
				_tmp14_ = merged;
				_tmp15_ = u;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
				_g_object_unref0 (u);
				break;
			}
			_tmp16_ = u;
			if (_tmp16_->stop == (r->start - 1)) {
				BirdFontUniRange* _tmp17_;
				GeeArrayList* _tmp18_;
				GeeArrayList* _tmp19_;
				BirdFontUniRange* _tmp20_;
				_tmp17_ = u;
				_tmp17_->stop = r->stop;
				_tmp18_ = deleted;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, r);
				_tmp19_ = merged;
				_tmp20_ = u;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
				_g_object_unref0 (u);
				break;
			}
			_g_object_unref0 (u);
		}
	}
	_tmp21_ = merged;
	_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	updated = _tmp23_ > 0;
	{
		GeeArrayList* _m_list = NULL;
		GeeArrayList* _tmp24_;
		gint _m_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _m_index = 0;
		_tmp24_ = deleted;
		_m_list = _tmp24_;
		_tmp25_ = _m_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_m_size = _tmp27_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			BirdFontUniRange* m = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			_m_index = _m_index + 1;
			_tmp28_ = _m_index;
			_tmp29_ = _m_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _m_list;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _m_index);
			m = (BirdFontUniRange*) _tmp31_;
			while (TRUE) {
				GeeArrayList* _tmp32_;
				BirdFontUniRange* _tmp33_;
				_tmp32_ = self->ranges;
				_tmp33_ = m;
				if (!gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp32_, _tmp33_)) {
					break;
				}
			}
			_g_object_unref0 (m);
		}
	}
	{
		GeeArrayList* _m_list = NULL;
		GeeArrayList* _tmp34_;
		gint _m_size = 0;
		GeeArrayList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _m_index = 0;
		_tmp34_ = merged;
		_m_list = _tmp34_;
		_tmp35_ = _m_list;
		_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_m_size = _tmp37_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			BirdFontUniRange* m = NULL;
			GeeArrayList* _tmp40_;
			gpointer _tmp41_;
			BirdFontUniRange* _tmp42_;
			_m_index = _m_index + 1;
			_tmp38_ = _m_index;
			_tmp39_ = _m_size;
			if (!(_tmp38_ < _tmp39_)) {
				break;
			}
			_tmp40_ = _m_list;
			_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _m_index);
			m = (BirdFontUniRange*) _tmp41_;
			_tmp42_ = m;
			bird_font_glyph_range_merge_range (self, _tmp42_);
			_g_object_unref0 (m);
		}
	}
	if (updated) {
		bird_font_glyph_range_merge_range (self, r);
	}
	_g_object_unref0 (merged);
	_g_object_unref0 (deleted);
}

/** Find a range which contains index. */
static void
bird_font_glyph_range_get_unirange_index (BirdFontGlyphRange* self,
                                          guint32 index,
                                          BirdFontUniRange** range,
                                          guint32* range_start_index)
{
	BirdFontUniRange* _vala_range = NULL;
	guint32 _vala_range_start_index = 0U;
	gint lower = 0;
	gint upper = 0;
	gint i = 0;
	gint end = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	lower = 0;
	upper = self->priv->index_size - 1;
	i = (lower + upper) / 2;
	end = self->priv->index_size - 1;
	_vala_range_start_index = (guint32) -1;
	_g_object_unref0 (_vala_range);
	_vala_range = NULL;
	_tmp0_ = self->ranges;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (G_UNLIKELY (_tmp2_ != self->priv->index_size)) {
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp3_ = self->ranges;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%i", _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%i", self->priv->index_size);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Range size does not match index size: ", _tmp7_, " != ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		g_warning ("GlyphRange.vala:444: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
	}
	while (TRUE) {
		gboolean _tmp12_ = FALSE;
		guint32* _tmp29_;
		guint32 _tmp30_;
		if (i == end) {
			guint32* _tmp13_;
			guint32 _tmp14_;
			_tmp13_ = self->priv->range_index;
			_tmp14_ = _tmp13_[i];
			_tmp12_ = _tmp14_ <= index;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			guint32* _tmp15_;
			guint32 _tmp16_;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			_tmp15_ = self->priv->range_index;
			_tmp16_ = _tmp15_[i];
			_vala_range_start_index = _tmp16_;
			_tmp17_ = self->ranges;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, i);
			_g_object_unref0 (_vala_range);
			_vala_range = (BirdFontUniRange*) _tmp18_;
			break;
		} else {
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			if (i != end) {
				guint32* _tmp21_;
				guint32 _tmp22_;
				_tmp21_ = self->priv->range_index;
				_tmp22_ = _tmp21_[i];
				_tmp20_ = _tmp22_ <= index;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				guint32* _tmp23_;
				guint32 _tmp24_;
				_tmp23_ = self->priv->range_index;
				_tmp24_ = _tmp23_[i + 1];
				_tmp19_ = _tmp24_ > index;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				guint32* _tmp25_;
				guint32 _tmp26_;
				GeeArrayList* _tmp27_;
				gpointer _tmp28_;
				_tmp25_ = self->priv->range_index;
				_tmp26_ = _tmp25_[i];
				_vala_range_start_index = _tmp26_;
				_tmp27_ = self->ranges;
				_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, i);
				_g_object_unref0 (_vala_range);
				_vala_range = (BirdFontUniRange*) _tmp28_;
				break;
			}
		}
		if (lower >= upper) {
			break;
		}
		_tmp29_ = self->priv->range_index;
		_tmp30_ = _tmp29_[i];
		if (_tmp30_ < index) {
			lower = i + 1;
		} else {
			upper = i - 1;
		}
		i = (lower + upper) / 2;
	}
	if (range) {
		*range = _vala_range;
	} else {
		_g_object_unref0 (_vala_range);
	}
	if (range_start_index) {
		*range_start_index = _vala_range_start_index;
	}
}

gchar*
bird_font_glyph_range_get_char (BirdFontGlyphRange* self,
                                guint32 index)
{
	GString* sb = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	_g_string_free0 (sb);
	sb = _tmp0_;
	g_string_append_unichar (sb, bird_font_glyph_range_get_character (self, index));
	_tmp1_ = sb->str;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	_g_string_free0 (sb);
	return result;
}

gunichar
bird_font_glyph_range_get_character (BirdFontGlyphRange* self,
                                     guint32 index)
{
	gchar* chr = NULL;
	BirdFontUniRange* r = NULL;
	gunichar c = 0U;
	BirdFontUniRange* range = NULL;
	guint32 range_start_index = 0U;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	BirdFontUniRange* _tmp9_ = NULL;
	guint32 _tmp10_ = 0U;
	BirdFontUniRange* _tmp11_;
	gboolean _tmp16_ = FALSE;
	BirdFontUniRange* _tmp23_;
	BirdFontUniRange* _tmp24_;
	BirdFontUniRange* _tmp25_;
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->unassigned;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (G_UNLIKELY (index > (self->priv->len + _tmp2_))) {
		result = (gunichar) '\0';
		_g_object_unref0 (range);
		_g_object_unref0 (r);
		_g_free0 (chr);
		return result;
	}
	if (index >= self->priv->len) {
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		GeeArrayList* _tmp6_;
		gpointer _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = self->unassigned;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (G_UNLIKELY ((index - self->priv->len) >= ((guint32) _tmp5_))) {
			result = (gunichar) '\0';
			_g_object_unref0 (range);
			_g_object_unref0 (r);
			_g_free0 (chr);
			return result;
		}
		_tmp6_ = self->unassigned;
		_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, (gint) (index - self->priv->len));
		_g_free0 (chr);
		chr = (gchar*) _tmp7_;
		_tmp8_ = chr;
		result = string_get_char (_tmp8_, (glong) 0);
		_g_object_unref0 (range);
		_g_object_unref0 (r);
		_g_free0 (chr);
		return result;
	}
	bird_font_glyph_range_get_unirange_index (self, index, &_tmp9_, &_tmp10_);
	_g_object_unref0 (range);
	range = _tmp9_;
	range_start_index = _tmp10_;
	_tmp11_ = range;
	if (G_UNLIKELY (_tmp11_ == NULL)) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = g_strdup_printf ("%u", index);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("No range found for index ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		g_warning ("GlyphRange.vala:504: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		result = (gunichar) '\0';
		_g_object_unref0 (range);
		_g_object_unref0 (r);
		_g_free0 (chr);
		return result;
	}
	if (range_start_index > index) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = range_start_index == ((guint32) -1);
	}
	if (G_UNLIKELY (_tmp16_)) {
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp17_ = g_strdup_printf ("%u", range_start_index);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%u", index);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat ("Index out of bounds in glyph range, range_start_index: ", _tmp18_, " index: ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		g_warning ("GlyphRange.vala:509: %s", _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		result = (gunichar) '\0';
		_g_object_unref0 (range);
		_g_object_unref0 (r);
		_g_free0 (chr);
		return result;
	}
	_tmp23_ = range;
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, BIRD_FONT_TYPE_UNI_RANGE, BirdFontUniRange));
	_g_object_unref0 (r);
	r = _tmp24_;
	_tmp25_ = r;
	c = bird_font_uni_range_get_char (_tmp25_, (gunichar) (index - range_start_index));
	if (G_UNLIKELY (!g_unichar_validate (c))) {
		g_warning ("GlyphRange.vala:517: Not a valid unicode character.");
		result = (gunichar) '\0';
		_g_object_unref0 (range);
		_g_object_unref0 (r);
		_g_free0 (chr);
		return result;
	}
	result = c;
	_g_object_unref0 (range);
	_g_object_unref0 (r);
	_g_free0 (chr);
	return result;
}

guint32
bird_font_glyph_range_length (BirdFontGlyphRange* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->len;
	return result;
}

gboolean
bird_font_glyph_range_has_character (BirdFontGlyphRange* self,
                                     const gchar* c)
{
	gunichar s = 0U;
	gchar* uns = NULL;
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->unassigned;
	if (gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, c) != -1) {
		result = TRUE;
		_g_free0 (uns);
		return result;
	}
	_tmp1_ = bird_font_glyph_range_unserialize (c);
	_g_free0 (uns);
	uns = _tmp1_;
	_tmp2_ = uns;
	if (g_utf8_strlen (_tmp2_, (gssize) -1) != 1) {
		result = FALSE;
		_g_free0 (uns);
		return result;
	}
	_tmp3_ = uns;
	s = string_get_char (_tmp3_, (glong) 0);
	result = !bird_font_glyph_range_unique (self, s, s);
	_g_free0 (uns);
	return result;
}

gboolean
bird_font_glyph_range_has_unichar (BirdFontGlyphRange* self,
                                   gunichar c)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = !bird_font_glyph_range_unique (self, c, c);
	return result;
}

static gboolean
bird_font_glyph_range_unique (BirdFontGlyphRange* self,
                              gunichar start,
                              gunichar stop)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _u_list = NULL;
		GeeArrayList* _tmp0_;
		gint _u_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _u_index = 0;
		_tmp0_ = self->ranges;
		_u_list = _tmp0_;
		_tmp1_ = _u_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_u_size = _tmp3_;
		_u_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontUniRange* u = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontUniRange* _tmp8_;
			BirdFontUniRange* _tmp9_;
			BirdFontUniRange* _tmp10_;
			BirdFontUniRange* _tmp11_;
			BirdFontUniRange* _tmp12_;
			BirdFontUniRange* _tmp13_;
			_u_index = _u_index + 1;
			_tmp4_ = _u_index;
			_tmp5_ = _u_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _u_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _u_index);
			u = (BirdFontUniRange*) _tmp7_;
			_tmp8_ = u;
			_tmp9_ = u;
			if (bird_font_glyph_range_inside (start, _tmp8_->start, _tmp9_->stop)) {
				result = FALSE;
				_g_object_unref0 (u);
				return result;
			}
			_tmp10_ = u;
			_tmp11_ = u;
			if (bird_font_glyph_range_inside (stop, _tmp10_->start, _tmp11_->stop)) {
				result = FALSE;
				_g_object_unref0 (u);
				return result;
			}
			_tmp12_ = u;
			if (bird_font_glyph_range_inside (_tmp12_->start, start, stop)) {
				result = FALSE;
				_g_object_unref0 (u);
				return result;
			}
			_tmp13_ = u;
			if (bird_font_glyph_range_inside (_tmp13_->stop, start, stop)) {
				result = FALSE;
				_g_object_unref0 (u);
				return result;
			}
			_g_object_unref0 (u);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
bird_font_glyph_range_inside (gunichar start,
                              gunichar u_start,
                              gunichar u_stop)
{
	gunichar _tmp0_;
	gboolean result;
	_tmp0_ = start;
	result = (u_start <= _tmp0_) && (_tmp0_ <= u_stop);
	return result;
}

static BirdFontUniRange*
bird_font_glyph_range_insert_range (BirdFontGlyphRange* self,
                                    gunichar start,
                                    gunichar stop)
{
	BirdFontUniRange* ur = NULL;
	BirdFontUniRange* _tmp0_;
	GeeArrayList* _tmp1_;
	BirdFontUniRange* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (G_UNLIKELY (start > stop)) {
		g_warning ("GlyphRange.vala:580: start > stop");
		stop = start;
	}
	_tmp0_ = bird_font_uni_range_new (start, stop);
	ur = _tmp0_;
	self->priv->len = self->priv->len + bird_font_uni_range_length (ur);
	_tmp1_ = self->ranges;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, ur);
	result = ur;
	return result;
}

void
bird_font_glyph_range_print_all (BirdFontGlyphRange* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FILE* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Ranges:\n");
	_tmp1_ = stdout;
	_tmp2_ = bird_font_glyph_range_get_all_ranges (self);
	_tmp3_ = _tmp2_;
	fprintf (_tmp1_, "%s", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = stdout;
	fprintf (_tmp4_, "\n");
}

gchar*
bird_font_glyph_range_to_string (BirdFontGlyphRange* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_glyph_range_get_all_ranges (self);
	result = _tmp0_;
	return result;
}

const gchar*
bird_font_glyph_range_get_name (BirdFontGlyphRange* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
bird_font_glyph_range_set_name (BirdFontGlyphRange* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

static void
bird_font_value_glyph_range_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_glyph_range_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_glyph_range_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_glyph_range_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_glyph_range_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_glyph_range_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_glyph_range_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontGlyphRange * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_glyph_range_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_glyph_range_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	BirdFontGlyphRange ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_glyph_range_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_glyph_range (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	BirdFontParamSpecGlyphRange* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_GLYPH_RANGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_glyph_range (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_GLYPH_RANGE), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_glyph_range (GValue* value,
                                 gpointer v_object)
{
	BirdFontGlyphRange * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_GLYPH_RANGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_GLYPH_RANGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_glyph_range_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_glyph_range_unref (old);
	}
}

void
bird_font_value_take_glyph_range (GValue* value,
                                  gpointer v_object)
{
	BirdFontGlyphRange * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_GLYPH_RANGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_GLYPH_RANGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_glyph_range_unref (old);
	}
}

static void
bird_font_glyph_range_class_init (BirdFontGlyphRangeClass * klass,
                                  gpointer klass_data)
{
	bird_font_glyph_range_parent_class = g_type_class_peek_parent (klass);
	((BirdFontGlyphRangeClass *) klass)->finalize = bird_font_glyph_range_finalize;
	g_type_class_adjust_private_offset (klass, &BirdFontGlyphRange_private_offset);
}

static void
bird_font_glyph_range_instance_init (BirdFontGlyphRange * self,
                                     gpointer klass)
{
	self->priv = bird_font_glyph_range_get_instance_private (self);
	self->priv->len = (guint32) 0;
	self->priv->range_is_class = FALSE;
	self->priv->range_index = NULL;
	self->priv->index_size = 0;
	self->ref_count = 1;
}

static void
bird_font_glyph_range_finalize (BirdFontGlyphRange * obj)
{
	BirdFontGlyphRange * self;
	guint32* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_GLYPH_RANGE, BirdFontGlyphRange);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->range_index;
	if (_tmp0_ != NULL) {
		guint32* _tmp1_;
		_tmp1_ = self->priv->range_index;
		_g_free0 (_tmp1_);
	}
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->ranges);
	_g_object_unref0 (self->unassigned);
}

static GType
bird_font_glyph_range_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_glyph_range_init, bird_font_value_glyph_range_free_value, bird_font_value_glyph_range_copy_value, bird_font_value_glyph_range_peek_pointer, "p", bird_font_value_glyph_range_collect_value, "p", bird_font_value_glyph_range_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontGlyphRangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_glyph_range_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontGlyphRange), 0, (GInstanceInitFunc) bird_font_glyph_range_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_glyph_range_type_id;
	bird_font_glyph_range_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontGlyphRange", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BirdFontGlyphRange_private_offset = g_type_add_instance_private (bird_font_glyph_range_type_id, sizeof (BirdFontGlyphRangePrivate));
	return bird_font_glyph_range_type_id;
}

GType
bird_font_glyph_range_get_type (void)
{
	static volatile gsize bird_font_glyph_range_type_id__once = 0;
	if (g_once_init_enter (&bird_font_glyph_range_type_id__once)) {
		GType bird_font_glyph_range_type_id;
		bird_font_glyph_range_type_id = bird_font_glyph_range_get_type_once ();
		g_once_init_leave (&bird_font_glyph_range_type_id__once, bird_font_glyph_range_type_id);
	}
	return bird_font_glyph_range_type_id__once;
}

gpointer
bird_font_glyph_range_ref (gpointer instance)
{
	BirdFontGlyphRange * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_glyph_range_unref (gpointer instance)
{
	BirdFontGlyphRange * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_GLYPH_RANGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

