/* GlyphCollection.c generated by valac 0.56.16, the Vala compiler
 * generated from GlyphCollection.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_GLYPH_COLLECTION_0_PROPERTY,
	BIRD_FONT_GLYPH_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* bird_font_glyph_collection_properties[BIRD_FONT_GLYPH_COLLECTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _BirdFontGlyphCollectionPrivate {
	gunichar unicode_character;
	gchar* name;
	gboolean unassigned;
	gint current_master;
};

static gint BirdFontGlyphCollection_private_offset;
static gpointer bird_font_glyph_collection_parent_class = NULL;

static void bird_font_glyph_collection_finalize (GObject * obj);
static GType bird_font_glyph_collection_get_type_once (void);

static inline gpointer
bird_font_glyph_collection_get_instance_private (BirdFontGlyphCollection* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontGlyphCollection_private_offset);
}

BirdFontGlyphCollection*
bird_font_glyph_collection_construct (GType object_type,
                                      gunichar unicode_character,
                                      const gchar* name)
{
	BirdFontGlyphCollection * self = NULL;
	gchar* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (BirdFontGlyphCollection*) g_object_new (object_type, NULL);
	self->priv->unicode_character = unicode_character;
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_MASTER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->glyph_masters);
	self->glyph_masters = _tmp1_;
	self->priv->unassigned = FALSE;
	return self;
}

BirdFontGlyphCollection*
bird_font_glyph_collection_new (gunichar unicode_character,
                                const gchar* name)
{
	return bird_font_glyph_collection_construct (BIRD_FONT_TYPE_GLYPH_COLLECTION, unicode_character, name);
}

BirdFontGlyphCollection*
bird_font_glyph_collection_construct_with_glyph (GType object_type,
                                                 gunichar unicode_character,
                                                 const gchar* name)
{
	BirdFontGlyphCollection * self = NULL;
	BirdFontGlyph* g = NULL;
	BirdFontGlyphMaster* master = NULL;
	GeeArrayList* _tmp0_;
	BirdFontGlyphMaster* _tmp1_;
	GeeArrayList* _tmp2_;
	gchar* _tmp3_;
	BirdFontGlyph* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (BirdFontGlyphCollection*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_MASTER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->glyph_masters);
	self->glyph_masters = _tmp0_;
	_tmp1_ = bird_font_glyph_master_new ();
	_g_object_unref0 (master);
	master = _tmp1_;
	_tmp2_ = self->glyph_masters;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, master);
	self->priv->unassigned = FALSE;
	self->priv->unicode_character = unicode_character;
	_tmp3_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp3_;
	_tmp4_ = bird_font_glyph_new (name, unicode_character);
	_g_object_unref0 (g);
	g = _tmp4_;
	_tmp5_ = master->glyphs;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, g);
	bird_font_glyph_master_set_selected (master, g);
	_g_object_unref0 (master);
	_g_object_unref0 (g);
	return self;
}

BirdFontGlyphCollection*
bird_font_glyph_collection_new_with_glyph (gunichar unicode_character,
                                           const gchar* name)
{
	return bird_font_glyph_collection_construct_with_glyph (BIRD_FONT_TYPE_GLYPH_COLLECTION, unicode_character, name);
}

gboolean
bird_font_glyph_collection_has_masters (BirdFontGlyphCollection* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->glyph_masters;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

/** This method returns the current master, it has global state. */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

BirdFontGlyphMaster*
bird_font_glyph_collection_get_current_master (BirdFontGlyphCollection* self)
{
	gint i = 0;
	BirdFontGlyphMaster* m = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GeeArrayList* _tmp31_;
	gpointer _tmp32_;
	BirdFontGlyphMaster* result;
	g_return_val_if_fail (self != NULL, NULL);
	i = self->priv->current_master;
	_tmp0_ = self->glyph_masters;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (G_UNLIKELY (_tmp2_ == 0)) {
		BirdFontGlyphMaster* _tmp3_;
		BirdFontGlyphMaster* _tmp4_;
		g_warning ("GlyphCollection.vala:62: No master is set for glyph.");
		_tmp3_ = bird_font_glyph_master_new ();
		_g_object_unref0 (m);
		m = _tmp3_;
		_tmp4_ = m;
		bird_font_glyph_collection_add_master (self, _tmp4_);
		result = m;
		return result;
	} else {
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->glyph_masters;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (G_UNLIKELY (i >= _tmp7_)) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			GeeArrayList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_tmp8_ = g_strdup_printf ("%i", i);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->glyph_masters;
			_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup_printf ("%i", _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->name;
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = g_strconcat ("No master at index ", _tmp9_, ". (", _tmp14_, ") in ", _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			g_warning ("GlyphCollection.vala:67: %s", _tmp18_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp9_);
			_tmp19_ = self->glyph_masters;
			_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			i = _tmp21_ - 1;
		}
	}
	_tmp22_ = self->glyph_masters;
	_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = i;
	if (G_UNLIKELY (!((0 <= _tmp25_) && (_tmp25_ < _tmp24_)))) {
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		BirdFontGlyphMaster* _tmp30_;
		_tmp26_ = g_strdup_printf ("%i", i);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("index out of bounds ", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		g_warning ("GlyphCollection.vala:72: %s", _tmp29_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_tmp30_ = bird_font_glyph_master_new ();
		result = _tmp30_;
		_g_object_unref0 (m);
		return result;
	}
	_tmp31_ = self->glyph_masters;
	_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, i);
	result = (BirdFontGlyphMaster*) _tmp32_;
	_g_object_unref0 (m);
	return result;
}

gboolean
bird_font_glyph_collection_has_master (BirdFontGlyphCollection* self,
                                       const gchar* id)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	{
		GeeArrayList* _m_list = NULL;
		GeeArrayList* _tmp0_;
		gint _m_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _m_index = 0;
		_tmp0_ = self->glyph_masters;
		_m_list = _tmp0_;
		_tmp1_ = _m_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_m_size = _tmp3_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontGlyphMaster* m = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontGlyphMaster* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			_m_index = _m_index + 1;
			_tmp4_ = _m_index;
			_tmp5_ = _m_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _m_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _m_index);
			m = (BirdFontGlyphMaster*) _tmp7_;
			_tmp8_ = m;
			_tmp9_ = bird_font_glyph_master_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, id) == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				result = TRUE;
				_g_object_unref0 (m);
				return result;
			}
			_g_object_unref0 (m);
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontGlyphMaster*
bird_font_glyph_collection_get_master (BirdFontGlyphCollection* self,
                                       const gchar* id)
{
	BirdFontGlyphMaster* found = NULL;
	BirdFontGlyphMaster* _tmp14_;
	BirdFontGlyphMaster* _tmp16_;
	BirdFontGlyphMaster* _tmp17_;
	BirdFontGlyphMaster* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	found = NULL;
	{
		GeeArrayList* _m_list = NULL;
		GeeArrayList* _tmp0_;
		gint _m_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _m_index = 0;
		_tmp0_ = self->glyph_masters;
		_m_list = _tmp0_;
		_tmp1_ = _m_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_m_size = _tmp3_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontGlyphMaster* m = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontGlyphMaster* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			_m_index = _m_index + 1;
			_tmp4_ = _m_index;
			_tmp5_ = _m_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _m_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _m_index);
			m = (BirdFontGlyphMaster*) _tmp7_;
			_tmp8_ = m;
			_tmp9_ = bird_font_glyph_master_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, id) == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				BirdFontGlyphMaster* _tmp12_;
				BirdFontGlyphMaster* _tmp13_;
				_tmp12_ = m;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_g_object_unref0 (found);
				found = _tmp13_;
			}
			_g_object_unref0 (m);
		}
	}
	_tmp14_ = found;
	if (G_UNLIKELY (_tmp14_ == NULL)) {
		BirdFontGlyphMaster* _tmp15_;
		g_warning ("GlyphCollection.vala:99: Master not found for id $(id).");
		_tmp15_ = bird_font_glyph_master_new ();
		result = _tmp15_;
		_g_object_unref0 (found);
		return result;
	}
	_tmp16_ = found;
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, BIRD_FONT_TYPE_GLYPH_MASTER, BirdFontGlyphMaster));
	result = _tmp17_;
	_g_object_unref0 (found);
	return result;
}

gboolean
bird_font_glyph_collection_is_multimaster (BirdFontGlyphCollection* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->glyph_masters;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 1;
	return result;
}

void
bird_font_glyph_collection_remove (BirdFontGlyphCollection* self,
                                   gint index)
{
	BirdFontGlyphMaster* _tmp0_;
	BirdFontGlyphMaster* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_glyph_collection_get_current_master (self);
	_tmp1_ = _tmp0_;
	bird_font_glyph_master_remove (_tmp1_, index);
	_g_object_unref0 (_tmp1_);
}

void
bird_font_glyph_collection_set_selected (BirdFontGlyphCollection* self,
                                         BirdFontGlyph* g)
{
	BirdFontGlyphMaster* _tmp0_;
	BirdFontGlyphMaster* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = bird_font_glyph_collection_get_current_master (self);
	_tmp1_ = _tmp0_;
	bird_font_glyph_master_set_selected (_tmp1_, g);
	_g_object_unref0 (_tmp1_);
}

void
bird_font_glyph_collection_set_unassigned (BirdFontGlyphCollection* self,
                                           gboolean a)
{
	g_return_if_fail (self != NULL);
	self->priv->unassigned = a;
}

gboolean
bird_font_glyph_collection_is_unassigned (BirdFontGlyphCollection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->unassigned;
	return result;
}

void
bird_font_glyph_collection_add_master (BirdFontGlyphCollection* self,
                                       BirdFontGlyphMaster* master)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (master != NULL);
	_tmp0_ = self->glyph_masters;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, master);
}

void
bird_font_glyph_collection_set_selected_master (BirdFontGlyphCollection* self,
                                                BirdFontGlyphMaster* m)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = self->glyph_masters;
	self->priv->current_master = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, m);
	if (G_UNLIKELY (self->priv->current_master == -1)) {
		g_warning ("GlyphCollection.vala:134: Master does not exits");
		self->priv->current_master = 0;
	}
}

BirdFontGlyph*
bird_font_glyph_collection_get_current (BirdFontGlyphCollection* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyphMaster* _tmp0_;
	BirdFontGlyphMaster* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontGlyph* _tmp3_;
	BirdFontGlyph* _tmp4_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	BirdFontGlyph* _tmp11_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_glyph_collection_get_current_master (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_glyph_master_get_current (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	g = _tmp3_;
	_tmp4_ = g;
	if (G_LIKELY (_tmp4_ != NULL)) {
		BirdFontGlyph* _tmp5_;
		BirdFontGlyph* _tmp6_;
		_tmp5_ = g;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
		result = _tmp6_;
		_g_object_unref0 (g);
		return result;
	}
	_tmp7_ = self->priv->name;
	_tmp8_ = string_to_string (_tmp7_);
	_tmp9_ = g_strconcat ("No glyph selected for ", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	g_warning ("GlyphCollection.vala:146: %s", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = bird_font_glyph_new ("", (gunichar) '\0');
	result = _tmp11_;
	_g_object_unref0 (g);
	return result;
}

BirdFontGlyph*
bird_font_glyph_collection_get_interpolated (BirdFontGlyphCollection* self,
                                             gdouble weight)
{
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontGlyph* _tmp8_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (weight == ((gdouble) 0)) {
		BirdFontGlyph* _tmp0_;
		_tmp0_ = bird_font_glyph_collection_get_current (self);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->glyph_masters;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 1) {
		BirdFontGlyph* _tmp4_;
		BirdFontGlyph* _tmp5_;
		BirdFontGlyph* _tmp6_;
		BirdFontGlyph* _tmp7_;
		_tmp4_ = bird_font_glyph_collection_get_current (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = bird_font_glyph_self_interpolate (_tmp5_, weight);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		result = _tmp7_;
		return result;
	} else {
		g_warning ("GlyphCollection.vala:158: Not implemented.");
	}
	_tmp8_ = bird_font_glyph_collection_get_current (self);
	result = _tmp8_;
	return result;
}

BirdFontGlyph*
bird_font_glyph_collection_get_interpolated_fast (BirdFontGlyphCollection* self,
                                                  gdouble weight)
{
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontGlyph* _tmp5_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (weight == ((gdouble) 0)) {
		BirdFontGlyph* _tmp0_;
		_tmp0_ = bird_font_glyph_collection_get_current (self);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->glyph_masters;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 1) {
		BirdFontGlyph* _tmp4_;
		_tmp4_ = bird_font_glyph_collection_get_current (self);
		result = _tmp4_;
		return result;
	} else {
		g_warning ("GlyphCollection.vala:173: Not implemented.");
	}
	_tmp5_ = bird_font_glyph_collection_get_current (self);
	result = _tmp5_;
	return result;
}

void
bird_font_glyph_collection_insert_glyph (BirdFontGlyphCollection* self,
                                         BirdFontGlyph* g,
                                         gboolean selected_glyph)
{
	BirdFontGlyphMaster* _tmp0_;
	BirdFontGlyphMaster* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = bird_font_glyph_collection_get_current_master (self);
	_tmp1_ = _tmp0_;
	bird_font_glyph_master_insert_glyph (_tmp1_, g, selected_glyph);
	_g_object_unref0 (_tmp1_);
}

guint
bird_font_glyph_collection_length (BirdFontGlyphCollection* self)
{
	BirdFontGlyphMaster* _tmp0_;
	BirdFontGlyphMaster* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	guint _tmp5_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	if (!bird_font_glyph_collection_has_masters (self)) {
		result = (guint) 0;
		return result;
	}
	_tmp0_ = bird_font_glyph_collection_get_current_master (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->glyphs;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = (guint) _tmp4_;
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar*
bird_font_glyph_collection_get_unicode (BirdFontGlyphCollection* self)
{
	GString* unicode = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	unicode = _tmp0_;
	g_string_append_unichar (unicode, self->priv->unicode_character);
	_tmp1_ = unicode->str;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	_g_string_free0 (unicode);
	return result;
}

void
bird_font_glyph_collection_set_unicode_character (BirdFontGlyphCollection* self,
                                                  gunichar c)
{
	g_return_if_fail (self != NULL);
	self->priv->unicode_character = c;
}

gunichar
bird_font_glyph_collection_get_unicode_character (BirdFontGlyphCollection* self)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->unicode_character;
	return result;
}

gchar*
bird_font_glyph_collection_get_name (BirdFontGlyphCollection* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
bird_font_glyph_collection_set_name (BirdFontGlyphCollection* self,
                                     const gchar* n)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = g_strdup (n);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
}

/** Create a copy of this list. This method will copy the list data but 
 * keep pointers to the original glyphs.
 * @return a new list with copies of pointers to the glyphs
 */
BirdFontGlyphCollection*
bird_font_glyph_collection_copy (BirdFontGlyphCollection* self)
{
	BirdFontGlyphCollection* n = NULL;
	const gchar* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyphCollection* _tmp15_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = bird_font_glyph_collection_new (self->priv->unicode_character, _tmp0_);
	n = _tmp1_;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp2_;
		gint _g_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _g_index = 0;
		_tmp2_ = self->glyph_masters;
		_g_list = _tmp2_;
		_tmp3_ = _g_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_size = _tmp5_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontGlyphMaster* g = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontGlyphCollection* _tmp10_;
			GeeArrayList* _tmp11_;
			BirdFontGlyphMaster* _tmp12_;
			BirdFontGlyphMaster* _tmp13_;
			BirdFontGlyphMaster* _tmp14_;
			_g_index = _g_index + 1;
			_tmp6_ = _g_index;
			_tmp7_ = _g_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _g_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _g_index);
			g = (BirdFontGlyphMaster*) _tmp9_;
			_tmp10_ = n;
			_tmp11_ = _tmp10_->glyph_masters;
			_tmp12_ = g;
			_tmp13_ = bird_font_glyph_master_copy (_tmp12_);
			_tmp14_ = _tmp13_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp14_);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (g);
		}
	}
	_tmp15_ = n;
	_tmp15_->priv->unassigned = self->priv->unassigned;
	result = n;
	return result;
}

BirdFontGlyphCollection*
bird_font_glyph_collection_copy_deep (BirdFontGlyphCollection* self)
{
	BirdFontGlyphCollection* n = NULL;
	const gchar* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyphCollection* _tmp15_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = bird_font_glyph_collection_new (self->priv->unicode_character, _tmp0_);
	n = _tmp1_;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp2_;
		gint _g_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _g_index = 0;
		_tmp2_ = self->glyph_masters;
		_g_list = _tmp2_;
		_tmp3_ = _g_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_size = _tmp5_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontGlyphMaster* g = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontGlyphCollection* _tmp10_;
			GeeArrayList* _tmp11_;
			BirdFontGlyphMaster* _tmp12_;
			BirdFontGlyphMaster* _tmp13_;
			BirdFontGlyphMaster* _tmp14_;
			_g_index = _g_index + 1;
			_tmp6_ = _g_index;
			_tmp7_ = _g_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _g_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _g_index);
			g = (BirdFontGlyphMaster*) _tmp9_;
			_tmp10_ = n;
			_tmp11_ = _tmp10_->glyph_masters;
			_tmp12_ = g;
			_tmp13_ = bird_font_glyph_master_copy_deep (_tmp12_);
			_tmp14_ = _tmp13_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp14_);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (g);
		}
	}
	_tmp15_ = n;
	_tmp15_->priv->unassigned = self->priv->unassigned;
	result = n;
	return result;
}

gint
bird_font_glyph_collection_get_last_id (BirdFontGlyphCollection* self)
{
	BirdFontGlyphMaster* _tmp0_;
	BirdFontGlyphMaster* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = bird_font_glyph_collection_get_current_master (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_glyph_master_get_last_id (_tmp1_);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/** @return all versions of all masters */
GeeArrayList*
bird_font_glyph_collection_get_all_glyph_masters (BirdFontGlyphCollection* self)
{
	GeeArrayList* glyphs = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	glyphs = _tmp0_;
	{
		GeeArrayList* _master_list = NULL;
		GeeArrayList* _tmp1_;
		gint _master_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _master_index = 0;
		_tmp1_ = self->glyph_masters;
		_master_list = _tmp1_;
		_tmp2_ = _master_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_master_size = _tmp4_;
		_master_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontGlyphMaster* master = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			_master_index = _master_index + 1;
			_tmp5_ = _master_index;
			_tmp6_ = _master_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _master_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _master_index);
			master = (BirdFontGlyphMaster*) _tmp8_;
			{
				GeeArrayList* _g_list = NULL;
				BirdFontGlyphMaster* _tmp9_;
				GeeArrayList* _tmp10_;
				gint _g_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _g_index = 0;
				_tmp9_ = master;
				_tmp10_ = _tmp9_->glyphs;
				_g_list = _tmp10_;
				_tmp11_ = _g_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_g_size = _tmp13_;
				_g_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					BirdFontGlyph* g = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					GeeArrayList* _tmp18_;
					BirdFontGlyph* _tmp19_;
					_g_index = _g_index + 1;
					_tmp14_ = _g_index;
					_tmp15_ = _g_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _g_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _g_index);
					g = (BirdFontGlyph*) _tmp17_;
					_tmp18_ = glyphs;
					_tmp19_ = g;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
					_g_object_unref0 (g);
				}
			}
			_g_object_unref0 (master);
		}
	}
	result = glyphs;
	return result;
}

static void
bird_font_glyph_collection_class_init (BirdFontGlyphCollectionClass * klass,
                                       gpointer klass_data)
{
	bird_font_glyph_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontGlyphCollection_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_glyph_collection_finalize;
}

static void
bird_font_glyph_collection_instance_init (BirdFontGlyphCollection * self,
                                          gpointer klass)
{
	self->priv = bird_font_glyph_collection_get_instance_private (self);
	self->priv->current_master = 0;
}

static void
bird_font_glyph_collection_finalize (GObject * obj)
{
	BirdFontGlyphCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection);
	_g_free0 (self->priv->name);
	_g_object_unref0 (self->glyph_masters);
	G_OBJECT_CLASS (bird_font_glyph_collection_parent_class)->finalize (obj);
}

static GType
bird_font_glyph_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontGlyphCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_glyph_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontGlyphCollection), 0, (GInstanceInitFunc) bird_font_glyph_collection_instance_init, NULL };
	GType bird_font_glyph_collection_type_id;
	bird_font_glyph_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontGlyphCollection", &g_define_type_info, 0);
	BirdFontGlyphCollection_private_offset = g_type_add_instance_private (bird_font_glyph_collection_type_id, sizeof (BirdFontGlyphCollectionPrivate));
	return bird_font_glyph_collection_type_id;
}

GType
bird_font_glyph_collection_get_type (void)
{
	static volatile gsize bird_font_glyph_collection_type_id__once = 0;
	if (g_once_init_enter (&bird_font_glyph_collection_type_id__once)) {
		GType bird_font_glyph_collection_type_id;
		bird_font_glyph_collection_type_id = bird_font_glyph_collection_get_type_once ();
		g_once_init_leave (&bird_font_glyph_collection_type_id__once, bird_font_glyph_collection_type_id);
	}
	return bird_font_glyph_collection_type_id__once;
}

