/* Glyph.c generated by valac 0.56.16, the Vala compiler
 * generated from Glyph.vala, do not modify */

/*
Copyright (C) 2012 - 2016 Johan Mattsson

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 3 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_TYPE_ZOOM_VIEW (bird_font_zoom_view_get_type ())
#define BIRD_FONT_ZOOM_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_ZOOM_VIEW, BirdFontZoomView))
#define BIRD_FONT_ZOOM_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_ZOOM_VIEW, BirdFontZoomViewClass))
#define BIRD_FONT_IS_ZOOM_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_ZOOM_VIEW))
#define BIRD_FONT_IS_ZOOM_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_ZOOM_VIEW))
#define BIRD_FONT_ZOOM_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_ZOOM_VIEW, BirdFontZoomViewClass))

typedef struct _BirdFontZoomView BirdFontZoomView;
typedef struct _BirdFontZoomViewClass BirdFontZoomViewClass;
enum  {
	BIRD_FONT_GLYPH_0_PROPERTY,
	BIRD_FONT_GLYPH_LEFT_LIMIT_PROPERTY,
	BIRD_FONT_GLYPH_RIGHT_LIMIT_PROPERTY,
	BIRD_FONT_GLYPH_NUM_PROPERTIES
};
static GParamSpec* bird_font_glyph_properties[BIRD_FONT_GLYPH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _bird_font_point_converter_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_point_converter_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _Block17Data Block17Data;
typedef struct _BirdFontZoomViewPrivate BirdFontZoomViewPrivate;
#define _bird_font_color_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_color_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block18Data Block18Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontGlyphPrivate {
	BirdFontBackgroundImage* background_image;
	gboolean background_image_visible;
	GeeArrayList* zoom_list;
	gint zoom_list_index;
	gdouble pointer_begin_x;
	gdouble pointer_begin_y;
	gint last_tap0_y;
	gint last_tap0_x;
	gint last_tap1_y;
	gint last_tap1_x;
	gdouble zoom_distance;
	gboolean change_view;
	gboolean ignore_input;
	gboolean view_is_moving;
	gboolean move_canvas;
	gdouble _right_limit;
	gdouble _left_limit;
	gboolean xheight_lines_visible;
	gboolean margin_boundaries_visible;
	gchar* new_guide_name;
	GeeArrayList* undo_list;
	GeeArrayList* redo_list;
	gchar* glyph_sequence;
	gboolean open;
	gboolean empty;
	BirdFontGlyfData* ttf_data;
	BirdFontLine* left_line;
	BirdFontLine* right_line;
	GeeHashMap* glyph_cache;
};

struct _Block17Data {
	int _ref_count_;
	BirdFontGlyph* self;
	gdouble max_x2;
	gdouble max_y2;
	gdouble min_x2;
	gdouble min_y2;
};

struct _BirdFontZoomView {
	GObject parent_instance;
	BirdFontZoomViewPrivate * priv;
	gdouble x;
	gdouble y;
	gdouble zoom;
	BirdFontWidgetAllocation* allocation;
};

struct _BirdFontZoomViewClass {
	GObjectClass parent_class;
};

struct _Block18Data {
	int _ref_count_;
	BirdFontGlyph* self;
	gint x;
	gint y;
};

static gint BirdFontGlyph_private_offset;
static gpointer bird_font_glyph_parent_class = NULL;
BirdFontGlyph* bird_font_glyph_background_glyph = NULL;
gboolean bird_font_glyph_show_orientation_arrow = FALSE;
gdouble bird_font_glyph_orientation_arrow_opacity = (gdouble) 1;

VALA_EXTERN GType bird_font_zoom_view_get_type (void) G_GNUC_CONST ;
static void bird_font_glyph_real_close (BirdFontFontDisplay* base);
static void bird_font_glyph_real_scroll_wheel (BirdFontFontDisplay* base,
                                        gdouble x,
                                        gdouble y,
                                        gdouble pixeldelta_x,
                                        gdouble pixeldelta_y);
static void bird_font_glyph_zoom_in_at_point (BirdFontGlyph* self,
                                       gdouble x,
                                       gdouble y,
                                       gdouble amount);
static void bird_font_glyph_zoom_out_at_point (BirdFontGlyph* self,
                                        gdouble x,
                                        gdouble y,
                                        gdouble amount);
static void bird_font_glyph_real_add_path (BirdFontGlyph* self,
                                    BirdFontPath* p);
static void bird_font_glyph_real_selected_canvas (BirdFontFontDisplay* base);
static gboolean __lambda168_ (BirdFontGlyph* self);
static gboolean ___lambda168__gsource_func (gpointer self);
static void bird_font_glyph_update_zoom_bar (BirdFontGlyph* self);
static void __lambda71_ (BirdFontGlyph* self,
                  gdouble pos);
static void ___lambda71__bird_font_line_position_updated (BirdFontLine* _sender,
                                                   gdouble pos,
                                                   gpointer self);
static void __lambda72_ (BirdFontGlyph* self,
                  gdouble pos);
static void ___lambda72__bird_font_line_position_updated (BirdFontLine* _sender,
                                                   gdouble pos,
                                                   gpointer self);
static void __lambda73_ (BirdFontGlyph* self,
                  gdouble pos);
static void ___lambda73__bird_font_line_position_updated (BirdFontLine* _sender,
                                                   gdouble pos,
                                                   gpointer self);
static void __lambda74_ (BirdFontGlyph* self,
                  gdouble pos);
static void ___lambda74__bird_font_line_position_updated (BirdFontLine* _sender,
                                                   gdouble pos,
                                                   gpointer self);
static void __lambda346_ (BirdFontGlyph* self,
                   gdouble pos);
static void ___lambda346__bird_font_line_position_updated (BirdFontLine* _sender,
                                                    gdouble pos,
                                                    gpointer self);
static void __lambda347_ (BirdFontGlyph* self,
                   gdouble pos);
static void ___lambda347__bird_font_line_position_updated (BirdFontLine* _sender,
                                                    gdouble pos,
                                                    gpointer self);
static void __lambda348_ (BirdFontGlyph* self,
                   gdouble pos);
static void ___lambda348__bird_font_line_position_updated (BirdFontLine* _sender,
                                                    gdouble pos,
                                                    gpointer self);
static void __lambda349_ (BirdFontGlyph* self,
                   gdouble pos);
static void ___lambda349__bird_font_line_position_updated (BirdFontLine* _sender,
                                                    gdouble pos,
                                                    gpointer self);
static void bird_font_glyph_add_line (BirdFontGlyph* self,
                               BirdFontLine* line);
static gboolean bird_font_glyph_has_top_line (BirdFontGlyph* self);
static void bird_font_glyph_boundaries_for_path (BirdFontGlyph* self,
                                          BirdFontPath* p,
                                          gdouble* min_x,
                                          gdouble* max_x,
                                          gdouble* min_y,
                                          gdouble* max_y);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gboolean __lambda38_ (Block17Data* _data17_,
                      gdouble x,
                      gdouble y,
                      gdouble t);
static gboolean ___lambda38__bird_font_path_raster_iterator (gdouble x,
                                                      gdouble y,
                                                      gdouble step,
                                                      gpointer self);
static void __lambda179_ (BirdFontGlyph* self,
                   gint x,
                   gint y,
                   gint w,
                   gint h);
static void ___lambda179__bird_font_line_queue_draw_area (BirdFontLine* _sender,
                                                   gint x,
                                                   gint y,
                                                   gint w,
                                                   gint h,
                                                   gpointer self);
static gint __lambda177_ (BirdFontGlyph* self,
                   BirdFontLine* a,
                   BirdFontLine* b);
static gint ___lambda177__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static gint __lambda178_ (BirdFontGlyph* self,
                   BirdFontLine* a,
                   BirdFontLine* b);
static gint ___lambda178__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static gchar* bird_font_glyph_real_get_name (BirdFontFontDisplay* base);
static gchar* bird_font_glyph_real_get_label (BirdFontFontDisplay* base);
static void bird_font_glyph_help_line_event (BirdFontGlyph* self,
                                      gint x,
                                      gint y);
static void bird_font_glyph_real_key_release (BirdFontFontDisplay* base,
                                       guint keyval);
static void bird_font_glyph_real_key_press (BirdFontFontDisplay* base,
                                     guint keyval);
static gboolean bird_font_glyph_process_deleted_points_in_path (BirdFontGlyph* self,
                                                         BirdFontPath* p);
static void bird_font_glyph_real_motion_notify (BirdFontFontDisplay* base,
                                         gdouble x,
                                         gdouble y);
static void bird_font_glyph_move_view_offset (BirdFontGlyph* self,
                                       gdouble x,
                                       gdouble y);
static void bird_font_glyph_real_button_release (BirdFontFontDisplay* base,
                                          gint button,
                                          gdouble ex,
                                          gdouble ey);
static GeeArrayList* bird_font_glyph_get_all_help_lines (BirdFontGlyph* self);
static void bird_font_glyph_real_double_click (BirdFontFontDisplay* base,
                                        guint button,
                                        gdouble ex,
                                        gdouble ey);
static void bird_font_glyph_real_button_press (BirdFontFontDisplay* base,
                                        guint button,
                                        gdouble ex,
                                        gdouble ey);
static void bird_font_glyph_redraw_path (BirdFontGlyph* self,
                                  gdouble xmin,
                                  gdouble ymin,
                                  gdouble xmax,
                                  gdouble ymax);
static void bird_font_glyph_redraw_last_stroke (BirdFontGlyph* self,
                                         gdouble x,
                                         gdouble y);
static void bird_font_glyph_real_zoom_in (BirdFontFontDisplay* base);
static void bird_font_glyph_real_zoom_out (BirdFontFontDisplay* base);
static void bird_font_glyph_real_zoom_max (BirdFontFontDisplay* base);
static void bird_font_glyph_real_zoom_min (BirdFontFontDisplay* base);
static void bird_font_glyph_real_store_current_view (BirdFontFontDisplay* base);
VALA_EXTERN BirdFontZoomView* bird_font_zoom_view_new (gdouble x,
                                           gdouble y,
                                           gdouble zoom,
                                           BirdFontWidgetAllocation* allocation);
VALA_EXTERN BirdFontZoomView* bird_font_zoom_view_construct (GType object_type,
                                                 gdouble x,
                                                 gdouble y,
                                                 gdouble zoom,
                                                 BirdFontWidgetAllocation* allocation);
static void bird_font_glyph_real_restore_last_view (BirdFontFontDisplay* base);
static void bird_font_glyph_real_next_view (BirdFontFontDisplay* base);
static void bird_font_glyph_real_reset_zoom (BirdFontFontDisplay* base);
static BirdFontColor* bird_font_glyph_get_path_fill_color (BirdFontGlyph* self);
static void bird_font_glyph_real_draw (BirdFontFontDisplay* base,
                                BirdFontWidgetAllocation* allocation,
                                cairo_t* cmp);
static void bird_font_glyph_draw_background_glyph (BirdFontGlyph* self,
                                            BirdFontWidgetAllocation* allocation,
                                            cairo_t* cr);
static void bird_font_glyph_zoom_at_point (BirdFontGlyph* self,
                                    gdouble x,
                                    gdouble y,
                                    gint n);
static void bird_font_glyph_set_glyph_data (BirdFontGlyph* self,
                                     BirdFontGlyph* g);
static void bird_font_glyph_real_undo (BirdFontFontDisplay* base);
static void bird_font_glyph_real_redo (BirdFontFontDisplay* base);
static gboolean bird_font_glyph_in_range (gdouble offset_x,
                                   gdouble coordinate_x1,
                                   gdouble coordinate_x2);
static void bird_font_glyph_real_move_view (BirdFontFontDisplay* base,
                                     gdouble x,
                                     gdouble y);
static void bird_font_glyph_real_tap_down (BirdFontFontDisplay* base,
                                    gint finger,
                                    gint x,
                                    gint y);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static gboolean ___lambda176_ (Block18Data* _data18_);
static gboolean ____lambda176__gsource_func (gpointer self);
static void bird_font_glyph_real_tap_up (BirdFontFontDisplay* base,
                                  gint finger,
                                  gint x,
                                  gint y);
static void bird_font_glyph_real_tap_move (BirdFontFontDisplay* base,
                                    gint finger,
                                    gint x,
                                    gint y);
static void __lambda545_ (BirdFontGlyph* self,
                   const gchar* text);
static void ___lambda545__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda546_ (BirdFontGlyph* self);
static void ___lambda546__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static void bird_font_glyph_real_magnify (BirdFontFontDisplay* base,
                                   gdouble magnification);
static void bird_font_glyph_finalize (GObject * obj);
static GType bird_font_glyph_get_type_once (void);
static void _vala_bird_font_glyph_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_bird_font_glyph_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
bird_font_glyph_get_instance_private (BirdFontGlyph* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontGlyph_private_offset);
}

BirdFontGlyph*
bird_font_glyph_construct (GType object_type,
                           const gchar* name,
                           gunichar unichar_code)
{
	BirdFontGlyph * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (BirdFontGlyph*) bird_font_font_display_construct (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	self->unichar_code = unichar_code;
	bird_font_glyph_add_help_lines (self);
	bird_font_glyph_set_left_limit (self, (gdouble) -28);
	bird_font_glyph_set_right_limit (self, (gdouble) 28);
	return self;
}

BirdFontGlyph*
bird_font_glyph_new (const gchar* name,
                     gunichar unichar_code)
{
	return bird_font_glyph_construct (BIRD_FONT_TYPE_GLYPH, name, unichar_code);
}

BirdFontGlyph*
bird_font_glyph_construct_no_lines (GType object_type,
                                    const gchar* name,
                                    gunichar unichar_code)
{
	BirdFontGlyph * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (BirdFontGlyph*) bird_font_font_display_construct (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	self->unichar_code = unichar_code;
	return self;
}

BirdFontGlyph*
bird_font_glyph_new_no_lines (const gchar* name,
                              gunichar unichar_code)
{
	return bird_font_glyph_construct_no_lines (BIRD_FONT_TYPE_GLYPH, name, unichar_code);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeArrayList*
bird_font_glyph_get_active_paths (BirdFontGlyph* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->active_paths;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

BirdFontLayer*
bird_font_glyph_get_current_layer (BirdFontGlyph* self)
{
	BirdFontLayer* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	BirdFontLayer* _tmp5_;
	BirdFontLayer* _tmp6_;
	BirdFontLayer* _tmp7_;
	GeeArrayList* _tmp8_;
	gpointer _tmp9_;
	BirdFontLayer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->layers;
	_tmp1_ = _tmp0_->subgroups;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->current_layer;
	_tmp5_ = bird_font_layer_new ();
	_tmp6_ = _tmp5_;
	g_return_val_if_fail ((0 <= _tmp4_) && (_tmp4_ < _tmp3_), _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->layers;
	_tmp8_ = _tmp7_->subgroups;
	_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, self->current_layer);
	result = (BirdFontLayer*) _tmp9_;
	return result;
}

void
bird_font_glyph_set_current_layer (BirdFontGlyph* self,
                                   BirdFontLayer* layer)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layer != NULL);
	i = 0;
	{
		GeeArrayList* _l_list = NULL;
		BirdFontLayer* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _l_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _l_index = 0;
		_tmp0_ = self->layers;
		_tmp1_ = _tmp0_->subgroups;
		_l_list = _tmp1_;
		_tmp2_ = _l_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_l_size = _tmp4_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontLayer* l = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontLayer* _tmp9_;
			gint _tmp10_;
			_l_index = _l_index + 1;
			_tmp5_ = _l_index;
			_tmp6_ = _l_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _l_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _l_index);
			l = (BirdFontLayer*) _tmp8_;
			_tmp9_ = l;
			if (G_LIKELY (_tmp9_ == layer)) {
				self->current_layer = i;
				_g_object_unref0 (l);
				return;
			}
			_tmp10_ = i;
			i = _tmp10_ + 1;
			_g_object_unref0 (l);
		}
	}
	g_warning ("Glyph.vala:178: Layer is not added to glyph.");
}

GeeArrayList*
bird_font_glyph_get_visible_paths (BirdFontGlyph* self)
{
	BirdFontLayer* _tmp0_;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->layers;
	_tmp1_ = bird_font_layer_get_visible_paths (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->paths;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}

BirdFontPathList*
bird_font_glyph_get_visible_path_list (BirdFontGlyph* self)
{
	BirdFontLayer* _tmp0_;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->layers;
	_tmp1_ = bird_font_layer_get_visible_paths (_tmp0_);
	result = _tmp1_;
	return result;
}

GeeArrayList*
bird_font_glyph_get_paths_in_current_layer (BirdFontGlyph* self)
{
	BirdFontLayer* _tmp0_;
	BirdFontLayer* _tmp1_;
	BirdFontPathList* _tmp2_;
	BirdFontPathList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_glyph_get_current_layer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_layer_get_all_paths (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->paths;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp6_;
	return result;
}

GeeArrayList*
bird_font_glyph_get_all_paths (BirdFontGlyph* self)
{
	BirdFontLayer* _tmp0_;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->layers;
	_tmp1_ = bird_font_layer_get_all_paths (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->paths;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}

void
bird_font_glyph_add_new_layer (BirdFontGlyph* self)
{
	BirdFontLayer* _tmp0_;
	BirdFontLayer* _tmp1_;
	BirdFontLayer* _tmp2_;
	BirdFontLayer* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->layers;
	_tmp1_ = bird_font_layer_new ();
	_tmp2_ = _tmp1_;
	bird_font_layer_add_layer (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->layers;
	_tmp4_ = _tmp3_->subgroups;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	self->current_layer = _tmp6_ - 1;
}

gint
bird_font_glyph_get_layer_index (BirdFontGlyph* self,
                                 BirdFontLayer* layer)
{
	BirdFontLayer* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (layer != NULL, 0);
	_tmp0_ = self->layers;
	result = bird_font_layer_index_of (_tmp0_, layer);
	return result;
}

BirdFontGlyfData*
bird_font_glyph_get_ttf_data (BirdFontGlyph* self)
{
	BirdFontGlyfData* _tmp0_;
	BirdFontGlyfData* _tmp2_;
	BirdFontGlyfData* _tmp3_;
	BirdFontGlyfData* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ttf_data;
	if (_tmp0_ == NULL) {
		BirdFontGlyfData* _tmp1_;
		_tmp1_ = bird_font_glyf_data_new (self);
		_g_object_unref0 (self->priv->ttf_data);
		self->priv->ttf_data = _tmp1_;
	}
	_tmp2_ = self->priv->ttf_data;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYF_DATA, BirdFontGlyfData));
	result = _tmp3_;
	return result;
}

BirdFontPathList*
bird_font_glyph_get_quadratic_paths (BirdFontGlyph* self)
{
	BirdFontPointConverter* pc = NULL;
	BirdFontPathList* pl = NULL;
	BirdFontPathList* stroke = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_list_new ();
	_g_object_unref0 (pl);
	pl = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = bird_font_glyph_get_visible_paths (self);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPath* _tmp9_;
			gdouble _tmp10_;
			gdouble _tmp11_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = bird_font_path_get_stroke (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ > ((gdouble) 0)) {
				BirdFontPath* _tmp12_;
				BirdFontPathList* _tmp13_;
				_tmp12_ = p;
				_tmp13_ = bird_font_path_get_completed_stroke (_tmp12_);
				_g_object_unref0 (stroke);
				stroke = _tmp13_;
				{
					GeeArrayList* _stroke_part_list = NULL;
					BirdFontPathList* _tmp14_;
					GeeArrayList* _tmp15_;
					gint _stroke_part_size = 0;
					GeeArrayList* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					gint _stroke_part_index = 0;
					_tmp14_ = stroke;
					_tmp15_ = _tmp14_->paths;
					_stroke_part_list = _tmp15_;
					_tmp16_ = _stroke_part_list;
					_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
					_tmp18_ = _tmp17_;
					_stroke_part_size = _tmp18_;
					_stroke_part_index = -1;
					while (TRUE) {
						gint _tmp19_;
						gint _tmp20_;
						BirdFontPath* stroke_part = NULL;
						GeeArrayList* _tmp21_;
						gpointer _tmp22_;
						BirdFontPath* _tmp23_;
						BirdFontPointConverter* _tmp24_;
						BirdFontPathList* _tmp25_;
						BirdFontPointConverter* _tmp26_;
						BirdFontPath* _tmp27_;
						BirdFontPath* _tmp28_;
						_stroke_part_index = _stroke_part_index + 1;
						_tmp19_ = _stroke_part_index;
						_tmp20_ = _stroke_part_size;
						if (!(_tmp19_ < _tmp20_)) {
							break;
						}
						_tmp21_ = _stroke_part_list;
						_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _stroke_part_index);
						stroke_part = (BirdFontPath*) _tmp22_;
						_tmp23_ = stroke_part;
						_tmp24_ = bird_font_point_converter_new (_tmp23_);
						_bird_font_point_converter_unref0 (pc);
						pc = _tmp24_;
						_tmp25_ = pl;
						_tmp26_ = pc;
						_tmp27_ = bird_font_point_converter_get_quadratic_path (_tmp26_);
						_tmp28_ = _tmp27_;
						bird_font_path_list_add (_tmp25_, _tmp28_);
						_g_object_unref0 (_tmp28_);
						_g_object_unref0 (stroke_part);
					}
				}
			} else {
				BirdFontPath* _tmp29_;
				BirdFontPointConverter* _tmp30_;
				BirdFontPathList* _tmp31_;
				BirdFontPointConverter* _tmp32_;
				BirdFontPath* _tmp33_;
				BirdFontPath* _tmp34_;
				_tmp29_ = p;
				_tmp30_ = bird_font_point_converter_new (_tmp29_);
				_bird_font_point_converter_unref0 (pc);
				pc = _tmp30_;
				_tmp31_ = pl;
				_tmp32_ = pc;
				_tmp33_ = bird_font_point_converter_get_quadratic_path (_tmp32_);
				_tmp34_ = _tmp33_;
				bird_font_path_list_add (_tmp31_, _tmp34_);
				_g_object_unref0 (_tmp34_);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	result = pl;
	_g_object_unref0 (stroke);
	_bird_font_point_converter_unref0 (pc);
	return result;
}

static void
bird_font_glyph_real_close (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (BirdFontGlyph*) base;
	_tmp0_ = self->priv->undo_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->redo_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
}

void
bird_font_glyph_set_empty_ttf (BirdFontGlyph* self,
                               gboolean e)
{
	g_return_if_fail (self != NULL);
	self->priv->empty = e;
}

gboolean
bird_font_glyph_is_empty_ttf (BirdFontGlyph* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->empty;
	return result;
}

void
bird_font_glyph_clear_active_paths (BirdFontGlyph* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->selected_groups;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->active_paths;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
}

void
bird_font_glyph_add_active_path (BirdFontGlyph* self,
                                 BirdFontLayer* group,
                                 BirdFontPath* p)
{
	BirdFontPath* path = NULL;
	BirdFontLayer* g = NULL;
	g_return_if_fail (self != NULL);
	if (p != NULL) {
		BirdFontPath* _tmp0_;
		BirdFontTool* _tmp1_;
		BirdFontTool* _tmp2_;
		gboolean _tmp3_;
		GeeArrayList* _tmp10_;
		BirdFontPath* _tmp11_;
		BirdFontPath* _tmp14_;
		BirdFontPath* _tmp15_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (p, BIRD_FONT_TYPE_PATH, BirdFontPath));
		_g_object_unref0 (path);
		path = _tmp0_;
		_tmp1_ = bird_font_toolbox_get_move_tool ();
		_tmp2_ = _tmp1_;
		_tmp3_ = bird_font_tool_is_selected (_tmp2_);
		_g_object_unref0 (_tmp2_);
		if (_tmp3_) {
			BirdFontPath* _tmp4_;
			gdouble _tmp5_;
			gdouble _tmp6_;
			_tmp4_ = path;
			_tmp5_ = bird_font_path_get_stroke (_tmp4_);
			_tmp6_ = _tmp5_;
			if (_tmp6_ > ((gdouble) 0)) {
				BirdFontPath* _tmp7_;
				gdouble _tmp8_;
				gdouble _tmp9_;
				_tmp7_ = path;
				_tmp8_ = bird_font_path_get_stroke (_tmp7_);
				_tmp9_ = _tmp8_;
				bird_font_toolbox_set_object_stroke (_tmp9_);
			}
		}
		_tmp10_ = self->active_paths;
		_tmp11_ = path;
		if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp10_, _tmp11_)) {
			GeeArrayList* _tmp12_;
			BirdFontPath* _tmp13_;
			_tmp12_ = self->active_paths;
			_tmp13_ = path;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
		}
		_tmp14_ = path;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (bird_font_pen_tool_active_path);
		bird_font_pen_tool_active_path = _tmp15_;
	}
	if (group != NULL) {
		BirdFontLayer* _tmp16_;
		GeeArrayList* _tmp17_;
		BirdFontLayer* _tmp18_;
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (group, BIRD_FONT_TYPE_LAYER, BirdFontLayer));
		_g_object_unref0 (g);
		g = _tmp16_;
		_tmp17_ = self->selected_groups;
		_tmp18_ = g;
		if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp17_, _tmp18_)) {
			GeeArrayList* _tmp19_;
			BirdFontLayer* _tmp20_;
			_tmp19_ = self->selected_groups;
			_tmp20_ = g;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
		}
	}
	_g_object_unref0 (g);
	_g_object_unref0 (path);
}

void
bird_font_glyph_delete_background (BirdFontGlyph* self)
{
	g_return_if_fail (self != NULL);
	bird_font_glyph_store_undo_state (self, FALSE);
	_g_object_unref0 (self->priv->background_image);
	self->priv->background_image = NULL;
	bird_font_glyph_canvas_redraw ();
}

BirdFontPath*
bird_font_glyph_get_active_path (BirdFontGlyph* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->active_paths;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (_tmp2_ > 0, NULL);
	_tmp3_ = self->active_paths;
	_tmp4_ = self->active_paths;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
	result = (BirdFontPath*) _tmp7_;
	return result;
}

gboolean
bird_font_glyph_boundaries (BirdFontGlyph* self,
                            gdouble* x1,
                            gdouble* y1,
                            gdouble* x2,
                            gdouble* y2)
{
	gdouble _vala_x1 = 0.0;
	gdouble _vala_y1 = 0.0;
	gdouble _vala_x2 = 0.0;
	gdouble _vala_y2 = 0.0;
	GeeArrayList* paths = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_glyph_get_all_paths (self);
	paths = _tmp0_;
	_tmp1_ = paths;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_vala_x1 = (gdouble) 0;
		_vala_y1 = (gdouble) 0;
		_vala_x2 = (gdouble) 0;
		_vala_y2 = (gdouble) 0;
		result = FALSE;
		_g_object_unref0 (paths);
		if (x1) {
			*x1 = _vala_x1;
		}
		if (y1) {
			*y1 = _vala_y1;
		}
		if (x2) {
			*x2 = _vala_x2;
		}
		if (y2) {
			*y2 = _vala_y2;
		}
		return result;
	}
	_vala_x1 = BIRD_FONT_GLYPH_CANVAS_MAX;
	_vala_x2 = BIRD_FONT_GLYPH_CANVAS_MIN;
	_vala_y1 = BIRD_FONT_GLYPH_CANVAS_MAX;
	_vala_y2 = BIRD_FONT_GLYPH_CANVAS_MIN;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp4_;
		gint _p_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _p_index = 0;
		_tmp4_ = paths;
		_p_list = _tmp4_;
		_tmp5_ = _p_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_p_size = _tmp7_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			BirdFontPath* _tmp12_;
			BirdFontPath* _tmp13_;
			GeeArrayList* _tmp14_;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_p_index = _p_index + 1;
			_tmp8_ = _p_index;
			_tmp9_ = _p_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _p_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _p_index);
			p = (BirdFontPath*) _tmp11_;
			_tmp12_ = p;
			bird_font_path_update_region_boundaries (_tmp12_);
			_tmp13_ = p;
			_tmp14_ = bird_font_path_get_points (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ > 1) {
				BirdFontPath* _tmp18_;
				BirdFontPath* _tmp20_;
				BirdFontPath* _tmp22_;
				BirdFontPath* _tmp24_;
				_tmp18_ = p;
				if (_tmp18_->xmin < _vala_x1) {
					BirdFontPath* _tmp19_;
					_tmp19_ = p;
					_vala_x1 = _tmp19_->xmin;
				}
				_tmp20_ = p;
				if (_tmp20_->xmax > _vala_x2) {
					BirdFontPath* _tmp21_;
					_tmp21_ = p;
					_vala_x2 = _tmp21_->xmax;
				}
				_tmp22_ = p;
				if (_tmp22_->ymin < _vala_y1) {
					BirdFontPath* _tmp23_;
					_tmp23_ = p;
					_vala_y1 = _tmp23_->ymin;
				}
				_tmp24_ = p;
				if (_tmp24_->ymax > _vala_y2) {
					BirdFontPath* _tmp25_;
					_tmp25_ = p;
					_vala_y2 = _tmp25_->ymax;
				}
			}
			_g_object_unref0 (p);
		}
	}
	result = _vala_x1 != DBL_MAX;
	_g_object_unref0 (paths);
	if (x1) {
		*x1 = _vala_x1;
	}
	if (y1) {
		*y1 = _vala_y1;
	}
	if (x2) {
		*x2 = _vala_x2;
	}
	if (y2) {
		*y2 = _vala_y2;
	}
	return result;
}

void
bird_font_glyph_selection_boundaries (BirdFontGlyph* self,
                                      gdouble* x,
                                      gdouble* y,
                                      gdouble* w,
                                      gdouble* h)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_w = 0.0;
	gdouble _vala_h = 0.0;
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble px2 = 0.0;
	gdouble py2 = 0.0;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	px = (gdouble) 10000;
	py = (gdouble) 10000;
	px2 = (gdouble) -10000;
	py2 = (gdouble) -10000;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = self->active_paths;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			BirdFontPath* _tmp10_;
			BirdFontPath* _tmp12_;
			BirdFontPath* _tmp14_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			_tmp8_ = p;
			if (_tmp8_->xmin < px) {
				BirdFontPath* _tmp9_;
				_tmp9_ = p;
				px = _tmp9_->xmin;
			}
			_tmp10_ = p;
			if (_tmp10_->ymin < py) {
				BirdFontPath* _tmp11_;
				_tmp11_ = p;
				py = _tmp11_->ymin;
			}
			_tmp12_ = p;
			if (_tmp12_->xmax > px2) {
				BirdFontPath* _tmp13_;
				_tmp13_ = p;
				px2 = _tmp13_->xmax;
			}
			_tmp14_ = p;
			if (_tmp14_->ymax > py2) {
				BirdFontPath* _tmp15_;
				_tmp15_ = p;
				py2 = _tmp15_->ymax;
			}
			_g_object_unref0 (p);
		}
	}
	if (px2 == ((gdouble) -10000)) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = px == ((gdouble) 10000);
	}
	if (_tmp16_) {
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp17_ = self->active_paths;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat ("No box for selected paths. (", _tmp21_, ")", NULL);
		_tmp23_ = _tmp22_;
		g_warning ("Glyph.vala:362: %s", _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		px = (gdouble) 0;
		py = (gdouble) 0;
		px2 = (gdouble) 0;
		py2 = (gdouble) 0;
	}
	_vala_x = px;
	_vala_y = py2;
	_vala_w = px2 - px;
	_vala_h = py2 - py;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}

/** @return centrum pixel for x coordinates. */
gdouble
bird_font_glyph_xc (void)
{
	gdouble c = 0.0;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontWidgetAllocation* _tmp2_;
	gdouble _tmp3_;
	gdouble result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->allocation;
	_tmp3_ = _tmp2_->width / 2.0;
	_g_object_unref0 (_tmp1_);
	c = _tmp3_;
	result = c;
	return result;
}

/** @return centrum pixel for y coordinates. */
gdouble
bird_font_glyph_yc (void)
{
	gdouble c = 0.0;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontWidgetAllocation* _tmp2_;
	gdouble _tmp3_;
	gdouble result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->allocation;
	_tmp3_ = _tmp2_->height / 2.0;
	_g_object_unref0 (_tmp1_);
	c = _tmp3_;
	result = c;
	return result;
}

/** @return 1/view_zoom */
gdouble
bird_font_glyph_ivz (void)
{
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	gdouble _tmp2_;
	gdouble result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_tmp1_ = _tmp0_;
	_tmp2_ = 1 / _tmp1_->view_zoom;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

void
bird_font_glyph_resized (BirdFontGlyph* self,
                         BirdFontWidgetAllocation* alloc)
{
	gdouble a = 0.0;
	gdouble b = 0.0;
	gdouble c = 0.0;
	gdouble d = 0.0;
	BirdFontWidgetAllocation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alloc != NULL);
	a = bird_font_glyph_path_coordinate_x ((gdouble) 0);
	b = bird_font_glyph_path_coordinate_y ((gdouble) 0);
	_tmp0_ = _g_object_ref0 (alloc);
	_g_object_unref0 (self->allocation);
	self->allocation = _tmp0_;
	c = bird_font_glyph_path_coordinate_x ((gdouble) 0);
	d = bird_font_glyph_path_coordinate_y ((gdouble) 0);
	self->view_offset_x = self->view_offset_x - (c - a);
	self->view_offset_y = self->view_offset_y - (b - d);
}

void
bird_font_glyph_set_background_image (BirdFontGlyph* self,
                                      BirdFontBackgroundImage* b)
{
	BirdFontBackgroundImage* bg = NULL;
	BirdFontFont* _tmp3_;
	BirdFontFont* _tmp4_;
	g_return_if_fail (self != NULL);
	if (b == NULL) {
		_g_object_unref0 (self->priv->background_image);
		self->priv->background_image = NULL;
	} else {
		BirdFontBackgroundImage* _tmp0_;
		BirdFontBackgroundImage* _tmp1_;
		BirdFontBackgroundImage* _tmp2_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage));
		_g_object_unref0 (bg);
		bg = _tmp0_;
		_tmp1_ = bg;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (self->priv->background_image);
		self->priv->background_image = _tmp2_;
	}
	_tmp3_ = bird_font_bird_font_get_current_font ();
	_tmp4_ = _tmp3_;
	bird_font_font_touch (_tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (bg);
}

BirdFontBackgroundImage*
bird_font_glyph_get_background_image (BirdFontGlyph* self)
{
	BirdFontBackgroundImage* _tmp0_;
	BirdFontBackgroundImage* _tmp1_;
	BirdFontBackgroundImage* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->background_image;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
bird_font_glyph_real_scroll_wheel (BirdFontFontDisplay* base,
                                   gdouble x,
                                   gdouble y,
                                   gdouble pixeldelta_x,
                                   gdouble pixeldelta_y)
{
	BirdFontGlyph * self;
	self = (BirdFontGlyph*) base;
	if (pixeldelta_y > ((gdouble) 0)) {
		bird_font_glyph_zoom_in_at_point (self, x, y, pixeldelta_y);
	} else {
		bird_font_glyph_zoom_out_at_point (self, x, y, pixeldelta_y);
	}
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_glyph_real_add_path (BirdFontGlyph* self,
                               BirdFontPath* p)
{
	BirdFontLayer* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontLayer* _tmp7_;
	BirdFontLayer* _tmp8_;
	g_return_if_fail (p != NULL);
	_tmp0_ = self->layers;
	_tmp1_ = _tmp0_->subgroups;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		BirdFontLayer* _tmp4_;
		BirdFontLayer* _tmp5_;
		BirdFontLayer* _tmp6_;
		_tmp4_ = self->layers;
		_tmp5_ = bird_font_layer_new ();
		_tmp6_ = _tmp5_;
		bird_font_layer_add_layer (_tmp4_, _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp7_ = bird_font_glyph_get_current_layer (self);
	_tmp8_ = _tmp7_;
	bird_font_layer_add_path (_tmp8_, p);
	_g_object_unref0 (_tmp8_);
}

void
bird_font_glyph_add_path (BirdFontGlyph* self,
                          BirdFontPath* p)
{
	BirdFontGlyphClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BIRD_FONT_GLYPH_GET_CLASS (self);
	if (_klass_->add_path) {
		_klass_->add_path (self, p);
	}
}

static gboolean
__lambda168_ (BirdFontGlyph* self)
{
	gboolean result;
	self->priv->ignore_input = FALSE;
	result = FALSE;
	return result;
}

static gboolean
___lambda168__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda168_ ((BirdFontGlyph*) self);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_glyph_real_selected_canvas (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	GSource* input_delay = NULL;
	GSource* _tmp0_;
	GSource* _tmp1_;
	GSource* _tmp2_;
	gchar* _tmp3_;
	BirdFontNativeWindow* _tmp4_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp6_;
	gchar* index = NULL;
	BirdFontFont* _tmp7_;
	BirdFontFontSettings* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	BirdFontToolbox* _tmp23_;
	BirdFontToolbox* _tmp24_;
	BirdFontTool* current_tool = NULL;
	BirdFontToolbox* _tmp25_;
	BirdFontToolbox* _tmp26_;
	BirdFontTool* _tmp27_;
	BirdFontTool* _tmp28_;
	self = (BirdFontGlyph*) base;
	_g_object_unref0 (self->priv->ttf_data);
	self->priv->ttf_data = NULL;
	_cairo_surface_destroy0 (self->overview_thumbnail);
	self->overview_thumbnail = NULL;
	self->priv->ignore_input = TRUE;
	_tmp0_ = g_timeout_source_new ((guint) 250);
	_g_source_unref0 (input_delay);
	input_delay = _tmp0_;
	_tmp1_ = input_delay;
	g_source_set_callback (_tmp1_, ___lambda168__gsource_func, g_object_ref (self), g_object_unref);
	_tmp2_ = input_delay;
	g_source_attach (_tmp2_, NULL);
	bird_font_glyph_add_help_lines (self);
	bird_font_key_bindings_set_require_modifier (FALSE);
	_tmp3_ = bird_font_preferences_get ("glyph_sequence");
	_g_free0 (self->priv->glyph_sequence);
	self->priv->glyph_sequence = _tmp3_;
	bird_font_grid_tool_update_lines ();
	_tmp4_ = bird_font_main_window_native_window;
	if (!bird_font_is_null (_tmp4_)) {
		BirdFontScrollbar* _tmp5_;
		_tmp5_ = bird_font_main_window_scrollbar;
		bird_font_scrollbar_set_size (_tmp5_, (gdouble) 0);
	}
	bird_font_glyph_update_zoom_bar (self);
	_tmp6_ = bird_font_bird_font_get_current_font ();
	font = _tmp6_;
	_tmp7_ = font;
	_tmp8_ = _tmp7_->settings;
	_tmp9_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("Active Layer ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = bird_font_font_settings_get_setting (_tmp8_, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	index = _tmp15_;
	_tmp16_ = index;
	if (g_strcmp0 (_tmp16_, "") != 0) {
		gint i = 0;
		const gchar* _tmp17_;
		BirdFontLayer* _tmp18_;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp17_ = index;
		i = atoi (_tmp17_);
		_tmp18_ = self->layers;
		_tmp19_ = _tmp18_->subgroups;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = i;
		if ((0 <= _tmp22_) && (_tmp22_ < _tmp21_)) {
			self->current_layer = i;
		}
	}
	bird_font_drawing_tools_update_layers ();
	_tmp23_ = bird_font_main_window_get_toolbox ();
	_tmp24_ = _tmp23_;
	bird_font_toolbox_update_expanders (_tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = bird_font_main_window_get_toolbox ();
	_tmp26_ = _tmp25_;
	_tmp27_ = bird_font_toolbox_get_current_tool (_tmp26_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (_tmp26_);
	current_tool = _tmp28_;
	g_signal_emit_by_name (current_tool, "select-action", current_tool);
	_g_object_unref0 (current_tool);
	_g_free0 (index);
	_g_object_unref0 (font);
	_g_source_unref0 (input_delay);
}

static void
bird_font_glyph_update_zoom_bar (BirdFontGlyph* self)
{
	gboolean _tmp0_ = FALSE;
	BirdFontDrawingTools* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = bird_font_toolbox_drawing_tools;
	if (!bird_font_is_null (_tmp1_)) {
		BirdFontDrawingTools* _tmp2_;
		BirdFontZoomBar* _tmp3_;
		_tmp2_ = bird_font_toolbox_drawing_tools;
		_tmp3_ = _tmp2_->zoom_bar;
		_tmp0_ = !bird_font_is_null (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BirdFontDrawingTools* _tmp4_;
		BirdFontZoomBar* _tmp5_;
		_tmp4_ = bird_font_toolbox_drawing_tools;
		_tmp5_ = _tmp4_->zoom_bar;
		bird_font_zoom_bar_set_zoom (_tmp5_, (self->view_zoom - 1) / 20);
	}
}

void
bird_font_glyph_remove_lines (BirdFontGlyph* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->vertical_help_lines;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->horizontal_help_lines;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
}

static void
__lambda71_ (BirdFontGlyph* self,
             gdouble pos)
{
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	_tmp1_->top_limit = pos;
	_g_object_unref0 (_tmp1_);
}

static void
___lambda71__bird_font_line_position_updated (BirdFontLine* _sender,
                                              gdouble pos,
                                              gpointer self)
{
	__lambda71_ ((BirdFontGlyph*) self, pos);
}

static void
__lambda72_ (BirdFontGlyph* self,
             gdouble pos)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	f->top_position = pos;
	_g_object_unref0 (f);
}

static void
___lambda72__bird_font_line_position_updated (BirdFontLine* _sender,
                                              gdouble pos,
                                              gpointer self)
{
	__lambda72_ ((BirdFontGlyph*) self, pos);
}

static void
__lambda73_ (BirdFontGlyph* self,
             gdouble pos)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	f->xheight_position = pos;
	_g_object_unref0 (f);
}

static void
___lambda73__bird_font_line_position_updated (BirdFontLine* _sender,
                                              gdouble pos,
                                              gpointer self)
{
	__lambda73_ ((BirdFontGlyph*) self, pos);
}

static void
__lambda74_ (BirdFontGlyph* self,
             gdouble pos)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	BirdFontOverview* o = NULL;
	BirdFontOverview* _tmp1_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	f->base_line = pos;
	_tmp1_ = bird_font_main_window_get_overview ();
	o = _tmp1_;
	bird_font_overview_reset_cache (o);
	_g_object_unref0 (o);
	_g_object_unref0 (f);
}

static void
___lambda74__bird_font_line_position_updated (BirdFontLine* _sender,
                                              gdouble pos,
                                              gpointer self)
{
	__lambda74_ ((BirdFontGlyph*) self, pos);
}

static void
__lambda346_ (BirdFontGlyph* self,
              gdouble pos)
{
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	_tmp1_->bottom_position = pos;
	_g_object_unref0 (_tmp1_);
}

static void
___lambda346__bird_font_line_position_updated (BirdFontLine* _sender,
                                               gdouble pos,
                                               gpointer self)
{
	__lambda346_ ((BirdFontGlyph*) self, pos);
}

static void
__lambda347_ (BirdFontGlyph* self,
              gdouble pos)
{
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	_tmp1_->bottom_limit = pos;
	_g_object_unref0 (_tmp1_);
}

static void
___lambda347__bird_font_line_position_updated (BirdFontLine* _sender,
                                               gdouble pos,
                                               gpointer self)
{
	__lambda347_ ((BirdFontGlyph*) self, pos);
}

static void
__lambda348_ (BirdFontGlyph* self,
              gdouble pos)
{
	BirdFontLine* _tmp0_;
	bird_font_glyph_set_left_limit (self, pos);
	bird_font_glyph_update_other_spacing_classes (self);
	_tmp0_ = self->priv->left_line;
	bird_font_line_set_metrics (_tmp0_, bird_font_glyph_get_left_side_bearing (self));
}

static void
___lambda348__bird_font_line_position_updated (BirdFontLine* _sender,
                                               gdouble pos,
                                               gpointer self)
{
	__lambda348_ ((BirdFontGlyph*) self, pos);
}

static void
__lambda349_ (BirdFontGlyph* self,
              gdouble pos)
{
	BirdFontLine* _tmp0_;
	bird_font_glyph_set_right_limit (self, pos);
	bird_font_glyph_update_other_spacing_classes (self);
	_tmp0_ = self->priv->right_line;
	bird_font_line_set_metrics (_tmp0_, bird_font_glyph_get_right_side_bearing (self));
}

static void
___lambda349__bird_font_line_position_updated (BirdFontLine* _sender,
                                               gdouble pos,
                                               gpointer self)
{
	__lambda349_ ((BirdFontGlyph*) self, pos);
}

void
bird_font_glyph_add_help_lines (BirdFontGlyph* self)
{
	BirdFontFont* _tmp0_;
	gdouble bgt = 0.0;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	gdouble _tmp3_;
	BirdFontLine* top_margin_line = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontLine* _tmp6_;
	BirdFontLine* _tmp7_;
	BirdFontLine* _tmp8_;
	BirdFontLine* _tmp9_;
	gdouble thp = 0.0;
	BirdFontFont* _tmp10_;
	BirdFontFont* _tmp11_;
	gdouble _tmp12_;
	BirdFontLine* top_line = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	BirdFontLine* _tmp15_;
	BirdFontLine* _tmp16_;
	BirdFontLine* _tmp17_;
	gdouble xhp = 0.0;
	BirdFontFont* _tmp18_;
	BirdFontFont* _tmp19_;
	gdouble _tmp20_;
	BirdFontLine* xheight_line = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	BirdFontLine* _tmp23_;
	BirdFontLine* _tmp24_;
	BirdFontLine* _tmp25_;
	BirdFontLine* _tmp26_;
	BirdFontLine* _tmp27_;
	gdouble xbl = 0.0;
	BirdFontFont* _tmp28_;
	BirdFontFont* _tmp29_;
	gdouble _tmp30_;
	BirdFontLine* base_line = NULL;
	gchar* _tmp31_;
	gchar* _tmp32_;
	BirdFontLine* _tmp33_;
	BirdFontLine* _tmp34_;
	BirdFontLine* _tmp35_;
	gdouble bp = 0.0;
	BirdFontFont* _tmp36_;
	BirdFontFont* _tmp37_;
	gdouble _tmp38_;
	BirdFontLine* bottom_line = NULL;
	gchar* _tmp39_;
	gchar* _tmp40_;
	BirdFontLine* _tmp41_;
	BirdFontLine* _tmp42_;
	BirdFontLine* _tmp43_;
	gdouble bgb = 0.0;
	BirdFontFont* _tmp44_;
	BirdFontFont* _tmp45_;
	gdouble _tmp46_;
	BirdFontLine* bottom_margin_line = NULL;
	gchar* _tmp47_;
	gchar* _tmp48_;
	BirdFontLine* _tmp49_;
	BirdFontLine* _tmp50_;
	BirdFontLine* _tmp51_;
	BirdFontLine* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gdouble _tmp55_;
	gdouble _tmp56_;
	BirdFontLine* _tmp57_;
	BirdFontLine* _tmp58_;
	BirdFontLine* _tmp59_;
	BirdFontLine* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gdouble _tmp63_;
	gdouble _tmp64_;
	BirdFontLine* _tmp65_;
	BirdFontLine* _tmp66_;
	BirdFontLine* _tmp67_;
	BirdFontLine* _tmp68_;
	BirdFontLine* _tmp69_;
	BirdFontLine* _tmp70_;
	gboolean glyph_has_top = FALSE;
	BirdFontLine* _tmp71_;
	BirdFontLine* _tmp72_;
	BirdFontLine* _tmp73_;
	gboolean _tmp74_ = FALSE;
	BirdFontLine* _tmp75_;
	BirdFontLine* _tmp76_;
	gboolean _tmp77_ = FALSE;
	BirdFontLine* _tmp78_;
	BirdFontLine* _tmp79_;
	BirdFontLine* _tmp80_;
	gboolean _tmp81_ = FALSE;
	BirdFontLine* _tmp82_;
	BirdFontLine* _tmp83_;
	BirdFontLine* _tmp84_;
	g_return_if_fail (self != NULL);
	bird_font_glyph_remove_lines (self);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	g_return_if_fail (!bird_font_is_null (_tmp0_));
	_tmp1_ = bird_font_bird_font_get_current_font ();
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->top_limit;
	_g_object_unref0 (_tmp2_);
	bgt = _tmp3_;
	_tmp4_ = bird_font_t_ ("top margin");
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_line_new ("top margin", _tmp5_, bgt, FALSE);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	top_margin_line = _tmp7_;
	_tmp8_ = top_margin_line;
	bird_font_line_set_color_theme (_tmp8_, "Guide 2");
	_tmp9_ = top_margin_line;
	g_signal_connect_object (_tmp9_, "position-updated", (GCallback) ___lambda71__bird_font_line_position_updated, self, 0);
	_tmp10_ = bird_font_bird_font_get_current_font ();
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->top_position;
	_g_object_unref0 (_tmp11_);
	thp = _tmp12_;
	_tmp13_ = bird_font_t_ ("top");
	_tmp14_ = _tmp13_;
	_tmp15_ = bird_font_line_new ("top", _tmp14_, thp, FALSE);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	top_line = _tmp16_;
	_tmp17_ = top_line;
	g_signal_connect_object (_tmp17_, "position-updated", (GCallback) ___lambda72__bird_font_line_position_updated, self, 0);
	_tmp18_ = bird_font_bird_font_get_current_font ();
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_->xheight_position;
	_g_object_unref0 (_tmp19_);
	xhp = _tmp20_;
	_tmp21_ = bird_font_t_ ("x-height");
	_tmp22_ = _tmp21_;
	_tmp23_ = bird_font_line_new ("x-height", _tmp22_, xhp, FALSE);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	xheight_line = _tmp24_;
	_tmp25_ = xheight_line;
	bird_font_line_set_color_theme (_tmp25_, "Guide 3");
	_tmp26_ = xheight_line;
	bird_font_line_set_dashed (_tmp26_, TRUE);
	_tmp27_ = xheight_line;
	g_signal_connect_object (_tmp27_, "position-updated", (GCallback) ___lambda73__bird_font_line_position_updated, self, 0);
	_tmp28_ = bird_font_bird_font_get_current_font ();
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_->base_line;
	_g_object_unref0 (_tmp29_);
	xbl = _tmp30_;
	_tmp31_ = bird_font_t_ ("baseline");
	_tmp32_ = _tmp31_;
	_tmp33_ = bird_font_line_new ("baseline", _tmp32_, xbl, FALSE);
	_tmp34_ = _tmp33_;
	_g_free0 (_tmp32_);
	base_line = _tmp34_;
	_tmp35_ = base_line;
	g_signal_connect_object (_tmp35_, "position-updated", (GCallback) ___lambda74__bird_font_line_position_updated, self, 0);
	_tmp36_ = bird_font_bird_font_get_current_font ();
	_tmp37_ = _tmp36_;
	_tmp38_ = _tmp37_->bottom_position;
	_g_object_unref0 (_tmp37_);
	bp = _tmp38_;
	_tmp39_ = bird_font_t_ ("bottom");
	_tmp40_ = _tmp39_;
	_tmp41_ = bird_font_line_new ("bottom", _tmp40_, bp, FALSE);
	_tmp42_ = _tmp41_;
	_g_free0 (_tmp40_);
	bottom_line = _tmp42_;
	_tmp43_ = bottom_line;
	g_signal_connect_object (_tmp43_, "position-updated", (GCallback) ___lambda346__bird_font_line_position_updated, self, 0);
	_tmp44_ = bird_font_bird_font_get_current_font ();
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_->bottom_limit;
	_g_object_unref0 (_tmp45_);
	bgb = _tmp46_;
	_tmp47_ = bird_font_t_ ("bottom margin");
	_tmp48_ = _tmp47_;
	_tmp49_ = bird_font_line_new ("bottom margin", _tmp48_, bgb, FALSE);
	_tmp50_ = _tmp49_;
	_g_free0 (_tmp48_);
	bottom_margin_line = _tmp50_;
	_tmp51_ = bottom_margin_line;
	bird_font_line_set_color_theme (_tmp51_, "Guide 2");
	_tmp52_ = bottom_margin_line;
	g_signal_connect_object (_tmp52_, "position-updated", (GCallback) ___lambda347__bird_font_line_position_updated, self, 0);
	_tmp53_ = bird_font_t_ ("left");
	_tmp54_ = _tmp53_;
	_tmp55_ = bird_font_glyph_get_left_limit (self);
	_tmp56_ = _tmp55_;
	_tmp57_ = bird_font_line_new ("left", _tmp54_, _tmp56_, TRUE);
	_g_object_unref0 (self->priv->left_line);
	self->priv->left_line = _tmp57_;
	_g_free0 (_tmp54_);
	_tmp58_ = self->priv->left_line;
	_tmp58_->lsb = TRUE;
	_tmp59_ = self->priv->left_line;
	g_signal_connect_object (_tmp59_, "position-updated", (GCallback) ___lambda348__bird_font_line_position_updated, self, 0);
	_tmp60_ = self->priv->left_line;
	bird_font_line_set_metrics (_tmp60_, bird_font_glyph_get_left_side_bearing (self));
	_tmp61_ = bird_font_t_ ("right");
	_tmp62_ = _tmp61_;
	_tmp63_ = bird_font_glyph_get_right_limit (self);
	_tmp64_ = _tmp63_;
	_tmp65_ = bird_font_line_new ("right", _tmp62_, _tmp64_, TRUE);
	_g_object_unref0 (self->priv->right_line);
	self->priv->right_line = _tmp65_;
	_g_free0 (_tmp62_);
	_tmp66_ = self->priv->right_line;
	_tmp66_->rsb = TRUE;
	_tmp67_ = self->priv->right_line;
	g_signal_connect_object (_tmp67_, "position-updated", (GCallback) ___lambda349__bird_font_line_position_updated, self, 0);
	_tmp68_ = self->priv->right_line;
	bird_font_line_set_metrics (_tmp68_, bird_font_glyph_get_right_side_bearing (self));
	_tmp69_ = self->priv->left_line;
	bird_font_glyph_add_line (self, _tmp69_);
	_tmp70_ = self->priv->right_line;
	bird_font_glyph_add_line (self, _tmp70_);
	glyph_has_top = bird_font_glyph_has_top_line (self);
	_tmp71_ = top_margin_line;
	bird_font_glyph_add_line (self, _tmp71_);
	_tmp72_ = top_margin_line;
	bird_font_line_set_visible (_tmp72_, self->priv->margin_boundaries_visible);
	_tmp73_ = top_line;
	bird_font_glyph_add_line (self, _tmp73_);
	if (glyph_has_top) {
		_tmp74_ = TRUE;
	} else {
		_tmp74_ = self->priv->xheight_lines_visible;
	}
	_tmp75_ = top_line;
	bird_font_line_set_visible (_tmp75_, _tmp74_);
	_tmp76_ = xheight_line;
	bird_font_glyph_add_line (self, _tmp76_);
	if (!glyph_has_top) {
		_tmp77_ = TRUE;
	} else {
		_tmp77_ = self->priv->xheight_lines_visible;
	}
	_tmp78_ = xheight_line;
	bird_font_line_set_visible (_tmp78_, _tmp77_);
	_tmp79_ = base_line;
	bird_font_glyph_add_line (self, _tmp79_);
	_tmp80_ = bottom_line;
	bird_font_glyph_add_line (self, _tmp80_);
	if (bird_font_char_database_has_descender (self->unichar_code)) {
		_tmp81_ = TRUE;
	} else {
		_tmp81_ = self->priv->xheight_lines_visible;
	}
	_tmp82_ = bottom_line;
	bird_font_line_set_visible (_tmp82_, _tmp81_);
	_tmp83_ = bottom_margin_line;
	bird_font_glyph_add_line (self, _tmp83_);
	_tmp84_ = bottom_margin_line;
	bird_font_line_set_visible (_tmp84_, self->priv->margin_boundaries_visible);
	{
		GeeArrayList* _guide_list = NULL;
		BirdFontFont* _tmp85_;
		BirdFontFont* _tmp86_;
		GeeArrayList* _tmp87_;
		GeeArrayList* _tmp88_;
		gint _guide_size = 0;
		GeeArrayList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _guide_index = 0;
		_tmp85_ = bird_font_bird_font_get_current_font ();
		_tmp86_ = _tmp85_;
		_tmp87_ = _tmp86_->custom_guides;
		_tmp88_ = _tmp87_;
		_g_object_unref0 (_tmp86_);
		_guide_list = _tmp88_;
		_tmp89_ = _guide_list;
		_tmp90_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_guide_size = _tmp91_;
		_guide_index = -1;
		while (TRUE) {
			gint _tmp92_;
			gint _tmp93_;
			BirdFontLine* guide = NULL;
			GeeArrayList* _tmp94_;
			gpointer _tmp95_;
			BirdFontLine* _tmp96_;
			_guide_index = _guide_index + 1;
			_tmp92_ = _guide_index;
			_tmp93_ = _guide_size;
			if (!(_tmp92_ < _tmp93_)) {
				break;
			}
			_tmp94_ = _guide_list;
			_tmp95_ = gee_abstract_list_get ((GeeAbstractList*) _tmp94_, _guide_index);
			guide = (BirdFontLine*) _tmp95_;
			_tmp96_ = guide;
			bird_font_glyph_add_line (self, _tmp96_);
			_g_object_unref0 (guide);
		}
	}
	_g_object_unref0 (bottom_margin_line);
	_g_object_unref0 (bottom_line);
	_g_object_unref0 (base_line);
	_g_object_unref0 (xheight_line);
	_g_object_unref0 (top_line);
	_g_object_unref0 (top_margin_line);
}

gdouble
bird_font_glyph_get_left_side_bearing (BirdFontGlyph* self)
{
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp4_ = bird_font_glyph_get_boundaries (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x1 = _tmp0_;
	y1 = _tmp1_;
	x2 = _tmp2_;
	y2 = _tmp3_;
	if (_tmp4_) {
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp5_ = bird_font_glyph_get_left_limit (self);
		_tmp6_ = _tmp5_;
		result = x1 - _tmp6_;
		return result;
	} else {
		gdouble _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		_tmp7_ = bird_font_glyph_get_right_limit (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = bird_font_glyph_get_left_limit (self);
		_tmp10_ = _tmp9_;
		result = _tmp8_ - _tmp10_;
		return result;
	}
}

gdouble
bird_font_glyph_get_right_side_bearing (BirdFontGlyph* self)
{
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp4_ = bird_font_glyph_get_boundaries (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	x1 = _tmp0_;
	y1 = _tmp1_;
	x2 = _tmp2_;
	y2 = _tmp3_;
	if (_tmp4_) {
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp5_ = bird_font_glyph_get_right_limit (self);
		_tmp6_ = _tmp5_;
		result = _tmp6_ - x2;
		return result;
	} else {
		gdouble _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		_tmp7_ = bird_font_glyph_get_right_limit (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = bird_font_glyph_get_left_limit (self);
		_tmp10_ = _tmp9_;
		result = _tmp8_ - _tmp10_;
		return result;
	}
}

gboolean
bird_font_glyph_get_boundaries (BirdFontGlyph* self,
                                gdouble* x1,
                                gdouble* y1,
                                gdouble* x2,
                                gdouble* y2)
{
	gdouble _vala_x1 = 0.0;
	gdouble _vala_y1 = 0.0;
	gdouble _vala_x2 = 0.0;
	gdouble _vala_y2 = 0.0;
	gdouble max_x = 0.0;
	gdouble min_x = 0.0;
	gdouble max_y = 0.0;
	gdouble min_y = 0.0;
	BirdFontPathList* pl = NULL;
	GeeArrayList* paths = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_glyph_get_all_paths (self);
	paths = _tmp0_;
	_tmp1_ = paths;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_vala_x1 = (gdouble) 0;
		_vala_y1 = (gdouble) 0;
		_vala_x2 = (gdouble) 0;
		_vala_y2 = (gdouble) 0;
		result = FALSE;
		_g_object_unref0 (paths);
		_g_object_unref0 (pl);
		if (x1) {
			*x1 = _vala_x1;
		}
		if (y1) {
			*y1 = _vala_y1;
		}
		if (x2) {
			*x2 = _vala_x2;
		}
		if (y2) {
			*y2 = _vala_y2;
		}
		return result;
	}
	max_x = BIRD_FONT_GLYPH_CANVAS_MIN;
	min_x = BIRD_FONT_GLYPH_CANVAS_MAX;
	max_y = BIRD_FONT_GLYPH_CANVAS_MIN;
	min_y = BIRD_FONT_GLYPH_CANVAS_MAX;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp4_;
		gint _p_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _p_index = 0;
		_tmp4_ = paths;
		_p_list = _tmp4_;
		_tmp5_ = _p_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_p_size = _tmp7_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			BirdFontPath* _tmp12_;
			gdouble _tmp13_;
			gdouble _tmp14_;
			_p_index = _p_index + 1;
			_tmp8_ = _p_index;
			_tmp9_ = _p_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _p_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _p_index);
			p = (BirdFontPath*) _tmp11_;
			_tmp12_ = p;
			_tmp13_ = bird_font_path_get_stroke (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ > ((gdouble) 0)) {
				BirdFontPath* _tmp15_;
				BirdFontPathList* _tmp16_;
				_tmp15_ = p;
				_tmp16_ = bird_font_path_get_stroke_fast (_tmp15_);
				_g_object_unref0 (pl);
				pl = _tmp16_;
				{
					GeeArrayList* _part_list = NULL;
					BirdFontPathList* _tmp17_;
					GeeArrayList* _tmp18_;
					gint _part_size = 0;
					GeeArrayList* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					gint _part_index = 0;
					_tmp17_ = pl;
					_tmp18_ = _tmp17_->paths;
					_part_list = _tmp18_;
					_tmp19_ = _part_list;
					_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
					_tmp21_ = _tmp20_;
					_part_size = _tmp21_;
					_part_index = -1;
					while (TRUE) {
						gint _tmp22_;
						gint _tmp23_;
						BirdFontPath* part = NULL;
						GeeArrayList* _tmp24_;
						gpointer _tmp25_;
						BirdFontPath* _tmp26_;
						_part_index = _part_index + 1;
						_tmp22_ = _part_index;
						_tmp23_ = _part_size;
						if (!(_tmp22_ < _tmp23_)) {
							break;
						}
						_tmp24_ = _part_list;
						_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _part_index);
						part = (BirdFontPath*) _tmp25_;
						_tmp26_ = part;
						bird_font_glyph_boundaries_for_path (self, _tmp26_, &min_x, &max_x, &min_y, &max_y);
						_g_object_unref0 (part);
					}
				}
			} else {
				BirdFontPath* _tmp27_;
				_tmp27_ = p;
				bird_font_glyph_boundaries_for_path (self, _tmp27_, &min_x, &max_x, &min_y, &max_y);
			}
			_g_object_unref0 (p);
		}
	}
	_vala_x1 = min_x;
	_vala_y1 = max_y;
	_vala_x2 = max_x;
	_vala_y2 = min_y;
	result = max_x != BIRD_FONT_GLYPH_CANVAS_MIN;
	_g_object_unref0 (paths);
	_g_object_unref0 (pl);
	if (x1) {
		*x1 = _vala_x1;
	}
	if (y1) {
		*y1 = _vala_y1;
	}
	if (x2) {
		*x2 = _vala_x2;
	}
	if (y2) {
		*y2 = _vala_y2;
	}
	return result;
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		BirdFontGlyph* self;
		self = _data17_->self;
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static gboolean
__lambda38_ (Block17Data* _data17_,
             gdouble x,
             gdouble y,
             gdouble t)
{
	BirdFontGlyph* self;
	gboolean result;
	self = _data17_->self;
	if (x > _data17_->max_x2) {
		_data17_->max_x2 = x;
	}
	if (y > _data17_->max_y2) {
		_data17_->max_y2 = y;
	}
	if (x < _data17_->min_x2) {
		_data17_->min_x2 = x;
	}
	if (y < _data17_->min_y2) {
		_data17_->min_y2 = y;
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda38__bird_font_path_raster_iterator (gdouble x,
                                             gdouble y,
                                             gdouble step,
                                             gpointer self)
{
	gboolean result;
	result = __lambda38_ (self, x, y, step);
	return result;
}

static void
bird_font_glyph_boundaries_for_path (BirdFontGlyph* self,
                                     BirdFontPath* p,
                                     gdouble* min_x,
                                     gdouble* max_x,
                                     gdouble* min_y,
                                     gdouble* max_y)
{
	Block17Data* _data17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_data17_->max_x2 = *max_x;
	_data17_->min_x2 = *min_x;
	_data17_->max_y2 = *max_y;
	_data17_->min_y2 = *min_y;
	bird_font_path_all_of_path (p, ___lambda38__bird_font_path_raster_iterator, _data17_, -1);
	*max_x = _data17_->max_x2;
	*min_x = _data17_->min_x2;
	*max_y = _data17_->max_y2;
	*min_y = _data17_->min_y2;
	block17_data_unref (_data17_);
	_data17_ = NULL;
}

static gboolean
bird_font_glyph_has_top_line (BirdFontGlyph* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!g_unichar_islower (self->unichar_code)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = bird_font_char_database_has_ascender (self->unichar_code);
	}
	result = _tmp0_;
	return result;
}

gboolean
bird_font_glyph_get_show_help_lines (BirdFontGlyph* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->show_help_lines;
	return result;
}

/** Show both x-height and top lines. */
gboolean
bird_font_glyph_get_xheight_lines_visible (BirdFontGlyph* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->xheight_lines_visible;
	return result;
}

/** Show both x-height and top lines. */
void
bird_font_glyph_set_xheight_lines_visible (BirdFontGlyph* self,
                                           gboolean x)
{
	g_return_if_fail (self != NULL);
	self->priv->xheight_lines_visible = x;
	bird_font_glyph_add_help_lines (self);
}

void
bird_font_glyph_set_margin_lines_visible (BirdFontGlyph* self,
                                          gboolean m)
{
	g_return_if_fail (self != NULL);
	self->priv->margin_boundaries_visible = m;
	bird_font_glyph_add_help_lines (self);
}

gboolean
bird_font_glyph_get_margin_lines_visible (BirdFontGlyph* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->margin_boundaries_visible;
	return result;
}

void
bird_font_glyph_remove_empty_paths (BirdFontGlyph* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = bird_font_glyph_get_all_paths (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			GeeArrayList* _tmp9_;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = bird_font_path_get_points (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ < 2) {
				BirdFontPath* _tmp13_;
				_tmp13_ = p;
				bird_font_glyph_delete_path (self, _tmp13_);
				bird_font_glyph_remove_empty_paths (self);
				_g_object_unref0 (p);
				_g_object_unref0 (_p_list);
				return;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
}

void
bird_font_glyph_delete_path (BirdFontGlyph* self,
                             BirdFontPath* p)
{
	BirdFontLayer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->layers;
	bird_font_layer_remove_path (_tmp0_, p);
}

gchar*
bird_font_glyph_get_svg_data (BirdFontGlyph* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_svg_to_svg_glyph (self);
	result = _tmp0_;
	return result;
}

gint
bird_font_glyph_get_height (BirdFontGlyph* self)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	result = (gint) fabs (f->top_limit - f->bottom_limit);
	_g_object_unref0 (f);
	return result;
}

gdouble
bird_font_glyph_get_width (BirdFontGlyph* self)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = bird_font_glyph_get_right_limit (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_glyph_get_left_limit (self);
	_tmp3_ = _tmp2_;
	result = fabs (_tmp1_ - _tmp3_);
	return result;
}

gunichar
bird_font_glyph_get_unichar (BirdFontGlyph* self)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->unichar_code;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

gchar*
bird_font_glyph_get_unichar_string (BirdFontGlyph* self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_unichar_to_string (bird_font_glyph_get_unichar (self));
	s = (gchar*) _tmp0_;
	_tmp1_ = s;
	if (G_UNLIKELY (_tmp1_ == NULL)) {
		gchar* _tmp2_;
		g_warning ("Glyph.vala:762: Invalid character.");
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		_g_free0 (s);
		return result;
	}
	_tmp3_ = s;
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	result = _tmp4_;
	_g_free0 (s);
	return result;
}

void
bird_font_glyph_redraw_help_lines (BirdFontGlyph* self)
{
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->allocation;
	_tmp1_ = self->allocation;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) 0, (gdouble) 0, (gdouble) _tmp0_->width, (gdouble) _tmp1_->height);
}

void
bird_font_glyph_set_show_help_lines (BirdFontGlyph* self,
                                     gboolean hl)
{
	g_return_if_fail (self != NULL);
	self->show_help_lines = hl;
}

static void
__lambda179_ (BirdFontGlyph* self,
              gint x,
              gint y,
              gint w,
              gint h)
{
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
}

static void
___lambda179__bird_font_line_queue_draw_area (BirdFontLine* _sender,
                                              gint x,
                                              gint y,
                                              gint w,
                                              gint h,
                                              gpointer self)
{
	__lambda179_ ((BirdFontGlyph*) self, x, y, w, h);
}

static void
bird_font_glyph_add_line (BirdFontGlyph* self,
                          BirdFontLine* line)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	if (bird_font_line_is_vertical (line)) {
		GeeArrayList* _tmp0_;
		_tmp0_ = self->vertical_help_lines;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, line);
	} else {
		GeeArrayList* _tmp1_;
		_tmp1_ = self->horizontal_help_lines;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, line);
	}
	bird_font_glyph_sort_help_lines (self);
	g_signal_connect_object (line, "queue-draw-area", (GCallback) ___lambda179__bird_font_line_queue_draw_area, self, 0);
}

static gint
__lambda177_ (BirdFontGlyph* self,
              BirdFontLine* a,
              BirdFontLine* b)
{
	BirdFontLine* first = NULL;
	BirdFontLine* next = NULL;
	BirdFontLine* _tmp0_;
	BirdFontLine* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_LINE, BirdFontLine));
	_g_object_unref0 (first);
	first = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_LINE, BirdFontLine));
	_g_object_unref0 (next);
	next = _tmp1_;
	result = (gint) (bird_font_line_get_pos (first) - bird_font_line_get_pos (next));
	_g_object_unref0 (next);
	_g_object_unref0 (first);
	return result;
}

static gint
___lambda177__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda177_ ((BirdFontGlyph*) self, (BirdFontLine*) a, (BirdFontLine*) b);
	return result;
}

static gint
__lambda178_ (BirdFontGlyph* self,
              BirdFontLine* a,
              BirdFontLine* b)
{
	BirdFontLine* first = NULL;
	BirdFontLine* next = NULL;
	BirdFontLine* _tmp0_;
	BirdFontLine* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_LINE, BirdFontLine));
	_g_object_unref0 (first);
	first = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_LINE, BirdFontLine));
	_g_object_unref0 (next);
	next = _tmp1_;
	result = (gint) (bird_font_line_get_pos (first) - bird_font_line_get_pos (next));
	_g_object_unref0 (next);
	_g_object_unref0 (first);
	return result;
}

static gint
___lambda178__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda178_ ((BirdFontGlyph*) self, (BirdFontLine*) a, (BirdFontLine*) b);
	return result;
}

void
bird_font_glyph_sort_help_lines (BirdFontGlyph* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->vertical_help_lines;
	gee_list_sort ((GeeList*) _tmp0_, ___lambda177__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp1_ = self->horizontal_help_lines;
	gee_list_sort ((GeeList*) _tmp1_, ___lambda178__gcompare_data_func, g_object_ref (self), g_object_unref);
}

static gchar*
bird_font_glyph_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (BirdFontGlyph*) base;
	_tmp0_ = self->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
bird_font_glyph_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (BirdFontGlyph*) base;
	_tmp0_ = self->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
bird_font_glyph_help_line_event (BirdFontGlyph* self,
                                 gint x,
                                 gint y)
{
	gboolean m = FALSE;
	g_return_if_fail (self != NULL);
	m = FALSE;
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp0_;
		gint _line_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _line_index = 0;
		_tmp0_ = self->vertical_help_lines;
		_line_list = _tmp0_;
		_tmp1_ = _line_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_line_size = _tmp3_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			_line_index = _line_index + 1;
			_tmp4_ = _line_index;
			_tmp5_ = _line_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _line_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _line_index);
			line = (BirdFontLine*) _tmp7_;
			if (!m) {
				BirdFontLine* _tmp9_;
				BirdFontWidgetAllocation* _tmp10_;
				_tmp9_ = line;
				_tmp10_ = self->allocation;
				_tmp8_ = bird_font_line_event_move_to (_tmp9_, x, y, _tmp10_);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				m = TRUE;
			}
			_g_object_unref0 (line);
		}
	}
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp11_;
		gint _line_size = 0;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _line_index = 0;
		_tmp11_ = self->horizontal_help_lines;
		_line_list = _tmp11_;
		_tmp12_ = _line_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_line_size = _tmp14_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			gboolean _tmp19_ = FALSE;
			_line_index = _line_index + 1;
			_tmp15_ = _line_index;
			_tmp16_ = _line_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _line_list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _line_index);
			line = (BirdFontLine*) _tmp18_;
			if (!m) {
				BirdFontLine* _tmp20_;
				BirdFontWidgetAllocation* _tmp21_;
				_tmp20_ = line;
				_tmp21_ = self->allocation;
				_tmp19_ = bird_font_line_event_move_to (_tmp20_, x, y, _tmp21_);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				m = TRUE;
			}
			_g_object_unref0 (line);
		}
	}
}

static void
bird_font_glyph_real_key_release (BirdFontFontDisplay* base,
                                  guint keyval)
{
	BirdFontGlyph * self;
	BirdFontTool* t = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* _tmp3_;
	BirdFontTool* _tmp4_;
	self = (BirdFontGlyph*) base;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_toolbox_get_current_tool (_tmp1_);
	_g_object_unref0 (t);
	t = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = t;
	_tmp4_ = t;
	g_signal_emit_by_name (_tmp3_, "key-release-action", _tmp4_, (guint32) keyval);
	if (keyval == ((guint) ' ')) {
		self->priv->move_canvas = FALSE;
	}
	_g_object_unref0 (t);
}

static void
bird_font_glyph_real_key_press (BirdFontFontDisplay* base,
                                guint keyval)
{
	BirdFontGlyph * self;
	BirdFontTool* t = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* _tmp3_;
	BirdFontTool* _tmp4_;
	BirdFontTool* _tmp5_;
	self = (BirdFontGlyph*) base;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_toolbox_get_current_tool (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	t = _tmp3_;
	_tmp4_ = t;
	_tmp5_ = t;
	g_signal_emit_by_name (_tmp4_, "key-press-action", _tmp5_, (guint32) keyval);
	if (keyval == ((guint) ' ')) {
		self->priv->move_canvas = TRUE;
	}
	switch (keyval) {
		case BIRD_FONT_KEY_NUM_PLUS:
		{
			bird_font_font_display_zoom_in ((BirdFontFontDisplay*) self);
			break;
		}
		case BIRD_FONT_KEY_NUM_MINUS:
		{
			bird_font_font_display_zoom_out ((BirdFontFontDisplay*) self);
			break;
		}
		default:
		break;
	}
	_g_object_unref0 (t);
}

/** Delete edit point from path.
 * @return false if no points was deleted
 */
gboolean
bird_font_glyph_process_deleted (BirdFontGlyph* self)
{
	GeeArrayList* deleted_paths = NULL;
	GeeArrayList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	deleted_paths = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = bird_font_glyph_get_all_paths (self);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPath* _tmp9_;
			GeeArrayList* _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = bird_font_path_get_points (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ > 0) {
				BirdFontPath* _tmp14_;
				_tmp14_ = p;
				if (bird_font_glyph_process_deleted_points_in_path (self, _tmp14_)) {
					result = TRUE;
					_g_object_unref0 (p);
					_g_object_unref0 (_p_list);
					_g_object_unref0 (deleted_paths);
					return result;
				}
			} else {
				GeeArrayList* _tmp15_;
				BirdFontPath* _tmp16_;
				_tmp15_ = deleted_paths;
				_tmp16_ = p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp17_;
		gint _p_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _p_index = 0;
		_tmp17_ = deleted_paths;
		_p_list = _tmp17_;
		_tmp18_ = _p_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_p_size = _tmp20_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp23_;
			gpointer _tmp24_;
			BirdFontPath* _tmp25_;
			_p_index = _p_index + 1;
			_tmp21_ = _p_index;
			_tmp22_ = _p_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _p_list;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _p_index);
			p = (BirdFontPath*) _tmp24_;
			_tmp25_ = p;
			bird_font_glyph_delete_path (self, _tmp25_);
			_g_object_unref0 (p);
		}
	}
	result = FALSE;
	_g_object_unref0 (deleted_paths);
	return result;
}

static gboolean
bird_font_glyph_process_deleted_points_in_path (BirdFontGlyph* self,
                                                BirdFontPath* p)
{
	BirdFontPathList* remaining_points = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = bird_font_path_process_deleted_points (p);
	_g_object_unref0 (remaining_points);
	remaining_points = _tmp0_;
	{
		GeeArrayList* _path_list = NULL;
		BirdFontPathList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _path_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _path_index = 0;
		_tmp1_ = remaining_points;
		_tmp2_ = _tmp1_->paths;
		_path_list = _tmp2_;
		_tmp3_ = _path_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_path_size = _tmp5_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			BirdFontPath* _tmp11_;
			BirdFontPath* _tmp12_;
			BirdFontPath* _tmp13_;
			_path_index = _path_index + 1;
			_tmp6_ = _path_index;
			_tmp7_ = _path_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _path_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _path_index);
			path = (BirdFontPath*) _tmp9_;
			_tmp10_ = path;
			bird_font_glyph_add_path (self, _tmp10_);
			_tmp11_ = path;
			bird_font_path_reopen (_tmp11_);
			_tmp12_ = path;
			bird_font_path_create_list (_tmp12_);
			_tmp13_ = path;
			bird_font_glyph_add_active_path (self, NULL, _tmp13_);
			_g_object_unref0 (path);
		}
	}
	_tmp14_ = remaining_points;
	_tmp15_ = _tmp14_->paths;
	_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > 0) {
		bird_font_glyph_delete_path (self, p);
		result = TRUE;
		_g_object_unref0 (remaining_points);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (remaining_points);
	return result;
}

static void
bird_font_glyph_real_motion_notify (BirdFontFontDisplay* base,
                                    gdouble x,
                                    gdouble y)
{
	BirdFontGlyph * self;
	BirdFontTool* t = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* _tmp3_;
	BirdFontTool* _tmp4_;
	BirdFontTool* _tmp5_;
	self = (BirdFontGlyph*) base;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_toolbox_get_current_tool (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	t = _tmp3_;
	if (self->priv->view_is_moving) {
		bird_font_glyph_move_view_offset (self, x, y);
		_g_object_unref0 (t);
		return;
	}
	bird_font_glyph_help_line_event (self, (gint) x, (gint) y);
	_tmp4_ = t;
	_tmp5_ = t;
	g_signal_emit_by_name (_tmp4_, "move-action", _tmp5_, (gint) x, (gint) y);
	self->motion_x = ((x * bird_font_glyph_ivz ()) - bird_font_glyph_xc ()) + self->view_offset_x;
	self->motion_y = (bird_font_glyph_yc () - (y * bird_font_glyph_ivz ())) - self->view_offset_y;
	_g_object_unref0 (t);
}

static void
bird_font_glyph_real_button_release (BirdFontFontDisplay* base,
                                     gint button,
                                     gdouble ex,
                                     gdouble ey)
{
	BirdFontGlyph * self;
	gboolean line_moving = FALSE;
	self = (BirdFontGlyph*) base;
	line_moving = FALSE;
	self->priv->view_is_moving = FALSE;
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp0_;
		gint _line_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _line_index = 0;
		_tmp0_ = bird_font_glyph_get_all_help_lines (self);
		_line_list = _tmp0_;
		_tmp1_ = _line_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_line_size = _tmp3_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontLine* _tmp8_;
			_line_index = _line_index + 1;
			_tmp4_ = _line_index;
			_tmp5_ = _line_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _line_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _line_index);
			line = (BirdFontLine*) _tmp7_;
			_tmp8_ = line;
			if (!bird_font_line_set_move (_tmp8_, FALSE)) {
				line_moving = TRUE;
			}
			_g_object_unref0 (line);
		}
		_g_object_unref0 (_line_list);
	}
	if (!line_moving) {
		BirdFontTool* t = NULL;
		BirdFontToolbox* _tmp9_;
		BirdFontToolbox* _tmp10_;
		BirdFontTool* _tmp11_;
		BirdFontTool* _tmp12_;
		BirdFontTool* _tmp13_;
		BirdFontTool* _tmp14_;
		_tmp9_ = bird_font_main_window_get_toolbox ();
		_tmp10_ = _tmp9_;
		_tmp11_ = bird_font_toolbox_get_current_tool (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		t = _tmp12_;
		_tmp13_ = t;
		_tmp14_ = t;
		g_signal_emit_by_name (_tmp13_, "release-action", _tmp14_, (gint) button, (gint) ex, (gint) ey);
		_g_object_unref0 (t);
	}
	bird_font_glyph_update_view (self);
}

static GeeArrayList*
bird_font_glyph_get_all_help_lines (BirdFontGlyph* self)
{
	GeeArrayList* all_lines = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_LINE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_lines = _tmp0_;
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp1_;
		gint _l_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _l_index = 0;
		_tmp1_ = self->vertical_help_lines;
		_l_list = _tmp1_;
		_tmp2_ = _l_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_l_size = _tmp4_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontLine* l = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			GeeArrayList* _tmp9_;
			BirdFontLine* _tmp10_;
			_l_index = _l_index + 1;
			_tmp5_ = _l_index;
			_tmp6_ = _l_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _l_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _l_index);
			l = (BirdFontLine*) _tmp8_;
			_tmp9_ = all_lines;
			_tmp10_ = l;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
			_g_object_unref0 (l);
		}
	}
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp11_;
		gint _l_size = 0;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _l_index = 0;
		_tmp11_ = self->horizontal_help_lines;
		_l_list = _tmp11_;
		_tmp12_ = _l_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_l_size = _tmp14_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			BirdFontLine* l = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			GeeArrayList* _tmp19_;
			BirdFontLine* _tmp20_;
			_l_index = _l_index + 1;
			_tmp15_ = _l_index;
			_tmp16_ = _l_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _l_list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _l_index);
			l = (BirdFontLine*) _tmp18_;
			_tmp19_ = all_lines;
			_tmp20_ = l;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
			_g_object_unref0 (l);
		}
	}
	if (bird_font_grid_tool_is_visible ()) {
		{
			GeeArrayList* _l_list = NULL;
			GeeArrayList* _tmp21_;
			gint _l_size = 0;
			GeeArrayList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _l_index = 0;
			_tmp21_ = bird_font_grid_tool_get_vertical_lines ();
			_l_list = _tmp21_;
			_tmp22_ = _l_list;
			_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			_l_size = _tmp24_;
			_l_index = -1;
			while (TRUE) {
				gint _tmp25_;
				gint _tmp26_;
				BirdFontLine* l = NULL;
				GeeArrayList* _tmp27_;
				gpointer _tmp28_;
				GeeArrayList* _tmp29_;
				BirdFontLine* _tmp30_;
				_l_index = _l_index + 1;
				_tmp25_ = _l_index;
				_tmp26_ = _l_size;
				if (!(_tmp25_ < _tmp26_)) {
					break;
				}
				_tmp27_ = _l_list;
				_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _l_index);
				l = (BirdFontLine*) _tmp28_;
				_tmp29_ = all_lines;
				_tmp30_ = l;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp30_);
				_g_object_unref0 (l);
			}
			_g_object_unref0 (_l_list);
		}
		{
			GeeArrayList* _l_list = NULL;
			GeeArrayList* _tmp31_;
			gint _l_size = 0;
			GeeArrayList* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint _l_index = 0;
			_tmp31_ = bird_font_grid_tool_get_horizontal_lines ();
			_l_list = _tmp31_;
			_tmp32_ = _l_list;
			_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
			_tmp34_ = _tmp33_;
			_l_size = _tmp34_;
			_l_index = -1;
			while (TRUE) {
				gint _tmp35_;
				gint _tmp36_;
				BirdFontLine* l = NULL;
				GeeArrayList* _tmp37_;
				gpointer _tmp38_;
				GeeArrayList* _tmp39_;
				BirdFontLine* _tmp40_;
				_l_index = _l_index + 1;
				_tmp35_ = _l_index;
				_tmp36_ = _l_size;
				if (!(_tmp35_ < _tmp36_)) {
					break;
				}
				_tmp37_ = _l_list;
				_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _l_index);
				l = (BirdFontLine*) _tmp38_;
				_tmp39_ = all_lines;
				_tmp40_ = l;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
				_g_object_unref0 (l);
			}
			_g_object_unref0 (_l_list);
		}
	}
	result = all_lines;
	return result;
}

void
bird_font_glyph_update_view (BirdFontGlyph* self)
{
	g_return_if_fail (self != NULL);
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_glyph_real_double_click (BirdFontFontDisplay* base,
                                   guint button,
                                   gdouble ex,
                                   gdouble ey)
{
	BirdFontGlyph * self;
	BirdFontTool* t = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* _tmp3_;
	self = (BirdFontGlyph*) base;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_toolbox_get_current_tool (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	t = _tmp3_;
	g_signal_emit_by_name (t, "double-click-action", t, (gint) button, (gint) ex, (gint) ey);
	_g_object_unref0 (t);
}

static void
bird_font_glyph_real_button_press (BirdFontFontDisplay* base,
                                   guint button,
                                   gdouble ex,
                                   gdouble ey)
{
	BirdFontGlyph * self;
	gboolean moving_lines = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	self = (BirdFontGlyph*) base;
	moving_lines = FALSE;
	self->priv->pointer_begin_x = ex;
	self->priv->pointer_begin_y = ey;
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp0_;
		gint _line_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _line_index = 0;
		_tmp0_ = self->horizontal_help_lines;
		_line_list = _tmp0_;
		_tmp1_ = _line_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_line_size = _tmp3_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			_line_index = _line_index + 1;
			_tmp4_ = _line_index;
			_tmp5_ = _line_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _line_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _line_index);
			line = (BirdFontLine*) _tmp7_;
			if (!moving_lines) {
				BirdFontLine* _tmp10_;
				_tmp10_ = line;
				_tmp9_ = bird_font_line_is_visible (_tmp10_);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				BirdFontLine* _tmp11_;
				_tmp11_ = line;
				_tmp8_ = bird_font_line_button_press (_tmp11_, button);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				moving_lines = TRUE;
			}
			_g_object_unref0 (line);
		}
	}
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp12_;
		gint _line_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _line_index = 0;
		_tmp12_ = self->vertical_help_lines;
		_line_list = _tmp12_;
		_tmp13_ = _line_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_line_size = _tmp15_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			_line_index = _line_index + 1;
			_tmp16_ = _line_index;
			_tmp17_ = _line_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _line_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _line_index);
			line = (BirdFontLine*) _tmp19_;
			if (!moving_lines) {
				BirdFontLine* _tmp22_;
				_tmp22_ = line;
				_tmp21_ = bird_font_line_is_visible (_tmp22_);
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				BirdFontLine* _tmp23_;
				_tmp23_ = line;
				_tmp20_ = bird_font_line_button_press (_tmp23_, button);
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				moving_lines = TRUE;
			}
			_g_object_unref0 (line);
		}
	}
	if (moving_lines) {
		return;
	}
	if (self->priv->move_canvas) {
		_tmp25_ = TRUE;
	} else {
		BirdFontTool* _tmp26_;
		_tmp26_ = bird_font_drawing_tools_move_canvas;
		_tmp25_ = bird_font_tool_is_selected (_tmp26_);
	}
	if (_tmp25_) {
		_tmp24_ = TRUE;
	} else {
		gboolean _tmp27_ = FALSE;
		if (bird_font_key_bindings_has_ctrl ()) {
			_tmp27_ = bird_font_key_bindings_has_shift ();
		} else {
			_tmp27_ = FALSE;
		}
		_tmp24_ = _tmp27_;
	}
	if (_tmp24_) {
		self->priv->view_is_moving = TRUE;
		self->move_offset_x = self->view_offset_x;
		self->move_offset_y = self->view_offset_y;
	} else {
		BirdFontTool* t = NULL;
		BirdFontToolbox* _tmp28_;
		BirdFontToolbox* _tmp29_;
		BirdFontTool* _tmp30_;
		BirdFontTool* _tmp31_;
		BirdFontTool* _tmp32_;
		BirdFontTool* _tmp33_;
		_tmp28_ = bird_font_main_window_get_toolbox ();
		_tmp29_ = _tmp28_;
		_tmp30_ = bird_font_toolbox_get_current_tool (_tmp29_);
		_tmp31_ = _tmp30_;
		_g_object_unref0 (_tmp29_);
		t = _tmp31_;
		_tmp32_ = t;
		_tmp33_ = t;
		g_signal_emit_by_name (_tmp32_, "press-action", _tmp33_, (gint) button, (gint) ex, (gint) ey);
		_g_object_unref0 (t);
	}
}

/** Add new points to this path. */
void
bird_font_glyph_set_active_path (BirdFontGlyph* self,
                                 BirdFontPath* p)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	bird_font_path_reopen (p);
	bird_font_glyph_clear_active_paths (self);
	bird_font_glyph_add_active_path (self, NULL, p);
}

/** Move view port centrum to this coordinate. */
void
bird_font_glyph_set_center (BirdFontGlyph* self,
                            gdouble x,
                            gdouble y)
{
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->allocation;
	x = x - (_tmp0_->width / 2.0);
	_tmp1_ = self->allocation;
	y = y - (_tmp1_->height / 2.0);
	self->view_offset_x = self->view_offset_x + (x / self->view_zoom);
	self->view_offset_y = self->view_offset_y + (y / self->view_zoom);
}

void
bird_font_glyph_set_zoom_from_area (BirdFontGlyph* self)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble view_zoom_x = 0.0;
	gdouble view_zoom_y = 0.0;
	gdouble ivz = 0.0;
	gdouble off = 0.0;
	g_return_if_fail (self != NULL);
	x = fmin (self->zoom_x1, self->zoom_x2);
	y = fmin (self->zoom_y1, self->zoom_y2);
	w = fabs (self->zoom_x1 - self->zoom_x2);
	h = fabs (self->zoom_y1 - self->zoom_y2);
	if (self->priv->move_canvas) {
		return;
	}
	if (bird_font_path_distance (x, x + w, y, y + h) < ((gdouble) 7)) {
		bird_font_font_display_zoom_in ((BirdFontFontDisplay*) self);
	} else {
		gboolean _tmp0_ = FALSE;
		BirdFontWidgetAllocation* _tmp1_;
		BirdFontWidgetAllocation* _tmp3_;
		BirdFontWidgetAllocation* _tmp4_;
		BirdFontWidgetAllocation* _tmp5_;
		BirdFontWidgetAllocation* _tmp6_;
		self->view_offset_x = self->view_offset_x + (x / self->view_zoom);
		self->view_offset_y = self->view_offset_y + (y / self->view_zoom);
		_tmp1_ = self->allocation;
		if (_tmp1_->width == 0) {
			_tmp0_ = TRUE;
		} else {
			BirdFontWidgetAllocation* _tmp2_;
			_tmp2_ = self->allocation;
			_tmp0_ = _tmp2_->height == 0;
		}
		if (G_UNLIKELY (_tmp0_)) {
			return;
		}
		_tmp3_ = self->allocation;
		view_zoom_x = (_tmp3_->width * self->view_zoom) / w;
		_tmp4_ = self->allocation;
		view_zoom_y = (_tmp4_->height * self->view_zoom) / h;
		_tmp5_ = self->allocation;
		_tmp6_ = self->allocation;
		if ((view_zoom_x * _tmp5_->width) < (view_zoom_y * _tmp6_->height)) {
			BirdFontWidgetAllocation* _tmp7_;
			BirdFontWidgetAllocation* _tmp8_;
			self->view_zoom = view_zoom_x;
			ivz = 1 / self->view_zoom;
			_tmp7_ = self->allocation;
			off = ((self->view_zoom / view_zoom_y) * _tmp7_->height) / self->view_zoom;
			_tmp8_ = self->allocation;
			off = (_tmp8_->height / self->view_zoom) - off;
			off /= (gdouble) 2;
			self->view_offset_y = self->view_offset_y - off;
		} else {
			BirdFontWidgetAllocation* _tmp9_;
			BirdFontWidgetAllocation* _tmp10_;
			self->view_zoom = view_zoom_y;
			ivz = 1 / self->view_zoom;
			_tmp9_ = self->allocation;
			off = ((self->view_zoom / view_zoom_x) * _tmp9_->width) / self->view_zoom;
			_tmp10_ = self->allocation;
			off = (_tmp10_->width / self->view_zoom) - off;
			off /= (gdouble) 2;
			self->view_offset_x = self->view_offset_x - off;
		}
		self->zoom_area_is_visible = FALSE;
		bird_font_font_display_store_current_view ((BirdFontFontDisplay*) self);
	}
	bird_font_glyph_update_zoom_bar (self);
}

void
bird_font_glyph_show_zoom_area (BirdFontGlyph* self,
                                gint sx,
                                gint sy,
                                gint nx,
                                gint ny)
{
	g_return_if_fail (self != NULL);
	bird_font_glyph_set_zoom_area (self, sx, sy, nx, ny);
	self->zoom_area_is_visible = TRUE;
	bird_font_glyph_canvas_redraw ();
}

void
bird_font_glyph_set_zoom_area (BirdFontGlyph* self,
                               gint sx,
                               gint sy,
                               gint nx,
                               gint ny)
{
	g_return_if_fail (self != NULL);
	self->zoom_x1 = (gdouble) sx;
	self->zoom_y1 = (gdouble) sy;
	self->zoom_x2 = (gdouble) nx;
	self->zoom_y2 = (gdouble) ny;
}

void
bird_font_glyph_validate_zoom (void)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = g;
	if (G_UNLIKELY (_tmp1_->view_zoom == ((gdouble) 0))) {
		BirdFontGlyph* _tmp2_;
		BirdFontGlyph* _tmp3_;
		g_warning ("Glyph.vala:1089: Zoom is zero.");
		_tmp2_ = g;
		bird_font_font_display_reset_zoom ((BirdFontFontDisplay*) _tmp2_);
		_tmp3_ = g;
		if (_tmp3_->view_zoom == ((gdouble) 0)) {
			BirdFontGlyph* _tmp4_;
			BirdFontGlyph* _tmp5_;
			BirdFontGlyph* _tmp6_;
			_tmp4_ = g;
			_tmp4_->view_zoom = (gdouble) 1;
			_tmp5_ = g;
			_tmp5_->view_offset_x = (gdouble) 0;
			_tmp6_ = g;
			_tmp6_->view_offset_y = (gdouble) 0;
		}
	}
	_g_object_unref0 (g);
}

gdouble
bird_font_glyph_path_coordinate_x (gdouble x)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	bird_font_glyph_validate_zoom ();
	result = ((x * bird_font_glyph_ivz ()) - bird_font_glyph_xc ()) + g->view_offset_x;
	_g_object_unref0 (g);
	return result;
}

gint
bird_font_glyph_reverse_path_coordinate_x (gdouble x)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gint result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	bird_font_glyph_validate_zoom ();
	result = (gint) rint (((x - g->view_offset_x) + bird_font_glyph_xc ()) * g->view_zoom);
	_g_object_unref0 (g);
	return result;
}

gdouble
bird_font_glyph_precise_reverse_path_coordinate_x (gdouble x)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	bird_font_glyph_validate_zoom ();
	result = ((x - g->view_offset_x) + bird_font_glyph_xc ()) * g->view_zoom;
	_g_object_unref0 (g);
	return result;
}

gdouble
bird_font_glyph_path_coordinate_y (gdouble y)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	bird_font_glyph_validate_zoom ();
	result = (bird_font_glyph_yc () - (y * bird_font_glyph_ivz ())) - g->view_offset_y;
	_g_object_unref0 (g);
	return result;
}

gint
bird_font_glyph_reverse_path_coordinate_y (gdouble y)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gint result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	bird_font_glyph_validate_zoom ();
	y = rint (((y + g->view_offset_y) - bird_font_glyph_yc ()) * g->view_zoom);
	result = (gint) (-y);
	_g_object_unref0 (g);
	return result;
}

gdouble
bird_font_glyph_precise_reverse_path_coordinate_y (gdouble y)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	bird_font_glyph_validate_zoom ();
	y = ((y + g->view_offset_y) - bird_font_glyph_yc ()) * g->view_zoom;
	result = -y;
	_g_object_unref0 (g);
	return result;
}

BirdFontLayer*
bird_font_glyph_get_path_at (BirdFontGlyph* self,
                             gdouble x,
                             gdouble y)
{
	BirdFontLayer* group = NULL;
	gboolean found = FALSE;
	GeeArrayList* subgroups = NULL;
	BirdFontLayer* _tmp0_;
	BirdFontLayer* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	BirdFontLayer* result;
	g_return_val_if_fail (self != NULL, NULL);
	group = NULL;
	found = FALSE;
	_tmp0_ = bird_font_glyph_get_current_layer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->subgroups;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	subgroups = _tmp4_;
	_tmp5_ = subgroups;
	if (bird_font_is_null (_tmp5_)) {
		g_warning ("Glyph.vala:1145: Expecting a sub group.");
		result = NULL;
		_g_object_unref0 (subgroups);
		_g_object_unref0 (group);
		return result;
	}
	{
		GeeArrayList* _layer_list = NULL;
		GeeArrayList* _tmp6_;
		gint _layer_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _layer_index = 0;
		_tmp6_ = subgroups;
		_layer_list = _tmp6_;
		_tmp7_ = _layer_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_layer_size = _tmp9_;
		_layer_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontLayer* layer = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			_layer_index = _layer_index + 1;
			_tmp10_ = _layer_index;
			_tmp11_ = _layer_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _layer_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _layer_index);
			layer = (BirdFontLayer*) _tmp13_;
			{
				GeeArrayList* _pt_list = NULL;
				BirdFontLayer* _tmp14_;
				BirdFontPathList* _tmp15_;
				GeeArrayList* _tmp16_;
				gint _pt_size = 0;
				GeeArrayList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _pt_index = 0;
				_tmp14_ = layer;
				_tmp15_ = _tmp14_->paths;
				_tmp16_ = _tmp15_->paths;
				_pt_list = _tmp16_;
				_tmp17_ = _pt_list;
				_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
				_tmp19_ = _tmp18_;
				_pt_size = _tmp19_;
				_pt_index = -1;
				while (TRUE) {
					gint _tmp20_;
					gint _tmp21_;
					BirdFontPath* pt = NULL;
					GeeArrayList* _tmp22_;
					gpointer _tmp23_;
					BirdFontPath* _tmp24_;
					_pt_index = _pt_index + 1;
					_tmp20_ = _pt_index;
					_tmp21_ = _pt_size;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = _pt_list;
					_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _pt_index);
					pt = (BirdFontPath*) _tmp23_;
					_tmp24_ = pt;
					if (bird_font_path_is_over (_tmp24_, x, y)) {
						BirdFontLayer* _tmp25_;
						BirdFontLayer* _tmp26_;
						found = TRUE;
						_tmp25_ = layer;
						_tmp26_ = _g_object_ref0 (_tmp25_);
						_g_object_unref0 (group);
						group = _tmp26_;
					}
					_g_object_unref0 (pt);
				}
			}
			_g_object_unref0 (layer);
		}
	}
	if (!found) {
		GeeArrayList* current_layer_paths = NULL;
		GeeArrayList* _tmp27_;
		GeeArrayList* _tmp28_;
		_tmp27_ = bird_font_glyph_get_paths_in_current_layer (self);
		current_layer_paths = _tmp27_;
		_tmp28_ = current_layer_paths;
		if (bird_font_is_null (_tmp28_)) {
			g_warning ("Glyph.vala:1162: Expecting current_layer_paths.");
			result = NULL;
			_g_object_unref0 (current_layer_paths);
			_g_object_unref0 (subgroups);
			_g_object_unref0 (group);
			return result;
		}
		{
			GeeArrayList* _pt_list = NULL;
			GeeArrayList* _tmp29_;
			gint _pt_size = 0;
			GeeArrayList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _pt_index = 0;
			_tmp29_ = current_layer_paths;
			_pt_list = _tmp29_;
			_tmp30_ = _pt_list;
			_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			_pt_size = _tmp32_;
			_pt_index = -1;
			while (TRUE) {
				gint _tmp33_;
				gint _tmp34_;
				BirdFontPath* pt = NULL;
				GeeArrayList* _tmp35_;
				gpointer _tmp36_;
				BirdFontPath* _tmp37_;
				_pt_index = _pt_index + 1;
				_tmp33_ = _pt_index;
				_tmp34_ = _pt_size;
				if (!(_tmp33_ < _tmp34_)) {
					break;
				}
				_tmp35_ = _pt_list;
				_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _pt_index);
				pt = (BirdFontPath*) _tmp36_;
				_tmp37_ = pt;
				if (bird_font_path_is_over (_tmp37_, x, y)) {
					BirdFontLayer* layer = NULL;
					BirdFontLayer* _tmp38_;
					BirdFontLayer* _tmp39_;
					BirdFontLayer* _tmp40_;
					BirdFontLayer* _tmp41_;
					BirdFontPath* _tmp42_;
					BirdFontLayer* _tmp43_;
					BirdFontLayer* _tmp44_;
					_tmp38_ = bird_font_layer_new ();
					layer = _tmp38_;
					_tmp39_ = layer;
					_tmp39_->is_counter = TRUE;
					_tmp40_ = layer;
					_tmp40_->single_path = TRUE;
					_tmp41_ = layer;
					_tmp42_ = pt;
					bird_font_layer_add_path (_tmp41_, _tmp42_);
					_tmp43_ = layer;
					_tmp44_ = _g_object_ref0 (_tmp43_);
					_g_object_unref0 (group);
					group = _tmp44_;
					_g_object_unref0 (layer);
				}
				_g_object_unref0 (pt);
			}
		}
		_g_object_unref0 (current_layer_paths);
	}
	result = group;
	_g_object_unref0 (subgroups);
	return result;
}

gboolean
bird_font_glyph_select_path (BirdFontGlyph* self,
                             gdouble x,
                             gdouble y)
{
	BirdFontPath* p = NULL;
	gboolean found = FALSE;
	BirdFontPath* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	p = NULL;
	found = FALSE;
	{
		GeeArrayList* _pt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _pt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _pt_index = 0;
		_tmp0_ = bird_font_glyph_get_paths_in_current_layer (self);
		_pt_list = _tmp0_;
		_tmp1_ = _pt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_pt_size = _tmp3_;
		_pt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* pt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			_pt_index = _pt_index + 1;
			_tmp4_ = _pt_index;
			_tmp5_ = _pt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _pt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _pt_index);
			pt = (BirdFontPath*) _tmp7_;
			_tmp8_ = pt;
			if (bird_font_path_is_over (_tmp8_, x, y)) {
				BirdFontPath* _tmp9_;
				BirdFontPath* _tmp10_;
				_tmp9_ = pt;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				_g_object_unref0 (p);
				p = _tmp10_;
				found = TRUE;
			}
			_g_object_unref0 (pt);
		}
		_g_object_unref0 (_pt_list);
	}
	if (!bird_font_key_bindings_has_shift ()) {
		bird_font_glyph_clear_active_paths (self);
	}
	_tmp11_ = p;
	bird_font_glyph_add_active_path (self, NULL, _tmp11_);
	result = found;
	_g_object_unref0 (p);
	return result;
}

gboolean
bird_font_glyph_is_over_selected_path (BirdFontGlyph* self,
                                       gdouble x,
                                       gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _pt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _pt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _pt_index = 0;
		_tmp0_ = self->active_paths;
		_pt_list = _tmp0_;
		_tmp1_ = _pt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_pt_size = _tmp3_;
		_pt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* pt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			_pt_index = _pt_index + 1;
			_tmp4_ = _pt_index;
			_tmp5_ = _pt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _pt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _pt_index);
			pt = (BirdFontPath*) _tmp7_;
			_tmp8_ = pt;
			if (bird_font_path_is_over (_tmp8_, x, y)) {
				result = TRUE;
				_g_object_unref0 (pt);
				return result;
			}
			_g_object_unref0 (pt);
		}
	}
	result = FALSE;
	return result;
}

void
bird_font_glyph_queue_redraw_path (BirdFontGlyph* self,
                                   BirdFontPath* path)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	bird_font_glyph_redraw_path (self, path->xmin, path->ymin, path->xmax, path->ymax);
}

static void
bird_font_glyph_redraw_path (BirdFontGlyph* self,
                             gdouble xmin,
                             gdouble ymin,
                             gdouble xmax,
                             gdouble ymax)
{
	gint yc = 0;
	BirdFontWidgetAllocation* _tmp0_;
	gdouble yta = 0.0;
	gdouble ytb = 0.0;
	gdouble xta = 0.0;
	gdouble xtb = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->allocation;
	yc = (gint) (_tmp0_->height / 2.0);
	yta = (yc - ymin) - self->view_offset_y;
	ytb = (yc - ymax) - self->view_offset_y;
	xta = (-self->view_offset_x) - xmin;
	xtb = (-self->view_offset_x) - xmax;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) (((gint) xtb) - 10), (gdouble) (((gint) yta) - 10), (gdouble) (((gint) (xtb - xta)) + 10), (gdouble) (((gint) (yta - ytb)) + 10));
}

BirdFontPath*
bird_font_glyph_get_closeset_path (BirdFontGlyph* self,
                                   gdouble x,
                                   gdouble y)
{
	gdouble d = 0.0;
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* _tmp0_;
	BirdFontPath* min_point = NULL;
	BirdFontPath* _tmp1_;
	gdouble min_distance = 0.0;
	gdouble xt = 0.0;
	gdouble yt = 0.0;
	GeeArrayList* paths = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	ep = _tmp0_;
	_tmp1_ = bird_font_path_new ();
	min_point = _tmp1_;
	min_distance = DBL_MAX;
	xt = bird_font_glyph_path_coordinate_x (x);
	yt = bird_font_glyph_path_coordinate_y (y);
	_tmp2_ = bird_font_glyph_get_visible_paths (self);
	paths = _tmp2_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp3_;
		gint _p_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp3_ = paths;
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontPath* _tmp11_;
			_p_index = _p_index + 1;
			_tmp7_ = _p_index;
			_tmp8_ = _p_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _p_index);
			p = (BirdFontPath*) _tmp10_;
			_tmp11_ = p;
			if (bird_font_path_is_over (_tmp11_, xt, yt)) {
				result = p;
				_g_object_unref0 (paths);
				_g_object_unref0 (min_point);
				_g_object_unref0 (ep);
				return result;
			}
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp12_;
		gint _p_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = paths;
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			BirdFontPath* _tmp20_;
			GeeArrayList* _tmp21_;
			GeeArrayList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			BirdFontPath* _tmp25_;
			BirdFontEditPoint* _tmp26_;
			BirdFontEditPoint* _tmp27_;
			BirdFontEditPoint* _tmp28_;
			_p_index = _p_index + 1;
			_tmp16_ = _p_index;
			_tmp17_ = _p_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _p_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _p_index);
			p = (BirdFontPath*) _tmp19_;
			_tmp20_ = p;
			_tmp21_ = bird_font_path_get_points (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_ == 0) {
				_g_object_unref0 (p);
				continue;
			}
			_tmp25_ = p;
			_tmp26_ = ep;
			bird_font_path_get_closest_point_on_path (_tmp25_, _tmp26_, xt, yt, NULL, NULL, -1);
			_tmp27_ = ep;
			_tmp28_ = ep;
			d = pow (_tmp27_->x - xt, (gdouble) 2) + pow (_tmp28_->y - yt, (gdouble) 2);
			if (d < min_distance) {
				BirdFontPath* _tmp29_;
				BirdFontPath* _tmp30_;
				min_distance = d;
				_tmp29_ = p;
				_tmp30_ = _g_object_ref0 (_tmp29_);
				_g_object_unref0 (min_point);
				min_point = _tmp30_;
			}
			_g_object_unref0 (p);
		}
	}
	_tmp31_ = paths;
	_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > 0) {
		GeeArrayList* _tmp34_;
		gpointer _tmp35_;
		_tmp34_ = paths;
		_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, 0);
		result = (BirdFontPath*) _tmp35_;
		_g_object_unref0 (paths);
		_g_object_unref0 (min_point);
		_g_object_unref0 (ep);
		return result;
	}
	if (G_UNLIKELY (min_distance == DBL_MAX)) {
		g_warning ("Glyph.vala:1261: %s", "No path found in path_list.");
	}
	result = min_point;
	_g_object_unref0 (paths);
	_g_object_unref0 (ep);
	return result;
}

void
bird_font_glyph_move_selected_edit_point_coordinates (BirdFontGlyph* self,
                                                      BirdFontEditPoint* selected_point,
                                                      gdouble xt,
                                                      gdouble yt)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selected_point != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	bird_font_font_touch (_tmp1_);
	_g_object_unref0 (_tmp1_);
	x = (gdouble) bird_font_glyph_reverse_path_coordinate_x (xt);
	y = (gdouble) bird_font_glyph_reverse_path_coordinate_y (yt);
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) ((gint) (x - (4 * self->view_zoom))), (gdouble) ((gint) (y - (4 * self->view_zoom))), (gdouble) ((gint) (x + (3 * self->view_zoom))), (gdouble) ((gint) (y + (3 * self->view_zoom))));
	bird_font_edit_point_set_position (selected_point, xt, yt);
	if (self->view_zoom >= ((gdouble) 2)) {
		BirdFontWidgetAllocation* _tmp2_;
		BirdFontWidgetAllocation* _tmp3_;
		_tmp2_ = self->allocation;
		_tmp3_ = self->allocation;
		g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) 0, (gdouble) 0, (gdouble) _tmp2_->width, (gdouble) _tmp3_->height);
	} else {
		bird_font_glyph_redraw_last_stroke (self, x, y);
	}
}

void
bird_font_glyph_move_selected_edit_point (BirdFontGlyph* self,
                                          BirdFontEditPoint* selected_point,
                                          gdouble x,
                                          gdouble y)
{
	gdouble xt = 0.0;
	gdouble yt = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selected_point != NULL);
	xt = bird_font_glyph_path_coordinate_x (x);
	yt = bird_font_glyph_path_coordinate_y (y);
	bird_font_glyph_move_selected_edit_point_coordinates (self, selected_point, xt, yt);
}

void
bird_font_glyph_redraw_segment (BirdFontGlyph* self,
                                BirdFontEditPoint* a,
                                BirdFontEditPoint* b)
{
	gdouble margin = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	margin = (gdouble) 10;
	x = fmin ((gdouble) bird_font_glyph_reverse_path_coordinate_x (a->x), (gdouble) bird_font_glyph_reverse_path_coordinate_x (b->x)) - margin;
	y = fmin ((gdouble) bird_font_glyph_reverse_path_coordinate_y (a->y), (gdouble) bird_font_glyph_reverse_path_coordinate_y (b->y)) - margin;
	w = fabs ((gdouble) (bird_font_glyph_reverse_path_coordinate_x (a->x) - bird_font_glyph_reverse_path_coordinate_x (b->x))) + (2 * margin);
	h = fabs ((gdouble) (bird_font_glyph_reverse_path_coordinate_y (a->y) - bird_font_glyph_reverse_path_coordinate_y (b->y))) + (2 * margin);
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) ((gint) x), (gdouble) ((gint) y), (gdouble) ((gint) w), (gdouble) ((gint) h));
}

static void
bird_font_glyph_redraw_last_stroke (BirdFontGlyph* self,
                                    gdouble x,
                                    gdouble y)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	gint tw = 0;
	gint th = 0;
	gdouble xc = 0.0;
	BirdFontWidgetAllocation* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	px = (gdouble) 0;
	py = (gdouble) 0;
	tw = 0;
	th = 0;
	_tmp0_ = self->allocation;
	xc = _tmp0_->width / 2.0;
	_tmp1_ = self->active_paths;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		return;
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp4_;
		gint _path_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _path_index = 0;
		_tmp4_ = self->active_paths;
		_path_list = _tmp4_;
		_tmp5_ = _path_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_path_size = _tmp7_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			BirdFontEditPoint* p = NULL;
			BirdFontEditPoint* pl = NULL;
			BirdFontPath* _tmp12_;
			BirdFontEditPoint* _tmp13_;
			BirdFontEditPoint* _tmp14_;
			BirdFontEditPoint* _tmp15_;
			_path_index = _path_index + 1;
			_tmp8_ = _path_index;
			_tmp9_ = _path_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _path_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _path_index);
			path = (BirdFontPath*) _tmp11_;
			_tmp12_ = path;
			_tmp13_ = bird_font_path_get_last_point (_tmp12_);
			pl = _tmp13_;
			_tmp14_ = pl;
			_tmp15_ = _tmp14_->prev;
			if (_tmp15_ != NULL) {
				BirdFontEditPoint* _tmp16_;
				BirdFontEditPoint* _tmp17_;
				BirdFontEditPoint* _tmp18_;
				BirdFontEditPoint* _tmp19_;
				BirdFontEditPoint* _tmp20_;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				_tmp16_ = pl;
				_tmp17_ = bird_font_edit_point_get_prev (_tmp16_);
				_tmp18_ = _g_object_ref0 (_tmp17_);
				_g_object_unref0 (p);
				p = _tmp18_;
				_tmp19_ = p;
				px = _tmp19_->x + xc;
				_tmp20_ = p;
				py = _tmp20_->y - xc;
				if (px > x) {
					_tmp21_ = (gint) (px - x);
				} else {
					_tmp21_ = (gint) (x - px);
				}
				tw = _tmp21_;
				if (py > y) {
					_tmp22_ = (gint) (py - y);
				} else {
					_tmp22_ = (gint) (y - py);
				}
				th = _tmp22_;
				if (px > x) {
					px -= (gdouble) (tw + 60);
				}
				if (py > y) {
					py -= (gdouble) (th + 60);
				}
			} else {
				px = x - 60;
				py = y - 60;
				tw = 0;
				th = 0;
			}
			_g_object_unref0 (pl);
			_g_object_unref0 (p);
			_g_object_unref0 (path);
		}
	}
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) (((gint) px) - 20), (gdouble) (((gint) py) - 20), (gdouble) (tw + 120), (gdouble) (th + 120));
}

gboolean
bird_font_glyph_has_active_path (BirdFontGlyph* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->active_paths;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

gboolean
bird_font_glyph_is_open (BirdFontGlyph* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->open;
	return result;
}

/** Close all editable paths and return false if no path have been closed. */
gboolean
bird_font_glyph_close_path (BirdFontGlyph* self)
{
	gboolean r = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	r = FALSE;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = bird_font_glyph_get_all_paths (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			_tmp8_ = p;
			if (bird_font_path_is_editable (_tmp8_)) {
				BirdFontPath* _tmp9_;
				r = TRUE;
				_tmp9_ = p;
				bird_font_path_set_editable (_tmp9_, FALSE);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	self->priv->open = FALSE;
	bird_font_glyph_clear_active_paths (self);
	bird_font_glyph_canvas_redraw ();
	bird_font_main_window_set_cursor (BIRD_FONT_NATIVE_WINDOW_VISIBLE);
	result = r;
	return result;
}

void
bird_font_glyph_open_path (BirdFontGlyph* self)
{
	BirdFontWidgetAllocation* _tmp29_;
	BirdFontWidgetAllocation* _tmp30_;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = bird_font_glyph_get_visible_paths (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			BirdFontPath* _tmp9_;
			gboolean _tmp10_ = FALSE;
			BirdFontPath* _tmp11_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			_tmp8_ = p;
			bird_font_path_set_editable (_tmp8_, TRUE);
			_tmp9_ = p;
			bird_font_path_recalculate_linear_handles (_tmp9_);
			_tmp11_ = p;
			if (bird_font_path_is_open (_tmp11_)) {
				BirdFontPath* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				_tmp12_ = p;
				_tmp13_ = bird_font_path_get_points (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp10_ = _tmp16_ > 0;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				BirdFontPath* _tmp17_;
				BirdFontEditPoint* _tmp18_;
				BirdFontEditPoint* _tmp19_;
				BirdFontPath* _tmp20_;
				BirdFontEditPoint* _tmp21_;
				BirdFontEditPoint* _tmp22_;
				BirdFontPath* _tmp23_;
				BirdFontEditPoint* _tmp24_;
				BirdFontEditPoint* _tmp25_;
				BirdFontPath* _tmp26_;
				BirdFontEditPoint* _tmp27_;
				BirdFontEditPoint* _tmp28_;
				_tmp17_ = p;
				_tmp18_ = bird_font_path_get_first_point (_tmp17_);
				_tmp19_ = _tmp18_;
				bird_font_edit_point_set_reflective_handles (_tmp19_, FALSE);
				_g_object_unref0 (_tmp19_);
				_tmp20_ = p;
				_tmp21_ = bird_font_path_get_first_point (_tmp20_);
				_tmp22_ = _tmp21_;
				bird_font_edit_point_set_tie_handle (_tmp22_, FALSE);
				_g_object_unref0 (_tmp22_);
				_tmp23_ = p;
				_tmp24_ = bird_font_path_get_last_point (_tmp23_);
				_tmp25_ = _tmp24_;
				bird_font_edit_point_set_reflective_handles (_tmp25_, FALSE);
				_g_object_unref0 (_tmp25_);
				_tmp26_ = p;
				_tmp27_ = bird_font_path_get_last_point (_tmp26_);
				_tmp28_ = _tmp27_;
				bird_font_edit_point_set_tie_handle (_tmp28_, FALSE);
				_g_object_unref0 (_tmp28_);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	self->priv->open = TRUE;
	_tmp29_ = self->allocation;
	_tmp30_ = self->allocation;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) 0, (gdouble) 0, (gdouble) _tmp29_->width, (gdouble) _tmp30_->height);
}

void
bird_font_glyph_redraw_path_region (BirdFontGlyph* self,
                                    BirdFontPath* p)
{
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	bird_font_path_update_region_boundaries (p);
	x = bird_font_glyph_reverse_path_coordinate_x (p->xmin);
	y = bird_font_glyph_reverse_path_coordinate_x (p->xmin);
	w = bird_font_glyph_reverse_path_coordinate_x (p->xmax) - x;
	h = bird_font_glyph_reverse_path_coordinate_x (p->ymax) - y;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
}

BirdFontLine*
bird_font_glyph_get_line (BirdFontGlyph* self,
                          const gchar* name)
{
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	BirdFontLine* _tmp27_;
	BirdFontLine* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp0_;
		gint _line_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _line_index = 0;
		_tmp0_ = self->vertical_help_lines;
		_line_list = _tmp0_;
		_tmp1_ = _line_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_line_size = _tmp3_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontLine* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			_line_index = _line_index + 1;
			_tmp4_ = _line_index;
			_tmp5_ = _line_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _line_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _line_index);
			line = (BirdFontLine*) _tmp7_;
			_tmp8_ = line;
			_tmp9_ = bird_font_line_get_label (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = G_LIKELY (g_strcmp0 (_tmp10_, name) == 0);
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				result = line;
				return result;
			}
			_g_object_unref0 (line);
		}
	}
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp12_;
		gint _line_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _line_index = 0;
		_tmp12_ = self->horizontal_help_lines;
		_line_list = _tmp12_;
		_tmp13_ = _line_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_line_size = _tmp15_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			BirdFontLine* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gboolean _tmp23_;
			_line_index = _line_index + 1;
			_tmp16_ = _line_index;
			_tmp17_ = _line_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _line_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _line_index);
			line = (BirdFontLine*) _tmp19_;
			_tmp20_ = line;
			_tmp21_ = bird_font_line_get_label (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = G_LIKELY (g_strcmp0 (_tmp22_, name) == 0);
			_g_free0 (_tmp22_);
			if (_tmp23_) {
				result = line;
				return result;
			}
			_g_object_unref0 (line);
		}
	}
	_tmp24_ = string_to_string (name);
	_tmp25_ = g_strconcat ("No line with label ", _tmp24_, " found", NULL);
	_tmp26_ = _tmp25_;
	g_warning ("Glyph.vala:1415: %s", _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = bird_font_line_new ("Err", "No label", (gdouble) 10, FALSE);
	result = _tmp27_;
	return result;
}

static void
bird_font_glyph_real_zoom_in (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	self = (BirdFontGlyph*) base;
	if (self->priv->move_canvas) {
		return;
	}
	_tmp0_ = self->allocation;
	_tmp1_ = self->allocation;
	bird_font_glyph_set_zoom_area (self, 10, 10, _tmp0_->width - 10, _tmp1_->height - 10);
	bird_font_glyph_set_zoom_from_area (self);
	bird_font_glyph_update_view (self);
	bird_font_glyph_update_zoom_bar (self);
}

static void
bird_font_glyph_real_zoom_out (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	gdouble w = 0.0;
	BirdFontWidgetAllocation* _tmp0_;
	gint n = 0;
	BirdFontWidgetAllocation* _tmp1_;
	BirdFontWidgetAllocation* _tmp2_;
	BirdFontWidgetAllocation* _tmp3_;
	self = (BirdFontGlyph*) base;
	_tmp0_ = self->allocation;
	w = (gdouble) _tmp0_->width;
	_tmp1_ = self->allocation;
	n = (gint) (10 * ((w - 10) / _tmp1_->width));
	_tmp2_ = self->allocation;
	_tmp3_ = self->allocation;
	bird_font_glyph_set_zoom_area (self, -n, -n, _tmp2_->width + n, _tmp3_->height + n);
	bird_font_glyph_set_zoom_from_area (self);
	bird_font_glyph_update_view (self);
	bird_font_glyph_update_zoom_bar (self);
}

static void
bird_font_glyph_real_zoom_max (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	self = (BirdFontGlyph*) base;
	bird_font_glyph_default_zoom (self);
	bird_font_glyph_update_zoom_bar (self);
}

static void
bird_font_glyph_real_zoom_min (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	gdouble ax = 0.0;
	gdouble ay = 0.0;
	gdouble bx = 0.0;
	gdouble by = 0.0;
	gint iax = 0;
	gint iay = 0;
	gint ibx = 0;
	gint iby = 0;
	BirdFontWidgetAllocation* _tmp22_;
	BirdFontWidgetAllocation* _tmp23_;
	BirdFontWidgetAllocation* _tmp24_;
	BirdFontWidgetAllocation* _tmp25_;
	BirdFontWidgetAllocation* _tmp26_;
	BirdFontWidgetAllocation* _tmp27_;
	self = (BirdFontGlyph*) base;
	ax = (gdouble) 1000;
	ay = (gdouble) 1000;
	bx = (gdouble) -1000;
	by = (gdouble) -1000;
	bird_font_font_display_reset_zoom ((BirdFontFontDisplay*) self);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = bird_font_glyph_get_visible_paths (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			BirdFontPath* _tmp9_;
			GeeArrayList* _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			_tmp8_ = p;
			bird_font_path_update_region_boundaries (_tmp8_);
			_tmp9_ = p;
			_tmp10_ = bird_font_path_get_points (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ > 2) {
				BirdFontPath* _tmp14_;
				BirdFontPath* _tmp16_;
				BirdFontPath* _tmp18_;
				BirdFontPath* _tmp20_;
				_tmp14_ = p;
				if (_tmp14_->xmin < ax) {
					BirdFontPath* _tmp15_;
					_tmp15_ = p;
					ax = _tmp15_->xmin;
				}
				_tmp16_ = p;
				if (_tmp16_->ymin < ay) {
					BirdFontPath* _tmp17_;
					_tmp17_ = p;
					ay = _tmp17_->ymin;
				}
				_tmp18_ = p;
				if (_tmp18_->xmax > bx) {
					BirdFontPath* _tmp19_;
					_tmp19_ = p;
					bx = _tmp19_->xmax;
				}
				_tmp20_ = p;
				if (_tmp20_->ymax > by) {
					BirdFontPath* _tmp21_;
					_tmp21_ = p;
					by = _tmp21_->ymax;
				}
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	if (ax == ((gdouble) 1000)) {
		return;
	}
	_tmp22_ = self->allocation;
	iax = (gint) (((ax + self->view_offset_x) + (_tmp22_->width / 2.0)) * self->view_zoom);
	_tmp23_ = self->allocation;
	iay = (gint) ((((-ay) + self->view_offset_y) + (_tmp23_->height / 2.0)) * self->view_zoom);
	_tmp24_ = self->allocation;
	ibx = (gint) (((bx + self->view_offset_x) + (_tmp24_->width / 2.0)) * self->view_zoom);
	_tmp25_ = self->allocation;
	iby = (gint) ((((-by) + self->view_offset_y) + (_tmp25_->height / 2.0)) * self->view_zoom);
	bird_font_glyph_show_zoom_area (self, iax, iay, ibx, iby);
	bird_font_glyph_set_zoom_from_area (self);
	bird_font_font_display_zoom_out ((BirdFontFontDisplay*) self);
	_tmp26_ = self->allocation;
	_tmp27_ = self->allocation;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) 0, (gdouble) 0, (gdouble) _tmp26_->width, (gdouble) _tmp27_->height);
	bird_font_glyph_update_zoom_bar (self);
}

static void
bird_font_glyph_real_store_current_view (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	BirdFontZoomView* n = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp19_;
	BirdFontWidgetAllocation* _tmp20_;
	BirdFontZoomView* _tmp21_;
	BirdFontZoomView* _tmp22_;
	GeeArrayList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GeeArrayList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	self = (BirdFontGlyph*) base;
	_tmp0_ = self->priv->zoom_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if ((self->priv->zoom_list_index + 1) < _tmp2_) {
		GeeArrayList* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->priv->zoom_list;
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, self->priv->zoom_list_index);
		_g_object_unref0 (n);
		n = (BirdFontZoomView*) _tmp4_;
		while (TRUE) {
			BirdFontZoomView* _tmp5_;
			GeeArrayList* _tmp6_;
			GeeArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			BirdFontZoomView* _tmp11_;
			gboolean _tmp12_;
			GeeArrayList* _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			BirdFontZoomView* _tmp18_;
			_tmp5_ = n;
			_tmp6_ = self->priv->zoom_list;
			_tmp7_ = self->priv->zoom_list;
			_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp9_ - 1);
			_tmp11_ = (BirdFontZoomView*) _tmp10_;
			_tmp12_ = !(_tmp5_ != _tmp11_);
			_g_object_unref0 (_tmp11_);
			if (_tmp12_) {
				break;
			}
			_tmp13_ = self->priv->zoom_list;
			_tmp14_ = self->priv->zoom_list;
			_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp13_, _tmp16_ - 1);
			_tmp18_ = (BirdFontZoomView*) _tmp17_;
			_g_object_unref0 (_tmp18_);
		}
	}
	_tmp19_ = self->priv->zoom_list;
	_tmp20_ = self->allocation;
	_tmp21_ = bird_font_zoom_view_new (self->view_offset_x, self->view_offset_y, self->view_zoom, _tmp20_);
	_tmp22_ = _tmp21_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->zoom_list;
	_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	self->priv->zoom_list_index = ((gint) _tmp25_) - 1;
	_tmp26_ = self->priv->zoom_list;
	_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ > 50) {
		GeeArrayList* _tmp29_;
		gpointer _tmp30_;
		BirdFontZoomView* _tmp31_;
		_tmp29_ = self->priv->zoom_list;
		_tmp30_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp29_, 0);
		_tmp31_ = (BirdFontZoomView*) _tmp30_;
		_g_object_unref0 (_tmp31_);
	}
	_g_object_unref0 (n);
}

static void
bird_font_glyph_real_restore_last_view (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	BirdFontZoomView* z = NULL;
	GeeArrayList* _tmp5_;
	gpointer _tmp6_;
	BirdFontZoomView* _tmp7_;
	BirdFontZoomView* _tmp8_;
	BirdFontZoomView* _tmp9_;
	BirdFontZoomView* _tmp10_;
	BirdFontWidgetAllocation* _tmp11_;
	BirdFontWidgetAllocation* _tmp12_;
	self = (BirdFontGlyph*) base;
	_tmp1_ = self->priv->zoom_list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (self->priv->zoom_list_index - 1) < 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->zoom_list_index;
	self->priv->zoom_list_index = _tmp4_ - 1;
	_tmp5_ = self->priv->zoom_list;
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, self->priv->zoom_list_index);
	z = (BirdFontZoomView*) _tmp6_;
	_tmp7_ = z;
	self->view_offset_x = _tmp7_->x;
	_tmp8_ = z;
	self->view_offset_y = _tmp8_->y;
	_tmp9_ = z;
	self->view_zoom = _tmp9_->zoom;
	_tmp10_ = z;
	_tmp11_ = _tmp10_->allocation;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->allocation);
	self->allocation = _tmp12_;
	bird_font_glyph_update_zoom_bar (self);
	_g_object_unref0 (z);
}

static void
bird_font_glyph_real_next_view (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	BirdFontZoomView* z = NULL;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp7_;
	GeeArrayList* _tmp8_;
	gpointer _tmp9_;
	BirdFontZoomView* _tmp10_;
	BirdFontZoomView* _tmp11_;
	BirdFontZoomView* _tmp12_;
	BirdFontZoomView* _tmp13_;
	BirdFontWidgetAllocation* _tmp14_;
	BirdFontWidgetAllocation* _tmp15_;
	self = (BirdFontGlyph*) base;
	_tmp1_ = self->priv->zoom_list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_tmp0_ = TRUE;
	} else {
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->zoom_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = (self->priv->zoom_list_index + 1) >= _tmp6_;
	}
	if (_tmp0_) {
		_g_object_unref0 (z);
		return;
	}
	_tmp7_ = self->priv->zoom_list_index;
	self->priv->zoom_list_index = _tmp7_ + 1;
	_tmp8_ = self->priv->zoom_list;
	_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, self->priv->zoom_list_index);
	_g_object_unref0 (z);
	z = (BirdFontZoomView*) _tmp9_;
	_tmp10_ = z;
	self->view_offset_x = _tmp10_->x;
	_tmp11_ = z;
	self->view_offset_y = _tmp11_->y;
	_tmp12_ = z;
	self->view_zoom = _tmp12_->zoom;
	_tmp13_ = z;
	_tmp14_ = _tmp13_->allocation;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (self->allocation);
	self->allocation = _tmp15_;
	bird_font_glyph_update_zoom_bar (self);
	_g_object_unref0 (z);
}

static void
bird_font_glyph_real_reset_zoom (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	self = (BirdFontGlyph*) base;
	self->view_offset_x = (gdouble) 0;
	self->view_offset_y = (gdouble) 0;
	bird_font_glyph_set_zoom (self, (gdouble) 1);
	bird_font_font_display_store_current_view ((BirdFontFontDisplay*) self);
	bird_font_glyph_update_zoom_bar (self);
}

/** Get x-height or top line. */
BirdFontLine*
bird_font_glyph_get_upper_line (BirdFontGlyph* self)
{
	gboolean _tmp0_ = FALSE;
	BirdFontLine* _tmp2_;
	BirdFontLine* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (bird_font_glyph_has_top_line (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->xheight_lines_visible;
	}
	if (_tmp0_) {
		BirdFontLine* _tmp1_;
		_tmp1_ = bird_font_glyph_get_line (self, "top");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = bird_font_glyph_get_line (self, "x-height");
	result = _tmp2_;
	return result;
}

/** Get base line. */
BirdFontLine*
bird_font_glyph_get_lower_line (BirdFontGlyph* self)
{
	BirdFontLine* _tmp0_;
	BirdFontLine* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_glyph_get_line (self, "baseline");
	result = _tmp0_;
	return result;
}

/** Set default zoom. See default_zoom. */
void
bird_font_glyph_set_default_zoom (BirdFontGlyph* self)
{
	gint bottom = 0;
	gint top = 0;
	gint left = 0;
	gint right = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BirdFontLine* _tmp6_;
	BirdFontLine* _tmp7_;
	BirdFontLine* _tmp8_;
	BirdFontLine* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gpointer _tmp14_;
	BirdFontLine* _tmp15_;
	GeeArrayList* _tmp16_;
	gpointer _tmp17_;
	BirdFontLine* _tmp18_;
	g_return_if_fail (self != NULL);
	bottom = 0;
	top = 0;
	left = 0;
	right = 0;
	_tmp0_ = self->vertical_help_lines;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != 0);
	_tmp3_ = self->horizontal_help_lines;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_return_if_fail (_tmp5_ != 0);
	bird_font_font_display_reset_zoom ((BirdFontFontDisplay*) self);
	_tmp6_ = bird_font_glyph_get_lower_line (self);
	_tmp7_ = _tmp6_;
	bottom = bird_font_line_get_position_pixel (_tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = bird_font_glyph_get_upper_line (self);
	_tmp9_ = _tmp8_;
	top = bird_font_line_get_position_pixel (_tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->vertical_help_lines;
	_tmp11_ = self->vertical_help_lines;
	_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp13_ - 1);
	_tmp15_ = (BirdFontLine*) _tmp14_;
	left = bird_font_line_get_position_pixel (_tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->vertical_help_lines;
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, 0);
	_tmp18_ = (BirdFontLine*) _tmp17_;
	right = bird_font_line_get_position_pixel (_tmp18_);
	_g_object_unref0 (_tmp18_);
	bird_font_glyph_set_zoom_area (self, left + 10, top - 10, right - 10, bottom + 10);
	bird_font_glyph_set_zoom_from_area (self);
}

/** Set default zoom and redraw canvas. */
void
bird_font_glyph_default_zoom (BirdFontGlyph* self)
{
	g_return_if_fail (self != NULL);
	bird_font_glyph_set_default_zoom (self);
	bird_font_glyph_update_view (self);
}

gboolean
bird_font_glyph_is_empty (BirdFontGlyph* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = bird_font_glyph_get_visible_paths (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			GeeArrayList* _tmp9_;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = bird_font_path_get_points (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ > 0) {
				result = FALSE;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_list);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	result = TRUE;
	return result;
}

void
bird_font_glyph_set_zoom (BirdFontGlyph* self,
                          gdouble z)
{
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (z > ((gdouble) 0), "z > 0");
	self->view_zoom = z;
}

void
bird_font_glyph_set_background_visible (BirdFontGlyph* self,
                                        gboolean visibility)
{
	g_return_if_fail (self != NULL);
	self->priv->background_image_visible = visibility;
}

gboolean
bird_font_glyph_get_background_visible (BirdFontGlyph* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->background_image_visible;
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
bird_font_glyph_draw_coordinate (BirdFontGlyph* self,
                                 cairo_t* cr)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	bird_font_theme_color (cr, "Table Border");
	cairo_set_font_size (cr, (gdouble) 12);
	cairo_move_to (cr, (gdouble) 0, (gdouble) 10);
	_tmp0_ = double_to_string (self->motion_x);
	_tmp1_ = _tmp0_;
	_tmp2_ = double_to_string (self->motion_y);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("(", _tmp1_, ", ", _tmp3_, ")", NULL);
	_tmp5_ = _tmp4_;
	cairo_show_text (cr, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	cairo_stroke (cr);
}

/** Draw filled paths. */
static gpointer
_bird_font_color_ref0 (gpointer self)
{
	return self ? bird_font_color_ref (self) : NULL;
}

void
bird_font_glyph_draw_paths (BirdFontGlyph* self,
                            cairo_t* cr,
                            BirdFontColor* c)
{
	BirdFontPathList* stroke = NULL;
	BirdFontColor* color = NULL;
	gboolean open = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	cairo_new_path (cr);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = bird_font_glyph_get_visible_paths (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp15_;
			gdouble _tmp16_;
			gdouble _tmp17_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			if (c != NULL) {
				BirdFontColor* _tmp8_;
				_tmp8_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (c, BIRD_FONT_TYPE_COLOR, BirdFontColor));
				_bird_font_color_unref0 (color);
				color = _tmp8_;
			} else {
				BirdFontPath* _tmp9_;
				BirdFontColor* _tmp10_;
				_tmp9_ = p;
				_tmp10_ = _tmp9_->color;
				if (_tmp10_ != NULL) {
					BirdFontPath* _tmp11_;
					BirdFontColor* _tmp12_;
					BirdFontColor* _tmp13_;
					_tmp11_ = p;
					_tmp12_ = _tmp11_->color;
					_tmp13_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
					_bird_font_color_unref0 (color);
					color = _tmp13_;
				} else {
					BirdFontColor* _tmp14_;
					_tmp14_ = bird_font_color_black ();
					_bird_font_color_unref0 (color);
					color = _tmp14_;
				}
			}
			_tmp15_ = p;
			_tmp16_ = bird_font_path_get_stroke (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ > ((gdouble) 0)) {
				BirdFontPath* _tmp18_;
				BirdFontPathList* _tmp19_;
				BirdFontPathList* _tmp20_;
				BirdFontColor* _tmp21_;
				_tmp18_ = p;
				_tmp19_ = bird_font_path_get_stroke_fast (_tmp18_);
				_g_object_unref0 (stroke);
				stroke = _tmp19_;
				_tmp20_ = stroke;
				_tmp21_ = color;
				bird_font_glyph_draw_path_list (self, _tmp20_, cr, _tmp21_);
			} else {
				BirdFontPath* _tmp22_;
				BirdFontPath* _tmp25_;
				BirdFontColor* _tmp26_;
				_tmp22_ = p;
				open = bird_font_path_is_open (_tmp22_);
				if (open) {
					BirdFontPath* _tmp23_;
					BirdFontPath* _tmp24_;
					_tmp23_ = p;
					bird_font_path_close (_tmp23_);
					_tmp24_ = p;
					bird_font_path_recalculate_linear_handles (_tmp24_);
				}
				_tmp25_ = p;
				_tmp26_ = color;
				bird_font_path_draw_path (_tmp25_, cr, self, _tmp26_);
				if (open) {
					BirdFontPath* _tmp27_;
					_tmp27_ = p;
					bird_font_path_reopen (_tmp27_);
				}
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	cairo_fill (cr);
	cairo_restore (cr);
	_bird_font_color_unref0 (color);
	_g_object_unref0 (stroke);
}

void
bird_font_glyph_draw_path (BirdFontGlyph* self,
                           cairo_t* cr)
{
	BirdFontPathList* stroke = NULL;
	BirdFontColor* color = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	BirdFontToolbox* _tmp22_;
	BirdFontToolbox* _tmp23_;
	BirdFontTool* _tmp24_;
	BirdFontTool* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp55_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	cairo_new_path (cr);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = bird_font_glyph_get_visible_paths (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			gdouble _tmp9_;
			gdouble _tmp10_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = bird_font_path_get_stroke (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ > ((gdouble) 0)) {
				BirdFontPath* _tmp11_;
				BirdFontPathList* _tmp12_;
				BirdFontPath* _tmp13_;
				BirdFontPathList* _tmp17_;
				BirdFontColor* _tmp18_;
				_tmp11_ = p;
				_tmp12_ = bird_font_path_get_stroke_fast (_tmp11_);
				_g_object_unref0 (stroke);
				stroke = _tmp12_;
				_tmp13_ = p;
				if (bird_font_path_is_editable (_tmp13_)) {
					BirdFontColor* _tmp14_;
					BirdFontColor* _tmp15_;
					_tmp14_ = bird_font_theme_get_color ("Filled Stroke");
					_bird_font_color_unref0 (color);
					color = _tmp14_;
					_tmp15_ = color;
					_tmp15_->a = 0.8;
				} else {
					BirdFontColor* _tmp16_;
					_tmp16_ = bird_font_color_black ();
					_bird_font_color_unref0 (color);
					color = _tmp16_;
				}
				_tmp17_ = stroke;
				_tmp18_ = color;
				bird_font_glyph_draw_path_list (self, _tmp17_, cr, _tmp18_);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	cairo_fill (cr);
	cairo_restore (cr);
	_tmp22_ = bird_font_main_window_get_toolbox ();
	_tmp23_ = _tmp22_;
	_tmp24_ = bird_font_toolbox_get_current_tool (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = !BIRD_FONT_IS_PEN_TOOL (_tmp25_);
	_g_object_unref0 (_tmp25_);
	_g_object_unref0 (_tmp23_);
	if (_tmp26_) {
		BirdFontToolbox* _tmp27_;
		BirdFontToolbox* _tmp28_;
		BirdFontTool* _tmp29_;
		BirdFontTool* _tmp30_;
		_tmp27_ = bird_font_main_window_get_toolbox ();
		_tmp28_ = _tmp27_;
		_tmp29_ = bird_font_toolbox_get_current_tool (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp21_ = !BIRD_FONT_IS_POINT_TOOL (_tmp30_);
		_g_object_unref0 (_tmp30_);
		_g_object_unref0 (_tmp28_);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		BirdFontToolbox* _tmp31_;
		BirdFontToolbox* _tmp32_;
		BirdFontTool* _tmp33_;
		BirdFontTool* _tmp34_;
		_tmp31_ = bird_font_main_window_get_toolbox ();
		_tmp32_ = _tmp31_;
		_tmp33_ = bird_font_toolbox_get_current_tool (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp20_ = !BIRD_FONT_IS_TRACK_TOOL (_tmp34_);
		_g_object_unref0 (_tmp34_);
		_g_object_unref0 (_tmp32_);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		BirdFontToolbox* _tmp35_;
		BirdFontToolbox* _tmp36_;
		BirdFontTool* _tmp37_;
		BirdFontTool* _tmp38_;
		_tmp35_ = bird_font_main_window_get_toolbox ();
		_tmp36_ = _tmp35_;
		_tmp37_ = bird_font_toolbox_get_current_tool (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp19_ = !BIRD_FONT_IS_BEZIER_TOOL (_tmp38_);
		_g_object_unref0 (_tmp38_);
		_g_object_unref0 (_tmp36_);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		cairo_save (cr);
		cairo_new_path (cr);
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp39_;
			gint _p_size = 0;
			GeeArrayList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _p_index = 0;
			_tmp39_ = self->active_paths;
			_p_list = _tmp39_;
			_tmp40_ = _p_list;
			_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_p_size = _tmp42_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp43_;
				gint _tmp44_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp45_;
				gpointer _tmp46_;
				BirdFontPath* _tmp47_;
				gdouble _tmp48_;
				gdouble _tmp49_;
				_p_index = _p_index + 1;
				_tmp43_ = _p_index;
				_tmp44_ = _p_size;
				if (!(_tmp43_ < _tmp44_)) {
					break;
				}
				_tmp45_ = _p_list;
				_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _p_index);
				p = (BirdFontPath*) _tmp46_;
				_tmp47_ = p;
				_tmp48_ = bird_font_path_get_stroke (_tmp47_);
				_tmp49_ = _tmp48_;
				if (_tmp49_ > ((gdouble) 0)) {
					BirdFontPath* _tmp50_;
					BirdFontPathList* _tmp51_;
					BirdFontColor* _tmp52_;
					BirdFontPathList* _tmp53_;
					BirdFontColor* _tmp54_;
					_tmp50_ = p;
					_tmp51_ = bird_font_path_get_stroke_fast (_tmp50_);
					_g_object_unref0 (stroke);
					stroke = _tmp51_;
					_tmp52_ = bird_font_theme_get_color ("Selected Objects");
					_bird_font_color_unref0 (color);
					color = _tmp52_;
					_tmp53_ = stroke;
					_tmp54_ = color;
					bird_font_glyph_draw_path_list (self, _tmp53_, cr, _tmp54_);
				}
				_g_object_unref0 (p);
			}
		}
		cairo_fill (cr);
		cairo_restore (cr);
	}
	if (bird_font_glyph_is_open (self)) {
		gboolean _tmp56_;
		gboolean _tmp57_;
		_tmp56_ = bird_font_path_get_fill_open_path ();
		_tmp57_ = _tmp56_;
		_tmp55_ = _tmp57_;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		cairo_save (cr);
		cairo_new_path (cr);
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp58_;
			gint _p_size = 0;
			GeeArrayList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _p_index = 0;
			_tmp58_ = bird_font_glyph_get_visible_paths (self);
			_p_list = _tmp58_;
			_tmp59_ = _p_list;
			_tmp60_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_p_size = _tmp61_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp62_;
				gint _tmp63_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp64_;
				gpointer _tmp65_;
				BirdFontPath* _tmp66_;
				gdouble _tmp67_;
				gdouble _tmp68_;
				_p_index = _p_index + 1;
				_tmp62_ = _p_index;
				_tmp63_ = _p_size;
				if (!(_tmp62_ < _tmp63_)) {
					break;
				}
				_tmp64_ = _p_list;
				_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp64_, _p_index);
				p = (BirdFontPath*) _tmp65_;
				_tmp66_ = p;
				_tmp67_ = bird_font_path_get_stroke (_tmp66_);
				_tmp68_ = _tmp67_;
				if (_tmp68_ == ((gdouble) 0)) {
					BirdFontColor* _tmp69_ = NULL;
					BirdFontPath* _tmp70_;
					BirdFontColor* _tmp71_;
					BirdFontColor* _tmp76_;
					BirdFontPath* _tmp77_;
					BirdFontColor* _tmp78_;
					_tmp70_ = p;
					_tmp71_ = _tmp70_->color;
					if (_tmp71_ == NULL) {
						BirdFontColor* _tmp72_;
						_tmp72_ = bird_font_glyph_get_path_fill_color (self);
						_bird_font_color_unref0 (_tmp69_);
						_tmp69_ = _tmp72_;
					} else {
						BirdFontPath* _tmp73_;
						BirdFontColor* _tmp74_;
						BirdFontColor* _tmp75_;
						_tmp73_ = p;
						_tmp74_ = _tmp73_->color;
						_tmp75_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (_tmp69_);
						_tmp69_ = _tmp75_;
					}
					_tmp76_ = _bird_font_color_ref0 (_tmp69_);
					_bird_font_color_unref0 (color);
					color = _tmp76_;
					_tmp77_ = p;
					_tmp78_ = color;
					bird_font_path_draw_path (_tmp77_, cr, self, _tmp78_);
					_bird_font_color_unref0 (_tmp69_);
				}
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_list);
		}
		cairo_fill (cr);
		cairo_restore (cr);
	}
	if (bird_font_glyph_is_open (self)) {
		cairo_save (cr);
		cairo_new_path (cr);
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp79_;
			gint _p_size = 0;
			GeeArrayList* _tmp80_;
			gint _tmp81_;
			gint _tmp82_;
			gint _p_index = 0;
			_tmp79_ = bird_font_glyph_get_visible_paths (self);
			_p_list = _tmp79_;
			_tmp80_ = _p_list;
			_tmp81_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp80_);
			_tmp82_ = _tmp81_;
			_p_size = _tmp82_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp83_;
				gint _tmp84_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp85_;
				gpointer _tmp86_;
				BirdFontPath* _tmp87_;
				BirdFontPath* _tmp88_;
				_p_index = _p_index + 1;
				_tmp83_ = _p_index;
				_tmp84_ = _p_size;
				if (!(_tmp83_ < _tmp84_)) {
					break;
				}
				_tmp85_ = _p_list;
				_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) _tmp85_, _p_index);
				p = (BirdFontPath*) _tmp86_;
				_tmp87_ = p;
				bird_font_path_draw_outline (_tmp87_, cr);
				_tmp88_ = p;
				bird_font_path_draw_edit_points (_tmp88_, cr);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_list);
		}
		cairo_restore (cr);
	}
	if (!bird_font_glyph_is_open (self)) {
		cairo_save (cr);
		cairo_new_path (cr);
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp89_;
			gint _p_size = 0;
			GeeArrayList* _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			gint _p_index = 0;
			_tmp89_ = bird_font_glyph_get_visible_paths (self);
			_p_list = _tmp89_;
			_tmp90_ = _p_list;
			_tmp91_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp90_);
			_tmp92_ = _tmp91_;
			_p_size = _tmp92_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp93_;
				gint _tmp94_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp95_;
				gpointer _tmp96_;
				BirdFontPath* _tmp97_;
				gdouble _tmp98_;
				gdouble _tmp99_;
				_p_index = _p_index + 1;
				_tmp93_ = _p_index;
				_tmp94_ = _p_size;
				if (!(_tmp93_ < _tmp94_)) {
					break;
				}
				_tmp95_ = _p_list;
				_tmp96_ = gee_abstract_list_get ((GeeAbstractList*) _tmp95_, _p_index);
				p = (BirdFontPath*) _tmp96_;
				_tmp97_ = p;
				_tmp98_ = bird_font_path_get_stroke (_tmp97_);
				_tmp99_ = _tmp98_;
				if (_tmp99_ == ((gdouble) 0)) {
					BirdFontColor* _tmp100_ = NULL;
					BirdFontPath* _tmp101_;
					BirdFontColor* _tmp102_;
					BirdFontColor* _tmp107_;
					BirdFontPath* _tmp108_;
					BirdFontColor* _tmp109_;
					_tmp101_ = p;
					_tmp102_ = _tmp101_->color;
					if (_tmp102_ == NULL) {
						BirdFontColor* _tmp103_;
						_tmp103_ = bird_font_color_black ();
						_bird_font_color_unref0 (_tmp100_);
						_tmp100_ = _tmp103_;
					} else {
						BirdFontPath* _tmp104_;
						BirdFontColor* _tmp105_;
						BirdFontColor* _tmp106_;
						_tmp104_ = p;
						_tmp105_ = _tmp104_->color;
						_tmp106_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (_tmp100_);
						_tmp100_ = _tmp106_;
					}
					_tmp107_ = _bird_font_color_ref0 (_tmp100_);
					_bird_font_color_unref0 (color);
					color = _tmp107_;
					_tmp108_ = p;
					_tmp109_ = color;
					bird_font_path_draw_path (_tmp108_, cr, self, _tmp109_);
					_bird_font_color_unref0 (_tmp100_);
				}
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_list);
		}
		cairo_close_path (cr);
		cairo_fill (cr);
		cairo_restore (cr);
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp110_;
			gint _p_size = 0;
			GeeArrayList* _tmp111_;
			gint _tmp112_;
			gint _tmp113_;
			gint _p_index = 0;
			_tmp110_ = self->active_paths;
			_p_list = _tmp110_;
			_tmp111_ = _p_list;
			_tmp112_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp111_);
			_tmp113_ = _tmp112_;
			_p_size = _tmp113_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp114_;
				gint _tmp115_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp116_;
				gpointer _tmp117_;
				BirdFontPath* _tmp118_;
				gdouble _tmp119_;
				gdouble _tmp120_;
				_p_index = _p_index + 1;
				_tmp114_ = _p_index;
				_tmp115_ = _p_size;
				if (!(_tmp114_ < _tmp115_)) {
					break;
				}
				_tmp116_ = _p_list;
				_tmp117_ = gee_abstract_list_get ((GeeAbstractList*) _tmp116_, _p_index);
				p = (BirdFontPath*) _tmp117_;
				cairo_save (cr);
				cairo_new_path (cr);
				_tmp118_ = p;
				_tmp119_ = bird_font_path_get_stroke (_tmp118_);
				_tmp120_ = _tmp119_;
				if (_tmp120_ == ((gdouble) 0)) {
					BirdFontPath* _tmp121_;
					_tmp121_ = p;
					bird_font_path_draw_path (_tmp121_, cr, self, NULL);
				}
				cairo_close_path (cr);
				cairo_fill (cr);
				cairo_restore (cr);
				_g_object_unref0 (p);
			}
		}
	}
	if (bird_font_glyph_show_orientation_arrow) {
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp122_;
			gint _p_size = 0;
			GeeArrayList* _tmp123_;
			gint _tmp124_;
			gint _tmp125_;
			gint _p_index = 0;
			_tmp122_ = bird_font_glyph_get_visible_paths (self);
			_p_list = _tmp122_;
			_tmp123_ = _p_list;
			_tmp124_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp123_);
			_tmp125_ = _tmp124_;
			_p_size = _tmp125_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp126_;
				gint _tmp127_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp128_;
				gpointer _tmp129_;
				BirdFontPath* _tmp130_;
				gdouble _tmp131_;
				gdouble _tmp132_;
				_p_index = _p_index + 1;
				_tmp126_ = _p_index;
				_tmp127_ = _p_size;
				if (!(_tmp126_ < _tmp127_)) {
					break;
				}
				_tmp128_ = _p_list;
				_tmp129_ = gee_abstract_list_get ((GeeAbstractList*) _tmp128_, _p_index);
				p = (BirdFontPath*) _tmp129_;
				_tmp130_ = p;
				_tmp131_ = bird_font_path_get_stroke (_tmp130_);
				_tmp132_ = _tmp131_;
				if (_tmp132_ > ((gdouble) 0)) {
					BirdFontPath* _tmp133_;
					BirdFontPathList* _tmp134_;
					_tmp133_ = p;
					_tmp134_ = bird_font_path_get_stroke_fast (_tmp133_);
					_g_object_unref0 (stroke);
					stroke = _tmp134_;
					{
						GeeArrayList* _ps_list = NULL;
						BirdFontPathList* _tmp135_;
						GeeArrayList* _tmp136_;
						gint _ps_size = 0;
						GeeArrayList* _tmp137_;
						gint _tmp138_;
						gint _tmp139_;
						gint _ps_index = 0;
						_tmp135_ = stroke;
						_tmp136_ = _tmp135_->paths;
						_ps_list = _tmp136_;
						_tmp137_ = _ps_list;
						_tmp138_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp137_);
						_tmp139_ = _tmp138_;
						_ps_size = _tmp139_;
						_ps_index = -1;
						while (TRUE) {
							gint _tmp140_;
							gint _tmp141_;
							BirdFontPath* ps = NULL;
							GeeArrayList* _tmp142_;
							gpointer _tmp143_;
							BirdFontPath* _tmp144_;
							_ps_index = _ps_index + 1;
							_tmp140_ = _ps_index;
							_tmp141_ = _ps_size;
							if (!(_tmp140_ < _tmp141_)) {
								break;
							}
							_tmp142_ = _ps_list;
							_tmp143_ = gee_abstract_list_get ((GeeAbstractList*) _tmp142_, _ps_index);
							ps = (BirdFontPath*) _tmp143_;
							_tmp144_ = ps;
							bird_font_path_draw_orientation_arrow (_tmp144_, cr, bird_font_glyph_orientation_arrow_opacity);
							_g_object_unref0 (ps);
						}
					}
				} else {
					BirdFontPath* _tmp145_;
					_tmp145_ = p;
					bird_font_path_draw_orientation_arrow (_tmp145_, cr, bird_font_glyph_orientation_arrow_opacity);
				}
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_list);
		}
	}
	_bird_font_color_unref0 (color);
	_g_object_unref0 (stroke);
}

static BirdFontColor*
bird_font_glyph_get_path_fill_color (BirdFontGlyph* self)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_theme_get_color ("Fill Color");
	result = _tmp0_;
	return result;
}

void
bird_font_glyph_draw_path_list (BirdFontGlyph* self,
                                BirdFontPathList* pl,
                                cairo_t* cr,
                                BirdFontColor* c)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (pl != NULL);
	g_return_if_fail (cr != NULL);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = pl->paths;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			_tmp8_ = p;
			bird_font_path_draw_path (_tmp8_, cr, self, c);
			_g_object_unref0 (p);
		}
	}
}

void
bird_font_glyph_draw_background_color (BirdFontGlyph* self,
                                       cairo_t* cr,
                                       gdouble opacity)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (opacity > ((gdouble) 0)) {
		BirdFontWidgetAllocation* _tmp0_;
		BirdFontWidgetAllocation* _tmp1_;
		cairo_save (cr);
		_tmp0_ = self->allocation;
		_tmp1_ = self->allocation;
		cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) _tmp0_->width, (gdouble) _tmp1_->height);
		bird_font_theme_color (cr, "Canvas Background");
		cairo_fill (cr);
		cairo_restore (cr);
	}
}

void
bird_font_glyph_draw_help_lines (BirdFontGlyph* self,
                                 cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp0_;
		gint _line_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _line_index = 0;
		_tmp0_ = bird_font_glyph_get_all_help_lines (self);
		_line_list = _tmp0_;
		_tmp1_ = _line_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_line_size = _tmp3_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontLine* _tmp8_;
			BirdFontWidgetAllocation* _tmp9_;
			_line_index = _line_index + 1;
			_tmp4_ = _line_index;
			_tmp5_ = _line_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _line_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _line_index);
			line = (BirdFontLine*) _tmp7_;
			cairo_save (cr);
			_tmp8_ = line;
			_tmp9_ = self->allocation;
			bird_font_line_draw (_tmp8_, cr, _tmp9_);
			cairo_restore (cr);
			_g_object_unref0 (line);
		}
		_g_object_unref0 (_line_list);
	}
}

void
bird_font_glyph_set_allocation (BirdFontGlyph* self,
                                BirdFontWidgetAllocation* a)
{
	BirdFontWidgetAllocation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = _g_object_ref0 (a);
	_g_object_unref0 (self->allocation);
	self->allocation = _tmp0_;
}

static void
bird_font_glyph_real_draw (BirdFontFontDisplay* base,
                           BirdFontWidgetAllocation* allocation,
                           cairo_t* cmp)
{
	BirdFontGlyph * self;
	BirdFontTool* tool = NULL;
	BirdFontWidgetAllocation* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BirdFontBackgroundImage* _tmp2_;
	BirdFontToolbox* _tmp13_;
	BirdFontToolbox* _tmp14_;
	BirdFontTool* _tmp15_;
	self = (BirdFontGlyph*) base;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cmp != NULL);
	_tmp0_ = _g_object_ref0 (allocation);
	_g_object_unref0 (self->allocation);
	self->allocation = _tmp0_;
	cairo_save (cmp);
	bird_font_glyph_draw_background_color (self, cmp, (gdouble) 1);
	cairo_restore (cmp);
	_tmp2_ = self->priv->background_image;
	if (_tmp2_ != NULL) {
		_tmp1_ = self->priv->background_image_visible;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		BirdFontBackgroundImage* _tmp3_;
		_tmp3_ = self->priv->background_image;
		bird_font_background_image_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage), cmp, allocation, self->view_offset_x, self->view_offset_y, self->view_zoom);
	}
	if (G_UNLIKELY (bird_font_preferences_draw_boundaries)) {
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp4_;
			gint _p_size = 0;
			GeeArrayList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _p_index = 0;
			_tmp4_ = bird_font_glyph_get_visible_paths (self);
			_p_list = _tmp4_;
			_tmp5_ = _p_list;
			_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_p_size = _tmp7_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp10_;
				gpointer _tmp11_;
				BirdFontPath* _tmp12_;
				_p_index = _p_index + 1;
				_tmp8_ = _p_index;
				_tmp9_ = _p_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _p_list;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _p_index);
				p = (BirdFontPath*) _tmp11_;
				_tmp12_ = p;
				bird_font_path_draw_boundaries (_tmp12_, cmp);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_list);
		}
	}
	bird_font_glyph_draw_background_glyph (self, allocation, cmp);
	bird_font_glyph_juxtapose (self, allocation, cmp);
	if (bird_font_bird_font_show_coordinates) {
		bird_font_glyph_draw_coordinate (self, cmp);
	}
	if (self->show_help_lines) {
		cairo_save (cmp);
		bird_font_glyph_draw_help_lines (self, cmp);
		cairo_restore (cmp);
	}
	if (!bird_font_glyph_is_empty (self)) {
		cairo_save (cmp);
		cairo_scale (cmp, self->view_zoom, self->view_zoom);
		cairo_translate (cmp, -self->view_offset_x, -self->view_offset_y);
		bird_font_glyph_draw_path (self, cmp);
		cairo_restore (cmp);
	}
	cairo_save (cmp);
	_tmp13_ = bird_font_main_window_get_toolbox ();
	_tmp14_ = _tmp13_;
	_tmp15_ = bird_font_toolbox_get_current_tool (_tmp14_);
	_g_object_unref0 (tool);
	tool = _tmp15_;
	_g_object_unref0 (_tmp14_);
	g_signal_emit_by_name (tool, "draw-action", tool, cmp, self);
	cairo_restore (cmp);
	_g_object_unref0 (tool);
}

static void
bird_font_glyph_zoom_in_at_point (BirdFontGlyph* self,
                                  gdouble x,
                                  gdouble y,
                                  gdouble amount)
{
	gint n = 0;
	g_return_if_fail (self != NULL);
	n = (gint) (-amount);
	bird_font_glyph_zoom_at_point (self, x, y, n);
}

static void
bird_font_glyph_zoom_out_at_point (BirdFontGlyph* self,
                                   gdouble x,
                                   gdouble y,
                                   gdouble amount)
{
	gdouble a = 0.0;
	gint n = 0;
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	g_return_if_fail (self != NULL);
	a = -amount;
	_tmp0_ = self->allocation;
	_tmp1_ = self->allocation;
	n = (gint) (a * ((_tmp0_->width - a) / _tmp1_->width));
	bird_font_glyph_zoom_at_point (self, x, y, n);
}

void
bird_font_glyph_zoom_tap (BirdFontGlyph* self,
                          gdouble distance)
{
	gint w = 0;
	g_return_if_fail (self != NULL);
	w = (gint) distance;
	if (distance != ((gdouble) 0)) {
		BirdFontWidgetAllocation* _tmp0_;
		BirdFontWidgetAllocation* _tmp1_;
		_tmp0_ = self->allocation;
		_tmp1_ = self->allocation;
		bird_font_glyph_show_zoom_area (self, -w, -w, _tmp0_->width + w, _tmp1_->height + w);
		bird_font_glyph_set_zoom_from_area (self);
	}
}

/** Zoom in @param n pixels. */
static void
bird_font_glyph_zoom_at_point (BirdFontGlyph* self,
                               gdouble x,
                               gdouble y,
                               gint n)
{
	gdouble w = 0.0;
	BirdFontWidgetAllocation* _tmp0_;
	gdouble h = 0.0;
	BirdFontWidgetAllocation* _tmp1_;
	gdouble rx = 0.0;
	gdouble ry = 0.0;
	gint _tmp2_ = 0;
	gint xd = 0;
	gint _tmp3_ = 0;
	gint yd = 0;
	BirdFontWidgetAllocation* _tmp4_;
	BirdFontWidgetAllocation* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->allocation;
	w = (gdouble) _tmp0_->width;
	_tmp1_ = self->allocation;
	h = (gdouble) _tmp1_->height;
	rx = fabs ((w / 2) - x) / (w / 2);
	ry = fabs ((h / 2) - y) / (h / 2);
	if (x < (w / 2)) {
		_tmp2_ = (gint) (n * rx);
	} else {
		_tmp2_ = (gint) ((-n) * rx);
	}
	xd = _tmp2_;
	if (y < (h / 2)) {
		_tmp3_ = (gint) (n * ry);
	} else {
		_tmp3_ = (gint) ((-n) * ry);
	}
	yd = _tmp3_;
	_tmp4_ = self->allocation;
	_tmp5_ = self->allocation;
	bird_font_glyph_show_zoom_area (self, (-n) + xd, (-n) + yd, (_tmp4_->width + n) + xd, (_tmp5_->height + n) + yd);
	bird_font_glyph_set_zoom_from_area (self);
}

static void
bird_font_glyph_move_view_offset (BirdFontGlyph* self,
                                  gdouble x,
                                  gdouble y)
{
	g_return_if_fail (self != NULL);
	self->view_offset_x = self->move_offset_x + ((self->priv->pointer_begin_x - x) * (1 / self->view_zoom));
	self->view_offset_y = self->move_offset_y + ((self->priv->pointer_begin_y - y) * (1 / self->view_zoom));
	bird_font_glyph_canvas_redraw ();
}

void
bird_font_glyph_store_undo_state (BirdFontGlyph* self,
                                  gboolean clear_redo)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	GeeArrayList* _tmp1_;
	BirdFontGlyph* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_glyph_copy (self);
	g = _tmp0_;
	_tmp1_ = self->priv->undo_list;
	_tmp2_ = g;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
	if (clear_redo) {
		GeeArrayList* _tmp3_;
		_tmp3_ = self->priv->redo_list;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
	}
	_g_object_unref0 (g);
}

void
bird_font_glyph_store_redo_state (BirdFontGlyph* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_glyph_copy (self);
	g = _tmp0_;
	_tmp1_ = self->priv->redo_list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, g);
	_g_object_unref0 (g);
}

BirdFontGlyph*
bird_font_glyph_copy (BirdFontGlyph* self)
{
	BirdFontGlyph* g = NULL;
	const gchar* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontGlyph* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontGlyph* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	BirdFontGlyph* _tmp9_;
	BirdFontGlyph* _tmp22_;
	BirdFontLayer* _tmp23_;
	BirdFontLayer* _tmp24_;
	BirdFontBackgroundImage* _tmp36_;
	BirdFontGlyph* _tmp40_;
	BirdFontGlyph* _tmp41_;
	BirdFontGlyph* _tmp42_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = bird_font_glyph_new_no_lines (_tmp0_, self->unichar_code);
	g = _tmp1_;
	_tmp2_ = g;
	_tmp2_->current_layer = self->current_layer;
	_tmp3_ = g;
	_tmp4_ = bird_font_glyph_get_left_limit (self);
	_tmp5_ = _tmp4_;
	bird_font_glyph_set_left_limit (_tmp3_, _tmp5_);
	_tmp6_ = g;
	_tmp7_ = bird_font_glyph_get_right_limit (self);
	_tmp8_ = _tmp7_;
	bird_font_glyph_set_right_limit (_tmp6_, _tmp8_);
	_tmp9_ = g;
	bird_font_glyph_remove_lines (_tmp9_);
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp10_;
		gint _line_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _line_index = 0;
		_tmp10_ = bird_font_glyph_get_all_help_lines (self);
		_line_list = _tmp10_;
		_tmp11_ = _line_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_line_size = _tmp13_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			BirdFontGlyph* _tmp18_;
			BirdFontLine* _tmp19_;
			BirdFontLine* _tmp20_;
			BirdFontLine* _tmp21_;
			_line_index = _line_index + 1;
			_tmp14_ = _line_index;
			_tmp15_ = _line_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _line_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _line_index);
			line = (BirdFontLine*) _tmp17_;
			_tmp18_ = g;
			_tmp19_ = line;
			_tmp20_ = bird_font_line_copy (_tmp19_);
			_tmp21_ = _tmp20_;
			bird_font_glyph_add_line (_tmp18_, _tmp21_);
			_g_object_unref0 (_tmp21_);
			_g_object_unref0 (line);
		}
		_g_object_unref0 (_line_list);
	}
	_tmp22_ = g;
	_tmp23_ = self->layers;
	_tmp24_ = bird_font_layer_copy (_tmp23_);
	_g_object_unref0 (_tmp22_->layers);
	_tmp22_->layers = _tmp24_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp25_;
		gint _p_size = 0;
		GeeArrayList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _p_index = 0;
		_tmp25_ = self->active_paths;
		_p_list = _tmp25_;
		_tmp26_ = _p_list;
		_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_p_size = _tmp28_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp31_;
			gpointer _tmp32_;
			BirdFontGlyph* _tmp33_;
			GeeArrayList* _tmp34_;
			BirdFontPath* _tmp35_;
			_p_index = _p_index + 1;
			_tmp29_ = _p_index;
			_tmp30_ = _p_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _p_list;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _p_index);
			p = (BirdFontPath*) _tmp32_;
			_tmp33_ = g;
			_tmp34_ = _tmp33_->active_paths;
			_tmp35_ = p;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
			_g_object_unref0 (p);
		}
	}
	_tmp36_ = self->priv->background_image;
	if (_tmp36_ != NULL) {
		BirdFontGlyph* _tmp37_;
		BirdFontBackgroundImage* _tmp38_;
		BirdFontBackgroundImage* _tmp39_;
		_tmp37_ = g;
		_tmp38_ = self->priv->background_image;
		_tmp39_ = bird_font_background_image_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage));
		_g_object_unref0 (_tmp37_->priv->background_image);
		_tmp37_->priv->background_image = _tmp39_;
	}
	_tmp40_ = g;
	_tmp40_->priv->empty = self->priv->empty;
	_tmp41_ = g;
	_tmp41_->priv->open = self->priv->open;
	_tmp42_ = g;
	_tmp42_->version_id = self->version_id;
	result = g;
	return result;
}

void
bird_font_glyph_reload (BirdFontGlyph* self)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	_tmp1_ = f;
	_tmp2_ = self->name;
	if (bird_font_font_has_glyph (_tmp1_, _tmp2_)) {
		BirdFontFont* _tmp3_;
		const gchar* _tmp4_;
		BirdFontGlyph* _tmp5_;
		BirdFontGlyph* _tmp6_;
		_tmp3_ = f;
		_tmp4_ = self->name;
		_tmp5_ = bird_font_font_get_glyph (_tmp3_, _tmp4_);
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph);
		bird_font_glyph_set_glyph_data (self, _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_g_object_unref0 (f);
}

static void
bird_font_glyph_real_undo (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	BirdFontGlyph* g = NULL;
	BirdFontTool* tool = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	BirdFontToolbox* _tmp3_;
	BirdFontToolbox* _tmp4_;
	BirdFontTool* _tmp5_;
	BirdFontTool* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	BirdFontGlyph* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gpointer _tmp17_;
	BirdFontGlyph* _tmp18_;
	BirdFontTool* _tmp19_;
	self = (BirdFontGlyph*) base;
	_tmp0_ = self->priv->undo_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		_g_object_unref0 (tool);
		_g_object_unref0 (g);
		return;
	}
	_tmp3_ = bird_font_main_window_get_toolbox ();
	_tmp4_ = _tmp3_;
	_tmp5_ = bird_font_toolbox_get_current_tool (_tmp4_);
	_g_object_unref0 (tool);
	tool = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp6_ = tool;
	bird_font_tool_before_undo (_tmp6_);
	_tmp7_ = self->priv->undo_list;
	_tmp8_ = self->priv->undo_list;
	_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp10_ - 1);
	_g_object_unref0 (g);
	g = (BirdFontGlyph*) _tmp11_;
	bird_font_glyph_store_redo_state (self);
	_tmp12_ = g;
	bird_font_glyph_set_glyph_data (self, _tmp12_);
	_tmp13_ = self->priv->undo_list;
	_tmp14_ = self->priv->undo_list;
	_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp13_, _tmp16_ - 1);
	_tmp18_ = (BirdFontGlyph*) _tmp17_;
	_g_object_unref0 (_tmp18_);
	bird_font_drawing_tools_update_layers ();
	bird_font_pen_tool_update_selected_points ();
	bird_font_glyph_clear_active_paths (self);
	_tmp19_ = tool;
	bird_font_tool_after_undo (_tmp19_);
	_g_object_unref0 (tool);
	_g_object_unref0 (g);
}

static void
bird_font_glyph_real_redo (BirdFontFontDisplay* base)
{
	BirdFontGlyph * self;
	BirdFontGlyph* g = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	BirdFontGlyph* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gpointer _tmp13_;
	BirdFontGlyph* _tmp14_;
	self = (BirdFontGlyph*) base;
	_tmp0_ = self->priv->redo_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		_g_object_unref0 (g);
		return;
	}
	_tmp3_ = self->priv->redo_list;
	_tmp4_ = self->priv->redo_list;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
	_g_object_unref0 (g);
	g = (BirdFontGlyph*) _tmp7_;
	bird_font_glyph_store_undo_state (self, FALSE);
	_tmp8_ = g;
	bird_font_glyph_set_glyph_data (self, _tmp8_);
	_tmp9_ = self->priv->redo_list;
	_tmp10_ = self->priv->redo_list;
	_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp9_, _tmp12_ - 1);
	_tmp14_ = (BirdFontGlyph*) _tmp13_;
	_g_object_unref0 (_tmp14_);
	bird_font_drawing_tools_update_layers ();
	bird_font_pen_tool_update_selected_points ();
	bird_font_glyph_clear_active_paths (self);
	_g_object_unref0 (g);
}

static void
bird_font_glyph_set_glyph_data (BirdFontGlyph* self,
                                BirdFontGlyph* g)
{
	BirdFontLayer* _tmp0_;
	BirdFontLayer* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontBackgroundImage* _tmp17_;
	BirdFontWidgetAllocation* _tmp29_;
	BirdFontWidgetAllocation* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	self->current_layer = g->current_layer;
	_tmp0_ = g->layers;
	_tmp1_ = bird_font_layer_copy (_tmp0_);
	_g_object_unref0 (self->layers);
	self->layers = _tmp1_;
	_tmp2_ = bird_font_glyph_get_left_limit (g);
	_tmp3_ = _tmp2_;
	bird_font_glyph_set_left_limit (self, _tmp3_);
	_tmp4_ = bird_font_glyph_get_right_limit (g);
	_tmp5_ = _tmp4_;
	bird_font_glyph_set_right_limit (self, _tmp5_);
	bird_font_glyph_remove_lines (self);
	{
		GeeArrayList* _line_list = NULL;
		GeeArrayList* _tmp6_;
		gint _line_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _line_index = 0;
		_tmp6_ = bird_font_glyph_get_all_help_lines (g);
		_line_list = _tmp6_;
		_tmp7_ = _line_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_line_size = _tmp9_;
		_line_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontLine* line = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			BirdFontLine* _tmp14_;
			BirdFontLine* _tmp15_;
			BirdFontLine* _tmp16_;
			_line_index = _line_index + 1;
			_tmp10_ = _line_index;
			_tmp11_ = _line_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _line_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _line_index);
			line = (BirdFontLine*) _tmp13_;
			_tmp14_ = line;
			_tmp15_ = bird_font_line_copy (_tmp14_);
			_tmp16_ = _tmp15_;
			bird_font_glyph_add_line (self, _tmp16_);
			_g_object_unref0 (_tmp16_);
			_g_object_unref0 (line);
		}
		_g_object_unref0 (_line_list);
	}
	bird_font_glyph_add_help_lines (self);
	_tmp17_ = g->priv->background_image;
	if (_tmp17_ != NULL) {
		BirdFontBackgroundImage* _tmp18_;
		BirdFontBackgroundImage* _tmp19_;
		_tmp18_ = g->priv->background_image;
		_tmp19_ = bird_font_background_image_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage));
		_g_object_unref0 (self->priv->background_image);
		self->priv->background_image = _tmp19_;
	}
	bird_font_glyph_clear_active_paths (self);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp20_;
		gint _p_size = 0;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _p_index = 0;
		_tmp20_ = g->active_paths;
		_p_list = _tmp20_;
		_tmp21_ = _p_list;
		_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_p_size = _tmp23_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp26_;
			gpointer _tmp27_;
			BirdFontPath* _tmp28_;
			_p_index = _p_index + 1;
			_tmp24_ = _p_index;
			_tmp25_ = _p_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _p_list;
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _p_index);
			p = (BirdFontPath*) _tmp27_;
			_tmp28_ = p;
			bird_font_glyph_add_active_path (self, NULL, _tmp28_);
			_g_object_unref0 (p);
		}
	}
	_tmp29_ = self->allocation;
	_tmp30_ = self->allocation;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) 0, (gdouble) 0, (gdouble) _tmp29_->width, (gdouble) _tmp30_->height);
}

/** Split curve in two parts and add a new point in between.
 * @return the new point
 */
void
bird_font_glyph_insert_new_point_on_path (BirdFontGlyph* self,
                                          gdouble x,
                                          gdouble y)
{
	gdouble min = 0.0;
	gdouble distance = 0.0;
	BirdFontPath* p = NULL;
	BirdFontPath* path = NULL;
	BirdFontEditPoint* np = NULL;
	BirdFontEditPoint* lep = NULL;
	gdouble xt = 0.0;
	gdouble yt = 0.0;
	BirdFontPath* _tmp17_;
	BirdFontPath* _tmp18_;
	BirdFontPath* _tmp19_;
	BirdFontEditPoint* _tmp20_;
	BirdFontPath* _tmp21_;
	BirdFontEditPoint* _tmp22_;
	BirdFontPath* _tmp23_;
	BirdFontEditPoint* _tmp24_;
	g_return_if_fail (self != NULL);
	p = NULL;
	np = NULL;
	xt = ((x * bird_font_glyph_ivz ()) - bird_font_glyph_xc ()) + self->view_offset_x;
	yt = (bird_font_glyph_yc () - (y * bird_font_glyph_ivz ())) - self->view_offset_y;
	min = DBL_MAX;
	{
		GeeArrayList* _pp_list = NULL;
		GeeArrayList* _tmp0_;
		gint _pp_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _pp_index = 0;
		_tmp0_ = bird_font_glyph_get_visible_paths (self);
		_pp_list = _tmp0_;
		_tmp1_ = _pp_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_pp_size = _tmp3_;
		_pp_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* pp = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontEditPoint* _tmp8_;
			BirdFontPath* _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			_pp_index = _pp_index + 1;
			_tmp4_ = _pp_index;
			_tmp5_ = _pp_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _pp_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _pp_index);
			pp = (BirdFontPath*) _tmp7_;
			_tmp8_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
			_g_object_unref0 (lep);
			lep = _tmp8_;
			_tmp9_ = pp;
			_tmp10_ = lep;
			bird_font_path_get_closest_point_on_path (_tmp9_, _tmp10_, xt, yt, NULL, NULL, -1);
			_tmp11_ = lep;
			_tmp12_ = lep;
			distance = sqrt (pow (fabs (xt - _tmp11_->x), (gdouble) 2) + pow (fabs (yt - _tmp12_->y), (gdouble) 2));
			if (distance < min) {
				BirdFontPath* _tmp13_;
				BirdFontPath* _tmp14_;
				BirdFontEditPoint* _tmp15_;
				BirdFontEditPoint* _tmp16_;
				min = distance;
				_tmp13_ = pp;
				_tmp14_ = _g_object_ref0 (_tmp13_);
				_g_object_unref0 (p);
				p = _tmp14_;
				_tmp15_ = lep;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (np);
				np = _tmp16_;
			}
			_g_object_unref0 (pp);
		}
		_g_object_unref0 (_pp_list);
	}
	_tmp17_ = p;
	if (_tmp17_ == NULL) {
		_g_object_unref0 (lep);
		_g_object_unref0 (np);
		_g_object_unref0 (path);
		_g_object_unref0 (p);
		return;
	}
	_tmp18_ = p;
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, BIRD_FONT_TYPE_PATH, BirdFontPath));
	_g_object_unref0 (path);
	path = _tmp19_;
	_tmp20_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (lep);
	lep = _tmp20_;
	_tmp21_ = path;
	_tmp22_ = lep;
	bird_font_path_get_closest_point_on_path (_tmp21_, _tmp22_, xt, yt, NULL, NULL, -1);
	_tmp23_ = path;
	_tmp24_ = lep;
	bird_font_path_insert_new_point_on_path (_tmp23_, _tmp24_, (gdouble) -1, FALSE);
	_g_object_unref0 (lep);
	_g_object_unref0 (np);
	_g_object_unref0 (path);
	_g_object_unref0 (p);
}

static gboolean
bird_font_glyph_in_range (gdouble offset_x,
                          gdouble coordinate_x1,
                          gdouble coordinate_x2)
{
	gdouble _tmp0_;
	gboolean result;
	_tmp0_ = offset_x;
	result = (coordinate_x1 <= _tmp0_) && (_tmp0_ <= coordinate_x2);
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

void
bird_font_glyph_juxtapose (BirdFontGlyph* self,
                           BirdFontWidgetAllocation* allocation,
                           cairo_t* cr)
{
	gchar* glyph_sequence = NULL;
	gchar* _tmp0_;
	gunichar c = 0U;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp2_;
	BirdFontGlyph* juxtaposed = NULL;
	GString* current = NULL;
	GString* _tmp3_;
	gint pos = 0;
	gchar* name = NULL;
	gdouble x = 0.0;
	gdouble kern = 0.0;
	gdouble left = 0.0;
	gdouble baseline = 0.0;
	gchar* last_name = NULL;
	gdouble box_x1 = 0.0;
	gdouble box_x2 = 0.0;
	gdouble box_y1 = 0.0;
	gdouble box_y2 = 0.0;
	gdouble marker_x = 0.0;
	gdouble marker_y = 0.0;
	BirdFontKerningClasses* classes = NULL;
	BirdFontFont* _tmp4_;
	BirdFontKerningClasses* _tmp5_;
	GString* _tmp6_;
	BirdFontGlyph* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	BirdFontFont* _tmp11_;
	BirdFontGlyph* _tmp12_;
	BirdFontLine* _tmp13_;
	BirdFontLine* _tmp14_;
	BirdFontGlyph* _tmp15_;
	BirdFontGlyph* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	BirdFontGlyph* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_preferences_get ("glyph_sequence");
	glyph_sequence = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	_tmp2_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp2_;
	_tmp3_ = g_string_new ("");
	current = _tmp3_;
	_tmp4_ = font;
	_tmp5_ = bird_font_font_get_kerning_classes (_tmp4_);
	classes = _tmp5_;
	x = (gdouble) 0;
	box_x1 = bird_font_glyph_path_coordinate_x ((gdouble) 0);
	box_y1 = bird_font_glyph_path_coordinate_y ((gdouble) 0);
	box_x2 = bird_font_glyph_path_coordinate_x ((gdouble) allocation->width);
	box_y2 = bird_font_glyph_path_coordinate_y ((gdouble) allocation->height);
	_tmp6_ = current;
	_tmp7_ = glyph;
	g_string_append_unichar (_tmp6_, _tmp7_->unichar_code);
	_tmp8_ = glyph_sequence;
	_tmp9_ = current;
	_tmp10_ = _tmp9_->str;
	pos = string_index_of (_tmp8_, _tmp10_, 0);
	_tmp11_ = font;
	baseline = _tmp11_->base_line;
	_tmp12_ = glyph;
	_tmp13_ = bird_font_glyph_get_line (_tmp12_, "left");
	_tmp14_ = _tmp13_;
	left = _tmp14_->pos;
	_g_object_unref0 (_tmp14_);
	_tmp15_ = glyph;
	x = bird_font_glyph_get_width (_tmp15_);
	_tmp16_ = glyph;
	_tmp17_ = _tmp16_->name;
	_tmp18_ = g_strdup (_tmp17_);
	_g_free0 (last_name);
	last_name = _tmp18_;
	{
		gint i = 0;
		i = pos + 1;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				BirdFontGlyph* _tmp24_ = NULL;
				BirdFontFont* _tmp25_;
				const gchar* _tmp26_;
				BirdFontGlyph* _tmp34_;
				gboolean _tmp35_ = FALSE;
				BirdFontFont* _tmp36_;
				const gchar* _tmp37_;
				gboolean _tmp43_ = FALSE;
				BirdFontGlyph* _tmp44_;
				BirdFontGlyph* _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = glyph_sequence;
				if (!(i < g_utf8_strlen (_tmp21_, (gssize) -1))) {
					break;
				}
				_tmp22_ = glyph_sequence;
				c = string_get_char (_tmp22_, (glong) i);
				_tmp23_ = g_unichar_to_string (c);
				_g_free0 (name);
				name = (gchar*) _tmp23_;
				_tmp25_ = font;
				_tmp26_ = name;
				if (bird_font_font_has_glyph (_tmp25_, _tmp26_)) {
					BirdFontFont* _tmp27_;
					const gchar* _tmp28_;
					BirdFontGlyph* _tmp29_;
					_tmp27_ = font;
					_tmp28_ = name;
					_tmp29_ = bird_font_font_get_glyph (_tmp27_, _tmp28_);
					_g_object_unref0 (_tmp24_);
					_tmp24_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph);
				} else {
					BirdFontFont* _tmp30_;
					BirdFontGlyphCollection* _tmp31_;
					BirdFontGlyphCollection* _tmp32_;
					BirdFontGlyph* _tmp33_;
					_tmp30_ = font;
					_tmp31_ = bird_font_font_get_space (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = bird_font_glyph_collection_get_current (_tmp32_);
					_g_object_unref0 (_tmp24_);
					_tmp24_ = _tmp33_;
					_g_object_unref0 (_tmp32_);
				}
				_tmp34_ = _g_object_ref0 (_tmp24_);
				_g_object_unref0 (juxtaposed);
				juxtaposed = _tmp34_;
				_tmp36_ = font;
				_tmp37_ = last_name;
				if (bird_font_font_has_glyph (_tmp36_, _tmp37_)) {
					BirdFontFont* _tmp38_;
					const gchar* _tmp39_;
					_tmp38_ = font;
					_tmp39_ = name;
					_tmp35_ = bird_font_font_has_glyph (_tmp38_, _tmp39_);
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					BirdFontKerningClasses* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					_tmp40_ = classes;
					_tmp41_ = last_name;
					_tmp42_ = name;
					kern = bird_font_kerning_classes_get_kerning (_tmp40_, _tmp41_, _tmp42_);
				} else {
					kern = (gdouble) 0;
				}
				_tmp44_ = juxtaposed;
				if (!bird_font_glyph_is_empty (_tmp44_)) {
					gboolean _tmp45_ = FALSE;
					if (bird_font_glyph_in_range ((left + x) + kern, box_x1, box_x2)) {
						_tmp45_ = TRUE;
					} else {
						BirdFontGlyph* _tmp46_;
						_tmp46_ = juxtaposed;
						_tmp45_ = bird_font_glyph_in_range (((left + x) + kern) + bird_font_glyph_get_width (_tmp46_), box_x1, box_x2);
					}
					_tmp43_ = _tmp45_;
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					BirdFontGlyph* _tmp47_;
					BirdFontGlyph* _tmp48_;
					BirdFontGlyph* _tmp49_;
					BirdFontGlyph* _tmp50_;
					BirdFontGlyph* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp47_ = glyph;
					marker_x = (((bird_font_glyph_xc () + left) + x) + kern) - _tmp47_->view_offset_x;
					_tmp48_ = glyph;
					marker_y = (bird_font_glyph_yc () - baseline) - _tmp48_->view_offset_y;
					cairo_save (cr);
					_tmp49_ = glyph;
					_tmp50_ = glyph;
					cairo_scale (cr, _tmp49_->view_zoom, _tmp50_->view_zoom);
					bird_font_theme_color (cr, "Foreground 1");
					_tmp51_ = juxtaposed;
					_tmp52_ = bird_font_glyph_get_svg_data (_tmp51_);
					_tmp53_ = _tmp52_;
					bird_font_svg_draw_svg_path (cr, _tmp53_, marker_x, marker_y);
					_g_free0 (_tmp53_);
					cairo_restore (cr);
				}
				_tmp54_ = juxtaposed;
				x += bird_font_glyph_get_width (_tmp54_) + kern;
				_tmp55_ = name;
				_tmp56_ = g_strdup (_tmp55_);
				_g_free0 (last_name);
				last_name = _tmp56_;
				_g_object_unref0 (_tmp24_);
			}
		}
	}
	x = (gdouble) 0;
	_tmp57_ = glyph;
	_tmp58_ = _tmp57_->name;
	_tmp59_ = g_strdup (_tmp58_);
	_g_free0 (last_name);
	last_name = _tmp59_;
	{
		gint i = 0;
		i = pos - 1;
		{
			gboolean _tmp60_ = FALSE;
			_tmp60_ = TRUE;
			while (TRUE) {
				const gchar* _tmp62_;
				gchar* _tmp63_;
				BirdFontGlyph* _tmp64_ = NULL;
				BirdFontFont* _tmp65_;
				const gchar* _tmp66_;
				BirdFontGlyph* _tmp74_;
				gboolean _tmp75_ = FALSE;
				BirdFontFont* _tmp76_;
				const gchar* _tmp77_;
				BirdFontGlyph* _tmp83_;
				gboolean _tmp84_ = FALSE;
				BirdFontGlyph* _tmp85_;
				const gchar* _tmp95_;
				gchar* _tmp96_;
				if (!_tmp60_) {
					gint _tmp61_;
					_tmp61_ = i;
					i = _tmp61_ - 1;
				}
				_tmp60_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp62_ = glyph_sequence;
				c = string_get_char (_tmp62_, (glong) i);
				_tmp63_ = g_unichar_to_string (c);
				_g_free0 (name);
				name = (gchar*) _tmp63_;
				_tmp65_ = font;
				_tmp66_ = name;
				if (bird_font_font_has_glyph (_tmp65_, _tmp66_)) {
					BirdFontFont* _tmp67_;
					const gchar* _tmp68_;
					BirdFontGlyph* _tmp69_;
					_tmp67_ = font;
					_tmp68_ = name;
					_tmp69_ = bird_font_font_get_glyph (_tmp67_, _tmp68_);
					_g_object_unref0 (_tmp64_);
					_tmp64_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph);
				} else {
					BirdFontFont* _tmp70_;
					BirdFontGlyphCollection* _tmp71_;
					BirdFontGlyphCollection* _tmp72_;
					BirdFontGlyph* _tmp73_;
					_tmp70_ = font;
					_tmp71_ = bird_font_font_get_space (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = bird_font_glyph_collection_get_current (_tmp72_);
					_g_object_unref0 (_tmp64_);
					_tmp64_ = _tmp73_;
					_g_object_unref0 (_tmp72_);
				}
				_tmp74_ = _g_object_ref0 (_tmp64_);
				_g_object_unref0 (juxtaposed);
				juxtaposed = _tmp74_;
				_tmp76_ = font;
				_tmp77_ = last_name;
				if (bird_font_font_has_glyph (_tmp76_, _tmp77_)) {
					BirdFontFont* _tmp78_;
					const gchar* _tmp79_;
					_tmp78_ = font;
					_tmp79_ = name;
					_tmp75_ = bird_font_font_has_glyph (_tmp78_, _tmp79_);
				} else {
					_tmp75_ = FALSE;
				}
				if (_tmp75_) {
					BirdFontKerningClasses* _tmp80_;
					const gchar* _tmp81_;
					const gchar* _tmp82_;
					_tmp80_ = classes;
					_tmp81_ = name;
					_tmp82_ = last_name;
					kern = bird_font_kerning_classes_get_kerning (_tmp80_, _tmp81_, _tmp82_);
				} else {
					kern = (gdouble) 0;
				}
				_tmp83_ = juxtaposed;
				x -= bird_font_glyph_get_width (_tmp83_);
				x -= kern;
				marker_x = (bird_font_glyph_xc () + left) + x;
				marker_y = bird_font_glyph_yc () - baseline;
				_tmp85_ = juxtaposed;
				if (!bird_font_glyph_is_empty (_tmp85_)) {
					gboolean _tmp86_ = FALSE;
					if (bird_font_glyph_in_range (left + x, box_x1, box_x2)) {
						_tmp86_ = TRUE;
					} else {
						BirdFontGlyph* _tmp87_;
						_tmp87_ = juxtaposed;
						_tmp86_ = bird_font_glyph_in_range ((left + x) + bird_font_glyph_get_width (_tmp87_), box_x1, box_x2);
					}
					_tmp84_ = _tmp86_;
				} else {
					_tmp84_ = FALSE;
				}
				if (_tmp84_) {
					BirdFontGlyph* _tmp88_;
					BirdFontGlyph* _tmp89_;
					BirdFontGlyph* _tmp90_;
					BirdFontGlyph* _tmp91_;
					BirdFontGlyph* _tmp92_;
					gchar* _tmp93_;
					gchar* _tmp94_;
					cairo_save (cr);
					_tmp88_ = glyph;
					_tmp89_ = glyph;
					cairo_scale (cr, _tmp88_->view_zoom, _tmp89_->view_zoom);
					_tmp90_ = glyph;
					_tmp91_ = glyph;
					cairo_translate (cr, -_tmp90_->view_offset_x, -_tmp91_->view_offset_y);
					bird_font_theme_color (cr, "Foreground 1");
					_tmp92_ = juxtaposed;
					_tmp93_ = bird_font_glyph_get_svg_data (_tmp92_);
					_tmp94_ = _tmp93_;
					bird_font_svg_draw_svg_path (cr, _tmp94_, marker_x, marker_y);
					_g_free0 (_tmp94_);
					cairo_restore (cr);
				}
				_tmp95_ = name;
				_tmp96_ = g_strdup (_tmp95_);
				_g_free0 (last_name);
				last_name = _tmp96_;
				_g_object_unref0 (_tmp64_);
			}
		}
	}
	_g_object_unref0 (classes);
	_g_free0 (last_name);
	_g_free0 (name);
	_g_string_free0 (current);
	_g_object_unref0 (juxtaposed);
	_g_object_unref0 (glyph);
	_g_object_unref0 (font);
	_g_free0 (glyph_sequence);
}

/** @return left side bearing */
gdouble
bird_font_glyph_get_lsb (BirdFontGlyph* self)
{
	BirdFontLine* _tmp0_;
	BirdFontLine* _tmp1_;
	gdouble _tmp2_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = bird_font_glyph_get_line (self, "left");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->pos;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/** @return bottom line */
gdouble
bird_font_glyph_get_baseline (BirdFontGlyph* self)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	result = font->base_line;
	_g_object_unref0 (font);
	return result;
}

static void
bird_font_glyph_draw_background_glyph (BirdFontGlyph* self,
                                       BirdFontWidgetAllocation* allocation,
                                       cairo_t* cr)
{
	gdouble left = 0.0;
	gdouble baseline = 0.0;
	gdouble current_left = 0.0;
	BirdFontGlyph* g = NULL;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontLine* _tmp1_;
	BirdFontLine* _tmp2_;
	BirdFontGlyph* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = bird_font_glyph_get_line (self, "left");
	_tmp2_ = _tmp1_;
	current_left = _tmp2_->pos;
	_g_object_unref0 (_tmp2_);
	_tmp3_ = bird_font_glyph_background_glyph;
	if (_tmp3_ != NULL) {
		BirdFontGlyph* _tmp4_;
		BirdFontGlyph* _tmp5_;
		BirdFontFont* _tmp6_;
		BirdFontGlyph* _tmp7_;
		BirdFontLine* _tmp8_;
		BirdFontLine* _tmp9_;
		BirdFontGlyph* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp4_ = bird_font_glyph_background_glyph;
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
		_g_object_unref0 (g);
		g = _tmp5_;
		_tmp6_ = font;
		baseline = _tmp6_->base_line;
		_tmp7_ = g;
		_tmp8_ = bird_font_glyph_get_line (_tmp7_, "left");
		_tmp9_ = _tmp8_;
		left = _tmp9_->pos;
		_g_object_unref0 (_tmp9_);
		cairo_save (cr);
		cairo_scale (cr, self->view_zoom, self->view_zoom);
		cairo_translate (cr, -self->view_offset_x, -self->view_offset_y);
		bird_font_theme_color (cr, "Background Glyph");
		_tmp10_ = g;
		_tmp11_ = bird_font_glyph_get_svg_data (_tmp10_);
		_tmp12_ = _tmp11_;
		bird_font_svg_draw_svg_path (cr, _tmp12_, (bird_font_glyph_xc () + left) - (left - current_left), bird_font_glyph_yc () - baseline);
		_g_free0 (_tmp12_);
		cairo_restore (cr);
	}
	_g_object_unref0 (font);
	_g_object_unref0 (g);
}

gchar*
bird_font_glyph_get_hex (BirdFontGlyph* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_to_hex_code (self->unichar_code);
	result = _tmp0_;
	return result;
}

static void
bird_font_glyph_real_move_view (BirdFontFontDisplay* base,
                                gdouble x,
                                gdouble y)
{
	BirdFontGlyph * self;
	self = (BirdFontGlyph*) base;
	self->view_offset_x = self->view_offset_x + (x / self->view_zoom);
	self->view_offset_y = self->view_offset_y + (y / self->view_zoom);
	bird_font_glyph_canvas_redraw ();
}

/** Scroll or zoom from tap events. */
void
bird_font_glyph_change_view_event (BirdFontGlyph* self,
                                   gint finger,
                                   gint x,
                                   gint y)
{
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	gdouble last_distance = 0.0;
	gdouble new_distance = 0.0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	dx = (gdouble) 0;
	dy = (gdouble) 0;
	new_distance = (gdouble) 0;
	if (self->priv->last_tap0_y == -1) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->last_tap0_x == -1;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->last_tap1_y == -1;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->last_tap1_x == -1;
	}
	if (_tmp0_) {
		return;
	}
	if (finger == 0) {
		dx = (gdouble) (self->priv->last_tap0_x - x);
		dy = (gdouble) (self->priv->last_tap0_y - y);
		new_distance = bird_font_path_distance ((gdouble) self->priv->last_tap1_x, (gdouble) x, (gdouble) self->priv->last_tap1_y, (gdouble) y);
	}
	if (finger == 1) {
		dx = (gdouble) (self->priv->last_tap1_x - x);
		dy = (gdouble) (self->priv->last_tap1_y - y);
		new_distance = bird_font_path_distance ((gdouble) self->priv->last_tap0_x, (gdouble) x, (gdouble) self->priv->last_tap0_y, (gdouble) y);
	}
	last_distance = bird_font_path_distance ((gdouble) self->priv->last_tap0_x, (gdouble) self->priv->last_tap1_x, (gdouble) self->priv->last_tap0_y, (gdouble) self->priv->last_tap1_y);
	if (self->priv->zoom_distance != ((gdouble) 0)) {
		bird_font_glyph_zoom_tap (self, self->priv->zoom_distance - new_distance);
	}
	if (finger == 1) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp3_ = double_to_string (dx);
		_tmp4_ = _tmp3_;
		_tmp5_ = double_to_string (dy);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("%i", self->priv->last_tap1_x);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("%i", self->priv->last_tap1_y);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%i", x);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("%i", y);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat ("dx ", _tmp4_, " dy ", _tmp6_, " last_tap1_x ", _tmp8_, "  last_tap1_y ", _tmp10_, "   x ", _tmp12_, "  y ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		g_warning ("Glyph.vala:2225: %s", _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		bird_font_font_display_move_view ((BirdFontFontDisplay*) self, dx, dy);
	}
	self->priv->zoom_distance = new_distance;
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		BirdFontGlyph* self;
		self = _data18_->self;
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static gboolean
___lambda176_ (Block18Data* _data18_)
{
	BirdFontGlyph* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data18_->self;
	if (!self->priv->change_view) {
		_tmp0_ = !self->priv->ignore_input;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		bird_font_font_display_button_press ((BirdFontFontDisplay*) self, (guint) 1, (gdouble) _data18_->x, (gdouble) _data18_->y);
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda176__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda176_ (self);
	return result;
}

static void
bird_font_glyph_real_tap_down (BirdFontFontDisplay* base,
                               gint finger,
                               gint x,
                               gint y)
{
	BirdFontGlyph * self;
	Block18Data* _data18_;
	GSource* delay = NULL;
	self = (BirdFontGlyph*) base;
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_data18_->x = x;
	_data18_->y = y;
	if (finger == 0) {
		GSource* _tmp0_;
		GSource* _tmp1_;
		GSource* _tmp2_;
		_tmp0_ = g_timeout_source_new ((guint) 400);
		_g_source_unref0 (delay);
		delay = _tmp0_;
		_tmp1_ = delay;
		g_source_set_callback (_tmp1_, ____lambda176__gsource_func, block18_data_ref (_data18_), block18_data_unref);
		_tmp2_ = delay;
		g_source_attach (_tmp2_, NULL);
		self->priv->last_tap0_x = _data18_->x;
		self->priv->last_tap0_y = _data18_->y;
	}
	if (finger == 1) {
		self->priv->change_view = TRUE;
		self->priv->last_tap1_x = _data18_->x;
		self->priv->last_tap1_y = _data18_->y;
	}
	_g_source_unref0 (delay);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}

static void
bird_font_glyph_real_tap_up (BirdFontFontDisplay* base,
                             gint finger,
                             gint x,
                             gint y)
{
	BirdFontGlyph * self;
	self = (BirdFontGlyph*) base;
	if (finger == 0) {
		bird_font_font_display_button_release ((BirdFontFontDisplay*) self, 1, (gdouble) x, (gdouble) y);
		self->priv->last_tap0_x = -1;
		self->priv->last_tap0_y = -1;
	}
	if (finger == 1) {
		self->priv->last_tap1_x = -1;
		self->priv->last_tap1_y = -1;
		self->priv->change_view = FALSE;
		self->priv->zoom_distance = (gdouble) 0;
	}
}

static void
bird_font_glyph_real_tap_move (BirdFontFontDisplay* base,
                               gint finger,
                               gint x,
                               gint y)
{
	BirdFontGlyph * self;
	self = (BirdFontGlyph*) base;
	if (!self->priv->change_view) {
		bird_font_font_display_motion_notify ((BirdFontFontDisplay*) self, (gdouble) x, (gdouble) y);
	} else {
		bird_font_glyph_change_view_event (self, finger, x, y);
	}
	if (finger == 0) {
		self->priv->last_tap0_x = x;
		self->priv->last_tap0_y = y;
	}
	if (finger == 1) {
		self->priv->last_tap1_x = x;
		self->priv->last_tap1_y = y;
	}
}

void
bird_font_glyph_update_spacing_class (BirdFontGlyph* self)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyphCollection* g = NULL;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyph* glyph = NULL;
	GeeArrayList* s = NULL;
	BirdFontSpacingData* sd = NULL;
	BirdFontFont* _tmp1_;
	BirdFontSpacingData* _tmp2_;
	BirdFontSpacingData* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeArrayList* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = font;
	_tmp2_ = bird_font_font_get_spacing (_tmp1_);
	_g_object_unref0 (sd);
	sd = _tmp2_;
	_tmp3_ = sd;
	_tmp4_ = g_unichar_to_string (self->unichar_code);
	_tmp5_ = (gchar*) _tmp4_;
	_tmp6_ = bird_font_spacing_data_get_all_connections (_tmp3_, _tmp5_);
	_g_object_unref0 (s);
	s = _tmp6_;
	_g_free0 (_tmp5_);
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp7_;
		gint _l_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _l_index = 0;
		_tmp7_ = s;
		_l_list = _tmp7_;
		_tmp8_ = _l_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_l_size = _tmp10_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gchar* l = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_;
			_l_index = _l_index + 1;
			_tmp11_ = _l_index;
			_tmp12_ = _l_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _l_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _l_index);
			l = (gchar*) _tmp14_;
			_tmp15_ = l;
			_tmp16_ = g_unichar_to_string (self->unichar_code);
			_tmp17_ = (gchar*) _tmp16_;
			_tmp18_ = g_strcmp0 (_tmp15_, _tmp17_) != 0;
			_g_free0 (_tmp17_);
			if (_tmp18_) {
				BirdFontFont* _tmp19_;
				const gchar* _tmp20_;
				BirdFontGlyphCollection* _tmp21_;
				BirdFontGlyphCollection* _tmp22_;
				_tmp19_ = font;
				_tmp20_ = l;
				_tmp21_ = bird_font_font_get_glyph_collection (_tmp19_, _tmp20_);
				_g_object_unref0 (g);
				g = _tmp21_;
				_tmp22_ = g;
				if (_tmp22_ != NULL) {
					BirdFontGlyphCollection* _tmp23_;
					BirdFontGlyphCollection* _tmp24_;
					BirdFontGlyphCollection* _tmp25_;
					BirdFontGlyph* _tmp26_;
					BirdFontGlyph* _tmp27_;
					gdouble _tmp28_;
					gdouble _tmp29_;
					BirdFontGlyph* _tmp30_;
					gdouble _tmp31_;
					gdouble _tmp32_;
					BirdFontGlyph* _tmp33_;
					gdouble _tmp34_;
					gdouble _tmp35_;
					BirdFontGlyph* _tmp36_;
					gdouble _tmp37_;
					gdouble _tmp38_;
					_tmp23_ = g;
					_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
					_g_object_unref0 (gc);
					gc = _tmp24_;
					_tmp25_ = gc;
					_tmp26_ = bird_font_glyph_collection_get_current (_tmp25_);
					_g_object_unref0 (glyph);
					glyph = _tmp26_;
					_tmp27_ = glyph;
					_tmp28_ = bird_font_glyph_get_left_limit (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = glyph;
					_tmp31_ = bird_font_glyph_get_right_limit (_tmp30_);
					_tmp32_ = _tmp31_;
					if (_tmp29_ == _tmp32_) {
						g_warning ("Glyph.vala:2309: Zero width glyph in kerning class.");
					}
					_tmp33_ = glyph;
					_tmp34_ = bird_font_glyph_get_left_limit (_tmp33_);
					_tmp35_ = _tmp34_;
					bird_font_glyph_set_left_limit (self, _tmp35_);
					_tmp36_ = glyph;
					_tmp37_ = bird_font_glyph_get_right_limit (_tmp36_);
					_tmp38_ = _tmp37_;
					bird_font_glyph_set_right_limit (self, _tmp38_);
					_g_free0 (l);
					break;
				}
			}
			_g_free0 (l);
		}
	}
	bird_font_glyph_add_help_lines (self);
	_g_object_unref0 (sd);
	_g_object_unref0 (s);
	_g_object_unref0 (glyph);
	_g_object_unref0 (gc);
	_g_object_unref0 (g);
	_g_object_unref0 (font);
}

void
bird_font_glyph_update_other_spacing_classes (BirdFontGlyph* self)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyphCollection* g = NULL;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyph* glyph = NULL;
	GeeArrayList* s = NULL;
	BirdFontSpacingData* sd = NULL;
	BirdFontFont* _tmp1_;
	BirdFontSpacingData* _tmp2_;
	BirdFontSpacingData* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeArrayList* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = font;
	_tmp2_ = bird_font_font_get_spacing (_tmp1_);
	_g_object_unref0 (sd);
	sd = _tmp2_;
	_tmp3_ = sd;
	_tmp4_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_spacing_data_get_all_connections (_tmp3_, _tmp5_);
	_g_object_unref0 (s);
	s = _tmp6_;
	_g_free0 (_tmp5_);
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp7_;
		gint _l_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _l_index = 0;
		_tmp7_ = s;
		_l_list = _tmp7_;
		_tmp8_ = _l_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_l_size = _tmp10_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gchar* l = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_;
			_l_index = _l_index + 1;
			_tmp11_ = _l_index;
			_tmp12_ = _l_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _l_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _l_index);
			l = (gchar*) _tmp14_;
			_tmp15_ = l;
			_tmp16_ = g_unichar_to_string (self->unichar_code);
			_tmp17_ = (gchar*) _tmp16_;
			_tmp18_ = g_strcmp0 (_tmp15_, _tmp17_) != 0;
			_g_free0 (_tmp17_);
			if (_tmp18_) {
				BirdFontFont* _tmp19_;
				const gchar* _tmp20_;
				BirdFontGlyphCollection* _tmp21_;
				BirdFontGlyphCollection* _tmp22_;
				_tmp19_ = font;
				_tmp20_ = l;
				_tmp21_ = bird_font_font_get_glyph_collection (_tmp19_, _tmp20_);
				_g_object_unref0 (g);
				g = _tmp21_;
				_tmp22_ = g;
				if (_tmp22_ != NULL) {
					BirdFontGlyphCollection* _tmp23_;
					BirdFontGlyphCollection* _tmp24_;
					BirdFontGlyphCollection* _tmp25_;
					BirdFontGlyph* _tmp26_;
					BirdFontGlyph* _tmp27_;
					gdouble _tmp28_;
					gdouble _tmp29_;
					BirdFontGlyph* _tmp30_;
					gdouble _tmp31_;
					gdouble _tmp32_;
					_tmp23_ = g;
					_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
					_g_object_unref0 (gc);
					gc = _tmp24_;
					_tmp25_ = gc;
					_tmp26_ = bird_font_glyph_collection_get_current (_tmp25_);
					_g_object_unref0 (glyph);
					glyph = _tmp26_;
					_tmp27_ = glyph;
					_tmp28_ = bird_font_glyph_get_left_limit (self);
					_tmp29_ = _tmp28_;
					bird_font_glyph_set_left_limit (_tmp27_, _tmp29_);
					_tmp30_ = glyph;
					_tmp31_ = bird_font_glyph_get_right_limit (self);
					_tmp32_ = _tmp31_;
					bird_font_glyph_set_right_limit (_tmp30_, _tmp32_);
				}
			}
			_g_free0 (l);
		}
	}
	_g_object_unref0 (sd);
	_g_object_unref0 (s);
	_g_object_unref0 (glyph);
	_g_object_unref0 (gc);
	_g_object_unref0 (g);
	_g_object_unref0 (font);
}

void
bird_font_glyph_set_cache (BirdFontGlyph* self,
                           const gchar* key,
                           cairo_surface_t* cache)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (cache != NULL);
	_tmp0_ = self->priv->glyph_cache;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, key, cache);
}

gboolean
bird_font_glyph_has_cache (BirdFontGlyph* self,
                           const gchar* key)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->glyph_cache;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, key);
	return result;
}

cairo_surface_t*
bird_font_glyph_get_cache (BirdFontGlyph* self,
                           const gchar* key)
{
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	if (G_UNLIKELY (!bird_font_glyph_has_cache (self, key))) {
		cairo_surface_t* _tmp0_;
		g_warning ("Glyph.vala:2357: No cache for glyph.");
		_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 1, 1);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->glyph_cache;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, key);
	result = (cairo_surface_t*) _tmp2_;
	return result;
}

static void
__lambda545_ (BirdFontGlyph* self,
              const gchar* text)
{
	gchar* _tmp0_;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->priv->new_guide_name);
	self->priv->new_guide_name = _tmp0_;
}

static void
___lambda545__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda545_ ((BirdFontGlyph*) self, text);
}

static void
__lambda546_ (BirdFontGlyph* self)
{
	BirdFontLine* guide = NULL;
	gdouble position = 0.0;
	BirdFontWidgetAllocation* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	BirdFontLine* _tmp3_;
	GeeArrayList* _tmp4_;
	BirdFontFont* _tmp5_;
	BirdFontFont* _tmp6_;
	GeeArrayList* _tmp7_;
	_tmp0_ = self->allocation;
	position = bird_font_glyph_path_coordinate_y (_tmp0_->height / 2.0);
	_tmp1_ = self->priv->new_guide_name;
	_tmp2_ = self->priv->new_guide_name;
	_tmp3_ = bird_font_line_new (_tmp1_, _tmp2_, position, FALSE);
	_g_object_unref0 (guide);
	guide = _tmp3_;
	_tmp4_ = self->horizontal_help_lines;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, guide);
	_tmp5_ = bird_font_bird_font_get_current_font ();
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->custom_guides;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, guide);
	_g_object_unref0 (_tmp6_);
	bird_font_tab_content_hide_text_input ();
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (guide);
}

static void
___lambda546__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda546_ ((BirdFontGlyph*) self);
}

void
bird_font_glyph_add_custom_guide (BirdFontGlyph* self)
{
	BirdFontTextListener* listener = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BirdFontTextListener* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_t_ ("Guide");
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_t_ ("Add");
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_text_listener_new (_tmp1_, "", _tmp3_);
	_g_object_unref0 (listener);
	listener = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	g_signal_connect_object (listener, "signal-text-input", (GCallback) ___lambda545__bird_font_text_listener_signal_text_input, self, 0);
	g_signal_connect_object (listener, "signal-submit", (GCallback) ___lambda546__bird_font_text_listener_signal_submit, self, 0);
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
}

BirdFontPath*
bird_font_glyph_get_last_path (BirdFontGlyph* self)
{
	GeeArrayList* paths = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_glyph_get_all_paths (self);
	paths = _tmp0_;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) paths);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (_tmp2_ > 0, NULL);
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) paths);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) paths, _tmp4_ - 1);
	result = (BirdFontPath*) _tmp5_;
	_g_object_unref0 (paths);
	return result;
}

void
bird_font_glyph_move_layer_up (BirdFontGlyph* self)
{
	BirdFontLayer* layer = NULL;
	BirdFontLayer* _tmp0_;
	BirdFontLayer* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_glyph_get_current_layer (self);
	layer = _tmp0_;
	_tmp1_ = self->layers;
	_tmp2_ = _tmp1_->subgroups;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if ((self->current_layer + 2) <= _tmp4_) {
		BirdFontLayer* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		BirdFontLayer* _tmp10_;
		GeeArrayList* _tmp11_;
		BirdFontLayer* _tmp12_;
		BirdFontLayer* _tmp13_;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		BirdFontLayer* _tmp18_;
		GeeArrayList* _tmp19_;
		gpointer _tmp20_;
		BirdFontLayer* _tmp21_;
		BirdFontLayer* _tmp22_;
		_tmp5_ = self->layers;
		_tmp6_ = _tmp5_->subgroups;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->current_layer + 2;
		g_return_if_fail ((0 <= _tmp9_) && (_tmp9_ <= _tmp8_));
		_tmp10_ = self->layers;
		_tmp11_ = _tmp10_->subgroups;
		_tmp12_ = layer;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp11_, self->current_layer + 2, _tmp12_);
		_tmp13_ = self->layers;
		_tmp14_ = _tmp13_->subgroups;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->current_layer + 1;
		g_return_if_fail ((0 <= _tmp17_) && (_tmp17_ < _tmp16_));
		_tmp18_ = self->layers;
		_tmp19_ = _tmp18_->subgroups;
		_tmp20_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp19_, self->current_layer);
		_tmp21_ = (BirdFontLayer*) _tmp20_;
		_g_object_unref0 (_tmp21_);
		_tmp22_ = layer;
		bird_font_glyph_set_current_layer (self, _tmp22_);
	}
	_g_object_unref0 (layer);
}

void
bird_font_glyph_move_layer_down (BirdFontGlyph* self)
{
	BirdFontLayer* layer = NULL;
	BirdFontLayer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_glyph_get_current_layer (self);
	layer = _tmp0_;
	if (self->current_layer >= 1) {
		BirdFontLayer* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		BirdFontLayer* _tmp6_;
		GeeArrayList* _tmp7_;
		BirdFontLayer* _tmp8_;
		BirdFontLayer* _tmp9_;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		BirdFontLayer* _tmp14_;
		GeeArrayList* _tmp15_;
		gpointer _tmp16_;
		BirdFontLayer* _tmp17_;
		BirdFontLayer* _tmp18_;
		_tmp1_ = self->layers;
		_tmp2_ = _tmp1_->subgroups;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->current_layer - 1;
		g_return_if_fail ((0 <= _tmp5_) && (_tmp5_ < _tmp4_));
		_tmp6_ = self->layers;
		_tmp7_ = _tmp6_->subgroups;
		_tmp8_ = layer;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp7_, self->current_layer - 1, _tmp8_);
		_tmp9_ = self->layers;
		_tmp10_ = _tmp9_->subgroups;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->current_layer + 1;
		g_return_if_fail ((0 <= _tmp13_) && (_tmp13_ < _tmp12_));
		_tmp14_ = self->layers;
		_tmp15_ = _tmp14_->subgroups;
		_tmp16_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp15_, self->current_layer + 1);
		_tmp17_ = (BirdFontLayer*) _tmp16_;
		_g_object_unref0 (_tmp17_);
		_tmp18_ = layer;
		bird_font_glyph_set_current_layer (self, _tmp18_);
	}
	_g_object_unref0 (layer);
}

void
bird_font_glyph_fix_curve_orientation (BirdFontGlyph* self)
{
	gint inside_count = 0;
	gboolean inside = FALSE;
	BirdFontPath* outline = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _p1_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p1_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p1_index = 0;
		_tmp0_ = bird_font_glyph_get_visible_paths (self);
		_p1_list = _tmp0_;
		_tmp1_ = _p1_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p1_size = _tmp3_;
		_p1_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p1 = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_p1_index = _p1_index + 1;
			_tmp4_ = _p1_index;
			_tmp5_ = _p1_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p1_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p1_index);
			p1 = (BirdFontPath*) _tmp7_;
			inside_count = 0;
			{
				GeeArrayList* _p2_list = NULL;
				GeeArrayList* _tmp8_;
				gint _p2_size = 0;
				GeeArrayList* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _p2_index = 0;
				_tmp8_ = bird_font_glyph_get_visible_paths (self);
				_p2_list = _tmp8_;
				_tmp9_ = _p2_list;
				_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
				_tmp11_ = _tmp10_;
				_p2_size = _tmp11_;
				_p2_index = -1;
				while (TRUE) {
					gint _tmp12_;
					gint _tmp13_;
					BirdFontPath* p2 = NULL;
					GeeArrayList* _tmp14_;
					gpointer _tmp15_;
					BirdFontPath* _tmp16_;
					BirdFontPath* _tmp17_;
					_p2_index = _p2_index + 1;
					_tmp12_ = _p2_index;
					_tmp13_ = _p2_size;
					if (!(_tmp12_ < _tmp13_)) {
						break;
					}
					_tmp14_ = _p2_list;
					_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _p2_index);
					p2 = (BirdFontPath*) _tmp15_;
					_tmp16_ = p1;
					_tmp17_ = p2;
					if (_tmp16_ != _tmp17_) {
						BirdFontPath* _tmp18_;
						BirdFontPath* _tmp19_;
						inside = TRUE;
						_tmp18_ = p2;
						_tmp19_ = bird_font_path_flatten (_tmp18_, 100);
						_g_object_unref0 (outline);
						outline = _tmp19_;
						{
							GeeArrayList* _ep_list = NULL;
							BirdFontPath* _tmp20_;
							GeeArrayList* _tmp21_;
							GeeArrayList* _tmp22_;
							gint _ep_size = 0;
							GeeArrayList* _tmp23_;
							gint _tmp24_;
							gint _tmp25_;
							gint _ep_index = 0;
							_tmp20_ = p1;
							_tmp21_ = bird_font_path_get_points (_tmp20_);
							_tmp22_ = _tmp21_;
							_ep_list = _tmp22_;
							_tmp23_ = _ep_list;
							_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
							_tmp25_ = _tmp24_;
							_ep_size = _tmp25_;
							_ep_index = -1;
							while (TRUE) {
								gint _tmp26_;
								gint _tmp27_;
								BirdFontEditPoint* ep = NULL;
								GeeArrayList* _tmp28_;
								gpointer _tmp29_;
								BirdFontEditPoint* _tmp30_;
								BirdFontPath* _tmp31_;
								_ep_index = _ep_index + 1;
								_tmp26_ = _ep_index;
								_tmp27_ = _ep_size;
								if (!(_tmp26_ < _tmp27_)) {
									break;
								}
								_tmp28_ = _ep_list;
								_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _ep_index);
								ep = (BirdFontEditPoint*) _tmp29_;
								_tmp30_ = ep;
								_tmp31_ = outline;
								if (!bird_font_svg_parser_is_inside (_tmp30_, _tmp31_)) {
									inside = FALSE;
								}
								_g_object_unref0 (ep);
							}
						}
						if (inside) {
							gint _tmp32_;
							_tmp32_ = inside_count;
							inside_count = _tmp32_ + 1;
						}
					}
					_g_object_unref0 (p2);
				}
				_g_object_unref0 (_p2_list);
			}
			if ((inside_count % 2) == 0) {
				BirdFontPath* _tmp33_;
				_tmp33_ = p1;
				bird_font_path_force_direction (_tmp33_, BIRD_FONT_DIRECTION_CLOCKWISE);
			} else {
				BirdFontPath* _tmp34_;
				_tmp34_ = p1;
				bird_font_path_force_direction (_tmp34_, BIRD_FONT_DIRECTION_COUNTER_CLOCKWISE);
			}
			_g_object_unref0 (p1);
		}
		_g_object_unref0 (_p1_list);
	}
	_g_object_unref0 (outline);
}

static void
bird_font_glyph_real_magnify (BirdFontFontDisplay* base,
                              gdouble magnification)
{
	BirdFontGlyph * self;
	gdouble x_center = 0.0;
	gdouble y_center = 0.0;
	self = (BirdFontGlyph*) base;
	x_center = bird_font_glyph_path_coordinate_x (bird_font_glyph_xc ());
	y_center = bird_font_glyph_path_coordinate_y (bird_font_glyph_yc ());
	self->view_zoom = self->view_zoom * (1 + magnification);
	self->view_offset_x = self->view_offset_x - (bird_font_glyph_path_coordinate_x (bird_font_glyph_xc ()) - x_center);
	self->view_offset_y = self->view_offset_y + (bird_font_glyph_path_coordinate_y (bird_font_glyph_yc ()) - y_center);
	bird_font_glyph_canvas_redraw ();
}

BirdFontGlyph*
bird_font_glyph_self_interpolate (BirdFontGlyph* self,
                                  gdouble weight)
{
	BirdFontGlyph* g1 = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* g2 = NULL;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontGlyph* _tmp3_;
	BirdFontLayer* _tmp4_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_glyph_copy (self);
	g1 = _tmp0_;
	_tmp1_ = bird_font_glyph_copy (self);
	g2 = _tmp1_;
	_tmp2_ = g1;
	bird_font_glyph_fix_curve_orientation (_tmp2_);
	_tmp3_ = g2;
	_tmp4_ = bird_font_layer_new ();
	_g_object_unref0 (_tmp3_->layers);
	_tmp3_->layers = _tmp4_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _p_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _p_index = 0;
		_tmp5_ = g1;
		_tmp6_ = bird_font_glyph_get_visible_paths (_tmp5_);
		_p_list = _tmp6_;
		_tmp7_ = _p_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_p_size = _tmp9_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			gboolean counter = FALSE;
			BirdFontPath* _tmp14_;
			BirdFontGlyph* _tmp15_;
			BirdFontPath* _tmp16_;
			BirdFontPath* _tmp17_;
			BirdFontPath* _tmp18_;
			BirdFontPath* _tmp19_;
			BirdFontPath* master = NULL;
			BirdFontPath* _tmp20_;
			BirdFontPath* _tmp21_;
			BirdFontPath* _tmp22_;
			BirdFontPath* _tmp23_;
			BirdFontPath* _tmp24_;
			BirdFontPath* _tmp25_;
			BirdFontGlyph* _tmp26_;
			BirdFontPath* _tmp27_;
			BirdFontGlyph* _tmp28_;
			BirdFontPath* _tmp29_;
			_p_index = _p_index + 1;
			_tmp10_ = _p_index;
			_tmp11_ = _p_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _p_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _p_index);
			p = (BirdFontPath*) _tmp13_;
			_tmp14_ = p;
			counter = !bird_font_path_is_clockwise (_tmp14_);
			_tmp15_ = g2;
			_tmp16_ = p;
			_tmp17_ = bird_font_path_copy (_tmp16_);
			_tmp18_ = _tmp17_;
			bird_font_glyph_add_path (_tmp15_, _tmp18_);
			_g_object_unref0 (_tmp18_);
			_tmp19_ = p;
			bird_font_path_remove_points_on_points (_tmp19_, 0.00001);
			_tmp20_ = p;
			_tmp21_ = bird_font_path_get_self_interpolated_master (_tmp20_, counter, weight);
			master = _tmp21_;
			_tmp22_ = p;
			_tmp23_ = master;
			_tmp24_ = bird_font_path_interpolate_estimated_path (_tmp22_, _tmp23_, weight);
			_g_object_unref0 (p);
			p = _tmp24_;
			_tmp25_ = p;
			bird_font_path_recalculate_linear_handles (_tmp25_);
			_tmp26_ = g2;
			_tmp27_ = p;
			bird_font_glyph_add_path (_tmp26_, _tmp27_);
			_tmp28_ = g2;
			_tmp29_ = master;
			bird_font_glyph_add_path (_tmp28_, _tmp29_);
			_g_object_unref0 (master);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	result = g2;
	_g_object_unref0 (g1);
	return result;
}

gdouble
bird_font_glyph_get_left_limit (BirdFontGlyph* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_left_limit;
	return result;
}

void
bird_font_glyph_set_left_limit (BirdFontGlyph* self,
                                gdouble value)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->ttf_data);
	self->priv->ttf_data = NULL;
	self->priv->_left_limit = value;
	g_object_notify_by_pspec ((GObject *) self, bird_font_glyph_properties[BIRD_FONT_GLYPH_LEFT_LIMIT_PROPERTY]);
}

gdouble
bird_font_glyph_get_right_limit (BirdFontGlyph* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_right_limit;
	return result;
}

void
bird_font_glyph_set_right_limit (BirdFontGlyph* self,
                                 gdouble value)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->ttf_data);
	self->priv->ttf_data = NULL;
	self->priv->_right_limit = value;
	g_object_notify_by_pspec ((GObject *) self, bird_font_glyph_properties[BIRD_FONT_GLYPH_RIGHT_LIMIT_PROPERTY]);
}

static void
bird_font_glyph_class_init (BirdFontGlyphClass * klass,
                            gpointer klass_data)
{
	bird_font_glyph_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontGlyph_private_offset);
	((BirdFontFontDisplayClass *) klass)->close = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_close;
	((BirdFontFontDisplayClass *) klass)->scroll_wheel = (void (*) (BirdFontFontDisplay*, gdouble, gdouble, gdouble, gdouble)) bird_font_glyph_real_scroll_wheel;
	((BirdFontGlyphClass *) klass)->add_path = (void (*) (BirdFontGlyph*, BirdFontPath*)) bird_font_glyph_real_add_path;
	((BirdFontFontDisplayClass *) klass)->selected_canvas = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_selected_canvas;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_glyph_real_get_name;
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_glyph_real_get_label;
	((BirdFontFontDisplayClass *) klass)->key_release = (void (*) (BirdFontFontDisplay*, guint)) bird_font_glyph_real_key_release;
	((BirdFontFontDisplayClass *) klass)->key_press = (void (*) (BirdFontFontDisplay*, guint)) bird_font_glyph_real_key_press;
	((BirdFontFontDisplayClass *) klass)->motion_notify = (void (*) (BirdFontFontDisplay*, gdouble, gdouble)) bird_font_glyph_real_motion_notify;
	((BirdFontFontDisplayClass *) klass)->button_release = (void (*) (BirdFontFontDisplay*, gint, gdouble, gdouble)) bird_font_glyph_real_button_release;
	((BirdFontFontDisplayClass *) klass)->double_click = (void (*) (BirdFontFontDisplay*, guint, gdouble, gdouble)) bird_font_glyph_real_double_click;
	((BirdFontFontDisplayClass *) klass)->button_press = (void (*) (BirdFontFontDisplay*, guint, gdouble, gdouble)) bird_font_glyph_real_button_press;
	((BirdFontFontDisplayClass *) klass)->zoom_in = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_zoom_in;
	((BirdFontFontDisplayClass *) klass)->zoom_out = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_zoom_out;
	((BirdFontFontDisplayClass *) klass)->zoom_max = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_zoom_max;
	((BirdFontFontDisplayClass *) klass)->zoom_min = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_zoom_min;
	((BirdFontFontDisplayClass *) klass)->store_current_view = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_store_current_view;
	((BirdFontFontDisplayClass *) klass)->restore_last_view = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_restore_last_view;
	((BirdFontFontDisplayClass *) klass)->next_view = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_next_view;
	((BirdFontFontDisplayClass *) klass)->reset_zoom = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_reset_zoom;
	((BirdFontFontDisplayClass *) klass)->draw = (void (*) (BirdFontFontDisplay*, BirdFontWidgetAllocation*, cairo_t*)) bird_font_glyph_real_draw;
	((BirdFontFontDisplayClass *) klass)->undo = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_undo;
	((BirdFontFontDisplayClass *) klass)->redo = (void (*) (BirdFontFontDisplay*)) bird_font_glyph_real_redo;
	((BirdFontFontDisplayClass *) klass)->move_view = (void (*) (BirdFontFontDisplay*, gdouble, gdouble)) bird_font_glyph_real_move_view;
	((BirdFontFontDisplayClass *) klass)->tap_down = (void (*) (BirdFontFontDisplay*, gint, gint, gint)) bird_font_glyph_real_tap_down;
	((BirdFontFontDisplayClass *) klass)->tap_up = (void (*) (BirdFontFontDisplay*, gint, gint, gint)) bird_font_glyph_real_tap_up;
	((BirdFontFontDisplayClass *) klass)->tap_move = (void (*) (BirdFontFontDisplay*, gint, gint, gint)) bird_font_glyph_real_tap_move;
	((BirdFontFontDisplayClass *) klass)->magnify = (void (*) (BirdFontFontDisplay*, gdouble)) bird_font_glyph_real_magnify;
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_glyph_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_glyph_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_glyph_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_GLYPH_LEFT_LIMIT_PROPERTY, bird_font_glyph_properties[BIRD_FONT_GLYPH_LEFT_LIMIT_PROPERTY] = g_param_spec_double ("left-limit", "left-limit", "left-limit", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_GLYPH_RIGHT_LIMIT_PROPERTY, bird_font_glyph_properties[BIRD_FONT_GLYPH_RIGHT_LIMIT_PROPERTY] = g_param_spec_double ("right-limit", "right-limit", "right-limit", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
bird_font_glyph_instance_init (BirdFontGlyph * self,
                               gpointer klass)
{
	GeeArrayList* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gchar* _tmp7_;
	GeeHashMap* _tmp8_;
	BirdFontLayer* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	self->priv = bird_font_glyph_get_instance_private (self);
	self->priv->background_image = NULL;
	self->priv->background_image_visible = TRUE;
	self->view_zoom = 0.1;
	self->view_offset_x = (gdouble) 0;
	self->view_offset_y = (gdouble) 0;
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_ZOOM_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->zoom_list = _tmp0_;
	self->priv->zoom_list_index = 0;
	self->priv->pointer_begin_x = (gdouble) 0;
	self->priv->pointer_begin_y = (gdouble) 0;
	self->priv->last_tap0_y = 0;
	self->priv->last_tap0_x = 0;
	self->priv->last_tap1_y = 0;
	self->priv->last_tap1_x = 0;
	self->priv->zoom_distance = (gdouble) 0;
	self->priv->ignore_input = FALSE;
	self->motion_x = (gdouble) 0;
	self->motion_y = (gdouble) 0;
	self->zoom_x1 = (gdouble) 0;
	self->zoom_y1 = (gdouble) 0;
	self->zoom_x2 = (gdouble) 0;
	self->zoom_y2 = (gdouble) 0;
	self->zoom_area_is_visible = FALSE;
	self->priv->view_is_moving = FALSE;
	self->move_offset_x = (gdouble) 0;
	self->move_offset_y = (gdouble) 0;
	self->priv->move_canvas = FALSE;
	_tmp1_ = bird_font_widget_allocation_new ();
	self->allocation = _tmp1_;
	self->unichar_code = (gunichar) 0;
	self->priv->_right_limit = (gdouble) 0;
	self->priv->_left_limit = (gdouble) 0;
	_tmp2_ = gee_array_list_new (BIRD_FONT_TYPE_LINE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->vertical_help_lines = _tmp2_;
	_tmp3_ = gee_array_list_new (BIRD_FONT_TYPE_LINE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->horizontal_help_lines = _tmp3_;
	self->show_help_lines = TRUE;
	self->priv->xheight_lines_visible = FALSE;
	self->priv->margin_boundaries_visible = FALSE;
	_tmp4_ = g_strdup ("");
	self->priv->new_guide_name = _tmp4_;
	_tmp5_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->undo_list = _tmp5_;
	_tmp6_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->redo_list = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->priv->glyph_sequence = _tmp7_;
	self->priv->open = TRUE;
	self->priv->empty = FALSE;
	self->version_id = 0;
	self->priv->ttf_data = NULL;
	_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, cairo_gobject_surface_get_type (), (GBoxedCopyFunc) cairo_surface_reference, (GDestroyNotify) cairo_surface_destroy, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->glyph_cache = _tmp8_;
	_tmp9_ = bird_font_layer_new ();
	self->layers = _tmp9_;
	self->current_layer = 0;
	_tmp10_ = gee_array_list_new (BIRD_FONT_TYPE_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->active_paths = _tmp10_;
	_tmp11_ = gee_array_list_new (BIRD_FONT_TYPE_LAYER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->selected_groups = _tmp11_;
	self->top_limit = (gdouble) 0;
	self->baseline = (gdouble) 0;
	self->bottom_limit = (gdouble) 0;
	self->overview_thumbnail = NULL;
}

static void
bird_font_glyph_finalize (GObject * obj)
{
	BirdFontGlyph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph);
	_g_object_unref0 (self->priv->background_image);
	_g_object_unref0 (self->priv->zoom_list);
	_g_object_unref0 (self->allocation);
	_g_free0 (self->name);
	_g_object_unref0 (self->vertical_help_lines);
	_g_object_unref0 (self->horizontal_help_lines);
	_g_free0 (self->priv->new_guide_name);
	_g_object_unref0 (self->priv->undo_list);
	_g_object_unref0 (self->priv->redo_list);
	_g_free0 (self->priv->glyph_sequence);
	_g_object_unref0 (self->priv->ttf_data);
	_g_object_unref0 (self->priv->left_line);
	_g_object_unref0 (self->priv->right_line);
	_g_object_unref0 (self->priv->glyph_cache);
	_g_object_unref0 (self->layers);
	_g_object_unref0 (self->active_paths);
	_g_object_unref0 (self->selected_groups);
	_cairo_surface_destroy0 (self->overview_thumbnail);
	G_OBJECT_CLASS (bird_font_glyph_parent_class)->finalize (obj);
}

static GType
bird_font_glyph_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontGlyphClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_glyph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontGlyph), 0, (GInstanceInitFunc) bird_font_glyph_instance_init, NULL };
	GType bird_font_glyph_type_id;
	bird_font_glyph_type_id = g_type_register_static (BIRD_FONT_TYPE_FONT_DISPLAY, "BirdFontGlyph", &g_define_type_info, 0);
	BirdFontGlyph_private_offset = g_type_add_instance_private (bird_font_glyph_type_id, sizeof (BirdFontGlyphPrivate));
	return bird_font_glyph_type_id;
}

GType
bird_font_glyph_get_type (void)
{
	static volatile gsize bird_font_glyph_type_id__once = 0;
	if (g_once_init_enter (&bird_font_glyph_type_id__once)) {
		GType bird_font_glyph_type_id;
		bird_font_glyph_type_id = bird_font_glyph_get_type_once ();
		g_once_init_leave (&bird_font_glyph_type_id__once, bird_font_glyph_type_id);
	}
	return bird_font_glyph_type_id__once;
}

static void
_vala_bird_font_glyph_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	BirdFontGlyph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph);
	switch (property_id) {
		case BIRD_FONT_GLYPH_LEFT_LIMIT_PROPERTY:
		g_value_set_double (value, bird_font_glyph_get_left_limit (self));
		break;
		case BIRD_FONT_GLYPH_RIGHT_LIMIT_PROPERTY:
		g_value_set_double (value, bird_font_glyph_get_right_limit (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_glyph_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	BirdFontGlyph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph);
	switch (property_id) {
		case BIRD_FONT_GLYPH_LEFT_LIMIT_PROPERTY:
		bird_font_glyph_set_left_limit (self, g_value_get_double (value));
		break;
		case BIRD_FONT_GLYPH_RIGHT_LIMIT_PROPERTY:
		bird_font_glyph_set_right_limit (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

