/* GlyfTable.c generated by valac 0.56.16, the Vala compiler
 * generated from GlyfTable.vala, do not modify */

/*
Copyright (C) 2012, 2013, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <stdio.h>

#define BIRD_FONT_GLYF_TABLE_BOTH_ARE_WORDS ((guint16) (1 << 0))
#define BIRD_FONT_GLYF_TABLE_BOTH_ARE_XY_VALUES ((guint16) (1 << 1))
#define BIRD_FONT_GLYF_TABLE_ROUND_TO_GRID ((guint16) (1 << 2))
#define BIRD_FONT_GLYF_TABLE_SCALE ((guint16) (1 << 3))
#define BIRD_FONT_GLYF_TABLE_RESERVED ((guint16) (1 << 4))
#define BIRD_FONT_GLYF_TABLE_MORE_COMPONENTS ((guint16) (1 << 5))
#define BIRD_FONT_GLYF_TABLE_SCALE_X_Y ((guint16) (1 << 6))
#define BIRD_FONT_GLYF_TABLE_SCALE_WITH_ROTATTION ((guint16) (1 << 7))
#define BIRD_FONT_GLYF_TABLE_INSTRUCTIONS ((guint16) (1 << 8))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_GLYF_TABLE_0_PROPERTY,
	BIRD_FONT_GLYF_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_glyf_table_properties[BIRD_FONT_GLYF_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define BIRD_FONT_TYPE_BAD_FORMAT (bird_font_bad_format_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontGlyfTablePrivate {
	guint16 max_points;
	guint16 max_contours;
};

typedef enum  {
	BIRD_FONT_BAD_FORMAT_PARSE
} BirdFontBadFormat;
#define BIRD_FONT_BAD_FORMAT bird_font_bad_format_quark ()

static gint BirdFontGlyfTable_private_offset;
static gpointer bird_font_glyf_table_parent_class = NULL;

static gint __lambda350_ (BirdFontGlyfTable* self,
                   BirdFontGlyphCollection* a,
                   BirdFontGlyphCollection* b);
static gint ___lambda350__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static BirdFontGlyph* bird_font_glyf_table_parse_next_composite_glyf (BirdFontGlyfTable* self,
                                                               BirdFontFontData* dis,
                                                               gunichar character,
                                                               gint pgid,
                                                               GError** error);
static BirdFontGlyph* bird_font_glyf_table_parse_next_glyf (BirdFontGlyfTable* self,
                                                     BirdFontFontData* dis,
                                                     gunichar character,
                                                     gint gid,
                                                     gdouble* xmin,
                                                     gdouble* xmax,
                                                     gdouble units_per_em,
                                                     GError** error);
VALA_EXTERN GQuark bird_font_bad_format_quark (void);
VALA_EXTERN GType bird_font_bad_format_get_type (void) G_GNUC_CONST ;
static void bird_font_glyf_table_finalize (GObject * obj);
static GType bird_font_glyf_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_glyf_table_get_instance_private (BirdFontGlyfTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontGlyfTable_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontGlyfTable*
bird_font_glyf_table_construct (GType object_type,
                                BirdFontLocaTable* l)
{
	BirdFontGlyfTable * self = NULL;
	gchar* _tmp0_;
	BirdFontLocaTable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_val_if_fail (l != NULL, NULL);
	self = (BirdFontGlyfTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = g_strdup ("glyf");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp0_;
	_tmp1_ = _g_object_ref0 (l);
	_g_object_unref0 (self->loca_table);
	self->loca_table = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->location_offsets);
	self->location_offsets = _tmp2_;
	_tmp3_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->glyphs);
	self->glyphs = _tmp3_;
	_tmp4_ = gee_array_list_new (BIRD_FONT_TYPE_GLYF_DATA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->glyf_data);
	self->glyf_data = _tmp4_;
	return self;
}

BirdFontGlyfTable*
bird_font_glyf_table_new (BirdFontLocaTable* l)
{
	return bird_font_glyf_table_construct (BIRD_FONT_TYPE_GLYF_TABLE, l);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gint
bird_font_glyf_table_get_gid (BirdFontGlyfTable* self,
                              const gchar* name)
{
	gint i = 0;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp0_;
		gint _g_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _g_index = 0;
		_tmp0_ = self->glyphs;
		_g_list = _tmp0_;
		_tmp1_ = _g_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_size = _tmp3_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontGlyphCollection* g = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontGlyphCollection* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			gint _tmp12_;
			_g_index = _g_index + 1;
			_tmp4_ = _g_index;
			_tmp5_ = _g_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _g_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _g_index);
			g = (BirdFontGlyphCollection*) _tmp7_;
			_tmp8_ = g;
			_tmp9_ = bird_font_glyph_collection_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, name) == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				result = i;
				_g_object_unref0 (g);
				return result;
			}
			_tmp12_ = i;
			i = _tmp12_ + 1;
			_g_object_unref0 (g);
		}
	}
	_tmp13_ = string_to_string (name);
	_tmp14_ = g_strconcat ("Glyph ", _tmp13_, " not found in font.", NULL);
	_tmp15_ = _tmp14_;
	g_warning ("GlyfTable.vala:69: %s", _tmp15_);
	_g_free0 (_tmp15_);
	result = -1;
	return result;
}

guint16
bird_font_glyf_table_get_max_contours (BirdFontGlyfTable* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->max_contours;
	return result;
}

guint16
bird_font_glyf_table_get_max_points (BirdFontGlyfTable* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->max_points;
	return result;
}

guint16
bird_font_glyf_table_get_first_char (BirdFontGlyfTable* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint16) 32;
	return result;
}

guint16
bird_font_glyf_table_get_last_char (BirdFontGlyfTable* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	BirdFontGlyphCollection* gc = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	BirdFontGlyphCollection* _tmp16_;
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->glyphs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_val_if_fail (_tmp2_ > 0, "glyphs.size > 0", 0U);
	_tmp3_ = self->glyphs;
	_tmp4_ = self->glyphs;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
	gc = (BirdFontGlyphCollection*) _tmp7_;
	{
		gint i = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = self->glyphs;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		i = _tmp10_ - 1;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				BirdFontGlyphCollection* _tmp15_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ - 1;
				}
				_tmp11_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp13_ = self->glyphs;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, i);
				_g_object_unref0 (gc);
				gc = (BirdFontGlyphCollection*) _tmp14_;
				_tmp15_ = gc;
				if (!bird_font_glyph_collection_is_unassigned (_tmp15_)) {
					break;
				}
			}
		}
	}
	_tmp16_ = gc;
	result = (guint16) bird_font_glyph_collection_get_unicode_character (_tmp16_);
	_g_object_unref0 (gc);
	return result;
}

void
bird_font_glyf_table_process (BirdFontGlyfTable* self,
                              GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	guint last_len = 0U;
	guint num_glyphs = 0U;
	BirdFontGlyph* g = NULL;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeArrayList* _tmp39_;
	BirdFontFontData* _tmp40_;
	BirdFontFontData* _tmp41_;
	BirdFontFontData* _tmp42_;
	BirdFontFontData* _tmp43_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	last_len = (guint) 0;
	bird_font_glyf_table_create_glyph_table (self);
	_tmp1_ = self->glyphs;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	num_glyphs = (guint) _tmp3_;
	_tmp4_ = self->glyphs;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		g_warning ("GlyfTable.vala:111: No glyphs in glyf table.");
	}
	{
		GeeArrayList* _gc_list = NULL;
		GeeArrayList* _tmp7_;
		gint _gc_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _gc_index = 0;
		_tmp7_ = self->glyphs;
		_gc_list = _tmp7_;
		_tmp8_ = _gc_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_gc_size = _tmp10_;
		_gc_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			BirdFontGlyphCollection* gc = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			BirdFontGlyphCollection* _tmp15_;
			BirdFontGlyph* _tmp16_;
			BirdFontGlyphCollection* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			BirdFontFontData* _tmp23_;
			GeeArrayList* _tmp24_;
			BirdFontFontData* _tmp25_;
			BirdFontGlyph* _tmp26_;
			BirdFontFontData* _tmp27_;
			BirdFontFontData* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			BirdFontFontData* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			BirdFontFontData* _tmp38_;
			_gc_index = _gc_index + 1;
			_tmp11_ = _gc_index;
			_tmp12_ = _gc_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _gc_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _gc_index);
			gc = (BirdFontGlyphCollection*) _tmp14_;
			_tmp15_ = gc;
			_tmp16_ = bird_font_glyph_collection_get_current (_tmp15_);
			_g_object_unref0 (g);
			g = _tmp16_;
			_tmp17_ = gc;
			_tmp18_ = bird_font_glyph_collection_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = string_to_string (_tmp19_);
			_tmp21_ = g_strconcat ("adding glyph: ", _tmp20_, "\n", NULL);
			_tmp22_ = _tmp21_;
			bird_font_printd (_tmp22_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp19_);
			_tmp23_ = fd;
			_vala_assert ((bird_font_font_data_length (_tmp23_) % 4) == ((guint) 0), "fd.length () % 4 == 0");
			_tmp24_ = self->location_offsets;
			_tmp25_ = fd;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (gpointer) ((guintptr) bird_font_font_data_length (_tmp25_)));
			_tmp26_ = g;
			_tmp27_ = fd;
			bird_font_glyf_table_process_glyph (self, _tmp26_, _tmp27_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (gc);
				_g_object_unref0 (g);
				_g_object_unref0 (fd);
				return;
			}
			_tmp28_ = fd;
			_tmp29_ = g_strdup_printf ("%u", bird_font_font_data_length (_tmp28_) - last_len);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat ("glyf length: ", _tmp30_, "\n", NULL);
			_tmp32_ = _tmp31_;
			bird_font_printd (_tmp32_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = fd;
			_tmp34_ = g_strdup_printf ("%u", bird_font_font_data_length (_tmp33_));
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat ("loca fd.length (): ", _tmp35_, "\n", NULL);
			_tmp37_ = _tmp36_;
			bird_font_printd (_tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_tmp38_ = fd;
			last_len = bird_font_font_data_length (_tmp38_);
			_g_object_unref0 (gc);
		}
	}
	_tmp39_ = self->location_offsets;
	_tmp40_ = fd;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, (gpointer) ((guintptr) bird_font_font_data_length (_tmp40_)));
	_tmp41_ = fd;
	_vala_assert ((bird_font_font_data_length (_tmp41_) % 4) == ((guint) 0), "fd.length () % 4 == 0");
	_tmp42_ = fd;
	_tmp43_ = _g_object_ref0 (_tmp42_);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp43_;
	_g_object_unref0 (g);
	_g_object_unref0 (fd);
}

static gint
__lambda350_ (BirdFontGlyfTable* self,
              BirdFontGlyphCollection* a,
              BirdFontGlyphCollection* b)
{
	BirdFontGlyphCollection* g1 = NULL;
	BirdFontGlyphCollection* g2 = NULL;
	BirdFontGlyphCollection* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
	_g_object_unref0 (g1);
	g1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
	_g_object_unref0 (g2);
	g2 = _tmp1_;
	result = (gint) (bird_font_glyph_collection_get_unicode_character (g1) - bird_font_glyph_collection_get_unicode_character (g2));
	_g_object_unref0 (g2);
	_g_object_unref0 (g1);
	return result;
}

static gint
___lambda350__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda350_ ((BirdFontGlyfTable*) self, (BirdFontGlyphCollection*) a, (BirdFontGlyphCollection*) b);
	return result;
}

void
bird_font_glyf_table_create_glyph_table (BirdFontGlyfTable* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* gcn = NULL;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	guint32 index = 0U;
	GeeArrayList* unassigned_glyphs = NULL;
	gboolean unassigned = FALSE;
	GeeArrayList* _tmp1_;
	BirdFontFont* _tmp2_;
	BirdFontGlyphCollection* _tmp3_;
	BirdFontGlyphCollection* _tmp4_;
	GeeArrayList* _tmp5_;
	BirdFontFont* _tmp6_;
	BirdFontGlyphCollection* _tmp7_;
	BirdFontGlyphCollection* _tmp8_;
	GeeArrayList* _tmp9_;
	BirdFontFont* _tmp10_;
	BirdFontGlyphCollection* _tmp11_;
	BirdFontGlyphCollection* _tmp12_;
	GeeArrayList* _tmp13_;
	BirdFontFont* _tmp14_;
	BirdFontGlyphCollection* _tmp15_;
	BirdFontGlyphCollection* _tmp16_;
	GeeArrayList* _tmp17_;
	BirdFontFont* _tmp18_;
	BirdFontGlyph* _tmp19_;
	BirdFontGlyph* _tmp20_;
	gboolean _tmp21_;
	GeeArrayList* _tmp44_;
	gint gid = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_open_font_format_writer_get_current_font ();
	font = _tmp0_;
	_tmp1_ = self->glyphs;
	_tmp2_ = font;
	_tmp3_ = bird_font_font_get_notdef_character (_tmp2_);
	_tmp4_ = _tmp3_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->glyphs;
	_tmp6_ = font;
	_tmp7_ = bird_font_font_get_null_character (_tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->glyphs;
	_tmp10_ = font;
	_tmp11_ = bird_font_font_get_nonmarking_return (_tmp10_);
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->glyphs;
	_tmp14_ = font;
	_tmp15_ = bird_font_font_get_space (_tmp14_);
	_tmp16_ = _tmp15_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (unassigned_glyphs);
	unassigned_glyphs = _tmp17_;
	_tmp18_ = font;
	_tmp19_ = bird_font_font_get_glyph_index (_tmp18_, (gunichar) 0);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_ == NULL;
	_g_object_unref0 (_tmp20_);
	if (_tmp21_) {
		g_warning ("GlyfTable.vala:157: No glyphs in font.");
	}
	{
		gboolean _tmp22_ = FALSE;
		index = (guint32) 0;
		_tmp22_ = TRUE;
		while (TRUE) {
			BirdFontFont* _tmp24_;
			BirdFontGlyphCollection* _tmp25_;
			BirdFontGlyphCollection* _tmp26_;
			BirdFontGlyphCollection* _tmp27_;
			BirdFontGlyphCollection* _tmp28_;
			BirdFontGlyphCollection* _tmp29_;
			BirdFontGlyphCollection* _tmp30_;
			BirdFontGlyphCollection* _tmp31_;
			BirdFontGlyph* _tmp32_;
			BirdFontGlyph* _tmp33_;
			BirdFontGlyphCollection* _tmp34_;
			BirdFontGlyph* _tmp37_;
			BirdFontGlyph* _tmp38_;
			BirdFontGlyph* _tmp39_;
			const gchar* _tmp40_;
			BirdFontGlyphCollection* _tmp41_;
			if (!_tmp22_) {
				guint32 _tmp23_;
				_tmp23_ = index;
				index = _tmp23_ + 1;
			}
			_tmp22_ = FALSE;
			_tmp24_ = font;
			_tmp25_ = bird_font_font_get_glyph_collection_index (_tmp24_, (gunichar) index);
			_g_object_unref0 (gcn);
			gcn = _tmp25_;
			_tmp26_ = gcn;
			if (!(_tmp26_ != NULL)) {
				break;
			}
			_tmp27_ = gcn;
			_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			_g_object_unref0 (gc);
			gc = _tmp28_;
			_tmp29_ = gc;
			_tmp30_ = bird_font_glyph_collection_copy_deep (_tmp29_);
			_g_object_unref0 (gc);
			gc = _tmp30_;
			_tmp31_ = gc;
			_tmp32_ = bird_font_glyph_collection_get_current (_tmp31_);
			_g_object_unref0 (g);
			g = _tmp32_;
			_tmp33_ = g;
			bird_font_glyph_remove_empty_paths (_tmp33_);
			_tmp34_ = gc;
			unassigned = bird_font_glyph_collection_is_unassigned (_tmp34_);
			if (unassigned) {
				GeeArrayList* _tmp35_;
				BirdFontGlyphCollection* _tmp36_;
				_tmp35_ = unassigned_glyphs;
				_tmp36_ = gc;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp36_);
			}
			_tmp37_ = g;
			if (_tmp37_->unichar_code <= ((gunichar) 27)) {
				continue;
			}
			_tmp38_ = g;
			if (_tmp38_->unichar_code == ((gunichar) 32)) {
				continue;
			}
			_tmp39_ = g;
			_tmp40_ = _tmp39_->name;
			if (g_strcmp0 (_tmp40_, ".notdef") == 0) {
				continue;
			}
			_tmp41_ = gc;
			if (!bird_font_glyph_collection_is_unassigned (_tmp41_)) {
				GeeArrayList* _tmp42_;
				BirdFontGlyphCollection* _tmp43_;
				_tmp42_ = self->glyphs;
				_tmp43_ = gc;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp43_);
			}
		}
	}
	_tmp44_ = self->glyphs;
	gee_list_sort ((GeeList*) _tmp44_, ___lambda350__gcompare_data_func, g_object_ref (self), g_object_unref);
	{
		GeeArrayList* _ug_list = NULL;
		GeeArrayList* _tmp45_;
		gint _ug_size = 0;
		GeeArrayList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _ug_index = 0;
		_tmp45_ = unassigned_glyphs;
		_ug_list = _tmp45_;
		_tmp46_ = _ug_list;
		_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_ug_size = _tmp48_;
		_ug_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			BirdFontGlyphCollection* ug = NULL;
			GeeArrayList* _tmp51_;
			gpointer _tmp52_;
			GeeArrayList* _tmp53_;
			BirdFontGlyphCollection* _tmp54_;
			_ug_index = _ug_index + 1;
			_tmp49_ = _ug_index;
			_tmp50_ = _ug_size;
			if (!(_tmp49_ < _tmp50_)) {
				break;
			}
			_tmp51_ = _ug_list;
			_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) _tmp51_, _ug_index);
			ug = (BirdFontGlyphCollection*) _tmp52_;
			_tmp53_ = self->glyphs;
			_tmp54_ = ug;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, _tmp54_);
			_g_object_unref0 (ug);
		}
	}
	gid = 0;
	{
		GeeArrayList* _ug_list = NULL;
		GeeArrayList* _tmp55_;
		gint _ug_size = 0;
		GeeArrayList* _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		gint _ug_index = 0;
		_tmp55_ = self->glyphs;
		_ug_list = _tmp55_;
		_tmp56_ = _ug_list;
		_tmp57_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp56_);
		_tmp58_ = _tmp57_;
		_ug_size = _tmp58_;
		_ug_index = -1;
		while (TRUE) {
			gint _tmp59_;
			gint _tmp60_;
			BirdFontGlyphCollection* ug = NULL;
			GeeArrayList* _tmp61_;
			gpointer _tmp62_;
			BirdFontGlyphCollection* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gint _tmp71_;
			_ug_index = _ug_index + 1;
			_tmp59_ = _ug_index;
			_tmp60_ = _ug_size;
			if (!(_tmp59_ < _tmp60_)) {
				break;
			}
			_tmp61_ = _ug_list;
			_tmp62_ = gee_abstract_list_get ((GeeAbstractList*) _tmp61_, _ug_index);
			ug = (BirdFontGlyphCollection*) _tmp62_;
			_tmp63_ = ug;
			_tmp64_ = bird_font_glyph_collection_get_name (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = string_to_string (_tmp65_);
			_tmp67_ = g_strdup_printf ("%i", gid);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strconcat ("Glyph: ", _tmp66_, " GID: ", _tmp68_, "\n", NULL);
			_tmp70_ = _tmp69_;
			bird_font_printd (_tmp70_);
			_g_free0 (_tmp70_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp65_);
			_tmp71_ = gid;
			gid = _tmp71_ + 1;
			_g_object_unref0 (ug);
		}
	}
	_g_object_unref0 (unassigned_glyphs);
	_g_object_unref0 (font);
	_g_object_unref0 (gcn);
	_g_object_unref0 (gc);
	_g_object_unref0 (g);
}

void
bird_font_glyf_table_process_glyph (BirdFontGlyfTable* self,
                                    BirdFontGlyph* g,
                                    BirdFontFontData* fd,
                                    GError** error)
{
	guint16 end_point = 0U;
	guint16 npoints = 0U;
	gint16 ncontours = 0;
	guint16 nflags = 0U;
	gint glyph_offset = 0;
	guint len = 0U;
	guint coordinate_length = 0U;
	BirdFontGlyfData* glyf_data = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BirdFontGlyfData* _tmp4_;
	gint points = 0;
	BirdFontGlyfData* _tmp5_;
	GeeArrayList* _tmp30_;
	BirdFontGlyfData* _tmp31_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	GeeArrayList* _tmp34_;
	GeeArrayList* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gboolean _tmp38_;
	BirdFontGlyfData* _tmp44_;
	BirdFontGlyfData* _tmp53_;
	GeeArrayList* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	BirdFontGlyfData* _tmp57_;
	BirdFontGlyfData* _tmp58_;
	BirdFontGlyfData* _tmp59_;
	BirdFontGlyfData* _tmp60_;
	guint glyph_header = 0U;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	BirdFontGlyfData* _tmp80_;
	BirdFontGlyfData* _tmp81_;
	guint16 _tmp82_ = 0U;
	BirdFontGlyfData* _tmp83_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	gchar* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	BirdFontGlyfData* _tmp141_;
	BirdFontGlyfData* _tmp148_;
	BirdFontGlyfData* _tmp155_;
	BirdFontGlyfData* _tmp162_;
	gchar* _tmp169_;
	gchar* _tmp170_;
	gchar* _tmp171_;
	gchar* _tmp172_;
	gchar* _tmp173_;
	gchar* _tmp174_;
	gchar* _tmp175_;
	gchar* _tmp176_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	g_return_if_fail (fd != NULL);
	bird_font_font_data_seek_end (fd);
	glyph_offset = (gint) bird_font_font_data_length (fd);
	_tmp0_ = g_strdup_printf ("%i", glyph_offset);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("glyph_offset: ", _tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	bird_font_printd (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	bird_font_glyph_remove_empty_paths (g);
	_tmp4_ = bird_font_glyph_get_ttf_data (g);
	_g_object_unref0 (glyf_data);
	glyf_data = _tmp4_;
	_tmp5_ = glyf_data;
	points = bird_font_glyf_data_get_num_points (_tmp5_);
	if (G_UNLIKELY (points >= ((gint) G_MAXUINT16))) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		_tmp6_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) g);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strdup_printf ("%i", points);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("Too many points in glyph ", _tmp8_, " (", _tmp10_, ")", NULL);
		_tmp12_ = _tmp11_;
		g_warning ("GlyfTable.vala:229: %s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		_tmp13_ = bird_font_t_ ("Too many control points");
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, " ", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = bird_font_t_ ("in");
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) g);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = g_strconcat (" ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp20_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_inner_error0_ = _tmp29_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (glyf_data);
		return;
	}
	_tmp30_ = self->glyf_data;
	_tmp31_ = glyf_data;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
	_tmp34_ = bird_font_glyph_get_visible_paths (g);
	_tmp35_ = _tmp34_;
	_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _tmp37_ == 0;
	_g_object_unref0 (_tmp35_);
	if (_tmp38_) {
		_tmp33_ = TRUE;
	} else {
		BirdFontGlyfData* _tmp39_;
		GeeArrayList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		_tmp39_ = glyf_data;
		_tmp40_ = _tmp39_->paths;
		_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp33_ = _tmp42_ == 0;
	}
	if (_tmp33_) {
		_tmp32_ = TRUE;
	} else {
		BirdFontGlyfData* _tmp43_;
		_tmp43_ = glyf_data;
		_tmp32_ = ((gint) bird_font_glyf_data_get_ncontours (_tmp43_)) == 0;
	}
	if (_tmp32_) {
		bird_font_glyph_set_empty_ttf (g, TRUE);
		_g_object_unref0 (glyf_data);
		return;
	}
	bird_font_glyph_set_empty_ttf (g, FALSE);
	_tmp44_ = glyf_data;
	if (((gint) bird_font_glyf_data_get_ncontours (_tmp44_)) == 0) {
		gchar* _tmp45_;
		gchar* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp45_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) g);
		_tmp46_ = _tmp45_;
		_tmp47_ = string_to_string (_tmp46_);
		_tmp48_ = bird_font_glyph_get_hex (g);
		_tmp49_ = _tmp48_;
		_tmp50_ = string_to_string (_tmp49_);
		_tmp51_ = g_strconcat ("No paths in ", _tmp47_, " (", _tmp50_, ") can be exported.", NULL);
		_tmp52_ = _tmp51_;
		g_warning ("GlyfTable.vala:245: %s", _tmp52_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp46_);
	}
	_tmp53_ = glyf_data;
	_tmp54_ = _tmp53_->paths;
	_tmp55_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp54_);
	_tmp56_ = _tmp55_;
	ncontours = (gint16) _tmp56_;
	bird_font_font_data_add_short (fd, ncontours, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (glyf_data);
		return;
	}
	_tmp57_ = glyf_data;
	bird_font_font_data_add_16 (fd, _tmp57_->bounding_box_xmin);
	_tmp58_ = glyf_data;
	bird_font_font_data_add_16 (fd, _tmp58_->bounding_box_ymin);
	_tmp59_ = glyf_data;
	bird_font_font_data_add_16 (fd, _tmp59_->bounding_box_xmax);
	_tmp60_ = glyf_data;
	bird_font_font_data_add_16 (fd, _tmp60_->bounding_box_ymax);
	{
		GeeArrayList* _end_list = NULL;
		BirdFontGlyfData* _tmp61_;
		GeeArrayList* _tmp62_;
		gint _end_size = 0;
		GeeArrayList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _end_index = 0;
		_tmp61_ = glyf_data;
		_tmp62_ = _tmp61_->end_points;
		_end_list = _tmp62_;
		_tmp63_ = _end_list;
		_tmp64_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_end_size = _tmp65_;
		_end_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			guint16 end = 0U;
			GeeArrayList* _tmp68_;
			gpointer _tmp69_;
			_end_index = _end_index + 1;
			_tmp66_ = _end_index;
			_tmp67_ = _end_size;
			if (!(_tmp66_ < _tmp67_)) {
				break;
			}
			_tmp68_ = _end_list;
			_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp68_, _end_index);
			end = (guint16) ((guintptr) _tmp69_);
			bird_font_font_data_add_u16 (fd, end);
		}
	}
	bird_font_font_data_add_u16 (fd, (guint16) 0);
	glyph_header = (guint) (12 + (ncontours * 2));
	_tmp70_ = g->name;
	_tmp71_ = string_to_string (_tmp70_);
	_tmp72_ = g_strdup_printf ("%u", (guint32) g->unichar_code);
	_tmp73_ = _tmp72_;
	_tmp74_ = g_strconcat ("next glyf: ", _tmp71_, " (", _tmp73_, ")\n", NULL);
	_tmp75_ = _tmp74_;
	bird_font_printd (_tmp75_);
	_g_free0 (_tmp75_);
	_g_free0 (_tmp73_);
	_tmp76_ = g_strdup_printf ("%u", glyph_header);
	_tmp77_ = _tmp76_;
	_tmp78_ = g_strconcat ("glyf header length: ", _tmp77_, "\n", NULL);
	_tmp79_ = _tmp78_;
	bird_font_printd (_tmp79_);
	_g_free0 (_tmp79_);
	_g_free0 (_tmp77_);
	_tmp80_ = glyf_data;
	end_point = bird_font_glyf_data_get_end_point (_tmp80_);
	_tmp81_ = glyf_data;
	ncontours = bird_font_glyf_data_get_ncontours (_tmp81_);
	if (((gint) ncontours) > 0) {
		_tmp82_ = end_point;
	} else {
		_tmp82_ = (guint16) 0;
	}
	npoints = _tmp82_;
	if (npoints > self->priv->max_points) {
		self->priv->max_points = npoints;
	}
	if (((guint16) ncontours) > self->priv->max_contours) {
		self->priv->max_contours = (guint16) ncontours;
	}
	_tmp83_ = glyf_data;
	nflags = bird_font_glyf_data_get_nflags (_tmp83_);
	if (G_UNLIKELY (nflags != npoints)) {
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		const gchar* _tmp88_;
		const gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		g_print ("glyf table data:\n");
		bird_font_font_data_dump (fd);
		_tmp84_ = g_strdup_printf ("%hu", nflags);
		_tmp85_ = _tmp84_;
		_tmp86_ = g_strdup_printf ("%hu", npoints);
		_tmp87_ = _tmp86_;
		_tmp88_ = g->name;
		_tmp89_ = string_to_string (_tmp88_);
		_tmp90_ = g_strdup_printf ("%" G_GINT16_FORMAT, ncontours);
		_tmp91_ = _tmp90_;
		_tmp92_ = g_strconcat ("(nflags != npoints)  (", _tmp85_, " != ", _tmp87_, ") in glyph ", _tmp89_, ". ncontours: ", _tmp91_, NULL);
		_tmp93_ = _tmp92_;
		g_warning ("GlyfTable.vala:286: %s", _tmp93_);
		_g_free0 (_tmp93_);
		_g_free0 (_tmp91_);
		_g_free0 (_tmp87_);
		_g_free0 (_tmp85_);
	}
	_vala_assert (nflags == npoints, "nflags == npoints");
	{
		GeeArrayList* _flag_list = NULL;
		BirdFontGlyfData* _tmp94_;
		GeeArrayList* _tmp95_;
		gint _flag_size = 0;
		GeeArrayList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _flag_index = 0;
		_tmp94_ = glyf_data;
		_tmp95_ = _tmp94_->flags;
		_flag_list = _tmp95_;
		_tmp96_ = _flag_list;
		_tmp97_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_flag_size = _tmp98_;
		_flag_index = -1;
		while (TRUE) {
			gint _tmp99_;
			gint _tmp100_;
			guint8 flag = 0U;
			GeeArrayList* _tmp101_;
			gpointer _tmp102_;
			_flag_index = _flag_index + 1;
			_tmp99_ = _flag_index;
			_tmp100_ = _flag_size;
			if (!(_tmp99_ < _tmp100_)) {
				break;
			}
			_tmp101_ = _flag_list;
			_tmp102_ = gee_abstract_list_get ((GeeAbstractList*) _tmp101_, _flag_index);
			flag = (guint8) ((guintptr) _tmp102_);
			bird_font_font_data_add_byte (fd, flag, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (glyf_data);
				return;
			}
		}
	}
	_tmp103_ = g_strdup_printf ("%hu", nflags);
	_tmp104_ = _tmp103_;
	_tmp105_ = g_strconcat ("flags: ", _tmp104_, "\n", NULL);
	_tmp106_ = _tmp105_;
	bird_font_printd (_tmp106_);
	_g_free0 (_tmp106_);
	_g_free0 (_tmp104_);
	{
		GeeArrayList* _x_list = NULL;
		BirdFontGlyfData* _tmp107_;
		GeeArrayList* _tmp108_;
		gint _x_size = 0;
		GeeArrayList* _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		gint _x_index = 0;
		_tmp107_ = glyf_data;
		_tmp108_ = _tmp107_->coordinate_x;
		_x_list = _tmp108_;
		_tmp109_ = _x_list;
		_tmp110_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp109_);
		_tmp111_ = _tmp110_;
		_x_size = _tmp111_;
		_x_index = -1;
		while (TRUE) {
			gint _tmp112_;
			gint _tmp113_;
			gint16 x = 0;
			GeeArrayList* _tmp114_;
			gpointer _tmp115_;
			_x_index = _x_index + 1;
			_tmp112_ = _x_index;
			_tmp113_ = _x_size;
			if (!(_tmp112_ < _tmp113_)) {
				break;
			}
			_tmp114_ = _x_list;
			_tmp115_ = gee_abstract_list_get ((GeeAbstractList*) _tmp114_, _x_index);
			x = (gint16) ((gintptr) _tmp115_);
			bird_font_font_data_add_16 (fd, x);
		}
	}
	{
		GeeArrayList* _y_list = NULL;
		BirdFontGlyfData* _tmp116_;
		GeeArrayList* _tmp117_;
		gint _y_size = 0;
		GeeArrayList* _tmp118_;
		gint _tmp119_;
		gint _tmp120_;
		gint _y_index = 0;
		_tmp116_ = glyf_data;
		_tmp117_ = _tmp116_->coordinate_y;
		_y_list = _tmp117_;
		_tmp118_ = _y_list;
		_tmp119_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp118_);
		_tmp120_ = _tmp119_;
		_y_size = _tmp120_;
		_y_index = -1;
		while (TRUE) {
			gint _tmp121_;
			gint _tmp122_;
			gint16 y = 0;
			GeeArrayList* _tmp123_;
			gpointer _tmp124_;
			_y_index = _y_index + 1;
			_tmp121_ = _y_index;
			_tmp122_ = _y_size;
			if (!(_tmp121_ < _tmp122_)) {
				break;
			}
			_tmp123_ = _y_list;
			_tmp124_ = gee_abstract_list_get ((GeeAbstractList*) _tmp123_, _y_index);
			y = (gint16) ((gintptr) _tmp124_);
			bird_font_font_data_add_16 (fd, y);
		}
	}
	len = bird_font_font_data_length (fd);
	coordinate_length = (bird_font_font_data_length (fd) - nflags) - glyph_header;
	_tmp125_ = g_strdup_printf ("%u", coordinate_length);
	_tmp126_ = _tmp125_;
	_tmp127_ = g_strconcat ("coordinate_length: ", _tmp126_, "\n", NULL);
	_tmp128_ = _tmp127_;
	bird_font_printd (_tmp128_);
	_g_free0 (_tmp128_);
	_g_free0 (_tmp126_);
	_tmp129_ = g_strdup_printf ("%u", bird_font_font_data_length (fd));
	_tmp130_ = _tmp129_;
	_tmp131_ = g_strconcat ("fd.length (): ", _tmp130_, "\n", NULL);
	_tmp132_ = _tmp131_;
	bird_font_printd (_tmp132_);
	_g_free0 (_tmp132_);
	_g_free0 (_tmp130_);
	_vala_assert (bird_font_font_data_length (fd) > (nflags + glyph_header), "fd.length () > nflags + glyph_header");
	_tmp133_ = g_strdup_printf ("%i", glyph_offset);
	_tmp134_ = _tmp133_;
	_tmp135_ = g_strconcat ("glyph_offset: ", _tmp134_, "\n", NULL);
	_tmp136_ = _tmp135_;
	bird_font_printd (_tmp136_);
	_g_free0 (_tmp136_);
	_g_free0 (_tmp134_);
	_tmp137_ = g_strdup_printf ("%u", len);
	_tmp138_ = _tmp137_;
	_tmp139_ = g_strconcat ("len: ", _tmp138_, "\n", NULL);
	_tmp140_ = _tmp139_;
	bird_font_printd (_tmp140_);
	_g_free0 (_tmp140_);
	_g_free0 (_tmp138_);
	_tmp141_ = glyf_data;
	if (_tmp141_->bounding_box_xmin < self->xmin) {
		gchar* _tmp142_;
		gchar* _tmp143_;
		const gchar* _tmp144_;
		gchar* _tmp145_;
		gchar* _tmp146_;
		BirdFontGlyfData* _tmp147_;
		_tmp142_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) g);
		_tmp143_ = _tmp142_;
		_tmp144_ = string_to_string (_tmp143_);
		_tmp145_ = g_strconcat ("YMin in ", _tmp144_, "\n", NULL);
		_tmp146_ = _tmp145_;
		bird_font_printd (_tmp146_);
		_g_free0 (_tmp146_);
		_g_free0 (_tmp143_);
		_tmp147_ = glyf_data;
		self->xmin = _tmp147_->bounding_box_xmin;
	}
	_tmp148_ = glyf_data;
	if (_tmp148_->bounding_box_ymin < self->ymin) {
		gchar* _tmp149_;
		gchar* _tmp150_;
		const gchar* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		BirdFontGlyfData* _tmp154_;
		_tmp149_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) g);
		_tmp150_ = _tmp149_;
		_tmp151_ = string_to_string (_tmp150_);
		_tmp152_ = g_strconcat ("YMin in ", _tmp151_, "\n", NULL);
		_tmp153_ = _tmp152_;
		bird_font_printd (_tmp153_);
		_g_free0 (_tmp153_);
		_g_free0 (_tmp150_);
		_tmp154_ = glyf_data;
		self->ymin = _tmp154_->bounding_box_ymin;
	}
	_tmp155_ = glyf_data;
	if (_tmp155_->bounding_box_xmax > self->xmax) {
		gchar* _tmp156_;
		gchar* _tmp157_;
		const gchar* _tmp158_;
		gchar* _tmp159_;
		gchar* _tmp160_;
		BirdFontGlyfData* _tmp161_;
		_tmp156_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) g);
		_tmp157_ = _tmp156_;
		_tmp158_ = string_to_string (_tmp157_);
		_tmp159_ = g_strconcat ("XMax in ", _tmp158_, "\n", NULL);
		_tmp160_ = _tmp159_;
		bird_font_printd (_tmp160_);
		_g_free0 (_tmp160_);
		_g_free0 (_tmp157_);
		_tmp161_ = glyf_data;
		self->xmax = _tmp161_->bounding_box_xmax;
	}
	_tmp162_ = glyf_data;
	if (_tmp162_->bounding_box_ymax > self->ymax) {
		gchar* _tmp163_;
		gchar* _tmp164_;
		const gchar* _tmp165_;
		gchar* _tmp166_;
		gchar* _tmp167_;
		BirdFontGlyfData* _tmp168_;
		_tmp163_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) g);
		_tmp164_ = _tmp163_;
		_tmp165_ = string_to_string (_tmp164_);
		_tmp166_ = g_strconcat ("YMax in ", _tmp165_, "\n", NULL);
		_tmp167_ = _tmp166_;
		bird_font_printd (_tmp167_);
		_g_free0 (_tmp167_);
		_g_free0 (_tmp164_);
		_tmp168_ = glyf_data;
		self->ymax = _tmp168_->bounding_box_ymax;
	}
	_tmp169_ = g_strdup_printf ("%u", bird_font_font_data_length (fd));
	_tmp170_ = _tmp169_;
	_tmp171_ = g_strconcat ("length before padding: ", _tmp170_, "\n", NULL);
	_tmp172_ = _tmp171_;
	bird_font_printd (_tmp172_);
	_g_free0 (_tmp172_);
	_g_free0 (_tmp170_);
	while (TRUE) {
		if (!((bird_font_font_data_length (fd) % 4) != ((guint) 0))) {
			break;
		}
		bird_font_font_data_add (fd, (guint8) 0);
	}
	_tmp173_ = g_strdup_printf ("%u", bird_font_font_data_length (fd));
	_tmp174_ = _tmp173_;
	_tmp175_ = g_strconcat ("length after padding: ", _tmp174_, "\n", NULL);
	_tmp176_ = _tmp175_;
	bird_font_printd (_tmp176_);
	_g_free0 (_tmp176_);
	_g_free0 (_tmp174_);
	_g_object_unref0 (glyf_data);
}

void
bird_font_glyf_table_parse (BirdFontGlyfTable* self,
                            BirdFontFontData* dis,
                            BirdFontCmapTable* cmap_table,
                            BirdFontLocaTable* loca,
                            BirdFontHmtxTable* hmtx_table,
                            BirdFontHeadTable* head_table,
                            BirdFontPostTable* post_table,
                            BirdFontKernTable* kern_table,
                            GError** error)
{
	BirdFontCmapTable* _tmp0_;
	BirdFontPostTable* _tmp1_;
	BirdFontLocaTable* _tmp2_;
	BirdFontHmtxTable* _tmp3_;
	BirdFontHeadTable* _tmp4_;
	BirdFontKernTable* _tmp5_;
	BirdFontFontData* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dis != NULL);
	g_return_if_fail (cmap_table != NULL);
	g_return_if_fail (loca != NULL);
	g_return_if_fail (hmtx_table != NULL);
	g_return_if_fail (head_table != NULL);
	g_return_if_fail (post_table != NULL);
	g_return_if_fail (kern_table != NULL);
	_tmp0_ = _g_object_ref0 (cmap_table);
	_g_object_unref0 (self->cmap_table);
	self->cmap_table = _tmp0_;
	_tmp1_ = _g_object_ref0 (post_table);
	_g_object_unref0 (self->post_table);
	self->post_table = _tmp1_;
	_tmp2_ = _g_object_ref0 (loca);
	_g_object_unref0 (self->loca_table);
	self->loca_table = _tmp2_;
	_tmp3_ = _g_object_ref0 (hmtx_table);
	_g_object_unref0 (self->hmtx_table);
	self->hmtx_table = _tmp3_;
	_tmp4_ = _g_object_ref0 (head_table);
	_g_object_unref0 (self->head_table);
	self->head_table = _tmp4_;
	_tmp5_ = _g_object_ref0 (kern_table);
	_g_object_unref0 (self->kern_table);
	self->kern_table = _tmp5_;
	_tmp6_ = _g_object_ref0 (dis);
	_g_object_unref0 (self->dis);
	self->dis = _tmp6_;
}

static BirdFontGlyph*
bird_font_glyf_table_parse_next_composite_glyf (BirdFontGlyfTable* self,
                                                BirdFontFontData* dis,
                                                gunichar character,
                                                gint pgid,
                                                GError** error)
{
	guint16 component_flags = 0U;
	guint16 glyph_index = 0U;
	gint16 arg1 = 0;
	gint16 arg2 = 0;
	BirdFontF2Dot14 scale = 0U;
	BirdFontF2Dot14 scalex = 0U;
	BirdFontF2Dot14 scaley = 0U;
	BirdFontF2Dot14 scale01 = 0U;
	BirdFontF2Dot14 scale10 = 0U;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* linked_glyph = NULL;
	GeeArrayList* x = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* y = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* gid = NULL;
	GeeArrayList* _tmp2_;
	gdouble xmin = 0.0;
	gdouble xmax = 0.0;
	gdouble units_per_em = 0.0;
	BirdFontHeadTable* _tmp3_;
	gint glid = 0;
	GString* name = NULL;
	GString* _tmp4_;
	GString* _tmp5_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	BirdFontGlyph* _tmp8_;
	GError* _inner_error0_ = NULL;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dis != NULL, NULL);
	component_flags = (guint16) 0;
	arg1 = (gint16) 0;
	arg2 = (gint16) 0;
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	x = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	y = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	gid = _tmp2_;
	_tmp3_ = self->head_table;
	units_per_em = bird_font_head_table_get_units_per_em (_tmp3_);
	_tmp4_ = g_string_new ("");
	name = _tmp4_;
	_tmp5_ = name;
	g_string_append_unichar (_tmp5_, character);
	_tmp6_ = name;
	_tmp7_ = _tmp6_->str;
	_tmp8_ = bird_font_glyph_new (_tmp7_, character);
	_g_object_unref0 (glyph);
	glyph = _tmp8_;
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			GeeArrayList* _tmp14_;
			GeeArrayList* _tmp15_;
			GeeArrayList* _tmp16_;
			if (!_tmp9_) {
				if (!(((gint) (component_flags & BIRD_FONT_GLYF_TABLE_MORE_COMPONENTS)) > 0)) {
					break;
				}
			}
			_tmp9_ = FALSE;
			component_flags = bird_font_font_data_read_ushort (dis);
			glyph_index = bird_font_font_data_read_ushort (dis);
			if (((gint) (component_flags & BIRD_FONT_GLYF_TABLE_BOTH_ARE_WORDS)) > 0) {
				gint16 _tmp10_ = 0;
				gint16 _tmp11_ = 0;
				_tmp10_ = bird_font_font_data_read_short (dis, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (name);
					_g_object_unref0 (gid);
					_g_object_unref0 (y);
					_g_object_unref0 (x);
					_g_object_unref0 (linked_glyph);
					_g_object_unref0 (glyph);
					return NULL;
				}
				arg1 = _tmp10_;
				_tmp11_ = bird_font_font_data_read_short (dis, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (name);
					_g_object_unref0 (gid);
					_g_object_unref0 (y);
					_g_object_unref0 (x);
					_g_object_unref0 (linked_glyph);
					_g_object_unref0 (glyph);
					return NULL;
				}
				arg2 = _tmp11_;
			} else {
				if (((gint) (component_flags & BIRD_FONT_GLYF_TABLE_BOTH_ARE_XY_VALUES)) > 0) {
					guint8 _tmp12_ = 0U;
					guint8 _tmp13_ = 0U;
					_tmp12_ = bird_font_font_data_read_byte (dis, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_string_free0 (name);
						_g_object_unref0 (gid);
						_g_object_unref0 (y);
						_g_object_unref0 (x);
						_g_object_unref0 (linked_glyph);
						_g_object_unref0 (glyph);
						return NULL;
					}
					arg1 = (gint16) _tmp12_;
					_tmp13_ = bird_font_font_data_read_byte (dis, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_string_free0 (name);
						_g_object_unref0 (gid);
						_g_object_unref0 (y);
						_g_object_unref0 (x);
						_g_object_unref0 (linked_glyph);
						_g_object_unref0 (glyph);
						return NULL;
					}
					arg2 = (gint16) _tmp13_;
				}
			}
			_tmp14_ = gid;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (gpointer) ((gintptr) glyph_index));
			_tmp15_ = x;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, (gpointer) ((gintptr) arg1));
			_tmp16_ = y;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, (gpointer) ((gintptr) arg2));
			if (((gint) (component_flags & BIRD_FONT_GLYF_TABLE_SCALE)) > 0) {
				BirdFontF2Dot14 _tmp17_ = 0U;
				_tmp17_ = bird_font_font_data_read_f2dot14 (dis, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (name);
					_g_object_unref0 (gid);
					_g_object_unref0 (y);
					_g_object_unref0 (x);
					_g_object_unref0 (linked_glyph);
					_g_object_unref0 (glyph);
					return NULL;
				}
				scale = _tmp17_;
			} else {
				if (((gint) (component_flags & BIRD_FONT_GLYF_TABLE_SCALE_X_Y)) > 0) {
					BirdFontF2Dot14 _tmp18_ = 0U;
					BirdFontF2Dot14 _tmp19_ = 0U;
					_tmp18_ = bird_font_font_data_read_f2dot14 (dis, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_string_free0 (name);
						_g_object_unref0 (gid);
						_g_object_unref0 (y);
						_g_object_unref0 (x);
						_g_object_unref0 (linked_glyph);
						_g_object_unref0 (glyph);
						return NULL;
					}
					scalex = _tmp18_;
					_tmp19_ = bird_font_font_data_read_f2dot14 (dis, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_string_free0 (name);
						_g_object_unref0 (gid);
						_g_object_unref0 (y);
						_g_object_unref0 (x);
						_g_object_unref0 (linked_glyph);
						_g_object_unref0 (glyph);
						return NULL;
					}
					scaley = _tmp19_;
				} else {
					if (((gint) (component_flags & BIRD_FONT_GLYF_TABLE_SCALE_WITH_ROTATTION)) > 0) {
						BirdFontF2Dot14 _tmp20_ = 0U;
						BirdFontF2Dot14 _tmp21_ = 0U;
						BirdFontF2Dot14 _tmp22_ = 0U;
						BirdFontF2Dot14 _tmp23_ = 0U;
						_tmp20_ = bird_font_font_data_read_f2dot14 (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_object_unref0 (gid);
							_g_object_unref0 (y);
							_g_object_unref0 (x);
							_g_object_unref0 (linked_glyph);
							_g_object_unref0 (glyph);
							return NULL;
						}
						scalex = _tmp20_;
						_tmp21_ = bird_font_font_data_read_f2dot14 (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_object_unref0 (gid);
							_g_object_unref0 (y);
							_g_object_unref0 (x);
							_g_object_unref0 (linked_glyph);
							_g_object_unref0 (glyph);
							return NULL;
						}
						scale01 = _tmp21_;
						_tmp22_ = bird_font_font_data_read_f2dot14 (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_object_unref0 (gid);
							_g_object_unref0 (y);
							_g_object_unref0 (x);
							_g_object_unref0 (linked_glyph);
							_g_object_unref0 (glyph);
							return NULL;
						}
						scale10 = _tmp22_;
						_tmp23_ = bird_font_font_data_read_f2dot14 (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_object_unref0 (gid);
							_g_object_unref0 (y);
							_g_object_unref0 (x);
							_g_object_unref0 (linked_glyph);
							_g_object_unref0 (glyph);
							return NULL;
						}
						scaley = _tmp23_;
					}
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				GeeArrayList* _tmp29_;
				gpointer _tmp30_;
				BirdFontGlyph* _tmp31_ = NULL;
				gdouble _tmp32_ = 0.0;
				gdouble _tmp33_ = 0.0;
				BirdFontGlyph* _tmp34_;
				BirdFontGlyph* _tmp35_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = gid;
				_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				if (!(i < _tmp28_)) {
					break;
				}
				_tmp29_ = gid;
				_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, i);
				glid = (gint) ((gintptr) _tmp30_);
				if (glid == pgid) {
					g_warning ("GlyfTable.vala:422: Cannot link a glyph to it self.");
					continue;
				}
				_tmp34_ = bird_font_glyf_table_parse_next_glyf (self, dis, character, glid, &_tmp32_, &_tmp33_, units_per_em, &_inner_error0_);
				xmin = _tmp32_;
				xmax = _tmp33_;
				_tmp31_ = _tmp34_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (name);
					_g_object_unref0 (gid);
					_g_object_unref0 (y);
					_g_object_unref0 (x);
					_g_object_unref0 (linked_glyph);
					_g_object_unref0 (glyph);
					return NULL;
				}
				_tmp35_ = _tmp31_;
				_tmp31_ = NULL;
				_g_object_unref0 (linked_glyph);
				linked_glyph = _tmp35_;
				_g_object_unref0 (_tmp31_);
			}
		}
	}
	result = glyph;
	_g_string_free0 (name);
	_g_object_unref0 (gid);
	_g_object_unref0 (y);
	_g_object_unref0 (x);
	_g_object_unref0 (linked_glyph);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static BirdFontGlyph*
bird_font_glyf_table_parse_next_glyf (BirdFontGlyfTable* self,
                                      BirdFontFontData* dis,
                                      gunichar character,
                                      gint gid,
                                      gdouble* xmin,
                                      gdouble* xmax,
                                      gdouble units_per_em,
                                      GError** error)
{
	gdouble _vala_xmin = 0.0;
	gdouble _vala_xmax = 0.0;
	guint16* end_points = NULL;
	guint8* instructions = NULL;
	guint8* flags = NULL;
	gint16* xcoordinates = NULL;
	gint16* ycoordinates = NULL;
	gint npoints = 0;
	gint16 ncontours = 0;
	gint16 ixmin = 0;
	gint16 iymin = 0;
	gint16 ixmax = 0;
	gint16 iymax = 0;
	guint16 ninstructions = 0U;
	gint16 rxmin = 0;
	gint16 rymin = 0;
	gint16 rxmax = 0;
	gint16 rymax = 0;
	gint nflags = 0;
	GError* _error_ = NULL;
	guint start = 0U;
	guint end = 0U;
	guint len = 0U;
	GString* name = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	BirdFontLocaTable* _tmp2_;
	BirdFontLocaTable* _tmp3_;
	gint16 _tmp4_ = 0;
	BirdFontGlyph* _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyph* _tmp15_;
	BirdFontGlyph* _tmp16_;
	gint16 _tmp24_ = 0;
	gint16 _tmp25_ = 0;
	gint16 _tmp26_ = 0;
	gint16 _tmp27_ = 0;
	guint16* _tmp28_;
	BirdFontGlyph* _tmp56_;
	BirdFontGlyph* _tmp57_;
	BirdFontGlyph* _tmp58_;
	BirdFontGlyph* _tmp59_;
	guint8* _tmp60_;
	guint8 repeat = 0U;
	guint8* _tmp65_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gint16 last = 0;
	gint16* _tmp115_;
	gint16* _tmp167_;
	gboolean _tmp219_ = FALSE;
	gboolean _tmp220_ = FALSE;
	gboolean _tmp221_ = FALSE;
	gint j = 0;
	gint first_point = 0;
	gint last_point = 0;
	BirdFontGlyph* glyph = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	GString* _tmp255_;
	const gchar* _tmp256_;
	BirdFontGlyph* _tmp257_;
	guint16* _tmp398_;
	guint8* _tmp400_;
	guint8* _tmp402_;
	gint16* _tmp404_;
	gint16* _tmp406_;
	GError* _tmp408_;
	GError* _inner_error0_ = NULL;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dis != NULL, NULL);
	end_points = NULL;
	instructions = NULL;
	flags = NULL;
	xcoordinates = NULL;
	ycoordinates = NULL;
	npoints = 0;
	rxmin = G_MAXINT16;
	rymin = G_MAXINT16;
	rxmax = G_MININT16;
	rymax = G_MININT16;
	_error_ = NULL;
	_tmp0_ = g_string_new ("");
	name = _tmp0_;
	_tmp1_ = name;
	g_string_append_unichar (_tmp1_, character);
	_vala_xmin = (gdouble) 0;
	_vala_xmax = (gdouble) 0;
	_tmp2_ = self->loca_table;
	start = (guint) bird_font_loca_table_get_offset (_tmp2_, (guint32) gid);
	_tmp3_ = self->loca_table;
	end = (guint) bird_font_loca_table_get_offset (_tmp3_, (guint32) (gid + 1));
	len = start - end;
	bird_font_font_data_seek (dis, (guint) (((BirdFontOtfTable*) self)->offset + start));
	_tmp4_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (name);
		_g_error_free0 (_error_);
		return NULL;
	}
	ncontours = _tmp4_;
	_tmp5_ = bird_font_glyph_new ("", (gunichar) 0);
	_tmp6_ = _tmp5_;
	g_return_val_if_fail (start < end, _tmp6_);
	_g_object_unref0 (_tmp6_);
	if (((gint) ncontours) == 0) {
		GString* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = name;
		_tmp8_ = _tmp7_->str;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("Zero contours in glyph ", _tmp9_, ".", NULL);
		_tmp11_ = _tmp10_;
		g_warning ("GlyfTable.vala:476: %s", _tmp11_);
		_g_free0 (_tmp11_);
	}
	if (((gint) ncontours) == -1) {
		BirdFontGlyph* _tmp12_ = NULL;
		BirdFontGlyph* _tmp13_;
		BirdFontGlyph* _tmp14_;
		_tmp13_ = bird_font_glyf_table_parse_next_composite_glyf (self, dis, character, gid, &_inner_error0_);
		_tmp12_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (name);
			_g_error_free0 (_error_);
			return NULL;
		}
		_tmp14_ = _tmp12_;
		_tmp12_ = NULL;
		result = _tmp14_;
		_g_object_unref0 (_tmp12_);
		_g_string_free0 (name);
		_g_error_free0 (_error_);
		if (xmin) {
			*xmin = _vala_xmin;
		}
		if (xmax) {
			*xmax = _vala_xmax;
		}
		return result;
	}
	_tmp15_ = bird_font_glyph_new ("", (gunichar) 0);
	_tmp16_ = _tmp15_;
	g_return_val_if_fail (((guint) ncontours) < len, _tmp16_);
	_g_object_unref0 (_tmp16_);
	if (((gint) ncontours) < -1) {
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		_tmp17_ = g_strdup_printf ("%" G_GINT16_FORMAT, ncontours);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, " contours in glyf table.", NULL);
		_tmp20_ = _tmp19_;
		g_warning ("GlyfTable.vala:488: %s", _tmp20_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_tmp21_ = g_error_new_literal (BIRD_FONT_BAD_FORMAT, BIRD_FONT_BAD_FORMAT_PARSE, "Invalid glyf");
		_g_error_free0 (_error_);
		_error_ = _tmp21_;
		_tmp22_ = _error_;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error0_ = _tmp23_;
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (name);
		_g_error_free0 (_error_);
		return NULL;
	}
	_tmp24_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (name);
		_g_error_free0 (_error_);
		return NULL;
	}
	ixmin = _tmp24_;
	_tmp25_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (name);
		_g_error_free0 (_error_);
		return NULL;
	}
	iymin = _tmp25_;
	_tmp26_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (name);
		_g_error_free0 (_error_);
		return NULL;
	}
	ixmax = _tmp26_;
	_tmp27_ = bird_font_font_data_read_short (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (name);
		_g_error_free0 (_error_);
		return NULL;
	}
	iymax = _tmp27_;
	_tmp28_ = g_new0 (guint16, ncontours + 1);
	end_points = _tmp28_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				guint16* _tmp31_;
				gboolean _tmp32_ = FALSE;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				if (!(i < ((gint) ncontours))) {
					break;
				}
				_tmp31_ = end_points;
				_tmp31_[i] = bird_font_font_data_read_ushort (dis);
				if (i > 0) {
					guint16* _tmp33_;
					guint16 _tmp34_;
					guint16* _tmp35_;
					guint16 _tmp36_;
					_tmp33_ = end_points;
					_tmp34_ = _tmp33_[i];
					_tmp35_ = end_points;
					_tmp36_ = _tmp35_[i - 1];
					_tmp32_ = _tmp34_ < _tmp36_;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					GString* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					guint16* _tmp40_;
					guint16 _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					guint16* _tmp44_;
					guint16 _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					_tmp37_ = name;
					_tmp38_ = _tmp37_->str;
					_tmp39_ = string_to_string (_tmp38_);
					_tmp40_ = end_points;
					_tmp41_ = _tmp40_[i];
					_tmp42_ = g_strdup_printf ("%hu", _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = end_points;
					_tmp45_ = _tmp44_[i - 1];
					_tmp46_ = g_strdup_printf ("%hu", _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = g_strdup_printf ("%i", i);
					_tmp49_ = _tmp48_;
					_tmp50_ = g_strdup_printf ("%" G_GINT16_FORMAT, ncontours);
					_tmp51_ = _tmp50_;
					_tmp52_ = g_strconcat ("Next endpoint has bad value in ", _tmp39_, ". (end_points[i] > end_points[i -1])  (", _tmp43_, " > ", _tmp47_, ") i: ", _tmp49_, " ncontours: ", _tmp51_, NULL);
					_tmp53_ = _tmp52_;
					g_warning ("GlyfTable.vala:503: %s", _tmp53_);
					_g_free0 (_tmp53_);
					_g_free0 (_tmp51_);
					_g_free0 (_tmp49_);
					_g_free0 (_tmp47_);
					_g_free0 (_tmp43_);
				}
			}
		}
	}
	if (((gint) ncontours) > 0) {
		guint16* _tmp54_;
		guint16 _tmp55_;
		_tmp54_ = end_points;
		_tmp55_ = _tmp54_[ncontours - 1];
		npoints = _tmp55_ + 1;
	} else {
		npoints = 0;
	}
	_tmp56_ = bird_font_glyph_new_no_lines ("", (gunichar) 0);
	_tmp57_ = _tmp56_;
	g_return_val_if_fail (((guint) npoints) < len, _tmp57_);
	_g_object_unref0 (_tmp57_);
	ninstructions = bird_font_font_data_read_ushort (dis);
	_tmp58_ = bird_font_glyph_new_no_lines ("", (gunichar) 0);
	_tmp59_ = _tmp58_;
	g_return_val_if_fail (((guint) ninstructions) < len, _tmp59_);
	_g_object_unref0 (_tmp59_);
	_tmp60_ = g_new0 (guint8, ninstructions + 1);
	instructions = _tmp60_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp61_ = FALSE;
			_tmp61_ = TRUE;
			while (TRUE) {
				guint8 _tmp63_ = 0U;
				guint8* _tmp64_;
				if (!_tmp61_) {
					gint _tmp62_;
					_tmp62_ = i;
					i = _tmp62_ + 1;
				}
				_tmp61_ = FALSE;
				if (!(i < ((gint) ninstructions))) {
					break;
				}
				_tmp63_ = bird_font_font_data_read_byte (dis, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (name);
					_g_error_free0 (_error_);
					return NULL;
				}
				_tmp64_ = instructions;
				_tmp64_[i] = _tmp63_;
			}
		}
	}
	nflags = 0;
	_tmp65_ = g_new0 (guint8, npoints + 1);
	flags = _tmp65_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp66_ = FALSE;
			_tmp66_ = TRUE;
			while (TRUE) {
				guint8 _tmp68_ = 0U;
				guint8* _tmp69_;
				guint8* _tmp70_;
				guint8 _tmp71_;
				gint _tmp79_;
				if (!_tmp66_) {
					gint _tmp67_;
					_tmp67_ = i;
					i = _tmp67_ + 1;
				}
				_tmp66_ = FALSE;
				if (!(i < npoints)) {
					break;
				}
				_tmp68_ = bird_font_font_data_read_byte (dis, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (name);
					_g_error_free0 (_error_);
					return NULL;
				}
				_tmp69_ = flags;
				_tmp69_[i] = _tmp68_;
				_tmp70_ = flags;
				_tmp71_ = _tmp70_[i];
				if (((gint) (_tmp71_ & BIRD_FONT_COORDINATE_FLAGS_REPEAT)) > 0) {
					guint8 _tmp72_ = 0U;
					_tmp72_ = bird_font_font_data_read_byte (dis, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_string_free0 (name);
						_g_error_free0 (_error_);
						return NULL;
					}
					repeat = _tmp72_;
					if ((i + repeat) >= npoints) {
						GError* _tmp73_;
						_tmp73_ = g_error_new_literal (BIRD_FONT_BAD_FORMAT, BIRD_FONT_BAD_FORMAT_PARSE, "Too many flags in glyf in glyph $(name.str). (i >= ninstructions).");
						_g_error_free0 (_error_);
						_error_ = _tmp73_;
						break;
					}
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp74_ = FALSE;
							_tmp74_ = TRUE;
							while (TRUE) {
								guint8* _tmp76_;
								guint8* _tmp77_;
								guint8 _tmp78_;
								if (!_tmp74_) {
									gint _tmp75_;
									_tmp75_ = j;
									j = _tmp75_ + 1;
								}
								_tmp74_ = FALSE;
								if (!(j < ((gint) repeat))) {
									break;
								}
								_tmp76_ = flags;
								_tmp77_ = flags;
								_tmp78_ = _tmp77_[i];
								_tmp76_[(j + i) + 1] = _tmp78_;
							}
						}
					}
					nflags += (gint) repeat;
					i += (gint) repeat;
				}
				_tmp79_ = nflags;
				nflags = _tmp79_ + 1;
			}
		}
	}
	if (nflags != npoints) {
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		GString* _tmp84_;
		const gchar* _tmp85_;
		const gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		GString* _tmp89_;
		const gchar* _tmp90_;
		const gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		GError* _tmp98_;
		_tmp80_ = g_strdup_printf ("%i", nflags);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_strdup_printf ("%i", npoints);
		_tmp83_ = _tmp82_;
		_tmp84_ = name;
		_tmp85_ = _tmp84_->str;
		_tmp86_ = string_to_string (_tmp85_);
		_tmp87_ = g_strconcat ("(nflags != npoints) (", _tmp81_, " != ", _tmp83_, ") in ", _tmp86_, NULL);
		_tmp88_ = _tmp87_;
		g_warning ("GlyfTable.vala:550: %s", _tmp88_);
		_g_free0 (_tmp88_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
		_tmp89_ = name;
		_tmp90_ = _tmp89_->str;
		_tmp91_ = string_to_string (_tmp90_);
		_tmp92_ = g_strdup_printf ("%i", nflags);
		_tmp93_ = _tmp92_;
		_tmp94_ = g_strdup_printf ("%i", npoints);
		_tmp95_ = _tmp94_;
		_tmp96_ = g_strconcat ("Wrong number of flags in glyph ", _tmp91_, ". (nflags != npoints) (", _tmp93_, " != ", _tmp95_, ")", NULL);
		_tmp97_ = _tmp96_;
		_tmp98_ = g_error_new_literal (BIRD_FONT_BAD_FORMAT, BIRD_FONT_BAD_FORMAT_PARSE, _tmp97_);
		_g_error_free0 (_error_);
		_error_ = _tmp98_;
		_g_free0 (_tmp97_);
		_g_free0 (_tmp95_);
		_g_free0 (_tmp93_);
	}
	g_warn_if_fail (nflags == npoints);
	_tmp99_ = g_strdup_printf ("%i", npoints);
	_tmp100_ = _tmp99_;
	_tmp101_ = g_strconcat ("npoints: ", _tmp100_, "\n", NULL);
	_tmp102_ = _tmp101_;
	bird_font_printd (_tmp102_);
	_g_free0 (_tmp102_);
	_g_free0 (_tmp100_);
	_tmp103_ = g_strdup_printf ("%" G_GINT16_FORMAT, ncontours);
	_tmp104_ = _tmp103_;
	_tmp105_ = g_strconcat ("ncontours: ", _tmp104_, "\n", NULL);
	_tmp106_ = _tmp105_;
	bird_font_printd (_tmp106_);
	_g_free0 (_tmp106_);
	_g_free0 (_tmp104_);
	_tmp107_ = g_strdup_printf ("%hu", ninstructions);
	_tmp108_ = _tmp107_;
	_tmp109_ = g_strconcat ("ninstructions: ", _tmp108_, "\n", NULL);
	_tmp110_ = _tmp109_;
	bird_font_printd (_tmp110_);
	_g_free0 (_tmp110_);
	_g_free0 (_tmp108_);
	_tmp111_ = g_strdup_printf ("%i", nflags);
	_tmp112_ = _tmp111_;
	_tmp113_ = g_strconcat ("nflags: ", _tmp112_, "\n", NULL);
	_tmp114_ = _tmp113_;
	bird_font_printd (_tmp114_);
	_g_free0 (_tmp114_);
	_g_free0 (_tmp112_);
	last = (gint16) 0;
	_tmp115_ = g_new0 (gint16, npoints + 1);
	xcoordinates = _tmp115_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp116_ = FALSE;
			_tmp116_ = TRUE;
			while (TRUE) {
				guint8* _tmp118_;
				guint8 _tmp119_;
				gint16* _tmp131_;
				gint16 _tmp132_;
				gint16 _tmp133_;
				BirdFontHeadTable* _tmp148_;
				BirdFontHeadTable* _tmp149_;
				gint16 _tmp150_;
				if (!_tmp116_) {
					gint _tmp117_;
					_tmp117_ = i;
					i = _tmp117_ + 1;
				}
				_tmp116_ = FALSE;
				if (!(i < npoints)) {
					break;
				}
				_tmp118_ = flags;
				_tmp119_ = _tmp118_[i];
				if (((gint) (_tmp119_ & BIRD_FONT_COORDINATE_FLAGS_X_SHORT_VECTOR)) > 0) {
					guint8* _tmp120_;
					guint8 _tmp121_;
					_tmp120_ = flags;
					_tmp121_ = _tmp120_[i];
					if (((gint) (_tmp121_ & BIRD_FONT_COORDINATE_FLAGS_X_SHORT_VECTOR_POSITIVE)) > 0) {
						guint8 _tmp122_ = 0U;
						gint16* _tmp123_;
						_tmp122_ = bird_font_font_data_read_byte (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_error_free0 (_error_);
							return NULL;
						}
						_tmp123_ = xcoordinates;
						_tmp123_[i] = last + _tmp122_;
					} else {
						guint8 _tmp124_ = 0U;
						gint16* _tmp125_;
						_tmp124_ = bird_font_font_data_read_byte (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_error_free0 (_error_);
							return NULL;
						}
						_tmp125_ = xcoordinates;
						_tmp125_[i] = last - _tmp124_;
					}
				} else {
					guint8* _tmp126_;
					guint8 _tmp127_;
					_tmp126_ = flags;
					_tmp127_ = _tmp126_[i];
					if (((gint) (_tmp127_ & BIRD_FONT_COORDINATE_FLAGS_X_IS_SAME)) > 0) {
						gint16* _tmp128_;
						_tmp128_ = xcoordinates;
						_tmp128_[i] = last;
					} else {
						gint16 _tmp129_ = 0;
						gint16* _tmp130_;
						_tmp129_ = bird_font_font_data_read_short (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_error_free0 (_error_);
							return NULL;
						}
						_tmp130_ = xcoordinates;
						_tmp130_[i] = last + _tmp129_;
					}
				}
				_tmp131_ = xcoordinates;
				_tmp132_ = _tmp131_[i];
				last = _tmp132_;
				if (last > rxmax) {
					rxmax = last;
				}
				if (last < rxmin) {
					rxmin = last;
				}
				_tmp133_ = last;
				if (!((ixmin <= _tmp133_) && (_tmp133_ <= ixmax))) {
					FILE* _tmp134_;
					GString* _tmp135_;
					const gchar* _tmp136_;
					const gchar* _tmp137_;
					gchar* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					gchar* _tmp142_;
					gchar* _tmp143_;
					gchar* _tmp144_;
					gchar* _tmp145_;
					gchar* _tmp146_;
					gchar* _tmp147_;
					_tmp134_ = stderr;
					_tmp135_ = name;
					_tmp136_ = _tmp135_->str;
					_tmp137_ = string_to_string (_tmp136_);
					_tmp138_ = g_strdup_printf ("%" G_GINT16_FORMAT, ixmin);
					_tmp139_ = _tmp138_;
					_tmp140_ = g_strdup_printf ("%" G_GINT16_FORMAT, last);
					_tmp141_ = _tmp140_;
					_tmp142_ = g_strdup_printf ("%" G_GINT16_FORMAT, ixmax);
					_tmp143_ = _tmp142_;
					_tmp144_ = g_strdup_printf ("%u", (guint) character);
					_tmp145_ = _tmp144_;
					_tmp146_ = g_strconcat ("x is out of bounds in glyph ", _tmp137_, ". (", _tmp139_, " <= ", _tmp141_, " <= ", _tmp143_, ") char ", _tmp145_, "\n", NULL);
					_tmp147_ = _tmp146_;
					fprintf (_tmp134_, "%s", _tmp147_);
					_g_free0 (_tmp147_);
					_g_free0 (_tmp145_);
					_g_free0 (_tmp143_);
					_g_free0 (_tmp141_);
					_g_free0 (_tmp139_);
				}
				_tmp148_ = self->head_table;
				_tmp149_ = self->head_table;
				_tmp150_ = last;
				if (!((_tmp148_->xmin <= _tmp150_) && (_tmp150_ <= _tmp149_->xmax))) {
					FILE* _tmp151_;
					GString* _tmp152_;
					const gchar* _tmp153_;
					const gchar* _tmp154_;
					BirdFontHeadTable* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					gchar* _tmp158_;
					gchar* _tmp159_;
					BirdFontHeadTable* _tmp160_;
					gchar* _tmp161_;
					gchar* _tmp162_;
					gchar* _tmp163_;
					gchar* _tmp164_;
					gchar* _tmp165_;
					gchar* _tmp166_;
					_tmp151_ = stderr;
					_tmp152_ = name;
					_tmp153_ = _tmp152_->str;
					_tmp154_ = string_to_string (_tmp153_);
					_tmp155_ = self->head_table;
					_tmp156_ = g_strdup_printf ("%" G_GINT16_FORMAT, _tmp155_->xmin);
					_tmp157_ = _tmp156_;
					_tmp158_ = g_strdup_printf ("%" G_GINT16_FORMAT, last);
					_tmp159_ = _tmp158_;
					_tmp160_ = self->head_table;
					_tmp161_ = g_strdup_printf ("%" G_GINT16_FORMAT, _tmp160_->xmax);
					_tmp162_ = _tmp161_;
					_tmp163_ = g_strdup_printf ("%u", (guint) character);
					_tmp164_ = _tmp163_;
					_tmp165_ = g_strconcat ("x is outside of of font bounding box in glyph ", _tmp154_, ". (", _tmp157_, " <= ", _tmp159_, " <= ", _tmp162_, ") char ", _tmp164_, "\n", NULL);
					_tmp166_ = _tmp165_;
					fprintf (_tmp151_, "%s", _tmp166_);
					_g_free0 (_tmp166_);
					_g_free0 (_tmp164_);
					_g_free0 (_tmp162_);
					_g_free0 (_tmp159_);
					_g_free0 (_tmp157_);
				}
			}
		}
	}
	last = (gint16) 0;
	_tmp167_ = g_new0 (gint16, npoints + 1);
	ycoordinates = _tmp167_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp168_ = FALSE;
			_tmp168_ = TRUE;
			while (TRUE) {
				guint8* _tmp170_;
				guint8 _tmp171_;
				gint16* _tmp183_;
				gint16 _tmp184_;
				gint16 _tmp185_;
				BirdFontHeadTable* _tmp200_;
				BirdFontHeadTable* _tmp201_;
				gint16 _tmp202_;
				if (!_tmp168_) {
					gint _tmp169_;
					_tmp169_ = i;
					i = _tmp169_ + 1;
				}
				_tmp168_ = FALSE;
				if (!(i < npoints)) {
					break;
				}
				_tmp170_ = flags;
				_tmp171_ = _tmp170_[i];
				if (((gint) (_tmp171_ & BIRD_FONT_COORDINATE_FLAGS_Y_SHORT_VECTOR)) > 0) {
					guint8* _tmp172_;
					guint8 _tmp173_;
					_tmp172_ = flags;
					_tmp173_ = _tmp172_[i];
					if (((gint) (_tmp173_ & BIRD_FONT_COORDINATE_FLAGS_Y_SHORT_VECTOR_POSITIVE)) > 0) {
						guint8 _tmp174_ = 0U;
						gint16* _tmp175_;
						_tmp174_ = bird_font_font_data_read_byte (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_error_free0 (_error_);
							return NULL;
						}
						_tmp175_ = ycoordinates;
						_tmp175_[i] = last + _tmp174_;
					} else {
						guint8 _tmp176_ = 0U;
						gint16* _tmp177_;
						_tmp176_ = bird_font_font_data_read_byte (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_error_free0 (_error_);
							return NULL;
						}
						_tmp177_ = ycoordinates;
						_tmp177_[i] = last - _tmp176_;
					}
				} else {
					guint8* _tmp178_;
					guint8 _tmp179_;
					_tmp178_ = flags;
					_tmp179_ = _tmp178_[i];
					if (((gint) (_tmp179_ & BIRD_FONT_COORDINATE_FLAGS_Y_IS_SAME)) > 0) {
						gint16* _tmp180_;
						_tmp180_ = ycoordinates;
						_tmp180_[i] = last;
					} else {
						gint16 _tmp181_ = 0;
						gint16* _tmp182_;
						_tmp181_ = bird_font_font_data_read_short (dis, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (name);
							_g_error_free0 (_error_);
							return NULL;
						}
						_tmp182_ = ycoordinates;
						_tmp182_[i] = last + _tmp181_;
					}
				}
				_tmp183_ = ycoordinates;
				_tmp184_ = _tmp183_[i];
				last = _tmp184_;
				if (last > rymax) {
					rymax = last;
				}
				if (last < rymin) {
					rymin = last;
				}
				_tmp185_ = last;
				if (!((iymin <= _tmp185_) && (_tmp185_ <= iymax))) {
					FILE* _tmp186_;
					GString* _tmp187_;
					const gchar* _tmp188_;
					const gchar* _tmp189_;
					gchar* _tmp190_;
					gchar* _tmp191_;
					gchar* _tmp192_;
					gchar* _tmp193_;
					gchar* _tmp194_;
					gchar* _tmp195_;
					gchar* _tmp196_;
					gchar* _tmp197_;
					gchar* _tmp198_;
					gchar* _tmp199_;
					_tmp186_ = stderr;
					_tmp187_ = name;
					_tmp188_ = _tmp187_->str;
					_tmp189_ = string_to_string (_tmp188_);
					_tmp190_ = g_strdup_printf ("%" G_GINT16_FORMAT, iymin);
					_tmp191_ = _tmp190_;
					_tmp192_ = g_strdup_printf ("%" G_GINT16_FORMAT, last);
					_tmp193_ = _tmp192_;
					_tmp194_ = g_strdup_printf ("%" G_GINT16_FORMAT, iymax);
					_tmp195_ = _tmp194_;
					_tmp196_ = g_strdup_printf ("%u", (guint) character);
					_tmp197_ = _tmp196_;
					_tmp198_ = g_strconcat ("y is out of bounds in glyph ", _tmp189_, ". (", _tmp191_, " <= ", _tmp193_, " <= ", _tmp195_, ") char ", _tmp197_, "\n", NULL);
					_tmp199_ = _tmp198_;
					fprintf (_tmp186_, "%s", _tmp199_);
					_g_free0 (_tmp199_);
					_g_free0 (_tmp197_);
					_g_free0 (_tmp195_);
					_g_free0 (_tmp193_);
					_g_free0 (_tmp191_);
				}
				_tmp200_ = self->head_table;
				_tmp201_ = self->head_table;
				_tmp202_ = last;
				if (!((_tmp200_->ymin <= _tmp202_) && (_tmp202_ <= _tmp201_->ymax))) {
					FILE* _tmp203_;
					GString* _tmp204_;
					const gchar* _tmp205_;
					const gchar* _tmp206_;
					BirdFontHeadTable* _tmp207_;
					gchar* _tmp208_;
					gchar* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					BirdFontHeadTable* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					gchar* _tmp215_;
					gchar* _tmp216_;
					gchar* _tmp217_;
					gchar* _tmp218_;
					_tmp203_ = stderr;
					_tmp204_ = name;
					_tmp205_ = _tmp204_->str;
					_tmp206_ = string_to_string (_tmp205_);
					_tmp207_ = self->head_table;
					_tmp208_ = g_strdup_printf ("%" G_GINT16_FORMAT, _tmp207_->ymin);
					_tmp209_ = _tmp208_;
					_tmp210_ = g_strdup_printf ("%" G_GINT16_FORMAT, last);
					_tmp211_ = _tmp210_;
					_tmp212_ = self->head_table;
					_tmp213_ = g_strdup_printf ("%" G_GINT16_FORMAT, _tmp212_->ymax);
					_tmp214_ = _tmp213_;
					_tmp215_ = g_strdup_printf ("%u", (guint) character);
					_tmp216_ = _tmp215_;
					_tmp217_ = g_strconcat ("y is outside of of font bounding box in glyph ", _tmp206_, ". (", _tmp209_, " <= ", _tmp211_, " <= ", _tmp214_, ") char ", _tmp216_, "\n", NULL);
					_tmp218_ = _tmp217_;
					fprintf (_tmp203_, "%s", _tmp218_);
					_g_free0 (_tmp218_);
					_g_free0 (_tmp216_);
					_g_free0 (_tmp214_);
					_g_free0 (_tmp211_);
					_g_free0 (_tmp209_);
				}
			}
		}
	}
	if (rymin != iymin) {
		_tmp221_ = TRUE;
	} else {
		_tmp221_ = rxmin != ixmin;
	}
	if (_tmp221_) {
		_tmp220_ = TRUE;
	} else {
		_tmp220_ = rxmax != ixmax;
	}
	if (_tmp220_) {
		_tmp219_ = TRUE;
	} else {
		_tmp219_ = rymax != iymax;
	}
	if (_tmp219_) {
		GString* _tmp222_;
		const gchar* _tmp223_;
		const gchar* _tmp224_;
		gchar* _tmp225_;
		gchar* _tmp226_;
		FILE* _tmp227_;
		gchar* _tmp228_;
		gchar* _tmp229_;
		gchar* _tmp230_;
		gchar* _tmp231_;
		gchar* _tmp232_;
		gchar* _tmp233_;
		FILE* _tmp234_;
		gchar* _tmp235_;
		gchar* _tmp236_;
		gchar* _tmp237_;
		gchar* _tmp238_;
		gchar* _tmp239_;
		gchar* _tmp240_;
		FILE* _tmp241_;
		gchar* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		gchar* _tmp245_;
		gchar* _tmp246_;
		gchar* _tmp247_;
		FILE* _tmp248_;
		gchar* _tmp249_;
		gchar* _tmp250_;
		gchar* _tmp251_;
		gchar* _tmp252_;
		gchar* _tmp253_;
		gchar* _tmp254_;
		_tmp222_ = name;
		_tmp223_ = _tmp222_->str;
		_tmp224_ = string_to_string (_tmp223_);
		_tmp225_ = g_strconcat ("Warning real boundary for glyph does not match boundary set in glyph h" \
"eader for glyph ", _tmp224_, ".", NULL);
		_tmp226_ = _tmp225_;
		g_warning ("GlyfTable.vala:624: %s", _tmp226_);
		_g_free0 (_tmp226_);
		_tmp227_ = stderr;
		_tmp228_ = g_strdup_printf ("%" G_GINT16_FORMAT, rymin);
		_tmp229_ = _tmp228_;
		_tmp230_ = g_strdup_printf ("%" G_GINT16_FORMAT, iymin);
		_tmp231_ = _tmp230_;
		_tmp232_ = g_strconcat ("ymin: ", _tmp229_, " header: ", _tmp231_, "\n", NULL);
		_tmp233_ = _tmp232_;
		fprintf (_tmp227_, "%s", _tmp233_);
		_g_free0 (_tmp233_);
		_g_free0 (_tmp231_);
		_g_free0 (_tmp229_);
		_tmp234_ = stderr;
		_tmp235_ = g_strdup_printf ("%" G_GINT16_FORMAT, rxmin);
		_tmp236_ = _tmp235_;
		_tmp237_ = g_strdup_printf ("%" G_GINT16_FORMAT, ixmin);
		_tmp238_ = _tmp237_;
		_tmp239_ = g_strconcat ("xmin: ", _tmp236_, " header: ", _tmp238_, "\n", NULL);
		_tmp240_ = _tmp239_;
		fprintf (_tmp234_, "%s", _tmp240_);
		_g_free0 (_tmp240_);
		_g_free0 (_tmp238_);
		_g_free0 (_tmp236_);
		_tmp241_ = stderr;
		_tmp242_ = g_strdup_printf ("%" G_GINT16_FORMAT, rymax);
		_tmp243_ = _tmp242_;
		_tmp244_ = g_strdup_printf ("%" G_GINT16_FORMAT, iymax);
		_tmp245_ = _tmp244_;
		_tmp246_ = g_strconcat ("ymax: ", _tmp243_, " header: ", _tmp245_, "\n", NULL);
		_tmp247_ = _tmp246_;
		fprintf (_tmp241_, "%s", _tmp247_);
		_g_free0 (_tmp247_);
		_g_free0 (_tmp245_);
		_g_free0 (_tmp243_);
		_tmp248_ = stderr;
		_tmp249_ = g_strdup_printf ("%" G_GINT16_FORMAT, rxmax);
		_tmp250_ = _tmp249_;
		_tmp251_ = g_strdup_printf ("%" G_GINT16_FORMAT, ixmax);
		_tmp252_ = _tmp251_;
		_tmp253_ = g_strconcat ("xmax: ", _tmp250_, " header: ", _tmp252_, "\n", NULL);
		_tmp254_ = _tmp253_;
		fprintf (_tmp248_, "%s", _tmp254_);
		_g_free0 (_tmp254_);
		_g_free0 (_tmp252_);
		_g_free0 (_tmp250_);
	}
	j = 0;
	last_point = 0;
	_tmp255_ = name;
	_tmp256_ = _tmp255_->str;
	_tmp257_ = bird_font_glyph_new (_tmp256_, character);
	_g_object_unref0 (glyph);
	glyph = _tmp257_;
	_vala_xmin = (ixmin * 1000.0) / units_per_em;
	_vala_xmax = (ixmax * 1000.0) / units_per_em;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp258_ = FALSE;
			_tmp258_ = TRUE;
			while (TRUE) {
				BirdFontPath* path = NULL;
				BirdFontPath* _tmp260_;
				BirdFontEditPoint* edit_point = NULL;
				BirdFontEditPoint* _tmp261_;
				gboolean prev_is_curve = FALSE;
				guint16* _tmp262_;
				guint16 _tmp263_;
				gint16* _tmp357_;
				gint16 _tmp358_;
				gint16* _tmp359_;
				gint16 _tmp360_;
				BirdFontEditPoint* _tmp361_;
				BirdFontEditPoint* _tmp362_;
				BirdFontEditPointHandle* _tmp363_;
				BirdFontEditPoint* _tmp364_;
				BirdFontEditPointHandle* _tmp365_;
				BirdFontPath* _tmp366_;
				BirdFontGlyph* _tmp367_;
				BirdFontPath* _tmp368_;
				if (!_tmp258_) {
					gint _tmp259_;
					_tmp259_ = i;
					i = _tmp259_ + 1;
				}
				_tmp258_ = FALSE;
				if (!(i < ((gint) ncontours))) {
					break;
				}
				x = (gdouble) 0;
				y = (gdouble) 0;
				_tmp260_ = bird_font_path_new ();
				path = _tmp260_;
				_tmp261_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
				edit_point = _tmp261_;
				prev_is_curve = FALSE;
				first_point = j;
				_tmp262_ = end_points;
				_tmp263_ = _tmp262_[i];
				last_point = (gint) _tmp263_;
				{
					gboolean _tmp264_ = FALSE;
					_tmp264_ = TRUE;
					while (TRUE) {
						guint16* _tmp266_;
						guint16 _tmp267_;
						gint16* _tmp281_;
						gint16 _tmp282_;
						gint16* _tmp283_;
						gint16 _tmp284_;
						guint8* _tmp285_;
						guint8 _tmp286_;
						if (!_tmp264_) {
							gint _tmp265_;
							_tmp265_ = j;
							j = _tmp265_ + 1;
						}
						_tmp264_ = FALSE;
						_tmp266_ = end_points;
						_tmp267_ = _tmp266_[i];
						if (!(j <= ((gint) _tmp267_))) {
							break;
						}
						if (j >= npoints) {
							GString* _tmp268_;
							const gchar* _tmp269_;
							const gchar* _tmp270_;
							gchar* _tmp271_;
							gchar* _tmp272_;
							guint16* _tmp273_;
							guint16 _tmp274_;
							gchar* _tmp275_;
							gchar* _tmp276_;
							gchar* _tmp277_;
							gchar* _tmp278_;
							gchar* _tmp279_;
							gchar* _tmp280_;
							_tmp268_ = name;
							_tmp269_ = _tmp268_->str;
							_tmp270_ = string_to_string (_tmp269_);
							_tmp271_ = g_strdup_printf ("%i", j);
							_tmp272_ = _tmp271_;
							_tmp273_ = end_points;
							_tmp274_ = _tmp273_[i];
							_tmp275_ = g_strdup_printf ("%hu", _tmp274_);
							_tmp276_ = _tmp275_;
							_tmp277_ = g_strdup_printf ("%i", npoints);
							_tmp278_ = _tmp277_;
							_tmp279_ = g_strconcat ("j >= npoints in glyph ", _tmp270_, ". (j: ", _tmp272_, ", end_points[i]: ", _tmp276_, ", npoints: ", _tmp278_, ")", NULL);
							_tmp280_ = _tmp279_;
							g_warning ("GlyfTable.vala:655: %s", _tmp280_);
							_g_free0 (_tmp280_);
							_g_free0 (_tmp278_);
							_g_free0 (_tmp276_);
							_g_free0 (_tmp272_);
							break;
						}
						_tmp281_ = xcoordinates;
						_tmp282_ = _tmp281_[j];
						x = (_tmp282_ * 1000.0) / units_per_em;
						_tmp283_ = ycoordinates;
						_tmp284_ = _tmp283_[j];
						y = (_tmp284_ * 1000.0) / units_per_em;
						_tmp285_ = flags;
						_tmp286_ = _tmp285_[j];
						if (((gint) (_tmp286_ & BIRD_FONT_COORDINATE_FLAGS_ON_PATH)) > 0) {
							BirdFontEditPoint* _tmp287_;
							BirdFontEditPoint* _tmp288_;
							BirdFontPath* _tmp289_;
							BirdFontEditPoint* _tmp290_;
							BirdFontEditPoint* _tmp291_;
							BirdFontEditPoint* _tmp292_;
							_tmp287_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
							_g_object_unref0 (edit_point);
							edit_point = _tmp287_;
							_tmp288_ = edit_point;
							bird_font_edit_point_set_position (_tmp288_, x, y);
							_tmp289_ = path;
							_tmp290_ = edit_point;
							_tmp291_ = bird_font_path_add_point (_tmp289_, _tmp290_);
							_tmp292_ = _tmp291_;
							_g_object_unref0 (_tmp292_);
							if (prev_is_curve) {
								BirdFontEditPoint* _tmp293_;
								BirdFontEditPointHandle* _tmp294_;
								BirdFontEditPoint* _tmp295_;
								BirdFontEditPointHandle* _tmp296_;
								_tmp293_ = edit_point;
								_tmp294_ = bird_font_edit_point_get_left_handle (_tmp293_);
								bird_font_edit_point_handle_set_point_type (_tmp294_, BIRD_FONT_POINT_TYPE_NONE);
								_tmp295_ = edit_point;
								_tmp296_ = bird_font_edit_point_get_left_handle (_tmp295_);
								_tmp296_->length = (gdouble) 0;
							} else {
								BirdFontPath* _tmp297_;
								BirdFontEditPoint* _tmp298_;
								_tmp297_ = path;
								_tmp298_ = edit_point;
								bird_font_path_recalculate_linear_handles_for_point (_tmp297_, _tmp298_);
							}
							prev_is_curve = FALSE;
						} else {
							gint16* _tmp313_;
							gint16 _tmp314_;
							gint16* _tmp315_;
							gint16 _tmp316_;
							BirdFontEditPoint* _tmp317_;
							BirdFontEditPointHandle* _tmp318_;
							BirdFontEditPoint* _tmp319_;
							BirdFontEditPointHandle* _tmp320_;
							BirdFontEditPoint* _tmp321_;
							BirdFontEditPoint* _tmp322_;
							BirdFontEditPointHandle* _tmp323_;
							BirdFontEditPoint* _tmp324_;
							BirdFontEditPointHandle* _tmp325_;
							if (prev_is_curve) {
								BirdFontEditPoint* _tmp299_;
								BirdFontEditPointHandle* _tmp300_;
								gdouble _tmp301_;
								gdouble _tmp302_;
								BirdFontEditPoint* _tmp303_;
								BirdFontEditPointHandle* _tmp304_;
								gdouble _tmp305_;
								gdouble _tmp306_;
								BirdFontEditPoint* _tmp307_;
								BirdFontEditPoint* _tmp308_;
								BirdFontPath* _tmp309_;
								BirdFontEditPoint* _tmp310_;
								BirdFontEditPoint* _tmp311_;
								BirdFontEditPoint* _tmp312_;
								_tmp299_ = edit_point;
								_tmp300_ = _tmp299_->right_handle;
								_tmp301_ = bird_font_edit_point_handle_get_x (_tmp300_);
								_tmp302_ = _tmp301_;
								x = x - ((x - _tmp302_) / 2);
								_tmp303_ = edit_point;
								_tmp304_ = _tmp303_->right_handle;
								_tmp305_ = bird_font_edit_point_handle_get_y (_tmp304_);
								_tmp306_ = _tmp305_;
								y = y - ((y - _tmp306_) / 2);
								_tmp307_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
								_g_object_unref0 (edit_point);
								edit_point = _tmp307_;
								_tmp308_ = edit_point;
								bird_font_edit_point_set_position (_tmp308_, x, y);
								_tmp309_ = path;
								_tmp310_ = edit_point;
								_tmp311_ = bird_font_path_add_point (_tmp309_, _tmp310_);
								_tmp312_ = _tmp311_;
								_g_object_unref0 (_tmp312_);
							}
							_tmp313_ = xcoordinates;
							_tmp314_ = _tmp313_[j];
							x = (_tmp314_ * 1000.0) / units_per_em;
							_tmp315_ = ycoordinates;
							_tmp316_ = _tmp315_[j];
							y = (_tmp316_ * 1000.0) / units_per_em;
							_tmp317_ = edit_point;
							_tmp318_ = bird_font_edit_point_get_left_handle (_tmp317_);
							bird_font_edit_point_handle_set_point_type (_tmp318_, BIRD_FONT_POINT_TYPE_NONE);
							_tmp319_ = edit_point;
							_tmp320_ = bird_font_edit_point_get_left_handle (_tmp319_);
							_tmp320_->length = (gdouble) 0;
							_tmp321_ = edit_point;
							_tmp321_->type = BIRD_FONT_POINT_TYPE_CUBIC;
							_tmp322_ = edit_point;
							_tmp323_ = bird_font_edit_point_get_right_handle (_tmp322_);
							bird_font_edit_point_handle_set_point_type (_tmp323_, BIRD_FONT_POINT_TYPE_CUBIC);
							_tmp324_ = edit_point;
							_tmp325_ = bird_font_edit_point_get_right_handle (_tmp324_);
							bird_font_edit_point_handle_move_to_coordinate (_tmp325_, x, y);
							prev_is_curve = TRUE;
						}
					}
				}
				if (prev_is_curve) {
					gint16* _tmp326_;
					gint16 _tmp327_;
					gint16* _tmp328_;
					gint16 _tmp329_;
					BirdFontEditPoint* _tmp330_;
					BirdFontEditPointHandle* _tmp331_;
					gdouble _tmp332_;
					gdouble _tmp333_;
					BirdFontEditPoint* _tmp334_;
					BirdFontEditPointHandle* _tmp335_;
					gdouble _tmp336_;
					gdouble _tmp337_;
					BirdFontEditPoint* _tmp338_;
					BirdFontEditPoint* _tmp339_;
					BirdFontPath* _tmp340_;
					BirdFontEditPoint* _tmp341_;
					BirdFontEditPoint* _tmp342_;
					BirdFontEditPoint* _tmp343_;
					gint16* _tmp344_;
					gint16 _tmp345_;
					gint16* _tmp346_;
					gint16 _tmp347_;
					BirdFontEditPoint* _tmp348_;
					BirdFontEditPointHandle* _tmp349_;
					BirdFontEditPoint* _tmp350_;
					BirdFontEditPointHandle* _tmp351_;
					BirdFontEditPoint* _tmp352_;
					BirdFontEditPoint* _tmp353_;
					BirdFontEditPointHandle* _tmp354_;
					BirdFontEditPoint* _tmp355_;
					BirdFontEditPointHandle* _tmp356_;
					_tmp326_ = xcoordinates;
					_tmp327_ = _tmp326_[first_point];
					x = (_tmp327_ * 1000.0) / units_per_em;
					_tmp328_ = ycoordinates;
					_tmp329_ = _tmp328_[first_point];
					y = (_tmp329_ * 1000.0) / units_per_em;
					_tmp330_ = edit_point;
					_tmp331_ = _tmp330_->right_handle;
					_tmp332_ = bird_font_edit_point_handle_get_x (_tmp331_);
					_tmp333_ = _tmp332_;
					x = x - ((x - _tmp333_) / 2);
					_tmp334_ = edit_point;
					_tmp335_ = _tmp334_->right_handle;
					_tmp336_ = bird_font_edit_point_handle_get_y (_tmp335_);
					_tmp337_ = _tmp336_;
					y = y - ((y - _tmp337_) / 2);
					_tmp338_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
					_g_object_unref0 (edit_point);
					edit_point = _tmp338_;
					_tmp339_ = edit_point;
					bird_font_edit_point_set_position (_tmp339_, x, y);
					_tmp340_ = path;
					_tmp341_ = edit_point;
					_tmp342_ = bird_font_path_add_point (_tmp340_, _tmp341_);
					_tmp343_ = _tmp342_;
					_g_object_unref0 (_tmp343_);
					_tmp344_ = xcoordinates;
					_tmp345_ = _tmp344_[first_point];
					x = (_tmp345_ * 1000.0) / units_per_em;
					_tmp346_ = ycoordinates;
					_tmp347_ = _tmp346_[first_point];
					y = (_tmp347_ * 1000.0) / units_per_em;
					_tmp348_ = edit_point;
					_tmp349_ = bird_font_edit_point_get_left_handle (_tmp348_);
					bird_font_edit_point_handle_set_point_type (_tmp349_, BIRD_FONT_POINT_TYPE_CUBIC);
					_tmp350_ = edit_point;
					_tmp351_ = bird_font_edit_point_get_left_handle (_tmp350_);
					_tmp351_->length = (gdouble) 0;
					_tmp352_ = edit_point;
					_tmp352_->type = BIRD_FONT_POINT_TYPE_CUBIC;
					_tmp353_ = edit_point;
					_tmp354_ = bird_font_edit_point_get_right_handle (_tmp353_);
					bird_font_edit_point_handle_set_point_type (_tmp354_, BIRD_FONT_POINT_TYPE_CUBIC);
					_tmp355_ = edit_point;
					_tmp356_ = bird_font_edit_point_get_right_handle (_tmp355_);
					bird_font_edit_point_handle_move_to_coordinate (_tmp356_, x, y);
				}
				_tmp357_ = xcoordinates;
				_tmp358_ = _tmp357_[first_point];
				x = (_tmp358_ * 1000.0) / units_per_em;
				_tmp359_ = ycoordinates;
				_tmp360_ = _tmp359_[first_point];
				y = (_tmp360_ * 1000.0) / units_per_em;
				_tmp361_ = edit_point;
				_tmp361_->type = BIRD_FONT_POINT_TYPE_CUBIC;
				_tmp362_ = edit_point;
				_tmp363_ = bird_font_edit_point_get_right_handle (_tmp362_);
				bird_font_edit_point_handle_set_point_type (_tmp363_, BIRD_FONT_POINT_TYPE_CUBIC);
				_tmp364_ = edit_point;
				_tmp365_ = bird_font_edit_point_get_right_handle (_tmp364_);
				bird_font_edit_point_handle_move_to_coordinate (_tmp365_, x, y);
				_tmp366_ = path;
				bird_font_path_close (_tmp366_);
				_tmp367_ = glyph;
				_tmp368_ = path;
				bird_font_glyph_add_path (_tmp367_, _tmp368_);
				_g_object_unref0 (edit_point);
				_g_object_unref0 (path);
			}
		}
	}
	if (ixmax <= ixmin) {
		gchar* _tmp369_;
		gchar* _tmp370_;
		gchar* _tmp371_;
		gchar* _tmp372_;
		gchar* _tmp373_;
		gchar* _tmp374_;
		GeeArrayList* visible_paths = NULL;
		BirdFontGlyph* _tmp375_;
		GeeArrayList* _tmp376_;
		GeeArrayList* _tmp377_;
		gint _tmp378_;
		gint _tmp379_;
		_tmp369_ = double_to_string (_vala_xmax);
		_tmp370_ = _tmp369_;
		_tmp371_ = double_to_string (_vala_xmin);
		_tmp372_ = _tmp371_;
		_tmp373_ = g_strconcat ("Bounding box is bad. (xmax == xmin) (", _tmp370_, " == ", _tmp372_, ")", NULL);
		_tmp374_ = _tmp373_;
		g_warning ("GlyfTable.vala:738: %s", _tmp374_);
		_g_free0 (_tmp374_);
		_g_free0 (_tmp372_);
		_g_free0 (_tmp370_);
		_tmp375_ = glyph;
		_tmp376_ = bird_font_glyph_get_visible_paths (_tmp375_);
		visible_paths = _tmp376_;
		_tmp377_ = visible_paths;
		_tmp378_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp377_);
		_tmp379_ = _tmp378_;
		if (_tmp379_ > 0) {
			BirdFontPath* ps = NULL;
			GeeArrayList* _tmp380_;
			gpointer _tmp381_;
			BirdFontPath* _tmp382_;
			BirdFontPath* _tmp383_;
			BirdFontPath* _tmp384_;
			_tmp380_ = visible_paths;
			_tmp381_ = gee_abstract_list_get ((GeeAbstractList*) _tmp380_, 0);
			ps = (BirdFontPath*) _tmp381_;
			_tmp382_ = ps;
			bird_font_path_update_region_boundaries (_tmp382_);
			_tmp383_ = ps;
			_vala_xmin = _tmp383_->xmin;
			_tmp384_ = ps;
			_vala_xmax = _tmp384_->xmax;
			{
				GeeArrayList* _p_list = NULL;
				GeeArrayList* _tmp385_;
				gint _p_size = 0;
				GeeArrayList* _tmp386_;
				gint _tmp387_;
				gint _tmp388_;
				gint _p_index = 0;
				_tmp385_ = visible_paths;
				_p_list = _tmp385_;
				_tmp386_ = _p_list;
				_tmp387_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp386_);
				_tmp388_ = _tmp387_;
				_p_size = _tmp388_;
				_p_index = -1;
				while (TRUE) {
					gint _tmp389_;
					gint _tmp390_;
					BirdFontPath* p = NULL;
					GeeArrayList* _tmp391_;
					gpointer _tmp392_;
					BirdFontPath* _tmp393_;
					BirdFontPath* _tmp394_;
					BirdFontPath* _tmp396_;
					_p_index = _p_index + 1;
					_tmp389_ = _p_index;
					_tmp390_ = _p_size;
					if (!(_tmp389_ < _tmp390_)) {
						break;
					}
					_tmp391_ = _p_list;
					_tmp392_ = gee_abstract_list_get ((GeeAbstractList*) _tmp391_, _p_index);
					p = (BirdFontPath*) _tmp392_;
					_tmp393_ = p;
					bird_font_path_update_region_boundaries (_tmp393_);
					_tmp394_ = p;
					if (_tmp394_->xmin < _vala_xmin) {
						BirdFontPath* _tmp395_;
						_tmp395_ = p;
						_vala_xmin = _tmp395_->xmin;
					}
					_tmp396_ = p;
					if (_tmp396_->xmax > _vala_xmax) {
						BirdFontPath* _tmp397_;
						_tmp397_ = p;
						_vala_xmax = _tmp397_->xmax;
					}
					_g_object_unref0 (p);
				}
			}
			_g_object_unref0 (ps);
		}
		_g_object_unref0 (visible_paths);
	}
	_tmp398_ = end_points;
	if (_tmp398_ != NULL) {
		guint16* _tmp399_;
		_tmp399_ = end_points;
		_g_free0 (_tmp399_);
	}
	_tmp400_ = instructions;
	if (_tmp400_ != NULL) {
		guint8* _tmp401_;
		_tmp401_ = instructions;
		_g_free0 (_tmp401_);
	}
	_tmp402_ = flags;
	if (_tmp402_ != NULL) {
		guint8* _tmp403_;
		_tmp403_ = flags;
		_g_free0 (_tmp403_);
	}
	_tmp404_ = xcoordinates;
	if (_tmp404_ != NULL) {
		gint16* _tmp405_;
		_tmp405_ = xcoordinates;
		_g_free0 (_tmp405_);
	}
	_tmp406_ = ycoordinates;
	if (_tmp406_ != NULL) {
		gint16* _tmp407_;
		_tmp407_ = ycoordinates;
		_g_free0 (_tmp407_);
	}
	_tmp408_ = _error_;
	if (_tmp408_ != NULL) {
		GError* _tmp409_;
		GError* _tmp410_;
		g_warning ("GlyfTable.vala:785: Failed to parse glyph");
		_tmp409_ = _error_;
		_tmp410_ = _g_error_copy0 ((GError*) _tmp409_);
		_inner_error0_ = _tmp410_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (glyph);
		_g_string_free0 (name);
		_g_error_free0 (_error_);
		return NULL;
	}
	result = glyph;
	_g_string_free0 (name);
	_g_error_free0 (_error_);
	if (xmin) {
		*xmin = _vala_xmin;
	}
	if (xmax) {
		*xmax = _vala_xmax;
	}
	return result;
}

static void
bird_font_glyf_table_class_init (BirdFontGlyfTableClass * klass,
                                 gpointer klass_data)
{
	bird_font_glyf_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontGlyfTable_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_glyf_table_finalize;
}

static void
bird_font_glyf_table_instance_init (BirdFontGlyfTable * self,
                                    gpointer klass)
{
	self->priv = bird_font_glyf_table_get_instance_private (self);
	self->xmin = G_MAXINT16;
	self->ymin = G_MAXINT16;
	self->xmax = G_MININT16;
	self->ymax = G_MININT16;
	self->priv->max_points = (guint16) 0;
	self->priv->max_contours = (guint16) 0;
}

static void
bird_font_glyf_table_finalize (GObject * obj)
{
	BirdFontGlyfTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_GLYF_TABLE, BirdFontGlyfTable);
	_g_object_unref0 (self->dis);
	_g_object_unref0 (self->head_table);
	_g_object_unref0 (self->hmtx_table);
	_g_object_unref0 (self->loca_table);
	_g_object_unref0 (self->cmap_table);
	_g_object_unref0 (self->post_table);
	_g_object_unref0 (self->kern_table);
	_g_object_unref0 (self->location_offsets);
	_g_object_unref0 (self->glyphs);
	_g_object_unref0 (self->glyf_data);
	G_OBJECT_CLASS (bird_font_glyf_table_parent_class)->finalize (obj);
}

static GType
bird_font_glyf_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontGlyfTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_glyf_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontGlyfTable), 0, (GInstanceInitFunc) bird_font_glyf_table_instance_init, NULL };
	GType bird_font_glyf_table_type_id;
	bird_font_glyf_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontGlyfTable", &g_define_type_info, 0);
	BirdFontGlyfTable_private_offset = g_type_add_instance_private (bird_font_glyf_table_type_id, sizeof (BirdFontGlyfTablePrivate));
	return bird_font_glyf_table_type_id;
}

GType
bird_font_glyf_table_get_type (void)
{
	static volatile gsize bird_font_glyf_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_glyf_table_type_id__once)) {
		GType bird_font_glyf_table_type_id;
		bird_font_glyf_table_type_id = bird_font_glyf_table_get_type_once ();
		g_once_init_leave (&bird_font_glyf_table_type_id__once, bird_font_glyf_table_type_id);
	}
	return bird_font_glyf_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

