/* GlyfData.c generated by valac 0.56.16, the Vala compiler
 * generated from GlyfData.vala, do not modify */

/*
Copyright (C) 2012, 2013, 2014 2017 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_COORDINATE_FLAGS_0_PROPERTY,
	BIRD_FONT_COORDINATE_FLAGS_NUM_PROPERTIES
};
static GParamSpec* bird_font_coordinate_flags_properties[BIRD_FONT_COORDINATE_FLAGS_NUM_PROPERTIES];
enum  {
	BIRD_FONT_GLYF_DATA_0_PROPERTY,
	BIRD_FONT_GLYF_DATA_NUM_PROPERTIES
};
static GParamSpec* bird_font_glyf_data_properties[BIRD_FONT_GLYF_DATA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block74Data Block74Data;
typedef struct _Block75Data Block75Data;
typedef struct _Block76Data Block76Data;

struct _BirdFontGlyfDataPrivate {
	guint16 end_point;
	guint16 nflags;
	BirdFontGlyph* glyph;
};

struct _Block74Data {
	int _ref_count_;
	gdouble x0;
	gdouble y0;
	gdouble x1;
	gdouble y1;
	gdouble x2;
	gdouble y2;
	gdouble x3;
	gdouble y3;
	gdouble minx;
	gdouble maxx;
	gdouble miny;
	gdouble maxy;
	BirdFontPath* path_minx;
	BirdFontPath* path_maxx;
	BirdFontPath* path_miny;
	BirdFontPath* path_maxy;
};

struct _Block75Data {
	int _ref_count_;
	Block74Data * _data74_;
	BirdFontPath* next_path;
};

struct _Block76Data {
	int _ref_count_;
	gboolean has_extrema;
	gdouble coordinate;
};

static gpointer bird_font_coordinate_flags_parent_class = NULL;
static gint BirdFontGlyfData_private_offset;
static gpointer bird_font_glyf_data_parent_class = NULL;

static GType bird_font_coordinate_flags_get_type_once (void);
static gboolean bird_font_glyf_data_is_empty (BirdFontGlyfData* self,
                                       BirdFontPath* p);
static void bird_font_glyf_data_process_end_points (BirdFontGlyfData* self);
static void bird_font_glyf_data_process_flags (BirdFontGlyfData* self);
static void bird_font_glyf_data_process_x (BirdFontGlyfData* self);
static void bird_font_glyf_data_process_y (BirdFontGlyfData* self);
static void bird_font_glyf_data_process_bounding_box (BirdFontGlyfData* self);
static Block74Data* block74_data_ref (Block74Data* _data74_);
static void block74_data_unref (void * _userdata_);
static Block75Data* block75_data_ref (Block75Data* _data75_);
static void block75_data_unref (void * _userdata_);
static gboolean ____lambda375_ (Block75Data* _data75_,
                         gdouble x,
                         gdouble y);
static gboolean _____lambda375__bird_font_path_raster_iterator (gdouble x,
                                                         gdouble y,
                                                         gdouble step,
                                                         gpointer self);
static Block76Data* block76_data_ref (Block76Data* _data76_);
static void block76_data_unref (void * _userdata_);
static gboolean ___lambda376_ (Block76Data* _data76_,
                        BirdFontEditPoint* start,
                        BirdFontEditPoint* stop);
static gboolean ____lambda376__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                         BirdFontEditPoint* stop,
                                                         gpointer self);
static gboolean ___lambda377_ (Block76Data* _data76_,
                        BirdFontEditPoint* start,
                        BirdFontEditPoint* stop);
static gboolean ____lambda377__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                         BirdFontEditPoint* stop,
                                                         gpointer self);
static gboolean ___lambda378_ (Block76Data* _data76_,
                        BirdFontEditPoint* start,
                        BirdFontEditPoint* stop);
static gboolean ____lambda378__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                         BirdFontEditPoint* stop,
                                                         gpointer self);
static gboolean ___lambda379_ (Block76Data* _data76_,
                        BirdFontEditPoint* start,
                        BirdFontEditPoint* stop);
static gboolean ____lambda379__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                         BirdFontEditPoint* stop,
                                                         gpointer self);
static gdouble bird_font_glyf_data_get_UNITS (void);
static void bird_font_glyf_data_finalize (GObject * obj);
static GType bird_font_glyf_data_get_type_once (void);
static void _vala_bird_font_glyf_data_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

BirdFontCoordinateFlags*
bird_font_coordinate_flags_construct (GType object_type)
{
	BirdFontCoordinateFlags * self = NULL;
	self = (BirdFontCoordinateFlags*) g_object_new (object_type, NULL);
	return self;
}

BirdFontCoordinateFlags*
bird_font_coordinate_flags_new (void)
{
	return bird_font_coordinate_flags_construct (BIRD_FONT_TYPE_COORDINATE_FLAGS);
}

static void
bird_font_coordinate_flags_class_init (BirdFontCoordinateFlagsClass * klass,
                                       gpointer klass_data)
{
	bird_font_coordinate_flags_parent_class = g_type_class_peek_parent (klass);
}

static void
bird_font_coordinate_flags_instance_init (BirdFontCoordinateFlags * self,
                                          gpointer klass)
{
}

static GType
bird_font_coordinate_flags_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCoordinateFlagsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_coordinate_flags_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCoordinateFlags), 0, (GInstanceInitFunc) bird_font_coordinate_flags_instance_init, NULL };
	GType bird_font_coordinate_flags_type_id;
	bird_font_coordinate_flags_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontCoordinateFlags", &g_define_type_info, 0);
	return bird_font_coordinate_flags_type_id;
}

GType
bird_font_coordinate_flags_get_type (void)
{
	static volatile gsize bird_font_coordinate_flags_type_id__once = 0;
	if (g_once_init_enter (&bird_font_coordinate_flags_type_id__once)) {
		GType bird_font_coordinate_flags_type_id;
		bird_font_coordinate_flags_type_id = bird_font_coordinate_flags_get_type_once ();
		g_once_init_leave (&bird_font_coordinate_flags_type_id__once, bird_font_coordinate_flags_type_id);
	}
	return bird_font_coordinate_flags_type_id__once;
}

static inline gpointer
bird_font_glyf_data_get_instance_private (BirdFontGlyfData* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontGlyfData_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

BirdFontGlyfData*
bird_font_glyf_data_construct (GType object_type,
                               BirdFontGlyph* g)
{
	BirdFontGlyfData * self = NULL;
	BirdFontPathList* all_quadratic = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* qp = NULL;
	BirdFontPathList* _tmp1_;
	BirdFontGlyph* _tmp2_;
	gint i = 0;
	BirdFontPathList* _tmp36_;
	GeeArrayList* _tmp37_;
	GeeArrayList* _tmp38_;
	GeeArrayList* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	g_return_val_if_fail (g != NULL, NULL);
	self = (BirdFontGlyfData*) g_object_new (object_type, NULL);
	_tmp0_ = bird_font_glyph_get_quadratic_paths (g);
	all_quadratic = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	qp = _tmp1_;
	_tmp2_ = _g_object_ref0 (g);
	_g_object_unref0 (self->priv->glyph);
	self->priv->glyph = _tmp2_;
	i = 0;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _p_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _p_index = 0;
		_tmp3_ = all_quadratic;
		_tmp4_ = _tmp3_->paths;
		_p_list = _tmp4_;
		_tmp5_ = _p_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_p_size = _tmp7_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			BirdFontPath* _tmp12_;
			GeeArrayList* _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			BirdFontPath* _tmp24_;
			gint _tmp35_;
			_p_index = _p_index + 1;
			_tmp8_ = _p_index;
			_tmp9_ = _p_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _p_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _p_index);
			p = (BirdFontPath*) _tmp11_;
			_tmp12_ = p;
			_tmp13_ = bird_font_path_get_points (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ < 2) {
				GeeArrayList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp17_ = self->points;
				_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strdup_printf ("%i", _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strconcat ("Missing points, ", _tmp21_, " points in path.", NULL);
				_tmp23_ = _tmp22_;
				g_warning ("GlyfData.vala:68: %s", _tmp23_);
				_g_free0 (_tmp23_);
				_g_free0 (_tmp21_);
				_g_object_unref0 (p);
				continue;
			}
			_tmp24_ = p;
			if (G_LIKELY (!bird_font_glyf_data_is_empty (self, _tmp24_))) {
				BirdFontPathList* _tmp25_;
				BirdFontPath* _tmp26_;
				_tmp25_ = qp;
				_tmp26_ = p;
				bird_font_path_list_add (_tmp25_, _tmp26_);
			} else {
				gchar* _tmp27_;
				gchar* _tmp28_;
				BirdFontGlyph* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp27_ = g_strdup_printf ("%i", i);
				_tmp28_ = _tmp27_;
				_tmp29_ = self->priv->glyph;
				_tmp30_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = string_to_string (_tmp31_);
				_tmp33_ = g_strconcat ("Path number ", _tmp28_, " is empty in ", _tmp32_, NULL);
				_tmp34_ = _tmp33_;
				g_warning ("GlyfData.vala:75: %s", _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
			}
			_tmp35_ = i;
			i = _tmp35_ + 1;
			_g_object_unref0 (p);
		}
	}
	_tmp36_ = qp;
	bird_font_glyf_data_add_extrema_to_path (_tmp36_);
	_tmp37_ = self->points;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp37_);
	_tmp38_ = self->paths;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp38_);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp39_;
		GeeArrayList* _tmp40_;
		gint _p_size = 0;
		GeeArrayList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _p_index = 0;
		_tmp39_ = qp;
		_tmp40_ = _tmp39_->paths;
		_p_list = _tmp40_;
		_tmp41_ = _p_list;
		_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_p_size = _tmp43_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp46_;
			gpointer _tmp47_;
			GeeArrayList* _tmp48_;
			BirdFontPath* _tmp49_;
			_p_index = _p_index + 1;
			_tmp44_ = _p_index;
			_tmp45_ = _p_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _p_list;
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _p_index);
			p = (BirdFontPath*) _tmp47_;
			_tmp48_ = self->paths;
			_tmp49_ = p;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp49_);
			{
				GeeArrayList* _ep_list = NULL;
				BirdFontPath* _tmp50_;
				GeeArrayList* _tmp51_;
				GeeArrayList* _tmp52_;
				gint _ep_size = 0;
				GeeArrayList* _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				gint _ep_index = 0;
				_tmp50_ = p;
				_tmp51_ = bird_font_path_get_points (_tmp50_);
				_tmp52_ = _tmp51_;
				_ep_list = _tmp52_;
				_tmp53_ = _ep_list;
				_tmp54_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp53_);
				_tmp55_ = _tmp54_;
				_ep_size = _tmp55_;
				_ep_index = -1;
				while (TRUE) {
					gint _tmp56_;
					gint _tmp57_;
					BirdFontEditPoint* ep = NULL;
					GeeArrayList* _tmp58_;
					gpointer _tmp59_;
					GeeArrayList* _tmp60_;
					BirdFontEditPoint* _tmp61_;
					_ep_index = _ep_index + 1;
					_tmp56_ = _ep_index;
					_tmp57_ = _ep_size;
					if (!(_tmp56_ < _tmp57_)) {
						break;
					}
					_tmp58_ = _ep_list;
					_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _ep_index);
					ep = (BirdFontEditPoint*) _tmp59_;
					_tmp60_ = self->points;
					_tmp61_ = ep;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp60_, _tmp61_);
					_g_object_unref0 (ep);
				}
			}
			_g_object_unref0 (p);
		}
	}
	_tmp62_ = self->paths;
	_tmp63_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp62_);
	_tmp64_ = _tmp63_;
	if (_tmp64_ > 0) {
		bird_font_glyf_data_process_end_points (self);
		bird_font_glyf_data_process_flags (self);
		bird_font_glyf_data_process_x (self);
		bird_font_glyf_data_process_y (self);
		bird_font_glyf_data_process_bounding_box (self);
	}
	_g_object_unref0 (qp);
	_g_object_unref0 (all_quadratic);
	return self;
}

BirdFontGlyfData*
bird_font_glyf_data_new (BirdFontGlyph* g)
{
	return bird_font_glyf_data_construct (BIRD_FONT_TYPE_GLYF_DATA, g);
}

static Block74Data*
block74_data_ref (Block74Data* _data74_)
{
	g_atomic_int_inc (&_data74_->_ref_count_);
	return _data74_;
}

static void
block74_data_unref (void * _userdata_)
{
	Block74Data* _data74_;
	_data74_ = (Block74Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data74_->_ref_count_)) {
		_g_object_unref0 (_data74_->path_maxy);
		_g_object_unref0 (_data74_->path_miny);
		_g_object_unref0 (_data74_->path_maxx);
		_g_object_unref0 (_data74_->path_minx);
		g_slice_free (Block74Data, _data74_);
	}
}

static Block75Data*
block75_data_ref (Block75Data* _data75_)
{
	g_atomic_int_inc (&_data75_->_ref_count_);
	return _data75_;
}

static void
block75_data_unref (void * _userdata_)
{
	Block75Data* _data75_;
	_data75_ = (Block75Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data75_->_ref_count_)) {
		_g_object_unref0 (_data75_->next_path);
		block74_data_unref (_data75_->_data74_);
		_data75_->_data74_ = NULL;
		g_slice_free (Block75Data, _data75_);
	}
}

static gboolean
____lambda375_ (Block75Data* _data75_,
                gdouble x,
                gdouble y)
{
	Block74Data* _data74_;
	gboolean result;
	_data74_ = _data75_->_data74_;
	if (x < _data74_->minx) {
		BirdFontPath* _tmp0_;
		BirdFontPath* _tmp1_;
		_data74_->x0 = x;
		_data74_->y0 = y;
		_data74_->minx = x;
		_tmp0_ = _data75_->next_path;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (_data74_->path_minx);
		_data74_->path_minx = _tmp1_;
	}
	if (x > _data74_->maxx) {
		BirdFontPath* _tmp2_;
		BirdFontPath* _tmp3_;
		_data74_->x1 = x;
		_data74_->y1 = y;
		_data74_->maxx = x;
		_tmp2_ = _data75_->next_path;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (_data74_->path_maxx);
		_data74_->path_maxx = _tmp3_;
	}
	if (y < _data74_->miny) {
		BirdFontPath* _tmp4_;
		BirdFontPath* _tmp5_;
		_data74_->x2 = x;
		_data74_->y2 = y;
		_data74_->miny = y;
		_tmp4_ = _data75_->next_path;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (_data74_->path_miny);
		_data74_->path_miny = _tmp5_;
	}
	if (y > _data74_->maxy) {
		BirdFontPath* _tmp6_;
		BirdFontPath* _tmp7_;
		_data74_->x3 = x;
		_data74_->y3 = y;
		_data74_->maxy = y;
		_tmp6_ = _data75_->next_path;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (_data74_->path_maxy);
		_data74_->path_maxy = _tmp7_;
	}
	result = TRUE;
	return result;
}

static gboolean
_____lambda375__bird_font_path_raster_iterator (gdouble x,
                                                gdouble y,
                                                gdouble step,
                                                gpointer self)
{
	gboolean result;
	result = ____lambda375_ (self, x, y);
	return result;
}

void
bird_font_glyf_data_add_extrema_to_path (BirdFontPathList* path_list)
{
	Block74Data* _data74_;
	BirdFontPath* _tmp0_;
	BirdFontPath* _tmp1_;
	BirdFontPath* _tmp2_;
	BirdFontPath* _tmp3_;
	BirdFontPath* _tmp27_;
	BirdFontPath* _tmp31_;
	BirdFontPath* _tmp35_;
	BirdFontPath* _tmp39_;
	g_return_if_fail (path_list != NULL);
	_data74_ = g_slice_new0 (Block74Data);
	_data74_->_ref_count_ = 1;
	_tmp0_ = bird_font_path_new ();
	_g_object_unref0 (_data74_->path_minx);
	_data74_->path_minx = _tmp0_;
	_tmp1_ = bird_font_path_new ();
	_g_object_unref0 (_data74_->path_maxx);
	_data74_->path_maxx = _tmp1_;
	_tmp2_ = bird_font_path_new ();
	_g_object_unref0 (_data74_->path_miny);
	_data74_->path_miny = _tmp2_;
	_tmp3_ = bird_font_path_new ();
	_g_object_unref0 (_data74_->path_maxy);
	_data74_->path_maxy = _tmp3_;
	_data74_->minx = BIRD_FONT_GLYPH_CANVAS_MAX;
	_data74_->miny = BIRD_FONT_GLYPH_CANVAS_MAX;
	_data74_->maxx = BIRD_FONT_GLYPH_CANVAS_MIN;
	_data74_->maxy = BIRD_FONT_GLYPH_CANVAS_MIN;
	_data74_->x0 = (gdouble) 0;
	_data74_->y0 = (gdouble) 0;
	_data74_->x1 = (gdouble) 0;
	_data74_->y1 = (gdouble) 0;
	_data74_->x2 = (gdouble) 0;
	_data74_->y2 = (gdouble) 0;
	_data74_->x3 = (gdouble) 0;
	_data74_->y3 = (gdouble) 0;
	{
		GeeArrayList* _next_path_list = NULL;
		GeeArrayList* _tmp4_;
		gint _next_path_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _next_path_index = 0;
		_tmp4_ = path_list->paths;
		_next_path_list = _tmp4_;
		_tmp5_ = _next_path_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_next_path_size = _tmp7_;
		_next_path_index = -1;
		while (TRUE) {
			Block75Data* _data75_;
			gint _tmp8_;
			gint _tmp9_;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			BirdFontPath* _tmp12_;
			GeeArrayList* _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			BirdFontPath* _tmp26_;
			_data75_ = g_slice_new0 (Block75Data);
			_data75_->_ref_count_ = 1;
			_data75_->_data74_ = block74_data_ref (_data74_);
			_next_path_index = _next_path_index + 1;
			_tmp8_ = _next_path_index;
			_tmp9_ = _next_path_size;
			if (!(_tmp8_ < _tmp9_)) {
				block75_data_unref (_data75_);
				_data75_ = NULL;
				break;
			}
			_tmp10_ = _next_path_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _next_path_index);
			_data75_->next_path = (BirdFontPath*) _tmp11_;
			_tmp12_ = _data75_->next_path;
			_tmp13_ = bird_font_path_get_points (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ < 2) {
				BirdFontPath* _tmp17_;
				GeeArrayList* _tmp18_;
				GeeArrayList* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp17_ = _data75_->next_path;
				_tmp18_ = bird_font_path_get_points (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf ("%i", _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat ("Missing points, ", _tmp23_, " points in path.", NULL);
				_tmp25_ = _tmp24_;
				g_warning ("GlyfData.vala:129: %s", _tmp25_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp23_);
				block75_data_unref (_data75_);
				_data75_ = NULL;
				continue;
			}
			_tmp26_ = _data75_->next_path;
			bird_font_path_all_of_path (_tmp26_, _____lambda375__bird_font_path_raster_iterator, _data75_, 3000);
			block75_data_unref (_data75_);
			_data75_ = NULL;
		}
	}
	_tmp27_ = _data74_->path_minx;
	if (!bird_font_glyf_data_has_extrema (_tmp27_, _data74_->x0 + 0.001, TRUE, TRUE)) {
		BirdFontPath* _tmp28_;
		BirdFontEditPoint* _tmp29_;
		BirdFontEditPoint* _tmp30_;
		_tmp28_ = _data74_->path_minx;
		_tmp29_ = bird_font_path_insert_new_point_on_path_at (_tmp28_, _data74_->x0 - 0.001, _data74_->y0);
		_tmp30_ = _tmp29_;
		_g_object_unref0 (_tmp30_);
	}
	_tmp31_ = _data74_->path_maxx;
	if (!bird_font_glyf_data_has_extrema (_tmp31_, _data74_->x1 - 0.001, TRUE, FALSE)) {
		BirdFontPath* _tmp32_;
		BirdFontEditPoint* _tmp33_;
		BirdFontEditPoint* _tmp34_;
		_tmp32_ = _data74_->path_maxx;
		_tmp33_ = bird_font_path_insert_new_point_on_path_at (_tmp32_, _data74_->x1 + 0.001, _data74_->y1);
		_tmp34_ = _tmp33_;
		_g_object_unref0 (_tmp34_);
	}
	_tmp35_ = _data74_->path_maxy;
	if (!bird_font_glyf_data_has_extrema (_tmp35_, _data74_->y2 + 0.001, FALSE, TRUE)) {
		BirdFontPath* _tmp36_;
		BirdFontEditPoint* _tmp37_;
		BirdFontEditPoint* _tmp38_;
		_tmp36_ = _data74_->path_maxy;
		_tmp37_ = bird_font_path_insert_new_point_on_path_at (_tmp36_, _data74_->x2, _data74_->y2 - 0.001);
		_tmp38_ = _tmp37_;
		_g_object_unref0 (_tmp38_);
	}
	_tmp39_ = _data74_->path_miny;
	if (!bird_font_glyf_data_has_extrema (_tmp39_, _data74_->y3 - 0.001, FALSE, FALSE)) {
		BirdFontPath* _tmp40_;
		BirdFontEditPoint* _tmp41_;
		BirdFontEditPoint* _tmp42_;
		_tmp40_ = _data74_->path_miny;
		_tmp41_ = bird_font_path_insert_new_point_on_path_at (_tmp40_, _data74_->x3, _data74_->y3 + 0.001);
		_tmp42_ = _tmp41_;
		_g_object_unref0 (_tmp42_);
	}
	block74_data_unref (_data74_);
	_data74_ = NULL;
}

static Block76Data*
block76_data_ref (Block76Data* _data76_)
{
	g_atomic_int_inc (&_data76_->_ref_count_);
	return _data76_;
}

static void
block76_data_unref (void * _userdata_)
{
	Block76Data* _data76_;
	_data76_ = (Block76Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data76_->_ref_count_)) {
		g_slice_free (Block76Data, _data76_);
	}
}

static gboolean
___lambda376_ (Block76Data* _data76_,
               BirdFontEditPoint* start,
               BirdFontEditPoint* stop)
{
	gboolean result;
	g_return_val_if_fail (start != NULL, FALSE);
	g_return_val_if_fail (stop != NULL, FALSE);
	if (start->x < _data76_->coordinate) {
		_data76_->has_extrema = TRUE;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda376__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                BirdFontEditPoint* stop,
                                                gpointer self)
{
	gboolean result;
	result = ___lambda376_ (self, start, stop);
	return result;
}

static gboolean
___lambda377_ (Block76Data* _data76_,
               BirdFontEditPoint* start,
               BirdFontEditPoint* stop)
{
	gboolean result;
	g_return_val_if_fail (start != NULL, FALSE);
	g_return_val_if_fail (stop != NULL, FALSE);
	if (start->x > _data76_->coordinate) {
		_data76_->has_extrema = TRUE;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda377__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                BirdFontEditPoint* stop,
                                                gpointer self)
{
	gboolean result;
	result = ___lambda377_ (self, start, stop);
	return result;
}

static gboolean
___lambda378_ (Block76Data* _data76_,
               BirdFontEditPoint* start,
               BirdFontEditPoint* stop)
{
	gboolean result;
	g_return_val_if_fail (start != NULL, FALSE);
	g_return_val_if_fail (stop != NULL, FALSE);
	if (start->y < _data76_->coordinate) {
		_data76_->has_extrema = TRUE;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda378__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                BirdFontEditPoint* stop,
                                                gpointer self)
{
	gboolean result;
	result = ___lambda378_ (self, start, stop);
	return result;
}

static gboolean
___lambda379_ (Block76Data* _data76_,
               BirdFontEditPoint* start,
               BirdFontEditPoint* stop)
{
	gboolean result;
	g_return_val_if_fail (start != NULL, FALSE);
	g_return_val_if_fail (stop != NULL, FALSE);
	if (start->y > _data76_->coordinate) {
		_data76_->has_extrema = TRUE;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda379__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                BirdFontEditPoint* stop,
                                                gpointer self)
{
	gboolean result;
	result = ___lambda379_ (self, start, stop);
	return result;
}

gboolean
bird_font_glyf_data_has_extrema (BirdFontPath* path,
                                 gdouble coordinate,
                                 gboolean x,
                                 gboolean min)
{
	Block76Data* _data76_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	_data76_ = g_slice_new0 (Block76Data);
	_data76_->_ref_count_ = 1;
	_data76_->coordinate = coordinate;
	_data76_->has_extrema = FALSE;
	if (x) {
		_tmp0_ = min;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		bird_font_path_all_segments (path, ____lambda376__bird_font_path_segment_iterator, _data76_);
	}
	if (x) {
		_tmp1_ = !min;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		bird_font_path_all_segments (path, ____lambda377__bird_font_path_segment_iterator, _data76_);
	}
	if (!x) {
		_tmp2_ = min;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		bird_font_path_all_segments (path, ____lambda378__bird_font_path_segment_iterator, _data76_);
	}
	if (!x) {
		_tmp3_ = !min;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		bird_font_path_all_segments (path, ____lambda379__bird_font_path_segment_iterator, _data76_);
	}
	result = _data76_->has_extrema;
	block76_data_unref (_data76_);
	_data76_ = NULL;
	return result;
}

static gboolean
bird_font_glyf_data_is_empty (BirdFontGlyfData* self,
                              BirdFontPath* p)
{
	BirdFontEditPoint* last = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	last = NULL;
	_tmp0_ = bird_font_path_get_points (p);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (G_UNLIKELY (_tmp3_ < 2)) {
		result = TRUE;
		_g_object_unref0 (last);
		return result;
	}
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _ep_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _ep_index = 0;
		_tmp4_ = bird_font_path_get_points (p);
		_tmp5_ = _tmp4_;
		_ep_list = _tmp5_;
		_tmp6_ = _ep_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_ep_size = _tmp8_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			gboolean _tmp13_ = FALSE;
			BirdFontEditPoint* _tmp14_;
			BirdFontEditPoint* _tmp17_;
			BirdFontEditPoint* _tmp18_;
			_ep_index = _ep_index + 1;
			_tmp9_ = _ep_index;
			_tmp10_ = _ep_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _ep_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp12_;
			_tmp14_ = last;
			if (_tmp14_ != NULL) {
				BirdFontEditPoint* _tmp15_;
				BirdFontEditPoint* _tmp16_;
				_tmp15_ = ep;
				_tmp16_ = last;
				_tmp13_ = !bird_font_edit_point_equals (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint));
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				result = FALSE;
				_g_object_unref0 (ep);
				_g_object_unref0 (last);
				return result;
			}
			_tmp17_ = ep;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (last);
			last = _tmp18_;
			_g_object_unref0 (ep);
		}
	}
	result = TRUE;
	_g_object_unref0 (last);
	return result;
}

guint16
bird_font_glyf_data_get_end_point (BirdFontGlyfData* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->end_point;
	return result;
}

gint16
bird_font_glyf_data_get_ncontours (BirdFontGlyfData* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint16 result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->paths;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (gint16) _tmp2_;
	return result;
}

guint16
bird_font_glyf_data_get_nflags (BirdFontGlyfData* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->nflags;
	return result;
}

/** Count off curve points and on curve points.
 * @return the number of points or uint16.MAX if more than uint16.MAX points where found. 
 */
gint
bird_font_glyf_data_get_num_points (BirdFontGlyfData* self)
{
	gint points = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	points = 0;
	{
		GeeArrayList* _quadratic_list = NULL;
		GeeArrayList* _tmp0_;
		gint _quadratic_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _quadratic_index = 0;
		_tmp0_ = self->paths;
		_quadratic_list = _tmp0_;
		_tmp1_ = _quadratic_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_quadratic_size = _tmp3_;
		_quadratic_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* quadratic = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			GeeArrayList* _tmp9_;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_quadratic_index = _quadratic_index + 1;
			_tmp4_ = _quadratic_index;
			_tmp5_ = _quadratic_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _quadratic_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _quadratic_index);
			quadratic = (BirdFontPath*) _tmp7_;
			_tmp8_ = quadratic;
			_tmp9_ = bird_font_path_get_points (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			points += 2 * _tmp12_;
			if (points >= ((gint) G_MAXUINT16)) {
				result = (gint) G_MAXUINT16;
				_g_object_unref0 (quadratic);
				return result;
			}
			_g_object_unref0 (quadratic);
		}
	}
	result = points;
	return result;
}

static void
bird_font_glyf_data_process_end_points (BirdFontGlyfData* self)
{
	guint16 last_end_point = 0U;
	BirdFontPointType type = 0;
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	last_end_point = (guint16) 0;
	_tmp0_ = self->end_points;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	self->priv->end_point = (guint16) 0;
	{
		GeeArrayList* _quadratic_list = NULL;
		GeeArrayList* _tmp1_;
		gint _quadratic_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _quadratic_index = 0;
		_tmp1_ = self->paths;
		_quadratic_list = _tmp1_;
		_tmp2_ = _quadratic_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_quadratic_size = _tmp4_;
		_quadratic_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* quadratic = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPath* _tmp9_;
			GeeArrayList* _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			BirdFontPath* _tmp23_;
			GeeArrayList* _tmp24_;
			GeeArrayList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GeeArrayList* _tmp54_;
			_quadratic_index = _quadratic_index + 1;
			_tmp5_ = _quadratic_index;
			_tmp6_ = _quadratic_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _quadratic_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _quadratic_index);
			quadratic = (BirdFontPath*) _tmp8_;
			_tmp9_ = quadratic;
			_tmp10_ = bird_font_path_get_points (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			if (G_UNLIKELY (_tmp13_ == 0)) {
				BirdFontPath* _tmp14_;
				GeeArrayList* _tmp15_;
				GeeArrayList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp14_ = quadratic;
				_tmp15_ = bird_font_path_get_points (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strdup_printf ("%i", _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat ("No points in path (before conversion ", _tmp20_, ")", NULL);
				_tmp22_ = _tmp21_;
				g_warning ("GlyfData.vala:288: %s", _tmp22_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_g_object_unref0 (quadratic);
				continue;
			}
			_tmp23_ = quadratic;
			_tmp24_ = bird_font_path_get_points (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			if (G_UNLIKELY (_tmp27_ < 2)) {
				g_warning ("GlyfData.vala:293: A path contains less than three points, it will not" \
" be exported. Path number: $path_number");
				_g_object_unref0 (quadratic);
				continue;
			}
			{
				GeeArrayList* _e_list = NULL;
				BirdFontPath* _tmp28_;
				GeeArrayList* _tmp29_;
				GeeArrayList* _tmp30_;
				gint _e_size = 0;
				GeeArrayList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _e_index = 0;
				_tmp28_ = quadratic;
				_tmp29_ = bird_font_path_get_points (_tmp28_);
				_tmp30_ = _tmp29_;
				_e_list = _tmp30_;
				_tmp31_ = _e_list;
				_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_e_size = _tmp33_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp34_;
					gint _tmp35_;
					BirdFontEditPoint* e = NULL;
					GeeArrayList* _tmp36_;
					gpointer _tmp37_;
					guint16 _tmp44_;
					BirdFontEditPoint* _tmp45_;
					BirdFontEditPointHandle* _tmp46_;
					guint16 _tmp53_;
					_e_index = _e_index + 1;
					_tmp34_ = _e_index;
					_tmp35_ = _e_size;
					if (!(_tmp34_ < _tmp35_)) {
						break;
					}
					_tmp36_ = _e_list;
					_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _e_index);
					e = (BirdFontEditPoint*) _tmp37_;
					if (G_UNLIKELY (((gint) self->priv->nflags) == (G_MAXUINT16 - 1))) {
						BirdFontGlyph* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						const gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp38_ = self->priv->glyph;
						_tmp39_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = string_to_string (_tmp40_);
						_tmp42_ = g_strconcat ("Too many end points in ", _tmp41_, NULL);
						_tmp43_ = _tmp42_;
						g_warning ("GlyfData.vala:299: %s", _tmp43_);
						_g_free0 (_tmp43_);
						_g_free0 (_tmp40_);
						_g_object_unref0 (e);
						break;
					}
					_tmp44_ = self->priv->end_point;
					self->priv->end_point = _tmp44_ + 1;
					_tmp45_ = e;
					_tmp46_ = bird_font_edit_point_get_right_handle (_tmp45_);
					type = _tmp46_->type;
					if (G_UNLIKELY (((gint) self->priv->nflags) == (G_MAXUINT16 - 1))) {
						BirdFontGlyph* _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						const gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						_tmp47_ = self->priv->glyph;
						_tmp48_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp47_);
						_tmp49_ = _tmp48_;
						_tmp50_ = string_to_string (_tmp49_);
						_tmp51_ = g_strconcat ("Too many end points in ", _tmp50_, NULL);
						_tmp52_ = _tmp51_;
						g_warning ("GlyfData.vala:308: %s", _tmp52_);
						_g_free0 (_tmp52_);
						_g_free0 (_tmp49_);
						_g_object_unref0 (e);
						break;
					}
					_tmp53_ = self->priv->end_point;
					self->priv->end_point = _tmp53_ + 1;
					_g_object_unref0 (e);
				}
			}
			_tmp54_ = self->end_points;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, (gpointer) ((guintptr) (self->priv->end_point - 1)));
			if (G_UNLIKELY ((self->priv->end_point - 1) < ((gint) last_end_point))) {
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				_tmp55_ = g_strdup_printf ("%i", self->priv->end_point - 1);
				_tmp56_ = _tmp55_;
				_tmp57_ = g_strdup_printf ("%hu", last_end_point);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_strconcat ("Next endpoint has bad value. (end_point - 1 < last_end_point)  (", _tmp56_, " < ", _tmp58_, ")", NULL);
				_tmp60_ = _tmp59_;
				g_warning ("GlyfData.vala:317: %s", _tmp60_);
				_g_free0 (_tmp60_);
				_g_free0 (_tmp58_);
				_g_free0 (_tmp56_);
			}
			last_end_point = (guint16) (self->priv->end_point - 1);
			_g_object_unref0 (quadratic);
		}
	}
	if (G_UNLIKELY (((gint) self->priv->end_point) == 0)) {
		BirdFontGlyph* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp61_ = self->priv->glyph;
		_tmp62_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = string_to_string (_tmp63_);
		_tmp65_ = g_strconcat ("End point is zero for glyph ", _tmp64_, NULL);
		_tmp66_ = _tmp65_;
		g_warning ("GlyfData.vala:324: %s", _tmp66_);
		_g_free0 (_tmp66_);
		_g_free0 (_tmp63_);
	}
}

static void
bird_font_glyf_data_process_flags (BirdFontGlyfData* self)
{
	BirdFontPointType type = 0;
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_UCHAR, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->flags);
	self->flags = _tmp0_;
	self->priv->nflags = (guint16) 0;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = self->paths;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			{
				GeeArrayList* _e_list = NULL;
				BirdFontPath* _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				gint _e_size = 0;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _e_index = 0;
				_tmp9_ = p;
				_tmp10_ = bird_font_path_get_points (_tmp9_);
				_tmp11_ = _tmp10_;
				_e_list = _tmp11_;
				_tmp12_ = _e_list;
				_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_e_size = _tmp14_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp15_;
					gint _tmp16_;
					BirdFontEditPoint* e = NULL;
					GeeArrayList* _tmp17_;
					gpointer _tmp18_;
					GeeArrayList* _tmp19_;
					guint16 _tmp20_;
					BirdFontEditPoint* _tmp21_;
					BirdFontEditPointHandle* _tmp22_;
					GeeArrayList* _tmp23_;
					guint16 _tmp30_;
					_e_index = _e_index + 1;
					_tmp15_ = _e_index;
					_tmp16_ = _e_size;
					if (!(_tmp15_ < _tmp16_)) {
						break;
					}
					_tmp17_ = _e_list;
					_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _e_index);
					e = (BirdFontEditPoint*) _tmp18_;
					_tmp19_ = self->flags;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (gpointer) ((guintptr) BIRD_FONT_COORDINATE_FLAGS_ON_PATH));
					_tmp20_ = self->priv->nflags;
					self->priv->nflags = _tmp20_ + 1;
					_tmp21_ = e;
					_tmp22_ = bird_font_edit_point_get_right_handle (_tmp21_);
					type = _tmp22_->type;
					_tmp23_ = self->flags;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, (gpointer) ((guintptr) BIRD_FONT_COORDINATE_FLAGS_NONE));
					if (G_UNLIKELY (self->priv->nflags == G_MAXUINT16)) {
						BirdFontGlyph* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp24_ = self->priv->glyph;
						_tmp25_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = string_to_string (_tmp26_);
						_tmp28_ = g_strconcat ("Too many flags in ", _tmp27_, NULL);
						_tmp29_ = _tmp28_;
						g_warning ("GlyfData.vala:345: %s", _tmp29_);
						_g_free0 (_tmp29_);
						_g_free0 (_tmp26_);
						_g_object_unref0 (e);
						_g_object_unref0 (p);
						return;
					}
					_tmp30_ = self->priv->nflags;
					self->priv->nflags = _tmp30_ + 1;
					_g_object_unref0 (e);
				}
			}
			_g_object_unref0 (p);
		}
	}
}

gdouble
bird_font_glyf_data_tie_to_ttf_grid_x (BirdFontGlyph* glyph,
                                       gdouble x)
{
	gdouble ttf_x = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble result;
	g_return_val_if_fail (glyph != NULL, 0.0);
	_tmp0_ = bird_font_glyf_data_get_UNITS ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_glyph_get_left_limit (glyph);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_glyf_data_get_UNITS ();
	_tmp5_ = _tmp4_;
	ttf_x = rint ((x * _tmp1_) - (_tmp3_ * _tmp5_));
	_tmp6_ = bird_font_glyf_data_get_UNITS ();
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_glyph_get_left_limit (glyph);
	_tmp9_ = _tmp8_;
	result = (ttf_x / _tmp7_) + _tmp9_;
	return result;
}

gdouble
bird_font_glyf_data_tie_to_ttf_grid_y (BirdFontFont* font,
                                       gdouble y)
{
	gdouble ttf_y = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble result;
	g_return_val_if_fail (font != NULL, 0.0);
	_tmp0_ = bird_font_glyf_data_get_UNITS ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_glyf_data_get_UNITS ();
	_tmp3_ = _tmp2_;
	ttf_y = rint ((y * _tmp1_) - (font->base_line * _tmp3_));
	_tmp4_ = bird_font_glyf_data_get_UNITS ();
	_tmp5_ = _tmp4_;
	result = (ttf_y / _tmp5_) + font->base_line;
	return result;
}

static void
bird_font_glyf_data_process_x (BirdFontGlyfData* self)
{
	gdouble prev = 0.0;
	gdouble x = 0.0;
	BirdFontPointType type = 0;
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	prev = (gdouble) 0;
	_tmp0_ = self->coordinate_x;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = self->paths;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			{
				GeeArrayList* _e_list = NULL;
				BirdFontPath* _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				gint _e_size = 0;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _e_index = 0;
				_tmp9_ = p;
				_tmp10_ = bird_font_path_get_points (_tmp9_);
				_tmp11_ = _tmp10_;
				_e_list = _tmp11_;
				_tmp12_ = _e_list;
				_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_e_size = _tmp14_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp15_;
					gint _tmp16_;
					BirdFontEditPoint* e = NULL;
					GeeArrayList* _tmp17_;
					gpointer _tmp18_;
					BirdFontEditPoint* _tmp19_;
					gdouble _tmp20_;
					gdouble _tmp21_;
					BirdFontGlyph* _tmp22_;
					gdouble _tmp23_;
					gdouble _tmp24_;
					gdouble _tmp25_;
					gdouble _tmp26_;
					GeeArrayList* _tmp27_;
					BirdFontEditPoint* _tmp28_;
					gdouble _tmp29_;
					gdouble _tmp30_;
					BirdFontGlyph* _tmp31_;
					gdouble _tmp32_;
					gdouble _tmp33_;
					gdouble _tmp34_;
					gdouble _tmp35_;
					BirdFontEditPoint* _tmp36_;
					BirdFontEditPointHandle* _tmp37_;
					BirdFontEditPoint* _tmp38_;
					BirdFontEditPointHandle* _tmp39_;
					gdouble _tmp40_;
					gdouble _tmp41_;
					gdouble _tmp42_;
					gdouble _tmp43_;
					BirdFontGlyph* _tmp44_;
					gdouble _tmp45_;
					gdouble _tmp46_;
					gdouble _tmp47_;
					gdouble _tmp48_;
					GeeArrayList* _tmp49_;
					BirdFontEditPoint* _tmp50_;
					BirdFontEditPointHandle* _tmp51_;
					gdouble _tmp52_;
					gdouble _tmp53_;
					gdouble _tmp54_;
					gdouble _tmp55_;
					BirdFontGlyph* _tmp56_;
					gdouble _tmp57_;
					gdouble _tmp58_;
					gdouble _tmp59_;
					gdouble _tmp60_;
					_e_index = _e_index + 1;
					_tmp15_ = _e_index;
					_tmp16_ = _e_size;
					if (!(_tmp15_ < _tmp16_)) {
						break;
					}
					_tmp17_ = _e_list;
					_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _e_index);
					e = (BirdFontEditPoint*) _tmp18_;
					_tmp19_ = e;
					_tmp20_ = bird_font_glyf_data_get_UNITS ();
					_tmp21_ = _tmp20_;
					_tmp22_ = self->priv->glyph;
					_tmp23_ = bird_font_glyph_get_left_limit (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = bird_font_glyf_data_get_UNITS ();
					_tmp26_ = _tmp25_;
					x = rint (((_tmp19_->x * _tmp21_) - prev) - (_tmp24_ * _tmp26_));
					_tmp27_ = self->coordinate_x;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, (gpointer) ((gintptr) x));
					_tmp28_ = e;
					_tmp29_ = bird_font_glyf_data_get_UNITS ();
					_tmp30_ = _tmp29_;
					_tmp31_ = self->priv->glyph;
					_tmp32_ = bird_font_glyph_get_left_limit (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = bird_font_glyf_data_get_UNITS ();
					_tmp35_ = _tmp34_;
					prev = rint ((_tmp28_->x * _tmp30_) - (_tmp33_ * _tmp35_));
					_tmp36_ = e;
					_tmp37_ = bird_font_edit_point_get_right_handle (_tmp36_);
					type = _tmp37_->type;
					_tmp38_ = e;
					_tmp39_ = bird_font_edit_point_get_right_handle (_tmp38_);
					_tmp40_ = bird_font_edit_point_handle_get_x (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = bird_font_glyf_data_get_UNITS ();
					_tmp43_ = _tmp42_;
					_tmp44_ = self->priv->glyph;
					_tmp45_ = bird_font_glyph_get_left_limit (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = bird_font_glyf_data_get_UNITS ();
					_tmp48_ = _tmp47_;
					x = rint (((_tmp41_ * _tmp43_) - prev) - (_tmp46_ * _tmp48_));
					_tmp49_ = self->coordinate_x;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, (gpointer) ((gintptr) x));
					_tmp50_ = e;
					_tmp51_ = bird_font_edit_point_get_right_handle (_tmp50_);
					_tmp52_ = bird_font_edit_point_handle_get_x (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = bird_font_glyf_data_get_UNITS ();
					_tmp55_ = _tmp54_;
					_tmp56_ = self->priv->glyph;
					_tmp57_ = bird_font_glyph_get_left_limit (_tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = bird_font_glyf_data_get_UNITS ();
					_tmp60_ = _tmp59_;
					prev = rint ((_tmp53_ * _tmp55_) - (_tmp58_ * _tmp60_));
					_g_object_unref0 (e);
				}
			}
			_g_object_unref0 (p);
		}
	}
}

static void
bird_font_glyf_data_process_y (BirdFontGlyfData* self)
{
	gdouble prev = 0.0;
	gdouble y = 0.0;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontPointType type = 0;
	gint epi = 0;
	GeeArrayList* _tmp1_;
	gint path_number = 0;
	g_return_if_fail (self != NULL);
	prev = (gdouble) 0;
	_tmp0_ = bird_font_open_font_format_writer_get_current_font ();
	font = _tmp0_;
	epi = 0;
	_tmp1_ = self->coordinate_y;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	path_number = 0;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp2_;
		gint _p_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p_index = 0;
		_tmp2_ = self->paths;
		_p_list = _tmp2_;
		_tmp3_ = _p_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p_size = _tmp5_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gint _tmp78_;
			_p_index = _p_index + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _p_index);
			p = (BirdFontPath*) _tmp9_;
			{
				GeeArrayList* _e_list = NULL;
				BirdFontPath* _tmp10_;
				GeeArrayList* _tmp11_;
				GeeArrayList* _tmp12_;
				gint _e_size = 0;
				GeeArrayList* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _e_index = 0;
				_tmp10_ = p;
				_tmp11_ = bird_font_path_get_points (_tmp10_);
				_tmp12_ = _tmp11_;
				_e_list = _tmp12_;
				_tmp13_ = _e_list;
				_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
				_tmp15_ = _tmp14_;
				_e_size = _tmp15_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp16_;
					gint _tmp17_;
					BirdFontEditPoint* e = NULL;
					GeeArrayList* _tmp18_;
					gpointer _tmp19_;
					BirdFontEditPoint* _tmp20_;
					gdouble _tmp21_;
					gdouble _tmp22_;
					BirdFontFont* _tmp23_;
					gdouble _tmp24_;
					gdouble _tmp25_;
					GeeArrayList* _tmp26_;
					gboolean _tmp27_ = FALSE;
					BirdFontEditPoint* _tmp50_;
					gdouble _tmp51_;
					gdouble _tmp52_;
					BirdFontFont* _tmp53_;
					gdouble _tmp54_;
					gdouble _tmp55_;
					BirdFontEditPoint* _tmp56_;
					BirdFontEditPointHandle* _tmp57_;
					BirdFontEditPoint* _tmp58_;
					BirdFontEditPointHandle* _tmp59_;
					gdouble _tmp60_;
					gdouble _tmp61_;
					gdouble _tmp62_;
					gdouble _tmp63_;
					BirdFontFont* _tmp64_;
					gdouble _tmp65_;
					gdouble _tmp66_;
					GeeArrayList* _tmp67_;
					BirdFontEditPoint* _tmp68_;
					BirdFontEditPointHandle* _tmp69_;
					gdouble _tmp70_;
					gdouble _tmp71_;
					gdouble _tmp72_;
					gdouble _tmp73_;
					BirdFontFont* _tmp74_;
					gdouble _tmp75_;
					gdouble _tmp76_;
					gint _tmp77_;
					_e_index = _e_index + 1;
					_tmp16_ = _e_index;
					_tmp17_ = _e_size;
					if (!(_tmp16_ < _tmp17_)) {
						break;
					}
					_tmp18_ = _e_list;
					_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _e_index);
					e = (BirdFontEditPoint*) _tmp19_;
					_tmp20_ = e;
					_tmp21_ = bird_font_glyf_data_get_UNITS ();
					_tmp22_ = _tmp21_;
					_tmp23_ = font;
					_tmp24_ = bird_font_glyf_data_get_UNITS ();
					_tmp25_ = _tmp24_;
					y = rint (((_tmp20_->y * _tmp22_) - prev) - (_tmp23_->base_line * _tmp25_));
					_tmp26_ = self->coordinate_y;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, (gpointer) ((gintptr) y));
					if (((gint) ((gint16) y)) == 0) {
						GeeArrayList* _tmp28_;
						GeeArrayList* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						gpointer _tmp32_;
						_tmp28_ = self->coordinate_x;
						_tmp29_ = self->coordinate_y;
						_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp31_ - 1);
						_tmp27_ = ((gint) ((gint16) ((gint16) ((gintptr) _tmp32_)))) == 0;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						GeeArrayList* _tmp33_;
						gint _tmp34_;
						gint _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						BirdFontGlyph* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						const gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						_tmp33_ = self->coordinate_y;
						_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strdup_printf ("%i", _tmp35_ - 1);
						_tmp37_ = _tmp36_;
						_tmp38_ = g_strconcat ("Point on point in TTF. Index ", _tmp37_, " ", NULL);
						_tmp39_ = _tmp38_;
						_tmp40_ = g_strdup_printf ("%i", path_number);
						_tmp41_ = _tmp40_;
						_tmp42_ = self->priv->glyph;
						_tmp43_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = string_to_string (_tmp44_);
						_tmp46_ = g_strconcat ("Path: ", _tmp41_, " in ", _tmp45_, NULL);
						_tmp47_ = _tmp46_;
						_tmp48_ = g_strconcat (_tmp39_, _tmp47_, NULL);
						_tmp49_ = _tmp48_;
						g_warning ("GlyfData.vala:407: %s", _tmp49_);
						_g_free0 (_tmp49_);
						_g_free0 (_tmp47_);
						_g_free0 (_tmp44_);
						_g_free0 (_tmp41_);
						_g_free0 (_tmp39_);
						_g_free0 (_tmp37_);
					}
					_tmp50_ = e;
					_tmp51_ = bird_font_glyf_data_get_UNITS ();
					_tmp52_ = _tmp51_;
					_tmp53_ = font;
					_tmp54_ = bird_font_glyf_data_get_UNITS ();
					_tmp55_ = _tmp54_;
					prev = rint ((_tmp50_->y * _tmp52_) - (_tmp53_->base_line * _tmp55_));
					_tmp56_ = e;
					_tmp57_ = bird_font_edit_point_get_right_handle (_tmp56_);
					type = _tmp57_->type;
					_tmp58_ = e;
					_tmp59_ = bird_font_edit_point_get_right_handle (_tmp58_);
					_tmp60_ = bird_font_edit_point_handle_get_y (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = bird_font_glyf_data_get_UNITS ();
					_tmp63_ = _tmp62_;
					_tmp64_ = font;
					_tmp65_ = bird_font_glyf_data_get_UNITS ();
					_tmp66_ = _tmp65_;
					y = rint (((_tmp61_ * _tmp63_) - prev) - (_tmp64_->base_line * _tmp66_));
					_tmp67_ = self->coordinate_y;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, (gpointer) ((gintptr) y));
					_tmp68_ = e;
					_tmp69_ = bird_font_edit_point_get_right_handle (_tmp68_);
					_tmp70_ = bird_font_edit_point_handle_get_y (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = bird_font_glyf_data_get_UNITS ();
					_tmp73_ = _tmp72_;
					_tmp74_ = font;
					_tmp75_ = bird_font_glyf_data_get_UNITS ();
					_tmp76_ = _tmp75_;
					prev = rint ((_tmp71_ * _tmp73_) - (_tmp74_->base_line * _tmp76_));
					_tmp77_ = epi;
					epi = _tmp77_ + 1;
					_g_object_unref0 (e);
				}
			}
			_tmp78_ = path_number;
			path_number = _tmp78_ + 1;
			_g_object_unref0 (p);
		}
	}
	_g_object_unref0 (font);
}

static void
bird_font_glyf_data_process_bounding_box (BirdFontGlyfData* self)
{
	gint16 last = 0;
	gint i = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	g_return_if_fail (self != NULL);
	last = (gint16) 0;
	i = 0;
	self->bounding_box_xmin = G_MAXINT16;
	self->bounding_box_ymin = G_MAXINT16;
	self->bounding_box_xmax = G_MININT16;
	self->bounding_box_ymax = G_MININT16;
	_tmp0_ = self->coordinate_x;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		g_warning ("GlyfData.vala:437: no points in coordinate_y");
	}
	{
		GeeArrayList* _c_list = NULL;
		GeeArrayList* _tmp3_;
		gint _c_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _c_index = 0;
		_tmp3_ = self->coordinate_x;
		_c_list = _tmp3_;
		_tmp4_ = _c_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_c_size = _tmp6_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint16 c = 0;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			gint _tmp11_;
			_c_index = _c_index + 1;
			_tmp7_ = _c_index;
			_tmp8_ = _c_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _c_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _c_index);
			c = (gint16) ((gintptr) _tmp10_);
			c += last;
			if (c < self->bounding_box_xmin) {
				self->bounding_box_xmin = c;
			}
			if (c > self->bounding_box_xmax) {
				self->bounding_box_xmax = c;
			}
			last = c;
			_tmp11_ = i;
			i = _tmp11_ + 1;
		}
	}
	_tmp12_ = self->coordinate_y;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == 0) {
		g_warning ("GlyfData.vala:456: no points in coordinate_y");
	}
	last = (gint16) 0;
	i = 0;
	{
		GeeArrayList* _c_list = NULL;
		GeeArrayList* _tmp15_;
		gint _c_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _c_index = 0;
		_tmp15_ = self->coordinate_y;
		_c_list = _tmp15_;
		_tmp16_ = _c_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_c_size = _tmp18_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			gint16 c = 0;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			gint _tmp23_;
			_c_index = _c_index + 1;
			_tmp19_ = _c_index;
			_tmp20_ = _c_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _c_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _c_index);
			c = (gint16) ((gintptr) _tmp22_);
			c += last;
			if (c < self->bounding_box_ymin) {
				self->bounding_box_ymin = c;
			}
			if (c > self->bounding_box_ymax) {
				self->bounding_box_ymax = c;
			}
			last = c;
			_tmp23_ = i;
			i = _tmp23_ + 1;
		}
	}
	_tmp24_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->bounding_box_xmin);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->bounding_box_ymin);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->bounding_box_xmax);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup_printf ("%" G_GINT16_FORMAT, self->bounding_box_ymax);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat ("Bounding box: ", _tmp25_, ",", _tmp27_, "  ", _tmp29_, ",", _tmp31_, "\n", NULL);
	_tmp33_ = _tmp32_;
	bird_font_printd (_tmp33_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
}

static gdouble
bird_font_glyf_data_get_UNITS (void)
{
	gdouble result;
	result = bird_font_head_table_UNITS;
	return result;
}

static void
bird_font_glyf_data_class_init (BirdFontGlyfDataClass * klass,
                                gpointer klass_data)
{
	bird_font_glyf_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontGlyfData_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_glyf_data_get_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_glyf_data_finalize;
}

static void
bird_font_glyf_data_instance_init (BirdFontGlyfData * self,
                                   gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	self->priv = bird_font_glyf_data_get_instance_private (self);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->paths = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->points = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	self->end_points = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_UCHAR, NULL, NULL, NULL, NULL, NULL);
	self->flags = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	self->coordinate_x = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	self->coordinate_y = _tmp5_;
	self->priv->end_point = (guint16) 0;
	self->priv->nflags = (guint16) 0;
	self->bounding_box_xmin = (gint16) 0;
	self->bounding_box_ymin = (gint16) 0;
	self->bounding_box_xmax = (gint16) 0;
	self->bounding_box_ymax = (gint16) 0;
}

static void
bird_font_glyf_data_finalize (GObject * obj)
{
	BirdFontGlyfData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_GLYF_DATA, BirdFontGlyfData);
	_g_object_unref0 (self->paths);
	_g_object_unref0 (self->points);
	_g_object_unref0 (self->end_points);
	_g_object_unref0 (self->flags);
	_g_object_unref0 (self->coordinate_x);
	_g_object_unref0 (self->coordinate_y);
	_g_object_unref0 (self->priv->glyph);
	G_OBJECT_CLASS (bird_font_glyf_data_parent_class)->finalize (obj);
}

/** Data for one entry in the glyf table. */
static GType
bird_font_glyf_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontGlyfDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_glyf_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontGlyfData), 0, (GInstanceInitFunc) bird_font_glyf_data_instance_init, NULL };
	GType bird_font_glyf_data_type_id;
	bird_font_glyf_data_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontGlyfData", &g_define_type_info, 0);
	BirdFontGlyfData_private_offset = g_type_add_instance_private (bird_font_glyf_data_type_id, sizeof (BirdFontGlyfDataPrivate));
	return bird_font_glyf_data_type_id;
}

GType
bird_font_glyf_data_get_type (void)
{
	static volatile gsize bird_font_glyf_data_type_id__once = 0;
	if (g_once_init_enter (&bird_font_glyf_data_type_id__once)) {
		GType bird_font_glyf_data_type_id;
		bird_font_glyf_data_type_id = bird_font_glyf_data_get_type_once ();
		g_once_init_leave (&bird_font_glyf_data_type_id__once, bird_font_glyf_data_type_id);
	}
	return bird_font_glyf_data_type_id__once;
}

static void
_vala_bird_font_glyf_data_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BirdFontGlyfData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_GLYF_DATA, BirdFontGlyfData);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

