/* FontData.c generated by valac 0.56.16, the Vala compiler
 * generated from FontData.vala, do not modify */

/*
Copyright (C) 2012 2013 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_FONT_DATA_0_PROPERTY,
	BIRD_FONT_FONT_DATA_NUM_PROPERTIES
};
static GParamSpec* bird_font_font_data_properties[BIRD_FONT_FONT_DATA_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontFontDataPrivate {
	guint rp;
	guint wp;
	guint32 len;
	guint32 padding;
	guint32 capacity;
};

static gint BirdFontFontData_private_offset;
static gpointer bird_font_font_data_parent_class = NULL;

static void bird_font_font_data_expand (BirdFontFontData* self,
                                 guint extra_bytes);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static void bird_font_font_data_finalize (GObject * obj);
static GType bird_font_font_data_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_font_data_get_instance_private (BirdFontFontData* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontFontData_private_offset);
}

BirdFontFontData*
bird_font_font_data_construct (GType object_type,
                               guint32 size)
{
	BirdFontFontData * self = NULL;
	void* _tmp0_;
	self = (BirdFontFontData*) g_object_new (object_type, NULL);
	self->priv->capacity = size;
	_tmp0_ = g_malloc ((gsize) size);
	self->table_data = _tmp0_;
	return self;
}

BirdFontFontData*
bird_font_font_data_new (guint32 size)
{
	return bird_font_font_data_construct (BIRD_FONT_TYPE_FONT_DATA, size);
}

gint
bird_font_font_data_get_read_pos (BirdFontFontData* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->priv->rp;
	return result;
}

gint
bird_font_font_data_get_write_pos (BirdFontFontData* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->priv->wp;
	return result;
}

void
bird_font_font_data_write_at (BirdFontFontData* self,
                              guint pos,
                              guint8 new_data,
                              GError** error)
{
	guint8* _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (pos <= ((guint) self->priv->capacity), "pos <= capacity");
	if (G_UNLIKELY (pos >= ((guint) self->priv->len))) {
		g_warning ("FontData.vala:58: end of table reached");
		_vala_assert (FALSE, "false");
	}
	_tmp0_ = self->table_data;
	_tmp0_[pos] = new_data;
}

void
bird_font_font_data_write_table (BirdFontFontData* self,
                                 BirdFontOtfInputStream* dis,
                                 guint32 offset,
                                 guint32 length,
                                 GError** error)
{
	guint32 l = 0U;
	guint8 b = 0U;
	guint8* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dis != NULL);
	l = length + (length % 4);
	if (length >= l) {
		bird_font_font_data_expand (self, (guint) l);
	}
	_tmp0_ = self->table_data;
	if (_tmp0_ == NULL) {
		g_warning ("FontData.vala:74: Failed to allocate memory for ttf data.");
		return;
	}
	bird_font_font_data_seek (self, (guint) 0);
	bird_font_otf_input_stream_seek (dis, (gint64) offset, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->wp = (guint) 0;
	while (TRUE) {
		guint8 _tmp1_ = 0U;
		if (!(self->priv->wp < ((guint) l))) {
			break;
		}
		_tmp1_ = bird_font_otf_input_stream_read_byte (dis, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		b = _tmp1_;
		bird_font_font_data_add (self, b);
	}
	self->priv->rp = (guint) 0;
}

guint
bird_font_font_data_length_with_padding (BirdFontFontData* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) self->priv->len;
	return result;
}

guint
bird_font_font_data_length (BirdFontFontData* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) (self->priv->len - self->priv->padding);
	return result;
}

void
bird_font_font_data_pad (BirdFontFontData* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		guint32 _tmp0_;
		if (!((self->priv->len % 4) != ((guint32) 0))) {
			break;
		}
		bird_font_font_data_add (self, (guint8) 0);
		_tmp0_ = self->priv->padding;
		self->priv->padding = _tmp0_ + 1;
	}
}

/** Add additional checksum data to this checksum. */
void
bird_font_font_data_continous_checksum (BirdFontFontData* self,
                                        guint32* current_checksum)
{
	guint trp = 0U;
	guint l = 0U;
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	trp = self->priv->rp;
	if ((bird_font_font_data_length_with_padding (self) % 4) != ((guint) 0)) {
		g_warning ("FontData.vala:111: OtfTable is not padded to correct size.");
	}
	bird_font_font_data_seek (self, (guint) 0);
	if ((bird_font_font_data_length (self) % 4) > ((guint) 0)) {
		_tmp0_ = (bird_font_font_data_length (self) / 4) + 1;
	} else {
		_tmp0_ = bird_font_font_data_length (self) / 4;
	}
	l = _tmp0_;
	{
		guint32 i = 0U;
		i = (guint32) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					guint32 _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((guint32) l))) {
					break;
				}
				*current_checksum = (*current_checksum) + bird_font_font_data_read_uint32 (self);
			}
		}
	}
	self->priv->rp = trp;
	return;
}

guint32
bird_font_font_data_checksum (BirdFontFontData* self)
{
	guint32 sum = 0U;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	sum = (guint32) 0;
	bird_font_font_data_continous_checksum (self, &sum);
	result = sum;
	return result;
}

void
bird_font_font_data_seek_end (BirdFontFontData* self)
{
	g_return_if_fail (self != NULL);
	bird_font_font_data_seek (self, (guint) self->priv->len);
}

void
bird_font_font_data_seek (BirdFontFontData* self,
                          guint i)
{
	g_return_if_fail (self != NULL);
	self->priv->rp = i;
	self->priv->wp = i;
}

void
bird_font_font_data_seek_relative (BirdFontFontData* self,
                                   guint i)
{
	g_return_if_fail (self != NULL);
	self->priv->rp = self->priv->rp + i;
	self->priv->wp = self->priv->wp + i;
}

/** Returns true if next byte is a CFF operator */
gboolean
bird_font_font_data_next_is_operator (BirdFontFontData* self)
{
	guint8 o = 0U;
	gint _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	o = bird_font_font_data_read (self);
	bird_font_font_data_seek_relative (self, (guint) -1);
	_tmp0_ = (gint) o;
	result = (0 <= _tmp0_) && (_tmp0_ <= 21);
	return result;
}

guint8
bird_font_font_data_read (BirdFontFontData* self)
{
	guint8* _tmp0_;
	guint _tmp1_;
	guint8 _tmp2_;
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	if (G_UNLIKELY (self->priv->rp >= ((guint) self->priv->len))) {
		g_warning ("FontData.vala:156: end of table reached");
		result = (guint8) 0;
		return result;
	}
	_tmp0_ = self->table_data;
	_tmp1_ = self->priv->rp;
	self->priv->rp = _tmp1_ + 1;
	_tmp2_ = _tmp0_[_tmp1_];
	result = _tmp2_;
	return result;
}

BirdFontFixed
bird_font_font_data_read_fixed (BirdFontFontData* self)
{
	BirdFontFixed result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (BirdFontFixed) bird_font_font_data_read_uint32 (self);
	return result;
}

guint32
bird_font_font_data_read_ulong (BirdFontFontData* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = bird_font_font_data_read_uint32 (self);
	return result;
}

guint16
bird_font_font_data_read_ushort (BirdFontFontData* self)
{
	guint16 f = 0U;
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	f = (guint16) (bird_font_font_data_read (self) << 8);
	f += (guint16) bird_font_font_data_read (self);
	result = f;
	return result;
}

gint16
bird_font_font_data_read_int16 (BirdFontFontData* self)
{
	gint16 f = 0;
	gint16 result;
	g_return_val_if_fail (self != NULL, 0);
	f = (gint16) (bird_font_font_data_read (self) << 8);
	f += (gint16) bird_font_font_data_read (self);
	result = f;
	return result;
}

gint16
bird_font_font_data_read_short (BirdFontFontData* self,
                                GError** error)
{
	gint16 result;
	g_return_val_if_fail (self != NULL, 0);
	result = bird_font_font_data_read_int16 (self);
	return result;
}

guint32
bird_font_font_data_read_uint32 (BirdFontFontData* self)
{
	guint32 f = 0U;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	f = (guint32) (bird_font_font_data_read (self) << (8 * 3));
	f += (guint32) (bird_font_font_data_read (self) << (8 * 2));
	f += (guint32) (bird_font_font_data_read (self) << (8 * 1));
	f += (guint32) (bird_font_font_data_read (self) << (8 * 0));
	result = f;
	return result;
}

gint32
bird_font_font_data_read_int32 (BirdFontFontData* self)
{
	gint32 f = 0;
	gint32 result;
	g_return_val_if_fail (self != NULL, 0);
	f = (gint32) (bird_font_font_data_read (self) << (8 * 3));
	f += (gint32) (bird_font_font_data_read (self) << (8 * 2));
	f += (gint32) (bird_font_font_data_read (self) << (8 * 1));
	f += (gint32) (bird_font_font_data_read (self) << (8 * 0));
	result = f;
	return result;
}

guint64
bird_font_font_data_read_uint64 (BirdFontFontData* self)
{
	guint64 f = 0ULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	f = ((guint64) bird_font_font_data_read (self)) << (8 * 7);
	f += ((guint64) bird_font_font_data_read (self)) << (8 * 6);
	f += ((guint64) bird_font_font_data_read (self)) << (8 * 5);
	f += ((guint64) bird_font_font_data_read (self)) << (8 * 4);
	f += ((guint64) bird_font_font_data_read (self)) << (8 * 3);
	f += ((guint64) bird_font_font_data_read (self)) << (8 * 2);
	f += ((guint64) bird_font_font_data_read (self)) << (8 * 1);
	f += ((guint64) bird_font_font_data_read (self)) << (8 * 0);
	result = f;
	return result;
}

BirdFontF2Dot14
bird_font_font_data_read_f2dot14 (BirdFontFontData* self,
                                  GError** error)
{
	BirdFontF2Dot14 f = 0U;
	BirdFontF2Dot14 result;
	g_return_val_if_fail (self != NULL, 0U);
	f = (BirdFontF2Dot14) bird_font_font_data_read_int16 (self);
	result = f;
	return result;
}

guint64
bird_font_font_data_read_udate (BirdFontFontData* self,
                                GError** error)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = bird_font_font_data_read_uint64 (self);
	return result;
}

guint8
bird_font_font_data_read_byte (BirdFontFontData* self,
                               GError** error)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = bird_font_font_data_read (self);
	return result;
}

gchar
bird_font_font_data_read_char (BirdFontFontData* self,
                               GError** error)
{
	guint8 _tmp0_ = 0U;
	GError* _inner_error0_ = NULL;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = bird_font_font_data_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gchar _tmp1_ = '\0';
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = (gchar) _tmp0_;
	return result;
}

gchar*
bird_font_font_data_read_string (BirdFontFontData* self,
                                 guint length,
                                 GError** error)
{
	GString* str = NULL;
	GString* _tmp0_;
	gchar c = '\0';
	GString* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar _tmp3_ = '\0';
				GString* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < length)) {
					break;
				}
				_tmp3_ = bird_font_font_data_read_char (self, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (str);
					return NULL;
				}
				c = _tmp3_;
				_tmp4_ = str;
				g_string_append_c (_tmp4_, c);
			}
		}
	}
	_tmp5_ = str;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	_g_string_free0 (str);
	return result;
}

gint
bird_font_font_data_read_charstring_value (BirdFontFontData* self,
                                           GError** error)
{
	guint8 a = 0U;
	guint8 b = 0U;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	FILE* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	a = bird_font_font_data_read (self);
	_tmp0_ = (gint) a;
	if ((32 <= _tmp0_) && (_tmp0_ <= 246)) {
		result = a - 139;
		return result;
	}
	b = bird_font_font_data_read (self);
	_tmp1_ = (gint) a;
	if ((247 <= _tmp1_) && (_tmp1_ <= 250)) {
		result = (((a - 247) * 256) + b) + 108;
		return result;
	}
	_tmp2_ = (gint) a;
	if ((251 <= _tmp2_) && (_tmp2_ <= 254)) {
		result = ((-((a - 251) * 256)) - b) - 108;
		return result;
	}
	if (((gint) a) == 255) {
		g_warning ("FontData.vala:267: fractions not implemented yet.");
	}
	_tmp3_ = stderr;
	_tmp4_ = g_strdup_printf ("%hhu", a);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("unexpected value: ", _tmp5_, "\n", NULL);
	_tmp7_ = _tmp6_;
	fprintf (_tmp3_, "%s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	g_warn_if_reached ();
	result = 0;
	return result;
}

void
bird_font_font_data_add_fixed (BirdFontFontData* self,
                               BirdFontFixed f,
                               GError** error)
{
	g_return_if_fail (self != NULL);
	bird_font_font_data_add_u32 (self, (guint32) f);
}

void
bird_font_font_data_add_short (BirdFontFontData* self,
                               gint16 d,
                               GError** error)
{
	g_return_if_fail (self != NULL);
	bird_font_font_data_add_16 (self, d);
}

void
bird_font_font_data_add_ushort (BirdFontFontData* self,
                                guint16 d,
                                GError** error)
{
	g_return_if_fail (self != NULL);
	bird_font_font_data_add_u16 (self, d);
}

void
bird_font_font_data_add_ulong (BirdFontFontData* self,
                               guint32 d,
                               GError** error)
{
	g_return_if_fail (self != NULL);
	bird_font_font_data_add_u32 (self, d);
}

void
bird_font_font_data_add_long (BirdFontFontData* self,
                              gint32 d,
                              GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	bird_font_font_data_add_32 (self, d, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
bird_font_font_data_add_32 (BirdFontFontData* self,
                            gint32 i,
                            GError** error)
{
	guint32 s = 0U;
	g_return_if_fail (self != NULL);
	s = (guint32) ((guint16) (i >> 16));
	bird_font_font_data_add_u16 (self, (guint16) s);
	bird_font_font_data_add_u16 (self, (guint16) (i - (s << 16)));
}

void
bird_font_font_data_add_byte (BirdFontFontData* self,
                              guint8 b,
                              GError** error)
{
	g_return_if_fail (self != NULL);
	bird_font_font_data_add (self, b);
}

static void
bird_font_font_data_expand (BirdFontFontData* self,
                            guint extra_bytes)
{
	guint8* _tmp0_;
	void* _tmp1_;
	guint8* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->capacity = self->priv->capacity + extra_bytes;
	_tmp0_ = self->table_data;
	_tmp1_ = g_try_realloc (_tmp0_, (gsize) self->priv->capacity);
	self->table_data = (guint8*) _tmp1_;
	_tmp2_ = self->table_data;
	if (_tmp2_ == NULL) {
		g_warning ("FontData.vala:311: Out of memory.");
		self->priv->capacity = (guint32) 0;
	}
}

void
bird_font_font_data_add (BirdFontFontData* self,
                         guint8 d)
{
	guint8* _tmp0_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	if (G_UNLIKELY (self->priv->len == self->priv->capacity)) {
		bird_font_font_data_expand (self, (guint) 1024);
	}
	_tmp0_ = self->table_data;
	_tmp0_[self->priv->wp] = d;
	if (self->priv->wp == ((guint) self->priv->len)) {
		guint32 _tmp1_;
		_tmp1_ = self->priv->len;
		self->priv->len = _tmp1_ + 1;
	}
	_tmp2_ = self->priv->wp;
	self->priv->wp = _tmp2_ + 1;
}

void
bird_font_font_data_add_littleendian_u16 (BirdFontFontData* self,
                                          guint32 i)
{
	g_return_if_fail (self != NULL);
	bird_font_font_data_add (self, (guint8) ((gint8) (i & 0x00FF)));
	bird_font_font_data_add (self, (guint8) ((gint8) ((i & 0xFF00) >> 8)));
}

void
bird_font_font_data_add_u16 (BirdFontFontData* self,
                             guint16 d)
{
	guint16 n = 0U;
	g_return_if_fail (self != NULL);
	n = (guint16) (d >> 8);
	bird_font_font_data_add (self, (guint8) n);
	bird_font_font_data_add (self, (guint8) (d - (n << 8)));
}

void
bird_font_font_data_add_16 (BirdFontFontData* self,
                            gint16 i)
{
	guint8 s = 0U;
	g_return_if_fail (self != NULL);
	s = (guint8) (i >> 8);
	bird_font_font_data_add (self, (guint8) s);
	bird_font_font_data_add (self, (guint8) (i - (s << 8)));
}

void
bird_font_font_data_add_littleendian_u32 (BirdFontFontData* self,
                                          guint32 i)
{
	g_return_if_fail (self != NULL);
	bird_font_font_data_add (self, (guint8) ((gint8) (i & 0x000000FF)));
	bird_font_font_data_add (self, (guint8) ((gint8) ((i & 0x0000FF00) >> 8)));
	bird_font_font_data_add (self, (guint8) ((gint8) ((i & 0x00FF0000) >> 16)));
	bird_font_font_data_add (self, (guint8) ((gint8) ((i & 0xFF000000LL) >> 24)));
}

void
bird_font_font_data_add_u32 (BirdFontFontData* self,
                             guint32 i)
{
	guint32 s = 0U;
	g_return_if_fail (self != NULL);
	s = (guint32) ((guint16) (i >> 16));
	bird_font_font_data_add_u16 (self, (guint16) s);
	bird_font_font_data_add_u16 (self, (guint16) (i - (s << 16)));
}

void
bird_font_font_data_add_u64 (BirdFontFontData* self,
                             guint64 i)
{
	guint64 s = 0ULL;
	g_return_if_fail (self != NULL);
	s = (guint64) ((guint32) (i >> 32));
	bird_font_font_data_add_u32 (self, (guint32) s);
	bird_font_font_data_add_u32 (self, (guint32) (i - (s << 32)));
}

void
bird_font_font_data_add_str_littleendian_utf16 (BirdFontFontData* self,
                                                const gchar* s)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	bird_font_font_data_add_str_utf16 (self, s, TRUE);
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

void
bird_font_font_data_add_str_utf16 (BirdFontFontData* self,
                                   const gchar* s,
                                   gboolean little_endian)
{
	gint index = 0;
	gunichar c = 0U;
	guint8 c0 = 0U;
	guint8 c1 = 0U;
	gint l = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	index = 0;
	l = 0;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		_tmp1_ = string_get_next_char (s, &index, &_tmp0_);
		c = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		if (c <= ((gunichar) 0x7FFF)) {
			c0 = (guint8) (c >> 8);
			c1 = (guint8) (c - (c0 << 8));
			if (little_endian) {
				bird_font_font_data_add (self, c1);
				bird_font_font_data_add (self, c0);
			} else {
				bird_font_font_data_add (self, c0);
				bird_font_font_data_add (self, c1);
			}
		} else {
			if (c <= ((gunichar) 0xFFFFF)) {
				gint high = 0;
				gint low = 0;
				high = (0xFFC00 & c) >> 10;
				low = 0x03FF & c;
				high += 0xD800;
				low += 0xDC00;
				c0 = (guint8) (high >> 8);
				c1 = (guint8) (high - (c0 << 8));
				if (little_endian) {
					bird_font_font_data_add (self, c1);
					bird_font_font_data_add (self, c0);
				} else {
					bird_font_font_data_add (self, c0);
					bird_font_font_data_add (self, c1);
				}
				c0 = (guint8) (low >> 8);
				c1 = (guint8) (low - (c0 << 8));
				if (little_endian) {
					bird_font_font_data_add (self, c1);
					bird_font_font_data_add (self, c0);
				} else {
					bird_font_font_data_add (self, c0);
					bird_font_font_data_add (self, c1);
				}
			} else {
				continue;
			}
		}
		l += 2;
	}
}

guint
bird_font_font_data_utf16_strlen (const gchar* s)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	guint result;
	g_return_val_if_fail (s != NULL, 0U);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	bird_font_font_data_add_str_utf16 (fd, s, FALSE);
	result = bird_font_font_data_length_with_padding (fd);
	_g_object_unref0 (fd);
	return result;
}

void
bird_font_font_data_add_macroman_str (BirdFontFontData* self,
                                      const gchar* s)
{
	gint index = 0;
	gunichar c = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	index = 0;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gunichar _tmp2_;
		_tmp1_ = string_get_next_char (s, &index, &_tmp0_);
		c = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = c;
		if ((((gunichar) 32) <= _tmp2_) && (_tmp2_ <= ((gunichar) 127))) {
			bird_font_font_data_add (self, (guint8) c);
		} else {
			if (c == ((gunichar) 196)) {
				bird_font_font_data_add (self, (guint8) 128);
			}
			if (c == ((gunichar) 197)) {
				bird_font_font_data_add (self, (guint8) 129);
			}
			if (c == ((gunichar) 199)) {
				bird_font_font_data_add (self, (guint8) 130);
			}
			if (c == ((gunichar) 201)) {
				bird_font_font_data_add (self, (guint8) 131);
			}
			if (c == ((gunichar) 209)) {
				bird_font_font_data_add (self, (guint8) 132);
			}
			if (c == ((gunichar) 214)) {
				bird_font_font_data_add (self, (guint8) 133);
			}
			if (c == ((gunichar) 220)) {
				bird_font_font_data_add (self, (guint8) 134);
			}
			if (c == ((gunichar) 225)) {
				bird_font_font_data_add (self, (guint8) 135);
			}
			if (c == ((gunichar) 224)) {
				bird_font_font_data_add (self, (guint8) 136);
			}
			if (c == ((gunichar) 226)) {
				bird_font_font_data_add (self, (guint8) 137);
			}
			if (c == ((gunichar) 228)) {
				bird_font_font_data_add (self, (guint8) 138);
			}
			if (c == ((gunichar) 227)) {
				bird_font_font_data_add (self, (guint8) 139);
			}
			if (c == ((gunichar) 229)) {
				bird_font_font_data_add (self, (guint8) 140);
			}
			if (c == ((gunichar) 231)) {
				bird_font_font_data_add (self, (guint8) 141);
			}
			if (c == ((gunichar) 233)) {
				bird_font_font_data_add (self, (guint8) 142);
			}
			if (c == ((gunichar) 232)) {
				bird_font_font_data_add (self, (guint8) 143);
			}
			if (c == ((gunichar) 234)) {
				bird_font_font_data_add (self, (guint8) 144);
			}
			if (c == ((gunichar) 235)) {
				bird_font_font_data_add (self, (guint8) 145);
			}
			if (c == ((gunichar) 237)) {
				bird_font_font_data_add (self, (guint8) 146);
			}
			if (c == ((gunichar) 236)) {
				bird_font_font_data_add (self, (guint8) 147);
			}
			if (c == ((gunichar) 238)) {
				bird_font_font_data_add (self, (guint8) 148);
			}
			if (c == ((gunichar) 239)) {
				bird_font_font_data_add (self, (guint8) 149);
			}
			if (c == ((gunichar) 241)) {
				bird_font_font_data_add (self, (guint8) 150);
			}
			if (c == ((gunichar) 243)) {
				bird_font_font_data_add (self, (guint8) 151);
			}
			if (c == ((gunichar) 242)) {
				bird_font_font_data_add (self, (guint8) 152);
			}
			if (c == ((gunichar) 244)) {
				bird_font_font_data_add (self, (guint8) 153);
			}
			if (c == ((gunichar) 246)) {
				bird_font_font_data_add (self, (guint8) 154);
			}
			if (c == ((gunichar) 245)) {
				bird_font_font_data_add (self, (guint8) 155);
			}
			if (c == ((gunichar) 250)) {
				bird_font_font_data_add (self, (guint8) 156);
			}
			if (c == ((gunichar) 249)) {
				bird_font_font_data_add (self, (guint8) 157);
			}
			if (c == ((gunichar) 251)) {
				bird_font_font_data_add (self, (guint8) 158);
			}
			if (c == ((gunichar) 252)) {
				bird_font_font_data_add (self, (guint8) 159);
			}
			if (c == ((gunichar) 8224)) {
				bird_font_font_data_add (self, (guint8) 160);
			}
			if (c == ((gunichar) 176)) {
				bird_font_font_data_add (self, (guint8) 161);
			}
			if (c == ((gunichar) 162)) {
				bird_font_font_data_add (self, (guint8) 162);
			}
			if (c == ((gunichar) 163)) {
				bird_font_font_data_add (self, (guint8) 163);
			}
			if (c == ((gunichar) 167)) {
				bird_font_font_data_add (self, (guint8) 164);
			}
			if (c == ((gunichar) 8226)) {
				bird_font_font_data_add (self, (guint8) 165);
			}
			if (c == ((gunichar) 182)) {
				bird_font_font_data_add (self, (guint8) 166);
			}
			if (c == ((gunichar) 223)) {
				bird_font_font_data_add (self, (guint8) 167);
			}
			if (c == ((gunichar) 174)) {
				bird_font_font_data_add (self, (guint8) 168);
			}
			if (c == ((gunichar) 169)) {
				bird_font_font_data_add (self, (guint8) 169);
			}
			if (c == ((gunichar) 8482)) {
				bird_font_font_data_add (self, (guint8) 170);
			}
			if (c == ((gunichar) 180)) {
				bird_font_font_data_add (self, (guint8) 171);
			}
			if (c == ((gunichar) 168)) {
				bird_font_font_data_add (self, (guint8) 172);
			}
			if (c == ((gunichar) 8800)) {
				bird_font_font_data_add (self, (guint8) 173);
			}
			if (c == ((gunichar) 198)) {
				bird_font_font_data_add (self, (guint8) 174);
			}
			if (c == ((gunichar) 216)) {
				bird_font_font_data_add (self, (guint8) 175);
			}
			if (c == ((gunichar) 8734)) {
				bird_font_font_data_add (self, (guint8) 176);
			}
			if (c == ((gunichar) 177)) {
				bird_font_font_data_add (self, (guint8) 177);
			}
			if (c == ((gunichar) 8804)) {
				bird_font_font_data_add (self, (guint8) 178);
			}
			if (c == ((gunichar) 8805)) {
				bird_font_font_data_add (self, (guint8) 179);
			}
			if (c == ((gunichar) 165)) {
				bird_font_font_data_add (self, (guint8) 180);
			}
			if (c == ((gunichar) 181)) {
				bird_font_font_data_add (self, (guint8) 181);
			}
			if (c == ((gunichar) 8706)) {
				bird_font_font_data_add (self, (guint8) 182);
			}
			if (c == ((gunichar) 8721)) {
				bird_font_font_data_add (self, (guint8) 183);
			}
			if (c == ((gunichar) 8719)) {
				bird_font_font_data_add (self, (guint8) 184);
			}
			if (c == ((gunichar) 960)) {
				bird_font_font_data_add (self, (guint8) 185);
			}
			if (c == ((gunichar) 8747)) {
				bird_font_font_data_add (self, (guint8) 186);
			}
			if (c == ((gunichar) 170)) {
				bird_font_font_data_add (self, (guint8) 187);
			}
			if (c == ((gunichar) 186)) {
				bird_font_font_data_add (self, (guint8) 188);
			}
			if (c == ((gunichar) 937)) {
				bird_font_font_data_add (self, (guint8) 189);
			}
			if (c == ((gunichar) 230)) {
				bird_font_font_data_add (self, (guint8) 190);
			}
			if (c == ((gunichar) 248)) {
				bird_font_font_data_add (self, (guint8) 191);
			}
			if (c == ((gunichar) 191)) {
				bird_font_font_data_add (self, (guint8) 192);
			}
			if (c == ((gunichar) 161)) {
				bird_font_font_data_add (self, (guint8) 193);
			}
			if (c == ((gunichar) 172)) {
				bird_font_font_data_add (self, (guint8) 194);
			}
			if (c == ((gunichar) 8730)) {
				bird_font_font_data_add (self, (guint8) 195);
			}
			if (c == ((gunichar) 402)) {
				bird_font_font_data_add (self, (guint8) 196);
			}
			if (c == ((gunichar) 8776)) {
				bird_font_font_data_add (self, (guint8) 197);
			}
			if (c == ((gunichar) 8710)) {
				bird_font_font_data_add (self, (guint8) 198);
			}
			if (c == ((gunichar) 171)) {
				bird_font_font_data_add (self, (guint8) 199);
			}
			if (c == ((gunichar) 187)) {
				bird_font_font_data_add (self, (guint8) 200);
			}
			if (c == ((gunichar) 8230)) {
				bird_font_font_data_add (self, (guint8) 201);
			}
			if (c == ((gunichar) 160)) {
				bird_font_font_data_add (self, (guint8) 202);
			}
			if (c == ((gunichar) 192)) {
				bird_font_font_data_add (self, (guint8) 203);
			}
			if (c == ((gunichar) 195)) {
				bird_font_font_data_add (self, (guint8) 204);
			}
			if (c == ((gunichar) 213)) {
				bird_font_font_data_add (self, (guint8) 205);
			}
			if (c == ((gunichar) 338)) {
				bird_font_font_data_add (self, (guint8) 206);
			}
			if (c == ((gunichar) 339)) {
				bird_font_font_data_add (self, (guint8) 207);
			}
			if (c == ((gunichar) 8211)) {
				bird_font_font_data_add (self, (guint8) 208);
			}
			if (c == ((gunichar) 8212)) {
				bird_font_font_data_add (self, (guint8) 209);
			}
			if (c == ((gunichar) 8220)) {
				bird_font_font_data_add (self, (guint8) 210);
			}
			if (c == ((gunichar) 8221)) {
				bird_font_font_data_add (self, (guint8) 211);
			}
			if (c == ((gunichar) 8216)) {
				bird_font_font_data_add (self, (guint8) 212);
			}
			if (c == ((gunichar) 8217)) {
				bird_font_font_data_add (self, (guint8) 213);
			}
			if (c == ((gunichar) 247)) {
				bird_font_font_data_add (self, (guint8) 214);
			}
			if (c == ((gunichar) 9674)) {
				bird_font_font_data_add (self, (guint8) 215);
			}
			if (c == ((gunichar) 255)) {
				bird_font_font_data_add (self, (guint8) 216);
			}
			if (c == ((gunichar) 376)) {
				bird_font_font_data_add (self, (guint8) 217);
			}
			if (c == ((gunichar) 8260)) {
				bird_font_font_data_add (self, (guint8) 218);
			}
			if (c == ((gunichar) 8364)) {
				bird_font_font_data_add (self, (guint8) 219);
			}
			if (c == ((gunichar) 8249)) {
				bird_font_font_data_add (self, (guint8) 220);
			}
			if (c == ((gunichar) 8250)) {
				bird_font_font_data_add (self, (guint8) 221);
			}
			if (c == ((gunichar) 64257)) {
				bird_font_font_data_add (self, (guint8) 222);
			}
			if (c == ((gunichar) 64258)) {
				bird_font_font_data_add (self, (guint8) 223);
			}
			if (c == ((gunichar) 8225)) {
				bird_font_font_data_add (self, (guint8) 224);
			}
			if (c == ((gunichar) 183)) {
				bird_font_font_data_add (self, (guint8) 225);
			}
			if (c == ((gunichar) 8218)) {
				bird_font_font_data_add (self, (guint8) 226);
			}
			if (c == ((gunichar) 8222)) {
				bird_font_font_data_add (self, (guint8) 227);
			}
			if (c == ((gunichar) 8240)) {
				bird_font_font_data_add (self, (guint8) 228);
			}
			if (c == ((gunichar) 194)) {
				bird_font_font_data_add (self, (guint8) 229);
			}
			if (c == ((gunichar) 202)) {
				bird_font_font_data_add (self, (guint8) 230);
			}
			if (c == ((gunichar) 193)) {
				bird_font_font_data_add (self, (guint8) 231);
			}
			if (c == ((gunichar) 203)) {
				bird_font_font_data_add (self, (guint8) 232);
			}
			if (c == ((gunichar) 200)) {
				bird_font_font_data_add (self, (guint8) 233);
			}
			if (c == ((gunichar) 205)) {
				bird_font_font_data_add (self, (guint8) 234);
			}
			if (c == ((gunichar) 206)) {
				bird_font_font_data_add (self, (guint8) 235);
			}
			if (c == ((gunichar) 207)) {
				bird_font_font_data_add (self, (guint8) 236);
			}
			if (c == ((gunichar) 204)) {
				bird_font_font_data_add (self, (guint8) 237);
			}
			if (c == ((gunichar) 211)) {
				bird_font_font_data_add (self, (guint8) 238);
			}
			if (c == ((gunichar) 212)) {
				bird_font_font_data_add (self, (guint8) 239);
			}
			if (c == ((gunichar) 63743)) {
				bird_font_font_data_add (self, (guint8) 240);
			}
			if (c == ((gunichar) 210)) {
				bird_font_font_data_add (self, (guint8) 241);
			}
			if (c == ((gunichar) 218)) {
				bird_font_font_data_add (self, (guint8) 242);
			}
			if (c == ((gunichar) 219)) {
				bird_font_font_data_add (self, (guint8) 243);
			}
			if (c == ((gunichar) 217)) {
				bird_font_font_data_add (self, (guint8) 244);
			}
			if (c == ((gunichar) 305)) {
				bird_font_font_data_add (self, (guint8) 245);
			}
			if (c == ((gunichar) 710)) {
				bird_font_font_data_add (self, (guint8) 246);
			}
			if (c == ((gunichar) 732)) {
				bird_font_font_data_add (self, (guint8) 247);
			}
			if (c == ((gunichar) 175)) {
				bird_font_font_data_add (self, (guint8) 248);
			}
			if (c == ((gunichar) 728)) {
				bird_font_font_data_add (self, (guint8) 249);
			}
			if (c == ((gunichar) 729)) {
				bird_font_font_data_add (self, (guint8) 250);
			}
			if (c == ((gunichar) 730)) {
				bird_font_font_data_add (self, (guint8) 251);
			}
			if (c == ((gunichar) 184)) {
				bird_font_font_data_add (self, (guint8) 252);
			}
			if (c == ((gunichar) 733)) {
				bird_font_font_data_add (self, (guint8) 253);
			}
			if (c == ((gunichar) 731)) {
				bird_font_font_data_add (self, (guint8) 254);
			}
			if (c == ((gunichar) 711)) {
				bird_font_font_data_add (self, (guint8) 255);
			}
		}
	}
}

guint
bird_font_font_data_macroman_strlen (const gchar* s)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	guint result;
	g_return_val_if_fail (s != NULL, 0U);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	bird_font_font_data_add_macroman_str (fd, s);
	result = bird_font_font_data_length_with_padding (fd);
	_g_object_unref0 (fd);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
bird_font_font_data_add_str (BirdFontFontData* self,
                             const gchar* s)
{
	guint8* data = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint data_length1;
	gint _data_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = string_get_data (s, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup3 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	data = _tmp3_;
	data_length1 = _tmp3__length1;
	_data_size_ = data_length1;
	{
		gint n = 0;
		n = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				guint8* _tmp6_;
				gint _tmp6__length1;
				guint8* _tmp7_;
				gint _tmp7__length1;
				guint8 _tmp8_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = n;
					n = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = data;
				_tmp6__length1 = data_length1;
				if (!(n < _tmp6__length1)) {
					break;
				}
				_tmp7_ = data;
				_tmp7__length1 = data_length1;
				_tmp8_ = _tmp7_[n];
				bird_font_font_data_add (self, _tmp8_);
			}
		}
	}
	data = (g_free (data), NULL);
}

void
bird_font_font_data_add_tag (BirdFontFontData* self,
                             const gchar* s)
{
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = strlen (s);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_get_data (s, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	_vala_return_if_fail ((_tmp1_ == 4) && (_tmp4__length1 == 4), "s.length == 4 && s.data.length == 4");
	bird_font_font_data_add_str (self, s);
}

void
bird_font_font_data_add_charstring_value (BirdFontFontData* self,
                                          gint v,
                                          GError** error)
{
	gint w = 0;
	guint8 t = 0U;
	gint _tmp0_;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = v;
	if (G_UNLIKELY (!((-1131 <= _tmp0_) && (_tmp0_ <= 1131)))) {
		g_warning ("FontData.vala:597: charstring value out of range");
		v = 0;
	}
	_tmp1_ = v;
	if ((-107 <= _tmp1_) && (_tmp1_ <= 107)) {
		bird_font_font_data_add_byte (self, (guint8) (v + 139), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	} else {
		gint _tmp2_;
		_tmp2_ = v;
		if ((107 < _tmp2_) && (_tmp2_ <= 1131)) {
			w = v;
			v = v - 108;
			t = (guint8) 0;
			while (TRUE) {
				guint8 _tmp3_;
				if (!(v >= 256)) {
					break;
				}
				v = v - 256;
				_tmp3_ = t;
				t = _tmp3_ + 1;
			}
			bird_font_font_data_add_byte (self, (guint8) (t + 247), &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			bird_font_font_data_add_byte (self, (guint8) ((w - 108) - (t * 256)), &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
		} else {
			gint _tmp4_;
			_tmp4_ = v;
			if ((-1131 <= _tmp4_) && (_tmp4_ < -107)) {
				v = (-v) - 108;
				bird_font_font_data_add_byte (self, (guint8) ((v >> 8) + 251), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					return;
				}
				bird_font_font_data_add_byte (self, (guint8) (v & 0xFF), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					return;
				}
			} else {
			}
		}
	}
}

void
bird_font_font_data_append (BirdFontFontData* self,
                            BirdFontFontData* fd)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (fd != NULL);
	bird_font_font_data_seek (fd, (guint) 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < bird_font_font_data_length (fd))) {
					break;
				}
				bird_font_font_data_add (self, bird_font_font_data_read (fd));
			}
		}
	}
}

gint32
bird_font_font_data_to_fixed (gdouble d)
{
	gint32 val = 0;
	gint32 mant = 0;
	gint32 result;
	val = (gint32) floor (d);
	mant = (gint32) floor (0x10000 * (d - val));
	val = (val << 16) | mant;
	result = val;
	return result;
}

gdouble
bird_font_font_data_from_fixed (gint32 val)
{
	gdouble result;
	result = val / 65536.0;
	return result;
}

void
bird_font_font_data_dump (BirdFontFontData* self)
{
	FILE* _tmp5_;
	g_return_if_fail (self != NULL);
	{
		guint32 i = 0U;
		i = (guint32) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				FILE* _tmp2_;
				guint8* _tmp3_;
				guint8 _tmp4_;
				if (!_tmp0_) {
					guint32 _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < ((guint32) bird_font_font_data_length_with_padding (self)))) {
					break;
				}
				_tmp2_ = stdout;
				_tmp3_ = self->table_data;
				_tmp4_ = _tmp3_[i];
				fprintf (_tmp2_, "%x ", (guint) _tmp4_);
			}
		}
	}
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n");
}

static void
bird_font_font_data_class_init (BirdFontFontDataClass * klass,
                                gpointer klass_data)
{
	bird_font_font_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontFontData_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_font_data_finalize;
}

static void
bird_font_font_data_instance_init (BirdFontFontData * self,
                                   gpointer klass)
{
	self->priv = bird_font_font_data_get_instance_private (self);
	self->priv->rp = (guint) 0;
	self->priv->wp = (guint) 0;
	self->priv->len = (guint32) 0;
	self->priv->padding = (guint32) 0;
	self->table_data = NULL;
	self->offset = (guint) 0;
}

static void
bird_font_font_data_finalize (GObject * obj)
{
	BirdFontFontData * self;
	guint8* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_FONT_DATA, BirdFontFontData);
	_tmp0_ = self->table_data;
	if (_tmp0_ != NULL) {
		guint8* _tmp1_;
		_tmp1_ = self->table_data;
		_g_free0 (_tmp1_);
		self->table_data = NULL;
	}
	G_OBJECT_CLASS (bird_font_font_data_parent_class)->finalize (obj);
}

static GType
bird_font_font_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontFontDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_font_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontFontData), 0, (GInstanceInitFunc) bird_font_font_data_instance_init, NULL };
	GType bird_font_font_data_type_id;
	bird_font_font_data_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontFontData", &g_define_type_info, 0);
	BirdFontFontData_private_offset = g_type_add_instance_private (bird_font_font_data_type_id, sizeof (BirdFontFontDataPrivate));
	return bird_font_font_data_type_id;
}

GType
bird_font_font_data_get_type (void)
{
	static volatile gsize bird_font_font_data_type_id__once = 0;
	if (g_once_init_enter (&bird_font_font_data_type_id__once)) {
		GType bird_font_font_data_type_id;
		bird_font_font_data_type_id = bird_font_font_data_get_type_once ();
		g_once_init_leave (&bird_font_font_data_type_id__once, bird_font_font_data_type_id);
	}
	return bird_font_font_data_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

