/* Font.c generated by valac 0.56.16, the Vala compiler
 * generated from Font.vala, do not modify */

/*
Copyright (C) 2012 2013 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <loadfont.h>

#define BIRD_FONT_BIRD_FONT_FILE_MIN_FORMAT_MAJOR 0
#define BIRD_FONT_BIRD_FONT_FILE_MIN_FORMAT_MINOR 0
#define BIRD_FONT_BIRD_FONT_FILE_FORMAT_MAJOR 2
#define BIRD_FONT_BIRD_FONT_FILE_FORMAT_MINOR 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_FONT_0_PROPERTY,
	BIRD_FONT_FONT_NUM_PROPERTIES
};
static GParamSpec* bird_font_font_properties[BIRD_FONT_FONT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

#define BIRD_FONT_TYPE_BIRD_FONT_FILE (bird_font_bird_font_file_get_type ())
#define BIRD_FONT_BIRD_FONT_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFile))
#define BIRD_FONT_BIRD_FONT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFileClass))
#define BIRD_FONT_IS_BIRD_FONT_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_BIRD_FONT_FILE))
#define BIRD_FONT_IS_BIRD_FONT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_BIRD_FONT_FILE))
#define BIRD_FONT_BIRD_FONT_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_BIRD_FONT_FILE, BirdFontBirdFontFileClass))

typedef struct _BirdFontBirdFontFile BirdFontBirdFontFile;
typedef struct _BirdFontBirdFontFileClass BirdFontBirdFontFileClass;

#define BIRD_FONT_TYPE_SVG_FONT (bird_font_svg_font_get_type ())
#define BIRD_FONT_SVG_FONT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_SVG_FONT, BirdFontSvgFont))
#define BIRD_FONT_SVG_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_SVG_FONT, BirdFontSvgFontClass))
#define BIRD_FONT_IS_SVG_FONT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_SVG_FONT))
#define BIRD_FONT_IS_SVG_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_SVG_FONT))
#define BIRD_FONT_SVG_FONT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_SVG_FONT, BirdFontSvgFontClass))

typedef struct _BirdFontSvgFont BirdFontSvgFont;
typedef struct _BirdFontSvgFontClass BirdFontSvgFontClass;
enum  {
	BIRD_FONT_FONT_FONT_DELETED_SIGNAL,
	BIRD_FONT_FONT_NUM_SIGNALS
};
static guint bird_font_font_signals[BIRD_FONT_FONT_NUM_SIGNALS] = {0};

struct _BirdFontFontPrivate {
	gboolean modified;
	BirdFontOpenFontFormatReader* otf;
	gboolean otf_font;
	gboolean read_only;
	gboolean bfp;
	BirdFontBirdFontPart* bfp_file;
};

static gint BirdFontFont_private_offset;
static gpointer bird_font_font_parent_class = NULL;
gchar* bird_font_font_default_license = NULL;
gchar* bird_font_font_default_license_url = NULL;
BirdFontFont* bird_font_font_empty = NULL;

VALA_EXTERN GFile* bird_font_bird_font_get_settings_directory (void);
static void __lambda597_ (BirdFontFont* self,
                   BirdFontGlyphCollection* g);
static void ___lambda597__gfunc (gconstpointer data,
                          gpointer self);
static void __lambda598_ (BirdFontFont* self,
                   BirdFontGlyphCollection* g);
static void ___lambda598__gfunc (gconstpointer data,
                          gpointer self);
static gboolean bird_font_font_save_bfp (BirdFontFont* self);
static void bird_font_font_save_bf (BirdFontFont* self);
static void bird_font_font_save_backups (BirdFontFont* self,
                                  GError** error);
VALA_EXTERN GType bird_font_bird_font_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontBirdFontFile* bird_font_bird_font_file_new (BirdFontFont* f);
VALA_EXTERN BirdFontBirdFontFile* bird_font_bird_font_file_construct (GType object_type,
                                                          BirdFontFont* f);
VALA_EXTERN gboolean bird_font_bird_font_file_write_font_file (BirdFontBirdFontFile* self,
                                                   const gchar* path,
                                                   gboolean backup);
static gboolean bird_font_font_parse_svg_file (BirdFontFont* self,
                                        const gchar* path);
static gboolean bird_font_font_parse_bf_file (BirdFontFont* self,
                                       const gchar* path);
static gboolean bird_font_font_parse_bfp_file (BirdFontFont* self,
                                        const gchar* path);
static gboolean bird_font_font_parse_freetype_file (BirdFontFont* self,
                                             const gchar* path);
VALA_EXTERN gboolean bird_font_bird_font_file_load (BirdFontBirdFontFile* self,
                                        const gchar* path);
VALA_EXTERN gboolean bird_font_bird_font_file_load_data (BirdFontBirdFontFile* self,
                                             const gchar* xml_data);
VALA_EXTERN GType bird_font_svg_font_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontSvgFont* bird_font_svg_font_new (BirdFontFont* f);
VALA_EXTERN BirdFontSvgFont* bird_font_svg_font_construct (GType object_type,
                                               BirdFontFont* f);
VALA_EXTERN void bird_font_svg_font_load (BirdFontSvgFont* self,
                              const gchar* path);
static guint8 bird_font_font_hex_to_oct (gunichar o,
                                  GError** error);
static gchar* bird_font_font_oct_to_hex (guint8 o);
static void bird_font_font_finalize (GObject * obj);
static GType bird_font_font_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GType
bird_font_font_format_get_type_once (void)
{
	static const GEnumValue values[] = {{BIRD_FONT_FONT_FORMAT_BIRDFONT, "BIRD_FONT_FONT_FORMAT_BIRDFONT", "birdfont"}, {BIRD_FONT_FONT_FORMAT_BIRDFONT_PART, "BIRD_FONT_FONT_FORMAT_BIRDFONT_PART", "birdfont-part"}, {BIRD_FONT_FONT_FORMAT_FFI, "BIRD_FONT_FONT_FORMAT_FFI", "ffi"}, {BIRD_FONT_FONT_FORMAT_SVG, "BIRD_FONT_FONT_FORMAT_SVG", "svg"}, {BIRD_FONT_FONT_FORMAT_FREETYPE, "BIRD_FONT_FONT_FORMAT_FREETYPE", "freetype"}, {0, NULL, NULL}};
	GType bird_font_font_format_type_id;
	bird_font_font_format_type_id = g_enum_register_static ("BirdFontFontFormat", values);
	return bird_font_font_format_type_id;
}

GType
bird_font_font_format_get_type (void)
{
	static volatile gsize bird_font_font_format_type_id__once = 0;
	if (g_once_init_enter (&bird_font_font_format_type_id__once)) {
		GType bird_font_font_format_type_id;
		bird_font_font_format_type_id = bird_font_font_format_get_type_once ();
		g_once_init_leave (&bird_font_font_format_type_id__once, bird_font_font_format_type_id);
	}
	return bird_font_font_format_type_id__once;
}

static inline gpointer
bird_font_font_get_instance_private (BirdFontFont* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontFont_private_offset);
}

BirdFontFont*
bird_font_font_construct (GType object_type)
{
	BirdFontFont * self = NULL;
	BirdFontKerningClasses* kerning_classes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp20_;
	BirdFontGlyphTable* _tmp23_;
	BirdFontGlyphTable* _tmp24_;
	BirdFontGlyphTable* _tmp25_;
	GeeArrayList* _tmp26_;
	BirdFontKerningClasses* _tmp27_;
	BirdFontSpacingData* _tmp28_;
	BirdFontBirdFontPart* _tmp29_;
	GeeArrayList* _tmp30_;
	BirdFontLigatures* _tmp31_;
	GeeArrayList* _tmp32_;
	BirdFontFontSettings* _tmp33_;
	BirdFontKerningStrings* _tmp34_;
	BirdFontAlternateSets* _tmp35_;
	self = (BirdFontFont*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("Typeface");
	_g_free0 (self->postscript_name);
	self->postscript_name = _tmp0_;
	_tmp1_ = g_strdup ("Typeface");
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = g_strdup ("Regular");
	_g_free0 (self->subfamily);
	self->subfamily = _tmp2_;
	_tmp3_ = g_strdup ("Typeface");
	_g_free0 (self->full_name);
	self->full_name = _tmp3_;
	_tmp4_ = g_strdup ("Typeface");
	_g_free0 (self->unique_identifier);
	self->unique_identifier = _tmp4_;
	_tmp5_ = g_strdup ("Version 1.0");
	_g_free0 (self->version);
	self->version = _tmp5_;
	_tmp6_ = g_strdup ("");
	_g_free0 (self->description);
	self->description = _tmp6_;
	_tmp7_ = g_strdup ("");
	_g_free0 (self->copyright);
	self->copyright = _tmp7_;
	_tmp8_ = g_strdup ("");
	_g_free0 (self->license);
	self->license = _tmp8_;
	_tmp9_ = g_strdup ("");
	_g_free0 (self->license_url);
	self->license_url = _tmp9_;
	_tmp10_ = g_strdup ("");
	_g_free0 (self->trademark);
	self->trademark = _tmp10_;
	_tmp11_ = g_strdup ("");
	_g_free0 (self->manufacturer);
	self->manufacturer = _tmp11_;
	_tmp12_ = g_strdup ("");
	_g_free0 (self->designer);
	self->designer = _tmp12_;
	_tmp13_ = g_strdup ("");
	_g_free0 (self->vendor_url);
	self->vendor_url = _tmp13_;
	_tmp14_ = g_strdup ("");
	_g_free0 (self->designer_url);
	self->designer_url = _tmp14_;
	_tmp15_ = bird_font_font_default_license;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = bird_font_font_default_license;
		_tmp17_ = g_strdup ((const gchar*) _tmp16_);
		_g_free0 (self->copyright);
		self->copyright = _tmp17_;
		_tmp18_ = bird_font_font_default_license;
		_tmp19_ = g_strdup ((const gchar*) _tmp18_);
		_g_free0 (self->license);
		self->license = _tmp19_;
	}
	_tmp20_ = bird_font_font_default_license_url;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp21_ = bird_font_font_default_license_url;
		_tmp22_ = g_strdup ((const gchar*) _tmp21_);
		_g_free0 (self->license_url);
		self->license_url = _tmp22_;
	}
	_tmp23_ = bird_font_glyph_table_new ();
	_g_object_unref0 (self->glyph_cache);
	self->glyph_cache = _tmp23_;
	_tmp24_ = bird_font_glyph_table_new ();
	_g_object_unref0 (self->glyph_name);
	self->glyph_name = _tmp24_;
	_tmp25_ = bird_font_glyph_table_new ();
	_g_object_unref0 (self->ligature);
	self->ligature = _tmp25_;
	_tmp26_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->grid_width);
	self->grid_width = _tmp26_;
	_tmp27_ = bird_font_kerning_classes_new (self);
	_g_object_unref0 (kerning_classes);
	kerning_classes = _tmp27_;
	_tmp28_ = bird_font_spacing_data_new (kerning_classes);
	_g_object_unref0 (self->spacing);
	self->spacing = _tmp28_;
	self->top_limit = (gdouble) 84;
	self->top_position = (gdouble) 72;
	self->xheight_position = (gdouble) 56;
	self->base_line = (gdouble) 0;
	self->bottom_position = (gdouble) -20;
	self->bottom_limit = (gdouble) -27;
	_tmp29_ = bird_font_bird_font_part_new (self);
	_g_object_unref0 (self->priv->bfp_file);
	self->priv->bfp_file = _tmp29_;
	_tmp30_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->deleted_glyphs);
	self->deleted_glyphs = _tmp30_;
	_tmp31_ = bird_font_ligatures_new (self);
	_g_object_unref0 (self->ligature_substitution);
	self->ligature_substitution = _tmp31_;
	_tmp32_ = gee_array_list_new (BIRD_FONT_TYPE_BACKGROUND_IMAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->background_images);
	self->background_images = _tmp32_;
	_tmp33_ = bird_font_font_settings_new ();
	_g_object_unref0 (self->settings);
	self->settings = _tmp33_;
	_tmp34_ = bird_font_kerning_strings_new ();
	_g_object_unref0 (self->kerning_strings);
	self->kerning_strings = _tmp34_;
	_tmp35_ = bird_font_alternate_sets_new ();
	_g_object_unref0 (self->alternates);
	self->alternates = _tmp35_;
	_g_object_unref0 (kerning_classes);
	return self;
}

BirdFontFont*
bird_font_font_new (void)
{
	return bird_font_font_construct (BIRD_FONT_TYPE_FONT);
}

gchar*
bird_font_font_get_export_directory (BirdFontFont* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_get_folder_path (self);
	result = _tmp0_;
	return result;
}

void
bird_font_font_add_default_characters (BirdFontFont* self)
{
	BirdFontGlyphCollection* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyphCollection* _tmp2_;
	BirdFontGlyphCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_get_notdef_character (self);
	_tmp1_ = _tmp0_;
	bird_font_font_add_glyph_collection (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = bird_font_font_get_space (self);
	_tmp3_ = _tmp2_;
	bird_font_font_add_glyph_collection (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

BirdFontAlternate*
bird_font_font_get_alternate (BirdFontFont* self,
                              const gchar* glyph_name,
                              const gchar* tag)
{
	GeeArrayList* alt = NULL;
	BirdFontAlternateSets* _tmp0_;
	GeeArrayList* _tmp1_;
	BirdFontAlternate* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (glyph_name != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = self->alternates;
	_tmp1_ = bird_font_alternate_sets_get_alt (_tmp0_, tag);
	alt = _tmp1_;
	{
		GeeArrayList* _a_list = NULL;
		GeeArrayList* _tmp2_;
		gint _a_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _a_index = 0;
		_tmp2_ = alt;
		_a_list = _tmp2_;
		_tmp3_ = _a_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_a_size = _tmp5_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontAlternate* a = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontAlternate* _tmp10_;
			const gchar* _tmp11_;
			_a_index = _a_index + 1;
			_tmp6_ = _a_index;
			_tmp7_ = _a_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _a_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _a_index);
			a = (BirdFontAlternate*) _tmp9_;
			_tmp10_ = a;
			_tmp11_ = _tmp10_->glyph_name;
			if (g_strcmp0 (_tmp11_, glyph_name) == 0) {
				result = a;
				_g_object_unref0 (alt);
				return result;
			}
			_g_object_unref0 (a);
		}
	}
	result = NULL;
	_g_object_unref0 (alt);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_font_add_new_alternate (BirdFontFont* self,
                                  BirdFontGlyphCollection* glyph,
                                  BirdFontGlyphCollection* alternate,
                                  const gchar* tag)
{
	BirdFontAlternate* a = NULL;
	BirdFontAlternate* alt = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontAlternate* _tmp2_;
	BirdFontAlternate* _tmp3_;
	BirdFontAlternate* _tmp4_;
	BirdFontAlternate* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	BirdFontGlyphTable* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	BirdFontGlyphTable* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyph != NULL);
	g_return_if_fail (alternate != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = bird_font_glyph_collection_get_name (glyph);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_font_get_alternate (self, _tmp1_, tag);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	alt = _tmp3_;
	_tmp4_ = alt;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		BirdFontAlternate* _tmp7_;
		BirdFontAlternateSets* _tmp8_;
		BirdFontAlternate* _tmp9_;
		_tmp5_ = bird_font_glyph_collection_get_name (glyph);
		_tmp6_ = _tmp5_;
		_tmp7_ = bird_font_alternate_new (_tmp6_, tag);
		_g_object_unref0 (a);
		a = _tmp7_;
		_g_free0 (_tmp6_);
		_tmp8_ = self->alternates;
		_tmp9_ = a;
		bird_font_alternate_sets_add (_tmp8_, _tmp9_);
	} else {
		BirdFontAlternate* _tmp10_;
		BirdFontAlternate* _tmp11_;
		_tmp10_ = alt;
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, BIRD_FONT_TYPE_ALTERNATE, BirdFontAlternate));
		_g_object_unref0 (a);
		a = _tmp11_;
	}
	_tmp12_ = a;
	_tmp13_ = bird_font_glyph_collection_get_name (alternate);
	_tmp14_ = _tmp13_;
	bird_font_alternate_add (_tmp12_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = self->glyph_name;
	_tmp16_ = bird_font_glyph_collection_get_name (alternate);
	_tmp17_ = _tmp16_;
	bird_font_glyph_table_insert (_tmp15_, _tmp17_, alternate);
	_g_free0 (_tmp17_);
	_tmp18_ = self->glyph_cache;
	_tmp19_ = bird_font_glyph_collection_get_name (alternate);
	_tmp20_ = _tmp19_;
	bird_font_glyph_table_insert (_tmp18_, _tmp20_, alternate);
	_g_free0 (_tmp20_);
	_g_object_unref0 (alt);
	_g_object_unref0 (a);
}

void
bird_font_font_add_alternate (BirdFontFont* self,
                              const gchar* glyph_name,
                              const gchar* alternate,
                              const gchar* tag)
{
	BirdFontAlternate* a = NULL;
	BirdFontAlternate* alt = NULL;
	BirdFontAlternate* _tmp0_;
	BirdFontAlternate* _tmp1_;
	BirdFontAlternate* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyph_name != NULL);
	g_return_if_fail (alternate != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = bird_font_font_get_alternate (self, glyph_name, tag);
	alt = _tmp0_;
	_tmp1_ = alt;
	if (_tmp1_ == NULL) {
		BirdFontAlternate* _tmp2_;
		BirdFontAlternateSets* _tmp3_;
		BirdFontAlternate* _tmp4_;
		_tmp2_ = bird_font_alternate_new (glyph_name, tag);
		_g_object_unref0 (a);
		a = _tmp2_;
		_tmp3_ = self->alternates;
		_tmp4_ = a;
		bird_font_alternate_sets_add (_tmp3_, _tmp4_);
	} else {
		BirdFontAlternate* _tmp5_;
		BirdFontAlternate* _tmp6_;
		_tmp5_ = alt;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, BIRD_FONT_TYPE_ALTERNATE, BirdFontAlternate));
		_g_object_unref0 (a);
		a = _tmp6_;
	}
	_tmp7_ = a;
	bird_font_alternate_add (_tmp7_, alternate);
	_g_object_unref0 (alt);
	_g_object_unref0 (a);
}

gboolean
bird_font_font_has_compatible_format (BirdFontFont* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!bird_font_font_newer_format (self)) {
		_tmp0_ = !bird_font_font_older_format (self);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
bird_font_font_older_format (BirdFontFont* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->format_major < BIRD_FONT_BIRD_FONT_FILE_MIN_FORMAT_MAJOR) {
		result = TRUE;
		return result;
	}
	if (self->format_major == BIRD_FONT_BIRD_FONT_FILE_MIN_FORMAT_MAJOR) {
		_tmp0_ = self->format_minor < BIRD_FONT_BIRD_FONT_FILE_MIN_FORMAT_MINOR;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
bird_font_font_newer_format (BirdFontFont* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("%i", self->format_major);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%i", self->format_minor);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("Loaded file format: ", _tmp1_, ".", _tmp3_, "\n", NULL);
	_tmp5_ = _tmp4_;
	g_print ("%s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = g_strdup_printf ("%i", BIRD_FONT_BIRD_FONT_FILE_FORMAT_MAJOR);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%i", BIRD_FONT_BIRD_FONT_FILE_FORMAT_MINOR);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("Parser version    : ", _tmp7_, ".", _tmp9_, "\n", NULL);
	_tmp11_ = _tmp10_;
	g_print ("%s", _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	if (self->format_major > BIRD_FONT_BIRD_FONT_FILE_FORMAT_MAJOR) {
		result = TRUE;
		return result;
	}
	if (BIRD_FONT_BIRD_FONT_FILE_FORMAT_MAJOR == self->format_major) {
		_tmp12_ = self->format_minor > BIRD_FONT_BIRD_FONT_FILE_FORMAT_MINOR;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

void
bird_font_font_set_default_license (const gchar* license,
                                    const gchar* url)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (license != NULL);
	g_return_if_fail (url != NULL);
	_tmp0_ = g_strdup (license);
	_g_free0 (bird_font_font_default_license);
	bird_font_font_default_license = _tmp0_;
	_tmp1_ = g_strdup (url);
	_g_free0 (bird_font_font_default_license_url);
	bird_font_font_default_license_url = _tmp1_;
}

BirdFontLigatures*
bird_font_font_get_ligatures (BirdFontFont* self)
{
	BirdFontLigatures* _tmp0_;
	BirdFontLigatures* _tmp1_;
	BirdFontLigatures* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->ligature_substitution;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
bird_font_font_set_weight (BirdFontFont* self,
                           const gchar* w)
{
	gint wi = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	wi = atoi (w);
	if (wi > 0) {
		self->weight = wi;
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

void
bird_font_font_set_italic_angle (BirdFontFont* self,
                                 const gchar* a)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	self->italic_angle = double_parse (a);
}

gchar*
bird_font_font_get_weight (BirdFontFont* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", self->weight);
	result = _tmp0_;
	return result;
}

void
bird_font_font_touch (BirdFontFont* self)
{
	g_return_if_fail (self != NULL);
	self->priv->modified = TRUE;
}

BirdFontKerningClasses*
bird_font_font_get_kerning_classes (BirdFontFont* self)
{
	BirdFontSpacingData* _tmp0_;
	BirdFontKerningClasses* _tmp1_;
	BirdFontKerningClasses* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->spacing;
	_tmp1_ = bird_font_spacing_data_get_kerning_classes (_tmp0_);
	result = _tmp1_;
	return result;
}

BirdFontSpacingData*
bird_font_font_get_spacing (BirdFontFont* self)
{
	BirdFontSpacingData* _tmp0_;
	BirdFontSpacingData* _tmp1_;
	BirdFontSpacingData* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->spacing;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

GFile*
bird_font_font_get_backgrounds_folder (BirdFontFont* self)
{
	gchar* fn = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* f = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat (_tmp2_, " backgrounds", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	fn = _tmp4_;
	_tmp5_ = bird_font_bird_font_get_settings_directory ();
	_tmp6_ = _tmp5_;
	_tmp7_ = bird_font_get_child (_tmp6_, fn);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	f = _tmp8_;
	result = f;
	_g_free0 (fn);
	return result;
}

/** Retuns true if the current font has be modified */
gboolean
bird_font_font_is_modified (BirdFontFont* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->modified;
	return result;
}

/** Full path to this font file. */
gchar*
bird_font_font_get_path (BirdFontFont* self)
{
	gint i = 0;
	gchar* fn = NULL;
	GFile* f = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_;
	GString* sb = NULL;
	GString* _tmp10_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	GString* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GString* _tmp19_;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	GString* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	i = 0;
	_tmp0_ = self->font_file;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->font_file;
		_tmp2_ = g_strdup ((const gchar*) _tmp1_);
		_g_free0 (fn);
		fn = _tmp2_;
		if (bird_font_bird_font_win32) {
			result = fn;
			_g_object_unref0 (file);
			_g_object_unref0 (f);
			return result;
		} else {
			const gchar* _tmp3_;
			GFile* _tmp4_;
			GFile* _tmp5_;
			GFile* _tmp6_;
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp3_ = fn;
			_tmp4_ = g_file_new_for_path (_tmp3_);
			_g_object_unref0 (file);
			file = _tmp4_;
			_tmp5_ = file;
			_tmp6_ = g_file_resolve_relative_path (_tmp5_, ".");
			_tmp7_ = _tmp6_;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = (gchar*) _tmp8_;
			_g_object_unref0 (_tmp7_);
			result = _tmp9_;
			_g_object_unref0 (file);
			_g_object_unref0 (f);
			_g_free0 (fn);
			return result;
		}
	}
	_tmp10_ = g_string_new ("");
	sb = _tmp10_;
	_tmp11_ = sb;
	_tmp12_ = g_get_home_dir ();
	g_string_append (_tmp11_, _tmp12_);
	_tmp13_ = sb;
	_tmp14_ = bird_font_font_get_name (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = string_to_string (_tmp15_);
	_tmp17_ = g_strconcat ("/", _tmp16_, ".birdfont", NULL);
	_tmp18_ = _tmp17_;
	g_string_append (_tmp13_, _tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_tmp19_ = sb;
	_tmp20_ = _tmp19_->str;
	_tmp21_ = g_file_new_for_path (_tmp20_);
	_g_object_unref0 (f);
	f = _tmp21_;
	while (TRUE) {
		GFile* _tmp22_;
		GString* _tmp23_;
		GString* _tmp24_;
		const gchar* _tmp25_;
		GString* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gint _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GString* _tmp35_;
		const gchar* _tmp36_;
		GFile* _tmp37_;
		_tmp22_ = f;
		if (!g_file_query_exists (_tmp22_, NULL)) {
			break;
		}
		_tmp23_ = sb;
		g_string_erase (_tmp23_, (gssize) 0, (gssize) -1);
		_tmp24_ = sb;
		_tmp25_ = g_get_home_dir ();
		g_string_append (_tmp24_, _tmp25_);
		_tmp26_ = sb;
		_tmp27_ = bird_font_font_get_name (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = string_to_string (_tmp28_);
		i = i + 1;
		_tmp30_ = i;
		_tmp31_ = g_strdup_printf ("%i", _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat ("/", _tmp29_, _tmp32_, ".birdfont", NULL);
		_tmp34_ = _tmp33_;
		g_string_append (_tmp26_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp28_);
		_tmp35_ = sb;
		_tmp36_ = _tmp35_->str;
		_tmp37_ = g_file_new_for_path (_tmp36_);
		_g_object_unref0 (f);
		f = _tmp37_;
	}
	_tmp38_ = sb;
	_tmp39_ = _tmp38_->str;
	_tmp40_ = g_strdup (_tmp39_);
	result = _tmp40_;
	_g_string_free0 (sb);
	_g_object_unref0 (file);
	_g_object_unref0 (f);
	_g_free0 (fn);
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
bird_font_font_get_file_from_full_path (const gchar* path)
{
	gchar* p = NULL;
	gchar* _tmp0_;
	gint i = 0;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_strdup (path);
	p = _tmp0_;
	_tmp1_ = p;
	i = string_last_index_of (_tmp1_, "/", 0);
	if (i == -1) {
		const gchar* _tmp2_;
		_tmp2_ = p;
		i = string_last_index_of (_tmp2_, "\\", 0);
	}
	_tmp3_ = p;
	_tmp4_ = string_substring (_tmp3_, (glong) (i + 1), (glong) -1);
	_g_free0 (p);
	p = _tmp4_;
	result = p;
	return result;
}

gchar*
bird_font_font_get_file_name (BirdFontFont* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_get_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_font_get_file_from_full_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/** @return an absolute path to the font folder. */
static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

GFile*
bird_font_font_get_folder (BirdFontFont* self)
{
	gchar* p = NULL;
	gchar* _tmp0_;
	GFile* fp = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_get_folder_path (self);
	p = _tmp0_;
	_tmp1_ = p;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	fp = _tmp2_;
	if (bird_font_bird_font_win32) {
		const gchar* _tmp3_;
		_tmp3_ = p;
		if (string_index_of (_tmp3_, ":\\", 0) == -1) {
			GFile* _tmp4_;
			GFile* _tmp5_;
			GFile* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = fp;
			_tmp5_ = g_file_resolve_relative_path (_tmp4_, "");
			_tmp6_ = _tmp5_;
			_tmp7_ = g_file_get_path (_tmp6_);
			_g_free0 (p);
			p = (gchar*) _tmp7_;
			_g_object_unref0 (_tmp6_);
		}
	} else {
		const gchar* _tmp8_;
		_tmp8_ = p;
		if (!g_str_has_prefix (_tmp8_, "/")) {
			GFile* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			gchar* _tmp12_;
			_tmp9_ = fp;
			_tmp10_ = g_file_resolve_relative_path (_tmp9_, "");
			_tmp11_ = _tmp10_;
			_tmp12_ = g_file_get_path (_tmp11_);
			_g_free0 (p);
			p = (gchar*) _tmp12_;
			_g_object_unref0 (_tmp11_);
		}
	}
	_tmp13_ = p;
	_tmp14_ = g_file_new_for_path (_tmp13_);
	result = _tmp14_;
	_g_object_unref0 (fp);
	_g_free0 (p);
	return result;
}

/** @return a path to the font folder, it can be relative. */
gchar*
bird_font_font_get_folder_path (BirdFontFont* self)
{
	gchar* p = NULL;
	gchar* _tmp0_;
	gint i = 0;
	const gchar* _tmp1_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_get_path (self);
	p = _tmp0_;
	_tmp1_ = p;
	i = string_last_index_of (_tmp1_, "/", 0);
	if (i == -1) {
		const gchar* _tmp2_;
		_tmp2_ = p;
		i = string_last_index_of (_tmp2_, "\\", 0);
	}
	if (i == -1) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = p;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("Can not find folder in ", _tmp4_, ".", NULL);
		_tmp6_ = _tmp5_;
		g_warning ("Font.vala:411: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = g_strdup (".");
		_g_free0 (p);
		p = _tmp7_;
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = p;
		_tmp9_ = string_substring (_tmp8_, (glong) 0, (glong) i);
		_g_free0 (p);
		p = _tmp9_;
	}
	_tmp11_ = p;
	if (string_index_of (_tmp11_, ":", 0) != -1) {
		const gchar* _tmp12_;
		_tmp12_ = p;
		_tmp10_ = g_utf8_strlen (_tmp12_, (gssize) -1) == 2;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = p;
		_tmp14_ = g_strconcat (_tmp13_, "\\", NULL);
		_g_free0 (p);
		p = _tmp14_;
	}
	result = p;
	return result;
}

gdouble
bird_font_font_get_height (BirdFontFont* self)
{
	gdouble r = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	r = self->top_position - self->base_line;
	if (r > ((gdouble) 0)) {
		_tmp0_ = r;
	} else {
		_tmp0_ = -r;
	}
	result = _tmp0_;
	return result;
}

void
bird_font_font_set_name (BirdFontFont* self,
                         const gchar* name)
{
	gchar* n = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	n = _tmp0_;
	_tmp1_ = g_strdup (n);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_g_free0 (n);
}

gchar*
bird_font_font_get_full_name (BirdFontFont* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->full_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
bird_font_font_get_name (BirdFontFont* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
__lambda597_ (BirdFontFont* self,
              BirdFontGlyphCollection* g)
{
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (g != NULL);
	_tmp0_ = stdout;
	_tmp1_ = bird_font_glyph_collection_get_unicode (g);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat (_tmp3_, "\n", NULL);
	_tmp5_ = _tmp4_;
	fprintf (_tmp0_, "%s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
}

static void
___lambda597__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda597_ ((BirdFontFont*) self, (BirdFontGlyphCollection*) data);
}

static void
__lambda598_ (BirdFontFont* self,
              BirdFontGlyphCollection* g)
{
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (g != NULL);
	_tmp0_ = stdout;
	_tmp1_ = bird_font_glyph_collection_get_name (g);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat (_tmp3_, "\n", NULL);
	_tmp5_ = _tmp4_;
	fprintf (_tmp0_, "%s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
}

static void
___lambda598__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda598_ ((BirdFontFont*) self, (BirdFontGlyphCollection*) data);
}

void
bird_font_font_print_all (BirdFontFont* self)
{
	FILE* _tmp0_;
	BirdFontGlyphTable* _tmp1_;
	FILE* _tmp2_;
	BirdFontGlyphTable* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Unicode:\n");
	_tmp1_ = self->glyph_cache;
	bird_font_glyph_table_for_each (_tmp1_, ___lambda597__gfunc, self);
	_tmp2_ = stdout;
	fprintf (_tmp2_, "Names:\n");
	_tmp3_ = self->glyph_name;
	bird_font_glyph_table_for_each (_tmp3_, ___lambda598__gfunc, self);
}

gboolean
bird_font_font_has_glyph (BirdFontFont* self,
                          const gchar* n)
{
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (n != NULL, FALSE);
	_tmp0_ = bird_font_font_get_glyph (self, n);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

BirdFontGlyphCollection*
bird_font_font_get_nonmarking_return (BirdFontFont* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* non_marking = NULL;
	BirdFontGlyphCollection* _tmp4_;
	BirdFontGlyph* _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyph* _tmp7_;
	BirdFontGlyph* _tmp8_;
	BirdFontGlyphCollection* _tmp9_;
	BirdFontGlyphMaster* master = NULL;
	BirdFontGlyphMaster* _tmp10_;
	BirdFontGlyphMaster* _tmp11_;
	BirdFontGlyph* _tmp12_;
	BirdFontGlyphCollection* _tmp13_;
	BirdFontGlyphMaster* _tmp14_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (bird_font_font_has_glyph (self, "nonmarkingreturn")) {
		BirdFontGlyphCollection* _tmp0_;
		BirdFontGlyphCollection* _tmp1_;
		_tmp0_ = bird_font_font_get_glyph_collection (self, "nonmarkingreturn");
		_g_object_unref0 (non_marking);
		non_marking = _tmp0_;
		_tmp1_ = non_marking;
		if (_tmp1_ == NULL) {
			g_warning ("Font.vala:467: Non marking return not created.");
		} else {
			BirdFontGlyphCollection* _tmp2_;
			BirdFontGlyphCollection* _tmp3_;
			_tmp2_ = non_marking;
			_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			result = _tmp3_;
			_g_object_unref0 (non_marking);
			_g_object_unref0 (gc);
			_g_object_unref0 (g);
			return result;
		}
	}
	_tmp4_ = bird_font_glyph_collection_new ((gunichar) '\r', "nonmarkingreturn");
	_g_object_unref0 (gc);
	gc = _tmp4_;
	_tmp5_ = bird_font_glyph_new ("nonmarkingreturn", (gunichar) '\r');
	_g_object_unref0 (g);
	g = _tmp5_;
	_tmp6_ = g;
	bird_font_glyph_set_left_limit (_tmp6_, (gdouble) 0);
	_tmp7_ = g;
	bird_font_glyph_set_right_limit (_tmp7_, (gdouble) 0);
	_tmp8_ = g;
	bird_font_glyph_remove_empty_paths (_tmp8_);
	_tmp9_ = gc;
	bird_font_glyph_collection_set_unassigned (_tmp9_, FALSE);
	_tmp10_ = bird_font_glyph_master_new ();
	master = _tmp10_;
	_tmp11_ = master;
	_tmp12_ = g;
	bird_font_glyph_master_add_glyph (_tmp11_, _tmp12_);
	_tmp13_ = gc;
	_tmp14_ = master;
	bird_font_glyph_collection_add_master (_tmp13_, _tmp14_);
	result = gc;
	_g_object_unref0 (master);
	_g_object_unref0 (non_marking);
	_g_object_unref0 (g);
	return result;
}

BirdFontGlyphCollection*
bird_font_font_get_null_character (BirdFontFont* self)
{
	BirdFontGlyph* n = NULL;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* none = NULL;
	BirdFontGlyphCollection* _tmp4_;
	BirdFontGlyph* _tmp5_;
	BirdFontGlyphMaster* master = NULL;
	BirdFontGlyphMaster* _tmp6_;
	BirdFontGlyphMaster* _tmp7_;
	BirdFontGlyph* _tmp8_;
	BirdFontGlyphCollection* _tmp9_;
	BirdFontGlyphMaster* _tmp10_;
	BirdFontGlyphCollection* _tmp11_;
	BirdFontGlyph* _tmp12_;
	BirdFontGlyph* _tmp13_;
	BirdFontGlyph* _tmp14_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (bird_font_font_has_glyph (self, "null")) {
		BirdFontGlyphCollection* _tmp0_;
		BirdFontGlyphCollection* _tmp1_;
		_tmp0_ = bird_font_font_get_glyph_collection (self, "null");
		_g_object_unref0 (none);
		none = _tmp0_;
		_tmp1_ = none;
		if (_tmp1_ == NULL) {
			g_warning ("Font.vala:498: Null character not created.");
		} else {
			BirdFontGlyphCollection* _tmp2_;
			BirdFontGlyphCollection* _tmp3_;
			_tmp2_ = none;
			_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			result = _tmp3_;
			_g_object_unref0 (none);
			_g_object_unref0 (gc);
			_g_object_unref0 (n);
			return result;
		}
	}
	_tmp4_ = bird_font_glyph_collection_new ((gunichar) '\0', "null");
	_g_object_unref0 (gc);
	gc = _tmp4_;
	_tmp5_ = bird_font_glyph_new ("null", (gunichar) '\0');
	_g_object_unref0 (n);
	n = _tmp5_;
	_tmp6_ = bird_font_glyph_master_new ();
	master = _tmp6_;
	_tmp7_ = master;
	_tmp8_ = n;
	bird_font_glyph_master_add_glyph (_tmp7_, _tmp8_);
	_tmp9_ = gc;
	_tmp10_ = master;
	bird_font_glyph_collection_add_master (_tmp9_, _tmp10_);
	_tmp11_ = gc;
	bird_font_glyph_collection_set_unassigned (_tmp11_, FALSE);
	_tmp12_ = n;
	bird_font_glyph_set_left_limit (_tmp12_, (gdouble) 0);
	_tmp13_ = n;
	bird_font_glyph_set_right_limit (_tmp13_, (gdouble) 0);
	_tmp14_ = n;
	bird_font_glyph_remove_empty_paths (_tmp14_);
	result = gc;
	_g_object_unref0 (master);
	_g_object_unref0 (none);
	_g_object_unref0 (n);
	return result;
}

BirdFontGlyphCollection*
bird_font_font_get_space (BirdFontFont* self)
{
	BirdFontGlyph* n = NULL;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* space = NULL;
	BirdFontGlyphCollection* _tmp2_;
	BirdFontGlyphCollection* _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyph* _tmp7_;
	BirdFontGlyph* _tmp8_;
	BirdFontGlyph* _tmp9_;
	BirdFontGlyphMaster* master = NULL;
	BirdFontGlyphMaster* _tmp10_;
	BirdFontGlyphMaster* _tmp11_;
	BirdFontGlyph* _tmp12_;
	BirdFontGlyphCollection* _tmp13_;
	BirdFontGlyphMaster* _tmp14_;
	BirdFontGlyphCollection* _tmp15_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	space = NULL;
	if (bird_font_font_has_glyph (self, " ")) {
		BirdFontGlyphCollection* _tmp0_;
		_tmp0_ = bird_font_font_get_glyph_collection (self, " ");
		_g_object_unref0 (space);
		space = _tmp0_;
	}
	if (bird_font_font_has_glyph (self, "space")) {
		BirdFontGlyphCollection* _tmp1_;
		_tmp1_ = bird_font_font_get_glyph_collection (self, "space");
		_g_object_unref0 (space);
		space = _tmp1_;
	}
	_tmp2_ = space;
	if (_tmp2_ != NULL) {
		BirdFontGlyphCollection* _tmp3_;
		BirdFontGlyphCollection* _tmp4_;
		_tmp3_ = space;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		result = _tmp4_;
		_g_object_unref0 (space);
		_g_object_unref0 (gc);
		_g_object_unref0 (n);
		return result;
	}
	_tmp5_ = bird_font_glyph_collection_new ((gunichar) ' ', "space");
	_g_object_unref0 (gc);
	gc = _tmp5_;
	_tmp6_ = bird_font_glyph_new (" ", (gunichar) ' ');
	_g_object_unref0 (n);
	n = _tmp6_;
	_tmp7_ = n;
	bird_font_glyph_set_left_limit (_tmp7_, (gdouble) 0);
	_tmp8_ = n;
	bird_font_glyph_set_right_limit (_tmp8_, (gdouble) 27);
	_tmp9_ = n;
	bird_font_glyph_remove_empty_paths (_tmp9_);
	_tmp10_ = bird_font_glyph_master_new ();
	master = _tmp10_;
	_tmp11_ = master;
	_tmp12_ = n;
	bird_font_glyph_master_add_glyph (_tmp11_, _tmp12_);
	_tmp13_ = gc;
	_tmp14_ = master;
	bird_font_glyph_collection_add_master (_tmp13_, _tmp14_);
	_tmp15_ = gc;
	bird_font_glyph_collection_set_unassigned (_tmp15_, FALSE);
	result = gc;
	_g_object_unref0 (master);
	_g_object_unref0 (space);
	_g_object_unref0 (n);
	return result;
}

BirdFontGlyphCollection*
bird_font_font_get_notdef_character (BirdFontFont* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontPath* p = NULL;
	BirdFontPath* i = NULL;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontPath* _tmp3_;
	BirdFontPath* _tmp4_;
	BirdFontGlyphCollection* _tmp5_;
	BirdFontGlyphMaster* master = NULL;
	BirdFontGlyphMaster* _tmp6_;
	BirdFontGlyphMaster* _tmp7_;
	BirdFontGlyph* _tmp8_;
	BirdFontGlyphCollection* _tmp9_;
	BirdFontGlyphMaster* _tmp10_;
	BirdFontGlyph* _tmp11_;
	BirdFontGlyph* _tmp12_;
	BirdFontGlyph* _tmp13_;
	BirdFontPath* _tmp14_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPoint* _tmp16_;
	BirdFontPath* _tmp17_;
	BirdFontEditPoint* _tmp18_;
	BirdFontEditPoint* _tmp19_;
	BirdFontPath* _tmp20_;
	BirdFontEditPoint* _tmp21_;
	BirdFontEditPoint* _tmp22_;
	BirdFontPath* _tmp23_;
	BirdFontEditPoint* _tmp24_;
	BirdFontEditPoint* _tmp25_;
	BirdFontPath* _tmp26_;
	BirdFontPath* _tmp27_;
	BirdFontEditPoint* _tmp28_;
	BirdFontEditPoint* _tmp29_;
	BirdFontPath* _tmp30_;
	BirdFontEditPoint* _tmp31_;
	BirdFontEditPoint* _tmp32_;
	BirdFontPath* _tmp33_;
	BirdFontEditPoint* _tmp34_;
	BirdFontEditPoint* _tmp35_;
	BirdFontPath* _tmp36_;
	BirdFontEditPoint* _tmp37_;
	BirdFontEditPoint* _tmp38_;
	BirdFontPath* _tmp39_;
	BirdFontPath* _tmp40_;
	BirdFontGlyph* _tmp41_;
	BirdFontPath* _tmp42_;
	BirdFontGlyph* _tmp43_;
	BirdFontPath* _tmp44_;
	BirdFontPath* _tmp45_;
	BirdFontPath* _tmp46_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (bird_font_font_has_glyph (self, ".notdef")) {
		BirdFontGlyphCollection* _tmp0_;
		_tmp0_ = bird_font_font_get_glyph_collection (self, ".notdef");
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection);
		_g_object_unref0 (i);
		_g_object_unref0 (p);
		_g_object_unref0 (gc);
		_g_object_unref0 (g);
		return result;
	}
	_tmp1_ = bird_font_glyph_collection_new ((gunichar) '\0', ".notdef");
	_g_object_unref0 (gc);
	gc = _tmp1_;
	_tmp2_ = bird_font_glyph_new (".notdef", (gunichar) 0);
	_g_object_unref0 (g);
	g = _tmp2_;
	_tmp3_ = bird_font_path_new ();
	_g_object_unref0 (p);
	p = _tmp3_;
	_tmp4_ = bird_font_path_new ();
	_g_object_unref0 (i);
	i = _tmp4_;
	_tmp5_ = gc;
	bird_font_glyph_collection_set_unassigned (_tmp5_, TRUE);
	_tmp6_ = bird_font_glyph_master_new ();
	master = _tmp6_;
	_tmp7_ = master;
	_tmp8_ = g;
	bird_font_glyph_master_add_glyph (_tmp7_, _tmp8_);
	_tmp9_ = gc;
	_tmp10_ = master;
	bird_font_glyph_collection_add_master (_tmp9_, _tmp10_);
	_tmp11_ = g;
	bird_font_glyph_set_left_limit (_tmp11_, (gdouble) -20);
	_tmp12_ = g;
	bird_font_glyph_set_right_limit (_tmp12_, (gdouble) 33);
	_tmp13_ = g;
	bird_font_glyph_add_help_lines (_tmp13_);
	_tmp14_ = p;
	_tmp15_ = bird_font_path_add (_tmp14_, (gdouble) -20, self->top_position - 5);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp16_);
	_tmp17_ = p;
	_tmp18_ = bird_font_path_add (_tmp17_, (gdouble) 20, self->top_position - 5);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp19_);
	_tmp20_ = p;
	_tmp21_ = bird_font_path_add (_tmp20_, (gdouble) 20, self->base_line + 5);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp22_);
	_tmp23_ = p;
	_tmp24_ = bird_font_path_add (_tmp23_, (gdouble) -20, self->base_line + 5);
	_tmp25_ = _tmp24_;
	_g_object_unref0 (_tmp25_);
	_tmp26_ = p;
	bird_font_path_close (_tmp26_);
	_tmp27_ = i;
	_tmp28_ = bird_font_path_add (_tmp27_, (gdouble) -15, self->top_position - 10);
	_tmp29_ = _tmp28_;
	_g_object_unref0 (_tmp29_);
	_tmp30_ = i;
	_tmp31_ = bird_font_path_add (_tmp30_, (gdouble) 15, self->top_position - 10);
	_tmp32_ = _tmp31_;
	_g_object_unref0 (_tmp32_);
	_tmp33_ = i;
	_tmp34_ = bird_font_path_add (_tmp33_, (gdouble) 15, self->base_line + 10);
	_tmp35_ = _tmp34_;
	_g_object_unref0 (_tmp35_);
	_tmp36_ = i;
	_tmp37_ = bird_font_path_add (_tmp36_, (gdouble) -15, self->base_line + 10);
	_tmp38_ = _tmp37_;
	_g_object_unref0 (_tmp38_);
	_tmp39_ = i;
	bird_font_path_reverse (_tmp39_);
	_tmp40_ = i;
	bird_font_path_close (_tmp40_);
	_tmp41_ = g;
	_tmp42_ = i;
	bird_font_glyph_add_path (_tmp41_, _tmp42_);
	_tmp43_ = g;
	_tmp44_ = p;
	bird_font_glyph_add_path (_tmp43_, _tmp44_);
	_tmp45_ = i;
	bird_font_path_recalculate_linear_handles (_tmp45_);
	_tmp46_ = p;
	bird_font_path_recalculate_linear_handles (_tmp46_);
	result = gc;
	_g_object_unref0 (master);
	_g_object_unref0 (i);
	_g_object_unref0 (p);
	_g_object_unref0 (g);
	return result;
}

void
bird_font_font_add_glyph_collection (BirdFontFont* self,
                                     BirdFontGlyphCollection* glyph_collection)
{
	BirdFontGlyphCollection* gc = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* name = NULL;
	gchar* _tmp3_;
	BirdFontGlyphTable* _tmp4_;
	const gchar* _tmp5_;
	BirdFontGlyphCollection* _tmp6_;
	BirdFontGlyphCollection* _tmp7_;
	BirdFontGlyphTable* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyph_collection != NULL);
	_tmp0_ = bird_font_glyph_collection_get_name (glyph_collection);
	_tmp1_ = _tmp0_;
	_tmp2_ = G_UNLIKELY (g_strcmp0 (_tmp1_, "") == 0);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		g_warning ("Font.vala:606: Refusing to add glyph with name \"\", null character sh" \
"ould be named null.");
		_g_object_unref0 (gc);
		return;
	}
	_tmp3_ = bird_font_glyph_collection_get_name (glyph_collection);
	name = _tmp3_;
	_tmp4_ = self->glyph_name;
	_tmp5_ = name;
	_tmp6_ = bird_font_glyph_table_get (_tmp4_, _tmp5_);
	_g_object_unref0 (gc);
	gc = _tmp6_;
	_tmp7_ = gc;
	if (G_UNLIKELY (_tmp7_ != NULL)) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = name;
		_tmp9_ = g_strconcat ("glyph has already been added: ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		g_warning ("Font.vala:613: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (name);
		_g_object_unref0 (gc);
		return;
	}
	_tmp11_ = self->glyph_name;
	_tmp12_ = bird_font_glyph_collection_get_name (glyph_collection);
	_tmp13_ = _tmp12_;
	bird_font_glyph_table_insert (_tmp11_, _tmp13_, glyph_collection);
	_g_free0 (_tmp13_);
	_tmp14_ = bird_font_glyph_collection_get_unicode (glyph_collection);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strcmp0 (_tmp15_, "") != 0;
	_g_free0 (_tmp15_);
	if (_tmp16_) {
		BirdFontGlyphTable* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = self->glyph_cache;
		_tmp18_ = bird_font_glyph_collection_get_unicode (glyph_collection);
		_tmp19_ = (gchar*) _tmp18_;
		bird_font_glyph_table_insert (_tmp17_, _tmp19_, glyph_collection);
		_g_free0 (_tmp19_);
	} else {
		BirdFontGlyphTable* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp20_ = self->glyph_cache;
		_tmp21_ = bird_font_glyph_collection_get_name (glyph_collection);
		_tmp22_ = (gchar*) _tmp21_;
		bird_font_glyph_table_insert (_tmp20_, _tmp22_, glyph_collection);
		_g_free0 (_tmp22_);
	}
	if (bird_font_glyph_collection_is_unassigned (glyph_collection)) {
		BirdFontGlyphTable* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp23_ = self->ligature;
		_tmp24_ = bird_font_glyph_collection_get_name (glyph_collection);
		_tmp25_ = _tmp24_;
		bird_font_glyph_table_insert (_tmp23_, _tmp25_, glyph_collection);
		_g_free0 (_tmp25_);
	}
	_g_free0 (name);
	_g_object_unref0 (gc);
}

gchar*
bird_font_font_get_name_for_character (gunichar c)
{
	GString* sb = NULL;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	if (c == ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (".null");
		result = _tmp0_;
		_g_string_free0 (sb);
		return result;
	}
	_tmp1_ = g_string_new ("");
	_g_string_free0 (sb);
	sb = _tmp1_;
	_tmp2_ = sb;
	g_string_append_unichar (_tmp2_, c);
	_tmp3_ = sb;
	_tmp4_ = _tmp3_->str;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	_g_string_free0 (sb);
	return result;
}

gboolean
bird_font_font_has_name (BirdFontFont* self,
                         const gchar* name)
{
	BirdFontGlyphTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->glyph_name;
	result = bird_font_glyph_table_has_key (_tmp0_, name);
	return result;
}

void
bird_font_font_delete_glyph (BirdFontFont* self,
                             BirdFontGlyphCollection* glyph)
{
	BirdFontGlyphTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	BirdFontGlyphTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontGlyphTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BirdFontGlyphTable* _tmp9_;
	BirdFontGlyph* _tmp10_;
	BirdFontGlyph* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyph != NULL);
	_tmp0_ = self->glyph_cache;
	_tmp1_ = bird_font_glyph_collection_get_unicode (glyph);
	_tmp2_ = _tmp1_;
	bird_font_glyph_table_remove (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->glyph_cache;
	_tmp4_ = bird_font_glyph_collection_get_name (glyph);
	_tmp5_ = _tmp4_;
	bird_font_glyph_table_remove (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->glyph_name;
	_tmp7_ = bird_font_glyph_collection_get_name (glyph);
	_tmp8_ = _tmp7_;
	bird_font_glyph_table_remove (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->ligature;
	_tmp10_ = bird_font_glyph_collection_get_current (glyph);
	_tmp11_ = _tmp10_;
	_tmp12_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp11_);
	_tmp13_ = _tmp12_;
	bird_font_glyph_table_remove (_tmp9_, _tmp13_);
	_g_free0 (_tmp13_);
	_g_object_unref0 (_tmp11_);
	{
		GeeArrayList* _a_list = NULL;
		BirdFontAlternateSets* _tmp14_;
		GeeArrayList* _tmp15_;
		gint _a_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _a_index = 0;
		_tmp14_ = self->alternates;
		_tmp15_ = _tmp14_->alternates;
		_a_list = _tmp15_;
		_tmp16_ = _a_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_a_size = _tmp18_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			BirdFontAlternate* a = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			BirdFontAlternate* _tmp23_;
			_a_index = _a_index + 1;
			_tmp19_ = _a_index;
			_tmp20_ = _a_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _a_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _a_index);
			a = (BirdFontAlternate*) _tmp22_;
			_tmp23_ = a;
			bird_font_alternate_remove (_tmp23_, glyph);
			_g_object_unref0 (a);
		}
	}
	{
		GeeArrayList* _master_list = NULL;
		GeeArrayList* _tmp24_;
		gint _master_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _master_index = 0;
		_tmp24_ = glyph->glyph_masters;
		_master_list = _tmp24_;
		_tmp25_ = _master_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_master_size = _tmp27_;
		_master_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			BirdFontGlyphMaster* master = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			_master_index = _master_index + 1;
			_tmp28_ = _master_index;
			_tmp29_ = _master_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _master_list;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _master_index);
			master = (BirdFontGlyphMaster*) _tmp31_;
			{
				GeeArrayList* _g_list = NULL;
				BirdFontGlyphMaster* _tmp32_;
				GeeArrayList* _tmp33_;
				gint _g_size = 0;
				GeeArrayList* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _g_index = 0;
				_tmp32_ = master;
				_tmp33_ = _tmp32_->glyphs;
				_g_list = _tmp33_;
				_tmp34_ = _g_list;
				_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp34_);
				_tmp36_ = _tmp35_;
				_g_size = _tmp36_;
				_g_index = -1;
				while (TRUE) {
					gint _tmp37_;
					gint _tmp38_;
					BirdFontGlyph* g = NULL;
					GeeArrayList* _tmp39_;
					gpointer _tmp40_;
					BirdFontGlyph* _tmp41_;
					BirdFontGlyphMaster* _tmp42_;
					_g_index = _g_index + 1;
					_tmp37_ = _g_index;
					_tmp38_ = _g_size;
					if (!(_tmp37_ < _tmp38_)) {
						break;
					}
					_tmp39_ = _g_list;
					_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _g_index);
					g = (BirdFontGlyph*) _tmp40_;
					_tmp41_ = g;
					_tmp42_ = master;
					bird_font_font_add_deleted_glyph (self, _tmp41_, _tmp42_);
					_g_object_unref0 (g);
				}
			}
			_g_object_unref0 (master);
		}
	}
}

void
bird_font_font_add_deleted_glyph (BirdFontFont* self,
                                  BirdFontGlyph* g,
                                  BirdFontGlyphMaster* master)
{
	gchar* file_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	g_return_if_fail (master != NULL);
	_tmp0_ = bird_font_bird_font_part_get_glyph_base_file_name (g, master);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".bfp", NULL);
	_g_free0 (file_name);
	file_name = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = self->deleted_glyphs;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, file_name);
	_g_free0 (file_name);
}

BirdFontGlyphCollection*
bird_font_font_get_ligature (BirdFontFont* self,
                             guint index)
{
	BirdFontGlyphTable* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->ligature;
	_tmp1_ = bird_font_glyph_table_nth (_tmp0_, index);
	result = _tmp1_;
	return result;
}

/** Obtain all versions and alterntes for this glyph. */
BirdFontGlyphCollection*
bird_font_font_get_glyph_collection (BirdFontFont* self,
                                     const gchar* unichar_code)
{
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphTable* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (unichar_code != NULL, NULL);
	gc = NULL;
	_tmp0_ = self->glyph_cache;
	_tmp1_ = bird_font_glyph_table_get (_tmp0_, unichar_code);
	_g_object_unref0 (gc);
	gc = _tmp1_;
	result = gc;
	return result;
}

/** Get glyph collection by name. */
BirdFontGlyphCollection*
bird_font_font_get_glyph_collection_by_name (BirdFontFont* self,
                                             const gchar* glyph)
{
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	gc = NULL;
	if (glyph != NULL) {
		BirdFontGlyphTable* _tmp0_;
		BirdFontGlyphCollection* _tmp1_;
		_tmp0_ = self->glyph_name;
		_tmp1_ = bird_font_glyph_table_get (_tmp0_, (const gchar*) glyph);
		_g_object_unref0 (gc);
		gc = _tmp1_;
	}
	result = gc;
	return result;
}

/** Get glyph by name. */
BirdFontGlyph*
bird_font_font_get_glyph_by_name (BirdFontFont* self,
                                  const gchar* glyph)
{
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyphCollection* _tmp2_;
	BirdFontGlyph* _tmp3_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (glyph != NULL, NULL);
	_tmp0_ = bird_font_font_get_glyph_collection_by_name (self, glyph);
	gc = _tmp0_;
	_tmp1_ = gc;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (gc);
		return result;
	}
	_tmp2_ = gc;
	_tmp3_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
	result = _tmp3_;
	_g_object_unref0 (gc);
	return result;
}

BirdFontGlyph*
bird_font_font_get_glyph (BirdFontFont* self,
                          const gchar* name)
{
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphTable* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	gboolean _tmp2_ = FALSE;
	BirdFontGlyphCollection* _tmp3_;
	BirdFontGlyphCollection* _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	gc = NULL;
	_tmp0_ = self->glyph_name;
	_tmp1_ = bird_font_glyph_table_get (_tmp0_, name);
	_g_object_unref0 (gc);
	gc = _tmp1_;
	_tmp3_ = gc;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		BirdFontGlyphCollection* _tmp4_;
		_tmp4_ = gc;
		_tmp2_ = bird_font_glyph_collection_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection)) == ((guint) 0);
	}
	if (_tmp2_) {
		result = NULL;
		_g_object_unref0 (gc);
		return result;
	}
	_tmp5_ = gc;
	_tmp6_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
	result = _tmp6_;
	_g_object_unref0 (gc);
	return result;
}

BirdFontGlyphCollection*
bird_font_font_get_glyph_collection_index (BirdFontFont* self,
                                           gunichar glyph_index)
{
	BirdFontGlyphTable* _tmp0_;
	gunichar _tmp1_;
	BirdFontGlyphTable* _tmp2_;
	BirdFontGlyphCollection* _tmp3_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->glyph_name;
	_tmp1_ = glyph_index;
	if (!((((gunichar) 0) <= _tmp1_) && (_tmp1_ < ((gunichar) bird_font_glyph_table_length (_tmp0_))))) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->glyph_name;
	_tmp3_ = bird_font_glyph_table_nth (_tmp2_, (guint) glyph_index);
	result = _tmp3_;
	return result;
}

BirdFontGlyph*
bird_font_font_get_glyph_index (BirdFontFont* self,
                                gunichar glyph_index)
{
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_get_glyph_collection_index (self, glyph_index);
	_g_object_unref0 (gc);
	gc = _tmp0_;
	_tmp1_ = gc;
	if (_tmp1_ != NULL) {
		BirdFontGlyphCollection* _tmp2_;
		BirdFontGlyph* _tmp3_;
		_tmp2_ = gc;
		_tmp3_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		result = _tmp3_;
		_g_object_unref0 (gc);
		return result;
	}
	result = NULL;
	_g_object_unref0 (gc);
	return result;
}

void
bird_font_font_add_background_image (BirdFontFont* self,
                                     BirdFontBackgroundImage* image)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	_tmp0_ = self->background_images;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, image);
}

void
bird_font_font_init_bfp (BirdFontFont* self,
                         const gchar* directory)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	{
		BirdFontBirdFontPart* _tmp0_;
		BirdFontBirdFontPart* _tmp1_;
		BirdFontBirdFontPart* _tmp2_;
		_tmp0_ = bird_font_bird_font_part_new (self);
		_g_object_unref0 (self->priv->bfp_file);
		self->priv->bfp_file = _tmp0_;
		_tmp1_ = self->priv->bfp_file;
		bird_font_bird_font_part_create_directory (_tmp1_, directory, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = self->priv->bfp_file;
		bird_font_bird_font_part_save (_tmp2_);
		self->priv->bfp = TRUE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Font.vala:745: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
bird_font_font_set_bfp (BirdFontFont* self,
                        gboolean bfp)
{
	g_return_if_fail (self != NULL);
	self->priv->bfp = bfp;
}

gboolean
bird_font_font_is_bfp (BirdFontFont* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->bfp;
	return result;
}

void
bird_font_font_save (BirdFontFont* self)
{
	BirdFontFontSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	if (bird_font_font_is_bfp (self)) {
		bird_font_font_save_bfp (self);
	} else {
		bird_font_font_save_bf (self);
	}
	_tmp0_ = self->settings;
	_tmp1_ = bird_font_font_get_file_name (self);
	_tmp2_ = _tmp1_;
	bird_font_font_settings_save (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
bird_font_font_save_backups (BirdFontFont* self,
                             GError** error)
{
	gchar* num_backups = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint backups = 0;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_preferences_get ("num_backups");
	num_backups = _tmp0_;
	_tmp1_ = num_backups;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("20");
		_g_free0 (num_backups);
		num_backups = _tmp2_;
	}
	_tmp3_ = num_backups;
	backups = atoi (_tmp3_);
	if (backups == 0) {
		bird_font_printd ("No backups according to settings. Skipping it.");
		bird_font_font_delete_old_backups (self, backups);
		_g_free0 (num_backups);
		return;
	}
	if (backups > 0) {
		gchar* path = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* bf_data = NULL;
		gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gboolean _tmp10_;
		_tmp4_ = self->font_file;
		_tmp5_ = g_strdup ((const gchar*) _tmp4_);
		path = _tmp5_;
		_tmp6_ = g_strdup ("");
		bf_data = _tmp6_;
		_tmp8_ = path;
		_tmp10_ = g_file_get_contents (_tmp8_, &_tmp9_, NULL, &_inner_error0_);
		_g_free0 (bf_data);
		bf_data = _tmp9_;
		_tmp7_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (bf_data);
			_g_free0 (path);
			_g_free0 (num_backups);
			return;
		}
		if (_tmp7_) {
			GDateTime* now = NULL;
			GDateTime* _tmp11_;
			gchar* time_stamp = NULL;
			GDateTime* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* fn = NULL;
			gchar* _tmp18_;
			GFile* backup_directory_for_font = NULL;
			const gchar* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			gchar* file_name = NULL;
			gchar* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp42_;
			gchar* backup_file_name = NULL;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			GFile* backup_file = NULL;
			GFile* _tmp57_;
			const gchar* _tmp58_;
			GFile* _tmp59_;
			GFile* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			const gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			GFile* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			const gchar* _tmp69_;
			_tmp11_ = g_date_time_new_now_local ();
			now = _tmp11_;
			_tmp12_ = now;
			_tmp13_ = g_date_time_to_string (_tmp12_);
			time_stamp = _tmp13_;
			_tmp14_ = time_stamp;
			_tmp15_ = string_replace (_tmp14_, ":", "_");
			_g_free0 (time_stamp);
			time_stamp = _tmp15_;
			_tmp16_ = time_stamp;
			_tmp17_ = string_replace (_tmp16_, "-", "_");
			_g_free0 (time_stamp);
			time_stamp = _tmp17_;
			_tmp18_ = bird_font_font_get_file_name (self);
			fn = _tmp18_;
			_tmp19_ = fn;
			_tmp20_ = bird_font_preferences_get_backup_directory_for_font (_tmp19_);
			backup_directory_for_font = _tmp20_;
			_tmp21_ = backup_directory_for_font;
			if (!g_file_query_exists (_tmp21_, NULL)) {
				gint _error_ = 0;
				GFile* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gint _tmp25_;
				_tmp22_ = backup_directory_for_font;
				_tmp23_ = g_file_get_path (_tmp22_);
				_tmp24_ = (gchar*) _tmp23_;
				_tmp25_ = g_mkdir (_tmp24_, 0766);
				_g_free0 (_tmp24_);
				_error_ = _tmp25_;
				if (_error_ == -1) {
					FILE* _tmp26_;
					GFile* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp26_ = stderr;
					_tmp27_ = backup_directory_for_font;
					_tmp28_ = g_file_get_path (_tmp27_);
					_tmp29_ = (gchar*) _tmp28_;
					_tmp30_ = string_to_string (_tmp29_);
					_tmp31_ = g_strconcat ("Failed to create backup directory: ", _tmp30_, "\n", NULL);
					_tmp32_ = _tmp31_;
					fprintf (_tmp26_, "%s", _tmp32_);
					_g_free0 (_tmp32_);
					_g_free0 (_tmp29_);
				}
			}
			_tmp33_ = bird_font_font_get_file_name (self);
			file_name = _tmp33_;
			_tmp34_ = file_name;
			if (g_str_has_suffix (_tmp34_, ".bf")) {
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gchar* _tmp41_;
				_tmp35_ = file_name;
				_tmp36_ = file_name;
				_tmp37_ = strlen (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = strlen (".bf");
				_tmp40_ = _tmp39_;
				_tmp41_ = string_substring (_tmp35_, (glong) 0, (glong) (_tmp38_ - _tmp40_));
				_g_free0 (file_name);
				file_name = _tmp41_;
			}
			_tmp42_ = file_name;
			if (g_str_has_suffix (_tmp42_, ".birdfont")) {
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gchar* _tmp49_;
				_tmp43_ = file_name;
				_tmp44_ = file_name;
				_tmp45_ = strlen (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = strlen (".birdfont");
				_tmp48_ = _tmp47_;
				_tmp49_ = string_substring (_tmp43_, (glong) 0, (glong) (_tmp46_ - _tmp48_));
				_g_free0 (file_name);
				file_name = _tmp49_;
			}
			_tmp50_ = file_name;
			_tmp51_ = time_stamp;
			_tmp52_ = string_to_string (_tmp51_);
			_tmp53_ = g_strconcat ("-", _tmp52_, ".bf_backup", NULL);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_strconcat (_tmp50_, _tmp54_, NULL);
			_tmp56_ = _tmp55_;
			_g_free0 (_tmp54_);
			backup_file_name = _tmp56_;
			_tmp57_ = backup_directory_for_font;
			_tmp58_ = backup_file_name;
			_tmp59_ = bird_font_get_child (_tmp57_, _tmp58_);
			backup_file = _tmp59_;
			_tmp60_ = backup_file;
			_tmp61_ = g_file_get_path (_tmp60_);
			_tmp62_ = (gchar*) _tmp61_;
			_tmp63_ = string_to_string (_tmp62_);
			_tmp64_ = g_strconcat ("Saving backup to: ", _tmp63_, "\n", NULL);
			_tmp65_ = _tmp64_;
			bird_font_printd (_tmp65_);
			_g_free0 (_tmp65_);
			_g_free0 (_tmp62_);
			_tmp66_ = backup_file;
			_tmp67_ = g_file_get_path (_tmp66_);
			_tmp68_ = (gchar*) _tmp67_;
			_tmp69_ = bf_data;
			g_file_set_contents (_tmp68_, _tmp69_, (gssize) -1, &_inner_error0_);
			_g_free0 (_tmp68_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (backup_file);
				_g_free0 (backup_file_name);
				_g_free0 (file_name);
				_g_object_unref0 (backup_directory_for_font);
				_g_free0 (fn);
				_g_free0 (time_stamp);
				_g_date_time_unref0 (now);
				_g_free0 (bf_data);
				_g_free0 (path);
				_g_free0 (num_backups);
				return;
			}
			_g_object_unref0 (backup_file);
			_g_free0 (backup_file_name);
			_g_free0 (file_name);
			_g_object_unref0 (backup_directory_for_font);
			_g_free0 (fn);
			_g_free0 (time_stamp);
			_g_date_time_unref0 (now);
		}
		_g_free0 (bf_data);
		_g_free0 (path);
	}
	bird_font_font_delete_old_backups (self, backups);
	_g_free0 (num_backups);
}

GeeArrayList*
bird_font_font_get_sorted_backups (const gchar* font_file_name)
{
	GeeArrayList* backups = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp42_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (font_file_name != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	backups = _tmp0_;
	{
		GFile* backup_directory_for_font = NULL;
		GFile* _tmp1_;
		GDir* dir = NULL;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GDir* _tmp5_;
		GDir* _tmp6_;
		gchar* name = NULL;
		_tmp1_ = bird_font_preferences_get_backup_directory_for_font (font_file_name);
		backup_directory_for_font = _tmp1_;
		_tmp2_ = backup_directory_for_font;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = (gchar*) _tmp3_;
		_tmp5_ = g_dir_open (_tmp4_, (guint) 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		dir = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (backup_directory_for_font);
			goto __catch0_g_error;
		}
		name = NULL;
		while (TRUE) {
			GDir* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* file_name = NULL;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GFile* backup_file = NULL;
			GFile* _tmp23_;
			const gchar* _tmp24_;
			GFile* _tmp25_;
			gboolean _tmp26_ = FALSE;
			GFile* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gboolean _tmp30_;
			_tmp7_ = dir;
			_tmp8_ = g_dir_read_name (_tmp7_);
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (name);
			name = _tmp9_;
			_tmp10_ = name;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = name;
			_tmp12_ = g_strdup ((const gchar*) _tmp11_);
			file_name = _tmp12_;
			_tmp13_ = backup_directory_for_font;
			_tmp14_ = g_file_get_path (_tmp13_);
			_tmp15_ = (gchar*) _tmp14_;
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = g_strconcat ("backup_directory_for_font: ", _tmp16_, "\n", NULL);
			_tmp18_ = _tmp17_;
			bird_font_printd (_tmp18_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp15_);
			_tmp19_ = file_name;
			_tmp20_ = string_to_string (_tmp19_);
			_tmp21_ = g_strconcat ("file_name ", _tmp20_, "\n", NULL);
			_tmp22_ = _tmp21_;
			bird_font_printd (_tmp22_);
			_g_free0 (_tmp22_);
			_tmp23_ = backup_directory_for_font;
			_tmp24_ = file_name;
			_tmp25_ = bird_font_get_child (_tmp23_, _tmp24_);
			backup_file = _tmp25_;
			_tmp27_ = backup_file;
			_tmp28_ = g_file_get_path (_tmp27_);
			_tmp29_ = (gchar*) _tmp28_;
			_tmp30_ = g_file_test (_tmp29_, G_FILE_TEST_IS_REGULAR);
			_g_free0 (_tmp29_);
			if (_tmp30_) {
				const gchar* _tmp31_;
				_tmp31_ = file_name;
				_tmp26_ = g_str_has_suffix (_tmp31_, ".bf_backup");
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				GeeArrayList* _tmp32_;
				GFile* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp32_ = backups;
				_tmp33_ = backup_file;
				_tmp34_ = g_file_get_path (_tmp33_);
				_tmp35_ = (gchar*) _tmp34_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp35_);
				_g_free0 (_tmp35_);
			} else {
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp36_ = file_name;
				_tmp37_ = string_to_string (_tmp36_);
				_tmp38_ = g_strconcat (_tmp37_, " does not seem to be a backup file.", NULL);
				_tmp39_ = _tmp38_;
				g_warning ("Font.vala:846: %s", _tmp39_);
				_g_free0 (_tmp39_);
			}
			_g_object_unref0 (backup_file);
			_g_free0 (file_name);
		}
		_g_free0 (name);
		_g_dir_close0 (dir);
		_g_object_unref0 (backup_directory_for_font);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp40_;
		const gchar* _tmp41_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = _error_;
		_tmp41_ = _tmp40_->message;
		g_warning ("Font.vala:850: %s", _tmp41_);
		g_warning ("Font.vala:851: Can't fetch backup files.");
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (backups);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp42_ = backups;
	gee_list_sort ((GeeList*) _tmp42_, NULL, NULL, NULL);
	result = backups;
	return result;
}

void
bird_font_font_delete_old_backups (BirdFontFont* self,
                                   gint keep)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* file_name = NULL;
		gchar* _tmp0_;
		GeeArrayList* backups = NULL;
		const gchar* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* old_backups = NULL;
		GeeArrayList* _tmp3_;
		_tmp0_ = bird_font_font_get_file_name (self);
		file_name = _tmp0_;
		_tmp1_ = file_name;
		_tmp2_ = bird_font_font_get_sorted_backups (_tmp1_);
		backups = _tmp2_;
		_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		old_backups = _tmp3_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
					gchar* b = NULL;
					GeeArrayList* _tmp9_;
					gpointer _tmp10_;
					GeeArrayList* _tmp11_;
					const gchar* _tmp12_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = backups;
					_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
					_tmp8_ = _tmp7_;
					if (!(i < (_tmp8_ - keep))) {
						break;
					}
					_tmp9_ = backups;
					_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, i);
					b = (gchar*) _tmp10_;
					_tmp11_ = old_backups;
					_tmp12_ = b;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
					_g_free0 (b);
				}
			}
		}
		{
			GeeArrayList* _path_list = NULL;
			GeeArrayList* _tmp13_;
			gint _path_size = 0;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _path_index = 0;
			_tmp13_ = old_backups;
			_path_list = _tmp13_;
			_tmp14_ = _path_list;
			_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_path_size = _tmp16_;
			_path_index = -1;
			while (TRUE) {
				gint _tmp17_;
				gint _tmp18_;
				gchar* path = NULL;
				GeeArrayList* _tmp19_;
				gpointer _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				GFile* file = NULL;
				const gchar* _tmp25_;
				GFile* _tmp26_;
				GFile* _tmp27_;
				_path_index = _path_index + 1;
				_tmp17_ = _path_index;
				_tmp18_ = _path_size;
				if (!(_tmp17_ < _tmp18_)) {
					break;
				}
				_tmp19_ = _path_list;
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _path_index);
				path = (gchar*) _tmp20_;
				_tmp21_ = path;
				_tmp22_ = string_to_string (_tmp21_);
				_tmp23_ = g_strconcat ("Deleting backup: ", _tmp22_, "\n", NULL);
				_tmp24_ = _tmp23_;
				bird_font_printd (_tmp24_);
				_g_free0 (_tmp24_);
				_tmp25_ = path;
				_tmp26_ = g_file_new_for_path (_tmp25_);
				file = _tmp26_;
				_tmp27_ = file;
				g_file_delete (_tmp27_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					_g_free0 (path);
					_g_object_unref0 (old_backups);
					_g_object_unref0 (backups);
					_g_free0 (file_name);
					goto __catch0_g_error;
				}
				_g_object_unref0 (file);
				_g_free0 (path);
			}
		}
		_g_object_unref0 (old_backups);
		_g_object_unref0 (backups);
		_g_free0 (file_name);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = _error_;
		_tmp29_ = _tmp28_->message;
		g_warning ("Font.vala:876: %s", _tmp29_);
		g_warning ("Font.vala:877: Can't delet backup.");
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
bird_font_font_save_bfp (BirdFontFont* self)
{
	BirdFontBirdFontPart* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->bfp_file;
	result = bird_font_bird_font_part_save (_tmp0_);
	return result;
}

static void
bird_font_font_save_bf (BirdFontFont* self)
{
	BirdFontBirdFontFile* birdfont_file = NULL;
	BirdFontBirdFontFile* _tmp0_;
	gchar* path = NULL;
	gboolean file_written = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	BirdFontBirdFontFile* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_file_new (self);
	birdfont_file = _tmp0_;
	_tmp1_ = self->font_file;
	if (_tmp1_ == NULL) {
		g_warning ("Font.vala:891: File name not set.");
		_g_free0 (path);
		_g_object_unref0 (birdfont_file);
		return;
	}
	_tmp2_ = self->font_file;
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	_g_free0 (path);
	path = _tmp3_;
	_tmp4_ = birdfont_file;
	_tmp5_ = path;
	file_written = bird_font_bird_font_file_write_font_file (_tmp4_, _tmp5_, FALSE);
	if (self->priv->read_only) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = path;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat (_tmp7_, " is write protected.", NULL);
		_tmp9_ = _tmp8_;
		g_warning ("Font.vala:899: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (path);
		_g_object_unref0 (birdfont_file);
		return;
	}
	_tmp11_ = path;
	if (!g_str_has_suffix (_tmp11_, ".bf")) {
		const gchar* _tmp12_;
		_tmp12_ = path;
		_tmp10_ = !g_str_has_suffix (_tmp12_, ".birdfont");
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		g_warning ("Font.vala:904: Expecting .bf or .birdfont format.");
		_g_free0 (path);
		_g_object_unref0 (birdfont_file);
		return;
	}
	{
		bird_font_font_save_backups (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("Font.vala:911: %s", _tmp14_);
		g_warning ("Font.vala:912: Can't save backup.");
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		_g_object_unref0 (birdfont_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->priv->modified = FALSE;
	_g_free0 (path);
	_g_object_unref0 (birdfont_file);
}

void
bird_font_font_set_font_file (BirdFontFont* self,
                              const gchar* path)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup (path);
	_g_free0 (self->font_file);
	self->font_file = _tmp0_;
	self->priv->modified = FALSE;
}

/** Number of glyphs in this font. */
guint
bird_font_font_length (BirdFontFont* self)
{
	BirdFontGlyphTable* _tmp0_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->glyph_name;
	result = bird_font_glyph_table_length (_tmp0_);
	return result;
}

gboolean
bird_font_font_is_empty (BirdFontFont* self)
{
	BirdFontGlyphTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->glyph_name;
	result = bird_font_glyph_table_length (_tmp0_) == ((guint) 0);
	return result;
}

void
bird_font_font_set_file (BirdFontFont* self,
                         const gchar* path)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup (path);
	_g_free0 (self->font_file);
	self->font_file = _tmp0_;
}

gboolean
bird_font_font_load (BirdFontFont* self)
{
	gchar* path = NULL;
	gboolean loaded = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GeeArrayList* _tmp3_;
	BirdFontGlyphTable* _tmp4_;
	BirdFontGlyphTable* _tmp5_;
	BirdFontGlyphTable* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp11_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	gboolean _tmp28_ = FALSE;
	const gchar* _tmp29_;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp39_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	loaded = FALSE;
	self->initialised = TRUE;
	self->priv->otf_font = FALSE;
	_tmp0_ = self->font_file;
	if (_tmp0_ == NULL) {
		g_warning ("Font.vala:944: No file name.");
		result = FALSE;
		_g_free0 (path);
		return result;
	}
	_tmp1_ = self->font_file;
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	_g_free0 (path);
	path = _tmp2_;
	_tmp3_ = self->grid_width;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
	_tmp4_ = self->glyph_cache;
	bird_font_glyph_table_remove_all (_tmp4_);
	_tmp5_ = self->glyph_name;
	bird_font_glyph_table_remove_all (_tmp5_);
	_tmp6_ = self->ligature;
	bird_font_glyph_table_remove_all (_tmp6_);
	_tmp8_ = path;
	if (g_str_has_suffix (_tmp8_, ".svg")) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = path;
		_tmp7_ = g_str_has_suffix (_tmp9_, ".SVG");
	}
	if (_tmp7_) {
		const gchar* _tmp10_;
		bird_font_toolbox_select_tool_by_name ("cubic_points");
		_tmp10_ = path;
		loaded = bird_font_font_parse_svg_file (self, _tmp10_);
		if (!loaded) {
			g_warning ("Font.vala:962: Failed to load SVG font.");
		}
		self->format = BIRD_FONT_FONT_FORMAT_SVG;
	}
	_tmp11_ = path;
	if (g_str_has_suffix (_tmp11_, ".ffi")) {
		const gchar* _tmp12_;
		_tmp12_ = path;
		loaded = bird_font_font_parse_bf_file (self, _tmp12_);
		self->format = BIRD_FONT_FONT_FORMAT_FFI;
	}
	_tmp17_ = path;
	if (g_str_has_suffix (_tmp17_, ".bf")) {
		_tmp16_ = TRUE;
	} else {
		const gchar* _tmp18_;
		_tmp18_ = path;
		_tmp16_ = g_str_has_suffix (_tmp18_, ".BF");
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		const gchar* _tmp19_;
		_tmp19_ = path;
		_tmp15_ = g_str_has_suffix (_tmp19_, ".BIRDFONT");
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = path;
		_tmp14_ = g_str_has_suffix (_tmp20_, ".birdfont");
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp21_;
		_tmp21_ = path;
		_tmp13_ = g_str_has_suffix (_tmp21_, ".bf_backup");
	}
	if (_tmp13_) {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = path;
		loaded = bird_font_font_parse_bf_file (self, _tmp22_);
		self->format = BIRD_FONT_FONT_FORMAT_BIRDFONT;
		_tmp23_ = path;
		if (g_str_has_suffix (_tmp23_, ".bf_backup")) {
			_g_free0 (self->font_file);
			self->font_file = NULL;
		}
	}
	_tmp25_ = path;
	if (g_str_has_suffix (_tmp25_, ".bfp")) {
		_tmp24_ = TRUE;
	} else {
		const gchar* _tmp26_;
		_tmp26_ = path;
		_tmp24_ = g_str_has_suffix (_tmp26_, ".BFP");
	}
	if (_tmp24_) {
		const gchar* _tmp27_;
		_tmp27_ = path;
		loaded = bird_font_font_parse_bfp_file (self, _tmp27_);
		self->format = BIRD_FONT_FONT_FORMAT_BIRDFONT_PART;
	}
	_tmp29_ = path;
	if (g_str_has_suffix (_tmp29_, ".ttf")) {
		_tmp28_ = TRUE;
	} else {
		const gchar* _tmp30_;
		_tmp30_ = path;
		_tmp28_ = g_str_has_suffix (_tmp30_, ".TTF");
	}
	if (_tmp28_) {
		const gchar* _tmp31_;
		_tmp31_ = path;
		loaded = bird_font_font_parse_freetype_file (self, _tmp31_);
		if (!loaded) {
			g_warning ("Font.vala:996: Failed to load TTF font.");
		}
		self->format = BIRD_FONT_FONT_FORMAT_FREETYPE;
		if (bird_font_bird_font_has_argument ("--test")) {
			{
				BirdFontOpenFontFormatReader* or = NULL;
				BirdFontOpenFontFormatReader* _tmp32_;
				BirdFontOpenFontFormatReader* _tmp33_;
				const gchar* _tmp34_;
				_tmp32_ = bird_font_open_font_format_reader_new ();
				or = _tmp32_;
				_tmp33_ = or;
				_tmp34_ = path;
				bird_font_open_font_format_reader_parse_index (_tmp33_, _tmp34_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (or);
					goto __catch0_g_error;
				}
				_g_object_unref0 (or);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp35_;
				const gchar* _tmp36_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp35_ = e;
				_tmp36_ = _tmp35_->message;
				g_warning ("Font.vala:1007: %s", _tmp36_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp37_ = FALSE;
				_g_free0 (path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp37_;
			}
		}
		_g_free0 (self->font_file);
		self->font_file = NULL;
	}
	_tmp39_ = path;
	if (g_str_has_suffix (_tmp39_, ".otf")) {
		_tmp38_ = TRUE;
	} else {
		const gchar* _tmp40_;
		_tmp40_ = path;
		_tmp38_ = g_str_has_suffix (_tmp40_, ".OTF");
	}
	if (_tmp38_) {
		const gchar* _tmp41_;
		_tmp41_ = path;
		loaded = bird_font_font_parse_freetype_file (self, _tmp41_);
		if (!loaded) {
			g_warning ("Font.vala:1018: Failed to load OTF font.");
		}
		self->format = BIRD_FONT_FONT_FORMAT_FREETYPE;
		_g_free0 (self->font_file);
		self->font_file = NULL;
	}
	if (loaded) {
		BirdFontFontSettings* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		BirdFontKerningStrings* _tmp45_;
		_tmp42_ = self->settings;
		_tmp43_ = bird_font_font_get_file_name (self);
		_tmp44_ = _tmp43_;
		bird_font_font_settings_load (_tmp42_, _tmp44_);
		_g_free0 (_tmp44_);
		_tmp45_ = self->kerning_strings;
		bird_font_kerning_strings_load (_tmp45_, self);
		bird_font_font_add_default_characters (self);
	}
	result = loaded;
	_g_free0 (path);
	return result;
}

static gboolean
bird_font_font_parse_bfp_file (BirdFontFont* self,
                               const gchar* path)
{
	BirdFontBirdFontPart* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->bfp_file;
	result = bird_font_bird_font_part_load (_tmp0_, path);
	return result;
}

static gboolean
bird_font_font_parse_bf_file (BirdFontFont* self,
                              const gchar* path)
{
	BirdFontBirdFontFile* font = NULL;
	BirdFontBirdFontFile* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = bird_font_bird_font_file_new (self);
	font = _tmp0_;
	result = bird_font_bird_font_file_load (font, path);
	_g_object_unref0 (font);
	return result;
}

static gboolean
bird_font_font_parse_freetype_file (BirdFontFont* self,
                                    const gchar* path)
{
	gchar* font_data = NULL;
	GString* data = NULL;
	gint _error_ = 0;
	gboolean parsed = FALSE;
	BirdFontBirdFontFile* bf_font = NULL;
	BirdFontBirdFontFile* _tmp0_;
	gint _tmp1_ = 0;
	GString* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	BirdFontBirdFontFile* _tmp7_;
	const gchar* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = bird_font_bird_font_file_new (self);
	bf_font = _tmp0_;
	_tmp2_ = load_freetype_font (path, &_tmp1_);
	_error_ = _tmp1_;
	_g_string_free0 (data);
	data = _tmp2_;
	if (_error_ != 0) {
		g_warning ("Font.vala:1054: Failed to load freetype font.");
		result = FALSE;
		_g_object_unref0 (bf_font);
		_g_string_free0 (data);
		_g_free0 (font_data);
		return result;
	}
	_tmp3_ = data;
	if (_tmp3_ == NULL) {
		g_warning ("Font.vala:1059: No svg data.");
		result = FALSE;
		_g_object_unref0 (bf_font);
		_g_string_free0 (data);
		_g_free0 (font_data);
		return result;
	}
	_tmp4_ = data;
	_tmp5_ = ((GString*) _tmp4_)->str;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (font_data);
	font_data = _tmp6_;
	_tmp7_ = bf_font;
	_tmp8_ = font_data;
	parsed = bird_font_bird_font_file_load_data (_tmp7_, _tmp8_);
	if (!parsed) {
		g_warning ("Font.vala:1067: Failed to parse loaded freetype font.");
	}
	result = parsed;
	_g_object_unref0 (bf_font);
	_g_string_free0 (data);
	_g_free0 (font_data);
	return result;
}

static gboolean
bird_font_font_parse_svg_file (BirdFontFont* self,
                               const gchar* path)
{
	BirdFontSvgFont* svg_font = NULL;
	BirdFontSvgFont* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = bird_font_svg_font_new (self);
	svg_font = _tmp0_;
	bird_font_svg_font_load (svg_font, path);
	result = TRUE;
	_g_object_unref0 (svg_font);
	return result;
}

gboolean
bird_font_font_parse_otf_file (BirdFontFont* self,
                               const gchar* path,
                               GError** error)
{
	BirdFontOpenFontFormatReader* _tmp0_;
	BirdFontOpenFontFormatReader* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = bird_font_open_font_format_reader_new ();
	_g_object_unref0 (self->priv->otf);
	self->priv->otf = _tmp0_;
	self->priv->otf_font = TRUE;
	_tmp1_ = self->priv->otf;
	bird_font_open_font_format_reader_parse_index (_tmp1_, path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = TRUE;
	return result;
}

void
bird_font_font_set_read_only (BirdFontFont* self,
                              gboolean r)
{
	g_return_if_fail (self != NULL);
	self->priv->read_only = r;
}

/** 
 * @param glyphs Name of glyphs or unicode values separated by space.
 * @return glyph names
 */
GeeArrayList*
bird_font_font_get_names (BirdFontFont* self,
                          const gchar* glyphs)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (glyphs != NULL, NULL);
	_tmp0_ = bird_font_font_get_names_order (self, glyphs, FALSE);
	result = _tmp0_;
	return result;
}

GeeArrayList*
bird_font_font_get_names_in_reverse_order (BirdFontFont* self,
                                           const gchar* glyphs)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (glyphs != NULL, NULL);
	_tmp0_ = bird_font_font_get_names_order (self, glyphs, TRUE);
	result = _tmp0_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

GeeArrayList*
bird_font_font_get_names_order (BirdFontFont* self,
                                const gchar* glyphs,
                                gboolean reverse)
{
	GeeArrayList* names = NULL;
	GeeArrayList* _tmp0_;
	gchar** parts = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (glyphs != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	names = _tmp0_;
	_tmp1_ = string_strip (glyphs);
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_free0 (_tmp2_);
	parts = _tmp5_;
	parts_length1 = _tmp5__length1;
	_parts_size_ = parts_length1;
	_tmp6_ = parts;
	_tmp6__length1 = parts_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp6_;
		p_collection_length1 = _tmp6__length1;
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			gchar* _tmp7_;
			gchar* p = NULL;
			_tmp7_ = g_strdup (p_collection[p_it]);
			p = _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				const gchar* _tmp9_;
				const gchar* _tmp13_;
				const gchar* _tmp15_;
				const gchar* _tmp17_;
				const gchar* _tmp27_;
				_tmp9_ = p;
				if (g_str_has_prefix (_tmp9_, "U+")) {
					_tmp8_ = TRUE;
				} else {
					const gchar* _tmp10_;
					_tmp10_ = p;
					_tmp8_ = g_str_has_prefix (_tmp10_, "u+");
				}
				if (_tmp8_) {
					const gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp11_ = p;
					_tmp12_ = g_unichar_to_string (bird_font_font_to_unichar (_tmp11_));
					_g_free0 (p);
					p = (gchar*) _tmp12_;
				}
				_tmp13_ = p;
				if (g_strcmp0 (_tmp13_, "space") == 0) {
					gchar* _tmp14_;
					_tmp14_ = g_strdup (" ");
					_g_free0 (p);
					p = _tmp14_;
				}
				_tmp15_ = p;
				if (g_strcmp0 (_tmp15_, "divis") == 0) {
					gchar* _tmp16_;
					_tmp16_ = g_strdup ("-");
					_g_free0 (p);
					p = _tmp16_;
				}
				_tmp17_ = p;
				if (!bird_font_font_has_glyph (self, _tmp17_)) {
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp18_ = p;
					_tmp19_ = string_to_string (_tmp18_);
					_tmp20_ = g_strconcat ("The character ", _tmp19_, " does not have a glyph in ", NULL);
					_tmp21_ = _tmp20_;
					_tmp22_ = bird_font_font_get_file_name (self);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
					_tmp25_ = _tmp24_;
					g_warning ("Font.vala:1120: %s", _tmp25_);
					_g_free0 (_tmp25_);
					_g_free0 (_tmp23_);
					_g_free0 (_tmp21_);
					_tmp26_ = g_strdup (".notdef");
					_g_free0 (p);
					p = _tmp26_;
				}
				_tmp27_ = p;
				if (g_strcmp0 (_tmp27_, "") != 0) {
					if (reverse) {
						GeeArrayList* _tmp28_;
						const gchar* _tmp29_;
						_tmp28_ = names;
						_tmp29_ = p;
						gee_abstract_list_insert ((GeeAbstractList*) _tmp28_, 0, _tmp29_);
					} else {
						GeeArrayList* _tmp30_;
						const gchar* _tmp31_;
						_tmp30_ = names;
						_tmp31_ = p;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
					}
				}
				_g_free0 (p);
			}
		}
	}
	result = names;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

gunichar
bird_font_font_to_unichar (const gchar* unicode)
{
	gint index = 0;
	gint i = 0;
	gunichar c = 0U;
	gunichar rc = 0U;
	gboolean r = FALSE;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gunichar result;
	g_return_val_if_fail (unicode != NULL, 0U);
	index = 2;
	i = 0;
	rc = (gunichar) 0;
	if (!g_str_has_prefix (unicode, "U+")) {
		_tmp0_ = !g_str_has_prefix (unicode, "u+");
	} else {
		_tmp0_ = FALSE;
	}
	if (G_UNLIKELY (_tmp0_)) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = string_to_string (unicode);
		_tmp2_ = g_strconcat ("All unicode values must begin with U+ (", _tmp1_, ")", NULL);
		_tmp3_ = _tmp2_;
		g_warning ("Font.vala:1144: %s", _tmp3_);
		_g_free0 (_tmp3_);
		result = (gunichar) '\0';
		return result;
	}
	{
		while (TRUE) {
			gunichar _tmp4_ = 0U;
			gboolean _tmp5_;
			guint8 _tmp6_ = 0U;
			gint _tmp8_;
			_tmp5_ = string_get_next_char (unicode, &index, &_tmp4_);
			c = _tmp4_;
			r = _tmp5_;
			if (!r) {
				break;
			}
			rc <<= (gunichar) 4;
			_tmp6_ = bird_font_font_hex_to_oct (c, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gunichar _tmp7_ = 0U;
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp7_;
			}
			rc += (gunichar) _tmp6_;
			i = i + 1;
			_tmp8_ = i;
			if (_tmp8_ > 6) {
				GError* _tmp9_;
				gunichar _tmp10_ = 0U;
				_tmp9_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, "i > 6");
				_inner_error0_ = _tmp9_;
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp10_;
			}
		}
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = string_to_string (unicode);
		_tmp12_ = g_strconcat ("unicode: ", _tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		g_warning ("Font.vala:1158: %s", _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("Font.vala:1159: %s", _tmp15_);
		rc = (gunichar) '\0';
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gunichar _tmp16_ = 0U;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp16_;
	}
	result = rc;
	return result;
}

static gchar*
bird_font_font_oct_to_hex (guint8 o)
{
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	switch (o) {
		case 10:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("a");
			result = _tmp0_;
			return result;
		}
		case 11:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("b");
			result = _tmp1_;
			return result;
		}
		case 12:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("c");
			result = _tmp2_;
			return result;
		}
		case 13:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("d");
			result = _tmp3_;
			return result;
		}
		case 14:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("e");
			result = _tmp4_;
			return result;
		}
		case 15:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("f");
			result = _tmp5_;
			return result;
		}
		default:
		break;
	}
	_tmp6_ = (gint) o;
	_tmp7_ = g_strdup ("-");
	_tmp8_ = _tmp7_;
	g_return_val_if_fail ((0 <= _tmp6_) && (_tmp6_ <= 9), _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = g_strdup_printf ("%hhu", o);
	result = _tmp9_;
	return result;
}

static guint8
bird_font_font_hex_to_oct (gunichar o,
                           GError** error)
{
	GString* s = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gunichar _tmp2_;
	GError* _inner_error0_ = NULL;
	guint8 result;
	_tmp0_ = g_string_new ("");
	s = _tmp0_;
	_tmp1_ = s;
	g_string_append_unichar (_tmp1_, o);
	switch (o) {
		case 'a':
		{
			result = (guint8) 10;
			_g_string_free0 (s);
			return result;
		}
		case 'b':
		{
			result = (guint8) 11;
			_g_string_free0 (s);
			return result;
		}
		case 'c':
		{
			result = (guint8) 12;
			_g_string_free0 (s);
			return result;
		}
		case 'd':
		{
			result = (guint8) 13;
			_g_string_free0 (s);
			return result;
		}
		case 'e':
		{
			result = (guint8) 14;
			_g_string_free0 (s);
			return result;
		}
		case 'f':
		{
			result = (guint8) 15;
			_g_string_free0 (s);
			return result;
		}
		case 'A':
		{
			result = (guint8) 10;
			_g_string_free0 (s);
			return result;
		}
		case 'B':
		{
			result = (guint8) 11;
			_g_string_free0 (s);
			return result;
		}
		case 'C':
		{
			result = (guint8) 12;
			_g_string_free0 (s);
			return result;
		}
		case 'D':
		{
			result = (guint8) 13;
			_g_string_free0 (s);
			return result;
		}
		case 'E':
		{
			result = (guint8) 14;
			_g_string_free0 (s);
			return result;
		}
		case 'F':
		{
			result = (guint8) 15;
			_g_string_free0 (s);
			return result;
		}
		default:
		break;
	}
	_tmp2_ = o;
	if (!((((gunichar) '0') <= _tmp2_) && (_tmp2_ <= ((gunichar) '9')))) {
		GString* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp3_ = s;
		_tmp4_ = _tmp3_->str;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Expecting a number (", _tmp5_, ").", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error0_ = _tmp9_;
		if (_inner_error0_->domain == G_CONVERT_ERROR) {
			guint8 _tmp10_ = 0U;
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (s);
			return _tmp10_;
		} else {
			guint8 _tmp11_ = 0U;
			_g_string_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
	}
	result = (guint8) (o - '0');
	_g_string_free0 (s);
	return result;
}

gchar*
bird_font_font_to_hex (gunichar ch)
{
	GString* s = NULL;
	GString* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_string_new ("");
	s = _tmp0_;
	g_string_append (s, "U+");
	_tmp1_ = bird_font_font_to_hex_code (ch);
	_tmp2_ = _tmp1_;
	g_string_append (s, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = s->str;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	_g_string_free0 (s);
	return result;
}

gchar*
bird_font_font_to_hex_code (gunichar ch)
{
	GString* s = NULL;
	GString* _tmp0_;
	gboolean has_ef = FALSE;
	guint8 a = 0U;
	guint8 b = 0U;
	guint8 c = 0U;
	guint8 d = 0U;
	guint8 e = 0U;
	guint8 f = 0U;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GString* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GString* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GString* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* result;
	_tmp0_ = g_string_new ("");
	s = _tmp0_;
	has_ef = FALSE;
	a = (guint8) (ch & 0x00000F);
	b = (guint8) ((ch & 0x0000F0) >> (4 * 1));
	c = (guint8) ((ch & 0x000F00) >> (4 * 2));
	d = (guint8) ((ch & 0x00F000) >> (4 * 3));
	e = (guint8) ((ch & 0x0F0000) >> (4 * 4));
	f = (guint8) ((ch & 0xF00000) >> (4 * 5));
	if (((gint) e) != 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = ((gint) f) != 0;
	}
	if (_tmp1_) {
		GString* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GString* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = s;
		_tmp3_ = bird_font_font_oct_to_hex (f);
		_tmp4_ = _tmp3_;
		g_string_append (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = s;
		_tmp6_ = bird_font_font_oct_to_hex (e);
		_tmp7_ = _tmp6_;
		g_string_append (_tmp5_, _tmp7_);
		_g_free0 (_tmp7_);
		has_ef = TRUE;
	}
	if (((gint) c) != 0) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = ((gint) d) != 0;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = has_ef;
	}
	if (_tmp8_) {
		GString* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GString* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp10_ = s;
		_tmp11_ = bird_font_font_oct_to_hex (d);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
		_tmp13_ = s;
		_tmp14_ = bird_font_font_oct_to_hex (c);
		_tmp15_ = _tmp14_;
		g_string_append (_tmp13_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = s;
	_tmp17_ = bird_font_font_oct_to_hex (b);
	_tmp18_ = _tmp17_;
	g_string_append (_tmp16_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = s;
	_tmp20_ = bird_font_font_oct_to_hex (a);
	_tmp21_ = _tmp20_;
	g_string_append (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = s;
	_tmp23_ = _tmp22_->str;
	_tmp24_ = g_strdup (_tmp23_);
	result = _tmp24_;
	_g_string_free0 (s);
	return result;
}

static void
bird_font_font_class_init (BirdFontFontClass * klass,
                           gpointer klass_data)
{
	bird_font_font_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontFont_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_font_finalize;
	bird_font_font_signals[BIRD_FONT_FONT_FONT_DELETED_SIGNAL] = g_signal_new ("font-deleted", BIRD_FONT_TYPE_FONT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bird_font_font_instance_init (BirdFontFont * self,
                              gpointer klass)
{
	gchar* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = bird_font_font_get_instance_private (self);
	_tmp0_ = g_strdup ("1");
	self->background_scale = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_LINE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->custom_guides = _tmp1_;
	self->font_file = NULL;
	self->export_directory = NULL;
	self->priv->modified = FALSE;
	self->bold = FALSE;
	self->italic = FALSE;
	self->weight = 400;
	self->italic_angle = (gdouble) 0;
	self->initialised = TRUE;
	self->priv->otf_font = FALSE;
	self->format = BIRD_FONT_FONT_FORMAT_BIRDFONT;
	self->priv->read_only = FALSE;
	self->priv->bfp = FALSE;
	self->format_major = 0;
	self->format_minor = 0;
	self->units_per_em = 1024;
	self->has_svg = FALSE;
}

static void
bird_font_font_finalize (GObject * obj)
{
	BirdFontFont * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_FONT, BirdFontFont);
	g_signal_emit (self, bird_font_font_signals[BIRD_FONT_FONT_FONT_DELETED_SIGNAL], 0);
	_g_object_unref0 (self->glyph_cache);
	_g_object_unref0 (self->glyph_name);
	_g_object_unref0 (self->ligature);
	_g_object_unref0 (self->alternates);
	_g_object_unref0 (self->background_images);
	_g_free0 (self->background_scale);
	_g_object_unref0 (self->custom_guides);
	_g_free0 (self->font_file);
	_g_free0 (self->export_directory);
	_g_free0 (self->postscript_name);
	_g_free0 (self->name);
	_g_free0 (self->subfamily);
	_g_free0 (self->full_name);
	_g_free0 (self->unique_identifier);
	_g_free0 (self->version);
	_g_free0 (self->description);
	_g_free0 (self->copyright);
	_g_free0 (self->license);
	_g_free0 (self->license_url);
	_g_free0 (self->trademark);
	_g_free0 (self->manufacturer);
	_g_free0 (self->designer);
	_g_free0 (self->vendor_url);
	_g_free0 (self->designer_url);
	_g_object_unref0 (self->priv->otf);
	_g_object_unref0 (self->grid_width);
	_g_object_unref0 (self->spacing);
	_g_object_unref0 (self->priv->bfp_file);
	_g_object_unref0 (self->deleted_glyphs);
	_g_object_unref0 (self->ligature_substitution);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->kerning_strings);
	G_OBJECT_CLASS (bird_font_font_parent_class)->finalize (obj);
}

static GType
bird_font_font_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontFontClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_font_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontFont), 0, (GInstanceInitFunc) bird_font_font_instance_init, NULL };
	GType bird_font_font_type_id;
	bird_font_font_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontFont", &g_define_type_info, 0);
	BirdFontFont_private_offset = g_type_add_instance_private (bird_font_font_type_id, sizeof (BirdFontFontPrivate));
	return bird_font_font_type_id;
}

GType
bird_font_font_get_type (void)
{
	static volatile gsize bird_font_font_type_id__once = 0;
	if (g_once_init_enter (&bird_font_font_type_id__once)) {
		GType bird_font_font_type_id;
		bird_font_font_type_id = bird_font_font_get_type_once ();
		g_once_init_leave (&bird_font_font_type_id__once, bird_font_font_type_id);
	}
	return bird_font_font_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

