/* FileDialogTab.c generated by valac 0.56.16, the Vala compiler
 * generated from FileDialogTab.vala, do not modify */

/*
Copyright (C) 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#define BIRD_FONT_FILE_DIALOG_TAB_DIRECTORY -3
#define BIRD_FONT_FILE_DIALOG_TAB_FILE -2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_FILE_DIALOG_TAB_0_PROPERTY,
	BIRD_FONT_FILE_DIALOG_TAB_NUM_PROPERTIES
};
static GParamSpec* bird_font_file_dialog_tab_properties[BIRD_FONT_FILE_DIALOG_TAB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE (bird_font_file_dialog_tab_selected_file_get_type ())
#define BIRD_FONT_FILE_DIALOG_TAB_SELECTED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE, BirdFontFileDialogTabSelectedFile))
#define BIRD_FONT_FILE_DIALOG_TAB_SELECTED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE, BirdFontFileDialogTabSelectedFileClass))
#define BIRD_FONT_FILE_DIALOG_TAB_IS_SELECTED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE))
#define BIRD_FONT_FILE_DIALOG_TAB_IS_SELECTED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE))
#define BIRD_FONT_FILE_DIALOG_TAB_SELECTED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE, BirdFontFileDialogTabSelectedFileClass))

typedef struct _BirdFontFileDialogTabSelectedFile BirdFontFileDialogTabSelectedFile;
typedef struct _BirdFontFileDialogTabSelectedFileClass BirdFontFileDialogTabSelectedFileClass;
typedef struct _BirdFontFileDialogTabSelectedFilePrivate BirdFontFileDialogTabSelectedFilePrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BIRD_FONT_FILE_DIALOG_TAB_SELECTED_FILE_0_PROPERTY,
	BIRD_FONT_FILE_DIALOG_TAB_SELECTED_FILE_NUM_PROPERTIES
};
static GParamSpec* bird_font_file_dialog_tab_selected_file_properties[BIRD_FONT_FILE_DIALOG_TAB_SELECTED_FILE_NUM_PROPERTIES];

struct _BirdFontFileDialogTabPrivate {
	GeeArrayList* rows;
	GeeArrayList* files;
	GeeArrayList* directories;
	gchar* title;
	BirdFontFileChooser* action;
	GFile* current_dir;
	gchar* selected_filename;
	BirdFontTextListener* listener;
	gboolean select_folder;
};

struct _BirdFontFileDialogTabSelectedFile {
	GObject parent_instance;
	BirdFontFileDialogTabSelectedFilePrivate * priv;
	gchar* file_name;
};

struct _BirdFontFileDialogTabSelectedFileClass {
	GObjectClass parent_class;
};

static gint BirdFontFileDialogTab_private_offset;
static gpointer bird_font_file_dialog_tab_parent_class = NULL;
static gboolean bird_font_file_dialog_tab_has_drive_letters;
static gboolean bird_font_file_dialog_tab_has_drive_letters = FALSE;
static GeeArrayList* bird_font_file_dialog_tab_drive_letters;
static GeeArrayList* bird_font_file_dialog_tab_drive_letters = NULL;
static gpointer bird_font_file_dialog_tab_selected_file_parent_class = NULL;

static void bird_font_file_dialog_tab_real_update_rows (BirdFontTable* base);
static BirdFontFileDialogTabSelectedFile* bird_font_file_dialog_tab_selected_file_new (const gchar* fn);
static BirdFontFileDialogTabSelectedFile* bird_font_file_dialog_tab_selected_file_construct (GType object_type,
                                                                                      const gchar* fn);
static GType bird_font_file_dialog_tab_selected_file_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GeeArrayList* bird_font_file_dialog_tab_real_get_rows (BirdFontTable* base);
static void bird_font_file_dialog_tab_real_selected_row (BirdFontTable* base,
                                                  BirdFontRow* row,
                                                  gint column,
                                                  gboolean delete_button);
static void bird_font_file_dialog_tab_real_selected_canvas (BirdFontFontDisplay* base);
static void __lambda409_ (BirdFontFileDialogTab* self,
                   const gchar* text);
static void ___lambda409__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda410_ (BirdFontFileDialogTab* self);
static void ___lambda410__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static void bird_font_file_dialog_tab_real_double_click (BirdFontFontDisplay* base,
                                                  guint button,
                                                  gdouble ex,
                                                  gdouble ey);
static gchar* bird_font_file_dialog_tab_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_file_dialog_tab_real_get_name (BirdFontFontDisplay* base);
static void bird_font_file_dialog_tab_real_button_release (BirdFontFontDisplay* base,
                                                    gint button,
                                                    gdouble ex,
                                                    gdouble ey);
static void bird_font_file_dialog_tab_selected_file_finalize (GObject * obj);
static GType bird_font_file_dialog_tab_selected_file_get_type_once (void);
static void bird_font_file_dialog_tab_finalize (GObject * obj);
static GType bird_font_file_dialog_tab_get_type_once (void);

static inline gpointer
bird_font_file_dialog_tab_get_instance_private (BirdFontFileDialogTab* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontFileDialogTab_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontFileDialogTab*
bird_font_file_dialog_tab_construct (GType object_type,
                                     const gchar* title,
                                     BirdFontFileChooser* action,
                                     gboolean folder)
{
	BirdFontFileDialogTab * self = NULL;
	gchar* _tmp0_;
	BirdFontFileChooser* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (BirdFontFileDialogTab*) bird_font_table_construct (object_type);
	_tmp0_ = g_strdup (title);
	_g_free0 (self->priv->title);
	self->priv->title = _tmp0_;
	_tmp1_ = _g_object_ref0 (action);
	_g_object_unref0 (self->priv->action);
	self->priv->action = _tmp1_;
	self->priv->select_folder = folder;
	_tmp2_ = gee_array_list_new (BIRD_FONT_TYPE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->rows);
	self->priv->rows = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->files);
	self->priv->files = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->directories);
	self->priv->directories = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->selected_filename);
	self->priv->selected_filename = _tmp5_;
	bird_font_font_display_selected_canvas ((BirdFontFontDisplay*) self);
	return self;
}

BirdFontFileDialogTab*
bird_font_file_dialog_tab_new (const gchar* title,
                               BirdFontFileChooser* action,
                               gboolean folder)
{
	return bird_font_file_dialog_tab_construct (BIRD_FONT_TYPE_FILE_DIALOG_TAB, title, action, folder);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_file_dialog_tab_add_drive_letter (gchar c)
{
	GeeArrayList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	if (!bird_font_file_dialog_tab_has_drive_letters) {
		GeeArrayList* _tmp0_;
		_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (bird_font_file_dialog_tab_drive_letters);
		bird_font_file_dialog_tab_drive_letters = _tmp0_;
		bird_font_file_dialog_tab_has_drive_letters = TRUE;
	}
	_tmp1_ = bird_font_file_dialog_tab_drive_letters;
	_tmp2_ = g_strdup_printf ("%c", c);
	_tmp3_ = (gchar*) _tmp2_;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat (_tmp4_, ":\\", NULL);
	_tmp6_ = _tmp5_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
}

static void
bird_font_file_dialog_tab_real_update_rows (BirdFontTable* base)
{
	BirdFontFileDialogTab * self;
	BirdFontRow* row = NULL;
	GeeArrayList* _tmp0_;
	BirdFontRow* _tmp1_;
	GeeArrayList* _tmp2_;
	BirdFontRow* _tmp3_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeArrayList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	self = (BirdFontFileDialogTab*) base;
	_tmp0_ = self->priv->rows;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = bird_font_row_new_headline ("");
	_g_object_unref0 (row);
	row = _tmp1_;
	_tmp2_ = self->priv->rows;
	_tmp3_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
	if (self->priv->select_folder) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		BirdFontRow* _tmp6_;
		_tmp4_ = bird_font_t_ ("Select a Folder");
		_tmp5_ = _tmp4_;
		_tmp6_ = bird_font_row_new_headline (_tmp5_);
		_g_object_unref0 (row);
		row = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = self->priv->directories;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > 0) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		BirdFontRow* _tmp12_;
		GeeArrayList* _tmp13_;
		BirdFontRow* _tmp14_;
		_tmp10_ = bird_font_t_ ("Folders");
		_tmp11_ = _tmp10_;
		_tmp12_ = bird_font_row_new_headline (_tmp11_);
		_g_object_unref0 (row);
		row = _tmp12_;
		_g_free0 (_tmp11_);
		_tmp13_ = self->priv->rows;
		_tmp14_ = row;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
	}
	{
		GeeArrayList* _dir_list = NULL;
		GeeArrayList* _tmp15_;
		gint _dir_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _dir_index = 0;
		_tmp15_ = self->priv->directories;
		_dir_list = _tmp15_;
		_tmp16_ = _dir_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_dir_size = _tmp18_;
		_dir_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			gchar* dir = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			const gchar* _tmp23_;
			BirdFontRow* _tmp24_;
			BirdFontRow* _tmp25_;
			const gchar* _tmp26_;
			BirdFontFileDialogTabSelectedFile* _tmp27_;
			BirdFontFileDialogTabSelectedFile* _tmp28_;
			GeeArrayList* _tmp29_;
			BirdFontRow* _tmp30_;
			_dir_index = _dir_index + 1;
			_tmp19_ = _dir_index;
			_tmp20_ = _dir_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _dir_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _dir_index);
			dir = (gchar*) _tmp22_;
			_tmp23_ = dir;
			_tmp24_ = bird_font_row_new_columns_1 (_tmp23_, BIRD_FONT_FILE_DIALOG_TAB_DIRECTORY, FALSE);
			_g_object_unref0 (row);
			row = _tmp24_;
			_tmp25_ = row;
			_tmp26_ = dir;
			_tmp27_ = bird_font_file_dialog_tab_selected_file_new (_tmp26_);
			_tmp28_ = _tmp27_;
			bird_font_row_set_row_data (_tmp25_, (GObject*) _tmp28_);
			_g_object_unref0 (_tmp28_);
			_tmp29_ = self->priv->rows;
			_tmp30_ = row;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp30_);
			_g_free0 (dir);
		}
	}
	_tmp31_ = self->priv->files;
	_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > 0) {
		gchar* _tmp34_;
		gchar* _tmp35_;
		BirdFontRow* _tmp36_;
		GeeArrayList* _tmp37_;
		BirdFontRow* _tmp38_;
		_tmp34_ = bird_font_t_ ("Files");
		_tmp35_ = _tmp34_;
		_tmp36_ = bird_font_row_new_headline (_tmp35_);
		_g_object_unref0 (row);
		row = _tmp36_;
		_g_free0 (_tmp35_);
		_tmp37_ = self->priv->rows;
		_tmp38_ = row;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp38_);
	}
	{
		GeeArrayList* _f_list = NULL;
		GeeArrayList* _tmp39_;
		gint _f_size = 0;
		GeeArrayList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _f_index = 0;
		_tmp39_ = self->priv->files;
		_f_list = _tmp39_;
		_tmp40_ = _f_list;
		_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_f_size = _tmp42_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			gchar* f = NULL;
			GeeArrayList* _tmp45_;
			gpointer _tmp46_;
			const gchar* _tmp47_;
			BirdFontRow* _tmp48_;
			BirdFontRow* _tmp49_;
			const gchar* _tmp50_;
			BirdFontFileDialogTabSelectedFile* _tmp51_;
			BirdFontFileDialogTabSelectedFile* _tmp52_;
			GeeArrayList* _tmp53_;
			BirdFontRow* _tmp54_;
			_f_index = _f_index + 1;
			_tmp43_ = _f_index;
			_tmp44_ = _f_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _f_list;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _f_index);
			f = (gchar*) _tmp46_;
			_tmp47_ = f;
			_tmp48_ = bird_font_row_new_columns_1 (_tmp47_, BIRD_FONT_FILE_DIALOG_TAB_FILE, FALSE);
			_g_object_unref0 (row);
			row = _tmp48_;
			_tmp49_ = row;
			_tmp50_ = f;
			_tmp51_ = bird_font_file_dialog_tab_selected_file_new (_tmp50_);
			_tmp52_ = _tmp51_;
			bird_font_row_set_row_data (_tmp49_, (GObject*) _tmp52_);
			_g_object_unref0 (_tmp52_);
			_tmp53_ = self->priv->rows;
			_tmp54_ = row;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, _tmp54_);
			_g_free0 (f);
		}
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (row);
}

static GeeArrayList*
bird_font_file_dialog_tab_real_get_rows (BirdFontTable* base)
{
	BirdFontFileDialogTab * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	self = (BirdFontFileDialogTab*) base;
	_tmp0_ = self->priv->rows;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
bird_font_file_dialog_tab_real_selected_row (BirdFontTable* base,
                                             BirdFontRow* row,
                                             gint column,
                                             gboolean delete_button)
{
	BirdFontFileDialogTab * self;
	BirdFontFileDialogTabSelectedFile* f = NULL;
	const gchar* _tmp41_;
	self = (BirdFontFileDialogTab*) base;
	g_return_if_fail (row != NULL);
	if (bird_font_row_get_index (row) == BIRD_FONT_FILE_DIALOG_TAB_FILE) {
		if (!self->priv->select_folder) {
			GObject* _tmp0_;
			GObject* _tmp1_;
			GObject* _tmp2_;
			BirdFontFileDialogTabSelectedFile* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp0_ = bird_font_row_get_row_data (row);
			_tmp1_ = _tmp0_;
			g_return_if_fail (BIRD_FONT_FILE_DIALOG_TAB_IS_SELECTED_FILE (_tmp1_));
			_g_object_unref0 (_tmp1_);
			_tmp2_ = bird_font_row_get_row_data (row);
			_g_object_unref0 (f);
			f = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE, BirdFontFileDialogTabSelectedFile);
			_tmp3_ = f;
			_tmp4_ = _tmp3_->file_name;
			_tmp5_ = g_strdup (_tmp4_);
			_g_free0 (self->priv->selected_filename);
			self->priv->selected_filename = _tmp5_;
		}
	} else {
		if (bird_font_row_get_index (row) == BIRD_FONT_FILE_DIALOG_TAB_DIRECTORY) {
			GObject* _tmp6_;
			GObject* _tmp7_;
			GObject* _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp6_ = bird_font_row_get_row_data (row);
			_tmp7_ = _tmp6_;
			g_return_if_fail (BIRD_FONT_FILE_DIALOG_TAB_IS_SELECTED_FILE (_tmp7_));
			_g_object_unref0 (_tmp7_);
			_tmp8_ = bird_font_row_get_row_data (row);
			_g_object_unref0 (f);
			f = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE, BirdFontFileDialogTabSelectedFile);
			if (self->priv->select_folder) {
				BirdFontFileDialogTabSelectedFile* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = f;
				_tmp11_ = _tmp10_->file_name;
				_tmp9_ = g_strcmp0 (_tmp11_, "..") != 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				BirdFontFileDialogTabSelectedFile* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = f;
				_tmp13_ = _tmp12_->file_name;
				_tmp14_ = g_strdup (_tmp13_);
				_g_free0 (self->priv->selected_filename);
				self->priv->selected_filename = _tmp14_;
			} else {
				BirdFontFileDialogTabSelectedFile* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp40_;
				_tmp15_ = f;
				_tmp16_ = _tmp15_->file_name;
				if (string_index_of (_tmp16_, ":", 0) > -1) {
					BirdFontFileDialogTabSelectedFile* _tmp17_;
					const gchar* _tmp18_;
					_tmp17_ = f;
					_tmp18_ = _tmp17_->file_name;
					bird_font_file_dialog_tab_propagate_files (self, _tmp18_);
				} else {
					gchar* d = NULL;
					GFile* _tmp19_;
					gchar* _tmp20_;
					BirdFontFileDialogTabSelectedFile* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* p = NULL;
					const gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					BirdFontFileDialogTabSelectedFile* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					const gchar* _tmp39_;
					_tmp19_ = self->priv->current_dir;
					_tmp20_ = g_file_get_path (_tmp19_);
					d = (gchar*) _tmp20_;
					_tmp21_ = f;
					_tmp22_ = _tmp21_->file_name;
					_tmp23_ = string_to_string (_tmp22_);
					_tmp24_ = d;
					_tmp25_ = string_to_string (_tmp24_);
					_tmp26_ = string_to_string (BIRD_FONT_FILE_DIALOG_TAB_path_separator);
					_tmp27_ = g_strconcat ("Subdir: ", _tmp23_, " in ", _tmp25_, " path_separator: ", _tmp26_, "\n", NULL);
					_tmp28_ = _tmp27_;
					bird_font_printd (_tmp28_);
					_g_free0 (_tmp28_);
					_tmp29_ = d;
					_tmp30_ = g_strconcat (_tmp29_, BIRD_FONT_FILE_DIALOG_TAB_path_separator, NULL);
					_tmp31_ = _tmp30_;
					_tmp32_ = f;
					_tmp33_ = _tmp32_->file_name;
					_tmp34_ = g_strconcat (_tmp31_, _tmp33_, NULL);
					_tmp35_ = _tmp34_;
					_g_free0 (_tmp31_);
					p = _tmp35_;
					while (TRUE) {
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						gchar* _tmp38_;
						_tmp36_ = p;
						if (!(string_index_of (_tmp36_, "\\\\", 0) != -1)) {
							break;
						}
						_tmp37_ = p;
						_tmp38_ = string_replace (_tmp37_, "\\\\", "\\");
						_g_free0 (p);
						p = _tmp38_;
					}
					_tmp39_ = p;
					bird_font_file_dialog_tab_propagate_files (self, _tmp39_);
					_g_free0 (p);
					_g_free0 (d);
				}
				_tmp40_ = g_strdup ("");
				_g_free0 (self->priv->selected_filename);
				self->priv->selected_filename = _tmp40_;
			}
		}
	}
	_tmp41_ = self->priv->selected_filename;
	bird_font_file_dialog_tab_show_text_area (self, _tmp41_);
	_g_object_unref0 (f);
}

static void
bird_font_file_dialog_tab_real_selected_canvas (BirdFontFontDisplay* base)
{
	BirdFontFileDialogTab * self;
	gchar* d = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp4_;
	self = (BirdFontFileDialogTab*) base;
	bird_font_file_dialog_tab_show_text_area (self, "");
	_tmp0_ = bird_font_preferences_get ("file_dialog_dir");
	_g_free0 (d);
	d = _tmp0_;
	_tmp1_ = d;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_get_home_dir ();
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (d);
		d = _tmp3_;
	}
	_tmp4_ = d;
	bird_font_file_dialog_tab_propagate_files (self, _tmp4_);
	BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_file_dialog_tab_parent_class)->selected_canvas ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TABLE, BirdFontTable));
	_g_free0 (d);
}

void
bird_font_file_dialog_tab_propagate_files (BirdFontFileDialogTab* self,
                                           const gchar* dir)
{
	GFileEnumerator* enumerator = NULL;
	GFileInfo* file_info = NULL;
	gchar* fn = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp9_;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp41_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = string_to_string (dir);
	_tmp1_ = g_strconcat ("Propagate_files in directory: ", _tmp0_, "\n", NULL);
	_tmp2_ = _tmp1_;
	bird_font_printd (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->files;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
	_tmp4_ = self->priv->directories;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
	_tmp5_ = g_file_new_for_path (dir);
	_g_object_unref0 (self->priv->current_dir);
	self->priv->current_dir = _tmp5_;
	bird_font_preferences_set ("file_dialog_dir", dir);
	_tmp6_ = self->priv->current_dir;
	_tmp7_ = g_file_get_parent (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != NULL;
	_g_object_unref0 (_tmp8_);
	if (_tmp9_) {
		GeeArrayList* _tmp10_;
		_tmp10_ = self->priv->directories;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "..");
	}
	{
		GFileEnumerator* _tmp11_ = NULL;
		GFile* _tmp12_;
		GFileEnumerator* _tmp13_;
		GFileEnumerator* _tmp14_;
		_tmp12_ = self->priv->current_dir;
		_tmp13_ = g_file_enumerate_children (_tmp12_, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, NULL, &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp14_;
		while (TRUE) {
			GFileInfo* _tmp15_ = NULL;
			GFileEnumerator* _tmp16_;
			GFileInfo* _tmp17_;
			GFileInfo* _tmp18_;
			GFileInfo* _tmp19_;
			GFileInfo* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp16_ = enumerator;
			_tmp17_ = g_file_enumerator_next_file (_tmp16_, NULL, &_inner_error0_);
			_tmp15_ = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp11_);
				goto __catch0_g_error;
			}
			_tmp18_ = _tmp15_;
			_tmp15_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp18_;
			_tmp19_ = file_info;
			if (!(_tmp19_ != NULL)) {
				_g_object_unref0 (_tmp15_);
				break;
			}
			_tmp20_ = file_info;
			_tmp21_ = g_file_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_file_info_get_type (), GFileInfo));
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (fn);
			fn = _tmp22_;
			_tmp23_ = fn;
			if (!g_str_has_prefix (_tmp23_, ".")) {
				GFileInfo* _tmp24_;
				_tmp24_ = file_info;
				if (g_file_info_get_file_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_file_info_get_type (), GFileInfo)) == G_FILE_TYPE_DIRECTORY) {
					GeeArrayList* _tmp25_;
					const gchar* _tmp26_;
					_tmp25_ = self->priv->directories;
					_tmp26_ = fn;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
				} else {
					GeeArrayList* _tmp27_;
					const gchar* _tmp28_;
					_tmp27_ = self->priv->files;
					_tmp28_ = fn;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
				}
			}
			_g_object_unref0 (_tmp15_);
		}
		_g_object_unref0 (_tmp11_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("FileDialogTab.vala:194: %s", _tmp30_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (fn);
		_g_object_unref0 (file_info);
		_g_object_unref0 (enumerator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp31_ = self->priv->directories;
	gee_list_sort ((GeeList*) _tmp31_, NULL, NULL, NULL);
	if (bird_font_file_dialog_tab_has_drive_letters) {
		{
			gint i = 0;
			GeeArrayList* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			_tmp32_ = bird_font_file_dialog_tab_drive_letters;
			_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
			_tmp34_ = _tmp33_;
			i = _tmp34_ - 1;
			{
				gboolean _tmp35_ = FALSE;
				_tmp35_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp37_;
					GeeArrayList* _tmp38_;
					gpointer _tmp39_;
					gchar* _tmp40_;
					if (!_tmp35_) {
						gint _tmp36_;
						_tmp36_ = i;
						i = _tmp36_ - 1;
					}
					_tmp35_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp37_ = self->priv->directories;
					_tmp38_ = bird_font_file_dialog_tab_drive_letters;
					_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, i);
					_tmp40_ = (gchar*) _tmp39_;
					gee_abstract_list_insert ((GeeAbstractList*) _tmp37_, 0, _tmp40_);
					_g_free0 (_tmp40_);
				}
			}
		}
	}
	_tmp41_ = self->priv->files;
	gee_list_sort ((GeeList*) _tmp41_, NULL, NULL, NULL);
	bird_font_table_layout ((BirdFontTable*) self);
	BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_file_dialog_tab_parent_class)->selected_canvas ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TABLE, BirdFontTable));
	bird_font_font_display_scroll_to ((BirdFontFontDisplay*) self, (gdouble) 0);
	bird_font_main_window_show_scrollbar ();
	_g_free0 (fn);
	_g_object_unref0 (file_info);
	_g_object_unref0 (enumerator);
}

static void
__lambda409_ (BirdFontFileDialogTab* self,
              const gchar* text)
{
	gchar* _tmp0_;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->priv->selected_filename);
	self->priv->selected_filename = _tmp0_;
}

static void
___lambda409__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda409_ ((BirdFontFileDialogTab*) self, text);
}

static void
__lambda410_ (BirdFontFileDialogTab* self)
{
	GFile* f = NULL;
	BirdFontTabBar* _tmp0_;
	BirdFontTabBar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = bird_font_main_window_get_tab_bar ();
	_tmp1_ = _tmp0_;
	bird_font_tab_bar_close_display (_tmp1_, (BirdFontFontDisplay*) self);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->selected_filename;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		BirdFontFileChooser* _tmp3_;
		_tmp3_ = self->priv->action;
		bird_font_file_chooser_cancel (_tmp3_);
	} else {
		const gchar* _tmp4_;
		BirdFontFileChooser* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp4_ = self->priv->selected_filename;
		if (string_index_of (_tmp4_, ":\\", 0) != -1) {
			const gchar* _tmp5_;
			GFile* _tmp6_;
			_tmp5_ = self->priv->selected_filename;
			_tmp6_ = g_file_new_for_path (_tmp5_);
			_g_object_unref0 (f);
			f = _tmp6_;
		} else {
			GFile* _tmp7_;
			const gchar* _tmp8_;
			GFile* _tmp9_;
			_tmp7_ = self->priv->current_dir;
			_tmp8_ = self->priv->selected_filename;
			_tmp9_ = bird_font_get_child (_tmp7_, _tmp8_);
			_g_object_unref0 (f);
			f = _tmp9_;
		}
		_tmp10_ = self->priv->action;
		_tmp11_ = f;
		_tmp12_ = g_file_get_path (_tmp11_);
		_tmp13_ = (gchar*) _tmp12_;
		g_signal_emit_by_name (_tmp10_, "file-selected", _tmp13_);
		_g_free0 (_tmp13_);
	}
	_g_object_unref0 (f);
}

static void
___lambda410__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda410_ ((BirdFontFileDialogTab*) self);
}

void
bird_font_file_dialog_tab_show_text_area (BirdFontFileDialogTab* self,
                                          const gchar* text)
{
	const gchar* _tmp0_;
	BirdFontTextListener* _tmp1_;
	BirdFontTextListener* _tmp2_;
	BirdFontTextListener* _tmp3_;
	BirdFontTextListener* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->title;
	_tmp1_ = bird_font_text_listener_new ("", text, _tmp0_);
	_g_object_unref0 (self->priv->listener);
	self->priv->listener = _tmp1_;
	_tmp2_ = self->priv->listener;
	g_signal_connect_object (_tmp2_, "signal-text-input", (GCallback) ___lambda409__bird_font_text_listener_signal_text_input, self, 0);
	_tmp3_ = self->priv->listener;
	g_signal_connect_object (_tmp3_, "signal-submit", (GCallback) ___lambda410__bird_font_text_listener_signal_submit, self, 0);
	_tmp4_ = self->priv->listener;
	bird_font_tab_content_show_text_input (_tmp4_);
}

static void
bird_font_file_dialog_tab_real_double_click (BirdFontFontDisplay* base,
                                             guint button,
                                             gdouble ex,
                                             gdouble ey)
{
	BirdFontFileDialogTab * self;
	GFile* f = NULL;
	const gchar* _tmp0_;
	self = (BirdFontFileDialogTab*) base;
	bird_font_font_display_button_release ((BirdFontFontDisplay*) self, (gint) button, ex, ey);
	_tmp0_ = self->priv->selected_filename;
	if (bird_font_is_null (_tmp0_)) {
		g_warning ("FileDialogTab.vala:247: No file.");
		_g_object_unref0 (f);
		return;
	}
	if (self->priv->select_folder) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->selected_filename;
		if (string_index_of (_tmp1_, ":", 0) > -1) {
			const gchar* _tmp2_;
			_tmp2_ = self->priv->selected_filename;
			bird_font_file_dialog_tab_propagate_files (self, _tmp2_);
		} else {
			GFile* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp3_ = self->priv->current_dir;
			_tmp4_ = g_file_get_path (_tmp3_);
			_tmp5_ = (gchar*) _tmp4_;
			_tmp6_ = g_strconcat (_tmp5_, BIRD_FONT_FILE_DIALOG_TAB_path_separator, NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->selected_filename;
			_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
			_tmp10_ = _tmp9_;
			bird_font_file_dialog_tab_propagate_files (self, _tmp10_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
		}
	} else {
		const gchar* _tmp11_;
		_tmp11_ = self->priv->selected_filename;
		if (g_strcmp0 (_tmp11_, "") != 0) {
			GFile* _tmp12_;
			const gchar* _tmp13_;
			GFile* _tmp14_;
			BirdFontFileChooser* _tmp15_;
			GFile* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp12_ = self->priv->current_dir;
			_tmp13_ = self->priv->selected_filename;
			_tmp14_ = bird_font_get_child (_tmp12_, _tmp13_);
			_g_object_unref0 (f);
			f = _tmp14_;
			_tmp15_ = self->priv->action;
			_tmp16_ = f;
			_tmp17_ = g_file_get_path (_tmp16_);
			_tmp18_ = (gchar*) _tmp17_;
			g_signal_emit_by_name (_tmp15_, "file-selected", _tmp18_);
			_g_free0 (_tmp18_);
		}
	}
	_g_object_unref0 (f);
}

static gchar*
bird_font_file_dialog_tab_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontFileDialogTab * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (BirdFontFileDialogTab*) base;
	_tmp0_ = self->priv->title;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
bird_font_file_dialog_tab_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontFileDialogTab * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontFileDialogTab*) base;
	_tmp0_ = g_strdup ("FileDialogTab");
	result = _tmp0_;
	return result;
}

static void
bird_font_file_dialog_tab_real_button_release (BirdFontFontDisplay* base,
                                               gint button,
                                               gdouble ex,
                                               gdouble ey)
{
	BirdFontFileDialogTab * self;
	const gchar* _tmp0_;
	self = (BirdFontFileDialogTab*) base;
	BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_file_dialog_tab_parent_class)->button_release ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TABLE, BirdFontTable), button, ex, ey);
	_tmp0_ = self->priv->selected_filename;
	bird_font_file_dialog_tab_show_text_area (self, _tmp0_);
}

static BirdFontFileDialogTabSelectedFile*
bird_font_file_dialog_tab_selected_file_construct (GType object_type,
                                                   const gchar* fn)
{
	BirdFontFileDialogTabSelectedFile * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (fn != NULL, NULL);
	self = (BirdFontFileDialogTabSelectedFile*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (fn);
	_g_free0 (self->file_name);
	self->file_name = _tmp0_;
	return self;
}

static BirdFontFileDialogTabSelectedFile*
bird_font_file_dialog_tab_selected_file_new (const gchar* fn)
{
	return bird_font_file_dialog_tab_selected_file_construct (BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE, fn);
}

static void
bird_font_file_dialog_tab_selected_file_class_init (BirdFontFileDialogTabSelectedFileClass * klass,
                                                    gpointer klass_data)
{
	bird_font_file_dialog_tab_selected_file_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_file_dialog_tab_selected_file_finalize;
}

static void
bird_font_file_dialog_tab_selected_file_instance_init (BirdFontFileDialogTabSelectedFile * self,
                                                       gpointer klass)
{
}

static void
bird_font_file_dialog_tab_selected_file_finalize (GObject * obj)
{
	BirdFontFileDialogTabSelectedFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_FILE_DIALOG_TAB_TYPE_SELECTED_FILE, BirdFontFileDialogTabSelectedFile);
	_g_free0 (self->file_name);
	G_OBJECT_CLASS (bird_font_file_dialog_tab_selected_file_parent_class)->finalize (obj);
}

static GType
bird_font_file_dialog_tab_selected_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontFileDialogTabSelectedFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_file_dialog_tab_selected_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontFileDialogTabSelectedFile), 0, (GInstanceInitFunc) bird_font_file_dialog_tab_selected_file_instance_init, NULL };
	GType bird_font_file_dialog_tab_selected_file_type_id;
	bird_font_file_dialog_tab_selected_file_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontFileDialogTabSelectedFile", &g_define_type_info, 0);
	return bird_font_file_dialog_tab_selected_file_type_id;
}

static GType
bird_font_file_dialog_tab_selected_file_get_type (void)
{
	static volatile gsize bird_font_file_dialog_tab_selected_file_type_id__once = 0;
	if (g_once_init_enter (&bird_font_file_dialog_tab_selected_file_type_id__once)) {
		GType bird_font_file_dialog_tab_selected_file_type_id;
		bird_font_file_dialog_tab_selected_file_type_id = bird_font_file_dialog_tab_selected_file_get_type_once ();
		g_once_init_leave (&bird_font_file_dialog_tab_selected_file_type_id__once, bird_font_file_dialog_tab_selected_file_type_id);
	}
	return bird_font_file_dialog_tab_selected_file_type_id__once;
}

static void
bird_font_file_dialog_tab_class_init (BirdFontFileDialogTabClass * klass,
                                      gpointer klass_data)
{
	bird_font_file_dialog_tab_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontFileDialogTab_private_offset);
	((BirdFontTableClass *) klass)->update_rows = (void (*) (BirdFontTable*)) bird_font_file_dialog_tab_real_update_rows;
	((BirdFontTableClass *) klass)->get_rows = (GeeArrayList* (*) (BirdFontTable*)) bird_font_file_dialog_tab_real_get_rows;
	((BirdFontTableClass *) klass)->selected_row = (void (*) (BirdFontTable*, BirdFontRow*, gint, gboolean)) bird_font_file_dialog_tab_real_selected_row;
	((BirdFontFontDisplayClass *) klass)->selected_canvas = (void (*) (BirdFontFontDisplay*)) bird_font_file_dialog_tab_real_selected_canvas;
	((BirdFontFontDisplayClass *) klass)->double_click = (void (*) (BirdFontFontDisplay*, guint, gdouble, gdouble)) bird_font_file_dialog_tab_real_double_click;
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_file_dialog_tab_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_file_dialog_tab_real_get_name;
	((BirdFontFontDisplayClass *) klass)->button_release = (void (*) (BirdFontFontDisplay*, gint, gdouble, gdouble)) bird_font_file_dialog_tab_real_button_release;
	G_OBJECT_CLASS (klass)->finalize = bird_font_file_dialog_tab_finalize;
}

static void
bird_font_file_dialog_tab_instance_init (BirdFontFileDialogTab * self,
                                         gpointer klass)
{
	self->priv = bird_font_file_dialog_tab_get_instance_private (self);
	self->priv->select_folder = FALSE;
}

static void
bird_font_file_dialog_tab_finalize (GObject * obj)
{
	BirdFontFileDialogTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_FILE_DIALOG_TAB, BirdFontFileDialogTab);
	_g_object_unref0 (self->priv->rows);
	_g_object_unref0 (self->priv->files);
	_g_object_unref0 (self->priv->directories);
	_g_free0 (self->priv->title);
	_g_object_unref0 (self->priv->action);
	_g_object_unref0 (self->priv->current_dir);
	_g_free0 (self->priv->selected_filename);
	_g_object_unref0 (self->priv->listener);
	G_OBJECT_CLASS (bird_font_file_dialog_tab_parent_class)->finalize (obj);
}

static GType
bird_font_file_dialog_tab_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontFileDialogTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_file_dialog_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontFileDialogTab), 0, (GInstanceInitFunc) bird_font_file_dialog_tab_instance_init, NULL };
	GType bird_font_file_dialog_tab_type_id;
	bird_font_file_dialog_tab_type_id = g_type_register_static (BIRD_FONT_TYPE_TABLE, "BirdFontFileDialogTab", &g_define_type_info, 0);
	BirdFontFileDialogTab_private_offset = g_type_add_instance_private (bird_font_file_dialog_tab_type_id, sizeof (BirdFontFileDialogTabPrivate));
	return bird_font_file_dialog_tab_type_id;
}

GType
bird_font_file_dialog_tab_get_type (void)
{
	static volatile gsize bird_font_file_dialog_tab_type_id__once = 0;
	if (g_once_init_enter (&bird_font_file_dialog_tab_type_id__once)) {
		GType bird_font_file_dialog_tab_type_id;
		bird_font_file_dialog_tab_type_id = bird_font_file_dialog_tab_get_type_once ();
		g_once_init_leave (&bird_font_file_dialog_tab_type_id__once, bird_font_file_dialog_tab_type_id);
	}
	return bird_font_file_dialog_tab_type_id__once;
}

