/* ExportSettings.c generated by valac 0.56.16, the Vala compiler
 * generated from ExportSettings.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_EXPORT_SETTINGS_0_PROPERTY,
	BIRD_FONT_EXPORT_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* bird_font_export_settings_properties[BIRD_FONT_EXPORT_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block15Data Block15Data;

#define BIRD_FONT_TYPE_HEADLINE (bird_font_headline_get_type ())
#define BIRD_FONT_HEADLINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_HEADLINE, BirdFontHeadline))
#define BIRD_FONT_HEADLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_HEADLINE, BirdFontHeadlineClass))
#define BIRD_FONT_IS_HEADLINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_HEADLINE))
#define BIRD_FONT_IS_HEADLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_HEADLINE))
#define BIRD_FONT_HEADLINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_HEADLINE, BirdFontHeadlineClass))

typedef struct _BirdFontHeadline BirdFontHeadline;
typedef struct _BirdFontHeadlineClass BirdFontHeadlineClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontExportSettingsPrivate {
	BirdFontTextArea* file_name;
	BirdFontTextArea* file_name_mac;
	BirdFontTextArea* units_per_em;
	BirdFontCheckBox* ttf;
	BirdFontCheckBox* eot;
	BirdFontCheckBox* svg;
	BirdFontCheckBox* svg_table;
	BirdFontCheckBox* colr_table;
	BirdFontButton* export_action;
	BirdFontButton* name_tab;
};

struct _Block15Data {
	int _ref_count_;
	BirdFontExportSettings* self;
	BirdFontCheckBox* otf;
};

static gint BirdFontExportSettings_private_offset;
static gpointer bird_font_export_settings_parent_class = NULL;

static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN GType bird_font_headline_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontHeadline* bird_font_headline_new (const gchar* text);
VALA_EXTERN BirdFontHeadline* bird_font_headline_construct (GType object_type,
                                                const gchar* text);
static void __lambda122_ (BirdFontExportSettings* self,
                   const gchar* t);
static void ___lambda122__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda123_ (BirdFontExportSettings* self,
                   const gchar* t);
static void ___lambda123__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda124_ (BirdFontExportSettings* self,
                   const gchar* t);
static void ___lambda124__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda181_ (Block15Data* _data15_,
                   gboolean c);
static void ___lambda181__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                                gboolean checked,
                                                gpointer self);
static void __lambda184_ (BirdFontExportSettings* self,
                   gboolean c);
static void ___lambda184__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                                gboolean checked,
                                                gpointer self);
static void __lambda185_ (BirdFontExportSettings* self,
                   gboolean c);
static void ___lambda185__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                                gboolean checked,
                                                gpointer self);
static void __lambda186_ (BirdFontExportSettings* self,
                   gboolean c);
static void ___lambda186__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                                gboolean checked,
                                                gpointer self);
static void __lambda187_ (BirdFontExportSettings* self,
                   gboolean c);
static void ___lambda187__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                                gboolean checked,
                                                gpointer self);
static void __lambda188_ (BirdFontExportSettings* self,
                   gboolean c);
static void ___lambda188__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                                gboolean checked,
                                                gpointer self);
static void __lambda189_ (BirdFontExportSettings* self,
                   BirdFontButton* c);
static void ___lambda189__bird_font_button_action (BirdFontButton* _sender,
                                            gpointer self);
static void __lambda209_ (BirdFontExportSettings* self,
                   BirdFontButton* c);
static void ___lambda209__bird_font_button_action (BirdFontButton* _sender,
                                            gpointer self);
static gchar* bird_font_export_settings_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_export_settings_real_get_name (BirdFontFontDisplay* base);
static void bird_font_export_settings_finalize (GObject * obj);
static GType bird_font_export_settings_get_type_once (void);

static inline gpointer
bird_font_export_settings_get_instance_private (BirdFontExportSettings* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontExportSettings_private_offset);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		BirdFontExportSettings* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->otf);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda122_ (BirdFontExportSettings* self,
              const gchar* t)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFontSettings* _tmp1_;
	g_return_if_fail (t != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	_tmp1_ = f->settings;
	bird_font_font_settings_set_setting (_tmp1_, "file_name", t);
	_g_object_unref0 (f);
}

static void
___lambda122__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda122_ ((BirdFontExportSettings*) self, text);
}

static void
__lambda123_ (BirdFontExportSettings* self,
              const gchar* t)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFontSettings* _tmp1_;
	g_return_if_fail (t != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	_tmp1_ = f->settings;
	bird_font_font_settings_set_setting (_tmp1_, "file_name_mac", t);
	_g_object_unref0 (f);
}

static void
___lambda123__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda123_ ((BirdFontExportSettings*) self, text);
}

static void
__lambda124_ (BirdFontExportSettings* self,
              const gchar* t)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	gint u = 0;
	g_return_if_fail (t != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	u = atoi (t);
	if (u > 0) {
		BirdFontFont* _tmp1_;
		BirdFontFont* _tmp2_;
		_tmp1_ = f;
		_tmp1_->units_per_em = u;
		_tmp2_ = f;
		bird_font_font_touch (_tmp2_);
	}
	_g_object_unref0 (f);
}

static void
___lambda124__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda124_ ((BirdFontExportSettings*) self, text);
}

static void
__lambda181_ (Block15Data* _data15_,
              gboolean c)
{
	BirdFontExportSettings* self;
	self = _data15_->self;
	if (c) {
		BirdFontMessageDialog* dialog = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		BirdFontMessageDialog* _tmp2_;
		BirdFontMessageDialog* _tmp3_;
		_tmp0_ = bird_font_t_ ("You need the plus version to export OTF fonts.");
		_tmp1_ = _tmp0_;
		_tmp2_ = bird_font_main_window_show_message (_tmp1_);
		_g_object_unref0 (dialog);
		dialog = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp3_ = dialog;
		bird_font_main_window_show_dialog ((BirdFontDialog*) _tmp3_);
		_data15_->otf->checked = FALSE;
		_g_object_unref0 (dialog);
	}
}

static void
___lambda181__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                           gboolean checked,
                                           gpointer self)
{
	__lambda181_ (self, checked);
}

static void
__lambda184_ (BirdFontExportSettings* self,
              gboolean c)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* v = NULL;
	gchar* _tmp2_;
	BirdFontFont* _tmp3_;
	BirdFontFontSettings* _tmp4_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	if (c) {
		_tmp1_ = "true";
	} else {
		_tmp1_ = "false";
	}
	_tmp2_ = g_strdup (_tmp1_);
	v = _tmp2_;
	_tmp3_ = f;
	_tmp4_ = _tmp3_->settings;
	bird_font_font_settings_set_setting (_tmp4_, "export_ttf", v);
	_g_free0 (v);
	_g_object_unref0 (f);
}

static void
___lambda184__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                           gboolean checked,
                                           gpointer self)
{
	__lambda184_ ((BirdFontExportSettings*) self, checked);
}

static void
__lambda185_ (BirdFontExportSettings* self,
              gboolean c)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* v = NULL;
	gchar* _tmp2_;
	BirdFontFont* _tmp3_;
	BirdFontFontSettings* _tmp4_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	if (c) {
		_tmp1_ = "true";
	} else {
		_tmp1_ = "false";
	}
	_tmp2_ = g_strdup (_tmp1_);
	v = _tmp2_;
	_tmp3_ = f;
	_tmp4_ = _tmp3_->settings;
	bird_font_font_settings_set_setting (_tmp4_, "export_eot", v);
	_g_free0 (v);
	_g_object_unref0 (f);
}

static void
___lambda185__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                           gboolean checked,
                                           gpointer self)
{
	__lambda185_ ((BirdFontExportSettings*) self, checked);
}

static void
__lambda186_ (BirdFontExportSettings* self,
              gboolean c)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* v = NULL;
	gchar* _tmp2_;
	BirdFontFont* _tmp3_;
	BirdFontFontSettings* _tmp4_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	if (c) {
		_tmp1_ = "true";
	} else {
		_tmp1_ = "false";
	}
	_tmp2_ = g_strdup (_tmp1_);
	v = _tmp2_;
	_tmp3_ = f;
	_tmp4_ = _tmp3_->settings;
	bird_font_font_settings_set_setting (_tmp4_, "export_svg", v);
	_g_free0 (v);
	_g_object_unref0 (f);
}

static void
___lambda186__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                           gboolean checked,
                                           gpointer self)
{
	__lambda186_ ((BirdFontExportSettings*) self, checked);
}

static void
__lambda187_ (BirdFontExportSettings* self,
              gboolean c)
{
	BirdFontCheckBox* _tmp0_;
	bird_font_export_settings_show_plus_version_needed_for_color_tables (self);
	_tmp0_ = self->priv->svg_table;
	_tmp0_->checked = FALSE;
}

static void
___lambda187__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                           gboolean checked,
                                           gpointer self)
{
	__lambda187_ ((BirdFontExportSettings*) self, checked);
}

static void
__lambda188_ (BirdFontExportSettings* self,
              gboolean c)
{
	BirdFontCheckBox* _tmp0_;
	bird_font_export_settings_show_plus_version_needed_for_color_tables (self);
	_tmp0_ = self->priv->colr_table;
	_tmp0_->checked = FALSE;
}

static void
___lambda188__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                           gboolean checked,
                                           gpointer self)
{
	__lambda188_ ((BirdFontExportSettings*) self, checked);
}

static void
__lambda189_ (BirdFontExportSettings* self,
              BirdFontButton* c)
{
	g_return_if_fail (c != NULL);
	bird_font_menu_tab_show_description ();
}

static void
___lambda189__bird_font_button_action (BirdFontButton* _sender,
                                       gpointer self)
{
	__lambda189_ ((BirdFontExportSettings*) self, _sender);
}

static void
__lambda209_ (BirdFontExportSettings* self,
              BirdFontButton* c)
{
	g_return_if_fail (c != NULL);
	bird_font_menu_tab_export_fonts_in_background ();
}

static void
___lambda209__bird_font_button_action (BirdFontButton* _sender,
                                       gpointer self)
{
	__lambda209_ ((BirdFontExportSettings*) self, _sender);
}

BirdFontExportSettings*
bird_font_export_settings_construct (GType object_type)
{
	BirdFontExportSettings * self = NULL;
	Block15Data* _data15_;
	BirdFontHeadline* headline = NULL;
	BirdFontFont* font = NULL;
	gdouble margin = 0.0;
	gdouble label_size = 0.0;
	gdouble label_margin = 0.0;
	gchar* fn = NULL;
	gchar* folder = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFontSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BirdFontHeadline* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BirdFontText* _tmp9_;
	BirdFontText* _tmp10_;
	BirdFontLineTextArea* _tmp11_;
	BirdFontTextArea* _tmp12_;
	gchar* _tmp13_;
	BirdFontTextArea* _tmp14_;
	const gchar* _tmp15_;
	BirdFontTextArea* _tmp16_;
	GeeArrayList* _tmp17_;
	BirdFontTextArea* _tmp18_;
	GeeArrayList* _tmp19_;
	BirdFontTextArea* _tmp20_;
	GeeArrayList* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	BirdFontText* _tmp26_;
	BirdFontText* _tmp27_;
	BirdFontLineTextArea* _tmp28_;
	BirdFontTextArea* _tmp29_;
	gchar* _tmp30_;
	BirdFontTextArea* _tmp31_;
	const gchar* _tmp32_;
	BirdFontTextArea* _tmp33_;
	GeeArrayList* _tmp34_;
	BirdFontTextArea* _tmp35_;
	GeeArrayList* _tmp36_;
	BirdFontTextArea* _tmp37_;
	GeeArrayList* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	BirdFontText* _tmp41_;
	BirdFontText* _tmp42_;
	BirdFontLineTextArea* _tmp43_;
	BirdFontTextArea* _tmp44_;
	BirdFontTextArea* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	BirdFontTextArea* _tmp48_;
	GeeArrayList* _tmp49_;
	BirdFontTextArea* _tmp50_;
	GeeArrayList* _tmp51_;
	BirdFontTextArea* _tmp52_;
	gchar* _tmp53_;
	BirdFontText* folder_row = NULL;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	BirdFontText* _tmp60_;
	BirdFontText* _tmp61_;
	GeeArrayList* _tmp62_;
	GeeArrayList* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	BirdFontText* _tmp66_;
	BirdFontText* _tmp67_;
	BirdFontCheckBox* _tmp68_;
	GeeArrayList* _tmp69_;
	GeeArrayList* _tmp70_;
	BirdFontCheckBox* _tmp71_;
	BirdFontCheckBox* _tmp72_;
	BirdFontCheckBox* _tmp73_;
	GeeArrayList* _tmp74_;
	BirdFontCheckBox* _tmp75_;
	GeeArrayList* _tmp76_;
	BirdFontCheckBox* _tmp77_;
	BirdFontCheckBox* _tmp78_;
	BirdFontCheckBox* _tmp79_;
	BirdFontCheckBox* _tmp80_;
	GeeArrayList* _tmp81_;
	BirdFontCheckBox* _tmp82_;
	GeeArrayList* _tmp83_;
	BirdFontCheckBox* _tmp84_;
	BirdFontCheckBox* _tmp85_;
	BirdFontCheckBox* _tmp86_;
	BirdFontCheckBox* _tmp87_;
	BirdFontCheckBox* _tmp88_;
	GeeArrayList* _tmp89_;
	BirdFontCheckBox* _tmp90_;
	GeeArrayList* _tmp91_;
	BirdFontCheckBox* _tmp92_;
	BirdFontCheckBox* _tmp93_;
	GeeArrayList* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	BirdFontText* _tmp97_;
	BirdFontText* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	BirdFontCheckBox* _tmp101_;
	BirdFontCheckBox* _tmp102_;
	BirdFontCheckBox* _tmp103_;
	GeeArrayList* _tmp104_;
	BirdFontCheckBox* _tmp105_;
	GeeArrayList* _tmp106_;
	BirdFontCheckBox* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	BirdFontCheckBox* _tmp110_;
	BirdFontCheckBox* _tmp111_;
	BirdFontCheckBox* _tmp112_;
	GeeArrayList* _tmp113_;
	BirdFontCheckBox* _tmp114_;
	GeeArrayList* _tmp115_;
	BirdFontCheckBox* _tmp116_;
	BirdFontCheckBox* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	BirdFontButton* _tmp120_;
	BirdFontButton* _tmp121_;
	GeeArrayList* _tmp122_;
	BirdFontButton* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	BirdFontButton* _tmp126_;
	BirdFontButton* _tmp127_;
	GeeArrayList* _tmp128_;
	BirdFontButton* _tmp129_;
	BirdFontTextArea* _tmp130_;
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	self = (BirdFontExportSettings*) bird_font_table_layout_construct (object_type);
	_data15_->self = g_object_ref (self);
	margin = (gdouble) 12;
	label_size = (gdouble) 20;
	label_margin = (gdouble) 4;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp0_;
	_tmp1_ = font->settings;
	bird_font_font_settings_set_setting (_tmp1_, "has_export_settings", "true");
	_tmp2_ = bird_font_t_ ("Export Settings");
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_headline_new (_tmp3_);
	_g_object_unref0 (headline);
	headline = _tmp4_;
	_g_free0 (_tmp3_);
	((BirdFontWidget*) headline)->margin_bottom = (gdouble) 20;
	_tmp5_ = ((BirdFontTableLayout*) self)->widgets;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, (BirdFontWidget*) headline);
	_tmp6_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp7_ = bird_font_t_ ("File Name");
	_tmp8_ = _tmp7_;
	_tmp9_ = bird_font_text_new (_tmp8_, label_size, label_margin);
	_tmp10_ = _tmp9_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (BirdFontWidget*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp11_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->file_name);
	self->priv->file_name = (BirdFontTextArea*) _tmp11_;
	_tmp12_ = self->priv->file_name;
	((BirdFontWidget*) _tmp12_)->margin_bottom = margin;
	_tmp13_ = bird_font_export_settings_get_file_name (font);
	_g_free0 (fn);
	fn = _tmp13_;
	_tmp14_ = self->priv->file_name;
	_tmp15_ = fn;
	bird_font_text_area_set_text (_tmp14_, _tmp15_);
	_tmp16_ = self->priv->file_name;
	g_signal_connect_object (_tmp16_, "text-changed", (GCallback) ___lambda122__bird_font_text_area_text_changed, self, 0);
	_tmp17_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp18_ = self->priv->file_name;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, (BirdFontWidget*) _tmp18_);
	_tmp19_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp20_ = self->priv->file_name;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (BirdFontWidget*) _tmp20_);
	_tmp21_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp22_ = bird_font_t_ ("File Name");
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, " Mac", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = bird_font_text_new (_tmp25_, label_size, label_margin);
	_tmp27_ = _tmp26_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, (BirdFontWidget*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_tmp28_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->file_name_mac);
	self->priv->file_name_mac = (BirdFontTextArea*) _tmp28_;
	_tmp29_ = self->priv->file_name_mac;
	((BirdFontWidget*) _tmp29_)->margin_bottom = margin;
	_tmp30_ = bird_font_export_settings_get_file_name_mac (font);
	_g_free0 (fn);
	fn = _tmp30_;
	_tmp31_ = self->priv->file_name_mac;
	_tmp32_ = fn;
	bird_font_text_area_set_text (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->file_name_mac;
	g_signal_connect_object (_tmp33_, "text-changed", (GCallback) ___lambda123__bird_font_text_area_text_changed, self, 0);
	_tmp34_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp35_ = self->priv->file_name_mac;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, (BirdFontWidget*) _tmp35_);
	_tmp36_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp37_ = self->priv->file_name_mac;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (BirdFontWidget*) _tmp37_);
	_tmp38_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp39_ = bird_font_t_ ("Units Per Em");
	_tmp40_ = _tmp39_;
	_tmp41_ = bird_font_text_new (_tmp40_, label_size, label_margin);
	_tmp42_ = _tmp41_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, (BirdFontWidget*) _tmp42_);
	_g_object_unref0 (_tmp42_);
	_g_free0 (_tmp40_);
	_tmp43_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->units_per_em);
	self->priv->units_per_em = (BirdFontTextArea*) _tmp43_;
	_tmp44_ = self->priv->units_per_em;
	((BirdFontWidget*) _tmp44_)->margin_bottom = margin;
	_tmp45_ = self->priv->units_per_em;
	_tmp46_ = g_strdup_printf ("%i", font->units_per_em);
	_tmp47_ = _tmp46_;
	bird_font_text_area_set_text (_tmp45_, _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = self->priv->units_per_em;
	g_signal_connect_object (_tmp48_, "text-changed", (GCallback) ___lambda124__bird_font_text_area_text_changed, self, 0);
	_tmp49_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp50_ = self->priv->units_per_em;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, (BirdFontWidget*) _tmp50_);
	_tmp51_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp52_ = self->priv->units_per_em;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, (BirdFontWidget*) _tmp52_);
	_tmp53_ = bird_font_export_tool_get_export_folder ();
	_g_free0 (folder);
	folder = _tmp53_;
	_tmp54_ = bird_font_t_ ("Folder");
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat (_tmp55_, ": ", NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = g_strconcat (_tmp57_, folder, NULL);
	_tmp59_ = _tmp58_;
	_tmp60_ = bird_font_text_new (_tmp59_, label_size, label_margin);
	_tmp61_ = _tmp60_;
	_g_free0 (_tmp59_);
	_g_free0 (_tmp57_);
	_g_free0 (_tmp55_);
	folder_row = _tmp61_;
	((BirdFontWidget*) folder_row)->margin_bottom = (gdouble) 20;
	_tmp62_ = ((BirdFontTableLayout*) self)->widgets;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, (BirdFontWidget*) folder_row);
	_tmp63_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp64_ = bird_font_t_ ("Formats");
	_tmp65_ = _tmp64_;
	_tmp66_ = bird_font_text_new (_tmp65_, label_size, label_margin);
	_tmp67_ = _tmp66_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp63_, (BirdFontWidget*) _tmp67_);
	_g_object_unref0 (_tmp67_);
	_g_free0 (_tmp65_);
	_tmp68_ = bird_font_check_box_new ("OTF", label_size);
	_data15_->otf = _tmp68_;
	g_signal_connect_data (_data15_->otf, "updated", (GCallback) ___lambda181__bird_font_check_box_updated, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_data15_->otf->checked = FALSE;
	_tmp69_ = ((BirdFontTableLayout*) self)->widgets;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, (BirdFontWidget*) _data15_->otf);
	_tmp70_ = ((BirdFontTableLayout*) self)->focus_ring;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp70_, (BirdFontWidget*) _data15_->otf);
	_tmp71_ = bird_font_check_box_new ("TTF", label_size);
	_g_object_unref0 (self->priv->ttf);
	self->priv->ttf = _tmp71_;
	_tmp72_ = self->priv->ttf;
	g_signal_connect_object (_tmp72_, "updated", (GCallback) ___lambda184__bird_font_check_box_updated, self, 0);
	_tmp73_ = self->priv->ttf;
	_tmp73_->checked = bird_font_export_settings_export_ttf_setting (font);
	_tmp74_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp75_ = self->priv->ttf;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp74_, (BirdFontWidget*) _tmp75_);
	_tmp76_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp77_ = self->priv->ttf;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp76_, (BirdFontWidget*) _tmp77_);
	_tmp78_ = bird_font_check_box_new ("EOT", label_size);
	_g_object_unref0 (self->priv->eot);
	self->priv->eot = _tmp78_;
	_tmp79_ = self->priv->eot;
	g_signal_connect_object (_tmp79_, "updated", (GCallback) ___lambda185__bird_font_check_box_updated, self, 0);
	_tmp80_ = self->priv->eot;
	_tmp80_->checked = bird_font_export_settings_export_eot_setting (font);
	_tmp81_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp82_ = self->priv->eot;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp81_, (BirdFontWidget*) _tmp82_);
	_tmp83_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp84_ = self->priv->eot;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp83_, (BirdFontWidget*) _tmp84_);
	_tmp85_ = bird_font_check_box_new ("SVG", label_size);
	_g_object_unref0 (self->priv->svg);
	self->priv->svg = _tmp85_;
	_tmp86_ = self->priv->svg;
	g_signal_connect_object (_tmp86_, "updated", (GCallback) ___lambda186__bird_font_check_box_updated, self, 0);
	_tmp87_ = self->priv->svg;
	_tmp87_->checked = bird_font_export_settings_export_svg_setting (font);
	_tmp88_ = self->priv->svg;
	((BirdFontWidget*) _tmp88_)->margin_bottom = margin;
	_tmp89_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp90_ = self->priv->svg;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp89_, (BirdFontWidget*) _tmp90_);
	_tmp91_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp92_ = self->priv->svg;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp91_, (BirdFontWidget*) _tmp92_);
	_tmp93_ = self->priv->svg;
	((BirdFontWidget*) _tmp93_)->margin_bottom = (gdouble) 20;
	_tmp94_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp95_ = bird_font_t_ ("Color Tables");
	_tmp96_ = _tmp95_;
	_tmp97_ = bird_font_text_new (_tmp96_, label_size, label_margin);
	_tmp98_ = _tmp97_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp94_, (BirdFontWidget*) _tmp98_);
	_g_object_unref0 (_tmp98_);
	_g_free0 (_tmp96_);
	_tmp99_ = bird_font_t_ ("Embedded SVG table");
	_tmp100_ = _tmp99_;
	_tmp101_ = bird_font_check_box_new (_tmp100_, label_size);
	_g_object_unref0 (self->priv->svg_table);
	self->priv->svg_table = _tmp101_;
	_g_free0 (_tmp100_);
	_tmp102_ = self->priv->svg_table;
	_tmp102_->checked = FALSE;
	_tmp103_ = self->priv->svg_table;
	g_signal_connect_object (_tmp103_, "updated", (GCallback) ___lambda187__bird_font_check_box_updated, self, 0);
	_tmp104_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp105_ = self->priv->svg_table;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, (BirdFontWidget*) _tmp105_);
	_tmp106_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp107_ = self->priv->svg_table;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp106_, (BirdFontWidget*) _tmp107_);
	_tmp108_ = bird_font_t_ ("COLR and CPAL tables");
	_tmp109_ = _tmp108_;
	_tmp110_ = bird_font_check_box_new (_tmp109_, label_size);
	_g_object_unref0 (self->priv->colr_table);
	self->priv->colr_table = _tmp110_;
	_g_free0 (_tmp109_);
	_tmp111_ = self->priv->colr_table;
	_tmp111_->checked = FALSE;
	_tmp112_ = self->priv->colr_table;
	g_signal_connect_object (_tmp112_, "updated", (GCallback) ___lambda188__bird_font_check_box_updated, self, 0);
	_tmp113_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp114_ = self->priv->colr_table;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp113_, (BirdFontWidget*) _tmp114_);
	_tmp115_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp116_ = self->priv->colr_table;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp115_, (BirdFontWidget*) _tmp116_);
	_tmp117_ = self->priv->colr_table;
	((BirdFontWidget*) _tmp117_)->margin_bottom = (gdouble) 20;
	_tmp118_ = bird_font_t_ ("Name and Description");
	_tmp119_ = _tmp118_;
	_tmp120_ = bird_font_button_new (_tmp119_, margin);
	_g_object_unref0 (self->priv->name_tab);
	self->priv->name_tab = _tmp120_;
	_g_free0 (_tmp119_);
	_tmp121_ = self->priv->name_tab;
	g_signal_connect_object (_tmp121_, "action", (GCallback) ___lambda189__bird_font_button_action, self, 0);
	_tmp122_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp123_ = self->priv->name_tab;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp122_, (BirdFontWidget*) _tmp123_);
	_tmp124_ = bird_font_t_ ("Export");
	_tmp125_ = _tmp124_;
	_tmp126_ = bird_font_button_new (_tmp125_, margin);
	_g_object_unref0 (self->priv->export_action);
	self->priv->export_action = _tmp126_;
	_g_free0 (_tmp125_);
	_tmp127_ = self->priv->export_action;
	g_signal_connect_object (_tmp127_, "action", (GCallback) ___lambda209__bird_font_button_action, self, 0);
	_tmp128_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp129_ = self->priv->export_action;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp128_, (BirdFontWidget*) _tmp129_);
	_tmp130_ = self->priv->file_name;
	bird_font_table_layout_set_focus ((BirdFontTableLayout*) self, (BirdFontWidget*) _tmp130_);
	_g_object_unref0 (folder_row);
	_g_free0 (folder);
	_g_free0 (fn);
	_g_object_unref0 (font);
	_g_object_unref0 (headline);
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return self;
}

BirdFontExportSettings*
bird_font_export_settings_new (void)
{
	return bird_font_export_settings_construct (BIRD_FONT_TYPE_EXPORT_SETTINGS);
}

gchar*
bird_font_export_settings_get_file_name (BirdFontFont* font)
{
	gchar* n = NULL;
	BirdFontFontSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (font != NULL, NULL);
	_tmp0_ = font->settings;
	_tmp1_ = bird_font_font_settings_get_setting (_tmp0_, "file_name");
	n = _tmp1_;
	_tmp2_ = n;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = font->full_name;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (n);
		n = _tmp4_;
	}
	result = n;
	return result;
}

gchar*
bird_font_export_settings_get_file_name_mac (BirdFontFont* font)
{
	gchar* n = NULL;
	BirdFontFontSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (font != NULL, NULL);
	_tmp0_ = font->settings;
	_tmp1_ = bird_font_font_settings_get_setting (_tmp0_, "file_name_mac");
	n = _tmp1_;
	_tmp2_ = n;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = font->full_name;
		_tmp4_ = g_strconcat (_tmp3_, " Mac", NULL);
		_g_free0 (n);
		n = _tmp4_;
	}
	result = n;
	return result;
}

gboolean
bird_font_export_settings_export_ttf_setting (BirdFontFont* f)
{
	BirdFontFontSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (f != NULL, FALSE);
	_tmp0_ = f->settings;
	_tmp1_ = bird_font_font_settings_get_setting (_tmp0_, "export_ttf");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "false") != 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
bird_font_export_settings_export_eot_setting (BirdFontFont* f)
{
	BirdFontFontSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (f != NULL, FALSE);
	_tmp0_ = f->settings;
	_tmp1_ = bird_font_font_settings_get_setting (_tmp0_, "export_eot");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "false") != 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
bird_font_export_settings_export_svg_setting (BirdFontFont* f)
{
	BirdFontFontSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (f != NULL, FALSE);
	_tmp0_ = f->settings;
	_tmp1_ = bird_font_font_settings_get_setting (_tmp0_, "export_svg");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "false") != 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
bird_font_export_settings_has_export_settings (BirdFontFont* f)
{
	BirdFontFontSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (f != NULL, FALSE);
	_tmp0_ = f->settings;
	_tmp1_ = bird_font_font_settings_get_setting (_tmp0_, "has_export_settings");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "true") == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
bird_font_export_settings_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontExportSettings * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontExportSettings*) base;
	_tmp0_ = bird_font_t_ ("Export Settings");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_export_settings_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontExportSettings * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontExportSettings*) base;
	_tmp0_ = g_strdup ("Export Settings");
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_export_settings_paste (BirdFontExportSettings* self,
                                 const gchar* text)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((BirdFontTableLayout*) self)->focus_index;
	if ((0 <= _tmp3_) && (_tmp3_ < _tmp2_)) {
		BirdFontWidget* widget = NULL;
		GeeArrayList* _tmp4_;
		gpointer _tmp5_;
		BirdFontWidget* _tmp6_;
		_tmp4_ = ((BirdFontTableLayout*) self)->focus_ring;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, ((BirdFontTableLayout*) self)->focus_index);
		widget = (BirdFontWidget*) _tmp5_;
		_tmp6_ = widget;
		if (BIRD_FONT_IS_TEXT_AREA (_tmp6_)) {
			BirdFontTextArea* text_area = NULL;
			BirdFontWidget* _tmp7_;
			BirdFontTextArea* _tmp8_;
			BirdFontTextArea* _tmp9_;
			_tmp7_ = widget;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, BIRD_FONT_TYPE_TEXT_AREA, BirdFontTextArea));
			text_area = _tmp8_;
			_tmp9_ = text_area;
			bird_font_text_area_insert_text (_tmp9_, text);
			_g_object_unref0 (text_area);
		}
		_g_object_unref0 (widget);
	}
}

gchar*
bird_font_export_settings_get_copy_selection (BirdFontExportSettings* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((BirdFontTableLayout*) self)->focus_index;
	if ((0 <= _tmp3_) && (_tmp3_ < _tmp2_)) {
		BirdFontWidget* widget = NULL;
		GeeArrayList* _tmp4_;
		gpointer _tmp5_;
		BirdFontWidget* _tmp6_;
		_tmp4_ = ((BirdFontTableLayout*) self)->focus_ring;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, ((BirdFontTableLayout*) self)->focus_index);
		widget = (BirdFontWidget*) _tmp5_;
		_tmp6_ = widget;
		if (BIRD_FONT_IS_TEXT_AREA (_tmp6_)) {
			BirdFontTextArea* text_area = NULL;
			BirdFontWidget* _tmp7_;
			BirdFontTextArea* _tmp8_;
			BirdFontTextArea* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = widget;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, BIRD_FONT_TYPE_TEXT_AREA, BirdFontTextArea));
			text_area = _tmp8_;
			_tmp9_ = text_area;
			_tmp10_ = bird_font_text_area_get_selected_text (_tmp9_);
			result = _tmp10_;
			_g_object_unref0 (text_area);
			_g_object_unref0 (widget);
			return result;
		}
		_g_object_unref0 (widget);
	}
	_tmp11_ = g_strdup ("");
	result = _tmp11_;
	return result;
}

void
bird_font_export_settings_show_plus_version_needed_for_color_tables (BirdFontExportSettings* self)
{
	BirdFontMessageDialog* dialog = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontMessageDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_t_ ("You need the plus version to export color fonts.");
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_main_window_show_message (_tmp1_);
	_g_object_unref0 (dialog);
	dialog = _tmp2_;
	_g_free0 (_tmp1_);
	bird_font_main_window_show_dialog ((BirdFontDialog*) dialog);
	_g_object_unref0 (dialog);
}

static void
bird_font_export_settings_class_init (BirdFontExportSettingsClass * klass,
                                      gpointer klass_data)
{
	bird_font_export_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontExportSettings_private_offset);
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_export_settings_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_export_settings_real_get_name;
	G_OBJECT_CLASS (klass)->finalize = bird_font_export_settings_finalize;
}

static void
bird_font_export_settings_instance_init (BirdFontExportSettings * self,
                                         gpointer klass)
{
	self->priv = bird_font_export_settings_get_instance_private (self);
}

static void
bird_font_export_settings_finalize (GObject * obj)
{
	BirdFontExportSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_EXPORT_SETTINGS, BirdFontExportSettings);
	_g_object_unref0 (self->priv->file_name);
	_g_object_unref0 (self->priv->file_name_mac);
	_g_object_unref0 (self->priv->units_per_em);
	_g_object_unref0 (self->priv->ttf);
	_g_object_unref0 (self->priv->eot);
	_g_object_unref0 (self->priv->svg);
	_g_object_unref0 (self->priv->svg_table);
	_g_object_unref0 (self->priv->colr_table);
	_g_object_unref0 (self->priv->export_action);
	_g_object_unref0 (self->priv->name_tab);
	G_OBJECT_CLASS (bird_font_export_settings_parent_class)->finalize (obj);
}

static GType
bird_font_export_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontExportSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_export_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontExportSettings), 0, (GInstanceInitFunc) bird_font_export_settings_instance_init, NULL };
	GType bird_font_export_settings_type_id;
	bird_font_export_settings_type_id = g_type_register_static (BIRD_FONT_TYPE_TABLE_LAYOUT, "BirdFontExportSettings", &g_define_type_info, 0);
	BirdFontExportSettings_private_offset = g_type_add_instance_private (bird_font_export_settings_type_id, sizeof (BirdFontExportSettingsPrivate));
	return bird_font_export_settings_type_id;
}

GType
bird_font_export_settings_get_type (void)
{
	static volatile gsize bird_font_export_settings_type_id__once = 0;
	if (g_once_init_enter (&bird_font_export_settings_type_id__once)) {
		GType bird_font_export_settings_type_id;
		bird_font_export_settings_type_id = bird_font_export_settings_get_type_once ();
		g_once_init_leave (&bird_font_export_settings_type_id__once, bird_font_export_settings_type_id);
	}
	return bird_font_export_settings_type_id__once;
}

