/* Expander.c generated by valac 0.56.16, the Vala compiler
 * generated from Expander.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <gee.h>

#define BIRD_FONT_EXPANDER_HEADLINE_MARGIN ((gdouble) 4)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_EXPANDER_0_PROPERTY,
	BIRD_FONT_EXPANDER_NUM_PROPERTIES
};
static GParamSpec* bird_font_expander_properties[BIRD_FONT_EXPANDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _BirdFontExpanderPrivate {
	gboolean persist;
	gboolean unique;
	gdouble content_height;
	gchar* headline;
	BirdFontText* title;
	cairo_surface_t* cached;
};

static gint BirdFontExpander_private_offset;
static gpointer bird_font_expander_parent_class = NULL;

static void __lambda92_ (BirdFontExpander* self);
static void ___lambda92__bird_font_tool_redraw_tool (BirdFontTool* _sender,
                                              gpointer self);
static void __lambda93_ (BirdFontExpander* self,
                  BirdFontTool* selected);
static void ___lambda93__bird_font_tool_select_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gpointer self);
static void bird_font_expander_finalize (GObject * obj);
static GType bird_font_expander_get_type_once (void);

static inline gpointer
bird_font_expander_get_instance_private (BirdFontExpander* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontExpander_private_offset);
}

BirdFontExpander*
bird_font_expander_construct (GType object_type,
                              const gchar* headline)
{
	BirdFontExpander * self = NULL;
	gchar* _tmp0_;
	BirdFontText* _tmp1_;
	GeeArrayList* _tmp3_;
	self = (BirdFontExpander*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (headline);
	_g_free0 (self->priv->headline);
	self->priv->headline = _tmp0_;
	_tmp1_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->priv->title);
	self->priv->title = _tmp1_;
	if (headline != NULL) {
		BirdFontText* _tmp2_;
		_tmp2_ = self->priv->title;
		bird_font_text_set_text (_tmp2_, (const gchar*) headline);
	}
	_tmp3_ = gee_array_list_new (BIRD_FONT_TYPE_TOOL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->tool);
	self->tool = _tmp3_;
	return self;
}

BirdFontExpander*
bird_font_expander_new (const gchar* headline)
{
	return bird_font_expander_construct (BIRD_FONT_TYPE_EXPANDER, headline);
}

void
bird_font_expander_clear_cache (BirdFontExpander* self)
{
	g_return_if_fail (self != NULL);
	_cairo_surface_destroy0 (self->priv->cached);
	self->priv->cached = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_expander_set_headline (BirdFontExpander* self,
                                 BirdFontText* h)
{
	gchar* _tmp0_;
	BirdFontText* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (h != NULL);
	_tmp0_ = bird_font_text_get_text (h);
	_g_free0 (self->priv->headline);
	self->priv->headline = _tmp0_;
	_tmp1_ = _g_object_ref0 (h);
	_g_object_unref0 (self->priv->title);
	self->priv->title = _tmp1_;
}

gdouble
bird_font_expander_get_content_height (BirdFontExpander* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->content_height;
	return result;
}

/** Returns true if tools can be used with the current canvas after
 * they have been selectes and false if they are a commands to be executed.
 */
gboolean
bird_font_expander_is_persistent (BirdFontExpander* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->persist;
	return result;
}

/** Returns true if all other tools in thid expander should be deselected 
 * when a tool is selected.
 */
gboolean
bird_font_expander_is_unique (BirdFontExpander* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->unique;
	return result;
}

void
bird_font_expander_set_persistent (BirdFontExpander* self,
                                   gboolean p)
{
	g_return_if_fail (self != NULL);
	self->priv->persist = p;
}

void
bird_font_expander_set_unique (BirdFontExpander* self,
                               gboolean u)
{
	g_return_if_fail (self != NULL);
	self->priv->unique = u;
}

void
bird_font_expander_update_tool_position (BirdFontExpander* self)
{
	gdouble scale = 0.0;
	gdouble margin_small = 0.0;
	gdouble xt = 0.0;
	gdouble yt = 0.0;
	gboolean new_row = FALSE;
	gboolean has_visible_tools = FALSE;
	BirdFontTool* previous = NULL;
	gboolean first_row = FALSE;
	GeeArrayList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gboolean _tmp44_ = FALSE;
	const gchar* _tmp45_;
	GeeArrayList* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	g_return_if_fail (self != NULL);
	scale = bird_font_toolbox_get_scale ();
	margin_small = 5 * scale;
	xt = self->x;
	yt = self->y + margin_small;
	new_row = FALSE;
	has_visible_tools = FALSE;
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp0_;
		gint _t_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _t_index = 0;
		_tmp0_ = self->tool;
		_t_list = _tmp0_;
		_tmp1_ = _t_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_t_size = _tmp3_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontTool* t = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontTool* _tmp8_;
			_t_index = _t_index + 1;
			_tmp4_ = _t_index;
			_tmp5_ = _t_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _t_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _t_index);
			t = (BirdFontTool*) _tmp7_;
			_tmp8_ = t;
			if (bird_font_tool_tool_is_visible (_tmp8_)) {
				has_visible_tools = TRUE;
				_g_object_unref0 (t);
				break;
			}
			_g_object_unref0 (t);
		}
	}
	if (!has_visible_tools) {
		self->priv->content_height = (gdouble) 0;
		_g_object_unref0 (previous);
		return;
	}
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp9_;
		gint _t_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _t_index = 0;
		_tmp9_ = self->tool;
		_t_list = _tmp9_;
		_tmp10_ = _t_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_t_size = _tmp12_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			BirdFontTool* t = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			BirdFontTool* _tmp17_;
			_t_index = _t_index + 1;
			_tmp13_ = _t_index;
			_tmp14_ = _t_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _t_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _t_index);
			t = (BirdFontTool*) _tmp16_;
			_tmp17_ = t;
			if (BIRD_FONT_IS_ZOOM_BAR (_tmp17_)) {
				BirdFontTool* _tmp18_;
				BirdFontTool* _tmp19_;
				_tmp18_ = t;
				_tmp18_->w = bird_font_toolbox_allocation_width * scale;
				_tmp19_ = t;
				_tmp19_->h = 10 * scale;
			} else {
				BirdFontTool* _tmp20_;
				_tmp20_ = t;
				if (BIRD_FONT_IS_LABEL_TOOL (_tmp20_)) {
					BirdFontTool* _tmp21_;
					BirdFontTool* _tmp22_;
					_tmp21_ = t;
					_tmp21_->w = bird_font_toolbox_allocation_width * scale;
					_tmp22_ = t;
					_tmp22_->h = 22 * scale;
				} else {
					BirdFontTool* _tmp23_;
					_tmp23_ = t;
					if (BIRD_FONT_IS_FONT_NAME (_tmp23_)) {
						BirdFontTool* _tmp24_;
						BirdFontTool* _tmp25_;
						_tmp24_ = t;
						_tmp24_->w = bird_font_toolbox_allocation_width * scale;
						_tmp25_ = t;
						_tmp25_->h = 20 * scale;
					} else {
						BirdFontTool* _tmp26_;
						_tmp26_ = t;
						if (BIRD_FONT_IS_KERNING_RANGE (_tmp26_)) {
							BirdFontTool* _tmp27_;
							BirdFontTool* _tmp28_;
							_tmp27_ = t;
							_tmp27_->w = bird_font_toolbox_allocation_width * scale;
							_tmp28_ = t;
							_tmp28_->h = 17 * scale;
						} else {
							BirdFontTool* _tmp29_;
							_tmp29_ = t;
							if (BIRD_FONT_IS_LAYER_LABEL (_tmp29_)) {
								BirdFontTool* _tmp30_;
								BirdFontTool* _tmp31_;
								_tmp30_ = t;
								_tmp30_->w = bird_font_toolbox_allocation_width * scale;
								_tmp31_ = t;
								_tmp31_->h = 21 * scale;
							} else {
								BirdFontTool* _tmp32_;
								_tmp32_ = t;
								if (BIRD_FONT_IS_COLOR_PICKER (_tmp32_)) {
									BirdFontTool* _tmp33_;
									BirdFontTool* _tmp34_;
									BirdFontTool* _tmp35_;
									_tmp33_ = t;
									_tmp33_->w = bird_font_toolbox_allocation_width * scale;
									_tmp34_ = t;
									_tmp35_ = t;
									_tmp34_->h = 5 * G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, BIRD_FONT_TYPE_COLOR_PICKER, BirdFontColorPicker)->bar_height;
								} else {
									BirdFontTool* _tmp36_;
									BirdFontTool* _tmp37_;
									_tmp36_ = t;
									_tmp36_->w = 33 * scale;
									_tmp37_ = t;
									_tmp37_->h = (33 / 1.11) * scale;
								}
							}
						}
					}
				}
			}
			_g_object_unref0 (t);
		}
	}
	_tmp38_ = self->tool;
	_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ > 0) {
		GeeArrayList* _tmp41_;
		gpointer _tmp42_;
		BirdFontTool* _tmp43_;
		_tmp41_ = self->tool;
		_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, 0);
		_tmp43_ = (BirdFontTool*) _tmp42_;
		self->priv->content_height = _tmp43_->h + margin_small;
		_g_object_unref0 (_tmp43_);
	} else {
		self->priv->content_height = (gdouble) 0;
	}
	_tmp45_ = self->priv->headline;
	if (_tmp45_ != NULL) {
		GeeArrayList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		_tmp46_ = self->tool;
		_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp44_ = _tmp48_ > 0;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		yt += (17 * scale) + BIRD_FONT_EXPANDER_HEADLINE_MARGIN;
		self->priv->content_height = self->priv->content_height + ((17 * scale) + BIRD_FONT_EXPANDER_HEADLINE_MARGIN);
	}
	_tmp49_ = self->tool;
	_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_ > 0) {
		GeeArrayList* _tmp52_;
		gpointer _tmp53_;
		_tmp52_ = self->tool;
		_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, 0);
		_g_object_unref0 (previous);
		previous = (BirdFontTool*) _tmp53_;
		first_row = TRUE;
		{
			GeeArrayList* _t_list = NULL;
			GeeArrayList* _tmp54_;
			gint _t_size = 0;
			GeeArrayList* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			gint _t_index = 0;
			_tmp54_ = self->tool;
			_t_list = _tmp54_;
			_tmp55_ = _t_list;
			_tmp56_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp55_);
			_tmp57_ = _tmp56_;
			_t_size = _tmp57_;
			_t_index = -1;
			while (TRUE) {
				gint _tmp58_;
				gint _tmp59_;
				BirdFontTool* t = NULL;
				GeeArrayList* _tmp60_;
				gpointer _tmp61_;
				BirdFontTool* _tmp62_;
				_t_index = _t_index + 1;
				_tmp58_ = _t_index;
				_tmp59_ = _t_size;
				if (!(_tmp58_ < _tmp59_)) {
					break;
				}
				_tmp60_ = _t_list;
				_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp60_, _t_index);
				t = (BirdFontTool*) _tmp61_;
				_tmp62_ = t;
				if (bird_font_tool_tool_is_visible (_tmp62_)) {
					BirdFontTool* _tmp63_;
					BirdFontTool* _tmp64_;
					BirdFontTool* _tmp70_;
					gboolean _tmp72_ = FALSE;
					BirdFontTool* _tmp79_;
					BirdFontTool* _tmp80_;
					BirdFontTool* _tmp81_;
					BirdFontTool* _tmp82_;
					BirdFontTool* _tmp84_;
					BirdFontTool* _tmp85_;
					_tmp63_ = t;
					new_row = (xt + _tmp63_->w) > (bird_font_toolbox_allocation_width - (7 * scale));
					_tmp64_ = t;
					if (BIRD_FONT_IS_ZOOM_BAR (_tmp64_)) {
						BirdFontTool* _tmp65_;
						BirdFontTool* _tmp66_;
						BirdFontTool* _tmp67_;
						BirdFontTool* _tmp68_;
						BirdFontTool* _tmp69_;
						_tmp65_ = t;
						_tmp65_->x = xt;
						_tmp66_ = t;
						_tmp66_->y = yt;
						_tmp67_ = t;
						yt += _tmp67_->h + (7 * scale);
						_tmp68_ = t;
						_tmp69_ = _g_object_ref0 (_tmp68_);
						_g_object_unref0 (previous);
						previous = _tmp69_;
						_g_object_unref0 (t);
						continue;
					}
					_tmp70_ = previous;
					if (BIRD_FONT_IS_ZOOM_BAR (_tmp70_)) {
						BirdFontTool* _tmp71_;
						_tmp71_ = t;
						self->priv->content_height = self->priv->content_height + _tmp71_->h;
					}
					if (new_row) {
						_tmp72_ = !first_row;
					} else {
						_tmp72_ = FALSE;
					}
					if (_tmp72_) {
						BirdFontTool* _tmp73_;
						BirdFontTool* _tmp74_;
						gboolean _tmp75_ = FALSE;
						BirdFontTool* _tmp76_;
						BirdFontTool* _tmp78_;
						_tmp73_ = previous;
						self->priv->content_height = self->priv->content_height + _tmp73_->h;
						xt = self->x;
						_tmp74_ = previous;
						yt += _tmp74_->h;
						_tmp76_ = t;
						if (!BIRD_FONT_IS_LABEL_TOOL (_tmp76_)) {
							BirdFontTool* _tmp77_;
							_tmp77_ = previous;
							_tmp75_ = !BIRD_FONT_IS_LAYER_LABEL (_tmp77_);
						} else {
							_tmp75_ = FALSE;
						}
						if (_tmp75_) {
							yt += 7 * scale;
						}
						_tmp78_ = previous;
						if (!BIRD_FONT_IS_LAYER_LABEL (_tmp78_)) {
							self->priv->content_height = self->priv->content_height + margin_small;
						}
					}
					_tmp79_ = t;
					_tmp79_->x = xt;
					_tmp80_ = t;
					_tmp80_->y = yt;
					_tmp81_ = t;
					xt += _tmp81_->w + (7 * scale);
					_tmp82_ = previous;
					if (BIRD_FONT_IS_ZOOM_BAR (_tmp82_)) {
						self->priv->content_height = self->priv->content_height + (7 * scale);
					} else {
						BirdFontTool* _tmp83_;
						_tmp83_ = previous;
						if (BIRD_FONT_IS_KERNING_RANGE (_tmp83_)) {
							self->priv->content_height = self->priv->content_height + (10 * scale);
						}
					}
					_tmp84_ = t;
					_tmp85_ = _g_object_ref0 (_tmp84_);
					_g_object_unref0 (previous);
					previous = _tmp85_;
					first_row = FALSE;
				}
				_g_object_unref0 (t);
			}
		}
		self->priv->content_height = self->priv->content_height + (5 * scale);
	}
	if (G_UNLIKELY (self->priv->content_height < ((gdouble) 0))) {
		g_warning ("Expander.vala:208: %s", "content_height < 0");
	}
	_g_object_unref0 (previous);
}

void
bird_font_expander_set_scroll (BirdFontExpander* self,
                               gdouble scroll)
{
	g_return_if_fail (self != NULL);
	self->scroll = scroll;
}

void
bird_font_expander_set_offset (BirdFontExpander* self,
                               gdouble ty)
{
	g_return_if_fail (self != NULL);
	self->y = ty;
	bird_font_expander_update_tool_position (self);
}

void
bird_font_expander_redraw (BirdFontExpander* self)
{
	g_return_if_fail (self != NULL);
	bird_font_toolbox_redraw_tool_box ();
}

static void
__lambda92_ (BirdFontExpander* self)
{
	_cairo_surface_destroy0 (self->priv->cached);
	self->priv->cached = NULL;
}

static void
___lambda92__bird_font_tool_redraw_tool (BirdFontTool* _sender,
                                         gpointer self)
{
	__lambda92_ ((BirdFontExpander*) self);
}

static void
__lambda93_ (BirdFontExpander* self,
             BirdFontTool* selected)
{
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (selected != NULL);
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name (_tmp1_, "redraw", (gint) self->x, (gint) self->y, ((gint) self->w) + 300, (gint) (self->h + self->margin));
	_g_object_unref0 (_tmp1_);
	if (bird_font_expander_is_unique (self)) {
		{
			GeeArrayList* _deselected_list = NULL;
			GeeArrayList* _tmp2_;
			gint _deselected_size = 0;
			GeeArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _deselected_index = 0;
			_tmp2_ = self->tool;
			_deselected_list = _tmp2_;
			_tmp3_ = _deselected_list;
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_deselected_size = _tmp5_;
			_deselected_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				BirdFontTool* deselected = NULL;
				GeeArrayList* _tmp8_;
				gpointer _tmp9_;
				BirdFontTool* _tmp10_;
				_deselected_index = _deselected_index + 1;
				_tmp6_ = _deselected_index;
				_tmp7_ = _deselected_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _deselected_list;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _deselected_index);
				deselected = (BirdFontTool*) _tmp9_;
				_tmp10_ = deselected;
				if (bird_font_tool_get_id (selected) != bird_font_tool_get_id (_tmp10_)) {
					BirdFontTool* _tmp11_;
					_tmp11_ = deselected;
					bird_font_tool_set_selected (_tmp11_, FALSE);
				}
				_g_object_unref0 (deselected);
			}
		}
	}
	if (!selected->new_selection) {
		_tmp12_ = selected->persistent;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		if (bird_font_expander_is_persistent (self)) {
			bird_font_tool_set_selected (selected, TRUE);
		} else {
			bird_font_tool_set_selected (selected, FALSE);
		}
	}
	selected->new_selection = FALSE;
}

static void
___lambda93__bird_font_tool_select_action (BirdFontTool* _sender,
                                           BirdFontTool* selected,
                                           gpointer self)
{
	__lambda93_ ((BirdFontExpander*) self, selected);
}

void
bird_font_expander_add_tool (BirdFontExpander* self,
                             BirdFontTool* t,
                             gint position)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	if (position < 0) {
		GeeArrayList* _tmp0_;
		_tmp0_ = self->tool;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, t);
	} else {
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		GeeArrayList* _tmp4_;
		_tmp1_ = self->tool;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		g_return_if_fail (position <= _tmp3_);
		_tmp4_ = self->tool;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp4_, position, t);
	}
	g_signal_connect_object (t, "redraw-tool", (GCallback) ___lambda92__bird_font_tool_redraw_tool, self, 0);
	bird_font_expander_update_tool_position (self);
	g_signal_connect_object (t, "select-action", (GCallback) ___lambda93__bird_font_tool_select_action, self, 0);
}

gboolean
bird_font_expander_is_over (BirdFontExpander* self,
                            gdouble xp,
                            gdouble yp)
{
	gdouble yt = 0.0;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	yt = (self->y + self->scroll) + 2;
	_tmp1_ = yp;
	if (((yt - 7) <= _tmp1_) && (_tmp1_ <= (yt + 7))) {
		_tmp0_ = xp < ((gdouble) 17);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
bird_font_expander_set_active (BirdFontExpander* self,
                               gboolean a)
{
	gboolean r = FALSE;
	gint _tmp0_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	r = self->active != a;
	if (a) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	self->opacity = (gdouble) _tmp0_;
	self->active = a;
	result = r;
	return result;
}

void
bird_font_expander_cache (BirdFontExpander* self)
{
	cairo_surface_t* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cached;
	if (_tmp0_ == NULL) {
		cairo_surface_t* workbench = NULL;
		cairo_surface_t* _tmp1_;
		cairo_t* context = NULL;
		cairo_surface_t* _tmp2_;
		cairo_t* _tmp3_;
		cairo_t* _tmp4_;
		_tmp1_ = bird_font_screen_create_background_surface (1, 1);
		workbench = _tmp1_;
		_tmp2_ = workbench;
		_tmp3_ = cairo_create (_tmp2_);
		context = _tmp3_;
		_tmp4_ = context;
		bird_font_expander_draw (self, _tmp4_);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (workbench);
	}
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

void
bird_font_expander_draw (BirdFontExpander* self,
                         cairo_t* cr)
{
	cairo_surface_t* cache = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->cached;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		cairo_t* cc = NULL;
		gdouble text_height = 0.0;
		gdouble offset_y = 0.0;
		cairo_surface_t* _tmp1_;
		cairo_surface_t* _tmp2_;
		cairo_t* _tmp3_;
		cairo_t* _tmp4_;
		gboolean _tmp5_ = FALSE;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		cairo_t* _tmp14_;
		cairo_surface_t* _tmp15_;
		cairo_surface_t* _tmp16_;
		text_height = 17 * bird_font_toolbox_get_scale ();
		offset_y = (gdouble) 0;
		_tmp1_ = bird_font_screen_create_background_surface (bird_font_toolbox_allocation_width, (gint) (self->h + self->priv->content_height));
		_cairo_surface_destroy0 (cache);
		cache = _tmp1_;
		_tmp2_ = cache;
		_tmp3_ = cairo_create (_tmp2_);
		_cairo_destroy0 (cc);
		cc = _tmp3_;
		_tmp4_ = cc;
		cairo_scale (_tmp4_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
		_tmp6_ = self->tool;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ > 0) {
			const gchar* _tmp9_;
			_tmp9_ = self->priv->headline;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			BirdFontText* _tmp10_;
			BirdFontText* _tmp11_;
			BirdFontText* _tmp12_;
			cairo_t* _tmp13_;
			_tmp10_ = self->priv->title;
			bird_font_theme_text_color (_tmp10_, "Text Tool Box");
			_tmp11_ = self->priv->title;
			bird_font_text_set_font_size (_tmp11_, text_height);
			_tmp12_ = self->priv->title;
			_tmp13_ = cc;
			bird_font_text_draw_at_top (_tmp12_, _tmp13_, self->x, (gdouble) 0, "");
			offset_y = text_height + BIRD_FONT_EXPANDER_HEADLINE_MARGIN;
		}
		_tmp14_ = cc;
		bird_font_expander_draw_content (self, _tmp14_, offset_y);
		_tmp15_ = cache;
		_tmp16_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp15_);
		_cairo_surface_destroy0 (self->priv->cached);
		self->priv->cached = _tmp16_;
		_cairo_destroy0 (cc);
	}
	_tmp17_ = self->priv->cached;
	if (_tmp17_ != NULL) {
		cairo_surface_t* _tmp18_;
		cairo_surface_t* _tmp19_;
		cairo_surface_t* _tmp20_;
		_tmp18_ = self->priv->cached;
		_tmp19_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp18_);
		_cairo_surface_destroy0 (cache);
		cache = _tmp19_;
		cairo_set_antialias (cr, CAIRO_ANTIALIAS_NONE);
		_tmp20_ = cache;
		bird_font_screen_paint_background_surface (cr, _tmp20_, 0, (gint) (self->y + self->scroll));
	}
	_cairo_surface_destroy0 (cache);
}

void
bird_font_expander_draw_content (BirdFontExpander* self,
                                 cairo_t* cr,
                                 gdouble text_end)
{
	gdouble offset_y = 0.0;
	gdouble offset_x = 0.0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	offset_y = (gdouble) 0;
	offset_x = (gdouble) 0;
	bird_font_expander_update_tool_position (self);
	_tmp0_ = self->tool;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		GeeArrayList* _tmp3_;
		gpointer _tmp4_;
		BirdFontTool* _tmp5_;
		GeeArrayList* _tmp6_;
		gpointer _tmp7_;
		BirdFontTool* _tmp8_;
		_tmp3_ = self->tool;
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
		_tmp5_ = (BirdFontTool*) _tmp4_;
		offset_x = _tmp5_->x;
		_g_object_unref0 (_tmp5_);
		_tmp6_ = self->tool;
		_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, 0);
		_tmp8_ = (BirdFontTool*) _tmp7_;
		offset_y = _tmp8_->y - text_end;
		_g_object_unref0 (_tmp8_);
	}
	cairo_save (cr);
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp9_;
		gint _t_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _t_index = 0;
		_tmp9_ = self->tool;
		_t_list = _tmp9_;
		_tmp10_ = _t_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_t_size = _tmp12_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			BirdFontTool* t = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			BirdFontTool* _tmp17_;
			_t_index = _t_index + 1;
			_tmp13_ = _t_index;
			_tmp14_ = _t_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _t_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _t_index);
			t = (BirdFontTool*) _tmp16_;
			_tmp17_ = t;
			if (bird_font_tool_tool_is_visible (_tmp17_)) {
				BirdFontTool* _tmp18_;
				_tmp18_ = t;
				bird_font_tool_draw_tool (_tmp18_, cr, offset_x - self->x, offset_y);
			}
			_g_object_unref0 (t);
		}
	}
	cairo_restore (cr);
}

static void
bird_font_expander_class_init (BirdFontExpanderClass * klass,
                               gpointer klass_data)
{
	bird_font_expander_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontExpander_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_expander_finalize;
}

static void
bird_font_expander_instance_init (BirdFontExpander * self,
                                  gpointer klass)
{
	self->priv = bird_font_expander_get_instance_private (self);
	self->x = (gdouble) 7;
	self->y = (gdouble) 5;
	self->scroll = (gdouble) 0;
	self->w = (gdouble) 6;
	self->h = (gdouble) 5;
	self->margin = (gdouble) 0;
	self->opacity = (gdouble) 0;
	self->active = FALSE;
	self->priv->persist = FALSE;
	self->priv->unique = FALSE;
	self->priv->content_height = (gdouble) 0;
	self->visible = TRUE;
	self->priv->cached = NULL;
}

static void
bird_font_expander_finalize (GObject * obj)
{
	BirdFontExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_EXPANDER, BirdFontExpander);
	_g_object_unref0 (self->tool);
	_g_free0 (self->priv->headline);
	_g_object_unref0 (self->priv->title);
	_cairo_surface_destroy0 (self->priv->cached);
	G_OBJECT_CLASS (bird_font_expander_parent_class)->finalize (obj);
}

static GType
bird_font_expander_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontExpanderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_expander_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontExpander), 0, (GInstanceInitFunc) bird_font_expander_instance_init, NULL };
	GType bird_font_expander_type_id;
	bird_font_expander_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontExpander", &g_define_type_info, 0);
	BirdFontExpander_private_offset = g_type_add_instance_private (bird_font_expander_type_id, sizeof (BirdFontExpanderPrivate));
	return bird_font_expander_type_id;
}

GType
bird_font_expander_get_type (void)
{
	static volatile gsize bird_font_expander_type_id__once = 0;
	if (g_once_init_enter (&bird_font_expander_type_id__once)) {
		GType bird_font_expander_type_id;
		bird_font_expander_type_id = bird_font_expander_get_type_once ();
		g_once_init_leave (&bird_font_expander_type_id__once, bird_font_expander_type_id);
	}
	return bird_font_expander_type_id__once;
}

