/* EditPoint.c generated by valac 0.56.16, the Vala compiler
 * generated from EditPoint.vala, do not modify */

/*
Copyright (C) 2012 2013 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_EDIT_POINT_0_PROPERTY,
	BIRD_FONT_EDIT_POINT_ACTIVE_POINT_PROPERTY,
	BIRD_FONT_EDIT_POINT_SELECTED_POINT_PROPERTY,
	BIRD_FONT_EDIT_POINT_DELETED_PROPERTY,
	BIRD_FONT_EDIT_POINT_TIE_HANDLES_PROPERTY,
	BIRD_FONT_EDIT_POINT_REFLECTIVE_POINT_PROPERTY,
	BIRD_FONT_EDIT_POINT_INDEPENDENT_X_PROPERTY,
	BIRD_FONT_EDIT_POINT_INDEPENDENT_Y_PROPERTY,
	BIRD_FONT_EDIT_POINT_NUM_PROPERTIES
};
static GParamSpec* bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _bird_font_color_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_color_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer bird_font_edit_point_parent_class = NULL;

static void bird_font_edit_point_finalize (GObject * obj);
static GType bird_font_edit_point_get_type_once (void);
static void _vala_bird_font_edit_point_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_bird_font_edit_point_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static GType
bird_font_point_type_get_type_once (void)
{
	static const GEnumValue values[] = {{BIRD_FONT_POINT_TYPE_NONE, "BIRD_FONT_POINT_TYPE_NONE", "none"}, {BIRD_FONT_POINT_TYPE_LINE_QUADRATIC, "BIRD_FONT_POINT_TYPE_LINE_QUADRATIC", "line-quadratic"}, {BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE, "BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE", "line-double-curve"}, {BIRD_FONT_POINT_TYPE_LINE_CUBIC, "BIRD_FONT_POINT_TYPE_LINE_CUBIC", "line-cubic"}, {BIRD_FONT_POINT_TYPE_CUBIC, "BIRD_FONT_POINT_TYPE_CUBIC", "cubic"}, {BIRD_FONT_POINT_TYPE_DOUBLE_CURVE, "BIRD_FONT_POINT_TYPE_DOUBLE_CURVE", "double-curve"}, {BIRD_FONT_POINT_TYPE_QUADRATIC, "BIRD_FONT_POINT_TYPE_QUADRATIC", "quadratic"}, {BIRD_FONT_POINT_TYPE_HIDDEN, "BIRD_FONT_POINT_TYPE_HIDDEN", "hidden"}, {BIRD_FONT_POINT_TYPE_FLOATING, "BIRD_FONT_POINT_TYPE_FLOATING", "floating"}, {BIRD_FONT_POINT_TYPE_END, "BIRD_FONT_POINT_TYPE_END", "end"}, {0, NULL, NULL}};
	GType bird_font_point_type_type_id;
	bird_font_point_type_type_id = g_enum_register_static ("BirdFontPointType", values);
	return bird_font_point_type_type_id;
}

GType
bird_font_point_type_get_type (void)
{
	static volatile gsize bird_font_point_type_type_id__once = 0;
	if (g_once_init_enter (&bird_font_point_type_type_id__once)) {
		GType bird_font_point_type_type_id;
		bird_font_point_type_type_id = bird_font_point_type_get_type_once ();
		g_once_init_leave (&bird_font_point_type_type_id__once, bird_font_point_type_type_id);
	}
	return bird_font_point_type_type_id__once;
}

BirdFontEditPoint*
bird_font_edit_point_construct (GType object_type,
                                gdouble nx,
                                gdouble ny,
                                BirdFontPointType nt)
{
	BirdFontEditPoint * self = NULL;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	self = (BirdFontEditPoint*) g_object_new (object_type, NULL);
	self->x = nx;
	self->y = ny;
	self->type = nt;
	_tmp0_ = bird_font_edit_point_handle_new (self, (gdouble) 0, (gdouble) 7);
	_g_object_unref0 (self->right_handle);
	self->right_handle = _tmp0_;
	_tmp1_ = bird_font_edit_point_handle_new (self, G_PI, (gdouble) 7);
	_g_object_unref0 (self->left_handle);
	self->left_handle = _tmp1_;
	return self;
}

BirdFontEditPoint*
bird_font_edit_point_new (gdouble nx,
                          gdouble ny,
                          BirdFontPointType nt)
{
	return bird_font_edit_point_construct (BIRD_FONT_TYPE_EDIT_POINT, nx, ny, nt);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

BirdFontEditPoint*
bird_font_edit_point_construct_full (GType object_type,
                                     gdouble nx,
                                     gdouble ny,
                                     BirdFontPointType nt)
{
	BirdFontEditPoint * self = NULL;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (BirdFontEditPoint*) g_object_new (object_type, NULL);
	self->x = nx;
	self->y = ny;
	self->type = nt;
	bird_font_edit_point_set_active_point (self, TRUE);
	if (nt == BIRD_FONT_POINT_TYPE_FLOATING) {
		bird_font_edit_point_set_active_point (self, FALSE);
	}
	_tmp0_ = bird_font_edit_point_handle_new (self, (gdouble) 0, (gdouble) 7);
	_g_object_unref0 (self->right_handle);
	self->right_handle = _tmp0_;
	_tmp1_ = bird_font_edit_point_handle_new (self, G_PI, (gdouble) 7);
	_g_object_unref0 (self->left_handle);
	self->left_handle = _tmp1_;
	if (isnan (nx)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = isnan (ny);
	}
	if (G_UNLIKELY (_tmp2_)) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = double_to_string (nx);
		_tmp4_ = _tmp3_;
		_tmp5_ = double_to_string (ny);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("Invalid point at (", _tmp4_, ",", _tmp6_, ").", NULL);
		_tmp8_ = _tmp7_;
		g_warning ("EditPoint.vala:190: %s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		self->x = (gdouble) 0;
		self->y = (gdouble) 0;
	}
	return self;
}

BirdFontEditPoint*
bird_font_edit_point_new_full (gdouble nx,
                               gdouble ny,
                               BirdFontPointType nt)
{
	return bird_font_edit_point_construct_full (BIRD_FONT_TYPE_EDIT_POINT, nx, ny, nt);
}

gboolean
bird_font_edit_point_is_valid (BirdFontEditPoint* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = bird_font_edit_point_is_valid_position (self->x, self->y);
	return result;
}

gboolean
bird_font_edit_point_is_valid_position (gdouble x,
                                        gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	if (isfinite (x)) {
		_tmp4_ = isfinite (y);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = x > BIRD_FONT_GLYPH_CANVAS_MIN;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = x < BIRD_FONT_GLYPH_CANVAS_MAX;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = y > BIRD_FONT_GLYPH_CANVAS_MIN;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = y < BIRD_FONT_GLYPH_CANVAS_MAX;
	} else {
		_tmp0_ = FALSE;
	}
	result = G_LIKELY (_tmp0_);
	return result;
}

void
bird_font_edit_point_set_point_type (BirdFontEditPoint* self,
                                     BirdFontPointType t)
{
	g_return_if_fail (self != NULL);
	self->type = t;
}

gboolean
bird_font_edit_point_equals (BirdFontEditPoint* self,
                             BirdFontEditPoint* e)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->x == self->x) {
		_tmp4_ = e->y == self->y;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		BirdFontEditPointHandle* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		BirdFontEditPointHandle* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		_tmp5_ = bird_font_edit_point_get_right_handle (self);
		_tmp6_ = bird_font_edit_point_handle_get_x (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = bird_font_edit_point_get_right_handle (e);
		_tmp9_ = bird_font_edit_point_handle_get_x (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp7_ == _tmp10_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		BirdFontEditPointHandle* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		BirdFontEditPointHandle* _tmp14_;
		gdouble _tmp15_;
		gdouble _tmp16_;
		_tmp11_ = bird_font_edit_point_get_right_handle (self);
		_tmp12_ = bird_font_edit_point_handle_get_y (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = bird_font_edit_point_get_right_handle (e);
		_tmp15_ = bird_font_edit_point_handle_get_y (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp2_ = _tmp13_ == _tmp16_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		BirdFontEditPointHandle* _tmp17_;
		gdouble _tmp18_;
		gdouble _tmp19_;
		BirdFontEditPointHandle* _tmp20_;
		gdouble _tmp21_;
		gdouble _tmp22_;
		_tmp17_ = bird_font_edit_point_get_left_handle (self);
		_tmp18_ = bird_font_edit_point_handle_get_x (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = bird_font_edit_point_get_left_handle (e);
		_tmp21_ = bird_font_edit_point_handle_get_x (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp1_ = _tmp19_ == _tmp22_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		BirdFontEditPointHandle* _tmp23_;
		gdouble _tmp24_;
		gdouble _tmp25_;
		BirdFontEditPointHandle* _tmp26_;
		gdouble _tmp27_;
		gdouble _tmp28_;
		_tmp23_ = bird_font_edit_point_get_left_handle (self);
		_tmp24_ = bird_font_edit_point_handle_get_y (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = bird_font_edit_point_get_left_handle (e);
		_tmp27_ = bird_font_edit_point_handle_get_y (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp0_ = _tmp25_ == _tmp28_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/** Make handles symmetrical. */
void
bird_font_edit_point_set_reflective_handles (BirdFontEditPoint* self,
                                             gboolean symmetrical)
{
	g_return_if_fail (self != NULL);
	bird_font_edit_point_set_reflective_point (self, symmetrical);
	if (symmetrical) {
		BirdFontEditPointHandle* _tmp0_;
		BirdFontEditPointHandle* _tmp1_;
		_tmp0_ = bird_font_edit_point_get_left_handle (self);
		bird_font_edit_point_handle_convert_to_curve (_tmp0_);
		_tmp1_ = bird_font_edit_point_get_right_handle (self);
		bird_font_edit_point_handle_convert_to_curve (_tmp1_);
		bird_font_edit_point_process_tied_handle (self);
	}
}

/** Flip handles if next point on path is in the other direction. 
 *  Used to recalculate handles after new point is inserted on a path.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_edit_point_recalculate_handles (BirdFontEditPoint* self,
                                          gdouble px,
                                          gdouble py)
{
	gdouble dr = 0.0;
	gdouble dl = 0.0;
	BirdFontEditPointHandle* t = NULL;
	gboolean _tmp0_ = FALSE;
	BirdFontEditPoint* _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp6_;
	BirdFontEditPoint* _tmp9_;
	BirdFontEditPoint* _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPointHandle* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	BirdFontEditPointHandle* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	BirdFontEditPointHandle* _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	BirdFontEditPointHandle* _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->next;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		BirdFontEditPoint* _tmp2_;
		BirdFontEditPoint* _tmp3_;
		_tmp2_ = bird_font_edit_point_get_next (self);
		_tmp3_ = _tmp2_->next;
		_tmp0_ = _tmp3_ != NULL;
	}
	if (_tmp0_) {
		_g_object_unref0 (t);
		return;
	}
	_tmp5_ = bird_font_edit_point_get_reflective_point (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = bird_font_edit_point_get_tie_handles (self);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	}
	if (G_UNLIKELY (_tmp4_)) {
		g_warning ("EditPoint.vala:242: Points on lines can't have tied handles.");
		_g_object_unref0 (t);
		return;
	}
	_tmp9_ = bird_font_edit_point_get_next (self);
	_tmp10_ = bird_font_edit_point_get_next (_tmp9_);
	px = _tmp10_->x;
	_tmp11_ = bird_font_edit_point_get_next (self);
	_tmp12_ = bird_font_edit_point_get_next (_tmp11_);
	py = _tmp12_->y;
	_tmp13_ = self->right_handle;
	_tmp14_ = bird_font_edit_point_handle_get_x (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->right_handle;
	_tmp17_ = bird_font_edit_point_handle_get_y (_tmp16_);
	_tmp18_ = _tmp17_;
	dr = sqrt (pow (px - _tmp15_, (gdouble) 2) + pow (py - _tmp18_, (gdouble) 2));
	_tmp19_ = self->left_handle;
	_tmp20_ = bird_font_edit_point_handle_get_x (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->left_handle;
	_tmp23_ = bird_font_edit_point_handle_get_y (_tmp22_);
	_tmp24_ = _tmp23_;
	dl = sqrt (pow (px - _tmp21_, (gdouble) 2) + pow (py - _tmp24_, (gdouble) 2));
	if (dl < dr) {
		BirdFontEditPointHandle* _tmp25_;
		BirdFontEditPointHandle* _tmp26_;
		BirdFontEditPointHandle* _tmp27_;
		BirdFontEditPointHandle* _tmp28_;
		BirdFontEditPointHandle* _tmp29_;
		BirdFontEditPointHandle* _tmp30_;
		_tmp25_ = self->right_handle;
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_g_object_unref0 (t);
		t = _tmp26_;
		_tmp27_ = self->left_handle;
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_g_object_unref0 (self->right_handle);
		self->right_handle = _tmp28_;
		_tmp29_ = t;
		_tmp30_ = _g_object_ref0 (_tmp29_);
		_g_object_unref0 (self->left_handle);
		self->left_handle = _tmp30_;
	}
	_g_object_unref0 (t);
}

gboolean
bird_font_edit_point_is_clockwise (BirdFontEditPoint* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = bird_font_edit_point_get_direction (self) >= ((gdouble) 0);
	return result;
}

gdouble
bird_font_edit_point_get_direction (BirdFontEditPoint* self)
{
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->prev;
	if (_tmp0_ == NULL) {
		result = (gdouble) 0;
		return result;
	}
	_tmp1_ = bird_font_edit_point_get_prev (self);
	_tmp2_ = bird_font_edit_point_get_prev (self);
	result = (self->x - _tmp1_->x) * (self->y + _tmp2_->y);
	return result;
}

void
bird_font_edit_point_set_tie_handle (BirdFontEditPoint* self,
                                     gboolean tie)
{
	g_return_if_fail (self != NULL);
	bird_font_edit_point_set_tie_handles (self, tie);
}

void
bird_font_edit_point_to_curve (BirdFontEditPoint* self)
{
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_edit_point_get_right_handle (self);
	bird_font_edit_point_convert_from_line_to_curve (_tmp0_);
	_tmp1_ = bird_font_edit_point_get_left_handle (self);
	bird_font_edit_point_convert_from_line_to_curve (_tmp1_);
}

void
bird_font_edit_point_convert_from_line_to_curve (BirdFontEditPointHandle* h)
{
	g_return_if_fail (h != NULL);
	switch (h->type) {
		case BIRD_FONT_POINT_TYPE_LINE_QUADRATIC:
		{
			h->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
			break;
		}
		case BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE:
		{
			h->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
			break;
		}
		case BIRD_FONT_POINT_TYPE_LINE_CUBIC:
		{
			h->type = BIRD_FONT_POINT_TYPE_CUBIC;
			break;
		}
		default:
		{
			break;
		}
	}
}

void
bird_font_edit_point_process_tied_handle (BirdFontEditPoint* self)
{
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	gdouble a = 0.0;
	gdouble b = 0.0;
	gdouble c = 0.0;
	gdouble length = 0.0;
	gdouble angle = 0.0;
	BirdFontEditPointHandle* eh = NULL;
	BirdFontEditPointHandle* prev_rh = NULL;
	BirdFontEditPointHandle* next_lh = NULL;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	BirdFontEditPointHandle* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	BirdFontEditPointHandle* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	BirdFontEditPointHandle* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	BirdFontEditPointHandle* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	BirdFontEditPointHandle* _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	BirdFontEditPoint* _tmp22_;
	BirdFontEditPointHandle* _tmp23_;
	BirdFontEditPointHandle* _tmp24_;
	BirdFontEditPoint* _tmp25_;
	BirdFontEditPointHandle* _tmp26_;
	BirdFontEditPointHandle* _tmp27_;
	BirdFontEditPointHandle* _tmp28_;
	BirdFontEditPointHandle* _tmp29_;
	BirdFontEditPointHandle* _tmp30_;
	BirdFontEditPointHandle* _tmp31_;
	BirdFontEditPointHandle* _tmp32_;
	BirdFontEditPointHandle* _tmp33_;
	BirdFontEditPointHandle* _tmp34_;
	BirdFontEditPointHandle* _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	BirdFontEditPointHandle* _tmp38_;
	gdouble _tmp39_;
	gdouble _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->next;
	_tmp1_ = self->prev;
	_vala_return_if_fail ((_tmp0_ != NULL) && (_tmp1_ != NULL), "next != null && prev != null");
	_tmp2_ = self->right_handle;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (eh);
	eh = _tmp3_;
	_tmp4_ = self->left_handle;
	_tmp5_ = bird_font_edit_point_handle_get_x (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->right_handle;
	_tmp8_ = bird_font_edit_point_handle_get_x (_tmp7_);
	_tmp9_ = _tmp8_;
	a = _tmp6_ - _tmp9_;
	_tmp10_ = self->left_handle;
	_tmp11_ = bird_font_edit_point_handle_get_y (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->right_handle;
	_tmp14_ = bird_font_edit_point_handle_get_y (_tmp13_);
	_tmp15_ = _tmp14_;
	b = _tmp12_ - _tmp15_;
	c = (a * a) + (b * b);
	if (c == ((gdouble) 0)) {
		_g_object_unref0 (next_lh);
		_g_object_unref0 (prev_rh);
		_g_object_unref0 (eh);
		return;
	}
	length = sqrt (fabs (c));
	_tmp16_ = self->right_handle;
	_tmp17_ = bird_font_edit_point_handle_get_y (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->left_handle;
	_tmp20_ = bird_font_edit_point_handle_get_y (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp18_ < _tmp21_) {
		angle = acos (a / length) + G_PI;
	} else {
		angle = (-acos (a / length)) + G_PI;
	}
	_tmp22_ = bird_font_edit_point_get_prev (self);
	_tmp23_ = bird_font_edit_point_get_right_handle (_tmp22_);
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_g_object_unref0 (prev_rh);
	prev_rh = _tmp24_;
	_tmp25_ = bird_font_edit_point_get_next (self);
	_tmp26_ = bird_font_edit_point_get_left_handle (_tmp25_);
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (next_lh);
	next_lh = _tmp27_;
	_tmp28_ = next_lh;
	bird_font_edit_point_convert_from_line_to_curve (_tmp28_);
	_tmp29_ = prev_rh;
	bird_font_edit_point_convert_from_line_to_curve (_tmp29_);
	_tmp30_ = self->left_handle;
	bird_font_edit_point_convert_from_line_to_curve (_tmp30_);
	_tmp31_ = self->right_handle;
	bird_font_edit_point_convert_from_line_to_curve (_tmp31_);
	_tmp32_ = self->right_handle;
	_tmp32_->angle = angle;
	_tmp33_ = self->left_handle;
	_tmp33_->angle = angle - G_PI;
	bird_font_edit_point_set_tie_handle (self, TRUE);
	_tmp34_ = eh;
	_tmp35_ = self->right_handle;
	_tmp36_ = bird_font_edit_point_handle_get_x (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = self->right_handle;
	_tmp39_ = bird_font_edit_point_handle_get_y (_tmp38_);
	_tmp40_ = _tmp39_;
	bird_font_edit_point_handle_move_to_coordinate (_tmp34_, _tmp37_, _tmp40_);
	_g_object_unref0 (next_lh);
	_g_object_unref0 (prev_rh);
	_g_object_unref0 (eh);
}

static gpointer
_bird_font_color_ref0 (gpointer self)
{
	return self ? bird_font_color_ref (self) : NULL;
}

BirdFontEditPoint*
bird_font_edit_point_copy (BirdFontEditPoint* self)
{
	BirdFontEditPoint* new_point = NULL;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	BirdFontEditPointHandle* _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	BirdFontEditPointHandle* _tmp7_;
	BirdFontEditPointHandle* _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	BirdFontEditPointHandle* _tmp10_;
	BirdFontEditPointHandle* _tmp11_;
	BirdFontEditPointHandle* _tmp12_;
	BirdFontColor* _tmp13_;
	BirdFontColor* _tmp14_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	new_point = _tmp0_;
	new_point->x = self->x;
	new_point->y = self->y;
	new_point->type = self->type;
	new_point->flags = self->flags;
	_tmp1_ = new_point->right_handle;
	_tmp2_ = self->right_handle;
	_tmp1_->angle = _tmp2_->angle;
	_tmp3_ = new_point->right_handle;
	_tmp4_ = self->right_handle;
	_tmp3_->length = _tmp4_->length;
	_tmp5_ = new_point->right_handle;
	_tmp6_ = self->right_handle;
	_tmp5_->type = _tmp6_->type;
	_tmp7_ = new_point->left_handle;
	_tmp8_ = self->left_handle;
	_tmp7_->angle = _tmp8_->angle;
	_tmp9_ = new_point->left_handle;
	_tmp10_ = self->left_handle;
	_tmp9_->length = _tmp10_->length;
	_tmp11_ = new_point->left_handle;
	_tmp12_ = self->left_handle;
	_tmp11_->type = _tmp12_->type;
	_tmp13_ = self->color;
	_tmp14_ = _bird_font_color_ref0 (_tmp13_);
	_bird_font_color_unref0 (new_point->color);
	new_point->color = _tmp14_;
	result = new_point;
	return result;
}

gdouble
bird_font_edit_point_get_distance (BirdFontEditPoint* self,
                                   gdouble x,
                                   gdouble y)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = bird_font_path_distance (self->x, x, self->y, y);
	return result;
}

BirdFontEditPointHandle*
bird_font_edit_point_get_left_handle (BirdFontEditPoint* self)
{
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPointHandle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->left_handle;
	if (G_UNLIKELY (bird_font_is_null (_tmp0_))) {
		g_warning ("EditPoint.vala:364: EditPoint.left_handle is null");
	}
	_tmp1_ = self->left_handle;
	result = _tmp1_;
	return result;
}

BirdFontEditPointHandle*
bird_font_edit_point_get_right_handle (BirdFontEditPoint* self)
{
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPointHandle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->right_handle;
	if (G_UNLIKELY (bird_font_is_null (_tmp0_))) {
		g_warning ("EditPoint.vala:372: EditPoint.right_handle is null");
	}
	_tmp1_ = self->right_handle;
	result = _tmp1_;
	return result;
}

BirdFontEditPoint*
bird_font_edit_point_get_prev (BirdFontEditPoint* self)
{
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->prev;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		g_warning ("EditPoint.vala:380: EditPoint.prev is null");
	}
	_tmp1_ = self->prev;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
	return result;
}

BirdFontEditPoint*
bird_font_edit_point_get_next (BirdFontEditPoint* self)
{
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->next;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		g_warning ("EditPoint.vala:388: EditPoint.next is null");
	}
	_tmp1_ = self->next;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
	return result;
}

BirdFontEditPoint*
bird_font_edit_point_get_link_item (BirdFontEditPoint* self)
{
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_edit_point_set_independet_position (BirdFontEditPoint* self,
                                              gdouble tx,
                                              gdouble ty)
{
	gdouble rx = 0.0;
	gdouble ry = 0.0;
	gdouble lx = 0.0;
	gdouble ly = 0.0;
	BirdFontEditPointHandle* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	BirdFontEditPointHandle* _tmp12_;
	BirdFontEditPointHandle* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->right_handle;
	_tmp1_ = bird_font_edit_point_handle_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	rx = _tmp2_;
	_tmp3_ = self->right_handle;
	_tmp4_ = bird_font_edit_point_handle_get_y (_tmp3_);
	_tmp5_ = _tmp4_;
	ry = _tmp5_;
	_tmp6_ = self->left_handle;
	_tmp7_ = bird_font_edit_point_handle_get_x (_tmp6_);
	_tmp8_ = _tmp7_;
	lx = _tmp8_;
	_tmp9_ = self->left_handle;
	_tmp10_ = bird_font_edit_point_handle_get_y (_tmp9_);
	_tmp11_ = _tmp10_;
	ly = _tmp11_;
	bird_font_edit_point_set_position (self, tx, ty);
	_tmp12_ = self->left_handle;
	bird_font_edit_point_handle_move_to_coordinate (_tmp12_, lx, ly);
	_tmp13_ = self->right_handle;
	bird_font_edit_point_handle_move_to_coordinate (_tmp13_, rx, ry);
}

void
bird_font_edit_point_set_position (BirdFontEditPoint* self,
                                   gdouble tx,
                                   gdouble ty)
{
	BirdFontEditPoint* p = NULL;
	BirdFontEditPoint* n = NULL;
	gboolean _tmp0_ = FALSE;
	BirdFontEditPointHandle* _tmp7_;
	BirdFontEditPointHandle* _tmp21_;
	g_return_if_fail (self != NULL);
	self->x = tx;
	self->y = ty;
	if (isnan (tx)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = isnan (ty);
	}
	if (G_UNLIKELY (_tmp0_)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = double_to_string (tx);
		_tmp2_ = _tmp1_;
		_tmp3_ = double_to_string (ty);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat ("Invalid point at (", _tmp2_, ",", _tmp4_, ").", NULL);
		_tmp6_ = _tmp5_;
		g_warning ("EditPoint.vala:420: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		self->x = (gdouble) 0;
		self->y = (gdouble) 0;
	}
	_tmp7_ = self->right_handle;
	if (_tmp7_->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
		BirdFontEditPoint* _tmp8_;
		_tmp8_ = self->next;
		if (_tmp8_ != NULL) {
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			BirdFontEditPoint* _tmp13_;
			BirdFontEditPointHandle* _tmp14_;
			BirdFontEditPointHandle* _tmp15_;
			gdouble _tmp16_;
			gdouble _tmp17_;
			BirdFontEditPointHandle* _tmp18_;
			gdouble _tmp19_;
			gdouble _tmp20_;
			_tmp9_ = bird_font_edit_point_get_next (self);
			_tmp10_ = _g_object_ref0 (_tmp9_);
			_g_object_unref0 (n);
			n = _tmp10_;
			_tmp11_ = n;
			bird_font_edit_point_set_tie_handle (_tmp11_, FALSE);
			_tmp12_ = n;
			bird_font_edit_point_set_reflective_handles (_tmp12_, FALSE);
			_tmp13_ = n;
			_tmp14_ = _tmp13_->left_handle;
			_tmp15_ = self->right_handle;
			_tmp16_ = bird_font_edit_point_handle_get_x (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->right_handle;
			_tmp19_ = bird_font_edit_point_handle_get_y (_tmp18_);
			_tmp20_ = _tmp19_;
			bird_font_edit_point_handle_move_to_coordinate_internal (_tmp14_, _tmp17_, _tmp20_);
		}
	}
	_tmp21_ = self->left_handle;
	if (_tmp21_->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
		gboolean _tmp22_ = FALSE;
		BirdFontEditPoint* _tmp23_;
		_tmp23_ = self->prev;
		if (_tmp23_ != NULL) {
			BirdFontEditPoint* _tmp24_;
			_tmp24_ = bird_font_edit_point_get_prev (self);
			_tmp22_ = !bird_font_edit_point_is_selected (_tmp24_);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			BirdFontEditPoint* _tmp25_;
			BirdFontEditPoint* _tmp26_;
			BirdFontEditPoint* _tmp27_;
			BirdFontEditPoint* _tmp28_;
			BirdFontEditPoint* _tmp29_;
			BirdFontEditPointHandle* _tmp30_;
			BirdFontEditPointHandle* _tmp31_;
			gdouble _tmp32_;
			gdouble _tmp33_;
			BirdFontEditPointHandle* _tmp34_;
			gdouble _tmp35_;
			gdouble _tmp36_;
			_tmp25_ = bird_font_edit_point_get_prev (self);
			_tmp26_ = _g_object_ref0 (_tmp25_);
			_g_object_unref0 (p);
			p = _tmp26_;
			_tmp27_ = p;
			bird_font_edit_point_set_tie_handle (_tmp27_, FALSE);
			_tmp28_ = p;
			bird_font_edit_point_set_reflective_handles (_tmp28_, FALSE);
			_tmp29_ = p;
			_tmp30_ = _tmp29_->right_handle;
			_tmp31_ = self->left_handle;
			_tmp32_ = bird_font_edit_point_handle_get_x (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = self->left_handle;
			_tmp35_ = bird_font_edit_point_handle_get_y (_tmp34_);
			_tmp36_ = _tmp35_;
			bird_font_edit_point_handle_move_to_coordinate (_tmp30_, _tmp33_, _tmp36_);
		}
	}
	_g_object_unref0 (n);
	_g_object_unref0 (p);
}

void
bird_font_edit_point_to_coordinate (gdouble* x,
                                    gdouble* y)
{
	gdouble xc = 0.0;
	gdouble yc = 0.0;
	gdouble xt = 0.0;
	gdouble yt = 0.0;
	gdouble ivz = 0.0;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	BirdFontWidgetAllocation* _tmp2_;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	ivz = 1 / g->view_zoom;
	_tmp1_ = g->allocation;
	xc = _tmp1_->width / 2.0;
	_tmp2_ = g->allocation;
	yc = _tmp2_->height / 2.0;
	*x = (*x) * ivz;
	*y = (*y) * ivz;
	xt = ((*x) - xc) + g->view_offset_x;
	yt = (yc - (*y)) - g->view_offset_y;
	*x = xt;
	*y = yt;
	_g_object_unref0 (g);
}

gboolean
bird_font_edit_point_is_selected (BirdFontEditPoint* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_edit_point_get_selected_point (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

void
bird_font_edit_point_set_selected (BirdFontEditPoint* self,
                                   gboolean s)
{
	g_return_if_fail (self != NULL);
	bird_font_edit_point_set_selected_point (self, s);
}

gboolean
bird_font_edit_point_set_active (BirdFontEditPoint* self,
                                 gboolean active)
{
	gboolean update = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_edit_point_get_active_point (self);
	_tmp1_ = _tmp0_;
	update = _tmp1_ != active;
	if (update) {
		bird_font_edit_point_set_active_point (self, active);
	}
	result = update;
	return result;
}

void
bird_font_edit_point_convert_to_line (BirdFontEditPoint* self)
{
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->left_handle;
	bird_font_edit_point_handle_convert_to_line (_tmp0_);
	_tmp1_ = self->right_handle;
	bird_font_edit_point_handle_convert_to_line (_tmp1_);
}

void
bird_font_edit_point_convert_to_curve (BirdFontEditPoint* self)
{
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->left_handle;
	bird_font_edit_point_handle_convert_to_curve (_tmp0_);
	_tmp1_ = self->right_handle;
	bird_font_edit_point_handle_convert_to_curve (_tmp1_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
bird_font_edit_point_to_string (BirdFontEditPoint* self)
{
	GString* s = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GString* _tmp11_;
	BirdFontEditPointHandle* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	BirdFontEditPointHandle* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GString* _tmp20_;
	BirdFontEditPointHandle* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	BirdFontEditPointHandle* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GString* _tmp29_;
	GEnumValue* _tmp30_;
	BirdFontEditPointHandle* _tmp31_;
	GEnumValue* _tmp32_;
	BirdFontEditPointHandle* _tmp33_;
	GEnumValue* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GString* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GString* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	s = _tmp0_;
	_tmp1_ = bird_font_edit_point_get_deleted (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = s;
		g_string_append (_tmp3_, "Deleted ");
	}
	_tmp4_ = s;
	_tmp5_ = double_to_string (self->x);
	_tmp6_ = _tmp5_;
	_tmp7_ = double_to_string (self->y);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("Control point: ", _tmp6_, ", ", _tmp8_, "\n", NULL);
	_tmp10_ = _tmp9_;
	g_string_append (_tmp4_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp11_ = s;
	_tmp12_ = self->left_handle;
	_tmp13_ = double_to_string (_tmp12_->angle);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->left_handle;
	_tmp16_ = double_to_string (_tmp15_->length);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat ("Left handle: angle: ", _tmp14_, " l: ", _tmp17_, "\n", NULL);
	_tmp19_ = _tmp18_;
	g_string_append (_tmp11_, _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp20_ = s;
	_tmp21_ = self->right_handle;
	_tmp22_ = double_to_string (_tmp21_->angle);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->right_handle;
	_tmp25_ = double_to_string (_tmp24_->length);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("Right handle: angle: ", _tmp23_, " l: ", _tmp26_, "\n", NULL);
	_tmp28_ = _tmp27_;
	g_string_append (_tmp20_, _tmp28_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp23_);
	_tmp29_ = s;
	_tmp30_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), self->type);
	_tmp31_ = self->left_handle;
	_tmp32_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), _tmp31_->type);
	_tmp33_ = self->right_handle;
	_tmp34_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), _tmp33_->type);
	_tmp35_ = g_strconcat ("Type: ", (_tmp30_ != NULL) ? _tmp30_->value_name : NULL, " Left: ", (_tmp32_ != NULL) ? _tmp32_->value_name : NULL, " Right: ", (_tmp34_ != NULL) ? _tmp34_->value_name : NULL, "\n", NULL);
	_tmp36_ = _tmp35_;
	_tmp37_ = string_replace (_tmp36_, "BIRD_FONT_POINT_TYPE_", "");
	_tmp38_ = _tmp37_;
	g_string_append (_tmp29_, _tmp38_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_tmp39_ = s;
	_tmp40_ = g_strdup_printf ("%u", self->flags);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat ("Flags ", _tmp41_, "\n", NULL);
	_tmp43_ = _tmp42_;
	g_string_append (_tmp39_, _tmp43_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	_tmp44_ = s;
	_tmp45_ = _tmp44_->str;
	_tmp46_ = g_strdup (_tmp45_);
	result = _tmp46_;
	_g_string_free0 (s);
	return result;
}

gboolean
bird_font_edit_point_get_active_point (BirdFontEditPoint* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (self->flags & BIRD_FONT_EDIT_POINT_ACTIVE) > ((guint) 0);
	return result;
}

void
bird_font_edit_point_set_active_point (BirdFontEditPoint* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		self->flags = self->flags | BIRD_FONT_EDIT_POINT_ACTIVE;
	} else {
		self->flags = self->flags & (~BIRD_FONT_EDIT_POINT_ACTIVE);
	}
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_ACTIVE_POINT_PROPERTY]);
}

gboolean
bird_font_edit_point_get_selected_point (BirdFontEditPoint* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (self->flags & BIRD_FONT_EDIT_POINT_SELECTED) > ((guint) 0);
	return result;
}

void
bird_font_edit_point_set_selected_point (BirdFontEditPoint* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		self->flags = self->flags | BIRD_FONT_EDIT_POINT_SELECTED;
	} else {
		self->flags = self->flags & (~BIRD_FONT_EDIT_POINT_SELECTED);
	}
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_SELECTED_POINT_PROPERTY]);
}

gboolean
bird_font_edit_point_get_deleted (BirdFontEditPoint* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (self->flags & BIRD_FONT_EDIT_POINT_DELETED_POINT) > ((guint) 0);
	return result;
}

void
bird_font_edit_point_set_deleted (BirdFontEditPoint* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		self->flags = self->flags | BIRD_FONT_EDIT_POINT_DELETED_POINT;
	} else {
		self->flags = self->flags & (~BIRD_FONT_EDIT_POINT_DELETED_POINT);
	}
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_DELETED_PROPERTY]);
}

gboolean
bird_font_edit_point_get_tie_handles (BirdFontEditPoint* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (self->flags & BIRD_FONT_EDIT_POINT_TIE) > ((guint) 0);
	return result;
}

void
bird_font_edit_point_set_tie_handles (BirdFontEditPoint* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		self->flags = self->flags | BIRD_FONT_EDIT_POINT_TIE;
	} else {
		self->flags = self->flags & (~BIRD_FONT_EDIT_POINT_TIE);
	}
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_TIE_HANDLES_PROPERTY]);
}

gboolean
bird_font_edit_point_get_reflective_point (BirdFontEditPoint* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (self->flags & BIRD_FONT_EDIT_POINT_REFLECTIVE) > ((guint) 0);
	return result;
}

void
bird_font_edit_point_set_reflective_point (BirdFontEditPoint* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		self->flags = self->flags | BIRD_FONT_EDIT_POINT_REFLECTIVE;
	} else {
		self->flags = self->flags & (~BIRD_FONT_EDIT_POINT_REFLECTIVE);
	}
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_REFLECTIVE_POINT_PROPERTY]);
}

gdouble
bird_font_edit_point_get_independent_x (BirdFontEditPoint* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->x;
	return result;
}

void
bird_font_edit_point_set_independent_x (BirdFontEditPoint* self,
                                        gdouble value)
{
	gdouble d = 0.0;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	BirdFontEditPointHandle* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	d = value - self->x;
	self->x = value;
	_tmp0_ = self->right_handle;
	_tmp1_ = self->right_handle;
	_tmp2_ = bird_font_edit_point_handle_get_independent_x (_tmp1_);
	_tmp3_ = _tmp2_;
	bird_font_edit_point_handle_set_independent_x (_tmp1_, _tmp3_ - d);
	_tmp4_ = self->left_handle;
	_tmp5_ = self->left_handle;
	_tmp6_ = bird_font_edit_point_handle_get_independent_x (_tmp5_);
	_tmp7_ = _tmp6_;
	bird_font_edit_point_handle_set_independent_x (_tmp5_, _tmp7_ - d);
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_INDEPENDENT_X_PROPERTY]);
}

gdouble
bird_font_edit_point_get_independent_y (BirdFontEditPoint* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->y;
	return result;
}

void
bird_font_edit_point_set_independent_y (BirdFontEditPoint* self,
                                        gdouble value)
{
	gdouble d = 0.0;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	BirdFontEditPointHandle* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	d = value - self->y;
	self->y = value;
	_tmp0_ = self->right_handle;
	_tmp1_ = self->right_handle;
	_tmp2_ = bird_font_edit_point_handle_get_independent_y (_tmp1_);
	_tmp3_ = _tmp2_;
	bird_font_edit_point_handle_set_independent_y (_tmp1_, _tmp3_ - d);
	_tmp4_ = self->left_handle;
	_tmp5_ = self->left_handle;
	_tmp6_ = bird_font_edit_point_handle_get_independent_y (_tmp5_);
	_tmp7_ = _tmp6_;
	bird_font_edit_point_handle_set_independent_y (_tmp5_, _tmp7_ - d);
	g_object_notify_by_pspec ((GObject *) self, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_INDEPENDENT_Y_PROPERTY]);
}

static void
bird_font_edit_point_class_init (BirdFontEditPointClass * klass,
                                 gpointer klass_data)
{
	bird_font_edit_point_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_edit_point_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_edit_point_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_edit_point_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_ACTIVE_POINT_PROPERTY, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_ACTIVE_POINT_PROPERTY] = g_param_spec_boolean ("active-point", "active-point", "active-point", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_SELECTED_POINT_PROPERTY, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_SELECTED_POINT_PROPERTY] = g_param_spec_boolean ("selected-point", "selected-point", "selected-point", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_DELETED_PROPERTY, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_DELETED_PROPERTY] = g_param_spec_boolean ("deleted", "deleted", "deleted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_TIE_HANDLES_PROPERTY, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_TIE_HANDLES_PROPERTY] = g_param_spec_boolean ("tie-handles", "tie-handles", "tie-handles", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_REFLECTIVE_POINT_PROPERTY, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_REFLECTIVE_POINT_PROPERTY] = g_param_spec_boolean ("reflective-point", "reflective-point", "reflective-point", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Set new position for control point without moving handles. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_INDEPENDENT_X_PROPERTY, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_INDEPENDENT_X_PROPERTY] = g_param_spec_double ("independent-x", "independent-x", "independent-x", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_EDIT_POINT_INDEPENDENT_Y_PROPERTY, bird_font_edit_point_properties[BIRD_FONT_EDIT_POINT_INDEPENDENT_Y_PROPERTY] = g_param_spec_double ("independent-y", "independent-y", "independent-y", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
bird_font_edit_point_instance_init (BirdFontEditPoint * self,
                                    gpointer klass)
{
	self->prev = NULL;
	self->next = NULL;
	self->flags = BIRD_FONT_EDIT_POINT_NONE;
	self->selected_handle = 0;
	self->color = NULL;
}

static void
bird_font_edit_point_finalize (GObject * obj)
{
	BirdFontEditPoint * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
	_g_object_unref0 (self->right_handle);
	_g_object_unref0 (self->left_handle);
	_bird_font_color_unref0 (self->color);
	G_OBJECT_CLASS (bird_font_edit_point_parent_class)->finalize (obj);
}

static GType
bird_font_edit_point_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontEditPointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_edit_point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontEditPoint), 0, (GInstanceInitFunc) bird_font_edit_point_instance_init, NULL };
	GType bird_font_edit_point_type_id;
	bird_font_edit_point_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontEditPoint", &g_define_type_info, 0);
	return bird_font_edit_point_type_id;
}

GType
bird_font_edit_point_get_type (void)
{
	static volatile gsize bird_font_edit_point_type_id__once = 0;
	if (g_once_init_enter (&bird_font_edit_point_type_id__once)) {
		GType bird_font_edit_point_type_id;
		bird_font_edit_point_type_id = bird_font_edit_point_get_type_once ();
		g_once_init_leave (&bird_font_edit_point_type_id__once, bird_font_edit_point_type_id);
	}
	return bird_font_edit_point_type_id__once;
}

static void
_vala_bird_font_edit_point_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	BirdFontEditPoint * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
	switch (property_id) {
		case BIRD_FONT_EDIT_POINT_ACTIVE_POINT_PROPERTY:
		g_value_set_boolean (value, bird_font_edit_point_get_active_point (self));
		break;
		case BIRD_FONT_EDIT_POINT_SELECTED_POINT_PROPERTY:
		g_value_set_boolean (value, bird_font_edit_point_get_selected_point (self));
		break;
		case BIRD_FONT_EDIT_POINT_DELETED_PROPERTY:
		g_value_set_boolean (value, bird_font_edit_point_get_deleted (self));
		break;
		case BIRD_FONT_EDIT_POINT_TIE_HANDLES_PROPERTY:
		g_value_set_boolean (value, bird_font_edit_point_get_tie_handles (self));
		break;
		case BIRD_FONT_EDIT_POINT_REFLECTIVE_POINT_PROPERTY:
		g_value_set_boolean (value, bird_font_edit_point_get_reflective_point (self));
		break;
		case BIRD_FONT_EDIT_POINT_INDEPENDENT_X_PROPERTY:
		g_value_set_double (value, bird_font_edit_point_get_independent_x (self));
		break;
		case BIRD_FONT_EDIT_POINT_INDEPENDENT_Y_PROPERTY:
		g_value_set_double (value, bird_font_edit_point_get_independent_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_edit_point_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	BirdFontEditPoint * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
	switch (property_id) {
		case BIRD_FONT_EDIT_POINT_ACTIVE_POINT_PROPERTY:
		bird_font_edit_point_set_active_point (self, g_value_get_boolean (value));
		break;
		case BIRD_FONT_EDIT_POINT_SELECTED_POINT_PROPERTY:
		bird_font_edit_point_set_selected_point (self, g_value_get_boolean (value));
		break;
		case BIRD_FONT_EDIT_POINT_DELETED_PROPERTY:
		bird_font_edit_point_set_deleted (self, g_value_get_boolean (value));
		break;
		case BIRD_FONT_EDIT_POINT_TIE_HANDLES_PROPERTY:
		bird_font_edit_point_set_tie_handles (self, g_value_get_boolean (value));
		break;
		case BIRD_FONT_EDIT_POINT_REFLECTIVE_POINT_PROPERTY:
		bird_font_edit_point_set_reflective_point (self, g_value_get_boolean (value));
		break;
		case BIRD_FONT_EDIT_POINT_INDEPENDENT_X_PROPERTY:
		bird_font_edit_point_set_independent_x (self, g_value_get_double (value));
		break;
		case BIRD_FONT_EDIT_POINT_INDEPENDENT_Y_PROPERTY:
		bird_font_edit_point_set_independent_y (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

