/* Doubles.c generated by valac 0.56.16, the Vala compiler
 * generated from Doubles.vala, do not modify */

/*
Copyright (C) 2015 2019 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_DOUBLES_0_PROPERTY,
	BIRD_FONT_DOUBLES_NUM_PROPERTIES
};
static GParamSpec* bird_font_doubles_properties[BIRD_FONT_DOUBLES_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BirdFontDoublesPrivate {
	gint capacity;
};

static gint BirdFontDoubles_private_offset;
static gpointer bird_font_doubles_parent_class = NULL;

static void bird_font_doubles_increase_capacity (BirdFontDoubles* self);
static void bird_font_doubles_finalize (GObject * obj);
static GType bird_font_doubles_get_type_once (void);

static inline gpointer
bird_font_doubles_get_instance_private (BirdFontDoubles* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontDoubles_private_offset);
}

BirdFontDoubles*
bird_font_doubles_construct (GType object_type)
{
	BirdFontDoubles * self = NULL;
	gdouble* _tmp0_;
	self = (BirdFontDoubles*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (gdouble, self->priv->capacity);
	self->data = _tmp0_;
	return self;
}

BirdFontDoubles*
bird_font_doubles_new (void)
{
	return bird_font_doubles_construct (BIRD_FONT_TYPE_DOUBLES);
}

BirdFontDoubles*
bird_font_doubles_construct_for_capacity (GType object_type,
                                          gint capacity)
{
	BirdFontDoubles * self = NULL;
	gdouble* _tmp0_;
	self = (BirdFontDoubles*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (gdouble, capacity);
	self->data = _tmp0_;
	self->priv->capacity = capacity;
	return self;
}

BirdFontDoubles*
bird_font_doubles_new_for_capacity (gint capacity)
{
	return bird_font_doubles_construct_for_capacity (BIRD_FONT_TYPE_DOUBLES, capacity);
}

void
bird_font_doubles_clear (BirdFontDoubles* self)
{
	g_return_if_fail (self != NULL);
	self->size = 0;
}

void
bird_font_doubles_set_double (BirdFontDoubles* self,
                              gint index,
                              gdouble p)
{
	gdouble* _tmp0_;
	g_return_if_fail (self != NULL);
	if (G_UNLIKELY (index < 0)) {
		g_warning ("Doubles.vala:44: index < 0");
		return;
	}
	if (G_UNLIKELY (index >= self->size)) {
		g_warning ("Doubles.vala:49: index >= size");
		return;
	}
	_tmp0_ = self->data;
	_tmp0_[index] = p;
}

void
bird_font_doubles_insert (BirdFontDoubles* self,
                          gint index,
                          gdouble p)
{
	gdouble* _tmp0_;
	g_return_if_fail (self != NULL);
	bird_font_doubles_insert_element (self, index);
	_tmp0_ = self->data;
	_tmp0_[index] = p;
}

void
bird_font_doubles_insert_element (BirdFontDoubles* self,
                                  gint index)
{
	gboolean _tmp0_ = FALSE;
	gdouble* point_data = NULL;
	gdouble* _tmp5_;
	gdouble* _tmp10_;
	gdouble* _tmp11_;
	g_return_if_fail (self != NULL);
	if (self->priv->capacity < (self->size + 1)) {
		bird_font_doubles_increase_capacity (self);
	}
	if (index < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = index > self->size;
	}
	if (G_UNLIKELY (_tmp0_)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = g_strdup_printf ("%i", index);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("Bad index ", _tmp2_, ".", NULL);
		_tmp4_ = _tmp3_;
		g_warning ("Doubles.vala:67: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		return;
	}
	_tmp5_ = g_new0 (gdouble, self->priv->capacity);
	point_data = _tmp5_;
	if (index > 0) {
		gdouble* _tmp6_;
		gdouble* _tmp7_;
		_tmp6_ = point_data;
		_tmp7_ = self->data;
		memcpy (_tmp6_, _tmp7_, (gsize) (sizeof (gdouble) * index));
	}
	if (index < self->size) {
		gint dest_position = 0;
		gdouble* _tmp8_;
		gdouble* _tmp9_;
		dest_position = index + 1;
		_tmp8_ = point_data;
		_tmp9_ = self->data;
		memcpy (_tmp8_ + dest_position, _tmp9_ + index, (gsize) (sizeof (gdouble) * (self->size - index)));
	}
	self->size = self->size + 1;
	_tmp10_ = self->data;
	_g_free0 (_tmp10_);
	_tmp11_ = point_data;
	self->data = _tmp11_;
}

void
bird_font_doubles_remove_first (BirdFontDoubles* self,
                                gint n)
{
	g_return_if_fail (self != NULL);
	if (self->size < n) {
		return;
	}
	self->size = self->size - n;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble* _tmp2_;
				gdouble* _tmp3_;
				gdouble _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < self->size)) {
					break;
				}
				_tmp2_ = self->data;
				_tmp3_ = self->data;
				_tmp4_ = _tmp3_[i + n];
				_tmp2_[i] = _tmp4_;
			}
		}
	}
}

void
bird_font_doubles_remove (BirdFontDoubles* self,
                          gint offset,
                          gint length)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (offset < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (offset + length) > self->size;
	}
	if (G_UNLIKELY (_tmp0_)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = g_strdup_printf ("%i", offset);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("%i", length);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", self->size);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat ("Invalid offset: ", _tmp2_, ", length: ", _tmp4_, ", size: ", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		g_warning ("Doubles.vala:101: %s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		return;
	}
	{
		gint i = 0;
		i = offset;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gdouble* _tmp11_;
				gdouble* _tmp12_;
				gdouble _tmp13_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < self->size)) {
					break;
				}
				_tmp11_ = self->data;
				_tmp12_ = self->data;
				_tmp13_ = _tmp12_[i + length];
				_tmp11_[i] = _tmp13_;
			}
		}
	}
	self->size = self->size - length;
}

static void
bird_font_doubles_increase_capacity (BirdFontDoubles* self)
{
	gint new_capacity = 0;
	gdouble* new_data = NULL;
	gdouble* _tmp0_;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	g_return_if_fail (self != NULL);
	new_capacity = 2 * self->priv->capacity;
	_tmp0_ = g_new0 (gdouble, new_capacity);
	new_data = _tmp0_;
	_tmp1_ = self->data;
	memcpy (new_data, _tmp1_, (gsize) (sizeof (gdouble) * self->size));
	_tmp2_ = self->data;
	_g_free0 (_tmp2_);
	self->data = new_data;
	self->priv->capacity = new_capacity;
}

void
bird_font_doubles_add (BirdFontDoubles* self,
                       gdouble d)
{
	gdouble* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->size >= self->priv->capacity) {
		bird_font_doubles_increase_capacity (self);
	}
	_tmp0_ = self->data;
	_tmp0_[self->size] = d;
	_tmp1_ = self->size;
	self->size = _tmp1_ + 1;
}

BirdFontDoubles*
bird_font_doubles_copy (BirdFontDoubles* self)
{
	BirdFontDoubles* d = NULL;
	BirdFontDoubles* _tmp0_;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gdouble* _tmp3_;
	gdouble* _tmp4_;
	BirdFontDoubles* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_doubles_new ();
	d = _tmp0_;
	_tmp1_ = d->data;
	_g_free0 (_tmp1_);
	_tmp2_ = g_new0 (gdouble, self->priv->capacity);
	d->data = _tmp2_;
	d->priv->capacity = self->priv->capacity;
	d->size = self->size;
	_tmp3_ = d->data;
	_tmp4_ = self->data;
	memcpy (_tmp3_, _tmp4_, (gsize) (sizeof (gdouble) * self->size));
	result = d;
	return result;
}

gdouble
bird_font_doubles_get_double (BirdFontDoubles* self,
                              gint index)
{
	gdouble* _tmp0_;
	gdouble _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (G_UNLIKELY (index < 0)) {
		g_warning ("Doubles.vala:142: index < 0");
		result = (gdouble) 0;
		return result;
	}
	if (G_UNLIKELY (index >= self->size)) {
		g_warning ("Doubles.vala:147: index >= size");
		result = (gdouble) 0;
		return result;
	}
	_tmp0_ = self->data;
	_tmp1_ = _tmp0_[index];
	result = _tmp1_;
	return result;
}

gchar*
bird_font_doubles_get_string (BirdFontDoubles* self,
                              gint i)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_doubles_round (bird_font_doubles_get_double (self, i), 5);
	result = _tmp0_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

gchar*
bird_font_doubles_round (gdouble p,
                         gint decimals)
{
	gchar* v = NULL;
	gchar* _tmp0_;
	gchar* c = NULL;
	gchar* _tmp1_;
	gint c_length1;
	gint _c_size_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	v = _tmp0_;
	_tmp1_ = g_new0 (gchar, 501);
	c = _tmp1_;
	c_length1 = 501;
	_c_size_ = c_length1;
	_tmp2_ = c;
	_tmp2__length1 = c_length1;
	_tmp3_ = g_strdup_printf ("%i", decimals);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("%.", _tmp4_, "f", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_ascii_formatd (_tmp2_, (gint) _tmp2__length1, _tmp6_, p);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (v);
	v = _tmp8_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = v;
	_tmp10_ = string_replace (_tmp9_, ",", ".");
	_g_free0 (v);
	v = _tmp10_;
	_tmp11_ = v;
	if (string_index_of (_tmp11_, "e", 0) != -1) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("0.0");
		_g_free0 (v);
		v = _tmp12_;
	}
	_tmp14_ = v;
	if (string_index_of (_tmp14_, "-", 0) == 0) {
		const gchar* _tmp15_;
		_tmp15_ = v;
		_tmp13_ = double_parse (_tmp15_) == ((gdouble) -0);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("0");
		_g_free0 (v);
		v = _tmp16_;
	}
	_tmp17_ = v;
	_tmp18_ = bird_font_doubles_remove_last_zeros (_tmp17_);
	result = _tmp18_;
	c = (g_free (c), NULL);
	_g_free0 (v);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
bird_font_doubles_remove_last_zeros (const gchar* value)
{
	gchar* v = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_strdup (value);
	v = _tmp0_;
	_tmp1_ = v;
	if (string_index_of (_tmp1_, ".", 0) != -1) {
		const gchar* _tmp10_;
		while (TRUE) {
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			_tmp2_ = v;
			if (!g_str_has_suffix (_tmp2_, "0")) {
				break;
			}
			_tmp3_ = v;
			_tmp4_ = v;
			_tmp5_ = strlen (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = strlen ("0");
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (_tmp3_, (glong) 0, (glong) (_tmp6_ - _tmp8_));
			_g_free0 (v);
			v = _tmp9_;
		}
		_tmp10_ = v;
		if (g_str_has_suffix (_tmp10_, ".")) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			_tmp11_ = v;
			_tmp12_ = v;
			_tmp13_ = strlen (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = strlen (".");
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (_tmp11_, (glong) 0, (glong) (_tmp14_ - _tmp16_));
			_g_free0 (v);
			v = _tmp17_;
		}
	}
	result = v;
	return result;
}

static void
bird_font_doubles_class_init (BirdFontDoublesClass * klass,
                              gpointer klass_data)
{
	bird_font_doubles_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontDoubles_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_doubles_finalize;
}

static void
bird_font_doubles_instance_init (BirdFontDoubles * self,
                                 gpointer klass)
{
	self->priv = bird_font_doubles_get_instance_private (self);
	self->size = 0;
	self->priv->capacity = 10;
}

static void
bird_font_doubles_finalize (GObject * obj)
{
	BirdFontDoubles * self;
	gdouble* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_DOUBLES, BirdFontDoubles);
	_tmp0_ = self->data;
	_g_free0 (_tmp0_);
	self->data = NULL;
	G_OBJECT_CLASS (bird_font_doubles_parent_class)->finalize (obj);
}

static GType
bird_font_doubles_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontDoublesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_doubles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontDoubles), 0, (GInstanceInitFunc) bird_font_doubles_instance_init, NULL };
	GType bird_font_doubles_type_id;
	bird_font_doubles_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontDoubles", &g_define_type_info, 0);
	BirdFontDoubles_private_offset = g_type_add_instance_private (bird_font_doubles_type_id, sizeof (BirdFontDoublesPrivate));
	return bird_font_doubles_type_id;
}

GType
bird_font_doubles_get_type (void)
{
	static volatile gsize bird_font_doubles_type_id__once = 0;
	if (g_once_init_enter (&bird_font_doubles_type_id__once)) {
		GType bird_font_doubles_type_id;
		bird_font_doubles_type_id = bird_font_doubles_get_type_once ();
		g_once_init_leave (&bird_font_doubles_type_id__once, bird_font_doubles_type_id);
	}
	return bird_font_doubles_type_id__once;
}

