/* DescriptionDisplay.c generated by valac 0.56.16, the Vala compiler
 * generated from DescriptionDisplay.vala, do not modify */

/*
Copyright (C) 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_DESCRIPTION_DISPLAY_0_PROPERTY,
	BIRD_FONT_DESCRIPTION_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* bird_font_description_display_properties[BIRD_FONT_DESCRIPTION_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block10Data Block10Data;

#define BIRD_FONT_TYPE_HEADLINE (bird_font_headline_get_type ())
#define BIRD_FONT_HEADLINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_HEADLINE, BirdFontHeadline))
#define BIRD_FONT_HEADLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_HEADLINE, BirdFontHeadlineClass))
#define BIRD_FONT_IS_HEADLINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_HEADLINE))
#define BIRD_FONT_IS_HEADLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_HEADLINE))
#define BIRD_FONT_HEADLINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_HEADLINE, BirdFontHeadlineClass))

typedef struct _BirdFontHeadline BirdFontHeadline;
typedef struct _BirdFontHeadlineClass BirdFontHeadlineClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontDescriptionDisplayPrivate {
	BirdFontTextArea* postscript_name;
	BirdFontTextArea* name;
	BirdFontTextArea* style;
	BirdFontCheckBox* bold;
	BirdFontCheckBox* italic;
	BirdFontTextArea* weight;
	BirdFontTextArea* italic_angle;
	BirdFontTextArea* full_name;
	BirdFontTextArea* unique_id;
	BirdFontTextArea* version;
	BirdFontTextArea* description;
	BirdFontTextArea* copyright;
	BirdFontTextArea* license;
	BirdFontLineTextArea* license_url;
	BirdFontTextArea* trademark;
	BirdFontLineTextArea* manufacturer;
	BirdFontLineTextArea* designer;
	BirdFontLineTextArea* vendor_url;
	BirdFontLineTextArea* designer_url;
};

struct _Block10Data {
	int _ref_count_;
	BirdFontDescriptionDisplay* self;
	BirdFontFont* font;
};

static gint BirdFontDescriptionDisplay_private_offset;
static gpointer bird_font_description_display_parent_class = NULL;
static gboolean bird_font_description_display_disable_copyright;
static gboolean bird_font_description_display_disable_copyright = FALSE;

static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
VALA_EXTERN GType bird_font_headline_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontHeadline* bird_font_headline_new (const gchar* text);
VALA_EXTERN BirdFontHeadline* bird_font_headline_construct (GType object_type,
                                                const gchar* text);
static void __lambda190_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda190__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda191_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda191__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda192_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda192__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda193_ (Block10Data* _data10_,
                   gboolean c);
static void ___lambda193__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                                gboolean checked,
                                                gpointer self);
static void __lambda194_ (Block10Data* _data10_,
                   gboolean c);
static void ___lambda194__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                                gboolean checked,
                                                gpointer self);
static void __lambda195_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda195__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda196_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda196__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda197_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda197__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda198_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda198__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda199_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda199__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void _bird_font_table_layout_scroll_event_bird_font_text_area_scroll (BirdFontTextArea* _sender,
                                                                      gdouble pixels,
                                                                      gpointer self);
static void __lambda200_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda200__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda201_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda201__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda202_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda202__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda203_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda203__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda204_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda204__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda205_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda205__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda206_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda206__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda207_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda207__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static void __lambda208_ (Block10Data* _data10_,
                   const gchar* t);
static void ___lambda208__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                     const gchar* text,
                                                     gpointer self);
static gchar* bird_font_description_display_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_description_display_real_get_name (BirdFontFontDisplay* base);
static void bird_font_description_display_real_selected_canvas (BirdFontFontDisplay* base);
static void bird_font_description_display_finalize (GObject * obj);
static GType bird_font_description_display_get_type_once (void);

static inline gpointer
bird_font_description_display_get_instance_private (BirdFontDescriptionDisplay* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontDescriptionDisplay_private_offset);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		BirdFontDescriptionDisplay* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->font);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda190_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->postscript_name);
	_tmp0_->postscript_name = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda190__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda190_ (self, text);
}

static void
__lambda191_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->name);
	_tmp0_->name = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda191__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda191_ (self, text);
}

static void
__lambda192_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->subfamily);
	_tmp0_->subfamily = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda192__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda192_ (self, text);
}

static void
__lambda193_ (Block10Data* _data10_,
              gboolean c)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	self = _data10_->self;
	_tmp0_ = _data10_->font;
	_tmp0_->bold = c;
	_tmp1_ = _data10_->font;
	bird_font_font_touch (_tmp1_);
}

static void
___lambda193__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                           gboolean checked,
                                           gpointer self)
{
	__lambda193_ (self, checked);
}

static void
__lambda194_ (Block10Data* _data10_,
              gboolean c)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	self = _data10_->self;
	_tmp0_ = _data10_->font;
	_tmp0_->italic = c;
	_tmp1_ = _data10_->font;
	bird_font_font_touch (_tmp1_);
}

static void
___lambda194__bird_font_check_box_updated (BirdFontCheckBox* _sender,
                                           gboolean checked,
                                           gpointer self)
{
	__lambda194_ (self, checked);
}

static void
__lambda195_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	bird_font_font_set_weight (_tmp0_, t);
	_tmp1_ = _data10_->font;
	bird_font_font_touch (_tmp1_);
}

static void
___lambda195__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda195_ (self, text);
}

static void
__lambda196_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	bird_font_font_set_italic_angle (_tmp0_, t);
	_tmp1_ = _data10_->font;
	bird_font_font_touch (_tmp1_);
}

static void
___lambda196__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda196_ (self, text);
}

static void
__lambda197_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	BirdFontToolbox* _tmp3_;
	BirdFontToolbox* _tmp4_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->full_name);
	_tmp0_->full_name = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
	_tmp3_ = bird_font_main_window_get_toolbox ();
	_tmp4_ = _tmp3_;
	bird_font_toolbox_update_all_expanders (_tmp4_);
	_g_object_unref0 (_tmp4_);
}

static void
___lambda197__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda197_ (self, text);
}

static void
__lambda198_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->unique_identifier);
	_tmp0_->unique_identifier = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda198__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda198_ (self, text);
}

static void
__lambda199_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->version);
	_tmp0_->version = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda199__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda199_ (self, text);
}

static void
_bird_font_table_layout_scroll_event_bird_font_text_area_scroll (BirdFontTextArea* _sender,
                                                                 gdouble pixels,
                                                                 gpointer self)
{
	bird_font_table_layout_scroll_event ((BirdFontTableLayout*) self, pixels);
}

static void
__lambda200_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->description);
	_tmp0_->description = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda200__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda200_ (self, text);
}

static void
__lambda201_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->copyright);
	_tmp0_->copyright = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda201__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda201_ (self, text);
}

static void
__lambda202_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->license);
	_tmp0_->license = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda202__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda202_ (self, text);
}

static void
__lambda203_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->license_url);
	_tmp0_->license_url = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda203__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda203_ (self, text);
}

static void
__lambda204_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->trademark);
	_tmp0_->trademark = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda204__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda204_ (self, text);
}

static void
__lambda205_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->manufacturer);
	_tmp0_->manufacturer = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda205__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda205_ (self, text);
}

static void
__lambda206_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->designer);
	_tmp0_->designer = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda206__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda206_ (self, text);
}

static void
__lambda207_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->vendor_url);
	_tmp0_->vendor_url = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda207__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda207_ (self, text);
}

static void
__lambda208_ (Block10Data* _data10_,
              const gchar* t)
{
	BirdFontDescriptionDisplay* self;
	BirdFontFont* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* _tmp2_;
	self = _data10_->self;
	g_return_if_fail (t != NULL);
	_tmp0_ = _data10_->font;
	_tmp1_ = g_strdup (t);
	_g_free0 (_tmp0_->designer_url);
	_tmp0_->designer_url = _tmp1_;
	_tmp2_ = _data10_->font;
	bird_font_font_touch (_tmp2_);
}

static void
___lambda208__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda208_ (self, text);
}

BirdFontDescriptionDisplay*
bird_font_description_display_construct (GType object_type)
{
	BirdFontDescriptionDisplay * self = NULL;
	Block10Data* _data10_;
	gdouble margin = 0.0;
	gdouble label_size = 0.0;
	gdouble label_margin = 0.0;
	BirdFontHeadline* headline = NULL;
	BirdFontFont* _tmp0_;
	BirdFontLineTextArea* _tmp1_;
	BirdFontLineTextArea* _tmp2_;
	BirdFontLineTextArea* _tmp3_;
	BirdFontLineTextArea* _tmp4_;
	BirdFontLineTextArea* _tmp5_;
	BirdFontLineTextArea* _tmp6_;
	BirdFontLineTextArea* _tmp7_;
	BirdFontLineTextArea* _tmp8_;
	BirdFontTextArea* _tmp9_;
	BirdFontTextArea* _tmp10_;
	BirdFontTextArea* _tmp11_;
	BirdFontLineTextArea* _tmp12_;
	BirdFontTextArea* _tmp13_;
	BirdFontLineTextArea* _tmp14_;
	BirdFontLineTextArea* _tmp15_;
	BirdFontLineTextArea* _tmp16_;
	BirdFontLineTextArea* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	BirdFontHeadline* _tmp20_;
	BirdFontHeadline* _tmp21_;
	GeeArrayList* _tmp22_;
	BirdFontHeadline* _tmp23_;
	GeeArrayList* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	BirdFontText* _tmp27_;
	BirdFontText* _tmp28_;
	BirdFontTextArea* _tmp29_;
	BirdFontTextArea* _tmp30_;
	BirdFontFont* _tmp31_;
	const gchar* _tmp32_;
	BirdFontTextArea* _tmp33_;
	GeeArrayList* _tmp34_;
	BirdFontTextArea* _tmp35_;
	GeeArrayList* _tmp36_;
	BirdFontTextArea* _tmp37_;
	GeeArrayList* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	BirdFontText* _tmp41_;
	BirdFontText* _tmp42_;
	BirdFontTextArea* _tmp43_;
	BirdFontTextArea* _tmp44_;
	BirdFontFont* _tmp45_;
	const gchar* _tmp46_;
	BirdFontTextArea* _tmp47_;
	GeeArrayList* _tmp48_;
	BirdFontTextArea* _tmp49_;
	GeeArrayList* _tmp50_;
	BirdFontTextArea* _tmp51_;
	GeeArrayList* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	BirdFontText* _tmp55_;
	BirdFontText* _tmp56_;
	BirdFontTextArea* _tmp57_;
	BirdFontTextArea* _tmp58_;
	BirdFontFont* _tmp59_;
	const gchar* _tmp60_;
	BirdFontTextArea* _tmp61_;
	GeeArrayList* _tmp62_;
	BirdFontTextArea* _tmp63_;
	GeeArrayList* _tmp64_;
	BirdFontTextArea* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	BirdFontCheckBox* _tmp68_;
	BirdFontCheckBox* _tmp69_;
	BirdFontCheckBox* _tmp70_;
	BirdFontFont* _tmp71_;
	GeeArrayList* _tmp72_;
	BirdFontCheckBox* _tmp73_;
	GeeArrayList* _tmp74_;
	BirdFontCheckBox* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	BirdFontCheckBox* _tmp78_;
	BirdFontCheckBox* _tmp79_;
	BirdFontCheckBox* _tmp80_;
	BirdFontFont* _tmp81_;
	BirdFontCheckBox* _tmp82_;
	GeeArrayList* _tmp83_;
	BirdFontCheckBox* _tmp84_;
	GeeArrayList* _tmp85_;
	BirdFontCheckBox* _tmp86_;
	GeeArrayList* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	BirdFontText* _tmp90_;
	BirdFontText* _tmp91_;
	BirdFontTextArea* _tmp92_;
	BirdFontTextArea* _tmp93_;
	BirdFontFont* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	BirdFontTextArea* _tmp97_;
	GeeArrayList* _tmp98_;
	BirdFontTextArea* _tmp99_;
	GeeArrayList* _tmp100_;
	BirdFontTextArea* _tmp101_;
	GeeArrayList* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	BirdFontText* _tmp105_;
	BirdFontText* _tmp106_;
	BirdFontTextArea* _tmp107_;
	BirdFontTextArea* _tmp108_;
	BirdFontFont* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	BirdFontTextArea* _tmp112_;
	GeeArrayList* _tmp113_;
	BirdFontTextArea* _tmp114_;
	GeeArrayList* _tmp115_;
	BirdFontTextArea* _tmp116_;
	GeeArrayList* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	BirdFontText* _tmp120_;
	BirdFontText* _tmp121_;
	BirdFontTextArea* _tmp122_;
	BirdFontTextArea* _tmp123_;
	BirdFontFont* _tmp124_;
	const gchar* _tmp125_;
	BirdFontTextArea* _tmp126_;
	GeeArrayList* _tmp127_;
	BirdFontTextArea* _tmp128_;
	GeeArrayList* _tmp129_;
	BirdFontTextArea* _tmp130_;
	GeeArrayList* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	BirdFontText* _tmp134_;
	BirdFontText* _tmp135_;
	BirdFontTextArea* _tmp136_;
	BirdFontTextArea* _tmp137_;
	BirdFontFont* _tmp138_;
	const gchar* _tmp139_;
	BirdFontTextArea* _tmp140_;
	GeeArrayList* _tmp141_;
	BirdFontTextArea* _tmp142_;
	GeeArrayList* _tmp143_;
	BirdFontTextArea* _tmp144_;
	GeeArrayList* _tmp145_;
	gchar* _tmp146_;
	gchar* _tmp147_;
	BirdFontText* _tmp148_;
	BirdFontText* _tmp149_;
	BirdFontTextArea* _tmp150_;
	BirdFontTextArea* _tmp151_;
	BirdFontFont* _tmp152_;
	const gchar* _tmp153_;
	BirdFontTextArea* _tmp154_;
	GeeArrayList* _tmp155_;
	BirdFontTextArea* _tmp156_;
	GeeArrayList* _tmp157_;
	BirdFontTextArea* _tmp158_;
	GeeArrayList* _tmp159_;
	gchar* _tmp160_;
	gchar* _tmp161_;
	BirdFontText* _tmp162_;
	BirdFontText* _tmp163_;
	BirdFontTextArea* _tmp164_;
	BirdFontTextArea* _tmp165_;
	BirdFontFont* _tmp166_;
	const gchar* _tmp167_;
	BirdFontTextArea* _tmp168_;
	BirdFontTextArea* _tmp169_;
	GeeArrayList* _tmp170_;
	BirdFontTextArea* _tmp171_;
	GeeArrayList* _tmp172_;
	BirdFontTextArea* _tmp173_;
	GeeArrayList* _tmp174_;
	gchar* _tmp175_;
	gchar* _tmp176_;
	BirdFontText* _tmp177_;
	BirdFontText* _tmp178_;
	BirdFontTextArea* _tmp179_;
	BirdFontTextArea* _tmp180_;
	BirdFontFont* _tmp181_;
	const gchar* _tmp182_;
	BirdFontTextArea* _tmp183_;
	BirdFontTextArea* _tmp184_;
	BirdFontTextArea* _tmp185_;
	GeeArrayList* _tmp186_;
	BirdFontTextArea* _tmp187_;
	GeeArrayList* _tmp188_;
	BirdFontTextArea* _tmp189_;
	GeeArrayList* _tmp190_;
	gchar* _tmp191_;
	gchar* _tmp192_;
	BirdFontText* _tmp193_;
	BirdFontText* _tmp194_;
	BirdFontTextArea* _tmp195_;
	BirdFontTextArea* _tmp196_;
	BirdFontFont* _tmp197_;
	const gchar* _tmp198_;
	BirdFontTextArea* _tmp199_;
	BirdFontTextArea* _tmp200_;
	BirdFontTextArea* _tmp201_;
	GeeArrayList* _tmp202_;
	BirdFontTextArea* _tmp203_;
	GeeArrayList* _tmp204_;
	BirdFontTextArea* _tmp205_;
	GeeArrayList* _tmp206_;
	gchar* _tmp207_;
	gchar* _tmp208_;
	BirdFontText* _tmp209_;
	BirdFontText* _tmp210_;
	BirdFontLineTextArea* _tmp211_;
	BirdFontLineTextArea* _tmp212_;
	BirdFontFont* _tmp213_;
	const gchar* _tmp214_;
	BirdFontLineTextArea* _tmp215_;
	BirdFontLineTextArea* _tmp216_;
	BirdFontLineTextArea* _tmp217_;
	GeeArrayList* _tmp218_;
	BirdFontLineTextArea* _tmp219_;
	GeeArrayList* _tmp220_;
	BirdFontLineTextArea* _tmp221_;
	GeeArrayList* _tmp222_;
	gchar* _tmp223_;
	gchar* _tmp224_;
	BirdFontText* _tmp225_;
	BirdFontText* _tmp226_;
	BirdFontTextArea* _tmp227_;
	BirdFontTextArea* _tmp228_;
	BirdFontFont* _tmp229_;
	const gchar* _tmp230_;
	BirdFontTextArea* _tmp231_;
	BirdFontTextArea* _tmp232_;
	BirdFontTextArea* _tmp233_;
	GeeArrayList* _tmp234_;
	BirdFontTextArea* _tmp235_;
	GeeArrayList* _tmp236_;
	BirdFontTextArea* _tmp237_;
	GeeArrayList* _tmp238_;
	gchar* _tmp239_;
	gchar* _tmp240_;
	BirdFontText* _tmp241_;
	BirdFontText* _tmp242_;
	BirdFontLineTextArea* _tmp243_;
	BirdFontLineTextArea* _tmp244_;
	BirdFontFont* _tmp245_;
	const gchar* _tmp246_;
	BirdFontLineTextArea* _tmp247_;
	BirdFontLineTextArea* _tmp248_;
	GeeArrayList* _tmp249_;
	BirdFontLineTextArea* _tmp250_;
	GeeArrayList* _tmp251_;
	BirdFontLineTextArea* _tmp252_;
	GeeArrayList* _tmp253_;
	gchar* _tmp254_;
	gchar* _tmp255_;
	BirdFontText* _tmp256_;
	BirdFontText* _tmp257_;
	BirdFontLineTextArea* _tmp258_;
	BirdFontLineTextArea* _tmp259_;
	BirdFontFont* _tmp260_;
	const gchar* _tmp261_;
	BirdFontLineTextArea* _tmp262_;
	BirdFontLineTextArea* _tmp263_;
	GeeArrayList* _tmp264_;
	BirdFontLineTextArea* _tmp265_;
	GeeArrayList* _tmp266_;
	BirdFontLineTextArea* _tmp267_;
	GeeArrayList* _tmp268_;
	gchar* _tmp269_;
	gchar* _tmp270_;
	BirdFontText* _tmp271_;
	BirdFontText* _tmp272_;
	BirdFontLineTextArea* _tmp273_;
	BirdFontLineTextArea* _tmp274_;
	BirdFontFont* _tmp275_;
	const gchar* _tmp276_;
	BirdFontLineTextArea* _tmp277_;
	BirdFontLineTextArea* _tmp278_;
	GeeArrayList* _tmp279_;
	BirdFontLineTextArea* _tmp280_;
	GeeArrayList* _tmp281_;
	BirdFontLineTextArea* _tmp282_;
	GeeArrayList* _tmp283_;
	gchar* _tmp284_;
	gchar* _tmp285_;
	BirdFontText* _tmp286_;
	BirdFontText* _tmp287_;
	BirdFontLineTextArea* _tmp288_;
	BirdFontLineTextArea* _tmp289_;
	BirdFontFont* _tmp290_;
	const gchar* _tmp291_;
	BirdFontLineTextArea* _tmp292_;
	BirdFontLineTextArea* _tmp293_;
	GeeArrayList* _tmp294_;
	BirdFontLineTextArea* _tmp295_;
	GeeArrayList* _tmp296_;
	BirdFontLineTextArea* _tmp297_;
	BirdFontTextArea* _tmp298_;
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	self = (BirdFontDescriptionDisplay*) bird_font_table_layout_construct (object_type);
	_data10_->self = g_object_ref (self);
	margin = (gdouble) 12;
	label_size = (gdouble) 20;
	label_margin = (gdouble) 4;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_data10_->font = _tmp0_;
	_tmp1_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->postscript_name);
	self->priv->postscript_name = (BirdFontTextArea*) _tmp1_;
	_tmp2_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->name);
	self->priv->name = (BirdFontTextArea*) _tmp2_;
	_tmp3_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->style);
	self->priv->style = (BirdFontTextArea*) _tmp3_;
	_tmp4_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->weight);
	self->priv->weight = (BirdFontTextArea*) _tmp4_;
	_tmp5_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->italic_angle);
	self->priv->italic_angle = (BirdFontTextArea*) _tmp5_;
	_tmp6_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->full_name);
	self->priv->full_name = (BirdFontTextArea*) _tmp6_;
	_tmp7_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->unique_id);
	self->priv->unique_id = (BirdFontTextArea*) _tmp7_;
	_tmp8_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->version);
	self->priv->version = (BirdFontTextArea*) _tmp8_;
	_tmp9_ = bird_font_text_area_new (label_size, NULL);
	_g_object_unref0 (self->priv->description);
	self->priv->description = _tmp9_;
	_tmp10_ = bird_font_text_area_new (label_size, NULL);
	_g_object_unref0 (self->priv->copyright);
	self->priv->copyright = _tmp10_;
	_tmp11_ = bird_font_text_area_new (label_size, NULL);
	_g_object_unref0 (self->priv->license);
	self->priv->license = _tmp11_;
	_tmp12_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->license_url);
	self->priv->license_url = _tmp12_;
	_tmp13_ = bird_font_text_area_new (label_size, NULL);
	_g_object_unref0 (self->priv->trademark);
	self->priv->trademark = _tmp13_;
	_tmp14_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->manufacturer);
	self->priv->manufacturer = _tmp14_;
	_tmp15_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->designer);
	self->priv->designer = _tmp15_;
	_tmp16_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->vendor_url);
	self->priv->vendor_url = _tmp16_;
	_tmp17_ = bird_font_line_text_area_new (label_size);
	_g_object_unref0 (self->priv->designer_url);
	self->priv->designer_url = _tmp17_;
	_tmp18_ = bird_font_t_ ("Name and Description");
	_tmp19_ = _tmp18_;
	_tmp20_ = bird_font_headline_new (_tmp19_);
	_g_object_unref0 (headline);
	headline = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp21_ = headline;
	((BirdFontWidget*) _tmp21_)->margin_bottom = (gdouble) 20;
	_tmp22_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp23_ = headline;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, (BirdFontWidget*) _tmp23_);
	_tmp24_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp25_ = bird_font_t_ ("PostScript Name");
	_tmp26_ = _tmp25_;
	_tmp27_ = bird_font_text_new (_tmp26_, label_size, label_margin);
	_tmp28_ = _tmp27_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (BirdFontWidget*) _tmp28_);
	_g_object_unref0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp29_ = self->priv->postscript_name;
	((BirdFontWidget*) _tmp29_)->margin_bottom = margin;
	_tmp30_ = self->priv->postscript_name;
	_tmp31_ = _data10_->font;
	_tmp32_ = _tmp31_->postscript_name;
	bird_font_text_area_set_text (_tmp30_, _tmp32_);
	_tmp33_ = self->priv->postscript_name;
	g_signal_connect_data (_tmp33_, "text-changed", (GCallback) ___lambda190__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp34_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp35_ = self->priv->postscript_name;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, (BirdFontWidget*) _tmp35_);
	_tmp36_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp37_ = self->priv->postscript_name;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (BirdFontWidget*) _tmp37_);
	_tmp38_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp39_ = bird_font_t_ ("Name");
	_tmp40_ = _tmp39_;
	_tmp41_ = bird_font_text_new (_tmp40_, label_size, label_margin);
	_tmp42_ = _tmp41_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, (BirdFontWidget*) _tmp42_);
	_g_object_unref0 (_tmp42_);
	_g_free0 (_tmp40_);
	_tmp43_ = self->priv->name;
	((BirdFontWidget*) _tmp43_)->margin_bottom = margin;
	_tmp44_ = self->priv->name;
	_tmp45_ = _data10_->font;
	_tmp46_ = _tmp45_->name;
	bird_font_text_area_set_text (_tmp44_, _tmp46_);
	_tmp47_ = self->priv->name;
	g_signal_connect_data (_tmp47_, "text-changed", (GCallback) ___lambda191__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp48_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp49_ = self->priv->name;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, (BirdFontWidget*) _tmp49_);
	_tmp50_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp51_ = self->priv->name;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, (BirdFontWidget*) _tmp51_);
	_tmp52_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp53_ = bird_font_t_ ("Style");
	_tmp54_ = _tmp53_;
	_tmp55_ = bird_font_text_new (_tmp54_, label_size, label_margin);
	_tmp56_ = _tmp55_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, (BirdFontWidget*) _tmp56_);
	_g_object_unref0 (_tmp56_);
	_g_free0 (_tmp54_);
	_tmp57_ = self->priv->style;
	((BirdFontWidget*) _tmp57_)->margin_bottom = 1.5 * margin;
	_tmp58_ = self->priv->style;
	_tmp59_ = _data10_->font;
	_tmp60_ = _tmp59_->subfamily;
	bird_font_text_area_set_text (_tmp58_, _tmp60_);
	_tmp61_ = self->priv->style;
	g_signal_connect_data (_tmp61_, "text-changed", (GCallback) ___lambda192__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp62_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp63_ = self->priv->style;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, (BirdFontWidget*) _tmp63_);
	_tmp64_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp65_ = self->priv->style;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp64_, (BirdFontWidget*) _tmp65_);
	_tmp66_ = bird_font_t_ ("Bold");
	_tmp67_ = _tmp66_;
	_tmp68_ = bird_font_check_box_new (_tmp67_, label_size);
	_g_object_unref0 (self->priv->bold);
	self->priv->bold = _tmp68_;
	_g_free0 (_tmp67_);
	_tmp69_ = self->priv->bold;
	g_signal_connect_data (_tmp69_, "updated", (GCallback) ___lambda193__bird_font_check_box_updated, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp70_ = self->priv->bold;
	_tmp71_ = _data10_->font;
	_tmp70_->checked = _tmp71_->bold;
	_tmp72_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp73_ = self->priv->bold;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp72_, (BirdFontWidget*) _tmp73_);
	_tmp74_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp75_ = self->priv->bold;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp74_, (BirdFontWidget*) _tmp75_);
	_tmp76_ = bird_font_t_ ("Italic");
	_tmp77_ = _tmp76_;
	_tmp78_ = bird_font_check_box_new (_tmp77_, label_size);
	_g_object_unref0 (self->priv->italic);
	self->priv->italic = _tmp78_;
	_g_free0 (_tmp77_);
	_tmp79_ = self->priv->italic;
	g_signal_connect_data (_tmp79_, "updated", (GCallback) ___lambda194__bird_font_check_box_updated, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp80_ = self->priv->italic;
	_tmp81_ = _data10_->font;
	_tmp80_->checked = _tmp81_->italic;
	_tmp82_ = self->priv->italic;
	((BirdFontWidget*) _tmp82_)->margin_bottom = margin;
	_tmp83_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp84_ = self->priv->italic;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp83_, (BirdFontWidget*) _tmp84_);
	_tmp85_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp86_ = self->priv->italic;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp85_, (BirdFontWidget*) _tmp86_);
	_tmp87_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp88_ = bird_font_t_ ("Weight");
	_tmp89_ = _tmp88_;
	_tmp90_ = bird_font_text_new (_tmp89_, label_size, label_margin);
	_tmp91_ = _tmp90_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp87_, (BirdFontWidget*) _tmp91_);
	_g_object_unref0 (_tmp91_);
	_g_free0 (_tmp89_);
	_tmp92_ = self->priv->weight;
	((BirdFontWidget*) _tmp92_)->margin_bottom = margin;
	_tmp93_ = self->priv->weight;
	_tmp94_ = _data10_->font;
	_tmp95_ = bird_font_font_get_weight (_tmp94_);
	_tmp96_ = _tmp95_;
	bird_font_text_area_set_text (_tmp93_, _tmp96_);
	_g_free0 (_tmp96_);
	_tmp97_ = self->priv->weight;
	g_signal_connect_data (_tmp97_, "text-changed", (GCallback) ___lambda195__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp98_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp99_ = self->priv->weight;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, (BirdFontWidget*) _tmp99_);
	_tmp100_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp101_ = self->priv->weight;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, (BirdFontWidget*) _tmp101_);
	_tmp102_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp103_ = bird_font_t_ ("Italic angle, use negative values for text that leans to the right.");
	_tmp104_ = _tmp103_;
	_tmp105_ = bird_font_text_new (_tmp104_, label_size, label_margin);
	_tmp106_ = _tmp105_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp102_, (BirdFontWidget*) _tmp106_);
	_g_object_unref0 (_tmp106_);
	_g_free0 (_tmp104_);
	_tmp107_ = self->priv->italic_angle;
	((BirdFontWidget*) _tmp107_)->margin_bottom = margin;
	_tmp108_ = self->priv->italic_angle;
	_tmp109_ = _data10_->font;
	_tmp110_ = bird_font_doubles_round (_tmp109_->italic_angle, 5);
	_tmp111_ = _tmp110_;
	bird_font_text_area_set_text (_tmp108_, _tmp111_);
	_g_free0 (_tmp111_);
	_tmp112_ = self->priv->italic_angle;
	g_signal_connect_data (_tmp112_, "text-changed", (GCallback) ___lambda196__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp113_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp114_ = self->priv->italic_angle;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp113_, (BirdFontWidget*) _tmp114_);
	_tmp115_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp116_ = self->priv->italic_angle;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp115_, (BirdFontWidget*) _tmp116_);
	_tmp117_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp118_ = bird_font_t_ ("Full Name (Name and Style)");
	_tmp119_ = _tmp118_;
	_tmp120_ = bird_font_text_new (_tmp119_, label_size, label_margin);
	_tmp121_ = _tmp120_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp117_, (BirdFontWidget*) _tmp121_);
	_g_object_unref0 (_tmp121_);
	_g_free0 (_tmp119_);
	_tmp122_ = self->priv->full_name;
	((BirdFontWidget*) _tmp122_)->margin_bottom = margin;
	_tmp123_ = self->priv->full_name;
	_tmp124_ = _data10_->font;
	_tmp125_ = _tmp124_->full_name;
	bird_font_text_area_set_text (_tmp123_, _tmp125_);
	_tmp126_ = self->priv->full_name;
	g_signal_connect_data (_tmp126_, "text-changed", (GCallback) ___lambda197__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp127_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp128_ = self->priv->full_name;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp127_, (BirdFontWidget*) _tmp128_);
	_tmp129_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp130_ = self->priv->full_name;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp129_, (BirdFontWidget*) _tmp130_);
	_tmp131_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp132_ = bird_font_t_ ("Unique Identifier");
	_tmp133_ = _tmp132_;
	_tmp134_ = bird_font_text_new (_tmp133_, label_size, label_margin);
	_tmp135_ = _tmp134_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp131_, (BirdFontWidget*) _tmp135_);
	_g_object_unref0 (_tmp135_);
	_g_free0 (_tmp133_);
	_tmp136_ = self->priv->unique_id;
	((BirdFontWidget*) _tmp136_)->margin_bottom = margin;
	_tmp137_ = self->priv->unique_id;
	_tmp138_ = _data10_->font;
	_tmp139_ = _tmp138_->unique_identifier;
	bird_font_text_area_set_text (_tmp137_, _tmp139_);
	_tmp140_ = self->priv->unique_id;
	g_signal_connect_data (_tmp140_, "text-changed", (GCallback) ___lambda198__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp141_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp142_ = self->priv->unique_id;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp141_, (BirdFontWidget*) _tmp142_);
	_tmp143_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp144_ = self->priv->unique_id;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp143_, (BirdFontWidget*) _tmp144_);
	_tmp145_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp146_ = bird_font_t_ ("Version");
	_tmp147_ = _tmp146_;
	_tmp148_ = bird_font_text_new (_tmp147_, label_size, label_margin);
	_tmp149_ = _tmp148_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp145_, (BirdFontWidget*) _tmp149_);
	_g_object_unref0 (_tmp149_);
	_g_free0 (_tmp147_);
	_tmp150_ = self->priv->version;
	((BirdFontWidget*) _tmp150_)->margin_bottom = margin;
	_tmp151_ = self->priv->version;
	_tmp152_ = _data10_->font;
	_tmp153_ = _tmp152_->version;
	bird_font_text_area_set_text (_tmp151_, _tmp153_);
	_tmp154_ = self->priv->version;
	g_signal_connect_data (_tmp154_, "text-changed", (GCallback) ___lambda199__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp155_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp156_ = self->priv->version;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp155_, (BirdFontWidget*) _tmp156_);
	_tmp157_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp158_ = self->priv->version;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp157_, (BirdFontWidget*) _tmp158_);
	_tmp159_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp160_ = bird_font_t_ ("Description");
	_tmp161_ = _tmp160_;
	_tmp162_ = bird_font_text_new (_tmp161_, label_size, label_margin);
	_tmp163_ = _tmp162_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp159_, (BirdFontWidget*) _tmp163_);
	_g_object_unref0 (_tmp163_);
	_g_free0 (_tmp161_);
	_tmp164_ = self->priv->description;
	((BirdFontWidget*) _tmp164_)->margin_bottom = margin;
	_tmp165_ = self->priv->description;
	_tmp166_ = _data10_->font;
	_tmp167_ = _tmp166_->description;
	bird_font_text_area_set_text (_tmp165_, _tmp167_);
	_tmp168_ = self->priv->description;
	g_signal_connect_object (_tmp168_, "scroll", (GCallback) _bird_font_table_layout_scroll_event_bird_font_text_area_scroll, (BirdFontTableLayout*) self, 0);
	_tmp169_ = self->priv->description;
	g_signal_connect_data (_tmp169_, "text-changed", (GCallback) ___lambda200__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp170_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp171_ = self->priv->description;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp170_, (BirdFontWidget*) _tmp171_);
	_tmp172_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp173_ = self->priv->description;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp172_, (BirdFontWidget*) _tmp173_);
	_tmp174_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp175_ = bird_font_t_ ("Copyright");
	_tmp176_ = _tmp175_;
	_tmp177_ = bird_font_text_new (_tmp176_, label_size, label_margin);
	_tmp178_ = _tmp177_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp174_, (BirdFontWidget*) _tmp178_);
	_g_object_unref0 (_tmp178_);
	_g_free0 (_tmp176_);
	_tmp179_ = self->priv->copyright;
	((BirdFontWidget*) _tmp179_)->margin_bottom = margin;
	_tmp180_ = self->priv->copyright;
	_tmp181_ = _data10_->font;
	_tmp182_ = _tmp181_->copyright;
	bird_font_text_area_set_text (_tmp180_, _tmp182_);
	_tmp183_ = self->priv->copyright;
	g_signal_connect_object (_tmp183_, "scroll", (GCallback) _bird_font_table_layout_scroll_event_bird_font_text_area_scroll, (BirdFontTableLayout*) self, 0);
	_tmp184_ = self->priv->copyright;
	g_signal_connect_data (_tmp184_, "text-changed", (GCallback) ___lambda201__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp185_ = self->priv->copyright;
	bird_font_text_area_set_editable (_tmp185_, !bird_font_description_display_disable_copyright);
	_tmp186_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp187_ = self->priv->copyright;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp186_, (BirdFontWidget*) _tmp187_);
	_tmp188_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp189_ = self->priv->copyright;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp188_, (BirdFontWidget*) _tmp189_);
	_tmp190_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp191_ = bird_font_t_ ("License");
	_tmp192_ = _tmp191_;
	_tmp193_ = bird_font_text_new (_tmp192_, label_size, label_margin);
	_tmp194_ = _tmp193_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp190_, (BirdFontWidget*) _tmp194_);
	_g_object_unref0 (_tmp194_);
	_g_free0 (_tmp192_);
	_tmp195_ = self->priv->license;
	((BirdFontWidget*) _tmp195_)->margin_bottom = margin;
	_tmp196_ = self->priv->license;
	_tmp197_ = _data10_->font;
	_tmp198_ = _tmp197_->license;
	bird_font_text_area_set_text (_tmp196_, _tmp198_);
	_tmp199_ = self->priv->license;
	g_signal_connect_object (_tmp199_, "scroll", (GCallback) _bird_font_table_layout_scroll_event_bird_font_text_area_scroll, (BirdFontTableLayout*) self, 0);
	_tmp200_ = self->priv->license;
	g_signal_connect_data (_tmp200_, "text-changed", (GCallback) ___lambda202__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp201_ = self->priv->license;
	bird_font_text_area_set_editable (_tmp201_, !bird_font_description_display_disable_copyright);
	_tmp202_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp203_ = self->priv->license;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp202_, (BirdFontWidget*) _tmp203_);
	_tmp204_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp205_ = self->priv->license;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp204_, (BirdFontWidget*) _tmp205_);
	_tmp206_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp207_ = bird_font_t_ ("License URL");
	_tmp208_ = _tmp207_;
	_tmp209_ = bird_font_text_new (_tmp208_, label_size, label_margin);
	_tmp210_ = _tmp209_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp206_, (BirdFontWidget*) _tmp210_);
	_g_object_unref0 (_tmp210_);
	_g_free0 (_tmp208_);
	_tmp211_ = self->priv->license_url;
	((BirdFontWidget*) _tmp211_)->margin_bottom = margin;
	_tmp212_ = self->priv->license_url;
	_tmp213_ = _data10_->font;
	_tmp214_ = _tmp213_->license_url;
	bird_font_text_area_set_text ((BirdFontTextArea*) _tmp212_, _tmp214_);
	_tmp215_ = self->priv->license_url;
	g_signal_connect_object ((BirdFontTextArea*) _tmp215_, "scroll", (GCallback) _bird_font_table_layout_scroll_event_bird_font_text_area_scroll, (BirdFontTableLayout*) self, 0);
	_tmp216_ = self->priv->license_url;
	g_signal_connect_data ((BirdFontTextArea*) _tmp216_, "text-changed", (GCallback) ___lambda203__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp217_ = self->priv->license_url;
	bird_font_text_area_set_editable ((BirdFontTextArea*) _tmp217_, !bird_font_description_display_disable_copyright);
	_tmp218_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp219_ = self->priv->license_url;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp218_, (BirdFontWidget*) _tmp219_);
	_tmp220_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp221_ = self->priv->license_url;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp220_, (BirdFontWidget*) _tmp221_);
	_tmp222_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp223_ = bird_font_t_ ("Trademark");
	_tmp224_ = _tmp223_;
	_tmp225_ = bird_font_text_new (_tmp224_, label_size, label_margin);
	_tmp226_ = _tmp225_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp222_, (BirdFontWidget*) _tmp226_);
	_g_object_unref0 (_tmp226_);
	_g_free0 (_tmp224_);
	_tmp227_ = self->priv->trademark;
	((BirdFontWidget*) _tmp227_)->margin_bottom = margin;
	_tmp228_ = self->priv->trademark;
	_tmp229_ = _data10_->font;
	_tmp230_ = _tmp229_->trademark;
	bird_font_text_area_set_text (_tmp228_, _tmp230_);
	_tmp231_ = self->priv->trademark;
	g_signal_connect_object (_tmp231_, "scroll", (GCallback) _bird_font_table_layout_scroll_event_bird_font_text_area_scroll, (BirdFontTableLayout*) self, 0);
	_tmp232_ = self->priv->trademark;
	g_signal_connect_data (_tmp232_, "text-changed", (GCallback) ___lambda204__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp233_ = self->priv->trademark;
	bird_font_text_area_set_editable (_tmp233_, !bird_font_description_display_disable_copyright);
	_tmp234_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp235_ = self->priv->trademark;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp234_, (BirdFontWidget*) _tmp235_);
	_tmp236_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp237_ = self->priv->trademark;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp236_, (BirdFontWidget*) _tmp237_);
	_tmp238_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp239_ = bird_font_t_ ("Manufacturer");
	_tmp240_ = _tmp239_;
	_tmp241_ = bird_font_text_new (_tmp240_, label_size, label_margin);
	_tmp242_ = _tmp241_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp238_, (BirdFontWidget*) _tmp242_);
	_g_object_unref0 (_tmp242_);
	_g_free0 (_tmp240_);
	_tmp243_ = self->priv->manufacturer;
	((BirdFontWidget*) _tmp243_)->margin_bottom = margin;
	_tmp244_ = self->priv->manufacturer;
	_tmp245_ = _data10_->font;
	_tmp246_ = _tmp245_->manufacturer;
	bird_font_text_area_set_text ((BirdFontTextArea*) _tmp244_, _tmp246_);
	_tmp247_ = self->priv->manufacturer;
	g_signal_connect_object ((BirdFontTextArea*) _tmp247_, "scroll", (GCallback) _bird_font_table_layout_scroll_event_bird_font_text_area_scroll, (BirdFontTableLayout*) self, 0);
	_tmp248_ = self->priv->manufacturer;
	g_signal_connect_data ((BirdFontTextArea*) _tmp248_, "text-changed", (GCallback) ___lambda205__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp249_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp250_ = self->priv->manufacturer;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp249_, (BirdFontWidget*) _tmp250_);
	_tmp251_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp252_ = self->priv->manufacturer;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp251_, (BirdFontWidget*) _tmp252_);
	_tmp253_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp254_ = bird_font_t_ ("Designer");
	_tmp255_ = _tmp254_;
	_tmp256_ = bird_font_text_new (_tmp255_, label_size, label_margin);
	_tmp257_ = _tmp256_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp253_, (BirdFontWidget*) _tmp257_);
	_g_object_unref0 (_tmp257_);
	_g_free0 (_tmp255_);
	_tmp258_ = self->priv->designer;
	((BirdFontWidget*) _tmp258_)->margin_bottom = margin;
	_tmp259_ = self->priv->designer;
	_tmp260_ = _data10_->font;
	_tmp261_ = _tmp260_->designer;
	bird_font_text_area_set_text ((BirdFontTextArea*) _tmp259_, _tmp261_);
	_tmp262_ = self->priv->designer;
	g_signal_connect_object ((BirdFontTextArea*) _tmp262_, "scroll", (GCallback) _bird_font_table_layout_scroll_event_bird_font_text_area_scroll, (BirdFontTableLayout*) self, 0);
	_tmp263_ = self->priv->designer;
	g_signal_connect_data ((BirdFontTextArea*) _tmp263_, "text-changed", (GCallback) ___lambda206__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp264_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp265_ = self->priv->designer;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp264_, (BirdFontWidget*) _tmp265_);
	_tmp266_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp267_ = self->priv->designer;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp266_, (BirdFontWidget*) _tmp267_);
	_tmp268_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp269_ = bird_font_t_ ("Vendor URL");
	_tmp270_ = _tmp269_;
	_tmp271_ = bird_font_text_new (_tmp270_, label_size, label_margin);
	_tmp272_ = _tmp271_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp268_, (BirdFontWidget*) _tmp272_);
	_g_object_unref0 (_tmp272_);
	_g_free0 (_tmp270_);
	_tmp273_ = self->priv->vendor_url;
	((BirdFontWidget*) _tmp273_)->margin_bottom = margin;
	_tmp274_ = self->priv->vendor_url;
	_tmp275_ = _data10_->font;
	_tmp276_ = _tmp275_->vendor_url;
	bird_font_text_area_set_text ((BirdFontTextArea*) _tmp274_, _tmp276_);
	_tmp277_ = self->priv->vendor_url;
	g_signal_connect_object ((BirdFontTextArea*) _tmp277_, "scroll", (GCallback) _bird_font_table_layout_scroll_event_bird_font_text_area_scroll, (BirdFontTableLayout*) self, 0);
	_tmp278_ = self->priv->vendor_url;
	g_signal_connect_data ((BirdFontTextArea*) _tmp278_, "text-changed", (GCallback) ___lambda207__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp279_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp280_ = self->priv->vendor_url;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp279_, (BirdFontWidget*) _tmp280_);
	_tmp281_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp282_ = self->priv->vendor_url;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp281_, (BirdFontWidget*) _tmp282_);
	_tmp283_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp284_ = bird_font_t_ ("Designer URL");
	_tmp285_ = _tmp284_;
	_tmp286_ = bird_font_text_new (_tmp285_, label_size, label_margin);
	_tmp287_ = _tmp286_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp283_, (BirdFontWidget*) _tmp287_);
	_g_object_unref0 (_tmp287_);
	_g_free0 (_tmp285_);
	_tmp288_ = self->priv->designer_url;
	((BirdFontWidget*) _tmp288_)->margin_bottom = margin;
	_tmp289_ = self->priv->designer_url;
	_tmp290_ = _data10_->font;
	_tmp291_ = _tmp290_->designer_url;
	bird_font_text_area_set_text ((BirdFontTextArea*) _tmp289_, _tmp291_);
	_tmp292_ = self->priv->designer_url;
	g_signal_connect_object ((BirdFontTextArea*) _tmp292_, "scroll", (GCallback) _bird_font_table_layout_scroll_event_bird_font_text_area_scroll, (BirdFontTableLayout*) self, 0);
	_tmp293_ = self->priv->designer_url;
	g_signal_connect_data ((BirdFontTextArea*) _tmp293_, "text-changed", (GCallback) ___lambda208__bird_font_text_area_text_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp294_ = ((BirdFontTableLayout*) self)->widgets;
	_tmp295_ = self->priv->designer_url;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp294_, (BirdFontWidget*) _tmp295_);
	_tmp296_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp297_ = self->priv->designer_url;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp296_, (BirdFontWidget*) _tmp297_);
	_tmp298_ = self->priv->postscript_name;
	bird_font_table_layout_set_focus ((BirdFontTableLayout*) self, (BirdFontWidget*) _tmp298_);
	{
		GeeArrayList* _w_list = NULL;
		GeeArrayList* _tmp299_;
		gint _w_size = 0;
		GeeArrayList* _tmp300_;
		gint _tmp301_;
		gint _tmp302_;
		gint _w_index = 0;
		_tmp299_ = ((BirdFontTableLayout*) self)->widgets;
		_w_list = _tmp299_;
		_tmp300_ = _w_list;
		_tmp301_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp300_);
		_tmp302_ = _tmp301_;
		_w_size = _tmp302_;
		_w_index = -1;
		while (TRUE) {
			gint _tmp303_;
			gint _tmp304_;
			BirdFontWidget* w = NULL;
			GeeArrayList* _tmp305_;
			gpointer _tmp306_;
			BirdFontWidget* _tmp307_;
			_w_index = _w_index + 1;
			_tmp303_ = _w_index;
			_tmp304_ = _w_size;
			if (!(_tmp303_ < _tmp304_)) {
				break;
			}
			_tmp305_ = _w_list;
			_tmp306_ = gee_abstract_list_get ((GeeAbstractList*) _tmp305_, _w_index);
			w = (BirdFontWidget*) _tmp306_;
			_tmp307_ = w;
			if (BIRD_FONT_IS_TEXT (_tmp307_)) {
				BirdFontWidget* _tmp308_;
				_tmp308_ = w;
				bird_font_theme_text_color (G_TYPE_CHECK_INSTANCE_CAST (_tmp308_, BIRD_FONT_TYPE_TEXT, BirdFontText), "Text Foreground");
			}
			_g_object_unref0 (w);
		}
	}
	_g_object_unref0 (headline);
	block10_data_unref (_data10_);
	_data10_ = NULL;
	return self;
}

BirdFontDescriptionDisplay*
bird_font_description_display_new (void)
{
	return bird_font_description_display_construct (BIRD_FONT_TYPE_DESCRIPTION_DISPLAY);
}

void
bird_font_description_display_set_copyright_editable (gboolean t)
{
	bird_font_description_display_disable_copyright = !t;
}

static gchar*
bird_font_description_display_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontDescriptionDisplay * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontDescriptionDisplay*) base;
	_tmp0_ = bird_font_t_ ("Name and Description");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_description_display_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontDescriptionDisplay * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontDescriptionDisplay*) base;
	_tmp0_ = g_strdup ("Description");
	result = _tmp0_;
	return result;
}

static void
bird_font_description_display_real_selected_canvas (BirdFontFontDisplay* base)
{
	BirdFontDescriptionDisplay * self;
	BirdFontTextArea* _tmp0_;
	self = (BirdFontDescriptionDisplay*) base;
	_tmp0_ = self->priv->copyright;
	bird_font_text_area_set_editable (_tmp0_, !bird_font_description_display_disable_copyright);
	BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_description_display_parent_class)->selected_canvas ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TABLE_LAYOUT, BirdFontTableLayout));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_description_display_paste (BirdFontDescriptionDisplay* self,
                                     const gchar* text)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((BirdFontTableLayout*) self)->focus_index;
	if ((0 <= _tmp3_) && (_tmp3_ < _tmp2_)) {
		BirdFontWidget* widget = NULL;
		GeeArrayList* _tmp4_;
		gpointer _tmp5_;
		BirdFontWidget* _tmp6_;
		_tmp4_ = ((BirdFontTableLayout*) self)->focus_ring;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, ((BirdFontTableLayout*) self)->focus_index);
		widget = (BirdFontWidget*) _tmp5_;
		_tmp6_ = widget;
		if (BIRD_FONT_IS_TEXT_AREA (_tmp6_)) {
			BirdFontTextArea* text_area = NULL;
			BirdFontWidget* _tmp7_;
			BirdFontTextArea* _tmp8_;
			BirdFontTextArea* _tmp9_;
			_tmp7_ = widget;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, BIRD_FONT_TYPE_TEXT_AREA, BirdFontTextArea));
			text_area = _tmp8_;
			_tmp9_ = text_area;
			bird_font_text_area_insert_text (_tmp9_, text);
			_g_object_unref0 (text_area);
		}
		_g_object_unref0 (widget);
	}
}

gchar*
bird_font_description_display_get_copy_selection (BirdFontDescriptionDisplay* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((BirdFontTableLayout*) self)->focus_ring;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((BirdFontTableLayout*) self)->focus_index;
	if ((0 <= _tmp3_) && (_tmp3_ < _tmp2_)) {
		BirdFontWidget* widget = NULL;
		GeeArrayList* _tmp4_;
		gpointer _tmp5_;
		BirdFontWidget* _tmp6_;
		_tmp4_ = ((BirdFontTableLayout*) self)->focus_ring;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, ((BirdFontTableLayout*) self)->focus_index);
		widget = (BirdFontWidget*) _tmp5_;
		_tmp6_ = widget;
		if (BIRD_FONT_IS_TEXT_AREA (_tmp6_)) {
			BirdFontTextArea* text_area = NULL;
			BirdFontWidget* _tmp7_;
			BirdFontTextArea* _tmp8_;
			BirdFontTextArea* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = widget;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, BIRD_FONT_TYPE_TEXT_AREA, BirdFontTextArea));
			text_area = _tmp8_;
			_tmp9_ = text_area;
			_tmp10_ = bird_font_text_area_get_selected_text (_tmp9_);
			result = _tmp10_;
			_g_object_unref0 (text_area);
			_g_object_unref0 (widget);
			return result;
		}
		_g_object_unref0 (widget);
	}
	_tmp11_ = g_strdup ("");
	result = _tmp11_;
	return result;
}

static void
bird_font_description_display_class_init (BirdFontDescriptionDisplayClass * klass,
                                          gpointer klass_data)
{
	bird_font_description_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontDescriptionDisplay_private_offset);
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_description_display_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_description_display_real_get_name;
	((BirdFontFontDisplayClass *) klass)->selected_canvas = (void (*) (BirdFontFontDisplay*)) bird_font_description_display_real_selected_canvas;
	G_OBJECT_CLASS (klass)->finalize = bird_font_description_display_finalize;
}

static void
bird_font_description_display_instance_init (BirdFontDescriptionDisplay * self,
                                             gpointer klass)
{
	self->priv = bird_font_description_display_get_instance_private (self);
}

static void
bird_font_description_display_finalize (GObject * obj)
{
	BirdFontDescriptionDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_DESCRIPTION_DISPLAY, BirdFontDescriptionDisplay);
	_g_object_unref0 (self->priv->postscript_name);
	_g_object_unref0 (self->priv->name);
	_g_object_unref0 (self->priv->style);
	_g_object_unref0 (self->priv->bold);
	_g_object_unref0 (self->priv->italic);
	_g_object_unref0 (self->priv->weight);
	_g_object_unref0 (self->priv->italic_angle);
	_g_object_unref0 (self->priv->full_name);
	_g_object_unref0 (self->priv->unique_id);
	_g_object_unref0 (self->priv->version);
	_g_object_unref0 (self->priv->description);
	_g_object_unref0 (self->priv->copyright);
	_g_object_unref0 (self->priv->license);
	_g_object_unref0 (self->priv->license_url);
	_g_object_unref0 (self->priv->trademark);
	_g_object_unref0 (self->priv->manufacturer);
	_g_object_unref0 (self->priv->designer);
	_g_object_unref0 (self->priv->vendor_url);
	_g_object_unref0 (self->priv->designer_url);
	G_OBJECT_CLASS (bird_font_description_display_parent_class)->finalize (obj);
}

static GType
bird_font_description_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontDescriptionDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_description_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontDescriptionDisplay), 0, (GInstanceInitFunc) bird_font_description_display_instance_init, NULL };
	GType bird_font_description_display_type_id;
	bird_font_description_display_type_id = g_type_register_static (BIRD_FONT_TYPE_TABLE_LAYOUT, "BirdFontDescriptionDisplay", &g_define_type_info, 0);
	BirdFontDescriptionDisplay_private_offset = g_type_add_instance_private (bird_font_description_display_type_id, sizeof (BirdFontDescriptionDisplayPrivate));
	return bird_font_description_display_type_id;
}

GType
bird_font_description_display_get_type (void)
{
	static volatile gsize bird_font_description_display_type_id__once = 0;
	if (g_once_init_enter (&bird_font_description_display_type_id__once)) {
		GType bird_font_description_display_type_id;
		bird_font_description_display_type_id = bird_font_description_display_get_type_once ();
		g_once_init_leave (&bird_font_description_display_type_id__once, bird_font_description_display_type_id);
	}
	return bird_font_description_display_type_id__once;
}

