/* CutBackgroundTool.c generated by valac 0.56.16, the Vala compiler
 * generated from CutBackgroundTool.vala, do not modify */

/*
Copyright (C) 2012 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CUT_BACKGROUND_TOOL_0_PROPERTY,
	BIRD_FONT_CUT_BACKGROUND_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_cut_background_tool_properties[BIRD_FONT_CUT_BACKGROUND_TOOL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BIRD_FONT_CUT_BACKGROUND_TOOL_NEW_IMAGE_SIGNAL,
	BIRD_FONT_CUT_BACKGROUND_TOOL_NUM_SIGNALS
};
static guint bird_font_cut_background_tool_signals[BIRD_FONT_CUT_BACKGROUND_TOOL_NUM_SIGNALS] = {0};

struct _BirdFontCutBackgroundToolPrivate {
	gdouble x1;
	gdouble y1;
	gdouble x2;
	gdouble y2;
	gboolean is_visible;
	gboolean is_set;
	gboolean is_done;
};

static gint BirdFontCutBackgroundTool_private_offset;
static gpointer bird_font_cut_background_tool_parent_class = NULL;

static void __lambda242_ (BirdFontCutBackgroundTool* self,
                   BirdFontTool* _self_);
static void ___lambda242__bird_font_tool_select_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gpointer self);
static void __lambda243_ (BirdFontCutBackgroundTool* self,
                   BirdFontTool* _self_);
static void ___lambda243__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                                   BirdFontTool* selected,
                                                   gpointer self);
static void __lambda244_ (BirdFontCutBackgroundTool* self,
                   BirdFontTool* _self_,
                   gint b,
                   gint x,
                   gint y);
static gboolean bird_font_cut_background_tool_is_over_rectangle (BirdFontCutBackgroundTool* self,
                                                          gdouble x,
                                                          gdouble y);
static void bird_font_cut_background_tool_do_cut (BirdFontCutBackgroundTool* self);
static void ___lambda244__bird_font_tool_press_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gint button,
                                                gint x,
                                                gint y,
                                                gpointer self);
static void __lambda245_ (BirdFontCutBackgroundTool* self,
                   BirdFontTool* _self_,
                   gint b,
                   gint x,
                   gint y);
static void ___lambda245__bird_font_tool_release_action (BirdFontTool* _sender,
                                                  BirdFontTool* selected,
                                                  gint button,
                                                  gint x,
                                                  gint y,
                                                  gpointer self);
static void __lambda246_ (BirdFontCutBackgroundTool* self,
                   BirdFontTool* _self_,
                   gint x,
                   gint y);
static void ___lambda246__bird_font_tool_move_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               gint x,
                                               gint y,
                                               gpointer self);
static void __lambda247_ (BirdFontCutBackgroundTool* self,
                   BirdFontTool* _self_,
                   cairo_t* cr,
                   BirdFontGlyph* glyph);
static void ___lambda247__bird_font_tool_draw_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               cairo_t* cr,
                                               BirdFontGlyph* glyph,
                                               gpointer self);
static void __lambda248_ (BirdFontCutBackgroundTool* self,
                   BirdFontBackgroundImage* file,
                   gdouble x,
                   gdouble y,
                   gdouble w,
                   gdouble h);
static void ___lambda248__bird_font_cut_background_tool_new_image (BirdFontCutBackgroundTool* _sender,
                                                            BirdFontBackgroundImage* file,
                                                            gdouble coordinate_x,
                                                            gdouble coordinate_y,
                                                            gdouble width,
                                                            gdouble height,
                                                            gpointer self);
static gdouble bird_font_cut_background_tool_real_get_width (BirdFontWidget* base);
static gdouble bird_font_cut_background_tool_real_get_height (BirdFontWidget* base);
static void bird_font_cut_background_tool_save_img (BirdFontCutBackgroundTool* self,
                                             cairo_surface_t* sr,
                                             BirdFontGlyph* g,
                                             BirdFontBackgroundImage* original_bg);
static void g_cclosure_user_marshal_VOID__OBJECT_DOUBLE_DOUBLE_DOUBLE_DOUBLE (GClosure * closure,
                                                                       GValue * return_value,
                                                                       guint n_param_values,
                                                                       const GValue * param_values,
                                                                       gpointer invocation_hint,
                                                                       gpointer marshal_data);
static void bird_font_cut_background_tool_finalize (GObject * obj);
static GType bird_font_cut_background_tool_get_type_once (void);

static inline gpointer
bird_font_cut_background_tool_get_instance_private (BirdFontCutBackgroundTool* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontCutBackgroundTool_private_offset);
}

static void
__lambda242_ (BirdFontCutBackgroundTool* self,
              BirdFontTool* _self_)
{
	g_return_if_fail (_self_ != NULL);
}

static void
___lambda242__bird_font_tool_select_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gpointer self)
{
	__lambda242_ ((BirdFontCutBackgroundTool*) self, selected);
}

static void
__lambda243_ (BirdFontCutBackgroundTool* self,
              BirdFontTool* _self_)
{
	g_return_if_fail (_self_ != NULL);
}

static void
___lambda243__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                              BirdFontTool* selected,
                                              gpointer self)
{
	__lambda243_ ((BirdFontCutBackgroundTool*) self, selected);
}

static void
__lambda244_ (BirdFontCutBackgroundTool* self,
              BirdFontTool* _self_,
              gint b,
              gint x,
              gint y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (_self_ != NULL);
	if (!bird_font_cut_background_tool_is_over_rectangle (self, (gdouble) x, (gdouble) y)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !self->priv->is_visible;
	}
	if (_tmp0_) {
		self->priv->x1 = (gdouble) x;
		self->priv->y1 = (gdouble) y;
		self->priv->x2 = (gdouble) x;
		self->priv->y2 = (gdouble) y;
		self->priv->is_visible = TRUE;
		self->priv->is_set = FALSE;
		self->priv->is_done = FALSE;
	}
	if (self->priv->is_set) {
		_tmp2_ = self->priv->is_visible;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = bird_font_cut_background_tool_is_over_rectangle (self, (gdouble) x, (gdouble) y);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		bird_font_cut_background_tool_do_cut (self);
		self->priv->is_set = FALSE;
		self->priv->is_visible = FALSE;
		self->priv->is_done = TRUE;
		self->priv->x1 = (gdouble) 0;
		self->priv->y1 = (gdouble) 0;
		self->priv->x2 = (gdouble) 0;
		self->priv->y2 = (gdouble) 0;
	}
}

static void
___lambda244__bird_font_tool_press_action (BirdFontTool* _sender,
                                           BirdFontTool* selected,
                                           gint button,
                                           gint x,
                                           gint y,
                                           gpointer self)
{
	__lambda244_ ((BirdFontCutBackgroundTool*) self, selected, button, x, y);
}

static void
__lambda245_ (BirdFontCutBackgroundTool* self,
              BirdFontTool* _self_,
              gint b,
              gint x,
              gint y)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (_self_ != NULL);
	if (!self->priv->is_set) {
		_tmp0_ = !self->priv->is_done;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->x2 = (gdouble) x;
		self->priv->y2 = (gdouble) y;
		self->priv->is_set = TRUE;
	}
	self->priv->is_done = FALSE;
}

static void
___lambda245__bird_font_tool_release_action (BirdFontTool* _sender,
                                             BirdFontTool* selected,
                                             gint button,
                                             gint x,
                                             gint y,
                                             gpointer self)
{
	__lambda245_ ((BirdFontCutBackgroundTool*) self, selected, button, x, y);
}

static void
__lambda246_ (BirdFontCutBackgroundTool* self,
              BirdFontTool* _self_,
              gint x,
              gint y)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (_self_ != NULL);
	if (self->priv->is_visible) {
		_tmp0_ = !self->priv->is_set;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->x2 = (gdouble) x;
		self->priv->y2 = (gdouble) y;
		bird_font_glyph_canvas_redraw ();
	}
}

static void
___lambda246__bird_font_tool_move_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          gint x,
                                          gint y,
                                          gpointer self)
{
	__lambda246_ ((BirdFontCutBackgroundTool*) self, selected, x, y);
}

static void
__lambda247_ (BirdFontCutBackgroundTool* self,
              BirdFontTool* _self_,
              cairo_t* cr,
              BirdFontGlyph* glyph)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (_self_ != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (glyph != NULL);
	if (self->priv->is_visible) {
		_tmp1_ = (self->priv->x1 - self->priv->x2) != ((gdouble) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = (self->priv->y1 - self->priv->y2) != ((gdouble) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BirdFontWidgetAllocation* _tmp2_;
		BirdFontWidgetAllocation* _tmp3_;
		BirdFontWidgetAllocation* _tmp4_;
		BirdFontWidgetAllocation* _tmp5_;
		BirdFontWidgetAllocation* _tmp6_;
		cairo_save (cr);
		cairo_set_line_width (cr, 2.0);
		bird_font_theme_color_opacity (cr, "Foreground 1", 0.3);
		cairo_rectangle (cr, fmin (self->priv->x1, self->priv->x2), fmin (self->priv->y1, self->priv->y2), fabs (self->priv->x1 - self->priv->x2), fabs (self->priv->y1 - self->priv->y2));
		cairo_stroke (cr);
		cairo_restore (cr);
		cairo_save (cr);
		cairo_set_line_width (cr, (gdouble) 0);
		bird_font_theme_color_opacity (cr, "Foreground 1", 0.075);
		_tmp2_ = glyph->allocation;
		cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) _tmp2_->width, fmin (self->priv->y1, self->priv->y2));
		cairo_rectangle (cr, (gdouble) 0, fmin (self->priv->y1, self->priv->y2), fmin (self->priv->x1, self->priv->x2), fabs (self->priv->y1 - self->priv->y2));
		_tmp3_ = glyph->allocation;
		_tmp4_ = glyph->allocation;
		cairo_rectangle (cr, (gdouble) 0, fmin (self->priv->y1, self->priv->y2) + fabs (self->priv->y1 - self->priv->y2), (gdouble) _tmp3_->width, _tmp4_->height - fabs (self->priv->y1 - self->priv->y2));
		_tmp5_ = glyph->allocation;
		_tmp6_ = glyph->allocation;
		cairo_rectangle (cr, fmin (self->priv->x1, self->priv->x2) + fabs (self->priv->x1 - self->priv->x2), fmin (self->priv->y1, self->priv->y2), (_tmp5_->width - fmin (self->priv->x1, self->priv->x2)) - fabs (self->priv->x1 - self->priv->x2), (gdouble) _tmp6_->height);
		cairo_fill (cr);
		cairo_restore (cr);
	}
}

static void
___lambda247__bird_font_tool_draw_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          cairo_t* cr,
                                          BirdFontGlyph* glyph,
                                          gpointer self)
{
	__lambda247_ ((BirdFontCutBackgroundTool*) self, selected, cr, glyph);
}

static void
__lambda248_ (BirdFontCutBackgroundTool* self,
              BirdFontBackgroundImage* file,
              gdouble x,
              gdouble y,
              gdouble w,
              gdouble h)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontTabBar* tb = NULL;
	g_return_if_fail (file != NULL);
	if (self->self_destination) {
		BirdFontGlyph* _tmp0_;
		BirdFontTabBar* _tmp1_;
		BirdFontGlyph* _tmp2_;
		BirdFontGlyph* _tmp3_;
		BirdFontTabBar* _tmp4_;
		BirdFontGlyph* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		BirdFontGlyph* _tmp8_;
		_tmp0_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (glyph);
		glyph = _tmp0_;
		_tmp1_ = bird_font_main_window_get_tab_bar ();
		_g_object_unref0 (tb);
		tb = _tmp1_;
		_tmp2_ = glyph;
		bird_font_glyph_store_undo_state (_tmp2_, FALSE);
		_tmp3_ = glyph;
		bird_font_glyph_set_background_image (_tmp3_, file);
		_tmp4_ = tb;
		_tmp5_ = glyph;
		_tmp6_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp5_);
		_tmp7_ = _tmp6_;
		bird_font_tab_bar_select_tab_name (_tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = glyph;
		bird_font_glyph_set_background_visible (_tmp8_, TRUE);
	}
	_g_object_unref0 (tb);
	_g_object_unref0 (glyph);
}

static void
___lambda248__bird_font_cut_background_tool_new_image (BirdFontCutBackgroundTool* _sender,
                                                       BirdFontBackgroundImage* file,
                                                       gdouble coordinate_x,
                                                       gdouble coordinate_y,
                                                       gdouble width,
                                                       gdouble height,
                                                       gpointer self)
{
	__lambda248_ ((BirdFontCutBackgroundTool*) self, file, coordinate_x, coordinate_y, width, height);
}

BirdFontCutBackgroundTool*
bird_font_cut_background_tool_construct (GType object_type,
                                         const gchar* name,
                                         const gchar* tool_tip)
{
	BirdFontCutBackgroundTool * self = NULL;
	gchar* tt = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	if (tool_tip == NULL) {
		gchar* _tmp1_;
		_tmp1_ = bird_font_t_ ("Crop background image");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ((const gchar*) tool_tip);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (tt);
	tt = _tmp3_;
	self = (BirdFontCutBackgroundTool*) bird_font_tool_construct (object_type, name, tt);
	g_signal_connect_object ((BirdFontTool*) self, "select-action", (GCallback) ___lambda242__bird_font_tool_select_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "deselect-action", (GCallback) ___lambda243__bird_font_tool_deselect_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "press-action", (GCallback) ___lambda244__bird_font_tool_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "release-action", (GCallback) ___lambda245__bird_font_tool_release_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "move-action", (GCallback) ___lambda246__bird_font_tool_move_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "draw-action", (GCallback) ___lambda247__bird_font_tool_draw_action, self, 0);
	g_signal_connect_object (self, "new-image", (GCallback) ___lambda248__bird_font_cut_background_tool_new_image, self, 0);
	_g_free0 (_tmp0_);
	_g_free0 (tt);
	return self;
}

BirdFontCutBackgroundTool*
bird_font_cut_background_tool_new (const gchar* name,
                                   const gchar* tool_tip)
{
	return bird_font_cut_background_tool_construct (BIRD_FONT_TYPE_CUT_BACKGROUND_TOOL, name, tool_tip);
}

static gboolean
bird_font_cut_background_tool_is_over_rectangle (BirdFontCutBackgroundTool* self,
                                                 gdouble x,
                                                 gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = x;
	if (((fmin (self->priv->x1, self->priv->x2) + 1) < _tmp1_) && (_tmp1_ < (fmax (self->priv->x1, self->priv->x2) - 1))) {
		gdouble _tmp2_;
		_tmp2_ = y;
		_tmp0_ = ((fmin (self->priv->y1, self->priv->y2) + 1) < _tmp2_) && (_tmp2_ < (fmax (self->priv->y1, self->priv->y2) - 1));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gdouble
bird_font_cut_background_tool_real_get_width (BirdFontWidget* base)
{
	BirdFontCutBackgroundTool * self;
	gdouble result;
	self = (BirdFontCutBackgroundTool*) base;
	result = fabs (self->priv->x1 - self->priv->x2);
	return result;
}

static gdouble
bird_font_cut_background_tool_real_get_height (BirdFontWidget* base)
{
	BirdFontCutBackgroundTool * self;
	gdouble result;
	self = (BirdFontCutBackgroundTool*) base;
	result = fabs (self->priv->y1 - self->priv->y2);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bird_font_cut_background_tool_do_cut (BirdFontCutBackgroundTool* self)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gint h = 0;
	gint w = 0;
	gdouble wc = 0.0;
	gdouble hc = 0.0;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontBackgroundImage* b = NULL;
	BirdFontGlyph* _tmp1_;
	BirdFontBackgroundImage* _tmp2_;
	BirdFontBackgroundImage* bg = NULL;
	BirdFontBackgroundImage* _tmp3_;
	BirdFontBackgroundImage* _tmp4_;
	cairo_surface_t* img = NULL;
	cairo_surface_t* sr = NULL;
	cairo_t* cr = NULL;
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	gdouble vx = 0.0;
	gdouble vy = 0.0;
	BirdFontBackgroundImage* _tmp5_;
	cairo_surface_t* sg = NULL;
	BirdFontBackgroundImage* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	BirdFontBackgroundImage* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_surface_t* _tmp11_;
	BirdFontBackgroundImage* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	BirdFontBackgroundImage* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	cairo_surface_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	cairo_t* cg = NULL;
	cairo_surface_t* _tmp20_;
	cairo_t* _tmp21_;
	BirdFontBackgroundImage* _tmp22_;
	BirdFontBackgroundImage* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	BirdFontBackgroundImage* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	BirdFontBackgroundImage* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	BirdFontBackgroundImage* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	BirdFontBackgroundImage* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	cairo_t* _tmp40_;
	BirdFontBackgroundImage* _tmp41_;
	cairo_t* _tmp42_;
	BirdFontBackgroundImage* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	BirdFontBackgroundImage* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	cairo_t* _tmp49_;
	BirdFontBackgroundImage* _tmp50_;
	cairo_surface_t* _tmp51_;
	cairo_surface_t* _tmp52_;
	cairo_t* _tmp53_;
	BirdFontBackgroundImage* _tmp54_;
	gdouble _tmp55_;
	gdouble _tmp56_;
	BirdFontGlyph* _tmp57_;
	BirdFontBackgroundImage* _tmp58_;
	gdouble _tmp59_;
	gdouble _tmp60_;
	BirdFontGlyph* _tmp61_;
	BirdFontGlyph* _tmp62_;
	BirdFontGlyph* _tmp63_;
	BirdFontBackgroundImage* _tmp64_;
	gdouble _tmp65_;
	gdouble _tmp66_;
	BirdFontBackgroundImage* _tmp67_;
	gdouble _tmp68_;
	gdouble _tmp69_;
	BirdFontBackgroundImage* _tmp70_;
	cairo_surface_t* _tmp71_;
	BirdFontGlyph* _tmp72_;
	BirdFontGlyph* _tmp73_;
	cairo_surface_t* _tmp74_;
	cairo_surface_t* _tmp75_;
	BirdFontBackgroundImage* _tmp76_;
	gdouble _tmp77_;
	gdouble _tmp78_;
	BirdFontBackgroundImage* _tmp79_;
	gdouble _tmp80_;
	gdouble _tmp81_;
	cairo_surface_t* _tmp82_;
	cairo_surface_t* _tmp83_;
	cairo_t* _tmp84_;
	cairo_t* _tmp85_;
	cairo_t* _tmp86_;
	cairo_t* _tmp87_;
	cairo_t* _tmp88_;
	cairo_surface_t* _tmp89_;
	cairo_t* _tmp90_;
	cairo_surface_t* _tmp91_;
	BirdFontGlyph* _tmp92_;
	BirdFontBackgroundImage* _tmp93_;
	cairo_t* _tmp94_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = g;
	_tmp2_ = bird_font_glyph_get_background_image (_tmp1_);
	b = _tmp2_;
	_tmp3_ = b;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage));
	bg = _tmp4_;
	_tmp5_ = b;
	if (_tmp5_ == NULL) {
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (sr);
		_cairo_surface_destroy0 (img);
		_g_object_unref0 (bg);
		_g_object_unref0 (b);
		_g_object_unref0 (g);
		return;
	}
	_tmp6_ = bg;
	_tmp7_ = bird_font_background_image_get_img (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = bg;
	_tmp10_ = bird_font_background_image_get_img (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = bg;
	_tmp13_ = bird_font_background_image_get_size_margin (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = bg;
	_tmp16_ = bird_font_background_image_get_size_margin (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = cairo_surface_create_similar (_tmp8_, cairo_surface_get_content (_tmp11_), _tmp14_, _tmp17_);
	_tmp19_ = _tmp18_;
	_cairo_surface_destroy0 (_tmp11_);
	_cairo_surface_destroy0 (_tmp8_);
	sg = _tmp19_;
	_tmp20_ = sg;
	_tmp21_ = cairo_create (_tmp20_);
	cg = _tmp21_;
	_tmp22_ = bg;
	wc = bird_font_background_image_get_margin_width (_tmp22_);
	_tmp23_ = bg;
	hc = bird_font_background_image_get_margin_height (_tmp23_);
	_tmp24_ = cg;
	bird_font_theme_color (_tmp24_, "Canvas Background");
	_tmp25_ = cg;
	_tmp26_ = bg;
	_tmp27_ = bird_font_background_image_get_size_margin (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = bg;
	_tmp30_ = bird_font_background_image_get_size_margin (_tmp29_);
	_tmp31_ = _tmp30_;
	cairo_rectangle (_tmp25_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp28_, (gdouble) _tmp31_);
	_tmp32_ = cg;
	cairo_fill (_tmp32_);
	_tmp33_ = cg;
	_tmp34_ = bg;
	_tmp35_ = bird_font_background_image_get_size_margin (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = bg;
	_tmp38_ = bird_font_background_image_get_size_margin (_tmp37_);
	_tmp39_ = _tmp38_;
	cairo_translate (_tmp33_, _tmp36_ * 0.5, _tmp39_ * 0.5);
	_tmp40_ = cg;
	_tmp41_ = bg;
	cairo_rotate (_tmp40_, _tmp41_->img_rotation);
	_tmp42_ = cg;
	_tmp43_ = bg;
	_tmp44_ = bird_font_background_image_get_size_margin (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = bg;
	_tmp47_ = bird_font_background_image_get_size_margin (_tmp46_);
	_tmp48_ = _tmp47_;
	cairo_translate (_tmp42_, (-_tmp45_) * 0.5, (-_tmp48_) * 0.5);
	_tmp49_ = cg;
	_tmp50_ = bg;
	_tmp51_ = bird_font_background_image_get_img (_tmp50_);
	_tmp52_ = _tmp51_;
	cairo_set_source_surface (_tmp49_, _tmp52_, wc, hc);
	_cairo_surface_destroy0 (_tmp52_);
	_tmp53_ = cg;
	cairo_paint (_tmp53_);
	_tmp54_ = bg;
	_tmp55_ = bird_font_background_image_get_img_offset_x (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = g;
	tx = _tmp56_ - _tmp57_->view_offset_x;
	_tmp58_ = bg;
	_tmp59_ = bird_font_background_image_get_img_offset_y (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = g;
	ty = _tmp60_ - _tmp61_->view_offset_y;
	_tmp62_ = g;
	ty *= _tmp62_->view_zoom;
	_tmp63_ = g;
	tx *= _tmp63_->view_zoom;
	vx = bird_font_glyph_path_coordinate_x (tx) - bird_font_glyph_path_coordinate_x (fmin (self->priv->x1, self->priv->x2));
	vy = bird_font_glyph_path_coordinate_y (ty) - bird_font_glyph_path_coordinate_y (fmin (self->priv->y1, self->priv->y2));
	_tmp64_ = bg;
	_tmp65_ = bird_font_background_image_get_img_scale_x (_tmp64_);
	_tmp66_ = _tmp65_;
	x = (gdouble) ((gint) (vx / _tmp66_));
	_tmp67_ = bg;
	_tmp68_ = bird_font_background_image_get_img_scale_y (_tmp67_);
	_tmp69_ = _tmp68_;
	y = (gdouble) ((gint) ((-vy) / _tmp69_));
	_tmp70_ = bg;
	_tmp71_ = bird_font_background_image_get_img (_tmp70_);
	_cairo_surface_destroy0 (img);
	img = _tmp71_;
	_tmp72_ = g;
	w = (gint) (bird_font_widget_get_width ((BirdFontWidget*) self) / _tmp72_->view_zoom);
	_tmp73_ = g;
	h = (gint) (bird_font_widget_get_height ((BirdFontWidget*) self) / _tmp73_->view_zoom);
	_tmp74_ = sg;
	_tmp75_ = img;
	_tmp76_ = bg;
	_tmp77_ = bird_font_background_image_get_img_scale_x (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = bg;
	_tmp80_ = bird_font_background_image_get_img_scale_y (_tmp79_);
	_tmp81_ = _tmp80_;
	_tmp82_ = cairo_surface_create_similar (_tmp74_, cairo_surface_get_content (_tmp75_), (gint) (w / _tmp78_), (gint) (h / _tmp81_));
	_cairo_surface_destroy0 (sr);
	sr = _tmp82_;
	_tmp83_ = sr;
	_tmp84_ = cairo_create (_tmp83_);
	_cairo_destroy0 (cr);
	cr = _tmp84_;
	_tmp85_ = cr;
	bird_font_theme_color (_tmp85_, "Canvas Background");
	_tmp86_ = cr;
	cairo_rectangle (_tmp86_, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	_tmp87_ = cr;
	cairo_fill (_tmp87_);
	_tmp88_ = cr;
	_tmp89_ = sg;
	cairo_set_source_surface (_tmp88_, _tmp89_, x, y);
	_tmp90_ = cr;
	cairo_paint (_tmp90_);
	_tmp91_ = sr;
	_tmp92_ = g;
	_tmp93_ = bg;
	bird_font_cut_background_tool_save_img (self, _tmp91_, _tmp92_, _tmp93_);
	_tmp94_ = cr;
	cairo_restore (_tmp94_);
	_cairo_destroy0 (cg);
	_cairo_surface_destroy0 (sg);
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (sr);
	_cairo_surface_destroy0 (img);
	_g_object_unref0 (bg);
	_g_object_unref0 (b);
	_g_object_unref0 (g);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_cut_background_tool_save_img (BirdFontCutBackgroundTool* self,
                                        cairo_surface_t* sr,
                                        BirdFontGlyph* g,
                                        BirdFontBackgroundImage* original_bg)
{
	BirdFontBackgroundImage* newbg = NULL;
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	GFile* img_dir = NULL;
	GFile* img_file = NULL;
	GFile* img_file_next = NULL;
	gchar* fn = NULL;
	gdouble wc = 0.0;
	gdouble hc = 0.0;
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	BirdFontFont* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	BirdFontBackgroundImage* _tmp22_;
	BirdFontBackgroundImage* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GFile* _tmp27_;
	const gchar* _tmp28_;
	GFile* _tmp29_;
	BirdFontFont* _tmp38_;
	GFile* _tmp39_;
	GFile* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	const gchar* _tmp43_;
	GFile* _tmp44_;
	GFile* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	BirdFontBackgroundImage* _tmp48_;
	BirdFontBackgroundImage* _tmp49_;
	BirdFontBackgroundImage* _tmp50_;
	gdouble _tmp51_;
	gdouble _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	BirdFontBackgroundImage* _tmp55_;
	BirdFontBackgroundImage* _tmp56_;
	BirdFontBackgroundImage* _tmp57_;
	gdouble _tmp58_;
	gdouble _tmp59_;
	BirdFontBackgroundImage* _tmp60_;
	gdouble _tmp61_;
	gdouble _tmp62_;
	BirdFontBackgroundImage* _tmp63_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sr != NULL);
	g_return_if_fail (g != NULL);
	g_return_if_fail (original_bg != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	_tmp1_ = f;
	_tmp2_ = bird_font_font_get_backgrounds_folder (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_get_child (_tmp3_, "parts");
	_g_object_unref0 (img_dir);
	img_dir = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_tmp5_ = img_dir;
	if (!g_file_query_exists (_tmp5_, NULL)) {
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp6_ = img_dir;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp8_ = (gchar*) _tmp7_;
		_tmp9_ = g_mkdir_with_parents (_tmp8_, 755) != 0;
		_g_free0 (_tmp8_);
		if (_tmp9_) {
			GFile* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = img_dir;
			_tmp11_ = g_file_get_path (_tmp10_);
			_tmp12_ = (gchar*) _tmp11_;
			_tmp13_ = string_to_string (_tmp12_);
			_tmp14_ = g_strconcat ("Can not create directory ", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			g_warning ("CutBackgroundTool.vala:235: %s", _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp12_);
		}
	}
	_tmp16_ = img_dir;
	_tmp17_ = g_file_get_child (_tmp16_, "NEW_BACKGROUND.png");
	_g_object_unref0 (img_file);
	img_file = _tmp17_;
	_tmp18_ = img_file;
	_tmp19_ = g_file_get_path (_tmp18_);
	_g_free0 (fn);
	fn = (gchar*) _tmp19_;
	_tmp20_ = fn;
	cairo_surface_write_to_png (sr, _tmp20_);
	_tmp21_ = fn;
	_tmp22_ = bird_font_background_image_new (_tmp21_);
	_g_object_unref0 (newbg);
	newbg = _tmp22_;
	_tmp23_ = newbg;
	_tmp24_ = bird_font_background_image_get_sha1 (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp25_, ".png", NULL);
	_g_free0 (fn);
	fn = _tmp26_;
	_g_free0 (_tmp25_);
	_tmp27_ = img_dir;
	_tmp28_ = fn;
	_tmp29_ = g_file_get_child (_tmp27_, _tmp28_);
	_g_object_unref0 (img_file_next);
	img_file_next = _tmp29_;
	{
		GFile* _tmp30_;
		GFile* _tmp32_;
		const gchar* _tmp33_;
		GFile* _tmp34_;
		GFile* _tmp35_;
		_tmp30_ = img_file_next;
		if (g_file_query_exists (_tmp30_, NULL)) {
			GFile* _tmp31_;
			_tmp31_ = img_file_next;
			g_file_delete (_tmp31_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		_tmp32_ = img_file;
		_tmp33_ = fn;
		_tmp34_ = g_file_set_display_name (_tmp32_, _tmp33_, NULL, &_inner_error0_);
		_tmp35_ = _tmp34_;
		_g_object_unref0 (_tmp35_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		g_warning ("CutBackgroundTool.vala:257: %s", _tmp37_);
		_g_error_free0 (e);
		_g_free0 (fn);
		_g_object_unref0 (img_file_next);
		_g_object_unref0 (img_file);
		_g_object_unref0 (img_dir);
		_g_object_unref0 (f);
		_g_object_unref0 (newbg);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (fn);
		_g_object_unref0 (img_file_next);
		_g_object_unref0 (img_file);
		_g_object_unref0 (img_dir);
		_g_object_unref0 (f);
		_g_object_unref0 (newbg);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp38_ = f;
	_tmp39_ = bird_font_font_get_backgrounds_folder (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_file_get_child (_tmp40_, "parts");
	_tmp42_ = _tmp41_;
	_tmp43_ = fn;
	_tmp44_ = g_file_get_child (_tmp42_, _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_file_get_path (_tmp45_);
	_tmp47_ = (gchar*) _tmp46_;
	_tmp48_ = bird_font_background_image_new (_tmp47_);
	_g_object_unref0 (newbg);
	newbg = _tmp48_;
	_g_free0 (_tmp47_);
	_g_object_unref0 (_tmp45_);
	_g_object_unref0 (_tmp42_);
	_g_object_unref0 (_tmp40_);
	_tmp49_ = newbg;
	wc = bird_font_glyph_path_coordinate_x ((gdouble) 0) - bird_font_glyph_path_coordinate_x (bird_font_background_image_get_margin_width (_tmp49_));
	_tmp50_ = newbg;
	hc = bird_font_glyph_path_coordinate_y ((gdouble) 0) - bird_font_glyph_path_coordinate_y (bird_font_background_image_get_margin_height (_tmp50_));
	wc *= g->view_zoom;
	hc *= g->view_zoom;
	_tmp51_ = bird_font_background_image_get_img_scale_x (original_bg);
	_tmp52_ = _tmp51_;
	wc *= _tmp52_;
	_tmp53_ = bird_font_background_image_get_img_scale_y (original_bg);
	_tmp54_ = _tmp53_;
	hc *= _tmp54_;
	_tmp55_ = newbg;
	_tmp55_->img_x = bird_font_glyph_path_coordinate_x (fmin (self->priv->x1, self->priv->x2)) + wc;
	_tmp56_ = newbg;
	_tmp56_->img_y = bird_font_glyph_path_coordinate_y (fmin (self->priv->y1, self->priv->y2)) + hc;
	_tmp57_ = newbg;
	_tmp58_ = bird_font_background_image_get_img_scale_x (original_bg);
	_tmp59_ = _tmp58_;
	bird_font_background_image_set_img_scale_x (_tmp57_, _tmp59_);
	_tmp60_ = newbg;
	_tmp61_ = bird_font_background_image_get_img_scale_y (original_bg);
	_tmp62_ = _tmp61_;
	bird_font_background_image_set_img_scale_y (_tmp60_, _tmp62_);
	px = bird_font_glyph_path_coordinate_x (fmin (self->priv->x1, self->priv->x2));
	py = bird_font_glyph_path_coordinate_y (fmin (self->priv->y1, self->priv->y2));
	w = bird_font_glyph_path_coordinate_x (fmax (self->priv->x1, self->priv->x2)) - px;
	h = bird_font_glyph_path_coordinate_y (fmax (self->priv->y1, self->priv->y2)) - py;
	_tmp63_ = newbg;
	g_signal_emit (self, bird_font_cut_background_tool_signals[BIRD_FONT_CUT_BACKGROUND_TOOL_NEW_IMAGE_SIGNAL], 0, _tmp63_, px, py, w, h);
	_g_free0 (fn);
	_g_object_unref0 (img_file_next);
	_g_object_unref0 (img_file);
	_g_object_unref0 (img_dir);
	_g_object_unref0 (f);
	_g_object_unref0 (newbg);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_DOUBLE_DOUBLE_DOUBLE_DOUBLE (GClosure * closure,
                                                                  GValue * return_value,
                                                                  guint n_param_values,
                                                                  const GValue * param_values,
                                                                  gpointer invocation_hint,
                                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_DOUBLE_DOUBLE_DOUBLE_DOUBLE) (gpointer data1, gpointer arg_1, gdouble arg_2, gdouble arg_3, gdouble arg_4, gdouble arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_DOUBLE_DOUBLE_DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_DOUBLE_DOUBLE_DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_double (param_values + 2), g_value_get_double (param_values + 3), g_value_get_double (param_values + 4), g_value_get_double (param_values + 5), data2);
}

static void
bird_font_cut_background_tool_class_init (BirdFontCutBackgroundToolClass * klass,
                                          gpointer klass_data)
{
	bird_font_cut_background_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontCutBackgroundTool_private_offset);
	((BirdFontWidgetClass *) klass)->get_width = (gdouble (*) (BirdFontWidget*)) bird_font_cut_background_tool_real_get_width;
	((BirdFontWidgetClass *) klass)->get_height = (gdouble (*) (BirdFontWidget*)) bird_font_cut_background_tool_real_get_height;
	G_OBJECT_CLASS (klass)->finalize = bird_font_cut_background_tool_finalize;
	bird_font_cut_background_tool_signals[BIRD_FONT_CUT_BACKGROUND_TOOL_NEW_IMAGE_SIGNAL] = g_signal_new ("new-image", BIRD_FONT_TYPE_CUT_BACKGROUND_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_DOUBLE_DOUBLE_DOUBLE_DOUBLE, G_TYPE_NONE, 5, BIRD_FONT_TYPE_BACKGROUND_IMAGE, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
}

static void
bird_font_cut_background_tool_instance_init (BirdFontCutBackgroundTool * self,
                                             gpointer klass)
{
	self->priv = bird_font_cut_background_tool_get_instance_private (self);
	self->priv->x1 = (gdouble) 0;
	self->priv->y1 = (gdouble) 0;
	self->priv->x2 = (gdouble) 0;
	self->priv->y2 = (gdouble) 0;
	self->priv->is_visible = FALSE;
	self->priv->is_set = FALSE;
	self->priv->is_done = FALSE;
	self->self_destination = TRUE;
}

static void
bird_font_cut_background_tool_finalize (GObject * obj)
{
	BirdFontCutBackgroundTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CUT_BACKGROUND_TOOL, BirdFontCutBackgroundTool);
	G_OBJECT_CLASS (bird_font_cut_background_tool_parent_class)->finalize (obj);
}

static GType
bird_font_cut_background_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCutBackgroundToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_cut_background_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCutBackgroundTool), 0, (GInstanceInitFunc) bird_font_cut_background_tool_instance_init, NULL };
	GType bird_font_cut_background_tool_type_id;
	bird_font_cut_background_tool_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontCutBackgroundTool", &g_define_type_info, 0);
	BirdFontCutBackgroundTool_private_offset = g_type_add_instance_private (bird_font_cut_background_tool_type_id, sizeof (BirdFontCutBackgroundToolPrivate));
	return bird_font_cut_background_tool_type_id;
}

GType
bird_font_cut_background_tool_get_type (void)
{
	static volatile gsize bird_font_cut_background_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_cut_background_tool_type_id__once)) {
		GType bird_font_cut_background_tool_type_id;
		bird_font_cut_background_tool_type_id = bird_font_cut_background_tool_get_type_once ();
		g_once_init_leave (&bird_font_cut_background_tool_type_id__once, bird_font_cut_background_tool_type_id);
	}
	return bird_font_cut_background_tool_type_id__once;
}

