/* ColorTool.c generated by valac 0.56.16, the Vala compiler
 * generated from ColorTool.vala, do not modify */

/*
Copyright (C) 2012 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <cairo-gobject.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_COLOR_TOOL_0_PROPERTY,
	BIRD_FONT_COLOR_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_color_tool_properties[BIRD_FONT_COLOR_TOOL_NUM_PROPERTIES];
enum  {
	BIRD_FONT_COLOR_TOOL_COLOR_UPDATED_SIGNAL,
	BIRD_FONT_COLOR_TOOL_NUM_SIGNALS
};
static guint bird_font_color_tool_signals[BIRD_FONT_COLOR_TOOL_NUM_SIGNALS] = {0};

static gpointer bird_font_color_tool_parent_class = NULL;

static void __lambda271_ (BirdFontColorTool* self);
static void ___lambda271__bird_font_color_tool_color_updated (BirdFontColorTool* _sender,
                                                       gpointer self);
static void bird_font_color_tool_real_draw_tool (BirdFontTool* base,
                                          cairo_t* cr,
                                          gdouble px,
                                          gdouble py);
static void bird_font_color_tool_finalize (GObject * obj);
static GType bird_font_color_tool_get_type_once (void);

static void
__lambda271_ (BirdFontColorTool* self)
{
	bird_font_tool_redraw ((BirdFontTool*) self);
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda271__bird_font_color_tool_color_updated (BirdFontColorTool* _sender,
                                                  gpointer self)
{
	__lambda271_ ((BirdFontColorTool*) self);
}

BirdFontColorTool*
bird_font_color_tool_construct (GType object_type,
                                const gchar* tooltip)
{
	BirdFontColorTool * self = NULL;
	g_return_val_if_fail (tooltip != NULL, NULL);
	self = (BirdFontColorTool*) bird_font_tool_construct (object_type, NULL, tooltip);
	g_signal_connect_object (self, "color-updated", (GCallback) ___lambda271__bird_font_color_tool_color_updated, self, 0);
	return self;
}

BirdFontColorTool*
bird_font_color_tool_new (const gchar* tooltip)
{
	return bird_font_color_tool_construct (BIRD_FONT_TYPE_COLOR_TOOL, tooltip);
}

BirdFontColor*
bird_font_color_tool_get_color (BirdFontColorTool* self)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_color_new (self->color_r, self->color_g, self->color_b, self->color_a);
	result = _tmp0_;
	return result;
}

void
bird_font_color_tool_set_color (BirdFontColorTool* self,
                                BirdFontColor* c)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	self->color_r = c->r;
	self->color_g = c->g;
	self->color_b = c->b;
	self->color_a = c->a;
	g_signal_emit (self, bird_font_color_tool_signals[BIRD_FONT_COLOR_TOOL_COLOR_UPDATED_SIGNAL], 0);
}

void
bird_font_color_tool_signal_color_updated (BirdFontColorTool* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, bird_font_color_tool_signals[BIRD_FONT_COLOR_TOOL_COLOR_UPDATED_SIGNAL], 0);
}

static void
bird_font_color_tool_real_draw_tool (BirdFontTool* base,
                                     cairo_t* cr,
                                     gdouble px,
                                     gdouble py)
{
	BirdFontColorTool * self;
	gdouble scale = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble xt = 0.0;
	gdouble yt = 0.0;
	self = (BirdFontColorTool*) base;
	g_return_if_fail (cr != NULL);
	scale = bird_font_toolbox_get_scale ();
	x = ((BirdFontTool*) self)->x - px;
	y = ((BirdFontTool*) self)->y - py;
	xt = (x + (((BirdFontTool*) self)->w / 2)) - (8 * scale);
	yt = (y + (((BirdFontTool*) self)->h / 2)) - (8 * scale);
	BIRD_FONT_TOOL_CLASS (bird_font_color_tool_parent_class)->draw_tool (G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool), cr, px, py);
	cairo_save (cr);
	cairo_set_source_rgba (cr, self->color_r, self->color_g, self->color_b, (gdouble) 1);
	cairo_rectangle (cr, xt, yt, 16 * scale, 16 * scale);
	cairo_fill (cr);
	cairo_restore (cr);
}

void
bird_font_color_tool_set_r (BirdFontColorTool* self,
                            gdouble c)
{
	g_return_if_fail (self != NULL);
	self->color_r = c;
}

void
bird_font_color_tool_set_g (BirdFontColorTool* self,
                            gdouble c)
{
	g_return_if_fail (self != NULL);
	self->color_g = c;
}

void
bird_font_color_tool_set_b (BirdFontColorTool* self,
                            gdouble c)
{
	g_return_if_fail (self != NULL);
	self->color_b = c;
}

void
bird_font_color_tool_set_a (BirdFontColorTool* self,
                            gdouble c)
{
	g_return_if_fail (self != NULL);
	self->color_a = c;
}

static void
bird_font_color_tool_class_init (BirdFontColorToolClass * klass,
                                 gpointer klass_data)
{
	bird_font_color_tool_parent_class = g_type_class_peek_parent (klass);
	((BirdFontToolClass *) klass)->draw_tool = (void (*) (BirdFontTool*, cairo_t*, gdouble, gdouble)) bird_font_color_tool_real_draw_tool;
	G_OBJECT_CLASS (klass)->finalize = bird_font_color_tool_finalize;
	bird_font_color_tool_signals[BIRD_FONT_COLOR_TOOL_COLOR_UPDATED_SIGNAL] = g_signal_new ("color-updated", BIRD_FONT_TYPE_COLOR_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bird_font_color_tool_instance_init (BirdFontColorTool * self,
                                    gpointer klass)
{
	self->color_r = (gdouble) 0;
	self->color_g = (gdouble) 0;
	self->color_b = (gdouble) 0;
	self->color_a = (gdouble) 0;
}

static void
bird_font_color_tool_finalize (GObject * obj)
{
	BirdFontColorTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_COLOR_TOOL, BirdFontColorTool);
	G_OBJECT_CLASS (bird_font_color_tool_parent_class)->finalize (obj);
}

static GType
bird_font_color_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontColorToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_color_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontColorTool), 0, (GInstanceInitFunc) bird_font_color_tool_instance_init, NULL };
	GType bird_font_color_tool_type_id;
	bird_font_color_tool_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontColorTool", &g_define_type_info, 0);
	return bird_font_color_tool_type_id;
}

GType
bird_font_color_tool_get_type (void)
{
	static volatile gsize bird_font_color_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_color_tool_type_id__once)) {
		GType bird_font_color_tool_type_id;
		bird_font_color_tool_type_id = bird_font_color_tool_get_type_once ();
		g_once_init_leave (&bird_font_color_tool_type_id__once, bird_font_color_tool_type_id);
	}
	return bird_font_color_tool_type_id__once;
}

