/* ColorPicker.c generated by valac 0.56.16, the Vala compiler
 * generated from ColorPicker.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_COLOR_PICKER_0_PROPERTY,
	BIRD_FONT_COLOR_PICKER_NUM_PROPERTIES
};
static GParamSpec* bird_font_color_picker_properties[BIRD_FONT_COLOR_PICKER_NUM_PROPERTIES];
#define _bird_font_color_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_color_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BIRD_FONT_COLOR_PICKER_FILL_COLOR_UPDATED_SIGNAL,
	BIRD_FONT_COLOR_PICKER_STROKE_COLOR_UPDATED_SIGNAL,
	BIRD_FONT_COLOR_PICKER_GRADIENT_COLOR_UPDATED_SIGNAL,
	BIRD_FONT_COLOR_PICKER_NUM_SIGNALS
};
static guint bird_font_color_picker_signals[BIRD_FONT_COLOR_PICKER_NUM_SIGNALS] = {0};

struct _BirdFontColorPickerPrivate {
	gdouble hue;
	gdouble s;
	gdouble b;
	gdouble a;
	gboolean update_color;
	gint selected_bar;
	gboolean stroke_selected;
	gboolean update_gradient;
	gint bars;
	BirdFontStop* current_stop;
};

static gint BirdFontColorPicker_private_offset;
static gpointer bird_font_color_picker_parent_class = NULL;

static void __lambda266_ (BirdFontColorPicker* self);
static void ___lambda266__bird_font_color_picker_stroke_color_updated (BirdFontColorPicker* _sender,
                                                                gpointer self);
static void __lambda267_ (BirdFontColorPicker* self,
                   BirdFontTool* selected,
                   guint button,
                   gdouble tx,
                   gdouble ty);
static void ___lambda267__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                      BirdFontTool* selected,
                                                      guint button,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self);
static gboolean __lambda268_ (BirdFontColorPicker* self,
                       BirdFontTool* selected,
                       BirdFontTool* button,
                       gdouble tx,
                       gdouble ty);
static gboolean ___lambda268__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                         BirdFontTool* selected,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self);
static void __lambda269_ (BirdFontColorPicker* self,
                   BirdFontTool* selected,
                   guint button,
                   gdouble tx,
                   gdouble ty);
static void ___lambda269__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                        BirdFontTool* selected,
                                                        guint button,
                                                        gdouble x,
                                                        gdouble y,
                                                        gpointer self);
static void bird_font_color_picker_real_draw_tool (BirdFontTool* base,
                                            cairo_t* cr,
                                            gdouble px,
                                            gdouble py);
static void bird_font_color_picker_draw_dial (BirdFontColorPicker* self,
                                       cairo_t* cr,
                                       gdouble px,
                                       gdouble py,
                                       gint bar_index,
                                       gdouble val);
static void bird_font_color_picker_finalize (GObject * obj);
static GType bird_font_color_picker_get_type_once (void);

static inline gpointer
bird_font_color_picker_get_instance_private (BirdFontColorPicker* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontColorPicker_private_offset);
}

static void
__lambda266_ (BirdFontColorPicker* self)
{
	bird_font_tool_redraw ((BirdFontTool*) self);
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda266__bird_font_color_picker_stroke_color_updated (BirdFontColorPicker* _sender,
                                                           gpointer self)
{
	__lambda266_ ((BirdFontColorPicker*) self);
}

static void
__lambda267_ (BirdFontColorPicker* self,
              BirdFontTool* selected,
              guint button,
              gdouble tx,
              gdouble ty)
{
	gdouble _tmp0_;
	g_return_if_fail (selected != NULL);
	_tmp0_ = ty;
	if ((((BirdFontTool*) self)->y <= _tmp0_) && (_tmp0_ <= (((BirdFontTool*) self)->y + (self->priv->bars * self->bar_height)))) {
		self->priv->update_color = TRUE;
		self->priv->selected_bar = (gint) ((ty - ((BirdFontTool*) self)->y) / self->bar_height);
		bird_font_color_picker_set_color_from_pointer (self, tx);
	}
}

static void
___lambda267__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 guint button,
                                                 gdouble x,
                                                 gdouble y,
                                                 gpointer self)
{
	__lambda267_ ((BirdFontColorPicker*) self, selected, button, x, y);
}

static gboolean
__lambda268_ (BirdFontColorPicker* self,
              BirdFontTool* selected,
              BirdFontTool* button,
              gdouble tx,
              gdouble ty)
{
	gboolean result;
	g_return_val_if_fail (selected != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	if (self->priv->update_color) {
		bird_font_color_picker_set_color_from_pointer (self, tx);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda268__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	gboolean result;
	result = __lambda268_ ((BirdFontColorPicker*) self, _sender, selected, x, y);
	return result;
}

static void
__lambda269_ (BirdFontColorPicker* self,
              BirdFontTool* selected,
              guint button,
              gdouble tx,
              gdouble ty)
{
	g_return_if_fail (selected != NULL);
	self->priv->update_color = FALSE;
}

static void
___lambda269__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                   BirdFontTool* selected,
                                                   guint button,
                                                   gdouble x,
                                                   gdouble y,
                                                   gpointer self)
{
	__lambda269_ ((BirdFontColorPicker*) self, selected, button, x, y);
}

BirdFontColorPicker*
bird_font_color_picker_construct (GType object_type,
                                  const gchar* tooltip)
{
	BirdFontColorPicker * self = NULL;
	g_return_val_if_fail (tooltip != NULL, NULL);
	self = (BirdFontColorPicker*) bird_font_tool_construct (object_type, NULL, tooltip);
	self->bar_height = 22 * bird_font_toolbox_get_scale ();
	self->priv->bars = 5;
	((BirdFontTool*) self)->h = self->priv->bars * self->bar_height;
	g_signal_connect_object (self, "stroke-color-updated", (GCallback) ___lambda266__bird_font_color_picker_stroke_color_updated, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-press-action", (GCallback) ___lambda267__bird_font_tool_panel_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-move-action", (GCallback) ___lambda268__bird_font_tool_panel_move_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-release-action", (GCallback) ___lambda269__bird_font_tool_panel_release_action, self, 0);
	return self;
}

BirdFontColorPicker*
bird_font_color_picker_new (const gchar* tooltip)
{
	return bird_font_color_picker_construct (BIRD_FONT_TYPE_COLOR_PICKER, tooltip);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_color_picker_set_gradient (BirdFontColorPicker* self,
                                     BirdFontGradient* g,
                                     BirdFontStop* stop,
                                     gboolean update_gradient)
{
	BirdFontGradient* _tmp0_;
	BirdFontStop* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	g_return_if_fail (stop != NULL);
	_tmp0_ = _g_object_ref0 (g);
	_g_object_unref0 (self->gradient);
	self->gradient = _tmp0_;
	self->priv->update_gradient = update_gradient;
	_tmp1_ = _g_object_ref0 (stop);
	_g_object_unref0 (self->priv->current_stop);
	self->priv->current_stop = _tmp1_;
	bird_font_tool_redraw ((BirdFontTool*) self);
}

void
bird_font_color_picker_set_color (BirdFontColorPicker* self,
                                  BirdFontColor* c)
{
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	bird_font_color_to_hsva (c, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	self->priv->hue = _tmp0_;
	self->priv->s = _tmp1_;
	self->priv->b = _tmp2_;
	self->priv->a = _tmp3_;
}

void
bird_font_color_picker_set_color_from_pointer (BirdFontColorPicker* self,
                                               gdouble tx)
{
	g_return_if_fail (self != NULL);
	if (tx > ((gdouble) bird_font_toolbox_allocation_width)) {
		tx = (gdouble) bird_font_toolbox_allocation_width;
	}
	if (tx < ((gdouble) 0)) {
		tx = (gdouble) 0;
	}
	if (self->priv->selected_bar == 0) {
		self->priv->hue = ((gdouble) tx) / bird_font_toolbox_allocation_width;
	} else {
		if (self->priv->selected_bar == 1) {
			self->priv->s = ((gdouble) tx) / bird_font_toolbox_allocation_width;
		} else {
			if (self->priv->selected_bar == 2) {
				self->priv->b = ((gdouble) tx) / bird_font_toolbox_allocation_width;
			} else {
				if (self->priv->selected_bar == 3) {
					self->priv->a = ((gdouble) tx) / bird_font_toolbox_allocation_width;
				} else {
					gboolean _tmp0_ = FALSE;
					if (!self->priv->update_gradient) {
						_tmp0_ = self->priv->selected_bar == 4;
					} else {
						_tmp0_ = FALSE;
					}
					if (_tmp0_) {
						if (self->has_stroke_color) {
							self->priv->stroke_selected = tx > (bird_font_toolbox_allocation_width / 2.0);
							if (self->priv->stroke_selected) {
								BirdFontColor* _tmp1_;
								_tmp1_ = self->stroke_color;
								bird_font_color_picker_set_color (self, _tmp1_);
							} else {
								BirdFontColor* _tmp2_;
								_tmp2_ = self->fill_color;
								bird_font_color_picker_set_color (self, _tmp2_);
							}
						}
					} else {
						gboolean _tmp3_ = FALSE;
						if (self->priv->update_gradient) {
							_tmp3_ = self->priv->selected_bar == 4;
						} else {
							_tmp3_ = FALSE;
						}
						if (_tmp3_) {
							BirdFontGradient* _tmp4_;
							GeeArrayList* _tmp5_;
							gint _tmp6_;
							gint _tmp7_;
							_tmp4_ = self->gradient;
							_tmp5_ = _tmp4_->stops;
							_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
							_tmp7_ = _tmp6_;
							if (_tmp7_ > 0) {
								gint g = 0;
								BirdFontGradient* _tmp8_;
								GeeArrayList* _tmp9_;
								gint _tmp10_;
								gint _tmp11_;
								BirdFontGradient* _tmp12_;
								GeeArrayList* _tmp13_;
								gint _tmp14_;
								gint _tmp15_;
								gint _tmp16_;
								BirdFontGradient* _tmp17_;
								GeeArrayList* _tmp18_;
								gpointer _tmp19_;
								BirdFontStop* _tmp20_;
								BirdFontColor* _tmp21_;
								_tmp8_ = self->gradient;
								_tmp9_ = _tmp8_->stops;
								_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
								_tmp11_ = _tmp10_;
								g = (gint) ((tx / bird_font_toolbox_allocation_width) * _tmp11_);
								_tmp12_ = self->gradient;
								_tmp13_ = _tmp12_->stops;
								_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
								_tmp15_ = _tmp14_;
								_tmp16_ = g;
								g_return_if_fail ((0 <= _tmp16_) && (_tmp16_ < _tmp15_));
								_tmp17_ = self->gradient;
								_tmp18_ = _tmp17_->stops;
								_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, g);
								_g_object_unref0 (self->priv->current_stop);
								self->priv->current_stop = (BirdFontStop*) _tmp19_;
								_tmp20_ = self->priv->current_stop;
								_tmp21_ = _tmp20_->color;
								bird_font_color_picker_set_color (self, _tmp21_);
							}
						}
					}
				}
			}
		}
	}
	if (self->priv->selected_bar != 4) {
		if (self->priv->update_gradient) {
			BirdFontStop* _tmp22_;
			BirdFontColor* _tmp23_;
			_tmp22_ = self->priv->current_stop;
			_tmp23_ = bird_font_color_new_hsba (self->priv->hue, self->priv->s, self->priv->b, self->priv->a);
			_bird_font_color_unref0 (_tmp22_->color);
			_tmp22_->color = _tmp23_;
			g_signal_emit (self, bird_font_color_picker_signals[BIRD_FONT_COLOR_PICKER_GRADIENT_COLOR_UPDATED_SIGNAL], 0);
		} else {
			gboolean _tmp24_ = FALSE;
			if (self->has_stroke_color) {
				_tmp24_ = self->priv->stroke_selected;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				BirdFontColor* _tmp25_;
				_tmp25_ = bird_font_color_new_hsba (self->priv->hue, self->priv->s, self->priv->b, self->priv->a);
				_bird_font_color_unref0 (self->stroke_color);
				self->stroke_color = _tmp25_;
				g_signal_emit (self, bird_font_color_picker_signals[BIRD_FONT_COLOR_PICKER_STROKE_COLOR_UPDATED_SIGNAL], 0);
			} else {
				BirdFontColor* _tmp26_;
				_tmp26_ = bird_font_color_new_hsba (self->priv->hue, self->priv->s, self->priv->b, self->priv->a);
				_bird_font_color_unref0 (self->fill_color);
				self->fill_color = _tmp26_;
				g_signal_emit (self, bird_font_color_picker_signals[BIRD_FONT_COLOR_PICKER_FILL_COLOR_UPDATED_SIGNAL], 0);
			}
		}
	}
}

static gpointer
_bird_font_color_ref0 (gpointer self)
{
	return self ? bird_font_color_ref (self) : NULL;
}

BirdFontColor*
bird_font_color_picker_get_stroke_color (BirdFontColorPicker* self)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* _tmp1_;
	BirdFontColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->stroke_color;
	_tmp1_ = _bird_font_color_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

BirdFontColor*
bird_font_color_picker_get_fill_color (BirdFontColorPicker* self)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* _tmp1_;
	BirdFontColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->fill_color;
	_tmp1_ = _bird_font_color_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
bird_font_color_picker_real_draw_tool (BirdFontTool* base,
                                       cairo_t* cr,
                                       gdouble px,
                                       gdouble py)
{
	BirdFontColorPicker * self;
	self = (BirdFontColorPicker*) base;
	g_return_if_fail (cr != NULL);
	bird_font_color_picker_draw_bars (self, cr, px, py);
	bird_font_color_picker_draw_dial (self, cr, px, py, 0, self->priv->hue);
	bird_font_color_picker_draw_dial (self, cr, px, py, 1, self->priv->s);
	bird_font_color_picker_draw_dial (self, cr, px, py, 2, self->priv->b);
	bird_font_color_picker_draw_dial (self, cr, px, py, 3, self->priv->a);
}

void
bird_font_color_picker_draw_bars (BirdFontColorPicker* self,
                                  cairo_t* cr,
                                  gdouble px,
                                  gdouble py)
{
	gdouble scale = 0.0;
	gdouble step = 0.0;
	BirdFontColor* c = NULL;
	gdouble y = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	scale = bird_font_toolbox_get_scale ();
	step = 1.0 / bird_font_toolbox_allocation_width;
	y = ((BirdFontTool*) self)->y - py;
	{
		gdouble p = 0.0;
		p = (gdouble) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				BirdFontColor* _tmp1_;
				BirdFontColor* _tmp2_;
				BirdFontColor* _tmp3_;
				BirdFontColor* _tmp4_;
				BirdFontColor* _tmp5_;
				BirdFontColor* _tmp6_;
				BirdFontColor* _tmp7_;
				BirdFontColor* _tmp8_;
				BirdFontColor* _tmp9_;
				BirdFontColor* _tmp10_;
				BirdFontColor* _tmp11_;
				BirdFontColor* _tmp12_;
				BirdFontColor* _tmp13_;
				BirdFontColor* _tmp14_;
				BirdFontColor* _tmp15_;
				BirdFontColor* _tmp16_;
				BirdFontColor* _tmp17_;
				BirdFontColor* _tmp18_;
				BirdFontColor* _tmp19_;
				BirdFontColor* _tmp20_;
				if (!_tmp0_) {
					p += step;
				}
				_tmp0_ = FALSE;
				if (!(p < ((gdouble) 1))) {
					break;
				}
				_tmp1_ = bird_font_color_new_hsba (p, (gdouble) 1, (gdouble) 1, (gdouble) 1);
				_bird_font_color_unref0 (c);
				c = _tmp1_;
				cairo_save (cr);
				_tmp2_ = c;
				_tmp3_ = c;
				_tmp4_ = c;
				_tmp5_ = c;
				cairo_set_source_rgba (cr, _tmp2_->r, _tmp3_->g, _tmp4_->b, _tmp5_->a);
				cairo_rectangle (cr, p * bird_font_toolbox_allocation_width, y, scale, self->bar_height);
				cairo_fill (cr);
				cairo_restore (cr);
				_tmp6_ = bird_font_color_new_hsba (self->priv->hue, p, (gdouble) 1, (gdouble) 1);
				_bird_font_color_unref0 (c);
				c = _tmp6_;
				cairo_save (cr);
				_tmp7_ = c;
				_tmp8_ = c;
				_tmp9_ = c;
				_tmp10_ = c;
				cairo_set_source_rgba (cr, _tmp7_->r, _tmp8_->g, _tmp9_->b, _tmp10_->a);
				cairo_rectangle (cr, p * bird_font_toolbox_allocation_width, y + self->bar_height, scale, self->bar_height);
				cairo_fill (cr);
				cairo_restore (cr);
				_tmp11_ = bird_font_color_new_hsba (self->priv->hue, self->priv->s, p, (gdouble) 1);
				_bird_font_color_unref0 (c);
				c = _tmp11_;
				cairo_save (cr);
				_tmp12_ = c;
				_tmp13_ = c;
				_tmp14_ = c;
				_tmp15_ = c;
				cairo_set_source_rgba (cr, _tmp12_->r, _tmp13_->g, _tmp14_->b, _tmp15_->a);
				cairo_rectangle (cr, p * bird_font_toolbox_allocation_width, y + (2 * self->bar_height), scale, self->bar_height);
				cairo_fill (cr);
				cairo_restore (cr);
				_tmp16_ = bird_font_color_new_hsba (self->priv->hue, self->priv->s, self->priv->b, p);
				_bird_font_color_unref0 (c);
				c = _tmp16_;
				cairo_save (cr);
				_tmp17_ = c;
				_tmp18_ = c;
				_tmp19_ = c;
				_tmp20_ = c;
				cairo_set_source_rgba (cr, _tmp17_->r, _tmp18_->g, _tmp19_->b, _tmp20_->a);
				cairo_rectangle (cr, p * bird_font_toolbox_allocation_width, y + (3 * self->bar_height), scale, self->bar_height);
				cairo_fill (cr);
				cairo_restore (cr);
			}
		}
	}
	if (!self->priv->update_gradient) {
		if (!self->has_stroke_color) {
			BirdFontColor* _tmp21_;
			BirdFontColor* _tmp22_;
			BirdFontColor* _tmp23_;
			BirdFontColor* _tmp24_;
			BirdFontColor* _tmp25_;
			BirdFontColor* _tmp26_;
			_tmp21_ = self->fill_color;
			_tmp22_ = _bird_font_color_ref0 (_tmp21_);
			_bird_font_color_unref0 (c);
			c = _tmp22_;
			cairo_save (cr);
			_tmp23_ = c;
			_tmp24_ = c;
			_tmp25_ = c;
			_tmp26_ = c;
			cairo_set_source_rgba (cr, _tmp23_->r, _tmp24_->g, _tmp25_->b, _tmp26_->a);
			cairo_rectangle (cr, (gdouble) 0, y + (4 * self->bar_height), (gdouble) bird_font_toolbox_allocation_width, self->bar_height);
			cairo_fill (cr);
			cairo_restore (cr);
		} else {
			gdouble cw = 0.0;
			BirdFontColor* _tmp27_;
			BirdFontColor* _tmp28_;
			BirdFontColor* _tmp29_;
			BirdFontColor* _tmp30_;
			BirdFontColor* _tmp31_;
			BirdFontColor* _tmp32_;
			BirdFontColor* _tmp33_;
			BirdFontColor* _tmp34_;
			cw = (bird_font_toolbox_allocation_width / 2.0) - (2 * scale);
			cairo_save (cr);
			_tmp27_ = self->fill_color;
			_tmp28_ = self->fill_color;
			_tmp29_ = self->fill_color;
			_tmp30_ = self->fill_color;
			cairo_set_source_rgba (cr, _tmp27_->r, _tmp28_->g, _tmp29_->b, _tmp30_->a);
			cairo_rectangle (cr, (gdouble) 0, y + (4 * self->bar_height), cw, self->bar_height);
			cairo_fill (cr);
			cairo_restore (cr);
			cairo_save (cr);
			_tmp31_ = self->stroke_color;
			_tmp32_ = self->stroke_color;
			_tmp33_ = self->stroke_color;
			_tmp34_ = self->stroke_color;
			cairo_set_source_rgba (cr, _tmp31_->r, _tmp32_->g, _tmp33_->b, _tmp34_->a);
			cairo_rectangle (cr, cw + (4 * scale), y + (4 * self->bar_height), cw, self->bar_height);
			cairo_fill (cr);
			cairo_restore (cr);
			if (self->has_stroke_color) {
				if (self->priv->stroke_selected) {
					cairo_save (cr);
					bird_font_theme_color (cr, "Tool Foreground");
					cairo_set_line_width (cr, (gdouble) 1);
					cairo_rectangle (cr, cw + (4 * scale), y + (4 * self->bar_height), cw, self->bar_height);
					cairo_stroke (cr);
					cairo_restore (cr);
				} else {
					cairo_save (cr);
					bird_font_theme_color (cr, "Tool Foreground");
					cairo_set_line_width (cr, (gdouble) 1);
					cairo_rectangle (cr, (gdouble) 0, y + (4 * self->bar_height), cw, self->bar_height);
					cairo_stroke (cr);
					cairo_restore (cr);
				}
			}
		}
	} else {
		gint stop_size = 0;
		BirdFontGradient* _tmp35_;
		GeeArrayList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gboolean found = FALSE;
		_tmp35_ = self->gradient;
		_tmp36_ = _tmp35_->stops;
		_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		stop_size = (gint) (((gdouble) bird_font_toolbox_allocation_width) / _tmp38_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp39_ = FALSE;
				_tmp39_ = TRUE;
				while (TRUE) {
					BirdFontGradient* _tmp41_;
					GeeArrayList* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					BirdFontStop* s = NULL;
					BirdFontGradient* _tmp45_;
					GeeArrayList* _tmp46_;
					gpointer _tmp47_;
					BirdFontStop* _tmp48_;
					BirdFontColor* _tmp49_;
					BirdFontColor* _tmp50_;
					BirdFontColor* _tmp51_;
					BirdFontColor* _tmp52_;
					BirdFontColor* _tmp53_;
					BirdFontColor* _tmp54_;
					if (!_tmp39_) {
						gint _tmp40_;
						_tmp40_ = i;
						i = _tmp40_ + 1;
					}
					_tmp39_ = FALSE;
					_tmp41_ = self->gradient;
					_tmp42_ = _tmp41_->stops;
					_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
					_tmp44_ = _tmp43_;
					if (!(i < _tmp44_)) {
						break;
					}
					_tmp45_ = self->gradient;
					_tmp46_ = _tmp45_->stops;
					_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, i);
					s = (BirdFontStop*) _tmp47_;
					_tmp48_ = s;
					_tmp49_ = _tmp48_->color;
					_tmp50_ = _bird_font_color_ref0 (_tmp49_);
					_bird_font_color_unref0 (c);
					c = _tmp50_;
					cairo_save (cr);
					_tmp51_ = c;
					_tmp52_ = c;
					_tmp53_ = c;
					_tmp54_ = c;
					cairo_set_source_rgba (cr, _tmp51_->r, _tmp52_->g, _tmp53_->b, _tmp54_->a);
					cairo_rectangle (cr, (gdouble) (i * stop_size), y + (4 * self->bar_height), (gdouble) stop_size, self->bar_height);
					cairo_fill (cr);
					cairo_restore (cr);
					_g_object_unref0 (s);
				}
			}
		}
		found = FALSE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp55_ = FALSE;
				_tmp55_ = TRUE;
				while (TRUE) {
					BirdFontGradient* _tmp57_;
					GeeArrayList* _tmp58_;
					gint _tmp59_;
					gint _tmp60_;
					BirdFontStop* s = NULL;
					BirdFontGradient* _tmp61_;
					GeeArrayList* _tmp62_;
					gpointer _tmp63_;
					BirdFontStop* _tmp64_;
					BirdFontStop* _tmp65_;
					if (!_tmp55_) {
						gint _tmp56_;
						_tmp56_ = i;
						i = _tmp56_ + 1;
					}
					_tmp55_ = FALSE;
					_tmp57_ = self->gradient;
					_tmp58_ = _tmp57_->stops;
					_tmp59_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp58_);
					_tmp60_ = _tmp59_;
					if (!(i < _tmp60_)) {
						break;
					}
					_tmp61_ = self->gradient;
					_tmp62_ = _tmp61_->stops;
					_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, i);
					s = (BirdFontStop*) _tmp63_;
					_tmp64_ = s;
					_tmp65_ = self->priv->current_stop;
					if (_tmp64_ == _tmp65_) {
						found = TRUE;
						cairo_save (cr);
						bird_font_theme_color (cr, "Tool Foreground");
						cairo_set_line_width (cr, (gdouble) 1);
						cairo_rectangle (cr, (gdouble) (i * stop_size), y + (4 * self->bar_height), (gdouble) stop_size, self->bar_height);
						cairo_stroke (cr);
						cairo_restore (cr);
					}
					_g_object_unref0 (s);
				}
			}
		}
		if (!found) {
			g_warning ("ColorPicker.vala:262: No stop selected.");
		}
	}
	_bird_font_color_unref0 (c);
}

static void
bird_font_color_picker_draw_dial (BirdFontColorPicker* self,
                                  cairo_t* cr,
                                  gdouble px,
                                  gdouble py,
                                  gint bar_index,
                                  gdouble val)
{
	gdouble y = 0.0;
	gdouble scale = 0.0;
	gdouble p = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	y = ((BirdFontTool*) self)->y - py;
	scale = bird_font_toolbox_get_scale ();
	p = bar_index * self->bar_height;
	g_return_if_fail ((((y + p) + self->bar_height) - (2 * scale)) > ((gdouble) 0));
	cairo_save (cr);
	cairo_set_line_width (cr, 1 * scale);
	cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_move_to (cr, ((val * bird_font_toolbox_allocation_width) * scale) - (3 * scale), (y + p) + self->bar_height);
	cairo_line_to (cr, val * bird_font_toolbox_allocation_width, ((y + p) + self->bar_height) - (2 * scale));
	cairo_line_to (cr, (val * bird_font_toolbox_allocation_width) + (3 * scale), (y + p) + self->bar_height);
	cairo_stroke_preserve (cr);
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	cairo_set_line_width (cr, 1 * scale);
	cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_move_to (cr, ((val * bird_font_toolbox_allocation_width) * scale) - (3 * scale), y + p);
	cairo_line_to (cr, val * bird_font_toolbox_allocation_width, (y + p) + (2 * scale));
	cairo_line_to (cr, (val * bird_font_toolbox_allocation_width) + (3 * scale), y + p);
	cairo_stroke_preserve (cr);
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	cairo_fill (cr);
	cairo_restore (cr);
}

static void
bird_font_color_picker_class_init (BirdFontColorPickerClass * klass,
                                   gpointer klass_data)
{
	bird_font_color_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontColorPicker_private_offset);
	((BirdFontToolClass *) klass)->draw_tool = (void (*) (BirdFontTool*, cairo_t*, gdouble, gdouble)) bird_font_color_picker_real_draw_tool;
	G_OBJECT_CLASS (klass)->finalize = bird_font_color_picker_finalize;
	bird_font_color_picker_signals[BIRD_FONT_COLOR_PICKER_FILL_COLOR_UPDATED_SIGNAL] = g_signal_new ("fill-color-updated", BIRD_FONT_TYPE_COLOR_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	bird_font_color_picker_signals[BIRD_FONT_COLOR_PICKER_STROKE_COLOR_UPDATED_SIGNAL] = g_signal_new ("stroke-color-updated", BIRD_FONT_TYPE_COLOR_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	bird_font_color_picker_signals[BIRD_FONT_COLOR_PICKER_GRADIENT_COLOR_UPDATED_SIGNAL] = g_signal_new ("gradient-color-updated", BIRD_FONT_TYPE_COLOR_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bird_font_color_picker_instance_init (BirdFontColorPicker * self,
                                      gpointer klass)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* _tmp1_;
	BirdFontGradient* _tmp2_;
	BirdFontStop* _tmp3_;
	self->priv = bird_font_color_picker_get_instance_private (self);
	self->priv->hue = (gdouble) 0;
	self->priv->s = (gdouble) 0;
	self->priv->b = (gdouble) 0;
	self->priv->a = (gdouble) 1;
	self->priv->update_color = FALSE;
	self->priv->selected_bar = 0;
	self->has_stroke_color = FALSE;
	self->priv->stroke_selected = FALSE;
	_tmp0_ = bird_font_color_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	self->stroke_color = _tmp0_;
	_tmp1_ = bird_font_color_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	self->fill_color = _tmp1_;
	_tmp2_ = bird_font_gradient_new ();
	self->gradient = _tmp2_;
	self->priv->update_gradient = FALSE;
	_tmp3_ = bird_font_stop_new ();
	self->priv->current_stop = _tmp3_;
}

static void
bird_font_color_picker_finalize (GObject * obj)
{
	BirdFontColorPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_COLOR_PICKER, BirdFontColorPicker);
	_bird_font_color_unref0 (self->stroke_color);
	_bird_font_color_unref0 (self->fill_color);
	_g_object_unref0 (self->gradient);
	_g_object_unref0 (self->priv->current_stop);
	G_OBJECT_CLASS (bird_font_color_picker_parent_class)->finalize (obj);
}

static GType
bird_font_color_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontColorPickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_color_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontColorPicker), 0, (GInstanceInitFunc) bird_font_color_picker_instance_init, NULL };
	GType bird_font_color_picker_type_id;
	bird_font_color_picker_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontColorPicker", &g_define_type_info, 0);
	BirdFontColorPicker_private_offset = g_type_add_instance_private (bird_font_color_picker_type_id, sizeof (BirdFontColorPickerPrivate));
	return bird_font_color_picker_type_id;
}

GType
bird_font_color_picker_get_type (void)
{
	static volatile gsize bird_font_color_picker_type_id__once = 0;
	if (g_once_init_enter (&bird_font_color_picker_type_id__once)) {
		GType bird_font_color_picker_type_id;
		bird_font_color_picker_type_id = bird_font_color_picker_get_type_once ();
		g_once_init_leave (&bird_font_color_picker_type_id__once, bird_font_color_picker_type_id);
	}
	return bird_font_color_picker_type_id__once;
}

