/* Color.c generated by valac 0.56.16, the Vala compiler
 * generated from Color.vala, do not modify */

/* Copyright (C) 1999 The Free Software Foundation
 *
 * Authors: Simon Budig <Simon.Budig@unix-ag.org> (original code)
 *          Federico Mena-Quintero <federico@gimp.org> (cleanup for GTK+)
 *          Jonathan Blandford <jrb@redhat.com> (cleanup for GTK+)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "birdfont.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BirdFontParamSpecColor BirdFontParamSpecColor;

struct _BirdFontParamSpecColor {
	GParamSpec parent_instance;
};

static gpointer bird_font_color_parent_class = NULL;

static void bird_font_color_finalize (BirdFontColor * obj);
static GType bird_font_color_get_type_once (void);

BirdFontColor*
bird_font_color_construct (GType object_type,
                           gdouble r,
                           gdouble g,
                           gdouble b,
                           gdouble a)
{
	BirdFontColor* self = NULL;
	self = (BirdFontColor*) g_type_create_instance (object_type);
	self->r = r;
	self->g = g;
	self->b = b;
	self->a = a;
	return self;
}

BirdFontColor*
bird_font_color_new (gdouble r,
                     gdouble g,
                     gdouble b,
                     gdouble a)
{
	return bird_font_color_construct (BIRD_FONT_TYPE_COLOR, r, g, b, a);
}

BirdFontColor*
bird_font_color_construct_hsba (GType object_type,
                                gdouble h,
                                gdouble s,
                                gdouble v,
                                gdouble a)
{
	BirdFontColor* self = NULL;
	gdouble hue = 0.0;
	gdouble saturation = 0.0;
	gdouble value = 0.0;
	gdouble f = 0.0;
	gdouble p = 0.0;
	gdouble q = 0.0;
	gdouble t = 0.0;
	self = (BirdFontColor*) g_type_create_instance (object_type);
	self->a = a;
	if (s == 0.0) {
		self->r = v;
		self->g = v;
		self->b = v;
	} else {
		hue = h * 6.0;
		saturation = s;
		value = v;
		if (hue == 6.0) {
			hue = 0.0;
		}
		f = hue - ((gint) hue);
		p = value * (1.0 - saturation);
		q = value * (1.0 - (saturation * f));
		t = value * (1.0 - (saturation * (1.0 - f)));
		switch ((gint) hue) {
			case 0:
			{
				self->r = value;
				self->g = t;
				self->b = p;
				break;
			}
			case 1:
			{
				self->r = q;
				self->g = value;
				self->b = p;
				break;
			}
			case 2:
			{
				self->r = p;
				self->g = value;
				self->b = t;
				break;
			}
			case 3:
			{
				self->r = p;
				self->g = q;
				self->b = value;
				break;
			}
			case 4:
			{
				self->r = t;
				self->g = p;
				self->b = value;
				break;
			}
			case 5:
			{
				self->r = value;
				self->g = p;
				self->b = q;
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	return self;
}

BirdFontColor*
bird_font_color_new_hsba (gdouble h,
                          gdouble s,
                          gdouble v,
                          gdouble a)
{
	return bird_font_color_construct_hsba (BIRD_FONT_TYPE_COLOR, h, s, v, a);
}

void
bird_font_color_to_hsva (BirdFontColor* self,
                         gdouble* h,
                         gdouble* s,
                         gdouble* v,
                         gdouble* a)
{
	gdouble _vala_h = 0.0;
	gdouble _vala_s = 0.0;
	gdouble _vala_v = 0.0;
	gdouble _vala_a = 0.0;
	gdouble red = 0.0;
	gdouble green = 0.0;
	gdouble blue = 0.0;
	gdouble min = 0.0;
	gdouble max = 0.0;
	gdouble delta = 0.0;
	g_return_if_fail (self != NULL);
	_vala_a = self->a;
	red = self->r;
	green = self->g;
	blue = self->b;
	_vala_h = 0.0;
	if (red > green) {
		if (red > blue) {
			max = red;
		} else {
			max = blue;
		}
		if (green < blue) {
			min = green;
		} else {
			min = blue;
		}
	} else {
		if (green > blue) {
			max = green;
		} else {
			max = blue;
		}
		if (red < blue) {
			min = red;
		} else {
			min = blue;
		}
	}
	_vala_v = max;
	if (max != 0.0) {
		_vala_s = (max - min) / max;
	} else {
		_vala_s = 0.0;
	}
	if (_vala_s == 0.0) {
		_vala_h = 0.0;
	} else {
		delta = max - min;
		if (red == max) {
			_vala_h = (green - blue) / delta;
		} else {
			if (green == max) {
				_vala_h = 2 + ((blue - red) / delta);
			} else {
				if (blue == max) {
					_vala_h = 4 + ((red - green) / delta);
				}
			}
		}
		_vala_h = _vala_h / 6.0;
		if (_vala_h < 0.0) {
			_vala_h = _vala_h + 1.0;
		} else {
			if (_vala_h > 1.0) {
				_vala_h = _vala_h - 1.0;
			}
		}
	}
	if (h) {
		*h = _vala_h;
	}
	if (s) {
		*s = _vala_s;
	}
	if (v) {
		*v = _vala_v;
	}
	if (a) {
		*a = _vala_a;
	}
}

BirdFontColor*
bird_font_color_black (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	result = _tmp0_;
	return result;
}

BirdFontColor*
bird_font_color_red (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new ((gdouble) 1, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	result = _tmp0_;
	return result;
}

BirdFontColor*
bird_font_color_green (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new ((gdouble) 0, (gdouble) 1, (gdouble) 0, (gdouble) 1);
	result = _tmp0_;
	return result;
}

BirdFontColor*
bird_font_color_blue (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new ((gdouble) 0, (gdouble) 0, (gdouble) 1, (gdouble) 1);
	result = _tmp0_;
	return result;
}

BirdFontColor*
bird_font_color_yellow (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new (222.0 / 255, 203.0 / 255, 43 / 255.0, (gdouble) 1);
	result = _tmp0_;
	return result;
}

BirdFontColor*
bird_font_color_brown (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new (160.0 / 255, 90.0 / 255, 44.0 / 255, (gdouble) 1);
	result = _tmp0_;
	return result;
}

BirdFontColor*
bird_font_color_pink (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new (247.0 / 255, 27.0 / 255, 113 / 255.0, (gdouble) 1);
	result = _tmp0_;
	return result;
}

BirdFontColor*
bird_font_color_white (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new ((gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	result = _tmp0_;
	return result;
}

BirdFontColor*
bird_font_color_grey (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new (0.5, 0.5, 0.5, (gdouble) 1);
	result = _tmp0_;
	return result;
}

BirdFontColor*
bird_font_color_magenta (void)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	_tmp0_ = bird_font_color_new (103.0 / 255, 33.0 / 255, 120.0 / 255, (gdouble) 1);
	result = _tmp0_;
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

gchar*
bird_font_color_to_string (BirdFontColor* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = double_to_string (self->r);
	_tmp1_ = _tmp0_;
	_tmp2_ = double_to_string (self->g);
	_tmp3_ = _tmp2_;
	_tmp4_ = double_to_string (self->b);
	_tmp5_ = _tmp4_;
	_tmp6_ = double_to_string (self->a);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("r: ", _tmp1_, ", g: ", _tmp3_, ", b: ", _tmp5_, ", a: ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp9_;
	return result;
}

BirdFontColor*
bird_font_color_copy (BirdFontColor* self)
{
	BirdFontColor* _tmp0_;
	BirdFontColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_color_new (self->r, self->g, self->b, self->a);
	result = _tmp0_;
	return result;
}

gchar*
bird_font_color_to_rgb_hex (BirdFontColor* self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("#");
	s = _tmp0_;
	_tmp1_ = s;
	_tmp2_ = bird_font_font_to_hex_code ((gunichar) rint (self->r * 255));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_g_free0 (s);
	s = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_ = s;
	_tmp6_ = bird_font_font_to_hex_code ((gunichar) rint (self->g * 255));
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
	_g_free0 (s);
	s = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = s;
	_tmp10_ = bird_font_font_to_hex_code ((gunichar) rint (self->b * 255));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
	_g_free0 (s);
	s = _tmp12_;
	_g_free0 (_tmp11_);
	result = s;
	return result;
}

static void
bird_font_value_color_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_color_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_color_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_color_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_color_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_color_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_color_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontColor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_color_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_color_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	BirdFontColor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_color_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_color (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	BirdFontParamSpecColor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_COLOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_color (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_COLOR), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_color (GValue* value,
                           gpointer v_object)
{
	BirdFontColor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_COLOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_COLOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_color_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_color_unref (old);
	}
}

void
bird_font_value_take_color (GValue* value,
                            gpointer v_object)
{
	BirdFontColor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_COLOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_COLOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_color_unref (old);
	}
}

static void
bird_font_color_class_init (BirdFontColorClass * klass,
                            gpointer klass_data)
{
	bird_font_color_parent_class = g_type_class_peek_parent (klass);
	((BirdFontColorClass *) klass)->finalize = bird_font_color_finalize;
}

static void
bird_font_color_instance_init (BirdFontColor * self,
                               gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_color_finalize (BirdFontColor * obj)
{
	BirdFontColor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_COLOR, BirdFontColor);
	g_signal_handlers_destroy (self);
}

static GType
bird_font_color_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_color_init, bird_font_value_color_free_value, bird_font_value_color_copy_value, bird_font_value_color_peek_pointer, "p", bird_font_value_color_collect_value, "p", bird_font_value_color_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontColorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_color_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontColor), 0, (GInstanceInitFunc) bird_font_color_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_color_type_id;
	bird_font_color_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontColor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_color_type_id;
}

GType
bird_font_color_get_type (void)
{
	static volatile gsize bird_font_color_type_id__once = 0;
	if (g_once_init_enter (&bird_font_color_type_id__once)) {
		GType bird_font_color_type_id;
		bird_font_color_type_id = bird_font_color_get_type_once ();
		g_once_init_leave (&bird_font_color_type_id__once, bird_font_color_type_id);
	}
	return bird_font_color_type_id__once;
}

gpointer
bird_font_color_ref (gpointer instance)
{
	BirdFontColor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_color_unref (gpointer instance)
{
	BirdFontColor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_COLOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

