/* ClipTool.c generated by valac 0.56.16, the Vala compiler
 * generated from ClipTool.vala, do not modify */

/*
Copyright (C) 2012 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CLIP_TOOL_0_PROPERTY,
	BIRD_FONT_CLIP_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_clip_tool_properties[BIRD_FONT_CLIP_TOOL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

static gpointer bird_font_clip_tool_parent_class = NULL;

static gchar* bird_font_clip_tool_export_selected_paths_to_birdfont_clipboard (void);
static gchar* bird_font_clip_tool_export_paths_to_birdfont_clipboard (gboolean overview,
                                                               gboolean selected);
static void bird_font_clip_tool_paste_paths (gboolean paste_guide_lines);
static void bird_font_clip_tool_paste_letters_to_spacing_tab (void);
static void bird_font_clip_tool_paste_letters_to_kerning_tab (void);
static void bird_font_clip_tool_paste_to_overview (void);
static void bird_font_clip_tool_paste_to_glyph (gboolean bf_clipboard_data,
                                         gboolean paste_guide_lines);
static void bird_font_clip_tool_import_birdfont_clipboard (const gchar* data,
                                                    gboolean paste_guide_lines,
                                                    gboolean overview);
VALA_EXTERN gchar* bird_font_bird_font_file_get_point_data (BirdFontPath* pl);
static gboolean bird_font_clip_tool_all_points_selected (BirdFontPath* p);
static BirdFontPath* bird_font_clip_tool_import_birdfont_path (BirdFontGlyph* glyph,
                                                        const gchar* data);
VALA_EXTERN void bird_font_bird_font_file_parse_path_data (const gchar* data,
                                               BirdFontPath* path);
static GType bird_font_clip_tool_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
bird_font_clip_tool_copy_text (BirdFontTextArea* t)
{
	BirdFontNativeWindow* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (t != NULL);
	_tmp0_ = bird_font_main_window_native_window;
	_tmp1_ = bird_font_text_area_get_selected_text (t);
	_tmp2_ = _tmp1_;
	bird_font_native_window_set_clipboard_text (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

void
bird_font_clip_tool_paste_text (BirdFontTextArea* t)
{
	g_return_if_fail (t != NULL);
	if (t->carret_is_visible) {
		BirdFontNativeWindow* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = bird_font_main_window_native_window;
		_tmp1_ = bird_font_native_window_get_clipboard_text (_tmp0_);
		_tmp2_ = _tmp1_;
		bird_font_text_area_insert_text (t, _tmp2_);
		_g_free0 (_tmp2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_clip_tool_copy (void)
{
	BirdFontFontDisplay* fd = NULL;
	BirdFontFontDisplay* _tmp0_;
	gchar* svg_data = NULL;
	gchar* bf_data = NULL;
	gchar* data = NULL;
	BirdFontFontDisplay* _tmp1_;
	_tmp0_ = bird_font_main_window_get_current_display ();
	fd = _tmp0_;
	_tmp1_ = fd;
	if (BIRD_FONT_IS_GLYPH_TAB (_tmp1_)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		BirdFontNativeWindow* _tmp7_;
		const gchar* _tmp8_;
		BirdFontNativeWindow* _tmp9_;
		const gchar* _tmp10_;
		_tmp2_ = bird_font_export_tool_export_selected_paths_to_svg ();
		_g_free0 (svg_data);
		svg_data = _tmp2_;
		_tmp3_ = bird_font_clip_tool_export_selected_paths_to_birdfont_clipboard ();
		_g_free0 (bf_data);
		bf_data = _tmp3_;
		_tmp4_ = svg_data;
		_tmp5_ = bf_data;
		_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
		_g_free0 (data);
		data = _tmp6_;
		_tmp7_ = bird_font_main_window_native_window;
		_tmp8_ = data;
		bird_font_native_window_set_clipboard (_tmp7_, _tmp8_);
		_tmp9_ = bird_font_main_window_native_window;
		_tmp10_ = data;
		bird_font_native_window_set_inkscape_clipboard (_tmp9_, _tmp10_);
	} else {
		BirdFontFontDisplay* _tmp11_;
		_tmp11_ = fd;
		if (BIRD_FONT_IS_OVERVIEW (_tmp11_)) {
			bird_font_clip_tool_copy_overview_glyphs ();
		} else {
			BirdFontFontDisplay* _tmp12_;
			_tmp12_ = fd;
			if (BIRD_FONT_IS_DESCRIPTION_DISPLAY (_tmp12_)) {
				BirdFontDescriptionDisplay* description_tab = NULL;
				BirdFontFontDisplay* _tmp13_;
				BirdFontDescriptionDisplay* _tmp14_;
				gchar* t = NULL;
				BirdFontDescriptionDisplay* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp13_ = fd;
				_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, BIRD_FONT_TYPE_DESCRIPTION_DISPLAY, BirdFontDescriptionDisplay));
				description_tab = _tmp14_;
				_tmp15_ = description_tab;
				_tmp16_ = bird_font_description_display_get_copy_selection (_tmp15_);
				t = _tmp16_;
				_tmp17_ = t;
				if (g_strcmp0 (_tmp17_, "") != 0) {
					BirdFontNativeWindow* _tmp18_;
					const gchar* _tmp19_;
					_tmp18_ = bird_font_main_window_native_window;
					_tmp19_ = t;
					bird_font_native_window_set_clipboard_text (_tmp18_, _tmp19_);
				}
				_g_free0 (t);
				_g_object_unref0 (description_tab);
			} else {
				BirdFontFontDisplay* _tmp20_;
				_tmp20_ = fd;
				if (BIRD_FONT_IS_EXPORT_SETTINGS (_tmp20_)) {
					BirdFontExportSettings* export_tab = NULL;
					BirdFontFontDisplay* _tmp21_;
					BirdFontExportSettings* _tmp22_;
					gchar* t = NULL;
					BirdFontExportSettings* _tmp23_;
					gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp21_ = fd;
					_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, BIRD_FONT_TYPE_EXPORT_SETTINGS, BirdFontExportSettings));
					export_tab = _tmp22_;
					_tmp23_ = export_tab;
					_tmp24_ = bird_font_export_settings_get_copy_selection (_tmp23_);
					t = _tmp24_;
					_tmp25_ = t;
					if (g_strcmp0 (_tmp25_, "") != 0) {
						BirdFontNativeWindow* _tmp26_;
						const gchar* _tmp27_;
						_tmp26_ = bird_font_main_window_native_window;
						_tmp27_ = t;
						bird_font_native_window_set_clipboard_text (_tmp26_, _tmp27_);
					}
					_g_free0 (t);
					_g_object_unref0 (export_tab);
				}
			}
		}
	}
	_g_free0 (data);
	_g_free0 (bf_data);
	_g_free0 (svg_data);
	_g_object_unref0 (fd);
}

/** Copy entire glyph. */
void
bird_font_clip_tool_copy_glyph (BirdFontGlyph* glyph)
{
	gchar* svg_data = NULL;
	gchar* bf_data = NULL;
	gchar* data = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	BirdFontNativeWindow* _tmp3_;
	BirdFontNativeWindow* _tmp4_;
	g_return_if_fail (glyph != NULL);
	_tmp0_ = bird_font_export_tool_export_to_inkscape_clipboard (glyph, FALSE);
	_g_free0 (svg_data);
	svg_data = _tmp0_;
	_tmp1_ = bird_font_clip_tool_export_paths_to_birdfont_clipboard (FALSE, FALSE);
	_g_free0 (bf_data);
	bf_data = _tmp1_;
	_tmp2_ = g_strconcat (svg_data, bf_data, NULL);
	_g_free0 (data);
	data = _tmp2_;
	_tmp3_ = bird_font_main_window_native_window;
	bird_font_native_window_set_clipboard (_tmp3_, data);
	_tmp4_ = bird_font_main_window_native_window;
	bird_font_native_window_set_inkscape_clipboard (_tmp4_, data);
	_g_free0 (data);
	_g_free0 (bf_data);
	_g_free0 (svg_data);
}

void
bird_font_clip_tool_copy_overview_glyphs (void)
{
	gchar* svg_data = NULL;
	gchar* _tmp0_;
	gchar* bf_data = NULL;
	gchar* _tmp1_;
	gchar* data = NULL;
	BirdFontOverview* o = NULL;
	BirdFontOverview* _tmp2_;
	BirdFontOverview* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	_tmp0_ = g_strdup ("");
	svg_data = _tmp0_;
	_tmp1_ = g_strdup ("");
	bf_data = _tmp1_;
	_tmp2_ = bird_font_main_window_get_overview ();
	o = _tmp2_;
	_tmp3_ = o;
	_tmp4_ = _tmp3_->selected_items;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		BirdFontOverview* _tmp7_;
		GeeArrayList* _tmp8_;
		gpointer _tmp9_;
		BirdFontGlyphCollection* _tmp10_;
		BirdFontGlyph* _tmp11_;
		BirdFontGlyph* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		BirdFontNativeWindow* _tmp18_;
		const gchar* _tmp19_;
		BirdFontNativeWindow* _tmp20_;
		const gchar* _tmp21_;
		_tmp7_ = o;
		_tmp8_ = _tmp7_->selected_items;
		_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, 0);
		_tmp10_ = (BirdFontGlyphCollection*) _tmp9_;
		_tmp11_ = bird_font_glyph_collection_get_current (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = bird_font_export_tool_export_to_inkscape_clipboard (_tmp12_, FALSE);
		_g_free0 (svg_data);
		svg_data = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp10_);
		_tmp14_ = bird_font_clip_tool_export_paths_to_birdfont_clipboard (TRUE, FALSE);
		_g_free0 (bf_data);
		bf_data = _tmp14_;
		_tmp15_ = svg_data;
		_tmp16_ = bf_data;
		_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
		_g_free0 (data);
		data = _tmp17_;
		_tmp18_ = bird_font_main_window_native_window;
		_tmp19_ = data;
		bird_font_native_window_set_clipboard (_tmp18_, _tmp19_);
		_tmp20_ = bird_font_main_window_native_window;
		_tmp21_ = data;
		bird_font_native_window_set_inkscape_clipboard (_tmp20_, _tmp21_);
	}
	_g_object_unref0 (o);
	_g_free0 (data);
	_g_free0 (bf_data);
	_g_free0 (svg_data);
}

void
bird_font_clip_tool_paste_in_place (void)
{
	bird_font_clip_tool_paste_paths (TRUE);
}

/** Paste at cursor. */
void
bird_font_clip_tool_paste (void)
{
	BirdFontFontDisplay* fd = NULL;
	BirdFontFontDisplay* _tmp0_;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp1_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	BirdFontFontDisplay* _tmp2_;
	_tmp0_ = bird_font_main_window_get_current_display ();
	fd = _tmp0_;
	_tmp1_ = bird_font_main_window_get_current_glyph ();
	g = _tmp1_;
	_tmp2_ = fd;
	if (BIRD_FONT_IS_GLYPH_TAB (_tmp2_)) {
		BirdFontGlyph* _tmp3_;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		BirdFontGlyph* _tmp8_;
		BirdFontGlyph* _tmp9_;
		bird_font_clip_tool_paste_paths (FALSE);
		_tmp3_ = g;
		bird_font_glyph_selection_boundaries (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
		x = _tmp4_;
		y = _tmp5_;
		w = _tmp6_;
		h = _tmp7_;
		_tmp8_ = g;
		dx = (_tmp8_->motion_x - x) - (w / 2.0);
		_tmp9_ = g;
		dy = (_tmp9_->motion_y - y) + (h / 2.0);
		{
			GeeArrayList* _path_list = NULL;
			BirdFontGlyph* _tmp10_;
			GeeArrayList* _tmp11_;
			gint _path_size = 0;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _path_index = 0;
			_tmp10_ = g;
			_tmp11_ = _tmp10_->active_paths;
			_path_list = _tmp11_;
			_tmp12_ = _path_list;
			_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_path_size = _tmp14_;
			_path_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				BirdFontPath* path = NULL;
				GeeArrayList* _tmp17_;
				gpointer _tmp18_;
				BirdFontPath* _tmp19_;
				_path_index = _path_index + 1;
				_tmp15_ = _path_index;
				_tmp16_ = _path_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _path_list;
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _path_index);
				path = (BirdFontPath*) _tmp18_;
				_tmp19_ = path;
				bird_font_path_move (_tmp19_, dx, dy);
				_g_object_unref0 (path);
			}
		}
	} else {
		BirdFontFontDisplay* _tmp20_;
		_tmp20_ = fd;
		if (BIRD_FONT_IS_SPACING_TAB (_tmp20_)) {
			bird_font_clip_tool_paste_letters_to_spacing_tab ();
		} else {
			BirdFontFontDisplay* _tmp21_;
			_tmp21_ = fd;
			if (BIRD_FONT_IS_KERNING_DISPLAY (_tmp21_)) {
				bird_font_clip_tool_paste_letters_to_kerning_tab ();
			} else {
				BirdFontFontDisplay* _tmp22_;
				_tmp22_ = fd;
				if (BIRD_FONT_IS_OVERVIEW (_tmp22_)) {
					bird_font_clip_tool_paste_to_overview ();
				} else {
					BirdFontFontDisplay* _tmp23_;
					_tmp23_ = fd;
					if (BIRD_FONT_IS_DESCRIPTION_DISPLAY (_tmp23_)) {
						BirdFontDescriptionDisplay* description_tab = NULL;
						BirdFontFontDisplay* _tmp24_;
						BirdFontDescriptionDisplay* _tmp25_;
						gchar* clipboard_data = NULL;
						BirdFontNativeWindow* _tmp26_;
						gchar* _tmp27_;
						const gchar* _tmp28_;
						_tmp24_ = fd;
						_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, BIRD_FONT_TYPE_DESCRIPTION_DISPLAY, BirdFontDescriptionDisplay));
						description_tab = _tmp25_;
						_tmp26_ = bird_font_main_window_native_window;
						_tmp27_ = bird_font_native_window_get_clipboard_data (_tmp26_);
						clipboard_data = _tmp27_;
						_tmp28_ = clipboard_data;
						if (!g_str_has_prefix (_tmp28_, "<?xml")) {
							BirdFontDescriptionDisplay* _tmp29_;
							const gchar* _tmp30_;
							_tmp29_ = description_tab;
							_tmp30_ = clipboard_data;
							bird_font_description_display_paste (_tmp29_, _tmp30_);
							bird_font_glyph_canvas_redraw ();
						}
						_g_free0 (clipboard_data);
						_g_object_unref0 (description_tab);
					} else {
						BirdFontFontDisplay* _tmp31_;
						_tmp31_ = fd;
						if (BIRD_FONT_IS_EXPORT_SETTINGS (_tmp31_)) {
							BirdFontExportSettings* export_tab = NULL;
							BirdFontFontDisplay* _tmp32_;
							BirdFontExportSettings* _tmp33_;
							gchar* clipboard_data = NULL;
							BirdFontNativeWindow* _tmp34_;
							gchar* _tmp35_;
							const gchar* _tmp36_;
							_tmp32_ = fd;
							_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, BIRD_FONT_TYPE_EXPORT_SETTINGS, BirdFontExportSettings));
							export_tab = _tmp33_;
							_tmp34_ = bird_font_main_window_native_window;
							_tmp35_ = bird_font_native_window_get_clipboard_data (_tmp34_);
							clipboard_data = _tmp35_;
							_tmp36_ = clipboard_data;
							if (!g_str_has_prefix (_tmp36_, "<?xml")) {
								BirdFontExportSettings* _tmp37_;
								const gchar* _tmp38_;
								_tmp37_ = export_tab;
								_tmp38_ = clipboard_data;
								bird_font_export_settings_paste (_tmp37_, _tmp38_);
								bird_font_glyph_canvas_redraw ();
							}
							_g_free0 (clipboard_data);
							_g_object_unref0 (export_tab);
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (g);
	_g_object_unref0 (fd);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
bird_font_clip_tool_paste_paths (gboolean paste_guide_lines)
{
	gboolean is_bf_clipboard = FALSE;
	BirdFontFontDisplay* fd = NULL;
	gchar* clipboard_data = NULL;
	BirdFontNativeWindow* _tmp0_;
	gchar* _tmp1_;
	BirdFontFontDisplay* _tmp2_;
	const gchar* _tmp3_;
	BirdFontFontDisplay* _tmp4_;
	BirdFontFont* _tmp5_;
	BirdFontFont* _tmp6_;
	_tmp0_ = bird_font_main_window_native_window;
	_tmp1_ = bird_font_native_window_get_clipboard_data (_tmp0_);
	clipboard_data = _tmp1_;
	_tmp2_ = bird_font_main_window_get_current_display ();
	_g_object_unref0 (fd);
	fd = _tmp2_;
	_tmp3_ = clipboard_data;
	is_bf_clipboard = string_index_of (_tmp3_, "BirdFontClipboard", 0) > -1;
	_tmp4_ = fd;
	if (BIRD_FONT_IS_GLYPH_TAB (_tmp4_)) {
		bird_font_clip_tool_paste_to_glyph (is_bf_clipboard, paste_guide_lines);
	}
	_tmp5_ = bird_font_bird_font_get_current_font ();
	_tmp6_ = _tmp5_;
	bird_font_font_touch (_tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_free0 (clipboard_data);
	_g_object_unref0 (fd);
}

static void
bird_font_clip_tool_paste_to_overview (void)
{
	gchar* data = NULL;
	BirdFontNativeWindow* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = bird_font_main_window_native_window;
	_tmp1_ = bird_font_native_window_get_clipboard_data (_tmp0_);
	data = _tmp1_;
	bird_font_clip_tool_import_birdfont_clipboard (data, TRUE, TRUE);
	bird_font_glyph_canvas_redraw ();
	_g_free0 (data);
}

static void
bird_font_clip_tool_paste_to_glyph (gboolean bf_clipboard_data,
                                    gboolean paste_guide_lines)
{
	BirdFontFontDisplay* fd = NULL;
	BirdFontFontDisplay* _tmp0_;
	BirdFontGlyph* destination = NULL;
	gchar* data = NULL;
	BirdFontFontDisplay* _tmp1_;
	BirdFontGlyphTab* glyph_tab = NULL;
	BirdFontFontDisplay* _tmp2_;
	BirdFontGlyphTab* _tmp3_;
	BirdFontGlyphTab* _tmp4_;
	BirdFontGlyphCollection* _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyph* _tmp7_;
	BirdFontGlyph* _tmp8_;
	BirdFontNativeWindow* _tmp9_;
	gchar* _tmp10_;
	BirdFontGlyph* _tmp14_;
	_tmp0_ = bird_font_main_window_get_current_display ();
	fd = _tmp0_;
	destination = NULL;
	_tmp1_ = fd;
	g_return_if_fail (BIRD_FONT_IS_GLYPH_TAB (_tmp1_));
	_tmp2_ = fd;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_TAB, BirdFontGlyphTab));
	glyph_tab = _tmp3_;
	_tmp4_ = glyph_tab;
	_tmp5_ = _tmp4_->glyphs;
	_tmp6_ = bird_font_glyph_collection_get_current (_tmp5_);
	_g_object_unref0 (destination);
	destination = _tmp6_;
	_tmp7_ = destination;
	bird_font_glyph_store_undo_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph), FALSE);
	_tmp8_ = destination;
	bird_font_glyph_clear_active_paths (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
	_tmp9_ = bird_font_main_window_native_window;
	_tmp10_ = bird_font_native_window_get_clipboard_data (_tmp9_);
	_g_free0 (data);
	data = _tmp10_;
	if (bf_clipboard_data) {
		const gchar* _tmp11_;
		_tmp11_ = data;
		bird_font_clip_tool_import_birdfont_clipboard (_tmp11_, paste_guide_lines, FALSE);
	} else {
		const gchar* _tmp12_;
		_tmp12_ = data;
		if (g_strcmp0 (_tmp12_, "") != 0) {
			const gchar* _tmp13_;
			_tmp13_ = data;
			bird_font_svg_parser_import_svg_data (_tmp13_, BIRD_FONT_SVG_FORMAT_INKSCAPE);
		}
	}
	_tmp14_ = destination;
	bird_font_glyph_update_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
	_g_object_unref0 (glyph_tab);
	_g_free0 (data);
	_g_object_unref0 (destination);
	_g_object_unref0 (fd);
}

static gchar*
bird_font_clip_tool_export_selected_paths_to_birdfont_clipboard (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = bird_font_clip_tool_export_paths_to_birdfont_clipboard (FALSE, TRUE);
	result = _tmp0_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gchar*
bird_font_clip_tool_export_paths_to_birdfont_clipboard (gboolean overview,
                                                        gboolean selected)
{
	GString* s = NULL;
	GString* _tmp0_;
	GeeArrayList* paths = NULL;
	GeeArrayList* _tmp1_;
	BirdFontPath* new_path = NULL;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyphCollection* glyph_collection = NULL;
	BirdFontOverview* o = NULL;
	GString* _tmp298_;
	const gchar* _tmp299_;
	gchar* _tmp300_;
	gchar* result;
	_tmp0_ = g_string_new ("");
	s = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	paths = _tmp1_;
	if (overview) {
		BirdFontOverview* _tmp2_;
		gunichar last_assigned = 0U;
		_tmp2_ = bird_font_main_window_get_overview ();
		_g_object_unref0 (o);
		o = _tmp2_;
		last_assigned = (gunichar) '\0';
		{
			GeeArrayList* _gc_list = NULL;
			BirdFontOverview* _tmp3_;
			GeeArrayList* _tmp4_;
			gint _gc_size = 0;
			GeeArrayList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _gc_index = 0;
			_tmp3_ = o;
			_tmp4_ = _tmp3_->selected_items;
			_gc_list = _tmp4_;
			_tmp5_ = _gc_list;
			_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_gc_size = _tmp7_;
			_gc_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				BirdFontGlyphCollection* gc = NULL;
				GeeArrayList* _tmp10_;
				gpointer _tmp11_;
				GString* _tmp12_;
				GString* _tmp13_;
				BirdFontGlyphCollection* _tmp14_;
				GString* _tmp30_;
				GString* _tmp31_;
				BirdFontGlyphCollection* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				GString* _tmp36_;
				GString* _tmp37_;
				GString* _tmp38_;
				BirdFontGlyphCollection* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				GString* _tmp42_;
				GString* _tmp43_;
				GString* _tmp44_;
				BirdFontGlyphCollection* _tmp45_;
				BirdFontGlyph* _tmp46_;
				BirdFontGlyph* _tmp47_;
				gdouble _tmp48_;
				gdouble _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				GString* _tmp52_;
				GString* _tmp53_;
				GString* _tmp54_;
				BirdFontGlyphCollection* _tmp55_;
				BirdFontGlyph* _tmp56_;
				BirdFontGlyph* _tmp57_;
				gdouble _tmp58_;
				gdouble _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				GString* _tmp62_;
				GString* _tmp93_;
				_gc_index = _gc_index + 1;
				_tmp8_ = _gc_index;
				_tmp9_ = _gc_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _gc_list;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _gc_index);
				gc = (BirdFontGlyphCollection*) _tmp11_;
				_tmp12_ = s;
				g_string_append (_tmp12_, "\n");
				_tmp13_ = s;
				g_string_append (_tmp13_, "<!-- BirdFontClipboard\n");
				_tmp14_ = gc;
				if (!bird_font_glyph_collection_is_unassigned (_tmp14_)) {
					BirdFontGlyphCollection* _tmp15_;
					GString* _tmp16_;
					GString* _tmp17_;
					BirdFontGlyphCollection* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					const gchar* _tmp21_;
					GString* _tmp22_;
					_tmp15_ = gc;
					last_assigned = bird_font_glyph_collection_get_unicode_character (_tmp15_);
					_tmp16_ = s;
					g_string_append (_tmp16_, "BF glyph: ");
					_tmp17_ = s;
					_tmp18_ = gc;
					_tmp19_ = bird_font_font_to_hex (bird_font_glyph_collection_get_unicode_character (_tmp18_));
					_tmp20_ = _tmp19_;
					_tmp21_ = string_to_string (_tmp20_);
					g_string_append (_tmp17_, _tmp21_);
					_g_free0 (_tmp20_);
					_tmp22_ = s;
					g_string_append (_tmp22_, "\n");
				} else {
					gunichar _tmp23_;
					GString* _tmp24_;
					GString* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					GString* _tmp29_;
					_tmp23_ = last_assigned;
					last_assigned = _tmp23_ + 1;
					_tmp24_ = s;
					g_string_append (_tmp24_, "BF glyph: ");
					_tmp25_ = s;
					_tmp26_ = bird_font_font_to_hex (last_assigned);
					_tmp27_ = _tmp26_;
					_tmp28_ = string_to_string (_tmp27_);
					g_string_append (_tmp25_, _tmp28_);
					_g_free0 (_tmp27_);
					_tmp29_ = s;
					g_string_append (_tmp29_, "\n");
				}
				_tmp30_ = s;
				g_string_append (_tmp30_, "BF name: ");
				_tmp31_ = s;
				_tmp32_ = gc;
				_tmp33_ = bird_font_glyph_collection_get_name (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = string_to_string (_tmp34_);
				g_string_append (_tmp31_, _tmp35_);
				_g_free0 (_tmp34_);
				_tmp36_ = s;
				g_string_append (_tmp36_, "\n");
				_tmp37_ = s;
				g_string_append (_tmp37_, "BF unassigned: ");
				_tmp38_ = s;
				_tmp39_ = gc;
				_tmp40_ = bool_to_string (bird_font_glyph_collection_is_unassigned (_tmp39_));
				_tmp41_ = _tmp40_;
				g_string_append (_tmp38_, _tmp41_);
				_g_free0 (_tmp41_);
				_tmp42_ = s;
				g_string_append (_tmp42_, "\n");
				_tmp43_ = s;
				g_string_append (_tmp43_, "BF left: ");
				_tmp44_ = s;
				_tmp45_ = gc;
				_tmp46_ = bird_font_glyph_collection_get_current (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = bird_font_glyph_get_left_limit (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = double_to_string (_tmp49_);
				_tmp51_ = _tmp50_;
				g_string_append (_tmp44_, _tmp51_);
				_g_free0 (_tmp51_);
				_g_object_unref0 (_tmp47_);
				_tmp52_ = s;
				g_string_append (_tmp52_, "\n");
				_tmp53_ = s;
				g_string_append (_tmp53_, "BF right: ");
				_tmp54_ = s;
				_tmp55_ = gc;
				_tmp56_ = bird_font_glyph_collection_get_current (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = bird_font_glyph_get_right_limit (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = double_to_string (_tmp59_);
				_tmp61_ = _tmp60_;
				g_string_append (_tmp54_, _tmp61_);
				_g_free0 (_tmp61_);
				_g_object_unref0 (_tmp57_);
				_tmp62_ = s;
				g_string_append (_tmp62_, "\n");
				{
					GeeArrayList* _path_list = NULL;
					BirdFontGlyphCollection* _tmp63_;
					BirdFontGlyph* _tmp64_;
					BirdFontGlyph* _tmp65_;
					GeeArrayList* _tmp66_;
					GeeArrayList* _tmp67_;
					gint _path_size = 0;
					GeeArrayList* _tmp68_;
					gint _tmp69_;
					gint _tmp70_;
					gint _path_index = 0;
					_tmp63_ = gc;
					_tmp64_ = bird_font_glyph_collection_get_current (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = bird_font_glyph_get_visible_paths (_tmp65_);
					_tmp67_ = _tmp66_;
					_g_object_unref0 (_tmp65_);
					_path_list = _tmp67_;
					_tmp68_ = _path_list;
					_tmp69_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp68_);
					_tmp70_ = _tmp69_;
					_path_size = _tmp70_;
					_path_index = -1;
					while (TRUE) {
						gint _tmp71_;
						gint _tmp72_;
						BirdFontPath* path = NULL;
						GeeArrayList* _tmp73_;
						gpointer _tmp74_;
						GString* _tmp75_;
						GString* _tmp76_;
						BirdFontPath* _tmp77_;
						gchar* _tmp78_;
						gchar* _tmp79_;
						GString* _tmp80_;
						GString* _tmp81_;
						GString* _tmp82_;
						BirdFontPath* _tmp83_;
						gdouble _tmp84_;
						gdouble _tmp85_;
						gchar* _tmp86_;
						gchar* _tmp87_;
						GString* _tmp88_;
						BirdFontPath* _tmp89_;
						_path_index = _path_index + 1;
						_tmp71_ = _path_index;
						_tmp72_ = _path_size;
						if (!(_tmp71_ < _tmp72_)) {
							break;
						}
						_tmp73_ = _path_list;
						_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp73_, _path_index);
						path = (BirdFontPath*) _tmp74_;
						_tmp75_ = s;
						g_string_append (_tmp75_, "BF path: ");
						_tmp76_ = s;
						_tmp77_ = path;
						_tmp78_ = bird_font_bird_font_file_get_point_data (_tmp77_);
						_tmp79_ = _tmp78_;
						g_string_append (_tmp76_, _tmp79_);
						_g_free0 (_tmp79_);
						_tmp80_ = s;
						g_string_append (_tmp80_, "\n");
						_tmp81_ = s;
						g_string_append (_tmp81_, "BF stroke: ");
						_tmp82_ = s;
						_tmp83_ = path;
						_tmp84_ = bird_font_path_get_stroke (_tmp83_);
						_tmp85_ = _tmp84_;
						_tmp86_ = double_to_string (_tmp85_);
						_tmp87_ = _tmp86_;
						g_string_append (_tmp82_, _tmp87_);
						_g_free0 (_tmp87_);
						_tmp88_ = s;
						g_string_append (_tmp88_, "\n");
						_tmp89_ = path;
						if (_tmp89_->line_cap == BIRD_FONT_LINE_CAP_ROUND) {
							GString* _tmp90_;
							_tmp90_ = s;
							g_string_append (_tmp90_, "BF cap: round\n");
						} else {
							BirdFontPath* _tmp91_;
							_tmp91_ = path;
							if (_tmp91_->line_cap == BIRD_FONT_LINE_CAP_SQUARE) {
								GString* _tmp92_;
								_tmp92_ = s;
								g_string_append (_tmp92_, "BF cap: square\n");
							}
						}
						_g_object_unref0 (path);
					}
					_g_object_unref0 (_path_list);
				}
				_tmp93_ = s;
				g_string_append (_tmp93_, "BF end -->");
				_g_object_unref0 (gc);
			}
		}
	} else {
		BirdFontGlyph* _tmp94_;
		BirdFontGlyphCollection* _tmp95_;
		GString* _tmp96_;
		GString* _tmp97_;
		GString* _tmp98_;
		GString* _tmp99_;
		BirdFontGlyph* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		const gchar* _tmp103_;
		GString* _tmp104_;
		GString* _tmp105_;
		GString* _tmp106_;
		BirdFontGlyphCollection* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		const gchar* _tmp110_;
		GString* _tmp111_;
		GString* _tmp112_;
		GString* _tmp113_;
		BirdFontGlyphCollection* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		GString* _tmp117_;
		GString* _tmp118_;
		GString* _tmp119_;
		BirdFontGlyph* _tmp120_;
		gdouble _tmp121_;
		gdouble _tmp122_;
		gchar* _tmp123_;
		gchar* _tmp124_;
		GString* _tmp125_;
		GString* _tmp126_;
		GString* _tmp127_;
		BirdFontGlyph* _tmp128_;
		gdouble _tmp129_;
		gdouble _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		GString* _tmp133_;
		GString* _tmp297_;
		_tmp94_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (glyph);
		glyph = _tmp94_;
		_tmp95_ = bird_font_main_window_get_current_glyph_collection ();
		_g_object_unref0 (glyph_collection);
		glyph_collection = _tmp95_;
		_tmp96_ = s;
		g_string_append (_tmp96_, "\n");
		_tmp97_ = s;
		g_string_append (_tmp97_, "<!-- BirdFontClipboard\n");
		_tmp98_ = s;
		g_string_append (_tmp98_, "BF glyph: ");
		_tmp99_ = s;
		_tmp100_ = glyph;
		_tmp101_ = bird_font_font_to_hex (_tmp100_->unichar_code);
		_tmp102_ = _tmp101_;
		_tmp103_ = string_to_string (_tmp102_);
		g_string_append (_tmp99_, _tmp103_);
		_g_free0 (_tmp102_);
		_tmp104_ = s;
		g_string_append (_tmp104_, "\n");
		_tmp105_ = s;
		g_string_append (_tmp105_, "BF name: ");
		_tmp106_ = s;
		_tmp107_ = glyph_collection;
		_tmp108_ = bird_font_glyph_collection_get_name (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = string_to_string (_tmp109_);
		g_string_append (_tmp106_, _tmp110_);
		_g_free0 (_tmp109_);
		_tmp111_ = s;
		g_string_append (_tmp111_, "\n");
		_tmp112_ = s;
		g_string_append (_tmp112_, "BF unassigned: ");
		_tmp113_ = s;
		_tmp114_ = glyph_collection;
		_tmp115_ = bool_to_string (bird_font_glyph_collection_is_unassigned (_tmp114_));
		_tmp116_ = _tmp115_;
		g_string_append (_tmp113_, _tmp116_);
		_g_free0 (_tmp116_);
		_tmp117_ = s;
		g_string_append (_tmp117_, "\n");
		_tmp118_ = s;
		g_string_append (_tmp118_, "BF left: ");
		_tmp119_ = s;
		_tmp120_ = glyph;
		_tmp121_ = bird_font_glyph_get_left_limit (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = double_to_string (_tmp122_);
		_tmp124_ = _tmp123_;
		g_string_append (_tmp119_, _tmp124_);
		_g_free0 (_tmp124_);
		_tmp125_ = s;
		g_string_append (_tmp125_, "\n");
		_tmp126_ = s;
		g_string_append (_tmp126_, "BF right: ");
		_tmp127_ = s;
		_tmp128_ = glyph;
		_tmp129_ = bird_font_glyph_get_right_limit (_tmp128_);
		_tmp130_ = _tmp129_;
		_tmp131_ = double_to_string (_tmp130_);
		_tmp132_ = _tmp131_;
		g_string_append (_tmp127_, _tmp132_);
		_g_free0 (_tmp132_);
		_tmp133_ = s;
		g_string_append (_tmp133_, "\n");
		if (!selected) {
			{
				GeeArrayList* _path_list = NULL;
				BirdFontGlyph* _tmp134_;
				GeeArrayList* _tmp135_;
				gint _path_size = 0;
				GeeArrayList* _tmp136_;
				gint _tmp137_;
				gint _tmp138_;
				gint _path_index = 0;
				_tmp134_ = glyph;
				_tmp135_ = bird_font_glyph_get_visible_paths (_tmp134_);
				_path_list = _tmp135_;
				_tmp136_ = _path_list;
				_tmp137_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp136_);
				_tmp138_ = _tmp137_;
				_path_size = _tmp138_;
				_path_index = -1;
				while (TRUE) {
					gint _tmp139_;
					gint _tmp140_;
					BirdFontPath* path = NULL;
					GeeArrayList* _tmp141_;
					gpointer _tmp142_;
					GString* _tmp143_;
					GString* _tmp144_;
					BirdFontPath* _tmp145_;
					gchar* _tmp146_;
					gchar* _tmp147_;
					GString* _tmp148_;
					GString* _tmp149_;
					GString* _tmp150_;
					BirdFontPath* _tmp151_;
					gdouble _tmp152_;
					gdouble _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					GString* _tmp156_;
					BirdFontPath* _tmp157_;
					_path_index = _path_index + 1;
					_tmp139_ = _path_index;
					_tmp140_ = _path_size;
					if (!(_tmp139_ < _tmp140_)) {
						break;
					}
					_tmp141_ = _path_list;
					_tmp142_ = gee_abstract_list_get ((GeeAbstractList*) _tmp141_, _path_index);
					path = (BirdFontPath*) _tmp142_;
					_tmp143_ = s;
					g_string_append (_tmp143_, "BF path: ");
					_tmp144_ = s;
					_tmp145_ = path;
					_tmp146_ = bird_font_bird_font_file_get_point_data (_tmp145_);
					_tmp147_ = _tmp146_;
					g_string_append (_tmp144_, _tmp147_);
					_g_free0 (_tmp147_);
					_tmp148_ = s;
					g_string_append (_tmp148_, "\n");
					_tmp149_ = s;
					g_string_append (_tmp149_, "BF stroke: ");
					_tmp150_ = s;
					_tmp151_ = path;
					_tmp152_ = bird_font_path_get_stroke (_tmp151_);
					_tmp153_ = _tmp152_;
					_tmp154_ = double_to_string (_tmp153_);
					_tmp155_ = _tmp154_;
					g_string_append (_tmp150_, _tmp155_);
					_g_free0 (_tmp155_);
					_tmp156_ = s;
					g_string_append (_tmp156_, "\n");
					_tmp157_ = path;
					if (_tmp157_->line_cap == BIRD_FONT_LINE_CAP_ROUND) {
						GString* _tmp158_;
						_tmp158_ = s;
						g_string_append (_tmp158_, "BF cap: round\n");
					} else {
						BirdFontPath* _tmp159_;
						_tmp159_ = path;
						if (_tmp159_->line_cap == BIRD_FONT_LINE_CAP_SQUARE) {
							GString* _tmp160_;
							_tmp160_ = s;
							g_string_append (_tmp160_, "BF cap: square\n");
						}
					}
					_g_object_unref0 (path);
				}
				_g_object_unref0 (_path_list);
			}
		} else {
			BirdFontGlyph* _tmp161_;
			GeeArrayList* _tmp162_;
			GeeArrayList* _tmp163_;
			gint _tmp164_;
			gint _tmp165_;
			gboolean _tmp166_;
			_tmp161_ = glyph;
			_tmp162_ = bird_font_glyph_get_visible_paths (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp163_);
			_tmp165_ = _tmp164_;
			_tmp166_ = _tmp165_ > 0;
			_g_object_unref0 (_tmp163_);
			if (_tmp166_) {
				{
					GeeArrayList* _path_list = NULL;
					BirdFontGlyph* _tmp167_;
					GeeArrayList* _tmp168_;
					gint _path_size = 0;
					GeeArrayList* _tmp169_;
					gint _tmp170_;
					gint _tmp171_;
					gint _path_index = 0;
					_tmp167_ = glyph;
					_tmp168_ = _tmp167_->active_paths;
					_path_list = _tmp168_;
					_tmp169_ = _path_list;
					_tmp170_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp169_);
					_tmp171_ = _tmp170_;
					_path_size = _tmp171_;
					_path_index = -1;
					while (TRUE) {
						gint _tmp172_;
						gint _tmp173_;
						BirdFontPath* path = NULL;
						GeeArrayList* _tmp174_;
						gpointer _tmp175_;
						GString* _tmp176_;
						GString* _tmp177_;
						BirdFontPath* _tmp178_;
						gchar* _tmp179_;
						gchar* _tmp180_;
						GString* _tmp181_;
						GString* _tmp182_;
						GString* _tmp183_;
						BirdFontPath* _tmp184_;
						gdouble _tmp185_;
						gdouble _tmp186_;
						gchar* _tmp187_;
						gchar* _tmp188_;
						GString* _tmp189_;
						BirdFontPath* _tmp190_;
						_path_index = _path_index + 1;
						_tmp172_ = _path_index;
						_tmp173_ = _path_size;
						if (!(_tmp172_ < _tmp173_)) {
							break;
						}
						_tmp174_ = _path_list;
						_tmp175_ = gee_abstract_list_get ((GeeAbstractList*) _tmp174_, _path_index);
						path = (BirdFontPath*) _tmp175_;
						_tmp176_ = s;
						g_string_append (_tmp176_, "BF path: ");
						_tmp177_ = s;
						_tmp178_ = path;
						_tmp179_ = bird_font_bird_font_file_get_point_data (_tmp178_);
						_tmp180_ = _tmp179_;
						g_string_append (_tmp177_, _tmp180_);
						_g_free0 (_tmp180_);
						_tmp181_ = s;
						g_string_append (_tmp181_, "\n");
						_tmp182_ = s;
						g_string_append (_tmp182_, "BF stroke: ");
						_tmp183_ = s;
						_tmp184_ = path;
						_tmp185_ = bird_font_path_get_stroke (_tmp184_);
						_tmp186_ = _tmp185_;
						_tmp187_ = double_to_string (_tmp186_);
						_tmp188_ = _tmp187_;
						g_string_append (_tmp183_, _tmp188_);
						_g_free0 (_tmp188_);
						_tmp189_ = s;
						g_string_append (_tmp189_, "\n");
						_tmp190_ = path;
						if (_tmp190_->line_cap == BIRD_FONT_LINE_CAP_ROUND) {
							GString* _tmp191_;
							_tmp191_ = s;
							g_string_append (_tmp191_, "BF cap: round\n");
						} else {
							BirdFontPath* _tmp192_;
							_tmp192_ = path;
							if (_tmp192_->line_cap == BIRD_FONT_LINE_CAP_SQUARE) {
								GString* _tmp193_;
								_tmp193_ = s;
								g_string_append (_tmp193_, "BF cap: square\n");
							}
						}
						_g_object_unref0 (path);
					}
				}
			} else {
				BirdFontPath* _tmp194_;
				GeeArrayList* _tmp264_;
				BirdFontPath* _tmp265_;
				_tmp194_ = bird_font_path_new ();
				_g_object_unref0 (new_path);
				new_path = _tmp194_;
				{
					GeeArrayList* _path_list = NULL;
					BirdFontGlyph* _tmp195_;
					GeeArrayList* _tmp196_;
					gint _path_size = 0;
					GeeArrayList* _tmp197_;
					gint _tmp198_;
					gint _tmp199_;
					gint _path_index = 0;
					_tmp195_ = glyph;
					_tmp196_ = bird_font_glyph_get_visible_paths (_tmp195_);
					_path_list = _tmp196_;
					_tmp197_ = _path_list;
					_tmp198_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp197_);
					_tmp199_ = _tmp198_;
					_path_size = _tmp199_;
					_path_index = -1;
					while (TRUE) {
						gint _tmp200_;
						gint _tmp201_;
						BirdFontPath* path = NULL;
						GeeArrayList* _tmp202_;
						gpointer _tmp203_;
						gboolean _tmp204_ = FALSE;
						gboolean _tmp205_ = FALSE;
						BirdFontPath* _tmp206_;
						GeeArrayList* _tmp207_;
						GeeArrayList* _tmp208_;
						gint _tmp209_;
						gint _tmp210_;
						BirdFontPath* _tmp262_;
						_path_index = _path_index + 1;
						_tmp200_ = _path_index;
						_tmp201_ = _path_size;
						if (!(_tmp200_ < _tmp201_)) {
							break;
						}
						_tmp202_ = _path_list;
						_tmp203_ = gee_abstract_list_get ((GeeAbstractList*) _tmp202_, _path_index);
						path = (BirdFontPath*) _tmp203_;
						_tmp206_ = path;
						_tmp207_ = bird_font_path_get_points (_tmp206_);
						_tmp208_ = _tmp207_;
						_tmp209_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp208_);
						_tmp210_ = _tmp209_;
						if (_tmp210_ > 0) {
							BirdFontPath* _tmp211_;
							GeeArrayList* _tmp212_;
							GeeArrayList* _tmp213_;
							gpointer _tmp214_;
							BirdFontEditPoint* _tmp215_;
							_tmp211_ = path;
							_tmp212_ = bird_font_path_get_points (_tmp211_);
							_tmp213_ = _tmp212_;
							_tmp214_ = gee_abstract_list_get ((GeeAbstractList*) _tmp213_, 0);
							_tmp215_ = (BirdFontEditPoint*) _tmp214_;
							_tmp205_ = bird_font_edit_point_is_selected (_tmp215_);
							_g_object_unref0 (_tmp215_);
						} else {
							_tmp205_ = FALSE;
						}
						if (_tmp205_) {
							BirdFontPath* _tmp216_;
							GeeArrayList* _tmp217_;
							GeeArrayList* _tmp218_;
							BirdFontPath* _tmp219_;
							GeeArrayList* _tmp220_;
							GeeArrayList* _tmp221_;
							gint _tmp222_;
							gint _tmp223_;
							gpointer _tmp224_;
							BirdFontEditPoint* _tmp225_;
							_tmp216_ = path;
							_tmp217_ = bird_font_path_get_points (_tmp216_);
							_tmp218_ = _tmp217_;
							_tmp219_ = path;
							_tmp220_ = bird_font_path_get_points (_tmp219_);
							_tmp221_ = _tmp220_;
							_tmp222_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp221_);
							_tmp223_ = _tmp222_;
							_tmp224_ = gee_abstract_list_get ((GeeAbstractList*) _tmp218_, _tmp223_ - 1);
							_tmp225_ = (BirdFontEditPoint*) _tmp224_;
							_tmp204_ = bird_font_edit_point_is_selected (_tmp225_);
							_g_object_unref0 (_tmp225_);
						} else {
							_tmp204_ = FALSE;
						}
						if (_tmp204_) {
							{
								GeeArrayList* _ep_list = NULL;
								BirdFontPath* _tmp226_;
								GeeArrayList* _tmp227_;
								GeeArrayList* _tmp228_;
								gint _ep_size = 0;
								GeeArrayList* _tmp229_;
								gint _tmp230_;
								gint _tmp231_;
								gint _ep_index = 0;
								_tmp226_ = path;
								_tmp227_ = bird_font_path_get_points (_tmp226_);
								_tmp228_ = _tmp227_;
								_ep_list = _tmp228_;
								_tmp229_ = _ep_list;
								_tmp230_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp229_);
								_tmp231_ = _tmp230_;
								_ep_size = _tmp231_;
								_ep_index = -1;
								while (TRUE) {
									gint _tmp232_;
									gint _tmp233_;
									BirdFontEditPoint* ep = NULL;
									GeeArrayList* _tmp234_;
									gpointer _tmp235_;
									BirdFontEditPoint* _tmp236_;
									_ep_index = _ep_index + 1;
									_tmp232_ = _ep_index;
									_tmp233_ = _ep_size;
									if (!(_tmp232_ < _tmp233_)) {
										break;
									}
									_tmp234_ = _ep_list;
									_tmp235_ = gee_abstract_list_get ((GeeAbstractList*) _tmp234_, _ep_index);
									ep = (BirdFontEditPoint*) _tmp235_;
									_tmp236_ = ep;
									if (!bird_font_edit_point_is_selected (_tmp236_)) {
										BirdFontPath* _tmp237_;
										BirdFontEditPoint* _tmp238_;
										_tmp237_ = path;
										_tmp238_ = ep;
										bird_font_path_set_new_start (_tmp237_, _tmp238_);
										_g_object_unref0 (ep);
										break;
									}
									_g_object_unref0 (ep);
								}
							}
						}
						{
							GeeArrayList* _ep_list = NULL;
							BirdFontPath* _tmp239_;
							GeeArrayList* _tmp240_;
							GeeArrayList* _tmp241_;
							gint _ep_size = 0;
							GeeArrayList* _tmp242_;
							gint _tmp243_;
							gint _tmp244_;
							gint _ep_index = 0;
							_tmp239_ = path;
							_tmp240_ = bird_font_path_get_points (_tmp239_);
							_tmp241_ = _tmp240_;
							_ep_list = _tmp241_;
							_tmp242_ = _ep_list;
							_tmp243_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp242_);
							_tmp244_ = _tmp243_;
							_ep_size = _tmp244_;
							_ep_index = -1;
							while (TRUE) {
								gint _tmp245_;
								gint _tmp246_;
								BirdFontEditPoint* ep = NULL;
								GeeArrayList* _tmp247_;
								gpointer _tmp248_;
								BirdFontEditPoint* _tmp249_;
								_ep_index = _ep_index + 1;
								_tmp245_ = _ep_index;
								_tmp246_ = _ep_size;
								if (!(_tmp245_ < _tmp246_)) {
									break;
								}
								_tmp247_ = _ep_list;
								_tmp248_ = gee_abstract_list_get ((GeeAbstractList*) _tmp247_, _ep_index);
								ep = (BirdFontEditPoint*) _tmp248_;
								_tmp249_ = ep;
								if (!bird_font_edit_point_is_selected (_tmp249_)) {
									BirdFontPath* _tmp250_;
									GeeArrayList* _tmp251_;
									GeeArrayList* _tmp252_;
									gint _tmp253_;
									gint _tmp254_;
									_tmp250_ = path;
									_tmp251_ = bird_font_path_get_points (_tmp250_);
									_tmp252_ = _tmp251_;
									_tmp253_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp252_);
									_tmp254_ = _tmp253_;
									if (_tmp254_ > 0) {
										GeeArrayList* _tmp255_;
										BirdFontPath* _tmp256_;
										BirdFontPath* _tmp257_;
										_tmp255_ = paths;
										_tmp256_ = new_path;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp255_, _tmp256_);
										_tmp257_ = bird_font_path_new ();
										_g_object_unref0 (new_path);
										new_path = _tmp257_;
									}
								} else {
									BirdFontPath* _tmp258_;
									BirdFontEditPoint* _tmp259_;
									BirdFontEditPoint* _tmp260_;
									BirdFontEditPoint* _tmp261_;
									_tmp258_ = new_path;
									_tmp259_ = ep;
									_tmp260_ = bird_font_path_add_point (_tmp258_, _tmp259_);
									_tmp261_ = _tmp260_;
									_g_object_unref0 (_tmp261_);
								}
								_g_object_unref0 (ep);
							}
						}
						_tmp262_ = path;
						if (bird_font_clip_tool_all_points_selected (_tmp262_)) {
							BirdFontPath* _tmp263_;
							_tmp263_ = new_path;
							bird_font_path_close (_tmp263_);
						}
						_g_object_unref0 (path);
					}
					_g_object_unref0 (_path_list);
				}
				_tmp264_ = paths;
				_tmp265_ = new_path;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp264_, _tmp265_);
				{
					GeeArrayList* _path_list = NULL;
					GeeArrayList* _tmp266_;
					gint _path_size = 0;
					GeeArrayList* _tmp267_;
					gint _tmp268_;
					gint _tmp269_;
					gint _path_index = 0;
					_tmp266_ = paths;
					_path_list = _tmp266_;
					_tmp267_ = _path_list;
					_tmp268_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp267_);
					_tmp269_ = _tmp268_;
					_path_size = _tmp269_;
					_path_index = -1;
					while (TRUE) {
						gint _tmp270_;
						gint _tmp271_;
						BirdFontPath* path = NULL;
						GeeArrayList* _tmp272_;
						gpointer _tmp273_;
						BirdFontPath* _tmp274_;
						GeeArrayList* _tmp275_;
						GeeArrayList* _tmp276_;
						gint _tmp277_;
						gint _tmp278_;
						_path_index = _path_index + 1;
						_tmp270_ = _path_index;
						_tmp271_ = _path_size;
						if (!(_tmp270_ < _tmp271_)) {
							break;
						}
						_tmp272_ = _path_list;
						_tmp273_ = gee_abstract_list_get ((GeeAbstractList*) _tmp272_, _path_index);
						path = (BirdFontPath*) _tmp273_;
						_tmp274_ = path;
						_tmp275_ = bird_font_path_get_points (_tmp274_);
						_tmp276_ = _tmp275_;
						_tmp277_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp276_);
						_tmp278_ = _tmp277_;
						if (_tmp278_ > 0) {
							GString* _tmp279_;
							GString* _tmp280_;
							BirdFontPath* _tmp281_;
							gchar* _tmp282_;
							gchar* _tmp283_;
							GString* _tmp284_;
							GString* _tmp285_;
							GString* _tmp286_;
							BirdFontPath* _tmp287_;
							gdouble _tmp288_;
							gdouble _tmp289_;
							gchar* _tmp290_;
							gchar* _tmp291_;
							GString* _tmp292_;
							BirdFontPath* _tmp293_;
							_tmp279_ = s;
							g_string_append (_tmp279_, "BF path: ");
							_tmp280_ = s;
							_tmp281_ = path;
							_tmp282_ = bird_font_bird_font_file_get_point_data (_tmp281_);
							_tmp283_ = _tmp282_;
							g_string_append (_tmp280_, _tmp283_);
							_g_free0 (_tmp283_);
							_tmp284_ = s;
							g_string_append (_tmp284_, "\n");
							_tmp285_ = s;
							g_string_append (_tmp285_, "BF stroke: ");
							_tmp286_ = s;
							_tmp287_ = path;
							_tmp288_ = bird_font_path_get_stroke (_tmp287_);
							_tmp289_ = _tmp288_;
							_tmp290_ = double_to_string (_tmp289_);
							_tmp291_ = _tmp290_;
							g_string_append (_tmp286_, _tmp291_);
							_g_free0 (_tmp291_);
							_tmp292_ = s;
							g_string_append (_tmp292_, "\n");
							_tmp293_ = path;
							if (_tmp293_->line_cap == BIRD_FONT_LINE_CAP_ROUND) {
								GString* _tmp294_;
								_tmp294_ = s;
								g_string_append (_tmp294_, "BF cap: round\n");
							} else {
								BirdFontPath* _tmp295_;
								_tmp295_ = path;
								if (_tmp295_->line_cap == BIRD_FONT_LINE_CAP_SQUARE) {
									GString* _tmp296_;
									_tmp296_ = s;
									g_string_append (_tmp296_, "BF cap: square\n");
								}
							}
						}
						_g_object_unref0 (path);
					}
				}
			}
		}
		_tmp297_ = s;
		g_string_append (_tmp297_, "BF end -->");
	}
	_tmp298_ = s;
	_tmp299_ = _tmp298_->str;
	_tmp300_ = g_strdup (_tmp299_);
	result = _tmp300_;
	_g_object_unref0 (o);
	_g_object_unref0 (glyph_collection);
	_g_object_unref0 (glyph);
	_g_object_unref0 (new_path);
	_g_object_unref0 (paths);
	_g_string_free0 (s);
	return result;
}

static gboolean
bird_font_clip_tool_all_points_selected (BirdFontPath* p)
{
	gboolean result;
	g_return_val_if_fail (p != NULL, FALSE);
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _ep_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ep_index = 0;
		_tmp0_ = bird_font_path_get_points (p);
		_tmp1_ = _tmp0_;
		_ep_list = _tmp1_;
		_tmp2_ = _ep_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ep_size = _tmp4_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			_ep_index = _ep_index + 1;
			_tmp5_ = _ep_index;
			_tmp6_ = _ep_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ep_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = ep;
			if (!bird_font_edit_point_is_selected (_tmp9_)) {
				result = FALSE;
				_g_object_unref0 (ep);
				return result;
			}
			_g_object_unref0 (ep);
		}
	}
	result = TRUE;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
bird_font_clip_tool_import_birdfont_clipboard (const gchar* data,
                                               gboolean paste_guide_lines,
                                               gboolean overview)
{
	GeeArrayList* glyphs = NULL;
	GeeArrayList* _tmp0_;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp1_;
	gchar** items = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint items_length1;
	gint _items_size_;
	gunichar c = 0U;
	BirdFontGlyph* destination = NULL;
	BirdFontGlyphCollection* glyph_collection = NULL;
	BirdFontGlyphCollection* _tmp4_;
	BirdFontOverview* o = NULL;
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (data != NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	glyphs = _tmp0_;
	_tmp1_ = bird_font_glyph_new ("null", (gunichar) '\0');
	glyph = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (data, "\nBF ", 0);
	items = _tmp3_;
	items_length1 = _vala_array_length (_tmp2_);
	_items_size_ = items_length1;
	_tmp4_ = bird_font_glyph_collection_new ((gunichar) '\0', "");
	glyph_collection = _tmp4_;
	_tmp5_ = bird_font_path_new ();
	path = _tmp5_;
	_tmp6_ = items;
	_tmp6__length1 = items_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp6_;
		p_collection_length1 = _tmp6__length1;
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			gchar* _tmp7_;
			gchar* p = NULL;
			_tmp7_ = g_strdup (p_collection[p_it]);
			p = _tmp7_;
			{
				const gchar* _tmp8_;
				const gchar* _tmp27_;
				const gchar* _tmp34_;
				const gchar* _tmp44_;
				const gchar* _tmp52_;
				const gchar* _tmp59_;
				const gchar* _tmp66_;
				const gchar* _tmp71_;
				_tmp8_ = p;
				if (g_str_has_prefix (_tmp8_, "glyph:")) {
					const gchar* _tmp9_;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					BirdFontGlyphCollection* _tmp16_;
					GeeArrayList* _tmp17_;
					BirdFontGlyphCollection* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					BirdFontGlyph* _tmp21_;
					BirdFontGlyphMaster* master = NULL;
					BirdFontGlyphMaster* _tmp22_;
					BirdFontGlyphMaster* _tmp23_;
					BirdFontGlyph* _tmp24_;
					BirdFontGlyphCollection* _tmp25_;
					BirdFontGlyphMaster* _tmp26_;
					_tmp9_ = p;
					_tmp10_ = string_replace (_tmp9_, "glyph: ", "");
					_g_free0 (p);
					p = _tmp10_;
					_tmp11_ = p;
					_tmp12_ = string_replace (_tmp11_, "\n", "");
					_g_free0 (p);
					p = _tmp12_;
					_tmp13_ = p;
					c = bird_font_font_to_unichar (_tmp13_);
					_tmp14_ = g_unichar_to_string (c);
					_tmp15_ = (gchar*) _tmp14_;
					_tmp16_ = bird_font_glyph_collection_new (c, _tmp15_);
					_g_object_unref0 (glyph_collection);
					glyph_collection = _tmp16_;
					_g_free0 (_tmp15_);
					_tmp17_ = glyphs;
					_tmp18_ = glyph_collection;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
					_tmp19_ = g_unichar_to_string (c);
					_tmp20_ = (gchar*) _tmp19_;
					_tmp21_ = bird_font_glyph_new (_tmp20_, c);
					_g_object_unref0 (glyph);
					glyph = _tmp21_;
					_g_free0 (_tmp20_);
					_tmp22_ = bird_font_glyph_master_new ();
					master = _tmp22_;
					_tmp23_ = master;
					_tmp24_ = glyph;
					bird_font_glyph_master_add_glyph (_tmp23_, _tmp24_);
					_tmp25_ = glyph_collection;
					_tmp26_ = master;
					bird_font_glyph_collection_add_master (_tmp25_, _tmp26_);
					_g_object_unref0 (master);
				}
				_tmp27_ = p;
				if (g_str_has_prefix (_tmp27_, "unassigned:")) {
					const gchar* _tmp28_;
					gchar* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					BirdFontGlyphCollection* _tmp32_;
					const gchar* _tmp33_;
					_tmp28_ = p;
					_tmp29_ = string_replace (_tmp28_, "unassigned: ", "");
					_g_free0 (p);
					p = _tmp29_;
					_tmp30_ = p;
					_tmp31_ = string_replace (_tmp30_, "\n", "");
					_g_free0 (p);
					p = _tmp31_;
					_tmp32_ = glyph_collection;
					_tmp33_ = p;
					bird_font_glyph_collection_set_unassigned (_tmp32_, bool_parse (_tmp33_));
				}
				_tmp34_ = p;
				if (g_str_has_prefix (_tmp34_, "name:")) {
					const gchar* _tmp35_;
					gchar* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					BirdFontGlyphCollection* _tmp39_;
					const gchar* _tmp40_;
					BirdFontGlyph* _tmp41_;
					const gchar* _tmp42_;
					gchar* _tmp43_;
					_tmp35_ = p;
					_tmp36_ = string_replace (_tmp35_, "name: ", "");
					_g_free0 (p);
					p = _tmp36_;
					_tmp37_ = p;
					_tmp38_ = string_replace (_tmp37_, "\n", "");
					_g_free0 (p);
					p = _tmp38_;
					_tmp39_ = glyph_collection;
					_tmp40_ = p;
					bird_font_glyph_collection_set_name (_tmp39_, _tmp40_);
					_tmp41_ = glyph;
					_tmp42_ = p;
					_tmp43_ = g_strdup (_tmp42_);
					_g_free0 (_tmp41_->name);
					_tmp41_->name = _tmp43_;
				}
				_tmp44_ = p;
				if (g_str_has_prefix (_tmp44_, "path:")) {
					const gchar* _tmp45_;
					gchar* _tmp46_;
					const gchar* _tmp47_;
					gchar* _tmp48_;
					BirdFontGlyph* _tmp49_;
					const gchar* _tmp50_;
					BirdFontPath* _tmp51_;
					_tmp45_ = p;
					_tmp46_ = string_replace (_tmp45_, "path: ", "");
					_g_free0 (p);
					p = _tmp46_;
					_tmp47_ = p;
					_tmp48_ = string_replace (_tmp47_, "\n", "");
					_g_free0 (p);
					p = _tmp48_;
					_tmp49_ = glyph;
					_tmp50_ = p;
					_tmp51_ = bird_font_clip_tool_import_birdfont_path (_tmp49_, _tmp50_);
					_g_object_unref0 (path);
					path = _tmp51_;
				}
				_tmp52_ = p;
				if (g_str_has_prefix (_tmp52_, "left:")) {
					BirdFontGlyph* _tmp53_;
					const gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					BirdFontGlyph* _tmp57_;
					BirdFontGlyph* _tmp58_;
					_tmp53_ = glyph;
					_tmp54_ = p;
					_tmp55_ = string_replace (_tmp54_, "left: ", "");
					_tmp56_ = _tmp55_;
					bird_font_glyph_set_left_limit (_tmp53_, double_parse (_tmp56_));
					_g_free0 (_tmp56_);
					_tmp57_ = glyph;
					bird_font_glyph_remove_lines (_tmp57_);
					_tmp58_ = glyph;
					bird_font_glyph_add_help_lines (_tmp58_);
				}
				_tmp59_ = p;
				if (g_str_has_prefix (_tmp59_, "right:")) {
					BirdFontGlyph* _tmp60_;
					const gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					BirdFontGlyph* _tmp64_;
					BirdFontGlyph* _tmp65_;
					_tmp60_ = glyph;
					_tmp61_ = p;
					_tmp62_ = string_replace (_tmp61_, "right: ", "");
					_tmp63_ = _tmp62_;
					bird_font_glyph_set_right_limit (_tmp60_, double_parse (_tmp63_));
					_g_free0 (_tmp63_);
					_tmp64_ = glyph;
					bird_font_glyph_remove_lines (_tmp64_);
					_tmp65_ = glyph;
					bird_font_glyph_add_help_lines (_tmp65_);
				}
				_tmp66_ = p;
				if (g_str_has_prefix (_tmp66_, "stroke:")) {
					BirdFontPath* _tmp67_;
					const gchar* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					_tmp67_ = path;
					_tmp68_ = p;
					_tmp69_ = string_replace (_tmp68_, "stroke: ", "");
					_tmp70_ = _tmp69_;
					bird_font_path_set_stroke (_tmp67_, double_parse (_tmp70_));
					_g_free0 (_tmp70_);
				}
				_tmp71_ = p;
				if (g_str_has_prefix (_tmp71_, "cap:")) {
					gchar* cap = NULL;
					const gchar* _tmp72_;
					gchar* _tmp73_;
					const gchar* _tmp74_;
					_tmp72_ = p;
					_tmp73_ = string_replace (_tmp72_, "cap: ", "");
					cap = _tmp73_;
					_tmp74_ = cap;
					if (g_strcmp0 (_tmp74_, "round") == 0) {
						BirdFontPath* _tmp75_;
						_tmp75_ = path;
						_tmp75_->line_cap = BIRD_FONT_LINE_CAP_ROUND;
					} else {
						const gchar* _tmp76_;
						_tmp76_ = cap;
						if (g_strcmp0 (_tmp76_, "square") == 0) {
							BirdFontPath* _tmp77_;
							_tmp77_ = path;
							_tmp77_->line_cap = BIRD_FONT_LINE_CAP_SQUARE;
						}
					}
					_g_free0 (cap);
				}
				_g_free0 (p);
			}
		}
	}
	if (!overview) {
		GeeArrayList* _tmp78_;
		gint _tmp79_;
		gint _tmp80_;
		BirdFontGlyph* _tmp81_;
		GeeArrayList* _tmp82_;
		gpointer _tmp83_;
		BirdFontGlyphCollection* _tmp84_;
		BirdFontGlyph* _tmp85_;
		_tmp78_ = glyphs;
		_tmp79_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp78_);
		_tmp80_ = _tmp79_;
		g_return_if_fail (_tmp80_ > 0);
		_tmp81_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (destination);
		destination = _tmp81_;
		_tmp82_ = glyphs;
		_tmp83_ = gee_abstract_list_get ((GeeAbstractList*) _tmp82_, 0);
		_tmp84_ = (BirdFontGlyphCollection*) _tmp83_;
		_tmp85_ = bird_font_glyph_collection_get_current (_tmp84_);
		_g_object_unref0 (glyph);
		glyph = _tmp85_;
		_g_object_unref0 (_tmp84_);
		{
			GeeArrayList* _p_list = NULL;
			BirdFontGlyph* _tmp86_;
			GeeArrayList* _tmp87_;
			gint _p_size = 0;
			GeeArrayList* _tmp88_;
			gint _tmp89_;
			gint _tmp90_;
			gint _p_index = 0;
			_tmp86_ = glyph;
			_tmp87_ = bird_font_glyph_get_visible_paths (_tmp86_);
			_p_list = _tmp87_;
			_tmp88_ = _p_list;
			_tmp89_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp88_);
			_tmp90_ = _tmp89_;
			_p_size = _tmp90_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp91_;
				gint _tmp92_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp93_;
				gpointer _tmp94_;
				BirdFontGlyph* _tmp95_;
				BirdFontPath* _tmp96_;
				BirdFontGlyph* _tmp97_;
				BirdFontPath* _tmp98_;
				_p_index = _p_index + 1;
				_tmp91_ = _p_index;
				_tmp92_ = _p_size;
				if (!(_tmp91_ < _tmp92_)) {
					break;
				}
				_tmp93_ = _p_list;
				_tmp94_ = gee_abstract_list_get ((GeeAbstractList*) _tmp93_, _p_index);
				p = (BirdFontPath*) _tmp94_;
				bird_font_pen_tool_clear_directions ();
				_tmp95_ = destination;
				_tmp96_ = p;
				bird_font_glyph_add_path (_tmp95_, _tmp96_);
				_tmp97_ = destination;
				_tmp98_ = p;
				bird_font_glyph_add_active_path (_tmp97_, NULL, _tmp98_);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_list);
		}
		if (paste_guide_lines) {
			BirdFontGlyph* _tmp99_;
			BirdFontGlyph* _tmp100_;
			gdouble _tmp101_;
			gdouble _tmp102_;
			BirdFontGlyph* _tmp103_;
			BirdFontGlyph* _tmp104_;
			gdouble _tmp105_;
			gdouble _tmp106_;
			BirdFontGlyph* _tmp107_;
			BirdFontGlyph* _tmp108_;
			_tmp99_ = destination;
			_tmp100_ = glyph;
			_tmp101_ = bird_font_glyph_get_left_limit (_tmp100_);
			_tmp102_ = _tmp101_;
			bird_font_glyph_set_left_limit (_tmp99_, _tmp102_);
			_tmp103_ = destination;
			_tmp104_ = glyph;
			_tmp105_ = bird_font_glyph_get_right_limit (_tmp104_);
			_tmp106_ = _tmp105_;
			bird_font_glyph_set_right_limit (_tmp103_, _tmp106_);
			_tmp107_ = destination;
			bird_font_glyph_add_help_lines (_tmp107_);
			_tmp108_ = destination;
			bird_font_glyph_update_other_spacing_classes (_tmp108_);
		}
	} else {
		BirdFontOverview* _tmp109_;
		BirdFontOverview* _tmp110_;
		GeeArrayList* _tmp111_;
		BirdFontOverview* _tmp123_;
		_tmp109_ = bird_font_main_window_get_overview ();
		_g_object_unref0 (o);
		o = _tmp109_;
		_tmp110_ = o;
		_tmp111_ = _tmp110_->copied_glyphs;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp111_);
		{
			GeeArrayList* _gc_list = NULL;
			GeeArrayList* _tmp112_;
			gint _gc_size = 0;
			GeeArrayList* _tmp113_;
			gint _tmp114_;
			gint _tmp115_;
			gint _gc_index = 0;
			_tmp112_ = glyphs;
			_gc_list = _tmp112_;
			_tmp113_ = _gc_list;
			_tmp114_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp113_);
			_tmp115_ = _tmp114_;
			_gc_size = _tmp115_;
			_gc_index = -1;
			while (TRUE) {
				gint _tmp116_;
				gint _tmp117_;
				BirdFontGlyphCollection* gc = NULL;
				GeeArrayList* _tmp118_;
				gpointer _tmp119_;
				BirdFontOverview* _tmp120_;
				GeeArrayList* _tmp121_;
				BirdFontGlyphCollection* _tmp122_;
				_gc_index = _gc_index + 1;
				_tmp116_ = _gc_index;
				_tmp117_ = _gc_size;
				if (!(_tmp116_ < _tmp117_)) {
					break;
				}
				_tmp118_ = _gc_list;
				_tmp119_ = gee_abstract_list_get ((GeeAbstractList*) _tmp118_, _gc_index);
				gc = (BirdFontGlyphCollection*) _tmp119_;
				_tmp120_ = o;
				_tmp121_ = _tmp120_->copied_glyphs;
				_tmp122_ = gc;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp121_, _tmp122_);
				_g_object_unref0 (gc);
			}
		}
		_tmp123_ = o;
		bird_font_overview_paste (_tmp123_);
	}
	_g_object_unref0 (path);
	_g_object_unref0 (o);
	_g_object_unref0 (glyph_collection);
	_g_object_unref0 (destination);
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (glyph);
	_g_object_unref0 (glyphs);
}

static BirdFontPath*
bird_font_clip_tool_import_birdfont_path (BirdFontGlyph* glyph,
                                          const gchar* data)
{
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp0_;
	BirdFontPath* _tmp1_;
	BirdFontPath* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	BirdFontPath* result;
	g_return_val_if_fail (glyph != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	path = _tmp0_;
	_tmp1_ = path;
	bird_font_bird_font_file_parse_path_data (data, _tmp1_);
	_tmp2_ = path;
	_tmp3_ = bird_font_path_get_points (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		BirdFontPath* _tmp7_;
		GeeArrayList* _tmp8_;
		BirdFontPath* _tmp9_;
		BirdFontPath* _tmp10_;
		bird_font_pen_tool_clear_directions ();
		_tmp7_ = path;
		bird_font_glyph_add_path (glyph, _tmp7_);
		_tmp8_ = glyph->active_paths;
		_tmp9_ = path;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
		_tmp10_ = path;
		bird_font_path_update_region_boundaries (_tmp10_);
	}
	bird_font_pen_tool_remove_all_selected_points ();
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp11_;
		gint _p_size = 0;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _p_index = 0;
		_tmp11_ = glyph->active_paths;
		_p_list = _tmp11_;
		_tmp12_ = _p_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_p_size = _tmp14_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			BirdFontPath* _tmp19_;
			_p_index = _p_index + 1;
			_tmp15_ = _p_index;
			_tmp16_ = _p_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _p_list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _p_index);
			p = (BirdFontPath*) _tmp18_;
			_tmp19_ = p;
			if (bird_font_path_is_open (_tmp19_)) {
				{
					GeeArrayList* _e_list = NULL;
					BirdFontPath* _tmp20_;
					GeeArrayList* _tmp21_;
					GeeArrayList* _tmp22_;
					gint _e_size = 0;
					GeeArrayList* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					gint _e_index = 0;
					_tmp20_ = p;
					_tmp21_ = bird_font_path_get_points (_tmp20_);
					_tmp22_ = _tmp21_;
					_e_list = _tmp22_;
					_tmp23_ = _e_list;
					_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
					_tmp25_ = _tmp24_;
					_e_size = _tmp25_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp26_;
						gint _tmp27_;
						BirdFontEditPoint* e = NULL;
						GeeArrayList* _tmp28_;
						gpointer _tmp29_;
						BirdFontEditPoint* _tmp30_;
						_e_index = _e_index + 1;
						_tmp26_ = _e_index;
						_tmp27_ = _e_size;
						if (!(_tmp26_ < _tmp27_)) {
							break;
						}
						_tmp28_ = _e_list;
						_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _e_index);
						e = (BirdFontEditPoint*) _tmp29_;
						_tmp30_ = e;
						bird_font_edit_point_set_selected (_tmp30_, TRUE);
						_g_object_unref0 (e);
					}
				}
			}
			_g_object_unref0 (p);
		}
	}
	bird_font_pen_tool_update_selection ();
	result = path;
	return result;
}

static void
bird_font_clip_tool_paste_letters_to_kerning_tab (void)
{
	gchar* clipboard_data = NULL;
	BirdFontNativeWindow* _tmp0_;
	gchar* _tmp1_;
	BirdFontKerningDisplay* kerning_display = NULL;
	BirdFontKerningDisplay* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = bird_font_main_window_native_window;
	_tmp1_ = bird_font_native_window_get_clipboard_data (_tmp0_);
	clipboard_data = _tmp1_;
	_tmp2_ = bird_font_main_window_get_kerning_display ();
	kerning_display = _tmp2_;
	_tmp3_ = clipboard_data;
	if (!g_str_has_prefix (_tmp3_, "<?xml")) {
		BirdFontKerningDisplay* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = kerning_display;
		_tmp5_ = clipboard_data;
		bird_font_kerning_display_add_text (_tmp4_, _tmp5_);
	}
	_g_object_unref0 (kerning_display);
	_g_free0 (clipboard_data);
}

static void
bird_font_clip_tool_paste_letters_to_spacing_tab (void)
{
	gchar* clipboard_data = NULL;
	BirdFontNativeWindow* _tmp0_;
	gchar* _tmp1_;
	BirdFontSpacingTab* spacing_tab = NULL;
	BirdFontSpacingTab* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = bird_font_main_window_native_window;
	_tmp1_ = bird_font_native_window_get_clipboard_data (_tmp0_);
	clipboard_data = _tmp1_;
	_tmp2_ = bird_font_main_window_get_spacing_tab ();
	spacing_tab = _tmp2_;
	_tmp3_ = clipboard_data;
	if (!g_str_has_prefix (_tmp3_, "<?xml")) {
		BirdFontSpacingTab* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = spacing_tab;
		_tmp5_ = clipboard_data;
		bird_font_kerning_display_add_text ((BirdFontKerningDisplay*) _tmp4_, _tmp5_);
	}
	_g_object_unref0 (spacing_tab);
	_g_free0 (clipboard_data);
}

BirdFontClipTool*
bird_font_clip_tool_construct (GType object_type)
{
	BirdFontClipTool * self = NULL;
	self = (BirdFontClipTool*) bird_font_tool_construct (object_type, NULL, "");
	return self;
}

BirdFontClipTool*
bird_font_clip_tool_new (void)
{
	return bird_font_clip_tool_construct (BIRD_FONT_TYPE_CLIP_TOOL);
}

static void
bird_font_clip_tool_class_init (BirdFontClipToolClass * klass,
                                gpointer klass_data)
{
	bird_font_clip_tool_parent_class = g_type_class_peek_parent (klass);
}

static void
bird_font_clip_tool_instance_init (BirdFontClipTool * self,
                                   gpointer klass)
{
}

static GType
bird_font_clip_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontClipToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_clip_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontClipTool), 0, (GInstanceInitFunc) bird_font_clip_tool_instance_init, NULL };
	GType bird_font_clip_tool_type_id;
	bird_font_clip_tool_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontClipTool", &g_define_type_info, 0);
	return bird_font_clip_tool_type_id;
}

GType
bird_font_clip_tool_get_type (void)
{
	static volatile gsize bird_font_clip_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_clip_tool_type_id__once)) {
		GType bird_font_clip_tool_type_id;
		bird_font_clip_tool_type_id = bird_font_clip_tool_get_type_once ();
		g_once_init_leave (&bird_font_clip_tool_type_id__once, bird_font_clip_tool_type_id);
	}
	return bird_font_clip_tool_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

