/* CircleTool.c generated by valac 0.56.16, the Vala compiler
 * generated from CircleTool.vala, do not modify */

/*
Copyright (C) 2012 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CIRCLE_TOOL_0_PROPERTY,
	BIRD_FONT_CIRCLE_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_circle_tool_properties[BIRD_FONT_CIRCLE_TOOL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontCircleToolPrivate {
	BirdFontPath* circle;
	gdouble press_x;
	gdouble press_y;
	gdouble last_x;
	gdouble last_y;
	gdouble last_radius;
	gboolean move_circle;
	gboolean resize_circle;
};

static gint BirdFontCircleTool_private_offset;
static gpointer bird_font_circle_tool_parent_class = NULL;

static void __lambda42_ (BirdFontCircleTool* self,
                  BirdFontTool* _self_,
                  gint b,
                  gint x,
                  gint y);
static void bird_font_circle_tool_press (BirdFontCircleTool* self,
                                  gint button,
                                  gdouble x,
                                  gdouble y);
static void ___lambda42__bird_font_tool_press_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               gint button,
                                               gint x,
                                               gint y,
                                               gpointer self);
static void __lambda43_ (BirdFontCircleTool* self,
                  BirdFontTool* _self_,
                  gint b,
                  gint x,
                  gint y);
static void ___lambda43__bird_font_tool_release_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gint button,
                                                 gint x,
                                                 gint y,
                                                 gpointer self);
static void __lambda44_ (BirdFontCircleTool* self,
                  BirdFontTool* _self_,
                  gint x,
                  gint y);
static void bird_font_circle_tool_move (BirdFontCircleTool* self,
                                 gdouble x,
                                 gdouble y);
static void ___lambda44__bird_font_tool_move_action (BirdFontTool* _sender,
                                              BirdFontTool* selected,
                                              gint x,
                                              gint y,
                                              gpointer self);
static void bird_font_circle_tool_get_boundaries (BirdFontCircleTool* self,
                                           gdouble* xmin,
                                           gdouble* xmax,
                                           gdouble* ymin);
static void bird_font_circle_tool_finalize (GObject * obj);
static GType bird_font_circle_tool_get_type_once (void);

static inline gpointer
bird_font_circle_tool_get_instance_private (BirdFontCircleTool* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontCircleTool_private_offset);
}

static void
__lambda42_ (BirdFontCircleTool* self,
             BirdFontTool* _self_,
             gint b,
             gint x,
             gint y)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_circle_tool_press (self, b, (gdouble) x, (gdouble) y);
}

static void
___lambda42__bird_font_tool_press_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          gint button,
                                          gint x,
                                          gint y,
                                          gpointer self)
{
	__lambda42_ ((BirdFontCircleTool*) self, selected, button, x, y);
}

static void
__lambda43_ (BirdFontCircleTool* self,
             BirdFontTool* _self_,
             gint b,
             gint x,
             gint y)
{
	BirdFontPath* _tmp0_;
	g_return_if_fail (_self_ != NULL);
	self->priv->press_x = (gdouble) -1;
	self->priv->press_y = (gdouble) -1;
	_tmp0_ = bird_font_path_new ();
	_g_object_unref0 (self->priv->circle);
	self->priv->circle = _tmp0_;
}

static void
___lambda43__bird_font_tool_release_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gint button,
                                            gint x,
                                            gint y,
                                            gpointer self)
{
	__lambda43_ ((BirdFontCircleTool*) self, selected, button, x, y);
}

static void
__lambda44_ (BirdFontCircleTool* self,
             BirdFontTool* _self_,
             gint x,
             gint y)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_circle_tool_move (self, (gdouble) x, (gdouble) y);
}

static void
___lambda44__bird_font_tool_move_action (BirdFontTool* _sender,
                                         BirdFontTool* selected,
                                         gint x,
                                         gint y,
                                         gpointer self)
{
	__lambda44_ ((BirdFontCircleTool*) self, selected, x, y);
}

BirdFontCircleTool*
bird_font_circle_tool_construct (GType object_type,
                                 const gchar* n)
{
	BirdFontCircleTool * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = bird_font_t_ ("Circle");
	_tmp1_ = _tmp0_;
	self = (BirdFontCircleTool*) bird_font_tool_construct (object_type, n, _tmp1_);
	_g_free0 (_tmp1_);
	g_signal_connect_object ((BirdFontTool*) self, "press-action", (GCallback) ___lambda42__bird_font_tool_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "release-action", (GCallback) ___lambda43__bird_font_tool_release_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "move-action", (GCallback) ___lambda44__bird_font_tool_move_action, self, 0);
	return self;
}

BirdFontCircleTool*
bird_font_circle_tool_new (const gchar* n)
{
	return bird_font_circle_tool_construct (BIRD_FONT_TYPE_CIRCLE_TOOL, n);
}

static void
bird_font_circle_tool_move (BirdFontCircleTool* self,
                            gdouble x,
                            gdouble y)
{
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	gdouble p = 0.0;
	gdouble ratio = 0.0;
	gdouble diameter = 0.0;
	gdouble radius = 0.0;
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble nx = 0.0;
	gdouble ny = 0.0;
	gdouble xmin = 0.0;
	gdouble xmax = 0.0;
	gdouble ymin = 0.0;
	g_return_if_fail (self != NULL);
	dx = self->priv->last_x - x;
	dy = self->priv->last_y - y;
	p = bird_font_pen_tool_precision;
	if (self->priv->move_circle) {
		BirdFontPath* _tmp0_;
		BirdFontPath* _tmp1_;
		_tmp0_ = self->priv->circle;
		bird_font_path_move (_tmp0_, (bird_font_glyph_ivz () * (-dx)) * p, (bird_font_glyph_ivz () * dy) * p);
		_tmp1_ = self->priv->circle;
		bird_font_path_reset_stroke (_tmp1_);
	}
	if (self->priv->resize_circle) {
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		gdouble _tmp8_ = 0.0;
		BirdFontPath* _tmp9_;
		BirdFontPath* _tmp10_;
		BirdFontPath* _tmp11_;
		bird_font_circle_tool_get_boundaries (self, &_tmp2_, &_tmp3_, &_tmp4_);
		xmin = _tmp2_;
		xmax = _tmp3_;
		ymin = _tmp4_;
		diameter = xmax - xmin;
		cx = xmin + (diameter / 2);
		cy = ymin + (diameter / 2);
		radius = bird_font_path_distance_pixels (self->priv->press_x, self->priv->press_y, x, y);
		ratio = (2 * radius) / diameter;
		if ((diameter * ratio) > 0.5) {
			BirdFontPath* _tmp5_;
			_tmp5_ = self->priv->circle;
			bird_font_path_resize (_tmp5_, ratio, ratio);
		}
		bird_font_circle_tool_get_boundaries (self, &_tmp6_, &_tmp7_, &_tmp8_);
		xmin = _tmp6_;
		xmax = _tmp7_;
		ymin = _tmp8_;
		diameter = xmax - xmin;
		nx = xmin + (diameter / 2);
		ny = ymin + (diameter / 2);
		_tmp9_ = self->priv->circle;
		bird_font_path_move (_tmp9_, cx - nx, cy - ny);
		self->priv->last_radius = radius;
		_tmp10_ = self->priv->circle;
		bird_font_path_reset_stroke (_tmp10_);
		_tmp11_ = self->priv->circle;
		bird_font_path_update_region_boundaries (_tmp11_);
	}
	self->priv->last_x = x;
	self->priv->last_y = y;
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_circle_tool_get_boundaries (BirdFontCircleTool* self,
                                      gdouble* xmin,
                                      gdouble* xmax,
                                      gdouble* ymin)
{
	gdouble _vala_xmin = 0.0;
	gdouble _vala_xmax = 0.0;
	gdouble _vala_ymin = 0.0;
	g_return_if_fail (self != NULL);
	_vala_xmin = BIRD_FONT_GLYPH_CANVAS_MAX;
	_vala_xmax = BIRD_FONT_GLYPH_CANVAS_MIN;
	_vala_ymin = BIRD_FONT_GLYPH_CANVAS_MAX;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPath* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _p_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p_index = 0;
		_tmp0_ = self->priv->circle;
		_tmp1_ = bird_font_path_get_points (_tmp0_);
		_tmp2_ = _tmp1_;
		_p_list = _tmp2_;
		_tmp3_ = _p_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p_size = _tmp5_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPoint* _tmp12_;
			BirdFontEditPoint* _tmp14_;
			_p_index = _p_index + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _p_index);
			p = (BirdFontEditPoint*) _tmp9_;
			_tmp10_ = p;
			if (_tmp10_->x < _vala_xmin) {
				BirdFontEditPoint* _tmp11_;
				_tmp11_ = p;
				_vala_xmin = _tmp11_->x;
			}
			_tmp12_ = p;
			if (_tmp12_->x > _vala_xmax) {
				BirdFontEditPoint* _tmp13_;
				_tmp13_ = p;
				_vala_xmax = _tmp13_->x;
			}
			_tmp14_ = p;
			if (_tmp14_->y < _vala_ymin) {
				BirdFontEditPoint* _tmp15_;
				_tmp15_ = p;
				_vala_ymin = _tmp15_->y;
			}
			_g_object_unref0 (p);
		}
	}
	if (xmin) {
		*xmin = _vala_xmin;
	}
	if (xmax) {
		*xmax = _vala_xmax;
	}
	if (ymin) {
		*ymin = _vala_ymin;
	}
}

BirdFontPath*
bird_font_circle_tool_create_circle (gdouble x,
                                     gdouble y,
                                     gdouble r,
                                     BirdFontPointType pt)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble steps = 0.0;
	BirdFontPath* _tmp6_;
	BirdFontPath* _tmp7_;
	BirdFontPath* _tmp8_;
	BirdFontPath* result;
	_tmp0_ = bird_font_path_new ();
	path = _tmp0_;
	if (pt == BIRD_FONT_POINT_TYPE_QUADRATIC) {
		_tmp1_ = G_PI / 8;
	} else {
		_tmp1_ = G_PI / 4;
	}
	steps = _tmp1_;
	{
		gdouble angle = 0.0;
		angle = (gdouble) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				BirdFontPath* _tmp3_;
				BirdFontEditPoint* _tmp4_;
				BirdFontEditPoint* _tmp5_;
				if (!_tmp2_) {
					angle += steps;
				}
				_tmp2_ = FALSE;
				if (!(angle < (2 * G_PI))) {
					break;
				}
				px = (r * cos (angle)) + x;
				py = (r * sin (angle)) + y;
				_tmp3_ = path;
				_tmp4_ = bird_font_path_add (_tmp3_, px, py);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (_tmp5_);
			}
		}
	}
	_tmp6_ = path;
	bird_font_path_init_point_type (_tmp6_, pt);
	_tmp7_ = path;
	bird_font_path_close (_tmp7_);
	_tmp8_ = path;
	bird_font_path_recalculate_linear_handles (_tmp8_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				{
					GeeArrayList* _ep_list = NULL;
					BirdFontPath* _tmp11_;
					GeeArrayList* _tmp12_;
					GeeArrayList* _tmp13_;
					gint _ep_size = 0;
					GeeArrayList* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _ep_index = 0;
					_tmp11_ = path;
					_tmp12_ = bird_font_path_get_points (_tmp11_);
					_tmp13_ = _tmp12_;
					_ep_list = _tmp13_;
					_tmp14_ = _ep_list;
					_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_ep_size = _tmp16_;
					_ep_index = -1;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						BirdFontEditPoint* ep = NULL;
						GeeArrayList* _tmp19_;
						gpointer _tmp20_;
						BirdFontEditPoint* _tmp21_;
						BirdFontEditPoint* _tmp22_;
						_ep_index = _ep_index + 1;
						_tmp17_ = _ep_index;
						_tmp18_ = _ep_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _ep_list;
						_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _ep_index);
						ep = (BirdFontEditPoint*) _tmp20_;
						_tmp21_ = ep;
						bird_font_edit_point_set_tie_handle (_tmp21_, TRUE);
						_tmp22_ = ep;
						bird_font_edit_point_process_tied_handle (_tmp22_);
						_g_object_unref0 (ep);
					}
				}
			}
		}
	}
	result = path;
	return result;
}

BirdFontPath*
bird_font_circle_tool_create_ellipse (gdouble x,
                                      gdouble y,
                                      gdouble rx,
                                      gdouble ry,
                                      BirdFontPointType point_type)
{
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp0_;
	BirdFontSvgTransforms* transforms = NULL;
	BirdFontSvgTransforms* _tmp12_;
	BirdFontSvgTransforms* _tmp13_;
	BirdFontSvgTransforms* _tmp14_;
	cairo_matrix_t m = {0};
	BirdFontSvgTransforms* _tmp15_;
	cairo_matrix_t _tmp16_ = {0};
	BirdFontPath* _tmp17_;
	cairo_matrix_t _tmp18_;
	BirdFontPath* result;
	_tmp0_ = bird_font_circle_tool_create_circle (x, y, (gdouble) 1, point_type);
	path = _tmp0_;
	{
		GeeArrayList* _ep_list = NULL;
		BirdFontPath* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _ep_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _ep_index = 0;
		_tmp1_ = path;
		_tmp2_ = bird_font_path_get_points (_tmp1_);
		_tmp3_ = _tmp2_;
		_ep_list = _tmp3_;
		_tmp4_ = _ep_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_ep_size = _tmp6_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontEditPoint* _tmp11_;
			_ep_index = _ep_index + 1;
			_tmp7_ = _ep_index;
			_tmp8_ = _ep_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _ep_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp10_;
			_tmp11_ = ep;
			bird_font_edit_point_set_tie_handle (_tmp11_, FALSE);
			_g_object_unref0 (ep);
		}
	}
	_tmp12_ = bird_font_svg_transforms_new ();
	transforms = _tmp12_;
	_tmp13_ = transforms;
	bird_font_svg_transforms_resize (_tmp13_, rx, ry, x, y);
	_tmp14_ = transforms;
	bird_font_svg_transforms_collapse_transforms (_tmp14_);
	_tmp15_ = transforms;
	bird_font_svg_transforms_get_matrix (_tmp15_, &_tmp16_);
	m = _tmp16_;
	_tmp17_ = path;
	_tmp18_ = m;
	bird_font_path_transform (_tmp17_, &_tmp18_);
	{
		GeeArrayList* _ep_list = NULL;
		BirdFontPath* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		gint _ep_size = 0;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _ep_index = 0;
		_tmp19_ = path;
		_tmp20_ = bird_font_path_get_points (_tmp19_);
		_tmp21_ = _tmp20_;
		_ep_list = _tmp21_;
		_tmp22_ = _ep_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_ep_size = _tmp24_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp27_;
			gpointer _tmp28_;
			BirdFontEditPoint* _tmp29_;
			_ep_index = _ep_index + 1;
			_tmp25_ = _ep_index;
			_tmp26_ = _ep_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _ep_list;
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp28_;
			_tmp29_ = ep;
			bird_font_edit_point_set_tie_handle (_tmp29_, TRUE);
			_g_object_unref0 (ep);
		}
	}
	result = path;
	_g_object_unref0 (transforms);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bird_font_circle_tool_press (BirdFontCircleTool* self,
                             gint button,
                             gdouble x,
                             gdouble y)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp1_;
	gboolean _tmp2_ = FALSE;
	BirdFontGlyph* _tmp3_;
	gdouble px = 0.0;
	gdouble py = 0.0;
	BirdFontPath* _tmp4_;
	BirdFontGlyph* _tmp7_;
	BirdFontPath* _tmp8_;
	BirdFontPath* _tmp9_;
	BirdFontPath* _tmp11_;
	BirdFontPath* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	_tmp1_ = bird_font_path_new ();
	path = _tmp1_;
	self->priv->press_x = x;
	self->priv->press_y = y;
	self->priv->move_circle = button == 3;
	self->priv->resize_circle = button == 1;
	if (!self->priv->move_circle) {
		_tmp2_ = !self->priv->resize_circle;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_g_object_unref0 (path);
		_g_object_unref0 (glyph);
		return;
	}
	_tmp3_ = glyph;
	bird_font_glyph_store_undo_state (_tmp3_, FALSE);
	px = bird_font_glyph_path_coordinate_x (x);
	py = bird_font_glyph_path_coordinate_y (y);
	_tmp4_ = bird_font_circle_tool_create_circle (px, py, (gdouble) 2, bird_font_drawing_tools_point_type);
	_g_object_unref0 (path);
	path = _tmp4_;
	if (bird_font_stroke_tool_add_stroke) {
		BirdFontPath* _tmp5_;
		BirdFontPath* _tmp6_;
		_tmp5_ = path;
		bird_font_path_set_stroke (_tmp5_, bird_font_stroke_tool_stroke_width);
		_tmp6_ = path;
		_tmp6_->line_cap = bird_font_stroke_tool_line_cap;
	}
	_tmp7_ = glyph;
	_tmp8_ = path;
	bird_font_glyph_add_path (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->circle;
	if (!bird_font_pen_tool_is_counter_path (_tmp9_)) {
		BirdFontPath* _tmp10_;
		_tmp10_ = path;
		bird_font_path_reverse (_tmp10_);
	}
	_tmp11_ = path;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->priv->circle);
	self->priv->circle = _tmp12_;
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (path);
	_g_object_unref0 (glyph);
}

static void
bird_font_circle_tool_class_init (BirdFontCircleToolClass * klass,
                                  gpointer klass_data)
{
	bird_font_circle_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontCircleTool_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_circle_tool_finalize;
}

static void
bird_font_circle_tool_instance_init (BirdFontCircleTool * self,
                                     gpointer klass)
{
	BirdFontPath* _tmp0_;
	self->priv = bird_font_circle_tool_get_instance_private (self);
	_tmp0_ = bird_font_path_new ();
	self->priv->circle = _tmp0_;
	self->priv->press_x = (gdouble) -1;
	self->priv->press_y = (gdouble) -1;
	self->priv->last_x = (gdouble) -1;
	self->priv->last_y = (gdouble) -1;
	self->priv->last_radius = (gdouble) 2;
	self->priv->move_circle = FALSE;
	self->priv->resize_circle = FALSE;
}

static void
bird_font_circle_tool_finalize (GObject * obj)
{
	BirdFontCircleTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CIRCLE_TOOL, BirdFontCircleTool);
	_g_object_unref0 (self->priv->circle);
	G_OBJECT_CLASS (bird_font_circle_tool_parent_class)->finalize (obj);
}

static GType
bird_font_circle_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCircleToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_circle_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCircleTool), 0, (GInstanceInitFunc) bird_font_circle_tool_instance_init, NULL };
	GType bird_font_circle_tool_type_id;
	bird_font_circle_tool_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontCircleTool", &g_define_type_info, 0);
	BirdFontCircleTool_private_offset = g_type_add_instance_private (bird_font_circle_tool_type_id, sizeof (BirdFontCircleToolPrivate));
	return bird_font_circle_tool_type_id;
}

GType
bird_font_circle_tool_get_type (void)
{
	static volatile gsize bird_font_circle_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_circle_tool_type_id__once)) {
		GType bird_font_circle_tool_type_id;
		bird_font_circle_tool_type_id = bird_font_circle_tool_get_type_once ();
		g_once_init_leave (&bird_font_circle_tool_type_id__once, bird_font_circle_tool_type_id);
	}
	return bird_font_circle_tool_type_id__once;
}

