/* CharacterInfo.c generated by valac 0.56.16, the Vala compiler
 * generated from CharacterInfo.vala, do not modify */

/*
Copyright (C) 2013 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CHARACTER_INFO_0_PROPERTY,
	BIRD_FONT_CHARACTER_INFO_NUM_PROPERTIES
};
static GParamSpec* bird_font_character_info_properties[BIRD_FONT_CHARACTER_INFO_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontCharacterInfoPrivate {
	BirdFontText* icon;
	gdouble x;
	gdouble y;
	gboolean ligature;
	gchar* name;
};

static gint BirdFontCharacterInfo_private_offset;
static gpointer bird_font_character_info_parent_class = NULL;
static BirdFontText* bird_font_character_info_info_icon;
static BirdFontText* bird_font_character_info_info_icon = NULL;

static void bird_font_character_info_finalize (GObject * obj);
static GType bird_font_character_info_get_type_once (void);

static inline gpointer
bird_font_character_info_get_instance_private (BirdFontCharacterInfo* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontCharacterInfo_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontCharacterInfo*
bird_font_character_info_construct (GType object_type,
                                    gunichar c,
                                    BirdFontGlyphCollection* gc)
{
	BirdFontCharacterInfo * self = NULL;
	BirdFontText* _tmp0_;
	BirdFontText* _tmp3_;
	BirdFontText* _tmp4_;
	self = (BirdFontCharacterInfo*) g_object_new (object_type, NULL);
	self->unicode = c;
	_tmp0_ = bird_font_character_info_info_icon;
	if (_tmp0_ == NULL) {
		BirdFontText* _tmp1_;
		BirdFontText* _tmp2_;
		_tmp1_ = bird_font_text_new ("info_icon", (gdouble) 22, (gdouble) 0);
		_g_object_unref0 (bird_font_character_info_info_icon);
		bird_font_character_info_info_icon = _tmp1_;
		_tmp2_ = bird_font_character_info_info_icon;
		bird_font_text_load_font (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_TEXT, BirdFontText), "icons.birdfont");
	}
	_tmp3_ = bird_font_character_info_info_icon;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BIRD_FONT_TYPE_TEXT, BirdFontText));
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp4_;
	if (gc != NULL) {
		gchar* _tmp5_;
		self->priv->ligature = bird_font_glyph_collection_is_unassigned (G_TYPE_CHECK_INSTANCE_CAST (gc, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_tmp5_ = bird_font_glyph_collection_get_name (G_TYPE_CHECK_INSTANCE_CAST (gc, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_g_free0 (self->priv->name);
		self->priv->name = _tmp5_;
	}
	return self;
}

BirdFontCharacterInfo*
bird_font_character_info_new (gunichar c,
                              BirdFontGlyphCollection* gc)
{
	return bird_font_character_info_construct (BIRD_FONT_TYPE_CHARACTER_INFO, c, gc);
}

gchar*
bird_font_character_info_get_name (BirdFontCharacterInfo* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
bird_font_character_info_is_ligature (BirdFontCharacterInfo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->ligature;
	return result;
}

gchar*
bird_font_character_info_get_entry (BirdFontCharacterInfo* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_char_database_get_unicode_database_entry (self->unicode);
	result = _tmp0_;
	return result;
}

void
bird_font_character_info_set_position (BirdFontCharacterInfo* self,
                                       gdouble x,
                                       gdouble y)
{
	g_return_if_fail (self != NULL);
	self->priv->x = x;
	self->priv->y = y;
}

gboolean
bird_font_character_info_is_over_icon (BirdFontCharacterInfo* self,
                                       gdouble px,
                                       gdouble py)
{
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = px;
	if ((self->priv->x <= _tmp1_) && (_tmp1_ <= (self->priv->x + 12))) {
		gdouble _tmp2_;
		_tmp2_ = py;
		_tmp0_ = (self->priv->y <= _tmp2_) && (_tmp2_ <= (self->priv->y + 24));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
bird_font_character_info_draw_icon (BirdFontCharacterInfo* self,
                                    cairo_t* cr,
                                    gboolean selected,
                                    gdouble px,
                                    gdouble py)
{
	BirdFontText* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (selected) {
		BirdFontText* _tmp0_;
		_tmp0_ = self->priv->icon;
		bird_font_theme_text_color (_tmp0_, "Overview Selected Foreground");
	} else {
		BirdFontText* _tmp1_;
		_tmp1_ = self->priv->icon;
		bird_font_theme_text_color (_tmp1_, "Overview Foreground");
	}
	_tmp2_ = self->priv->icon;
	bird_font_text_draw_at_top (_tmp2_, cr, px, py, "");
}

static void
bird_font_character_info_class_init (BirdFontCharacterInfoClass * klass,
                                     gpointer klass_data)
{
	bird_font_character_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontCharacterInfo_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_character_info_finalize;
}

static void
bird_font_character_info_instance_init (BirdFontCharacterInfo * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	self->priv = bird_font_character_info_get_instance_private (self);
	self->priv->x = (gdouble) 0;
	self->priv->y = (gdouble) 0;
	self->priv->ligature = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->name = _tmp0_;
}

static void
bird_font_character_info_finalize (GObject * obj)
{
	BirdFontCharacterInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CHARACTER_INFO, BirdFontCharacterInfo);
	_g_object_unref0 (self->priv->icon);
	_g_free0 (self->priv->name);
	G_OBJECT_CLASS (bird_font_character_info_parent_class)->finalize (obj);
}

/** Display functions for a unicode character database entry. */
static GType
bird_font_character_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCharacterInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_character_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCharacterInfo), 0, (GInstanceInitFunc) bird_font_character_info_instance_init, NULL };
	GType bird_font_character_info_type_id;
	bird_font_character_info_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontCharacterInfo", &g_define_type_info, 0);
	BirdFontCharacterInfo_private_offset = g_type_add_instance_private (bird_font_character_info_type_id, sizeof (BirdFontCharacterInfoPrivate));
	return bird_font_character_info_type_id;
}

GType
bird_font_character_info_get_type (void)
{
	static volatile gsize bird_font_character_info_type_id__once = 0;
	if (g_once_init_enter (&bird_font_character_info_type_id__once)) {
		GType bird_font_character_info_type_id;
		bird_font_character_info_type_id = bird_font_character_info_get_type_once ();
		g_once_init_leave (&bird_font_character_info_type_id__once, bird_font_character_info_type_id);
	}
	return bird_font_character_info_type_id__once;
}

