/* CharDatabase.c generated by valac 0.56.16, the Vala compiler
 * generated from CharDatabase.vala, do not modify */

/*
Copyright (C) 2012 2015 Johan Mattsson

All rights reserved.
*/

#include "birdfont.h"
#include <sqlite3.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BirdFontParamSpecCharDatabase BirdFontParamSpecCharDatabase;

struct _BirdFontParamSpecCharDatabase {
	GParamSpec parent_instance;
};

static gpointer bird_font_char_database_parent_class = NULL;
BirdFontGlyphRange* bird_font_char_database_full_unicode_range = NULL;
static sqlite3* bird_font_char_database_db;
static sqlite3* bird_font_char_database_db = NULL;
static sqlite3* bird_font_char_database_database;
static sqlite3* bird_font_char_database_database = NULL;

static gboolean bird_font_char_database_has_all_terms (gunichar c,
                                                const gchar* query);
static gboolean bird_font_char_database_has_term (gunichar c,
                                           const gchar* term);
static void bird_font_char_database_finalize (BirdFontCharDatabase * obj);
static GType bird_font_char_database_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

BirdFontCharDatabase*
bird_font_char_database_construct (GType object_type)
{
	BirdFontCharDatabase* self = NULL;
	GFile* f = NULL;
	BirdFontGlyphRange* _tmp0_;
	GFile* _tmp1_;
	self = (BirdFontCharDatabase*) g_type_create_instance (object_type);
	_tmp0_ = bird_font_glyph_range_new ();
	_bird_font_glyph_range_unref0 (bird_font_char_database_full_unicode_range);
	bird_font_char_database_full_unicode_range = _tmp0_;
	_tmp1_ = bird_font_char_database_get_database_file ();
	_g_object_unref0 (f);
	f = _tmp1_;
	bird_font_char_database_open_database ();
	_g_object_unref0 (f);
	return self;
}

BirdFontCharDatabase*
bird_font_char_database_new (void)
{
	return bird_font_char_database_construct (BIRD_FONT_TYPE_CHAR_DATABASE);
}

void
bird_font_char_database_open_database (void)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint rc = 0;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	sqlite3* _tmp11_ = NULL;
	gint _tmp12_;
	gint _tmp13_;
	sqlite3* _tmp14_;
	_tmp0_ = bird_font_char_database_get_database_file ();
	f = _tmp0_;
	_tmp1_ = f;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = (gchar*) _tmp2_;
	_tmp4_ = g_strconcat ("Open database: ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "\n", NULL);
	_tmp7_ = _tmp6_;
	bird_font_printd (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp8_ = f;
	_tmp9_ = g_file_get_path (_tmp8_);
	_tmp10_ = (gchar*) _tmp9_;
	_tmp12_ = sqlite3_open_v2 (_tmp10_, &_tmp11_, SQLITE_OPEN_READONLY, NULL);
	_sqlite3_close0 (bird_font_char_database_database);
	bird_font_char_database_database = _tmp11_;
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp10_);
	rc = _tmp13_;
	_tmp14_ = bird_font_char_database_database;
	bird_font_char_database_db = (sqlite3*) _tmp14_;
	if (rc != SQLITE_OK) {
		FILE* _tmp15_;
		sqlite3* _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = stderr;
		_tmp16_ = bird_font_char_database_db;
		_tmp17_ = sqlite3_errmsg (_tmp16_);
		fprintf (_tmp15_, "Can't open database: %d, %s\n", rc, _tmp17_);
	}
	_g_object_unref0 (f);
}

GFile*
bird_font_char_database_get_database_file (void)
{
	GFile* _tmp0_;
	GFile* result;
	_tmp0_ = bird_font_search_paths_find_file (NULL, "ucd.sqlite");
	result = _tmp0_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

BirdFontGlyphRange*
bird_font_char_database_search (const gchar* s)
{
	BirdFontGlyphRange* _result_ = NULL;
	BirdFontGlyphRange* _tmp0_;
	BirdFontGlyphRange* ucd_result = NULL;
	BirdFontGlyphRange* _tmp1_;
	gint rc = 0;
	gint cols = 0;
	sqlite3_stmt* statement = NULL;
	gchar* select = NULL;
	gunichar c = 0U;
	gchar* query = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp10_;
	gchar** terms = NULL;
	const gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint terms_length1;
	gint _terms_size_;
	gboolean first = FALSE;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	sqlite3* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	sqlite3_stmt* _tmp40_ = NULL;
	gint _tmp41_;
	GError* _inner_error0_ = NULL;
	BirdFontGlyphRange* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = bird_font_glyph_range_new ();
	_result_ = _tmp0_;
	_tmp1_ = bird_font_glyph_range_new ();
	ucd_result = _tmp1_;
	_tmp2_ = string_strip (s);
	query = _tmp2_;
	_tmp4_ = query;
	if (g_str_has_prefix (_tmp4_, "U+")) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = query;
		_tmp3_ = g_str_has_prefix (_tmp5_, "u+");
	}
	if (_tmp3_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = query;
		_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
		_tmp8_ = _tmp7_;
		c = bird_font_font_to_unichar (_tmp8_);
		_g_free0 (_tmp8_);
		if (c != ((gunichar) '\0')) {
			BirdFontGlyphRange* _tmp9_;
			_tmp9_ = _result_;
			bird_font_glyph_range_add_single (_tmp9_, c);
		}
	}
	_tmp10_ = query;
	if (g_utf8_strlen (_tmp10_, (gssize) -1) == 1) {
		BirdFontGlyphRange* _tmp11_;
		_tmp11_ = _result_;
		bird_font_glyph_range_add_single (_tmp11_, string_get_char (s, (glong) 0));
	}
	_tmp12_ = query;
	_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, " ", 0);
	terms = _tmp14_;
	terms_length1 = _vala_array_length (_tmp13_);
	_terms_size_ = terms_length1;
	first = TRUE;
	_tmp15_ = g_strdup ("");
	_g_free0 (select);
	select = _tmp15_;
	_tmp16_ = terms;
	_tmp16__length1 = terms_length1;
	{
		gchar** term_collection = NULL;
		gint term_collection_length1 = 0;
		gint _term_collection_size_ = 0;
		gint term_it = 0;
		term_collection = _tmp16_;
		term_collection_length1 = _tmp16__length1;
		for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
			gchar* _tmp17_;
			gchar* term = NULL;
			_tmp17_ = g_strdup (term_collection[term_it]);
			term = _tmp17_;
			{
				if (first) {
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp18_ = term;
					_tmp19_ = string_replace (_tmp18_, "'", "''");
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strconcat ("SELECT unicode FROM Words " "WHERE word GLOB '", _tmp20_, NULL);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strconcat (_tmp22_, "' ", NULL);
					_g_free0 (select);
					select = _tmp23_;
					_g_free0 (_tmp22_);
					_g_free0 (_tmp20_);
				} else {
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp24_ = select;
					_tmp25_ = term;
					_tmp26_ = string_replace (_tmp25_, "'", "''");
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strconcat ("OR word GLOB '", _tmp27_, NULL);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strconcat (_tmp29_, "' ", NULL);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_strconcat (_tmp24_, _tmp31_, NULL);
					_g_free0 (select);
					select = _tmp32_;
					_g_free0 (_tmp31_);
					_g_free0 (_tmp29_);
					_g_free0 (_tmp27_);
				}
				first = FALSE;
				_g_free0 (term);
			}
		}
	}
	_tmp33_ = select;
	_tmp34_ = g_strconcat (_tmp33_, ";", NULL);
	_g_free0 (select);
	select = _tmp34_;
	_tmp35_ = bird_font_char_database_db;
	_tmp36_ = select;
	_tmp37_ = select;
	_tmp38_ = strlen (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp41_ = sqlite3_prepare_v2 (_tmp35_, _tmp36_, _tmp39_, &_tmp40_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp40_;
	rc = _tmp41_;
	if (rc == SQLITE_OK) {
		sqlite3_stmt* _tmp42_;
		_tmp42_ = statement;
		cols = sqlite3_column_count (_tmp42_);
		if (cols != 1) {
			g_warning ("CharDatabase.vala:87: Expecting one column.");
			result = _result_;
			terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (query);
			_g_free0 (select);
			_sqlite3_finalize0 (statement);
			_bird_font_glyph_range_unref0 (ucd_result);
			return result;
		}
		while (TRUE) {
			sqlite3_stmt* _tmp43_;
			_tmp43_ = statement;
			rc = sqlite3_step (_tmp43_);
			if (rc == SQLITE_DONE) {
				break;
			} else {
				if (rc == SQLITE_ROW) {
					sqlite3_stmt* _tmp44_;
					const gchar* _tmp45_;
					_tmp44_ = statement;
					c = (gunichar) sqlite3_column_int64 (_tmp44_, 0);
					_tmp45_ = query;
					if (bird_font_char_database_has_all_terms (c, _tmp45_)) {
						BirdFontGlyphRange* _tmp46_;
						_tmp46_ = ucd_result;
						bird_font_glyph_range_add_single (_tmp46_, c);
					}
				} else {
					sqlite3* _tmp47_;
					const gchar* _tmp48_;
					_tmp47_ = bird_font_char_database_db;
					_tmp48_ = sqlite3_errmsg (_tmp47_);
					g_warning ("CharDatabase.vala:103: Error: %d, %s\n", rc, _tmp48_);
					break;
				}
			}
		}
		{
			BirdFontGlyphRange* _tmp49_;
			_tmp49_ = ucd_result;
			if (bird_font_glyph_range_get_length (_tmp49_) > ((guint32) 0)) {
				BirdFontGlyphRange* _tmp50_;
				BirdFontGlyphRange* _tmp51_;
				BirdFontGlyphRange* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp50_ = ucd_result;
				bird_font_glyph_range_sort (_tmp50_);
				_tmp51_ = _result_;
				_tmp52_ = ucd_result;
				_tmp53_ = bird_font_glyph_range_get_all_ranges (_tmp52_);
				_tmp54_ = _tmp53_;
				bird_font_glyph_range_parse_ranges (_tmp51_, _tmp54_, &_inner_error0_);
				_g_free0 (_tmp54_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_MARKUP_ERROR) {
						goto __catch0_g_markup_error;
					}
					terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (query);
					_g_free0 (select);
					_sqlite3_finalize0 (statement);
					_bird_font_glyph_range_unref0 (ucd_result);
					_bird_font_glyph_range_unref0 (_result_);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
		goto __finally0;
		__catch0_g_markup_error:
		{
			GError* e = NULL;
			GError* _tmp55_;
			const gchar* _tmp56_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp55_ = e;
			_tmp56_ = _tmp55_->message;
			g_warning ("CharDatabase.vala:114: %s", _tmp56_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (query);
			_g_free0 (select);
			_sqlite3_finalize0 (statement);
			_bird_font_glyph_range_unref0 (ucd_result);
			_bird_font_glyph_range_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		sqlite3* _tmp57_;
		const gchar* _tmp58_;
		_tmp57_ = bird_font_char_database_db;
		_tmp58_ = sqlite3_errmsg (_tmp57_);
		g_warning ("CharDatabase.vala:118: SQL error: %d, %s\n", rc, _tmp58_);
	}
	result = _result_;
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
	_g_free0 (select);
	_sqlite3_finalize0 (statement);
	_bird_font_glyph_range_unref0 (ucd_result);
	return result;
}

gboolean
bird_font_char_database_has_ascender (gunichar c)
{
	gboolean result;
	if (!g_unichar_islower (c)) {
		result = TRUE;
		return result;
	}
	switch (c) {
		case 'b':
		{
			result = TRUE;
			return result;
		}
		case 'd':
		{
			result = TRUE;
			return result;
		}
		case 'f':
		{
			result = TRUE;
			return result;
		}
		case 'h':
		{
			result = TRUE;
			return result;
		}
		case 'k':
		{
			result = TRUE;
			return result;
		}
		case 'l':
		{
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

gboolean
bird_font_char_database_has_descender (gunichar c)
{
	gboolean result;
	switch (c) {
		case 'g':
		{
			result = TRUE;
			return result;
		}
		case 'j':
		{
			result = TRUE;
			return result;
		}
		case 'p':
		{
			result = TRUE;
			return result;
		}
		case 'q':
		{
			result = TRUE;
			return result;
		}
		case 'y':
		{
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

static gboolean
bird_font_char_database_has_term (gunichar c,
                                  const gchar* term)
{
	sqlite3_stmt* statement = NULL;
	gchar* select = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gint rc = 0;
	sqlite3* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_;
	gboolean result;
	g_return_val_if_fail (term != NULL, FALSE);
	_tmp0_ = string_replace (term, "'", "''");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("SELECT unicode FROM Words " "WHERE word GLOB '", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "' ", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) c);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("AND unicode = ", _tmp7_, ";", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp5_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	select = _tmp11_;
	_tmp12_ = bird_font_char_database_db;
	_tmp13_ = select;
	_tmp14_ = select;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp18_ = sqlite3_prepare_v2 (_tmp12_, _tmp13_, _tmp16_, &_tmp17_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp17_;
	rc = _tmp18_;
	if (rc == SQLITE_OK) {
		sqlite3_stmt* _tmp19_;
		_tmp19_ = statement;
		rc = sqlite3_step (_tmp19_);
		if (rc == SQLITE_DONE) {
			result = FALSE;
			_g_free0 (select);
			_sqlite3_finalize0 (statement);
			return result;
		} else {
			if (rc == SQLITE_ROW) {
				sqlite3_stmt* _tmp20_;
				_tmp20_ = statement;
				c = (gunichar) sqlite3_column_int64 (_tmp20_, 0);
				result = TRUE;
				_g_free0 (select);
				_sqlite3_finalize0 (statement);
				return result;
			}
		}
	} else {
		sqlite3* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = bird_font_char_database_db;
		_tmp22_ = sqlite3_errmsg (_tmp21_);
		g_warning ("CharDatabase.vala:169: Error: %d, %s\n", rc, _tmp22_);
		result = FALSE;
		_g_free0 (select);
		_sqlite3_finalize0 (statement);
		return result;
	}
	result = FALSE;
	_g_free0 (select);
	_sqlite3_finalize0 (statement);
	return result;
}

static gboolean
bird_font_char_database_has_all_terms (gunichar c,
                                       const gchar* query)
{
	gchar** terms = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint terms_length1;
	gint _terms_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (query != NULL, FALSE);
	_tmp1_ = _tmp0_ = g_strsplit (query, " ", 0);
	terms = _tmp1_;
	terms_length1 = _vala_array_length (_tmp0_);
	_terms_size_ = terms_length1;
	_tmp2_ = terms;
	_tmp2__length1 = terms_length1;
	{
		gchar** term_collection = NULL;
		gint term_collection_length1 = 0;
		gint _term_collection_size_ = 0;
		gint term_it = 0;
		term_collection = _tmp2_;
		term_collection_length1 = _tmp2__length1;
		for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
			gchar* _tmp3_;
			gchar* term = NULL;
			_tmp3_ = g_strdup (term_collection[term_it]);
			term = _tmp3_;
			{
				const gchar* _tmp4_;
				_tmp4_ = term;
				if (!bird_font_char_database_has_term (c, _tmp4_)) {
					result = FALSE;
					_g_free0 (term);
					terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (term);
			}
		}
	}
	result = TRUE;
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gchar*
bird_font_char_database_get_unicode_database_entry (gunichar c)
{
	gchar* description = NULL;
	gchar* _tmp0_;
	gint rc = 0;
	gint cols = 0;
	sqlite3_stmt* statement = NULL;
	gchar* select = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	sqlite3* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_;
	const gchar* _tmp23_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	description = _tmp0_;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) c);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("WHERE unicode = ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("SELECT description FROM Description ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	select = _tmp6_;
	_tmp7_ = bird_font_char_database_db;
	_tmp8_ = select;
	_tmp9_ = select;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = sqlite3_prepare_v2 (_tmp7_, _tmp8_, _tmp11_, &_tmp12_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp12_;
	rc = _tmp13_;
	if (rc == SQLITE_OK) {
		sqlite3_stmt* _tmp14_;
		_tmp14_ = statement;
		cols = sqlite3_column_count (_tmp14_);
		if (cols != 1) {
			g_warning ("CharDatabase.vala:201: Expecting one column.");
			result = description;
			_g_free0 (select);
			_sqlite3_finalize0 (statement);
			return result;
		}
		while (TRUE) {
			sqlite3_stmt* _tmp15_;
			_tmp15_ = statement;
			rc = sqlite3_step (_tmp15_);
			if (rc == SQLITE_DONE) {
				break;
			} else {
				if (rc == SQLITE_ROW) {
					sqlite3_stmt* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp16_ = statement;
					_tmp17_ = (const gchar*) sqlite3_column_text (_tmp16_, 0);
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (description);
					description = _tmp18_;
				} else {
					sqlite3* _tmp19_;
					const gchar* _tmp20_;
					_tmp19_ = bird_font_char_database_db;
					_tmp20_ = sqlite3_errmsg (_tmp19_);
					g_printerr ("Error: %d, %s\n", rc, _tmp20_);
					break;
				}
			}
		}
	} else {
		sqlite3* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = bird_font_char_database_db;
		_tmp22_ = sqlite3_errmsg (_tmp21_);
		g_printerr ("SQL error: %d, %s\n", rc, _tmp22_);
	}
	_tmp23_ = description;
	if (g_strcmp0 (_tmp23_, "") == 0) {
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = bird_font_font_to_hex (c);
		_tmp25_ = _tmp24_;
		_tmp26_ = string_replace (_tmp25_, "U+", "");
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, "\tUNICODE CHARACTER", NULL);
		_g_free0 (description);
		description = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
	}
	result = description;
	_g_free0 (select);
	_sqlite3_finalize0 (statement);
	return result;
}

void
bird_font_char_database_get_full_unicode (BirdFontGlyphRange* glyph_range)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (glyph_range != NULL);
	{
		BirdFontGlyphRange* _tmp0_;
		_tmp0_ = bird_font_char_database_full_unicode_range;
		if (!bird_font_is_null (_tmp0_)) {
			BirdFontGlyphRange* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = bird_font_char_database_full_unicode_range;
			_tmp2_ = bird_font_glyph_range_get_all_ranges (_tmp1_);
			_tmp3_ = _tmp2_;
			bird_font_glyph_range_parse_ranges (glyph_range, _tmp3_, &_inner_error0_);
			_g_free0 (_tmp3_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
					goto __catch0_g_markup_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("CharDatabase.vala:235: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
bird_font_value_char_database_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_char_database_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_char_database_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_char_database_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_char_database_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_char_database_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_char_database_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontCharDatabase * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_char_database_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_char_database_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	BirdFontCharDatabase ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_char_database_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_char_database (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	BirdFontParamSpecCharDatabase* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_CHAR_DATABASE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_char_database (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_CHAR_DATABASE), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_char_database (GValue* value,
                                   gpointer v_object)
{
	BirdFontCharDatabase * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_CHAR_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_CHAR_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_char_database_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_char_database_unref (old);
	}
}

void
bird_font_value_take_char_database (GValue* value,
                                    gpointer v_object)
{
	BirdFontCharDatabase * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_CHAR_DATABASE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_CHAR_DATABASE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_char_database_unref (old);
	}
}

static void
bird_font_char_database_class_init (BirdFontCharDatabaseClass * klass,
                                    gpointer klass_data)
{
	bird_font_char_database_parent_class = g_type_class_peek_parent (klass);
	((BirdFontCharDatabaseClass *) klass)->finalize = bird_font_char_database_finalize;
}

static void
bird_font_char_database_instance_init (BirdFontCharDatabase * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_char_database_finalize (BirdFontCharDatabase * obj)
{
	BirdFontCharDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CHAR_DATABASE, BirdFontCharDatabase);
	g_signal_handlers_destroy (self);
}

static GType
bird_font_char_database_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_char_database_init, bird_font_value_char_database_free_value, bird_font_value_char_database_copy_value, bird_font_value_char_database_peek_pointer, "p", bird_font_value_char_database_collect_value, "p", bird_font_value_char_database_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCharDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_char_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCharDatabase), 0, (GInstanceInitFunc) bird_font_char_database_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_char_database_type_id;
	bird_font_char_database_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontCharDatabase", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_char_database_type_id;
}

GType
bird_font_char_database_get_type (void)
{
	static volatile gsize bird_font_char_database_type_id__once = 0;
	if (g_once_init_enter (&bird_font_char_database_type_id__once)) {
		GType bird_font_char_database_type_id;
		bird_font_char_database_type_id = bird_font_char_database_get_type_once ();
		g_once_init_leave (&bird_font_char_database_type_id__once, bird_font_char_database_type_id);
	}
	return bird_font_char_database_type_id__once;
}

gpointer
bird_font_char_database_ref (gpointer instance)
{
	BirdFontCharDatabase * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_char_database_unref (gpointer instance)
{
	BirdFontCharDatabase * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_CHAR_DATABASE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

