/* CffTable.c generated by valac 0.56.16, the Vala compiler
 * generated from CffTable.vala, do not modify */

/*
Copyright (C) 2012, 2013 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <stdio.h>

#define BIRD_FONT_CFF_TABLE_HSTEM ((guint8) 1)
#define BIRD_FONT_CFF_TABLE_VSTEM ((guint8) 3)
#define BIRD_FONT_CFF_TABLE_VMOVETO ((guint8) 4)
#define BIRD_FONT_CFF_TABLE_HLINETO ((guint8) 6)
#define BIRD_FONT_CFF_TABLE_VLINETO ((guint8) 7)
#define BIRD_FONT_CFF_TABLE_ENDCHAR ((guint8) 14)
#define BIRD_FONT_CFF_TABLE_HMOVETO ((guint8) 22)
#define BIRD_FONT_CFF_TABLE_RMOVETO ((guint8) 21)
#define BIRD_FONT_CFF_TABLE_CHARSET ((guint8) 15)
#define BIRD_FONT_CFF_TABLE_ENCODING ((guint8) 16)
#define BIRD_FONT_CFF_TABLE_VERSION ((guint8) 0)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_CFF_TABLE_0_PROPERTY,
	BIRD_FONT_CFF_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_cff_table_properties[BIRD_FONT_CFF_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontCffTablePrivate {
	BirdFontFontData* dis;
};

static gint BirdFontCffTable_private_offset;
static gpointer bird_font_cff_table_parent_class = NULL;

static guint32 bird_font_cff_table_read_offset (BirdFontCffTable* self,
                                         guint size,
                                         GError** error);
static GeeArrayList* bird_font_cff_table_read_index (BirdFontCffTable* self,
                                              GError** error);
static void bird_font_cff_table_real_parse (BirdFontOtfTable* base,
                                     BirdFontFontData* dis,
                                     GError** error);
static void bird_font_cff_table_finalize (GObject * obj);
static GType bird_font_cff_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_cff_table_get_instance_private (BirdFontCffTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontCffTable_private_offset);
}

BirdFontCffTable*
bird_font_cff_table_construct (GType object_type)
{
	BirdFontCffTable * self = NULL;
	gchar* _tmp0_;
	self = (BirdFontCffTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = g_strdup ("CFF ");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp0_;
	return self;
}

BirdFontCffTable*
bird_font_cff_table_new (void)
{
	return bird_font_cff_table_construct (BIRD_FONT_TYPE_CFF_TABLE);
}

static guint32
bird_font_cff_table_read_offset (BirdFontCffTable* self,
                                 guint size,
                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	switch (size) {
		case 0:
		{
			guint8 _tmp0_ = 0U;
			BirdFontFontData* _tmp1_;
			g_warning ("CffTable.vala:45: offset size is zero");
			_tmp1_ = self->priv->dis;
			_tmp0_ = bird_font_font_data_read_byte (_tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				guint32 _tmp2_ = 0U;
				g_propagate_error (error, _inner_error0_);
				return _tmp2_;
			}
			result = (guint32) _tmp0_;
			return result;
		}
		case 1:
		{
			guint8 _tmp3_ = 0U;
			BirdFontFontData* _tmp4_;
			_tmp4_ = self->priv->dis;
			_tmp3_ = bird_font_font_data_read_byte (_tmp4_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				guint32 _tmp5_ = 0U;
				g_propagate_error (error, _inner_error0_);
				return _tmp5_;
			}
			result = (guint32) _tmp3_;
			return result;
		}
		case 2:
		{
			BirdFontFontData* _tmp6_;
			_tmp6_ = self->priv->dis;
			result = (guint32) bird_font_font_data_read_ushort (_tmp6_);
			return result;
		}
		case 4:
		{
			BirdFontFontData* _tmp7_;
			_tmp7_ = self->priv->dis;
			result = bird_font_font_data_read_ulong (_tmp7_);
			return result;
		}
		default:
		{
			g_warn_if_reached ();
			break;
		}
	}
	g_warning ("CffTable.vala:58: offset size is zero");
	result = (guint32) 0;
	return result;
}

static GeeArrayList*
bird_font_cff_table_read_index (BirdFontCffTable* self,
                                GError** error)
{
	guint32 offset_size = 0U;
	guint32 off = 0U;
	gint entries = 0;
	GeeArrayList* offsets = NULL;
	GeeArrayList* _tmp0_;
	BirdFontFontData* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontFontData* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	offsets = _tmp0_;
	_tmp1_ = self->priv->dis;
	entries = (gint) bird_font_font_data_read_ushort (_tmp1_);
	_tmp2_ = g_strdup_printf ("%i", entries);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("number of entries ", _tmp3_, "\n", NULL);
	_tmp5_ = _tmp4_;
	bird_font_printd (_tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	if (entries == 0) {
		bird_font_printd ("skip index");
		result = offsets;
		return result;
	}
	_tmp6_ = self->priv->dis;
	offset_size = (guint32) bird_font_font_data_read (_tmp6_);
	_tmp7_ = g_strdup_printf ("%u", offset_size);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("Offset size ", _tmp8_, "\n", NULL);
	_tmp10_ = _tmp9_;
	bird_font_printd (_tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				guint32 _tmp13_ = 0U;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				GeeArrayList* _tmp18_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(i <= entries)) {
					break;
				}
				_tmp13_ = bird_font_cff_table_read_offset (self, (guint) offset_size, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (offsets);
					return NULL;
				}
				off = _tmp13_;
				_tmp14_ = g_strdup_printf ("%u", off);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat ("offset ", _tmp15_, "\n", NULL);
				_tmp17_ = _tmp16_;
				bird_font_printd (_tmp17_);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
				_tmp18_ = offsets;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (gpointer) ((guintptr) off));
			}
		}
	}
	result = offsets;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bird_font_cff_table_real_parse (BirdFontOtfTable* base,
                                BirdFontFontData* dis,
                                GError** error)
{
	BirdFontCffTable * self;
	guint v1 = 0U;
	guint v2 = 0U;
	guint offset_size = 0U;
	guint header_size = 0U;
	guint len = 0U;
	gchar* data = NULL;
	GeeArrayList* offsets = NULL;
	GeeArrayList* dict_index = NULL;
	gint id = 0;
	gint val = 0;
	gint off = 0;
	BirdFontFontData* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GeeArrayList* _tmp15_ = NULL;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp30_ = NULL;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp32_;
	GeeArrayList* _tmp56_;
	GeeArrayList* _tmp57_;
	GError* _inner_error0_ = NULL;
	self = (BirdFontCffTable*) base;
	g_return_if_fail (dis != NULL);
	bird_font_font_data_seek (dis, (guint) ((BirdFontOtfTable*) self)->offset);
	_tmp0_ = _g_object_ref0 (dis);
	_g_object_unref0 (self->priv->dis);
	self->priv->dis = _tmp0_;
	bird_font_printd ("Parse CFF.\n");
	v1 = (guint) bird_font_font_data_read (dis);
	v2 = (guint) bird_font_font_data_read (dis);
	_tmp1_ = g_strdup_printf ("%u", v1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%u", v2);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("Version ", _tmp2_, ".", _tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	bird_font_printd (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	header_size = (guint) bird_font_font_data_read (dis);
	_tmp7_ = g_strdup_printf ("%u", header_size);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("Header size ", _tmp8_, "\n", NULL);
	_tmp10_ = _tmp9_;
	bird_font_printd (_tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	offset_size = (guint) bird_font_font_data_read (dis);
	_tmp11_ = g_strdup_printf ("%u", offset_size);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("Offset size ", _tmp12_, "\n", NULL);
	_tmp14_ = _tmp13_;
	bird_font_printd (_tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp16_ = bird_font_cff_table_read_index (self, &_inner_error0_);
	_tmp15_ = _tmp16_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dict_index);
		_g_object_unref0 (offsets);
		_g_free0 (data);
		return;
	}
	_tmp17_ = _tmp15_;
	_tmp15_ = NULL;
	_g_object_unref0 (offsets);
	offsets = _tmp17_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				GeeArrayList* _tmp23_;
				gpointer _tmp24_;
				GeeArrayList* _tmp25_;
				gpointer _tmp26_;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				gchar* _tmp29_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = offsets;
				_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
				_tmp22_ = _tmp21_;
				if (!(i < (_tmp22_ - 1))) {
					break;
				}
				_tmp23_ = offsets;
				_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, i);
				off = (gint) ((guint32) ((guintptr) _tmp24_));
				_tmp25_ = offsets;
				_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, i + 1);
				len = (guint) (((guint32) ((guintptr) _tmp26_)) - off);
				_tmp28_ = bird_font_font_data_read_string (dis, len, &_inner_error0_);
				_tmp27_ = _tmp28_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (_tmp15_);
					_g_object_unref0 (dict_index);
					_g_object_unref0 (offsets);
					_g_free0 (data);
					return;
				}
				_tmp29_ = _tmp27_;
				_tmp27_ = NULL;
				_g_free0 (data);
				data = _tmp29_;
				_g_free0 (_tmp27_);
			}
		}
	}
	_tmp31_ = bird_font_cff_table_read_index (self, &_inner_error0_);
	_tmp30_ = _tmp31_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (dict_index);
		_g_object_unref0 (offsets);
		_g_free0 (data);
		return;
	}
	_tmp32_ = _tmp30_;
	_tmp30_ = NULL;
	_g_object_unref0 (dict_index);
	dict_index = _tmp32_;
	id = 0;
	val = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				GeeArrayList* _tmp38_;
				gpointer _tmp39_;
				GeeArrayList* _tmp40_;
				gpointer _tmp41_;
				GeeArrayList* _tmp42_;
				gpointer _tmp43_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = dict_index;
				_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				if (!(i < (_tmp37_ - 1))) {
					break;
				}
				_tmp38_ = offsets;
				_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, i);
				off = (gint) ((guint32) ((guintptr) _tmp39_));
				_tmp40_ = dict_index;
				_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, i + 1);
				_tmp42_ = dict_index;
				_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, i);
				len = (guint) (((guint32) ((guintptr) _tmp41_)) - ((guint32) ((guintptr) _tmp43_)));
				if (bird_font_font_data_next_is_operator (dis)) {
					id = (gint) bird_font_font_data_read (dis);
					if (id == 12) {
						id = (gint) bird_font_font_data_read (dis);
					} else {
						switch (id) {
							case 0:
							{
								self->version = val;
								break;
							}
							default:
							{
								FILE* _tmp44_;
								_tmp44_ = stderr;
								fprintf (_tmp44_, "unknown operator");
								break;
							}
						}
					}
				} else {
					gint _tmp45_ = 0;
					_tmp45_ = bird_font_font_data_read_charstring_value (dis, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (_tmp30_);
						_g_object_unref0 (_tmp15_);
						_g_object_unref0 (dict_index);
						_g_object_unref0 (offsets);
						_g_free0 (data);
						return;
					}
					val = _tmp45_;
				}
				_tmp46_ = g_strdup_printf ("%i", i);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_strdup_printf ("%i", id);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strconcat (_tmp47_, ": id ", _tmp49_, "\n", NULL);
				_tmp51_ = _tmp50_;
				bird_font_printd (_tmp51_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				_g_free0 (_tmp47_);
				_tmp52_ = g_strdup_printf ("%i", val);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strconcat ("val ", _tmp53_, "\n", NULL);
				_tmp55_ = _tmp54_;
				bird_font_printd (_tmp55_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp53_);
			}
		}
	}
	_tmp56_ = bird_font_cff_table_read_index (self, &_inner_error0_);
	_tmp57_ = _tmp56_;
	_g_object_unref0 (_tmp57_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp30_);
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (dict_index);
		_g_object_unref0 (offsets);
		_g_free0 (data);
		return;
	}
	_g_object_unref0 (_tmp30_);
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (dict_index);
	_g_object_unref0 (offsets);
	_g_free0 (data);
}

void
bird_font_cff_table_process (BirdFontCffTable* self,
                             GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	gchar* name = NULL;
	gchar* _tmp1_;
	BirdFontFontData* _tmp2_;
	BirdFontFontData* _tmp3_;
	BirdFontFontData* _tmp4_;
	BirdFontFontData* _tmp5_;
	BirdFontFontData* _tmp6_;
	BirdFontFontData* _tmp7_;
	BirdFontFontData* _tmp8_;
	BirdFontFontData* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	BirdFontFontData* _tmp13_;
	const gchar* _tmp14_;
	BirdFontFontData* _tmp15_;
	BirdFontFontData* _tmp16_;
	BirdFontFontData* _tmp17_;
	BirdFontFontData* _tmp18_;
	BirdFontFontData* _tmp19_;
	BirdFontFontData* _tmp20_;
	BirdFontFontData* _tmp21_;
	BirdFontFontData* _tmp22_;
	BirdFontFontData* _tmp23_;
	BirdFontFontData* _tmp24_;
	BirdFontFontData* _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	_tmp1_ = g_strdup ("typeface");
	name = _tmp1_;
	_tmp2_ = fd;
	bird_font_font_data_add_byte (_tmp2_, (guint8) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp3_ = fd;
	bird_font_font_data_add_byte (_tmp3_, (guint8) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp4_ = fd;
	bird_font_font_data_add_byte (_tmp4_, (guint8) 4, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp5_ = fd;
	bird_font_font_data_add_byte (_tmp5_, (guint8) 2, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp6_ = fd;
	bird_font_font_data_add_ushort (_tmp6_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp7_ = fd;
	bird_font_font_data_add_byte (_tmp7_, (guint8) 2, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp8_ = fd;
	bird_font_font_data_add_ushort (_tmp8_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp9_ = fd;
	_tmp10_ = name;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	bird_font_font_data_add (_tmp9_, (guint8) _tmp12_);
	_tmp13_ = fd;
	_tmp14_ = name;
	bird_font_font_data_add_str (_tmp13_, _tmp14_);
	_tmp15_ = fd;
	bird_font_font_data_add_ushort (_tmp15_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp16_ = fd;
	bird_font_font_data_add_byte (_tmp16_, (guint8) 2, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp17_ = fd;
	bird_font_font_data_add_ushort (_tmp17_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp18_ = fd;
	bird_font_font_data_add_ushort (_tmp18_, (guint16) 2, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp19_ = fd;
	bird_font_font_data_add_charstring_value (_tmp19_, 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp20_ = fd;
	bird_font_font_data_add_byte (_tmp20_, BIRD_FONT_CFF_TABLE_CHARSET, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp21_ = fd;
	bird_font_font_data_add_byte (_tmp21_, (guint8) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp22_ = fd;
	bird_font_font_data_add_byte (_tmp22_, (guint8) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		_g_object_unref0 (fd);
		return;
	}
	_tmp23_ = fd;
	bird_font_font_data_pad (_tmp23_);
	_tmp24_ = fd;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp25_;
	_g_free0 (name);
	_g_object_unref0 (fd);
}

static void
bird_font_cff_table_class_init (BirdFontCffTableClass * klass,
                                gpointer klass_data)
{
	bird_font_cff_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontCffTable_private_offset);
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_cff_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_cff_table_finalize;
}

static void
bird_font_cff_table_instance_init (BirdFontCffTable * self,
                                   gpointer klass)
{
	self->priv = bird_font_cff_table_get_instance_private (self);
}

static void
bird_font_cff_table_finalize (GObject * obj)
{
	BirdFontCffTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_CFF_TABLE, BirdFontCffTable);
	_g_object_unref0 (self->priv->dis);
	G_OBJECT_CLASS (bird_font_cff_table_parent_class)->finalize (obj);
}

/** Type2, PostScript outlines */
static GType
bird_font_cff_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontCffTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_cff_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontCffTable), 0, (GInstanceInitFunc) bird_font_cff_table_instance_init, NULL };
	GType bird_font_cff_table_type_id;
	bird_font_cff_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontCffTable", &g_define_type_info, 0);
	BirdFontCffTable_private_offset = g_type_add_instance_private (bird_font_cff_table_type_id, sizeof (BirdFontCffTablePrivate));
	return bird_font_cff_table_type_id;
}

GType
bird_font_cff_table_get_type (void)
{
	static volatile gsize bird_font_cff_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_cff_table_type_id__once)) {
		GType bird_font_cff_table_type_id;
		bird_font_cff_table_type_id = bird_font_cff_table_get_type_once ();
		g_once_init_leave (&bird_font_cff_table_type_id__once, bird_font_cff_table_type_id);
	}
	return bird_font_cff_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

