/* Button.c generated by valac 0.56.16, the Vala compiler
 * generated from Button.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_BUTTON_0_PROPERTY,
	BIRD_FONT_BUTTON_NUM_PROPERTIES
};
static GParamSpec* bird_font_button_properties[BIRD_FONT_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BIRD_FONT_BUTTON_ACTION_SIGNAL,
	BIRD_FONT_BUTTON_NUM_SIGNALS
};
static guint bird_font_button_signals[BIRD_FONT_BUTTON_NUM_SIGNALS] = {0};

struct _BirdFontButtonPrivate {
	BirdFontText* label;
	gdouble padding;
	gdouble font_size;
};

static gint BirdFontButton_private_offset;
static gpointer bird_font_button_parent_class = NULL;

static void bird_font_button_real_draw (BirdFontWidget* base,
                                 cairo_t* cr);
static gdouble bird_font_button_real_get_height (BirdFontWidget* base);
static gdouble bird_font_button_real_get_width (BirdFontWidget* base);
static void bird_font_button_real_button_release (BirdFontWidget* base,
                                           guint button,
                                           gdouble x,
                                           gdouble y);
static void bird_font_button_finalize (GObject * obj);
static GType bird_font_button_get_type_once (void);

static inline gpointer
bird_font_button_get_instance_private (BirdFontButton* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontButton_private_offset);
}

BirdFontButton*
bird_font_button_construct (GType object_type,
                            const gchar* label,
                            gdouble margin_bottom)
{
	BirdFontButton * self = NULL;
	BirdFontText* _tmp0_;
	g_return_val_if_fail (label != NULL, NULL);
	self = (BirdFontButton*) bird_font_widget_construct (object_type);
	((BirdFontWidget*) self)->margin_bottom = margin_bottom;
	self->priv->font_size = (gdouble) 17;
	_tmp0_ = bird_font_text_new (label, self->priv->font_size, (gdouble) 0);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp0_;
	self->priv->padding = (gdouble) 15;
	return self;
}

BirdFontButton*
bird_font_button_new (const gchar* label,
                      gdouble margin_bottom)
{
	return bird_font_button_construct (BIRD_FONT_TYPE_BUTTON, label, margin_bottom);
}

static void
bird_font_button_real_draw (BirdFontWidget* base,
                            cairo_t* cr)
{
	BirdFontButton * self;
	BirdFontText* _tmp0_;
	BirdFontText* _tmp1_;
	self = (BirdFontButton*) base;
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	bird_font_theme_color (cr, "Button Background 3");
	bird_font_widget_draw_rounded_rectangle (cr, ((BirdFontWidget*) self)->widget_x, ((BirdFontWidget*) self)->widget_y, bird_font_widget_get_width ((BirdFontWidget*) self), self->priv->padding, self->priv->padding);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	bird_font_theme_color (cr, "Button Border 3");
	cairo_set_line_width (cr, (gdouble) 1);
	bird_font_widget_draw_rounded_rectangle (cr, ((BirdFontWidget*) self)->widget_x, ((BirdFontWidget*) self)->widget_y, bird_font_widget_get_width ((BirdFontWidget*) self), self->priv->padding, self->priv->padding);
	cairo_stroke (cr);
	cairo_restore (cr);
	cairo_save (cr);
	_tmp0_ = self->priv->label;
	bird_font_theme_text_color (_tmp0_, "Button Foreground");
	_tmp1_ = self->priv->label;
	bird_font_text_draw_at_top (_tmp1_, cr, ((BirdFontWidget*) self)->widget_x + self->priv->padding, ((BirdFontWidget*) self)->widget_y + ((((2 * self->priv->padding) - self->priv->font_size) - 3) / 2.0), "");
	cairo_restore (cr);
}

static gdouble
bird_font_button_real_get_height (BirdFontWidget* base)
{
	BirdFontButton * self;
	gdouble result;
	self = (BirdFontButton*) base;
	result = 2 * self->priv->padding;
	return result;
}

static gdouble
bird_font_button_real_get_width (BirdFontWidget* base)
{
	BirdFontButton * self;
	BirdFontText* _tmp0_;
	gdouble result;
	self = (BirdFontButton*) base;
	_tmp0_ = self->priv->label;
	result = bird_font_widget_get_width ((BirdFontWidget*) _tmp0_) + (2 * self->priv->padding);
	return result;
}

static void
bird_font_button_real_button_release (BirdFontWidget* base,
                                      guint button,
                                      gdouble x,
                                      gdouble y)
{
	BirdFontButton * self;
	self = (BirdFontButton*) base;
	if (bird_font_widget_is_over ((BirdFontWidget*) self, x, y)) {
		g_signal_emit (self, bird_font_button_signals[BIRD_FONT_BUTTON_ACTION_SIGNAL], 0);
	}
}

static void
bird_font_button_class_init (BirdFontButtonClass * klass,
                             gpointer klass_data)
{
	bird_font_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontButton_private_offset);
	((BirdFontWidgetClass *) klass)->draw = (void (*) (BirdFontWidget*, cairo_t*)) bird_font_button_real_draw;
	((BirdFontWidgetClass *) klass)->get_height = (gdouble (*) (BirdFontWidget*)) bird_font_button_real_get_height;
	((BirdFontWidgetClass *) klass)->get_width = (gdouble (*) (BirdFontWidget*)) bird_font_button_real_get_width;
	((BirdFontWidgetClass *) klass)->button_release = (void (*) (BirdFontWidget*, guint, gdouble, gdouble)) bird_font_button_real_button_release;
	G_OBJECT_CLASS (klass)->finalize = bird_font_button_finalize;
	bird_font_button_signals[BIRD_FONT_BUTTON_ACTION_SIGNAL] = g_signal_new ("action", BIRD_FONT_TYPE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bird_font_button_instance_init (BirdFontButton * self,
                                gpointer klass)
{
	self->priv = bird_font_button_get_instance_private (self);
}

static void
bird_font_button_finalize (GObject * obj)
{
	BirdFontButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_BUTTON, BirdFontButton);
	_g_object_unref0 (self->priv->label);
	G_OBJECT_CLASS (bird_font_button_parent_class)->finalize (obj);
}

static GType
bird_font_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontButton), 0, (GInstanceInitFunc) bird_font_button_instance_init, NULL };
	GType bird_font_button_type_id;
	bird_font_button_type_id = g_type_register_static (BIRD_FONT_TYPE_WIDGET, "BirdFontButton", &g_define_type_info, 0);
	BirdFontButton_private_offset = g_type_add_instance_private (bird_font_button_type_id, sizeof (BirdFontButtonPrivate));
	return bird_font_button_type_id;
}

GType
bird_font_button_get_type (void)
{
	static volatile gsize bird_font_button_type_id__once = 0;
	if (g_once_init_enter (&bird_font_button_type_id__once)) {
		GType bird_font_button_type_id;
		bird_font_button_type_id = bird_font_button_get_type_once ();
		g_once_init_leave (&bird_font_button_type_id__once, bird_font_button_type_id);
	}
	return bird_font_button_type_id__once;
}

