/* BirdFont.c generated by valac 0.56.16, the Vala compiler
 * generated from BirdFont.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 3 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdio.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define BIRD_FONT_VERSION "2.33.5"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define BIRD_FONT_TYPE_TEST_BIRD_FONT (bird_font_test_bird_font_get_type ())
#define BIRD_FONT_TEST_BIRD_FONT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_TEST_BIRD_FONT, BirdFontTestBirdFont))
#define BIRD_FONT_TEST_BIRD_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_TEST_BIRD_FONT, BirdFontTestBirdFontClass))
#define BIRD_FONT_IS_TEST_BIRD_FONT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_TEST_BIRD_FONT))
#define BIRD_FONT_IS_TEST_BIRD_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_TEST_BIRD_FONT))
#define BIRD_FONT_TEST_BIRD_FONT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_TEST_BIRD_FONT, BirdFontTestBirdFontClass))

typedef struct _BirdFontTestBirdFont BirdFontTestBirdFont;
typedef struct _BirdFontTestBirdFontClass BirdFontTestBirdFontClass;
typedef struct _BirdFontTestBirdFontPrivate BirdFontTestBirdFontPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BirdFontParamSpecBirdFont BirdFontParamSpecBirdFont;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontTestBirdFont {
	GObject parent_instance;
	BirdFontTestBirdFontPrivate * priv;
	gchar* test_cases_to_run;
};

struct _BirdFontTestBirdFontClass {
	GObjectClass parent_class;
};

struct _BirdFontParamSpecBirdFont {
	GParamSpec parent_instance;
};

gchar* bird_font_settings_directory = NULL;
VALA_EXTERN gboolean bird_font_bird_font_logging;
GRecMutex __lock_bird_font_bird_font_bird_font_bird_font_logging = {0};
static gpointer bird_font_bird_font_parent_class = NULL;
BirdFontArgument* bird_font_bird_font_args = NULL;
gboolean bird_font_bird_font_experimental = FALSE;
gboolean bird_font_bird_font_show_coordinates = FALSE;
gboolean bird_font_bird_font_fatal_wanings = FALSE;
gboolean bird_font_bird_font_win32 = FALSE;
gboolean bird_font_bird_font_mac = FALSE;
gboolean bird_font_bird_font_android = FALSE;
gchar* bird_font_bird_font_exec_path = NULL;
gchar* bird_font_bird_font_bundle_path = NULL;
gboolean bird_font_bird_font_logging = FALSE;
GDataOutputStream* bird_font_bird_font_logstream = NULL;
BirdFontFont* bird_font_bird_font_current_font = NULL;
BirdFontGlyphCollection* bird_font_bird_font_current_glyph_collection = NULL;
gchar* bird_font_bird_font_settings_subdirectory = NULL;
gchar* bird_font_bird_font_sandbox_directory = NULL;

VALA_EXTERN gchar* bird_font_build_absoulute_path (const gchar* file_name);
VALA_EXTERN void bird_font_init_logfile (void);
VALA_EXTERN void bird_font_bird_font_fatal_warning (const gchar* log_domain,
                                        GLogLevelFlags log_levels,
                                        const gchar* message);
static void _bird_font_bird_font_fatal_warning_glog_func (const gchar* log_domain,
                                                   GLogLevelFlags log_levels,
                                                   const gchar* message,
                                                   gpointer self);
VALA_EXTERN GType bird_font_test_bird_font_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BirdFontTestBirdFont* bird_font_test_bird_font_get_singleton (void);
VALA_EXTERN void bird_font_test_bird_font_run_tests (void);
VALA_EXTERN GFile* bird_font_bird_font_get_settings_directory (void);
VALA_EXTERN gchar* bird_font_bird_font_get_argument (const gchar* param);
static void bird_font_bird_font_finalize (BirdFontBirdFont * obj);
static GType bird_font_bird_font_get_type_once (void);
VALA_EXTERN void bird_font_log_warning (const gchar* log_domain,
                            GLogLevelFlags log_levels,
                            const gchar* message);
static void _bird_font_log_warning_glog_func (const gchar* log_domain,
                                       GLogLevelFlags log_levels,
                                       const gchar* message,
                                       gpointer self);

gchar*
bird_font_build_absoulute_path (const gchar* file_name)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (file_name != NULL, NULL);
	_tmp0_ = g_file_new_for_path (file_name);
	f = _tmp0_;
	_tmp1_ = g_file_get_path (f);
	result = (gchar*) _tmp1_;
	_g_object_unref0 (f);
	return result;
}

gchar*
bird_font_get_version (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (BIRD_FONT_VERSION);
	result = _tmp0_;
	return result;
}

gchar*
bird_font_get_os (void)
{
	gchar* result;
	if (bird_font_bird_font_win32) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("windows");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("*nix");
		result = _tmp1_;
		return result;
	}
}

void
bird_font_set_logging (gboolean log)
{
	bird_font_bird_font_logging = log;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
bird_font_wine_to_unix_path (const gchar* exec_path)
{
	gboolean drive_c = FALSE;
	gboolean drive_z = FALSE;
	gint i = 0;
	gchar* p = NULL;
	gchar* q = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp21_;
	gchar* result;
	g_return_val_if_fail (exec_path != NULL, NULL);
	_tmp0_ = g_strdup (exec_path);
	_g_free0 (p);
	p = _tmp0_;
	_tmp1_ = p;
	_tmp2_ = string_replace (_tmp1_, "\\", "/");
	_g_free0 (p);
	p = _tmp2_;
	drive_c = string_index_of (exec_path, "C:", 0) == 0;
	drive_z = string_index_of (exec_path, "Z:", 0) == 0;
	_tmp3_ = p;
	i = string_index_of (_tmp3_, ":", 0);
	if (i != -1) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = p;
		_tmp5_ = string_substring (_tmp4_, (glong) (i + 2), (glong) -1);
		_g_free0 (p);
		p = _tmp5_;
	}
	if (drive_c) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		gboolean _tmp15_;
		_tmp6_ = g_get_user_name ();
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("/home/", _tmp7_, "/.wine/drive_c/", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = p;
		_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
		_g_free0 (q);
		q = _tmp11_;
		_g_free0 (_tmp9_);
		_tmp12_ = q;
		_tmp13_ = g_file_new_for_path (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_query_exists (_tmp14_, NULL);
		_g_object_unref0 (_tmp14_);
		if (_tmp15_) {
			result = q;
			_g_free0 (p);
			return result;
		} else {
			result = p;
			_g_free0 (q);
			return result;
		}
	}
	if (drive_z) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = p;
		_tmp17_ = g_strconcat ("/", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		result = _tmp20_;
		_g_free0 (q);
		_g_free0 (p);
		return result;
	}
	_tmp21_ = g_strdup (exec_path);
	result = _tmp21_;
	_g_free0 (q);
	_g_free0 (p);
	return result;
}

gboolean
bird_font_is_null (void* n)
{
	gboolean result;
	result = n == NULL;
	return result;
}

gboolean
bird_font_has_flag (guint32 flag,
                    guint32 mask)
{
	gboolean result;
	result = (flag & mask) > ((guint32) 0);
	return result;
}

BirdFontBirdFont*
bird_font_bird_font_construct (GType object_type)
{
	BirdFontBirdFont* self = NULL;
	self = (BirdFontBirdFont*) g_type_create_instance (object_type);
	return self;
}

BirdFontBirdFont*
bird_font_bird_font_new (void)
{
	return bird_font_bird_font_construct (BIRD_FONT_TYPE_BIRD_FONT);
}

/**
 * @param arg command line arguments
 * @param program path
 * @param setting subdirectory
 */
static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_bird_font_bird_font_fatal_warning_glog_func (const gchar* log_domain,
                                              GLogLevelFlags log_levels,
                                              const gchar* message,
                                              gpointer self)
{
	bird_font_bird_font_fatal_warning (log_domain, log_levels, message);
}

void
bird_font_bird_font_init (BirdFontBirdFont* self,
                          gchar** arg,
                          gint arg_length1,
                          const gchar* program_path,
                          const gchar* settings_subdir,
                          const gchar* sandbox_path)
{
	gint i = 0;
	GFile* font_file = NULL;
	gchar* exec_path = NULL;
	gchar* theme = NULL;
	gint default_theme_version = 0;
	gchar* theme_version = NULL;
	BirdFontCharDatabaseParser* parser = NULL;
	BirdFontCodePageBits* codepage_bits = NULL;
	gchar* _tmp0_;
	BirdFontArgument* _tmp1_;
	BirdFontFont* _tmp2_;
	FILE* _tmp3_;
	BirdFontArgument* _tmp4_;
	BirdFontArgument* _tmp6_;
	BirdFontArgument* _tmp7_;
	gint err_arg = 0;
	BirdFontArgument* _tmp9_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	BirdFontFont* _tmp25_;
	BirdFontFont* _tmp26_;
	BirdFontFont* _tmp27_;
	BirdFontGlyphCollection* _tmp28_;
	BirdFontArgument* _tmp29_;
	gboolean _tmp30_ = FALSE;
	BirdFontArgument* _tmp31_;
	BirdFontArgument* _tmp32_;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	const gchar* _tmp35_;
	BirdFontArgument* _tmp38_;
	BirdFontArgument* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gboolean _tmp52_;
	BirdFontFont* _tmp65_;
	BirdFontFont* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	BirdFontTestBirdFont* _tmp71_;
	BirdFontTestBirdFont* _tmp72_;
	const gchar* _tmp73_;
	gboolean _tmp74_;
	g_return_if_fail (self != NULL);
	bird_font_bird_font_set_settings_subdir (settings_subdir);
	_tmp0_ = g_strdup (sandbox_path);
	_g_free0 (bird_font_bird_font_sandbox_directory);
	bird_font_bird_font_sandbox_directory = _tmp0_;
	_tmp1_ = bird_font_argument_new_command_line (arg, arg_length1);
	_g_object_unref0 (bird_font_bird_font_args);
	bird_font_bird_font_args = _tmp1_;
	_tmp2_ = bird_font_font_new ();
	_g_object_unref0 (bird_font_font_empty);
	bird_font_font_empty = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "birdfont version %s\n", BIRD_FONT_VERSION);
	_tmp4_ = bird_font_bird_font_args;
	bird_font_bird_font_android = bird_font_argument_has_argument (_tmp4_, "--android");
	if (!bird_font_bird_font_logging) {
		BirdFontArgument* _tmp5_;
		_tmp5_ = bird_font_bird_font_args;
		bird_font_bird_font_logging = bird_font_argument_has_argument (_tmp5_, "--log");
	}
	if (bird_font_bird_font_logging) {
		bird_font_init_logfile ();
	}
	_tmp6_ = bird_font_bird_font_args;
	if (!bird_font_argument_has_argument (_tmp6_, "--no-translation")) {
		bird_font_bird_font_init_gettext ();
	}
	_tmp7_ = bird_font_bird_font_args;
	if (bird_font_argument_has_argument (_tmp7_, "--help")) {
		BirdFontArgument* _tmp8_;
		_tmp8_ = bird_font_bird_font_args;
		bird_font_argument_print_help (_tmp8_);
		exit (0);
	}
	_tmp9_ = bird_font_bird_font_args;
	err_arg = bird_font_argument_validate (_tmp9_);
	if (err_arg != 0) {
		FILE* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		BirdFontArgument* _tmp15_;
		_tmp10_ = stdout;
		_tmp11_ = arg[err_arg];
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = g_strconcat ("Unknown parameter ", _tmp12_, "\n\n", NULL);
		_tmp14_ = _tmp13_;
		fprintf (_tmp10_, "%s", _tmp14_);
		_g_free0 (_tmp14_);
		_tmp15_ = bird_font_bird_font_args;
		bird_font_argument_print_help (_tmp15_);
		exit (0);
	}
	bird_font_preferences_load ();
	default_theme_version = 1;
	_tmp16_ = bird_font_preferences_get ("theme");
	_g_free0 (theme);
	theme = _tmp16_;
	_tmp17_ = bird_font_preferences_get ("theme_version");
	_g_free0 (theme_version);
	theme_version = _tmp17_;
	bird_font_theme_set_default_colors ();
	_tmp19_ = theme_version;
	if (g_strcmp0 (_tmp19_, "") == 0) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = theme_version;
		_tmp18_ = atoi (_tmp20_) < default_theme_version;
	}
	if (_tmp18_) {
		bird_font_theme_load_theme ("dark.theme");
		bird_font_preferences_set ("theme", "dark.theme");
	} else {
		const gchar* _tmp21_;
		_tmp21_ = theme;
		if (g_strcmp0 (_tmp21_, "") != 0) {
			const gchar* _tmp22_;
			_tmp22_ = theme;
			bird_font_theme_load_theme (_tmp22_);
		} else {
			bird_font_theme_load_theme ("dark.theme");
		}
	}
	_tmp23_ = g_strdup_printf ("%i", default_theme_version);
	_tmp24_ = _tmp23_;
	bird_font_preferences_set ("theme_version", _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = bird_font_font_new ();
	_g_object_unref0 (bird_font_bird_font_current_font);
	bird_font_bird_font_current_font = _tmp25_;
	_tmp26_ = bird_font_bird_font_current_font;
	bird_font_font_set_name (_tmp26_, "");
	_tmp27_ = bird_font_bird_font_current_font;
	_tmp27_->initialised = FALSE;
	_tmp28_ = bird_font_glyph_collection_new_with_glyph ((gunichar) '\0', "");
	_g_object_unref0 (bird_font_bird_font_current_glyph_collection);
	bird_font_bird_font_current_glyph_collection = _tmp28_;
	_tmp29_ = bird_font_bird_font_args;
	bird_font_bird_font_experimental = bird_font_argument_has_argument (_tmp29_, "--test");
	_tmp31_ = bird_font_bird_font_args;
	if (bird_font_argument_has_argument (_tmp31_, "--show-coordinates")) {
		_tmp30_ = TRUE;
	} else {
		_tmp30_ = bird_font_bird_font_experimental;
	}
	bird_font_bird_font_show_coordinates = _tmp30_;
	_tmp32_ = bird_font_bird_font_args;
	bird_font_bird_font_fatal_wanings = bird_font_argument_has_argument (_tmp32_, "--fatal-warning");
	_tmp35_ = arg[0];
	if (string_index_of (_tmp35_, ".exe", 0) > -1) {
		_tmp34_ = TRUE;
	} else {
		const gchar* _tmp36_;
		_tmp36_ = arg[0];
		_tmp34_ = g_strcmp0 (_tmp36_, "wine") == 0;
	}
	if (_tmp34_) {
		_tmp33_ = TRUE;
	} else {
		BirdFontArgument* _tmp37_;
		_tmp37_ = bird_font_bird_font_args;
		_tmp33_ = bird_font_argument_has_argument (_tmp37_, "--windows");
	}
	bird_font_bird_font_win32 = _tmp33_;
	_tmp38_ = bird_font_bird_font_args;
	bird_font_bird_font_mac = bird_font_argument_has_argument (_tmp38_, "--mac");
	if (program_path == NULL) {
		gchar* _tmp39_;
		_tmp39_ = g_strdup ("");
		_g_free0 (exec_path);
		exec_path = _tmp39_;
		if (bird_font_bird_font_win32) {
			const gchar* _tmp40_;
			_tmp40_ = arg[0];
			i = string_last_index_of (_tmp40_, "\\", 0);
			if (i != -1) {
				const gchar* _tmp41_;
				gchar* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				_tmp41_ = arg[0];
				_tmp42_ = g_strdup (_tmp41_);
				_g_free0 (exec_path);
				exec_path = _tmp42_;
				_tmp43_ = exec_path;
				_tmp44_ = string_substring (_tmp43_, (glong) 0, (glong) i);
				_g_free0 (exec_path);
				exec_path = _tmp44_;
				_tmp45_ = exec_path;
				_tmp46_ = bird_font_wine_to_unix_path (_tmp45_);
				_g_free0 (exec_path);
				exec_path = _tmp46_;
			}
		} else {
			gchar* _tmp47_;
			_tmp47_ = g_strdup ("./");
			_g_free0 (exec_path);
			exec_path = _tmp47_;
		}
	} else {
		gchar* _tmp48_;
		_tmp48_ = g_strdup ((const gchar*) program_path);
		_g_free0 (exec_path);
		exec_path = _tmp48_;
	}
	_tmp49_ = bird_font_bird_font_args;
	_tmp50_ = bird_font_argument_get_file (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strcmp0 (_tmp51_, "") != 0;
	_g_free0 (_tmp51_);
	if (_tmp52_) {
		BirdFontArgument* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		GFile* _tmp56_;
		GFile* _tmp57_;
		_tmp53_ = bird_font_bird_font_args;
		_tmp54_ = bird_font_argument_get_file (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_file_new_for_path (_tmp55_);
		_g_object_unref0 (font_file);
		font_file = _tmp56_;
		_g_free0 (_tmp55_);
		_tmp57_ = font_file;
		if (!g_file_query_exists (_tmp57_, NULL)) {
			FILE* _tmp58_;
			BirdFontArgument* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			const gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			_tmp58_ = stderr;
			_tmp59_ = bird_font_bird_font_args;
			_tmp60_ = bird_font_argument_get_file (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = string_to_string (_tmp61_);
			_tmp63_ = g_strconcat ("The file \"", _tmp62_, "\" was not found.\n", NULL);
			_tmp64_ = _tmp63_;
			fprintf (_tmp58_, "%s", _tmp64_);
			_g_free0 (_tmp64_);
			_g_free0 (_tmp61_);
			exit (-1);
		}
	}
	if (bird_font_bird_font_fatal_wanings) {
		GLogLevelFlags levels = 0U;
		levels = (G_LOG_LEVEL_ERROR | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_WARNING;
		g_log_set_handler (NULL, levels, _bird_font_bird_font_fatal_warning_glog_func, NULL);
	}
	_tmp65_ = bird_font_bird_font_get_current_font ();
	_tmp66_ = _tmp65_;
	_tmp67_ = bird_font_font_get_path (_tmp66_);
	_tmp68_ = _tmp67_;
	bird_font_preferences_set_last_file (_tmp68_);
	_g_free0 (_tmp68_);
	_g_object_unref0 (_tmp66_);
	bird_font_default_character_set_create_default_character_sets ();
	_tmp69_ = bird_font_default_character_set_get_characters_for_prefered_language ();
	_tmp70_ = _tmp69_;
	_g_free0 (_tmp70_);
	bird_font_head_table_init (1024);
	_tmp71_ = bird_font_test_bird_font_get_singleton ();
	_tmp72_ = _tmp71_;
	_tmp73_ = _tmp72_->test_cases_to_run;
	_tmp74_ = g_strcmp0 (_tmp73_, "All") != 0;
	_g_object_unref0 (_tmp72_);
	if (_tmp74_) {
		bird_font_test_bird_font_run_tests ();
	}
	if (bird_font_bird_font_has_argument ("--parse-ucd")) {
		BirdFontCharDatabaseParser* _tmp75_;
		BirdFontCharDatabaseParser* _tmp76_;
		_tmp75_ = bird_font_char_database_parser_new ();
		_g_object_unref0 (parser);
		parser = _tmp75_;
		_tmp76_ = parser;
		bird_font_char_database_parser_regenerate_database (_tmp76_);
	}
	if (bird_font_bird_font_has_argument ("--codepages")) {
		BirdFontCodePageBits* _tmp77_;
		BirdFontCodePageBits* _tmp78_;
		_tmp77_ = bird_font_code_page_bits_new ();
		_g_object_unref0 (codepage_bits);
		codepage_bits = _tmp77_;
		_tmp78_ = codepage_bits;
		bird_font_code_page_bits_generate_codepage_database (_tmp78_);
	}
	bird_font_export_tool_generate_html_template ();
	_g_object_unref0 (codepage_bits);
	_g_object_unref0 (parser);
	_g_free0 (theme_version);
	_g_free0 (theme);
	_g_free0 (exec_path);
	_g_object_unref0 (font_file);
}

gboolean
bird_font_bird_font_has_logging (void)
{
	gboolean log = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		g_rec_mutex_lock (&__lock_bird_font_bird_font_bird_font_bird_font_logging);
		{
			log = bird_font_bird_font_logging;
		}
		__finally0:
		{
			g_rec_mutex_unlock (&__lock_bird_font_bird_font_bird_font_bird_font_logging);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp0_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp0_;
		}
	}
	result = log;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontArgument*
bird_font_bird_font_get_arguments (void)
{
	BirdFontArgument* _tmp0_;
	BirdFontArgument* _tmp1_;
	BirdFontArgument* result;
	_tmp0_ = bird_font_bird_font_args;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
bird_font_bird_font_set_bundle_path (const gchar* path)
{
	gchar* _tmp0_;
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup (path);
	_g_free0 (bird_font_bird_font_bundle_path);
	bird_font_bird_font_bundle_path = _tmp0_;
}

void
bird_font_bird_font_init_gettext (void)
{
	gchar* locale_directory = NULL;
	gchar* _tmp0_;
	_tmp0_ = bird_font_search_paths_get_locale_directory ();
	locale_directory = _tmp0_;
	setlocale (LC_MESSAGES, "");
	bind_textdomain_codeset (GETTEXT_PACKAGE, "utf-8");
	bindtextdomain (GETTEXT_PACKAGE, locale_directory);
	_g_free0 (locale_directory);
}

void
bird_font_bird_font_load_font_from_command_line (BirdFontBirdFont* self)
{
	gchar* file = NULL;
	BirdFontArgument* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_args;
	_tmp1_ = bird_font_argument_get_file (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = file;
		bird_font_recent_files_load_font (_tmp3_);
	}
	_g_free0 (file);
}

BirdFontFont*
bird_font_bird_font_get_current_font (void)
{
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontFont* result;
	_tmp0_ = bird_font_bird_font_current_font;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
bird_font_bird_font_fatal_warning (const gchar* log_domain,
                                   GLogLevelFlags log_levels,
                                   const gchar* message)
{
	gboolean fatal = FALSE;
	FILE* _tmp1_;
	g_return_if_fail (message != NULL);
	fatal = TRUE;
	if (log_domain != NULL) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "%s: \n", (const gchar*) log_domain);
	}
	_tmp1_ = stderr;
	fprintf (_tmp1_, "\n%s\n\n", message);
	_vala_assert (!fatal, "!fatal");
}

BirdFontFont*
bird_font_bird_font_new_font (void)
{
	BirdFontFont* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontBackgroundTools* _tmp10_;
	BirdFontFont* _tmp12_;
	BirdFontFont* _tmp13_;
	BirdFontFont* result;
	_tmp0_ = bird_font_font_new ();
	_g_object_unref0 (bird_font_bird_font_current_font);
	bird_font_bird_font_current_font = _tmp0_;
	_tmp1_ = bird_font_main_window_tools;
	if (!bird_font_is_null (_tmp1_)) {
		BirdFontDrawingTools* _tmp2_;
		BirdFontDrawingTools* _tmp3_;
		BirdFontSpinButton* _tmp4_;
		BirdFontSpinButton* _tmp5_;
		BirdFontSpinButton* _tmp6_;
		BirdFontSpinButton* _tmp7_;
		BirdFontSpinButton* _tmp8_;
		BirdFontSpinButton* _tmp9_;
		_tmp2_ = bird_font_main_window_get_drawing_tools ();
		_tmp3_ = _tmp2_;
		bird_font_drawing_tools_remove_all_grid_buttons (_tmp3_);
		_g_object_unref0 (_tmp3_);
		_tmp4_ = bird_font_drawing_tools_add_new_grid ((gdouble) 1, FALSE);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp5_);
		_tmp6_ = bird_font_drawing_tools_add_new_grid ((gdouble) 2, FALSE);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		_tmp8_ = bird_font_drawing_tools_add_new_grid ((gdouble) 4, FALSE);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp9_);
	}
	_tmp10_ = bird_font_toolbox_background_tools;
	if (!bird_font_is_null (_tmp10_)) {
		BirdFontBackgroundTools* _tmp11_;
		_tmp11_ = bird_font_toolbox_background_tools;
		bird_font_background_tools_remove_images (_tmp11_);
	}
	bird_font_kerning_tools_update_kerning_classes ();
	_tmp12_ = bird_font_bird_font_current_font;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	result = _tmp13_;
	return result;
}

gchar*
bird_font_bird_font_get_sandbox_directory (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = bird_font_bird_font_sandbox_directory;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
bird_font_bird_font_set_settings_directory (const gchar* directory)
{
	gchar* _tmp0_;
	g_return_if_fail (directory != NULL);
	_tmp0_ = g_strdup (directory);
	_g_free0 (bird_font_bird_font_settings_subdirectory);
	bird_font_bird_font_settings_subdirectory = _tmp0_;
}

GFile*
bird_font_bird_font_get_preview_directory (void)
{
	gchar* export = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* e = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* p = NULL;
	GFile* _tmp8_;
	GFile* result;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_font_get_export_directory (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	export = _tmp3_;
	_tmp4_ = export;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		g_warning ("BirdFont.vala:356: No export directory is set.");
		_tmp5_ = g_strdup ("");
		_g_free0 (export);
		export = _tmp5_;
	}
	_tmp6_ = export;
	_tmp7_ = g_file_new_for_path ((const gchar*) _tmp6_);
	e = _tmp7_;
	_tmp8_ = bird_font_get_child (e, "preview");
	p = _tmp8_;
	result = p;
	_g_object_unref0 (e);
	_g_free0 (export);
	return result;
}

void
bird_font_bird_font_set_settings_subdir (const gchar* subdir)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (subdir);
	_g_free0 (bird_font_bird_font_settings_subdirectory);
	bird_font_bird_font_settings_subdirectory = _tmp0_;
}

GFile*
bird_font_bird_font_get_settings_directory (void)
{
	gchar* home_path = NULL;
	GFile* home = NULL;
	GFile* settings = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp12_;
	GFile* _tmp18_;
	GFile* result;
	_tmp0_ = bird_font_bird_font_sandbox_directory;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		GFile* _tmp2_;
		_tmp1_ = bird_font_bird_font_sandbox_directory;
		_tmp2_ = g_file_new_for_path ((const gchar*) _tmp1_);
		_g_object_unref0 (home);
		home = _tmp2_;
	} else {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp10_;
		GFile* _tmp11_;
		_tmp4_ = bird_font_settings_directory;
		if (_tmp4_ != NULL) {
			const gchar* _tmp5_;
			_tmp5_ = bird_font_settings_directory;
			_tmp3_ = (const gchar*) _tmp5_;
		} else {
			const gchar* _tmp6_;
			_tmp6_ = g_get_user_config_dir ();
			_tmp3_ = _tmp6_;
		}
		_tmp7_ = g_strdup (_tmp3_);
		_g_free0 (home_path);
		home_path = _tmp7_;
		_tmp8_ = home_path;
		if (bird_font_is_null (_tmp8_)) {
			gchar* _tmp9_;
			g_warning ("BirdFont.vala:391: No home directory set.");
			_tmp9_ = g_strdup (".");
			_g_free0 (home_path);
			home_path = _tmp9_;
		}
		_tmp10_ = home_path;
		_tmp11_ = g_file_new_for_path (_tmp10_);
		_g_object_unref0 (home);
		home = _tmp11_;
	}
	_tmp12_ = bird_font_bird_font_settings_subdirectory;
	if (_tmp12_ != NULL) {
		GFile* _tmp13_;
		const gchar* _tmp14_;
		GFile* _tmp15_;
		_tmp13_ = home;
		_tmp14_ = bird_font_bird_font_settings_subdirectory;
		_tmp15_ = bird_font_get_child (_tmp13_, (const gchar*) _tmp14_);
		_g_object_unref0 (settings);
		settings = _tmp15_;
	} else {
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp16_ = home;
		_tmp17_ = bird_font_get_child (_tmp16_, "birdfont");
		_g_object_unref0 (settings);
		settings = _tmp17_;
	}
	_tmp18_ = settings;
	if (!g_file_query_exists (_tmp18_, NULL)) {
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp19_ = settings;
		_tmp20_ = g_file_get_path (_tmp19_);
		_tmp21_ = (gchar*) _tmp20_;
		g_mkdir (_tmp21_, 0755);
		_g_free0 (_tmp21_);
	}
	result = settings;
	_g_object_unref0 (home);
	_g_free0 (home_path);
	return result;
}

gboolean
bird_font_bird_font_has_argument (const gchar* param)
{
	BirdFontArgument* _tmp0_;
	BirdFontArgument* _tmp1_;
	gboolean result;
	g_return_val_if_fail (param != NULL, FALSE);
	_tmp0_ = bird_font_bird_font_args;
	if (bird_font_is_null (_tmp0_)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = bird_font_bird_font_args;
	result = bird_font_argument_has_argument (_tmp1_, param);
	return result;
}

gchar*
bird_font_bird_font_get_argument (const gchar* param)
{
	BirdFontArgument* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (param != NULL, NULL);
	_tmp0_ = bird_font_bird_font_args;
	_tmp1_ = bird_font_argument_get_argument (_tmp0_, param);
	result = _tmp1_;
	return result;
}

void
bird_font_bird_font_debug_message (const gchar* s)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (s != NULL);
	if (G_UNLIKELY (bird_font_bird_font_has_logging ())) {
		{
			GDataOutputStream* _tmp0_;
			FILE* _tmp3_;
			_tmp0_ = bird_font_bird_font_logstream;
			if (_tmp0_ != NULL) {
				GDataOutputStream* _tmp1_;
				GDataOutputStream* _tmp2_;
				_tmp1_ = bird_font_bird_font_logstream;
				g_data_output_stream_put_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_data_output_stream_get_type (), GDataOutputStream), s, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp2_ = bird_font_bird_font_logstream;
				g_output_stream_flush ((GOutputStream*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_data_output_stream_get_type (), GDataOutputStream), NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			} else {
				g_warning ("BirdFont.vala:431: No logstream.");
			}
			_tmp3_ = stderr;
			fprintf (_tmp3_, "%s", s);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("BirdFont.vala:436: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
bird_font_value_bird_font_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_bird_font_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_bird_font_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_bird_font_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_bird_font_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_bird_font_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_bird_font_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontBirdFont * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_bird_font_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_bird_font_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	BirdFontBirdFont ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_bird_font_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_bird_font (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	BirdFontParamSpecBirdFont* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_BIRD_FONT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_bird_font (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_BIRD_FONT), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_bird_font (GValue* value,
                               gpointer v_object)
{
	BirdFontBirdFont * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_BIRD_FONT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_BIRD_FONT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_bird_font_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_bird_font_unref (old);
	}
}

void
bird_font_value_take_bird_font (GValue* value,
                                gpointer v_object)
{
	BirdFontBirdFont * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_BIRD_FONT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_BIRD_FONT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_bird_font_unref (old);
	}
}

static void
bird_font_bird_font_class_init (BirdFontBirdFontClass * klass,
                                gpointer klass_data)
{
	gchar* _tmp0_;
	bird_font_bird_font_parent_class = g_type_class_peek_parent (klass);
	((BirdFontBirdFontClass *) klass)->finalize = bird_font_bird_font_finalize;
	_tmp0_ = g_strdup ("");
	bird_font_bird_font_exec_path = _tmp0_;
	g_rec_mutex_init (&__lock_bird_font_bird_font_bird_font_bird_font_logging);
}

static void
bird_font_bird_font_instance_init (BirdFontBirdFont * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_bird_font_finalize (BirdFontBirdFont * obj)
{
	BirdFontBirdFont * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_BIRD_FONT, BirdFontBirdFont);
	g_signal_handlers_destroy (self);
}

static GType
bird_font_bird_font_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_bird_font_init, bird_font_value_bird_font_free_value, bird_font_value_bird_font_copy_value, bird_font_value_bird_font_peek_pointer, "p", bird_font_value_bird_font_collect_value, "p", bird_font_value_bird_font_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontBirdFontClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_bird_font_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontBirdFont), 0, (GInstanceInitFunc) bird_font_bird_font_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_bird_font_type_id;
	bird_font_bird_font_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontBirdFont", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_bird_font_type_id;
}

GType
bird_font_bird_font_get_type (void)
{
	static volatile gsize bird_font_bird_font_type_id__once = 0;
	if (g_once_init_enter (&bird_font_bird_font_type_id__once)) {
		GType bird_font_bird_font_type_id;
		bird_font_bird_font_type_id = bird_font_bird_font_get_type_once ();
		g_once_init_leave (&bird_font_bird_font_type_id__once, bird_font_bird_font_type_id);
	}
	return bird_font_bird_font_type_id__once;
}

gpointer
bird_font_bird_font_ref (gpointer instance)
{
	BirdFontBirdFont * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_bird_font_unref (gpointer instance)
{
	BirdFontBirdFont * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_BIRD_FONT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static void
_bird_font_log_warning_glog_func (const gchar* log_domain,
                                  GLogLevelFlags log_levels,
                                  const gchar* message,
                                  gpointer self)
{
	bird_font_log_warning (log_domain, log_levels, message);
}

void
bird_font_init_logfile (void)
{
	GDateTime* t = NULL;
	GFile* settings = NULL;
	gchar* s = NULL;
	GFile* log = NULL;
	GLogLevelFlags levels = 0U;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _inner_error0_ = NULL;
	{
		GDateTime* _tmp0_;
		GFile* _tmp1_;
		GDateTime* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GFile* _tmp11_;
		GFileOutputStream* _tmp12_ = NULL;
		GFile* _tmp13_;
		GFileOutputStream* _tmp14_;
		GDataOutputStream* _tmp15_;
		GDataOutputStream* _tmp16_;
		GFile* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GDataOutputStream* _tmp20_;
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp0_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (t);
		t = _tmp0_;
		_tmp1_ = bird_font_bird_font_get_settings_directory ();
		_g_object_unref0 (settings);
		settings = _tmp1_;
		_tmp2_ = t;
		_tmp3_ = g_date_time_to_string (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_replace (_tmp4_, ":", "_");
		_g_free0 (s);
		s = _tmp5_;
		_g_free0 (_tmp4_);
		_tmp6_ = settings;
		_tmp7_ = s;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat ("birdfont_", _tmp8_, ".log", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = bird_font_get_child (_tmp6_, _tmp10_);
		_g_object_unref0 (log);
		log = _tmp11_;
		_g_free0 (_tmp10_);
		_tmp13_ = log;
		_tmp14_ = g_file_create (_tmp13_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp15_ = g_data_output_stream_new ((GOutputStream*) _tmp12_);
		_g_object_unref0 (bird_font_bird_font_logstream);
		bird_font_bird_font_logstream = _tmp15_;
		_tmp16_ = bird_font_bird_font_logstream;
		_tmp17_ = log;
		_tmp18_ = g_file_get_path (_tmp17_);
		_tmp19_ = (gchar*) _tmp18_;
		g_data_output_stream_put_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_data_output_stream_get_type (), GDataOutputStream), _tmp19_, NULL, &_inner_error0_);
		_g_free0 (_tmp19_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp12_);
			goto __catch0_g_error;
		}
		_tmp20_ = bird_font_bird_font_logstream;
		g_data_output_stream_put_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_data_output_stream_get_type (), GDataOutputStream), "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp12_);
			goto __catch0_g_error;
		}
		_tmp21_ = log;
		_tmp22_ = g_file_get_path (_tmp21_);
		_tmp23_ = (gchar*) _tmp22_;
		_tmp24_ = g_strconcat ("Logging to ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		g_warning ("BirdFont.vala:458: %s", _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_object_unref0 (_tmp12_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		GFile* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_warning ("BirdFont.vala:460: %s", _tmp27_);
		_tmp28_ = log;
		_tmp29_ = g_file_get_path (_tmp28_);
		_tmp30_ = (gchar*) _tmp29_;
		g_warning ("BirdFont.vala:461: %s", _tmp30_);
		_g_free0 (_tmp30_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (log);
		_g_free0 (s);
		_g_object_unref0 (settings);
		_g_date_time_unref0 (t);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	levels = ((G_LOG_LEVEL_ERROR | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_WARNING) | G_LOG_LEVEL_DEBUG;
	g_log_set_handler (NULL, levels, _bird_font_log_warning_glog_func, NULL);
	bird_font_bird_font_logging = TRUE;
	_tmp31_ = string_to_string (BIRD_FONT_VERSION);
	_tmp32_ = g_strconcat ("Program version: ", _tmp31_, "\n", NULL);
	_tmp33_ = _tmp32_;
	bird_font_printd (_tmp33_);
	_g_free0 (_tmp33_);
	_g_object_unref0 (log);
	_g_free0 (s);
	_g_object_unref0 (settings);
	_g_date_time_unref0 (t);
}

void
bird_font_log_warning (const gchar* log_domain,
                       GLogLevelFlags log_levels,
                       const gchar* message)
{
	g_return_if_fail (message != NULL);
	if (log_domain != NULL) {
		bird_font_printd ((const gchar*) log_domain);
	}
	bird_font_printd ("\n");
	bird_font_printd (message);
	bird_font_printd ("\n");
	bird_font_printd ("\n");
}

/** Write debug output to logfile. */
void
bird_font_printd (const gchar* s)
{
	g_return_if_fail (s != NULL);
	bird_font_bird_font_debug_message (s);
}

/** Translate string */
gchar*
bird_font_t_ (const gchar* t)
{
	gchar* translate = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (t != NULL, NULL);
	_tmp0_ = bird_font_preferences_get ("translate");
	translate = _tmp0_;
	_tmp2_ = translate;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = translate;
		_tmp1_ = g_strcmp0 (_tmp3_, "true") == 0;
	}
	if (_tmp1_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_ (t));
		result = _tmp4_;
		_g_free0 (translate);
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (t);
		result = _tmp5_;
		_g_free0 (translate);
		return result;
	}
}

/** Translate mac menu items */
gchar*
bird_font_translate_mac (const gchar* t)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (t != NULL, NULL);
	_tmp0_ = bird_font_t_ (t);
	s = _tmp0_;
	_tmp1_ = string_replace (s, "_", "");
	result = _tmp1_;
	_g_free0 (s);
	return result;
}

/** Print a warning if Birdfont was started with the --test argument. */
void
bird_font_warn_if_test (const gchar* message)
{
	g_return_if_fail (message != NULL);
	if (bird_font_bird_font_has_argument ("--test")) {
		g_warning ("BirdFont.vala:516: %s", message);
	}
}

/** Obtain a handle to a file in a folder. */
GFile*
bird_font_get_child (GFile* folder,
                     const gchar* file_name)
{
	gchar* f = NULL;
	gchar* s = NULL;
	gchar* n = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	GFile* result;
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (file_name != NULL, NULL);
	_tmp0_ = g_file_get_path (folder);
	_g_free0 (f);
	f = (gchar*) _tmp0_;
	if (bird_font_bird_font_win32) {
		_tmp1_ = "\\";
	} else {
		_tmp1_ = "/";
	}
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (s);
	s = _tmp2_;
	_tmp3_ = g_strdup (file_name);
	_g_free0 (n);
	n = _tmp3_;
	if (bird_font_bird_font_win32) {
		_tmp4_ = string_index_of (file_name, "\\", 0) != -1;
	} else {
		_tmp4_ = FALSE;
	}
	if (G_UNLIKELY (_tmp4_)) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp5_ = string_to_string (file_name);
		_tmp6_ = f;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("File name contains path separator: ", _tmp5_, ", Directory: ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		g_warning ("BirdFont.vala:538: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = n;
		_tmp11_ = n;
		_tmp12_ = string_substring (_tmp10_, (glong) string_last_index_of (_tmp11_, "\\", 0), (glong) -1);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_replace (_tmp13_, "\\", "");
		_g_free0 (n);
		n = _tmp14_;
		_g_free0 (_tmp13_);
	}
	_tmp15_ = f;
	_tmp16_ = s;
	if (!g_str_has_suffix (_tmp15_, _tmp16_)) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = f;
		_tmp18_ = s;
		_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
		_g_free0 (f);
		f = _tmp19_;
	}
	_tmp20_ = f;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = n;
	_tmp23_ = string_to_string (_tmp22_);
	_tmp24_ = g_strconcat ("File in Directory: ", _tmp21_, " Name: ", _tmp23_, "\n", NULL);
	_tmp25_ = _tmp24_;
	bird_font_printd (_tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = f;
	_tmp27_ = n;
	_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_file_new_for_path (_tmp29_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	result = _tmp31_;
	_g_free0 (n);
	_g_free0 (s);
	_g_free0 (f);
	return result;
}

