/* BackupTab.c generated by valac 0.56.16, the Vala compiler
 * generated from BackupTab.vala, do not modify */

/*
Copyright (C) 2019 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib/gstdio.h>

#define BIRD_FONT_BACKUP_TAB_FONT_FOLDER -2
#define BIRD_FONT_BACKUP_TAB_FONT_FILE -1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_BACKUP_TAB_0_PROPERTY,
	BIRD_FONT_BACKUP_TAB_NUM_PROPERTIES
};
static GParamSpec* bird_font_backup_tab_properties[BIRD_FONT_BACKUP_TAB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BirdFontBackupTabPrivate {
	GeeArrayList* rows;
	BirdFontBackupDir* backup_folder;
};

static gint BirdFontBackupTab_private_offset;
static gpointer bird_font_backup_tab_parent_class = NULL;

static GeeArrayList* bird_font_backup_tab_real_get_rows (BirdFontTable* base);
static void bird_font_backup_tab_real_selected_row (BirdFontTable* base,
                                             BirdFontRow* row,
                                             gint column,
                                             gboolean delete_button);
static void bird_font_backup_tab_real_update_rows (BirdFontTable* base);
static gchar* bird_font_backup_tab_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_backup_tab_real_get_name (BirdFontFontDisplay* base);
static gint __lambda309_ (BirdFontBackupTab* self,
                   BirdFontBackupDir* a,
                   BirdFontBackupDir* b);
static gint ___lambda309__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static void bird_font_backup_tab_real_draw (BirdFontFontDisplay* base,
                                     BirdFontWidgetAllocation* allocation,
                                     cairo_t* cr);
static void bird_font_backup_tab_finalize (GObject * obj);
static GType bird_font_backup_tab_get_type_once (void);

static inline gpointer
bird_font_backup_tab_get_instance_private (BirdFontBackupTab* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontBackupTab_private_offset);
}

BirdFontBackupTab*
bird_font_backup_tab_construct (GType object_type)
{
	BirdFontBackupTab * self = NULL;
	self = (BirdFontBackupTab*) bird_font_table_construct (object_type);
	return self;
}

BirdFontBackupTab*
bird_font_backup_tab_new (void)
{
	return bird_font_backup_tab_construct (BIRD_FONT_TYPE_BACKUP_TAB);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GeeArrayList*
bird_font_backup_tab_real_get_rows (BirdFontTable* base)
{
	BirdFontBackupTab * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	self = (BirdFontBackupTab*) base;
	_tmp0_ = self->priv->rows;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
bird_font_backup_tab_real_selected_row (BirdFontTable* base,
                                        BirdFontRow* row,
                                        gint column,
                                        gboolean delete_button)
{
	BirdFontBackupTab * self;
	self = (BirdFontBackupTab*) base;
	g_return_if_fail (row != NULL);
	if (bird_font_row_get_index (row) == BIRD_FONT_BACKUP_TAB_FONT_FOLDER) {
		GObject* _tmp0_;
		GObject* _tmp1_;
		GObject* _tmp2_;
		BirdFontScrollbar* _tmp3_;
		_tmp0_ = bird_font_row_get_row_data (row);
		_tmp1_ = _tmp0_;
		g_return_if_fail (BIRD_FONT_IS_BACKUP_DIR (_tmp1_));
		_g_object_unref0 (_tmp1_);
		_tmp2_ = bird_font_row_get_row_data (row);
		_g_object_unref0 (self->priv->backup_folder);
		self->priv->backup_folder = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_BACKUP_DIR, BirdFontBackupDir);
		_tmp3_ = bird_font_main_window_scrollbar;
		bird_font_scrollbar_set_size (_tmp3_, (gdouble) 0);
		bird_font_table_update_rows ((BirdFontTable*) self);
	} else {
		if (bird_font_row_get_index (row) == BIRD_FONT_BACKUP_TAB_FONT_FILE) {
			GObject* _tmp4_;
			GObject* _tmp5_;
			BirdFontString* backup_file = NULL;
			GObject* _tmp6_;
			BirdFontString* _tmp7_;
			const gchar* _tmp8_;
			BirdFontScrollbar* _tmp9_;
			_tmp4_ = bird_font_row_get_row_data (row);
			_tmp5_ = _tmp4_;
			g_return_if_fail (BIRD_FONT_IS_STRING (_tmp5_));
			_g_object_unref0 (_tmp5_);
			_tmp6_ = bird_font_row_get_row_data (row);
			backup_file = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BIRD_FONT_TYPE_STRING, BirdFontString);
			_tmp7_ = backup_file;
			_tmp8_ = _tmp7_->c_str;
			bird_font_recent_files_load_font (_tmp8_);
			_tmp9_ = bird_font_main_window_scrollbar;
			bird_font_scrollbar_set_size (_tmp9_, (gdouble) 0);
			_g_object_unref0 (backup_file);
		}
	}
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_backup_tab_real_update_rows (BirdFontTable* base)
{
	BirdFontBackupTab * self;
	BirdFontRow* row = NULL;
	GeeArrayList* _tmp0_;
	BirdFontBackupDir* _tmp1_;
	self = (BirdFontBackupTab*) base;
	_tmp0_ = self->priv->rows;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->backup_folder;
	if (_tmp1_ != NULL) {
		BirdFontBackupDir* folder = NULL;
		BirdFontBackupDir* _tmp2_;
		BirdFontBackupDir* _tmp3_;
		GeeArrayList* files = NULL;
		BirdFontBackupDir* _tmp4_;
		const gchar* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp2_ = self->priv->backup_folder;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_BACKUP_DIR, BirdFontBackupDir));
		folder = _tmp3_;
		_tmp4_ = folder;
		_tmp5_ = _tmp4_->folder_name;
		_tmp6_ = bird_font_font_get_sorted_backups (_tmp5_);
		files = _tmp6_;
		_tmp7_ = files;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ > 0) {
			gchar* _tmp10_;
			gchar* _tmp11_;
			BirdFontRow* _tmp12_;
			GeeArrayList* _tmp13_;
			BirdFontRow* _tmp14_;
			_tmp10_ = bird_font_t_ ("Backups");
			_tmp11_ = _tmp10_;
			_tmp12_ = bird_font_row_new_headline (_tmp11_);
			_g_object_unref0 (row);
			row = _tmp12_;
			_g_free0 (_tmp11_);
			_tmp13_ = self->priv->rows;
			_tmp14_ = row;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
		}
		_tmp15_ = files;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == 0) {
			gchar* _tmp18_;
			gchar* _tmp19_;
			BirdFontRow* _tmp20_;
			GeeArrayList* _tmp21_;
			BirdFontRow* _tmp22_;
			_tmp18_ = bird_font_t_ ("No backups for this font.");
			_tmp19_ = _tmp18_;
			_tmp20_ = bird_font_row_new_headline (_tmp19_);
			_g_object_unref0 (row);
			row = _tmp20_;
			_g_free0 (_tmp19_);
			_tmp21_ = self->priv->rows;
			_tmp22_ = row;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
		}
		{
			GeeArrayList* _path_list = NULL;
			GeeArrayList* _tmp23_;
			gint _path_size = 0;
			GeeArrayList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _path_index = 0;
			_tmp23_ = files;
			_path_list = _tmp23_;
			_tmp24_ = _path_list;
			_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_path_size = _tmp26_;
			_path_index = -1;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				gchar* path = NULL;
				GeeArrayList* _tmp29_;
				gpointer _tmp30_;
				gchar* name = NULL;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				BirdFontRow* _tmp34_;
				BirdFontString* file_name = NULL;
				const gchar* _tmp35_;
				BirdFontString* _tmp36_;
				BirdFontRow* _tmp37_;
				BirdFontString* _tmp38_;
				GeeArrayList* _tmp39_;
				BirdFontRow* _tmp40_;
				_path_index = _path_index + 1;
				_tmp27_ = _path_index;
				_tmp28_ = _path_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _path_list;
				_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _path_index);
				path = (gchar*) _tmp30_;
				_tmp31_ = path;
				_tmp32_ = bird_font_font_get_file_from_full_path (_tmp31_);
				name = _tmp32_;
				_tmp33_ = name;
				_tmp34_ = bird_font_row_new_columns_1 (_tmp33_, BIRD_FONT_BACKUP_TAB_FONT_FILE, FALSE);
				_g_object_unref0 (row);
				row = _tmp34_;
				_tmp35_ = path;
				_tmp36_ = bird_font_string_new (_tmp35_);
				file_name = _tmp36_;
				_tmp37_ = row;
				_tmp38_ = file_name;
				bird_font_row_set_row_data (_tmp37_, (GObject*) _tmp38_);
				_tmp39_ = self->priv->rows;
				_tmp40_ = row;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
				_g_object_unref0 (file_name);
				_g_free0 (name);
				_g_free0 (path);
			}
		}
		_g_object_unref0 (files);
		_g_object_unref0 (folder);
	} else {
		GeeArrayList* backup_folders = NULL;
		GeeArrayList* _tmp41_;
		GeeArrayList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		GeeArrayList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		_tmp41_ = bird_font_backup_tab_get_backup_folders (self);
		backup_folders = _tmp41_;
		_tmp42_ = backup_folders;
		_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		if (_tmp44_ == 0) {
			gchar* _tmp45_;
			gchar* _tmp46_;
			BirdFontRow* _tmp47_;
			GeeArrayList* _tmp48_;
			BirdFontRow* _tmp49_;
			_tmp45_ = bird_font_t_ ("No backups found.");
			_tmp46_ = _tmp45_;
			_tmp47_ = bird_font_row_new_headline (_tmp46_);
			_g_object_unref0 (row);
			row = _tmp47_;
			_g_free0 (_tmp46_);
			_tmp48_ = self->priv->rows;
			_tmp49_ = row;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp49_);
		}
		_tmp50_ = backup_folders;
		_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp52_ > 0) {
			gchar* _tmp53_;
			gchar* _tmp54_;
			BirdFontRow* _tmp55_;
			GeeArrayList* _tmp56_;
			BirdFontRow* _tmp57_;
			_tmp53_ = bird_font_t_ ("Backups");
			_tmp54_ = _tmp53_;
			_tmp55_ = bird_font_row_new_headline (_tmp54_);
			_g_object_unref0 (row);
			row = _tmp55_;
			_g_free0 (_tmp54_);
			_tmp56_ = self->priv->rows;
			_tmp57_ = row;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp57_);
		}
		{
			GeeArrayList* _backup_font_list = NULL;
			GeeArrayList* _tmp58_;
			gint _backup_font_size = 0;
			GeeArrayList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _backup_font_index = 0;
			_tmp58_ = backup_folders;
			_backup_font_list = _tmp58_;
			_tmp59_ = _backup_font_list;
			_tmp60_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_backup_font_size = _tmp61_;
			_backup_font_index = -1;
			while (TRUE) {
				gint _tmp62_;
				gint _tmp63_;
				BirdFontBackupDir* backup_font = NULL;
				GeeArrayList* _tmp64_;
				gpointer _tmp65_;
				BirdFontBackupDir* _tmp66_;
				const gchar* _tmp67_;
				BirdFontBackupDir* _tmp68_;
				const gchar* _tmp69_;
				BirdFontRow* _tmp70_;
				BirdFontRow* _tmp71_;
				BirdFontBackupDir* _tmp72_;
				GeeArrayList* _tmp73_;
				BirdFontRow* _tmp74_;
				_backup_font_index = _backup_font_index + 1;
				_tmp62_ = _backup_font_index;
				_tmp63_ = _backup_font_size;
				if (!(_tmp62_ < _tmp63_)) {
					break;
				}
				_tmp64_ = _backup_font_list;
				_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp64_, _backup_font_index);
				backup_font = (BirdFontBackupDir*) _tmp65_;
				_tmp66_ = backup_font;
				_tmp67_ = _tmp66_->folder_name;
				_tmp68_ = backup_font;
				_tmp69_ = _tmp68_->modification_time;
				_tmp70_ = bird_font_row_new_columns_2 (_tmp67_, _tmp69_, BIRD_FONT_BACKUP_TAB_FONT_FOLDER, FALSE);
				_g_object_unref0 (row);
				row = _tmp70_;
				_tmp71_ = row;
				_tmp72_ = backup_font;
				bird_font_row_set_row_data (_tmp71_, (GObject*) _tmp72_);
				_tmp73_ = self->priv->rows;
				_tmp74_ = row;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp73_, _tmp74_);
				_g_object_unref0 (backup_font);
			}
		}
		_g_object_unref0 (backup_folders);
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (row);
}

static gchar*
bird_font_backup_tab_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontBackupTab * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontBackupTab*) base;
	_tmp0_ = bird_font_t_ ("Backups");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_backup_tab_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontBackupTab * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontBackupTab*) base;
	_tmp0_ = g_strdup ("Backups");
	result = _tmp0_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
bird_font_backup_tab_get_time_stamp_from_file_name (BirdFontBackupTab* self,
                                                    const gchar* file_name)
{
	gint dash = 0;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_name != NULL, NULL);
	dash = string_last_index_of (file_name, "-", 0);
	if (g_str_has_suffix (file_name, ".bf_backup")) {
		_tmp0_ = dash > -1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* time_stamp = NULL;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp1_ = strlen ("-");
		_tmp2_ = _tmp1_;
		_tmp3_ = strlen (file_name);
		_tmp4_ = _tmp3_;
		_tmp5_ = strlen (".bf_backup");
		_tmp6_ = _tmp5_;
		_tmp7_ = string_substring (file_name, (glong) (dash + _tmp2_), (glong) ((_tmp4_ - dash) - _tmp6_));
		time_stamp = _tmp7_;
		_tmp8_ = time_stamp;
		_tmp9_ = string_replace (_tmp8_, "_", " ");
		_g_free0 (time_stamp);
		time_stamp = _tmp9_;
		result = time_stamp;
		return result;
	}
	_tmp10_ = g_strconcat ("Can't obtain timestamp from ", file_name, NULL);
	_tmp11_ = _tmp10_;
	g_warning ("BackupTab.vala:117: %s", _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = g_strdup ("Unknown time.");
	result = _tmp12_;
	return result;
}

static gint
__lambda309_ (BirdFontBackupTab* self,
              BirdFontBackupDir* a,
              BirdFontBackupDir* b)
{
	BirdFontBackupDir* first = NULL;
	BirdFontBackupDir* next = NULL;
	BirdFontBackupDir* _tmp0_;
	BirdFontBackupDir* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_BACKUP_DIR, BirdFontBackupDir));
	_g_object_unref0 (first);
	first = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_BACKUP_DIR, BirdFontBackupDir));
	_g_object_unref0 (next);
	next = _tmp1_;
	_tmp2_ = b->modification_time;
	_tmp3_ = a->modification_time;
	result = strcmp (_tmp2_, _tmp3_);
	_g_object_unref0 (next);
	_g_object_unref0 (first);
	return result;
}

static gint
___lambda309__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda309_ ((BirdFontBackupTab*) self, (BirdFontBackupDir*) a, (BirdFontBackupDir*) b);
	return result;
}

GeeArrayList*
bird_font_backup_tab_get_backup_folders (BirdFontBackupTab* self)
{
	GFileEnumerator* enumerator = NULL;
	gchar* folder_name = NULL;
	GFileInfo* file_info = NULL;
	GeeArrayList* backup_folders = NULL;
	GeeArrayList* _tmp0_;
	GFile* dir = NULL;
	GFile* _tmp1_;
	GeeArrayList* _tmp60_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_BACKUP_DIR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	backup_folders = _tmp0_;
	_tmp1_ = bird_font_preferences_get_backup_directory ();
	dir = _tmp1_;
	{
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFileEnumerator* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileEnumerator* _tmp7_;
		GFileEnumerator* _tmp8_;
		bird_font_printd ("Backup dir: ");
		_tmp2_ = dir;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = (gchar*) _tmp3_;
		bird_font_printd (_tmp4_);
		_g_free0 (_tmp4_);
		bird_font_printd ("\n");
		_tmp6_ = dir;
		_tmp7_ = g_file_enumerate_children (_tmp6_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp8_;
		while (TRUE) {
			GFileInfo* _tmp9_ = NULL;
			GFileEnumerator* _tmp10_;
			GFileInfo* _tmp11_;
			GFileInfo* _tmp12_;
			GFileInfo* _tmp13_;
			GFileInfo* info = NULL;
			GFileInfo* _tmp14_;
			GFileInfo* _tmp15_;
			GFileInfo* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* full_path = NULL;
			GFile* _tmp19_;
			const gchar* _tmp20_;
			GFile* _tmp21_;
			GFile* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp30_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gchar* _tmp40_;
			GeeArrayList* files = NULL;
			const gchar* _tmp41_;
			GeeArrayList* _tmp42_;
			GeeArrayList* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			_tmp10_ = enumerator;
			_tmp11_ = g_file_enumerator_next_file (_tmp10_, NULL, &_inner_error0_);
			_tmp9_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp5_);
				goto __catch0_g_error;
			}
			_tmp12_ = _tmp9_;
			_tmp9_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp12_;
			_tmp13_ = file_info;
			if (!(_tmp13_ != NULL)) {
				_g_object_unref0 (_tmp9_);
				break;
			}
			_tmp14_ = file_info;
			_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_file_info_get_type (), GFileInfo));
			info = _tmp15_;
			_tmp16_ = info;
			_tmp17_ = g_file_info_get_name (_tmp16_);
			_tmp18_ = g_strdup (_tmp17_);
			_g_free0 (folder_name);
			folder_name = _tmp18_;
			_tmp19_ = dir;
			_tmp20_ = folder_name;
			_tmp21_ = bird_font_get_child (_tmp19_, _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_file_get_path (_tmp22_);
			_tmp24_ = (gchar*) _tmp23_;
			_g_object_unref0 (_tmp22_);
			full_path = _tmp24_;
			bird_font_printd ("In backup dir: ");
			_tmp25_ = full_path;
			bird_font_printd (_tmp25_);
			bird_font_printd ("\n");
			_tmp26_ = full_path;
			if (!g_file_test (_tmp26_, G_FILE_TEST_IS_DIR)) {
				const gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = folder_name;
				_tmp28_ = g_strconcat (_tmp27_, " is not a backup directory.", NULL);
				_tmp29_ = _tmp28_;
				g_warning ("BackupTab.vala:145: %s", _tmp29_);
				_g_free0 (_tmp29_);
				_g_free0 (full_path);
				_g_object_unref0 (info);
				_g_object_unref0 (_tmp9_);
				continue;
			}
			_tmp30_ = folder_name;
			if (!g_str_has_suffix (_tmp30_, ".backup")) {
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp31_ = folder_name;
				_tmp32_ = g_strconcat (_tmp31_, " is not a backup directory, expecting the suffix .backup", NULL);
				_tmp33_ = _tmp32_;
				g_warning ("BackupTab.vala:150: %s", _tmp33_);
				_g_free0 (_tmp33_);
				_g_free0 (full_path);
				_g_object_unref0 (info);
				_g_object_unref0 (_tmp9_);
				continue;
			}
			_tmp34_ = folder_name;
			_tmp35_ = folder_name;
			_tmp36_ = strlen (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = strlen (".backup");
			_tmp39_ = _tmp38_;
			_tmp40_ = string_substring (_tmp34_, (glong) 0, (glong) (_tmp37_ - _tmp39_));
			_g_free0 (folder_name);
			folder_name = _tmp40_;
			_tmp41_ = folder_name;
			_tmp42_ = bird_font_font_get_sorted_backups (_tmp41_);
			files = _tmp42_;
			_tmp43_ = files;
			_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			if (_tmp45_ > 0) {
				gchar* last_file = NULL;
				GeeArrayList* _tmp46_;
				GeeArrayList* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gpointer _tmp50_;
				gchar* modification_time = NULL;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				BirdFontBackupDir* backup = NULL;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				BirdFontBackupDir* _tmp55_;
				GeeArrayList* _tmp56_;
				BirdFontBackupDir* _tmp57_;
				_tmp46_ = files;
				_tmp47_ = files;
				_tmp48_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _tmp49_ - 1);
				last_file = (gchar*) _tmp50_;
				_tmp51_ = last_file;
				_tmp52_ = bird_font_backup_tab_get_time_stamp_from_file_name (self, _tmp51_);
				modification_time = _tmp52_;
				_tmp53_ = folder_name;
				_tmp54_ = modification_time;
				_tmp55_ = bird_font_backup_dir_new (_tmp53_, _tmp54_);
				backup = _tmp55_;
				_tmp56_ = backup_folders;
				_tmp57_ = backup;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp57_);
				_g_object_unref0 (backup);
				_g_free0 (modification_time);
				_g_free0 (last_file);
			}
			_g_object_unref0 (files);
			_g_free0 (full_path);
			_g_object_unref0 (info);
			_g_object_unref0 (_tmp9_);
		}
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp58_;
		const gchar* _tmp59_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp58_ = e;
		_tmp59_ = _tmp58_->message;
		g_warning ("BackupTab.vala:165: %s", _tmp59_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dir);
		_g_object_unref0 (backup_folders);
		_g_object_unref0 (file_info);
		_g_free0 (folder_name);
		_g_object_unref0 (enumerator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp60_ = backup_folders;
	gee_list_sort ((GeeList*) _tmp60_, ___lambda309__gcompare_data_func, g_object_ref (self), g_object_unref);
	result = backup_folders;
	_g_object_unref0 (dir);
	_g_object_unref0 (file_info);
	_g_free0 (folder_name);
	_g_object_unref0 (enumerator);
	return result;
}

static void
bird_font_backup_tab_real_draw (BirdFontFontDisplay* base,
                                BirdFontWidgetAllocation* allocation,
                                cairo_t* cr)
{
	BirdFontBackupTab * self;
	BirdFontOverview* _tmp0_;
	BirdFontOverview* _tmp1_;
	BirdFontWidgetAllocation* _tmp2_;
	self = (BirdFontBackupTab*) base;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_main_window_get_overview ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (allocation);
	_g_object_unref0 (_tmp1_->allocation);
	_tmp1_->allocation = _tmp2_;
	_g_object_unref0 (_tmp1_);
	BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_backup_tab_parent_class)->draw ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TABLE, BirdFontTable), allocation, cr);
}

static void
bird_font_backup_tab_class_init (BirdFontBackupTabClass * klass,
                                 gpointer klass_data)
{
	bird_font_backup_tab_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontBackupTab_private_offset);
	((BirdFontTableClass *) klass)->get_rows = (GeeArrayList* (*) (BirdFontTable*)) bird_font_backup_tab_real_get_rows;
	((BirdFontTableClass *) klass)->selected_row = (void (*) (BirdFontTable*, BirdFontRow*, gint, gboolean)) bird_font_backup_tab_real_selected_row;
	((BirdFontTableClass *) klass)->update_rows = (void (*) (BirdFontTable*)) bird_font_backup_tab_real_update_rows;
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_backup_tab_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_backup_tab_real_get_name;
	((BirdFontFontDisplayClass *) klass)->draw = (void (*) (BirdFontFontDisplay*, BirdFontWidgetAllocation*, cairo_t*)) bird_font_backup_tab_real_draw;
	G_OBJECT_CLASS (klass)->finalize = bird_font_backup_tab_finalize;
}

static void
bird_font_backup_tab_instance_init (BirdFontBackupTab * self,
                                    gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = bird_font_backup_tab_get_instance_private (self);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->rows = _tmp0_;
	self->priv->backup_folder = NULL;
}

static void
bird_font_backup_tab_finalize (GObject * obj)
{
	BirdFontBackupTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_BACKUP_TAB, BirdFontBackupTab);
	_g_object_unref0 (self->priv->rows);
	_g_object_unref0 (self->priv->backup_folder);
	G_OBJECT_CLASS (bird_font_backup_tab_parent_class)->finalize (obj);
}

static GType
bird_font_backup_tab_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontBackupTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_backup_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontBackupTab), 0, (GInstanceInitFunc) bird_font_backup_tab_instance_init, NULL };
	GType bird_font_backup_tab_type_id;
	bird_font_backup_tab_type_id = g_type_register_static (BIRD_FONT_TYPE_TABLE, "BirdFontBackupTab", &g_define_type_info, 0);
	BirdFontBackupTab_private_offset = g_type_add_instance_private (bird_font_backup_tab_type_id, sizeof (BirdFontBackupTabPrivate));
	return bird_font_backup_tab_type_id;
}

GType
bird_font_backup_tab_get_type (void)
{
	static volatile gsize bird_font_backup_tab_type_id__once = 0;
	if (g_once_init_enter (&bird_font_backup_tab_type_id__once)) {
		GType bird_font_backup_tab_type_id;
		bird_font_backup_tab_type_id = bird_font_backup_tab_get_type_once ();
		g_once_init_leave (&bird_font_backup_tab_type_id__once, bird_font_backup_tab_type_id);
	}
	return bird_font_backup_tab_type_id__once;
}

