/* BackgroundImage.c generated by valac 0.56.16, the Vala compiler
 * generated from BackgroundImage.vala, do not modify */

/*
Copyright (C) 2012 2013 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT (bird_font_background_image_traced_point_get_type ())
#define BIRD_FONT_BACKGROUND_IMAGE_TRACED_POINT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, BirdFontBackgroundImageTracedPoint))
#define BIRD_FONT_BACKGROUND_IMAGE_TRACED_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, BirdFontBackgroundImageTracedPointClass))
#define BIRD_FONT_BACKGROUND_IMAGE_IS_TRACED_POINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT))
#define BIRD_FONT_BACKGROUND_IMAGE_IS_TRACED_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT))
#define BIRD_FONT_BACKGROUND_IMAGE_TRACED_POINT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, BirdFontBackgroundImageTracedPointClass))

typedef struct _BirdFontBackgroundImageTracedPoint BirdFontBackgroundImageTracedPoint;
typedef struct _BirdFontBackgroundImageTracedPointClass BirdFontBackgroundImageTracedPointClass;
enum  {
	BIRD_FONT_BACKGROUND_IMAGE_0_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_X_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_Y_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_X_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_Y_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_SIZE_MARGIN_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_MARGIN_LEFT_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_MARGIN_TOP_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_X_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_Y_PROPERTY,
	BIRD_FONT_BACKGROUND_IMAGE_NUM_PROPERTIES
};
static GParamSpec* bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _bird_font_background_image_traced_point_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_background_image_traced_point_unref (var), NULL)))
typedef struct _BirdFontBackgroundImageTracedPointPrivate BirdFontBackgroundImageTracedPointPrivate;
typedef struct _BirdFontBackgroundImageParamSpecTracedPoint BirdFontBackgroundImageParamSpecTracedPoint;
enum  {
	BIRD_FONT_BACKGROUND_IMAGE_UPDATED_SIGNAL,
	BIRD_FONT_BACKGROUND_IMAGE_NUM_SIGNALS
};
static guint bird_font_background_image_signals[BIRD_FONT_BACKGROUND_IMAGE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontBackgroundImagePrivate {
	gdouble img_scale_x_size;
	gdouble img_scale_y_size;
	gdouble preview_img_rotation;
	gint size;
	cairo_surface_t* background_image;
	cairo_surface_t* original_image;
	gchar* path;
	GeeArrayList* points;
	GeeArrayList* start_points;
	BirdFontScaledBackgrounds* scaled;
	cairo_surface_t* contrast_image;
};

struct _BirdFontBackgroundImageTracedPoint {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BirdFontBackgroundImageTracedPointPrivate * priv;
	gint index;
	gdouble x;
	gdouble y;
};

struct _BirdFontBackgroundImageTracedPointClass {
	GTypeClass parent_class;
	void (*finalize) (BirdFontBackgroundImageTracedPoint *self);
};

struct _BirdFontBackgroundImageParamSpecTracedPoint {
	GParamSpec parent_instance;
};

static gint BirdFontBackgroundImage_private_offset;
static gpointer bird_font_background_image_parent_class = NULL;
static gpointer bird_font_background_image_traced_point_parent_class = NULL;

static gpointer bird_font_background_image_traced_point_ref (gpointer instance);
static void bird_font_background_image_traced_point_unref (gpointer instance);
static GParamSpec* bird_font_background_image_param_spec_traced_point (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags) G_GNUC_UNUSED ;
static void bird_font_background_image_value_set_traced_point (GValue* value,
                                                        gpointer v_object) G_GNUC_UNUSED ;
static void bird_font_background_image_value_take_traced_point (GValue* value,
                                                         gpointer v_object) G_GNUC_UNUSED ;
static gpointer bird_font_background_image_value_get_traced_point (const GValue* value) G_GNUC_UNUSED ;
static GType bird_font_background_image_traced_point_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static cairo_surface_t* bird_font_background_image_rotate (BirdFontBackgroundImage* self,
                                                    cairo_surface_t* padded_image);
static void bird_font_background_image_create_png (BirdFontBackgroundImage* self);
VALA_EXTERN GFile* bird_font_bird_font_get_settings_directory (void);
static BirdFontScaledBackgrounds* bird_font_background_image_get_image (BirdFontBackgroundImage* self);
static void bird_font_background_image_cache_scaled_image (BirdFontBackgroundImage* self);
static void _bird_font_background_image_cache_scaled_image_bird_font_task_runnable (gpointer self);
static cairo_surface_t* bird_font_background_image_get_contrast_image (BirdFontBackgroundImage* self);
static gboolean bird_font_background_image_is_over_rotate (BirdFontBackgroundImage* self,
                                                    gdouble nx,
                                                    gdouble ny);
static gboolean bird_font_background_image_is_over_resize (BirdFontBackgroundImage* self,
                                                    gdouble nx,
                                                    gdouble ny);
static void bird_font_background_image_draw_handle_triangle (BirdFontBackgroundImage* self,
                                                      gdouble x,
                                                      gdouble y,
                                                      cairo_t* cr,
                                                      BirdFontGlyph* g,
                                                      gint direction,
                                                      gdouble s);
static cairo_surface_t* bird_font_background_image_get_contrast_image_surface (BirdFontBackgroundImage* self);
static gint bird_font_background_image_find_start_point (BirdFontBackgroundImage* self,
                                                  guint8* outline_img,
                                                  gint len,
                                                  gint s,
                                                  gint start_index);
static gboolean bird_font_background_image_is_traced (BirdFontBackgroundImage* self,
                                               gint i);
static BirdFontPath* bird_font_background_image_generate_path (BirdFontBackgroundImage* self,
                                                        guint8* outline_img,
                                                        gint stride,
                                                        gint w,
                                                        gint h,
                                                        gint length);
static BirdFontBackgroundImageTracedPoint* bird_font_background_image_traced_point_new (gint index);
static BirdFontBackgroundImageTracedPoint* bird_font_background_image_traced_point_construct (GType object_type,
                                                                                       gint index);
static gboolean bird_font_background_image_has_start_point (BirdFontBackgroundImage* self,
                                                     gint i);
static void bird_font_background_image_find_corner (BirdFontBackgroundImage* self,
                                             BirdFontPath* path,
                                             gint point_index,
                                             gint end,
                                             gdouble points_per_unit,
                                             gdouble* x,
                                             gdouble* y);
static gint* _int_dup (gint* self);
static void bird_font_background_image_traced_point_finalize (BirdFontBackgroundImageTracedPoint * obj);
static GType bird_font_background_image_traced_point_get_type_once (void);
static void bird_font_background_image_finalize (GObject * obj);
static GType bird_font_background_image_get_type_once (void);
static void _vala_bird_font_background_image_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_bird_font_background_image_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
bird_font_background_image_get_instance_private (BirdFontBackgroundImage* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontBackgroundImage_private_offset);
}

BirdFontBackgroundImage*
bird_font_background_image_construct (GType object_type,
                                      const gchar* file_name)
{
	BirdFontBackgroundImage * self = NULL;
	gchar* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_val_if_fail (file_name != NULL, NULL);
	self = (BirdFontBackgroundImage*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (file_name);
	_g_free0 (self->priv->path);
	self->priv->path = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_BACKGROUND_SELECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->selections);
	self->selections = _tmp1_;
	return self;
}

BirdFontBackgroundImage*
bird_font_background_image_new (const gchar* file_name)
{
	return bird_font_background_image_construct (BIRD_FONT_TYPE_BACKGROUND_IMAGE, file_name);
}

BirdFontBackgroundImage*
bird_font_background_image_copy (BirdFontBackgroundImage* self)
{
	BirdFontBackgroundImage* bg = NULL;
	const gchar* _tmp0_;
	BirdFontBackgroundImage* _tmp1_;
	BirdFontBackgroundImage* _tmp2_;
	BirdFontBackgroundImage* _tmp3_;
	BirdFontBackgroundImage* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	BirdFontBackgroundImage* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	BirdFontBackgroundImage* _tmp10_;
	BirdFontBackgroundImage* _tmp11_;
	BirdFontBackgroundImage* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->path;
	_tmp1_ = bird_font_background_image_new (_tmp0_);
	bg = _tmp1_;
	_tmp2_ = bg;
	_tmp2_->img_x = self->img_x;
	_tmp3_ = bg;
	_tmp3_->img_y = self->img_y;
	_tmp4_ = bg;
	_tmp5_ = bird_font_background_image_get_img_scale_x (self);
	_tmp6_ = _tmp5_;
	bird_font_background_image_set_img_scale_x (_tmp4_, _tmp6_);
	_tmp7_ = bg;
	_tmp8_ = bird_font_background_image_get_img_scale_y (self);
	_tmp9_ = _tmp8_;
	bird_font_background_image_set_img_scale_y (_tmp7_, _tmp9_);
	_tmp10_ = bg;
	_tmp10_->img_rotation = self->img_rotation;
	_tmp11_ = bg;
	_tmp11_->high_contrast = self->high_contrast;
	{
		GeeArrayList* _b_list = NULL;
		GeeArrayList* _tmp12_;
		gint _b_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _b_index = 0;
		_tmp12_ = self->selections;
		_b_list = _tmp12_;
		_tmp13_ = _b_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_b_size = _tmp15_;
		_b_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			BirdFontBackgroundSelection* b = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			BirdFontBackgroundImage* _tmp20_;
			GeeArrayList* _tmp21_;
			BirdFontBackgroundSelection* _tmp22_;
			_b_index = _b_index + 1;
			_tmp16_ = _b_index;
			_tmp17_ = _b_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _b_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _b_index);
			b = (BirdFontBackgroundSelection*) _tmp19_;
			_tmp20_ = bg;
			_tmp21_ = _tmp20_->selections;
			_tmp22_ = b;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
			_g_object_unref0 (b);
		}
	}
	result = bg;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontScaledBackgrounds*
bird_font_background_image_get_scaled_backgrounds (BirdFontBackgroundImage* self)
{
	BirdFontScaledBackgrounds* _tmp0_;
	BirdFontScaledBackgrounds* _tmp7_;
	BirdFontScaledBackgrounds* _tmp8_;
	BirdFontScaledBackgrounds* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scaled;
	if (_tmp0_ == NULL) {
		cairo_surface_t* rotated = NULL;
		cairo_surface_t* _tmp1_;
		cairo_surface_t* _tmp2_;
		cairo_surface_t* _tmp3_;
		cairo_surface_t* _tmp4_;
		cairo_surface_t* _tmp5_;
		BirdFontScaledBackgrounds* _tmp6_;
		_tmp1_ = bird_font_background_image_get_padded_image (self);
		_tmp2_ = (cairo_surface_t*) _tmp1_;
		_tmp3_ = bird_font_background_image_rotate (self, _tmp2_);
		_tmp4_ = _tmp3_;
		_cairo_surface_destroy0 (_tmp2_);
		rotated = _tmp4_;
		_tmp5_ = rotated;
		_tmp6_ = bird_font_scaled_backgrounds_new (_tmp5_);
		_g_object_unref0 (self->priv->scaled);
		self->priv->scaled = _tmp6_;
		_cairo_surface_destroy0 (rotated);
	}
	_tmp7_ = self->priv->scaled;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, BIRD_FONT_TYPE_SCALED_BACKGROUNDS, BirdFontScaledBackgrounds));
	result = _tmp8_;
	return result;
}

void
bird_font_background_image_add_selection (BirdFontBackgroundImage* self,
                                          BirdFontBackgroundSelection* bs)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bs != NULL);
	_tmp0_ = self->selections;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, bs);
}

void
bird_font_background_image_set_high_contrast (BirdFontBackgroundImage* self,
                                              gboolean t)
{
	g_return_if_fail (self != NULL);
	self->high_contrast = t;
}

gdouble
bird_font_background_image_get_margin_width (BirdFontBackgroundImage* self)
{
	gint _tmp0_;
	gint _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	gdouble _tmp4_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = bird_font_background_image_get_size_margin (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = (_tmp1_ - cairo_image_surface_get_width (_tmp3_)) / 2.0;
	_cairo_surface_destroy0 (_tmp3_);
	result = _tmp4_;
	return result;
}

gdouble
bird_font_background_image_get_margin_height (BirdFontBackgroundImage* self)
{
	gint _tmp0_;
	gint _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	gdouble _tmp4_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = bird_font_background_image_get_size_margin (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = (_tmp1_ - cairo_image_surface_get_height (_tmp3_)) / 2.0;
	_cairo_surface_destroy0 (_tmp3_);
	result = _tmp4_;
	return result;
}

void
bird_font_background_image_set_img_offset (BirdFontBackgroundImage* self,
                                           gdouble x,
                                           gdouble y)
{
	g_return_if_fail (self != NULL);
	bird_font_background_image_set_img_offset_x (self, x);
	bird_font_background_image_set_img_offset_y (self, y);
}

void
bird_font_background_image_set_position (BirdFontBackgroundImage* self,
                                         gdouble coordinate_x,
                                         gdouble coordinate_y)
{
	g_return_if_fail (self != NULL);
	self->img_x = coordinate_x;
	self->img_y = coordinate_y;
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

cairo_surface_t*
bird_font_background_image_get_img (BirdFontBackgroundImage* self)
{
	const gchar* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->path;
	if (!g_str_has_suffix (_tmp0_, ".png")) {
		bird_font_background_image_create_png (self);
	}
	_tmp1_ = self->priv->background_image;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		cairo_surface_t* _tmp3_;
		const gchar* _tmp4_;
		cairo_surface_t* _tmp5_;
		_tmp2_ = self->priv->path;
		_tmp3_ = cairo_image_surface_create_from_png (_tmp2_);
		_cairo_surface_destroy0 (self->priv->background_image);
		self->priv->background_image = _tmp3_;
		_tmp4_ = self->priv->path;
		_tmp5_ = cairo_image_surface_create_from_png (_tmp4_);
		_cairo_surface_destroy0 (self->priv->original_image);
		self->priv->original_image = _tmp5_;
	}
	_tmp6_ = self->priv->background_image;
	_tmp7_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp6_);
	result = _tmp7_;
	return result;
}

cairo_surface_t*
bird_font_background_image_get_original (BirdFontBackgroundImage* self)
{
	const gchar* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->path;
	if (!g_str_has_suffix (_tmp0_, ".png")) {
		bird_font_background_image_create_png (self);
	}
	_tmp1_ = self->priv->background_image;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		cairo_surface_t* _tmp3_;
		const gchar* _tmp4_;
		cairo_surface_t* _tmp5_;
		_tmp2_ = self->priv->path;
		_tmp3_ = cairo_image_surface_create_from_png (_tmp2_);
		_cairo_surface_destroy0 (self->priv->background_image);
		self->priv->background_image = _tmp3_;
		_tmp4_ = self->priv->path;
		_tmp5_ = cairo_image_surface_create_from_png (_tmp4_);
		_cairo_surface_destroy0 (self->priv->original_image);
		self->priv->original_image = _tmp5_;
	}
	_tmp6_ = self->priv->original_image;
	_tmp7_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp6_);
	result = _tmp7_;
	return result;
}

gboolean
bird_font_background_image_is_valid (BirdFontBackgroundImage* self)
{
	GFileInfo* file_info = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		result = FALSE;
		_g_object_unref0 (file);
		_g_object_unref0 (file_info);
		return result;
	}
	{
		GFileInfo* _tmp3_ = NULL;
		GFile* _tmp4_;
		GFileInfo* _tmp5_;
		GFileInfo* _tmp6_;
		GFileInfo* _tmp7_;
		_tmp4_ = file;
		_tmp5_ = g_file_query_info (_tmp4_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (file_info);
		file_info = _tmp6_;
		_tmp7_ = file_info;
		if (g_file_info_get_size (_tmp7_) == ((gint64) 0)) {
			result = FALSE;
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (file);
			_g_object_unref0 (file_info);
			return result;
		}
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("BackgroundImage.vala:221: %s", _tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (file);
		_g_object_unref0 (file_info);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_object_unref0 (file);
		_g_object_unref0 (file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	result = TRUE;
	_g_object_unref0 (file);
	_g_object_unref0 (file_info);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
bird_font_background_image_get_png_base64 (BirdFontBackgroundImage* self)
{
	gchar* _tmp33_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GFile* file = NULL;
		const gchar* _tmp0_;
		GFile* _tmp1_;
		GFileInfo* file_info = NULL;
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
		guint8* buffer = NULL;
		GFileInfo* _tmp4_;
		guint8* _tmp5_;
		gint buffer_length1;
		gint _buffer_size_;
		GFileInputStream* file_stream = NULL;
		GDataInputStream* png_stream = NULL;
		GFile* _tmp6_;
		guint8* _tmp12_;
		gint _tmp12__length1;
		GFileInputStream* _tmp21_ = NULL;
		GFile* _tmp22_;
		GFileInputStream* _tmp23_;
		GFileInputStream* _tmp24_;
		GFileInputStream* _tmp25_;
		GDataInputStream* _tmp26_;
		GDataInputStream* _tmp27_;
		guint8* _tmp28_;
		gint _tmp28__length1;
		guint8* _tmp29_;
		gint _tmp29__length1;
		gchar* _tmp30_;
		_tmp0_ = self->priv->path;
		_tmp1_ = g_file_new_for_path (_tmp0_);
		file = _tmp1_;
		_tmp2_ = file;
		_tmp3_ = g_file_query_info (_tmp2_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		file_info = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp4_ = file_info;
		_tmp5_ = g_new0 (guint8, g_file_info_get_size (_tmp4_));
		buffer = _tmp5_;
		buffer_length1 = g_file_info_get_size (_tmp4_);
		_buffer_size_ = buffer_length1;
		_tmp6_ = file;
		if (!g_file_query_exists (_tmp6_, NULL)) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = self->priv->path;
			_tmp8_ = string_to_string (_tmp7_);
			_tmp9_ = g_strconcat ("Can't to save image ", _tmp8_, ", file does not exist.", NULL);
			_tmp10_ = _tmp9_;
			g_warning ("BackgroundImage.vala:237: %s", _tmp10_);
			_g_free0 (_tmp10_);
			_tmp11_ = g_strdup ("");
			result = _tmp11_;
			_g_object_unref0 (png_stream);
			_g_object_unref0 (file_stream);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			return result;
		}
		_tmp12_ = buffer;
		_tmp12__length1 = buffer_length1;
		if (bird_font_is_null (_tmp12_)) {
			GFileInfo* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp13_ = file_info;
			_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_file_info_get_size (_tmp13_));
			_tmp15_ = _tmp14_;
			_tmp16_ = self->priv->path;
			_tmp17_ = string_to_string (_tmp16_);
			_tmp18_ = g_strconcat ("Can not allocate a buffer of ", _tmp15_, " bytes to store ", _tmp17_, ".", NULL);
			_tmp19_ = _tmp18_;
			g_warning ("BackgroundImage.vala:242: %s", _tmp19_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp15_);
			_tmp20_ = g_strdup ("");
			result = _tmp20_;
			_g_object_unref0 (png_stream);
			_g_object_unref0 (file_stream);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			return result;
		}
		_tmp22_ = file;
		_tmp23_ = g_file_read (_tmp22_, NULL, &_inner_error0_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (png_stream);
			_g_object_unref0 (file_stream);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp24_ = _tmp21_;
		_tmp21_ = NULL;
		_g_object_unref0 (file_stream);
		file_stream = _tmp24_;
		_tmp25_ = file_stream;
		_tmp26_ = g_data_input_stream_new ((GInputStream*) _tmp25_);
		_g_object_unref0 (png_stream);
		png_stream = _tmp26_;
		_tmp27_ = png_stream;
		_tmp28_ = buffer;
		_tmp28__length1 = buffer_length1;
		g_input_stream_read ((GInputStream*) _tmp27_, _tmp28_, (gsize) _tmp28__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp21_);
			_g_object_unref0 (png_stream);
			_g_object_unref0 (file_stream);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp29_ = buffer;
		_tmp29__length1 = buffer_length1;
		_tmp30_ = g_base64_encode (_tmp29_, (gint) _tmp29__length1);
		result = _tmp30_;
		_g_object_unref0 (_tmp21_);
		_g_object_unref0 (png_stream);
		_g_object_unref0 (file_stream);
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("BackgroundImage.vala:253: %s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp33_ = g_strdup ("");
	result = _tmp33_;
	return result;
}

void
bird_font_background_image_create_background_folders (BirdFontBackgroundImage* self,
                                                      BirdFontFont* font)
{
	GFile* dir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	_tmp0_ = bird_font_bird_font_get_settings_directory ();
	_g_object_unref0 (dir);
	dir = _tmp0_;
	_tmp1_ = dir;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = dir;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = (gchar*) _tmp3_;
		g_mkdir (_tmp4_, 0755);
		_g_free0 (_tmp4_);
	}
	_tmp5_ = bird_font_font_get_backgrounds_folder (font);
	_g_object_unref0 (dir);
	dir = _tmp5_;
	_tmp6_ = dir;
	if (!g_file_query_exists (_tmp6_, NULL)) {
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = dir;
		_tmp8_ = g_file_get_path (_tmp7_);
		_tmp9_ = (gchar*) _tmp8_;
		g_mkdir (_tmp9_, 0755);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = bird_font_font_get_backgrounds_folder (font);
	_tmp11_ = _tmp10_;
	_tmp12_ = bird_font_get_child (_tmp11_, "parts");
	_g_object_unref0 (dir);
	dir = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_tmp13_ = dir;
	if (!g_file_query_exists (_tmp13_, NULL)) {
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = dir;
		_tmp15_ = g_file_get_path (_tmp14_);
		_tmp16_ = (gchar*) _tmp15_;
		g_mkdir (_tmp16_, 0755);
		_g_free0 (_tmp16_);
	}
	_g_object_unref0 (dir);
}

void
bird_font_background_image_copy_if_new (BirdFontBackgroundImage* self,
                                        GFile* destination)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	if (!g_file_query_exists (destination, NULL)) {
		bird_font_background_image_copy_file (self, destination);
	}
}

void
bird_font_background_image_copy_file (BirdFontBackgroundImage* self,
                                      GFile* destination)
{
	GFile* source = NULL;
	GFileInfo* info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	{
		GFile* _tmp9_;
		GFile* _tmp10_;
		gboolean _tmp11_;
		const gchar* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		if (g_file_query_exists (destination, NULL)) {
			GFileInfo* _tmp0_ = NULL;
			GFileInfo* _tmp1_;
			GFileInfo* _tmp2_;
			GFileInfo* _tmp3_;
			_tmp1_ = g_file_query_info (destination, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (info);
			info = _tmp2_;
			_tmp3_ = info;
			if (g_file_info_get_file_type (_tmp3_) == G_FILE_TYPE_DIRECTORY) {
				gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp4_ = g_file_get_path (destination);
				_tmp5_ = (gchar*) _tmp4_;
				_tmp6_ = string_to_string (_tmp5_);
				_tmp7_ = g_strconcat (_tmp6_, " is a directory.", NULL);
				_tmp8_ = _tmp7_;
				g_warning ("BackgroundImage.vala:293: %s", _tmp8_);
				_g_free0 (_tmp8_);
				_g_free0 (_tmp5_);
				_g_object_unref0 (_tmp0_);
				_g_object_unref0 (info);
				_g_object_unref0 (source);
				return;
			}
			_g_object_unref0 (_tmp0_);
		}
		_tmp9_ = g_file_get_parent (destination);
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_file_get_type (), GFile);
		_tmp11_ = !g_file_query_exists (_tmp10_, NULL);
		_g_object_unref0 (_tmp10_);
		if (_tmp11_) {
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp12_ = g_file_get_path (destination);
			_tmp13_ = (gchar*) _tmp12_;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strconcat ("Directory for file ", _tmp14_, " is not created.", NULL);
			_tmp16_ = _tmp15_;
			g_warning ("BackgroundImage.vala:299: %s", _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (info);
			_g_object_unref0 (source);
			return;
		}
		if (g_file_query_exists (destination, NULL)) {
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp17_ = g_file_get_path (destination);
			_tmp18_ = (gchar*) _tmp17_;
			_tmp19_ = string_to_string (_tmp18_);
			_tmp20_ = g_strconcat ("Image ", _tmp19_, " is already created.", NULL);
			_tmp21_ = _tmp20_;
			g_warning ("BackgroundImage.vala:304: %s", _tmp21_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp18_);
			_g_object_unref0 (info);
			_g_object_unref0 (source);
			return;
		}
		_tmp22_ = self->priv->path;
		_tmp23_ = g_file_new_for_path (_tmp22_);
		_g_object_unref0 (source);
		source = _tmp23_;
		_tmp24_ = source;
		g_file_copy (_tmp24_, destination, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("BackgroundImage.vala:311: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (info);
	_g_object_unref0 (source);
}

gchar*
bird_font_background_image_get_sha1 (BirdFontBackgroundImage* self)
{
	gchar* _tmp32_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GFile* file = NULL;
		const gchar* _tmp0_;
		GFile* _tmp1_;
		GFileInfo* file_info = NULL;
		guint8* buffer = NULL;
		gint buffer_length1 = 0;
		gint _buffer_size_ = 0;
		GFileInputStream* file_stream = NULL;
		GDataInputStream* png_stream = NULL;
		GFile* _tmp2_;
		GFileInfo* _tmp8_ = NULL;
		GFile* _tmp9_;
		GFileInfo* _tmp10_;
		GFileInfo* _tmp11_;
		GFileInfo* _tmp12_;
		GFileInfo* _tmp18_;
		guint8* _tmp19_;
		GFileInputStream* _tmp20_ = NULL;
		GFile* _tmp21_;
		GFileInputStream* _tmp22_;
		GFileInputStream* _tmp23_;
		GFileInputStream* _tmp24_;
		GDataInputStream* _tmp25_;
		GDataInputStream* _tmp26_;
		guint8* _tmp27_;
		gint _tmp27__length1;
		guint8* _tmp28_;
		gint _tmp28__length1;
		gchar* _tmp29_;
		_tmp0_ = self->priv->path;
		_tmp1_ = g_file_new_for_path (_tmp0_);
		file = _tmp1_;
		_tmp2_ = file;
		if (!g_file_query_exists (_tmp2_, NULL)) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = self->priv->path;
			_tmp4_ = string_to_string (_tmp3_);
			_tmp5_ = g_strconcat ("Can't save ", _tmp4_, " file does not exist.", NULL);
			_tmp6_ = _tmp5_;
			g_warning ("BackgroundImage.vala:324: %s", _tmp6_);
			_g_free0 (_tmp6_);
			_tmp7_ = g_strdup ("");
			result = _tmp7_;
			_g_object_unref0 (png_stream);
			_g_object_unref0 (file_stream);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			return result;
		}
		_tmp9_ = file;
		_tmp10_ = g_file_query_info (_tmp9_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (png_stream);
			_g_object_unref0 (file_stream);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (file_info);
		file_info = _tmp11_;
		_tmp12_ = file_info;
		if (g_file_info_get_size (_tmp12_) == ((gint64) 0)) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp13_ = self->priv->path;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strconcat ("length of image ", _tmp14_, " is zero", NULL);
			_tmp16_ = _tmp15_;
			g_warning ("BackgroundImage.vala:331: %s", _tmp16_);
			_g_free0 (_tmp16_);
			_tmp17_ = g_strdup ("");
			result = _tmp17_;
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (png_stream);
			_g_object_unref0 (file_stream);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			return result;
		}
		_tmp18_ = file_info;
		_tmp19_ = g_new0 (guint8, g_file_info_get_size (_tmp18_));
		buffer = (g_free (buffer), NULL);
		buffer = _tmp19_;
		buffer_length1 = g_file_info_get_size (_tmp18_);
		_buffer_size_ = buffer_length1;
		_tmp21_ = file;
		_tmp22_ = g_file_read (_tmp21_, NULL, &_inner_error0_);
		_tmp20_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (png_stream);
			_g_object_unref0 (file_stream);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp23_ = _tmp20_;
		_tmp20_ = NULL;
		_g_object_unref0 (file_stream);
		file_stream = _tmp23_;
		_tmp24_ = file_stream;
		_tmp25_ = g_data_input_stream_new ((GInputStream*) _tmp24_);
		_g_object_unref0 (png_stream);
		png_stream = _tmp25_;
		_tmp26_ = png_stream;
		_tmp27_ = buffer;
		_tmp27__length1 = buffer_length1;
		g_input_stream_read ((GInputStream*) _tmp26_, _tmp27_, (gsize) _tmp27__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp20_);
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (png_stream);
			_g_object_unref0 (file_stream);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp28_ = buffer;
		_tmp28__length1 = buffer_length1;
		_tmp29_ = g_compute_checksum_for_data (G_CHECKSUM_SHA1, _tmp28_, (gint) _tmp28__length1);
		result = _tmp29_;
		_g_object_unref0 (_tmp20_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (png_stream);
		_g_object_unref0 (file_stream);
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("BackgroundImage.vala:343: %s", _tmp31_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp32_ = g_strdup ("");
	result = _tmp32_;
	return result;
}

static void
bird_font_background_image_create_png (BirdFontBackgroundImage* self)
{
	gchar* file_name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp3_;
	GFile* folder = NULL;
	BirdFontFont* _tmp4_;
	GFile* _tmp5_;
	GFile* original = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* png_image = NULL;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	gboolean converted = FALSE;
	GFile* _tmp17_;
	const gchar* _tmp20_;
	BirdFontNativeWindow* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GFile* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GFile* _tmp33_;
	gchar* _tmp34_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->path;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat (_tmp1_, ".png", NULL);
	file_name = _tmp2_;
	_tmp3_ = bird_font_bird_font_get_current_font ();
	font = _tmp3_;
	_tmp4_ = font;
	_tmp5_ = bird_font_font_get_backgrounds_folder (_tmp4_);
	folder = _tmp5_;
	_tmp6_ = file_name;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	original = _tmp7_;
	_tmp8_ = folder;
	_tmp9_ = original;
	_tmp10_ = g_file_get_basename (_tmp9_);
	_tmp11_ = (gchar*) _tmp10_;
	_tmp12_ = string_to_string (_tmp11_);
	_tmp13_ = g_strconcat ("full_", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = bird_font_get_child (_tmp8_, _tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	png_image = _tmp16_;
	_tmp17_ = png_image;
	if (g_file_query_exists (_tmp17_, NULL)) {
		GFile* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = png_image;
		_tmp19_ = g_file_get_path (_tmp18_);
		_g_free0 (self->priv->path);
		self->priv->path = (gchar*) _tmp19_;
		_g_object_unref0 (png_image);
		_g_object_unref0 (original);
		_g_object_unref0 (folder);
		_g_object_unref0 (font);
		_g_free0 (file_name);
		return;
	}
	_tmp20_ = self->priv->path;
	if (bird_font_is_null (_tmp20_)) {
		g_warning ("BackgroundImage.vala:363: Background image path is null.");
		_g_object_unref0 (png_image);
		_g_object_unref0 (original);
		_g_object_unref0 (folder);
		_g_object_unref0 (font);
		_g_free0 (file_name);
		return;
	}
	{
		GFile* _tmp21_;
		_tmp21_ = folder;
		g_file_make_directory (_tmp21_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_warning ("BackgroundImage.vala:370: %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (png_image);
		_g_object_unref0 (original);
		_g_object_unref0 (folder);
		_g_object_unref0 (font);
		_g_free0 (file_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp24_ = bird_font_main_window_native_window;
	_tmp25_ = self->priv->path;
	_tmp26_ = g_strdup (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = png_image;
	_tmp29_ = g_file_get_path (_tmp28_);
	_tmp30_ = (gchar*) _tmp29_;
	_tmp31_ = g_strdup (_tmp30_);
	_tmp32_ = _tmp31_;
	converted = bird_font_native_window_convert_to_png (_tmp24_, _tmp27_, _tmp32_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp27_);
	if (!converted) {
		g_warning ("BackgroundImage.vala:376: Failed to convert image: $(path)");
		_g_object_unref0 (png_image);
		_g_object_unref0 (original);
		_g_object_unref0 (folder);
		_g_object_unref0 (font);
		_g_free0 (file_name);
		return;
	}
	_tmp33_ = png_image;
	_tmp34_ = g_file_get_path (_tmp33_);
	_g_free0 (self->priv->path);
	self->priv->path = (gchar*) _tmp34_;
	_g_object_unref0 (png_image);
	_g_object_unref0 (original);
	_g_object_unref0 (folder);
	_g_object_unref0 (font);
	_g_free0 (file_name);
}

static BirdFontScaledBackgrounds*
bird_font_background_image_get_image (BirdFontBackgroundImage* self)
{
	BirdFontScaledBackgrounds* _tmp0_;
	BirdFontScaledBackgrounds* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_background_image_get_scaled_backgrounds (self);
	result = _tmp0_;
	return result;
}

void
bird_font_background_image_start_rotation_preview (BirdFontBackgroundImage* self)
{
	g_return_if_fail (self != NULL);
	self->priv->preview_img_rotation = self->img_rotation;
}

void
bird_font_background_image_preview_img_rotation_from_coordinate (BirdFontBackgroundImage* self,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gdouble view_zoom)
{
	gdouble rotation = 0.0;
	BirdFontScaledBackgrounds* backgrounds = NULL;
	BirdFontScaledBackground* backgound = NULL;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = bird_font_background_image_get_img_rotation_from_coordinate (self, x, y, &_tmp0_);
	rotation = _tmp0_;
	if (_tmp1_) {
		BirdFontScaledBackgrounds* _tmp2_;
		BirdFontScaledBackgrounds* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		BirdFontScaledBackground* _tmp6_;
		_tmp2_ = bird_font_background_image_get_scaled_backgrounds (self);
		_g_object_unref0 (backgrounds);
		backgrounds = _tmp2_;
		_tmp3_ = backgrounds;
		_tmp4_ = bird_font_background_image_get_img_scale_x (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = bird_font_scaled_backgrounds_get_image (_tmp3_, view_zoom * _tmp5_);
		_g_object_unref0 (backgound);
		backgound = _tmp6_;
		self->img_rotation = rotation;
		if (!self->high_contrast) {
			BirdFontScaledBackground* _tmp7_;
			_tmp7_ = backgound;
			bird_font_scaled_background_rotate (_tmp7_, rotation - self->priv->preview_img_rotation);
		} else {
			_cairo_surface_destroy0 (self->priv->contrast_image);
			self->priv->contrast_image = NULL;
		}
	}
	_g_object_unref0 (backgound);
	_g_object_unref0 (backgrounds);
}

static void
_bird_font_background_image_cache_scaled_image_bird_font_task_runnable (gpointer self)
{
	bird_font_background_image_cache_scaled_image ((BirdFontBackgroundImage*) self);
}

void
bird_font_background_image_set_img_rotation_from_coordinate (BirdFontBackgroundImage* self,
                                                             gdouble x,
                                                             gdouble y)
{
	gdouble rotation = 0.0;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = bird_font_background_image_get_img_rotation_from_coordinate (self, x, y, &_tmp0_);
	rotation = _tmp0_;
	if (_tmp1_) {
		BirdFontTask* task = NULL;
		BirdFontTask* _tmp2_;
		BirdFontTask* _tmp3_;
		self->img_rotation = rotation;
		_tmp2_ = bird_font_task_new (_bird_font_background_image_cache_scaled_image_bird_font_task_runnable, g_object_ref (self), g_object_unref, FALSE);
		task = _tmp2_;
		_tmp3_ = task;
		bird_font_main_window_run_blocking_task (_tmp3_);
		_g_object_unref0 (task);
	}
}

static void
bird_font_background_image_cache_scaled_image (BirdFontBackgroundImage* self)
{
	BirdFontScaledBackgrounds* _tmp0_;
	BirdFontScaledBackgrounds* _tmp1_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->scaled);
	self->priv->scaled = NULL;
	_cairo_surface_destroy0 (self->priv->contrast_image);
	self->priv->contrast_image = NULL;
	_tmp0_ = bird_font_background_image_get_image (self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}

gboolean
bird_font_background_image_get_img_rotation_from_coordinate (BirdFontBackgroundImage* self,
                                                             gdouble x,
                                                             gdouble y,
                                                             gdouble* rotation)
{
	gdouble _vala_rotation = 0.0;
	gdouble bcx = 0.0;
	gdouble bcy = 0.0;
	gdouble a = 0.0;
	gdouble b = 0.0;
	gdouble c = 0.0;
	gdouble length = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_ = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_rotation = (gdouble) 0;
	_tmp0_ = bird_font_background_image_get_img_middle_x (self);
	_tmp1_ = _tmp0_;
	bcx = _tmp1_;
	_tmp2_ = bird_font_background_image_get_img_middle_y (self);
	_tmp3_ = _tmp2_;
	bcy = _tmp3_;
	a = bcx - x;
	b = bcy - y;
	c = (a * a) + (b * b);
	if (c == ((gdouble) 0)) {
		result = FALSE;
		if (rotation) {
			*rotation = _vala_rotation;
		}
		return result;
	}
	length = sqrt (fabs (c));
	if (c < ((gdouble) 0)) {
		length = -length;
	}
	if (y > bcy) {
		_tmp4_ = acos (a / length) + G_PI;
	} else {
		_tmp4_ = (-acos (a / length)) + G_PI;
	}
	_vala_rotation = _tmp4_;
	result = TRUE;
	if (rotation) {
		*rotation = _vala_rotation;
	}
	return result;
}

void
bird_font_background_image_set_img_scale (BirdFontBackgroundImage* self,
                                          gdouble xs,
                                          gdouble ys)
{
	g_return_if_fail (self != NULL);
	bird_font_background_image_set_img_scale_x (self, xs);
	bird_font_background_image_set_img_scale_y (self, ys);
}

void
bird_font_background_image_reset_scale (BirdFontBackgroundImage* self,
                                        BirdFontGlyph* g)
{
	gdouble w = 0.0;
	gdouble h = 0.0;
	BirdFontLine* _tmp0_;
	BirdFontLine* _tmp1_;
	BirdFontLine* _tmp2_;
	BirdFontLine* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	w = bird_font_glyph_get_width (g);
	h = (gdouble) bird_font_glyph_get_height (g);
	bird_font_background_image_set_img_scale_x (self, (gdouble) 1);
	bird_font_background_image_set_img_scale_y (self, (gdouble) 1);
	_tmp0_ = bird_font_glyph_get_line (g, "left");
	_tmp1_ = _tmp0_;
	bird_font_background_image_set_img_offset_x (self, _tmp1_->pos);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = bird_font_glyph_get_line (g, "top");
	_tmp3_ = _tmp2_;
	bird_font_background_image_set_img_offset_y (self, _tmp3_->pos);
	_g_object_unref0 (_tmp3_);
}

void
bird_font_background_image_draw (BirdFontBackgroundImage* self,
                                 cairo_t* cr,
                                 BirdFontWidgetAllocation* allocation,
                                 gdouble view_offset_x,
                                 gdouble view_offset_y,
                                 gdouble view_zoom)
{
	gdouble scale_x = 0.0;
	gdouble scale_y = 0.0;
	gdouble image_scale_x = 0.0;
	gdouble image_scale_y = 0.0;
	BirdFontScaledBackgrounds* backgrounds = NULL;
	BirdFontScaledBackgrounds* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	gboolean _tmp3_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	cairo_surface_t* scaled_image = NULL;
	cairo_t* scaled_context = NULL;
	cairo_surface_t* _tmp75_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = bird_font_background_image_get_scaled_backgrounds (self);
	backgrounds = _tmp0_;
	_tmp1_ = bird_font_background_image_get_img (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = G_UNLIKELY (cairo_surface_status (_tmp2_) != CAIRO_STATUS_SUCCESS);
	_cairo_surface_destroy0 (_tmp2_);
	if (_tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		BirdFontGlyph* _tmp8_;
		BirdFontGlyph* _tmp9_;
		_tmp4_ = self->priv->path;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Background image is invalid. (\"", _tmp5_, "\")\n", NULL);
		_tmp7_ = _tmp6_;
		g_warning ("BackgroundImage.vala:479: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = bird_font_main_window_get_current_glyph ();
		_tmp9_ = _tmp8_;
		bird_font_glyph_set_background_visible (_tmp9_, FALSE);
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (backgrounds);
		return;
	}
	_tmp10_ = bird_font_background_image_get_img_scale_x (self);
	_tmp11_ = _tmp10_;
	image_scale_x = _tmp11_;
	_tmp12_ = bird_font_background_image_get_img_scale_y (self);
	_tmp13_ = _tmp12_;
	image_scale_y = _tmp13_;
	if (!self->high_contrast) {
		BirdFontScaledBackground* scaled = NULL;
		BirdFontScaledBackgroundPart* part = NULL;
		BirdFontScaledBackgrounds* _tmp14_;
		gdouble _tmp15_;
		gdouble _tmp16_;
		BirdFontScaledBackground* _tmp17_;
		gdouble part_offset_x = 0.0;
		gdouble _tmp18_;
		gdouble _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		BirdFontScaledBackground* _tmp22_;
		gdouble part_offset_y = 0.0;
		gdouble _tmp23_;
		gdouble _tmp24_;
		gdouble _tmp25_;
		gdouble _tmp26_;
		BirdFontScaledBackground* _tmp27_;
		gdouble part_allocation_width = 0.0;
		gdouble part_allocation_height = 0.0;
		BirdFontScaledBackground* _tmp28_;
		BirdFontScaledBackgroundPart* _tmp29_;
		BirdFontScaledBackgroundPart* _tmp30_;
		BirdFontScaledBackgroundPart* _tmp31_;
		cairo_surface_t* _tmp32_;
		cairo_surface_t* _tmp33_;
		cairo_t* _tmp34_;
		cairo_t* _tmp35_;
		gdouble scaled_x = 0.0;
		BirdFontScaledBackgroundPart* _tmp36_;
		gdouble scaled_y = 0.0;
		BirdFontScaledBackgroundPart* _tmp37_;
		gdouble _tmp38_;
		gdouble _tmp39_;
		gdouble _tmp40_;
		gdouble _tmp41_;
		cairo_t* _tmp42_;
		BirdFontScaledBackgroundPart* _tmp43_;
		cairo_surface_t* _tmp44_;
		cairo_surface_t* _tmp45_;
		cairo_t* _tmp46_;
		_tmp14_ = backgrounds;
		_tmp15_ = bird_font_background_image_get_img_scale_x (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = bird_font_scaled_backgrounds_get_image (_tmp14_, view_zoom * _tmp16_);
		_g_object_unref0 (scaled);
		scaled = _tmp17_;
		_tmp18_ = bird_font_background_image_get_img_offset_x (self);
		_tmp19_ = _tmp18_;
		part_offset_x = _tmp19_ - view_offset_x;
		_tmp20_ = bird_font_background_image_get_img_scale_x (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = scaled;
		part_offset_x /= _tmp21_ / bird_font_scaled_background_get_scale (_tmp22_);
		part_offset_x = -part_offset_x;
		_tmp23_ = bird_font_background_image_get_img_offset_y (self);
		_tmp24_ = _tmp23_;
		part_offset_y = _tmp24_ - view_offset_y;
		_tmp25_ = bird_font_background_image_get_img_scale_y (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = scaled;
		part_offset_y /= _tmp26_ / bird_font_scaled_background_get_scale (_tmp27_);
		part_offset_y = -part_offset_y;
		part_allocation_height = (gdouble) allocation->height;
		part_allocation_height /= view_zoom;
		part_allocation_height /= image_scale_x;
		part_allocation_width = (gdouble) allocation->width;
		part_allocation_width /= view_zoom;
		part_allocation_width /= image_scale_y;
		_tmp28_ = scaled;
		_tmp29_ = bird_font_scaled_background_get_part (_tmp28_, part_offset_x, part_offset_y, (gint) part_allocation_width, (gint) part_allocation_height);
		_g_object_unref0 (part);
		part = _tmp29_;
		scale_x = view_zoom * image_scale_x;
		scale_y = view_zoom * image_scale_y;
		_tmp30_ = part;
		scale_x /= bird_font_scaled_background_part_get_scale (_tmp30_);
		_tmp31_ = part;
		scale_y /= bird_font_scaled_background_part_get_scale (_tmp31_);
		_tmp32_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, allocation->width, allocation->height);
		_cairo_surface_destroy0 (scaled_image);
		scaled_image = _tmp32_;
		_tmp33_ = scaled_image;
		_tmp34_ = cairo_create (_tmp33_);
		_cairo_destroy0 (scaled_context);
		scaled_context = _tmp34_;
		_tmp35_ = scaled_context;
		cairo_scale (_tmp35_, scale_x, scale_y);
		_tmp36_ = part;
		scaled_x = (gdouble) _tmp36_->offset_x;
		_tmp37_ = part;
		scaled_y = (gdouble) _tmp37_->offset_y;
		_tmp38_ = bird_font_background_image_get_img_offset_x (self);
		_tmp39_ = _tmp38_;
		scaled_x += view_zoom * ((_tmp39_ / scale_x) - (view_offset_x / scale_x));
		_tmp40_ = bird_font_background_image_get_img_offset_y (self);
		_tmp41_ = _tmp40_;
		scaled_y += view_zoom * ((_tmp41_ / scale_y) - (view_offset_y / scale_y));
		_tmp42_ = scaled_context;
		_tmp43_ = part;
		_tmp44_ = bird_font_scaled_background_part_get_image (_tmp43_);
		_tmp45_ = _tmp44_;
		cairo_set_source_surface (_tmp42_, _tmp45_, scaled_x, scaled_y);
		_cairo_surface_destroy0 (_tmp45_);
		_tmp46_ = scaled_context;
		cairo_paint (_tmp46_);
		_g_object_unref0 (part);
		_g_object_unref0 (scaled);
	} else {
		cairo_surface_t* contrast = NULL;
		cairo_surface_t* _tmp47_;
		gdouble _tmp48_;
		gdouble _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		cairo_surface_t* _tmp52_;
		gdouble _tmp53_;
		gdouble _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		cairo_surface_t* _tmp57_;
		cairo_surface_t* _tmp58_;
		cairo_t* contrast_context = NULL;
		cairo_surface_t* _tmp59_;
		cairo_t* _tmp60_;
		cairo_t* _tmp61_;
		cairo_t* _tmp62_;
		cairo_t* _tmp63_;
		cairo_t* _tmp64_;
		cairo_t* _tmp65_;
		cairo_t* _tmp66_;
		cairo_t* _tmp67_;
		cairo_surface_t* _tmp68_;
		gdouble _tmp69_;
		gdouble _tmp70_;
		gdouble _tmp71_;
		gdouble _tmp72_;
		cairo_t* _tmp73_;
		cairo_t* _tmp74_;
		_tmp47_ = bird_font_background_image_get_contrast_image (self);
		contrast = _tmp47_;
		_tmp48_ = bird_font_background_image_get_img_scale_x (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = bird_font_background_image_get_size_margin (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = contrast;
		image_scale_x = _tmp49_ * (((gdouble) _tmp51_) / cairo_image_surface_get_width (_tmp52_));
		_tmp53_ = bird_font_background_image_get_img_scale_y (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = bird_font_background_image_get_size_margin (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = contrast;
		image_scale_y = _tmp54_ * (((gdouble) _tmp56_) / cairo_image_surface_get_height (_tmp57_));
		_tmp58_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, allocation->width, allocation->height);
		_cairo_surface_destroy0 (scaled_image);
		scaled_image = _tmp58_;
		_tmp59_ = scaled_image;
		_tmp60_ = cairo_create (_tmp59_);
		contrast_context = _tmp60_;
		_tmp61_ = contrast_context;
		cairo_save (_tmp61_);
		_tmp62_ = contrast_context;
		cairo_set_source_rgba (_tmp62_, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp63_ = contrast_context;
		cairo_rectangle (_tmp63_, (gdouble) 0, (gdouble) 0, (gdouble) allocation->width, (gdouble) allocation->height);
		_tmp64_ = contrast_context;
		cairo_fill (_tmp64_);
		scale_x = view_zoom * image_scale_x;
		scale_y = view_zoom * image_scale_y;
		_tmp65_ = contrast_context;
		cairo_scale (_tmp65_, scale_x, scale_y);
		_tmp66_ = contrast_context;
		cairo_translate (_tmp66_, (-view_offset_x) / image_scale_x, (-view_offset_y) / image_scale_y);
		_tmp67_ = contrast_context;
		_tmp68_ = contrast;
		_tmp69_ = bird_font_background_image_get_img_offset_x (self);
		_tmp70_ = _tmp69_;
		_tmp71_ = bird_font_background_image_get_img_offset_y (self);
		_tmp72_ = _tmp71_;
		cairo_set_source_surface (_tmp67_, _tmp68_, _tmp70_ / image_scale_x, _tmp72_ / image_scale_y);
		_tmp73_ = contrast_context;
		cairo_paint (_tmp73_);
		_tmp74_ = contrast_context;
		cairo_restore (_tmp74_);
		_cairo_destroy0 (contrast_context);
		_cairo_surface_destroy0 (contrast);
	}
	cairo_save (cr);
	_tmp75_ = scaled_image;
	cairo_set_source_surface (cr, _tmp75_, (gdouble) 0, (gdouble) 0);
	cairo_paint (cr);
	cairo_restore (cr);
	_cairo_destroy0 (scaled_context);
	_cairo_surface_destroy0 (scaled_image);
	_g_object_unref0 (backgrounds);
}

cairo_surface_t*
bird_font_background_image_get_padded_image (BirdFontBackgroundImage* self)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble iw = 0.0;
	gdouble ih = 0.0;
	gint h = 0;
	gint w = 0;
	gdouble oy = 0.0;
	gdouble ox = 0.0;
	cairo_surface_t* o = NULL;
	cairo_surface_t* sg = NULL;
	cairo_t* cg = NULL;
	gdouble wc = 0.0;
	gdouble hc = 0.0;
	cairo_surface_t* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_t* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	cairo_surface_t* _tmp11_;
	cairo_surface_t* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	cairo_surface_t* _tmp17_;
	cairo_surface_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	cairo_surface_t* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_background_image_get_original (self);
	_cairo_surface_destroy0 (o);
	o = _tmp0_;
	_tmp1_ = bird_font_background_image_get_size_margin (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_background_image_get_size_margin (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = cairo_surface_create_similar (o, cairo_surface_get_content (o), _tmp2_, _tmp4_);
	_cairo_surface_destroy0 (sg);
	sg = _tmp5_;
	_tmp6_ = cairo_create (sg);
	_cairo_destroy0 (cg);
	cg = _tmp6_;
	wc = bird_font_background_image_get_margin_width (self);
	hc = bird_font_background_image_get_margin_height (self);
	bird_font_theme_color (cg, "Background 1");
	_tmp7_ = bird_font_background_image_get_size_margin (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = bird_font_background_image_get_size_margin (self);
	_tmp10_ = _tmp9_;
	cairo_rectangle (cg, (gdouble) 0, (gdouble) 0, (gdouble) _tmp8_, (gdouble) _tmp10_);
	cairo_fill (cg);
	_tmp11_ = bird_font_background_image_get_img (self);
	_tmp12_ = _tmp11_;
	cairo_set_source_surface (cg, _tmp12_, wc, hc);
	_cairo_surface_destroy0 (_tmp12_);
	cairo_paint (cg);
	_tmp13_ = bird_font_background_image_get_img_offset_x (self);
	_tmp14_ = _tmp13_;
	x = (gdouble) bird_font_glyph_reverse_path_coordinate_x (_tmp14_);
	_tmp15_ = bird_font_background_image_get_img_offset_y (self);
	_tmp16_ = _tmp15_;
	y = (gdouble) bird_font_glyph_reverse_path_coordinate_y (_tmp16_);
	_tmp17_ = bird_font_background_image_get_img (self);
	_tmp18_ = _tmp17_;
	ih = (gdouble) ((gint) cairo_image_surface_get_height (_tmp18_));
	_cairo_surface_destroy0 (_tmp18_);
	_tmp19_ = bird_font_background_image_get_img (self);
	_tmp20_ = _tmp19_;
	iw = (gdouble) ((gint) cairo_image_surface_get_width (_tmp20_));
	_cairo_surface_destroy0 (_tmp20_);
	w = (gint) iw;
	h = (gint) ih;
	_tmp21_ = bird_font_background_image_get_size_margin (self);
	_tmp22_ = _tmp21_;
	oy = (gdouble) _tmp22_;
	_tmp23_ = bird_font_background_image_get_size_margin (self);
	_tmp24_ = _tmp23_;
	ox = (gdouble) _tmp24_;
	result = sg;
	_cairo_destroy0 (cg);
	_cairo_surface_destroy0 (o);
	return result;
}

static cairo_surface_t*
bird_font_background_image_rotate (BirdFontBackgroundImage* self,
                                   cairo_surface_t* padded_image)
{
	cairo_surface_t* _tmp0_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (padded_image != NULL, NULL);
	_tmp0_ = bird_font_background_image_rotate_image (padded_image, self->img_rotation);
	result = _tmp0_;
	return result;
}

cairo_surface_t*
bird_font_background_image_rotate_image (cairo_surface_t* padded_image,
                                         gdouble angle)
{
	cairo_surface_t* s = NULL;
	cairo_t* c = NULL;
	gint w = 0;
	gint h = 0;
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_surface_t* result;
	g_return_val_if_fail (padded_image != NULL, NULL);
	w = cairo_image_surface_get_width (padded_image);
	h = cairo_image_surface_get_height (padded_image);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, w, h);
	_cairo_surface_destroy0 (s);
	s = _tmp0_;
	_tmp1_ = cairo_create (s);
	_cairo_destroy0 (c);
	c = _tmp1_;
	cairo_save (c);
	cairo_translate (c, w * 0.5, h * 0.5);
	cairo_rotate (c, angle);
	cairo_translate (c, (-w) * 0.5, (-h) * 0.5);
	cairo_set_source_surface (c, padded_image, (gdouble) 0, (gdouble) 0);
	cairo_paint (c);
	cairo_restore (c);
	result = s;
	_cairo_destroy0 (c);
	return result;
}

void
bird_font_background_image_handler_release (BirdFontBackgroundImage* self,
                                            gdouble nx,
                                            gdouble ny)
{
	g_return_if_fail (self != NULL);
	self->selected_handle = 0;
	bird_font_background_image_handler_move (self, nx, ny);
}

void
bird_font_background_image_handler_press (BirdFontBackgroundImage* self,
                                          gdouble nx,
                                          gdouble ny)
{
	g_return_if_fail (self != NULL);
	if (bird_font_background_image_is_over_rotate (self, nx, ny)) {
		self->selected_handle = 2;
	} else {
		if (bird_font_background_image_is_over_resize (self, nx, ny)) {
			self->selected_handle = 1;
		} else {
			self->selected_handle = 0;
		}
	}
}

static gboolean
bird_font_background_image_is_over_rotate (BirdFontBackgroundImage* self,
                                           gdouble nx,
                                           gdouble ny)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble d = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_background_image_get_img_middle_x (self);
	_tmp1_ = _tmp0_;
	x = (gdouble) bird_font_glyph_reverse_path_coordinate_x (_tmp1_);
	_tmp2_ = bird_font_background_image_get_img_middle_y (self);
	_tmp3_ = _tmp2_;
	y = (gdouble) bird_font_glyph_reverse_path_coordinate_y (_tmp3_);
	x += cos (self->img_rotation) * 75;
	y += sin (self->img_rotation) * 75;
	d = bird_font_path_distance (x, nx, y, ny);
	result = d < ((gdouble) 15);
	return result;
}

static gboolean
bird_font_background_image_is_over_resize (BirdFontBackgroundImage* self,
                                           gdouble nx,
                                           gdouble ny)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble size = 0.0;
	gboolean inx = FALSE;
	gboolean iny = FALSE;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_surface_t* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	size = (gdouble) 12;
	_tmp0_ = bird_font_background_image_get_img_middle_x (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img_scale_x (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_background_image_get_img (self);
	_tmp5_ = _tmp4_;
	x = _tmp1_ - ((_tmp3_ * cairo_image_surface_get_width (_tmp5_)) / 2);
	_cairo_surface_destroy0 (_tmp5_);
	_tmp6_ = bird_font_background_image_get_img_middle_y (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_background_image_get_img_scale_y (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_background_image_get_img (self);
	_tmp11_ = _tmp10_;
	y = _tmp7_ - ((_tmp9_ * cairo_image_surface_get_height (_tmp11_)) / 2);
	_cairo_surface_destroy0 (_tmp11_);
	x = (gdouble) bird_font_glyph_reverse_path_coordinate_x (x);
	y = (gdouble) bird_font_glyph_reverse_path_coordinate_y (y);
	_tmp12_ = nx;
	inx = ((x - size) <= _tmp12_) && (_tmp12_ <= (x + size));
	_tmp13_ = ny;
	iny = ((y - size) <= _tmp13_) && (_tmp13_ <= (y + size));
	if (inx) {
		_tmp14_ = iny;
	} else {
		_tmp14_ = FALSE;
	}
	result = _tmp14_;
	return result;
}

void
bird_font_background_image_handler_move (BirdFontBackgroundImage* self,
                                         gdouble nx,
                                         gdouble ny)
{
	gint prev_handle = 0;
	g_return_if_fail (self != NULL);
	prev_handle = self->active_handle;
	if (bird_font_background_image_is_over_rotate (self, nx, ny)) {
		self->active_handle = 2;
	} else {
		if (bird_font_background_image_is_over_resize (self, nx, ny)) {
			self->active_handle = 1;
		} else {
			self->active_handle = 0;
		}
	}
	if (prev_handle != self->active_handle) {
		bird_font_glyph_canvas_redraw ();
	}
}

void
bird_font_background_image_draw_handle (BirdFontBackgroundImage* self,
                                        cairo_t* cr,
                                        BirdFontGlyph* g)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (g != NULL);
	bird_font_background_image_draw_resize_handle (self, cr, g);
	bird_font_background_image_draw_rotate_handle (self, cr, g);
}

void
bird_font_background_image_draw_resize_handle (BirdFontBackgroundImage* self,
                                               cairo_t* cr,
                                               BirdFontGlyph* g)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_surface_t* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (g != NULL);
	cairo_save (cr);
	bird_font_theme_color (cr, "Menu Background");
	_tmp0_ = bird_font_background_image_get_img_middle_x (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img_scale_x (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_background_image_get_img (self);
	_tmp5_ = _tmp4_;
	x = _tmp1_ - ((_tmp3_ * cairo_image_surface_get_width (_tmp5_)) / 2);
	_cairo_surface_destroy0 (_tmp5_);
	_tmp6_ = bird_font_background_image_get_img_middle_y (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_background_image_get_img_scale_y (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_background_image_get_img (self);
	_tmp11_ = _tmp10_;
	y = _tmp7_ - ((_tmp9_ * cairo_image_surface_get_height (_tmp11_)) / 2);
	_cairo_surface_destroy0 (_tmp11_);
	x = (gdouble) bird_font_glyph_reverse_path_coordinate_x (x);
	y = (gdouble) bird_font_glyph_reverse_path_coordinate_y (y);
	bird_font_background_image_draw_handle_triangle (self, x, y, cr, g, 6, (gdouble) 1);
	cairo_restore (cr);
}

void
bird_font_background_image_draw_rotate_handle (BirdFontBackgroundImage* self,
                                               cairo_t* cr,
                                               BirdFontGlyph* g)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble hx = 0.0;
	gdouble hy = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble ivz = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (g != NULL);
	ivz = 1.0 / g->view_zoom;
	cairo_save (cr);
	cairo_scale (cr, g->view_zoom, g->view_zoom);
	if (self->selected_handle == 2) {
		bird_font_theme_color (cr, "Highlighted 1");
	} else {
		if (self->active_handle == 2) {
			bird_font_theme_color (cr, "Default Background");
		} else {
			bird_font_theme_color (cr, "Menu Background");
		}
	}
	_tmp0_ = bird_font_background_image_get_img_offset_x (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_size_margin (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_background_image_get_img_scale_x (self);
	_tmp5_ = _tmp4_;
	x = (_tmp1_ - g->view_offset_x) + ((_tmp3_ / 2) * _tmp5_);
	_tmp6_ = bird_font_background_image_get_img_offset_y (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_background_image_get_size_margin (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_background_image_get_img_scale_y (self);
	_tmp11_ = _tmp10_;
	y = (_tmp7_ - g->view_offset_y) + ((_tmp9_ / 2) * _tmp11_);
	cairo_rectangle (cr, x, y, 5 * ivz, 5 * ivz);
	cairo_fill (cr);
	hx = (cos (self->img_rotation) * 75) * ivz;
	hy = (sin (self->img_rotation) * 75) * ivz;
	x2 = x + hx;
	y2 = y + hy;
	cairo_rectangle (cr, x2, y2, 5 * ivz, 5 * ivz);
	cairo_fill (cr);
	cairo_set_line_width (cr, ivz);
	cairo_move_to (cr, x + (2.5 * ivz), y + (2.5 * ivz));
	cairo_line_to (cr, x2 + (2.5 * ivz), y2 + (2.5 * ivz));
	cairo_stroke (cr);
	cairo_restore (cr);
}

static void
bird_font_background_image_draw_handle_triangle (BirdFontBackgroundImage* self,
                                                 gdouble x,
                                                 gdouble y,
                                                 cairo_t* cr,
                                                 BirdFontGlyph* g,
                                                 gint direction,
                                                 gdouble s)
{
	gint _tmp0_;
	gdouble ivz = 0.0;
	gdouble size = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = direction;
	_vala_return_if_fail ((0 < _tmp0_) && (_tmp0_ < 8), "0 < direction < 8");
	ivz = 1.0 / g->view_zoom;
	cairo_save (cr);
	cairo_set_line_width (cr, ivz);
	if (self->selected_handle == 1) {
		bird_font_theme_color (cr, "Highlighted 1");
	} else {
		if (self->active_handle == 1) {
			bird_font_theme_color (cr, "Default Background");
		} else {
			bird_font_theme_color (cr, "Menu Background");
		}
	}
	size = 8 * s;
	cairo_scale (cr, (gdouble) 1, (gdouble) 1);
	cairo_new_path (cr);
	if (direction == 1) {
		cairo_move_to (cr, x - size, y - size);
		cairo_line_to (cr, x + size, y - size);
		cairo_line_to (cr, x - size, y + size);
	}
	if (direction == 6) {
		cairo_move_to (cr, x + size, y + size);
		cairo_line_to (cr, x - size, y + size);
		cairo_line_to (cr, x - size, y - size);
	}
	cairo_close_path (cr);
	cairo_fill (cr);
	cairo_restore (cr);
}

void
bird_font_background_image_update_background (BirdFontBackgroundImage* self)
{
	g_return_if_fail (self != NULL);
	_cairo_surface_destroy0 (self->priv->background_image);
	self->priv->background_image = NULL;
	_cairo_surface_destroy0 (self->priv->contrast_image);
	self->priv->contrast_image = NULL;
	bird_font_glyph_canvas_redraw ();
	g_signal_emit (self, bird_font_background_image_signals[BIRD_FONT_BACKGROUND_IMAGE_UPDATED_SIGNAL], 0);
}

static cairo_surface_t*
bird_font_background_image_get_contrast_image (BirdFontBackgroundImage* self)
{
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->contrast_image;
	if (_tmp0_ == NULL) {
		cairo_surface_t* _tmp1_;
		_tmp1_ = bird_font_background_image_get_contrast_image_surface (self);
		_cairo_surface_destroy0 (self->priv->contrast_image);
		self->priv->contrast_image = _tmp1_;
	}
	_tmp2_ = self->priv->contrast_image;
	_tmp3_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp2_);
	result = _tmp3_;
	return result;
}

static cairo_surface_t*
bird_font_background_image_get_contrast_image_surface (BirdFontBackgroundImage* self)
{
	cairo_surface_t* s = NULL;
	cairo_t* c = NULL;
	cairo_surface_t* sg = NULL;
	gint scaled_width = 0;
	guchar* pix_buff = NULL;
	gint pix_buff_length1 = 0;
	gint _pix_buff_size_ = 0;
	gint i = 0;
	gint len = 0;
	gdouble thres = 0.0;
	gint stride = 0;
	cairo_surface_t* img = NULL;
	cairo_surface_t* ns = NULL;
	gdouble trace_resolution = 0.0;
	BirdFontSpinButton* _tmp0_;
	gdouble threshold = 0.0;
	BirdFontSpinButton* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_surface_t* _tmp16_;
	cairo_surface_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_surface_t* _tmp22_;
	cairo_surface_t* _tmp23_;
	cairo_surface_t* _tmp24_;
	guchar* _tmp25_;
	cairo_surface_t* _tmp26_;
	cairo_surface_t* _tmp27_;
	guint8* outline_img = NULL;
	guint8* _tmp28_;
	cairo_surface_t* _tmp41_;
	guint8* _tmp92_;
	cairo_surface_t* _tmp93_;
	cairo_surface_t* _tmp94_;
	cairo_surface_t* _tmp95_;
	cairo_surface_t* _tmp96_;
	cairo_surface_t* _tmp97_;
	cairo_surface_t* _tmp98_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_drawing_tools_auto_trace_resolution;
	trace_resolution = bird_font_spin_button_get_value (_tmp0_);
	_tmp1_ = bird_font_drawing_tools_background_threshold;
	threshold = bird_font_spin_button_get_value (_tmp1_);
	thres = (threshold - 0.5) * 255;
	scaled_width = (gint) (600 * trace_resolution);
	_tmp2_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, scaled_width, scaled_width);
	_cairo_surface_destroy0 (s);
	s = _tmp2_;
	_tmp3_ = bird_font_background_image_get_padded_image (self);
	_cairo_surface_destroy0 (sg);
	sg = (cairo_surface_t*) _tmp3_;
	_tmp4_ = sg;
	_tmp5_ = bird_font_background_image_rotate (self, _tmp4_);
	_cairo_surface_destroy0 (sg);
	sg = _tmp5_;
	_tmp6_ = s;
	_tmp7_ = cairo_create (_tmp6_);
	_cairo_destroy0 (c);
	c = _tmp7_;
	_tmp8_ = c;
	cairo_save (_tmp8_);
	_tmp9_ = c;
	bird_font_theme_color (_tmp9_, "Background 1");
	_tmp10_ = c;
	cairo_rectangle (_tmp10_, (gdouble) 0, (gdouble) 0, (gdouble) scaled_width, (gdouble) scaled_width);
	_tmp11_ = c;
	cairo_fill (_tmp11_);
	_tmp12_ = c;
	cairo_translate (_tmp12_, scaled_width * 0.5, scaled_width * 0.5);
	_tmp13_ = c;
	cairo_rotate (_tmp13_, self->img_rotation);
	_tmp14_ = c;
	cairo_translate (_tmp14_, (-scaled_width) * 0.5, (-scaled_width) * 0.5);
	_tmp15_ = c;
	_tmp16_ = sg;
	_tmp17_ = sg;
	cairo_scale (_tmp15_, ((gdouble) scaled_width) / cairo_image_surface_get_width (_tmp16_), ((gdouble) scaled_width) / cairo_image_surface_get_height (_tmp17_));
	_tmp18_ = c;
	_tmp19_ = sg;
	cairo_set_source_surface (_tmp18_, _tmp19_, (gdouble) 0, (gdouble) 0);
	_tmp20_ = c;
	cairo_paint (_tmp20_);
	_tmp21_ = c;
	cairo_restore (_tmp21_);
	_tmp22_ = s;
	_tmp23_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp22_);
	_cairo_surface_destroy0 (img);
	img = _tmp23_;
	_tmp24_ = img;
	_tmp25_ = cairo_image_surface_get_data (_tmp24_);
	pix_buff = _tmp25_;
	pix_buff_length1 = -1;
	_pix_buff_size_ = pix_buff_length1;
	_tmp26_ = s;
	_tmp27_ = s;
	len = cairo_image_surface_get_height (_tmp26_) * cairo_image_surface_get_stride (_tmp27_);
	_tmp28_ = g_new0 (guint8, len);
	outline_img = _tmp28_;
	{
		gboolean _tmp29_ = FALSE;
		i = 0;
		_tmp29_ = TRUE;
		while (TRUE) {
			guint8 o = 0U;
			guchar* _tmp30_;
			gint _tmp30__length1;
			guchar _tmp31_;
			guchar* _tmp32_;
			gint _tmp32__length1;
			guchar _tmp33_;
			guchar* _tmp34_;
			gint _tmp34__length1;
			guchar _tmp35_;
			gint _tmp36_ = 0;
			guint8 bw = 0U;
			guint8* _tmp37_;
			guint8* _tmp38_;
			guint8* _tmp39_;
			guint8* _tmp40_;
			if (!_tmp29_) {
				i += 4;
			}
			_tmp29_ = FALSE;
			if (!(i < (len - 4))) {
				break;
			}
			_tmp30_ = pix_buff;
			_tmp30__length1 = pix_buff_length1;
			_tmp31_ = _tmp30_[i];
			_tmp32_ = pix_buff;
			_tmp32__length1 = pix_buff_length1;
			_tmp33_ = _tmp32_[i + 1];
			_tmp34_ = pix_buff;
			_tmp34__length1 = pix_buff_length1;
			_tmp35_ = _tmp34_[i + 2];
			o = (guint8) (((_tmp31_ + _tmp33_) + _tmp35_) / 3.0);
			if (((gdouble) o) < thres) {
				_tmp36_ = 0;
			} else {
				_tmp36_ = 255;
			}
			bw = (guint8) _tmp36_;
			_tmp37_ = outline_img;
			_tmp37_[i] = bw;
			_tmp38_ = outline_img;
			_tmp38_[i + 1] = bw;
			_tmp39_ = outline_img;
			_tmp39_[i + 2] = bw;
			_tmp40_ = outline_img;
			_tmp40_[i + 3] = bw;
		}
	}
	_tmp41_ = s;
	stride = cairo_image_surface_get_stride (_tmp41_);
	{
		gint m = 0;
		m = 0;
		{
			gboolean _tmp42_ = FALSE;
			_tmp42_ = TRUE;
			while (TRUE) {
				if (!_tmp42_) {
					gint _tmp43_;
					_tmp43_ = m;
					m = _tmp43_ + 1;
				}
				_tmp42_ = FALSE;
				if (!(m < 2)) {
					break;
				}
				i = stride + 4;
				while (TRUE) {
					gboolean _tmp44_ = FALSE;
					gboolean _tmp45_ = FALSE;
					gboolean _tmp46_ = FALSE;
					gboolean _tmp47_ = FALSE;
					guint8* _tmp48_;
					guint8 _tmp49_;
					gboolean _tmp71_ = FALSE;
					gboolean _tmp72_ = FALSE;
					gboolean _tmp73_ = FALSE;
					guint8* _tmp74_;
					guint8 _tmp75_;
					if (!(i < ((len - 4) - stride))) {
						break;
					}
					_tmp48_ = outline_img;
					_tmp49_ = _tmp48_[i];
					if (((gint) _tmp49_) == 255) {
						guint8* _tmp50_;
						guint8 _tmp51_;
						_tmp50_ = outline_img;
						_tmp51_ = _tmp50_[i + 4];
						_tmp47_ = ((gint) _tmp51_) == 0;
					} else {
						_tmp47_ = FALSE;
					}
					if (_tmp47_) {
						guint8* _tmp52_;
						guint8 _tmp53_;
						_tmp52_ = outline_img;
						_tmp53_ = _tmp52_[i + stride];
						_tmp46_ = ((gint) _tmp53_) == 0;
					} else {
						_tmp46_ = FALSE;
					}
					if (_tmp46_) {
						guint8* _tmp54_;
						guint8 _tmp55_;
						_tmp54_ = outline_img;
						_tmp55_ = _tmp54_[(i + stride) + 4];
						_tmp45_ = ((gint) _tmp55_) == 255;
					} else {
						_tmp45_ = FALSE;
					}
					if (_tmp45_) {
						_tmp44_ = TRUE;
					} else {
						gboolean _tmp56_ = FALSE;
						gboolean _tmp57_ = FALSE;
						gboolean _tmp58_ = FALSE;
						guint8* _tmp59_;
						guint8 _tmp60_;
						_tmp59_ = outline_img;
						_tmp60_ = _tmp59_[i];
						if (((gint) _tmp60_) == 0) {
							guint8* _tmp61_;
							guint8 _tmp62_;
							_tmp61_ = outline_img;
							_tmp62_ = _tmp61_[i + 4];
							_tmp58_ = ((gint) _tmp62_) == 255;
						} else {
							_tmp58_ = FALSE;
						}
						if (_tmp58_) {
							guint8* _tmp63_;
							guint8 _tmp64_;
							_tmp63_ = outline_img;
							_tmp64_ = _tmp63_[i + stride];
							_tmp57_ = ((gint) _tmp64_) == 255;
						} else {
							_tmp57_ = FALSE;
						}
						if (_tmp57_) {
							guint8* _tmp65_;
							guint8 _tmp66_;
							_tmp65_ = outline_img;
							_tmp66_ = _tmp65_[(i + stride) + 4];
							_tmp56_ = ((gint) _tmp66_) == 0;
						} else {
							_tmp56_ = FALSE;
						}
						_tmp44_ = _tmp56_;
					}
					if (_tmp44_) {
						guint8* _tmp67_;
						guint8* _tmp68_;
						guint8* _tmp69_;
						guint8* _tmp70_;
						_tmp67_ = outline_img;
						_tmp67_[i] = (guint8) 0;
						_tmp68_ = outline_img;
						_tmp68_[i + 4] = (guint8) 0;
						_tmp69_ = outline_img;
						_tmp69_[i + stride] = (guint8) 0;
						_tmp70_ = outline_img;
						_tmp70_[(i + stride) + 4] = (guint8) 0;
					}
					_tmp74_ = outline_img;
					_tmp75_ = _tmp74_[i];
					if (((gint) _tmp75_) == 255) {
						guint8* _tmp76_;
						guint8 _tmp77_;
						_tmp76_ = outline_img;
						_tmp77_ = _tmp76_[i + 4];
						_tmp73_ = ((gint) _tmp77_) == 0;
					} else {
						_tmp73_ = FALSE;
					}
					if (_tmp73_) {
						guint8* _tmp78_;
						guint8 _tmp79_;
						_tmp78_ = outline_img;
						_tmp79_ = _tmp78_[i + 8];
						_tmp72_ = ((gint) _tmp79_) == 255;
					} else {
						_tmp72_ = FALSE;
					}
					if (_tmp72_) {
						_tmp71_ = TRUE;
					} else {
						gboolean _tmp80_ = FALSE;
						gboolean _tmp81_ = FALSE;
						guint8* _tmp82_;
						guint8 _tmp83_;
						_tmp82_ = outline_img;
						_tmp83_ = _tmp82_[i];
						if (((gint) _tmp83_) == 0) {
							guint8* _tmp84_;
							guint8 _tmp85_;
							_tmp84_ = outline_img;
							_tmp85_ = _tmp84_[i + 4];
							_tmp81_ = ((gint) _tmp85_) == 255;
						} else {
							_tmp81_ = FALSE;
						}
						if (_tmp81_) {
							guint8* _tmp86_;
							guint8 _tmp87_;
							_tmp86_ = outline_img;
							_tmp87_ = _tmp86_[i + 8];
							_tmp80_ = ((gint) _tmp87_) == 0;
						} else {
							_tmp80_ = FALSE;
						}
						_tmp71_ = _tmp80_;
					}
					if (_tmp71_) {
						guint8* _tmp88_;
						guint8* _tmp89_;
						guint8* _tmp90_;
						guint8* _tmp91_;
						_tmp88_ = outline_img;
						_tmp88_[i] = (guint8) 0;
						_tmp89_ = outline_img;
						_tmp89_[i + 4] = (guint8) 0;
						_tmp90_ = outline_img;
						_tmp90_[i + stride] = (guint8) 0;
						_tmp91_ = outline_img;
						_tmp91_[(i + stride) + 4] = (guint8) 0;
					}
					i += 4;
				}
			}
		}
	}
	_tmp92_ = outline_img;
	_tmp93_ = s;
	_tmp94_ = s;
	_tmp95_ = s;
	_tmp96_ = s;
	_tmp97_ = cairo_image_surface_create_for_data ((guchar*) _tmp92_, cairo_image_surface_get_format (_tmp93_), cairo_image_surface_get_width (_tmp94_), cairo_image_surface_get_height (_tmp95_), cairo_image_surface_get_stride (_tmp96_));
	_cairo_surface_destroy0 (ns);
	ns = _tmp97_;
	_cairo_surface_destroy0 (self->priv->background_image);
	self->priv->background_image = NULL;
	_cairo_surface_destroy0 (self->priv->original_image);
	self->priv->original_image = NULL;
	_tmp98_ = _cairo_surface_reference0 ((cairo_surface_t*) ns);
	result = _tmp98_;
	_cairo_surface_destroy0 (ns);
	_cairo_surface_destroy0 (img);
	_cairo_surface_destroy0 (sg);
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (s);
	return result;
}

BirdFontPathList*
bird_font_background_image_autotrace (BirdFontBackgroundImage* self)
{
	cairo_surface_t* img = NULL;
	gint len = 0;
	gint w = 0;
	gint h = 0;
	gint i = 0;
	gint s = 0;
	BirdFontPath* p = NULL;
	BirdFontPathList* pl = NULL;
	guint8* outline_img = NULL;
	cairo_surface_t* scaled_image = NULL;
	gdouble scale = 0.0;
	BirdFontPath* _tmp0_;
	BirdFontPathList* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_surface_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_surface_t* _tmp11_;
	cairo_surface_t* _tmp12_;
	cairo_surface_t* _tmp13_;
	cairo_surface_t* _tmp14_;
	cairo_surface_t* _tmp15_;
	cairo_surface_t* _tmp16_;
	cairo_surface_t* _tmp17_;
	guchar* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	gint direction_vertical = 0;
	gint direction_horizontal = 0;
	gint last_move = 0;
	gint pp = 0;
	GeeArrayList* _tmp310_;
	GeeArrayList* _tmp311_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	_g_object_unref0 (p);
	p = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	_g_object_unref0 (pl);
	pl = _tmp1_;
	_tmp2_ = bird_font_background_image_get_img (self);
	_tmp3_ = _tmp2_;
	_cairo_surface_destroy0 (_tmp3_);
	_tmp4_ = self->priv->background_image;
	if (_tmp4_ == NULL) {
		result = pl;
		_cairo_surface_destroy0 (scaled_image);
		_g_object_unref0 (p);
		_cairo_surface_destroy0 (img);
		return result;
	}
	_tmp5_ = bird_font_background_image_get_contrast_image (self);
	_cairo_surface_destroy0 (img);
	img = _tmp5_;
	_tmp6_ = img;
	w = cairo_image_surface_get_width (_tmp6_);
	_tmp7_ = img;
	h = cairo_image_surface_get_height (_tmp7_);
	_tmp8_ = img;
	if (G_UNLIKELY (cairo_surface_status (_tmp8_) != CAIRO_STATUS_SUCCESS)) {
		g_warning ("BackgroundImage.vala:937: Error");
		result = pl;
		_cairo_surface_destroy0 (scaled_image);
		_g_object_unref0 (p);
		_cairo_surface_destroy0 (img);
		return result;
	}
	_tmp9_ = img;
	if (cairo_image_surface_get_format (_tmp9_) != CAIRO_FORMAT_RGB24) {
		g_warning ("BackgroundImage.vala:942: Wrong format");
		result = pl;
		_cairo_surface_destroy0 (scaled_image);
		_g_object_unref0 (p);
		_cairo_surface_destroy0 (img);
		return result;
	}
	_tmp10_ = img;
	_tmp11_ = _cairo_surface_reference0 (_tmp10_);
	_cairo_surface_destroy0 (scaled_image);
	scaled_image = _tmp11_;
	_tmp12_ = scaled_image;
	_tmp13_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp12_);
	_cairo_surface_destroy0 (img);
	img = _tmp13_;
	_tmp14_ = img;
	w = cairo_image_surface_get_width (_tmp14_);
	_tmp15_ = img;
	h = cairo_image_surface_get_height (_tmp15_);
	_tmp16_ = img;
	s = cairo_image_surface_get_stride (_tmp16_);
	len = s * h;
	_tmp17_ = img;
	_tmp18_ = cairo_image_surface_get_data (_tmp17_);
	outline_img = (guint8*) _tmp18_;
	_tmp19_ = gee_array_list_new (BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, (GBoxedCopyFunc) bird_font_background_image_traced_point_ref, (GDestroyNotify) bird_font_background_image_traced_point_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->start_points);
	self->priv->start_points = _tmp19_;
	_tmp20_ = gee_array_list_new (BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, (GBoxedCopyFunc) bird_font_background_image_traced_point_ref, (GDestroyNotify) bird_font_background_image_traced_point_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->points);
	self->priv->points = _tmp20_;
	direction_vertical = 4;
	direction_horizontal = s;
	last_move = 0;
	pp = 0;
	scale = (gdouble) 1;
	i = 0;
	while (TRUE) {
		guint8* _tmp21_;
		_tmp21_ = outline_img;
		i = bird_font_background_image_find_start_point (self, _tmp21_, len, s, i);
		if (!(i != -1)) {
			break;
		}
		pp = 0;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			gboolean _tmp39_ = FALSE;
			guint8* _tmp40_;
			guint8 _tmp41_;
			gboolean _tmp52_ = FALSE;
			gboolean _tmp53_ = FALSE;
			gboolean _tmp54_ = FALSE;
			guint8* _tmp55_;
			guint8 _tmp56_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			gboolean _tmp69_ = FALSE;
			guint8* _tmp70_;
			guint8 _tmp71_;
			_tmp22_ = i;
			if (!(((4 + s) <= _tmp22_) && (_tmp22_ < ((len - 4) - s)))) {
				break;
			}
			_tmp23_ = pp;
			pp = _tmp23_ + 1;
			if (bird_font_background_image_is_traced (self, i)) {
				BirdFontPath* np = NULL;
				guint8* _tmp24_;
				BirdFontPath* _tmp25_;
				BirdFontPath* _tmp26_;
				GeeArrayList* _tmp27_;
				GeeArrayList* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				_tmp24_ = outline_img;
				_tmp25_ = bird_font_background_image_generate_path (self, _tmp24_, s, w, h, len);
				np = _tmp25_;
				_tmp26_ = np;
				_tmp27_ = bird_font_path_get_points (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ >= 3) {
					BirdFontPathList* _tmp31_;
					BirdFontPath* _tmp32_;
					BirdFontPathList* _tmp35_;
					BirdFontPath* _tmp36_;
					_tmp31_ = pl;
					_tmp32_ = np;
					if (bird_font_path_is_counter (_tmp31_, _tmp32_)) {
						BirdFontPath* _tmp33_;
						_tmp33_ = np;
						bird_font_path_force_direction (_tmp33_, BIRD_FONT_DIRECTION_COUNTER_CLOCKWISE);
					} else {
						BirdFontPath* _tmp34_;
						_tmp34_ = np;
						bird_font_path_force_direction (_tmp34_, BIRD_FONT_DIRECTION_CLOCKWISE);
					}
					_tmp35_ = pl;
					_tmp36_ = np;
					bird_font_path_list_add (_tmp35_, _tmp36_);
				}
				_g_object_unref0 (np);
				break;
			}
			_tmp40_ = outline_img;
			_tmp41_ = _tmp40_[i];
			if (((gint) _tmp41_) == 255) {
				guint8* _tmp42_;
				guint8 _tmp43_;
				_tmp42_ = outline_img;
				_tmp43_ = _tmp42_[i + 4];
				_tmp39_ = ((gint) _tmp43_) == 255;
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				guint8* _tmp44_;
				guint8 _tmp45_;
				_tmp44_ = outline_img;
				_tmp45_ = _tmp44_[i + s];
				_tmp38_ = ((gint) _tmp45_) == 255;
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				guint8* _tmp46_;
				guint8 _tmp47_;
				_tmp46_ = outline_img;
				_tmp47_ = _tmp46_[(i + s) + 4];
				_tmp37_ = ((gint) _tmp47_) == 255;
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				BirdFontPath* np = NULL;
				guint8* _tmp48_;
				BirdFontPath* _tmp49_;
				BirdFontPathList* _tmp50_;
				BirdFontPath* _tmp51_;
				g_warning ("BackgroundImage.vala:989: Lost path");
				_tmp48_ = outline_img;
				_tmp49_ = bird_font_background_image_generate_path (self, _tmp48_, s, w, h, len);
				np = _tmp49_;
				_tmp50_ = pl;
				_tmp51_ = np;
				bird_font_path_list_add (_tmp50_, _tmp51_);
				_g_object_unref0 (np);
				break;
			}
			_tmp55_ = outline_img;
			_tmp56_ = _tmp55_[i];
			if (((gint) _tmp56_) == 0) {
				guint8* _tmp57_;
				guint8 _tmp58_;
				_tmp57_ = outline_img;
				_tmp58_ = _tmp57_[i + 4];
				_tmp54_ = ((gint) _tmp58_) == 0;
			} else {
				_tmp54_ = FALSE;
			}
			if (_tmp54_) {
				guint8* _tmp59_;
				guint8 _tmp60_;
				_tmp59_ = outline_img;
				_tmp60_ = _tmp59_[i + s];
				_tmp53_ = ((gint) _tmp60_) == 0;
			} else {
				_tmp53_ = FALSE;
			}
			if (_tmp53_) {
				guint8* _tmp61_;
				guint8 _tmp62_;
				_tmp61_ = outline_img;
				_tmp62_ = _tmp61_[(i + s) + 4];
				_tmp52_ = ((gint) _tmp62_) == 0;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				BirdFontPath* np = NULL;
				guint8* _tmp63_;
				BirdFontPath* _tmp64_;
				BirdFontPathList* _tmp65_;
				BirdFontPath* _tmp66_;
				g_warning ("BackgroundImage.vala:997: Lost path");
				_tmp63_ = outline_img;
				_tmp64_ = bird_font_background_image_generate_path (self, _tmp63_, s, w, h, len);
				np = _tmp64_;
				_tmp65_ = pl;
				_tmp66_ = np;
				bird_font_path_list_add (_tmp65_, _tmp66_);
				_g_object_unref0 (np);
				break;
			}
			_tmp70_ = outline_img;
			_tmp71_ = _tmp70_[i];
			if (((gint) _tmp71_) == 0) {
				guint8* _tmp72_;
				guint8 _tmp73_;
				_tmp72_ = outline_img;
				_tmp73_ = _tmp72_[i + 4];
				_tmp69_ = ((gint) _tmp73_) == 255;
			} else {
				_tmp69_ = FALSE;
			}
			if (_tmp69_) {
				guint8* _tmp74_;
				guint8 _tmp75_;
				_tmp74_ = outline_img;
				_tmp75_ = _tmp74_[i + s];
				_tmp68_ = ((gint) _tmp75_) == 255;
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				guint8* _tmp76_;
				guint8 _tmp77_;
				_tmp76_ = outline_img;
				_tmp77_ = _tmp76_[(i + s) + 4];
				_tmp67_ = ((gint) _tmp77_) == 255;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				GeeArrayList* _tmp78_;
				BirdFontBackgroundImageTracedPoint* _tmp79_;
				BirdFontBackgroundImageTracedPoint* _tmp80_;
				_tmp78_ = self->priv->points;
				_tmp79_ = bird_font_background_image_traced_point_new (i);
				_tmp80_ = _tmp79_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp78_, _tmp80_);
				_bird_font_background_image_traced_point_unref0 (_tmp80_);
				if (last_move == direction_horizontal) {
					direction_vertical = -s;
					i += direction_vertical;
					last_move = direction_vertical;
				} else {
					direction_horizontal = -4;
					i += direction_horizontal;
					last_move = direction_horizontal;
				}
			} else {
				gboolean _tmp81_ = FALSE;
				gboolean _tmp82_ = FALSE;
				gboolean _tmp83_ = FALSE;
				guint8* _tmp84_;
				guint8 _tmp85_;
				_tmp84_ = outline_img;
				_tmp85_ = _tmp84_[i];
				if (((gint) _tmp85_) == 0) {
					guint8* _tmp86_;
					guint8 _tmp87_;
					_tmp86_ = outline_img;
					_tmp87_ = _tmp86_[i + 4];
					_tmp83_ = ((gint) _tmp87_) == 255;
				} else {
					_tmp83_ = FALSE;
				}
				if (_tmp83_) {
					guint8* _tmp88_;
					guint8 _tmp89_;
					_tmp88_ = outline_img;
					_tmp89_ = _tmp88_[i + s];
					_tmp82_ = ((gint) _tmp89_) == 255;
				} else {
					_tmp82_ = FALSE;
				}
				if (_tmp82_) {
					guint8* _tmp90_;
					guint8 _tmp91_;
					_tmp90_ = outline_img;
					_tmp91_ = _tmp90_[(i + s) + 4];
					_tmp81_ = ((gint) _tmp91_) == 255;
				} else {
					_tmp81_ = FALSE;
				}
				if (_tmp81_) {
					GeeArrayList* _tmp92_;
					BirdFontBackgroundImageTracedPoint* _tmp93_;
					BirdFontBackgroundImageTracedPoint* _tmp94_;
					_tmp92_ = self->priv->points;
					_tmp93_ = bird_font_background_image_traced_point_new (i);
					_tmp94_ = _tmp93_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp92_, _tmp94_);
					_bird_font_background_image_traced_point_unref0 (_tmp94_);
					if (last_move == direction_horizontal) {
						direction_vertical = -s;
						i += direction_vertical;
						last_move = direction_vertical;
					} else {
						direction_horizontal = -4;
						i += direction_horizontal;
						last_move = direction_horizontal;
					}
				} else {
					gboolean _tmp95_ = FALSE;
					gboolean _tmp96_ = FALSE;
					gboolean _tmp97_ = FALSE;
					guint8* _tmp98_;
					guint8 _tmp99_;
					_tmp98_ = outline_img;
					_tmp99_ = _tmp98_[i];
					if (((gint) _tmp99_) == 255) {
						guint8* _tmp100_;
						guint8 _tmp101_;
						_tmp100_ = outline_img;
						_tmp101_ = _tmp100_[i + 4];
						_tmp97_ = ((gint) _tmp101_) == 0;
					} else {
						_tmp97_ = FALSE;
					}
					if (_tmp97_) {
						guint8* _tmp102_;
						guint8 _tmp103_;
						_tmp102_ = outline_img;
						_tmp103_ = _tmp102_[i + s];
						_tmp96_ = ((gint) _tmp103_) == 255;
					} else {
						_tmp96_ = FALSE;
					}
					if (_tmp96_) {
						guint8* _tmp104_;
						guint8 _tmp105_;
						_tmp104_ = outline_img;
						_tmp105_ = _tmp104_[(i + s) + 4];
						_tmp95_ = ((gint) _tmp105_) == 255;
					} else {
						_tmp95_ = FALSE;
					}
					if (_tmp95_) {
						GeeArrayList* _tmp106_;
						BirdFontBackgroundImageTracedPoint* _tmp107_;
						BirdFontBackgroundImageTracedPoint* _tmp108_;
						_tmp106_ = self->priv->points;
						_tmp107_ = bird_font_background_image_traced_point_new (i);
						_tmp108_ = _tmp107_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp106_, _tmp108_);
						_bird_font_background_image_traced_point_unref0 (_tmp108_);
						if (last_move == direction_horizontal) {
							direction_vertical = -s;
							i += direction_vertical;
							last_move = direction_vertical;
						} else {
							direction_horizontal = 4;
							i += direction_horizontal;
							last_move = direction_horizontal;
						}
					} else {
						gboolean _tmp109_ = FALSE;
						gboolean _tmp110_ = FALSE;
						gboolean _tmp111_ = FALSE;
						guint8* _tmp112_;
						guint8 _tmp113_;
						_tmp112_ = outline_img;
						_tmp113_ = _tmp112_[i];
						if (((gint) _tmp113_) == 0) {
							guint8* _tmp114_;
							guint8 _tmp115_;
							_tmp114_ = outline_img;
							_tmp115_ = _tmp114_[i + 4];
							_tmp111_ = ((gint) _tmp115_) == 0;
						} else {
							_tmp111_ = FALSE;
						}
						if (_tmp111_) {
							guint8* _tmp116_;
							guint8 _tmp117_;
							_tmp116_ = outline_img;
							_tmp117_ = _tmp116_[i + s];
							_tmp110_ = ((gint) _tmp117_) == 255;
						} else {
							_tmp110_ = FALSE;
						}
						if (_tmp110_) {
							guint8* _tmp118_;
							guint8 _tmp119_;
							_tmp118_ = outline_img;
							_tmp119_ = _tmp118_[(i + s) + 4];
							_tmp109_ = ((gint) _tmp119_) == 0;
						} else {
							_tmp109_ = FALSE;
						}
						if (_tmp109_) {
							GeeArrayList* _tmp120_;
							BirdFontBackgroundImageTracedPoint* _tmp121_;
							BirdFontBackgroundImageTracedPoint* _tmp122_;
							_tmp120_ = self->priv->points;
							_tmp121_ = bird_font_background_image_traced_point_new (i);
							_tmp122_ = _tmp121_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, _tmp122_);
							_bird_font_background_image_traced_point_unref0 (_tmp122_);
							if (last_move == direction_horizontal) {
								direction_vertical = s;
								i += direction_vertical;
								last_move = direction_vertical;
							} else {
								direction_horizontal = -4;
								i += direction_horizontal;
								last_move = direction_horizontal;
							}
						} else {
							gboolean _tmp123_ = FALSE;
							gboolean _tmp124_ = FALSE;
							gboolean _tmp125_ = FALSE;
							guint8* _tmp126_;
							guint8 _tmp127_;
							_tmp126_ = outline_img;
							_tmp127_ = _tmp126_[i];
							if (((gint) _tmp127_) == 255) {
								guint8* _tmp128_;
								guint8 _tmp129_;
								_tmp128_ = outline_img;
								_tmp129_ = _tmp128_[i + 4];
								_tmp125_ = ((gint) _tmp129_) == 255;
							} else {
								_tmp125_ = FALSE;
							}
							if (_tmp125_) {
								guint8* _tmp130_;
								guint8 _tmp131_;
								_tmp130_ = outline_img;
								_tmp131_ = _tmp130_[i + s];
								_tmp124_ = ((gint) _tmp131_) == 255;
							} else {
								_tmp124_ = FALSE;
							}
							if (_tmp124_) {
								guint8* _tmp132_;
								guint8 _tmp133_;
								_tmp132_ = outline_img;
								_tmp133_ = _tmp132_[(i + s) + 4];
								_tmp123_ = ((gint) _tmp133_) == 0;
							} else {
								_tmp123_ = FALSE;
							}
							if (_tmp123_) {
								GeeArrayList* _tmp134_;
								BirdFontBackgroundImageTracedPoint* _tmp135_;
								BirdFontBackgroundImageTracedPoint* _tmp136_;
								_tmp134_ = self->priv->points;
								_tmp135_ = bird_font_background_image_traced_point_new (i);
								_tmp136_ = _tmp135_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp134_, _tmp136_);
								_bird_font_background_image_traced_point_unref0 (_tmp136_);
								if (last_move == direction_horizontal) {
									direction_vertical = s;
									i += direction_vertical;
									last_move = direction_vertical;
								} else {
									direction_horizontal = 4;
									i += direction_horizontal;
									last_move = direction_horizontal;
								}
							} else {
								gboolean _tmp137_ = FALSE;
								gboolean _tmp138_ = FALSE;
								gboolean _tmp139_ = FALSE;
								guint8* _tmp140_;
								guint8 _tmp141_;
								_tmp140_ = outline_img;
								_tmp141_ = _tmp140_[i];
								if (((gint) _tmp141_) == 255) {
									guint8* _tmp142_;
									guint8 _tmp143_;
									_tmp142_ = outline_img;
									_tmp143_ = _tmp142_[i + 4];
									_tmp139_ = ((gint) _tmp143_) == 255;
								} else {
									_tmp139_ = FALSE;
								}
								if (_tmp139_) {
									guint8* _tmp144_;
									guint8 _tmp145_;
									_tmp144_ = outline_img;
									_tmp145_ = _tmp144_[i + s];
									_tmp138_ = ((gint) _tmp145_) == 0;
								} else {
									_tmp138_ = FALSE;
								}
								if (_tmp138_) {
									guint8* _tmp146_;
									guint8 _tmp147_;
									_tmp146_ = outline_img;
									_tmp147_ = _tmp146_[(i + s) + 4];
									_tmp137_ = ((gint) _tmp147_) == 255;
								} else {
									_tmp137_ = FALSE;
								}
								if (_tmp137_) {
									GeeArrayList* _tmp148_;
									BirdFontBackgroundImageTracedPoint* _tmp149_;
									BirdFontBackgroundImageTracedPoint* _tmp150_;
									_tmp148_ = self->priv->points;
									_tmp149_ = bird_font_background_image_traced_point_new (i);
									_tmp150_ = _tmp149_;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp148_, _tmp150_);
									_bird_font_background_image_traced_point_unref0 (_tmp150_);
									if (last_move == direction_horizontal) {
										direction_vertical = s;
										i += direction_vertical;
										last_move = direction_vertical;
									} else {
										direction_horizontal = -4;
										i += direction_horizontal;
										last_move = direction_horizontal;
									}
								} else {
									gboolean _tmp151_ = FALSE;
									gboolean _tmp152_ = FALSE;
									gboolean _tmp153_ = FALSE;
									guint8* _tmp154_;
									guint8 _tmp155_;
									_tmp154_ = outline_img;
									_tmp155_ = _tmp154_[i];
									if (((gint) _tmp155_) == 255) {
										guint8* _tmp156_;
										guint8 _tmp157_;
										_tmp156_ = outline_img;
										_tmp157_ = _tmp156_[i + 4];
										_tmp153_ = ((gint) _tmp157_) == 0;
									} else {
										_tmp153_ = FALSE;
									}
									if (_tmp153_) {
										guint8* _tmp158_;
										guint8 _tmp159_;
										_tmp158_ = outline_img;
										_tmp159_ = _tmp158_[i + s];
										_tmp152_ = ((gint) _tmp159_) == 0;
									} else {
										_tmp152_ = FALSE;
									}
									if (_tmp152_) {
										guint8* _tmp160_;
										guint8 _tmp161_;
										_tmp160_ = outline_img;
										_tmp161_ = _tmp160_[(i + s) + 4];
										_tmp151_ = ((gint) _tmp161_) == 0;
									} else {
										_tmp151_ = FALSE;
									}
									if (_tmp151_) {
										GeeArrayList* _tmp162_;
										BirdFontBackgroundImageTracedPoint* _tmp163_;
										BirdFontBackgroundImageTracedPoint* _tmp164_;
										_tmp162_ = self->priv->points;
										_tmp163_ = bird_font_background_image_traced_point_new (i);
										_tmp164_ = _tmp163_;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp162_, _tmp164_);
										_bird_font_background_image_traced_point_unref0 (_tmp164_);
										if (last_move == direction_horizontal) {
											direction_vertical = -s;
											i += direction_vertical;
											last_move = direction_vertical;
										} else {
											direction_horizontal = -4;
											i += direction_horizontal;
											last_move = direction_horizontal;
										}
									} else {
										gboolean _tmp165_ = FALSE;
										gboolean _tmp166_ = FALSE;
										gboolean _tmp167_ = FALSE;
										guint8* _tmp168_;
										guint8 _tmp169_;
										_tmp168_ = outline_img;
										_tmp169_ = _tmp168_[i];
										if (((gint) _tmp169_) == 0) {
											guint8* _tmp170_;
											guint8 _tmp171_;
											_tmp170_ = outline_img;
											_tmp171_ = _tmp170_[i + 4];
											_tmp167_ = ((gint) _tmp171_) == 255;
										} else {
											_tmp167_ = FALSE;
										}
										if (_tmp167_) {
											guint8* _tmp172_;
											guint8 _tmp173_;
											_tmp172_ = outline_img;
											_tmp173_ = _tmp172_[i + s];
											_tmp166_ = ((gint) _tmp173_) == 0;
										} else {
											_tmp166_ = FALSE;
										}
										if (_tmp166_) {
											guint8* _tmp174_;
											guint8 _tmp175_;
											_tmp174_ = outline_img;
											_tmp175_ = _tmp174_[(i + s) + 4];
											_tmp165_ = ((gint) _tmp175_) == 0;
										} else {
											_tmp165_ = FALSE;
										}
										if (_tmp165_) {
											GeeArrayList* _tmp176_;
											BirdFontBackgroundImageTracedPoint* _tmp177_;
											BirdFontBackgroundImageTracedPoint* _tmp178_;
											_tmp176_ = self->priv->points;
											_tmp177_ = bird_font_background_image_traced_point_new (i);
											_tmp178_ = _tmp177_;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp176_, _tmp178_);
											_bird_font_background_image_traced_point_unref0 (_tmp178_);
											if (last_move == direction_horizontal) {
												direction_vertical = -s;
												i += direction_vertical;
												last_move = direction_vertical;
											} else {
												direction_horizontal = 4;
												i += direction_horizontal;
												last_move = direction_horizontal;
											}
										} else {
											gboolean _tmp179_ = FALSE;
											gboolean _tmp180_ = FALSE;
											gboolean _tmp181_ = FALSE;
											guint8* _tmp182_;
											guint8 _tmp183_;
											_tmp182_ = outline_img;
											_tmp183_ = _tmp182_[i];
											if (((gint) _tmp183_) == 0) {
												guint8* _tmp184_;
												guint8 _tmp185_;
												_tmp184_ = outline_img;
												_tmp185_ = _tmp184_[i + 4];
												_tmp181_ = ((gint) _tmp185_) == 0;
											} else {
												_tmp181_ = FALSE;
											}
											if (_tmp181_) {
												guint8* _tmp186_;
												guint8 _tmp187_;
												_tmp186_ = outline_img;
												_tmp187_ = _tmp186_[i + s];
												_tmp180_ = ((gint) _tmp187_) == 0;
											} else {
												_tmp180_ = FALSE;
											}
											if (_tmp180_) {
												guint8* _tmp188_;
												guint8 _tmp189_;
												_tmp188_ = outline_img;
												_tmp189_ = _tmp188_[(i + s) + 4];
												_tmp179_ = ((gint) _tmp189_) == 255;
											} else {
												_tmp179_ = FALSE;
											}
											if (_tmp179_) {
												GeeArrayList* _tmp190_;
												BirdFontBackgroundImageTracedPoint* _tmp191_;
												BirdFontBackgroundImageTracedPoint* _tmp192_;
												_tmp190_ = self->priv->points;
												_tmp191_ = bird_font_background_image_traced_point_new (i);
												_tmp192_ = _tmp191_;
												gee_abstract_collection_add ((GeeAbstractCollection*) _tmp190_, _tmp192_);
												_bird_font_background_image_traced_point_unref0 (_tmp192_);
												if (last_move == direction_horizontal) {
													direction_vertical = s;
													i += direction_vertical;
													last_move = direction_vertical;
												} else {
													direction_horizontal = 4;
													i += direction_horizontal;
													last_move = direction_horizontal;
												}
											} else {
												gboolean _tmp193_ = FALSE;
												gboolean _tmp194_ = FALSE;
												gboolean _tmp195_ = FALSE;
												guint8* _tmp196_;
												guint8 _tmp197_;
												_tmp196_ = outline_img;
												_tmp197_ = _tmp196_[i];
												if (((gint) _tmp197_) == 255) {
													guint8* _tmp198_;
													guint8 _tmp199_;
													_tmp198_ = outline_img;
													_tmp199_ = _tmp198_[i + 4];
													_tmp195_ = ((gint) _tmp199_) == 255;
												} else {
													_tmp195_ = FALSE;
												}
												if (_tmp195_) {
													guint8* _tmp200_;
													guint8 _tmp201_;
													_tmp200_ = outline_img;
													_tmp201_ = _tmp200_[i + s];
													_tmp194_ = ((gint) _tmp201_) == 0;
												} else {
													_tmp194_ = FALSE;
												}
												if (_tmp194_) {
													guint8* _tmp202_;
													guint8 _tmp203_;
													_tmp202_ = outline_img;
													_tmp203_ = _tmp202_[(i + s) + 4];
													_tmp193_ = ((gint) _tmp203_) == 255;
												} else {
													_tmp193_ = FALSE;
												}
												if (_tmp193_) {
													GeeArrayList* _tmp204_;
													BirdFontBackgroundImageTracedPoint* _tmp205_;
													BirdFontBackgroundImageTracedPoint* _tmp206_;
													_tmp204_ = self->priv->points;
													_tmp205_ = bird_font_background_image_traced_point_new (i);
													_tmp206_ = _tmp205_;
													gee_abstract_collection_add ((GeeAbstractCollection*) _tmp204_, _tmp206_);
													_bird_font_background_image_traced_point_unref0 (_tmp206_);
													if (last_move == direction_horizontal) {
														direction_vertical = s;
														i += direction_vertical;
														last_move = direction_vertical;
													} else {
														direction_horizontal = -4;
														i += direction_horizontal;
														last_move = direction_horizontal;
													}
												} else {
													gboolean _tmp207_ = FALSE;
													gboolean _tmp208_ = FALSE;
													gboolean _tmp209_ = FALSE;
													guint8* _tmp210_;
													guint8 _tmp211_;
													_tmp210_ = outline_img;
													_tmp211_ = _tmp210_[i];
													if (((gint) _tmp211_) == 255) {
														guint8* _tmp212_;
														guint8 _tmp213_;
														_tmp212_ = outline_img;
														_tmp213_ = _tmp212_[i + 4];
														_tmp209_ = ((gint) _tmp213_) == 255;
													} else {
														_tmp209_ = FALSE;
													}
													if (_tmp209_) {
														guint8* _tmp214_;
														guint8 _tmp215_;
														_tmp214_ = outline_img;
														_tmp215_ = _tmp214_[i + s];
														_tmp208_ = ((gint) _tmp215_) == 0;
													} else {
														_tmp208_ = FALSE;
													}
													if (_tmp208_) {
														guint8* _tmp216_;
														guint8 _tmp217_;
														_tmp216_ = outline_img;
														_tmp217_ = _tmp216_[(i + s) + 4];
														_tmp207_ = ((gint) _tmp217_) == 0;
													} else {
														_tmp207_ = FALSE;
													}
													if (_tmp207_) {
														GeeArrayList* _tmp218_;
														BirdFontBackgroundImageTracedPoint* _tmp219_;
														BirdFontBackgroundImageTracedPoint* _tmp220_;
														_tmp218_ = self->priv->points;
														_tmp219_ = bird_font_background_image_traced_point_new (i);
														_tmp220_ = _tmp219_;
														gee_abstract_collection_add ((GeeAbstractCollection*) _tmp218_, _tmp220_);
														_bird_font_background_image_traced_point_unref0 (_tmp220_);
														i += direction_horizontal;
														last_move = direction_horizontal;
													} else {
														gboolean _tmp221_ = FALSE;
														gboolean _tmp222_ = FALSE;
														gboolean _tmp223_ = FALSE;
														guint8* _tmp224_;
														guint8 _tmp225_;
														_tmp224_ = outline_img;
														_tmp225_ = _tmp224_[i];
														if (((gint) _tmp225_) == 0) {
															guint8* _tmp226_;
															guint8 _tmp227_;
															_tmp226_ = outline_img;
															_tmp227_ = _tmp226_[i + 4];
															_tmp223_ = ((gint) _tmp227_) == 0;
														} else {
															_tmp223_ = FALSE;
														}
														if (_tmp223_) {
															guint8* _tmp228_;
															guint8 _tmp229_;
															_tmp228_ = outline_img;
															_tmp229_ = _tmp228_[i + s];
															_tmp222_ = ((gint) _tmp229_) == 255;
														} else {
															_tmp222_ = FALSE;
														}
														if (_tmp222_) {
															guint8* _tmp230_;
															guint8 _tmp231_;
															_tmp230_ = outline_img;
															_tmp231_ = _tmp230_[(i + s) + 4];
															_tmp221_ = ((gint) _tmp231_) == 255;
														} else {
															_tmp221_ = FALSE;
														}
														if (_tmp221_) {
															GeeArrayList* _tmp232_;
															BirdFontBackgroundImageTracedPoint* _tmp233_;
															BirdFontBackgroundImageTracedPoint* _tmp234_;
															_tmp232_ = self->priv->points;
															_tmp233_ = bird_font_background_image_traced_point_new (i);
															_tmp234_ = _tmp233_;
															gee_abstract_collection_add ((GeeAbstractCollection*) _tmp232_, _tmp234_);
															_bird_font_background_image_traced_point_unref0 (_tmp234_);
															i += direction_horizontal;
															last_move = direction_horizontal;
														} else {
															gboolean _tmp235_ = FALSE;
															gboolean _tmp236_ = FALSE;
															gboolean _tmp237_ = FALSE;
															guint8* _tmp238_;
															guint8 _tmp239_;
															_tmp238_ = outline_img;
															_tmp239_ = _tmp238_[i];
															if (((gint) _tmp239_) == 255) {
																guint8* _tmp240_;
																guint8 _tmp241_;
																_tmp240_ = outline_img;
																_tmp241_ = _tmp240_[i + 4];
																_tmp237_ = ((gint) _tmp241_) == 0;
															} else {
																_tmp237_ = FALSE;
															}
															if (_tmp237_) {
																guint8* _tmp242_;
																guint8 _tmp243_;
																_tmp242_ = outline_img;
																_tmp243_ = _tmp242_[i + s];
																_tmp236_ = ((gint) _tmp243_) == 255;
															} else {
																_tmp236_ = FALSE;
															}
															if (_tmp236_) {
																guint8* _tmp244_;
																guint8 _tmp245_;
																_tmp244_ = outline_img;
																_tmp245_ = _tmp244_[(i + s) + 4];
																_tmp235_ = ((gint) _tmp245_) == 0;
															} else {
																_tmp235_ = FALSE;
															}
															if (_tmp235_) {
																GeeArrayList* _tmp246_;
																BirdFontBackgroundImageTracedPoint* _tmp247_;
																BirdFontBackgroundImageTracedPoint* _tmp248_;
																_tmp246_ = self->priv->points;
																_tmp247_ = bird_font_background_image_traced_point_new (i);
																_tmp248_ = _tmp247_;
																gee_abstract_collection_add ((GeeAbstractCollection*) _tmp246_, _tmp248_);
																_bird_font_background_image_traced_point_unref0 (_tmp248_);
																i += direction_vertical;
																last_move = direction_vertical;
															} else {
																gboolean _tmp249_ = FALSE;
																gboolean _tmp250_ = FALSE;
																gboolean _tmp251_ = FALSE;
																guint8* _tmp252_;
																guint8 _tmp253_;
																_tmp252_ = outline_img;
																_tmp253_ = _tmp252_[i];
																if (((gint) _tmp253_) == 0) {
																	guint8* _tmp254_;
																	guint8 _tmp255_;
																	_tmp254_ = outline_img;
																	_tmp255_ = _tmp254_[i + 4];
																	_tmp251_ = ((gint) _tmp255_) == 255;
																} else {
																	_tmp251_ = FALSE;
																}
																if (_tmp251_) {
																	guint8* _tmp256_;
																	guint8 _tmp257_;
																	_tmp256_ = outline_img;
																	_tmp257_ = _tmp256_[i + s];
																	_tmp250_ = ((gint) _tmp257_) == 0;
																} else {
																	_tmp250_ = FALSE;
																}
																if (_tmp250_) {
																	guint8* _tmp258_;
																	guint8 _tmp259_;
																	_tmp258_ = outline_img;
																	_tmp259_ = _tmp258_[(i + s) + 4];
																	_tmp249_ = ((gint) _tmp259_) == 255;
																} else {
																	_tmp249_ = FALSE;
																}
																if (_tmp249_) {
																	GeeArrayList* _tmp260_;
																	BirdFontBackgroundImageTracedPoint* _tmp261_;
																	BirdFontBackgroundImageTracedPoint* _tmp262_;
																	_tmp260_ = self->priv->points;
																	_tmp261_ = bird_font_background_image_traced_point_new (i);
																	_tmp262_ = _tmp261_;
																	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp260_, _tmp262_);
																	_bird_font_background_image_traced_point_unref0 (_tmp262_);
																	i += direction_vertical;
																	last_move = direction_vertical;
																} else {
																	gboolean _tmp263_ = FALSE;
																	gboolean _tmp264_ = FALSE;
																	gboolean _tmp265_ = FALSE;
																	gboolean _tmp266_ = FALSE;
																	guint8* _tmp267_;
																	guint8 _tmp268_;
																	_tmp267_ = outline_img;
																	_tmp268_ = _tmp267_[i];
																	if (((gint) _tmp268_) == 255) {
																		guint8* _tmp269_;
																		guint8 _tmp270_;
																		_tmp269_ = outline_img;
																		_tmp270_ = _tmp269_[i + 4];
																		_tmp266_ = ((gint) _tmp270_) == 0;
																	} else {
																		_tmp266_ = FALSE;
																	}
																	if (_tmp266_) {
																		guint8* _tmp271_;
																		guint8 _tmp272_;
																		_tmp271_ = outline_img;
																		_tmp272_ = _tmp271_[i + s];
																		_tmp265_ = ((gint) _tmp272_) == 0;
																	} else {
																		_tmp265_ = FALSE;
																	}
																	if (_tmp265_) {
																		guint8* _tmp273_;
																		guint8 _tmp274_;
																		_tmp273_ = outline_img;
																		_tmp274_ = _tmp273_[(i + s) + 4];
																		_tmp264_ = ((gint) _tmp274_) == 255;
																	} else {
																		_tmp264_ = FALSE;
																	}
																	if (_tmp264_) {
																		_tmp263_ = TRUE;
																	} else {
																		gboolean _tmp275_ = FALSE;
																		gboolean _tmp276_ = FALSE;
																		gboolean _tmp277_ = FALSE;
																		guint8* _tmp278_;
																		guint8 _tmp279_;
																		_tmp278_ = outline_img;
																		_tmp279_ = _tmp278_[i];
																		if (((gint) _tmp279_) == 0) {
																			guint8* _tmp280_;
																			guint8 _tmp281_;
																			_tmp280_ = outline_img;
																			_tmp281_ = _tmp280_[i + 4];
																			_tmp277_ = ((gint) _tmp281_) == 255;
																		} else {
																			_tmp277_ = FALSE;
																		}
																		if (_tmp277_) {
																			guint8* _tmp282_;
																			guint8 _tmp283_;
																			_tmp282_ = outline_img;
																			_tmp283_ = _tmp282_[i + s];
																			_tmp276_ = ((gint) _tmp283_) == 255;
																		} else {
																			_tmp276_ = FALSE;
																		}
																		if (_tmp276_) {
																			guint8* _tmp284_;
																			guint8 _tmp285_;
																			_tmp284_ = outline_img;
																			_tmp285_ = _tmp284_[(i + s) + 4];
																			_tmp275_ = ((gint) _tmp285_) == 0;
																		} else {
																			_tmp275_ = FALSE;
																		}
																		_tmp263_ = _tmp275_;
																	}
																	if (_tmp263_) {
																		GeeArrayList* _tmp286_;
																		BirdFontBackgroundImageTracedPoint* _tmp287_;
																		BirdFontBackgroundImageTracedPoint* _tmp288_;
																		_tmp286_ = self->priv->points;
																		_tmp287_ = bird_font_background_image_traced_point_new (i);
																		_tmp288_ = _tmp287_;
																		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp286_, _tmp288_);
																		_bird_font_background_image_traced_point_unref0 (_tmp288_);
																		g_warning ("BackgroundImage.vala:1170: Bad edge");
																		i += last_move;
																	} else {
																		GeeArrayList* _tmp289_;
																		BirdFontBackgroundImageTracedPoint* _tmp290_;
																		BirdFontBackgroundImageTracedPoint* _tmp291_;
																		guint8* _tmp292_;
																		guint8 _tmp293_;
																		gchar* _tmp294_;
																		gchar* _tmp295_;
																		guint8* _tmp296_;
																		guint8 _tmp297_;
																		gchar* _tmp298_;
																		gchar* _tmp299_;
																		guint8* _tmp300_;
																		guint8 _tmp301_;
																		gchar* _tmp302_;
																		gchar* _tmp303_;
																		guint8* _tmp304_;
																		guint8 _tmp305_;
																		gchar* _tmp306_;
																		gchar* _tmp307_;
																		gchar* _tmp308_;
																		gchar* _tmp309_;
																		_tmp289_ = self->priv->points;
																		_tmp290_ = bird_font_background_image_traced_point_new (i);
																		_tmp291_ = _tmp290_;
																		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp289_, _tmp291_);
																		_bird_font_background_image_traced_point_unref0 (_tmp291_);
																		_tmp292_ = outline_img;
																		_tmp293_ = _tmp292_[i];
																		_tmp294_ = g_strdup_printf ("%hhu", _tmp293_);
																		_tmp295_ = _tmp294_;
																		_tmp296_ = outline_img;
																		_tmp297_ = _tmp296_[i + 4];
																		_tmp298_ = g_strdup_printf ("%hhu", _tmp297_);
																		_tmp299_ = _tmp298_;
																		_tmp300_ = outline_img;
																		_tmp301_ = _tmp300_[i + s];
																		_tmp302_ = g_strdup_printf ("%hhu", _tmp301_);
																		_tmp303_ = _tmp302_;
																		_tmp304_ = outline_img;
																		_tmp305_ = _tmp304_[(i + s) + 4];
																		_tmp306_ = g_strdup_printf ("%hhu", _tmp305_);
																		_tmp307_ = _tmp306_;
																		_tmp308_ = g_strconcat ("No direction\n ", _tmp295_, " ", _tmp299_, "\n ", _tmp303_, " ", _tmp307_, NULL);
																		_tmp309_ = _tmp308_;
																		g_warning ("BackgroundImage.vala:1175: %s", _tmp309_);
																		_g_free0 (_tmp309_);
																		_g_free0 (_tmp307_);
																		_g_free0 (_tmp303_);
																		_g_free0 (_tmp299_);
																		_g_free0 (_tmp295_);
																		i += 4;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp310_ = self->priv->start_points;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp310_);
	_tmp311_ = self->priv->points;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp311_);
	result = pl;
	_cairo_surface_destroy0 (scaled_image);
	_g_object_unref0 (p);
	_cairo_surface_destroy0 (img);
	return result;
}

static gint
bird_font_background_image_find_start_point (BirdFontBackgroundImage* self,
                                             guint8* outline_img,
                                             gint len,
                                             gint s,
                                             gint start_index)
{
	gint i = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	i = start_index;
	if (i < (s + 4)) {
		i = s + 4;
	}
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		guint8 _tmp4_;
		if (!(i < ((len - 4) - s))) {
			break;
		}
		_tmp4_ = outline_img[i];
		if (((gint) _tmp4_) == 0) {
			guint8 _tmp5_;
			_tmp5_ = outline_img[i + 4];
			_tmp3_ = ((gint) _tmp5_) == 255;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			guint8 _tmp6_;
			_tmp6_ = outline_img[i + s];
			_tmp2_ = ((gint) _tmp6_) == 255;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			guint8 _tmp7_;
			_tmp7_ = outline_img[(i + s) + 4];
			_tmp1_ = ((gint) _tmp7_) == 255;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = !bird_font_background_image_has_start_point (self, i);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = i;
			return result;
		} else {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			guint8 _tmp12_;
			_tmp12_ = outline_img[i];
			if (((gint) _tmp12_) == 255) {
				guint8 _tmp13_;
				_tmp13_ = outline_img[i + 4];
				_tmp11_ = ((gint) _tmp13_) == 0;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				guint8 _tmp14_;
				_tmp14_ = outline_img[i + s];
				_tmp10_ = ((gint) _tmp14_) == 255;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				guint8 _tmp15_;
				_tmp15_ = outline_img[(i + s) + 4];
				_tmp9_ = ((gint) _tmp15_) == 255;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				_tmp8_ = !bird_font_background_image_has_start_point (self, i);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = i;
				return result;
			} else {
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				guint8 _tmp20_;
				_tmp20_ = outline_img[i];
				if (((gint) _tmp20_) == 255) {
					guint8 _tmp21_;
					_tmp21_ = outline_img[i + 4];
					_tmp19_ = ((gint) _tmp21_) == 255;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					guint8 _tmp22_;
					_tmp22_ = outline_img[i + s];
					_tmp18_ = ((gint) _tmp22_) == 0;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					guint8 _tmp23_;
					_tmp23_ = outline_img[(i + s) + 4];
					_tmp17_ = ((gint) _tmp23_) == 255;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					_tmp16_ = !bird_font_background_image_has_start_point (self, i);
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					result = i;
					return result;
				} else {
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_ = FALSE;
					gboolean _tmp26_ = FALSE;
					gboolean _tmp27_ = FALSE;
					guint8 _tmp28_;
					_tmp28_ = outline_img[i];
					if (((gint) _tmp28_) == 255) {
						guint8 _tmp29_;
						_tmp29_ = outline_img[i + 4];
						_tmp27_ = ((gint) _tmp29_) == 255;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						guint8 _tmp30_;
						_tmp30_ = outline_img[i + s];
						_tmp26_ = ((gint) _tmp30_) == 255;
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						guint8 _tmp31_;
						_tmp31_ = outline_img[(i + s) + 4];
						_tmp25_ = ((gint) _tmp31_) == 0;
					} else {
						_tmp25_ = FALSE;
					}
					if (_tmp25_) {
						_tmp24_ = !bird_font_background_image_has_start_point (self, i);
					} else {
						_tmp24_ = FALSE;
					}
					if (_tmp24_) {
						result = i;
						return result;
					} else {
						gboolean _tmp32_ = FALSE;
						gboolean _tmp33_ = FALSE;
						gboolean _tmp34_ = FALSE;
						gboolean _tmp35_ = FALSE;
						guint8 _tmp36_;
						_tmp36_ = outline_img[i];
						if (((gint) _tmp36_) == 255) {
							guint8 _tmp37_;
							_tmp37_ = outline_img[i + 4];
							_tmp35_ = ((gint) _tmp37_) == 0;
						} else {
							_tmp35_ = FALSE;
						}
						if (_tmp35_) {
							guint8 _tmp38_;
							_tmp38_ = outline_img[i + s];
							_tmp34_ = ((gint) _tmp38_) == 0;
						} else {
							_tmp34_ = FALSE;
						}
						if (_tmp34_) {
							guint8 _tmp39_;
							_tmp39_ = outline_img[(i + s) + 4];
							_tmp33_ = ((gint) _tmp39_) == 0;
						} else {
							_tmp33_ = FALSE;
						}
						if (_tmp33_) {
							_tmp32_ = !bird_font_background_image_has_start_point (self, i);
						} else {
							_tmp32_ = FALSE;
						}
						if (_tmp32_) {
							result = i;
							return result;
						} else {
							gboolean _tmp40_ = FALSE;
							gboolean _tmp41_ = FALSE;
							gboolean _tmp42_ = FALSE;
							gboolean _tmp43_ = FALSE;
							guint8 _tmp44_;
							_tmp44_ = outline_img[i];
							if (((gint) _tmp44_) == 0) {
								guint8 _tmp45_;
								_tmp45_ = outline_img[i + 4];
								_tmp43_ = ((gint) _tmp45_) == 255;
							} else {
								_tmp43_ = FALSE;
							}
							if (_tmp43_) {
								guint8 _tmp46_;
								_tmp46_ = outline_img[i + s];
								_tmp42_ = ((gint) _tmp46_) == 0;
							} else {
								_tmp42_ = FALSE;
							}
							if (_tmp42_) {
								guint8 _tmp47_;
								_tmp47_ = outline_img[(i + s) + 4];
								_tmp41_ = ((gint) _tmp47_) == 0;
							} else {
								_tmp41_ = FALSE;
							}
							if (_tmp41_) {
								_tmp40_ = !bird_font_background_image_has_start_point (self, i);
							} else {
								_tmp40_ = FALSE;
							}
							if (_tmp40_) {
								result = i;
								return result;
							} else {
								gboolean _tmp48_ = FALSE;
								gboolean _tmp49_ = FALSE;
								gboolean _tmp50_ = FALSE;
								gboolean _tmp51_ = FALSE;
								guint8 _tmp52_;
								_tmp52_ = outline_img[i];
								if (((gint) _tmp52_) == 0) {
									guint8 _tmp53_;
									_tmp53_ = outline_img[i + 4];
									_tmp51_ = ((gint) _tmp53_) == 0;
								} else {
									_tmp51_ = FALSE;
								}
								if (_tmp51_) {
									guint8 _tmp54_;
									_tmp54_ = outline_img[i + s];
									_tmp50_ = ((gint) _tmp54_) == 255;
								} else {
									_tmp50_ = FALSE;
								}
								if (_tmp50_) {
									guint8 _tmp55_;
									_tmp55_ = outline_img[(i + s) + 4];
									_tmp49_ = ((gint) _tmp55_) == 0;
								} else {
									_tmp49_ = FALSE;
								}
								if (_tmp49_) {
									_tmp48_ = !bird_font_background_image_has_start_point (self, i);
								} else {
									_tmp48_ = FALSE;
								}
								if (_tmp48_) {
									result = i;
									return result;
								} else {
									gboolean _tmp56_ = FALSE;
									gboolean _tmp57_ = FALSE;
									gboolean _tmp58_ = FALSE;
									gboolean _tmp59_ = FALSE;
									guint8 _tmp60_;
									_tmp60_ = outline_img[i];
									if (((gint) _tmp60_) == 0) {
										guint8 _tmp61_;
										_tmp61_ = outline_img[i + 4];
										_tmp59_ = ((gint) _tmp61_) == 0;
									} else {
										_tmp59_ = FALSE;
									}
									if (_tmp59_) {
										guint8 _tmp62_;
										_tmp62_ = outline_img[i + s];
										_tmp58_ = ((gint) _tmp62_) == 0;
									} else {
										_tmp58_ = FALSE;
									}
									if (_tmp58_) {
										guint8 _tmp63_;
										_tmp63_ = outline_img[(i + s) + 4];
										_tmp57_ = ((gint) _tmp63_) == 255;
									} else {
										_tmp57_ = FALSE;
									}
									if (_tmp57_) {
										_tmp56_ = !bird_font_background_image_has_start_point (self, i);
									} else {
										_tmp56_ = FALSE;
									}
									if (_tmp56_) {
										result = i;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
		i += 4;
	}
	result = -1;
	return result;
}

static void
bird_font_background_image_find_corner (BirdFontBackgroundImage* self,
                                        BirdFontPath* path,
                                        gint point_index,
                                        gint end,
                                        gdouble points_per_unit,
                                        gdouble* x,
                                        gdouble* y)
{
	BirdFontBackgroundImageTracedPoint* tp0 = NULL;
	gdouble sx = 0.0;
	gdouble sy = 0.0;
	gdouble d = 0.0;
	gdouble mind = 0.0;
	gint index = 0;
	gint pi = 0;
	BirdFontEditPoint* ep0 = NULL;
	BirdFontEditPoint* ep1 = NULL;
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gpointer _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gpointer _tmp13_;
	BirdFontEditPoint* _tmp14_;
	BirdFontEditPointHandle* _tmp15_;
	BirdFontEditPoint* _tmp16_;
	BirdFontEditPointHandle* _tmp17_;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	BirdFontEditPoint* _tmp20_;
	BirdFontEditPoint* _tmp21_;
	BirdFontEditPoint* _tmp22_;
	BirdFontEditPoint* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	sx = (gdouble) 0;
	sy = (gdouble) 0;
	d = (gdouble) 0;
	mind = DBL_MAX;
	index = 0;
	pi = point_index - 1;
	if (pi < 0) {
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp0_ = bird_font_path_get_points (path);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		pi += _tmp3_;
	}
	_tmp4_ = bird_font_path_get_points (path);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, pi);
	_g_object_unref0 (ep0);
	ep0 = (BirdFontEditPoint*) _tmp6_;
	pi = point_index + 1;
	_tmp7_ = bird_font_path_get_points (path);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	pi %= _tmp10_;
	_tmp11_ = bird_font_path_get_points (path);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, pi);
	_g_object_unref0 (ep1);
	ep1 = (BirdFontEditPoint*) _tmp13_;
	_tmp14_ = ep0;
	_tmp15_ = bird_font_edit_point_get_left_handle (_tmp14_);
	_tmp16_ = ep1;
	_tmp17_ = bird_font_edit_point_get_right_handle (_tmp16_);
	bird_font_path_find_intersection_handle (_tmp15_, _tmp17_, &_tmp18_, &_tmp19_);
	sx = _tmp18_;
	sy = _tmp19_;
	_tmp20_ = ep0;
	dx = (*x) - _tmp20_->x;
	_tmp21_ = ep0;
	dy = (*y) - _tmp21_->y;
	sx += 3 * dx;
	sy += 3 * dy;
	_tmp22_ = ep1;
	dx = (*x) - _tmp22_->x;
	_tmp23_ = ep1;
	dy = (*y) - _tmp23_->y;
	sx += 3 * dx;
	sy += 3 * dy;
	end = end + ((gint) (points_per_unit / 2.0));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp32_;
				gpointer _tmp33_;
				BirdFontBackgroundImageTracedPoint* _tmp34_;
				BirdFontBackgroundImageTracedPoint* _tmp35_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(((gdouble) i) < (2 * points_per_unit))) {
					break;
				}
				index = end - i;
				if (index < 0) {
					GeeArrayList* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					_tmp26_ = self->priv->points;
					_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
					_tmp28_ = _tmp27_;
					index += _tmp28_;
				} else {
					GeeArrayList* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					_tmp29_ = self->priv->points;
					_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
					_tmp31_ = _tmp30_;
					index %= _tmp31_;
				}
				_tmp32_ = self->priv->points;
				_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, index);
				_bird_font_background_image_traced_point_unref0 (tp0);
				tp0 = (BirdFontBackgroundImageTracedPoint*) _tmp33_;
				_tmp34_ = tp0;
				_tmp35_ = tp0;
				d = bird_font_path_distance (_tmp34_->x, sx, _tmp35_->y, sy);
				if (d < mind) {
					BirdFontBackgroundImageTracedPoint* _tmp36_;
					BirdFontBackgroundImageTracedPoint* _tmp37_;
					mind = d;
					_tmp36_ = tp0;
					*x = _tmp36_->x;
					_tmp37_ = tp0;
					*y = _tmp37_->y;
				}
			}
		}
	}
	_g_object_unref0 (ep1);
	_g_object_unref0 (ep0);
	_bird_font_background_image_traced_point_unref0 (tp0);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static BirdFontPath*
bird_font_background_image_generate_path (BirdFontBackgroundImage* self,
                                          guint8* outline_img,
                                          gint stride,
                                          gint w,
                                          gint h,
                                          gint length)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble np = 0.0;
	gint i = 0;
	gint index = 0;
	gdouble sumx = 0.0;
	gdouble sumy = 0.0;
	gdouble points_per_unit = 0.0;
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp0_;
	GeeArrayList* sp = NULL;
	GeeArrayList* _tmp1_;
	gdouble corner = 0.0;
	GeeArrayList* traced = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* corners = NULL;
	GeeArrayList* _tmp3_;
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPointHandle* r = NULL;
	BirdFontEditPointHandle* l = NULL;
	gdouble la = 0.0;
	gdouble a = 0.0;
	BirdFontPointSelection* ps = NULL;
	gdouble image_scale_x = 0.0;
	gdouble image_scale_y = 0.0;
	BirdFontBackgroundImageTracedPoint* average_point = NULL;
	gint pi = 0;
	cairo_surface_t* img = NULL;
	gdouble simplification = 0.0;
	BirdFontSpinButton* _tmp4_;
	cairo_surface_t* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	cairo_surface_t* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	cairo_surface_t* _tmp11_;
	BirdFontPath* _tmp84_;
	BirdFontPath* _tmp85_;
	BirdFontPath* _tmp86_;
	BirdFontPath* _tmp155_;
	BirdFontPath* _tmp156_;
	BirdFontPath* _tmp157_;
	BirdFontPath* _tmp206_;
	BirdFontPath* _tmp207_;
	GeeArrayList* _tmp208_;
	BirdFontPath* _tmp209_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	path = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_INT, (GBoxedCopyFunc) _int_dup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	sp = _tmp1_;
	_tmp2_ = gee_array_list_new (BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, (GBoxedCopyFunc) bird_font_background_image_traced_point_ref, (GDestroyNotify) bird_font_background_image_traced_point_unref, NULL, NULL, NULL);
	traced = _tmp2_;
	_tmp3_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	corners = _tmp3_;
	_tmp4_ = bird_font_drawing_tools_auto_trace_simplify;
	simplification = bird_font_spin_button_get_value (_tmp4_);
	_tmp5_ = bird_font_background_image_get_contrast_image (self);
	_cairo_surface_destroy0 (img);
	img = _tmp5_;
	_tmp6_ = bird_font_background_image_get_size_margin (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = img;
	image_scale_x = ((gdouble) _tmp7_) / cairo_image_surface_get_width (_tmp8_);
	_tmp9_ = bird_font_background_image_get_size_margin (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = img;
	image_scale_y = ((gdouble) _tmp10_) / cairo_image_surface_get_height (_tmp11_);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp12_;
		gint _p_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = self->priv->points;
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			BirdFontBackgroundImageTracedPoint* p = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			GeeArrayList* _tmp20_;
			BirdFontBackgroundImageTracedPoint* _tmp21_;
			_p_index = _p_index + 1;
			_tmp16_ = _p_index;
			_tmp17_ = _p_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _p_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _p_index);
			p = (BirdFontBackgroundImageTracedPoint*) _tmp19_;
			_tmp20_ = self->priv->start_points;
			_tmp21_ = p;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
			_bird_font_background_image_traced_point_unref0 (p);
		}
	}
	sumx = (gdouble) 0;
	sumy = (gdouble) 0;
	np = (gdouble) 0;
	points_per_unit = (gdouble) 9;
	corner = G_PI / 3.5;
	i = 0;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp22_;
		gint _p_size = 0;
		GeeArrayList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _p_index = 0;
		_tmp22_ = self->priv->points;
		_p_list = _tmp22_;
		_tmp23_ = _p_list;
		_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_p_size = _tmp25_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			BirdFontBackgroundImageTracedPoint* p = NULL;
			GeeArrayList* _tmp28_;
			gpointer _tmp29_;
			BirdFontBackgroundImageTracedPoint* _tmp30_;
			gdouble _tmp31_;
			gdouble _tmp32_;
			gdouble _tmp33_;
			gdouble _tmp34_;
			gdouble _tmp35_;
			gdouble _tmp36_;
			gdouble _tmp37_;
			gdouble _tmp38_;
			gdouble _tmp39_;
			gdouble _tmp40_;
			gdouble _tmp41_;
			gdouble _tmp42_;
			BirdFontBackgroundImageTracedPoint* _tmp43_;
			BirdFontBackgroundImageTracedPoint* _tmp44_;
			gdouble _tmp45_;
			gint _tmp52_;
			_p_index = _p_index + 1;
			_tmp26_ = _p_index;
			_tmp27_ = _p_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _p_list;
			_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _p_index);
			p = (BirdFontBackgroundImageTracedPoint*) _tmp29_;
			_tmp30_ = p;
			index = _tmp30_->index;
			_tmp31_ = bird_font_background_image_get_img_scale_x (self);
			_tmp32_ = _tmp31_;
			_tmp33_ = bird_font_background_image_get_img_scale_x (self);
			_tmp34_ = _tmp33_;
			x = (((-w) * _tmp32_) / 2) + ((((index + 4) % stride) / 4) * _tmp34_);
			_tmp35_ = bird_font_background_image_get_img_scale_y (self);
			_tmp36_ = _tmp35_;
			_tmp37_ = bird_font_background_image_get_img_scale_y (self);
			_tmp38_ = _tmp37_;
			y = ((h * _tmp36_) / 2) + ((-((index - (x * 4)) / stride)) * _tmp38_);
			x *= image_scale_x;
			y *= image_scale_y;
			_tmp39_ = bird_font_background_image_get_img_middle_x (self);
			_tmp40_ = _tmp39_;
			x += _tmp40_;
			_tmp41_ = bird_font_background_image_get_img_middle_y (self);
			_tmp42_ = _tmp41_;
			y += _tmp42_;
			_tmp43_ = p;
			_tmp43_->x = x;
			_tmp44_ = p;
			_tmp44_->y = y;
			_tmp45_ = np;
			np = _tmp45_ + 1;
			sumx += x;
			sumy += y;
			if (np >= points_per_unit) {
				BirdFontBackgroundImageTracedPoint* _tmp46_;
				BirdFontBackgroundImageTracedPoint* _tmp47_;
				BirdFontBackgroundImageTracedPoint* _tmp48_;
				GeeArrayList* _tmp49_;
				BirdFontBackgroundImageTracedPoint* _tmp50_;
				GeeArrayList* _tmp51_;
				_tmp46_ = bird_font_background_image_traced_point_new (-1);
				_bird_font_background_image_traced_point_unref0 (average_point);
				average_point = _tmp46_;
				_tmp47_ = average_point;
				_tmp47_->x = sumx / np;
				_tmp48_ = average_point;
				_tmp48_->y = sumy / np;
				_tmp49_ = traced;
				_tmp50_ = average_point;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
				_tmp51_ = sp;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, &i);
				np = (gdouble) 0;
				sumx = (gdouble) 0;
				sumy = (gdouble) 0;
			}
			_tmp52_ = i;
			i = _tmp52_ + 1;
			_bird_font_background_image_traced_point_unref0 (p);
		}
	}
	if (np != ((gdouble) 0)) {
		BirdFontBackgroundImageTracedPoint* _tmp53_;
		BirdFontBackgroundImageTracedPoint* _tmp54_;
		BirdFontBackgroundImageTracedPoint* _tmp55_;
		GeeArrayList* _tmp56_;
		BirdFontBackgroundImageTracedPoint* _tmp57_;
		GeeArrayList* _tmp58_;
		_tmp53_ = bird_font_background_image_traced_point_new (-1);
		_bird_font_background_image_traced_point_unref0 (average_point);
		average_point = _tmp53_;
		_tmp54_ = average_point;
		_tmp54_->x = sumx / np;
		_tmp55_ = average_point;
		_tmp55_->y = sumy / np;
		_tmp56_ = traced;
		_tmp57_ = average_point;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp57_);
		_tmp58_ = sp;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp58_, &i);
	}
	{
		GeeArrayList* _avgp_list = NULL;
		GeeArrayList* _tmp59_;
		gint _avgp_size = 0;
		GeeArrayList* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		gint _avgp_index = 0;
		_tmp59_ = traced;
		_avgp_list = _tmp59_;
		_tmp60_ = _avgp_list;
		_tmp61_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp60_);
		_tmp62_ = _tmp61_;
		_avgp_size = _tmp62_;
		_avgp_index = -1;
		while (TRUE) {
			gint _tmp63_;
			gint _tmp64_;
			BirdFontBackgroundImageTracedPoint* avgp = NULL;
			GeeArrayList* _tmp65_;
			gpointer _tmp66_;
			BirdFontBackgroundImageTracedPoint* _tmp67_;
			BirdFontBackgroundImageTracedPoint* _tmp68_;
			BirdFontEditPoint* _tmp69_;
			BirdFontPath* _tmp70_;
			GeeArrayList* _tmp71_;
			GeeArrayList* _tmp72_;
			BirdFontEditPoint* _tmp73_;
			_avgp_index = _avgp_index + 1;
			_tmp63_ = _avgp_index;
			_tmp64_ = _avgp_size;
			if (!(_tmp63_ < _tmp64_)) {
				break;
			}
			_tmp65_ = _avgp_list;
			_tmp66_ = gee_abstract_list_get ((GeeAbstractList*) _tmp65_, _avgp_index);
			avgp = (BirdFontBackgroundImageTracedPoint*) _tmp66_;
			_tmp67_ = avgp;
			_tmp68_ = avgp;
			_tmp69_ = bird_font_edit_point_new (_tmp67_->x, _tmp68_->y, BIRD_FONT_POINT_TYPE_NONE);
			_g_object_unref0 (ep);
			ep = _tmp69_;
			_tmp70_ = path;
			_tmp71_ = bird_font_path_get_points (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = ep;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp72_, _tmp73_);
			if (bird_font_drawing_tools_point_type == BIRD_FONT_POINT_TYPE_CUBIC) {
				BirdFontEditPoint* _tmp74_;
				BirdFontEditPoint* _tmp75_;
				BirdFontEditPointHandle* _tmp76_;
				BirdFontEditPoint* _tmp77_;
				BirdFontEditPointHandle* _tmp78_;
				_tmp74_ = ep;
				_tmp74_->type = BIRD_FONT_POINT_TYPE_CUBIC;
				_tmp75_ = ep;
				_tmp76_ = bird_font_edit_point_get_right_handle (_tmp75_);
				_tmp76_->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
				_tmp77_ = ep;
				_tmp78_ = bird_font_edit_point_get_left_handle (_tmp77_);
				_tmp78_->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
			} else {
				BirdFontEditPoint* _tmp79_;
				BirdFontEditPoint* _tmp80_;
				BirdFontEditPointHandle* _tmp81_;
				BirdFontEditPoint* _tmp82_;
				BirdFontEditPointHandle* _tmp83_;
				_tmp79_ = ep;
				_tmp79_->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
				_tmp80_ = ep;
				_tmp81_ = bird_font_edit_point_get_right_handle (_tmp80_);
				_tmp81_->type = BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
				_tmp82_ = ep;
				_tmp83_ = bird_font_edit_point_get_left_handle (_tmp82_);
				_tmp83_->type = BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
			}
			_bird_font_background_image_traced_point_unref0 (avgp);
		}
	}
	_tmp84_ = path;
	bird_font_path_close (_tmp84_);
	_tmp85_ = path;
	bird_font_path_create_list (_tmp85_);
	_tmp86_ = path;
	bird_font_path_recalculate_linear_handles (_tmp86_);
	pi = 0;
	{
		gboolean _tmp87_ = FALSE;
		i = 1;
		_tmp87_ = TRUE;
		while (TRUE) {
			GeeArrayList* _tmp88_;
			gint _tmp89_;
			gint _tmp90_;
			BirdFontPath* _tmp91_;
			GeeArrayList* _tmp92_;
			GeeArrayList* _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			BirdFontPath* _tmp97_;
			BirdFontPath* _tmp98_;
			GeeArrayList* _tmp99_;
			GeeArrayList* _tmp100_;
			gpointer _tmp101_;
			BirdFontPath* _tmp102_;
			GeeArrayList* _tmp103_;
			GeeArrayList* _tmp104_;
			gint _tmp105_;
			gint _tmp106_;
			BirdFontPath* _tmp107_;
			GeeArrayList* _tmp108_;
			GeeArrayList* _tmp109_;
			gint _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			BirdFontPath* _tmp113_;
			BirdFontPath* _tmp114_;
			GeeArrayList* _tmp115_;
			GeeArrayList* _tmp116_;
			gpointer _tmp117_;
			BirdFontEditPoint* _tmp118_;
			BirdFontEditPointHandle* _tmp119_;
			BirdFontEditPointHandle* _tmp120_;
			BirdFontPath* _tmp126_;
			GeeArrayList* _tmp127_;
			GeeArrayList* _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			gint _tmp131_;
			BirdFontPath* _tmp132_;
			BirdFontPath* _tmp133_;
			GeeArrayList* _tmp134_;
			GeeArrayList* _tmp135_;
			gpointer _tmp136_;
			BirdFontEditPoint* _tmp137_;
			BirdFontEditPointHandle* _tmp138_;
			BirdFontEditPointHandle* _tmp139_;
			BirdFontEditPointHandle* _tmp140_;
			gboolean _tmp141_ = FALSE;
			BirdFontEditPointHandle* _tmp142_;
			BirdFontEditPointHandle* _tmp145_;
			if (!_tmp87_) {
				i += 2;
			}
			_tmp87_ = FALSE;
			_tmp88_ = sp;
			_tmp89_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp88_);
			_tmp90_ = _tmp89_;
			if (!(i < _tmp90_)) {
				break;
			}
			_tmp91_ = path;
			_tmp92_ = bird_font_path_get_points (_tmp91_);
			_tmp93_ = _tmp92_;
			_tmp94_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp93_);
			_tmp95_ = _tmp94_;
			_tmp96_ = i;
			_tmp97_ = path;
			g_return_val_if_fail ((0 <= _tmp96_) && (_tmp96_ < _tmp95_), _tmp97_);
			_tmp98_ = path;
			_tmp99_ = bird_font_path_get_points (_tmp98_);
			_tmp100_ = _tmp99_;
			_tmp101_ = gee_abstract_list_get ((GeeAbstractList*) _tmp100_, i);
			_g_object_unref0 (ep);
			ep = (BirdFontEditPoint*) _tmp101_;
			pi = i + 2;
			_tmp102_ = path;
			_tmp103_ = bird_font_path_get_points (_tmp102_);
			_tmp104_ = _tmp103_;
			_tmp105_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp104_);
			_tmp106_ = _tmp105_;
			pi %= _tmp106_;
			_tmp107_ = path;
			_tmp108_ = bird_font_path_get_points (_tmp107_);
			_tmp109_ = _tmp108_;
			_tmp110_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp109_);
			_tmp111_ = _tmp110_;
			_tmp112_ = pi;
			_tmp113_ = path;
			g_return_val_if_fail ((0 <= _tmp112_) && (_tmp112_ < _tmp111_), _tmp113_);
			_tmp114_ = path;
			_tmp115_ = bird_font_path_get_points (_tmp114_);
			_tmp116_ = _tmp115_;
			_tmp117_ = gee_abstract_list_get ((GeeAbstractList*) _tmp116_, pi);
			_tmp118_ = (BirdFontEditPoint*) _tmp117_;
			_tmp119_ = bird_font_edit_point_get_left_handle (_tmp118_);
			_tmp120_ = _g_object_ref0 (_tmp119_);
			_g_object_unref0 (l);
			l = _tmp120_;
			_g_object_unref0 (_tmp118_);
			pi = i - 2;
			if (pi < 0) {
				BirdFontPath* _tmp121_;
				GeeArrayList* _tmp122_;
				GeeArrayList* _tmp123_;
				gint _tmp124_;
				gint _tmp125_;
				_tmp121_ = path;
				_tmp122_ = bird_font_path_get_points (_tmp121_);
				_tmp123_ = _tmp122_;
				_tmp124_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp123_);
				_tmp125_ = _tmp124_;
				pi += _tmp125_;
			}
			_tmp126_ = path;
			_tmp127_ = bird_font_path_get_points (_tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = pi;
			_tmp132_ = path;
			g_return_val_if_fail ((0 <= _tmp131_) && (_tmp131_ < _tmp130_), _tmp132_);
			_tmp133_ = path;
			_tmp134_ = bird_font_path_get_points (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = gee_abstract_list_get ((GeeAbstractList*) _tmp135_, pi);
			_tmp137_ = (BirdFontEditPoint*) _tmp136_;
			_tmp138_ = bird_font_edit_point_get_right_handle (_tmp137_);
			_tmp139_ = _g_object_ref0 (_tmp138_);
			_g_object_unref0 (r);
			r = _tmp139_;
			_g_object_unref0 (_tmp137_);
			_tmp140_ = l;
			la = _tmp140_->angle - G_PI;
			while (TRUE) {
				if (!(la < ((gdouble) 0))) {
					break;
				}
				la += 2 * G_PI;
			}
			_tmp142_ = r;
			if (_tmp142_->angle > ((2.0 / 3.0) * G_PI)) {
				_tmp141_ = la < (G_PI / 2);
			} else {
				_tmp141_ = FALSE;
			}
			if (_tmp141_) {
				la += 2 * G_PI;
			} else {
				gboolean _tmp143_ = FALSE;
				if (la > ((2.0 / 3.0) * G_PI)) {
					BirdFontEditPointHandle* _tmp144_;
					_tmp144_ = r;
					_tmp143_ = _tmp144_->angle < (G_PI / 2);
				} else {
					_tmp143_ = FALSE;
				}
				if (_tmp143_) {
					la -= 2 * G_PI;
				}
			}
			_tmp145_ = r;
			a = _tmp145_->angle - la;
			if (fabs (a) > corner) {
				BirdFontEditPoint* _tmp146_;
				BirdFontPath* _tmp147_;
				GeeArrayList* _tmp148_;
				gpointer _tmp149_;
				BirdFontEditPoint* _tmp150_;
				BirdFontEditPoint* _tmp151_;
				GeeArrayList* _tmp152_;
				BirdFontEditPoint* _tmp153_;
				_tmp146_ = ep;
				bird_font_edit_point_set_tie_handle (_tmp146_, FALSE);
				_tmp147_ = path;
				_tmp148_ = sp;
				_tmp149_ = gee_abstract_list_get ((GeeAbstractList*) _tmp148_, i);
				_tmp150_ = ep;
				_tmp151_ = ep;
				bird_font_background_image_find_corner (self, _tmp147_, i, (gint) (*((gint*) _tmp149_)), points_per_unit, &_tmp150_->x, &_tmp151_->y);
				_g_free0 (_tmp149_);
				_tmp152_ = corners;
				_tmp153_ = ep;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp152_, _tmp153_);
			} else {
				BirdFontEditPoint* _tmp154_;
				_tmp154_ = ep;
				bird_font_edit_point_set_tie_handle (_tmp154_, TRUE);
			}
		}
	}
	_tmp155_ = path;
	bird_font_path_recalculate_linear_handles (_tmp155_);
	_tmp156_ = path;
	bird_font_path_remove_points_on_points (_tmp156_, 0.00001);
	_tmp157_ = path;
	bird_font_path_create_list (_tmp157_);
	{
		GeeArrayList* _e_list = NULL;
		BirdFontPath* _tmp158_;
		GeeArrayList* _tmp159_;
		GeeArrayList* _tmp160_;
		gint _e_size = 0;
		GeeArrayList* _tmp161_;
		gint _tmp162_;
		gint _tmp163_;
		gint _e_index = 0;
		_tmp158_ = path;
		_tmp159_ = bird_font_path_get_points (_tmp158_);
		_tmp160_ = _tmp159_;
		_e_list = _tmp160_;
		_tmp161_ = _e_list;
		_tmp162_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp161_);
		_tmp163_ = _tmp162_;
		_e_size = _tmp163_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp164_;
			gint _tmp165_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp166_;
			gpointer _tmp167_;
			BirdFontEditPoint* _tmp168_;
			gboolean _tmp169_;
			gboolean _tmp170_;
			_e_index = _e_index + 1;
			_tmp164_ = _e_index;
			_tmp165_ = _e_size;
			if (!(_tmp164_ < _tmp165_)) {
				break;
			}
			_tmp166_ = _e_list;
			_tmp167_ = gee_abstract_list_get ((GeeAbstractList*) _tmp166_, _e_index);
			e = (BirdFontEditPoint*) _tmp167_;
			_tmp168_ = e;
			_tmp169_ = bird_font_edit_point_get_tie_handles (_tmp168_);
			_tmp170_ = _tmp169_;
			if (_tmp170_) {
				BirdFontEditPoint* _tmp171_;
				_tmp171_ = e;
				bird_font_edit_point_process_tied_handle (_tmp171_);
			}
			_g_object_unref0 (e);
		}
	}
	if (simplification > 0.01) {
		{
			gboolean _tmp172_ = FALSE;
			i = 0;
			_tmp172_ = TRUE;
			while (TRUE) {
				BirdFontPath* _tmp174_;
				GeeArrayList* _tmp175_;
				GeeArrayList* _tmp176_;
				gint _tmp177_;
				gint _tmp178_;
				BirdFontPath* _tmp179_;
				GeeArrayList* _tmp180_;
				GeeArrayList* _tmp181_;
				gpointer _tmp182_;
				BirdFontEditPoint* _tmp183_;
				BirdFontPath* _tmp184_;
				BirdFontPointSelection* _tmp185_;
				GeeArrayList* _tmp186_;
				BirdFontEditPoint* _tmp187_;
				if (!_tmp172_) {
					gint _tmp173_;
					_tmp173_ = i;
					i = _tmp173_ + 1;
				}
				_tmp172_ = FALSE;
				_tmp174_ = path;
				_tmp175_ = bird_font_path_get_points (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp176_);
				_tmp178_ = _tmp177_;
				if (!(i < _tmp178_)) {
					break;
				}
				_tmp179_ = path;
				_tmp180_ = bird_font_path_get_points (_tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = gee_abstract_list_get ((GeeAbstractList*) _tmp181_, i);
				_g_object_unref0 (ep);
				ep = (BirdFontEditPoint*) _tmp182_;
				_tmp183_ = ep;
				_tmp184_ = path;
				_tmp185_ = bird_font_point_selection_new (_tmp183_, _tmp184_);
				_g_object_unref0 (ps);
				ps = _tmp185_;
				_tmp186_ = corners;
				_tmp187_ = ep;
				if (gee_abstract_list_index_of ((GeeAbstractList*) _tmp186_, _tmp187_) == -1) {
					BirdFontPointSelection* _tmp188_;
					_tmp188_ = ps;
					bird_font_pen_tool_remove_point_simplify (_tmp188_, simplification);
				}
			}
		}
	}
	{
		gboolean _tmp189_ = FALSE;
		i = 0;
		_tmp189_ = TRUE;
		while (TRUE) {
			BirdFontPath* _tmp191_;
			GeeArrayList* _tmp192_;
			GeeArrayList* _tmp193_;
			gint _tmp194_;
			gint _tmp195_;
			BirdFontPath* _tmp196_;
			GeeArrayList* _tmp197_;
			GeeArrayList* _tmp198_;
			gpointer _tmp199_;
			BirdFontEditPoint* _tmp200_;
			BirdFontPath* _tmp201_;
			BirdFontPointSelection* _tmp202_;
			GeeArrayList* _tmp203_;
			BirdFontEditPoint* _tmp204_;
			if (!_tmp189_) {
				gint _tmp190_;
				_tmp190_ = i;
				i = _tmp190_ + 1;
			}
			_tmp189_ = FALSE;
			_tmp191_ = path;
			_tmp192_ = bird_font_path_get_points (_tmp191_);
			_tmp193_ = _tmp192_;
			_tmp194_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp193_);
			_tmp195_ = _tmp194_;
			if (!(i < _tmp195_)) {
				break;
			}
			_tmp196_ = path;
			_tmp197_ = bird_font_path_get_points (_tmp196_);
			_tmp198_ = _tmp197_;
			_tmp199_ = gee_abstract_list_get ((GeeAbstractList*) _tmp198_, i);
			_g_object_unref0 (ep);
			ep = (BirdFontEditPoint*) _tmp199_;
			_tmp200_ = ep;
			_tmp201_ = path;
			_tmp202_ = bird_font_point_selection_new (_tmp200_, _tmp201_);
			_g_object_unref0 (ps);
			ps = _tmp202_;
			_tmp203_ = corners;
			_tmp204_ = ep;
			if (gee_abstract_list_index_of ((GeeAbstractList*) _tmp203_, _tmp204_) == -1) {
				BirdFontEditPoint* _tmp205_;
				_tmp205_ = ep;
				bird_font_edit_point_set_selected (_tmp205_, TRUE);
			}
		}
	}
	_tmp206_ = path;
	_tmp207_ = bird_font_pen_tool_simplify (_tmp206_, TRUE, simplification);
	_g_object_unref0 (path);
	path = _tmp207_;
	_tmp208_ = self->priv->points;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp208_);
	_tmp209_ = path;
	bird_font_path_update_region_boundaries (_tmp209_);
	result = path;
	_cairo_surface_destroy0 (img);
	_bird_font_background_image_traced_point_unref0 (average_point);
	_g_object_unref0 (ps);
	_g_object_unref0 (l);
	_g_object_unref0 (r);
	_g_object_unref0 (ep);
	_g_object_unref0 (corners);
	_g_object_unref0 (traced);
	_g_object_unref0 (sp);
	return result;
}

static gboolean
bird_font_background_image_has_start_point (BirdFontBackgroundImage* self,
                                            gint i)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = self->priv->start_points;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontBackgroundImageTracedPoint* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontBackgroundImageTracedPoint* _tmp8_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontBackgroundImageTracedPoint*) _tmp7_;
			_tmp8_ = p;
			if (_tmp8_->index == i) {
				result = TRUE;
				_bird_font_background_image_traced_point_unref0 (p);
				return result;
			}
			_bird_font_background_image_traced_point_unref0 (p);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
bird_font_background_image_is_traced (BirdFontBackgroundImage* self,
                                      gint i)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = self->priv->points;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontBackgroundImageTracedPoint* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontBackgroundImageTracedPoint* _tmp8_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontBackgroundImageTracedPoint*) _tmp7_;
			_tmp8_ = p;
			if (_tmp8_->index == i) {
				result = TRUE;
				_bird_font_background_image_traced_point_unref0 (p);
				return result;
			}
			_bird_font_background_image_traced_point_unref0 (p);
		}
	}
	result = FALSE;
	return result;
}

void
bird_font_background_image_center_in_glyph (BirdFontBackgroundImage* self,
                                            BirdFontGlyph* glyph)
{
	BirdFontGlyph* g = NULL;
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyph* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontGlyph* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	BirdFontGlyph* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	BirdFontFont* _tmp12_;
	BirdFontFont* _tmp13_;
	BirdFontFont* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	if (glyph != NULL) {
		BirdFontGlyph* _tmp1_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (glyph, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
		_g_object_unref0 (g);
		g = _tmp1_;
	} else {
		BirdFontGlyph* _tmp2_;
		_tmp2_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (g);
		g = _tmp2_;
	}
	_tmp3_ = g;
	_tmp4_ = bird_font_glyph_get_left_limit (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g;
	_tmp7_ = bird_font_glyph_get_right_limit (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g;
	_tmp10_ = bird_font_glyph_get_left_limit (_tmp9_);
	_tmp11_ = _tmp10_;
	bird_font_background_image_set_img_middle_x (self, _tmp5_ + ((_tmp8_ - _tmp11_) / 2));
	_tmp12_ = f;
	_tmp13_ = f;
	_tmp14_ = f;
	bird_font_background_image_set_img_middle_y (self, _tmp12_->bottom_position + ((_tmp13_->top_position - _tmp14_->bottom_position) / 2));
	_g_object_unref0 (f);
	_g_object_unref0 (g);
}

gdouble
bird_font_background_image_get_img_scale_x (BirdFontBackgroundImage* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->img_scale_x_size;
	return result;
}

void
bird_font_background_image_set_img_scale_x (BirdFontBackgroundImage* self,
                                            gdouble value)
{
	g_return_if_fail (self != NULL);
	if (value > 0.0001) {
		self->priv->img_scale_x_size = value;
	}
	g_object_notify_by_pspec ((GObject *) self, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_X_PROPERTY]);
}

gdouble
bird_font_background_image_get_img_scale_y (BirdFontBackgroundImage* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->img_scale_y_size;
	return result;
}

void
bird_font_background_image_set_img_scale_y (BirdFontBackgroundImage* self,
                                            gdouble value)
{
	g_return_if_fail (self != NULL);
	if (value > 0.0001) {
		self->priv->img_scale_y_size = value;
	}
	g_object_notify_by_pspec ((GObject *) self, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_Y_PROPERTY]);
}

gdouble
bird_font_background_image_get_img_offset_x (BirdFontBackgroundImage* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->img_x + bird_font_glyph_xc ();
	return result;
}

void
bird_font_background_image_set_img_offset_x (BirdFontBackgroundImage* self,
                                             gdouble value)
{
	g_return_if_fail (self != NULL);
	self->img_x = value - bird_font_glyph_xc ();
	g_object_notify_by_pspec ((GObject *) self, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_X_PROPERTY]);
}

gdouble
bird_font_background_image_get_img_offset_y (BirdFontBackgroundImage* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = bird_font_glyph_yc () - self->img_y;
	return result;
}

void
bird_font_background_image_set_img_offset_y (BirdFontBackgroundImage* self,
                                             gdouble value)
{
	g_return_if_fail (self != NULL);
	self->img_y = bird_font_glyph_yc () - value;
	g_object_notify_by_pspec ((GObject *) self, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_Y_PROPERTY]);
}

gint
bird_font_background_image_get_size_margin (BirdFontBackgroundImage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (G_UNLIKELY (self->priv->size == -1)) {
		cairo_surface_t* _tmp0_;
		cairo_surface_t* _tmp1_;
		cairo_surface_t* _tmp2_;
		cairo_surface_t* _tmp3_;
		_tmp0_ = bird_font_background_image_get_img (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = bird_font_background_image_get_img (self);
		_tmp3_ = _tmp2_;
		self->priv->size = (gint) (sqrt (pow ((gdouble) cairo_image_surface_get_height (_tmp1_), (gdouble) 2) + pow ((gdouble) cairo_image_surface_get_width (_tmp3_), (gdouble) 2)) + 0.5);
		_cairo_surface_destroy0 (_tmp3_);
		_cairo_surface_destroy0 (_tmp1_);
	}
	result = self->priv->size;
	return result;
}

gint
bird_font_background_image_get_margin_left (BirdFontBackgroundImage* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = bird_font_background_image_get_size_margin (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp1_ - cairo_image_surface_get_width (_tmp3_);
	_cairo_surface_destroy0 (_tmp3_);
	result = _tmp4_;
	return result;
}

gint
bird_font_background_image_get_margin_top (BirdFontBackgroundImage* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = bird_font_background_image_get_size_margin (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp1_ - cairo_image_surface_get_height (_tmp3_);
	_cairo_surface_destroy0 (_tmp3_);
	result = _tmp4_;
	return result;
}

gdouble
bird_font_background_image_get_img_middle_x (BirdFontBackgroundImage* self)
{
	gdouble result;
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = bird_font_background_image_get_size_margin (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img_scale_x (self);
	_tmp3_ = _tmp2_;
	result = self->img_x + ((_tmp1_ * _tmp3_) / 2);
	return result;
}

void
bird_font_background_image_set_img_middle_x (BirdFontBackgroundImage* self,
                                             gdouble value)
{
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_background_image_get_size_margin (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img_scale_x (self);
	_tmp3_ = _tmp2_;
	self->img_x = value - ((_tmp1_ * _tmp3_) / 2);
	g_object_notify_by_pspec ((GObject *) self, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_X_PROPERTY]);
}

gdouble
bird_font_background_image_get_img_middle_y (BirdFontBackgroundImage* self)
{
	gdouble result;
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = bird_font_background_image_get_size_margin (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img_scale_y (self);
	_tmp3_ = _tmp2_;
	result = self->img_y - ((_tmp1_ * _tmp3_) / 2);
	return result;
}

void
bird_font_background_image_set_img_middle_y (BirdFontBackgroundImage* self,
                                             gdouble value)
{
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_background_image_get_size_margin (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_background_image_get_img_scale_y (self);
	_tmp3_ = _tmp2_;
	self->img_y = value + ((_tmp1_ * _tmp3_) / 2);
	g_object_notify_by_pspec ((GObject *) self, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_Y_PROPERTY]);
}

static BirdFontBackgroundImageTracedPoint*
bird_font_background_image_traced_point_construct (GType object_type,
                                                   gint index)
{
	BirdFontBackgroundImageTracedPoint* self = NULL;
	self = (BirdFontBackgroundImageTracedPoint*) g_type_create_instance (object_type);
	self->index = index;
	return self;
}

static BirdFontBackgroundImageTracedPoint*
bird_font_background_image_traced_point_new (gint index)
{
	return bird_font_background_image_traced_point_construct (BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, index);
}

static void
bird_font_background_image_value_traced_point_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_background_image_value_traced_point_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_background_image_traced_point_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_background_image_value_traced_point_copy_value (const GValue* src_value,
                                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_background_image_traced_point_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_background_image_value_traced_point_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_background_image_value_traced_point_collect_value (GValue* value,
                                                             guint n_collect_values,
                                                             GTypeCValue* collect_values,
                                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontBackgroundImageTracedPoint * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_background_image_traced_point_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_background_image_value_traced_point_lcopy_value (const GValue* value,
                                                           guint n_collect_values,
                                                           GTypeCValue* collect_values,
                                                           guint collect_flags)
{
	BirdFontBackgroundImageTracedPoint ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_background_image_traced_point_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
bird_font_background_image_param_spec_traced_point (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags)
{
	BirdFontBackgroundImageParamSpecTracedPoint* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
bird_font_background_image_value_get_traced_point (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT), NULL);
	return value->data[0].v_pointer;
}

static void
bird_font_background_image_value_set_traced_point (GValue* value,
                                                   gpointer v_object)
{
	BirdFontBackgroundImageTracedPoint * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_background_image_traced_point_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_background_image_traced_point_unref (old);
	}
}

static void
bird_font_background_image_value_take_traced_point (GValue* value,
                                                    gpointer v_object)
{
	BirdFontBackgroundImageTracedPoint * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_background_image_traced_point_unref (old);
	}
}

static void
bird_font_background_image_traced_point_class_init (BirdFontBackgroundImageTracedPointClass * klass,
                                                    gpointer klass_data)
{
	bird_font_background_image_traced_point_parent_class = g_type_class_peek_parent (klass);
	((BirdFontBackgroundImageTracedPointClass *) klass)->finalize = bird_font_background_image_traced_point_finalize;
}

static void
bird_font_background_image_traced_point_instance_init (BirdFontBackgroundImageTracedPoint * self,
                                                       gpointer klass)
{
	self->x = (gdouble) 0;
	self->y = (gdouble) 0;
	self->ref_count = 1;
}

static void
bird_font_background_image_traced_point_finalize (BirdFontBackgroundImageTracedPoint * obj)
{
	BirdFontBackgroundImageTracedPoint * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, BirdFontBackgroundImageTracedPoint);
	g_signal_handlers_destroy (self);
}

static GType
bird_font_background_image_traced_point_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_background_image_value_traced_point_init, bird_font_background_image_value_traced_point_free_value, bird_font_background_image_value_traced_point_copy_value, bird_font_background_image_value_traced_point_peek_pointer, "p", bird_font_background_image_value_traced_point_collect_value, "p", bird_font_background_image_value_traced_point_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontBackgroundImageTracedPointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_background_image_traced_point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontBackgroundImageTracedPoint), 0, (GInstanceInitFunc) bird_font_background_image_traced_point_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_background_image_traced_point_type_id;
	bird_font_background_image_traced_point_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontBackgroundImageTracedPoint", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_background_image_traced_point_type_id;
}

static GType
bird_font_background_image_traced_point_get_type (void)
{
	static volatile gsize bird_font_background_image_traced_point_type_id__once = 0;
	if (g_once_init_enter (&bird_font_background_image_traced_point_type_id__once)) {
		GType bird_font_background_image_traced_point_type_id;
		bird_font_background_image_traced_point_type_id = bird_font_background_image_traced_point_get_type_once ();
		g_once_init_leave (&bird_font_background_image_traced_point_type_id__once, bird_font_background_image_traced_point_type_id);
	}
	return bird_font_background_image_traced_point_type_id__once;
}

static gpointer
bird_font_background_image_traced_point_ref (gpointer instance)
{
	BirdFontBackgroundImageTracedPoint * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
bird_font_background_image_traced_point_unref (gpointer instance)
{
	BirdFontBackgroundImageTracedPoint * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_BACKGROUND_IMAGE_TRACED_POINT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
bird_font_background_image_class_init (BirdFontBackgroundImageClass * klass,
                                       gpointer klass_data)
{
	bird_font_background_image_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontBackgroundImage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_background_image_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_background_image_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_background_image_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_X_PROPERTY, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_X_PROPERTY] = g_param_spec_double ("img-scale-x", "img-scale-x", "img-scale-x", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_Y_PROPERTY, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_Y_PROPERTY] = g_param_spec_double ("img-scale-y", "img-scale-y", "img-scale-y", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_X_PROPERTY, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_X_PROPERTY] = g_param_spec_double ("img-offset-x", "img-offset-x", "img-offset-x", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_Y_PROPERTY, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_Y_PROPERTY] = g_param_spec_double ("img-offset-y", "img-offset-y", "img-offset-y", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_BACKGROUND_IMAGE_SIZE_MARGIN_PROPERTY, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_SIZE_MARGIN_PROPERTY] = g_param_spec_int ("size-margin", "size-margin", "size-margin", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_BACKGROUND_IMAGE_MARGIN_LEFT_PROPERTY, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_MARGIN_LEFT_PROPERTY] = g_param_spec_int ("margin-left", "margin-left", "margin-left", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_BACKGROUND_IMAGE_MARGIN_TOP_PROPERTY, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_MARGIN_TOP_PROPERTY] = g_param_spec_int ("margin-top", "margin-top", "margin-top", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_X_PROPERTY, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_X_PROPERTY] = g_param_spec_double ("img-middle-x", "img-middle-x", "img-middle-x", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_Y_PROPERTY, bird_font_background_image_properties[BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_Y_PROPERTY] = g_param_spec_double ("img-middle-y", "img-middle-y", "img-middle-y", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	bird_font_background_image_signals[BIRD_FONT_BACKGROUND_IMAGE_UPDATED_SIGNAL] = g_signal_new ("updated", BIRD_FONT_TYPE_BACKGROUND_IMAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bird_font_background_image_instance_init (BirdFontBackgroundImage * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	self->priv = bird_font_background_image_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->name = _tmp0_;
	self->img_x = (gdouble) 0;
	self->img_y = (gdouble) 0;
	self->priv->img_scale_x_size = (gdouble) 1;
	self->priv->img_scale_y_size = (gdouble) 1;
	self->img_rotation = (gdouble) 0;
	self->priv->preview_img_rotation = (gdouble) 0;
	self->priv->size = -1;
	self->active_handle = -1;
	self->selected_handle = -1;
	self->priv->background_image = NULL;
	self->priv->original_image = NULL;
	self->high_contrast = FALSE;
	_tmp1_ = gee_array_list_new (BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, (GBoxedCopyFunc) bird_font_background_image_traced_point_ref, (GDestroyNotify) bird_font_background_image_traced_point_unref, NULL, NULL, NULL);
	self->priv->points = _tmp1_;
	_tmp2_ = gee_array_list_new (BIRD_FONT_BACKGROUND_IMAGE_TYPE_TRACED_POINT, (GBoxedCopyFunc) bird_font_background_image_traced_point_ref, (GDestroyNotify) bird_font_background_image_traced_point_unref, NULL, NULL, NULL);
	self->priv->start_points = _tmp2_;
	self->priv->scaled = NULL;
	self->priv->contrast_image = NULL;
}

static void
bird_font_background_image_finalize (GObject * obj)
{
	BirdFontBackgroundImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage);
	_g_free0 (self->name);
	_g_object_unref0 (self->selections);
	_cairo_surface_destroy0 (self->priv->background_image);
	_cairo_surface_destroy0 (self->priv->original_image);
	_g_free0 (self->priv->path);
	_g_object_unref0 (self->priv->points);
	_g_object_unref0 (self->priv->start_points);
	_g_object_unref0 (self->priv->scaled);
	_cairo_surface_destroy0 (self->priv->contrast_image);
	G_OBJECT_CLASS (bird_font_background_image_parent_class)->finalize (obj);
}

static GType
bird_font_background_image_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontBackgroundImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_background_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontBackgroundImage), 0, (GInstanceInitFunc) bird_font_background_image_instance_init, NULL };
	GType bird_font_background_image_type_id;
	bird_font_background_image_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontBackgroundImage", &g_define_type_info, 0);
	BirdFontBackgroundImage_private_offset = g_type_add_instance_private (bird_font_background_image_type_id, sizeof (BirdFontBackgroundImagePrivate));
	return bird_font_background_image_type_id;
}

GType
bird_font_background_image_get_type (void)
{
	static volatile gsize bird_font_background_image_type_id__once = 0;
	if (g_once_init_enter (&bird_font_background_image_type_id__once)) {
		GType bird_font_background_image_type_id;
		bird_font_background_image_type_id = bird_font_background_image_get_type_once ();
		g_once_init_leave (&bird_font_background_image_type_id__once, bird_font_background_image_type_id);
	}
	return bird_font_background_image_type_id__once;
}

static void
_vala_bird_font_background_image_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	BirdFontBackgroundImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage);
	switch (property_id) {
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_X_PROPERTY:
		g_value_set_double (value, bird_font_background_image_get_img_scale_x (self));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_Y_PROPERTY:
		g_value_set_double (value, bird_font_background_image_get_img_scale_y (self));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_X_PROPERTY:
		g_value_set_double (value, bird_font_background_image_get_img_offset_x (self));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_Y_PROPERTY:
		g_value_set_double (value, bird_font_background_image_get_img_offset_y (self));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_SIZE_MARGIN_PROPERTY:
		g_value_set_int (value, bird_font_background_image_get_size_margin (self));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_MARGIN_LEFT_PROPERTY:
		g_value_set_int (value, bird_font_background_image_get_margin_left (self));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_MARGIN_TOP_PROPERTY:
		g_value_set_int (value, bird_font_background_image_get_margin_top (self));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_X_PROPERTY:
		g_value_set_double (value, bird_font_background_image_get_img_middle_x (self));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_Y_PROPERTY:
		g_value_set_double (value, bird_font_background_image_get_img_middle_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_background_image_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	BirdFontBackgroundImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_BACKGROUND_IMAGE, BirdFontBackgroundImage);
	switch (property_id) {
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_X_PROPERTY:
		bird_font_background_image_set_img_scale_x (self, g_value_get_double (value));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_SCALE_Y_PROPERTY:
		bird_font_background_image_set_img_scale_y (self, g_value_get_double (value));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_X_PROPERTY:
		bird_font_background_image_set_img_offset_x (self, g_value_get_double (value));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_OFFSET_Y_PROPERTY:
		bird_font_background_image_set_img_offset_y (self, g_value_get_double (value));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_X_PROPERTY:
		bird_font_background_image_set_img_middle_x (self, g_value_get_double (value));
		break;
		case BIRD_FONT_BACKGROUND_IMAGE_IMG_MIDDLE_Y_PROPERTY:
		bird_font_background_image_set_img_middle_y (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

