/* AutoTrace.c generated by valac 0.56.16, the Vala compiler
 * generated from AutoTrace.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <birdfont.h>
#include <gio/gio.h>
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BIRD_FONT_TYPE_AUTO_TRACE (bird_font_auto_trace_get_type ())
#define BIRD_FONT_AUTO_TRACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_AUTO_TRACE, BirdFontAutoTrace))
#define BIRD_FONT_AUTO_TRACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_AUTO_TRACE, BirdFontAutoTraceClass))
#define BIRD_FONT_IS_AUTO_TRACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_AUTO_TRACE))
#define BIRD_FONT_IS_AUTO_TRACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_AUTO_TRACE))
#define BIRD_FONT_AUTO_TRACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_AUTO_TRACE, BirdFontAutoTraceClass))

typedef struct _BirdFontAutoTrace BirdFontAutoTrace;
typedef struct _BirdFontAutoTraceClass BirdFontAutoTraceClass;
typedef struct _BirdFontAutoTracePrivate BirdFontAutoTracePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BirdFontParamSpecAutoTrace BirdFontParamSpecAutoTrace;
#define _bird_font_preferences_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_preferences_unref (var), NULL)))
#define _bird_font_auto_trace_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_auto_trace_unref (var), NULL)))

struct _BirdFontAutoTrace {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BirdFontAutoTracePrivate * priv;
};

struct _BirdFontAutoTraceClass {
	GTypeClass parent_class;
	void (*finalize) (BirdFontAutoTrace *self);
};

struct _BirdFontAutoTracePrivate {
	GeeArrayList* files;
	gboolean help;
	gboolean quadratic_control_points;
	gdouble cutoff;
	gdouble details;
	gdouble simplification;
};

struct _BirdFontParamSpecAutoTrace {
	GParamSpec parent_instance;
};

static gint BirdFontAutoTrace_private_offset;
static gpointer bird_font_auto_trace_parent_class = NULL;

VALA_EXTERN gpointer bird_font_auto_trace_ref (gpointer instance);
VALA_EXTERN void bird_font_auto_trace_unref (gpointer instance);
VALA_EXTERN GParamSpec* bird_font_param_spec_auto_trace (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void bird_font_value_set_auto_trace (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void bird_font_value_take_auto_trace (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer bird_font_value_get_auto_trace (const GValue* value);
VALA_EXTERN GType bird_font_auto_trace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BirdFontAutoTrace, bird_font_auto_trace_unref)
VALA_EXTERN BirdFontAutoTrace* bird_font_auto_trace_new (gchar** arg,
                                             gint arg_length1);
VALA_EXTERN BirdFontAutoTrace* bird_font_auto_trace_construct (GType object_type,
                                                   gchar** arg,
                                                   gint arg_length1);
VALA_EXTERN gboolean bird_font_auto_trace_has_help_flag (BirdFontAutoTrace* self);
VALA_EXTERN void bird_font_auto_trace_print_help (gchar** arg,
                                      gint arg_length1);
VALA_EXTERN gint bird_font_auto_trace_trace (BirdFontAutoTrace* self);
static void bird_font_auto_trace_finalize (BirdFontAutoTrace * obj);
static GType bird_font_auto_trace_get_type_once (void);
static gint bird_font_main (gchar** arg,
                     gint arg_length1);

static inline gpointer
bird_font_auto_trace_get_instance_private (BirdFontAutoTrace* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontAutoTrace_private_offset);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

BirdFontAutoTrace*
bird_font_auto_trace_construct (GType object_type,
                                gchar** arg,
                                gint arg_length1)
{
	BirdFontAutoTrace* self = NULL;
	GeeArrayList* _tmp0_;
	self = (BirdFontAutoTrace*) g_type_create_instance (object_type);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->files);
	self->priv->files = _tmp0_;
	self->priv->help = FALSE;
	self->priv->quadratic_control_points = FALSE;
	self->priv->cutoff = (gdouble) 1;
	self->priv->details = (gdouble) 1;
	self->priv->simplification = 0.5;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < arg_length1)) {
					break;
				}
				_tmp4_ = arg[i];
				if (g_strcmp0 (_tmp4_, "-q") == 0) {
					_tmp3_ = TRUE;
				} else {
					const gchar* _tmp5_;
					_tmp5_ = arg[i];
					_tmp3_ = g_strcmp0 (_tmp5_, "--quadratic") == 0;
				}
				if (_tmp3_) {
					self->priv->quadratic_control_points = TRUE;
				} else {
					gboolean _tmp6_ = FALSE;
					const gchar* _tmp7_;
					_tmp7_ = arg[i];
					if (g_strcmp0 (_tmp7_, "-c") == 0) {
						_tmp6_ = TRUE;
					} else {
						gboolean _tmp8_ = FALSE;
						const gchar* _tmp9_;
						_tmp9_ = arg[i];
						if (g_strcmp0 (_tmp9_, "--cutoff") == 0) {
							_tmp8_ = (i + 1) < arg_length1;
						} else {
							_tmp8_ = FALSE;
						}
						_tmp6_ = _tmp8_;
					}
					if (_tmp6_) {
						const gchar* _tmp10_;
						gint _tmp11_;
						_tmp10_ = arg[i + 1];
						self->priv->cutoff = double_parse (_tmp10_);
						_tmp11_ = i;
						i = _tmp11_ + 1;
					} else {
						gboolean _tmp12_ = FALSE;
						const gchar* _tmp13_;
						_tmp13_ = arg[i];
						if (g_strcmp0 (_tmp13_, "-d") == 0) {
							_tmp12_ = TRUE;
						} else {
							gboolean _tmp14_ = FALSE;
							const gchar* _tmp15_;
							_tmp15_ = arg[i];
							if (g_strcmp0 (_tmp15_, "--details") == 0) {
								_tmp14_ = (i + 1) < arg_length1;
							} else {
								_tmp14_ = FALSE;
							}
							_tmp12_ = _tmp14_;
						}
						if (_tmp12_) {
							const gchar* _tmp16_;
							gint _tmp17_;
							_tmp16_ = arg[i + 1];
							self->priv->details = double_parse (_tmp16_);
							_tmp17_ = i;
							i = _tmp17_ + 1;
						} else {
							gboolean _tmp18_ = FALSE;
							const gchar* _tmp19_;
							_tmp19_ = arg[i];
							if (g_strcmp0 (_tmp19_, "-s") == 0) {
								_tmp18_ = TRUE;
							} else {
								gboolean _tmp20_ = FALSE;
								const gchar* _tmp21_;
								_tmp21_ = arg[i];
								if (g_strcmp0 (_tmp21_, "--simplification") == 0) {
									_tmp20_ = (i + 1) < arg_length1;
								} else {
									_tmp20_ = FALSE;
								}
								_tmp18_ = _tmp20_;
							}
							if (_tmp18_) {
								const gchar* _tmp22_;
								gint _tmp23_;
								_tmp22_ = arg[i + 1];
								self->priv->simplification = double_parse (_tmp22_);
								_tmp23_ = i;
								i = _tmp23_ + 1;
							} else {
								gboolean _tmp24_ = FALSE;
								const gchar* _tmp25_;
								_tmp25_ = arg[i];
								if (g_strcmp0 (_tmp25_, "-h") == 0) {
									_tmp24_ = TRUE;
								} else {
									const gchar* _tmp26_;
									_tmp26_ = arg[i];
									_tmp24_ = g_strcmp0 (_tmp26_, "--help") == 0;
								}
								if (_tmp24_) {
									self->priv->help = TRUE;
								} else {
									GeeArrayList* _tmp27_;
									const gchar* _tmp28_;
									_tmp27_ = self->priv->files;
									_tmp28_ = arg[i];
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
								}
							}
						}
					}
				}
			}
		}
	}
	return self;
}

BirdFontAutoTrace*
bird_font_auto_trace_new (gchar** arg,
                          gint arg_length1)
{
	return bird_font_auto_trace_construct (BIRD_FONT_TYPE_AUTO_TRACE, arg, arg_length1);
}

gboolean
bird_font_auto_trace_has_help_flag (BirdFontAutoTrace* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->help;
	return result;
}

void
bird_font_auto_trace_print_help (gchar** arg,
                                 gint arg_length1)
{
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	const gchar* _tmp4_;
	FILE* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	FILE* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	FILE* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	FILE* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	FILE* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	FILE* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	FILE* _tmp55_;
	_tmp0_ = stdout;
	_tmp1_ = bird_font_t_ ("Usage:");
	_tmp2_ = _tmp1_;
	fprintf (_tmp0_, "%s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = stdout;
	_tmp4_ = arg[0];
	fprintf (_tmp3_, "%s", _tmp4_);
	_tmp5_ = stdout;
	_tmp6_ = bird_font_t_ ("OPTION");
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (" [", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, " ...] ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = bird_font_t_ ("FILE");
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, " ...", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, "\n", NULL);
	_tmp19_ = _tmp18_;
	fprintf (_tmp5_, "%s", _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp20_ = stdout;
	_tmp21_ = bird_font_t_ ("brightness cutoff, from 0.001 to 2, the default value is 1");
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat ("-c, --cutoff                    ", _tmp22_, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
	_tmp26_ = _tmp25_;
	fprintf (_tmp20_, "%s", _tmp26_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_tmp27_ = stdout;
	_tmp28_ = bird_font_t_ ("details, from 0.001 to 9.999, the default value is 1");
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat ("-d, --details                   ", _tmp29_, NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
	_tmp33_ = _tmp32_;
	fprintf (_tmp27_, "%s", _tmp33_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_tmp34_ = stdout;
	_tmp35_ = bird_font_t_ ("print this message");
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat ("-h, --help                      ", _tmp36_, NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strconcat (_tmp38_, "\n", NULL);
	_tmp40_ = _tmp39_;
	fprintf (_tmp34_, "%s", _tmp40_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_tmp41_ = stdout;
	_tmp42_ = bird_font_t_ ("use quadratic control points");
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strconcat ("-q, --quadratic                 ", _tmp43_, NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strconcat (_tmp45_, "\n", NULL);
	_tmp47_ = _tmp46_;
	fprintf (_tmp41_, "%s", _tmp47_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp43_);
	_tmp48_ = stdout;
	_tmp49_ = bird_font_t_ ("simplification, from 0.001 to 1, the default value is 0.5");
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strconcat ("-s, --simplification            ", _tmp50_, NULL);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strconcat (_tmp52_, "\n", NULL);
	_tmp54_ = _tmp53_;
	fprintf (_tmp48_, "%s", _tmp54_);
	_g_free0 (_tmp54_);
	_g_free0 (_tmp52_);
	_g_free0 (_tmp50_);
	_tmp55_ = stdout;
	fprintf (_tmp55_, "\n");
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gint
bird_font_auto_trace_trace (BirdFontAutoTrace* self)
{
	BirdFontBackgroundImage* bg = NULL;
	GFile* file = NULL;
	BirdFontPathList* pl = NULL;
	BirdFontGlyph* g = NULL;
	gdouble w = 0.0;
	gdouble h = 0.0;
	BirdFontFont* font = NULL;
	gchar* svg = NULL;
	gchar* file_name = NULL;
	GDataOutputStream* data_stream = NULL;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	{
		GeeArrayList* _f_list = NULL;
		GeeArrayList* _tmp0_;
		gint _f_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _f_index = 0;
		_tmp0_ = self->priv->files;
		_f_list = _tmp0_;
		_tmp1_ = _f_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_f_size = _tmp3_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* f = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			_f_index = _f_index + 1;
			_tmp4_ = _f_index;
			_tmp5_ = _f_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _f_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _f_index);
			f = (gchar*) _tmp7_;
			_tmp8_ = f;
			_tmp9_ = g_file_new_for_path (_tmp8_);
			_g_object_unref0 (file);
			file = _tmp9_;
			_tmp10_ = file;
			if (!g_file_query_exists (_tmp10_, NULL)) {
				FILE* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				FILE* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp11_ = stdout;
				_tmp12_ = f;
				_tmp13_ = string_to_string (_tmp12_);
				_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
				_tmp15_ = _tmp14_;
				fprintf (_tmp11_, "%s", _tmp15_);
				_g_free0 (_tmp15_);
				_tmp16_ = stdout;
				_tmp17_ = bird_font_t_ ("File does not exist.");
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
				_tmp20_ = _tmp19_;
				fprintf (_tmp16_, "%s", _tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				result = 1;
				_g_free0 (f);
				_g_object_unref0 (data_stream);
				_g_free0 (file_name);
				_g_free0 (svg);
				_g_object_unref0 (font);
				_g_object_unref0 (g);
				_g_object_unref0 (pl);
				_g_object_unref0 (file);
				_g_object_unref0 (bg);
				return result;
			}
			_tmp21_ = file;
			_tmp22_ = g_file_get_basename (_tmp21_);
			_tmp23_ = (gchar*) _tmp22_;
			_tmp24_ = string_index_of (_tmp23_, ".", 0) == -1;
			_g_free0 (_tmp23_);
			if (_tmp24_) {
				FILE* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				FILE* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp25_ = stdout;
				_tmp26_ = f;
				_tmp27_ = string_to_string (_tmp26_);
				_tmp28_ = g_strconcat (_tmp27_, "\n", NULL);
				_tmp29_ = _tmp28_;
				fprintf (_tmp25_, "%s", _tmp29_);
				_g_free0 (_tmp29_);
				_tmp30_ = stdout;
				_tmp31_ = bird_font_t_ ("Unknown file format.");
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp32_, "\n", NULL);
				_tmp34_ = _tmp33_;
				fprintf (_tmp30_, "%s", _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp32_);
				result = 2;
				_g_free0 (f);
				_g_object_unref0 (data_stream);
				_g_free0 (file_name);
				_g_free0 (svg);
				_g_object_unref0 (font);
				_g_object_unref0 (g);
				_g_object_unref0 (pl);
				_g_object_unref0 (file);
				_g_object_unref0 (bg);
				return result;
			}
			_g_free0 (f);
		}
	}
	if (self->priv->quadratic_control_points) {
		bird_font_drawing_tools_point_type = BIRD_FONT_POINT_TYPE_QUADRATIC;
	} else {
		bird_font_drawing_tools_point_type = BIRD_FONT_POINT_TYPE_CUBIC;
	}
	{
		GeeArrayList* _f_list = NULL;
		GeeArrayList* _tmp35_;
		gint _f_size = 0;
		GeeArrayList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _f_index = 0;
		_tmp35_ = self->priv->files;
		_f_list = _tmp35_;
		_tmp36_ = _f_list;
		_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_f_size = _tmp38_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			gchar* f = NULL;
			GeeArrayList* _tmp41_;
			gpointer _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			FILE* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			const gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			BirdFontFont* _tmp61_;
			const gchar* _tmp62_;
			BirdFontBackgroundImage* _tmp63_;
			BirdFontSpinButton* _tmp64_;
			BirdFontSpinButton* _tmp65_;
			BirdFontSpinButton* _tmp66_;
			BirdFontBackgroundImage* _tmp67_;
			BirdFontGlyph* _tmp68_;
			BirdFontGlyph* _tmp69_;
			BirdFontFontDisplay* _tmp70_;
			BirdFontGlyphCollection* _tmp71_;
			BirdFontBackgroundImage* _tmp72_;
			cairo_surface_t* _tmp73_;
			cairo_surface_t* _tmp74_;
			BirdFontFont* _tmp75_;
			BirdFontFont* _tmp76_;
			BirdFontFont* _tmp77_;
			BirdFontFont* _tmp78_;
			BirdFontBackgroundImage* _tmp79_;
			cairo_surface_t* _tmp80_;
			cairo_surface_t* _tmp81_;
			BirdFontGlyph* _tmp82_;
			BirdFontGlyph* _tmp83_;
			BirdFontBackgroundImage* _tmp84_;
			BirdFontBackgroundImage* _tmp85_;
			BirdFontPathList* _tmp86_;
			BirdFontGlyph* _tmp98_;
			gchar* _tmp99_;
			const gchar* _tmp100_;
			GFile* _tmp101_;
			_f_index = _f_index + 1;
			_tmp39_ = _f_index;
			_tmp40_ = _f_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _f_list;
			_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, _f_index);
			f = (gchar*) _tmp42_;
			_tmp43_ = f;
			_tmp44_ = g_strdup (_tmp43_);
			_g_free0 (file_name);
			file_name = _tmp44_;
			_tmp45_ = file_name;
			_tmp46_ = file_name;
			_tmp47_ = string_substring (_tmp45_, (glong) 0, (glong) string_last_index_of (_tmp46_, ".", 0));
			_g_free0 (file_name);
			file_name = _tmp47_;
			_tmp48_ = file_name;
			_tmp49_ = string_to_string (_tmp48_);
			_tmp50_ = g_strconcat (_tmp49_, ".svg", NULL);
			_g_free0 (file_name);
			file_name = _tmp50_;
			_tmp51_ = stdout;
			_tmp52_ = bird_font_t_ ("Writing");
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strconcat (_tmp53_, " ", NULL);
			_tmp55_ = _tmp54_;
			_tmp56_ = file_name;
			_tmp57_ = g_strconcat (_tmp55_, _tmp56_, NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat (_tmp58_, "\n", NULL);
			_tmp60_ = _tmp59_;
			fprintf (_tmp51_, "%s", _tmp60_);
			_g_free0 (_tmp60_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp55_);
			_g_free0 (_tmp53_);
			_tmp61_ = bird_font_bird_font_new_font ();
			_g_object_unref0 (font);
			font = _tmp61_;
			_tmp62_ = f;
			_tmp63_ = bird_font_background_image_new (_tmp62_);
			_g_object_unref0 (bg);
			bg = _tmp63_;
			_tmp64_ = bird_font_drawing_tools_auto_trace_resolution;
			bird_font_spin_button_set_value_round (_tmp64_, self->priv->details, TRUE, TRUE);
			_tmp65_ = bird_font_drawing_tools_background_threshold;
			bird_font_spin_button_set_value_round (_tmp65_, self->priv->details, TRUE, TRUE);
			_tmp66_ = bird_font_drawing_tools_auto_trace_simplify;
			bird_font_spin_button_set_value_round (_tmp66_, self->priv->simplification, TRUE, TRUE);
			_tmp67_ = bg;
			bird_font_background_image_set_high_contrast (_tmp67_, TRUE);
			_tmp68_ = bird_font_glyph_new_no_lines ("", (gunichar) 0);
			_g_object_unref0 (g);
			g = _tmp68_;
			_tmp69_ = g;
			_tmp70_ = _g_object_ref0 ((BirdFontFontDisplay*) _tmp69_);
			_g_object_unref0 (bird_font_glyph_canvas_current_display);
			bird_font_glyph_canvas_current_display = _tmp70_;
			_tmp71_ = bird_font_glyph_collection_new_with_glyph ((gunichar) '\0', "");
			_g_object_unref0 (bird_font_bird_font_current_glyph_collection);
			bird_font_bird_font_current_glyph_collection = _tmp71_;
			_tmp72_ = bg;
			_tmp73_ = bird_font_background_image_get_img (_tmp72_);
			_tmp74_ = _tmp73_;
			h = (gdouble) cairo_image_surface_get_height (_tmp74_);
			_cairo_surface_destroy0 (_tmp74_);
			_tmp75_ = font;
			_tmp75_->top_limit = h / 2;
			_tmp76_ = font;
			_tmp76_->bottom_limit = (-h) / 2;
			_tmp77_ = font;
			_tmp77_->top_position = h / 2;
			_tmp78_ = font;
			_tmp78_->bottom_position = (-h) / 2;
			_tmp79_ = bg;
			_tmp80_ = bird_font_background_image_get_img (_tmp79_);
			_tmp81_ = _tmp80_;
			w = (gdouble) cairo_image_surface_get_width (_tmp81_);
			_cairo_surface_destroy0 (_tmp81_);
			_tmp82_ = g;
			bird_font_glyph_set_left_limit (_tmp82_, (-w) / 2.0);
			_tmp83_ = g;
			bird_font_glyph_set_right_limit (_tmp83_, w / 2.0);
			_tmp84_ = bg;
			bird_font_background_image_center_in_glyph (_tmp84_, NULL);
			_tmp85_ = bg;
			_tmp86_ = bird_font_background_image_autotrace (_tmp85_);
			_g_object_unref0 (pl);
			pl = _tmp86_;
			{
				GeeArrayList* _p_list = NULL;
				BirdFontPathList* _tmp87_;
				GeeArrayList* _tmp88_;
				gint _p_size = 0;
				GeeArrayList* _tmp89_;
				gint _tmp90_;
				gint _tmp91_;
				gint _p_index = 0;
				_tmp87_ = pl;
				_tmp88_ = _tmp87_->paths;
				_p_list = _tmp88_;
				_tmp89_ = _p_list;
				_tmp90_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp89_);
				_tmp91_ = _tmp90_;
				_p_size = _tmp91_;
				_p_index = -1;
				while (TRUE) {
					gint _tmp92_;
					gint _tmp93_;
					BirdFontPath* p = NULL;
					GeeArrayList* _tmp94_;
					gpointer _tmp95_;
					BirdFontGlyph* _tmp96_;
					BirdFontPath* _tmp97_;
					_p_index = _p_index + 1;
					_tmp92_ = _p_index;
					_tmp93_ = _p_size;
					if (!(_tmp92_ < _tmp93_)) {
						break;
					}
					_tmp94_ = _p_list;
					_tmp95_ = gee_abstract_list_get ((GeeAbstractList*) _tmp94_, _p_index);
					p = (BirdFontPath*) _tmp95_;
					_tmp96_ = g;
					_tmp97_ = p;
					bird_font_glyph_add_path (_tmp96_, _tmp97_);
					_g_object_unref0 (p);
				}
			}
			_tmp98_ = g;
			_tmp99_ = bird_font_export_tool_export_to_string (_tmp98_, FALSE);
			_g_free0 (svg);
			svg = _tmp99_;
			_tmp100_ = file_name;
			_tmp101_ = g_file_new_for_path (_tmp100_);
			_g_object_unref0 (file);
			file = _tmp101_;
			{
				GFile* _tmp102_;
				GFileOutputStream* _tmp104_ = NULL;
				GFile* _tmp105_;
				GFileOutputStream* _tmp106_;
				GDataOutputStream* _tmp107_;
				GDataOutputStream* _tmp108_;
				const gchar* _tmp109_;
				_tmp102_ = file;
				if (g_file_query_exists (_tmp102_, NULL)) {
					GFile* _tmp103_;
					_tmp103_ = file;
					g_file_delete (_tmp103_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				_tmp105_ = file;
				_tmp106_ = g_file_create (_tmp105_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
				_tmp104_ = _tmp106_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp107_ = g_data_output_stream_new ((GOutputStream*) _tmp104_);
				_g_object_unref0 (data_stream);
				data_stream = _tmp107_;
				_tmp108_ = data_stream;
				_tmp109_ = svg;
				g_data_output_stream_put_string (_tmp108_, _tmp109_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp104_);
					goto __catch0_g_error;
				}
				_g_object_unref0 (_tmp104_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp110_;
				const gchar* _tmp111_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp110_ = e;
				_tmp111_ = _tmp110_->message;
				g_warning ("AutoTrace.vala:160: %s", _tmp111_);
				result = 1;
				_g_error_free0 (e);
				_g_free0 (f);
				_g_object_unref0 (data_stream);
				_g_free0 (file_name);
				_g_free0 (svg);
				_g_object_unref0 (font);
				_g_object_unref0 (g);
				_g_object_unref0 (pl);
				_g_object_unref0 (file);
				_g_object_unref0 (bg);
				return result;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp112_ = -1;
				_g_free0 (f);
				_g_object_unref0 (data_stream);
				_g_free0 (file_name);
				_g_free0 (svg);
				_g_object_unref0 (font);
				_g_object_unref0 (g);
				_g_object_unref0 (pl);
				_g_object_unref0 (file);
				_g_object_unref0 (bg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp112_;
			}
			_g_free0 (f);
		}
	}
	result = 0;
	_g_object_unref0 (data_stream);
	_g_free0 (file_name);
	_g_free0 (svg);
	_g_object_unref0 (font);
	_g_object_unref0 (g);
	_g_object_unref0 (pl);
	_g_object_unref0 (file);
	_g_object_unref0 (bg);
	return result;
}

static void
bird_font_value_auto_trace_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_auto_trace_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_auto_trace_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_auto_trace_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_auto_trace_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_auto_trace_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_auto_trace_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontAutoTrace * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_auto_trace_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_auto_trace_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	BirdFontAutoTrace ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_auto_trace_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_auto_trace (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	BirdFontParamSpecAutoTrace* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_AUTO_TRACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_auto_trace (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_AUTO_TRACE), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_auto_trace (GValue* value,
                                gpointer v_object)
{
	BirdFontAutoTrace * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_AUTO_TRACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_AUTO_TRACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_auto_trace_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_auto_trace_unref (old);
	}
}

void
bird_font_value_take_auto_trace (GValue* value,
                                 gpointer v_object)
{
	BirdFontAutoTrace * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_AUTO_TRACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_AUTO_TRACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_auto_trace_unref (old);
	}
}

static void
bird_font_auto_trace_class_init (BirdFontAutoTraceClass * klass,
                                 gpointer klass_data)
{
	bird_font_auto_trace_parent_class = g_type_class_peek_parent (klass);
	((BirdFontAutoTraceClass *) klass)->finalize = bird_font_auto_trace_finalize;
	g_type_class_adjust_private_offset (klass, &BirdFontAutoTrace_private_offset);
}

static void
bird_font_auto_trace_instance_init (BirdFontAutoTrace * self,
                                    gpointer klass)
{
	self->priv = bird_font_auto_trace_get_instance_private (self);
	self->ref_count = 1;
}

static void
bird_font_auto_trace_finalize (BirdFontAutoTrace * obj)
{
	BirdFontAutoTrace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_AUTO_TRACE, BirdFontAutoTrace);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->files);
}

static GType
bird_font_auto_trace_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_auto_trace_init, bird_font_value_auto_trace_free_value, bird_font_value_auto_trace_copy_value, bird_font_value_auto_trace_peek_pointer, "p", bird_font_value_auto_trace_collect_value, "p", bird_font_value_auto_trace_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontAutoTraceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_auto_trace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontAutoTrace), 0, (GInstanceInitFunc) bird_font_auto_trace_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_auto_trace_type_id;
	bird_font_auto_trace_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontAutoTrace", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BirdFontAutoTrace_private_offset = g_type_add_instance_private (bird_font_auto_trace_type_id, sizeof (BirdFontAutoTracePrivate));
	return bird_font_auto_trace_type_id;
}

GType
bird_font_auto_trace_get_type (void)
{
	static volatile gsize bird_font_auto_trace_type_id__once = 0;
	if (g_once_init_enter (&bird_font_auto_trace_type_id__once)) {
		GType bird_font_auto_trace_type_id;
		bird_font_auto_trace_type_id = bird_font_auto_trace_get_type_once ();
		g_once_init_leave (&bird_font_auto_trace_type_id__once, bird_font_auto_trace_type_id);
	}
	return bird_font_auto_trace_type_id__once;
}

gpointer
bird_font_auto_trace_ref (gpointer instance)
{
	BirdFontAutoTrace * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_auto_trace_unref (gpointer instance)
{
	BirdFontAutoTrace * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_AUTO_TRACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gint
bird_font_main (gchar** arg,
                gint arg_length1)
{
	BirdFontAutoTrace* autotrace = NULL;
	BirdFontPreferences* p = NULL;
	BirdFontFont* _tmp0_;
	BirdFontPreferences* _tmp1_;
	BirdFontSpinButton* _tmp2_;
	BirdFontSpinButton* _tmp3_;
	BirdFontSpinButton* _tmp4_;
	BirdFontSpinButton* _tmp5_;
	BirdFontAutoTrace* _tmp6_;
	gboolean _tmp7_ = FALSE;
	BirdFontAutoTrace* _tmp8_;
	BirdFontAutoTrace* _tmp9_;
	gint result;
	_tmp0_ = bird_font_font_new ();
	_g_object_unref0 (bird_font_bird_font_current_font);
	bird_font_bird_font_current_font = _tmp0_;
	_tmp1_ = bird_font_preferences_new ();
	_bird_font_preferences_unref0 (p);
	p = _tmp1_;
	bird_font_bird_font_init_gettext ();
	bird_font_theme_set_default_colors ();
	_tmp2_ = bird_font_spin_button_new (NULL, "");
	_g_object_unref0 (bird_font_drawing_tools_background_threshold);
	bird_font_drawing_tools_background_threshold = _tmp2_;
	_tmp3_ = bird_font_spin_button_new (NULL, "");
	_g_object_unref0 (bird_font_drawing_tools_background_scale);
	bird_font_drawing_tools_background_scale = _tmp3_;
	_tmp4_ = bird_font_spin_button_new (NULL, "");
	_g_object_unref0 (bird_font_drawing_tools_auto_trace_resolution);
	bird_font_drawing_tools_auto_trace_resolution = _tmp4_;
	_tmp5_ = bird_font_spin_button_new (NULL, "");
	_g_object_unref0 (bird_font_drawing_tools_auto_trace_simplify);
	bird_font_drawing_tools_auto_trace_simplify = _tmp5_;
	_tmp6_ = bird_font_auto_trace_new (arg, arg_length1);
	_bird_font_auto_trace_unref0 (autotrace);
	autotrace = _tmp6_;
	_tmp8_ = autotrace;
	if (bird_font_auto_trace_has_help_flag (_tmp8_)) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = arg_length1 <= 1;
	}
	if (_tmp7_) {
		bird_font_auto_trace_print_help (arg, (gint) arg_length1);
		result = 0;
		_bird_font_preferences_unref0 (p);
		_bird_font_auto_trace_unref0 (autotrace);
		return result;
	}
	_tmp9_ = autotrace;
	result = bird_font_auto_trace_trace (_tmp9_);
	_bird_font_preferences_unref0 (p);
	_bird_font_auto_trace_unref0 (autotrace);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return bird_font_main (argv, argc);
}

