/* This file is is generated by a shell script.  DO NOT EDIT! */

/* 32 bit ELF emulation code for avr2
   Copyright (C) 1991-2024 Free Software Foundation, Inc.
   Written by Steve Chamberlain <sac@cygnus.com>
   ELF support by Ian Lance Taylor <ian@cygnus.com>

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_avr2

#include "sysdep.h"
#include "bfd.h"
#include "libiberty.h"
#include "getopt.h"
#include "bfdlink.h"
#include "ctf-api.h"
#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"
#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"
#include <ldgram.h>
#include "elf-bfd.h"
#include "ldelf.h"
#include "ldelfgen.h"

/* Declare functions used by various EXTRA_EM_FILEs.  */
static void gldavr2_before_parse (void);
static void gldavr2_before_plugin_all_symbols_read
  (void);
static void gldavr2_after_open (void);
static void gldavr2_before_allocation (void);
static void gldavr2_after_allocation (void);


#include "elf32-avr.h"
#include "ldctor.h"
#include "elf/avr.h"

/* The fake file and it's corresponding section meant to hold
   the linker stubs if needed.  */

static lang_input_statement_type *stub_file;
static asection *avr_stub_section;

/* Variables set by the command-line parameters and transferred
   to the bfd without use of global shared variables.  */

static bool avr_no_stubs = false;
static bool avr_debug_relax = false;
static bool avr_debug_stubs = false;
static bool avr_replace_call_ret_sequences = true;
static bfd_vma avr_pc_wrap_around = 0x10000000;

/* Transfers information to the bfd frontend.  */

static void
avr_elf_set_global_bfd_parameters (void)
{
  elf32_avr_setup_params (& link_info,
			  stub_file->the_bfd,
			  avr_stub_section,
			  avr_no_stubs,
			  avr_debug_stubs,
			  avr_debug_relax,
			  avr_pc_wrap_around,
			  avr_replace_call_ret_sequences);
}


/* Makes a conservative estimate of the trampoline section size that could
   be corrected later on.  */

static void
avr_elf_avr2_before_allocation (void)
{
  int ret;

  gldavr2_before_allocation ();

  if (bfd_get_flavour (link_info.output_bfd) != bfd_target_elf_flavour)
    {
      avr_no_stubs = true;
      return;
    }

  /* We only need stubs for avr6, avrxmega6, and avrxmega7.  */
  if (strcmp ("avr2", "avr6") != 0
      && strcmp ("avr2", "avrxmega6") != 0
      && strcmp ("avr2", "avrxmega7") != 0)
    avr_no_stubs = true;

  avr_elf_set_global_bfd_parameters ();

  /* If generating a relocatable output file, then
     we don't  have to generate the trampolines.  */
  if (bfd_link_relocatable (&link_info))
    avr_no_stubs = true;

  if (avr_no_stubs)
    return;

  ret = elf32_avr_setup_section_lists (link_info.output_bfd, &link_info);

  if (ret < 0)
    einfo (_("%X%P: can not setup the input section list: %E\n"));

  if (ret <= 0)
    return;

  /* Call into the BFD backend to do the real "stub"-work.  */
  if (! elf32_avr_size_stubs (link_info.output_bfd, &link_info, true))
    einfo (_("%X%P: can not size stub section: %E\n"));
}

/* This is called before the input files are opened.  We create a new
   fake input file to hold the stub section and generate the section itself.  */

static void
avr_elf_create_output_section_statements (void)
{
  flagword flags;

  if (bfd_get_flavour (link_info.output_bfd) != bfd_target_elf_flavour)
    {
      einfo (_("%F%P: error: cannot change output format "
	       "whilst linking %s binaries\n"), "AVR");
      return;
    }

  stub_file = lang_add_input_file ("linker stubs",
				   lang_input_file_is_fake_enum,
				   NULL);

  stub_file->the_bfd = bfd_create ("linker stubs", link_info.output_bfd);
  if (stub_file->the_bfd == NULL
      || !bfd_set_arch_mach (stub_file->the_bfd,
			     bfd_get_arch (link_info.output_bfd),
			     bfd_get_mach (link_info.output_bfd)))
    {
      einfo (_("%X%P: can not create stub BFD: %E\n"));
      return;
    }
  stub_file->the_bfd->flags |= BFD_LINKER_CREATED;

  /* Now we add the stub section.  */

  flags = (SEC_ALLOC | SEC_LOAD | SEC_READONLY | SEC_CODE
	   | SEC_HAS_CONTENTS | SEC_RELOC | SEC_IN_MEMORY | SEC_KEEP);
  avr_stub_section = bfd_make_section_anyway_with_flags (stub_file->the_bfd,
							 ".trampolines",
							 flags);
  if (avr_stub_section == NULL)
    goto err_ret;

  avr_stub_section->alignment_power = 1;

  ldlang_add_file (stub_file);

  return;

 err_ret:
  einfo (_("%X%P: can not make stub section: %E\n"));
  return;
}

/* Re-calculates the size of the stubs so that we won't waste space.  */

static void
avr_elf_after_allocation (void)
{
  if (!avr_no_stubs && ! RELAXATION_ENABLED)
    {
      /* If relaxing, elf32_avr_size_stubs will be called from
	 elf32_avr_relax_section.  */
      if (!elf32_avr_size_stubs (link_info.output_bfd, &link_info, true))
	einfo (_("%X%P: can not size stub section: %E\n"));
    }

  gldavr2_after_allocation ();

  /* Now build the linker stubs.  */
  if (!avr_no_stubs)
    {
      if (!elf32_avr_build_stubs (&link_info))
	einfo (_("%X%P: can not build stubs: %E\n"));
    }
}

static void
avr_elf_before_parse (void)
{
  /* Don't create a demand-paged executable, since this feature isn't
     meaningful in AVR. */
  config.magic_demand_paged = false;

  gldavr2_before_parse ();
}

static void
avr_finish (void)
{
  bfd *abfd;
  bool avr_link_relax;

  if (bfd_link_relocatable (&link_info))
    {
      avr_link_relax = true;
      for (abfd = link_info.input_bfds; abfd != NULL; abfd = abfd->link.next)
	{
	  /* Don't let the linker stubs prevent the final object being
	     marked as link-relax ready.  */
	  if ((elf_elfheader (abfd)->e_flags
	       & EF_AVR_LINKRELAX_PREPARED) == 0
	      && abfd != stub_file->the_bfd)
	    {
	      avr_link_relax = false;
	      break;
	    }
	}
    }
  else
    {
      avr_link_relax = RELAXATION_ENABLED;
    }

  abfd = link_info.output_bfd;

  if (bfd_get_flavour (link_info.output_bfd) == bfd_target_elf_flavour)
    {
      if (avr_link_relax)
	elf_elfheader (abfd)->e_flags |= EF_AVR_LINKRELAX_PREPARED;
      else
	elf_elfheader (abfd)->e_flags &= ~EF_AVR_LINKRELAX_PREPARED;
    }

  finish_default ();
}

static void
gldavr2_before_parse (void)
{
  ldfile_set_output_arch ("avr:2", bfd_arch_avr);
  input_flags.dynamic = true;
  config.has_shared = false;
  config.separate_code = false;
  link_info.check_relocs_after_open_input = true;
  link_info.separate_code = DEFAULT_LD_Z_SEPARATE_CODE;
  link_info.warn_execstack = DEFAULT_LD_WARN_EXECSTACK;
  link_info.no_warn_rwx_segments = ! DEFAULT_LD_WARN_RWX_SEGMENTS;
  link_info.default_execstack = DEFAULT_LD_EXECSTACK;
  link_info.error_execstack = DEFAULT_LD_ERROR_EXECSTACK;
  link_info.warn_is_error_for_rwx_segments = DEFAULT_LD_ERROR_RWX_SEGMENTS;
}


/* These variables are used to implement target options */

static char *audit; /* colon (typically) separated list of libs */
static char *depaudit; /* colon (typically) separated list of libs */


/* This is called before calling plugin 'all symbols read' hook.  */

static void
gldavr2_before_plugin_all_symbols_read (void)
{
  ldelf_before_plugin_all_symbols_read (false, false,
				        false,
					false,
					32, "/usr");
}

/* This is called after all the input files have been opened.  */

static void
gldavr2_after_open (void)
{
  ldelf_after_open (false, false,
		    false, false, 32, "/usr");
}


/* This is called after the sections have been attached to output
   sections, but before any sizes or addresses have been set.  */

static void
gldavr2_before_allocation (void)
{
  ldelf_before_allocation (audit, depaudit, NULL);
}


static void
gldavr2_after_allocation (void)
{
  int need_layout = bfd_elf_discard_info (link_info.output_bfd, &link_info);

  if (need_layout < 0)
    einfo (_("%X%P: .eh_frame/.stab edit: %E\n"));
  else
    ldelf_map_segments (need_layout);
}

static char *
gldavr2_get_script (int *isfile)
{
  *isfile = 0;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return
"/* Script for -Ur */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf32-avr\",\"elf32-avr\",\"elf32-avr\")\n\
OUTPUT_ARCH(avr:2)\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  .hash        0 : { *(.hash)		}\n\
  .dynsym      0 : { *(.dynsym)		}\n\
  .dynstr      0 : { *(.dynstr)		}\n\
  .gnu.version 0 : { *(.gnu.version)	}\n\
  .gnu.version_d 0 : { *(.gnu.version_d)	}\n\
  .gnu.version_r 0 : { *(.gnu.version_r)	}\n\
  .rel.init    0 : { *(.rel.init)		}\n\
  .rela.init   0 : { *(.rela.init)	}\n\
  .rel.text    0 :\n\
    {\n\
      *(.rel.text)\n\
    }\n\
  .rela.text   0 :\n\
    {\n\
      *(.rela.text)\n"
"    }\n\
  .rel.fini    0 : { *(.rel.fini)		}\n\
  .rela.fini   0 : { *(.rela.fini)	}\n\
  .rel.rodata  0 :\n\
    {\n\
      *(.rel.rodata)\n\
    }\n\
  .rela.rodata 0 :\n\
    {\n\
      *(.rela.rodata)\n\
    }\n\
  .rel.data    0 :\n\
    {\n\
      *(.rel.data)\n\
    }\n\
  .rela.data   0 :\n\
    {\n\
      *(.rela.data)\n\
    }\n\
  .rel.ctors   0 : { *(.rel.ctors)	}\n\
  .rela.ctors  0 : { *(.rela.ctors)	}\n\
  .rel.dtors   0 : { *(.rel.dtors)	}\n\
  .rela.dtors  0 : { *(.rela.dtors)	}\n\
  .rel.got     0 : { *(.rel.got)		}\n\
  .rela.got    0 : { *(.rela.got)		}\n"
"  .rel.bss     0 : { *(.rel.bss)		}\n\
  .rela.bss    0 : { *(.rela.bss)		}\n\
  .rel.plt     0 : { *(.rel.plt)		}\n\
  .rela.plt    0 : { *(.rela.plt)		}\n\
  /* Internal text space or external memory.  */\n\
  .text 0 :\n\
  {\n\
     __ctors_start = . ;\n\
     *(.ctors)\n\
     __ctors_end = . ;\n\
     __dtors_start = . ;\n\
     *(.dtors)\n\
     __dtors_end = . ;\n\
    *(.text)\n\
  }\n\
  .data        0 :\n\
  {\n\
    *(.data)\n\
  }\n\
  .bss  0 :\n\
  {\n\
    *(.bss)\n\
  }\n\
  /* Global data not cleared after reset.  */\n\
  .noinit  0:\n"
"  {\n\
    *(.noinit)\n\
  }\n\
  .eeprom 0:\n\
  {\n\
    /* See .data above...  */\n\
    KEEP(*(.eeprom*))\n\
  }\n\
  .fuse 0:\n\
  {\n\
    KEEP(*(.fuse))\n\
  }\n\
  .lock 0:\n\
  {\n\
    KEEP(*(.lock*))\n\
  }\n\
  .signature 0:\n\
  {\n\
    KEEP(*(.signature*))\n\
  }\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n"
"  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes) }\n\
  .note.gnu.build-id 0 : { *(.note.gnu.build-id) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
}\n\n"
  ; else if (bfd_link_relocatable (&link_info)) return
"/* Script for -r */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf32-avr\",\"elf32-avr\",\"elf32-avr\")\n\
OUTPUT_ARCH(avr:2)\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  .hash        0 : { *(.hash)		}\n\
  .dynsym      0 : { *(.dynsym)		}\n\
  .dynstr      0 : { *(.dynstr)		}\n\
  .gnu.version 0 : { *(.gnu.version)	}\n\
  .gnu.version_d 0 : { *(.gnu.version_d)	}\n\
  .gnu.version_r 0 : { *(.gnu.version_r)	}\n\
  .rel.init    0 : { *(.rel.init)		}\n\
  .rela.init   0 : { *(.rela.init)	}\n\
  .rel.text    0 :\n\
    {\n\
      *(.rel.text)\n\
    }\n\
  .rela.text   0 :\n\
    {\n\
      *(.rela.text)\n"
"    }\n\
  .rel.fini    0 : { *(.rel.fini)		}\n\
  .rela.fini   0 : { *(.rela.fini)	}\n\
  .rel.rodata  0 :\n\
    {\n\
      *(.rel.rodata)\n\
    }\n\
  .rela.rodata 0 :\n\
    {\n\
      *(.rela.rodata)\n\
    }\n\
  .rel.data    0 :\n\
    {\n\
      *(.rel.data)\n\
    }\n\
  .rela.data   0 :\n\
    {\n\
      *(.rela.data)\n\
    }\n\
  .rel.ctors   0 : { *(.rel.ctors)	}\n\
  .rela.ctors  0 : { *(.rela.ctors)	}\n\
  .rel.dtors   0 : { *(.rel.dtors)	}\n\
  .rela.dtors  0 : { *(.rela.dtors)	}\n\
  .rel.got     0 : { *(.rel.got)		}\n\
  .rela.got    0 : { *(.rela.got)		}\n"
"  .rel.bss     0 : { *(.rel.bss)		}\n\
  .rela.bss    0 : { *(.rela.bss)		}\n\
  .rel.plt     0 : { *(.rel.plt)		}\n\
  .rela.plt    0 : { *(.rela.plt)		}\n\
  /* Internal text space or external memory.  */\n\
  .text 0 :\n\
  {\n\
    *(.text)\n\
  }\n\
  .data        0 :\n\
  {\n\
    *(.data)\n\
  }\n\
  .bss  0 :\n\
  {\n\
    *(.bss)\n\
  }\n\
  /* Global data not cleared after reset.  */\n\
  .noinit  0:\n\
  {\n\
    *(.noinit)\n\
  }\n\
  .eeprom 0:\n\
  {\n\
    /* See .data above...  */\n"
"    KEEP(*(.eeprom*))\n\
  }\n\
  .fuse 0:\n\
  {\n\
    KEEP(*(.fuse))\n\
  }\n\
  .lock 0:\n\
  {\n\
    KEEP(*(.lock*))\n\
  }\n\
  .signature 0:\n\
  {\n\
    KEEP(*(.signature*))\n\
  }\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes) }\n\
  .note.gnu.build-id 0 : { *(.note.gnu.build-id) }\n\
  /* DWARF debug sections.\n"
"     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
}\n\n"
  ; else if (!config.text_read_only) return
"/* Script for -N */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf32-avr\",\"elf32-avr\",\"elf32-avr\")\n\
OUTPUT_ARCH(avr:2)\n\
__TEXT_REGION_ORIGIN__ = DEFINED(__TEXT_REGION_ORIGIN__) ? __TEXT_REGION_ORIGIN__ : 0;\n\
__TEXT_REGION_LENGTH__ = DEFINED(__TEXT_REGION_LENGTH__) ? __TEXT_REGION_LENGTH__ : 8K;\n\
__DATA_REGION_ORIGIN__ = DEFINED(__DATA_REGION_ORIGIN__) ? __DATA_REGION_ORIGIN__ : 0x800060;\n\
__DATA_REGION_LENGTH__ = DEFINED(__DATA_REGION_LENGTH__) ? __DATA_REGION_LENGTH__ : 0xffa0;\n\
__EEPROM_REGION_LENGTH__ = DEFINED(__EEPROM_REGION_LENGTH__) ? __EEPROM_REGION_LENGTH__ : 64K;\n\
__FUSE_REGION_LENGTH__ = DEFINED(__FUSE_REGION_LENGTH__) ? __FUSE_REGION_LENGTH__ : 1K;\n\
__LOCK_REGION_LENGTH__ = DEFINED(__LOCK_REGION_LENGTH__) ? __LOCK_REGION_LENGTH__ : 1K;\n\
__SIGNATURE_REGION_LENGTH__ = DEFINED(__SIGNATURE_REGION_LENGTH__) ? __SIGNATURE_REGION_LENGTH__ : 1K;\n\
__USER_SIGNATURE_REGION_LENGTH__ = DEFINED(__USER_SIGNATURE_REGION_LENGTH__) ? __USER_SIGNATURE_REGION_LENGTH__ : 1K;\n\
MEMORY\n\
{\n\
  text   (rx)   : ORIGIN = __TEXT_REGION_ORIGIN__, LENGTH = __TEXT_REGION_LENGTH__\n\
  data   (rw!x) : ORIGIN = __DATA_REGION_ORIGIN__, LENGTH = __DATA_REGION_LENGTH__\n\
  eeprom (rw!x) : ORIGIN = 0x810000, LENGTH = __EEPROM_REGION_LENGTH__\n\
  fuse      (rw!x) : ORIGIN = 0x820000, LENGTH = __FUSE_REGION_LENGTH__\n\
  lock      (rw!x) : ORIGIN = 0x830000, LENGTH = __LOCK_REGION_LENGTH__\n\
  signature (rw!x) : ORIGIN = 0x840000, LENGTH = __SIGNATURE_REGION_LENGTH__\n\
  user_signatures (rw!x) : ORIGIN = 0x850000, LENGTH = __USER_SIGNATURE_REGION_LENGTH__\n"
"}\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  .hash          : { *(.hash)		}\n\
  .dynsym        : { *(.dynsym)		}\n\
  .dynstr        : { *(.dynstr)		}\n\
  .gnu.version   : { *(.gnu.version)	}\n\
  .gnu.version_d   : { *(.gnu.version_d)	}\n\
  .gnu.version_r   : { *(.gnu.version_r)	}\n\
  .rel.init      : { *(.rel.init)		}\n\
  .rela.init     : { *(.rela.init)	}\n\
  .rel.text      :\n\
    {\n\
      *(.rel.text)\n\
      *(.rel.text.*)\n\
      *(.rel.gnu.linkonce.t*)\n\
    }\n\
  .rela.text     :\n\
    {\n\
      *(.rela.text)\n\
      *(.rela.text.*)\n\
      *(.rela.gnu.linkonce.t*)\n\
    }\n\
  .rel.fini      : { *(.rel.fini)		}\n"
"  .rela.fini     : { *(.rela.fini)	}\n\
  .rel.rodata    :\n\
    {\n\
      *(.rel.rodata)\n\
      *(.rel.rodata.*)\n\
      *(.rel.gnu.linkonce.r*)\n\
    }\n\
  .rela.rodata   :\n\
    {\n\
      *(.rela.rodata)\n\
      *(.rela.rodata.*)\n\
      *(.rela.gnu.linkonce.r*)\n\
    }\n\
  .rel.data      :\n\
    {\n\
      *(.rel.data)\n\
      *(.rel.data.*)\n\
      *(.rel.gnu.linkonce.d*)\n\
    }\n\
  .rela.data     :\n\
    {\n\
      *(.rela.data)\n\
      *(.rela.data.*)\n\
      *(.rela.gnu.linkonce.d*)\n\
    }\n"
"  .rel.ctors     : { *(.rel.ctors)	}\n\
  .rela.ctors    : { *(.rela.ctors)	}\n\
  .rel.dtors     : { *(.rel.dtors)	}\n\
  .rela.dtors    : { *(.rela.dtors)	}\n\
  .rel.got       : { *(.rel.got)		}\n\
  .rela.got      : { *(.rela.got)		}\n\
  .rel.bss       : { *(.rel.bss)		}\n\
  .rela.bss      : { *(.rela.bss)		}\n\
  .rel.plt       : { *(.rel.plt)		}\n\
  .rela.plt      : { *(.rela.plt)		}\n\
  /* Internal text space or external memory.  */\n\
  .text   :\n\
  {\n\
    *(.vectors)\n\
    KEEP(*(.vectors))\n\
    /* For data that needs to reside in the lower 64k of progmem.  */\n\
    *(.progmem.gcc*)\n\
    /* PR 13812: Placing the trampolines here gives a better chance\n\
       that they will be in range of the code that uses them.  */\n\
    . = ALIGN(2);\n\
    __trampolines_start = . ;\n\
    /* The jump trampolines for the 16-bit limited relocs will reside here.  */\n\
    *(.trampolines)\n\
    *(.trampolines*)\n\
    __trampolines_end = . ;\n"
"    /* avr-libc expects these data to reside in lower 64K. */\n\
    *libprintf_flt.a:*(.progmem.data)\n\
    *libc.a:*(.progmem.data)\n\
    *(.progmem.*)\n\
    . = ALIGN(2);\n\
    /* For code that needs to reside in the lower 128k progmem.  */\n\
    *(.lowtext)\n\
    *(.lowtext*)\n\
     __ctors_start = . ;\n\
     *(.ctors)\n\
     __ctors_end = . ;\n\
     __dtors_start = . ;\n\
     *(.dtors)\n\
     __dtors_end = . ;\n\
    KEEP(SORT(*)(.ctors))\n\
    KEEP(SORT(*)(.dtors))\n\
    /* From this point on, we do not bother about whether the insns are\n\
       below or above the 16 bits boundary.  */\n\
    *(.init0)  /* Start here after reset.  */\n\
    KEEP (*(.init0))\n\
    *(.init1)\n\
    KEEP (*(.init1))\n\
    *(.init2)  /* Clear __zero_reg__, set up stack pointer.  */\n\
    KEEP (*(.init2))\n\
    *(.init3)\n\
    KEEP (*(.init3))\n\
    *(.init4)  /* Initialize data and BSS.  */\n\
    KEEP (*(.init4))\n\
    *(.init5)\n\
    KEEP (*(.init5))\n\
    *(.init6)  /* C++ constructors.  */\n\
    KEEP (*(.init6))\n\
    *(.init7)\n\
    KEEP (*(.init7))\n\
    *(.init8)\n\
    KEEP (*(.init8))\n\
    *(.init9)  /* Call main().  */\n\
    KEEP (*(.init9))\n\
    *(.text)\n\
    . = ALIGN(2);\n\
    *(.text.*)\n\
    . = ALIGN(2);\n\
    *(.fini9)  /* _exit() starts here.  */\n\
    KEEP (*(.fini9))\n\
    *(.fini8)\n\
    KEEP (*(.fini8))\n\
    *(.fini7)\n\
    KEEP (*(.fini7))\n\
    *(.fini6)  /* C++ destructors.  */\n\
    KEEP (*(.fini6))\n\
    *(.fini5)\n\
    KEEP (*(.fini5))\n\
    *(.fini4)\n\
    KEEP (*(.fini4))\n\
    *(.fini3)\n\
    KEEP (*(.fini3))\n\
    *(.fini2)\n\
    KEEP (*(.fini2))\n\
    *(.fini1)\n\
    KEEP (*(.fini1))\n\
    *(.fini0)  /* Infinite loop after program termination.  */\n\
    KEEP (*(.fini0))\n\
    /* For code that needs not to reside in the lower progmem.  */\n\
    *(.hightext)\n\
    *(.hightext*)\n\
    *(.progmemx.*)\n\
    . = ALIGN(2);\n\
    /* For tablejump instruction arrays.  We do not relax\n\
       JMP / CALL instructions within these sections.  */\n\
    *(.jumptables)\n\
    *(.jumptables*)\n\
    _etext = . ;\n\
  }  > text\n\
  .data          :\n\
  {\n\
     PROVIDE (__data_start = .) ;\n\
    *(.data)\n\
     *(.data*)\n\
    *(.gnu.linkonce.d*)\n\
    *(.rodata)  /* We need to include .rodata here if gcc is used */\n\
    *(.rodata*) /* with -fdata-sections.  */\n\
    *(.gnu.linkonce.r*)\n\
    . = ALIGN(2);\n\
     _edata = . ;\n\
     PROVIDE (__data_end = .) ;\n\
  }  > data AT> text\n\
  .bss  ADDR(.data) + SIZEOF (.data)   : AT (ADDR (.bss))\n\
  {\n\
     PROVIDE (__bss_start = .) ;\n\
    *(.bss)\n\
     *(.bss*)\n\
     *(COMMON)\n\
     PROVIDE (__bss_end = .) ;\n\
  }  > data\n\
   __data_load_start = LOADADDR(.data);\n\
   __data_load_end = __data_load_start + SIZEOF(.data);\n\
  /* Global data not cleared after reset.  */\n\
  .noinit  ADDR(.bss) + SIZEOF (.bss)  :  AT (ADDR (.noinit))\n\
  {\n\
     PROVIDE (__noinit_start = .) ;\n\
    *(.noinit .noinit.* .gnu.linkonce.n.*)\n\
     PROVIDE (__noinit_end = .) ;\n\
     _end = . ;\n\
     PROVIDE (__heap_start = .) ;\n\
  }  > data\n\
PROVIDE (__flmap_init_label = DEFINED(__flmap_noinit_start) ? __flmap_noinit_start : 0) ;\n\
PROVIDE (__flmap = DEFINED(__flmap) ? __flmap : 0) ;\n\
  .eeprom  :\n\
  {\n\
    /* See .data above...  */\n\
    KEEP(*(.eeprom*))\n\
     __eeprom_end = . ;\n\
  }  > eeprom\n\
  .fuse  :\n\
  {\n\
    KEEP(*(.fuse))\n\
    KEEP(*(.lfuse))\n\
    KEEP(*(.hfuse))\n\
    KEEP(*(.efuse))\n\
  }  > fuse\n\
  .lock  :\n\
  {\n\
    KEEP(*(.lock*))\n\
  }  > lock\n\
  .signature  :\n\
  {\n\
    KEEP(*(.signature*))\n\
  }  > signature\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  .note.gnu.build-id   : { *(.note.gnu.build-id) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
}\n\n"
  ; else if (!config.magic_demand_paged) return
"/* Script for -n */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf32-avr\",\"elf32-avr\",\"elf32-avr\")\n\
OUTPUT_ARCH(avr:2)\n\
__TEXT_REGION_ORIGIN__ = DEFINED(__TEXT_REGION_ORIGIN__) ? __TEXT_REGION_ORIGIN__ : 0;\n\
__TEXT_REGION_LENGTH__ = DEFINED(__TEXT_REGION_LENGTH__) ? __TEXT_REGION_LENGTH__ : 8K;\n\
__DATA_REGION_ORIGIN__ = DEFINED(__DATA_REGION_ORIGIN__) ? __DATA_REGION_ORIGIN__ : 0x800060;\n\
__DATA_REGION_LENGTH__ = DEFINED(__DATA_REGION_LENGTH__) ? __DATA_REGION_LENGTH__ : 0xffa0;\n\
__EEPROM_REGION_LENGTH__ = DEFINED(__EEPROM_REGION_LENGTH__) ? __EEPROM_REGION_LENGTH__ : 64K;\n\
__FUSE_REGION_LENGTH__ = DEFINED(__FUSE_REGION_LENGTH__) ? __FUSE_REGION_LENGTH__ : 1K;\n\
__LOCK_REGION_LENGTH__ = DEFINED(__LOCK_REGION_LENGTH__) ? __LOCK_REGION_LENGTH__ : 1K;\n\
__SIGNATURE_REGION_LENGTH__ = DEFINED(__SIGNATURE_REGION_LENGTH__) ? __SIGNATURE_REGION_LENGTH__ : 1K;\n\
__USER_SIGNATURE_REGION_LENGTH__ = DEFINED(__USER_SIGNATURE_REGION_LENGTH__) ? __USER_SIGNATURE_REGION_LENGTH__ : 1K;\n\
MEMORY\n\
{\n\
  text   (rx)   : ORIGIN = __TEXT_REGION_ORIGIN__, LENGTH = __TEXT_REGION_LENGTH__\n\
  data   (rw!x) : ORIGIN = __DATA_REGION_ORIGIN__, LENGTH = __DATA_REGION_LENGTH__\n\
  eeprom (rw!x) : ORIGIN = 0x810000, LENGTH = __EEPROM_REGION_LENGTH__\n\
  fuse      (rw!x) : ORIGIN = 0x820000, LENGTH = __FUSE_REGION_LENGTH__\n\
  lock      (rw!x) : ORIGIN = 0x830000, LENGTH = __LOCK_REGION_LENGTH__\n\
  signature (rw!x) : ORIGIN = 0x840000, LENGTH = __SIGNATURE_REGION_LENGTH__\n\
  user_signatures (rw!x) : ORIGIN = 0x850000, LENGTH = __USER_SIGNATURE_REGION_LENGTH__\n"
"}\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  .hash          : { *(.hash)		}\n\
  .dynsym        : { *(.dynsym)		}\n\
  .dynstr        : { *(.dynstr)		}\n\
  .gnu.version   : { *(.gnu.version)	}\n\
  .gnu.version_d   : { *(.gnu.version_d)	}\n\
  .gnu.version_r   : { *(.gnu.version_r)	}\n\
  .rel.init      : { *(.rel.init)		}\n\
  .rela.init     : { *(.rela.init)	}\n\
  .rel.text      :\n\
    {\n\
      *(.rel.text)\n\
      *(.rel.text.*)\n\
      *(.rel.gnu.linkonce.t*)\n\
    }\n\
  .rela.text     :\n\
    {\n\
      *(.rela.text)\n\
      *(.rela.text.*)\n\
      *(.rela.gnu.linkonce.t*)\n\
    }\n\
  .rel.fini      : { *(.rel.fini)		}\n"
"  .rela.fini     : { *(.rela.fini)	}\n\
  .rel.rodata    :\n\
    {\n\
      *(.rel.rodata)\n\
      *(.rel.rodata.*)\n\
      *(.rel.gnu.linkonce.r*)\n\
    }\n\
  .rela.rodata   :\n\
    {\n\
      *(.rela.rodata)\n\
      *(.rela.rodata.*)\n\
      *(.rela.gnu.linkonce.r*)\n\
    }\n\
  .rel.data      :\n\
    {\n\
      *(.rel.data)\n\
      *(.rel.data.*)\n\
      *(.rel.gnu.linkonce.d*)\n\
    }\n\
  .rela.data     :\n\
    {\n\
      *(.rela.data)\n\
      *(.rela.data.*)\n\
      *(.rela.gnu.linkonce.d*)\n\
    }\n"
"  .rel.ctors     : { *(.rel.ctors)	}\n\
  .rela.ctors    : { *(.rela.ctors)	}\n\
  .rel.dtors     : { *(.rel.dtors)	}\n\
  .rela.dtors    : { *(.rela.dtors)	}\n\
  .rel.got       : { *(.rel.got)		}\n\
  .rela.got      : { *(.rela.got)		}\n\
  .rel.bss       : { *(.rel.bss)		}\n\
  .rela.bss      : { *(.rela.bss)		}\n\
  .rel.plt       : { *(.rel.plt)		}\n\
  .rela.plt      : { *(.rela.plt)		}\n\
  /* Internal text space or external memory.  */\n\
  .text   :\n\
  {\n\
    *(.vectors)\n\
    KEEP(*(.vectors))\n\
    /* For data that needs to reside in the lower 64k of progmem.  */\n\
    *(.progmem.gcc*)\n\
    /* PR 13812: Placing the trampolines here gives a better chance\n\
       that they will be in range of the code that uses them.  */\n\
    . = ALIGN(2);\n\
    __trampolines_start = . ;\n\
    /* The jump trampolines for the 16-bit limited relocs will reside here.  */\n\
    *(.trampolines)\n\
    *(.trampolines*)\n\
    __trampolines_end = . ;\n"
"    /* avr-libc expects these data to reside in lower 64K. */\n\
    *libprintf_flt.a:*(.progmem.data)\n\
    *libc.a:*(.progmem.data)\n\
    *(.progmem.*)\n\
    . = ALIGN(2);\n\
    /* For code that needs to reside in the lower 128k progmem.  */\n\
    *(.lowtext)\n\
    *(.lowtext*)\n\
     __ctors_start = . ;\n\
     *(.ctors)\n\
     __ctors_end = . ;\n\
     __dtors_start = . ;\n\
     *(.dtors)\n\
     __dtors_end = . ;\n\
    KEEP(SORT(*)(.ctors))\n\
    KEEP(SORT(*)(.dtors))\n\
    /* From this point on, we do not bother about whether the insns are\n\
       below or above the 16 bits boundary.  */\n\
    *(.init0)  /* Start here after reset.  */\n\
    KEEP (*(.init0))\n\
    *(.init1)\n\
    KEEP (*(.init1))\n\
    *(.init2)  /* Clear __zero_reg__, set up stack pointer.  */\n\
    KEEP (*(.init2))\n\
    *(.init3)\n\
    KEEP (*(.init3))\n\
    *(.init4)  /* Initialize data and BSS.  */\n\
    KEEP (*(.init4))\n\
    *(.init5)\n\
    KEEP (*(.init5))\n\
    *(.init6)  /* C++ constructors.  */\n\
    KEEP (*(.init6))\n\
    *(.init7)\n\
    KEEP (*(.init7))\n\
    *(.init8)\n\
    KEEP (*(.init8))\n\
    *(.init9)  /* Call main().  */\n\
    KEEP (*(.init9))\n\
    *(.text)\n\
    . = ALIGN(2);\n\
    *(.text.*)\n\
    . = ALIGN(2);\n\
    *(.fini9)  /* _exit() starts here.  */\n\
    KEEP (*(.fini9))\n\
    *(.fini8)\n\
    KEEP (*(.fini8))\n\
    *(.fini7)\n\
    KEEP (*(.fini7))\n\
    *(.fini6)  /* C++ destructors.  */\n\
    KEEP (*(.fini6))\n\
    *(.fini5)\n\
    KEEP (*(.fini5))\n\
    *(.fini4)\n\
    KEEP (*(.fini4))\n\
    *(.fini3)\n\
    KEEP (*(.fini3))\n\
    *(.fini2)\n\
    KEEP (*(.fini2))\n\
    *(.fini1)\n\
    KEEP (*(.fini1))\n\
    *(.fini0)  /* Infinite loop after program termination.  */\n\
    KEEP (*(.fini0))\n\
    /* For code that needs not to reside in the lower progmem.  */\n\
    *(.hightext)\n\
    *(.hightext*)\n\
    *(.progmemx.*)\n\
    . = ALIGN(2);\n\
    /* For tablejump instruction arrays.  We do not relax\n\
       JMP / CALL instructions within these sections.  */\n\
    *(.jumptables)\n\
    *(.jumptables*)\n\
    _etext = . ;\n\
  }  > text\n\
  .data          :\n\
  {\n\
     PROVIDE (__data_start = .) ;\n\
    *(.data)\n\
     *(.data*)\n\
    *(.gnu.linkonce.d*)\n\
    *(.rodata)  /* We need to include .rodata here if gcc is used */\n\
    *(.rodata*) /* with -fdata-sections.  */\n\
    *(.gnu.linkonce.r*)\n\
    . = ALIGN(2);\n\
     _edata = . ;\n\
     PROVIDE (__data_end = .) ;\n\
  }  > data AT> text\n\
  .bss  ADDR(.data) + SIZEOF (.data)   : AT (ADDR (.bss))\n\
  {\n\
     PROVIDE (__bss_start = .) ;\n\
    *(.bss)\n\
     *(.bss*)\n\
     *(COMMON)\n\
     PROVIDE (__bss_end = .) ;\n\
  }  > data\n\
   __data_load_start = LOADADDR(.data);\n\
   __data_load_end = __data_load_start + SIZEOF(.data);\n\
  /* Global data not cleared after reset.  */\n\
  .noinit  ADDR(.bss) + SIZEOF (.bss)  :  AT (ADDR (.noinit))\n\
  {\n\
     PROVIDE (__noinit_start = .) ;\n\
    *(.noinit .noinit.* .gnu.linkonce.n.*)\n\
     PROVIDE (__noinit_end = .) ;\n\
     _end = . ;\n\
     PROVIDE (__heap_start = .) ;\n\
  }  > data\n\
PROVIDE (__flmap_init_label = DEFINED(__flmap_noinit_start) ? __flmap_noinit_start : 0) ;\n\
PROVIDE (__flmap = DEFINED(__flmap) ? __flmap : 0) ;\n\
  .eeprom  :\n\
  {\n\
    /* See .data above...  */\n\
    KEEP(*(.eeprom*))\n\
     __eeprom_end = . ;\n\
  }  > eeprom\n\
  .fuse  :\n\
  {\n\
    KEEP(*(.fuse))\n\
    KEEP(*(.lfuse))\n\
    KEEP(*(.hfuse))\n\
    KEEP(*(.efuse))\n\
  }  > fuse\n\
  .lock  :\n\
  {\n\
    KEEP(*(.lock*))\n\
  }  > lock\n\
  .signature  :\n\
  {\n\
    KEEP(*(.signature*))\n\
  }  > signature\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  .note.gnu.build-id   : { *(.note.gnu.build-id) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
}\n\n"
  ; else if (link_info.separate_code) return
"/* Script for -z separate-code */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf32-avr\",\"elf32-avr\",\"elf32-avr\")\n\
OUTPUT_ARCH(avr:2)\n\
__TEXT_REGION_ORIGIN__ = DEFINED(__TEXT_REGION_ORIGIN__) ? __TEXT_REGION_ORIGIN__ : 0;\n\
__TEXT_REGION_LENGTH__ = DEFINED(__TEXT_REGION_LENGTH__) ? __TEXT_REGION_LENGTH__ : 8K;\n\
__DATA_REGION_ORIGIN__ = DEFINED(__DATA_REGION_ORIGIN__) ? __DATA_REGION_ORIGIN__ : 0x800060;\n\
__DATA_REGION_LENGTH__ = DEFINED(__DATA_REGION_LENGTH__) ? __DATA_REGION_LENGTH__ : 0xffa0;\n\
__EEPROM_REGION_LENGTH__ = DEFINED(__EEPROM_REGION_LENGTH__) ? __EEPROM_REGION_LENGTH__ : 64K;\n\
__FUSE_REGION_LENGTH__ = DEFINED(__FUSE_REGION_LENGTH__) ? __FUSE_REGION_LENGTH__ : 1K;\n\
__LOCK_REGION_LENGTH__ = DEFINED(__LOCK_REGION_LENGTH__) ? __LOCK_REGION_LENGTH__ : 1K;\n\
__SIGNATURE_REGION_LENGTH__ = DEFINED(__SIGNATURE_REGION_LENGTH__) ? __SIGNATURE_REGION_LENGTH__ : 1K;\n\
__USER_SIGNATURE_REGION_LENGTH__ = DEFINED(__USER_SIGNATURE_REGION_LENGTH__) ? __USER_SIGNATURE_REGION_LENGTH__ : 1K;\n\
MEMORY\n\
{\n\
  text   (rx)   : ORIGIN = __TEXT_REGION_ORIGIN__, LENGTH = __TEXT_REGION_LENGTH__\n\
  data   (rw!x) : ORIGIN = __DATA_REGION_ORIGIN__, LENGTH = __DATA_REGION_LENGTH__\n\
  eeprom (rw!x) : ORIGIN = 0x810000, LENGTH = __EEPROM_REGION_LENGTH__\n\
  fuse      (rw!x) : ORIGIN = 0x820000, LENGTH = __FUSE_REGION_LENGTH__\n\
  lock      (rw!x) : ORIGIN = 0x830000, LENGTH = __LOCK_REGION_LENGTH__\n\
  signature (rw!x) : ORIGIN = 0x840000, LENGTH = __SIGNATURE_REGION_LENGTH__\n\
  user_signatures (rw!x) : ORIGIN = 0x850000, LENGTH = __USER_SIGNATURE_REGION_LENGTH__\n"
"}\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  .hash          : { *(.hash)		}\n\
  .dynsym        : { *(.dynsym)		}\n\
  .dynstr        : { *(.dynstr)		}\n\
  .gnu.version   : { *(.gnu.version)	}\n\
  .gnu.version_d   : { *(.gnu.version_d)	}\n\
  .gnu.version_r   : { *(.gnu.version_r)	}\n\
  .rel.init      : { *(.rel.init)		}\n\
  .rela.init     : { *(.rela.init)	}\n\
  .rel.text      :\n\
    {\n\
      *(.rel.text)\n\
      *(.rel.text.*)\n\
      *(.rel.gnu.linkonce.t*)\n\
    }\n\
  .rela.text     :\n\
    {\n\
      *(.rela.text)\n\
      *(.rela.text.*)\n\
      *(.rela.gnu.linkonce.t*)\n\
    }\n\
  .rel.fini      : { *(.rel.fini)		}\n"
"  .rela.fini     : { *(.rela.fini)	}\n\
  .rel.rodata    :\n\
    {\n\
      *(.rel.rodata)\n\
      *(.rel.rodata.*)\n\
      *(.rel.gnu.linkonce.r*)\n\
    }\n\
  .rela.rodata   :\n\
    {\n\
      *(.rela.rodata)\n\
      *(.rela.rodata.*)\n\
      *(.rela.gnu.linkonce.r*)\n\
    }\n\
  .rel.data      :\n\
    {\n\
      *(.rel.data)\n\
      *(.rel.data.*)\n\
      *(.rel.gnu.linkonce.d*)\n\
    }\n\
  .rela.data     :\n\
    {\n\
      *(.rela.data)\n\
      *(.rela.data.*)\n\
      *(.rela.gnu.linkonce.d*)\n\
    }\n"
"  .rel.ctors     : { *(.rel.ctors)	}\n\
  .rela.ctors    : { *(.rela.ctors)	}\n\
  .rel.dtors     : { *(.rel.dtors)	}\n\
  .rela.dtors    : { *(.rela.dtors)	}\n\
  .rel.got       : { *(.rel.got)		}\n\
  .rela.got      : { *(.rela.got)		}\n\
  .rel.bss       : { *(.rel.bss)		}\n\
  .rela.bss      : { *(.rela.bss)		}\n\
  .rel.plt       : { *(.rel.plt)		}\n\
  .rela.plt      : { *(.rela.plt)		}\n\
  /* Internal text space or external memory.  */\n\
  .text   :\n\
  {\n\
    *(.vectors)\n\
    KEEP(*(.vectors))\n\
    /* For data that needs to reside in the lower 64k of progmem.  */\n\
    *(.progmem.gcc*)\n\
    /* PR 13812: Placing the trampolines here gives a better chance\n\
       that they will be in range of the code that uses them.  */\n\
    . = ALIGN(2);\n\
    __trampolines_start = . ;\n\
    /* The jump trampolines for the 16-bit limited relocs will reside here.  */\n\
    *(.trampolines)\n\
    *(.trampolines*)\n\
    __trampolines_end = . ;\n"
"    /* avr-libc expects these data to reside in lower 64K. */\n\
    *libprintf_flt.a:*(.progmem.data)\n\
    *libc.a:*(.progmem.data)\n\
    *(.progmem.*)\n\
    . = ALIGN(2);\n\
    /* For code that needs to reside in the lower 128k progmem.  */\n\
    *(.lowtext)\n\
    *(.lowtext*)\n\
     __ctors_start = . ;\n\
     *(.ctors)\n\
     __ctors_end = . ;\n\
     __dtors_start = . ;\n\
     *(.dtors)\n\
     __dtors_end = . ;\n\
    KEEP(SORT(*)(.ctors))\n\
    KEEP(SORT(*)(.dtors))\n\
    /* From this point on, we do not bother about whether the insns are\n\
       below or above the 16 bits boundary.  */\n\
    *(.init0)  /* Start here after reset.  */\n\
    KEEP (*(.init0))\n\
    *(.init1)\n\
    KEEP (*(.init1))\n\
    *(.init2)  /* Clear __zero_reg__, set up stack pointer.  */\n\
    KEEP (*(.init2))\n\
    *(.init3)\n\
    KEEP (*(.init3))\n\
    *(.init4)  /* Initialize data and BSS.  */\n\
    KEEP (*(.init4))\n\
    *(.init5)\n\
    KEEP (*(.init5))\n\
    *(.init6)  /* C++ constructors.  */\n\
    KEEP (*(.init6))\n\
    *(.init7)\n\
    KEEP (*(.init7))\n\
    *(.init8)\n\
    KEEP (*(.init8))\n\
    *(.init9)  /* Call main().  */\n\
    KEEP (*(.init9))\n\
    *(.text)\n\
    . = ALIGN(2);\n\
    *(.text.*)\n\
    . = ALIGN(2);\n\
    *(.fini9)  /* _exit() starts here.  */\n\
    KEEP (*(.fini9))\n\
    *(.fini8)\n\
    KEEP (*(.fini8))\n\
    *(.fini7)\n\
    KEEP (*(.fini7))\n\
    *(.fini6)  /* C++ destructors.  */\n\
    KEEP (*(.fini6))\n\
    *(.fini5)\n\
    KEEP (*(.fini5))\n\
    *(.fini4)\n\
    KEEP (*(.fini4))\n\
    *(.fini3)\n\
    KEEP (*(.fini3))\n\
    *(.fini2)\n\
    KEEP (*(.fini2))\n\
    *(.fini1)\n\
    KEEP (*(.fini1))\n\
    *(.fini0)  /* Infinite loop after program termination.  */\n\
    KEEP (*(.fini0))\n\
    /* For code that needs not to reside in the lower progmem.  */\n\
    *(.hightext)\n\
    *(.hightext*)\n\
    *(.progmemx.*)\n\
    . = ALIGN(2);\n\
    /* For tablejump instruction arrays.  We do not relax\n\
       JMP / CALL instructions within these sections.  */\n\
    *(.jumptables)\n\
    *(.jumptables*)\n\
    _etext = . ;\n\
  }  > text\n\
  .data          :\n\
  {\n\
     PROVIDE (__data_start = .) ;\n\
    *(.data)\n\
     *(.data*)\n\
    *(.gnu.linkonce.d*)\n\
    *(.rodata)  /* We need to include .rodata here if gcc is used */\n\
    *(.rodata*) /* with -fdata-sections.  */\n\
    *(.gnu.linkonce.r*)\n\
    . = ALIGN(2);\n\
     _edata = . ;\n\
     PROVIDE (__data_end = .) ;\n\
  }  > data AT> text\n\
  .bss  ADDR(.data) + SIZEOF (.data)   : AT (ADDR (.bss))\n\
  {\n\
     PROVIDE (__bss_start = .) ;\n\
    *(.bss)\n\
     *(.bss*)\n\
     *(COMMON)\n\
     PROVIDE (__bss_end = .) ;\n\
  }  > data\n\
   __data_load_start = LOADADDR(.data);\n\
   __data_load_end = __data_load_start + SIZEOF(.data);\n\
  /* Global data not cleared after reset.  */\n\
  .noinit  ADDR(.bss) + SIZEOF (.bss)  :  AT (ADDR (.noinit))\n\
  {\n\
     PROVIDE (__noinit_start = .) ;\n\
    *(.noinit .noinit.* .gnu.linkonce.n.*)\n\
     PROVIDE (__noinit_end = .) ;\n\
     _end = . ;\n\
     PROVIDE (__heap_start = .) ;\n\
  }  > data\n\
PROVIDE (__flmap_init_label = DEFINED(__flmap_noinit_start) ? __flmap_noinit_start : 0) ;\n\
PROVIDE (__flmap = DEFINED(__flmap) ? __flmap : 0) ;\n\
  .eeprom  :\n\
  {\n\
    /* See .data above...  */\n\
    KEEP(*(.eeprom*))\n\
     __eeprom_end = . ;\n\
  }  > eeprom\n\
  .fuse  :\n\
  {\n\
    KEEP(*(.fuse))\n\
    KEEP(*(.lfuse))\n\
    KEEP(*(.hfuse))\n\
    KEEP(*(.efuse))\n\
  }  > fuse\n\
  .lock  :\n\
  {\n\
    KEEP(*(.lock*))\n\
  }  > lock\n\
  .signature  :\n\
  {\n\
    KEEP(*(.signature*))\n\
  }  > signature\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  .note.gnu.build-id   : { *(.note.gnu.build-id) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
}\n\n"
  ; else return
"/* Default linker script, for normal executables */\n\
/* Copyright (C) 2014-2024 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf32-avr\",\"elf32-avr\",\"elf32-avr\")\n\
OUTPUT_ARCH(avr:2)\n\
__TEXT_REGION_ORIGIN__ = DEFINED(__TEXT_REGION_ORIGIN__) ? __TEXT_REGION_ORIGIN__ : 0;\n\
__TEXT_REGION_LENGTH__ = DEFINED(__TEXT_REGION_LENGTH__) ? __TEXT_REGION_LENGTH__ : 8K;\n\
__DATA_REGION_ORIGIN__ = DEFINED(__DATA_REGION_ORIGIN__) ? __DATA_REGION_ORIGIN__ : 0x800060;\n\
__DATA_REGION_LENGTH__ = DEFINED(__DATA_REGION_LENGTH__) ? __DATA_REGION_LENGTH__ : 0xffa0;\n\
__EEPROM_REGION_LENGTH__ = DEFINED(__EEPROM_REGION_LENGTH__) ? __EEPROM_REGION_LENGTH__ : 64K;\n\
__FUSE_REGION_LENGTH__ = DEFINED(__FUSE_REGION_LENGTH__) ? __FUSE_REGION_LENGTH__ : 1K;\n\
__LOCK_REGION_LENGTH__ = DEFINED(__LOCK_REGION_LENGTH__) ? __LOCK_REGION_LENGTH__ : 1K;\n\
__SIGNATURE_REGION_LENGTH__ = DEFINED(__SIGNATURE_REGION_LENGTH__) ? __SIGNATURE_REGION_LENGTH__ : 1K;\n\
__USER_SIGNATURE_REGION_LENGTH__ = DEFINED(__USER_SIGNATURE_REGION_LENGTH__) ? __USER_SIGNATURE_REGION_LENGTH__ : 1K;\n\
MEMORY\n\
{\n\
  text   (rx)   : ORIGIN = __TEXT_REGION_ORIGIN__, LENGTH = __TEXT_REGION_LENGTH__\n\
  data   (rw!x) : ORIGIN = __DATA_REGION_ORIGIN__, LENGTH = __DATA_REGION_LENGTH__\n\
  eeprom (rw!x) : ORIGIN = 0x810000, LENGTH = __EEPROM_REGION_LENGTH__\n\
  fuse      (rw!x) : ORIGIN = 0x820000, LENGTH = __FUSE_REGION_LENGTH__\n\
  lock      (rw!x) : ORIGIN = 0x830000, LENGTH = __LOCK_REGION_LENGTH__\n\
  signature (rw!x) : ORIGIN = 0x840000, LENGTH = __SIGNATURE_REGION_LENGTH__\n\
  user_signatures (rw!x) : ORIGIN = 0x850000, LENGTH = __USER_SIGNATURE_REGION_LENGTH__\n"
"}\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  .hash          : { *(.hash)		}\n\
  .dynsym        : { *(.dynsym)		}\n\
  .dynstr        : { *(.dynstr)		}\n\
  .gnu.version   : { *(.gnu.version)	}\n\
  .gnu.version_d   : { *(.gnu.version_d)	}\n\
  .gnu.version_r   : { *(.gnu.version_r)	}\n\
  .rel.init      : { *(.rel.init)		}\n\
  .rela.init     : { *(.rela.init)	}\n\
  .rel.text      :\n\
    {\n\
      *(.rel.text)\n\
      *(.rel.text.*)\n\
      *(.rel.gnu.linkonce.t*)\n\
    }\n\
  .rela.text     :\n\
    {\n\
      *(.rela.text)\n\
      *(.rela.text.*)\n\
      *(.rela.gnu.linkonce.t*)\n\
    }\n\
  .rel.fini      : { *(.rel.fini)		}\n"
"  .rela.fini     : { *(.rela.fini)	}\n\
  .rel.rodata    :\n\
    {\n\
      *(.rel.rodata)\n\
      *(.rel.rodata.*)\n\
      *(.rel.gnu.linkonce.r*)\n\
    }\n\
  .rela.rodata   :\n\
    {\n\
      *(.rela.rodata)\n\
      *(.rela.rodata.*)\n\
      *(.rela.gnu.linkonce.r*)\n\
    }\n\
  .rel.data      :\n\
    {\n\
      *(.rel.data)\n\
      *(.rel.data.*)\n\
      *(.rel.gnu.linkonce.d*)\n\
    }\n\
  .rela.data     :\n\
    {\n\
      *(.rela.data)\n\
      *(.rela.data.*)\n\
      *(.rela.gnu.linkonce.d*)\n\
    }\n"
"  .rel.ctors     : { *(.rel.ctors)	}\n\
  .rela.ctors    : { *(.rela.ctors)	}\n\
  .rel.dtors     : { *(.rel.dtors)	}\n\
  .rela.dtors    : { *(.rela.dtors)	}\n\
  .rel.got       : { *(.rel.got)		}\n\
  .rela.got      : { *(.rela.got)		}\n\
  .rel.bss       : { *(.rel.bss)		}\n\
  .rela.bss      : { *(.rela.bss)		}\n\
  .rel.plt       : { *(.rel.plt)		}\n\
  .rela.plt      : { *(.rela.plt)		}\n\
  /* Internal text space or external memory.  */\n\
  .text   :\n\
  {\n\
    *(.vectors)\n\
    KEEP(*(.vectors))\n\
    /* For data that needs to reside in the lower 64k of progmem.  */\n\
    *(.progmem.gcc*)\n\
    /* PR 13812: Placing the trampolines here gives a better chance\n\
       that they will be in range of the code that uses them.  */\n\
    . = ALIGN(2);\n\
    __trampolines_start = . ;\n\
    /* The jump trampolines for the 16-bit limited relocs will reside here.  */\n\
    *(.trampolines)\n\
    *(.trampolines*)\n\
    __trampolines_end = . ;\n"
"    /* avr-libc expects these data to reside in lower 64K. */\n\
    *libprintf_flt.a:*(.progmem.data)\n\
    *libc.a:*(.progmem.data)\n\
    *(.progmem.*)\n\
    . = ALIGN(2);\n\
    /* For code that needs to reside in the lower 128k progmem.  */\n\
    *(.lowtext)\n\
    *(.lowtext*)\n\
     __ctors_start = . ;\n\
     *(.ctors)\n\
     __ctors_end = . ;\n\
     __dtors_start = . ;\n\
     *(.dtors)\n\
     __dtors_end = . ;\n\
    KEEP(SORT(*)(.ctors))\n\
    KEEP(SORT(*)(.dtors))\n\
    /* From this point on, we do not bother about whether the insns are\n\
       below or above the 16 bits boundary.  */\n\
    *(.init0)  /* Start here after reset.  */\n\
    KEEP (*(.init0))\n\
    *(.init1)\n\
    KEEP (*(.init1))\n\
    *(.init2)  /* Clear __zero_reg__, set up stack pointer.  */\n\
    KEEP (*(.init2))\n\
    *(.init3)\n\
    KEEP (*(.init3))\n\
    *(.init4)  /* Initialize data and BSS.  */\n\
    KEEP (*(.init4))\n\
    *(.init5)\n\
    KEEP (*(.init5))\n\
    *(.init6)  /* C++ constructors.  */\n\
    KEEP (*(.init6))\n\
    *(.init7)\n\
    KEEP (*(.init7))\n\
    *(.init8)\n\
    KEEP (*(.init8))\n\
    *(.init9)  /* Call main().  */\n\
    KEEP (*(.init9))\n\
    *(.text)\n\
    . = ALIGN(2);\n\
    *(.text.*)\n\
    . = ALIGN(2);\n\
    *(.fini9)  /* _exit() starts here.  */\n\
    KEEP (*(.fini9))\n\
    *(.fini8)\n\
    KEEP (*(.fini8))\n\
    *(.fini7)\n\
    KEEP (*(.fini7))\n\
    *(.fini6)  /* C++ destructors.  */\n\
    KEEP (*(.fini6))\n\
    *(.fini5)\n\
    KEEP (*(.fini5))\n\
    *(.fini4)\n\
    KEEP (*(.fini4))\n\
    *(.fini3)\n\
    KEEP (*(.fini3))\n\
    *(.fini2)\n\
    KEEP (*(.fini2))\n\
    *(.fini1)\n\
    KEEP (*(.fini1))\n\
    *(.fini0)  /* Infinite loop after program termination.  */\n\
    KEEP (*(.fini0))\n\
    /* For code that needs not to reside in the lower progmem.  */\n\
    *(.hightext)\n\
    *(.hightext*)\n\
    *(.progmemx.*)\n\
    . = ALIGN(2);\n\
    /* For tablejump instruction arrays.  We do not relax\n\
       JMP / CALL instructions within these sections.  */\n\
    *(.jumptables)\n\
    *(.jumptables*)\n\
    _etext = . ;\n\
  }  > text\n\
  .data          :\n\
  {\n\
     PROVIDE (__data_start = .) ;\n\
    *(.data)\n\
     *(.data*)\n\
    *(.gnu.linkonce.d*)\n\
    *(.rodata)  /* We need to include .rodata here if gcc is used */\n\
    *(.rodata*) /* with -fdata-sections.  */\n\
    *(.gnu.linkonce.r*)\n\
    . = ALIGN(2);\n\
     _edata = . ;\n\
     PROVIDE (__data_end = .) ;\n\
  }  > data AT> text\n\
  .bss  ADDR(.data) + SIZEOF (.data)   : AT (ADDR (.bss))\n\
  {\n\
     PROVIDE (__bss_start = .) ;\n\
    *(.bss)\n\
     *(.bss*)\n\
     *(COMMON)\n\
     PROVIDE (__bss_end = .) ;\n\
  }  > data\n\
   __data_load_start = LOADADDR(.data);\n\
   __data_load_end = __data_load_start + SIZEOF(.data);\n\
  /* Global data not cleared after reset.  */\n\
  .noinit  ADDR(.bss) + SIZEOF (.bss)  :  AT (ADDR (.noinit))\n\
  {\n\
     PROVIDE (__noinit_start = .) ;\n\
    *(.noinit .noinit.* .gnu.linkonce.n.*)\n\
     PROVIDE (__noinit_end = .) ;\n\
     _end = . ;\n\
     PROVIDE (__heap_start = .) ;\n\
  }  > data\n\
PROVIDE (__flmap_init_label = DEFINED(__flmap_noinit_start) ? __flmap_noinit_start : 0) ;\n\
PROVIDE (__flmap = DEFINED(__flmap) ? __flmap : 0) ;\n\
  .eeprom  :\n\
  {\n\
    /* See .data above...  */\n\
    KEEP(*(.eeprom*))\n\
     __eeprom_end = . ;\n\
  }  > eeprom\n\
  .fuse  :\n\
  {\n\
    KEEP(*(.fuse))\n\
    KEEP(*(.lfuse))\n\
    KEEP(*(.hfuse))\n\
    KEEP(*(.efuse))\n\
  }  > fuse\n\
  .lock  :\n\
  {\n\
    KEEP(*(.lock*))\n\
  }  > lock\n\
  .signature  :\n\
  {\n\
    KEEP(*(.signature*))\n\
  }  > signature\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment 0 (INFO) : { *(.comment); LINKER_VERSION; }\n\
  .gnu.build.attributes : { *(.gnu.build.attributes .gnu.build.attributes.*) }\n\
  .note.gnu.build-id   : { *(.note.gnu.build-id) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1.  */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions.  */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2.  */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2.  */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions.  */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3.  */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF 5.  */\n\
  .debug_addr     0 : { *(.debug_addr) }\n\
  .debug_line_str 0 : { *(.debug_line_str) }\n\
  .debug_loclists 0 : { *(.debug_loclists) }\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .debug_names    0 : { *(.debug_names) }\n\
  .debug_rnglists 0 : { *(.debug_rnglists) }\n\
  .debug_str_offsets 0 : { *(.debug_str_offsets) }\n\
  .debug_sup      0 : { *(.debug_sup) }\n\
}\n\n"
; }
 

#define OPTION_NO_CALL_RET_REPLACEMENT 301
#define OPTION_PMEM_WRAP_AROUND	       302
#define OPTION_NO_STUBS		       303
#define OPTION_DEBUG_STUBS	       304
#define OPTION_DEBUG_RELAX	       305


enum elf_options
{
  OPTION_DISABLE_NEW_DTAGS = 400,
  OPTION_ENABLE_NEW_DTAGS,
  OPTION_GROUP,
  OPTION_EH_FRAME_HDR,
  OPTION_NO_EH_FRAME_HDR,
  OPTION_EXCLUDE_LIBS,
  OPTION_HASH_STYLE,
  OPTION_BUILD_ID,
  OPTION_PACKAGE_METADATA,
  OPTION_AUDIT,
  OPTION_COMPRESS_DEBUG
};

static void
gldavr2_add_options
  (int ns, char **shortopts, int nl, struct option **longopts,
   int nrl ATTRIBUTE_UNUSED, struct option **really_longopts ATTRIBUTE_UNUSED)
{
  static const char xtra_short[] = "z:";
  static const struct option xtra_long[] = {
    {"build-id", optional_argument, NULL, OPTION_BUILD_ID},
    {"package-metadata", optional_argument, NULL, OPTION_PACKAGE_METADATA},
    {"compress-debug-sections", required_argument, NULL, OPTION_COMPRESS_DEBUG},
    
  { "no-call-ret-replacement", no_argument,
    NULL, OPTION_NO_CALL_RET_REPLACEMENT},
  { "pmem-wrap-around", required_argument,
    NULL, OPTION_PMEM_WRAP_AROUND},
  { "no-stubs", no_argument,
    NULL, OPTION_NO_STUBS},
  { "debug-stubs", no_argument,
    NULL, OPTION_DEBUG_STUBS},
  { "debug-relax", no_argument,
    NULL, OPTION_DEBUG_RELAX},

    {NULL, no_argument, NULL, 0}
  };

  *shortopts = (char *) xrealloc (*shortopts, ns + sizeof (xtra_short));
  memcpy (*shortopts + ns, &xtra_short, sizeof (xtra_short));
  *longopts = (struct option *)
    xrealloc (*longopts, nl * sizeof (struct option) + sizeof (xtra_long));
  memcpy (*longopts + nl, &xtra_long, sizeof (xtra_long));
}

#define DEFAULT_BUILD_ID_STYLE	"sha1"

static bool
gldavr2_handle_option (int optc)
{
  switch (optc)
    {
    default:
      return false;

    case OPTION_BUILD_ID:
      free ((char *) ldelf_emit_note_gnu_build_id);
      ldelf_emit_note_gnu_build_id = NULL;
      if (optarg == NULL)
	optarg = DEFAULT_BUILD_ID_STYLE;
      if (strcmp (optarg, "none"))
	ldelf_emit_note_gnu_build_id = xstrdup (optarg);
      break;

    case OPTION_PACKAGE_METADATA:
      free ((char *) ldelf_emit_note_fdo_package_metadata);
      ldelf_emit_note_fdo_package_metadata = NULL;
      if (optarg != NULL && strlen(optarg) > 0)
	ldelf_emit_note_fdo_package_metadata = xstrdup (optarg);
      break;

    case OPTION_COMPRESS_DEBUG:
      config.compress_debug = bfd_get_compression_algorithm (optarg);
      if (strcasecmp (optarg, "zstd") == 0)
	{
#ifndef HAVE_ZSTD
	  if (config.compress_debug == COMPRESS_DEBUG_ZSTD)
	    einfo (_ ("%F%P: --compress-debug-sections=zstd: ld is not built "
		  "with zstd support\n"));
#endif
	}
      if (config.compress_debug == COMPRESS_UNKNOWN)
	einfo (_("%F%P: invalid --compress-debug-sections option: `%s'\n"),
	       optarg);
      break;
    case 'z':
      if (strcmp (optarg, "defs") == 0)
	link_info.unresolved_syms_in_objects = RM_DIAGNOSE;
      else if (strcmp (optarg, "undefs") == 0)
	link_info.unresolved_syms_in_objects = RM_IGNORE;
      else if (strcmp (optarg, "muldefs") == 0)
	link_info.allow_multiple_definition = true;
      else if (startswith (optarg, "max-page-size="))
	{
	  char *end;

	  link_info.maxpagesize = strtoul (optarg + 14, &end, 0);
	  if (*end
	      || (link_info.maxpagesize & (link_info.maxpagesize - 1)) != 0)
	    einfo (_("%F%P: invalid maximum page size `%s'\n"),
		   optarg + 14);
	  link_info.maxpagesize_is_set = true;
	}
      else if (startswith (optarg, "common-page-size="))
	{
	  char *end;
	  link_info.commonpagesize = strtoul (optarg + 17, &end, 0);
	  if (*end
	      || (link_info.commonpagesize & (link_info.commonpagesize - 1)) != 0)
	    einfo (_("%F%P: invalid common page size `%s'\n"),
		   optarg + 17);
	  link_info.commonpagesize_is_set = true;
	}
      else if (startswith (optarg, "stack-size="))
	{
	  char *end;
	  link_info.stacksize = strtoul (optarg + 11, &end, 0);
	  if (*end || link_info.stacksize < 0)
	    einfo (_("%F%P: invalid stack size `%s'\n"), optarg + 11);
	  if (!link_info.stacksize)
	    /* Use -1 for explicit no-stack, because zero means
	       'default'.   */
	    link_info.stacksize = -1;
	}
      else if (strcmp (optarg, "execstack") == 0)
	{
	  link_info.execstack = true;
	  link_info.noexecstack = false;
	}
      else if (strcmp (optarg, "noexecstack") == 0)
	{
	  link_info.noexecstack = true;
	  link_info.execstack = false;
	}
      else if (strcmp (optarg, "unique-symbol") == 0)
	link_info.unique_symbol = true;
      else if (strcmp (optarg, "nounique-symbol") == 0)
	link_info.unique_symbol = false;
      else if (strcmp (optarg, "globalaudit") == 0)
	{
	  link_info.flags_1 |= DF_1_GLOBAUDIT;
	}
      else if (startswith (optarg, "start-stop-gc"))
	link_info.start_stop_gc = true;
      else if (startswith (optarg, "nostart-stop-gc"))
	link_info.start_stop_gc = false;
      else if (startswith (optarg, "start-stop-visibility="))
	{
	  if (strcmp (optarg, "start-stop-visibility=default") == 0)
	    link_info.start_stop_visibility = STV_DEFAULT;
	  else if (strcmp (optarg, "start-stop-visibility=internal") == 0)
	    link_info.start_stop_visibility = STV_INTERNAL;
	  else if (strcmp (optarg, "start-stop-visibility=hidden") == 0)
	    link_info.start_stop_visibility = STV_HIDDEN;
	  else if (strcmp (optarg, "start-stop-visibility=protected") == 0)
	    link_info.start_stop_visibility = STV_PROTECTED;
	  else
	    einfo (_("%F%P: invalid visibility in `-z %s'; "
		     "must be default, internal, hidden, or protected"),
		   optarg);
	}
      else if (strcmp (optarg, "sectionheader") == 0)
	config.no_section_header = false;
      else if (strcmp (optarg, "nosectionheader") == 0)
	config.no_section_header = true;
      else
	einfo (_("%P: warning: -z %s ignored\n"), optarg);
      break;
 

    case OPTION_PMEM_WRAP_AROUND:
      {
	/* This variable is defined in the bfd library.  */
	if ((!strcmp (optarg,"32k"))      || (!strcmp (optarg,"32K")))
	  avr_pc_wrap_around = 32768;
	else if ((!strcmp (optarg,"8k"))  || (!strcmp (optarg,"8K")))
	  avr_pc_wrap_around = 8192;
	else if ((!strcmp (optarg,"16k")) || (!strcmp (optarg,"16K")))
	  avr_pc_wrap_around = 16384;
	else if ((!strcmp (optarg,"64k")) || (!strcmp (optarg,"64K")))
	  avr_pc_wrap_around = 0x10000;
	else
	  return false;
      }
      break;

    case OPTION_DEBUG_STUBS:
      avr_debug_stubs = true;
      break;

    case OPTION_DEBUG_RELAX:
      avr_debug_relax = true;
      break;

    case OPTION_NO_STUBS:
      avr_no_stubs = true;
      break;

    case OPTION_NO_CALL_RET_REPLACEMENT:
      {
	/* This variable is defined in the bfd library.  */
	avr_replace_call_ret_sequences = false;
      }
      break;

    }

  return true;
}


static void
gldavr2_list_options (FILE * file)
{
 
  fprintf (file, _("  --pmem-wrap-around=<val>    "
		   "Make the linker relaxation machine assume that a\n"
		   "                              "
		   "  program counter wrap-around occurs at address\n"
		   "                              "
		   "  <val>.  Supported values: 8k, 16k, 32k and 64k.\n"));
  fprintf (file, _("  --no-call-ret-replacement   "
		   "The relaxation machine normally will\n"
		   "                              "
		   "  substitute two immediately following call/ret\n"
		   "                              "
		   "  instructions by a single jump instruction.\n"
		   "                              "
		   "  This option disables this optimization.\n"));
  fprintf (file, _("  --no-stubs                  "
		   "If the linker detects to attempt to access\n"
		   "                              "
		   "  an instruction beyond 128k by a reloc that\n"
		   "                              "
		   "  is limited to 128k max, it inserts a jump\n"
		   "                              "
		   "  stub. You can de-active this with this switch.\n"));
  fprintf (file, _("  --debug-stubs               "
		   "Used for debugging avr-ld.\n"));
  fprintf (file, _("  --debug-relax               "
		   "Used for debugging avr-ld.\n"));

}

struct ld_emulation_xfer_struct ld_avr2_emulation =
{
  avr_elf_before_parse,
  syslib_default,
  hll_default,
  ldelf_after_parse,
  gldavr2_before_plugin_all_symbols_read,
  gldavr2_after_open,
  after_check_relocs_default,
  ldelf_before_place_orphans,
  avr_elf_after_allocation,
  ldelf_set_output_arch,
  ldemul_default_target,
  avr_elf_avr2_before_allocation,
  gldavr2_get_script,
  "avr2",
  "elf32-avr",
  avr_finish,
  avr_elf_create_output_section_statements,
  ldelf_open_dynamic_archive,
  ldelf_place_orphan,
  NULL,
  NULL,
  gldavr2_add_options,
  gldavr2_handle_option,
  NULL,
  gldavr2_list_options,
  ldelf_load_symbols,
  NULL,
  NULL,
  NULL,
  ldelf_emit_ctf_early,
  ldelf_acquire_strings_for_ctf,
  ldelf_new_dynsym_for_ctf,
  NULL
};
