/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "ev-gdbus-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_args,
        guint arg_timestamp,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_VARIANT_UINT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringVariantUintFunc)
       (void *data1,
        const gchar *arg_source_file,
        GVariant *arg_source_point,
        guint arg_timestamp,
        void *data2);
  _GDbusCodegenMarshalVoid_StringVariantUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringVariantUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_variant (param_values + 2),
            g_marshal_value_peek_uint (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringVariantUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_source_file,
        GVariant *arg_source_point,
        guint arg_timestamp,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringVariantUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringVariantUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.mate.atril.Application
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:EvAtrilApplication
 * @title: EvAtrilApplication
 * @short_description: Generated C code for the org.mate.atril.Application D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.mate.atril.Application ---- */

static const _ExtendedGDBusArgInfo _ev_atril_application_method_info_reload_IN_ARG_args =
{
  {
    -1,
    (gchar *) "args",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ev_atril_application_method_info_reload_IN_ARG_timestamp =
{
  {
    -1,
    (gchar *) "timestamp",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ev_atril_application_method_info_reload_IN_ARG_pointers[] =
{
  &_ev_atril_application_method_info_reload_IN_ARG_args.parent_struct,
  &_ev_atril_application_method_info_reload_IN_ARG_timestamp.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ev_atril_application_method_info_reload =
{
  {
    -1,
    (gchar *) "Reload",
    (GDBusArgInfo **) &_ev_atril_application_method_info_reload_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reload",
  FALSE
};

static const _ExtendedGDBusArgInfo _ev_atril_application_method_info_get_window_list_OUT_ARG_window_list =
{
  {
    -1,
    (gchar *) "window_list",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ev_atril_application_method_info_get_window_list_OUT_ARG_pointers[] =
{
  &_ev_atril_application_method_info_get_window_list_OUT_ARG_window_list.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ev_atril_application_method_info_get_window_list =
{
  {
    -1,
    (gchar *) "GetWindowList",
    NULL,
    (GDBusArgInfo **) &_ev_atril_application_method_info_get_window_list_OUT_ARG_pointers,
    NULL
  },
  "handle-get-window-list",
  FALSE
};

static const GDBusMethodInfo * const _ev_atril_application_method_info_pointers[] =
{
  &_ev_atril_application_method_info_reload.parent_struct,
  &_ev_atril_application_method_info_get_window_list.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ev_atril_application_interface_info =
{
  {
    -1,
    (gchar *) "org.mate.atril.Application",
    (GDBusMethodInfo **) &_ev_atril_application_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "atril-application",
};


/**
 * ev_atril_application_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ev_atril_application_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ev_atril_application_interface_info.parent_struct;
}

/**
 * ev_atril_application_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #EvAtrilApplication interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ev_atril_application_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
ev_atril_application_method_marshal_reload (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ev_atril_application_method_marshal_get_window_list (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * EvAtrilApplication:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link>.
 */

/**
 * EvAtrilApplicationIface:
 * @parent_iface: The parent interface.
 * @handle_get_window_list: Handler for the #EvAtrilApplication::handle-get-window-list signal.
 * @handle_reload: Handler for the #EvAtrilApplication::handle-reload signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link>.
 */

typedef EvAtrilApplicationIface EvAtrilApplicationInterface;
G_DEFINE_INTERFACE (EvAtrilApplication, ev_atril_application, G_TYPE_OBJECT)

static void
ev_atril_application_default_init (EvAtrilApplicationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * EvAtrilApplication::handle-reload:
   * @object: A #EvAtrilApplication.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_args: Argument passed by remote caller.
   * @arg_timestamp: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mate-atril-Application.Reload">Reload()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ev_atril_application_complete_reload() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EvAtrilApplicationIface, handle_reload),
    g_signal_accumulator_true_handled,
    NULL,
      ev_atril_application_method_marshal_reload,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_UINT);

  /**
   * EvAtrilApplication::handle-get-window-list:
   * @object: A #EvAtrilApplication.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mate-atril-Application.GetWindowList">GetWindowList()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ev_atril_application_complete_get_window_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-window-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EvAtrilApplicationIface, handle_get_window_list),
    g_signal_accumulator_true_handled,
    NULL,
      ev_atril_application_method_marshal_get_window_list,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * ev_atril_application_call_reload:
 * @proxy: A #EvAtrilApplicationProxy.
 * @arg_args: Argument to pass with the method invocation.
 * @arg_timestamp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mate-atril-Application.Reload">Reload()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ev_atril_application_call_reload_finish() to get the result of the operation.
 *
 * See ev_atril_application_call_reload_sync() for the synchronous, blocking version of this method.
 */
void
ev_atril_application_call_reload (
    EvAtrilApplication *proxy,
    GVariant *arg_args,
    guint arg_timestamp,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reload",
    g_variant_new ("(@a{sv}u)",
                   arg_args,
                   arg_timestamp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ev_atril_application_call_reload_finish:
 * @proxy: A #EvAtrilApplicationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ev_atril_application_call_reload().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ev_atril_application_call_reload().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ev_atril_application_call_reload_finish (
    EvAtrilApplication *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ev_atril_application_call_reload_sync:
 * @proxy: A #EvAtrilApplicationProxy.
 * @arg_args: Argument to pass with the method invocation.
 * @arg_timestamp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mate-atril-Application.Reload">Reload()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ev_atril_application_call_reload() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ev_atril_application_call_reload_sync (
    EvAtrilApplication *proxy,
    GVariant *arg_args,
    guint arg_timestamp,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reload",
    g_variant_new ("(@a{sv}u)",
                   arg_args,
                   arg_timestamp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ev_atril_application_call_get_window_list:
 * @proxy: A #EvAtrilApplicationProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mate-atril-Application.GetWindowList">GetWindowList()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ev_atril_application_call_get_window_list_finish() to get the result of the operation.
 *
 * See ev_atril_application_call_get_window_list_sync() for the synchronous, blocking version of this method.
 */
void
ev_atril_application_call_get_window_list (
    EvAtrilApplication *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetWindowList",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ev_atril_application_call_get_window_list_finish:
 * @proxy: A #EvAtrilApplicationProxy.
 * @out_window_list: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ev_atril_application_call_get_window_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ev_atril_application_call_get_window_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ev_atril_application_call_get_window_list_finish (
    EvAtrilApplication *proxy,
    gchar ***out_window_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_window_list);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ev_atril_application_call_get_window_list_sync:
 * @proxy: A #EvAtrilApplicationProxy.
 * @out_window_list: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mate-atril-Application.GetWindowList">GetWindowList()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ev_atril_application_call_get_window_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ev_atril_application_call_get_window_list_sync (
    EvAtrilApplication *proxy,
    gchar ***out_window_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetWindowList",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_window_list);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ev_atril_application_complete_reload:
 * @object: A #EvAtrilApplication.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mate-atril-Application.Reload">Reload()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ev_atril_application_complete_reload (
    EvAtrilApplication *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ev_atril_application_complete_get_window_list:
 * @object: A #EvAtrilApplication.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @window_list: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mate-atril-Application.GetWindowList">GetWindowList()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ev_atril_application_complete_get_window_list (
    EvAtrilApplication *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *window_list)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   window_list));
}

/* ------------------------------------------------------------------------ */

/**
 * EvAtrilApplicationProxy:
 *
 * The #EvAtrilApplicationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * EvAtrilApplicationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EvAtrilApplicationProxy.
 */

struct _EvAtrilApplicationProxyPrivate
{
  GData *qdata;
};

static void ev_atril_application_proxy_iface_init (EvAtrilApplicationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (EvAtrilApplicationProxy, ev_atril_application_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (EvAtrilApplicationProxy)
                         G_IMPLEMENT_INTERFACE (EV_TYPE_ATRIL_APPLICATION, ev_atril_application_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (EvAtrilApplicationProxy, ev_atril_application_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (EV_TYPE_ATRIL_APPLICATION, ev_atril_application_proxy_iface_init))

#endif
static void
ev_atril_application_proxy_finalize (GObject *object)
{
  EvAtrilApplicationProxy *proxy = EV_ATRIL_APPLICATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ev_atril_application_proxy_parent_class)->finalize (object);
}

static void
ev_atril_application_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ev_atril_application_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ev_atril_application_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ev_atril_application_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], EV_TYPE_ATRIL_APPLICATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, EV_TYPE_ATRIL_APPLICATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ev_atril_application_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  EvAtrilApplicationProxy *proxy = EV_ATRIL_APPLICATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ev_atril_application_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ev_atril_application_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
ev_atril_application_proxy_init (EvAtrilApplicationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ev_atril_application_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, EV_TYPE_ATRIL_APPLICATION_PROXY, EvAtrilApplicationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ev_atril_application_interface_info ());
}

static void
ev_atril_application_proxy_class_init (EvAtrilApplicationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ev_atril_application_proxy_finalize;
  gobject_class->get_property = ev_atril_application_proxy_get_property;
  gobject_class->set_property = ev_atril_application_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ev_atril_application_proxy_g_signal;
  proxy_class->g_properties_changed = ev_atril_application_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (EvAtrilApplicationProxyPrivate));
#endif
}

static void
ev_atril_application_proxy_iface_init (EvAtrilApplicationIface *iface G_GNUC_UNUSED)
{
}

/**
 * ev_atril_application_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ev_atril_application_proxy_new_finish() to get the result of the operation.
 *
 * See ev_atril_application_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ev_atril_application_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (EV_TYPE_ATRIL_APPLICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mate.atril.Application", NULL);
}

/**
 * ev_atril_application_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ev_atril_application_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ev_atril_application_proxy_new().
 *
 * Returns: (transfer full) (type EvAtrilApplicationProxy): The constructed proxy object or %NULL if @error is set.
 */
EvAtrilApplication *
ev_atril_application_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return EV_ATRIL_APPLICATION (ret);
  else
    return NULL;
}

/**
 * ev_atril_application_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ev_atril_application_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EvAtrilApplicationProxy): The constructed proxy object or %NULL if @error is set.
 */
EvAtrilApplication *
ev_atril_application_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (EV_TYPE_ATRIL_APPLICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mate.atril.Application", NULL);
  if (ret != NULL)
    return EV_ATRIL_APPLICATION (ret);
  else
    return NULL;
}


/**
 * ev_atril_application_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ev_atril_application_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ev_atril_application_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ev_atril_application_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ev_atril_application_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (EV_TYPE_ATRIL_APPLICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mate.atril.Application", NULL);
}

/**
 * ev_atril_application_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ev_atril_application_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ev_atril_application_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type EvAtrilApplicationProxy): The constructed proxy object or %NULL if @error is set.
 */
EvAtrilApplication *
ev_atril_application_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return EV_ATRIL_APPLICATION (ret);
  else
    return NULL;
}

/**
 * ev_atril_application_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ev_atril_application_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ev_atril_application_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EvAtrilApplicationProxy): The constructed proxy object or %NULL if @error is set.
 */
EvAtrilApplication *
ev_atril_application_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (EV_TYPE_ATRIL_APPLICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mate.atril.Application", NULL);
  if (ret != NULL)
    return EV_ATRIL_APPLICATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * EvAtrilApplicationSkeleton:
 *
 * The #EvAtrilApplicationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * EvAtrilApplicationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EvAtrilApplicationSkeleton.
 */

struct _EvAtrilApplicationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ev_atril_application_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  EvAtrilApplicationSkeleton *skeleton = EV_ATRIL_APPLICATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], EV_TYPE_ATRIL_APPLICATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, EV_TYPE_ATRIL_APPLICATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ev_atril_application_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  EvAtrilApplicationSkeleton *skeleton = EV_ATRIL_APPLICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ev_atril_application_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ev_atril_application_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  EvAtrilApplicationSkeleton *skeleton = EV_ATRIL_APPLICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ev_atril_application_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ev_atril_application_skeleton_vtable =
{
  _ev_atril_application_skeleton_handle_method_call,
  _ev_atril_application_skeleton_handle_get_property,
  _ev_atril_application_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ev_atril_application_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ev_atril_application_interface_info ();
}

static GDBusInterfaceVTable *
ev_atril_application_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ev_atril_application_skeleton_vtable;
}

static GVariant *
ev_atril_application_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  EvAtrilApplicationSkeleton *skeleton = EV_ATRIL_APPLICATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ev_atril_application_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ev_atril_application_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ev_atril_application_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ev_atril_application_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mate.atril.Application", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
ev_atril_application_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void ev_atril_application_skeleton_iface_init (EvAtrilApplicationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (EvAtrilApplicationSkeleton, ev_atril_application_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (EvAtrilApplicationSkeleton)
                         G_IMPLEMENT_INTERFACE (EV_TYPE_ATRIL_APPLICATION, ev_atril_application_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (EvAtrilApplicationSkeleton, ev_atril_application_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (EV_TYPE_ATRIL_APPLICATION, ev_atril_application_skeleton_iface_init))

#endif
static void
ev_atril_application_skeleton_finalize (GObject *object)
{
  EvAtrilApplicationSkeleton *skeleton = EV_ATRIL_APPLICATION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ev_atril_application_skeleton_parent_class)->finalize (object);
}

static void
ev_atril_application_skeleton_init (EvAtrilApplicationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ev_atril_application_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, EV_TYPE_ATRIL_APPLICATION_SKELETON, EvAtrilApplicationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
ev_atril_application_skeleton_class_init (EvAtrilApplicationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ev_atril_application_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ev_atril_application_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ev_atril_application_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ev_atril_application_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ev_atril_application_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (EvAtrilApplicationSkeletonPrivate));
#endif
}

static void
ev_atril_application_skeleton_iface_init (EvAtrilApplicationIface *iface G_GNUC_UNUSED)
{
}

/**
 * ev_atril_application_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link>.
 *
 * Returns: (transfer full) (type EvAtrilApplicationSkeleton): The skeleton object.
 */
EvAtrilApplication *
ev_atril_application_skeleton_new (void)
{
  return EV_ATRIL_APPLICATION (g_object_new (EV_TYPE_ATRIL_APPLICATION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.mate.atril.Window
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:EvAtrilWindow
 * @title: EvAtrilWindow
 * @short_description: Generated C code for the org.mate.atril.Window D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link> D-Bus interface in C.
 */

enum
{
  EV__ATRIL_WINDOW_SYNC_SOURCE,
  EV__ATRIL_WINDOW_CLOSED,
  EV__ATRIL_WINDOW_DOCUMENT_LOADED,
};

static unsigned EV__ATRIL_WINDOW_SIGNALS[3] = { 0 };

/* ---- Introspection data for org.mate.atril.Window ---- */

static const _ExtendedGDBusArgInfo _ev_atril_window_method_info_sync_view_IN_ARG_source_file =
{
  {
    -1,
    (gchar *) "source_file",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ev_atril_window_method_info_sync_view_IN_ARG_source_point =
{
  {
    -1,
    (gchar *) "source_point",
    (gchar *) "(ii)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ev_atril_window_method_info_sync_view_IN_ARG_timestamp =
{
  {
    -1,
    (gchar *) "timestamp",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ev_atril_window_method_info_sync_view_IN_ARG_pointers[] =
{
  &_ev_atril_window_method_info_sync_view_IN_ARG_source_file.parent_struct,
  &_ev_atril_window_method_info_sync_view_IN_ARG_source_point.parent_struct,
  &_ev_atril_window_method_info_sync_view_IN_ARG_timestamp.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ev_atril_window_method_info_sync_view =
{
  {
    -1,
    (gchar *) "SyncView",
    (GDBusArgInfo **) &_ev_atril_window_method_info_sync_view_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-sync-view",
  FALSE
};

static const GDBusMethodInfo * const _ev_atril_window_method_info_pointers[] =
{
  &_ev_atril_window_method_info_sync_view.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ev_atril_window_signal_info_sync_source_ARG_source_file =
{
  {
    -1,
    (gchar *) "source_file",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ev_atril_window_signal_info_sync_source_ARG_source_point =
{
  {
    -1,
    (gchar *) "source_point",
    (gchar *) "(ii)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ev_atril_window_signal_info_sync_source_ARG_timestamp =
{
  {
    -1,
    (gchar *) "timestamp",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ev_atril_window_signal_info_sync_source_ARG_pointers[] =
{
  &_ev_atril_window_signal_info_sync_source_ARG_source_file.parent_struct,
  &_ev_atril_window_signal_info_sync_source_ARG_source_point.parent_struct,
  &_ev_atril_window_signal_info_sync_source_ARG_timestamp.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ev_atril_window_signal_info_sync_source =
{
  {
    -1,
    (gchar *) "SyncSource",
    (GDBusArgInfo **) &_ev_atril_window_signal_info_sync_source_ARG_pointers,
    NULL
  },
  "sync-source"
};

static const _ExtendedGDBusSignalInfo _ev_atril_window_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const _ExtendedGDBusArgInfo _ev_atril_window_signal_info_document_loaded_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ev_atril_window_signal_info_document_loaded_ARG_pointers[] =
{
  &_ev_atril_window_signal_info_document_loaded_ARG_uri.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ev_atril_window_signal_info_document_loaded =
{
  {
    -1,
    (gchar *) "DocumentLoaded",
    (GDBusArgInfo **) &_ev_atril_window_signal_info_document_loaded_ARG_pointers,
    NULL
  },
  "document-loaded"
};

static const GDBusSignalInfo * const _ev_atril_window_signal_info_pointers[] =
{
  &_ev_atril_window_signal_info_sync_source.parent_struct,
  &_ev_atril_window_signal_info_closed.parent_struct,
  &_ev_atril_window_signal_info_document_loaded.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ev_atril_window_interface_info =
{
  {
    -1,
    (gchar *) "org.mate.atril.Window",
    (GDBusMethodInfo **) &_ev_atril_window_method_info_pointers,
    (GDBusSignalInfo **) &_ev_atril_window_signal_info_pointers,
    NULL,
    NULL
  },
  "atril-window",
};


/**
 * ev_atril_window_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ev_atril_window_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ev_atril_window_interface_info.parent_struct;
}

/**
 * ev_atril_window_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #EvAtrilWindow interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ev_atril_window_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
ev_atril_window_signal_marshal_sync_source (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ev_atril_window_signal_marshal_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ev_atril_window_signal_marshal_document_loaded (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ev_atril_window_method_marshal_sync_view (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * EvAtrilWindow:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link>.
 */

/**
 * EvAtrilWindowIface:
 * @parent_iface: The parent interface.
 * @handle_sync_view: Handler for the #EvAtrilWindow::handle-sync-view signal.
 * @closed: Handler for the #EvAtrilWindow::closed signal.
 * @document_loaded: Handler for the #EvAtrilWindow::document-loaded signal.
 * @sync_source: Handler for the #EvAtrilWindow::sync-source signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link>.
 */

typedef EvAtrilWindowIface EvAtrilWindowInterface;
G_DEFINE_INTERFACE (EvAtrilWindow, ev_atril_window, G_TYPE_OBJECT)

static void
ev_atril_window_default_init (EvAtrilWindowIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * EvAtrilWindow::handle-sync-view:
   * @object: A #EvAtrilWindow.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_source_file: Argument passed by remote caller.
   * @arg_source_point: Argument passed by remote caller.
   * @arg_timestamp: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mate-atril-Window.SyncView">SyncView()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ev_atril_window_complete_sync_view() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-sync-view",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EvAtrilWindowIface, handle_sync_view),
    g_signal_accumulator_true_handled,
    NULL,
      ev_atril_window_method_marshal_sync_view,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * EvAtrilWindow::sync-source:
   * @object: A #EvAtrilWindow.
   * @arg_source_file: Argument.
   * @arg_source_point: Argument.
   * @arg_timestamp: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mate-atril-Window.SyncSource">"SyncSource"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  EV__ATRIL_WINDOW_SIGNALS[EV__ATRIL_WINDOW_SYNC_SOURCE] =
    g_signal_new ("sync-source",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (EvAtrilWindowIface, sync_source),
      NULL,
      NULL,
      ev_atril_window_signal_marshal_sync_source,
      G_TYPE_NONE,
      3, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT);

  /**
   * EvAtrilWindow::closed:
   * @object: A #EvAtrilWindow.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mate-atril-Window.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  EV__ATRIL_WINDOW_SIGNALS[EV__ATRIL_WINDOW_CLOSED] =
    g_signal_new ("closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (EvAtrilWindowIface, closed),
      NULL,
      NULL,
      ev_atril_window_signal_marshal_closed,
      G_TYPE_NONE,
      0);

  /**
   * EvAtrilWindow::document-loaded:
   * @object: A #EvAtrilWindow.
   * @arg_uri: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mate-atril-Window.DocumentLoaded">"DocumentLoaded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  EV__ATRIL_WINDOW_SIGNALS[EV__ATRIL_WINDOW_DOCUMENT_LOADED] =
    g_signal_new ("document-loaded",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (EvAtrilWindowIface, document_loaded),
      NULL,
      NULL,
      ev_atril_window_signal_marshal_document_loaded,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

}

/**
 * ev_atril_window_emit_sync_source:
 * @object: A #EvAtrilWindow.
 * @arg_source_file: Argument to pass with the signal.
 * @arg_source_point: Argument to pass with the signal.
 * @arg_timestamp: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mate-atril-Window.SyncSource">"SyncSource"</link> D-Bus signal.
 */
void
ev_atril_window_emit_sync_source (
    EvAtrilWindow *object,
    const gchar *arg_source_file,
    GVariant *arg_source_point,
    guint arg_timestamp)
{
  g_signal_emit (object, EV__ATRIL_WINDOW_SIGNALS[EV__ATRIL_WINDOW_SYNC_SOURCE], 0, arg_source_file, arg_source_point, arg_timestamp);
}

/**
 * ev_atril_window_emit_closed:
 * @object: A #EvAtrilWindow.
 *
 * Emits the <link linkend="gdbus-signal-org-mate-atril-Window.Closed">"Closed"</link> D-Bus signal.
 */
void
ev_atril_window_emit_closed (
    EvAtrilWindow *object)
{
  g_signal_emit (object, EV__ATRIL_WINDOW_SIGNALS[EV__ATRIL_WINDOW_CLOSED], 0);
}

/**
 * ev_atril_window_emit_document_loaded:
 * @object: A #EvAtrilWindow.
 * @arg_uri: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mate-atril-Window.DocumentLoaded">"DocumentLoaded"</link> D-Bus signal.
 */
void
ev_atril_window_emit_document_loaded (
    EvAtrilWindow *object,
    const gchar *arg_uri)
{
  g_signal_emit (object, EV__ATRIL_WINDOW_SIGNALS[EV__ATRIL_WINDOW_DOCUMENT_LOADED], 0, arg_uri);
}

/**
 * ev_atril_window_call_sync_view:
 * @proxy: A #EvAtrilWindowProxy.
 * @arg_source_file: Argument to pass with the method invocation.
 * @arg_source_point: Argument to pass with the method invocation.
 * @arg_timestamp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mate-atril-Window.SyncView">SyncView()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ev_atril_window_call_sync_view_finish() to get the result of the operation.
 *
 * See ev_atril_window_call_sync_view_sync() for the synchronous, blocking version of this method.
 */
void
ev_atril_window_call_sync_view (
    EvAtrilWindow *proxy,
    const gchar *arg_source_file,
    GVariant *arg_source_point,
    guint arg_timestamp,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SyncView",
    g_variant_new ("(s@(ii)u)",
                   arg_source_file,
                   arg_source_point,
                   arg_timestamp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ev_atril_window_call_sync_view_finish:
 * @proxy: A #EvAtrilWindowProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ev_atril_window_call_sync_view().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ev_atril_window_call_sync_view().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ev_atril_window_call_sync_view_finish (
    EvAtrilWindow *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ev_atril_window_call_sync_view_sync:
 * @proxy: A #EvAtrilWindowProxy.
 * @arg_source_file: Argument to pass with the method invocation.
 * @arg_source_point: Argument to pass with the method invocation.
 * @arg_timestamp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mate-atril-Window.SyncView">SyncView()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ev_atril_window_call_sync_view() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ev_atril_window_call_sync_view_sync (
    EvAtrilWindow *proxy,
    const gchar *arg_source_file,
    GVariant *arg_source_point,
    guint arg_timestamp,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SyncView",
    g_variant_new ("(s@(ii)u)",
                   arg_source_file,
                   arg_source_point,
                   arg_timestamp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ev_atril_window_complete_sync_view:
 * @object: A #EvAtrilWindow.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mate-atril-Window.SyncView">SyncView()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ev_atril_window_complete_sync_view (
    EvAtrilWindow *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * EvAtrilWindowProxy:
 *
 * The #EvAtrilWindowProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * EvAtrilWindowProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EvAtrilWindowProxy.
 */

struct _EvAtrilWindowProxyPrivate
{
  GData *qdata;
};

static void ev_atril_window_proxy_iface_init (EvAtrilWindowIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (EvAtrilWindowProxy, ev_atril_window_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (EvAtrilWindowProxy)
                         G_IMPLEMENT_INTERFACE (EV_TYPE_ATRIL_WINDOW, ev_atril_window_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (EvAtrilWindowProxy, ev_atril_window_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (EV_TYPE_ATRIL_WINDOW, ev_atril_window_proxy_iface_init))

#endif
static void
ev_atril_window_proxy_finalize (GObject *object)
{
  EvAtrilWindowProxy *proxy = EV_ATRIL_WINDOW_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ev_atril_window_proxy_parent_class)->finalize (object);
}

static void
ev_atril_window_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ev_atril_window_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ev_atril_window_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ev_atril_window_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], EV_TYPE_ATRIL_WINDOW);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, EV_TYPE_ATRIL_WINDOW);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ev_atril_window_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  EvAtrilWindowProxy *proxy = EV_ATRIL_WINDOW_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ev_atril_window_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ev_atril_window_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
ev_atril_window_proxy_init (EvAtrilWindowProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ev_atril_window_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, EV_TYPE_ATRIL_WINDOW_PROXY, EvAtrilWindowProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ev_atril_window_interface_info ());
}

static void
ev_atril_window_proxy_class_init (EvAtrilWindowProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ev_atril_window_proxy_finalize;
  gobject_class->get_property = ev_atril_window_proxy_get_property;
  gobject_class->set_property = ev_atril_window_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ev_atril_window_proxy_g_signal;
  proxy_class->g_properties_changed = ev_atril_window_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (EvAtrilWindowProxyPrivate));
#endif
}

static void
ev_atril_window_proxy_iface_init (EvAtrilWindowIface *iface G_GNUC_UNUSED)
{
}

/**
 * ev_atril_window_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ev_atril_window_proxy_new_finish() to get the result of the operation.
 *
 * See ev_atril_window_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ev_atril_window_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (EV_TYPE_ATRIL_WINDOW_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mate.atril.Window", NULL);
}

/**
 * ev_atril_window_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ev_atril_window_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ev_atril_window_proxy_new().
 *
 * Returns: (transfer full) (type EvAtrilWindowProxy): The constructed proxy object or %NULL if @error is set.
 */
EvAtrilWindow *
ev_atril_window_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return EV_ATRIL_WINDOW (ret);
  else
    return NULL;
}

/**
 * ev_atril_window_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ev_atril_window_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EvAtrilWindowProxy): The constructed proxy object or %NULL if @error is set.
 */
EvAtrilWindow *
ev_atril_window_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (EV_TYPE_ATRIL_WINDOW_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mate.atril.Window", NULL);
  if (ret != NULL)
    return EV_ATRIL_WINDOW (ret);
  else
    return NULL;
}


/**
 * ev_atril_window_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ev_atril_window_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ev_atril_window_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ev_atril_window_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ev_atril_window_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (EV_TYPE_ATRIL_WINDOW_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mate.atril.Window", NULL);
}

/**
 * ev_atril_window_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ev_atril_window_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ev_atril_window_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type EvAtrilWindowProxy): The constructed proxy object or %NULL if @error is set.
 */
EvAtrilWindow *
ev_atril_window_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return EV_ATRIL_WINDOW (ret);
  else
    return NULL;
}

/**
 * ev_atril_window_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ev_atril_window_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ev_atril_window_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EvAtrilWindowProxy): The constructed proxy object or %NULL if @error is set.
 */
EvAtrilWindow *
ev_atril_window_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (EV_TYPE_ATRIL_WINDOW_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mate.atril.Window", NULL);
  if (ret != NULL)
    return EV_ATRIL_WINDOW (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * EvAtrilWindowSkeleton:
 *
 * The #EvAtrilWindowSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * EvAtrilWindowSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EvAtrilWindowSkeleton.
 */

struct _EvAtrilWindowSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ev_atril_window_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  EvAtrilWindowSkeleton *skeleton = EV_ATRIL_WINDOW_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], EV_TYPE_ATRIL_WINDOW);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, EV_TYPE_ATRIL_WINDOW);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ev_atril_window_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  EvAtrilWindowSkeleton *skeleton = EV_ATRIL_WINDOW_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ev_atril_window_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ev_atril_window_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  EvAtrilWindowSkeleton *skeleton = EV_ATRIL_WINDOW_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ev_atril_window_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ev_atril_window_skeleton_vtable =
{
  _ev_atril_window_skeleton_handle_method_call,
  _ev_atril_window_skeleton_handle_get_property,
  _ev_atril_window_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ev_atril_window_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ev_atril_window_interface_info ();
}

static GDBusInterfaceVTable *
ev_atril_window_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ev_atril_window_skeleton_vtable;
}

static GVariant *
ev_atril_window_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  EvAtrilWindowSkeleton *skeleton = EV_ATRIL_WINDOW_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ev_atril_window_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ev_atril_window_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ev_atril_window_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ev_atril_window_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mate.atril.Window", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
ev_atril_window_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_ev_atril_window_on_signal_sync_source (
    EvAtrilWindow *object,
    const gchar *arg_source_file,
    GVariant *arg_source_point,
    guint arg_timestamp)
{
  EvAtrilWindowSkeleton *skeleton = EV_ATRIL_WINDOW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@(ii)u)",
                   arg_source_file,
                   arg_source_point,
                   arg_timestamp));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mate.atril.Window", "SyncSource",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ev_atril_window_on_signal_closed (
    EvAtrilWindow *object)
{
  EvAtrilWindowSkeleton *skeleton = EV_ATRIL_WINDOW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mate.atril.Window", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ev_atril_window_on_signal_document_loaded (
    EvAtrilWindow *object,
    const gchar *arg_uri)
{
  EvAtrilWindowSkeleton *skeleton = EV_ATRIL_WINDOW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_uri));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mate.atril.Window", "DocumentLoaded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void ev_atril_window_skeleton_iface_init (EvAtrilWindowIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (EvAtrilWindowSkeleton, ev_atril_window_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (EvAtrilWindowSkeleton)
                         G_IMPLEMENT_INTERFACE (EV_TYPE_ATRIL_WINDOW, ev_atril_window_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (EvAtrilWindowSkeleton, ev_atril_window_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (EV_TYPE_ATRIL_WINDOW, ev_atril_window_skeleton_iface_init))

#endif
static void
ev_atril_window_skeleton_finalize (GObject *object)
{
  EvAtrilWindowSkeleton *skeleton = EV_ATRIL_WINDOW_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ev_atril_window_skeleton_parent_class)->finalize (object);
}

static void
ev_atril_window_skeleton_init (EvAtrilWindowSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ev_atril_window_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, EV_TYPE_ATRIL_WINDOW_SKELETON, EvAtrilWindowSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
ev_atril_window_skeleton_class_init (EvAtrilWindowSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ev_atril_window_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ev_atril_window_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ev_atril_window_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ev_atril_window_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ev_atril_window_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (EvAtrilWindowSkeletonPrivate));
#endif
}

static void
ev_atril_window_skeleton_iface_init (EvAtrilWindowIface *iface)
{
  iface->sync_source = _ev_atril_window_on_signal_sync_source;
  iface->closed = _ev_atril_window_on_signal_closed;
  iface->document_loaded = _ev_atril_window_on_signal_document_loaded;
}

/**
 * ev_atril_window_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link>.
 *
 * Returns: (transfer full) (type EvAtrilWindowSkeleton): The skeleton object.
 */
EvAtrilWindow *
ev_atril_window_skeleton_new (void)
{
  return EV_ATRIL_WINDOW (g_object_new (EV_TYPE_ATRIL_WINDOW_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:EvObject
 * @title: EvObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #EvObject, #EvObjectProxy, and #EvObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * EvObject:
 *
 * The #EvObject type is a specialized container of interfaces.
 */

/**
 * EvObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #EvObject interface.
 */

typedef EvObjectIface EvObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (EvObject, ev_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
ev_object_default_init (EvObjectIface *iface)
{
  /**
   * EvObject:atril-application:
   *
   * The #EvAtrilApplication instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("atril-application", "atril-application", "atril-application", EV_TYPE_ATRIL_APPLICATION, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * EvObject:atril-window:
   *
   * The #EvAtrilWindow instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("atril-window", "atril-window", "atril-window", EV_TYPE_ATRIL_WINDOW, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * ev_object_get_atril_application:
 * @object: A #EvObject.
 *
 * Gets the #EvAtrilApplication instance for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #EvAtrilApplication that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
EvAtrilApplication *ev_object_get_atril_application (EvObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.mate.atril.Application");
  if (ret == NULL)
    return NULL;
  return EV_ATRIL_APPLICATION (ret);
}

/**
 * ev_object_get_atril_window:
 * @object: A #EvObject.
 *
 * Gets the #EvAtrilWindow instance for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #EvAtrilWindow that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
EvAtrilWindow *ev_object_get_atril_window (EvObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.mate.atril.Window");
  if (ret == NULL)
    return NULL;
  return EV_ATRIL_WINDOW (ret);
}


/**
 * ev_object_peek_atril_application: (skip)
 * @object: A #EvObject.
 *
 * Like ev_object_get_atril_application() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #EvAtrilApplication or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
EvAtrilApplication *ev_object_peek_atril_application (EvObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.mate.atril.Application");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return EV_ATRIL_APPLICATION (ret);
}

/**
 * ev_object_peek_atril_window: (skip)
 * @object: A #EvObject.
 *
 * Like ev_object_get_atril_window() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #EvAtrilWindow or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
EvAtrilWindow *ev_object_peek_atril_window (EvObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.mate.atril.Window");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return EV_ATRIL_WINDOW (ret);
}


static void
ev_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * EvObjectProxy:
 *
 * The #EvObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * EvObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EvObjectProxy.
 */

static void
ev_object_proxy__ev_object_iface_init (EvObjectIface *iface G_GNUC_UNUSED)
{
}

static void
ev_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = ev_object_notify;
  iface->interface_removed = ev_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (EvObjectProxy, ev_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (EV_TYPE_OBJECT, ev_object_proxy__ev_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, ev_object_proxy__g_dbus_object_iface_init))

static void
ev_object_proxy_init (EvObjectProxy *object G_GNUC_UNUSED)
{
}

static void
ev_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
ev_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  EvObjectProxy *object = EV_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.mate.atril.Application");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.mate.atril.Window");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
ev_object_proxy_class_init (EvObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = ev_object_proxy_set_property;
  gobject_class->get_property = ev_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "atril-application");
  g_object_class_override_property (gobject_class, 2, "atril-window");
}

/**
 * ev_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
EvObjectProxy *
ev_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return EV_OBJECT_PROXY (g_object_new (EV_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * EvObjectSkeleton:
 *
 * The #EvObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * EvObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EvObjectSkeleton.
 */

static void
ev_object_skeleton__ev_object_iface_init (EvObjectIface *iface G_GNUC_UNUSED)
{
}


static void
ev_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = ev_object_notify;
  iface->interface_removed = ev_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (EvObjectSkeleton, ev_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (EV_TYPE_OBJECT, ev_object_skeleton__ev_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, ev_object_skeleton__g_dbus_object_iface_init))

static void
ev_object_skeleton_init (EvObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
ev_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  EvObjectSkeleton *object = EV_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (EV_IS_ATRIL_APPLICATION (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.mate.atril.Application");
        }
      break;

    case 2:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (EV_IS_ATRIL_WINDOW (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.mate.atril.Window");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
ev_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  EvObjectSkeleton *object = EV_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.mate.atril.Application");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.mate.atril.Window");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
ev_object_skeleton_class_init (EvObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = ev_object_skeleton_set_property;
  gobject_class->get_property = ev_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "atril-application");
  g_object_class_override_property (gobject_class, 2, "atril-window");
}

/**
 * ev_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
EvObjectSkeleton *
ev_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return EV_OBJECT_SKELETON (g_object_new (EV_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * ev_object_skeleton_set_atril_application:
 * @object: A #EvObjectSkeleton.
 * @interface_: (nullable): A #EvAtrilApplication or %NULL to clear the interface.
 *
 * Sets the #EvAtrilApplication instance for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Application.top_of_page">org.mate.atril.Application</link> on @object.
 */
void ev_object_skeleton_set_atril_application (EvObjectSkeleton *object, EvAtrilApplication *interface_)
{
  g_object_set (G_OBJECT (object), "atril-application", interface_, NULL);
}

/**
 * ev_object_skeleton_set_atril_window:
 * @object: A #EvObjectSkeleton.
 * @interface_: (nullable): A #EvAtrilWindow or %NULL to clear the interface.
 *
 * Sets the #EvAtrilWindow instance for the D-Bus interface <link linkend="gdbus-interface-org-mate-atril-Window.top_of_page">org.mate.atril.Window</link> on @object.
 */
void ev_object_skeleton_set_atril_window (EvObjectSkeleton *object, EvAtrilWindow *interface_)
{
  g_object_set (G_OBJECT (object), "atril-window", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:EvObjectManagerClient
 * @title: EvObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses ev_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * EvObjectManagerClient:
 *
 * The #EvObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * EvObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EvObjectManagerClient.
 */

G_DEFINE_TYPE (EvObjectManagerClient, ev_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
ev_object_manager_client_init (EvObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
ev_object_manager_client_class_init (EvObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * ev_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #EvObjectProxy.
 */
GType
ev_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return EV_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.mate.atril.Application", (gpointer) (guintptr) (EV_TYPE_ATRIL_APPLICATION_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.mate.atril.Window", (gpointer) (guintptr) (EV_TYPE_ATRIL_WINDOW_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * ev_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using ev_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ev_object_manager_client_new_finish() to get the result of the operation.
 *
 * See ev_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ev_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (EV_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", ev_object_manager_client_get_proxy_type, NULL);
}

/**
 * ev_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ev_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ev_object_manager_client_new().
 *
 * Returns: (transfer full) (type EvObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
ev_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * ev_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using ev_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ev_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EvObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
ev_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (EV_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", ev_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * ev_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ev_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ev_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See ev_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ev_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (EV_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", ev_object_manager_client_get_proxy_type, NULL);
}

/**
 * ev_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ev_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ev_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type EvObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
ev_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * ev_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ev_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ev_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EvObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
ev_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (EV_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", ev_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


