/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */
#ifndef QTTAPIOCA_USER_CONTACT_H
#define QTTAPIOCA_USER_CONTACT_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <qglobal.h>

#include <QtTapioca/ContactBase>

#include <QtTelepathy/Client/Connection>
#include <QtTelepathy/Client/ConnectionAvatarsInterface>
#include <QtTelepathy/Client/ConnectionPresenceInterface>
#include <QtTelepathy/Client/ConnectionAliasingInterface>
#include <QtTelepathy/Client/ConnectionCapabilitiesInterface>

namespace QtTapioca {

class UserContactPrivate;
class Avatar;
class Handle;

class Q_DECL_EXPORT UserContact : public ContactBase {
    Q_OBJECT
    Q_DECLARE_PRIVATE(UserContact)

public:
    ~UserContact();

    bool setAvatar(Avatar *avatar);
    bool setPresence(ContactBase::Presence status);
    bool setPresenceMessage(const QString &message);
    bool setPresenceWithMessage(ContactBase::Presence status, const QString &message);
    bool setAlias(const QString &alias);
    bool setCapabilities(QList<ContactBase::Capability> caps);

private:
    friend class Connection;
    UserContact(org::freedesktop::Telepathy::Connection *telepathyConn,
                org::freedesktop::Telepathy::ConnectionAvatarsInterface  *iAvatar,
                org::freedesktop::Telepathy::ConnectionPresenceInterface *iPresence,
                org::freedesktop::Telepathy::ConnectionAliasingInterface *iAliasing,
                org::freedesktop::Telepathy::ConnectionCapabilitiesInterface *iCapabilities,
                Handle *handle, QObject *parent = 0);

    void setPresenceStatus(const QString &presenceStr, const QString &message);
    UserContactPrivate *d;
};

} // namespace

#endif

