/*
 * VC-1 and WMV3 decoder
 * copyright (c) 2011 Mashiat Sarker Shakkhar
 * copyright (c) 2006 Konstantin Shishkov
 * (c) 2005 anonymous, Alex Beregszaszi, Michael Niedermayer
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file
 * VC-1 tables.
 */

#include "avcodec.h"
#include "vc1.h"
#include "vc1data.h"

/** Table for conversion between TTBLK and TTMB */
const int ff_vc1_ttblk_to_tt[3][8] = {
    { TT_8X4, TT_4X8, TT_8X8, TT_4X4, TT_8X4_TOP, TT_8X4_BOTTOM, TT_4X8_RIGHT, TT_4X8_LEFT },
    { TT_8X8, TT_4X8_RIGHT, TT_4X8_LEFT, TT_4X4, TT_8X4, TT_4X8, TT_8X4_BOTTOM, TT_8X4_TOP },
    { TT_8X8, TT_4X8, TT_4X4, TT_8X4_BOTTOM, TT_4X8_RIGHT, TT_4X8_LEFT, TT_8X4, TT_8X4_TOP }
};

const int ff_vc1_ttfrm_to_tt[4] = { TT_8X8, TT_8X4, TT_4X8, TT_4X4 };

/** MV P mode - the 5th element is only used for mode 1 */
const uint8_t ff_vc1_mv_pmode_table[2][5] = {
    { MV_PMODE_1MV_HPEL_BILIN, MV_PMODE_1MV, MV_PMODE_1MV_HPEL, MV_PMODE_INTENSITY_COMP, MV_PMODE_MIXED_MV },
    { MV_PMODE_1MV, MV_PMODE_MIXED_MV, MV_PMODE_1MV_HPEL, MV_PMODE_INTENSITY_COMP, MV_PMODE_1MV_HPEL_BILIN }
};
const uint8_t ff_vc1_mv_pmode_table2[2][4] = {
    { MV_PMODE_1MV_HPEL_BILIN, MV_PMODE_1MV, MV_PMODE_1MV_HPEL, MV_PMODE_MIXED_MV },
    { MV_PMODE_1MV, MV_PMODE_MIXED_MV, MV_PMODE_1MV_HPEL, MV_PMODE_1MV_HPEL_BILIN }
};

/* MBMODE table for interlaced frame P-picture */
const uint8_t ff_vc1_mbmode_intfrp[2][15][4] = {
    { /* 1: 4-MV, 0: non-4-MV */
        /* Type, FIELDTX, 1-MV Differential present, Residuals (CBP) present */
        /* Table 164 - Table 167 */
        { MV_PMODE_INTFR_1MV      , 0, 1, 1 },
        { MV_PMODE_INTFR_1MV      , 1, 1, 1 },
        { MV_PMODE_INTFR_1MV      , 0, 1, 0 },
        { MV_PMODE_INTFR_1MV      , 0, 0, 1 },
        { MV_PMODE_INTFR_1MV      , 1, 0, 1 },
        { MV_PMODE_INTFR_2MV_FIELD, 0, 0, 1 },
        { MV_PMODE_INTFR_2MV_FIELD, 1, 0, 1 },
        { MV_PMODE_INTFR_2MV_FIELD, 0, 0, 0 },
        { MV_PMODE_INTFR_INTRA    , 0, 0, 0 }
    },
    {
        /* Table 160 - Table 163 */
        { MV_PMODE_INTFR_1MV      , 0, 1, 1 },
        { MV_PMODE_INTFR_1MV      , 1, 1, 1 },
        { MV_PMODE_INTFR_1MV      , 0, 1, 0 },
        { MV_PMODE_INTFR_1MV      , 0, 0, 1 },
        { MV_PMODE_INTFR_1MV      , 1, 0, 1 },
        { MV_PMODE_INTFR_2MV_FIELD, 0, 0, 1 },
        { MV_PMODE_INTFR_2MV_FIELD, 1, 0, 1 },
        { MV_PMODE_INTFR_2MV_FIELD, 0, 0, 0 },
        { MV_PMODE_INTFR_4MV      , 0, 0, 1 },
        { MV_PMODE_INTFR_4MV      , 1, 0, 1 },
        { MV_PMODE_INTFR_4MV      , 0, 0, 0 },
        { MV_PMODE_INTFR_4MV_FIELD, 0, 0, 1 },
        { MV_PMODE_INTFR_4MV_FIELD, 1, 0, 1 },
        { MV_PMODE_INTFR_4MV_FIELD, 0, 0, 0 },
        { MV_PMODE_INTFR_INTRA    , 0, 0, 0 }
    }
};

const int ff_vc1_fps_nr[5] = { 24, 25, 30, 50, 60 },
          ff_vc1_fps_dr[2] = { 1000, 1001 };
const uint8_t ff_vc1_pquant_table[3][32] = {
    /* Implicit quantizer */
    {  0,  1,  2,  3,  4,  5,  6,  7,  8,  6,  7,  8,  9, 10, 11, 12,
      13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 29, 31 },
    /* Explicit quantizer, pquantizer uniform */
    {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 },
    /* Explicit quantizer, pquantizer non-uniform */
    {  0,  1,  1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13,
      14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 31 }
};

/** @name VC-1 VLC tables and defines
 *  @todo TODO move this into the context
 */
//@{
#define VC1_BFRACTION_VLC_BITS 7
VLC ff_vc1_bfraction_vlc;
#define VC1_IMODE_VLC_BITS 4
VLC ff_vc1_imode_vlc;
#define VC1_NORM2_VLC_BITS 3
VLC ff_vc1_norm2_vlc;
#define VC1_NORM6_VLC_BITS 9
VLC ff_vc1_norm6_vlc;
/* Could be optimized, one table only needs 8 bits */
#define VC1_TTMB_VLC_BITS 9 //12
VLC ff_vc1_ttmb_vlc[3];
#define VC1_MV_DIFF_VLC_BITS 9 //15
VLC ff_vc1_mv_diff_vlc[4];
#define VC1_CBPCY_P_VLC_BITS 9 //14
VLC ff_vc1_cbpcy_p_vlc[4];
#define VC1_ICBPCY_VLC_BITS 9
VLC ff_vc1_icbpcy_vlc[8];
#define VC1_4MV_BLOCK_PATTERN_VLC_BITS 6
VLC ff_vc1_4mv_block_pattern_vlc[4];
#define VC1_2MV_BLOCK_PATTERN_VLC_BITS 3
VLC ff_vc1_2mv_block_pattern_vlc[4];
#define VC1_TTBLK_VLC_BITS 5
VLC ff_vc1_ttblk_vlc[3];
#define VC1_SUBBLKPAT_VLC_BITS 6
VLC ff_vc1_subblkpat_vlc[3];
#define VC1_INTFR_4MV_MBMODE_VLC_BITS 9
VLC ff_vc1_intfr_4mv_mbmode_vlc[4];
#define VC1_INTFR_NON4MV_MBMODE_VLC_BITS 6
VLC ff_vc1_intfr_non4mv_mbmode_vlc[4];
#define VC1_IF_MMV_MBMODE_VLC_BITS 5
VLC ff_vc1_if_mmv_mbmode_vlc[8];
#define VC1_IF_1MV_MBMODE_VLC_BITS 5
VLC ff_vc1_if_1mv_mbmode_vlc[8];
#define VC1_1REF_MVDATA_VLC_BITS 9
VLC ff_vc1_1ref_mvdata_vlc[4];
#define VC1_2REF_MVDATA_VLC_BITS 9
VLC ff_vc1_2ref_mvdata_vlc[8];

VLC ff_vc1_ac_coeff_table[8];

#define VC1_IF_MBMODE_VLC_BITS 5    // as a placeholder for VC1_IF_MMV_MBMODE_VLC_BITS
                                    // or VC1_IF_1MV_MBMODE_VLC_BITS since they are the same
//@}


#if B_FRACTION_DEN == 840 // original bfraction from vc9data.h, not conforming to standard
/* bfraction is fractional, we scale to the GCD 3*5*7*8 = 840 */
const int16_t ff_vc1_bfraction_lut[23] = {
    420 /*1/2*/, 280 /*1/3*/, 560 /*2/3*/, 210 /*1/4*/,
    630 /*3/4*/, 168 /*1/5*/, 336 /*2/5*/,
    504 /*3/5*/, 672 /*4/5*/, 140 /*1/6*/, 700 /*5/6*/,
    120 /*1/7*/, 240 /*2/7*/, 360 /*3/7*/, 480 /*4/7*/,
    600 /*5/7*/, 720 /*6/7*/, 105 /*1/8*/, 315 /*3/8*/,
    525 /*5/8*/, 735 /*7/8*/,
    -1 /*inv.*/, 0 /*BI fm*/
};
#else
/* pre-computed scales for all bfractions and base=256 */
const int16_t ff_vc1_bfraction_lut[23] = {
    128 /*1/2*/,  85 /*1/3*/, 170 /*2/3*/,  64 /*1/4*/,
    192 /*3/4*/,  51 /*1/5*/, 102 /*2/5*/,
    153 /*3/5*/, 204 /*4/5*/,  43 /*1/6*/, 215 /*5/6*/,
     37 /*1/7*/,  74 /*2/7*/, 111 /*3/7*/, 148 /*4/7*/,
    185 /*5/7*/, 222 /*6/7*/,  32 /*1/8*/,  96 /*3/8*/,
    160 /*5/8*/, 224 /*7/8*/,
    -1 /*inv.*/, 0 /*BI fm*/
};
#endif

const uint8_t ff_vc1_bfraction_bits[23] = {
    3, 3, 3, 3,
    3, 3, 3,
    7, 7, 7, 7,
    7, 7, 7, 7,
    7, 7, 7, 7,
    7, 7,
    7, 7
};
const uint8_t ff_vc1_bfraction_codes[23] = {
      0,   1,   2,   3,
      4,   5,   6,
    112, 113, 114, 115,
    116, 117, 118, 119,
    120, 121, 122, 123,
    124, 125,
    126, 127
};

//Same as H.264
const AVRational ff_vc1_pixel_aspect[16] = {
    {   0,  1 },
    {   1,  1 },
    {  12, 11 },
    {  10, 11 },
    {  16, 11 },
    {  40, 33 },
    {  24, 11 },
    {  20, 11 },
    {  32, 11 },
    {  80, 33 },
    {  18, 11 },
    {  15, 11 },
    {  64, 33 },
    { 160, 99 },
    {   0,  1 },
    {   0,  1 }
};

/* BitPlane IMODE - such a small table... */
const uint8_t ff_vc1_imode_codes[7] = {
    0, 2, 1, 3, 1, 2, 3
};
const uint8_t ff_vc1_imode_bits[7] = {
    4, 2, 3, 2, 4, 3, 3
};

/* Normal-2 imode */
const uint8_t ff_vc1_norm2_codes[4] = {
    0, 4, 5, 3
};
const uint8_t ff_vc1_norm2_bits[4] = {
    1, 3, 3, 2
};

const uint16_t ff_vc1_norm6_codes[64] = {
    0x001, 0x002, 0x003, 0x000, 0x004, 0x001, 0x002, 0x047, 0x005, 0x003, 0x004, 0x04B, 0x005, 0x04D, 0x04E, 0x30E,
    0x006, 0x006, 0x007, 0x053, 0x008, 0x055, 0x056, 0x30D, 0x009, 0x059, 0x05A, 0x30C, 0x05C, 0x30B, 0x30A, 0x037,
    0x007, 0x00A, 0x00B, 0x043, 0x00C, 0x045, 0x046, 0x309, 0x00D, 0x049, 0x04A, 0x308, 0x04C, 0x307, 0x306, 0x036,
    0x00E, 0x051, 0x052, 0x305, 0x054, 0x304, 0x303, 0x035, 0x058, 0x302, 0x301, 0x034, 0x300, 0x033, 0x032, 0x007,
};

const uint8_t ff_vc1_norm6_bits[64] = {
    1,  4,  4,  8,  4,  8,  8, 10,  4,  8,  8, 10,  8, 10, 10, 13,
    4,  8,  8, 10,  8, 10, 10, 13,  8, 10, 10, 13, 10, 13, 13,  9,
    4,  8,  8, 10,  8, 10, 10, 13,  8, 10, 10, 13, 10, 13, 13,  9,
    8, 10, 10, 13, 10, 13, 13,  9, 10, 13, 13,  9, 13,  9,  9,  6,
};

/* 4MV Block pattern VLC tables */
const uint8_t ff_vc1_4mv_block_pattern_codes[4][16] = {
    { 14, 58, 59, 25, 12, 26, 15, 15, 13, 24, 27,  0, 28,  1,  2,  2 },
    {  8, 18, 19,  4, 20,  5, 30, 11, 21, 31,  6, 12,  7, 13, 14,  0 },
    { 15,  6,  7,  2,  8,  3, 28,  9, 10, 29,  4, 11,  5, 12, 13,  0 },
    {  0, 11, 12,  4, 13,  5, 30, 16, 14, 31,  6, 17,  7, 18, 19, 10 }
};
const uint8_t ff_vc1_4mv_block_pattern_bits[4][16] = {
    { 5, 6, 6, 5, 5, 5, 5, 4, 5, 5, 5, 3, 5, 3, 3, 2 },
    { 4, 5, 5, 4, 5, 4, 5, 4, 5, 5, 4, 4, 4, 4, 4, 2 },
    { 4, 4, 4, 4, 4, 4, 5, 4, 4, 5, 4, 4, 4, 4, 4, 3 },
    { 2, 4, 4, 4, 4, 4, 5, 5, 4, 5, 4, 5, 4, 5, 5, 4 }
};

/* 2MV Block pattern VLC tables */
const uint8_t ff_vc1_2mv_block_pattern_codes[4][4] = {
    { 2, 1, 0, 3 }, { 1, 0, 2, 3 }, { 2, 0, 3, 1 }, { 1, 3, 2, 0 }
};

const uint8_t ff_vc1_2mv_block_pattern_bits[4][4] = {
    { 2, 2, 2, 2 }, { 1, 2, 3, 3 }, { 3, 2, 3, 1 }, { 1, 3, 3, 2 }
};

/* Interlaced frame picture 4MV MBMODE VLC tables (p. 246, p. 360) */
const uint16_t ff_vc1_intfr_4mv_mbmode_codes[4][15] = {
    { 22,  17,  0, 47,  32, 10,  1,  3, 67,  133, 132,  92,  19,  93,   18 },
    {  3,  45,  0,  7,  23,  6,  1,  2, 10,   39,  44,   8,  18,  77,   76 },
    { 15,   6, 28,  9,  41,  6,  2, 15, 14,    8,  40,  29,   0,  21,   11 },
    {  7, 198,  1,  2, 193, 13, 25,  0, 97, 1599,  98, 398, 798, 192, 1598 }
};

const uint8_t ff_vc1_intfr_4mv_mbmode_bits[4][15] = {
    { 5, 5, 2, 6, 6, 4, 2, 2, 7,  8, 8,  7,  5, 7,  5 },
    { 3, 6, 3, 3, 5, 3, 3, 3, 4,  6, 6,  4,  5, 7,  7 },
    { 4, 3, 5, 5, 7, 4, 2, 5, 5,  5, 7,  5,  2, 6,  5 },
    { 4, 9, 1, 3, 9, 5, 6, 2, 8, 12, 8, 10, 11, 9, 12 }
};

/* Interlaced frame picture NON-4MV MBMODE VLC tables (p. 363) */
const uint8_t ff_vc1_intfr_non4mv_mbmode_codes[4][9] = {
    {  9, 22,  0, 17, 16, 10,  1,  3, 23 },
    {  7,  0,  5,  2,  1,  1,  6,  3,  4 },
    {  1,  0, 10, 23, 44,  8,  3,  9, 45 },
    {  7, 97,  1,  2, 49, 13, 25,  0, 96 }
};

const uint8_t ff_vc1_intfr_non4mv_mbmode_bits[4][9] = {
    {  4,  5,  2,  5,  5,  4,  2,  2,  5 },
    {  3,  4,  6,  2,  3,  2,  3,  5,  6 },
    {  2,  2,  4,  5,  6,  4,  2,  4,  6 },
    {  4,  8,  1,  3,  7,  5,  6,  2,  8 }
};

/* Interlaced field picture MBMODE VLC tables (p. 356 - 11.4.1, 11.4.2) */
/* mixed-MV */
const uint8_t ff_vc1_if_mmv_mbmode_codes[8][8] = {
    { 16, 17,  3,  3,  0,  5,  9,  2 },
    {  8,  9,  3,  6,  7,  0,  5,  2 },
    { 16, 17,  5,  3,  0,  3,  9,  2 },
    { 56, 57, 15,  4,  5,  6, 29,  0 },
    { 52, 53, 27, 14, 15,  2, 12,  0 },
    { 56, 57, 29,  5,  6,  0, 15,  4 },
    { 16, 17,  6,  7,  0,  1,  9,  5 },
    { 56, 57,  0,  5,  6, 29,  4, 15 }
};
const uint8_t ff_vc1_if_mmv_mbmode_bits[8][8] = {
    { 6, 6, 2, 3, 2, 4, 5, 2 },
    { 5, 5, 3, 3, 3, 2, 4, 2 },
    { 6, 6, 4, 3, 2, 2, 5, 2 },
    { 6, 6, 4, 3, 3, 3, 5, 1 },
    { 6, 6, 5, 4, 4, 2, 4, 1 },
    { 6, 6, 5, 3, 3, 1, 4, 3 },
    { 5, 5, 3, 3, 2, 2, 4, 3 },
    { 6, 6, 1, 3, 3, 5, 3, 4 }
};
/* 1MV */
const uint8_t ff_vc1_if_1mv_mbmode_codes[8][6] = {
    {  0,  1,  1,  1,  1,  1 },
    {  0,  1,  1,  1,  1,  1 },
    { 16, 17,  3,  0,  9,  5 },
    { 20, 21,  3, 11,  0,  4 },
    {  4,  5,  2,  3,  3,  0 },
    {  4,  5,  3,  2,  0,  3 },
    {  0,  1,  1,  1,  1,  1 },
    { 16, 17,  9,  5,  3,  0 }
};
const uint8_t ff_vc1_if_1mv_mbmode_bits[8][6] = {
    { 5, 5, 1, 3, 2, 4 },
    { 5, 5, 1, 2, 3, 4 },
    { 5, 5, 2, 1, 4, 3 },
    { 5, 5, 2, 4, 1, 3 },
    { 4, 4, 2, 3, 2, 2 },
    { 4, 4, 3, 2, 2, 2 },
    { 5, 5, 3, 4, 1, 2 },
    { 5, 5, 4, 3, 2, 1 }
};

/* Interlaced frame/field picture MVDATA VLC tables */

/* 1-reference tables */
const uint32_t ff_vc1_1ref_mvdata_codes[4][72] = { /* uint32_t may be too big */
  {
    0x00005, 0x0000C, 0x0001E, 0x00012, 0x0000C, 0x00034, 0x00075, 0x00070,
    0x00000, 0x00008, 0x0001B, 0x00008, 0x0001D, 0x0007C, 0x000D6, 0x001DE,
    0x001AF, 0x00005, 0x0001B, 0x00026, 0x0001E, 0x00012, 0x00076, 0x0004D,
    0x001F6, 0x001F4, 0x00039, 0x0007F, 0x00027, 0x0006A, 0x00071, 0x00035,
    0x00071, 0x00068, 0x001DC, 0x00027, 0x00073, 0x000FF, 0x000E8, 0x000E9,
    0x0007E, 0x001F9, 0x001F5, 0x001FD, 0x0003E, 0x001CA, 0x003F9, 0x0004C,
    0x00069, 0x001FA, 0x001DF, 0x001F7, 0x00070, 0x001DD, 0x00E4D, 0x00727,
    0x00392, 0x001C8, 0x001CB, 0x003F8, 0x001AE, 0x001F8, 0x001FB, 0x0E4CE,
    0x0E4CF, 0x07260, 0x07261, 0x07262, 0x07263, 0x07264, 0x07265, 0x07266
  },
  {
    0x00007, 0x00001, 0x00007, 0x00016, 0x00001, 0x00045, 0x00018, 0x002B6,
    0x00006, 0x00004, 0x00017, 0x00010, 0x00029, 0x0002C, 0x0015A, 0x00066,
    0x0019E, 0x00009, 0x00028, 0x00017, 0x00000, 0x0002A, 0x00004, 0x0005B,
    0x000B5, 0x000CE, 0x00006, 0x00044, 0x0000F, 0x00046, 0x0000E, 0x000AC,
    0x00032, 0x00037, 0x011EB, 0x0000A, 0x0001A, 0x0011F, 0x00016, 0x00014,
    0x0002B, 0x00168, 0x00055, 0x023D5, 0x00057, 0x0002F, 0x00036, 0x0002E,
    0x00169, 0x00054, 0x0047B, 0x0019F, 0x02B7D, 0x0008E, 0x00ADE, 0x00479,
    0x0056E, 0x008F4, 0x015BF, 0x00478, 0x023D4, 0x0ADF1, 0x056F9, 0xADF0E,
    0xADF0F, 0x56F80, 0x56F81, 0x56F82, 0x56F83, 0x56F84, 0x56F85, 0x56F86
  },
  {
    0x00002, 0x00006, 0x00007, 0x0000D, 0x00007, 0x00030, 0x000FF, 0x001F0,
    0x00002, 0x00000, 0x00005, 0x00019, 0x0001E, 0x00007, 0x00063, 0x000FD,
    0x00023, 0x0000E, 0x0001B, 0x0001A, 0x00006, 0x00009, 0x00018, 0x000C5,
    0x00033, 0x001F1, 0x00002, 0x003FB, 0x001F3, 0x00022, 0x001FC, 0x00042,
    0x00623, 0x00083, 0x00620, 0x0007D, 0x00040, 0x00043, 0x003E4, 0x003E5,
    0x00191, 0x00FE9, 0x00105, 0x00208, 0x000FC, 0x00624, 0x00622, 0x00190,
    0x00626, 0x007F5, 0x00C4B, 0x01FD0, 0x0104D, 0x00065, 0x00C42, 0x000C9,
    0x00627, 0x00C43, 0x00C4A, 0x0104E, 0x01FD1, 0x0104F, 0x00412, 0x104CE,
    0x104CF, 0x08260, 0x08261, 0x08262, 0x08263, 0x08264, 0x08265, 0x08266
  },
  {
    0x0000D, 0x00001, 0x00004, 0x00000, 0x00017, 0x00005, 0x0007F, 0x0004D,
    0x00003, 0x00011, 0x0003E, 0x0003B, 0x00017, 0x00067, 0x0004A, 0x000C3,
    0x000F2, 0x0000A, 0x0002C, 0x00032, 0x0003D, 0x00015, 0x00028, 0x00093,
    0x000CC, 0x00096, 0x00003, 0x00075, 0x00020, 0x0002D, 0x00021, 0x00029,
    0x00090, 0x001D0, 0x001FB, 0x0001C, 0x0004C, 0x00060, 0x00009, 0x00008,
    0x0002D, 0x0009F, 0x001FA, 0x0013D, 0x00031, 0x000FC, 0x00058, 0x00092,
    0x000F0, 0x000F1, 0x000CD, 0x00185, 0x00165, 0x0004E, 0x00091, 0x000E9,
    0x00184, 0x001D1, 0x001E6, 0x00097, 0x001E7, 0x000B3, 0x0013C, 0x0164E,
    0x0164F, 0x00B20, 0x00B21, 0x00B22, 0x00B23, 0x00B24, 0x00B25, 0x00B26
  }
};

const uint8_t ff_vc1_1ref_mvdata_bits[4][72] = {
  {
     3,  4,  5,  5,  5,  6,  7,  7,  2,  4,  5,  5,  6,  7,  8,  9,  9,  4,
     6,  6,  6,  6,  7,  8,  9,  9,  6,  8,  7,  7,  7,  7,  8,  8,  9,  6,
     8,  8,  8,  8,  8,  9,  9,  9,  7, 10, 10,  8,  8,  9,  9,  9,  8,  9,
    13, 12, 11, 10, 10, 10,  9,  9,  9, 17, 17, 16, 16, 16, 16, 16, 16, 16
  },
  {
     3,  3,  4,  5,  5,  7,  8, 10,  3,  4,  5,  5,  6,  7,  9, 10, 12,  4,
     6,  6,  5,  6,  6,  8,  9, 11,  4,  7,  7,  7,  7,  8,  9,  9, 13,  5,
     8,  9,  8,  8,  9, 10, 10, 14,  7,  9,  9,  9, 10, 10, 11, 12, 14,  8,
    12, 11, 11, 12, 13, 11, 14, 16, 15, 20, 20, 19, 19, 19, 19, 19, 19, 19
  },
  {
     3,  4,  4,  4,  5,  6,  8,  9,  2,  4,  5,  5,  5,  6,  7,  8,  8,  4,
     7,  7,  6,  6,  7,  8,  8,  9,  5, 10,  9,  8,  9,  9, 11, 10, 11,  7,
     9,  9, 10, 10, 11, 12, 11, 12,  8, 11, 11, 11, 11, 11, 12, 13, 15,  9,
    12, 10, 11, 12, 12, 15, 13, 15, 13, 19, 19, 18, 18, 18, 18, 18, 18, 18
  },
  {
     4,  4,  4,  4,  5,  5,  7,  7,  3,  5,  6,  6,  6,  7,  7,  8,  8,  4,
     6,  6,  6,  6,  7,  8,  8,  8,  4,  7,  6,  6,  6,  7,  8,  9,  9,  5,
     7,  7,  6,  6,  7,  8,  9,  9,  6,  8,  8,  8,  8,  8,  8,  9, 10,  7,
     8,  8,  9,  9,  9,  8,  9,  9,  9, 14, 14, 13, 13, 13, 13, 13, 13, 13
  }
};

/* 2-reference tables */
const uint32_t ff_vc1_2ref_mvdata_codes[8][126] = { /* table 132 - table 139 */
  {
    0x0000C, 0x0001C, 0x0000B, 0x00000, 0x0000E, 0x0002A, 0x00050, 0x00368,
    0x00002, 0x0001A, 0x00004, 0x0003A, 0x0001D, 0x0006C, 0x000EF, 0x001BC,
    0x0015F, 0x0000F, 0x00003, 0x0001C, 0x0000D, 0x0000B, 0x0003E, 0x000A7,
    0x00146, 0x00199, 0x00006, 0x0001F, 0x00004, 0x0003C, 0x00007, 0x001BE,
    0x0008B, 0x0002C, 0x007B3, 0x00005, 0x000DB, 0x00056, 0x000EC, 0x00052,
    0x001BD, 0x00078, 0x000CF, 0x00573, 0x00009, 0x00023, 0x000ED, 0x00018,
    0x00006, 0x00044, 0x000F5, 0x00079, 0x006D2, 0x0006E, 0x0002B, 0x0015D,
    0x00017, 0x0037F, 0x00144, 0x000CE, 0x00028, 0x000AB, 0x00010, 0x001B5,
    0x000F7, 0x000A6, 0x0007B, 0x00028, 0x001ED, 0x001E9, 0x006FD, 0x00004,
    0x000F5, 0x00029, 0x0028A, 0x0028B, 0x0028F, 0x00DF9, 0x00335, 0x01E85,
    0x000EE, 0x002BD, 0x0002B, 0x003D8, 0x003D1, 0x00198, 0x001E9, 0x0051D,
    0x000B4, 0x0003F, 0x00455, 0x0022B, 0x00229, 0x00451, 0x00578, 0x007B2,
    0x00570, 0x00155, 0x00032, 0x003D0, 0x00054, 0x006D3, 0x00571, 0x00454,
    0x00334, 0x01BF1, 0x000B7, 0x00029, 0x01E84, 0x0016C, 0x0019B, 0x01BF0,
    0x00579, 0x00F43, 0x000B5, 0x008A1, 0x0002A, 0x0016D, 0x008A0, 0x007A0,
    0x003D1, 0x00AE5, 0x00154, 0x00AE4, 0x00A39, 0x00A38
  },
  {
    0x00003, 0x00009, 0x00016, 0x00010, 0x000D7, 0x00335, 0x00574, 0x00555,
    0x00000, 0x0001D, 0x00009, 0x00017, 0x0002C, 0x000AD, 0x00374, 0x006B3,
    0x00577, 0x0000F, 0x00018, 0x0000A, 0x0002E, 0x00022, 0x0017C, 0x00E7B,
    0x01B89, 0x015D8, 0x00008, 0x00034, 0x0006D, 0x00023, 0x001C2, 0x00376,
    0x002D3, 0x01C4A, 0x0330A, 0x00014, 0x0006A, 0x00072, 0x0006C, 0x000E3,
    0x0019B, 0x0073F, 0x01CF0, 0x00B41, 0x00032, 0x000E6, 0x000E0, 0x000CF,
    0x000AB, 0x0019C, 0x002AB, 0x00E2B, 0x015D9, 0x0006F, 0x001C3, 0x000AF,
    0x000BF, 0x000AC, 0x0017D, 0x006E3, 0x00E29, 0x01984, 0x00054, 0x000B5,
    0x0017A, 0x001AD, 0x00199, 0x00178, 0x00358, 0x002D2, 0x01C4B, 0x0005B,
    0x002A8, 0x00331, 0x00388, 0x0038B, 0x00370, 0x00713, 0x00CC3, 0x01CF1,
    0x001B9, 0x005EF, 0x00738, 0x002F2, 0x0033B, 0x002B9, 0x006EB, 0x00570,
    0x00E24, 0x0039D, 0x005A2, 0x005A3, 0x00E7D, 0x005EE, 0x00739, 0x00554,
    0x00AA5, 0x00AA4, 0x00377, 0x01CF5, 0x00BCE, 0x00E79, 0x00660, 0x00674,
    0x006EA, 0x00E7C, 0x00D65, 0x002F6, 0x015DA, 0x01B88, 0x005A1, 0x01CF4,
    0x005E6, 0x00E28, 0x00575, 0x00D64, 0x00334, 0x0330B, 0x015DB, 0x00B40,
    0x00BCF, 0x00DC5, 0x00E2A, 0x00675, 0x00571, 0x00553
  },
  {
    0x00004, 0x00002, 0x00010, 0x00003, 0x00017, 0x00045, 0x0003E, 0x0007E,
    0x00003, 0x00002, 0x00028, 0x0001E, 0x00015, 0x00047, 0x00002, 0x0014D,
    0x00060, 0x0000B, 0x00026, 0x00024, 0x00014, 0x00032, 0x0006F, 0x000C3,
    0x00531, 0x006E5, 0x00015, 0x0003F, 0x0002D, 0x00001, 0x0013E, 0x000DD,
    0x000F6, 0x00305, 0x00331, 0x0000E, 0x00003, 0x00034, 0x00033, 0x0001A,
    0x0014A, 0x000C5, 0x000F4, 0x006E4, 0x00001, 0x0003C, 0x0007D, 0x0008D,
    0x0009D, 0x00031, 0x0006E, 0x00296, 0x000CD, 0x00025, 0x00149, 0x00032,
    0x00089, 0x00036, 0x00088, 0x0006F, 0x00003, 0x0031D, 0x0000E, 0x001AA,
    0x0027E, 0x00061, 0x0014E, 0x0014F, 0x00067, 0x000FF, 0x00183, 0x00036,
    0x00357, 0x000F5, 0x000C6, 0x000C2, 0x00299, 0x00119, 0x00231, 0x00350,
    0x0002C, 0x0018F, 0x00530, 0x00297, 0x00004, 0x001B8, 0x000C0, 0x0027A,
    0x00311, 0x0009C, 0x00621, 0x00199, 0x0031C, 0x000F7, 0x003E3, 0x00356,
    0x00189, 0x00005, 0x0006B, 0x008C2, 0x00330, 0x004FF, 0x004F0, 0x00351,
    0x004F2, 0x001F2, 0x00373, 0x00000, 0x00C41, 0x008C3, 0x009EC, 0x003E2,
    0x00304, 0x004F7, 0x004F1, 0x001F0, 0x00148, 0x00C40, 0x009ED, 0x008C0,
    0x008C1, 0x004F3, 0x004FE, 0x000FE, 0x001F3, 0x001A9
  },
  {
    0x00000, 0x00004, 0x0002F, 0x00052, 0x00010, 0x000AD, 0x0050B, 0x00190,
    0x00003, 0x00016, 0x00007, 0x0000D, 0x000BB, 0x00173, 0x000C9, 0x0050F,
    0x0172C, 0x00003, 0x00011, 0x00005, 0x00043, 0x00023, 0x0004B, 0x0032E,
    0x02E5B, 0x00482, 0x00009, 0x0002A, 0x00014, 0x0002A, 0x00108, 0x005CA,
    0x0065A, 0x02136, 0x02132, 0x0000B, 0x00013, 0x00041, 0x000B8, 0x00174,
    0x00100, 0x014DA, 0x0404E, 0x01437, 0x0002B, 0x00085, 0x000A7, 0x000A0,
    0x0014C, 0x0029A, 0x0032C, 0x02133, 0x0142A, 0x00051, 0x00284, 0x000AC,
    0x00102, 0x00045, 0x00044, 0x0081B, 0x0065E, 0x00CB7, 0x00018, 0x0050C,
    0x00212, 0x002E4, 0x00203, 0x00094, 0x00122, 0x0081A, 0x00655, 0x00033,
    0x002BA, 0x00246, 0x00242, 0x00A6E, 0x0040C, 0x00808, 0x02134, 0x0404F,
    0x00175, 0x00405, 0x00247, 0x0012A, 0x00A14, 0x002BB, 0x00191, 0x0084F,
    0x01438, 0x000AF, 0x00B97, 0x00483, 0x0143B, 0x0032B, 0x00243, 0x0142B,
    0x00958, 0x029BF, 0x00049, 0x00A6C, 0x014DB, 0x004AD, 0x014DE, 0x0084E,
    0x01434, 0x00257, 0x02E5A, 0x00207, 0x01435, 0x01439, 0x00CB6, 0x0143A,
    0x00194, 0x00654, 0x02135, 0x0537C, 0x0015C, 0x00240, 0x01012, 0x0537D,
    0x00959, 0x01098, 0x01436, 0x0065F, 0x02026, 0x02137
  },
  {
    0x00005, 0x00019, 0x00016, 0x00011, 0x0003E, 0x0005E, 0x000EF, 0x000E2,
    0x00000, 0x00039, 0x0002B, 0x00026, 0x00028, 0x00012, 0x000C2, 0x000ED,
    0x0011D, 0x0000D, 0x00031, 0x0002A, 0x00025, 0x00020, 0x0005C, 0x001ED,
    0x0024D, 0x00770, 0x00006, 0x0007A, 0x00060, 0x0004F, 0x00048, 0x00039,
    0x00186, 0x00213, 0x00EC6, 0x0000F, 0x00026, 0x0005F, 0x00075, 0x00070,
    0x00027, 0x001DB, 0x003C6, 0x0078F, 0x0003F, 0x000A6, 0x000F0, 0x0003A,
    0x00052, 0x0004E, 0x000E3, 0x001D9, 0x0030F, 0x00010, 0x001DD, 0x000A7,
    0x000F7, 0x00022, 0x00092, 0x003C4, 0x002EF, 0x00762, 0x00079, 0x0008F,
    0x001DA, 0x00087, 0x000E8, 0x000BA, 0x00176, 0x000EE, 0x003B0, 0x00085,
    0x00119, 0x0030E, 0x00108, 0x001D2, 0x0010C, 0x00773, 0x00424, 0x00434,
    0x00071, 0x005DD, 0x001C1, 0x003A7, 0x00127, 0x0008D, 0x0021B, 0x007B2,
    0x001DF, 0x003D8, 0x00764, 0x00EE4, 0x003B3, 0x0074D, 0x001D8, 0x005DC,
    0x0084A, 0x00499, 0x003C5, 0x01D8E, 0x00765, 0x00435, 0x00771, 0x001C2,
    0x00118, 0x003BC, 0x00381, 0x00387, 0x07B33, 0x01097, 0x01096, 0x01ECD,
    0x00E99, 0x00F1C, 0x00F1D, 0x00EE5, 0x0011C, 0x07B32, 0x03D98, 0x01D8F,
    0x00E98, 0x00F67, 0x003BD, 0x00380, 0x00498, 0x00386
  },
  {
    0x0000D, 0x00010, 0x0002E, 0x00039, 0x0000D, 0x00074, 0x000ED, 0x000B6,
    0x00001, 0x00002, 0x00000, 0x00030, 0x00029, 0x00070, 0x000F3, 0x0008C,
    0x00166, 0x00009, 0x00033, 0x00078, 0x00006, 0x000C4, 0x0000B, 0x00163,
    0x000CC, 0x005BE, 0x0001F, 0x0002F, 0x00064, 0x00018, 0x000C6, 0x0000A,
    0x00162, 0x002C0, 0x00EF3, 0x00007, 0x0000F, 0x000E3, 0x000CA, 0x000B2,
    0x0018F, 0x003AE, 0x0075F, 0x00C51, 0x00015, 0x00047, 0x000EE, 0x000E2,
    0x000EA, 0x00009, 0x0016A, 0x002C3, 0x0059D, 0x0003D, 0x00008, 0x001D9,
    0x00032, 0x0000E, 0x0016E, 0x0032C, 0x0065B, 0x0196B, 0x00002, 0x0000F,
    0x001D8, 0x0008D, 0x000B4, 0x001E4, 0x00067, 0x00317, 0x00794, 0x00022,
    0x003BE, 0x00315, 0x00034, 0x00037, 0x002DE, 0x0006C, 0x00EFE, 0x0066C,
    0x00028, 0x003CB, 0x003AC, 0x00035, 0x0016B, 0x003BD, 0x002C1, 0x0062C,
    0x01DFE, 0x0000E, 0x0059E, 0x005BF, 0x000DA, 0x00629, 0x00584, 0x00EB7,
    0x00B0A, 0x0066D, 0x0000C, 0x0077E, 0x0059C, 0x00778, 0x0075E, 0x0075A,
    0x0062D, 0x00337, 0x00334, 0x00197, 0x01E57, 0x01DE4, 0x0196A, 0x01E56,
    0x00C50, 0x00B3F, 0x01E54, 0x00B0B, 0x0018E, 0x001B6, 0x01E55, 0x00CB4,
    0x00B3E, 0x00EB6, 0x01DE5, 0x01DFF, 0x00335, 0x001B7
  },
  {
    0x00001, 0x0000B, 0x00019, 0x0006F, 0x0002A, 0x00075, 0x007EB, 0x00163,
    0x00001, 0x0000E, 0x0001A, 0x0003E, 0x0001C, 0x0002D, 0x00164, 0x007EC,
    0x00165, 0x00004, 0x00006, 0x00036, 0x0007F, 0x000AE, 0x00158, 0x0015C,
    0x0056D, 0xFD510, 0x00000, 0x00004, 0x0007B, 0x000F3, 0x0003B, 0x007ED,
    0x002B3, 0x002CC, 0x0056E, 0x00018, 0x0003E, 0x00017, 0x0001E, 0x000AF,
    0x003F7, 0x0056F, 0x002CD, 0xFD511, 0x00014, 0x000AD, 0x000AA, 0x00014,
    0x000A8, 0x00153, 0x000E8, 0x001FE, 0x00DCF, 0x00078, 0x001B8, 0x00152,
    0x000FE, 0x002B1, 0x0015D, 0x00160, 0xFD512, 0xFD513, 0x0007A, 0x002B0,
    0x001E5, 0x000E9, 0x000FC, 0x006E6, 0x00DC8, 0x00584, 0xFD514, 0x000AB,
    0x00DDE, 0x00159, 0x003F4, 0x00DC9, 0x00DCA, 0x001FA, 0xFD515, 0xFD516,
    0x000FC, 0x001FF, 0x001E4, 0x000AF, 0x0015A, 0x00167, 0x00DCB, 0x00585,
    0xFD517, 0x003F7, 0x03F55, 0xFD518, 0x00DDC, 0x00586, 0x03F56, 0xFD519,
    0x03F57, 0xFD51A, 0x001BA, 0x00587, 0x00588, 0x00DDF, 0x002B2, 0xFD51B,
    0x00DCE, 0x003F6, 0xFD51C, 0x00FD4, 0xFD51D, 0xFD51E, 0xFD51F, 0x7EA80,
    0x7EA81, 0x0056C, 0x7EA82, 0x7EA83, 0x00376, 0x00589, 0x0058A, 0x7EA84,
    0x7EA85, 0x00DDD, 0x7EA86, 0x7EA87, 0x0058B, 0x07EA9
  },
  {
    0x00003, 0x0000E, 0x0000F, 0x0007E, 0x00062, 0x000C6, 0x00CD9, 0x0063E,
    0x00002, 0x00002, 0x00000, 0x00018, 0x0000C, 0x00069, 0x00039, 0x00707,
    0x00C7E, 0x00002, 0x0000D, 0x0001B, 0x0000F, 0x0019A, 0x00647, 0x01A37,
    0x346C4, 0x0346D, 0x00001, 0x0001E, 0x0007F, 0x0000A, 0x000E1, 0x00661,
    0x00CE4, 0x346C5, 0x346C6, 0x0001D, 0x00030, 0x0000D, 0x000CB, 0x00199,
    0x00320, 0x0008E, 0x0652E, 0x346C7, 0x0003E, 0x00039, 0x00035, 0x00033,
    0x0019F, 0x001C0, 0x00CDA, 0x346C8, 0x346C9, 0x0000B, 0x000D0, 0x0019E,
    0x00022, 0x00038, 0x0018E, 0x0031E, 0x03294, 0x0023C, 0x00032, 0x00012,
    0x00013, 0x00071, 0x0019D, 0x00020, 0x00C87, 0x00CC0, 0x346CA, 0x00338,
    0x00653, 0x001A2, 0x0032A, 0x00322, 0x00CE7, 0x00084, 0x0011F, 0x346CB,
    0x00325, 0x00649, 0x0032B, 0x00077, 0x00648, 0x00642, 0x00C86, 0x00C8C,
    0x346CC, 0x0003A, 0x019B7, 0x00043, 0x00327, 0x0008C, 0x0008D, 0x00C8D,
    0x346CD, 0x346CE, 0x00337, 0x00CE5, 0x00085, 0x00326, 0x00347, 0x00CA4,
    0x00C7F, 0x00D1A, 0x346CF, 0x00328, 0x1A360, 0x1A361, 0x00CD8, 0x0068C,
    0x03295, 0x03296, 0x0652F, 0x066D8, 0x00331, 0x00706, 0x0023D, 0x00076,
    0x00CC1, 0x00382, 0x00CE6, 0x066D9, 0x066DA, 0x066DB
  }
};

const uint8_t ff_vc1_2ref_mvdata_bits[8][126] = {
  {
     4,  5,  5,  5,  6,  7,  8, 10,  2,  5,  5,  6,  6,  7,  8,  9,
    10,  4,  5,  6,  6,  7,  8,  9, 10, 11,  4,  6,  6,  7,  7,  9,
     9, 10, 12,  5,  8,  8,  8,  8,  9,  9, 10, 12,  5,  7,  8,  7,
     7,  8,  9,  9, 11,  7,  9, 10,  9, 10, 10, 10, 10, 12,  6,  9,
     9,  9,  9,  9, 10, 10, 11,  7, 10, 10, 11, 11, 11, 12, 12, 14,
     8, 11, 10, 11, 11, 11, 11, 12, 12,  8, 12, 11, 11, 12, 12, 12,
    12, 13,  8, 12, 11, 11, 12, 12, 12, 13, 12,  9, 14, 13, 11, 13,
    12, 13, 12, 13,  9, 13, 13, 12, 12, 13, 13, 13, 13, 13
  },
  {
     3,  4,  5,  6,  8, 10, 11, 11,  2,  5,  5,  6,  7,  8, 10, 11,
    11,  4,  5,  5,  6,  7,  9, 12, 13, 13,  4,  6,  7,  7,  9, 10,
    11, 13, 14,  5,  7,  7,  7,  8,  9, 11, 13, 13,  6,  8,  8,  8,
     8,  9, 10, 12, 13,  7,  9,  8,  8,  8,  9, 11, 12, 13,  7,  9,
     9,  9,  9,  9, 10, 11, 13,  8, 10, 10, 10, 10, 10, 11, 12, 13,
     9, 11, 11, 10, 10, 10, 11, 11, 12, 10, 12, 12, 12, 11, 11, 11,
    12, 12, 10, 13, 12, 12, 11, 11, 11, 12, 12, 10, 13, 13, 12, 13,
    11, 12, 11, 12, 10, 14, 13, 13, 12, 12, 12, 11, 11, 11
  },
  {
     4,  4,  5,  5,  6,  7,  8,  9,  2,  5,  6,  6,  6,  7,  7,  9,
     9,  4,  6,  6,  6,  7,  8,  9, 11, 12,  5,  7,  7,  7,  9,  9,
    10, 11, 12,  5,  7,  7,  7,  7,  9,  9, 10, 12,  5,  8,  8,  8,
     8,  8,  9, 10, 10,  6,  9,  8,  8,  8,  8,  9,  9, 11,  6, 10,
    10,  9,  9,  9,  9, 10, 10,  7, 11, 10,  9,  9, 10,  9, 10, 11,
     7, 10, 11, 10, 10, 10,  9, 10, 11,  8, 12, 11, 11, 10, 11, 11,
    10, 10,  8, 12, 12, 11, 11, 11, 11, 10, 11,  8, 13, 12, 12, 11,
    11, 11, 11, 10,  9, 13, 12, 12, 12, 11, 11, 10, 10, 10
  },
  {
     3,  4,  6,  7,  7,  9, 11, 11,  2,  5,  5,  6,  8,  9, 10, 11,
    13,  3,  5,  5,  7,  8,  9, 12, 14, 13,  4,  6,  6,  7,  9, 11,
    13, 14, 14,  5,  7,  7,  8,  9,  9, 13, 15, 13,  6,  8,  8,  8,
     9, 10, 12, 14, 13,  7, 10,  9,  9,  9,  9, 12, 13, 14,  7, 11,
    10, 10, 10, 10, 11, 12, 13,  8, 11, 12, 12, 12, 11, 12, 14, 15,
     9, 11, 12, 11, 12, 11, 11, 12, 13,  9, 12, 13, 13, 12, 12, 13,
    14, 14,  9, 12, 13, 13, 13, 12, 13, 12, 14, 10, 13, 13, 14, 13,
    11, 13, 14, 15, 10, 12, 13, 15, 14, 13, 13, 13, 14, 14
  },
  {
     4,  5,  5,  5,  6,  7,  8,  8,  2,  6,  6,  6,  6,  6,  8,  9,
    10,  4,  6,  6,  6,  6,  7,  9, 10, 11,  4,  7,  7,  7,  7,  7,
     9, 10, 12,  5,  7,  7,  7,  7,  7,  9, 10, 11,  6,  8,  8,  7,
     7,  7,  8,  9, 10,  6,  9,  8,  8,  7,  8, 10, 10, 11,  7,  9,
     9,  8,  8,  8,  9,  9, 10,  8, 10, 10,  9,  9,  9, 11, 11, 11,
     8, 11, 10, 10,  9,  9, 10, 11, 10, 10, 12, 12, 11, 11, 10, 11,
    12, 11, 10, 13, 12, 11, 11, 10, 10, 11, 11, 11, 15, 13, 13, 13,
    12, 12, 12, 12, 10, 15, 14, 13, 12, 12, 11, 11, 11, 11
  },
  {
     4,  5,  6,  6,  6,  7,  8,  8,  2,  4,  5,  6,  6,  7,  8,  8,
     9,  4,  6,  7,  7,  8,  8,  9, 10, 11,  5,  6,  7,  7,  8,  8,
     9, 10, 12,  5,  7,  8,  8,  8,  9, 10, 11, 12,  5,  7,  8,  8,
     8,  8,  9, 10, 11,  6,  8,  9,  8,  8,  9, 10, 11, 13,  5,  8,
     9,  8,  8,  9,  9, 10, 11,  6, 10, 10,  9,  9, 10, 10, 12, 13,
     6, 10, 10,  9,  9, 10, 10, 11, 13,  7, 11, 11, 11, 11, 11, 12,
    12, 13,  7, 11, 11, 11, 11, 11, 11, 12, 12,  9, 13, 13, 13, 13,
    12, 12, 13, 12,  9, 12, 13, 12, 12, 12, 13, 13, 12, 12
  },
  {
     3,  5,  6,  8,  9, 10, 12, 12,  1,  5,  6,  7,  8,  9, 12, 12,
    12,  4,  6,  7,  8,  9, 12, 12, 14, 21,  4,  6,  8,  9,  9, 12,
    13, 13, 14,  6,  9,  8,  8,  9, 13, 14, 13, 21,  6,  9,  9,  8,
     9, 10, 11, 12, 13,  8, 10, 10, 11, 11, 12, 12, 21, 21,  8, 11,
    10, 11, 11, 12, 13, 14, 21,  9, 13, 10, 11, 13, 13, 12, 21, 21,
     9, 12, 10, 11, 12, 12, 13, 14, 21, 11, 15, 21, 13, 14, 15, 21,
    15, 21, 10, 14, 14, 13, 13, 21, 13, 13, 21, 13, 21, 21, 21, 20,
    20, 14, 20, 20, 11, 14, 14, 20, 20, 13, 20, 20, 14, 16
  },
  {
     2,  5,  6,  8,  9, 10, 13, 13,  2,  4,  5,  6,  8,  9, 10, 13,
    14,  3,  5,  7,  8, 10, 12, 15, 20, 16,  4,  6,  8,  8, 10, 12,
    13, 20, 20,  7,  8,  8,  9, 10, 11, 12, 16, 20,  7,  8,  8,  8,
    10, 11, 13, 20, 20,  8, 10, 10, 10, 10, 11, 12, 15, 14,  8,  9,
     9,  9, 10, 10, 13, 13, 20, 11, 12, 11, 11, 11, 13, 12, 13, 20,
    11, 12, 11, 11, 12, 12, 13, 13, 20, 10, 14, 11, 11, 12, 12, 13,
    20, 20, 11, 13, 12, 11, 12, 13, 14, 14, 20, 11, 19, 19, 13, 13,
    15, 15, 16, 16, 11, 13, 14, 11, 13, 12, 13, 16, 16, 16
  }
};

const uint8_t ff_wmv3_dc_scale_table[32] = {
     0,  2,  4,  8,  8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13,
    14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21
};

/* P-Picture CBPCY VLC tables */
// Looks like original tables are not conforming to standard at all. Are they used for old WMV?
const uint16_t ff_vc1_cbpcy_p_codes[4][64] = {
  {
      0,   6,  15,  13,  13,  11,   3,  13,   5,   8,  49,  10,  12, 114, 102, 119,
      1,  54,  96,   8,  10, 111,   5,  15,  12,  10,   2,  12,  13, 115,  53,  63,
      1,   7,   1,   7,  14,  12,   4,  14,   1,   9,  97,  11,   7,  58,  52,  62,
      4, 103,   1,   9,  11,  56, 101, 118,   4, 110, 100,  30,   2,   5,   4,   3
  },
  {
      0,   9,   1,  18,   5,  14, 237,  26,   3, 121,   3,  22,  13,  16,   6,  30,
      2,  10,   1,  20,  12, 241,   5,  28,  16,  12,   3,  24,  28, 124, 239, 247,
      1, 240,   1,  19,  18,  15,   4,  27,   1, 122,   2,  23,   1,  17,   7,  31,
      1,  11,   2,  21,  19, 246, 238,  29,  17,  13, 236,  25,  58,  63,   8, 125
  },
  {
      0, 201,  25, 231,   5, 221,   1,   3,   2, 414,   2, 241,  16, 225, 195, 492,
      2, 412,   1, 240,   7, 224,  98, 245,   1, 220,  96,   5,   9, 230, 101, 247,
      1, 102,   1, 415,  24,   3,   2, 244,   3,  54,   3, 484,  17, 114, 200, 493,
      3, 413,   1,   4,  13, 113,  99, 485,   4, 111, 194, 243,   5,  29,  26,  31
  },
  {
      0,  28,  12,  44,   3,  36,  20,  52,   2,  32,  16,  48,   8,  40,  24,  28,
      1,  30,  14,  46,   6,  38,  22,  54,   3,  34,  18,  50,  10,  42,  26,  30,
      1,  29,  13,  45,   5,  37,  21,  53,   2,  33,  17,  49,   9,  41,  25,  29,
      1,  31,  15,  47,   7,  39,  23,  55,   4,  35,  19,  51,  11,  43,  27,  31
   }
};

const uint8_t ff_vc1_cbpcy_p_bits[4][64] = {
  {
    13,  13,   7,  13,   7,  13,  13,  12,   6,  13,   7,  12,   6,   8,   8,   8,
     5,   7,   8,  12,   6,   8,  13,  12,   7,  13,  13,  12,   6,   8,   7,   7,
     6,  13,   8,  12,   7,  13,  13,  12,   7,  13,   8,  12,   5,   7,   7,   7,
     6,   8,  13,  12,   6,   7,   8,   8,   5,   8,   8,   6,   3,   3,   3,   2
  },
  {
    14,  13,   8,  13,   3,  13,   8,  13,   3,   7,   8,  13,   4,  13,  13,  13,
     3,  13,  13,  13,   4,   8,  13,  13,   5,  13,  13,  13,   5,   7,   8,   8,
     3,   8,  14,  13,   5,  13,  13,  13,   4,   7,  13,  13,   6,  13,  13,  13,
     5,  13,   8,  13,   5,   8,   8,  13,   5,  13,   8,  13,   6,   6,  13,   7
  },
  {
    13,   8,   6,   8,   4,   8,  13,  12,   4,   9,   8,   8,   5,   8,   8,   9,
     5,   9,  10,   8,   4,   8,   7,   8,   6,   8,   7,  13,   4,   8,   7,   8,
     5,   7,   8,   9,   6,  13,  13,   8,   4,   6,   8,   9,   5,   7,   8,   9,
     5,   9,   9,  13,   5,   7,   7,   9,   4,   7,   8,   8,   3,   5,   5,   5
  },
  {
     9,   9,   9,   9,   2,   9,   9,   9,   2,   9,   9,   9,   9,   9,   9,   8,
     3,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   8,
     2,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   8,
     9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   8
  }
};

/* Interlaced CBPCY VLC tables (Table 124 - Table 131) */
const uint16_t ff_vc1_icbpcy_p_codes[8][63] = {
  {
    0x2F1A, 0x2F1B, 0x178C, 0x0090, 0x02A8, 0x02A9, 0x0BC7, 0x0091,
    0x02AA, 0x02AB, 0x05E0, 0x004A, 0x0096, 0x0097, 0x00BD, 0x0092,
    0x02AC, 0x02AD, 0x05E1, 0x0098, 0x0132, 0x0133, 0x0179, 0x0134,
    0x026A, 0x026B, 0x02FC, 0x004E, 0x0040, 0x0041, 0x002B, 0x0093,
    0x02AE, 0x02AF, 0x05E2, 0x0136, 0x026E, 0x026F, 0x02FD, 0x009E,
    0x013E, 0x013F, 0x017F, 0x0050, 0x0042, 0x0043, 0x002C, 0x0051,
    0x00A4, 0x00A5, 0x00BE, 0x0053, 0x0044, 0x0045, 0x002D, 0x0054,
    0x0046, 0x0047, 0x002E, 0x0003, 0x0000, 0x0001, 0x0001
  },
  {
    0x0041, 0x0042, 0x0100, 0x0043, 0x0088, 0x0089, 0x0101, 0x0045,
    0x008C, 0x008D, 0x0102, 0x0010, 0x0022, 0x0023, 0x0024, 0x0047,
    0x0010, 0x0011, 0x0103, 0x0025, 0x0058, 0x0059, 0x005A, 0x005B,
    0x005A, 0x005B, 0x005C, 0x000C, 0x0030, 0x0031, 0x0019, 0x0009,
    0x0014, 0x0015, 0x002C, 0x005C, 0x005D, 0x005E, 0x005F, 0x0026,
    0x005D, 0x005E, 0x005F, 0x000D, 0x0034, 0x0035, 0x001B, 0x0014,
    0x0027, 0x002A, 0x002B, 0x000E, 0x0038, 0x0039, 0x001D, 0x000F,
    0x003C, 0x003D, 0x001F, 0x0005, 0x0009, 0x0000, 0x0003
  },
  {
    0x0032, 0x0033, 0x001A, 0x0026, 0x00E4, 0x00E5, 0x01E6, 0x0027,
    0x00E6, 0x00E7, 0x01E7, 0x000E, 0x0063, 0x006C, 0x0077, 0x0028,
    0x00E8, 0x00E9, 0x01E8, 0x007B, 0x00DA, 0x00DB, 0x00EC, 0x00F5,
    0x01B8, 0x01B9, 0x01DA, 0x0021, 0x004B, 0x0054, 0x002B, 0x0029,
    0x00EA, 0x00EB, 0x01E9, 0x004A, 0x01BA, 0x01BB, 0x01DB, 0x0020,
    0x00DE, 0x00DF, 0x00F2, 0x0022, 0x0055, 0x0058, 0x002D, 0x000F,
    0x0070, 0x0071, 0x0078, 0x0023, 0x0059, 0x005C, 0x002F, 0x0024,
    0x005D, 0x0062, 0x0030, 0x0002, 0x001F, 0x0006, 0x0000
  },
  {
    0x0028, 0x0029, 0x009D, 0x0000, 0x01EA, 0x01EB, 0x01EC, 0x0001,
    0x01ED, 0x01EE, 0x01EF, 0x0005, 0x00F0, 0x00F1, 0x003B, 0x0002,
    0x01F0, 0x01F1, 0x01F2, 0x003F, 0x015C, 0x015D, 0x0099, 0x0010,
    0x03D0, 0x03D1, 0x0130, 0x000F, 0x009E, 0x009F, 0x00FB, 0x0003,
    0x01F3, 0x01F4, 0x01F5, 0x0011, 0x03D2, 0x03D3, 0x0131, 0x0009,
    0x015E, 0x015F, 0x009C, 0x0010, 0x00A8, 0x00A9, 0x0038, 0x0006,
    0x00F2, 0x00F3, 0x004D, 0x0011, 0x00AA, 0x00AB, 0x0039, 0x0012,
    0x00AC, 0x00AD, 0x003A, 0x0006, 0x0016, 0x0017, 0x000E
  },
  {
    0x003C, 0x003D, 0x001F, 0x000A, 0x0061, 0x0062, 0x0002, 0x000B,
    0x0063, 0x0064, 0x0003, 0x0007, 0x0003, 0x0004, 0x000B, 0x000C,
    0x0065, 0x0066, 0x0004, 0x0012, 0x000A, 0x000B, 0x0014, 0x001B,
    0x0018, 0x0019, 0x0034, 0x002C, 0x0067, 0x0068, 0x0035, 0x000D,
    0x0069, 0x006C, 0x0005, 0x0060, 0x001A, 0x001B, 0x0035, 0x0013,
    0x000E, 0x000F, 0x0015, 0x002D, 0x006D, 0x006E, 0x0038, 0x0008,
    0x0008, 0x0009, 0x000C, 0x002E, 0x006F, 0x0072, 0x003A, 0x002F,
    0x0073, 0x0000, 0x003B, 0x0007, 0x0014, 0x0015, 0x0004
  },
  {
    0x0038, 0x0039, 0x009D, 0x000A, 0x0091, 0x0092, 0x0093, 0x000B,
    0x0094, 0x0095, 0x0096, 0x0003, 0x00EE, 0x00EF, 0x0036, 0x000C,
    0x0097, 0x0098, 0x0099, 0x0008, 0x01E4, 0x01E5, 0x006A, 0x0018,
    0x03CC, 0x03CD, 0x00D6, 0x000E, 0x009E, 0x009F, 0x00F5, 0x000D,
    0x009A, 0x009B, 0x009C, 0x0019, 0x03CE, 0x03CF, 0x00D7, 0x0009,
    0x01E8, 0x01E9, 0x0090, 0x000F, 0x00E8, 0x00E9, 0x00F6, 0x0005,
    0x00F0, 0x00F1, 0x0037, 0x0010, 0x00EA, 0x00EB, 0x00F7, 0x0011,
    0x00EC, 0x00ED, 0x0034, 0x0000, 0x003E, 0x003F, 0x0002
  },
  {
    0x003C, 0x003D, 0x01CF, 0x0000, 0x00BF, 0x00E0, 0x01FC, 0x0001,
    0x00E1, 0x00E2, 0x01FD, 0x0009, 0x01F1, 0x01F2, 0x01F3, 0x0002,
    0x00E3, 0x00E4, 0x01FE, 0x0011, 0x03EE, 0x03EF, 0x03F0, 0x0021,
    0x07E2, 0x07E3, 0x07E4, 0x0018, 0x03F7, 0x03FE, 0x03FF, 0x0003,
    0x00E5, 0x00E6, 0x0080, 0x002E, 0x07E5, 0x07E6, 0x07E7, 0x0016,
    0x03F4, 0x03F5, 0x03F6, 0x0019, 0x0102, 0x0103, 0x0104, 0x000A,
    0x01F4, 0x01F5, 0x01F6, 0x001A, 0x0105, 0x0106, 0x0107, 0x001B,
    0x0178, 0x0179, 0x01CE, 0x001D, 0x00BD, 0x00BE, 0x01F0
  },
  {
    0x0003, 0x0004, 0x01B6, 0x0004, 0x002E, 0x002F, 0x000E, 0x0005,
    0x0030, 0x0031, 0x000F, 0x0003, 0x000A, 0x000B, 0x0014, 0x0006,
    0x0032, 0x0033, 0x0010, 0x0005, 0x0030, 0x0031, 0x0032, 0x0009,
    0x0066, 0x0067, 0x0068, 0x001D, 0x01B7, 0x01B8, 0x01B9, 0x0007,
    0x0034, 0x0035, 0x0011, 0x0016, 0x0069, 0x006A, 0x006B, 0x000A,
    0x0036, 0x0037, 0x00D8, 0x001E, 0x01BA, 0x01BB, 0x01BC, 0x0004,
    0x0015, 0x0016, 0x0017, 0x001F, 0x01BD, 0x01BE, 0x01BF, 0x0000,
    0x0010, 0x0011, 0x0012, 0x001C, 0x00D9, 0x00DA, 0x0013
  }
};

const uint8_t ff_vc1_icbpcy_p_bits[8][63] = {
  {
    15, 15, 14,  9, 11, 11, 13,  9, 11, 11, 12,  8,  9,  9,  9,  9,
    11, 11, 12,  9, 10, 10, 10, 10, 11, 11, 11,  8,  8,  8,  7,  9,
    11, 11, 12, 10, 11, 11, 11,  9, 10, 10, 10,  8,  8,  8,  7,  8,
     9,  9,  9,  8,  8,  8,  7,  8,  8,  8,  7,  3,  3,  3,  1
  },
  {
     7,  7,  9,  7,  8,  8,  9,  7,  8,  8,  9,  6,  7,  7,  7,  7,
     7,  7,  9,  7,  8,  8,  8,  8,  9,  9,  9,  6,  7,  7,  6,  6,
     7,  7,  8,  8,  9,  9,  9,  7,  8,  8,  8,  6,  7,  7,  6,  6,
     7,  7,  7,  6,  7,  7,  6,  6,  7,  7,  6,  3,  4,  3,  2
  },
  {
     6,  6,  5,  6,  8,  8,  9,  6,  8,  8,  9,  5,  7,  7,  7,  6,
     8,  8,  9,  7,  8,  8,  8,  8,  9,  9,  9,  6,  7,  7,  6,  6,
     8,  8,  9,  7,  9,  9,  9,  6,  8,  8,  8,  6,  7,  7,  6,  5,
     7,  7,  7,  6,  7,  7,  6,  6,  7,  7,  6,  3,  5,  4,  2
  },
  {
     6,  6,  8,  4,  9,  9,  9,  4,  9,  9,  9,  4,  8,  8,  7,  4,
     9,  9,  9,  6,  9,  9,  8,  6, 10, 10,  9,  5,  8,  8,  8,  4,
     9,  9,  9,  6, 10, 10,  9,  5,  9,  9,  8,  5,  8,  8,  7,  4,
     8,  8,  7,  5,  8,  8,  7,  5,  8,  8,  7,  3,  5,  5,  4
  },
  {
     6,  6,  5,  5,  7,  7,  7,  5,  7,  7,  7,  5,  6,  6,  6,  5,
     7,  7,  7,  6,  7,  7,  7,  7,  8,  8,  8,  6,  7,  7,  6,  5,
     7,  7,  7,  7,  8,  8,  8,  6,  7,  7,  7,  6,  7,  7,  6,  5,
     6,  6,  6,  6,  7,  7,  6,  6,  7,  6,  6,  4,  5,  5,  3
  },
  {
     6,  6,  8,  4,  8,  8,  8,  4,  8,  8,  8,  4,  8,  8,  7,  4,
     8,  8,  8,  5,  9,  9,  8,  6, 10, 10,  9,  5,  8,  8,  8,  4,
     8,  8,  8,  6, 10, 10,  9,  5,  9,  9,  8,  5,  8,  8,  8,  4,
     8,  8,  7,  5,  8,  8,  8,  5,  8,  8,  7,  3,  6,  6,  4
  },
  {
     6,  6,  9,  3,  8,  8,  9,  3,  8,  8,  9,  4,  9,  9,  9,  3,
     8,  8,  9,  5, 10, 10, 10,  6, 11, 11, 11,  5, 10, 10, 10,  3,
     8,  8,  8,  6, 11, 11, 11,  5, 10, 10, 10,  5,  9,  9,  9,  4,
     9,  9,  9,  5,  9,  9,  9,  5,  9,  9,  9,  5,  8,  8,  9
  },
  {
     6,  6, 10,  3,  7,  7,  7,  3,  7,  7,  7,  4,  8,  8,  8,  3,
     7,  7,  7,  5,  9,  9,  9,  6, 10, 10, 10,  6, 10, 10, 10,  3,
     7,  7,  7,  6, 10, 10, 10,  5,  9,  9,  9,  6, 10, 10, 10,  4,
     8,  8,  8,  6, 10, 10, 10,  5,  9,  9,  9,  6,  9,  9,  9
  }
};

/* MacroBlock Transform Type: 7.1.3.11, p89
 * 8x8:B
 * 8x4:B:btm  8x4:B:top  8x4:B:both,
 * 4x8:B:right  4x8:B:left  4x8:B:both
 * 4x4:B  8x8:MB
 * 8x4:MB:btm  8x4:MB:top  8x4,MB,both
 * 4x8,MB,right  4x8,MB,left
 * 4x4,MB                               */
const uint16_t ff_vc1_ttmb_codes[3][16] = {
  {
    0x0003,
    0x002E, 0x005F, 0x0000,
    0x0016, 0x0015, 0x0001,
    0x0004, 0x0014,
    0x02F1, 0x0179, 0x017B,
    0x0BC0, 0x0BC1, 0x05E1,
    0x017A
  },
  {
    0x0006,
    0x0006, 0x0003, 0x0007,
    0x000F, 0x000E, 0x0000,
    0x0002, 0x0002,
    0x0014, 0x0011, 0x000B,
    0x0009, 0x0021, 0x0015,
    0x0020
  },
  {
    0x0006,
    0x0000, 0x000E, 0x0005,
    0x0002, 0x0003, 0x0003,
    0x000F, 0x0002,
    0x0081, 0x0021, 0x0009,
    0x0101, 0x0041, 0x0011,
    0x0100
  }
};

const uint8_t ff_vc1_ttmb_bits[3][16] = {
  {
     2,
     6,  7,  2,
     5,  5,  2,
     3,  5,
    10,  9,  9,
    12, 12, 11,
     9
  },
  {
    3,
    4, 4, 4,
    4, 4, 3,
    3, 2,
    7, 7, 6,
    6, 8, 7,
    8
  },
  {
     3,
     3, 4, 5,
     3, 3, 4,
     4, 2,
    10, 8, 6,
    11, 9, 7,
    11
  }
};

/* TTBLK (Transform Type per Block) tables */
const uint8_t ff_vc1_ttblk_codes[3][8] = {
    {  0,  1,  3,  5, 16, 17, 18, 19 },
    {  3,  0,  1,  2,  3,  5,  8,  9 },
    {  1,  0,  1,  4,  6,  7, 10, 11 }
};
const uint8_t ff_vc1_ttblk_bits[3][8] = {
    {  2,  2,  2,  3,  5,  5,  5,  5 },
    {  2,  3,  3,  3,  3,  3,  4,  4 },
    {  2,  3,  3,  3,  3,  3,  4,  4 }
};

/* SUBBLKPAT tables, p93-94, reordered */
const uint8_t ff_vc1_subblkpat_codes[3][15] = {
    { 14, 12,  7, 11,  9, 26,  2, 10, 27,  8,  0,  6,  1, 15,  1 },
    { 14,  0,  8, 15, 10,  4, 23, 13,  5,  9, 25,  3, 24, 22,  1 },
    {  5,  6,  2,  2,  8,  0, 28,  3,  1,  3, 29,  1, 19, 18, 15 }
};
const uint8_t ff_vc1_subblkpat_bits[3][15] = {
    {  5,  5,  5,  5,  5,  6,  4,  5,  6,  5,  4,  5,  4,  5,  1},
    {  4,  3,  4,  4,  4,  5,  5,  4,  5,  4,  5,  4,  5,  5,  2},
    {  3,  3,  4,  3,  4,  5,  5,  3,  5,  4,  5,  4,  5,  5,  4}
};

/* MV differential tables, p265 */
const uint16_t ff_vc1_mv_diff_codes[4][73] = {
  {
       0,    2,    3,    8,  576,    3,    2,    6,
       5,  577,  578,    7,    8,    9,   40,   19,
      37,   82,   21,   22,   23,  579,  580,  166,
      96,  167,   49,  194,  195,  581,  582,  583,
     292,  293,  294,   13,    2,    7,   24,   50,
     102,  295,   13,    7,    8,   18,   50,  103,
      38,   20,   21,   22,   39,  204,  103,   23,
      24,   25,  104,  410,  105,  106,  107,  108,
     109,  220,  411,  442,  222,  443,  446,  447,
       7 /* 73 elements */
  },
  {
       0,    4,    5,    3,    4,    3,    4,    5,
      20,    6,   21,   44,   45,   46, 3008,   95,
     112,  113,   57, 3009, 3010,  116,  117, 3011,
     118, 3012, 3013, 3014, 3015, 3016, 3017, 3018,
    3019, 3020, 3021, 3022,    1,    4,   15,  160,
     161,   41,    6,   11,   42,  162,   43,  119,
      56,   57,   58,  163,  236,  237, 3023,  119,
     120,  242,  122,  486, 1512,  487,  246,  494,
    1513,  495, 1514, 1515, 1516, 1517, 1518, 1519,
      31 /* 73 elements */
  },
  {
       0,  512,  513,  514,  515,    2,    3,  258,
     259,  260,  261,  262,  263,  264,  265,  266,
     267,  268,  269,  270,  271,  272,  273,  274,
     275,  276,  277,  278,  279,  280,  281,  282,
     283,  284,  285,  286,    1,    5,  287,  288,
     289,  290,    6,    7,  291,  292,  293,  294,
     295,  296,  297,  298,  299,  300,  301,  302,
     303,  304,  305,  306,  307,  308,  309,  310,
     311,  312,  313,  314,  315,  316,  317,  318,
     319 /* 73 elements */
  },
  {
       0,    1,    1,    2,    3,    4,    1,    5,
       4,    3,    5,    8,    6,    9,   10,   11,
      12,    7,  104,   14,  105,    4,   10,   15,
      11,    6,   14,    8,  106,  107,  108,   15,
     109,    9,   55,   10,    1,    2,    1,    2,
       3,   12,    6,    2,    6,    7,   28,    7,
      15,    8,    5,   18,   29,  152,   77,   24,
      25,   26,   39,  108,   13,  109,   55,   56,
      57,  116,   11,  153,  234,  235,  118,  119,
      15 /* 73 elements */
  }
};
const uint8_t ff_vc1_mv_diff_bits[4][73] = {
  {
     6,  7,  7,  8, 14,  6,  5,  6,  7, 14, 14,  6,  6,  6,  8,  9,
    10,  9,  7,  7,  7, 14, 14, 10,  9, 10,  8, 10, 10, 14, 14, 14,
    13, 13, 13,  6,  3,  5,  6,  8,  9, 13,  5,  4,  4,  5,  7,  9,
     6,  5,  5,  5,  6,  9,  8,  5,  5,  5,  7, 10,  7,  7,  7,  7,
     7,  8, 10,  9,  8,  9,  9,  9,  3 /* 73 elements */
  },
  {
     5,  7,  7,  6,  6,  5,  5,  6,  7,  5,  7,  8,  8,  8, 14,  9,
     9,  9,  8, 14, 14,  9,  9, 14,  9, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14,  2,  3,  6,  8,  8,  6,  3,  4,  6,  8,  6,  9,
     6,  6,  6,  8,  8,  8, 14,  7,  7,  8,  7,  9, 13,  9,  8,  9,
    13,  9, 13, 13, 13, 13, 13, 13,  5 /* 73 elements */

  },
  {
     3, 12, 12, 12, 12,  3,  4, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11,  1,  5, 11, 11, 11, 11,  4,  4, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11 /* 73 elements */
  },
  {
    15, 11, 15, 15, 15, 15, 12, 15, 12, 11, 12, 12, 15, 12, 12, 12,
    12, 15, 15, 12, 15, 10, 11, 12, 11, 10, 11, 10, 15, 15, 15, 11,
    15, 10, 14, 10,  4,  4,  5,  7,  8,  9,  5,  3,  4,  5,  6,  8,
     5,  4,  3,  5,  6,  8,  7,  5,  5,  5,  6,  7,  9,  7,  6,  6,
     6,  7, 10,  8,  8,  8,  7,  7,  4 /* 73 elements */
  }
};

/* DC differentials low+hi-mo, p217 are the same as in msmpeg4data .h */

/* Table 232 */
const int8_t ff_vc1_simple_progressive_4x4_zz [16] = {
     0,     8,    16,     1,
     9,    24,    17,     2,
    10,    18,    25,     3,
    11,    26,    19,    27
};

const int8_t ff_vc1_adv_progressive_8x4_zz [32] = { /* Table 233 */
     0,     8,     1,    16,     2,     9,    10,     3,
    24,    17,     4,    11,    18,    12,     5,    19,
    25,    13,    20,    26,    27,     6,    21,    28,
    14,    22,    29,     7,    30,    15,    23,    31
};

const int8_t ff_vc1_adv_progressive_4x8_zz [32] = { /* Table 234 */
     0,     1,     8,     2,
     9,    16,    17,    24,
    10,    32,    25,    18,
    40,     3,    33,    26,
    48,    11,    56,    41,
    34,    49,    57,    42,
    19,    50,    27,    58,
    35,    43,    51,    59
};

const int8_t ff_vc1_adv_interlaced_8x8_zz [64] = { /* Table 235 */
     0,     8,     1,    16,    24,     9,     2,    32,
    40,    48,    56,    17,    10,     3,    25,    18,
    11,     4,    33,    41,    49,    57,    26,    34,
    42,    50,    58,    19,    12,     5,    27,    20,
    13,     6,    35,    28,    21,    14,     7,    15,
    22,    29,    36,    43,    51,    59,    60,    52,
    44,    37,    30,    23,    31,    38,    45,    53,
    61,    62,    54,    46,    39,    47,    55,    63
};

const int8_t ff_vc1_adv_interlaced_8x4_zz [32] = { /* Table 236 */
     0,     8,    16,    24,     1,     9,     2,    17,
    25,    10,     3,    18,    26,     4,    11,    19,
    12,     5,    13,    20,    27,     6,    21,    28,
    14,    22,    29,     7,    30,    15,    23,    31
};

const int8_t ff_vc1_adv_interlaced_4x8_zz [32] = { /* Table 237 */
     0,     1,     2,     8,
    16,     9,    24,    17,
    10,     3,    32,    40,
    48,    56,    25,    18,
    33,    26,    41,    34,
    49,    57,    11,    42,
    19,    50,    27,    58,
    35,    43,    51,    59
};

const int8_t ff_vc1_adv_interlaced_4x4_zz [16] = { /* Table 238 */
     0,     8,    16,    24,
     1,     9,    17,     2,
    25,    10,    18,     3,
    26,    11,    19,    27
};


/* DQScale as specified in 8.1.3.9 - almost identical to 0x40000/i */
const int32_t ff_vc1_dqscale[63] = {
    0x40000, 0x20000, 0x15555, 0x10000, 0xCCCD, 0xAAAB, 0x9249, 0x8000,
     0x71C7,  0x6666,  0x5D17,  0x5555, 0x4EC5, 0x4925, 0x4444, 0x4000,
     0x3C3C,  0x38E4,  0x35E5,  0x3333, 0x30C3, 0x2E8C, 0x2C86, 0x2AAB,
     0x28F6,  0x2762,  0x25ED,  0x2492, 0x234F, 0x2222, 0x2108, 0x2000,
     0x1F08,  0x1E1E,  0x1D42,  0x1C72, 0x1BAD, 0x1AF3, 0x1A42, 0x199A,
     0x18FA,  0x1862,  0x17D0,  0x1746, 0x16C1, 0x1643, 0x15CA, 0x1555,
     0x14E6,  0x147B,  0x1414,  0x13B1, 0x1352, 0x12F7, 0x129E, 0x1249,
     0x11F7,  0x11A8,  0x115B,  0x1111, 0x10C9, 0x1084, 0x1000
};

/* P Interlaced field picture MV predictor scaling values (Table 114) */
const uint16_t ff_vc1_field_mvpred_scales[2][7][4] = {
// Refdist:
//      0       1       2       3 or greater
  { // current field is first
    { 128,    192,    213,    224 },   // SCALEOPP
    { 512,    341,    307,    293 },   // SCALESAME1
    { 219,    236,    242,    245 },   // SCALESAME2
    {  32,     48,     53,     56 },   // SCALEZONE1_X
    {   8,     12,     13,     14 },   // SCALEZONE1_Y
    {  37,     20,     14,     11 },   // ZONE1OFFSET_X
    {  10,      5,      4,      3 }    // ZONE1OFFSET_Y
  },
  { // current field is second
    { 128,     64,     43,     32 },   // SCALEOPP
    { 512,   1024,   1536,   2048 },   // SCALESAME1
    { 219,    204,    200,    198 },   // SCALESAME2
    {  32,     16,     11,      8 },   // SCALEZONE1_X
    {   8,      4,      3,      2 },   // SCALEZONE1_Y
    {  37,     52,     56,     58 },   // ZONE1OFFSET_X
    {  10,     13,     14,     15 }    // ZONE1OFFSET_Y
  }
};

/* B Interlaced field picture backward MV predictor scaling values for first field (Table 115) */
const uint16_t ff_vc1_b_field_mvpred_scales[7][4] = {
    // BRFD:
    //  0       1       2       3 or greater
    { 171,    205,    219,    228 },   // SCALESAME
    { 384,    320,    299,    288 },   // SCALEOPP1
    { 230,    239,    244,    246 },   // SCALEOPP2
    {  43,     51,     55,     57 },   // SCALEZONE1_X
    {  11,     13,     14,     14 },   // SCALEZONE1_Y
    {  26,     17,     12,     10 },   // ZONE1OFFSET_X
    {   7,      4,      3,      3 }    // ZONE1OFFSET_Y
};
