/******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2019-2024 Baldur Karlsson
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#include "vk_common.h"
#include "vk_resources.h"

template <>
rdcstr DoStringise(const VulkanChunk &el)
{
  RDCCOMPILE_ASSERT((uint32_t)VulkanChunk::Max == 1209, "Chunks changed without updating names");

  BEGIN_ENUM_STRINGISE(VulkanChunk)
  {
    STRINGISE_ENUM_CLASS(vkEnumeratePhysicalDevices);
    STRINGISE_ENUM_CLASS(vkCreateDevice);
    STRINGISE_ENUM_CLASS(vkGetDeviceQueue);
    STRINGISE_ENUM_CLASS(vkAllocateMemory);
    STRINGISE_ENUM_CLASS(vkUnmapMemory);
    STRINGISE_ENUM_CLASS(vkFlushMappedMemoryRanges);
    STRINGISE_ENUM_CLASS(vkCreateCommandPool);
    STRINGISE_ENUM_CLASS(vkResetCommandPool);
    STRINGISE_ENUM_CLASS(vkAllocateCommandBuffers);
    STRINGISE_ENUM_CLASS(vkCreateFramebuffer);
    STRINGISE_ENUM_CLASS(vkCreateRenderPass);
    STRINGISE_ENUM_CLASS(vkCreateDescriptorPool);
    STRINGISE_ENUM_CLASS(vkCreateDescriptorSetLayout);
    STRINGISE_ENUM_CLASS(vkCreateBuffer);
    STRINGISE_ENUM_CLASS(vkCreateBufferView);
    STRINGISE_ENUM_CLASS(vkCreateImage);
    STRINGISE_ENUM_CLASS(vkCreateImageView);
    STRINGISE_ENUM_CLASS(vkCreateDepthTargetView);
    STRINGISE_ENUM_CLASS(vkCreateSampler);
    STRINGISE_ENUM_CLASS(vkCreateShaderModule);
    STRINGISE_ENUM_CLASS(vkCreatePipelineLayout);
    STRINGISE_ENUM_CLASS(vkCreatePipelineCache);
    STRINGISE_ENUM_CLASS(vkCreateGraphicsPipelines);
    STRINGISE_ENUM_CLASS(vkCreateComputePipelines);
    STRINGISE_ENUM_CLASS(vkGetSwapchainImagesKHR);
    STRINGISE_ENUM_CLASS(vkCreateSemaphore);
    STRINGISE_ENUM_CLASS(vkCreateFence);
    STRINGISE_ENUM_CLASS(vkGetFenceStatus);
    STRINGISE_ENUM_CLASS(vkResetFences);
    STRINGISE_ENUM_CLASS(vkWaitForFences);
    STRINGISE_ENUM_CLASS(vkCreateEvent);
    STRINGISE_ENUM_CLASS(vkGetEventStatus);
    STRINGISE_ENUM_CLASS(vkSetEvent);
    STRINGISE_ENUM_CLASS(vkResetEvent);
    STRINGISE_ENUM_CLASS(vkCreateQueryPool);
    STRINGISE_ENUM_CLASS(vkAllocateDescriptorSets);
    STRINGISE_ENUM_CLASS(vkUpdateDescriptorSets);
    STRINGISE_ENUM_CLASS(vkBeginCommandBuffer);
    STRINGISE_ENUM_CLASS(vkEndCommandBuffer);
    STRINGISE_ENUM_CLASS(vkQueueWaitIdle);
    STRINGISE_ENUM_CLASS(vkDeviceWaitIdle);
    STRINGISE_ENUM_CLASS(vkQueueSubmit);
    STRINGISE_ENUM_CLASS(vkBindBufferMemory);
    STRINGISE_ENUM_CLASS(vkBindImageMemory);
    STRINGISE_ENUM_CLASS(vkQueueBindSparse);
    STRINGISE_ENUM_CLASS(vkCmdBeginRenderPass);
    STRINGISE_ENUM_CLASS(vkCmdNextSubpass);
    STRINGISE_ENUM_CLASS(vkCmdExecuteCommands);
    STRINGISE_ENUM_CLASS(vkCmdEndRenderPass);
    STRINGISE_ENUM_CLASS(vkCmdBindPipeline);
    STRINGISE_ENUM_CLASS(vkCmdSetViewport);
    STRINGISE_ENUM_CLASS(vkCmdSetScissor);
    STRINGISE_ENUM_CLASS(vkCmdSetLineWidth);
    STRINGISE_ENUM_CLASS(vkCmdSetDepthBias);
    STRINGISE_ENUM_CLASS(vkCmdSetBlendConstants);
    STRINGISE_ENUM_CLASS(vkCmdSetDepthBounds);
    STRINGISE_ENUM_CLASS(vkCmdSetStencilCompareMask);
    STRINGISE_ENUM_CLASS(vkCmdSetStencilWriteMask);
    STRINGISE_ENUM_CLASS(vkCmdSetStencilReference);
    STRINGISE_ENUM_CLASS(vkCmdBindDescriptorSets);
    STRINGISE_ENUM_CLASS(vkCmdBindVertexBuffers);
    STRINGISE_ENUM_CLASS(vkCmdBindIndexBuffer);
    STRINGISE_ENUM_CLASS(vkCmdCopyBufferToImage);
    STRINGISE_ENUM_CLASS(vkCmdCopyImageToBuffer);
    STRINGISE_ENUM_CLASS(vkCmdCopyBuffer);
    STRINGISE_ENUM_CLASS(vkCmdCopyImage);
    STRINGISE_ENUM_CLASS(vkCmdBlitImage);
    STRINGISE_ENUM_CLASS(vkCmdResolveImage);
    STRINGISE_ENUM_CLASS(vkCmdUpdateBuffer);
    STRINGISE_ENUM_CLASS(vkCmdFillBuffer);
    STRINGISE_ENUM_CLASS(vkCmdPushConstants);
    STRINGISE_ENUM_CLASS(vkCmdClearColorImage);
    STRINGISE_ENUM_CLASS(vkCmdClearDepthStencilImage);
    STRINGISE_ENUM_CLASS(vkCmdClearAttachments);
    STRINGISE_ENUM_CLASS(vkCmdPipelineBarrier);
    STRINGISE_ENUM_CLASS(vkCmdWriteTimestamp);
    STRINGISE_ENUM_CLASS(vkCmdCopyQueryPoolResults);
    STRINGISE_ENUM_CLASS(vkCmdBeginQuery);
    STRINGISE_ENUM_CLASS(vkCmdEndQuery);
    STRINGISE_ENUM_CLASS(vkCmdResetQueryPool);
    STRINGISE_ENUM_CLASS(vkCmdSetEvent);
    STRINGISE_ENUM_CLASS(vkCmdResetEvent);
    STRINGISE_ENUM_CLASS(vkCmdWaitEvents);
    STRINGISE_ENUM_CLASS(vkCmdDraw);
    STRINGISE_ENUM_CLASS(vkCmdDrawIndirect);
    STRINGISE_ENUM_CLASS(vkCmdDrawIndexed);
    STRINGISE_ENUM_CLASS(vkCmdDrawIndexedIndirect);
    STRINGISE_ENUM_CLASS(vkCmdDispatch);
    STRINGISE_ENUM_CLASS(vkCmdDispatchIndirect);
    STRINGISE_ENUM_CLASS(vkCmdDebugMarkerBeginEXT);
    STRINGISE_ENUM_CLASS(vkCmdDebugMarkerInsertEXT);
    STRINGISE_ENUM_CLASS(vkCmdDebugMarkerEndEXT);
    STRINGISE_ENUM_CLASS(vkDebugMarkerSetObjectNameEXT);
    STRINGISE_ENUM_CLASS(vkCreateSwapchainKHR);
    STRINGISE_ENUM_CLASS(SetShaderDebugPath);
    STRINGISE_ENUM_CLASS(vkRegisterDeviceEventEXT);
    STRINGISE_ENUM_CLASS(vkRegisterDisplayEventEXT);
    STRINGISE_ENUM_CLASS_NAMED(vkCmdIndirectSubCommand, "Indirect sub-command");
    STRINGISE_ENUM_CLASS(vkCmdPushDescriptorSetKHR);
    STRINGISE_ENUM_CLASS(vkCmdPushDescriptorSetWithTemplateKHR);
    STRINGISE_ENUM_CLASS(vkCreateDescriptorUpdateTemplate);
    STRINGISE_ENUM_CLASS(vkUpdateDescriptorSetWithTemplate);
    STRINGISE_ENUM_CLASS(vkBindBufferMemory2);
    STRINGISE_ENUM_CLASS(vkBindImageMemory2);
    STRINGISE_ENUM_CLASS(vkCmdWriteBufferMarkerAMD);
    STRINGISE_ENUM_CLASS(vkSetDebugUtilsObjectNameEXT);
    STRINGISE_ENUM_CLASS(vkQueueBeginDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkQueueEndDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkQueueInsertDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkCmdBeginDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkCmdEndDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkCmdInsertDebugUtilsLabelEXT);
    STRINGISE_ENUM_CLASS(vkCreateSamplerYcbcrConversion);
    STRINGISE_ENUM_CLASS(vkCmdSetDeviceMask);
    STRINGISE_ENUM_CLASS(vkCmdDispatchBase);
    STRINGISE_ENUM_CLASS(vkGetDeviceQueue2);
    STRINGISE_ENUM_CLASS(vkCmdDrawIndirectCount);
    STRINGISE_ENUM_CLASS(vkCmdDrawIndexedIndirectCount);
    STRINGISE_ENUM_CLASS(vkCreateRenderPass2);
    STRINGISE_ENUM_CLASS(vkCmdBeginRenderPass2);
    STRINGISE_ENUM_CLASS(vkCmdNextSubpass2);
    STRINGISE_ENUM_CLASS(vkCmdEndRenderPass2);
    STRINGISE_ENUM_CLASS(vkCmdBindTransformFeedbackBuffersEXT)
    STRINGISE_ENUM_CLASS(vkCmdBeginTransformFeedbackEXT)
    STRINGISE_ENUM_CLASS(vkCmdEndTransformFeedbackEXT)
    STRINGISE_ENUM_CLASS(vkCmdBeginQueryIndexedEXT)
    STRINGISE_ENUM_CLASS(vkCmdEndQueryIndexedEXT)
    STRINGISE_ENUM_CLASS(vkCmdDrawIndirectByteCountEXT)
    STRINGISE_ENUM_CLASS(vkCmdBeginConditionalRenderingEXT)
    STRINGISE_ENUM_CLASS(vkCmdEndConditionalRenderingEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetSampleLocationsEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetDiscardRectangleEXT)
    STRINGISE_ENUM_CLASS_NAMED(DeviceMemoryRefs, "Internal::Device Memory References")
    STRINGISE_ENUM_CLASS(vkResetQueryPool);
    STRINGISE_ENUM_CLASS_NAMED(ImageRefs, "Internal::Image References")
    STRINGISE_ENUM_CLASS(vkCmdSetLineStippleKHR);
    STRINGISE_ENUM_CLASS(vkGetSemaphoreCounterValue);
    STRINGISE_ENUM_CLASS(vkWaitSemaphores);
    STRINGISE_ENUM_CLASS(vkSignalSemaphore);
    STRINGISE_ENUM_CLASS(vkQueuePresentKHR);
    STRINGISE_ENUM_CLASS(vkCmdSetCullMode);
    STRINGISE_ENUM_CLASS(vkCmdSetFrontFace);
    STRINGISE_ENUM_CLASS(vkCmdSetPrimitiveTopology);
    STRINGISE_ENUM_CLASS(vkCmdSetViewportWithCount);
    STRINGISE_ENUM_CLASS(vkCmdSetScissorWithCount);
    STRINGISE_ENUM_CLASS(vkCmdBindVertexBuffers2);
    STRINGISE_ENUM_CLASS(vkCmdSetDepthTestEnable);
    STRINGISE_ENUM_CLASS(vkCmdSetDepthWriteEnable);
    STRINGISE_ENUM_CLASS(vkCmdSetDepthCompareOp);
    STRINGISE_ENUM_CLASS(vkCmdSetDepthBoundsTestEnable);
    STRINGISE_ENUM_CLASS(vkCmdSetStencilTestEnable);
    STRINGISE_ENUM_CLASS(vkCmdSetStencilOp);
    STRINGISE_ENUM_CLASS_NAMED(CoherentMapWrite, "Internal::Coherent Mapped Memory Write")
    STRINGISE_ENUM_CLASS(vkCmdCopyBuffer2);
    STRINGISE_ENUM_CLASS(vkCmdCopyImage2);
    STRINGISE_ENUM_CLASS(vkCmdCopyBufferToImage2);
    STRINGISE_ENUM_CLASS(vkCmdCopyImageToBuffer2);
    STRINGISE_ENUM_CLASS(vkCmdBlitImage2);
    STRINGISE_ENUM_CLASS(vkCmdResolveImage2);
    STRINGISE_ENUM_CLASS(vkCmdSetEvent2);
    STRINGISE_ENUM_CLASS(vkCmdResetEvent2);
    STRINGISE_ENUM_CLASS(vkCmdWaitEvents2);
    STRINGISE_ENUM_CLASS(vkCmdPipelineBarrier2);
    STRINGISE_ENUM_CLASS(vkCmdWriteTimestamp2);
    STRINGISE_ENUM_CLASS(vkQueueSubmit2);
    STRINGISE_ENUM_CLASS(vkCmdWriteBufferMarker2AMD);
    STRINGISE_ENUM_CLASS(vkCmdSetColorWriteEnableEXT);
    STRINGISE_ENUM_CLASS(vkCmdSetDepthBiasEnable)
    STRINGISE_ENUM_CLASS(vkCmdSetLogicOpEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetPatchControlPointsEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetPrimitiveRestartEnable)
    STRINGISE_ENUM_CLASS(vkCmdSetRasterizerDiscardEnable)
    STRINGISE_ENUM_CLASS(vkCmdSetVertexInputEXT)
    STRINGISE_ENUM_CLASS(vkCmdBeginRendering)
    STRINGISE_ENUM_CLASS(vkCmdEndRendering)
    STRINGISE_ENUM_CLASS(vkCmdSetFragmentShadingRateKHR)
    STRINGISE_ENUM_CLASS(vkSetDeviceMemoryPriorityEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetAttachmentFeedbackLoopEnableEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetAlphaToCoverageEnableEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetAlphaToOneEnableEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetColorBlendEnableEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetColorBlendEquationEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetColorWriteMaskEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetConservativeRasterizationModeEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetDepthClampEnableEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetDepthClipEnableEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetDepthClipNegativeOneToOneEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetExtraPrimitiveOverestimationSizeEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetLineRasterizationModeEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetLineStippleEnableEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetLogicOpEnableEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetPolygonModeEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetProvokingVertexModeEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetRasterizationSamplesEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetRasterizationStreamEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetSampleLocationsEnableEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetSampleMaskEXT)
    STRINGISE_ENUM_CLASS(vkCmdSetTessellationDomainOriginEXT)
    STRINGISE_ENUM_CLASS(vkCmdDrawMeshTasksEXT)
    STRINGISE_ENUM_CLASS(vkCmdDrawMeshTasksIndirectEXT)
    STRINGISE_ENUM_CLASS(vkCmdDrawMeshTasksIndirectCountEXT)
    STRINGISE_ENUM_CLASS(vkCmdBuildAccelerationStructuresIndirectKHR)
    STRINGISE_ENUM_CLASS(vkCmdBuildAccelerationStructuresKHR)
    STRINGISE_ENUM_CLASS(vkCmdCopyAccelerationStructureKHR)
    STRINGISE_ENUM_CLASS(vkCmdCopyAccelerationStructureToMemoryKHR)
    STRINGISE_ENUM_CLASS(vkCmdCopyMemoryToAccelerationStructureKHR)
    STRINGISE_ENUM_CLASS(vkCreateAccelerationStructureKHR)
    STRINGISE_ENUM_CLASS(vkCmdBindShadersEXT)
    STRINGISE_ENUM_CLASS(vkCreateShadersEXT)
    STRINGISE_ENUM_CLASS_NAMED(Max, "Max Chunk");
  }
  END_ENUM_STRINGISE()
}

template <>
rdcstr DoStringise(const VkResourceType &el)
{
  BEGIN_ENUM_STRINGISE(VkResourceType);
  {
    STRINGISE_ENUM(eResUnknown)
    STRINGISE_ENUM(eResPhysicalDevice)
    STRINGISE_ENUM(eResInstance)
    STRINGISE_ENUM(eResDevice)
    STRINGISE_ENUM(eResQueue)
    STRINGISE_ENUM(eResDeviceMemory)
    STRINGISE_ENUM(eResBuffer)
    STRINGISE_ENUM(eResBufferView)
    STRINGISE_ENUM(eResImage)
    STRINGISE_ENUM(eResImageView)
    STRINGISE_ENUM(eResFramebuffer)
    STRINGISE_ENUM(eResRenderPass)
    STRINGISE_ENUM(eResShaderModule)
    STRINGISE_ENUM(eResPipelineCache)
    STRINGISE_ENUM(eResPipelineLayout)
    STRINGISE_ENUM(eResPipeline)
    STRINGISE_ENUM(eResSampler)
    STRINGISE_ENUM(eResDescriptorPool)
    STRINGISE_ENUM(eResDescriptorSetLayout)
    STRINGISE_ENUM(eResDescriptorSet)
    STRINGISE_ENUM(eResCommandPool)
    STRINGISE_ENUM(eResCommandBuffer)
    STRINGISE_ENUM(eResFence)
    STRINGISE_ENUM(eResEvent)
    STRINGISE_ENUM(eResQueryPool)
    STRINGISE_ENUM(eResSemaphore)
    STRINGISE_ENUM(eResSwapchain)
    STRINGISE_ENUM(eResSurface)
    STRINGISE_ENUM(eResDescUpdateTemplate)
    STRINGISE_ENUM(eResSamplerConversion)
    STRINGISE_ENUM(eResAccelerationStructureKHR)
    STRINGISE_ENUM(eResShaderEXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const MemoryScope &el)
{
  BEGIN_ENUM_STRINGISE(MemoryScope);
  {
    STRINGISE_ENUM_CLASS(InitialContents);
    STRINGISE_ENUM_CLASS(IndirectReadback);
  }
  END_ENUM_STRINGISE()
}

template <>
rdcstr DoStringise(const MemoryType &el)
{
  BEGIN_ENUM_STRINGISE(MemoryType)
  {
    STRINGISE_ENUM_CLASS(Upload);
    STRINGISE_ENUM_CLASS(GPULocal);
    STRINGISE_ENUM_CLASS(Readback);
  }
  END_ENUM_STRINGISE()
}

template <>
rdcstr DoStringise(const VkFlagWithNoBits &el)
{
  if(el != 0)
    return StringFormat::Fmt("Invalid bits set: %x", el);
  return "0"_lit;
}

template <>
rdcstr DoStringise(const VkQueueFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkQueueFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_QUEUE_GRAPHICS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_COMPUTE_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_TRANSFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_SPARSE_BINDING_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_PROTECTED_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_VIDEO_DECODE_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_VIDEO_ENCODE_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_QUEUE_OPTICAL_FLOW_BIT_NV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineCacheCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineCacheCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_DERIVATIVE_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_DISPATCH_BASE_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_LIBRARY_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_DESCRIPTOR_BUFFER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineLayoutCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineLayoutCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineStageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineStageFlagBits);
  {
    STRINGISE_BITFIELD_VALUE(VK_PIPELINE_STAGE_NONE);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_VERTEX_INPUT_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_VERTEX_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TRANSFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_HOST_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_ALL_COMMANDS_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_TASK_SHADER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_STAGE_MESH_SHADER_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkBufferUsageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkBufferUsageFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_TRANSFER_SRC_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_TRANSFER_DST_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_STORAGE_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_INDEX_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_VERTEX_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_USAGE_MICROMAP_STORAGE_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkImageViewCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkImageViewCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkImageUsageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkImageUsageFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_TRANSFER_SRC_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_TRANSFER_DST_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_SAMPLED_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_STORAGE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_HOST_TRANSFER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_USAGE_SAMPLE_BLOCK_MATCH_BIT_QCOM);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkBufferCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkBufferCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_SPARSE_BINDING_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_SPARSE_ALIASED_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_PROTECTED_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkImageCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkImageCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SPARSE_BINDING_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SPARSE_ALIASED_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_ALIAS_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_EXTENDED_USAGE_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_PROTECTED_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_DISJOINT_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSamplerCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSamplerCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLER_CREATE_NON_SEAMLESS_CUBE_MAP_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSparseMemoryBindFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSparseMemoryBindFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SPARSE_MEMORY_BIND_METADATA_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkCommandPoolCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkCommandPoolCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_COMMAND_POOL_CREATE_TRANSIENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT(VK_COMMAND_POOL_CREATE_PROTECTED_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkCommandPoolResetFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkCommandPoolResetFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkCommandBufferUsageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkCommandBufferUsageFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT);
    STRINGISE_BITFIELD_BIT(VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT);
    STRINGISE_BITFIELD_BIT(VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDescriptorPoolCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDescriptorPoolCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT);
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT);
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkFenceCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkFenceCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_FENCE_CREATE_SIGNALED_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkQueryPipelineStatisticFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkQueryPipelineStatisticFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_TASK_SHADER_INVOCATIONS_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_MESH_SHADER_INVOCATIONS_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_PIPELINE_STATISTIC_CLUSTER_CULLING_SHADER_INVOCATIONS_BIT_HUAWEI);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkQueryControlFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkQueryControlFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_QUERY_CONTROL_PRECISE_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkQueryResultFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkQueryResultFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_QUERY_RESULT_64_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_RESULT_WAIT_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_RESULT_WITH_AVAILABILITY_BIT);
    STRINGISE_BITFIELD_BIT(VK_QUERY_RESULT_PARTIAL_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkAttachmentDescriptionFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkAttachmentDescriptionFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkResolveModeFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkResolveModeFlagBits);
  {
    STRINGISE_BITFIELD_VALUE(VK_RESOLVE_MODE_NONE);
    STRINGISE_BITFIELD_BIT(VK_RESOLVE_MODE_SAMPLE_ZERO_BIT);
    STRINGISE_BITFIELD_BIT(VK_RESOLVE_MODE_AVERAGE_BIT);
    STRINGISE_BITFIELD_BIT(VK_RESOLVE_MODE_MIN_BIT);
    STRINGISE_BITFIELD_BIT(VK_RESOLVE_MODE_MAX_BIT);
    STRINGISE_BITFIELD_BIT(VK_RESOLVE_MODE_EXTERNAL_FORMAT_DOWNSAMPLE_ANDROID);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSampleCountFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSampleCountFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_1_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_2_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_4_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_8_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_16_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_32_BIT);
    STRINGISE_BITFIELD_BIT(VK_SAMPLE_COUNT_64_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkImageAspectFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkImageAspectFlagBits);
  {
    STRINGISE_BITFIELD_VALUE(VK_IMAGE_ASPECT_NONE);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_COLOR_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_DEPTH_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_STENCIL_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_METADATA_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_PLANE_0_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_PLANE_1_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_PLANE_2_BIT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDependencyFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDependencyFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_DEPENDENCY_BY_REGION_BIT);
    STRINGISE_BITFIELD_BIT(VK_DEPENDENCY_DEVICE_GROUP_BIT);
    STRINGISE_BITFIELD_BIT(VK_DEPENDENCY_VIEW_LOCAL_BIT);
    STRINGISE_BITFIELD_BIT(VK_DEPENDENCY_FEEDBACK_LOOP_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkShaderStageFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkShaderStageFlagBits);
  {
    STRINGISE_BITFIELD_VALUE(VK_SHADER_STAGE_ALL_GRAPHICS);
    STRINGISE_BITFIELD_VALUE(VK_SHADER_STAGE_ALL);

    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_VERTEX_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_GEOMETRY_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_FRAGMENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_COMPUTE_BIT);

    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_RAYGEN_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_ANY_HIT_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_MISS_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_INTERSECTION_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_CALLABLE_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_TASK_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_MESH_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI);
    STRINGISE_BITFIELD_BIT(VK_SHADER_STAGE_CLUSTER_CULLING_BIT_HUAWEI);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkMemoryHeapFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkMemoryHeapFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_MEMORY_HEAP_DEVICE_LOCAL_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_HEAP_MULTI_INSTANCE_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkMemoryPropertyFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkMemoryPropertyFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_HOST_COHERENT_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_HOST_CACHED_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_PROTECTED_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkAccessFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkAccessFlagBits);
  {
    STRINGISE_BITFIELD_VALUE(VK_ACCESS_NONE);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_INDIRECT_COMMAND_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_INDEX_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_UNIFORM_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_INPUT_ATTACHMENT_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_SHADER_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_SHADER_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COLOR_ATTACHMENT_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_TRANSFER_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_TRANSFER_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_HOST_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_HOST_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_MEMORY_READ_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_MEMORY_WRITE_BIT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkExternalMemoryHandleTypeFlagBitsNV &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalMemoryHandleTypeFlagBitsNV);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM_NV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkExternalMemoryHandleTypeFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalMemoryHandleTypeFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkExternalSemaphoreHandleTypeFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalSemaphoreHandleTypeFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_ZIRCON_EVENT_BIT_FUCHSIA);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkExternalFenceHandleTypeFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalFenceHandleTypeFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT);
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSurfaceCounterFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSurfaceCounterFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_SURFACE_COUNTER_VBLANK_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDeviceGroupPresentModeFlagBitsKHR &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDeviceGroupPresentModeFlagBitsKHR);
  {
    STRINGISE_BITFIELD_BIT(VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDebugReportFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDebugReportFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_DEBUG_REPORT_INFORMATION_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_REPORT_WARNING_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_REPORT_ERROR_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_REPORT_DEBUG_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDebugUtilsMessageSeverityFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDebugUtilsMessageSeverityFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkConditionalRenderingFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkConditionalRenderingFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDebugUtilsMessageTypeFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDebugUtilsMessageTypeFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_DEBUG_UTILS_MESSAGE_TYPE_DEVICE_ADDRESS_BINDING_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkAcquireProfilingLockFlagBitsKHR &el)
{
  BEGIN_BITFIELD_STRINGISE(VkAcquireProfilingLockFlagBitsKHR);
  {
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPerformanceCounterDescriptionFlagBitsKHR &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPerformanceCounterDescriptionFlagBitsKHR);
  {
    STRINGISE_BITFIELD_BIT(VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkMemoryAllocateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkMemoryAllocateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT);
    STRINGISE_BITFIELD_BIT(VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkStencilFaceFlagBits &el)
{
  // technically a bitfield but each combination has a particular meaning
  BEGIN_ENUM_STRINGISE(VkStencilFaceFlagBits);
  {
    STRINGISE_ENUM(VK_STENCIL_FACE_FRONT_BIT)
    STRINGISE_ENUM(VK_STENCIL_FACE_BACK_BIT)
    STRINGISE_ENUM(VK_STENCIL_FACE_FRONT_AND_BACK)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkCullModeFlagBits &el)
{
  // technically a bitfield but each combination has a particular meaning
  BEGIN_ENUM_STRINGISE(VkCullModeFlagBits);
  {
    STRINGISE_ENUM(VK_CULL_MODE_NONE)
    STRINGISE_ENUM(VK_CULL_MODE_FRONT_BIT)
    STRINGISE_ENUM(VK_CULL_MODE_BACK_BIT)
    STRINGISE_ENUM(VK_CULL_MODE_FRONT_AND_BACK)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkColorComponentFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkColorComponentFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_COLOR_COMPONENT_R_BIT)
    STRINGISE_BITFIELD_BIT(VK_COLOR_COMPONENT_G_BIT)
    STRINGISE_BITFIELD_BIT(VK_COLOR_COMPONENT_B_BIT)
    STRINGISE_BITFIELD_BIT(VK_COLOR_COMPONENT_A_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkEventCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkEventCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EVENT_CREATE_DEVICE_ONLY_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineBindPoint &el)
{
  BEGIN_ENUM_STRINGISE(VkPipelineBindPoint);
  {
    STRINGISE_ENUM(VK_PIPELINE_BIND_POINT_COMPUTE)
    STRINGISE_ENUM(VK_PIPELINE_BIND_POINT_GRAPHICS)
    STRINGISE_ENUM(VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR)
    STRINGISE_ENUM(VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkIndexType &el)
{
  BEGIN_ENUM_STRINGISE(VkIndexType);
  {
    STRINGISE_ENUM(VK_INDEX_TYPE_UINT16)
    STRINGISE_ENUM(VK_INDEX_TYPE_UINT32)
    STRINGISE_ENUM(VK_INDEX_TYPE_NONE_KHR)
    STRINGISE_ENUM(VK_INDEX_TYPE_UINT8_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkImageType &el)
{
  BEGIN_ENUM_STRINGISE(VkImageType);
  {
    STRINGISE_ENUM(VK_IMAGE_TYPE_1D)
    STRINGISE_ENUM(VK_IMAGE_TYPE_2D)
    STRINGISE_ENUM(VK_IMAGE_TYPE_3D)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkImageTiling &el)
{
  BEGIN_ENUM_STRINGISE(VkImageTiling);
  {
    STRINGISE_ENUM(VK_IMAGE_TILING_LINEAR)
    STRINGISE_ENUM(VK_IMAGE_TILING_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkImageViewType &el)
{
  BEGIN_ENUM_STRINGISE(VkImageViewType);
  {
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_1D)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_2D)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_3D)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_CUBE)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_1D_ARRAY)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_2D_ARRAY)
    STRINGISE_ENUM(VK_IMAGE_VIEW_TYPE_CUBE_ARRAY)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkVertexInputRate &el)
{
  BEGIN_ENUM_STRINGISE(VkVertexInputRate);
  {
    STRINGISE_ENUM(VK_VERTEX_INPUT_RATE_VERTEX)
    STRINGISE_ENUM(VK_VERTEX_INPUT_RATE_INSTANCE)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPolygonMode &el)
{
  BEGIN_ENUM_STRINGISE(VkPolygonMode);
  {
    STRINGISE_ENUM(VK_POLYGON_MODE_FILL)
    STRINGISE_ENUM(VK_POLYGON_MODE_LINE)
    STRINGISE_ENUM(VK_POLYGON_MODE_POINT)
    STRINGISE_ENUM(VK_POLYGON_MODE_FILL_RECTANGLE_NV)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkFrontFace &el)
{
  BEGIN_ENUM_STRINGISE(VkFrontFace);
  {
    STRINGISE_ENUM(VK_FRONT_FACE_COUNTER_CLOCKWISE)
    STRINGISE_ENUM(VK_FRONT_FACE_CLOCKWISE)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkBlendFactor &el)
{
  BEGIN_ENUM_STRINGISE(VkBlendFactor);
  {
    STRINGISE_ENUM(VK_BLEND_FACTOR_ZERO)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_DST_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_DST_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_CONSTANT_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_CONSTANT_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC_ALPHA_SATURATE)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC1_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR)
    STRINGISE_ENUM(VK_BLEND_FACTOR_SRC1_ALPHA)
    STRINGISE_ENUM(VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkBlendOp &el)
{
  BEGIN_ENUM_STRINGISE(VkBlendOp);
  {
    STRINGISE_ENUM(VK_BLEND_OP_ADD)
    STRINGISE_ENUM(VK_BLEND_OP_SUBTRACT)
    STRINGISE_ENUM(VK_BLEND_OP_REVERSE_SUBTRACT)
    STRINGISE_ENUM(VK_BLEND_OP_MIN)
    STRINGISE_ENUM(VK_BLEND_OP_MAX)
    STRINGISE_ENUM(VK_BLEND_OP_ZERO_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_OVER_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_OVER_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_IN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_IN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_OUT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_OUT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SRC_ATOP_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DST_ATOP_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_XOR_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_MULTIPLY_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SCREEN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_OVERLAY_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DARKEN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_LIGHTEN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_COLORDODGE_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_COLORBURN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HARDLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_SOFTLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_DIFFERENCE_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_EXCLUSION_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_INVERT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_INVERT_RGB_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_LINEARDODGE_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_LINEARBURN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_VIVIDLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_LINEARLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PINLIGHT_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HARDMIX_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HSL_HUE_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HSL_SATURATION_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HSL_COLOR_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_HSL_LUMINOSITY_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PLUS_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PLUS_CLAMPED_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_PLUS_DARKER_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_MINUS_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_MINUS_CLAMPED_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_CONTRAST_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_INVERT_OVG_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_RED_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_GREEN_EXT)
    STRINGISE_ENUM(VK_BLEND_OP_BLUE_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDynamicState &el)
{
  BEGIN_ENUM_STRINGISE(VkDynamicState);
  {
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VIEWPORT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_SCISSOR)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_LINE_WIDTH)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_BIAS)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_BLEND_CONSTANTS)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_BOUNDS)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_STENCIL_WRITE_MASK)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_STENCIL_REFERENCE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_CULL_MODE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_FRONT_FACE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_COMPARE_OP)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_STENCIL_OP)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_LINE_STIPPLE_KHR)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VERTEX_INPUT_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_LOGIC_OP_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_POLYGON_MODE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_SAMPLE_MASK_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_RASTERIZATION_STREAM_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV)
    STRINGISE_ENUM(VK_DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkAttachmentLoadOp &el)
{
  BEGIN_ENUM_STRINGISE(VkAttachmentLoadOp);
  {
    STRINGISE_ENUM(VK_ATTACHMENT_LOAD_OP_LOAD)
    STRINGISE_ENUM(VK_ATTACHMENT_LOAD_OP_CLEAR)
    STRINGISE_ENUM(VK_ATTACHMENT_LOAD_OP_DONT_CARE)
    STRINGISE_ENUM(VK_ATTACHMENT_LOAD_OP_NONE_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkAttachmentStoreOp &el)
{
  BEGIN_ENUM_STRINGISE(VkAttachmentStoreOp);
  {
    STRINGISE_ENUM(VK_ATTACHMENT_STORE_OP_STORE)
    STRINGISE_ENUM(VK_ATTACHMENT_STORE_OP_DONT_CARE)
    STRINGISE_ENUM(VK_ATTACHMENT_STORE_OP_NONE)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkStencilOp &el)
{
  BEGIN_ENUM_STRINGISE(VkStencilOp);
  {
    STRINGISE_ENUM(VK_STENCIL_OP_KEEP)
    STRINGISE_ENUM(VK_STENCIL_OP_ZERO)
    STRINGISE_ENUM(VK_STENCIL_OP_REPLACE)
    STRINGISE_ENUM(VK_STENCIL_OP_INCREMENT_AND_CLAMP)
    STRINGISE_ENUM(VK_STENCIL_OP_DECREMENT_AND_CLAMP)
    STRINGISE_ENUM(VK_STENCIL_OP_INVERT)
    STRINGISE_ENUM(VK_STENCIL_OP_INCREMENT_AND_WRAP)
    STRINGISE_ENUM(VK_STENCIL_OP_DECREMENT_AND_WRAP)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkLogicOp &el)
{
  BEGIN_ENUM_STRINGISE(VkLogicOp);
  {
    STRINGISE_ENUM(VK_LOGIC_OP_CLEAR)
    STRINGISE_ENUM(VK_LOGIC_OP_AND)
    STRINGISE_ENUM(VK_LOGIC_OP_AND_REVERSE)
    STRINGISE_ENUM(VK_LOGIC_OP_COPY)
    STRINGISE_ENUM(VK_LOGIC_OP_AND_INVERTED)
    STRINGISE_ENUM(VK_LOGIC_OP_NO_OP)
    STRINGISE_ENUM(VK_LOGIC_OP_XOR)
    STRINGISE_ENUM(VK_LOGIC_OP_OR)
    STRINGISE_ENUM(VK_LOGIC_OP_NOR)
    STRINGISE_ENUM(VK_LOGIC_OP_EQUIVALENT)
    STRINGISE_ENUM(VK_LOGIC_OP_INVERT)
    STRINGISE_ENUM(VK_LOGIC_OP_OR_REVERSE)
    STRINGISE_ENUM(VK_LOGIC_OP_COPY_INVERTED)
    STRINGISE_ENUM(VK_LOGIC_OP_OR_INVERTED)
    STRINGISE_ENUM(VK_LOGIC_OP_NAND)
    STRINGISE_ENUM(VK_LOGIC_OP_SET)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkCompareOp &el)
{
  BEGIN_ENUM_STRINGISE(VkCompareOp);
  {
    STRINGISE_ENUM(VK_COMPARE_OP_NEVER)
    STRINGISE_ENUM(VK_COMPARE_OP_LESS)
    STRINGISE_ENUM(VK_COMPARE_OP_EQUAL)
    STRINGISE_ENUM(VK_COMPARE_OP_LESS_OR_EQUAL)
    STRINGISE_ENUM(VK_COMPARE_OP_GREATER)
    STRINGISE_ENUM(VK_COMPARE_OP_NOT_EQUAL)
    STRINGISE_ENUM(VK_COMPARE_OP_GREATER_OR_EQUAL)
    STRINGISE_ENUM(VK_COMPARE_OP_ALWAYS)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkFilter &el)
{
  BEGIN_ENUM_STRINGISE(VkFilter);
  {
    STRINGISE_ENUM(VK_FILTER_NEAREST)
    STRINGISE_ENUM(VK_FILTER_LINEAR)
    STRINGISE_ENUM(VK_FILTER_CUBIC_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSamplerMipmapMode &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerMipmapMode);
  {
    STRINGISE_ENUM(VK_SAMPLER_MIPMAP_MODE_NEAREST)
    STRINGISE_ENUM(VK_SAMPLER_MIPMAP_MODE_LINEAR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSamplerAddressMode &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerAddressMode);
  {
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_REPEAT)
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT)
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE)
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER)
    STRINGISE_ENUM(VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkBorderColor &el)
{
  BEGIN_ENUM_STRINGISE(VkBorderColor);
  {
    STRINGISE_ENUM(VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK)
    STRINGISE_ENUM(VK_BORDER_COLOR_INT_TRANSPARENT_BLACK)
    STRINGISE_ENUM(VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK)
    STRINGISE_ENUM(VK_BORDER_COLOR_INT_OPAQUE_BLACK)
    STRINGISE_ENUM(VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE)
    STRINGISE_ENUM(VK_BORDER_COLOR_INT_OPAQUE_WHITE)
    STRINGISE_ENUM(VK_BORDER_COLOR_FLOAT_CUSTOM_EXT)
    STRINGISE_ENUM(VK_BORDER_COLOR_INT_CUSTOM_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPrimitiveTopology &el)
{
  BEGIN_ENUM_STRINGISE(VkPrimitiveTopology);
  {
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_POINT_LIST)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_LINE_LIST)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_LINE_STRIP)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY)
    STRINGISE_ENUM(VK_PRIMITIVE_TOPOLOGY_PATCH_LIST)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDescriptorType &el)
{
  BEGIN_ENUM_STRINGISE(VkDescriptorType);
  {
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_SAMPLER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_STORAGE_IMAGE)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_STORAGE_BUFFER)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM)
    STRINGISE_ENUM(VK_DESCRIPTOR_TYPE_MUTABLE_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkQueryType &el)
{
  BEGIN_ENUM_STRINGISE(VkQueryType);
  {
    STRINGISE_ENUM(VK_QUERY_TYPE_OCCLUSION)
    STRINGISE_ENUM(VK_QUERY_TYPE_PIPELINE_STATISTICS)
    STRINGISE_ENUM(VK_QUERY_TYPE_TIMESTAMP)
    STRINGISE_ENUM(VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT)
    STRINGISE_ENUM(VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR)
    STRINGISE_ENUM(VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR)
    STRINGISE_ENUM(VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR)
    STRINGISE_ENUM(VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV)
    STRINGISE_ENUM(VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL)
    STRINGISE_ENUM(VK_QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR)
    STRINGISE_ENUM(VK_QUERY_TYPE_MESH_PRIMITIVES_GENERATED_EXT)
    STRINGISE_ENUM(VK_QUERY_TYPE_PRIMITIVES_GENERATED_EXT)
    STRINGISE_ENUM(VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_BOTTOM_LEVEL_POINTERS_KHR)
    STRINGISE_ENUM(VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SIZE_KHR)
    STRINGISE_ENUM(VK_QUERY_TYPE_MICROMAP_SERIALIZATION_SIZE_EXT)
    STRINGISE_ENUM(VK_QUERY_TYPE_MICROMAP_COMPACTED_SIZE_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPhysicalDeviceType &el)
{
  BEGIN_ENUM_STRINGISE(VkPhysicalDeviceType);
  {
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_OTHER)
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU)
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU)
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU)
    STRINGISE_ENUM(VK_PHYSICAL_DEVICE_TYPE_CPU)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSharingMode &el)
{
  BEGIN_ENUM_STRINGISE(VkSharingMode);
  {
    STRINGISE_ENUM(VK_SHARING_MODE_EXCLUSIVE)
    STRINGISE_ENUM(VK_SHARING_MODE_CONCURRENT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkCommandBufferLevel &el)
{
  BEGIN_ENUM_STRINGISE(VkCommandBufferLevel);
  {
    STRINGISE_ENUM(VK_COMMAND_BUFFER_LEVEL_PRIMARY)
    STRINGISE_ENUM(VK_COMMAND_BUFFER_LEVEL_SECONDARY)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSubpassContents &el)
{
  BEGIN_ENUM_STRINGISE(VkSubpassContents);
  {
    STRINGISE_ENUM(VK_SUBPASS_CONTENTS_INLINE)
    STRINGISE_ENUM(VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS)
    STRINGISE_ENUM(VK_SUBPASS_CONTENTS_INLINE_AND_SECONDARY_COMMAND_BUFFERS_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkImageLayout &el)
{
  if(el == UNKNOWN_PREV_IMG_LAYOUT)
    return "Unknown previous layout"_lit;

  BEGIN_ENUM_STRINGISE(VkImageLayout);
  {
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_UNDEFINED)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_GENERAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_PREINITIALIZED)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_PRESENT_SRC_KHR)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT)
    STRINGISE_ENUM(VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkStructureType &el)
{
  BEGIN_ENUM_STRINGISE(VkStructureType);
  {
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_APPLICATION_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBMIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_SPARSE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FENCE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EVENT_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_BARRIER)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBPASS_END_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_BARRIER_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEPENDENCY_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBMIT_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_COPY_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_COPY_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_BLIT_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDERING_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PRESENT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUALITY_LEVEL_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_FEEDBACK_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUALITY_LEVEL_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_FEEDBACK_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_HDR_METADATA_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GEOMETRY_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_MAP_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_UNMAP_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_COMPATIBILITY_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RELEASE_SWAPCHAIN_IMAGES_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PRESENT_ID_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_GET_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_FEEDBACK_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CUDA_MODULE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CUDA_FUNCTION_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CUDA_LAUNCH_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECTS_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_METAL_DEVICE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_METAL_BUFFER_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXPORT_METAL_SHARED_EVENT_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SYSMEM_COLOR_SPACE_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_PROPERTIES_IDENTIFIER_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MICROMAP_BUILD_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MICROMAP_VERSION_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MICROMAP_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MICROMAP_BUILD_SIZES_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_VRS_FEATURES_HUAWEI)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_PROPERTIES_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_PROPERTIES_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_INFO_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_SUBMIT_INFO_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_INDIRECT_DEVICE_ADDRESS_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SHADER_MODULE_IDENTIFIER_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_OPTICAL_FLOW_EXECUTE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_FEATURES_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_RESOLVE_PROPERTIES_ANDROID)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_RENDERING_AREA_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SHADER_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_TILE_PROPERTIES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_PROPERTIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LATENCY_SLEEP_MODE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LATENCY_SLEEP_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SET_LATENCY_MARKER_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_GET_LATENCY_MARKER_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LATENCY_TIMINGS_FRAME_REPORT_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_OUT_OF_BAND_QUEUE_TYPE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SWAPCHAIN_LATENCY_CREATE_INFO_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_LATENCY_SURFACE_CAPABILITIES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_CAPABILITIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PICTURE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_DPB_SLOT_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_VIDEO_INLINE_QUERY_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_PROPERTIES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_BLOCK_MATCH_WINDOW_CREATE_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_CUBIC_WEIGHTS_CREATE_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_YCBCR_DEGAMMA_CREATE_INFO_QCOM)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM)
    STRINGISE_ENUM(
        VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SCREEN_BUFFER_PROPERTIES_QNX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SCREEN_BUFFER_FORMAT_PROPERTIES_QNX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_IMPORT_SCREEN_BUFFER_INFO_QNX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_SCREEN_BUFFER_FEATURES_QNX)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_DRIVER_PROPERTIES_MSFT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_WITH_TEMPLATE_INFO_KHR)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_SET_DESCRIPTOR_BUFFER_OFFSETS_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT)
    STRINGISE_ENUM(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkObjectType &el)
{
  BEGIN_ENUM_STRINGISE(VkObjectType);
  {
    STRINGISE_ENUM(VK_OBJECT_TYPE_UNKNOWN)
    STRINGISE_ENUM(VK_OBJECT_TYPE_INSTANCE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_PHYSICAL_DEVICE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DEVICE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_QUEUE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_SEMAPHORE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_COMMAND_BUFFER)
    STRINGISE_ENUM(VK_OBJECT_TYPE_FENCE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DEVICE_MEMORY)
    STRINGISE_ENUM(VK_OBJECT_TYPE_BUFFER)
    STRINGISE_ENUM(VK_OBJECT_TYPE_IMAGE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_EVENT)
    STRINGISE_ENUM(VK_OBJECT_TYPE_QUERY_POOL)
    STRINGISE_ENUM(VK_OBJECT_TYPE_BUFFER_VIEW)
    STRINGISE_ENUM(VK_OBJECT_TYPE_IMAGE_VIEW)
    STRINGISE_ENUM(VK_OBJECT_TYPE_SHADER_MODULE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_PIPELINE_CACHE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_PIPELINE_LAYOUT)
    STRINGISE_ENUM(VK_OBJECT_TYPE_RENDER_PASS)
    STRINGISE_ENUM(VK_OBJECT_TYPE_PIPELINE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT)
    STRINGISE_ENUM(VK_OBJECT_TYPE_SAMPLER)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DESCRIPTOR_POOL)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DESCRIPTOR_SET)
    STRINGISE_ENUM(VK_OBJECT_TYPE_FRAMEBUFFER)
    STRINGISE_ENUM(VK_OBJECT_TYPE_COMMAND_POOL)
    STRINGISE_ENUM(VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE)
    STRINGISE_ENUM(VK_OBJECT_TYPE_SURFACE_KHR)
    STRINGISE_ENUM(VK_OBJECT_TYPE_SWAPCHAIN_KHR)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DISPLAY_KHR)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DISPLAY_MODE_KHR)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT)
    STRINGISE_ENUM(VK_OBJECT_TYPE_CU_MODULE_NVX)
    STRINGISE_ENUM(VK_OBJECT_TYPE_CU_FUNCTION_NVX)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT)
    STRINGISE_ENUM(VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR)
    STRINGISE_ENUM(VK_OBJECT_TYPE_VALIDATION_CACHE_EXT)
    STRINGISE_ENUM(VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV)
    STRINGISE_ENUM(VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL)
    STRINGISE_ENUM(VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR)
    STRINGISE_ENUM(VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV)
    STRINGISE_ENUM(VK_OBJECT_TYPE_CUDA_MODULE_NV)
    STRINGISE_ENUM(VK_OBJECT_TYPE_CUDA_FUNCTION_NV)
    STRINGISE_ENUM(VK_OBJECT_TYPE_PRIVATE_DATA_SLOT_EXT)
    STRINGISE_ENUM(VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA)
    STRINGISE_ENUM(VK_OBJECT_TYPE_MICROMAP_EXT)
    STRINGISE_ENUM(VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV)
    STRINGISE_ENUM(VK_OBJECT_TYPE_SHADER_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkComponentSwizzle &el)
{
  BEGIN_ENUM_STRINGISE(VkComponentSwizzle);
  {
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_IDENTITY)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_ZERO)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_ONE)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_R)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_G)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_B)
    STRINGISE_ENUM(VK_COMPONENT_SWIZZLE_A)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkFormat &el)
{
  BEGIN_ENUM_STRINGISE(VkFormat);
  {
    STRINGISE_ENUM(VK_FORMAT_UNDEFINED)
    STRINGISE_ENUM(VK_FORMAT_R4G4_UNORM_PACK8)
    STRINGISE_ENUM(VK_FORMAT_R4G4B4A4_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_B4G4R4A4_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R5G6B5_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_B5G6R5_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R5G5B5A1_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_B5G5R5A1_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_A1R5G5B5_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R8_UINT)
    STRINGISE_ENUM(VK_FORMAT_R8_SINT)
    STRINGISE_ENUM(VK_FORMAT_R8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_R8G8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8_UINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8_SINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_UINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_SINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_UINT)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_SINT)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_UINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_SINT)
    STRINGISE_ENUM(VK_FORMAT_R8G8B8A8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_UNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_SNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_USCALED)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_UINT)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_SINT)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8A8_SRGB)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_UNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_SNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_USCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_SSCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_UINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_SINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A8B8G8R8_SRGB_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_UNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_SNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_USCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_SSCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_UINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2R10G10B10_SINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_UNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_SNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_USCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_SSCALED_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_UINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_A2B10G10R10_SINT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_R16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R16_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R16_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R16_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R16_UINT)
    STRINGISE_ENUM(VK_FORMAT_R16_SINT)
    STRINGISE_ENUM(VK_FORMAT_R16_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R16G16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16_UINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16_SINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_UINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_SINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_SNORM)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_USCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_SSCALED)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_UINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_SINT)
    STRINGISE_ENUM(VK_FORMAT_R16G16B16A16_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R32_UINT)
    STRINGISE_ENUM(VK_FORMAT_R32_SINT)
    STRINGISE_ENUM(VK_FORMAT_R32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R32G32_UINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32_SINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32_UINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32_SINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32A32_UINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32A32_SINT)
    STRINGISE_ENUM(VK_FORMAT_R32G32B32A32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R64_UINT)
    STRINGISE_ENUM(VK_FORMAT_R64_SINT)
    STRINGISE_ENUM(VK_FORMAT_R64_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R64G64_UINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64_SINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64_UINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64_SINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64A64_UINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64A64_SINT)
    STRINGISE_ENUM(VK_FORMAT_R64G64B64A64_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_B10G11R11_UFLOAT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_E5B9G9R9_UFLOAT_PACK32)
    STRINGISE_ENUM(VK_FORMAT_D16_UNORM)
    STRINGISE_ENUM(VK_FORMAT_X8_D24_UNORM_PACK32)
    STRINGISE_ENUM(VK_FORMAT_D32_SFLOAT)
    STRINGISE_ENUM(VK_FORMAT_S8_UINT)
    STRINGISE_ENUM(VK_FORMAT_D16_UNORM_S8_UINT)
    STRINGISE_ENUM(VK_FORMAT_D24_UNORM_S8_UINT)
    STRINGISE_ENUM(VK_FORMAT_D32_SFLOAT_S8_UINT)
    STRINGISE_ENUM(VK_FORMAT_BC1_RGB_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC1_RGB_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC1_RGBA_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC1_RGBA_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC2_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC2_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC3_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC3_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC4_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC4_SNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC5_SNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC6H_UFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC6H_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC7_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_BC7_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_EAC_R11_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_EAC_R11_SNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_EAC_R11G11_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_EAC_R11G11_SNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_4x4_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_4x4_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x4_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x4_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x5_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x5_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x6_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x6_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x5_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x6_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x6_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x8_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x8_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x5_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x5_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x6_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x6_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x8_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x8_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x10_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x10_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x10_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x10_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x12_UNORM_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x12_SRGB_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_A4R4G4B4_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_A4B4G4R4_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_G8B8G8R8_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_B8G8R8G8_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8R8_2PLANE_420_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8R8_2PLANE_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM)
    STRINGISE_ENUM(VK_FORMAT_R10X6_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R10X6G10X6_UNORM_2PACK16)
    STRINGISE_ENUM(VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_R12X4_UNORM_PACK16)
    STRINGISE_ENUM(VK_FORMAT_R12X4G12X4_UNORM_2PACK16)
    STRINGISE_ENUM(VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16)
    STRINGISE_ENUM(VK_FORMAT_G16B16G16R16_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_B16G16R16G16_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16R16_2PLANE_420_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16R16_2PLANE_422_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM)
    STRINGISE_ENUM(VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG)
    STRINGISE_ENUM(VK_FORMAT_R16G16_S10_5_NV)
    STRINGISE_ENUM(VK_FORMAT_A1B5G5R5_UNORM_PACK16_KHR)
    STRINGISE_ENUM(VK_FORMAT_A8_UNORM_KHR)
    STRINGISE_ENUM(VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK)
    STRINGISE_ENUM(VK_FORMAT_G8_B8R8_2PLANE_444_UNORM)
    STRINGISE_ENUM(VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16_EXT)
    STRINGISE_ENUM(VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16_EXT)
    STRINGISE_ENUM(VK_FORMAT_G16_B16R16_2PLANE_444_UNORM)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkResult &el)
{
  BEGIN_ENUM_STRINGISE(VkResult);
  {
    STRINGISE_ENUM(VK_SUCCESS)
    STRINGISE_ENUM(VK_NOT_READY)
    STRINGISE_ENUM(VK_TIMEOUT)
    STRINGISE_ENUM(VK_EVENT_SET)
    STRINGISE_ENUM(VK_EVENT_RESET)
    STRINGISE_ENUM(VK_INCOMPLETE)
    STRINGISE_ENUM(VK_ERROR_OUT_OF_HOST_MEMORY)
    STRINGISE_ENUM(VK_ERROR_OUT_OF_DEVICE_MEMORY)
    STRINGISE_ENUM(VK_ERROR_INITIALIZATION_FAILED)
    STRINGISE_ENUM(VK_ERROR_DEVICE_LOST)
    STRINGISE_ENUM(VK_ERROR_MEMORY_MAP_FAILED)
    STRINGISE_ENUM(VK_ERROR_LAYER_NOT_PRESENT)
    STRINGISE_ENUM(VK_ERROR_EXTENSION_NOT_PRESENT)
    STRINGISE_ENUM(VK_ERROR_FEATURE_NOT_PRESENT)
    STRINGISE_ENUM(VK_ERROR_INCOMPATIBLE_DRIVER)
    STRINGISE_ENUM(VK_ERROR_TOO_MANY_OBJECTS)
    STRINGISE_ENUM(VK_ERROR_FORMAT_NOT_SUPPORTED)
    STRINGISE_ENUM(VK_ERROR_FRAGMENTED_POOL)
    STRINGISE_ENUM(VK_ERROR_UNKNOWN)
    STRINGISE_ENUM(VK_ERROR_OUT_OF_POOL_MEMORY)
    STRINGISE_ENUM(VK_ERROR_INVALID_EXTERNAL_HANDLE)
    STRINGISE_ENUM(VK_ERROR_FRAGMENTATION)
    STRINGISE_ENUM(VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS)
    STRINGISE_ENUM(VK_PIPELINE_COMPILE_REQUIRED)
    STRINGISE_ENUM(VK_ERROR_SURFACE_LOST_KHR)
    STRINGISE_ENUM(VK_ERROR_NATIVE_WINDOW_IN_USE_KHR)
    STRINGISE_ENUM(VK_SUBOPTIMAL_KHR)
    STRINGISE_ENUM(VK_ERROR_OUT_OF_DATE_KHR)
    STRINGISE_ENUM(VK_ERROR_INCOMPATIBLE_DISPLAY_KHR)
    STRINGISE_ENUM(VK_ERROR_VALIDATION_FAILED_EXT)
    STRINGISE_ENUM(VK_ERROR_INVALID_SHADER_NV)
    STRINGISE_ENUM(VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT)
    STRINGISE_ENUM(VK_ERROR_NOT_PERMITTED_KHR)
    STRINGISE_ENUM(VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT)
    STRINGISE_ENUM(VK_THREAD_IDLE_KHR)
    STRINGISE_ENUM(VK_THREAD_DONE_KHR)
    STRINGISE_ENUM(VK_OPERATION_DEFERRED_KHR)
    STRINGISE_ENUM(VK_OPERATION_NOT_DEFERRED_KHR)
    STRINGISE_ENUM(VK_ERROR_COMPRESSION_EXHAUSTED_EXT)
    STRINGISE_ENUM(VK_ERROR_INCOMPATIBLE_SHADER_BINARY_EXT)
  }
  END_ENUM_STRINGISE();
}

////////////////////////////////////////////////////////////
// VK_KHR_surface
////////////////////////////////////////////////////////////

template <>
rdcstr DoStringise(const VkSurfaceTransformFlagBitsKHR &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSurfaceTransformFlagBitsKHR);
  {
    STRINGISE_BITFIELD_BIT(VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkCompositeAlphaFlagBitsKHR &el)
{
  BEGIN_BITFIELD_STRINGISE(VkCompositeAlphaFlagBitsKHR);
  {
    STRINGISE_BITFIELD_BIT(VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR);
    STRINGISE_BITFIELD_BIT(VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkColorSpaceKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkColorSpaceKHR);
  {
    STRINGISE_ENUM(VK_COLOR_SPACE_SRGB_NONLINEAR_KHR)
    STRINGISE_ENUM(VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_BT709_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_BT709_NONLINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_BT2020_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_HDR10_ST2084_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_DOLBYVISION_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_HDR10_HLG_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_PASS_THROUGH_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT)
    STRINGISE_ENUM(VK_COLOR_SPACE_DISPLAY_NATIVE_AMD)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPresentModeKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkPresentModeKHR);
  {
    STRINGISE_ENUM(VK_PRESENT_MODE_IMMEDIATE_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_MAILBOX_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_FIFO_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_FIFO_RELAXED_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR)
    STRINGISE_ENUM(VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDescriptorUpdateTemplateType &el)
{
  BEGIN_ENUM_STRINGISE(VkDescriptorUpdateTemplateType);
  {
    STRINGISE_ENUM(VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET)
    STRINGISE_ENUM(VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkConservativeRasterizationModeEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkConservativeRasterizationModeEXT);
  {
    STRINGISE_ENUM(VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT)
    STRINGISE_ENUM(VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT)
    STRINGISE_ENUM(VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkTessellationDomainOrigin &el)
{
  BEGIN_ENUM_STRINGISE(VkTessellationDomainOrigin);
  {
    STRINGISE_ENUM(VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT)
    STRINGISE_ENUM(VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSamplerReductionMode &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerReductionMode);
  {
    STRINGISE_ENUM(VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE)
    STRINGISE_ENUM(VK_SAMPLER_REDUCTION_MODE_MIN)
    STRINGISE_ENUM(VK_SAMPLER_REDUCTION_MODE_MAX)
    STRINGISE_ENUM(VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_RANGECLAMP_QCOM)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkTimeDomainEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkTimeDomainEXT);
  {
    STRINGISE_ENUM(VK_TIME_DOMAIN_DEVICE_EXT)
    STRINGISE_ENUM(VK_TIME_DOMAIN_CLOCK_MONOTONIC_EXT)
    STRINGISE_ENUM(VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_EXT)
    STRINGISE_ENUM(VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSamplerYcbcrModelConversion &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerYcbcrModelConversion);
  {
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSamplerYcbcrRange &el)
{
  BEGIN_ENUM_STRINGISE(VkSamplerYcbcrRange);
  {
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_RANGE_ITU_FULL)
    STRINGISE_ENUM(VK_SAMPLER_YCBCR_RANGE_ITU_NARROW)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkChromaLocation &el)
{
  BEGIN_ENUM_STRINGISE(VkChromaLocation);
  {
    STRINGISE_ENUM(VK_CHROMA_LOCATION_COSITED_EVEN)
    STRINGISE_ENUM(VK_CHROMA_LOCATION_MIDPOINT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDeviceQueueCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDeviceQueueCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSubpassDescriptionFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSubpassDescriptionFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX)
    STRINGISE_BITFIELD_BIT(VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX)
    STRINGISE_BITFIELD_BIT(VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM)
    STRINGISE_BITFIELD_BIT(VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM)
    STRINGISE_BITFIELD_BIT(VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_EXT)
    STRINGISE_BITFIELD_BIT(VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT)
    STRINGISE_BITFIELD_BIT(VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDescriptorSetLayoutCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDescriptorSetLayoutCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT)
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT)
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT)
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_SET_LAYOUT_CREATE_INDIRECT_BINDABLE_BIT_NV)
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT)
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSwapchainCreateFlagBitsKHR &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSwapchainCreateFlagBitsKHR);
  {
    STRINGISE_BITFIELD_BIT(VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_EXT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkQueueGlobalPriorityEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkQueueGlobalPriorityEXT);
  {
    STRINGISE_ENUM(VK_QUEUE_GLOBAL_PRIORITY_LOW_EXT)
    STRINGISE_ENUM(VK_QUEUE_GLOBAL_PRIORITY_MEDIUM_EXT)
    STRINGISE_ENUM(VK_QUEUE_GLOBAL_PRIORITY_HIGH_EXT)
    STRINGISE_ENUM(VK_QUEUE_GLOBAL_PRIORITY_REALTIME_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDeviceEventTypeEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkDeviceEventTypeEXT);
  {
    STRINGISE_ENUM(VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkValidationCheckEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkValidationCheckEXT);
  {
    STRINGISE_ENUM(VK_VALIDATION_CHECK_ALL_EXT)
    STRINGISE_ENUM(VK_VALIDATION_CHECK_SHADERS_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkValidationFeatureEnableEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkValidationFeatureEnableEXT);
  {
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkValidationFeatureDisableEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkValidationFeatureDisableEXT);
  {
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_DISABLE_ALL_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_DISABLE_SHADERS_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT)
    STRINGISE_ENUM(VK_VALIDATION_FEATURE_DISABLE_SHADER_VALIDATION_CACHE_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDriverId &el)
{
  BEGIN_ENUM_STRINGISE(VkDriverId);
  {
    STRINGISE_ENUM(VK_DRIVER_ID_AMD_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_AMD_OPEN_SOURCE)
    STRINGISE_ENUM(VK_DRIVER_ID_MESA_RADV)
    STRINGISE_ENUM(VK_DRIVER_ID_NVIDIA_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS)
    STRINGISE_ENUM(VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA)
    STRINGISE_ENUM(VK_DRIVER_ID_IMAGINATION_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_QUALCOMM_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_ARM_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_GOOGLE_SWIFTSHADER)
    STRINGISE_ENUM(VK_DRIVER_ID_GGP_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_BROADCOM_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_MESA_LLVMPIPE)
    STRINGISE_ENUM(VK_DRIVER_ID_MOLTENVK)
    STRINGISE_ENUM(VK_DRIVER_ID_COREAVI_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_JUICE_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_VERISILICON_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_MESA_TURNIP)
    STRINGISE_ENUM(VK_DRIVER_ID_MESA_V3DV)
    STRINGISE_ENUM(VK_DRIVER_ID_MESA_PANVK)
    STRINGISE_ENUM(VK_DRIVER_ID_SAMSUNG_PROPRIETARY)
    STRINGISE_ENUM(VK_DRIVER_ID_MESA_VENUS)
    STRINGISE_ENUM(VK_DRIVER_ID_MESA_DOZEN)
    STRINGISE_ENUM(VK_DRIVER_ID_MESA_NVK)
    STRINGISE_ENUM(VK_DRIVER_ID_IMAGINATION_OPEN_SOURCE_MESA)
    STRINGISE_ENUM(VK_DRIVER_ID_MESA_AGXV)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDisplayPowerStateEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkDisplayPowerStateEXT);
  {
    STRINGISE_ENUM(VK_DISPLAY_POWER_STATE_OFF_EXT)
    STRINGISE_ENUM(VK_DISPLAY_POWER_STATE_SUSPEND_EXT)
    STRINGISE_ENUM(VK_DISPLAY_POWER_STATE_ON_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDisplayEventTypeEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkDisplayEventTypeEXT);
  {
    STRINGISE_ENUM(VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDiscardRectangleModeEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkDiscardRectangleModeEXT);
  {
    STRINGISE_ENUM(VK_DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT)
    STRINGISE_ENUM(VK_DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPerformanceCounterUnitKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkPerformanceCounterUnitKHR);
  {
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPerformanceCounterScopeKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkPerformanceCounterScopeKHR);
  {
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPerformanceCounterStorageKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkPerformanceCounterStorageKHR);
  {
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR)
    STRINGISE_ENUM(VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPointClippingBehavior &el)
{
  BEGIN_ENUM_STRINGISE(VkPointClippingBehavior);
  {
    STRINGISE_ENUM(VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES)
    STRINGISE_ENUM(VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkFragmentShadingRateCombinerOpKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkFragmentShadingRateCombinerOpKHR);
  {
    STRINGISE_ENUM(VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR)
    STRINGISE_ENUM(VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR)
    STRINGISE_ENUM(VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR)
    STRINGISE_ENUM(VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR)
    STRINGISE_ENUM(VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDeviceMemoryReportEventTypeEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkDeviceMemoryReportEventTypeEXT);
  {
    STRINGISE_ENUM(VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT)
    STRINGISE_ENUM(VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT)
    STRINGISE_ENUM(VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT)
    STRINGISE_ENUM(VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT)
    STRINGISE_ENUM(VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkProvokingVertexModeEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkProvokingVertexModeEXT);
  {
    STRINGISE_ENUM(VK_PROVOKING_VERTEX_MODE_FIRST_VERTEX_EXT)
    STRINGISE_ENUM(VK_PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSemaphoreImportFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSemaphoreImportFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SEMAPHORE_IMPORT_TEMPORARY_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkFenceImportFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkFenceImportFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_FENCE_IMPORT_TEMPORARY_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkExternalSemaphoreFeatureFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalSemaphoreFeatureFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT)
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkExternalFenceFeatureFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalFenceFeatureFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT)
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSparseImageFormatFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSparseImageFormatFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT)
    STRINGISE_BITFIELD_BIT(VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT)
    STRINGISE_BITFIELD_BIT(VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkFormatFeatureFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkFormatFeatureFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_BLIT_SRC_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_BLIT_DST_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_TRANSFER_SRC_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_TRANSFER_DST_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT)
    STRINGISE_BITFIELD_BIT(
        VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT)
    STRINGISE_BITFIELD_BIT(
        VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT)
    STRINGISE_BITFIELD_BIT(
        VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_DISJOINT_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkExternalMemoryFeatureFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkExternalMemoryFeatureFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT)
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT)
    STRINGISE_BITFIELD_BIT(VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDisplayPlaneAlphaFlagBitsKHR &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDisplayPlaneAlphaFlagBitsKHR);
  {
    STRINGISE_BITFIELD_BIT(VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSubgroupFeatureFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSubgroupFeatureFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_BASIC_BIT)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_VOTE_BIT)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_ARITHMETIC_BIT)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_BALLOT_BIT)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_SHUFFLE_BIT)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_CLUSTERED_BIT)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_QUAD_BIT)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_PARTITIONED_BIT_NV)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_ROTATE_BIT_KHR)
    STRINGISE_BITFIELD_BIT(VK_SUBGROUP_FEATURE_ROTATE_CLUSTERED_BIT_KHR)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineCreationFeedbackFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineCreationFeedbackFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT)
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT)
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkDescriptorBindingFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkDescriptorBindingFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT)
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT)
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT)
    STRINGISE_BITFIELD_BIT(VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT)
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkFramebufferCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkFramebufferCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineShaderStageCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineShaderStageCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT);
    STRINGISE_BITFIELD_BIT(VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineDepthStencilStateCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineDepthStencilStateCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(
        VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT);
    STRINGISE_BITFIELD_BIT(
        VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineColorBlendStateCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPipelineColorBlendStateCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(
        VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkRenderPassCreateFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkRenderPassCreateFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkShaderFloatControlsIndependence &el)
{
  BEGIN_ENUM_STRINGISE(VkShaderFloatControlsIndependence);
  {
    STRINGISE_ENUM(VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY);
    STRINGISE_ENUM(VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL);
    STRINGISE_ENUM(VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineExecutableStatisticFormatKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkPipelineExecutableStatisticFormatKHR);
  {
    STRINGISE_ENUM(VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR);
    STRINGISE_ENUM(VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR);
    STRINGISE_ENUM(VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR);
    STRINGISE_ENUM(VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkLineRasterizationModeKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkLineRasterizationModeKHR);
  {
    STRINGISE_ENUM(VK_LINE_RASTERIZATION_MODE_DEFAULT_KHR);
    STRINGISE_ENUM(VK_LINE_RASTERIZATION_MODE_RECTANGULAR_KHR);
    STRINGISE_ENUM(VK_LINE_RASTERIZATION_MODE_BRESENHAM_KHR);
    STRINGISE_ENUM(VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_KHR);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSemaphoreType &el)
{
  BEGIN_ENUM_STRINGISE(VkSemaphoreType);
  {
    STRINGISE_ENUM(VK_SEMAPHORE_TYPE_BINARY);
    STRINGISE_ENUM(VK_SEMAPHORE_TYPE_TIMELINE);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkMemoryOverallocationBehaviorAMD &el)
{
  BEGIN_ENUM_STRINGISE(VkMemoryOverallocationBehaviorAMD);
  {
    STRINGISE_ENUM(VK_MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD);
    STRINGISE_ENUM(VK_MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD);
    STRINGISE_ENUM(VK_MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSemaphoreWaitFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSemaphoreWaitFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SEMAPHORE_WAIT_ANY_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkToolPurposeFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkToolPurposeFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_TOOL_PURPOSE_VALIDATION_BIT);
    STRINGISE_BITFIELD_BIT(VK_TOOL_PURPOSE_PROFILING_BIT);
    STRINGISE_BITFIELD_BIT(VK_TOOL_PURPOSE_TRACING_BIT);
    STRINGISE_BITFIELD_BIT(VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT);
    STRINGISE_BITFIELD_BIT(VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT);
    STRINGISE_BITFIELD_BIT(VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkSubmitFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkSubmitFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_SUBMIT_PROTECTED_BIT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPipelineStageFlagBits2 &el)
{
// need a special define here to add specific casting rules
#define STRINGISE_BITFIELD_BIT64(a) STRINGISE_BITFIELD_BIT_NAMED((enumType)a, #a)

  BEGIN_BITFIELD_STRINGISE(VkPipelineStageFlagBits2);
  {
    STRINGISE_BITFIELD_VALUE(VK_PIPELINE_STAGE_2_NONE);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_TRANSFER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_HOST_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_COPY_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_RESOLVE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_BLIT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_CLEAR_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI);
    STRINGISE_BITFIELD_BIT64(VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkAccessFlagBits2 &el)
{
  BEGIN_BITFIELD_STRINGISE(VkAccessFlagBits2);
  {
    STRINGISE_BITFIELD_VALUE(VK_ACCESS_2_NONE);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_INDEX_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_UNIFORM_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_SHADER_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_SHADER_WRITE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_TRANSFER_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_TRANSFER_WRITE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_HOST_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_HOST_WRITE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_MEMORY_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_MEMORY_WRITE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_SHADER_SAMPLED_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_SHADER_STORAGE_READ_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_MICROMAP_READ_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkFormatFeatureFlagBits2 &el)
{
  BEGIN_BITFIELD_STRINGISE(VkFormatFeatureFlagBits2);
  {
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_STORAGE_IMAGE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_STORAGE_IMAGE_ATOMIC_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_UNIFORM_TEXEL_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_ATOMIC_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_VERTEX_BUFFER_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BLEND_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_DEPTH_STENCIL_ATTACHMENT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_BLIT_SRC_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_BLIT_DST_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_LINEAR_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_TRANSFER_SRC_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_TRANSFER_DST_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_MINMAX_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_MIDPOINT_CHROMA_SAMPLES_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT);
    STRINGISE_BITFIELD_BIT64(
        VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT);
    STRINGISE_BITFIELD_BIT64(
        VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT);
    STRINGISE_BITFIELD_BIT64(
        VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_DISJOINT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_COSITED_CHROMA_SAMPLES_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_STORAGE_READ_WITHOUT_FORMAT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_STORAGE_WRITE_WITHOUT_FORMAT_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_DEPTH_COMPARISON_BIT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_VIDEO_DECODE_OUTPUT_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_VIDEO_DECODE_DPB_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_FRAGMENT_DENSITY_MAP_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_HOST_IMAGE_TRANSFER_BIT_EXT);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_VIDEO_ENCODE_INPUT_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_VIDEO_ENCODE_DPB_BIT_KHR);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_WEIGHT_IMAGE_BIT_QCOM);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_WEIGHT_SAMPLED_IMAGE_BIT_QCOM);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_BLOCK_MATCHING_BIT_QCOM);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_BOX_FILTER_SAMPLED_BIT_QCOM);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_OPTICAL_FLOW_IMAGE_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_OPTICAL_FLOW_VECTOR_BIT_NV);
    STRINGISE_BITFIELD_BIT64(VK_FORMAT_FEATURE_2_OPTICAL_FLOW_COST_BIT_NV);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkGraphicsPipelineLibraryFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkGraphicsPipelineLibraryFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkRenderingFlagBits &el)
{
  BEGIN_BITFIELD_STRINGISE(VkRenderingFlagBits);
  {
    STRINGISE_BITFIELD_BIT(VK_RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT);
    STRINGISE_BITFIELD_BIT(VK_RENDERING_SUSPENDING_BIT);
    STRINGISE_BITFIELD_BIT(VK_RENDERING_RESUMING_BIT);
    STRINGISE_BITFIELD_BIT(VK_RENDERING_CONTENTS_INLINE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_RENDERING_ENABLE_LEGACY_DITHERING_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPresentGravityFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPresentGravityFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_PRESENT_GRAVITY_MIN_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PRESENT_GRAVITY_MAX_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PRESENT_GRAVITY_CENTERED_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkPresentScalingFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkPresentScalingFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_PRESENT_SCALING_ONE_TO_ONE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PRESENT_SCALING_ASPECT_RATIO_STRETCH_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_PRESENT_SCALING_STRETCH_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkShaderCodeTypeEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkShaderCodeTypeEXT);
  {
    STRINGISE_ENUM(VK_SHADER_CODE_TYPE_BINARY_EXT);
    STRINGISE_ENUM(VK_SHADER_CODE_TYPE_SPIRV_EXT);
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkShaderCreateFlagBitsEXT &el)
{
  BEGIN_BITFIELD_STRINGISE(VkShaderCreateFlagBitsEXT);
  {
    STRINGISE_BITFIELD_BIT(VK_SHADER_CREATE_LINK_STAGE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_CREATE_NO_TASK_SHADER_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_CREATE_DISPATCH_BASE_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_EXT);
    STRINGISE_BITFIELD_BIT(VK_SHADER_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT);
  }
  END_BITFIELD_STRINGISE();
}

template <>
rdcstr DoStringise(const VkExtent3D &el)
{
  return StringFormat::Fmt("VkExtent3D(%u, %u, %u)", el.width, el.height, el.depth);
}

template <>
rdcstr DoStringise(const VkPackedVersion &el)
{
  return StringFormat::Fmt("VK_MAKE_VERSION(%u, %u, %u)", VK_VERSION_MAJOR(el.version),
                           VK_VERSION_MINOR(el.version), VK_VERSION_PATCH(el.version));
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
template <>
rdcstr DoStringise(const VkFullScreenExclusiveEXT &el)
{
  BEGIN_ENUM_STRINGISE(VkFullScreenExclusiveEXT);
  {
    STRINGISE_ENUM(VK_FULL_SCREEN_EXCLUSIVE_DEFAULT_EXT)
    STRINGISE_ENUM(VK_FULL_SCREEN_EXCLUSIVE_ALLOWED_EXT)
    STRINGISE_ENUM(VK_FULL_SCREEN_EXCLUSIVE_DISALLOWED_EXT)
  }
  END_ENUM_STRINGISE();
}
#endif

template <>
rdcstr DoStringise(const VkAccelerationStructureBuildTypeKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkAccelerationStructureBuildTypeKHR);
  {
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR)
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR)
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkAccelerationStructureCompatibilityKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkAccelerationStructureCompatibilityKHR);
  {
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR)
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkAccelerationStructureCreateFlagBitsKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkAccelerationStructureCreateFlagBitsKHR);
  {
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR)
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT)
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkAccelerationStructureTypeKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkAccelerationStructureTypeKHR);
  {
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR)
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR)
    STRINGISE_ENUM(VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkBuildAccelerationStructureFlagBitsKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkBuildAccelerationStructureFlagBitsKHR);
  {
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_UPDATE_EXT)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DISABLE_OPACITY_MICROMAPS_EXT)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_DATA_UPDATE_EXT)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkBuildAccelerationStructureModeKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkBuildAccelerationStructureModeKHR);
  {
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR)
    STRINGISE_ENUM(VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkCopyAccelerationStructureModeKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkCopyAccelerationStructureModeKHR);
  {
    STRINGISE_ENUM(VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR)
    STRINGISE_ENUM(VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR)
    STRINGISE_ENUM(VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR)
    STRINGISE_ENUM(VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkGeometryFlagBitsKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkGeometryFlagBitsKHR);
  {
    STRINGISE_ENUM(VK_GEOMETRY_OPAQUE_BIT_KHR)
    STRINGISE_ENUM(VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkGeometryInstanceFlagBitsKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkGeometryInstanceFlagBitsKHR);
  {
    STRINGISE_ENUM(VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR)
    STRINGISE_ENUM(VK_GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR)
    STRINGISE_ENUM(VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR)
    STRINGISE_ENUM(VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR)
    STRINGISE_ENUM(VK_GEOMETRY_INSTANCE_FORCE_OPACITY_MICROMAP_2_STATE_EXT)
    STRINGISE_ENUM(VK_GEOMETRY_INSTANCE_DISABLE_OPACITY_MICROMAPS_EXT)
  }
  END_ENUM_STRINGISE();
}

template <>
rdcstr DoStringise(const VkGeometryTypeKHR &el)
{
  BEGIN_ENUM_STRINGISE(VkGeometryTypeKHR);
  {
    STRINGISE_ENUM(VK_GEOMETRY_TYPE_TRIANGLES_KHR)
    STRINGISE_ENUM(VK_GEOMETRY_TYPE_AABBS_KHR)
    STRINGISE_ENUM(VK_GEOMETRY_TYPE_INSTANCES_KHR)
  }
  END_ENUM_STRINGISE();
}
