
/* Copyright © 2015-2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* This file generated from vk_entrypoints_gen.py, don't edit directly. */

#include "nvk_entrypoints.h"

/* Weak aliases for all potential implementations. These will resolve to
 * NULL if they're not defined, which lets the resolve_entrypoint() function
 * either pick the correct entry point.
 *
 * MSVC uses different decorated names for 32-bit versus 64-bit. Declare
 * all argument sizes for 32-bit because computing the actual size would be
 * difficult.
 */




#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateInstance=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateInstance=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateInstance(const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyInstance=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyInstance=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyInstance(VkInstance instance, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDevices@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EnumeratePhysicalDevices=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EnumeratePhysicalDevices=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetInstanceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetInstanceProcAddr=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetInstanceProcAddr=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL nvk_GetInstanceProcAddr(VkInstance instance, const char* pName) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceVersion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EnumerateInstanceVersion=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EnumerateInstanceVersion=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EnumerateInstanceVersion(uint32_t* pApiVersion) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EnumerateInstanceLayerProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EnumerateInstanceLayerProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EnumerateInstanceLayerProperties(uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateInstanceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EnumerateInstanceExtensionProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EnumerateInstanceExtensionProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EnumerateInstanceExtensionProperties(const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAndroidSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateAndroidSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateAndroidSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateAndroidSurfaceKHR(VkInstance instance, const VkAndroidSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayPlaneSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDisplayPlaneSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDisplayPlaneSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDisplayPlaneSurfaceKHR(VkInstance instance, const VkDisplaySurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroySurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroySurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroySurfaceKHR(VkInstance instance, VkSurfaceKHR surface, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_VI_NN
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateViSurfaceNN@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateViSurfaceNN=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateViSurfaceNN=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateViSurfaceNN(VkInstance instance, const VkViSurfaceCreateInfoNN* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWaylandSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateWaylandSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateWaylandSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateWaylandSurfaceKHR(VkInstance instance, const VkWaylandSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateWin32SurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateWin32SurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateWin32SurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateWin32SurfaceKHR(VkInstance instance, const VkWin32SurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXlibSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateXlibSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateXlibSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateXlibSurfaceKHR(VkInstance instance, const VkXlibSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateXcbSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateXcbSurfaceKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateXcbSurfaceKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateXcbSurfaceKHR(VkInstance instance, const VkXcbSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDirectFBSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDirectFBSurfaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDirectFBSurfaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDirectFBSurfaceEXT(VkInstance instance, const VkDirectFBSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImagePipeSurfaceFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateImagePipeSurfaceFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateImagePipeSurfaceFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateImagePipeSurfaceFUCHSIA(VkInstance instance, const VkImagePipeSurfaceCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateStreamDescriptorSurfaceGGP@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateStreamDescriptorSurfaceGGP=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateStreamDescriptorSurfaceGGP=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateStreamDescriptorSurfaceGGP(VkInstance instance, const VkStreamDescriptorSurfaceCreateInfoGGP* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateScreenSurfaceQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateScreenSurfaceQNX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateScreenSurfaceQNX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateScreenSurfaceQNX(VkInstance instance, const VkScreenSurfaceCreateInfoQNX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDebugReportCallbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDebugReportCallbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDebugReportCallbackEXT(VkInstance instance, const VkDebugReportCallbackCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugReportCallbackEXT* pCallback) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyDebugReportCallbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyDebugReportCallbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyDebugReportCallbackEXT(VkInstance instance, VkDebugReportCallbackEXT callback, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugReportMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DebugReportMessageEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DebugReportMessageEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DebugReportMessageEXT(VkInstance instance, VkDebugReportFlagsEXT flags, VkDebugReportObjectTypeEXT objectType, uint64_t object, size_t location, int32_t messageCode, const char* pLayerPrefix, const char* pMessage) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroups@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EnumeratePhysicalDeviceGroups=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EnumeratePhysicalDeviceGroups=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceGroupsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EnumeratePhysicalDeviceGroupsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EnumeratePhysicalDeviceGroupsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EnumeratePhysicalDeviceGroupsKHR(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_IOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateIOSSurfaceMVK=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateIOSSurfaceMVK=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateIOSSurfaceMVK(VkInstance instance, const VkIOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMacOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateMacOSSurfaceMVK=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateMacOSSurfaceMVK=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateMacOSSurfaceMVK(VkInstance instance, const VkMacOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateMetalSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateMetalSurfaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateMetalSurfaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateMetalSurfaceEXT(VkInstance instance, const VkMetalSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDebugUtilsMessengerEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDebugUtilsMessengerEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDebugUtilsMessengerEXT(VkInstance instance, const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugUtilsMessengerEXT* pMessenger) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyDebugUtilsMessengerEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyDebugUtilsMessengerEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerEXT messenger, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SubmitDebugUtilsMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_SubmitDebugUtilsMessageEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_SubmitDebugUtilsMessageEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_SubmitDebugUtilsMessageEXT(VkInstance instance, VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity, VkDebugUtilsMessageTypeFlagsEXT messageTypes, const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateHeadlessSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateHeadlessSurfaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateHeadlessSurfaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateHeadlessSurfaceEXT(VkInstance instance, const VkHeadlessSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));

#endif


const struct vk_instance_entrypoint_table nvk_instance_entrypoints = {
    .CreateInstance = nvk_CreateInstance,
    .DestroyInstance = nvk_DestroyInstance,
    .EnumeratePhysicalDevices = nvk_EnumeratePhysicalDevices,
    .GetInstanceProcAddr = nvk_GetInstanceProcAddr,
    .EnumerateInstanceVersion = nvk_EnumerateInstanceVersion,
    .EnumerateInstanceLayerProperties = nvk_EnumerateInstanceLayerProperties,
    .EnumerateInstanceExtensionProperties = nvk_EnumerateInstanceExtensionProperties,
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    .CreateAndroidSurfaceKHR = nvk_CreateAndroidSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateAndroidSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_ANDROID_KHR
    .CreateDisplayPlaneSurfaceKHR = nvk_CreateDisplayPlaneSurfaceKHR,
    .DestroySurfaceKHR = nvk_DestroySurfaceKHR,
#ifdef VK_USE_PLATFORM_VI_NN
    .CreateViSurfaceNN = nvk_CreateViSurfaceNN,
#elif defined(_MSC_VER)
    .CreateViSurfaceNN = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .CreateWaylandSurfaceKHR = nvk_CreateWaylandSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWaylandSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .CreateWin32SurfaceKHR = nvk_CreateWin32SurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWin32SurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .CreateXlibSurfaceKHR = nvk_CreateXlibSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXlibSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .CreateXcbSurfaceKHR = nvk_CreateXcbSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXcbSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .CreateDirectFBSurfaceEXT = nvk_CreateDirectFBSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateDirectFBSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
    .CreateImagePipeSurfaceFUCHSIA = nvk_CreateImagePipeSurfaceFUCHSIA,
#elif defined(_MSC_VER)
    .CreateImagePipeSurfaceFUCHSIA = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
    .CreateStreamDescriptorSurfaceGGP = nvk_CreateStreamDescriptorSurfaceGGP,
#elif defined(_MSC_VER)
    .CreateStreamDescriptorSurfaceGGP = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .CreateScreenSurfaceQNX = nvk_CreateScreenSurfaceQNX,
#elif defined(_MSC_VER)
    .CreateScreenSurfaceQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .CreateDebugReportCallbackEXT = nvk_CreateDebugReportCallbackEXT,
    .DestroyDebugReportCallbackEXT = nvk_DestroyDebugReportCallbackEXT,
    .DebugReportMessageEXT = nvk_DebugReportMessageEXT,
    .EnumeratePhysicalDeviceGroups = nvk_EnumeratePhysicalDeviceGroups,
    .EnumeratePhysicalDeviceGroupsKHR = nvk_EnumeratePhysicalDeviceGroupsKHR,
#ifdef VK_USE_PLATFORM_IOS_MVK
    .CreateIOSSurfaceMVK = nvk_CreateIOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateIOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
    .CreateMacOSSurfaceMVK = nvk_CreateMacOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateMacOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
    .CreateMetalSurfaceEXT = nvk_CreateMetalSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateMetalSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_METAL_EXT
    .CreateDebugUtilsMessengerEXT = nvk_CreateDebugUtilsMessengerEXT,
    .DestroyDebugUtilsMessengerEXT = nvk_DestroyDebugUtilsMessengerEXT,
    .SubmitDebugUtilsMessageEXT = nvk_SubmitDebugUtilsMessageEXT,
    .CreateHeadlessSurfaceEXT = nvk_CreateHeadlessSurfaceEXT,
};



#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceQueueFamilyProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceQueueFamilyProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceMemoryProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceMemoryProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceFeatures=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceFeatures=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceFormatProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceFormatProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceImageFormatProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceImageFormatProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDevice=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDevice=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EnumerateDeviceLayerProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EnumerateDeviceLayerProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumerateDeviceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EnumerateDeviceExtensionProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EnumerateDeviceExtensionProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSparseImageFormatProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSparseImageFormatProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceDisplayPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceDisplayPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPropertiesKHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlanePropertiesKHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneSupportedDisplaysKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDisplayPlaneSupportedDisplaysKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDisplayPlaneSupportedDisplaysKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex, uint32_t* pDisplayCount, VkDisplayKHR* pDisplays) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDisplayModePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDisplayModePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDisplayModeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDisplayModeKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDisplayModeKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, const VkDisplayModeCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDisplayPlaneCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDisplayPlaneCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode, uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSurfaceSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSurfaceSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, VkSurfaceKHR surface, VkBool32* pSupported) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilitiesKHR* pSurfaceCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormatsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSurfaceFormatsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSurfaceFormatsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pSurfaceFormatCount, VkSurfaceFormatKHR* pSurfaceFormats) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSurfacePresentModesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSurfacePresentModesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWaylandPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceWaylandPresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceWaylandPresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL nvk_GetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct wl_display* display) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceWin32PresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceWin32PresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceWin32PresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL nvk_GetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXlibPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceXlibPresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceXlibPresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL nvk_GetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, Display* dpy, VisualID visualID) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceXcbPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceXcbPresentationSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceXcbPresentationSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL nvk_GetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, xcb_connection_t* connection, xcb_visualid_t visual_id) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, IDirectFB* dfb) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceScreenPresentationSupportQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceScreenPresentationSupportQNX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceScreenPresentationSupportQNX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL nvk_GetPhysicalDeviceScreenPresentationSupportQNX(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct _screen_window* window) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType, VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceFeatures2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceFeatures2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFeatures2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceFeatures2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceFeatures2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceFeatures2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceFormatProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceFormatProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceFormatProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceFormatProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceFormatProperties2KHR(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceImageFormatProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceImageFormatProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceImageFormatProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceImageFormatProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceQueueFamilyProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceQueueFamilyProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceQueueFamilyProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceQueueFamilyProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceQueueFamilyProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceMemoryProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceMemoryProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMemoryProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceMemoryProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceMemoryProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceMemoryProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSparseImageFormatProperties2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSparseImageFormatProperties2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceExternalBufferProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceExternalBufferProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalBufferPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceExternalBufferPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceExternalBufferPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceExternalBufferPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphoreProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceExternalSemaphoreProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceExternalSemaphoreProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFenceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceExternalFenceProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceExternalFenceProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceExternalFencePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceExternalFencePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceExternalFencePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceExternalFencePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ReleaseDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ReleaseDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireXlibDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AcquireXlibDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AcquireXlibDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRandROutputDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetRandROutputDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetRandROutputDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput, VkDisplayKHR* pDisplay) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AcquireWinrtDisplayNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AcquireWinrtDisplayNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AcquireWinrtDisplayNV(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetWinrtDisplayNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetWinrtDisplayNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetWinrtDisplayNV(VkPhysicalDevice physicalDevice, uint32_t deviceRelativeId, VkDisplayKHR* pDisplay) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSurfaceCapabilities2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSurfaceCapabilities2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilities2EXT* pSurfaceCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDevicePresentRectanglesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDevicePresentRectanglesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDevicePresentRectanglesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pRectCount, VkRect2D* pRects) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceMultisamplePropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceMultisamplePropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceMultisamplePropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples, VkMultisamplePropertiesEXT* pMultisampleProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSurfaceCapabilities2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSurfaceCapabilities2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkSurfaceCapabilities2KHR* pSurfaceCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfaceFormats2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSurfaceFormats2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSurfaceFormats2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pSurfaceFormatCount, VkSurfaceFormat2KHR* pSurfaceFormats) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceDisplayProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceDisplayProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayProperties2KHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlaneProperties2KHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayModeProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDisplayModeProperties2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDisplayModeProperties2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDisplayPlaneCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDisplayPlaneCapabilities2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDisplayPlaneCapabilities2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo, VkDisplayPlaneCapabilities2KHR* pCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainKHR* pTimeDomains) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainKHR* pTimeDomains) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesNV* pProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSurfacePresentModes2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSurfacePresentModes2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSurfacePresentModes2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceSurfacePresentModes2EXT(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters, VkPerformanceCounterDescriptionKHR* pCounterDescriptions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(VkPhysicalDevice physicalDevice, uint32_t* pCombinationCount, VkFramebufferMixedSamplesCombinationNV* pCombinations) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceToolProperties=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceToolProperties=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceToolPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceToolPropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceToolPropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceFragmentShadingRatesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceFragmentShadingRatesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceFragmentShadingRatesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount, VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceVideoCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceVideoCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice, const VkVideoProfileInfoKHR* pVideoProfile, VkVideoCapabilitiesKHR* pCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoFormatPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceVideoFormatPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceVideoFormatPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo, uint32_t* pVideoFormatPropertyCount, VkVideoFormatPropertiesKHR* pVideoFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* pQualityLevelInfo, VkVideoEncodeQualityLevelPropertiesKHR* pQualityLevelProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AcquireDrmDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AcquireDrmDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AcquireDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, VkDisplayKHR display) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDrmDisplayEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDrmDisplayEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, uint32_t connectorId, VkDisplayKHR* display) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV(VkPhysicalDevice physicalDevice, const VkOpticalFlowImageFormatInfoNV* pOpticalFlowImageFormatInfo, uint32_t* pFormatCount, VkOpticalFlowImageFormatPropertiesNV* pImageFormatProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesKHR* pProperties) __attribute__ ((weak));

#endif


const struct vk_physical_device_entrypoint_table nvk_physical_device_entrypoints = {
    .GetPhysicalDeviceProperties = nvk_GetPhysicalDeviceProperties,
    .GetPhysicalDeviceQueueFamilyProperties = nvk_GetPhysicalDeviceQueueFamilyProperties,
    .GetPhysicalDeviceMemoryProperties = nvk_GetPhysicalDeviceMemoryProperties,
    .GetPhysicalDeviceFeatures = nvk_GetPhysicalDeviceFeatures,
    .GetPhysicalDeviceFormatProperties = nvk_GetPhysicalDeviceFormatProperties,
    .GetPhysicalDeviceImageFormatProperties = nvk_GetPhysicalDeviceImageFormatProperties,
    .CreateDevice = nvk_CreateDevice,
    .EnumerateDeviceLayerProperties = nvk_EnumerateDeviceLayerProperties,
    .EnumerateDeviceExtensionProperties = nvk_EnumerateDeviceExtensionProperties,
    .GetPhysicalDeviceSparseImageFormatProperties = nvk_GetPhysicalDeviceSparseImageFormatProperties,
    .GetPhysicalDeviceDisplayPropertiesKHR = nvk_GetPhysicalDeviceDisplayPropertiesKHR,
    .GetPhysicalDeviceDisplayPlanePropertiesKHR = nvk_GetPhysicalDeviceDisplayPlanePropertiesKHR,
    .GetDisplayPlaneSupportedDisplaysKHR = nvk_GetDisplayPlaneSupportedDisplaysKHR,
    .GetDisplayModePropertiesKHR = nvk_GetDisplayModePropertiesKHR,
    .CreateDisplayModeKHR = nvk_CreateDisplayModeKHR,
    .GetDisplayPlaneCapabilitiesKHR = nvk_GetDisplayPlaneCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceSupportKHR = nvk_GetPhysicalDeviceSurfaceSupportKHR,
    .GetPhysicalDeviceSurfaceCapabilitiesKHR = nvk_GetPhysicalDeviceSurfaceCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceFormatsKHR = nvk_GetPhysicalDeviceSurfaceFormatsKHR,
    .GetPhysicalDeviceSurfacePresentModesKHR = nvk_GetPhysicalDeviceSurfacePresentModesKHR,
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .GetPhysicalDeviceWaylandPresentationSupportKHR = nvk_GetPhysicalDeviceWaylandPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWaylandPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceWin32PresentationSupportKHR = nvk_GetPhysicalDeviceWin32PresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWin32PresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .GetPhysicalDeviceXlibPresentationSupportKHR = nvk_GetPhysicalDeviceXlibPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXlibPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .GetPhysicalDeviceXcbPresentationSupportKHR = nvk_GetPhysicalDeviceXcbPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXcbPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = nvk_GetPhysicalDeviceDirectFBPresentationSupportEXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceScreenPresentationSupportQNX = nvk_GetPhysicalDeviceScreenPresentationSupportQNX,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceScreenPresentationSupportQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceExternalImageFormatPropertiesNV = nvk_GetPhysicalDeviceExternalImageFormatPropertiesNV,
    .GetPhysicalDeviceFeatures2 = nvk_GetPhysicalDeviceFeatures2,
    .GetPhysicalDeviceFeatures2KHR = nvk_GetPhysicalDeviceFeatures2KHR,
    .GetPhysicalDeviceProperties2 = nvk_GetPhysicalDeviceProperties2,
    .GetPhysicalDeviceProperties2KHR = nvk_GetPhysicalDeviceProperties2KHR,
    .GetPhysicalDeviceFormatProperties2 = nvk_GetPhysicalDeviceFormatProperties2,
    .GetPhysicalDeviceFormatProperties2KHR = nvk_GetPhysicalDeviceFormatProperties2KHR,
    .GetPhysicalDeviceImageFormatProperties2 = nvk_GetPhysicalDeviceImageFormatProperties2,
    .GetPhysicalDeviceImageFormatProperties2KHR = nvk_GetPhysicalDeviceImageFormatProperties2KHR,
    .GetPhysicalDeviceQueueFamilyProperties2 = nvk_GetPhysicalDeviceQueueFamilyProperties2,
    .GetPhysicalDeviceQueueFamilyProperties2KHR = nvk_GetPhysicalDeviceQueueFamilyProperties2KHR,
    .GetPhysicalDeviceMemoryProperties2 = nvk_GetPhysicalDeviceMemoryProperties2,
    .GetPhysicalDeviceMemoryProperties2KHR = nvk_GetPhysicalDeviceMemoryProperties2KHR,
    .GetPhysicalDeviceSparseImageFormatProperties2 = nvk_GetPhysicalDeviceSparseImageFormatProperties2,
    .GetPhysicalDeviceSparseImageFormatProperties2KHR = nvk_GetPhysicalDeviceSparseImageFormatProperties2KHR,
    .GetPhysicalDeviceExternalBufferProperties = nvk_GetPhysicalDeviceExternalBufferProperties,
    .GetPhysicalDeviceExternalBufferPropertiesKHR = nvk_GetPhysicalDeviceExternalBufferPropertiesKHR,
    .GetPhysicalDeviceExternalSemaphoreProperties = nvk_GetPhysicalDeviceExternalSemaphoreProperties,
    .GetPhysicalDeviceExternalSemaphorePropertiesKHR = nvk_GetPhysicalDeviceExternalSemaphorePropertiesKHR,
    .GetPhysicalDeviceExternalFenceProperties = nvk_GetPhysicalDeviceExternalFenceProperties,
    .GetPhysicalDeviceExternalFencePropertiesKHR = nvk_GetPhysicalDeviceExternalFencePropertiesKHR,
    .ReleaseDisplayEXT = nvk_ReleaseDisplayEXT,
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .AcquireXlibDisplayEXT = nvk_AcquireXlibDisplayEXT,
#elif defined(_MSC_VER)
    .AcquireXlibDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .GetRandROutputDisplayEXT = nvk_GetRandROutputDisplayEXT,
#elif defined(_MSC_VER)
    .GetRandROutputDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .AcquireWinrtDisplayNV = nvk_AcquireWinrtDisplayNV,
#elif defined(_MSC_VER)
    .AcquireWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetWinrtDisplayNV = nvk_GetWinrtDisplayNV,
#elif defined(_MSC_VER)
    .GetWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfaceCapabilities2EXT = nvk_GetPhysicalDeviceSurfaceCapabilities2EXT,
    .GetPhysicalDevicePresentRectanglesKHR = nvk_GetPhysicalDevicePresentRectanglesKHR,
    .GetPhysicalDeviceMultisamplePropertiesEXT = nvk_GetPhysicalDeviceMultisamplePropertiesEXT,
    .GetPhysicalDeviceSurfaceCapabilities2KHR = nvk_GetPhysicalDeviceSurfaceCapabilities2KHR,
    .GetPhysicalDeviceSurfaceFormats2KHR = nvk_GetPhysicalDeviceSurfaceFormats2KHR,
    .GetPhysicalDeviceDisplayProperties2KHR = nvk_GetPhysicalDeviceDisplayProperties2KHR,
    .GetPhysicalDeviceDisplayPlaneProperties2KHR = nvk_GetPhysicalDeviceDisplayPlaneProperties2KHR,
    .GetDisplayModeProperties2KHR = nvk_GetDisplayModeProperties2KHR,
    .GetDisplayPlaneCapabilities2KHR = nvk_GetDisplayPlaneCapabilities2KHR,
    .GetPhysicalDeviceCalibrateableTimeDomainsKHR = nvk_GetPhysicalDeviceCalibrateableTimeDomainsKHR,
    .GetPhysicalDeviceCalibrateableTimeDomainsEXT = nvk_GetPhysicalDeviceCalibrateableTimeDomainsEXT,
    .GetPhysicalDeviceCooperativeMatrixPropertiesNV = nvk_GetPhysicalDeviceCooperativeMatrixPropertiesNV,
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfacePresentModes2EXT = nvk_GetPhysicalDeviceSurfacePresentModes2EXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceSurfacePresentModes2EXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = nvk_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR,
    .GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = nvk_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR,
    .GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = nvk_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV,
    .GetPhysicalDeviceToolProperties = nvk_GetPhysicalDeviceToolProperties,
    .GetPhysicalDeviceToolPropertiesEXT = nvk_GetPhysicalDeviceToolPropertiesEXT,
    .GetPhysicalDeviceFragmentShadingRatesKHR = nvk_GetPhysicalDeviceFragmentShadingRatesKHR,
    .GetPhysicalDeviceVideoCapabilitiesKHR = nvk_GetPhysicalDeviceVideoCapabilitiesKHR,
    .GetPhysicalDeviceVideoFormatPropertiesKHR = nvk_GetPhysicalDeviceVideoFormatPropertiesKHR,
    .GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR = nvk_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR,
    .AcquireDrmDisplayEXT = nvk_AcquireDrmDisplayEXT,
    .GetDrmDisplayEXT = nvk_GetDrmDisplayEXT,
    .GetPhysicalDeviceOpticalFlowImageFormatsNV = nvk_GetPhysicalDeviceOpticalFlowImageFormatsNV,
    .GetPhysicalDeviceCooperativeMatrixPropertiesKHR = nvk_GetPhysicalDeviceCooperativeMatrixPropertiesKHR,
};



#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceProcAddr=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceProcAddr=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL nvk_GetDeviceProcAddr(VkDevice device, const char* pName) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyDevice=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyDevice=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceQueue=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceQueue=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSubmit@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_QueueSubmit=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_QueueSubmit=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_QueueWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_QueueWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_QueueWaitIdle(VkQueue queue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeviceWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DeviceWaitIdle=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DeviceWaitIdle=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_DeviceWaitIdle(VkDevice device) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AllocateMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AllocateMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_FreeMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_FreeMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_MapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_MapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UnmapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_UnmapMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_UnmapMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_UnmapMemory(VkDevice device, VkDeviceMemory memory) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FlushMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_FlushMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_FlushMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InvalidateMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_InvalidateMappedMemoryRanges=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_InvalidateMappedMemoryRanges=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryCommitment@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceMemoryCommitment=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceMemoryCommitment=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetBufferMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetBufferMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_BindBufferMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_BindBufferMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_BindImageMemory=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_BindImageMemory=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageSparseMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageSparseMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBindSparse@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_QueueBindSparse=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_QueueBindSparse=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyFence=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyFence=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ResetFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ResetFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetFenceStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetFenceStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetFenceStatus(VkDevice device, VkFence fence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitForFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_WaitForFences=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_WaitForFences=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateSemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateSemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroySemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroySemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetEventStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetEventStatus=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetEventStatus=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetEventStatus(VkDevice device, VkEvent event) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_SetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_SetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_SetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ResetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetQueryPoolEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ResetQueryPoolEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ResetQueryPoolEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyBufferView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyBufferView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSubresourceLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageSubresourceLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageSubresourceLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyImageView=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyImageView=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyShaderModule=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyShaderModule=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreatePipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreatePipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyPipelineCache=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyPipelineCache=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineCacheData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPipelineCacheData=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPipelineCacheData=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergePipelineCaches@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_MergePipelineCaches=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_MergePipelineCaches=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateGraphicsPipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateGraphicsPipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateGraphicsPipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateComputePipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateComputePipelines=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateComputePipelines=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreatePipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreatePipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreatePipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyPipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyPipelineLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyPipelineLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateSampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateSampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroySampler=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroySampler=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyDescriptorSetLayout=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyDescriptorSetLayout=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ResetDescriptorPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ResetDescriptorPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AllocateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AllocateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_FreeDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_FreeDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_UpdateDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_UpdateDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyFramebuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyFramebuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderAreaGranularity@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetRenderAreaGranularity=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetRenderAreaGranularity=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRenderingAreaGranularityKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetRenderingAreaGranularityKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetRenderingAreaGranularityKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetRenderingAreaGranularityKHR(VkDevice device, const VkRenderingAreaInfoKHR* pRenderingAreaInfo, VkExtent2D* pGranularity) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ResetCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ResetCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AllocateCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AllocateCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AllocateCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_FreeCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_FreeCommandBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_FreeCommandBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BeginCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_BeginCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_BeginCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_EndCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_EndCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_EndCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_EndCommandBuffer(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ResetCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ResetCommandBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ResetCommandBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindPipeline=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindPipeline=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAttachmentFeedbackLoopEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetAttachmentFeedbackLoopEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetAttachmentFeedbackLoopEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetAttachmentFeedbackLoopEnableEXT(VkCommandBuffer commandBuffer, VkImageAspectFlags aspectMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetViewport=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetViewport=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissor@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetScissor=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetScissor=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineWidth@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetLineWidth=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetLineWidth=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBias@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthBias=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthBias=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetBlendConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetBlendConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetBlendConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBounds@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthBounds=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthBounds=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilCompareMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetStencilCompareMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetStencilCompareMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilWriteMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetStencilWriteMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetStencilWriteMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilReference@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetStencilReference=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetStencilReference=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindDescriptorSets=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindDescriptorSets=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindIndexBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindIndexBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindVertexBuffers=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindVertexBuffers=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDraw@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDraw=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDraw=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexed@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndexed=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndexed=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawMultiEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawMultiEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMultiIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawMultiIndexedEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawMultiIndexedEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndexedIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndexedIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatch@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDispatch=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDispatch=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDispatchIndirect=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDispatchIndirect=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSubpassShadingHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSubpassShadingHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSubpassShadingHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawClusterHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawClusterHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawClusterHUAWEI(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawClusterIndirectHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawClusterIndirectHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawClusterIndirectHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawClusterIndirectHUAWEI(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdatePipelineIndirectBufferNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdUpdatePipelineIndirectBufferNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdUpdatePipelineIndirectBufferNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdUpdatePipelineIndirectBufferNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint           pipelineBindPoint, VkPipeline                    pipeline) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBlitImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBlitImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBlitImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyBufferToImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyBufferToImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyBufferToImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyImageToBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyImageToBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyImageToBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryIndirectNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyMemoryIndirectNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyMemoryIndirectNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyMemoryIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToImageIndirectNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyMemoryToImageIndirectNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyMemoryToImageIndirectNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyMemoryToImageIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride, VkImage dstImage, VkImageLayout dstImageLayout, const VkImageSubresourceLayers* pImageSubresources) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdUpdateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdUpdateBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdUpdateBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdFillBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdFillBuffer=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdFillBuffer=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearColorImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdClearColorImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdClearColorImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearDepthStencilImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdClearDepthStencilImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdClearDepthStencilImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdClearAttachments@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdClearAttachments=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdClearAttachments=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResolveImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdResolveImage=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdResolveImage=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdResetEvent=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdResetEvent=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWaitEvents@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdWaitEvents=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdWaitEvents=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPipelineBarrier@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdPipelineBarrier=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdPipelineBarrier=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBeginQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBeginQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdEndQuery=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdEndQuery=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBeginConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBeginConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdEndConditionalRenderingEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdEndConditionalRenderingEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdResetQueryPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdResetQueryPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteTimestamp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdWriteTimestamp=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdWriteTimestamp=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyQueryPoolResults=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyQueryPoolResults=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdPushConstants=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdPushConstants=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBeginRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBeginRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdNextSubpass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdNextSubpass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdEndRenderPass=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdEndRenderPass=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdEndRenderPass(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteCommands@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdExecuteCommands=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdExecuteCommands=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSharedSwapchainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateSharedSwapchainsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateSharedSwapchainsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateSwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateSwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroySwapchainKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroySwapchainKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainImagesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSwapchainImagesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSwapchainImagesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImageKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AcquireNextImageKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AcquireNextImageKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueuePresentKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_QueuePresentKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_QueuePresentKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DebugMarkerSetObjectNameEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DebugMarkerSetObjectNameEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DebugMarkerSetObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DebugMarkerSetObjectTagEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DebugMarkerSetObjectTagEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerBeginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDebugMarkerBeginEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDebugMarkerBeginEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerEndEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDebugMarkerEndEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDebugMarkerEndEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDebugMarkerInsertEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDebugMarkerInsertEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDebugMarkerInsertEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryWin32HandleNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryWin32HandleNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdExecuteGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdExecuteGeneratedCommandsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdExecuteGeneratedCommandsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPreprocessGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdPreprocessGeneratedCommandsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdPreprocessGeneratedCommandsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindPipelineShaderGroupNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindPipelineShaderGroupNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindPipelineShaderGroupNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetGeneratedCommandsMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetGeneratedCommandsMemoryRequirementsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetGeneratedCommandsMemoryRequirementsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateIndirectCommandsLayoutNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateIndirectCommandsLayoutNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyIndirectCommandsLayoutNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyIndirectCommandsLayoutNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdPushDescriptorSetKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdPushDescriptorSetKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_TrimCommandPool=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_TrimCommandPool=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_TrimCommandPoolKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_TrimCommandPoolKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_TrimCommandPoolKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryWin32HandlePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryWin32HandlePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryWin32HandlePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryFdPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryFdPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryFdPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryZirconHandleFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryZirconHandleFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryZirconHandlePropertiesFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryZirconHandlePropertiesFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryZirconHandlePropertiesFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryRemoteAddressNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryRemoteAddressNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryRemoteAddressNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSemaphoreWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ImportSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ImportSemaphoreWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSemaphoreFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSemaphoreFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ImportSemaphoreFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ImportSemaphoreFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSemaphoreZirconHandleFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ImportSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ImportSemaphoreZirconHandleFUCHSIA=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetFenceWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetFenceWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ImportFenceWin32HandleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ImportFenceWin32HandleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetFenceFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetFenceFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ImportFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ImportFenceFdKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ImportFenceFdKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DisplayPowerControlEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DisplayPowerControlEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DisplayPowerControlEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDeviceEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_RegisterDeviceEventEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_RegisterDeviceEventEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_RegisterDisplayEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_RegisterDisplayEventEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_RegisterDisplayEventEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainCounterEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSwapchainCounterEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSwapchainCounterEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceGroupPeerMemoryFeatures=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceGroupPeerMemoryFeatures=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPeerMemoryFeaturesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceGroupPeerMemoryFeaturesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceGroupPeerMemoryFeaturesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_BindBufferMemory2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_BindBufferMemory2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_BindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindBufferMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_BindBufferMemory2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_BindBufferMemory2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_BindImageMemory2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_BindImageMemory2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindImageMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_BindImageMemory2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_BindImageMemory2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDeviceMask=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDeviceMask=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDeviceMaskKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDeviceMaskKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDeviceMaskKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupPresentCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceGroupPresentCapabilitiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceGroupPresentCapabilitiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceGroupSurfacePresentModesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceGroupSurfacePresentModesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireNextImage2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AcquireNextImage2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AcquireNextImage2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBase@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDispatchBase=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDispatchBase=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDispatchBaseKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDispatchBaseKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDispatchBaseKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDescriptorUpdateTemplate=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDescriptorUpdateTemplate=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDescriptorUpdateTemplateKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDescriptorUpdateTemplateKHR(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyDescriptorUpdateTemplate=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyDescriptorUpdateTemplate=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyDescriptorUpdateTemplateKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_UpdateDescriptorSetWithTemplate=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_UpdateDescriptorSetWithTemplate=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UpdateDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_UpdateDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_UpdateDescriptorSetWithTemplateKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdPushDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdPushDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdPushDescriptorSetWithTemplateKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetHdrMetadataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_SetHdrMetadataEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_SetHdrMetadataEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainStatusKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSwapchainStatusKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSwapchainStatusKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRefreshCycleDurationGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetRefreshCycleDurationGOOGLE=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetRefreshCycleDurationGOOGLE=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPastPresentationTimingGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPastPresentationTimingGOOGLE=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPastPresentationTimingGOOGLE=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWScalingNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetViewportWScalingNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetViewportWScalingNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDiscardRectangleEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDiscardRectangleEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDiscardRectangleEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDiscardRectangleEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDiscardRectangleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDiscardRectangleModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDiscardRectangleModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDiscardRectangleModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDiscardRectangleModeEXT(VkCommandBuffer commandBuffer, VkDiscardRectangleModeEXT discardRectangleMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleLocationsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetSampleLocationsEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetSampleLocationsEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetBufferMemoryRequirements2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetBufferMemoryRequirements2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetBufferMemoryRequirements2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetBufferMemoryRequirements2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageMemoryRequirements2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageMemoryRequirements2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageMemoryRequirements2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageMemoryRequirements2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageSparseMemoryRequirements2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageSparseMemoryRequirements2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageSparseMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageSparseMemoryRequirements2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageSparseMemoryRequirements2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceBufferMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceBufferMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceBufferMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceBufferMemoryRequirementsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceBufferMemoryRequirementsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceImageMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceImageMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceImageMemoryRequirementsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceImageMemoryRequirementsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceImageSparseMemoryRequirements=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceImageSparseMemoryRequirements=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceImageSparseMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceImageSparseMemoryRequirementsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceImageSparseMemoryRequirementsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateSamplerYcbcrConversion=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateSamplerYcbcrConversion=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateSamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateSamplerYcbcrConversionKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateSamplerYcbcrConversionKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateSamplerYcbcrConversionKHR(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroySamplerYcbcrConversion=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroySamplerYcbcrConversion=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroySamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroySamplerYcbcrConversionKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroySamplerYcbcrConversionKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceQueue2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceQueue2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceQueue2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateValidationCacheEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateValidationCacheEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyValidationCacheEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyValidationCacheEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetValidationCacheDataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetValidationCacheDataEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetValidationCacheDataEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_MergeValidationCachesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_MergeValidationCachesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_MergeValidationCachesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_MergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDescriptorSetLayoutSupport=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDescriptorSetLayoutSupport=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDescriptorSetLayoutSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDescriptorSetLayoutSupportKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDescriptorSetLayoutSupportKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSwapchainGrallocUsageANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSwapchainGrallocUsageANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSwapchainGrallocUsageANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSwapchainGrallocUsage2ANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSwapchainGrallocUsage2ANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSwapchainGrallocUsage2ANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSwapchainGrallocUsage2ANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AcquireImageANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AcquireImageANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AcquireImageANDROID(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSignalReleaseImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_QueueSignalReleaseImageANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_QueueSignalReleaseImageANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_QueueSignalReleaseImageANDROID(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetShaderInfoAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetShaderInfoAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetShaderInfoAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage, VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetLocalDimmingAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_SetLocalDimmingAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_SetLocalDimmingAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_SetLocalDimmingAMD(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetCalibratedTimestampsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetCalibratedTimestampsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetCalibratedTimestampsKHR(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetCalibratedTimestampsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetCalibratedTimestampsEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetCalibratedTimestampsEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetCalibratedTimestampsEXT(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_SetDebugUtilsObjectNameEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_SetDebugUtilsObjectNameEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_SetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SetDebugUtilsObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_SetDebugUtilsObjectTagEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_SetDebugUtilsObjectTagEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_SetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueBeginDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_QueueBeginDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_QueueBeginDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_QueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueEndDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_QueueEndDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_QueueEndDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_QueueEndDebugUtilsLabelEXT(VkQueue queue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueInsertDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_QueueInsertDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_QueueInsertDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_QueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBeginDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBeginDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdEndDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdEndDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdInsertDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdInsertDebugUtilsLabelEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdInsertDebugUtilsLabelEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryHostPointerPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryHostPointerPropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryHostPointerPropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHostPointer, VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteBufferMarkerAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdWriteBufferMarkerAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdWriteBufferMarkerAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateRenderPass2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateRenderPass2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRenderPass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateRenderPass2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateRenderPass2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateRenderPass2KHR(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBeginRenderPass2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBeginRenderPass2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginRenderPass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBeginRenderPass2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBeginRenderPass2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBeginRenderPass2KHR(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdNextSubpass2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdNextSubpass2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdNextSubpass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdNextSubpass2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdNextSubpass2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdNextSubpass2KHR(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdEndRenderPass2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdEndRenderPass2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndRenderPass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdEndRenderPass2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdEndRenderPass2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdEndRenderPass2KHR(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSemaphoreCounterValue=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSemaphoreCounterValue=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetSemaphoreCounterValueKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetSemaphoreCounterValueKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetSemaphoreCounterValueKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetSemaphoreCounterValueKHR(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphores@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_WaitSemaphores=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_WaitSemaphores=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_WaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WaitSemaphoresKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_WaitSemaphoresKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_WaitSemaphoresKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_WaitSemaphoresKHR(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_SignalSemaphore=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_SignalSemaphore=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_SignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_SignalSemaphoreKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_SignalSemaphoreKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_SignalSemaphoreKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_SignalSemaphoreKHR(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAndroidHardwareBufferPropertiesANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetAndroidHardwareBufferPropertiesANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetAndroidHardwareBufferPropertiesANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer, VkAndroidHardwareBufferPropertiesANDROID* pProperties) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetMemoryAndroidHardwareBufferANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetMemoryAndroidHardwareBufferANDROID=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetMemoryAndroidHardwareBufferANDROID=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetMemoryAndroidHardwareBufferANDROID(VkDevice device, const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo, struct AHardwareBuffer** pBuffer) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndirectCount=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndirectCount=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndirectCountKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndirectCountKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectCountAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndirectCountAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndirectCountAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndexedIndirectCount=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndexedIndirectCount=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndexedIndirectCountKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndexedIndirectCountKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndexedIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndexedIndirectCountAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndexedIndirectCountAMD=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndexedIndirectCountAMD=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCheckpointNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetCheckpointNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetCheckpointNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetQueueCheckpointDataNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetQueueCheckpointDataNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetQueueCheckpointDataNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointDataNV* pCheckpointData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindTransformFeedbackBuffersEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindTransformFeedbackBuffersEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindTransformFeedbackBuffersEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginTransformFeedbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBeginTransformFeedbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBeginTransformFeedbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndTransformFeedbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdEndTransformFeedbackEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdEndTransformFeedbackEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBeginQueryIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBeginQueryIndexedEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBeginQueryIndexedEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdEndQueryIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdEndQueryIndexedEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdEndQueryIndexedEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawIndirectByteCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawIndirectByteCountEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawIndirectByteCountEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetExclusiveScissorNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetExclusiveScissorNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetExclusiveScissorEnableNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetExclusiveScissorEnableNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetExclusiveScissorEnableNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetExclusiveScissorEnableNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkBool32* pExclusiveScissorEnables) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindShadingRateImageNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindShadingRateImageNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindShadingRateImageNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportShadingRatePaletteNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetViewportShadingRatePaletteNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetViewportShadingRatePaletteNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkShadingRatePaletteNV* pShadingRatePalettes) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCoarseSampleOrderNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetCoarseSampleOrderNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetCoarseSampleOrderNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType, uint32_t customSampleOrderCount, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawMeshTasksNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawMeshTasksNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawMeshTasksIndirectNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawMeshTasksIndirectNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawMeshTasksIndirectCountNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawMeshTasksIndirectCountNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawMeshTasksEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawMeshTasksEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawMeshTasksEXT(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawMeshTasksIndirectEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawMeshTasksIndirectEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawMeshTasksIndirectEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdDrawMeshTasksIndirectCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdDrawMeshTasksIndirectCountEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdDrawMeshTasksIndirectCountEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdDrawMeshTasksIndirectCountEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CompileDeferredNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CompileDeferredNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CompileDeferredNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateAccelerationStructureNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateAccelerationStructureNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateAccelerationStructureNV(VkDevice device, const VkAccelerationStructureCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureNV* pAccelerationStructure) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindInvocationMaskHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindInvocationMaskHUAWEI=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindInvocationMaskHUAWEI=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindInvocationMaskHUAWEI(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyAccelerationStructureKHR(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyAccelerationStructureNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyAccelerationStructureNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetAccelerationStructureMemoryRequirementsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetAccelerationStructureMemoryRequirementsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetAccelerationStructureMemoryRequirementsNV(VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BindAccelerationStructureMemoryNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_BindAccelerationStructureMemoryNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_BindAccelerationStructureMemoryNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_BindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount, const VkBindAccelerationStructureMemoryInfoNV* pBindInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyAccelerationStructureNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyAccelerationStructureNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CopyAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CopyAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CopyAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyAccelerationStructureToMemoryKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyAccelerationStructureToMemoryKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyAccelerationStructureToMemoryKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyAccelerationStructureToMemoryKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyAccelerationStructureToMemoryKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CopyAccelerationStructureToMemoryKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CopyAccelerationStructureToMemoryKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CopyAccelerationStructureToMemoryKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdCopyMemoryToAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdCopyMemoryToAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdCopyMemoryToAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdCopyMemoryToAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CopyMemoryToAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CopyMemoryToAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CopyMemoryToAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CopyMemoryToAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdWriteAccelerationStructuresPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdWriteAccelerationStructuresPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdWriteAccelerationStructuresPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdWriteAccelerationStructuresPropertiesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdWriteAccelerationStructuresPropertiesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureNV* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBuildAccelerationStructureNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBuildAccelerationStructureNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData, VkDeviceSize instanceOffset, VkBool32 update, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkBuffer scratch, VkDeviceSize scratchOffset) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_WriteAccelerationStructuresPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_WriteAccelerationStructuresPropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_WriteAccelerationStructuresPropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_WriteAccelerationStructuresPropertiesKHR(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdTraceRaysKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdTraceRaysKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdTraceRaysKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, uint32_t width, uint32_t height, uint32_t depth) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdTraceRaysNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdTraceRaysNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer, VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer, VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride, VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset, VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer, VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride, uint32_t width, uint32_t height, uint32_t depth) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetRayTracingShaderGroupHandlesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetRayTracingShaderGroupHandlesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupHandlesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetRayTracingShaderGroupHandlesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetRayTracingShaderGroupHandlesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetRayTracingShaderGroupHandlesNV(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetRayTracingCaptureReplayShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureHandleNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetAccelerationStructureHandleNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetAccelerationStructureHandleNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, size_t dataSize, void* pData) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateRayTracingPipelinesNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateRayTracingPipelinesNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateRayTracingPipelinesNV(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoNV* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateRayTracingPipelinesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateRayTracingPipelinesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateRayTracingPipelinesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateRayTracingPipelinesKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirectKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdTraceRaysIndirectKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdTraceRaysIndirectKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdTraceRaysIndirectKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, VkDeviceAddress indirectDeviceAddress) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdTraceRaysIndirect2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdTraceRaysIndirect2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdTraceRaysIndirect2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdTraceRaysIndirect2KHR(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceAccelerationStructureCompatibilityKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceAccelerationStructureCompatibilityKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceAccelerationStructureCompatibilityKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetRayTracingShaderGroupStackSizeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetRayTracingShaderGroupStackSizeKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetRayTracingShaderGroupStackSizeKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceSize VKAPI_CALL nvk_GetRayTracingShaderGroupStackSizeKHR(VkDevice device, VkPipeline pipeline, uint32_t group, VkShaderGroupShaderKHR groupShader) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRayTracingPipelineStackSizeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetRayTracingPipelineStackSizeKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetRayTracingPipelineStackSizeKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetRayTracingPipelineStackSizeKHR(VkCommandBuffer commandBuffer, uint32_t pipelineStackSize) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewHandleNVX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageViewHandleNVX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageViewHandleNVX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint32_t VKAPI_CALL nvk_GetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageViewAddressNVX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageViewAddressNVX=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageViewAddressNVX=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetImageViewAddressNVX(VkDevice device, VkImageView imageView, VkImageViewAddressPropertiesNVX* pProperties) __attribute__ ((weak));

#endif

#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceGroupSurfacePresentModes2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceGroupSurfacePresentModes2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceGroupSurfacePresentModes2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDeviceGroupSurfacePresentModes2EXT(VkDevice device, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkDeviceGroupPresentModeFlagsKHR* pModes) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireFullScreenExclusiveModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AcquireFullScreenExclusiveModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AcquireFullScreenExclusiveModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AcquireFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseFullScreenExclusiveModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ReleaseFullScreenExclusiveModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ReleaseFullScreenExclusiveModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ReleaseFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));

#endif

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquireProfilingLockKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AcquireProfilingLockKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AcquireProfilingLockKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleaseProfilingLockKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ReleaseProfilingLockKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ReleaseProfilingLockKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_ReleaseProfilingLockKHR(VkDevice device) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetImageDrmFormatModifierPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetImageDrmFormatModifierPropertiesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetImageDrmFormatModifierPropertiesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddress@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetBufferOpaqueCaptureAddress=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetBufferOpaqueCaptureAddress=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL nvk_GetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferOpaqueCaptureAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetBufferOpaqueCaptureAddressKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetBufferOpaqueCaptureAddressKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL nvk_GetBufferOpaqueCaptureAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddress@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetBufferDeviceAddress=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetBufferDeviceAddress=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL nvk_GetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetBufferDeviceAddressKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetBufferDeviceAddressKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL nvk_GetBufferDeviceAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetBufferDeviceAddressEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetBufferDeviceAddressEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetBufferDeviceAddressEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL nvk_GetBufferDeviceAddressEXT(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_InitializePerformanceApiINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_InitializePerformanceApiINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_InitializePerformanceApiINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_InitializePerformanceApiINTEL(VkDevice device, const VkInitializePerformanceApiInfoINTEL* pInitializeInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_UninitializePerformanceApiINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_UninitializePerformanceApiINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_UninitializePerformanceApiINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_UninitializePerformanceApiINTEL(VkDevice device) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceMarkerINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetPerformanceMarkerINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetPerformanceMarkerINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceMarkerInfoINTEL* pMarkerInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceStreamMarkerINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetPerformanceStreamMarkerINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetPerformanceStreamMarkerINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPerformanceOverrideINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetPerformanceOverrideINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetPerformanceOverrideINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, const VkPerformanceOverrideInfoINTEL* pOverrideInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_AcquirePerformanceConfigurationINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_AcquirePerformanceConfigurationINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_AcquirePerformanceConfigurationINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_AcquirePerformanceConfigurationINTEL(VkDevice device, const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo, VkPerformanceConfigurationINTEL* pConfiguration) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_ReleasePerformanceConfigurationINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_ReleasePerformanceConfigurationINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_ReleasePerformanceConfigurationINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_ReleasePerformanceConfigurationINTEL(VkDevice device, VkPerformanceConfigurationINTEL configuration) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_QueueSetPerformanceConfigurationINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_QueueSetPerformanceConfigurationINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_QueueSetPerformanceConfigurationINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_QueueSetPerformanceConfigurationINTEL(VkQueue queue, VkPerformanceConfigurationINTEL configuration) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPerformanceParameterINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPerformanceParameterINTEL=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPerformanceParameterINTEL=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPerformanceParameterINTEL(VkDevice device, VkPerformanceParameterTypeINTEL parameter, VkPerformanceValueINTEL* pValue) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddress@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceMemoryOpaqueCaptureAddress=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceMemoryOpaqueCaptureAddress=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL nvk_GetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeviceMemoryOpaqueCaptureAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeviceMemoryOpaqueCaptureAddressKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeviceMemoryOpaqueCaptureAddressKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL nvk_GetDeviceMemoryOpaqueCaptureAddressKHR(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutablePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPipelineExecutablePropertiesKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPipelineExecutablePropertiesKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPipelineExecutablePropertiesKHR(VkDevice                        device, const VkPipelineInfoKHR*        pPipelineInfo, uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableStatisticsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPipelineExecutableStatisticsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPipelineExecutableStatisticsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPipelineExecutableStatisticsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineExecutableInternalRepresentationsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPipelineExecutableInternalRepresentationsKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPipelineExecutableInternalRepresentationsKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetPipelineExecutableInternalRepresentationsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pInternalRepresentationCount, VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetLineStippleKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetLineStippleKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetLineStippleKHR(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLineStippleEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetLineStippleEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetLineStippleEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetLineStippleEXT(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateAccelerationStructureKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateAccelerationStructureKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateAccelerationStructureKHR(VkDevice                                           device, const VkAccelerationStructureCreateInfoKHR*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkAccelerationStructureKHR*                        pAccelerationStructure) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBuildAccelerationStructuresKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBuildAccelerationStructuresKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBuildAccelerationStructuresKHR(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBuildAccelerationStructuresIndirectKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBuildAccelerationStructuresIndirectKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBuildAccelerationStructuresIndirectKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer                  commandBuffer, uint32_t                                           infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkDeviceAddress*             pIndirectDeviceAddresses, const uint32_t*                    pIndirectStrides, const uint32_t* const*             ppMaxPrimitiveCounts) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_BuildAccelerationStructuresKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_BuildAccelerationStructuresKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_BuildAccelerationStructuresKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_BuildAccelerationStructuresKHR(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetAccelerationStructureDeviceAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetAccelerationStructureDeviceAddressKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetAccelerationStructureDeviceAddressKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL nvk_GetAccelerationStructureDeviceAddressKHR(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CreateDeferredOperationKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CreateDeferredOperationKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CreateDeferredOperationKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_CreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator, VkDeferredOperationKHR* pDeferredOperation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DestroyDeferredOperationKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DestroyDeferredOperationKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DestroyDeferredOperationKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_DestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationMaxConcurrencyKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeferredOperationMaxConcurrencyKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeferredOperationMaxConcurrencyKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR uint32_t VKAPI_CALL nvk_GetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetDeferredOperationResultKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetDeferredOperationResultKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetDeferredOperationResultKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_GetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_DeferredOperationJoinKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_DeferredOperationJoinKHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_DeferredOperationJoinKHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL nvk_DeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPipelineIndirectMemoryRequirementsNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPipelineIndirectMemoryRequirementsNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_GetPipelineIndirectMemoryRequirementsNV(VkDevice device, const VkComputePipelineCreateInfo* pCreateInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_GetPipelineIndirectDeviceAddressNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_GetPipelineIndirectDeviceAddressNV=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_GetPipelineIndirectDeviceAddressNV=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL nvk_GetPipelineIndirectDeviceAddressNV(VkDevice device, const VkPipelineIndirectDeviceAddressInfoNV* pInfo) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullMode@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetCullMode=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetCullMode=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetCullModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetCullModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetCullModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetCullModeEXT(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFace@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetFrontFace=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetFrontFace=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetFrontFaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetFrontFaceEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetFrontFaceEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, VkFrontFace frontFace) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopology@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetPrimitiveTopology=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetPrimitiveTopology=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveTopologyEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetPrimitiveTopologyEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetPrimitiveTopologyEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetViewportWithCount=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetViewportWithCount=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetViewportWithCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetViewportWithCountEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetViewportWithCountEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetScissorWithCount=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetScissorWithCount=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetScissorWithCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetScissorWithCountEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetScissorWithCountEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindIndexBuffer2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindIndexBuffer2KHR=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindIndexBuffer2KHR=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindIndexBuffer2KHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindVertexBuffers2=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindVertexBuffers2=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdBindVertexBuffers2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdBindVertexBuffers2EXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdBindVertexBuffers2EXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthTestEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthTestEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthTestEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthTestEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthTestEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthWriteEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthWriteEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthWriteEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthWriteEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthWriteEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthCompareOp=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthCompareOp=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthCompareOpEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthCompareOpEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthCompareOpEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthBoundsTestEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthBoundsTestEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBoundsTestEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthBoundsTestEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthBoundsTestEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetStencilTestEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetStencilTestEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilTestEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetStencilTestEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetStencilTestEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetStencilOp=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetStencilOp=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetStencilOpEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetStencilOpEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetStencilOpEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetStencilOpEXT(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPatchControlPointsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetPatchControlPointsEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetPatchControlPointsEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, uint32_t patchControlPoints) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetRasterizerDiscardEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetRasterizerDiscardEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizerDiscardEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetRasterizerDiscardEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetRasterizerDiscardEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetRasterizerDiscardEnableEXT(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthBiasEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthBiasEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthBiasEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthBiasEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthBiasEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthBiasEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetLogicOpEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetLogicOpEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetLogicOpEXT(VkCommandBuffer commandBuffer, VkLogicOp logicOp) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetPrimitiveRestartEnable=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetPrimitiveRestartEnable=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPrimitiveRestartEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetPrimitiveRestartEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetPrimitiveRestartEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetPrimitiveRestartEnableEXT(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetTessellationDomainOriginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetTessellationDomainOriginEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetTessellationDomainOriginEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetTessellationDomainOriginEXT(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetDepthClampEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetDepthClampEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetDepthClampEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetDepthClampEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetPolygonModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetPolygonModeEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetPolygonModeEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetPolygonModeEXT(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetRasterizationSamplesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetRasterizationSamplesEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetRasterizationSamplesEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetRasterizationSamplesEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  rasterizationSamples) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetSampleMaskEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetSampleMaskEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetSampleMaskEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  samples, const VkSampleMask*    pSampleMask) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToCoverageEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetAlphaToCoverageEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetAlphaToCoverageEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetAlphaToCoverageEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetAlphaToOneEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetAlphaToOneEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetAlphaToOneEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetAlphaToOneEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetLogicOpEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetLogicOpEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetLogicOpEnableEXT=#vk_entrypoint_stub")
#endif
#endif
#else
    VKAPI_ATTR void VKAPI_CALL nvk_CmdSetLogicOpEnableEXT(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable) __attribute__ ((weak));

#endif

#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_nvk_CmdSetColorBlendEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:nvk_CmdSetColorBlendEnableEXT=vk_entrypoint_stub")
#if defined(_M_ARM64EC)
    #pragma comment(linker, "/alternatename:#nvk_CmdSetColorBlendEnableEXT=#vk_entrypoint_stub")
