#include "nvk_clc3c0.h"

#include <stdio.h>

const char*
P_PARSE_NVC3C0_MTHD(uint16_t idx)
{
    switch (idx) {
    case NVC3C0_SET_OBJECT:
        return "NVC3C0_SET_OBJECT";
    case NVC3C0_NO_OPERATION:
        return "NVC3C0_NO_OPERATION";
    case NVC3C0_SET_NOTIFY_A:
        return "NVC3C0_SET_NOTIFY_A";
    case NVC3C0_SET_NOTIFY_B:
        return "NVC3C0_SET_NOTIFY_B";
    case NVC3C0_NOTIFY:
        return "NVC3C0_NOTIFY";
    case NVC3C0_WAIT_FOR_IDLE:
        return "NVC3C0_WAIT_FOR_IDLE";
    case NVC3C0_SET_GLOBAL_RENDER_ENABLE_A:
        return "NVC3C0_SET_GLOBAL_RENDER_ENABLE_A";
    case NVC3C0_SET_GLOBAL_RENDER_ENABLE_B:
        return "NVC3C0_SET_GLOBAL_RENDER_ENABLE_B";
    case NVC3C0_SET_GLOBAL_RENDER_ENABLE_C:
        return "NVC3C0_SET_GLOBAL_RENDER_ENABLE_C";
    case NVC3C0_SEND_GO_IDLE:
        return "NVC3C0_SEND_GO_IDLE";
    case NVC3C0_PM_TRIGGER:
        return "NVC3C0_PM_TRIGGER";
    case NVC3C0_PM_TRIGGER_WFI:
        return "NVC3C0_PM_TRIGGER_WFI";
    case NVC3C0_FE_ATOMIC_SEQUENCE_BEGIN:
        return "NVC3C0_FE_ATOMIC_SEQUENCE_BEGIN";
    case NVC3C0_FE_ATOMIC_SEQUENCE_END:
        return "NVC3C0_FE_ATOMIC_SEQUENCE_END";
    case NVC3C0_SET_INSTRUMENTATION_METHOD_HEADER:
        return "NVC3C0_SET_INSTRUMENTATION_METHOD_HEADER";
    case NVC3C0_SET_INSTRUMENTATION_METHOD_DATA:
        return "NVC3C0_SET_INSTRUMENTATION_METHOD_DATA";
    case NVC3C0_LINE_LENGTH_IN:
        return "NVC3C0_LINE_LENGTH_IN";
    case NVC3C0_LINE_COUNT:
        return "NVC3C0_LINE_COUNT";
    case NVC3C0_OFFSET_OUT_UPPER:
        return "NVC3C0_OFFSET_OUT_UPPER";
    case NVC3C0_OFFSET_OUT:
        return "NVC3C0_OFFSET_OUT";
    case NVC3C0_PITCH_OUT:
        return "NVC3C0_PITCH_OUT";
    case NVC3C0_SET_DST_BLOCK_SIZE:
        return "NVC3C0_SET_DST_BLOCK_SIZE";
    case NVC3C0_SET_DST_WIDTH:
        return "NVC3C0_SET_DST_WIDTH";
    case NVC3C0_SET_DST_HEIGHT:
        return "NVC3C0_SET_DST_HEIGHT";
    case NVC3C0_SET_DST_DEPTH:
        return "NVC3C0_SET_DST_DEPTH";
    case NVC3C0_SET_DST_LAYER:
        return "NVC3C0_SET_DST_LAYER";
    case NVC3C0_SET_DST_ORIGIN_BYTES_X:
        return "NVC3C0_SET_DST_ORIGIN_BYTES_X";
    case NVC3C0_SET_DST_ORIGIN_SAMPLES_Y:
        return "NVC3C0_SET_DST_ORIGIN_SAMPLES_Y";
    case NVC3C0_LAUNCH_DMA:
        return "NVC3C0_LAUNCH_DMA";
    case NVC3C0_LOAD_INLINE_DATA:
        return "NVC3C0_LOAD_INLINE_DATA";
    case NVC3C0_SET_I2M_SEMAPHORE_A:
        return "NVC3C0_SET_I2M_SEMAPHORE_A";
    case NVC3C0_SET_I2M_SEMAPHORE_B:
        return "NVC3C0_SET_I2M_SEMAPHORE_B";
    case NVC3C0_SET_I2M_SEMAPHORE_C:
        return "NVC3C0_SET_I2M_SEMAPHORE_C";
    case NVC3C0_SET_I2M_SPARE_NOOP00:
        return "NVC3C0_SET_I2M_SPARE_NOOP00";
    case NVC3C0_SET_I2M_SPARE_NOOP01:
        return "NVC3C0_SET_I2M_SPARE_NOOP01";
    case NVC3C0_SET_I2M_SPARE_NOOP02:
        return "NVC3C0_SET_I2M_SPARE_NOOP02";
    case NVC3C0_SET_I2M_SPARE_NOOP03:
        return "NVC3C0_SET_I2M_SPARE_NOOP03";
    case NVC3C0_SET_VALID_SPAN_OVERFLOW_AREA_A:
        return "NVC3C0_SET_VALID_SPAN_OVERFLOW_AREA_A";
    case NVC3C0_SET_VALID_SPAN_OVERFLOW_AREA_B:
        return "NVC3C0_SET_VALID_SPAN_OVERFLOW_AREA_B";
    case NVC3C0_SET_VALID_SPAN_OVERFLOW_AREA_C:
        return "NVC3C0_SET_VALID_SPAN_OVERFLOW_AREA_C";
    case NVC3C0_PERFMON_TRANSFER:
        return "NVC3C0_PERFMON_TRANSFER";
    case NVC3C0_INVALIDATE_SHADER_CACHES:
        return "NVC3C0_INVALIDATE_SHADER_CACHES";
    case NVC3C0_SET_RESERVED_SW_METHOD00:
        return "NVC3C0_SET_RESERVED_SW_METHOD00";
    case NVC3C0_SET_RESERVED_SW_METHOD01:
        return "NVC3C0_SET_RESERVED_SW_METHOD01";
    case NVC3C0_SET_RESERVED_SW_METHOD02:
        return "NVC3C0_SET_RESERVED_SW_METHOD02";
    case NVC3C0_SET_RESERVED_SW_METHOD03:
        return "NVC3C0_SET_RESERVED_SW_METHOD03";
    case NVC3C0_SET_RESERVED_SW_METHOD04:
        return "NVC3C0_SET_RESERVED_SW_METHOD04";
    case NVC3C0_SET_RESERVED_SW_METHOD05:
        return "NVC3C0_SET_RESERVED_SW_METHOD05";
    case NVC3C0_SET_RESERVED_SW_METHOD06:
        return "NVC3C0_SET_RESERVED_SW_METHOD06";
    case NVC3C0_SET_RESERVED_SW_METHOD07:
        return "NVC3C0_SET_RESERVED_SW_METHOD07";
    case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
        return "NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI";
    case NVC3C0_SET_CWD_REF_COUNTER:
        return "NVC3C0_SET_CWD_REF_COUNTER";
    case NVC3C0_SET_RESERVED_SW_METHOD08:
        return "NVC3C0_SET_RESERVED_SW_METHOD08";
    case NVC3C0_SET_RESERVED_SW_METHOD09:
        return "NVC3C0_SET_RESERVED_SW_METHOD09";
    case NVC3C0_SET_RESERVED_SW_METHOD10:
        return "NVC3C0_SET_RESERVED_SW_METHOD10";
    case NVC3C0_SET_RESERVED_SW_METHOD11:
        return "NVC3C0_SET_RESERVED_SW_METHOD11";
    case NVC3C0_SET_RESERVED_SW_METHOD12:
        return "NVC3C0_SET_RESERVED_SW_METHOD12";
    case NVC3C0_SET_RESERVED_SW_METHOD13:
        return "NVC3C0_SET_RESERVED_SW_METHOD13";
    case NVC3C0_SET_RESERVED_SW_METHOD14:
        return "NVC3C0_SET_RESERVED_SW_METHOD14";
    case NVC3C0_SET_RESERVED_SW_METHOD15:
        return "NVC3C0_SET_RESERVED_SW_METHOD15";
    case NVC3C0_SET_SCG_CONTROL:
        return "NVC3C0_SET_SCG_CONTROL";
    case NVC3C0_SET_COMPUTE_CLASS_VERSION:
        return "NVC3C0_SET_COMPUTE_CLASS_VERSION";
    case NVC3C0_CHECK_COMPUTE_CLASS_VERSION:
        return "NVC3C0_CHECK_COMPUTE_CLASS_VERSION";
    case NVC3C0_SET_QMD_VERSION:
        return "NVC3C0_SET_QMD_VERSION";
    case NVC3C0_CHECK_QMD_VERSION:
        return "NVC3C0_CHECK_QMD_VERSION";
    case NVC3C0_INVALIDATE_SKED_CACHES:
        return "NVC3C0_INVALIDATE_SKED_CACHES";
    case NVC3C0_SET_SHADER_SHARED_MEMORY_WINDOW_A:
        return "NVC3C0_SET_SHADER_SHARED_MEMORY_WINDOW_A";
    case NVC3C0_SET_SHADER_SHARED_MEMORY_WINDOW_B:
        return "NVC3C0_SET_SHADER_SHARED_MEMORY_WINDOW_B";
    case NVC3C0_SCG_HYSTERESIS_CONTROL:
        return "NVC3C0_SCG_HYSTERESIS_CONTROL";
    case NVC3C0_SET_CWD_SLOT_COUNT:
        return "NVC3C0_SET_CWD_SLOT_COUNT";
    case NVC3C0_SEND_PCAS_A:
        return "NVC3C0_SEND_PCAS_A";
    case NVC3C0_SEND_PCAS_B:
        return "NVC3C0_SEND_PCAS_B";
    case NVC3C0_SEND_SIGNALING_PCAS_B:
        return "NVC3C0_SEND_SIGNALING_PCAS_B";
    case NVC3C0_SET_SKED_CACHE_CONTROL:
        return "NVC3C0_SET_SKED_CACHE_CONTROL";
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A:
        return "NVC3C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A";
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B:
        return "NVC3C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B";
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C:
        return "NVC3C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C";
    case NVC3C0_SET_SPA_VERSION:
        return "NVC3C0_SET_SPA_VERSION";
    case NVC3C0_SET_INLINE_QMD_ADDRESS_A:
        return "NVC3C0_SET_INLINE_QMD_ADDRESS_A";
    case NVC3C0_SET_INLINE_QMD_ADDRESS_B:
        return "NVC3C0_SET_INLINE_QMD_ADDRESS_B";
    case NVC3C0_LOAD_INLINE_QMD_DATA(0):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(0)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(1):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(1)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(2):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(2)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(3):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(3)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(4):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(4)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(5):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(5)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(6):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(6)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(7):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(7)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(8):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(8)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(9):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(9)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(10):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(10)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(11):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(11)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(12):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(12)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(13):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(13)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(14):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(14)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(15):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(15)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(16):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(16)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(17):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(17)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(18):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(18)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(19):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(19)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(20):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(20)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(21):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(21)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(22):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(22)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(23):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(23)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(24):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(24)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(25):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(25)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(26):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(26)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(27):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(27)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(28):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(28)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(29):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(29)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(30):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(30)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(31):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(31)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(32):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(32)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(33):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(33)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(34):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(34)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(35):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(35)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(36):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(36)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(37):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(37)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(38):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(38)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(39):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(39)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(40):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(40)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(41):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(41)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(42):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(42)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(43):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(43)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(44):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(44)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(45):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(45)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(46):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(46)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(47):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(47)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(48):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(48)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(49):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(49)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(50):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(50)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(51):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(51)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(52):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(52)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(53):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(53)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(54):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(54)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(55):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(55)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(56):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(56)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(57):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(57)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(58):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(58)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(59):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(59)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(60):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(60)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(61):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(61)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(62):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(62)";
    case NVC3C0_LOAD_INLINE_QMD_DATA(63):
        return "NVC3C0_LOAD_INLINE_QMD_DATA(63)";
    case NVC3C0_SET_FALCON00:
        return "NVC3C0_SET_FALCON00";
    case NVC3C0_SET_FALCON01:
        return "NVC3C0_SET_FALCON01";
    case NVC3C0_SET_FALCON02:
        return "NVC3C0_SET_FALCON02";
    case NVC3C0_SET_FALCON03:
        return "NVC3C0_SET_FALCON03";
    case NVC3C0_SET_FALCON04:
        return "NVC3C0_SET_FALCON04";
    case NVC3C0_SET_FALCON05:
        return "NVC3C0_SET_FALCON05";
    case NVC3C0_SET_FALCON06:
        return "NVC3C0_SET_FALCON06";
    case NVC3C0_SET_FALCON07:
        return "NVC3C0_SET_FALCON07";
    case NVC3C0_SET_FALCON08:
        return "NVC3C0_SET_FALCON08";
    case NVC3C0_SET_FALCON09:
        return "NVC3C0_SET_FALCON09";
    case NVC3C0_SET_FALCON10:
        return "NVC3C0_SET_FALCON10";
    case NVC3C0_SET_FALCON11:
        return "NVC3C0_SET_FALCON11";
    case NVC3C0_SET_FALCON12:
        return "NVC3C0_SET_FALCON12";
    case NVC3C0_SET_FALCON13:
        return "NVC3C0_SET_FALCON13";
    case NVC3C0_SET_FALCON14:
        return "NVC3C0_SET_FALCON14";
    case NVC3C0_SET_FALCON15:
        return "NVC3C0_SET_FALCON15";
    case NVC3C0_SET_FALCON16:
        return "NVC3C0_SET_FALCON16";
    case NVC3C0_SET_FALCON17:
        return "NVC3C0_SET_FALCON17";
    case NVC3C0_SET_FALCON18:
        return "NVC3C0_SET_FALCON18";
    case NVC3C0_SET_FALCON19:
        return "NVC3C0_SET_FALCON19";
    case NVC3C0_SET_FALCON20:
        return "NVC3C0_SET_FALCON20";
    case NVC3C0_SET_FALCON21:
        return "NVC3C0_SET_FALCON21";
    case NVC3C0_SET_FALCON22:
        return "NVC3C0_SET_FALCON22";
    case NVC3C0_SET_FALCON23:
        return "NVC3C0_SET_FALCON23";
    case NVC3C0_SET_FALCON24:
        return "NVC3C0_SET_FALCON24";
    case NVC3C0_SET_FALCON25:
        return "NVC3C0_SET_FALCON25";
    case NVC3C0_SET_FALCON26:
        return "NVC3C0_SET_FALCON26";
    case NVC3C0_SET_FALCON27:
        return "NVC3C0_SET_FALCON27";
    case NVC3C0_SET_FALCON28:
        return "NVC3C0_SET_FALCON28";
    case NVC3C0_SET_FALCON29:
        return "NVC3C0_SET_FALCON29";
    case NVC3C0_SET_FALCON30:
        return "NVC3C0_SET_FALCON30";
    case NVC3C0_SET_FALCON31:
        return "NVC3C0_SET_FALCON31";
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_A:
        return "NVC3C0_SET_SHADER_LOCAL_MEMORY_A";
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_B:
        return "NVC3C0_SET_SHADER_LOCAL_MEMORY_B";
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A:
        return "NVC3C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A";
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B:
        return "NVC3C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B";
    case NVC3C0_SET_SHADER_CACHE_CONTROL:
        return "NVC3C0_SET_SHADER_CACHE_CONTROL";
    case NVC3C0_SET_SM_TIMEOUT_INTERVAL:
        return "NVC3C0_SET_SM_TIMEOUT_INTERVAL";
    case NVC3C0_INVALIDATE_SAMPLER_CACHE_ALL:
        return "NVC3C0_INVALIDATE_SAMPLER_CACHE_ALL";
    case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_ALL:
        return "NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_ALL";
    case NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
        return "NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI";
    case NVC3C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT:
        return "NVC3C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT";
    case NVC3C0_INVALIDATE_SAMPLER_CACHE:
        return "NVC3C0_INVALIDATE_SAMPLER_CACHE";
    case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE:
        return "NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE";
    case NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE:
        return "NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE";
    case NVC3C0_INVALIDATE_SAMPLER_CACHE_NO_WFI:
        return "NVC3C0_INVALIDATE_SAMPLER_CACHE_NO_WFI";
    case NVC3C0_SET_SHADER_EXCEPTIONS:
        return "NVC3C0_SET_SHADER_EXCEPTIONS";
    case NVC3C0_SET_RENDER_ENABLE_A:
        return "NVC3C0_SET_RENDER_ENABLE_A";
    case NVC3C0_SET_RENDER_ENABLE_B:
        return "NVC3C0_SET_RENDER_ENABLE_B";
    case NVC3C0_SET_RENDER_ENABLE_C:
        return "NVC3C0_SET_RENDER_ENABLE_C";
    case NVC3C0_SET_TEX_SAMPLER_POOL_A:
        return "NVC3C0_SET_TEX_SAMPLER_POOL_A";
    case NVC3C0_SET_TEX_SAMPLER_POOL_B:
        return "NVC3C0_SET_TEX_SAMPLER_POOL_B";
    case NVC3C0_SET_TEX_SAMPLER_POOL_C:
        return "NVC3C0_SET_TEX_SAMPLER_POOL_C";
    case NVC3C0_SET_TEX_HEADER_POOL_A:
        return "NVC3C0_SET_TEX_HEADER_POOL_A";
    case NVC3C0_SET_TEX_HEADER_POOL_B:
        return "NVC3C0_SET_TEX_HEADER_POOL_B";
    case NVC3C0_SET_TEX_HEADER_POOL_C:
        return "NVC3C0_SET_TEX_HEADER_POOL_C";
    case NVC3C0_INVALIDATE_SHADER_CACHES_NO_WFI:
        return "NVC3C0_INVALIDATE_SHADER_CACHES_NO_WFI";
    case NVC3C0_SET_RENDER_ENABLE_OVERRIDE:
        return "NVC3C0_SET_RENDER_ENABLE_OVERRIDE";
    case NVC3C0_PIPE_NOP:
        return "NVC3C0_PIPE_NOP";
    case NVC3C0_SET_SPARE00:
        return "NVC3C0_SET_SPARE00";
    case NVC3C0_SET_SPARE01:
        return "NVC3C0_SET_SPARE01";
    case NVC3C0_SET_SPARE02:
        return "NVC3C0_SET_SPARE02";
    case NVC3C0_SET_SPARE03:
        return "NVC3C0_SET_SPARE03";
    case NVC3C0_SET_REPORT_SEMAPHORE_A:
        return "NVC3C0_SET_REPORT_SEMAPHORE_A";
    case NVC3C0_SET_REPORT_SEMAPHORE_B:
        return "NVC3C0_SET_REPORT_SEMAPHORE_B";
    case NVC3C0_SET_REPORT_SEMAPHORE_C:
        return "NVC3C0_SET_REPORT_SEMAPHORE_C";
    case NVC3C0_SET_REPORT_SEMAPHORE_D:
        return "NVC3C0_SET_REPORT_SEMAPHORE_D";
    case NVC3C0_SET_TRAP_HANDLER_A:
        return "NVC3C0_SET_TRAP_HANDLER_A";
    case NVC3C0_SET_TRAP_HANDLER_B:
        return "NVC3C0_SET_TRAP_HANDLER_B";
    case NVC3C0_SET_BINDLESS_TEXTURE:
        return "NVC3C0_SET_BINDLESS_TEXTURE";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6)";
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7):
        return "NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7)";
    case NVC3C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
        return "NVC3C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER";
    case NVC3C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
        return "NVC3C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7)";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL";
    case NVC3C0_START_SHADER_PERFORMANCE_COUNTER:
        return "NVC3C0_START_SHADER_PERFORMANCE_COUNTER";
    case NVC3C0_STOP_SHADER_PERFORMANCE_COUNTER:
        return "NVC3C0_STOP_SHADER_PERFORMANCE_COUNTER";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER";
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:
        return "NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(0):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(0)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(1):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(1)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(2):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(2)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(3):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(3)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(4):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(4)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(5):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(5)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(6):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(6)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(7):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(7)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(8):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(8)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(9):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(9)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(10):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(10)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(11):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(11)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(12):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(12)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(13):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(13)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(14):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(14)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(15):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(15)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(16):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(16)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(17):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(17)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(18):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(18)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(19):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(19)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(20):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(20)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(21):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(21)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(22):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(22)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(23):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(23)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(24):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(24)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(25):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(25)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(26):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(26)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(27):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(27)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(28):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(28)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(29):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(29)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(30):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(30)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(31):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(31)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(32):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(32)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(33):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(33)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(34):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(34)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(35):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(35)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(36):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(36)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(37):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(37)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(38):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(38)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(39):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(39)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(40):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(40)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(41):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(41)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(42):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(42)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(43):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(43)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(44):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(44)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(45):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(45)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(46):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(46)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(47):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(47)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(48):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(48)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(49):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(49)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(50):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(50)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(51):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(51)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(52):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(52)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(53):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(53)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(54):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(54)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(55):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(55)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(56):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(56)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(57):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(57)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(58):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(58)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(59):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(59)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(60):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(60)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(61):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(61)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(62):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(62)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(63):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(63)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(64):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(64)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(65):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(65)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(66):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(66)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(67):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(67)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(68):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(68)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(69):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(69)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(70):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(70)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(71):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(71)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(72):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(72)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(73):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(73)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(74):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(74)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(75):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(75)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(76):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(76)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(77):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(77)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(78):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(78)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(79):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(79)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(80):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(80)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(81):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(81)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(82):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(82)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(83):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(83)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(84):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(84)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(85):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(85)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(86):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(86)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(87):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(87)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(88):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(88)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(89):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(89)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(90):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(90)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(91):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(91)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(92):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(92)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(93):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(93)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(94):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(94)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(95):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(95)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(96):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(96)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(97):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(97)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(98):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(98)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(99):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(99)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(100):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(100)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(101):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(101)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(102):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(102)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(103):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(103)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(104):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(104)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(105):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(105)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(106):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(106)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(107):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(107)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(108):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(108)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(109):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(109)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(110):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(110)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(111):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(111)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(112):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(112)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(113):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(113)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(114):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(114)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(115):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(115)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(116):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(116)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(117):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(117)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(118):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(118)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(119):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(119)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(120):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(120)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(121):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(121)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(122):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(122)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(123):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(123)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(124):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(124)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(125):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(125)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(126):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(126)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(127):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(127)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(128):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(128)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(129):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(129)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(130):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(130)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(131):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(131)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(132):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(132)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(133):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(133)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(134):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(134)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(135):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(135)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(136):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(136)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(137):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(137)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(138):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(138)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(139):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(139)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(140):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(140)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(141):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(141)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(142):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(142)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(143):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(143)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(144):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(144)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(145):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(145)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(146):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(146)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(147):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(147)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(148):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(148)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(149):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(149)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(150):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(150)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(151):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(151)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(152):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(152)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(153):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(153)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(154):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(154)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(155):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(155)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(156):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(156)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(157):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(157)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(158):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(158)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(159):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(159)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(160):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(160)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(161):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(161)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(162):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(162)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(163):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(163)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(164):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(164)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(165):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(165)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(166):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(166)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(167):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(167)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(168):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(168)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(169):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(169)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(170):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(170)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(171):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(171)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(172):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(172)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(173):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(173)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(174):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(174)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(175):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(175)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(176):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(176)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(177):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(177)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(178):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(178)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(179):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(179)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(180):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(180)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(181):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(181)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(182):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(182)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(183):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(183)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(184):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(184)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(185):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(185)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(186):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(186)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(187):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(187)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(188):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(188)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(189):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(189)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(190):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(190)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(191):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(191)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(192):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(192)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(193):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(193)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(194):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(194)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(195):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(195)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(196):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(196)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(197):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(197)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(198):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(198)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(199):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(199)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(200):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(200)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(201):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(201)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(202):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(202)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(203):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(203)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(204):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(204)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(205):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(205)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(206):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(206)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(207):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(207)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(208):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(208)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(209):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(209)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(210):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(210)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(211):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(211)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(212):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(212)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(213):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(213)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(214):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(214)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(215):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(215)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(216):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(216)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(217):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(217)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(218):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(218)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(219):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(219)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(220):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(220)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(221):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(221)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(222):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(222)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(223):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(223)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(224):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(224)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(225):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(225)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(226):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(226)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(227):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(227)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(228):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(228)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(229):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(229)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(230):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(230)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(231):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(231)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(232):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(232)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(233):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(233)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(234):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(234)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(235):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(235)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(236):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(236)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(237):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(237)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(238):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(238)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(239):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(239)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(240):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(240)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(241):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(241)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(242):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(242)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(243):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(243)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(244):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(244)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(245):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(245)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(246):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(246)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(247):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(247)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(248):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(248)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(249):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(249)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(250):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(250)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(251):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(251)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(252):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(252)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(253):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(253)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(254):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(254)";
    case NVC3C0_SET_MME_SHADOW_SCRATCH(255):
        return "NVC3C0_SET_MME_SHADOW_SCRATCH(255)";
    default:
        return "unknown method";
    }
}

void
P_DUMP_NVC3C0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    uint32_t parsed;
    switch (idx) {
    case NVC3C0_SET_OBJECT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CLASS_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 5) - 1);
        fprintf(fp, "%s.ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_NO_OPERATION:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_NOTIFY_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_NOTIFY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_NOTIFY:
    
        parsed = data;
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC3C0_NOTIFY_TYPE_WRITE_ONLY:
            fprintf(fp, "WRITE_ONLY\n");
            break;
        case NVC3C0_NOTIFY_TYPE_WRITE_THEN_AWAKEN:
            fprintf(fp, "WRITE_THEN_AWAKEN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_WAIT_FOR_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_GLOBAL_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_GLOBAL_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_GLOBAL_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVC3C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVC3C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVC3C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SEND_GO_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_PM_TRIGGER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_PM_TRIGGER_WFI:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_FE_ATOMIC_SEQUENCE_BEGIN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_FE_ATOMIC_SEQUENCE_END:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_INSTRUMENTATION_METHOD_HEADER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_INSTRUMENTATION_METHOD_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_LINE_LENGTH_IN:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_LINE_COUNT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_OFFSET_OUT_UPPER:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_OFFSET_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_PITCH_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_DST_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC3C0_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_DST_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_DST_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_DST_DEPTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_DST_LAYER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_DST_ORIGIN_BYTES_X:
    
        parsed = (data >> 0) & ((1u << 21) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_DST_ORIGIN_SAMPLES_Y:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_LAUNCH_DMA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVC3C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVC3C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.COMPLETION_TYPE = ", prefix);
        switch (parsed) {
        case NVC3C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE:
            fprintf(fp, "FLUSH_DISABLE\n");
            break;
        case NVC3C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY:
            fprintf(fp, "FLUSH_ONLY\n");
            break;
        case NVC3C0_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE:
            fprintf(fp, "RELEASE_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NVC3C0_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC3C0_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT:
            fprintf(fp, "INTERRUPT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_STRUCT_SIZE = ", prefix);
        switch (parsed) {
        case NVC3C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVC3C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC3C0_LAUNCH_DMA_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_LAUNCH_DMA_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC3C0_LAUNCH_DMA_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC3C0_LAUNCH_DMA_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC3C0_LAUNCH_DMA_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC3C0_LAUNCH_DMA_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC3C0_LAUNCH_DMA_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC3C0_LAUNCH_DMA_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC3C0_LAUNCH_DMA_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC3C0_LAUNCH_DMA_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC3C0_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVC3C0_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SYSMEMBAR_DISABLE = ", prefix);
        switch (parsed) {
        case NVC3C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_LOAD_INLINE_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_I2M_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_I2M_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_I2M_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_I2M_SPARE_NOOP00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_I2M_SPARE_NOOP01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_I2M_SPARE_NOOP02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_I2M_SPARE_NOOP03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_VALID_SPAN_OVERFLOW_AREA_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_VALID_SPAN_OVERFLOW_AREA_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_VALID_SPAN_OVERFLOW_AREA_C:
    
        parsed = data;
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_PERFMON_TRANSFER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_SHADER_CACHES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.DATA = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SHADER_CACHES_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_INVALIDATE_SHADER_CACHES_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.LOCKS = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SHADER_CACHES_LOCKS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_INVALIDATE_SHADER_CACHES_LOCKS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DATA = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_CWD_REF_COUNTER:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RESERVED_SW_METHOD15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SCG_CONTROL:
    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.COMPUTE1_MAX_SM_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 9) - 1);
        fprintf(fp, "%s.COMPUTE1_MIN_SM_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_COMPUTE_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_CHECK_COMPUTE_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_QMD_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_CHECK_QMD_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_SKED_CACHES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_SHARED_MEMORY_WINDOW_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.BASE_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_SHARED_MEMORY_WINDOW_B:
    
        parsed = data;
        fprintf(fp, "%s.BASE_ADDRESS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SCG_HYSTERESIS_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_TIMEOUT_ONCE = ", prefix);
        switch (parsed) {
        case NVC3C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_NULL_TIMEOUT_ONCE = ", prefix);
        switch (parsed) {
        case NVC3C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_CWD_SLOT_COUNT:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SEND_PCAS_A:
    
        parsed = data;
        fprintf(fp, "%s.QMD_ADDRESS_SHIFTED8 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SEND_PCAS_B:
    
        parsed = (data >> 0) & ((1u << 24) - 1);
        fprintf(fp, "%s.FROM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.DELTA = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SEND_SIGNALING_PCAS_B:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INVALIDATE = ", prefix);
        switch (parsed) {
        case NVC3C0_SEND_SIGNALING_PCAS_B_INVALIDATE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SEND_SIGNALING_PCAS_B_INVALIDATE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.SCHEDULE = ", prefix);
        switch (parsed) {
        case NVC3C0_SEND_SIGNALING_PCAS_B_SCHEDULE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SEND_SIGNALING_PCAS_B_SCHEDULE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_SKED_CACHE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IGNORE_VEID = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SIZE_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B:
    
        parsed = data;
        fprintf(fp, "%s.SIZE_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C:
    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.MAX_SM_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SPA_VERSION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MINOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAJOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_INLINE_QMD_ADDRESS_A:
    
        parsed = data;
        fprintf(fp, "%s.QMD_ADDRESS_SHIFTED8_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_INLINE_QMD_ADDRESS_B:
    
        parsed = data;
        fprintf(fp, "%s.QMD_ADDRESS_SHIFTED8_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_LOAD_INLINE_QMD_DATA(0):
    case NVC3C0_LOAD_INLINE_QMD_DATA(1):
    case NVC3C0_LOAD_INLINE_QMD_DATA(2):
    case NVC3C0_LOAD_INLINE_QMD_DATA(3):
    case NVC3C0_LOAD_INLINE_QMD_DATA(4):
    case NVC3C0_LOAD_INLINE_QMD_DATA(5):
    case NVC3C0_LOAD_INLINE_QMD_DATA(6):
    case NVC3C0_LOAD_INLINE_QMD_DATA(7):
    case NVC3C0_LOAD_INLINE_QMD_DATA(8):
    case NVC3C0_LOAD_INLINE_QMD_DATA(9):
    case NVC3C0_LOAD_INLINE_QMD_DATA(10):
    case NVC3C0_LOAD_INLINE_QMD_DATA(11):
    case NVC3C0_LOAD_INLINE_QMD_DATA(12):
    case NVC3C0_LOAD_INLINE_QMD_DATA(13):
    case NVC3C0_LOAD_INLINE_QMD_DATA(14):
    case NVC3C0_LOAD_INLINE_QMD_DATA(15):
    case NVC3C0_LOAD_INLINE_QMD_DATA(16):
    case NVC3C0_LOAD_INLINE_QMD_DATA(17):
    case NVC3C0_LOAD_INLINE_QMD_DATA(18):
    case NVC3C0_LOAD_INLINE_QMD_DATA(19):
    case NVC3C0_LOAD_INLINE_QMD_DATA(20):
    case NVC3C0_LOAD_INLINE_QMD_DATA(21):
    case NVC3C0_LOAD_INLINE_QMD_DATA(22):
    case NVC3C0_LOAD_INLINE_QMD_DATA(23):
    case NVC3C0_LOAD_INLINE_QMD_DATA(24):
    case NVC3C0_LOAD_INLINE_QMD_DATA(25):
    case NVC3C0_LOAD_INLINE_QMD_DATA(26):
    case NVC3C0_LOAD_INLINE_QMD_DATA(27):
    case NVC3C0_LOAD_INLINE_QMD_DATA(28):
    case NVC3C0_LOAD_INLINE_QMD_DATA(29):
    case NVC3C0_LOAD_INLINE_QMD_DATA(30):
    case NVC3C0_LOAD_INLINE_QMD_DATA(31):
    case NVC3C0_LOAD_INLINE_QMD_DATA(32):
    case NVC3C0_LOAD_INLINE_QMD_DATA(33):
    case NVC3C0_LOAD_INLINE_QMD_DATA(34):
    case NVC3C0_LOAD_INLINE_QMD_DATA(35):
    case NVC3C0_LOAD_INLINE_QMD_DATA(36):
    case NVC3C0_LOAD_INLINE_QMD_DATA(37):
    case NVC3C0_LOAD_INLINE_QMD_DATA(38):
    case NVC3C0_LOAD_INLINE_QMD_DATA(39):
    case NVC3C0_LOAD_INLINE_QMD_DATA(40):
    case NVC3C0_LOAD_INLINE_QMD_DATA(41):
    case NVC3C0_LOAD_INLINE_QMD_DATA(42):
    case NVC3C0_LOAD_INLINE_QMD_DATA(43):
    case NVC3C0_LOAD_INLINE_QMD_DATA(44):
    case NVC3C0_LOAD_INLINE_QMD_DATA(45):
    case NVC3C0_LOAD_INLINE_QMD_DATA(46):
    case NVC3C0_LOAD_INLINE_QMD_DATA(47):
    case NVC3C0_LOAD_INLINE_QMD_DATA(48):
    case NVC3C0_LOAD_INLINE_QMD_DATA(49):
    case NVC3C0_LOAD_INLINE_QMD_DATA(50):
    case NVC3C0_LOAD_INLINE_QMD_DATA(51):
    case NVC3C0_LOAD_INLINE_QMD_DATA(52):
    case NVC3C0_LOAD_INLINE_QMD_DATA(53):
    case NVC3C0_LOAD_INLINE_QMD_DATA(54):
    case NVC3C0_LOAD_INLINE_QMD_DATA(55):
    case NVC3C0_LOAD_INLINE_QMD_DATA(56):
    case NVC3C0_LOAD_INLINE_QMD_DATA(57):
    case NVC3C0_LOAD_INLINE_QMD_DATA(58):
    case NVC3C0_LOAD_INLINE_QMD_DATA(59):
    case NVC3C0_LOAD_INLINE_QMD_DATA(60):
    case NVC3C0_LOAD_INLINE_QMD_DATA(61):
    case NVC3C0_LOAD_INLINE_QMD_DATA(62):
    case NVC3C0_LOAD_INLINE_QMD_DATA(63):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON16:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON17:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON18:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON19:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON20:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON21:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON22:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON23:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON24:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON25:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON26:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON27:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON28:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON29:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON30:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_FALCON31:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.BASE_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B:
    
        parsed = data;
        fprintf(fp, "%s.BASE_ADDRESS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_CACHE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ICACHE_PREFETCH_ENABLE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_SM_TIMEOUT_INTERVAL:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.COUNTER_BIT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_SAMPLER_CACHE_ALL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_ALL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALL = ", prefix);
        switch (parsed) {
        case NVC3C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_INVALIDATE_SAMPLER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SAMPLER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC3C0_INVALIDATE_SAMPLER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC3C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC3C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_SAMPLER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC3C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_EXCEPTIONS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_SHADER_EXCEPTIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SET_SHADER_EXCEPTIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SET_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVC3C0_SET_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVC3C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVC3C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_TEX_SAMPLER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_TEX_SAMPLER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_TEX_SAMPLER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_TEX_HEADER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_TEX_HEADER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_TEX_HEADER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_INVALIDATE_SHADER_CACHES_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GLOBAL_DATA = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVC3C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_RENDER_ENABLE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE:
            fprintf(fp, "USE_RENDER_ENABLE\n");
            break;
        case NVC3C0_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER:
            fprintf(fp, "ALWAYS_RENDER\n");
            break;
        case NVC3C0_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER:
            fprintf(fp, "NEVER_RENDER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_PIPE_NOP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SPARE00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SPARE01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SPARE02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SPARE03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_REPORT_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_REPORT_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_REPORT_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_REPORT_SEMAPHORE_D:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 17) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVC3C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC3C0_SET_TRAP_HANDLER_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_TRAP_HANDLER_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_BINDLESS_TEXTURE:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.CONSTANT_BUFFER_SLOT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6):
    case NVC3C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.EVENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 15) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 22) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 25) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 30) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPARE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.EDGE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 1) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.WINDOWED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 16) - 1);
        fprintf(fp, "%s.FUNC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_START_SHADER_PERFORMANCE_COUNTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNTER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_STOP_SHADER_PERFORMANCE_COUNTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNTER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC3C0_SET_MME_SHADOW_SCRATCH(0):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(1):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(2):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(3):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(4):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(5):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(6):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(7):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(8):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(9):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(10):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(11):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(12):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(13):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(14):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(15):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(16):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(17):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(18):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(19):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(20):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(21):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(22):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(23):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(24):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(25):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(26):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(27):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(28):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(29):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(30):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(31):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(32):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(33):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(34):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(35):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(36):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(37):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(38):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(39):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(40):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(41):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(42):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(43):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(44):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(45):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(46):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(47):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(48):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(49):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(50):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(51):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(52):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(53):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(54):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(55):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(56):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(57):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(58):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(59):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(60):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(61):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(62):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(63):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(64):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(65):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(66):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(67):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(68):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(69):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(70):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(71):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(72):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(73):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(74):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(75):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(76):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(77):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(78):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(79):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(80):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(81):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(82):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(83):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(84):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(85):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(86):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(87):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(88):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(89):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(90):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(91):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(92):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(93):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(94):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(95):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(96):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(97):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(98):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(99):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(100):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(101):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(102):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(103):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(104):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(105):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(106):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(107):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(108):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(109):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(110):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(111):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(112):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(113):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(114):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(115):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(116):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(117):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(118):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(119):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(120):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(121):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(122):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(123):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(124):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(125):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(126):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(127):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(128):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(129):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(130):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(131):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(132):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(133):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(134):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(135):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(136):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(137):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(138):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(139):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(140):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(141):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(142):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(143):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(144):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(145):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(146):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(147):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(148):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(149):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(150):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(151):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(152):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(153):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(154):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(155):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(156):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(157):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(158):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(159):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(160):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(161):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(162):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(163):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(164):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(165):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(166):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(167):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(168):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(169):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(170):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(171):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(172):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(173):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(174):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(175):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(176):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(177):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(178):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(179):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(180):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(181):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(182):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(183):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(184):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(185):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(186):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(187):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(188):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(189):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(190):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(191):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(192):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(193):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(194):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(195):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(196):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(197):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(198):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(199):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(200):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(201):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(202):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(203):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(204):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(205):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(206):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(207):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(208):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(209):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(210):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(211):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(212):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(213):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(214):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(215):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(216):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(217):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(218):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(219):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(220):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(221):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(222):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(223):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(224):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(225):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(226):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(227):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(228):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(229):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(230):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(231):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(232):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(233):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(234):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(235):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(236):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(237):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(238):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(239):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(240):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(241):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(242):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(243):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(244):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(245):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(246):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(247):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(248):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(249):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(250):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(251):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(252):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(253):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(254):
    case NVC3C0_SET_MME_SHADOW_SCRATCH(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
