#include "nvk_cl90b5.h"

#include <stdio.h>

const char*
P_PARSE_NV90B5_MTHD(uint16_t idx)
{
    switch (idx) {
    case NV90B5_LL_CMD1:
        return "NV90B5_LL_CMD1";
    case NV90B5_NOP:
        return "NV90B5_NOP";
    case NV90B5_PM_TRIGGER:
        return "NV90B5_PM_TRIGGER";
    case NV90B5_SET_APPLICATION_ID:
        return "NV90B5_SET_APPLICATION_ID";
    case NV90B5_SET_WATCHDOG_TIMER:
        return "NV90B5_SET_WATCHDOG_TIMER";
    case NV90B5_SET_SEMAPHORE_A:
        return "NV90B5_SET_SEMAPHORE_A";
    case NV90B5_SET_SEMAPHORE_B:
        return "NV90B5_SET_SEMAPHORE_B";
    case NV90B5_SET_SEMAPHORE_PAYLOAD:
        return "NV90B5_SET_SEMAPHORE_PAYLOAD";
    case NV90B5_ADDRESSING_MODE:
        return "NV90B5_ADDRESSING_MODE";
    case NV90B5_SET_RENDER_ENABLE_A:
        return "NV90B5_SET_RENDER_ENABLE_A";
    case NV90B5_SET_RENDER_ENABLE_B:
        return "NV90B5_SET_RENDER_ENABLE_B";
    case NV90B5_SET_RENDER_ENABLE_C:
        return "NV90B5_SET_RENDER_ENABLE_C";
    case NV90B5_LAUNCH_DMA:
        return "NV90B5_LAUNCH_DMA";
    case NV90B5_OFFSET_IN_UPPER:
        return "NV90B5_OFFSET_IN_UPPER";
    case NV90B5_OFFSET_IN_LOWER:
        return "NV90B5_OFFSET_IN_LOWER";
    case NV90B5_OFFSET_OUT_UPPER:
        return "NV90B5_OFFSET_OUT_UPPER";
    case NV90B5_OFFSET_OUT_LOWER:
        return "NV90B5_OFFSET_OUT_LOWER";
    case NV90B5_PITCH_IN:
        return "NV90B5_PITCH_IN";
    case NV90B5_PITCH_OUT:
        return "NV90B5_PITCH_OUT";
    case NV90B5_LINE_LENGTH_IN:
        return "NV90B5_LINE_LENGTH_IN";
    case NV90B5_LINE_COUNT:
        return "NV90B5_LINE_COUNT";
    case NV90B5_SET_REMAP_CONST_A:
        return "NV90B5_SET_REMAP_CONST_A";
    case NV90B5_SET_REMAP_CONST_B:
        return "NV90B5_SET_REMAP_CONST_B";
    case NV90B5_SET_REMAP_COMPONENTS:
        return "NV90B5_SET_REMAP_COMPONENTS";
    case NV90B5_SET_DST_BLOCK_SIZE:
        return "NV90B5_SET_DST_BLOCK_SIZE";
    case NV90B5_SET_DST_WIDTH:
        return "NV90B5_SET_DST_WIDTH";
    case NV90B5_SET_DST_HEIGHT:
        return "NV90B5_SET_DST_HEIGHT";
    case NV90B5_SET_DST_DEPTH:
        return "NV90B5_SET_DST_DEPTH";
    case NV90B5_SET_DST_LAYER:
        return "NV90B5_SET_DST_LAYER";
    case NV90B5_SET_DST_ORIGIN:
        return "NV90B5_SET_DST_ORIGIN";
    case NV90B5_SET_SRC_BLOCK_SIZE:
        return "NV90B5_SET_SRC_BLOCK_SIZE";
    case NV90B5_SET_SRC_WIDTH:
        return "NV90B5_SET_SRC_WIDTH";
    case NV90B5_SET_SRC_HEIGHT:
        return "NV90B5_SET_SRC_HEIGHT";
    case NV90B5_SET_SRC_DEPTH:
        return "NV90B5_SET_SRC_DEPTH";
    case NV90B5_SET_SRC_LAYER:
        return "NV90B5_SET_SRC_LAYER";
    case NV90B5_SET_SRC_ORIGIN:
        return "NV90B5_SET_SRC_ORIGIN";
    case NV90B5_PM_TRIGGER_END:
        return "NV90B5_PM_TRIGGER_END";
    default:
        return "unknown method";
    }
}

void
P_DUMP_NV90B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    uint32_t parsed;
    switch (idx) {
    case NV90B5_LL_CMD1:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.SRC_MAX_GOBLINE_PAD_POLICY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 2) - 1);
        fprintf(fp, "%s.DST_MAX_GOBLINE_PAD_POLICY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.SRC_NONCROSSING_BOUNDARY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DST_NONCROSSING_BOUNDARY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.P2_P_1_LINE_TRAVERSAL = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 1) - 1);
        fprintf(fp, "%s.NO_WRITE_B14 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 18) & ((1u << 5) - 1);
        fprintf(fp, "%s.SELECT_OUT_B15 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 23) & ((1u << 1) - 1);
        fprintf(fp, "%s.NO_WRITE_B15 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.COPY_TYPE_SWIZ = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.COPY_TYPE_BIGMEM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 11) & ((1u << 3) - 1);
        fprintf(fp, "%s.BURSTSIZE_SRC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 14) & ((1u << 3) - 1);
        fprintf(fp, "%s.BURSTSIZE_DST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 1) - 1);
        fprintf(fp, "%s.GOBWIDTH_SRC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 18) & ((1u << 1) - 1);
        fprintf(fp, "%s.GOBWIDTH_DST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 19) & ((1u << 1) - 1);
        fprintf(fp, "%s.PIPELINED_READS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 3) - 1);
        fprintf(fp, "%s.SRC_CTXDMA = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 23) & ((1u << 3) - 1);
        fprintf(fp, "%s.DST_CTXDMA = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_NOP:
    
        parsed = data;
        fprintf(fp, "%s.PARAMETER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_PM_TRIGGER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_APPLICATION_ID:
    
        parsed = data;
        fprintf(fp, "%s.ID = ", prefix);
        switch (parsed) {
        case NV90B5_SET_APPLICATION_ID_ID_NORMAL:
            fprintf(fp, "NORMAL\n");
            break;
        case NV90B5_SET_APPLICATION_ID_ID_LOW_LEVEL_CLASS:
            fprintf(fp, "LOW_LEVEL_CLASS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NV90B5_SET_WATCHDOG_TIMER:
    
        parsed = data;
        fprintf(fp, "%s.TIMER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_SEMAPHORE_PAYLOAD:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_ADDRESSING_MODE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_TYPE = ", prefix);
        switch (parsed) {
        case NV90B5_ADDRESSING_MODE_SRC_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NV90B5_ADDRESSING_MODE_SRC_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.SRC_TARGET = ", prefix);
        switch (parsed) {
        case NV90B5_ADDRESSING_MODE_SRC_TARGET_LOCAL_FB:
            fprintf(fp, "LOCAL_FB\n");
            break;
        case NV90B5_ADDRESSING_MODE_SRC_TARGET_COHERENT_SYSMEM:
            fprintf(fp, "COHERENT_SYSMEM\n");
            break;
        case NV90B5_ADDRESSING_MODE_SRC_TARGET_NONCOHERENT_SYSMEM:
            fprintf(fp, "NONCOHERENT_SYSMEM\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_TYPE = ", prefix);
        switch (parsed) {
        case NV90B5_ADDRESSING_MODE_DST_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NV90B5_ADDRESSING_MODE_DST_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 2) - 1);
        fprintf(fp, "%s.DST_TARGET = ", prefix);
        switch (parsed) {
        case NV90B5_ADDRESSING_MODE_DST_TARGET_LOCAL_FB:
            fprintf(fp, "LOCAL_FB\n");
            break;
        case NV90B5_ADDRESSING_MODE_DST_TARGET_COHERENT_SYSMEM:
            fprintf(fp, "COHERENT_SYSMEM\n");
            break;
        case NV90B5_ADDRESSING_MODE_DST_TARGET_NONCOHERENT_SYSMEM:
            fprintf(fp, "NONCOHERENT_SYSMEM\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NV90B5_SET_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NV90B5_SET_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV90B5_SET_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NV90B5_SET_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NV90B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NV90B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NV90B5_LAUNCH_DMA:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.DATA_TRANSFER_TYPE = ", prefix);
        switch (parsed) {
        case NV90B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NV90B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PIPELINED:
            fprintf(fp, "PIPELINED\n");
            break;
        case NV90B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NON_PIPELINED:
            fprintf(fp, "NON_PIPELINED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_ENABLE = ", prefix);
        switch (parsed) {
        case NV90B5_LAUNCH_DMA_FLUSH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV90B5_LAUNCH_DMA_FLUSH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 2) - 1);
        fprintf(fp, "%s.SEMAPHORE_TYPE = ", prefix);
        switch (parsed) {
        case NV90B5_LAUNCH_DMA_SEMAPHORE_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NV90B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE:
            fprintf(fp, "RELEASE_ONE_WORD_SEMAPHORE\n");
            break;
        case NV90B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE:
            fprintf(fp, "RELEASE_FOUR_WORD_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NV90B5_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NV90B5_LAUNCH_DMA_INTERRUPT_TYPE_BLOCKING:
            fprintf(fp, "BLOCKING\n");
            break;
        case NV90B5_LAUNCH_DMA_INTERRUPT_TYPE_NON_BLOCKING:
            fprintf(fp, "NON_BLOCKING\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NV90B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NV90B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NV90B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NV90B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.MULTI_LINE_ENABLE = ", prefix);
        switch (parsed) {
        case NV90B5_LAUNCH_DMA_MULTI_LINE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV90B5_LAUNCH_DMA_MULTI_LINE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.REMAP_ENABLE = ", prefix);
        switch (parsed) {
        case NV90B5_LAUNCH_DMA_REMAP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV90B5_LAUNCH_DMA_REMAP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NV90B5_OFFSET_IN_UPPER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_OFFSET_IN_LOWER:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_OFFSET_OUT_UPPER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_OFFSET_OUT_LOWER:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_PITCH_IN:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_PITCH_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_LINE_LENGTH_IN:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_LINE_COUNT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_REMAP_CONST_A:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_REMAP_CONST_B:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_REMAP_COMPONENTS:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.DST_X = ", prefix);
        switch (parsed) {
        case NV90B5_SET_REMAP_COMPONENTS_DST_X_SRC_X:
            fprintf(fp, "SRC_X\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_X_SRC_Y:
            fprintf(fp, "SRC_Y\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_X_SRC_Z:
            fprintf(fp, "SRC_Z\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_X_SRC_W:
            fprintf(fp, "SRC_W\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_X_CONST_A:
            fprintf(fp, "CONST_A\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_X_CONST_B:
            fprintf(fp, "CONST_B\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_X_NO_WRITE:
            fprintf(fp, "NO_WRITE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.DST_Y = ", prefix);
        switch (parsed) {
        case NV90B5_SET_REMAP_COMPONENTS_DST_Y_SRC_X:
            fprintf(fp, "SRC_X\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Y:
            fprintf(fp, "SRC_Y\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Z:
            fprintf(fp, "SRC_Z\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Y_SRC_W:
            fprintf(fp, "SRC_W\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Y_CONST_A:
            fprintf(fp, "CONST_A\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Y_CONST_B:
            fprintf(fp, "CONST_B\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Y_NO_WRITE:
            fprintf(fp, "NO_WRITE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 3) - 1);
        fprintf(fp, "%s.DST_Z = ", prefix);
        switch (parsed) {
        case NV90B5_SET_REMAP_COMPONENTS_DST_Z_SRC_X:
            fprintf(fp, "SRC_X\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Y:
            fprintf(fp, "SRC_Y\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Z:
            fprintf(fp, "SRC_Z\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Z_SRC_W:
            fprintf(fp, "SRC_W\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Z_CONST_A:
            fprintf(fp, "CONST_A\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Z_CONST_B:
            fprintf(fp, "CONST_B\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_Z_NO_WRITE:
            fprintf(fp, "NO_WRITE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.DST_W = ", prefix);
        switch (parsed) {
        case NV90B5_SET_REMAP_COMPONENTS_DST_W_SRC_X:
            fprintf(fp, "SRC_X\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_W_SRC_Y:
            fprintf(fp, "SRC_Y\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_W_SRC_Z:
            fprintf(fp, "SRC_Z\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_W_SRC_W:
            fprintf(fp, "SRC_W\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_W_CONST_A:
            fprintf(fp, "CONST_A\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_W_CONST_B:
            fprintf(fp, "CONST_B\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_DST_W_NO_WRITE:
            fprintf(fp, "NO_WRITE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 2) - 1);
        fprintf(fp, "%s.COMPONENT_SIZE = ", prefix);
        switch (parsed) {
        case NV90B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_TWO:
            fprintf(fp, "TWO\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_THREE:
            fprintf(fp, "THREE\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_FOUR:
            fprintf(fp, "FOUR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 2) - 1);
        fprintf(fp, "%s.NUM_SRC_COMPONENTS = ", prefix);
        switch (parsed) {
        case NV90B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_TWO:
            fprintf(fp, "TWO\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_THREE:
            fprintf(fp, "THREE\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_FOUR:
            fprintf(fp, "FOUR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 2) - 1);
        fprintf(fp, "%s.NUM_DST_COMPONENTS = ", prefix);
        switch (parsed) {
        case NV90B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_TWO:
            fprintf(fp, "TWO\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_THREE:
            fprintf(fp, "THREE\n");
            break;
        case NV90B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_FOUR:
            fprintf(fp, "FOUR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NV90B5_SET_DST_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NV90B5_SET_DST_BLOCK_SIZE_WIDTH_QUARTER_GOB:
            fprintf(fp, "QUARTER_GOB\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NV90B5_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NV90B5_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.GOB_HEIGHT = ", prefix);
        switch (parsed) {
        case NV90B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_TESLA_4:
            fprintf(fp, "GOB_HEIGHT_TESLA_4\n");
            break;
        case NV90B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8:
            fprintf(fp, "GOB_HEIGHT_FERMI_8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NV90B5_SET_DST_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_DST_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_DST_DEPTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_DST_LAYER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_DST_ORIGIN:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.X = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.Y = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_SRC_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NV90B5_SET_SRC_BLOCK_SIZE_WIDTH_QUARTER_GOB:
            fprintf(fp, "QUARTER_GOB\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NV90B5_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NV90B5_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.GOB_HEIGHT = ", prefix);
        switch (parsed) {
        case NV90B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_TESLA_4:
            fprintf(fp, "GOB_HEIGHT_TESLA_4\n");
            break;
        case NV90B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8:
            fprintf(fp, "GOB_HEIGHT_FERMI_8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NV90B5_SET_SRC_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_SRC_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_SRC_DEPTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_SRC_LAYER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_SET_SRC_ORIGIN:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.X = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.Y = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NV90B5_PM_TRIGGER_END:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
