/* parsed class NV902D */

#include "nvtypes.h"
#include "cl902d.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nv902d_SET_OBJECT {
    uint32_t class_id;
    uint32_t engine_id;
};

static inline void
__NV902D_SET_OBJECT(uint32_t *val_out, struct nv_nv902d_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.class_id < (1ULL << 16));
    val |= st.class_id << 0;
    
    assert(st.engine_id < (1ULL << 5));
    val |= st.engine_id << 16;
    *val_out = val;
}

#define V_NV902D_SET_OBJECT(val, args...) { \
    struct nv_nv902d_SET_OBJECT __data = args; \
    __NV902D_SET_OBJECT(&val, __data); \
}

#define VA_NV902D_SET_OBJECT V_NV902D_SET_OBJECT

#define P_NV902D_SET_OBJECT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nv902d_NO_OPERATION {
    uint32_t v;
};

static inline void
__NV902D_NO_OPERATION(uint32_t *val_out, struct nv_nv902d_NO_OPERATION st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_NO_OPERATION(val, args...) { \
    struct nv_nv902d_NO_OPERATION __data = { .v = (args) }; \
    __NV902D_NO_OPERATION(&val, __data); \
}

#define VA_NV902D_NO_OPERATION V_NV902D_NO_OPERATION

#define P_NV902D_NO_OPERATION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_NO_OPERATION(nvk_p_ret, args); \
    nv_push_val(push, NV902D_NO_OPERATION, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_NOTIFY_A {
    uint32_t address_upper;
};

static inline void
__NV902D_SET_NOTIFY_A(uint32_t *val_out, struct nv_nv902d_SET_NOTIFY_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 25));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NV902D_SET_NOTIFY_A(val, args...) { \
    struct nv_nv902d_SET_NOTIFY_A __data = { .address_upper = (args) }; \
    __NV902D_SET_NOTIFY_A(&val, __data); \
}

#define VA_NV902D_SET_NOTIFY_A V_NV902D_SET_NOTIFY_A

#define P_NV902D_SET_NOTIFY_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_NOTIFY_A(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_NOTIFY_A, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_NOTIFY_B {
    uint32_t address_lower;
};

static inline void
__NV902D_SET_NOTIFY_B(uint32_t *val_out, struct nv_nv902d_SET_NOTIFY_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NV902D_SET_NOTIFY_B(val, args...) { \
    struct nv_nv902d_SET_NOTIFY_B __data = { .address_lower = (args) }; \
    __NV902D_SET_NOTIFY_B(&val, __data); \
}

#define VA_NV902D_SET_NOTIFY_B V_NV902D_SET_NOTIFY_B

#define P_NV902D_SET_NOTIFY_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_NOTIFY_B(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_NOTIFY_B, nvk_p_ret); \
} while(0)

struct nv_nv902d_NOTIFY {
    uint32_t type;
};

static inline void
__NV902D_NOTIFY(uint32_t *val_out, struct nv_nv902d_NOTIFY st)
{
    uint32_t val = 0;
    
    val |= st.type;
    *val_out = val;
}

#define V_NV902D_NOTIFY(val, args...) { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NV902D_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NV902D_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    struct nv_nv902d_NOTIFY __data = { .type = (args) }; \
    __NV902D_NOTIFY(&val, __data); \
}

#define VA_NV902D_NOTIFY V_NV902D_NOTIFY

#define P_NV902D_NOTIFY(push, args...) do { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NV902D_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NV902D_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    uint32_t nvk_p_ret; \
    V_NV902D_NOTIFY(nvk_p_ret, args); \
    nv_push_val(push, NV902D_NOTIFY, nvk_p_ret); \
} while(0)

struct nv_nv902d_WAIT_FOR_IDLE {
    uint32_t v;
};

static inline void
__NV902D_WAIT_FOR_IDLE(uint32_t *val_out, struct nv_nv902d_WAIT_FOR_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_WAIT_FOR_IDLE(val, args...) { \
    struct nv_nv902d_WAIT_FOR_IDLE __data = { .v = (args) }; \
    __NV902D_WAIT_FOR_IDLE(&val, __data); \
}

#define VA_NV902D_WAIT_FOR_IDLE V_NV902D_WAIT_FOR_IDLE

#define P_NV902D_WAIT_FOR_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_WAIT_FOR_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_WAIT_FOR_IDLE, nvk_p_ret); \
} while(0)

struct nv_nv902d_LOAD_MME_INSTRUCTION_RAM_POINTER {
    uint32_t v;
};

static inline void
__NV902D_LOAD_MME_INSTRUCTION_RAM_POINTER(uint32_t *val_out, struct nv_nv902d_LOAD_MME_INSTRUCTION_RAM_POINTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_LOAD_MME_INSTRUCTION_RAM_POINTER(val, args...) { \
    struct nv_nv902d_LOAD_MME_INSTRUCTION_RAM_POINTER __data = { .v = (args) }; \
    __NV902D_LOAD_MME_INSTRUCTION_RAM_POINTER(&val, __data); \
}

#define VA_NV902D_LOAD_MME_INSTRUCTION_RAM_POINTER V_NV902D_LOAD_MME_INSTRUCTION_RAM_POINTER

#define P_NV902D_LOAD_MME_INSTRUCTION_RAM_POINTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_LOAD_MME_INSTRUCTION_RAM_POINTER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_LOAD_MME_INSTRUCTION_RAM_POINTER, nvk_p_ret); \
} while(0)

struct nv_nv902d_LOAD_MME_INSTRUCTION_RAM {
    uint32_t v;
};

static inline void
__NV902D_LOAD_MME_INSTRUCTION_RAM(uint32_t *val_out, struct nv_nv902d_LOAD_MME_INSTRUCTION_RAM st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_LOAD_MME_INSTRUCTION_RAM(val, args...) { \
    struct nv_nv902d_LOAD_MME_INSTRUCTION_RAM __data = { .v = (args) }; \
    __NV902D_LOAD_MME_INSTRUCTION_RAM(&val, __data); \
}

#define VA_NV902D_LOAD_MME_INSTRUCTION_RAM V_NV902D_LOAD_MME_INSTRUCTION_RAM

#define P_NV902D_LOAD_MME_INSTRUCTION_RAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_LOAD_MME_INSTRUCTION_RAM(nvk_p_ret, args); \
    nv_push_val(push, NV902D_LOAD_MME_INSTRUCTION_RAM, nvk_p_ret); \
} while(0)

struct nv_nv902d_LOAD_MME_START_ADDRESS_RAM_POINTER {
    uint32_t v;
};

static inline void
__NV902D_LOAD_MME_START_ADDRESS_RAM_POINTER(uint32_t *val_out, struct nv_nv902d_LOAD_MME_START_ADDRESS_RAM_POINTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_LOAD_MME_START_ADDRESS_RAM_POINTER(val, args...) { \
    struct nv_nv902d_LOAD_MME_START_ADDRESS_RAM_POINTER __data = { .v = (args) }; \
    __NV902D_LOAD_MME_START_ADDRESS_RAM_POINTER(&val, __data); \
}

#define VA_NV902D_LOAD_MME_START_ADDRESS_RAM_POINTER V_NV902D_LOAD_MME_START_ADDRESS_RAM_POINTER

#define P_NV902D_LOAD_MME_START_ADDRESS_RAM_POINTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_LOAD_MME_START_ADDRESS_RAM_POINTER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_LOAD_MME_START_ADDRESS_RAM_POINTER, nvk_p_ret); \
} while(0)

struct nv_nv902d_LOAD_MME_START_ADDRESS_RAM {
    uint32_t v;
};

static inline void
__NV902D_LOAD_MME_START_ADDRESS_RAM(uint32_t *val_out, struct nv_nv902d_LOAD_MME_START_ADDRESS_RAM st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_LOAD_MME_START_ADDRESS_RAM(val, args...) { \
    struct nv_nv902d_LOAD_MME_START_ADDRESS_RAM __data = { .v = (args) }; \
    __NV902D_LOAD_MME_START_ADDRESS_RAM(&val, __data); \
}

#define VA_NV902D_LOAD_MME_START_ADDRESS_RAM V_NV902D_LOAD_MME_START_ADDRESS_RAM

#define P_NV902D_LOAD_MME_START_ADDRESS_RAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_LOAD_MME_START_ADDRESS_RAM(nvk_p_ret, args); \
    nv_push_val(push, NV902D_LOAD_MME_START_ADDRESS_RAM, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MME_SHADOW_RAM_CONTROL {
    uint32_t mode;
};

static inline void
__NV902D_SET_MME_SHADOW_RAM_CONTROL(uint32_t *val_out, struct nv_nv902d_SET_MME_SHADOW_RAM_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV902D_SET_MME_SHADOW_RAM_CONTROL(val, args...) { \
    UNUSED uint32_t MODE_METHOD_TRACK = NV902D_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK; \
    UNUSED uint32_t MODE_METHOD_TRACK_WITH_FILTER = NV902D_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER; \
    UNUSED uint32_t MODE_METHOD_PASSTHROUGH = NV902D_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH; \
    UNUSED uint32_t MODE_METHOD_REPLAY = NV902D_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY; \
    struct nv_nv902d_SET_MME_SHADOW_RAM_CONTROL __data = { .mode = (args) }; \
    __NV902D_SET_MME_SHADOW_RAM_CONTROL(&val, __data); \
}

#define VA_NV902D_SET_MME_SHADOW_RAM_CONTROL V_NV902D_SET_MME_SHADOW_RAM_CONTROL

#define P_NV902D_SET_MME_SHADOW_RAM_CONTROL(push, args...) do { \
    UNUSED uint32_t MODE_METHOD_TRACK = NV902D_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK; \
    UNUSED uint32_t MODE_METHOD_TRACK_WITH_FILTER = NV902D_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER; \
    UNUSED uint32_t MODE_METHOD_PASSTHROUGH = NV902D_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH; \
    UNUSED uint32_t MODE_METHOD_REPLAY = NV902D_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MME_SHADOW_RAM_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MME_SHADOW_RAM_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_GLOBAL_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NV902D_SET_GLOBAL_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nv902d_SET_GLOBAL_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NV902D_SET_GLOBAL_RENDER_ENABLE_A(val, args...) { \
    struct nv_nv902d_SET_GLOBAL_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NV902D_SET_GLOBAL_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NV902D_SET_GLOBAL_RENDER_ENABLE_A V_NV902D_SET_GLOBAL_RENDER_ENABLE_A

#define P_NV902D_SET_GLOBAL_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_GLOBAL_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_GLOBAL_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_GLOBAL_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NV902D_SET_GLOBAL_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nv902d_SET_GLOBAL_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NV902D_SET_GLOBAL_RENDER_ENABLE_B(val, args...) { \
    struct nv_nv902d_SET_GLOBAL_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NV902D_SET_GLOBAL_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NV902D_SET_GLOBAL_RENDER_ENABLE_B V_NV902D_SET_GLOBAL_RENDER_ENABLE_B

#define P_NV902D_SET_GLOBAL_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_GLOBAL_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_GLOBAL_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_GLOBAL_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NV902D_SET_GLOBAL_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nv902d_SET_GLOBAL_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV902D_SET_GLOBAL_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nv902d_SET_GLOBAL_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NV902D_SET_GLOBAL_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NV902D_SET_GLOBAL_RENDER_ENABLE_C V_NV902D_SET_GLOBAL_RENDER_ENABLE_C

#define P_NV902D_SET_GLOBAL_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NV902D_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_GLOBAL_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_GLOBAL_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nv902d_SEND_GO_IDLE {
    uint32_t v;
};

static inline void
__NV902D_SEND_GO_IDLE(uint32_t *val_out, struct nv_nv902d_SEND_GO_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SEND_GO_IDLE(val, args...) { \
    struct nv_nv902d_SEND_GO_IDLE __data = { .v = (args) }; \
    __NV902D_SEND_GO_IDLE(&val, __data); \
}

#define VA_NV902D_SEND_GO_IDLE V_NV902D_SEND_GO_IDLE

#define P_NV902D_SEND_GO_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SEND_GO_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SEND_GO_IDLE, nvk_p_ret); \
} while(0)

struct nv_nv902d_PM_TRIGGER {
    uint32_t v;
};

static inline void
__NV902D_PM_TRIGGER(uint32_t *val_out, struct nv_nv902d_PM_TRIGGER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_PM_TRIGGER(val, args...) { \
    struct nv_nv902d_PM_TRIGGER __data = { .v = (args) }; \
    __NV902D_PM_TRIGGER(&val, __data); \
}

#define VA_NV902D_PM_TRIGGER V_NV902D_PM_TRIGGER

#define P_NV902D_PM_TRIGGER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_PM_TRIGGER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_PM_TRIGGER, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_INSTRUMENTATION_METHOD_HEADER {
    uint32_t v;
};

static inline void
__NV902D_SET_INSTRUMENTATION_METHOD_HEADER(uint32_t *val_out, struct nv_nv902d_SET_INSTRUMENTATION_METHOD_HEADER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_INSTRUMENTATION_METHOD_HEADER(val, args...) { \
    struct nv_nv902d_SET_INSTRUMENTATION_METHOD_HEADER __data = { .v = (args) }; \
    __NV902D_SET_INSTRUMENTATION_METHOD_HEADER(&val, __data); \
}

#define VA_NV902D_SET_INSTRUMENTATION_METHOD_HEADER V_NV902D_SET_INSTRUMENTATION_METHOD_HEADER

#define P_NV902D_SET_INSTRUMENTATION_METHOD_HEADER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_INSTRUMENTATION_METHOD_HEADER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_INSTRUMENTATION_METHOD_HEADER, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_INSTRUMENTATION_METHOD_DATA {
    uint32_t v;
};

static inline void
__NV902D_SET_INSTRUMENTATION_METHOD_DATA(uint32_t *val_out, struct nv_nv902d_SET_INSTRUMENTATION_METHOD_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_INSTRUMENTATION_METHOD_DATA(val, args...) { \
    struct nv_nv902d_SET_INSTRUMENTATION_METHOD_DATA __data = { .v = (args) }; \
    __NV902D_SET_INSTRUMENTATION_METHOD_DATA(&val, __data); \
}

#define VA_NV902D_SET_INSTRUMENTATION_METHOD_DATA V_NV902D_SET_INSTRUMENTATION_METHOD_DATA

#define P_NV902D_SET_INSTRUMENTATION_METHOD_DATA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_INSTRUMENTATION_METHOD_DATA(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_INSTRUMENTATION_METHOD_DATA, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MME_SWITCH_STATE {
    uint32_t valid;
    uint32_t save_macro;
    uint32_t restore_macro;
};

static inline void
__NV902D_SET_MME_SWITCH_STATE(uint32_t *val_out, struct nv_nv902d_SET_MME_SWITCH_STATE st)
{
    uint32_t val = 0;
    
    assert(st.valid < (1ULL << 1));
    val |= st.valid << 0;
    
    assert(st.save_macro < (1ULL << 8));
    val |= st.save_macro << 4;
    
    assert(st.restore_macro < (1ULL << 8));
    val |= st.restore_macro << 12;
    *val_out = val;
}

#define V_NV902D_SET_MME_SWITCH_STATE(val, args...) { \
    UNUSED uint32_t VALID_FALSE = NV902D_SET_MME_SWITCH_STATE_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV902D_SET_MME_SWITCH_STATE_VALID_TRUE; \
    struct nv_nv902d_SET_MME_SWITCH_STATE __data = args; \
    __NV902D_SET_MME_SWITCH_STATE(&val, __data); \
}

#define VA_NV902D_SET_MME_SWITCH_STATE V_NV902D_SET_MME_SWITCH_STATE

#define P_NV902D_SET_MME_SWITCH_STATE(push, args...) do { \
    UNUSED uint32_t VALID_FALSE = NV902D_SET_MME_SWITCH_STATE_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NV902D_SET_MME_SWITCH_STATE_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MME_SWITCH_STATE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MME_SWITCH_STATE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_FORMAT {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_FORMAT(uint32_t *val_out, struct nv_nv902d_SET_DST_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_DST_FORMAT(val, args...) { \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_DST_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A8RL8GL8BL8 = NV902D_SET_DST_FORMAT_V_A8RL8GL8BL8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_DST_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_A8B8G8R8 = NV902D_SET_DST_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A8BL8GL8RL8 = NV902D_SET_DST_FORMAT_V_A8BL8GL8RL8; \
    UNUSED uint32_t V_A2B10G10R10 = NV902D_SET_DST_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_X8R8G8B8 = NV902D_SET_DST_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8RL8GL8BL8 = NV902D_SET_DST_FORMAT_V_X8RL8GL8BL8; \
    UNUSED uint32_t V_X8B8G8R8 = NV902D_SET_DST_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_X8BL8GL8RL8 = NV902D_SET_DST_FORMAT_V_X8BL8GL8RL8; \
    UNUSED uint32_t V_R5G6B5 = NV902D_SET_DST_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_DST_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_X1R5G5B5 = NV902D_SET_DST_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_Y8 = NV902D_SET_DST_FORMAT_V_Y8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_DST_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_DST_FORMAT_V_Y32; \
    UNUSED uint32_t V_Z1R5G5B5 = NV902D_SET_DST_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NV902D_SET_DST_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NV902D_SET_DST_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NV902D_SET_DST_FORMAT_V_O8R8G8B8; \
    UNUSED uint32_t V_Y1_8X8 = NV902D_SET_DST_FORMAT_V_Y1_8X8; \
    UNUSED uint32_t V_RF16 = NV902D_SET_DST_FORMAT_V_RF16; \
    UNUSED uint32_t V_RF32 = NV902D_SET_DST_FORMAT_V_RF32; \
    UNUSED uint32_t V_RF32_GF32 = NV902D_SET_DST_FORMAT_V_RF32_GF32; \
    UNUSED uint32_t V_RF16_GF16_BF16_AF16 = NV902D_SET_DST_FORMAT_V_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t V_RF16_GF16_BF16_X16 = NV902D_SET_DST_FORMAT_V_RF16_GF16_BF16_X16; \
    UNUSED uint32_t V_RF32_GF32_BF32_AF32 = NV902D_SET_DST_FORMAT_V_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t V_RF32_GF32_BF32_X32 = NV902D_SET_DST_FORMAT_V_RF32_GF32_BF32_X32; \
    UNUSED uint32_t V_R16_G16_B16_A16 = NV902D_SET_DST_FORMAT_V_R16_G16_B16_A16; \
    UNUSED uint32_t V_RN16_GN16_BN16_AN16 = NV902D_SET_DST_FORMAT_V_RN16_GN16_BN16_AN16; \
    UNUSED uint32_t V_BF10GF11RF11 = NV902D_SET_DST_FORMAT_V_BF10GF11RF11; \
    UNUSED uint32_t V_AN8BN8GN8RN8 = NV902D_SET_DST_FORMAT_V_AN8BN8GN8RN8; \
    UNUSED uint32_t V_RF16_GF16 = NV902D_SET_DST_FORMAT_V_RF16_GF16; \
    UNUSED uint32_t V_R16_G16 = NV902D_SET_DST_FORMAT_V_R16_G16; \
    UNUSED uint32_t V_RN16_GN16 = NV902D_SET_DST_FORMAT_V_RN16_GN16; \
    UNUSED uint32_t V_G8R8 = NV902D_SET_DST_FORMAT_V_G8R8; \
    UNUSED uint32_t V_GN8RN8 = NV902D_SET_DST_FORMAT_V_GN8RN8; \
    UNUSED uint32_t V_RN16 = NV902D_SET_DST_FORMAT_V_RN16; \
    UNUSED uint32_t V_RN8 = NV902D_SET_DST_FORMAT_V_RN8; \
    UNUSED uint32_t V_A8 = NV902D_SET_DST_FORMAT_V_A8; \
    struct nv_nv902d_SET_DST_FORMAT __data = { .v = (args) }; \
    __NV902D_SET_DST_FORMAT(&val, __data); \
}

#define VA_NV902D_SET_DST_FORMAT V_NV902D_SET_DST_FORMAT

#define P_NV902D_SET_DST_FORMAT(push, args...) do { \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_DST_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A8RL8GL8BL8 = NV902D_SET_DST_FORMAT_V_A8RL8GL8BL8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_DST_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_A8B8G8R8 = NV902D_SET_DST_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A8BL8GL8RL8 = NV902D_SET_DST_FORMAT_V_A8BL8GL8RL8; \
    UNUSED uint32_t V_A2B10G10R10 = NV902D_SET_DST_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_X8R8G8B8 = NV902D_SET_DST_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8RL8GL8BL8 = NV902D_SET_DST_FORMAT_V_X8RL8GL8BL8; \
    UNUSED uint32_t V_X8B8G8R8 = NV902D_SET_DST_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_X8BL8GL8RL8 = NV902D_SET_DST_FORMAT_V_X8BL8GL8RL8; \
    UNUSED uint32_t V_R5G6B5 = NV902D_SET_DST_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_DST_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_X1R5G5B5 = NV902D_SET_DST_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_Y8 = NV902D_SET_DST_FORMAT_V_Y8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_DST_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_DST_FORMAT_V_Y32; \
    UNUSED uint32_t V_Z1R5G5B5 = NV902D_SET_DST_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NV902D_SET_DST_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NV902D_SET_DST_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NV902D_SET_DST_FORMAT_V_O8R8G8B8; \
    UNUSED uint32_t V_Y1_8X8 = NV902D_SET_DST_FORMAT_V_Y1_8X8; \
    UNUSED uint32_t V_RF16 = NV902D_SET_DST_FORMAT_V_RF16; \
    UNUSED uint32_t V_RF32 = NV902D_SET_DST_FORMAT_V_RF32; \
    UNUSED uint32_t V_RF32_GF32 = NV902D_SET_DST_FORMAT_V_RF32_GF32; \
    UNUSED uint32_t V_RF16_GF16_BF16_AF16 = NV902D_SET_DST_FORMAT_V_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t V_RF16_GF16_BF16_X16 = NV902D_SET_DST_FORMAT_V_RF16_GF16_BF16_X16; \
    UNUSED uint32_t V_RF32_GF32_BF32_AF32 = NV902D_SET_DST_FORMAT_V_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t V_RF32_GF32_BF32_X32 = NV902D_SET_DST_FORMAT_V_RF32_GF32_BF32_X32; \
    UNUSED uint32_t V_R16_G16_B16_A16 = NV902D_SET_DST_FORMAT_V_R16_G16_B16_A16; \
    UNUSED uint32_t V_RN16_GN16_BN16_AN16 = NV902D_SET_DST_FORMAT_V_RN16_GN16_BN16_AN16; \
    UNUSED uint32_t V_BF10GF11RF11 = NV902D_SET_DST_FORMAT_V_BF10GF11RF11; \
    UNUSED uint32_t V_AN8BN8GN8RN8 = NV902D_SET_DST_FORMAT_V_AN8BN8GN8RN8; \
    UNUSED uint32_t V_RF16_GF16 = NV902D_SET_DST_FORMAT_V_RF16_GF16; \
    UNUSED uint32_t V_R16_G16 = NV902D_SET_DST_FORMAT_V_R16_G16; \
    UNUSED uint32_t V_RN16_GN16 = NV902D_SET_DST_FORMAT_V_RN16_GN16; \
    UNUSED uint32_t V_G8R8 = NV902D_SET_DST_FORMAT_V_G8R8; \
    UNUSED uint32_t V_GN8RN8 = NV902D_SET_DST_FORMAT_V_GN8RN8; \
    UNUSED uint32_t V_RN16 = NV902D_SET_DST_FORMAT_V_RN16; \
    UNUSED uint32_t V_RN8 = NV902D_SET_DST_FORMAT_V_RN8; \
    UNUSED uint32_t V_A8 = NV902D_SET_DST_FORMAT_V_A8; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_MEMORY_LAYOUT {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_MEMORY_LAYOUT(uint32_t *val_out, struct nv_nv902d_SET_DST_MEMORY_LAYOUT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_DST_MEMORY_LAYOUT(val, args...) { \
    UNUSED uint32_t V_BLOCKLINEAR = NV902D_SET_DST_MEMORY_LAYOUT_V_BLOCKLINEAR; \
    UNUSED uint32_t V_PITCH = NV902D_SET_DST_MEMORY_LAYOUT_V_PITCH; \
    struct nv_nv902d_SET_DST_MEMORY_LAYOUT __data = { .v = (args) }; \
    __NV902D_SET_DST_MEMORY_LAYOUT(&val, __data); \
}

#define VA_NV902D_SET_DST_MEMORY_LAYOUT V_NV902D_SET_DST_MEMORY_LAYOUT

#define P_NV902D_SET_DST_MEMORY_LAYOUT(push, args...) do { \
    UNUSED uint32_t V_BLOCKLINEAR = NV902D_SET_DST_MEMORY_LAYOUT_V_BLOCKLINEAR; \
    UNUSED uint32_t V_PITCH = NV902D_SET_DST_MEMORY_LAYOUT_V_PITCH; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_MEMORY_LAYOUT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_MEMORY_LAYOUT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_BLOCK_SIZE {
    uint32_t height;
    uint32_t depth;
};

static inline void
__NV902D_SET_DST_BLOCK_SIZE(uint32_t *val_out, struct nv_nv902d_SET_DST_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.height < (1ULL << 3));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 3));
    val |= st.depth << 8;
    *val_out = val;
}

#define V_NV902D_SET_DST_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t HEIGHT_ONE_GOB = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NV902D_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    struct nv_nv902d_SET_DST_BLOCK_SIZE __data = args; \
    __NV902D_SET_DST_BLOCK_SIZE(&val, __data); \
}

#define VA_NV902D_SET_DST_BLOCK_SIZE V_NV902D_SET_DST_BLOCK_SIZE

#define P_NV902D_SET_DST_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t HEIGHT_ONE_GOB = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NV902D_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NV902D_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NV902D_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_DEPTH {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_DEPTH(uint32_t *val_out, struct nv_nv902d_SET_DST_DEPTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_DST_DEPTH(val, args...) { \
    struct nv_nv902d_SET_DST_DEPTH __data = { .v = (args) }; \
    __NV902D_SET_DST_DEPTH(&val, __data); \
}

#define VA_NV902D_SET_DST_DEPTH V_NV902D_SET_DST_DEPTH

#define P_NV902D_SET_DST_DEPTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_DEPTH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_DEPTH, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_LAYER {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_LAYER(uint32_t *val_out, struct nv_nv902d_SET_DST_LAYER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_DST_LAYER(val, args...) { \
    struct nv_nv902d_SET_DST_LAYER __data = { .v = (args) }; \
    __NV902D_SET_DST_LAYER(&val, __data); \
}

#define VA_NV902D_SET_DST_LAYER V_NV902D_SET_DST_LAYER

#define P_NV902D_SET_DST_LAYER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_LAYER, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_PITCH {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_PITCH(uint32_t *val_out, struct nv_nv902d_SET_DST_PITCH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_DST_PITCH(val, args...) { \
    struct nv_nv902d_SET_DST_PITCH __data = { .v = (args) }; \
    __NV902D_SET_DST_PITCH(&val, __data); \
}

#define VA_NV902D_SET_DST_PITCH V_NV902D_SET_DST_PITCH

#define P_NV902D_SET_DST_PITCH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_PITCH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_PITCH, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_WIDTH {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_WIDTH(uint32_t *val_out, struct nv_nv902d_SET_DST_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_DST_WIDTH(val, args...) { \
    struct nv_nv902d_SET_DST_WIDTH __data = { .v = (args) }; \
    __NV902D_SET_DST_WIDTH(&val, __data); \
}

#define VA_NV902D_SET_DST_WIDTH V_NV902D_SET_DST_WIDTH

#define P_NV902D_SET_DST_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_HEIGHT {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_HEIGHT(uint32_t *val_out, struct nv_nv902d_SET_DST_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_DST_HEIGHT(val, args...) { \
    struct nv_nv902d_SET_DST_HEIGHT __data = { .v = (args) }; \
    __NV902D_SET_DST_HEIGHT(&val, __data); \
}

#define VA_NV902D_SET_DST_HEIGHT V_NV902D_SET_DST_HEIGHT

#define P_NV902D_SET_DST_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_OFFSET_UPPER {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_OFFSET_UPPER(uint32_t *val_out, struct nv_nv902d_SET_DST_OFFSET_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_DST_OFFSET_UPPER(val, args...) { \
    struct nv_nv902d_SET_DST_OFFSET_UPPER __data = { .v = (args) }; \
    __NV902D_SET_DST_OFFSET_UPPER(&val, __data); \
}

#define VA_NV902D_SET_DST_OFFSET_UPPER V_NV902D_SET_DST_OFFSET_UPPER

#define P_NV902D_SET_DST_OFFSET_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_OFFSET_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_OFFSET_UPPER, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_OFFSET_LOWER {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_OFFSET_LOWER(uint32_t *val_out, struct nv_nv902d_SET_DST_OFFSET_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_DST_OFFSET_LOWER(val, args...) { \
    struct nv_nv902d_SET_DST_OFFSET_LOWER __data = { .v = (args) }; \
    __NV902D_SET_DST_OFFSET_LOWER(&val, __data); \
}

#define VA_NV902D_SET_DST_OFFSET_LOWER V_NV902D_SET_DST_OFFSET_LOWER

#define P_NV902D_SET_DST_OFFSET_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_OFFSET_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_OFFSET_LOWER, nvk_p_ret); \
} while(0)

struct nv_nv902d_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE {
    uint32_t v;
};

static inline void
__NV902D_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(uint32_t *val_out, struct nv_nv902d_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(val, args...) { \
    struct nv_nv902d_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE __data = { .v = (args) }; \
    __NV902D_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(&val, __data); \
}

#define VA_NV902D_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE V_NV902D_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE

#define P_NV902D_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP06 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP06(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP06 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP06(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP06 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP06(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP06 V_NV902D_SET_SPARE_NOOP06

#define P_NV902D_SET_SPARE_NOOP06(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP06(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP06, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SRC_FORMAT {
    uint32_t v;
};

static inline void
__NV902D_SET_SRC_FORMAT(uint32_t *val_out, struct nv_nv902d_SET_SRC_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_SRC_FORMAT(val, args...) { \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_SRC_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A8RL8GL8BL8 = NV902D_SET_SRC_FORMAT_V_A8RL8GL8BL8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_SRC_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_A8B8G8R8 = NV902D_SET_SRC_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A8BL8GL8RL8 = NV902D_SET_SRC_FORMAT_V_A8BL8GL8RL8; \
    UNUSED uint32_t V_A2B10G10R10 = NV902D_SET_SRC_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_X8R8G8B8 = NV902D_SET_SRC_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8RL8GL8BL8 = NV902D_SET_SRC_FORMAT_V_X8RL8GL8BL8; \
    UNUSED uint32_t V_X8B8G8R8 = NV902D_SET_SRC_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_X8BL8GL8RL8 = NV902D_SET_SRC_FORMAT_V_X8BL8GL8RL8; \
    UNUSED uint32_t V_R5G6B5 = NV902D_SET_SRC_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_SRC_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_X1R5G5B5 = NV902D_SET_SRC_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_Y8 = NV902D_SET_SRC_FORMAT_V_Y8; \
    UNUSED uint32_t V_AY8 = NV902D_SET_SRC_FORMAT_V_AY8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_SRC_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_SRC_FORMAT_V_Y32; \
    UNUSED uint32_t V_Z1R5G5B5 = NV902D_SET_SRC_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NV902D_SET_SRC_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NV902D_SET_SRC_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NV902D_SET_SRC_FORMAT_V_O8R8G8B8; \
    UNUSED uint32_t V_Y1_8X8 = NV902D_SET_SRC_FORMAT_V_Y1_8X8; \
    UNUSED uint32_t V_RF16 = NV902D_SET_SRC_FORMAT_V_RF16; \
    UNUSED uint32_t V_RF32 = NV902D_SET_SRC_FORMAT_V_RF32; \
    UNUSED uint32_t V_RF32_GF32 = NV902D_SET_SRC_FORMAT_V_RF32_GF32; \
    UNUSED uint32_t V_RF16_GF16_BF16_AF16 = NV902D_SET_SRC_FORMAT_V_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t V_RF16_GF16_BF16_X16 = NV902D_SET_SRC_FORMAT_V_RF16_GF16_BF16_X16; \
    UNUSED uint32_t V_RF32_GF32_BF32_AF32 = NV902D_SET_SRC_FORMAT_V_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t V_RF32_GF32_BF32_X32 = NV902D_SET_SRC_FORMAT_V_RF32_GF32_BF32_X32; \
    UNUSED uint32_t V_R16_G16_B16_A16 = NV902D_SET_SRC_FORMAT_V_R16_G16_B16_A16; \
    UNUSED uint32_t V_RN16_GN16_BN16_AN16 = NV902D_SET_SRC_FORMAT_V_RN16_GN16_BN16_AN16; \
    UNUSED uint32_t V_BF10GF11RF11 = NV902D_SET_SRC_FORMAT_V_BF10GF11RF11; \
    UNUSED uint32_t V_AN8BN8GN8RN8 = NV902D_SET_SRC_FORMAT_V_AN8BN8GN8RN8; \
    UNUSED uint32_t V_RF16_GF16 = NV902D_SET_SRC_FORMAT_V_RF16_GF16; \
    UNUSED uint32_t V_R16_G16 = NV902D_SET_SRC_FORMAT_V_R16_G16; \
    UNUSED uint32_t V_RN16_GN16 = NV902D_SET_SRC_FORMAT_V_RN16_GN16; \
    UNUSED uint32_t V_G8R8 = NV902D_SET_SRC_FORMAT_V_G8R8; \
    UNUSED uint32_t V_GN8RN8 = NV902D_SET_SRC_FORMAT_V_GN8RN8; \
    UNUSED uint32_t V_RN16 = NV902D_SET_SRC_FORMAT_V_RN16; \
    UNUSED uint32_t V_RN8 = NV902D_SET_SRC_FORMAT_V_RN8; \
    UNUSED uint32_t V_A8 = NV902D_SET_SRC_FORMAT_V_A8; \
    struct nv_nv902d_SET_SRC_FORMAT __data = { .v = (args) }; \
    __NV902D_SET_SRC_FORMAT(&val, __data); \
}

#define VA_NV902D_SET_SRC_FORMAT V_NV902D_SET_SRC_FORMAT

#define P_NV902D_SET_SRC_FORMAT(push, args...) do { \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_SRC_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A8RL8GL8BL8 = NV902D_SET_SRC_FORMAT_V_A8RL8GL8BL8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_SRC_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_A8B8G8R8 = NV902D_SET_SRC_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A8BL8GL8RL8 = NV902D_SET_SRC_FORMAT_V_A8BL8GL8RL8; \
    UNUSED uint32_t V_A2B10G10R10 = NV902D_SET_SRC_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_X8R8G8B8 = NV902D_SET_SRC_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8RL8GL8BL8 = NV902D_SET_SRC_FORMAT_V_X8RL8GL8BL8; \
    UNUSED uint32_t V_X8B8G8R8 = NV902D_SET_SRC_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_X8BL8GL8RL8 = NV902D_SET_SRC_FORMAT_V_X8BL8GL8RL8; \
    UNUSED uint32_t V_R5G6B5 = NV902D_SET_SRC_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_SRC_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_X1R5G5B5 = NV902D_SET_SRC_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_Y8 = NV902D_SET_SRC_FORMAT_V_Y8; \
    UNUSED uint32_t V_AY8 = NV902D_SET_SRC_FORMAT_V_AY8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_SRC_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_SRC_FORMAT_V_Y32; \
    UNUSED uint32_t V_Z1R5G5B5 = NV902D_SET_SRC_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NV902D_SET_SRC_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NV902D_SET_SRC_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NV902D_SET_SRC_FORMAT_V_O8R8G8B8; \
    UNUSED uint32_t V_Y1_8X8 = NV902D_SET_SRC_FORMAT_V_Y1_8X8; \
    UNUSED uint32_t V_RF16 = NV902D_SET_SRC_FORMAT_V_RF16; \
    UNUSED uint32_t V_RF32 = NV902D_SET_SRC_FORMAT_V_RF32; \
    UNUSED uint32_t V_RF32_GF32 = NV902D_SET_SRC_FORMAT_V_RF32_GF32; \
    UNUSED uint32_t V_RF16_GF16_BF16_AF16 = NV902D_SET_SRC_FORMAT_V_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t V_RF16_GF16_BF16_X16 = NV902D_SET_SRC_FORMAT_V_RF16_GF16_BF16_X16; \
    UNUSED uint32_t V_RF32_GF32_BF32_AF32 = NV902D_SET_SRC_FORMAT_V_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t V_RF32_GF32_BF32_X32 = NV902D_SET_SRC_FORMAT_V_RF32_GF32_BF32_X32; \
    UNUSED uint32_t V_R16_G16_B16_A16 = NV902D_SET_SRC_FORMAT_V_R16_G16_B16_A16; \
    UNUSED uint32_t V_RN16_GN16_BN16_AN16 = NV902D_SET_SRC_FORMAT_V_RN16_GN16_BN16_AN16; \
    UNUSED uint32_t V_BF10GF11RF11 = NV902D_SET_SRC_FORMAT_V_BF10GF11RF11; \
    UNUSED uint32_t V_AN8BN8GN8RN8 = NV902D_SET_SRC_FORMAT_V_AN8BN8GN8RN8; \
    UNUSED uint32_t V_RF16_GF16 = NV902D_SET_SRC_FORMAT_V_RF16_GF16; \
    UNUSED uint32_t V_R16_G16 = NV902D_SET_SRC_FORMAT_V_R16_G16; \
    UNUSED uint32_t V_RN16_GN16 = NV902D_SET_SRC_FORMAT_V_RN16_GN16; \
    UNUSED uint32_t V_G8R8 = NV902D_SET_SRC_FORMAT_V_G8R8; \
    UNUSED uint32_t V_GN8RN8 = NV902D_SET_SRC_FORMAT_V_GN8RN8; \
    UNUSED uint32_t V_RN16 = NV902D_SET_SRC_FORMAT_V_RN16; \
    UNUSED uint32_t V_RN8 = NV902D_SET_SRC_FORMAT_V_RN8; \
    UNUSED uint32_t V_A8 = NV902D_SET_SRC_FORMAT_V_A8; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SRC_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SRC_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SRC_MEMORY_LAYOUT {
    uint32_t v;
};

static inline void
__NV902D_SET_SRC_MEMORY_LAYOUT(uint32_t *val_out, struct nv_nv902d_SET_SRC_MEMORY_LAYOUT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_SRC_MEMORY_LAYOUT(val, args...) { \
    UNUSED uint32_t V_BLOCKLINEAR = NV902D_SET_SRC_MEMORY_LAYOUT_V_BLOCKLINEAR; \
    UNUSED uint32_t V_PITCH = NV902D_SET_SRC_MEMORY_LAYOUT_V_PITCH; \
    struct nv_nv902d_SET_SRC_MEMORY_LAYOUT __data = { .v = (args) }; \
    __NV902D_SET_SRC_MEMORY_LAYOUT(&val, __data); \
}

#define VA_NV902D_SET_SRC_MEMORY_LAYOUT V_NV902D_SET_SRC_MEMORY_LAYOUT

#define P_NV902D_SET_SRC_MEMORY_LAYOUT(push, args...) do { \
    UNUSED uint32_t V_BLOCKLINEAR = NV902D_SET_SRC_MEMORY_LAYOUT_V_BLOCKLINEAR; \
    UNUSED uint32_t V_PITCH = NV902D_SET_SRC_MEMORY_LAYOUT_V_PITCH; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SRC_MEMORY_LAYOUT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SRC_MEMORY_LAYOUT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SRC_BLOCK_SIZE {
    uint32_t height;
    uint32_t depth;
};

static inline void
__NV902D_SET_SRC_BLOCK_SIZE(uint32_t *val_out, struct nv_nv902d_SET_SRC_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.height < (1ULL << 3));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 3));
    val |= st.depth << 8;
    *val_out = val;
}

#define V_NV902D_SET_SRC_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t HEIGHT_ONE_GOB = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    struct nv_nv902d_SET_SRC_BLOCK_SIZE __data = args; \
    __NV902D_SET_SRC_BLOCK_SIZE(&val, __data); \
}

#define VA_NV902D_SET_SRC_BLOCK_SIZE V_NV902D_SET_SRC_BLOCK_SIZE

#define P_NV902D_SET_SRC_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t HEIGHT_ONE_GOB = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NV902D_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NV902D_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SRC_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SRC_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SRC_DEPTH {
    uint32_t v;
};

static inline void
__NV902D_SET_SRC_DEPTH(uint32_t *val_out, struct nv_nv902d_SET_SRC_DEPTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SRC_DEPTH(val, args...) { \
    struct nv_nv902d_SET_SRC_DEPTH __data = { .v = (args) }; \
    __NV902D_SET_SRC_DEPTH(&val, __data); \
}

#define VA_NV902D_SET_SRC_DEPTH V_NV902D_SET_SRC_DEPTH

#define P_NV902D_SET_SRC_DEPTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SRC_DEPTH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SRC_DEPTH, nvk_p_ret); \
} while(0)

struct nv_nv902d_TWOD_INVALIDATE_TEXTURE_DATA_CACHE {
    uint32_t v;
};

static inline void
__NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE(uint32_t *val_out, struct nv_nv902d_TWOD_INVALIDATE_TEXTURE_DATA_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 2));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE(val, args...) { \
    UNUSED uint32_t V_L1_ONLY = NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V_L1_ONLY; \
    UNUSED uint32_t V_L2_ONLY = NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V_L2_ONLY; \
    UNUSED uint32_t V_L1_AND_L2 = NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V_L1_AND_L2; \
    struct nv_nv902d_TWOD_INVALIDATE_TEXTURE_DATA_CACHE __data = { .v = (args) }; \
    __NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE(&val, __data); \
}

#define VA_NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE V_NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE

#define P_NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE(push, args...) do { \
    UNUSED uint32_t V_L1_ONLY = NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V_L1_ONLY; \
    UNUSED uint32_t V_L2_ONLY = NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V_L2_ONLY; \
    UNUSED uint32_t V_L1_AND_L2 = NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V_L1_AND_L2; \
    uint32_t nvk_p_ret; \
    V_NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_TWOD_INVALIDATE_TEXTURE_DATA_CACHE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SRC_PITCH {
    uint32_t v;
};

static inline void
__NV902D_SET_SRC_PITCH(uint32_t *val_out, struct nv_nv902d_SET_SRC_PITCH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SRC_PITCH(val, args...) { \
    struct nv_nv902d_SET_SRC_PITCH __data = { .v = (args) }; \
    __NV902D_SET_SRC_PITCH(&val, __data); \
}

#define VA_NV902D_SET_SRC_PITCH V_NV902D_SET_SRC_PITCH

#define P_NV902D_SET_SRC_PITCH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SRC_PITCH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SRC_PITCH, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SRC_WIDTH {
    uint32_t v;
};

static inline void
__NV902D_SET_SRC_WIDTH(uint32_t *val_out, struct nv_nv902d_SET_SRC_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SRC_WIDTH(val, args...) { \
    struct nv_nv902d_SET_SRC_WIDTH __data = { .v = (args) }; \
    __NV902D_SET_SRC_WIDTH(&val, __data); \
}

#define VA_NV902D_SET_SRC_WIDTH V_NV902D_SET_SRC_WIDTH

#define P_NV902D_SET_SRC_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SRC_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SRC_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SRC_HEIGHT {
    uint32_t v;
};

static inline void
__NV902D_SET_SRC_HEIGHT(uint32_t *val_out, struct nv_nv902d_SET_SRC_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SRC_HEIGHT(val, args...) { \
    struct nv_nv902d_SET_SRC_HEIGHT __data = { .v = (args) }; \
    __NV902D_SET_SRC_HEIGHT(&val, __data); \
}

#define VA_NV902D_SET_SRC_HEIGHT V_NV902D_SET_SRC_HEIGHT

#define P_NV902D_SET_SRC_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SRC_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SRC_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SRC_OFFSET_UPPER {
    uint32_t v;
};

static inline void
__NV902D_SET_SRC_OFFSET_UPPER(uint32_t *val_out, struct nv_nv902d_SET_SRC_OFFSET_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_SRC_OFFSET_UPPER(val, args...) { \
    struct nv_nv902d_SET_SRC_OFFSET_UPPER __data = { .v = (args) }; \
    __NV902D_SET_SRC_OFFSET_UPPER(&val, __data); \
}

#define VA_NV902D_SET_SRC_OFFSET_UPPER V_NV902D_SET_SRC_OFFSET_UPPER

#define P_NV902D_SET_SRC_OFFSET_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SRC_OFFSET_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SRC_OFFSET_UPPER, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SRC_OFFSET_LOWER {
    uint32_t v;
};

static inline void
__NV902D_SET_SRC_OFFSET_LOWER(uint32_t *val_out, struct nv_nv902d_SET_SRC_OFFSET_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SRC_OFFSET_LOWER(val, args...) { \
    struct nv_nv902d_SET_SRC_OFFSET_LOWER __data = { .v = (args) }; \
    __NV902D_SET_SRC_OFFSET_LOWER(&val, __data); \
}

#define VA_NV902D_SET_SRC_OFFSET_LOWER V_NV902D_SET_SRC_OFFSET_LOWER

#define P_NV902D_SET_SRC_OFFSET_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SRC_OFFSET_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SRC_OFFSET_LOWER, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 2));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION(val, args...) { \
    UNUSED uint32_t V_NO_PROMOTION = NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_NO_PROMOTION; \
    UNUSED uint32_t V_PROMOTE_TO_2_V = NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_PROMOTE_TO_2_V; \
    UNUSED uint32_t V_PROMOTE_TO_2_H = NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_PROMOTE_TO_2_H; \
    UNUSED uint32_t V_PROMOTE_TO_4 = NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_PROMOTE_TO_4; \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION V_NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION

#define P_NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION(push, args...) do { \
    UNUSED uint32_t V_NO_PROMOTION = NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_NO_PROMOTION; \
    UNUSED uint32_t V_PROMOTE_TO_2_V = NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_PROMOTE_TO_2_V; \
    UNUSED uint32_t V_PROMOTE_TO_2_H = NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_PROMOTE_TO_2_H; \
    UNUSED uint32_t V_PROMOTE_TO_4 = NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_PROMOTE_TO_4; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP12 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP12(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP12 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP12(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP12 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP12(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP12 V_NV902D_SET_SPARE_NOOP12

#define P_NV902D_SET_SPARE_NOOP12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP12(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP12, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_NUM_PROCESSING_CLUSTERS {
    uint32_t v;
};

static inline void
__NV902D_SET_NUM_PROCESSING_CLUSTERS(uint32_t *val_out, struct nv_nv902d_SET_NUM_PROCESSING_CLUSTERS st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_NUM_PROCESSING_CLUSTERS(val, args...) { \
    UNUSED uint32_t V_ALL = NV902D_SET_NUM_PROCESSING_CLUSTERS_V_ALL; \
    UNUSED uint32_t V_ONE = NV902D_SET_NUM_PROCESSING_CLUSTERS_V_ONE; \
    struct nv_nv902d_SET_NUM_PROCESSING_CLUSTERS __data = { .v = (args) }; \
    __NV902D_SET_NUM_PROCESSING_CLUSTERS(&val, __data); \
}

#define VA_NV902D_SET_NUM_PROCESSING_CLUSTERS V_NV902D_SET_NUM_PROCESSING_CLUSTERS

#define P_NV902D_SET_NUM_PROCESSING_CLUSTERS(push, args...) do { \
    UNUSED uint32_t V_ALL = NV902D_SET_NUM_PROCESSING_CLUSTERS_V_ALL; \
    UNUSED uint32_t V_ONE = NV902D_SET_NUM_PROCESSING_CLUSTERS_V_ONE; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_NUM_PROCESSING_CLUSTERS(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_NUM_PROCESSING_CLUSTERS, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NV902D_SET_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nv902d_SET_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_ENABLE_A(val, args...) { \
    struct nv_nv902d_SET_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NV902D_SET_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NV902D_SET_RENDER_ENABLE_A V_NV902D_SET_RENDER_ENABLE_A

#define P_NV902D_SET_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NV902D_SET_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nv902d_SET_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_ENABLE_B(val, args...) { \
    struct nv_nv902d_SET_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NV902D_SET_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NV902D_SET_RENDER_ENABLE_B V_NV902D_SET_RENDER_ENABLE_B

#define P_NV902D_SET_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NV902D_SET_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nv902d_SET_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NV902D_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NV902D_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NV902D_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NV902D_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NV902D_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nv902d_SET_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NV902D_SET_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NV902D_SET_RENDER_ENABLE_C V_NV902D_SET_RENDER_ENABLE_C

#define P_NV902D_SET_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NV902D_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NV902D_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NV902D_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NV902D_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NV902D_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP08 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP08(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP08 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP08(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP08 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP08(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP08 V_NV902D_SET_SPARE_NOOP08

#define P_NV902D_SET_SPARE_NOOP08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP08(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP08, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP01 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP01(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP01(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP01 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP01(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP01 V_NV902D_SET_SPARE_NOOP01

#define P_NV902D_SET_SPARE_NOOP01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP01(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP01, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP11 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP11(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP11 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP11(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP11 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP11(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP11 V_NV902D_SET_SPARE_NOOP11

#define P_NV902D_SET_SPARE_NOOP11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP11(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP11, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP07 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP07(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP07 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP07(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP07 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP07(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP07 V_NV902D_SET_SPARE_NOOP07

#define P_NV902D_SET_SPARE_NOOP07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP07(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP07, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_CLIP_X0 {
    uint32_t v;
};

static inline void
__NV902D_SET_CLIP_X0(uint32_t *val_out, struct nv_nv902d_SET_CLIP_X0 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_CLIP_X0(val, args...) { \
    struct nv_nv902d_SET_CLIP_X0 __data = { .v = (args) }; \
    __NV902D_SET_CLIP_X0(&val, __data); \
}

#define VA_NV902D_SET_CLIP_X0 V_NV902D_SET_CLIP_X0

#define P_NV902D_SET_CLIP_X0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_CLIP_X0(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_CLIP_X0, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_CLIP_Y0 {
    uint32_t v;
};

static inline void
__NV902D_SET_CLIP_Y0(uint32_t *val_out, struct nv_nv902d_SET_CLIP_Y0 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_CLIP_Y0(val, args...) { \
    struct nv_nv902d_SET_CLIP_Y0 __data = { .v = (args) }; \
    __NV902D_SET_CLIP_Y0(&val, __data); \
}

#define VA_NV902D_SET_CLIP_Y0 V_NV902D_SET_CLIP_Y0

#define P_NV902D_SET_CLIP_Y0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_CLIP_Y0(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_CLIP_Y0, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_CLIP_WIDTH {
    uint32_t v;
};

static inline void
__NV902D_SET_CLIP_WIDTH(uint32_t *val_out, struct nv_nv902d_SET_CLIP_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_CLIP_WIDTH(val, args...) { \
    struct nv_nv902d_SET_CLIP_WIDTH __data = { .v = (args) }; \
    __NV902D_SET_CLIP_WIDTH(&val, __data); \
}

#define VA_NV902D_SET_CLIP_WIDTH V_NV902D_SET_CLIP_WIDTH

#define P_NV902D_SET_CLIP_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_CLIP_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_CLIP_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_CLIP_HEIGHT {
    uint32_t v;
};

static inline void
__NV902D_SET_CLIP_HEIGHT(uint32_t *val_out, struct nv_nv902d_SET_CLIP_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_CLIP_HEIGHT(val, args...) { \
    struct nv_nv902d_SET_CLIP_HEIGHT __data = { .v = (args) }; \
    __NV902D_SET_CLIP_HEIGHT(&val, __data); \
}

#define VA_NV902D_SET_CLIP_HEIGHT V_NV902D_SET_CLIP_HEIGHT

#define P_NV902D_SET_CLIP_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_CLIP_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_CLIP_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_CLIP_ENABLE {
    uint32_t v;
};

static inline void
__NV902D_SET_CLIP_ENABLE(uint32_t *val_out, struct nv_nv902d_SET_CLIP_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_CLIP_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NV902D_SET_CLIP_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NV902D_SET_CLIP_ENABLE_V_TRUE; \
    struct nv_nv902d_SET_CLIP_ENABLE __data = { .v = (args) }; \
    __NV902D_SET_CLIP_ENABLE(&val, __data); \
}

#define VA_NV902D_SET_CLIP_ENABLE V_NV902D_SET_CLIP_ENABLE

#define P_NV902D_SET_CLIP_ENABLE(push, args...) do { \
    UNUSED uint32_t V_FALSE = NV902D_SET_CLIP_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NV902D_SET_CLIP_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_CLIP_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_CLIP_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_COLOR_KEY_FORMAT {
    uint32_t v;
};

static inline void
__NV902D_SET_COLOR_KEY_FORMAT(uint32_t *val_out, struct nv_nv902d_SET_COLOR_KEY_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 3));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_COLOR_KEY_FORMAT(val, args...) { \
    UNUSED uint32_t V_A16R5G6B5 = NV902D_SET_COLOR_KEY_FORMAT_V_A16R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_COLOR_KEY_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_COLOR_KEY_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_COLOR_KEY_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_Y8 = NV902D_SET_COLOR_KEY_FORMAT_V_Y8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_COLOR_KEY_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_COLOR_KEY_FORMAT_V_Y32; \
    struct nv_nv902d_SET_COLOR_KEY_FORMAT __data = { .v = (args) }; \
    __NV902D_SET_COLOR_KEY_FORMAT(&val, __data); \
}

#define VA_NV902D_SET_COLOR_KEY_FORMAT V_NV902D_SET_COLOR_KEY_FORMAT

#define P_NV902D_SET_COLOR_KEY_FORMAT(push, args...) do { \
    UNUSED uint32_t V_A16R5G6B5 = NV902D_SET_COLOR_KEY_FORMAT_V_A16R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_COLOR_KEY_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_COLOR_KEY_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_COLOR_KEY_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_Y8 = NV902D_SET_COLOR_KEY_FORMAT_V_Y8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_COLOR_KEY_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_COLOR_KEY_FORMAT_V_Y32; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_COLOR_KEY_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_COLOR_KEY_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_COLOR_KEY {
    uint32_t v;
};

static inline void
__NV902D_SET_COLOR_KEY(uint32_t *val_out, struct nv_nv902d_SET_COLOR_KEY st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_COLOR_KEY(val, args...) { \
    struct nv_nv902d_SET_COLOR_KEY __data = { .v = (args) }; \
    __NV902D_SET_COLOR_KEY(&val, __data); \
}

#define VA_NV902D_SET_COLOR_KEY V_NV902D_SET_COLOR_KEY

#define P_NV902D_SET_COLOR_KEY(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_COLOR_KEY(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_COLOR_KEY, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_COLOR_KEY_ENABLE {
    uint32_t v;
};

static inline void
__NV902D_SET_COLOR_KEY_ENABLE(uint32_t *val_out, struct nv_nv902d_SET_COLOR_KEY_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_COLOR_KEY_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NV902D_SET_COLOR_KEY_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NV902D_SET_COLOR_KEY_ENABLE_V_TRUE; \
    struct nv_nv902d_SET_COLOR_KEY_ENABLE __data = { .v = (args) }; \
    __NV902D_SET_COLOR_KEY_ENABLE(&val, __data); \
}

#define VA_NV902D_SET_COLOR_KEY_ENABLE V_NV902D_SET_COLOR_KEY_ENABLE

#define P_NV902D_SET_COLOR_KEY_ENABLE(push, args...) do { \
    UNUSED uint32_t V_FALSE = NV902D_SET_COLOR_KEY_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NV902D_SET_COLOR_KEY_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_COLOR_KEY_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_COLOR_KEY_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_ROP {
    uint32_t v;
};

static inline void
__NV902D_SET_ROP(uint32_t *val_out, struct nv_nv902d_SET_ROP st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_ROP(val, args...) { \
    struct nv_nv902d_SET_ROP __data = { .v = (args) }; \
    __NV902D_SET_ROP(&val, __data); \
}

#define VA_NV902D_SET_ROP V_NV902D_SET_ROP

#define P_NV902D_SET_ROP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_ROP(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_ROP, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_BETA1 {
    uint32_t v;
};

static inline void
__NV902D_SET_BETA1(uint32_t *val_out, struct nv_nv902d_SET_BETA1 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_BETA1(val, args...) { \
    struct nv_nv902d_SET_BETA1 __data = { .v = (args) }; \
    __NV902D_SET_BETA1(&val, __data); \
}

#define VA_NV902D_SET_BETA1 V_NV902D_SET_BETA1

#define P_NV902D_SET_BETA1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_BETA1(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_BETA1, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_BETA4 {
    uint32_t b;
    uint32_t g;
    uint32_t r;
    uint32_t a;
};

static inline void
__NV902D_SET_BETA4(uint32_t *val_out, struct nv_nv902d_SET_BETA4 st)
{
    uint32_t val = 0;
    
    assert(st.b < (1ULL << 8));
    val |= st.b << 0;
    
    assert(st.g < (1ULL << 8));
    val |= st.g << 8;
    
    assert(st.r < (1ULL << 8));
    val |= st.r << 16;
    
    assert(st.a < (1ULL << 8));
    val |= st.a << 24;
    *val_out = val;
}

#define V_NV902D_SET_BETA4(val, args...) { \
    struct nv_nv902d_SET_BETA4 __data = args; \
    __NV902D_SET_BETA4(&val, __data); \
}

#define VA_NV902D_SET_BETA4 V_NV902D_SET_BETA4

#define P_NV902D_SET_BETA4(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_BETA4(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_BETA4, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_OPERATION {
    uint32_t v;
};

static inline void
__NV902D_SET_OPERATION(uint32_t *val_out, struct nv_nv902d_SET_OPERATION st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 3));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_OPERATION(val, args...) { \
    UNUSED uint32_t V_SRCCOPY_AND = NV902D_SET_OPERATION_V_SRCCOPY_AND; \
    UNUSED uint32_t V_ROP_AND = NV902D_SET_OPERATION_V_ROP_AND; \
    UNUSED uint32_t V_BLEND_AND = NV902D_SET_OPERATION_V_BLEND_AND; \
    UNUSED uint32_t V_SRCCOPY = NV902D_SET_OPERATION_V_SRCCOPY; \
    UNUSED uint32_t V_ROP = NV902D_SET_OPERATION_V_ROP; \
    UNUSED uint32_t V_SRCCOPY_PREMULT = NV902D_SET_OPERATION_V_SRCCOPY_PREMULT; \
    UNUSED uint32_t V_BLEND_PREMULT = NV902D_SET_OPERATION_V_BLEND_PREMULT; \
    struct nv_nv902d_SET_OPERATION __data = { .v = (args) }; \
    __NV902D_SET_OPERATION(&val, __data); \
}

#define VA_NV902D_SET_OPERATION V_NV902D_SET_OPERATION

#define P_NV902D_SET_OPERATION(push, args...) do { \
    UNUSED uint32_t V_SRCCOPY_AND = NV902D_SET_OPERATION_V_SRCCOPY_AND; \
    UNUSED uint32_t V_ROP_AND = NV902D_SET_OPERATION_V_ROP_AND; \
    UNUSED uint32_t V_BLEND_AND = NV902D_SET_OPERATION_V_BLEND_AND; \
    UNUSED uint32_t V_SRCCOPY = NV902D_SET_OPERATION_V_SRCCOPY; \
    UNUSED uint32_t V_ROP = NV902D_SET_OPERATION_V_ROP; \
    UNUSED uint32_t V_SRCCOPY_PREMULT = NV902D_SET_OPERATION_V_SRCCOPY_PREMULT; \
    UNUSED uint32_t V_BLEND_PREMULT = NV902D_SET_OPERATION_V_BLEND_PREMULT; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_OPERATION(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_OPERATION, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PATTERN_OFFSET {
    uint32_t x;
    uint32_t y;
};

static inline void
__NV902D_SET_PATTERN_OFFSET(uint32_t *val_out, struct nv_nv902d_SET_PATTERN_OFFSET st)
{
    uint32_t val = 0;
    
    assert(st.x < (1ULL << 6));
    val |= st.x << 0;
    
    assert(st.y < (1ULL << 6));
    val |= st.y << 8;
    *val_out = val;
}

#define V_NV902D_SET_PATTERN_OFFSET(val, args...) { \
    struct nv_nv902d_SET_PATTERN_OFFSET __data = args; \
    __NV902D_SET_PATTERN_OFFSET(&val, __data); \
}

#define VA_NV902D_SET_PATTERN_OFFSET V_NV902D_SET_PATTERN_OFFSET

#define P_NV902D_SET_PATTERN_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PATTERN_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PATTERN_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PATTERN_SELECT {
    uint32_t v;
};

static inline void
__NV902D_SET_PATTERN_SELECT(uint32_t *val_out, struct nv_nv902d_SET_PATTERN_SELECT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 2));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PATTERN_SELECT(val, args...) { \
    UNUSED uint32_t V_MONOCHROME_8x8 = NV902D_SET_PATTERN_SELECT_V_MONOCHROME_8x8; \
    UNUSED uint32_t V_MONOCHROME_64x1 = NV902D_SET_PATTERN_SELECT_V_MONOCHROME_64x1; \
    UNUSED uint32_t V_MONOCHROME_1x64 = NV902D_SET_PATTERN_SELECT_V_MONOCHROME_1x64; \
    UNUSED uint32_t V_COLOR = NV902D_SET_PATTERN_SELECT_V_COLOR; \
    struct nv_nv902d_SET_PATTERN_SELECT __data = { .v = (args) }; \
    __NV902D_SET_PATTERN_SELECT(&val, __data); \
}

#define VA_NV902D_SET_PATTERN_SELECT V_NV902D_SET_PATTERN_SELECT

#define P_NV902D_SET_PATTERN_SELECT(push, args...) do { \
    UNUSED uint32_t V_MONOCHROME_8x8 = NV902D_SET_PATTERN_SELECT_V_MONOCHROME_8x8; \
    UNUSED uint32_t V_MONOCHROME_64x1 = NV902D_SET_PATTERN_SELECT_V_MONOCHROME_64x1; \
    UNUSED uint32_t V_MONOCHROME_1x64 = NV902D_SET_PATTERN_SELECT_V_MONOCHROME_1x64; \
    UNUSED uint32_t V_COLOR = NV902D_SET_PATTERN_SELECT_V_COLOR; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PATTERN_SELECT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PATTERN_SELECT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE {
    uint32_t v;
};

static inline void
__NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE(uint32_t *val_out, struct nv_nv902d_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE(val, args...) { \
    UNUSED uint32_t V_FALSE = NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE_V_TRUE; \
    struct nv_nv902d_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE __data = { .v = (args) }; \
    __NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE(&val, __data); \
}

#define VA_NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE V_NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE

#define P_NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE(push, args...) do { \
    UNUSED uint32_t V_FALSE = NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_DST_COLOR_RENDER_TO_ZETA_SURFACE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP04 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP04(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP04 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP04(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP04 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP04(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP04 V_NV902D_SET_SPARE_NOOP04

#define P_NV902D_SET_SPARE_NOOP04(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP04(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP04, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP15 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP15(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP15 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP15(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP15 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP15(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP15 V_NV902D_SET_SPARE_NOOP15

#define P_NV902D_SET_SPARE_NOOP15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP15(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP15, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP13 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP13(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP13 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP13(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP13 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP13(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP13 V_NV902D_SET_SPARE_NOOP13

#define P_NV902D_SET_SPARE_NOOP13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP13(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP13, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP03 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP03(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP03(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP03 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP03(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP03 V_NV902D_SET_SPARE_NOOP03

#define P_NV902D_SET_SPARE_NOOP03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP03(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP03, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP14 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP14(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP14 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP14(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP14 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP14(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP14 V_NV902D_SET_SPARE_NOOP14

#define P_NV902D_SET_SPARE_NOOP14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP14(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP14, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP02 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP02(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP02(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP02 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP02(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP02 V_NV902D_SET_SPARE_NOOP02

#define P_NV902D_SET_SPARE_NOOP02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP02(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP02, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_COMPRESSION {
    uint32_t enable;
};

static inline void
__NV902D_SET_COMPRESSION(uint32_t *val_out, struct nv_nv902d_SET_COMPRESSION st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NV902D_SET_COMPRESSION(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NV902D_SET_COMPRESSION_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV902D_SET_COMPRESSION_ENABLE_TRUE; \
    struct nv_nv902d_SET_COMPRESSION __data = { .enable = (args) }; \
    __NV902D_SET_COMPRESSION(&val, __data); \
}

#define VA_NV902D_SET_COMPRESSION V_NV902D_SET_COMPRESSION

#define P_NV902D_SET_COMPRESSION(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NV902D_SET_COMPRESSION_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NV902D_SET_COMPRESSION_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_COMPRESSION(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_COMPRESSION, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP09 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP09(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP09 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP09(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP09 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP09(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP09 V_NV902D_SET_SPARE_NOOP09

#define P_NV902D_SET_SPARE_NOOP09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP09(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP09, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_ENABLE_OVERRIDE {
    uint32_t mode;
};

static inline void
__NV902D_SET_RENDER_ENABLE_OVERRIDE(uint32_t *val_out, struct nv_nv902d_SET_RENDER_ENABLE_OVERRIDE st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_ENABLE_OVERRIDE(val, args...) { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NV902D_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NV902D_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NV902D_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    struct nv_nv902d_SET_RENDER_ENABLE_OVERRIDE __data = { .mode = (args) }; \
    __NV902D_SET_RENDER_ENABLE_OVERRIDE(&val, __data); \
}

#define VA_NV902D_SET_RENDER_ENABLE_OVERRIDE V_NV902D_SET_RENDER_ENABLE_OVERRIDE

#define P_NV902D_SET_RENDER_ENABLE_OVERRIDE(push, args...) do { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NV902D_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NV902D_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NV902D_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_ENABLE_OVERRIDE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_ENABLE_OVERRIDE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DIRECTION {
    uint32_t horizontal;
    uint32_t vertical;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DIRECTION st)
{
    uint32_t val = 0;
    
    assert(st.horizontal < (1ULL << 2));
    val |= st.horizontal << 0;
    
    assert(st.vertical < (1ULL << 2));
    val |= st.vertical << 4;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION(val, args...) { \
    UNUSED uint32_t HORIZONTAL_HW_DECIDES = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL_HW_DECIDES; \
    UNUSED uint32_t HORIZONTAL_LEFT_TO_RIGHT = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL_LEFT_TO_RIGHT; \
    UNUSED uint32_t HORIZONTAL_RIGHT_TO_LEFT = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL_RIGHT_TO_LEFT; \
    UNUSED uint32_t VERTICAL_HW_DECIDES = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL_HW_DECIDES; \
    UNUSED uint32_t VERTICAL_TOP_TO_BOTTOM = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL_TOP_TO_BOTTOM; \
    UNUSED uint32_t VERTICAL_BOTTOM_TO_TOP = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL_BOTTOM_TO_TOP; \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DIRECTION __data = args; \
    __NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION V_NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION

#define P_NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION(push, args...) do { \
    UNUSED uint32_t HORIZONTAL_HW_DECIDES = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL_HW_DECIDES; \
    UNUSED uint32_t HORIZONTAL_LEFT_TO_RIGHT = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL_LEFT_TO_RIGHT; \
    UNUSED uint32_t HORIZONTAL_RIGHT_TO_LEFT = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL_RIGHT_TO_LEFT; \
    UNUSED uint32_t VERTICAL_HW_DECIDES = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL_HW_DECIDES; \
    UNUSED uint32_t VERTICAL_TOP_TO_BOTTOM = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL_TOP_TO_BOTTOM; \
    UNUSED uint32_t VERTICAL_BOTTOM_TO_TOP = NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL_BOTTOM_TO_TOP; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_DIRECTION, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_SPARE_NOOP10 {
    uint32_t v;
};

static inline void
__NV902D_SET_SPARE_NOOP10(uint32_t *val_out, struct nv_nv902d_SET_SPARE_NOOP10 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_SPARE_NOOP10(val, args...) { \
    struct nv_nv902d_SET_SPARE_NOOP10 __data = { .v = (args) }; \
    __NV902D_SET_SPARE_NOOP10(&val, __data); \
}

#define VA_NV902D_SET_SPARE_NOOP10 V_NV902D_SET_SPARE_NOOP10

#define P_NV902D_SET_SPARE_NOOP10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_SPARE_NOOP10(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_SPARE_NOOP10, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MONOCHROME_PATTERN_COLOR_FORMAT {
    uint32_t v;
};

static inline void
__NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT(uint32_t *val_out, struct nv_nv902d_SET_MONOCHROME_PATTERN_COLOR_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 3));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT(val, args...) { \
    UNUSED uint32_t V_A8X8R5G6B5 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8X8R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A8Y8 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8Y8; \
    UNUSED uint32_t V_A8X8Y16 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8X8Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_Y32; \
    UNUSED uint32_t V_BYTE_EXPAND = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_BYTE_EXPAND; \
    struct nv_nv902d_SET_MONOCHROME_PATTERN_COLOR_FORMAT __data = { .v = (args) }; \
    __NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT(&val, __data); \
}

#define VA_NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT V_NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT

#define P_NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT(push, args...) do { \
    UNUSED uint32_t V_A8X8R5G6B5 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8X8R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A8Y8 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8Y8; \
    UNUSED uint32_t V_A8X8Y16 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8X8Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_Y32; \
    UNUSED uint32_t V_BYTE_EXPAND = NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_BYTE_EXPAND; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MONOCHROME_PATTERN_COLOR_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MONOCHROME_PATTERN_FORMAT {
    uint32_t v;
};

static inline void
__NV902D_SET_MONOCHROME_PATTERN_FORMAT(uint32_t *val_out, struct nv_nv902d_SET_MONOCHROME_PATTERN_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_MONOCHROME_PATTERN_FORMAT(val, args...) { \
    UNUSED uint32_t V_CGA6_M1 = NV902D_SET_MONOCHROME_PATTERN_FORMAT_V_CGA6_M1; \
    UNUSED uint32_t V_LE_M1 = NV902D_SET_MONOCHROME_PATTERN_FORMAT_V_LE_M1; \
    struct nv_nv902d_SET_MONOCHROME_PATTERN_FORMAT __data = { .v = (args) }; \
    __NV902D_SET_MONOCHROME_PATTERN_FORMAT(&val, __data); \
}

#define VA_NV902D_SET_MONOCHROME_PATTERN_FORMAT V_NV902D_SET_MONOCHROME_PATTERN_FORMAT

#define P_NV902D_SET_MONOCHROME_PATTERN_FORMAT(push, args...) do { \
    UNUSED uint32_t V_CGA6_M1 = NV902D_SET_MONOCHROME_PATTERN_FORMAT_V_CGA6_M1; \
    UNUSED uint32_t V_LE_M1 = NV902D_SET_MONOCHROME_PATTERN_FORMAT_V_LE_M1; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MONOCHROME_PATTERN_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MONOCHROME_PATTERN_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MONOCHROME_PATTERN_COLOR0 {
    uint32_t v;
};

static inline void
__NV902D_SET_MONOCHROME_PATTERN_COLOR0(uint32_t *val_out, struct nv_nv902d_SET_MONOCHROME_PATTERN_COLOR0 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_MONOCHROME_PATTERN_COLOR0(val, args...) { \
    struct nv_nv902d_SET_MONOCHROME_PATTERN_COLOR0 __data = { .v = (args) }; \
    __NV902D_SET_MONOCHROME_PATTERN_COLOR0(&val, __data); \
}

#define VA_NV902D_SET_MONOCHROME_PATTERN_COLOR0 V_NV902D_SET_MONOCHROME_PATTERN_COLOR0

#define P_NV902D_SET_MONOCHROME_PATTERN_COLOR0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MONOCHROME_PATTERN_COLOR0(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MONOCHROME_PATTERN_COLOR0, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MONOCHROME_PATTERN_COLOR1 {
    uint32_t v;
};

static inline void
__NV902D_SET_MONOCHROME_PATTERN_COLOR1(uint32_t *val_out, struct nv_nv902d_SET_MONOCHROME_PATTERN_COLOR1 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_MONOCHROME_PATTERN_COLOR1(val, args...) { \
    struct nv_nv902d_SET_MONOCHROME_PATTERN_COLOR1 __data = { .v = (args) }; \
    __NV902D_SET_MONOCHROME_PATTERN_COLOR1(&val, __data); \
}

#define VA_NV902D_SET_MONOCHROME_PATTERN_COLOR1 V_NV902D_SET_MONOCHROME_PATTERN_COLOR1

#define P_NV902D_SET_MONOCHROME_PATTERN_COLOR1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MONOCHROME_PATTERN_COLOR1(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MONOCHROME_PATTERN_COLOR1, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MONOCHROME_PATTERN0 {
    uint32_t v;
};

static inline void
__NV902D_SET_MONOCHROME_PATTERN0(uint32_t *val_out, struct nv_nv902d_SET_MONOCHROME_PATTERN0 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_MONOCHROME_PATTERN0(val, args...) { \
    struct nv_nv902d_SET_MONOCHROME_PATTERN0 __data = { .v = (args) }; \
    __NV902D_SET_MONOCHROME_PATTERN0(&val, __data); \
}

#define VA_NV902D_SET_MONOCHROME_PATTERN0 V_NV902D_SET_MONOCHROME_PATTERN0

#define P_NV902D_SET_MONOCHROME_PATTERN0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MONOCHROME_PATTERN0(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MONOCHROME_PATTERN0, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MONOCHROME_PATTERN1 {
    uint32_t v;
};

static inline void
__NV902D_SET_MONOCHROME_PATTERN1(uint32_t *val_out, struct nv_nv902d_SET_MONOCHROME_PATTERN1 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_MONOCHROME_PATTERN1(val, args...) { \
    struct nv_nv902d_SET_MONOCHROME_PATTERN1 __data = { .v = (args) }; \
    __NV902D_SET_MONOCHROME_PATTERN1(&val, __data); \
}

#define VA_NV902D_SET_MONOCHROME_PATTERN1 V_NV902D_SET_MONOCHROME_PATTERN1

#define P_NV902D_SET_MONOCHROME_PATTERN1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MONOCHROME_PATTERN1(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MONOCHROME_PATTERN1, nvk_p_ret); \
} while(0)

struct nv_nv902d_COLOR_PATTERN_X8R8G8B8 {
    uint32_t b0;
    uint32_t g0;
    uint32_t r0;
    uint32_t ignore0;
};

static inline void
__NV902D_COLOR_PATTERN_X8R8G8B8(uint32_t *val_out, struct nv_nv902d_COLOR_PATTERN_X8R8G8B8 st)
{
    uint32_t val = 0;
    
    assert(st.b0 < (1ULL << 8));
    val |= st.b0 << 0;
    
    assert(st.g0 < (1ULL << 8));
    val |= st.g0 << 8;
    
    assert(st.r0 < (1ULL << 8));
    val |= st.r0 << 16;
    
    assert(st.ignore0 < (1ULL << 8));
    val |= st.ignore0 << 24;
    *val_out = val;
}

#define V_NV902D_COLOR_PATTERN_X8R8G8B8(val, args...) { \
    struct nv_nv902d_COLOR_PATTERN_X8R8G8B8 __data = args; \
    __NV902D_COLOR_PATTERN_X8R8G8B8(&val, __data); \
}

#define VA_NV902D_COLOR_PATTERN_X8R8G8B8(i) V_NV902D_COLOR_PATTERN_X8R8G8B8

#define P_NV902D_COLOR_PATTERN_X8R8G8B8(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_COLOR_PATTERN_X8R8G8B8(nvk_p_ret, args); \
    nv_push_val(push, NV902D_COLOR_PATTERN_X8R8G8B8(idx), nvk_p_ret); \
} while(0)

struct nv_nv902d_COLOR_PATTERN_R5G6B5 {
    uint32_t b0;
    uint32_t g0;
    uint32_t r0;
    uint32_t b1;
    uint32_t g1;
    uint32_t r1;
};

static inline void
__NV902D_COLOR_PATTERN_R5G6B5(uint32_t *val_out, struct nv_nv902d_COLOR_PATTERN_R5G6B5 st)
{
    uint32_t val = 0;
    
    assert(st.b0 < (1ULL << 5));
    val |= st.b0 << 0;
    
    assert(st.g0 < (1ULL << 6));
    val |= st.g0 << 5;
    
    assert(st.r0 < (1ULL << 5));
    val |= st.r0 << 11;
    
    assert(st.b1 < (1ULL << 5));
    val |= st.b1 << 16;
    
    assert(st.g1 < (1ULL << 6));
    val |= st.g1 << 21;
    
    assert(st.r1 < (1ULL << 5));
    val |= st.r1 << 27;
    *val_out = val;
}

#define V_NV902D_COLOR_PATTERN_R5G6B5(val, args...) { \
    struct nv_nv902d_COLOR_PATTERN_R5G6B5 __data = args; \
    __NV902D_COLOR_PATTERN_R5G6B5(&val, __data); \
}

#define VA_NV902D_COLOR_PATTERN_R5G6B5(i) V_NV902D_COLOR_PATTERN_R5G6B5

#define P_NV902D_COLOR_PATTERN_R5G6B5(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_COLOR_PATTERN_R5G6B5(nvk_p_ret, args); \
    nv_push_val(push, NV902D_COLOR_PATTERN_R5G6B5(idx), nvk_p_ret); \
} while(0)

struct nv_nv902d_COLOR_PATTERN_X1R5G5B5 {
    uint32_t b0;
    uint32_t g0;
    uint32_t r0;
    uint32_t ignore0;
    uint32_t b1;
    uint32_t g1;
    uint32_t r1;
    uint32_t ignore1;
};

static inline void
__NV902D_COLOR_PATTERN_X1R5G5B5(uint32_t *val_out, struct nv_nv902d_COLOR_PATTERN_X1R5G5B5 st)
{
    uint32_t val = 0;
    
    assert(st.b0 < (1ULL << 5));
    val |= st.b0 << 0;
    
    assert(st.g0 < (1ULL << 5));
    val |= st.g0 << 5;
    
    assert(st.r0 < (1ULL << 5));
    val |= st.r0 << 10;
    
    assert(st.ignore0 < (1ULL << 1));
    val |= st.ignore0 << 15;
    
    assert(st.b1 < (1ULL << 5));
    val |= st.b1 << 16;
    
    assert(st.g1 < (1ULL << 5));
    val |= st.g1 << 21;
    
    assert(st.r1 < (1ULL << 5));
    val |= st.r1 << 26;
    
    assert(st.ignore1 < (1ULL << 1));
    val |= st.ignore1 << 31;
    *val_out = val;
}

#define V_NV902D_COLOR_PATTERN_X1R5G5B5(val, args...) { \
    struct nv_nv902d_COLOR_PATTERN_X1R5G5B5 __data = args; \
    __NV902D_COLOR_PATTERN_X1R5G5B5(&val, __data); \
}

#define VA_NV902D_COLOR_PATTERN_X1R5G5B5(i) V_NV902D_COLOR_PATTERN_X1R5G5B5

#define P_NV902D_COLOR_PATTERN_X1R5G5B5(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_COLOR_PATTERN_X1R5G5B5(nvk_p_ret, args); \
    nv_push_val(push, NV902D_COLOR_PATTERN_X1R5G5B5(idx), nvk_p_ret); \
} while(0)

struct nv_nv902d_COLOR_PATTERN_Y8 {
    uint32_t y0;
    uint32_t y1;
    uint32_t y2;
    uint32_t y3;
};

static inline void
__NV902D_COLOR_PATTERN_Y8(uint32_t *val_out, struct nv_nv902d_COLOR_PATTERN_Y8 st)
{
    uint32_t val = 0;
    
    assert(st.y0 < (1ULL << 8));
    val |= st.y0 << 0;
    
    assert(st.y1 < (1ULL << 8));
    val |= st.y1 << 8;
    
    assert(st.y2 < (1ULL << 8));
    val |= st.y2 << 16;
    
    assert(st.y3 < (1ULL << 8));
    val |= st.y3 << 24;
    *val_out = val;
}

#define V_NV902D_COLOR_PATTERN_Y8(val, args...) { \
    struct nv_nv902d_COLOR_PATTERN_Y8 __data = args; \
    __NV902D_COLOR_PATTERN_Y8(&val, __data); \
}

#define VA_NV902D_COLOR_PATTERN_Y8(i) V_NV902D_COLOR_PATTERN_Y8

#define P_NV902D_COLOR_PATTERN_Y8(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_COLOR_PATTERN_Y8(nvk_p_ret, args); \
    nv_push_val(push, NV902D_COLOR_PATTERN_Y8(idx), nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR0 {
    uint32_t v;
};

static inline void
__NV902D_SET_RENDER_SOLID_PRIM_COLOR0(uint32_t *val_out, struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR0 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_SOLID_PRIM_COLOR0(val, args...) { \
    struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR0 __data = { .v = (args) }; \
    __NV902D_SET_RENDER_SOLID_PRIM_COLOR0(&val, __data); \
}

#define VA_NV902D_SET_RENDER_SOLID_PRIM_COLOR0 V_NV902D_SET_RENDER_SOLID_PRIM_COLOR0

#define P_NV902D_SET_RENDER_SOLID_PRIM_COLOR0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_SOLID_PRIM_COLOR0(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_SOLID_PRIM_COLOR0, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR1 {
    uint32_t v;
};

static inline void
__NV902D_SET_RENDER_SOLID_PRIM_COLOR1(uint32_t *val_out, struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR1 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_SOLID_PRIM_COLOR1(val, args...) { \
    struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR1 __data = { .v = (args) }; \
    __NV902D_SET_RENDER_SOLID_PRIM_COLOR1(&val, __data); \
}

#define VA_NV902D_SET_RENDER_SOLID_PRIM_COLOR1 V_NV902D_SET_RENDER_SOLID_PRIM_COLOR1

#define P_NV902D_SET_RENDER_SOLID_PRIM_COLOR1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_SOLID_PRIM_COLOR1(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_SOLID_PRIM_COLOR1, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR2 {
    uint32_t v;
};

static inline void
__NV902D_SET_RENDER_SOLID_PRIM_COLOR2(uint32_t *val_out, struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR2 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_SOLID_PRIM_COLOR2(val, args...) { \
    struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR2 __data = { .v = (args) }; \
    __NV902D_SET_RENDER_SOLID_PRIM_COLOR2(&val, __data); \
}

#define VA_NV902D_SET_RENDER_SOLID_PRIM_COLOR2 V_NV902D_SET_RENDER_SOLID_PRIM_COLOR2

#define P_NV902D_SET_RENDER_SOLID_PRIM_COLOR2(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_SOLID_PRIM_COLOR2(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_SOLID_PRIM_COLOR2, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR3 {
    uint32_t v;
};

static inline void
__NV902D_SET_RENDER_SOLID_PRIM_COLOR3(uint32_t *val_out, struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR3 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_SOLID_PRIM_COLOR3(val, args...) { \
    struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR3 __data = { .v = (args) }; \
    __NV902D_SET_RENDER_SOLID_PRIM_COLOR3(&val, __data); \
}

#define VA_NV902D_SET_RENDER_SOLID_PRIM_COLOR3 V_NV902D_SET_RENDER_SOLID_PRIM_COLOR3

#define P_NV902D_SET_RENDER_SOLID_PRIM_COLOR3(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_SOLID_PRIM_COLOR3(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_SOLID_PRIM_COLOR3, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MME_MEM_ADDRESS_A {
    uint32_t upper;
};

static inline void
__NV902D_SET_MME_MEM_ADDRESS_A(uint32_t *val_out, struct nv_nv902d_SET_MME_MEM_ADDRESS_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 25));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NV902D_SET_MME_MEM_ADDRESS_A(val, args...) { \
    struct nv_nv902d_SET_MME_MEM_ADDRESS_A __data = { .upper = (args) }; \
    __NV902D_SET_MME_MEM_ADDRESS_A(&val, __data); \
}

#define VA_NV902D_SET_MME_MEM_ADDRESS_A V_NV902D_SET_MME_MEM_ADDRESS_A

#define P_NV902D_SET_MME_MEM_ADDRESS_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MME_MEM_ADDRESS_A(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MME_MEM_ADDRESS_A, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MME_MEM_ADDRESS_B {
    uint32_t lower;
};

static inline void
__NV902D_SET_MME_MEM_ADDRESS_B(uint32_t *val_out, struct nv_nv902d_SET_MME_MEM_ADDRESS_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NV902D_SET_MME_MEM_ADDRESS_B(val, args...) { \
    struct nv_nv902d_SET_MME_MEM_ADDRESS_B __data = { .lower = (args) }; \
    __NV902D_SET_MME_MEM_ADDRESS_B(&val, __data); \
}

#define VA_NV902D_SET_MME_MEM_ADDRESS_B V_NV902D_SET_MME_MEM_ADDRESS_B

#define P_NV902D_SET_MME_MEM_ADDRESS_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MME_MEM_ADDRESS_B(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MME_MEM_ADDRESS_B, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MME_DATA_RAM_ADDRESS {
    uint32_t word;
};

static inline void
__NV902D_SET_MME_DATA_RAM_ADDRESS(uint32_t *val_out, struct nv_nv902d_SET_MME_DATA_RAM_ADDRESS st)
{
    uint32_t val = 0;
    
    val |= st.word;
    *val_out = val;
}

#define V_NV902D_SET_MME_DATA_RAM_ADDRESS(val, args...) { \
    struct nv_nv902d_SET_MME_DATA_RAM_ADDRESS __data = { .word = (args) }; \
    __NV902D_SET_MME_DATA_RAM_ADDRESS(&val, __data); \
}

#define VA_NV902D_SET_MME_DATA_RAM_ADDRESS V_NV902D_SET_MME_DATA_RAM_ADDRESS

#define P_NV902D_SET_MME_DATA_RAM_ADDRESS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MME_DATA_RAM_ADDRESS(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MME_DATA_RAM_ADDRESS, nvk_p_ret); \
} while(0)

struct nv_nv902d_MME_DMA_READ {
    uint32_t length;
};

static inline void
__NV902D_MME_DMA_READ(uint32_t *val_out, struct nv_nv902d_MME_DMA_READ st)
{
    uint32_t val = 0;
    
    val |= st.length;
    *val_out = val;
}

#define V_NV902D_MME_DMA_READ(val, args...) { \
    struct nv_nv902d_MME_DMA_READ __data = { .length = (args) }; \
    __NV902D_MME_DMA_READ(&val, __data); \
}

#define VA_NV902D_MME_DMA_READ V_NV902D_MME_DMA_READ

#define P_NV902D_MME_DMA_READ(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_MME_DMA_READ(nvk_p_ret, args); \
    nv_push_val(push, NV902D_MME_DMA_READ, nvk_p_ret); \
} while(0)

struct nv_nv902d_MME_DMA_READ_FIFOED {
    uint32_t length;
};

static inline void
__NV902D_MME_DMA_READ_FIFOED(uint32_t *val_out, struct nv_nv902d_MME_DMA_READ_FIFOED st)
{
    uint32_t val = 0;
    
    val |= st.length;
    *val_out = val;
}

#define V_NV902D_MME_DMA_READ_FIFOED(val, args...) { \
    struct nv_nv902d_MME_DMA_READ_FIFOED __data = { .length = (args) }; \
    __NV902D_MME_DMA_READ_FIFOED(&val, __data); \
}

#define VA_NV902D_MME_DMA_READ_FIFOED V_NV902D_MME_DMA_READ_FIFOED

#define P_NV902D_MME_DMA_READ_FIFOED(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_MME_DMA_READ_FIFOED(nvk_p_ret, args); \
    nv_push_val(push, NV902D_MME_DMA_READ_FIFOED, nvk_p_ret); \
} while(0)

struct nv_nv902d_MME_DMA_WRITE {
    uint32_t length;
};

static inline void
__NV902D_MME_DMA_WRITE(uint32_t *val_out, struct nv_nv902d_MME_DMA_WRITE st)
{
    uint32_t val = 0;
    
    val |= st.length;
    *val_out = val;
}

#define V_NV902D_MME_DMA_WRITE(val, args...) { \
    struct nv_nv902d_MME_DMA_WRITE __data = { .length = (args) }; \
    __NV902D_MME_DMA_WRITE(&val, __data); \
}

#define VA_NV902D_MME_DMA_WRITE V_NV902D_MME_DMA_WRITE

#define P_NV902D_MME_DMA_WRITE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_MME_DMA_WRITE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_MME_DMA_WRITE, nvk_p_ret); \
} while(0)

struct nv_nv902d_MME_DMA_REDUCTION {
    uint32_t reduction_op;
    uint32_t reduction_format;
    uint32_t reduction_size;
};

static inline void
__NV902D_MME_DMA_REDUCTION(uint32_t *val_out, struct nv_nv902d_MME_DMA_REDUCTION st)
{
    uint32_t val = 0;
    
    assert(st.reduction_op < (1ULL << 3));
    val |= st.reduction_op << 0;
    
    assert(st.reduction_format < (1ULL << 2));
    val |= st.reduction_format << 4;
    
    assert(st.reduction_size < (1ULL << 1));
    val |= st.reduction_size << 8;
    *val_out = val;
}

#define V_NV902D_MME_DMA_REDUCTION(val, args...) { \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED = NV902D_MME_DMA_REDUCTION_REDUCTION_FORMAT_UNSIGNED; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED = NV902D_MME_DMA_REDUCTION_REDUCTION_FORMAT_SIGNED; \
    UNUSED uint32_t REDUCTION_SIZE_FOUR_BYTES = NV902D_MME_DMA_REDUCTION_REDUCTION_SIZE_FOUR_BYTES; \
    UNUSED uint32_t REDUCTION_SIZE_EIGHT_BYTES = NV902D_MME_DMA_REDUCTION_REDUCTION_SIZE_EIGHT_BYTES; \
    struct nv_nv902d_MME_DMA_REDUCTION __data = args; \
    __NV902D_MME_DMA_REDUCTION(&val, __data); \
}

#define VA_NV902D_MME_DMA_REDUCTION V_NV902D_MME_DMA_REDUCTION

#define P_NV902D_MME_DMA_REDUCTION(push, args...) do { \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NV902D_MME_DMA_REDUCTION_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED = NV902D_MME_DMA_REDUCTION_REDUCTION_FORMAT_UNSIGNED; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED = NV902D_MME_DMA_REDUCTION_REDUCTION_FORMAT_SIGNED; \
    UNUSED uint32_t REDUCTION_SIZE_FOUR_BYTES = NV902D_MME_DMA_REDUCTION_REDUCTION_SIZE_FOUR_BYTES; \
    UNUSED uint32_t REDUCTION_SIZE_EIGHT_BYTES = NV902D_MME_DMA_REDUCTION_REDUCTION_SIZE_EIGHT_BYTES; \
    uint32_t nvk_p_ret; \
    V_NV902D_MME_DMA_REDUCTION(nvk_p_ret, args); \
    nv_push_val(push, NV902D_MME_DMA_REDUCTION, nvk_p_ret); \
} while(0)

struct nv_nv902d_MME_DMA_SYSMEMBAR {
    uint32_t v;
};

static inline void
__NV902D_MME_DMA_SYSMEMBAR(uint32_t *val_out, struct nv_nv902d_MME_DMA_SYSMEMBAR st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_MME_DMA_SYSMEMBAR(val, args...) { \
    struct nv_nv902d_MME_DMA_SYSMEMBAR __data = { .v = (args) }; \
    __NV902D_MME_DMA_SYSMEMBAR(&val, __data); \
}

#define VA_NV902D_MME_DMA_SYSMEMBAR V_NV902D_MME_DMA_SYSMEMBAR

#define P_NV902D_MME_DMA_SYSMEMBAR(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_MME_DMA_SYSMEMBAR(nvk_p_ret, args); \
    nv_push_val(push, NV902D_MME_DMA_SYSMEMBAR, nvk_p_ret); \
} while(0)

struct nv_nv902d_MME_DMA_SYNC {
    uint32_t value;
};

static inline void
__NV902D_MME_DMA_SYNC(uint32_t *val_out, struct nv_nv902d_MME_DMA_SYNC st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NV902D_MME_DMA_SYNC(val, args...) { \
    struct nv_nv902d_MME_DMA_SYNC __data = { .value = (args) }; \
    __NV902D_MME_DMA_SYNC(&val, __data); \
}

#define VA_NV902D_MME_DMA_SYNC V_NV902D_MME_DMA_SYNC

#define P_NV902D_MME_DMA_SYNC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_MME_DMA_SYNC(nvk_p_ret, args); \
    nv_push_val(push, NV902D_MME_DMA_SYNC, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MME_DATA_FIFO_CONFIG {
    uint32_t fifo_size;
};

static inline void
__NV902D_SET_MME_DATA_FIFO_CONFIG(uint32_t *val_out, struct nv_nv902d_SET_MME_DATA_FIFO_CONFIG st)
{
    uint32_t val = 0;
    
    assert(st.fifo_size < (1ULL << 3));
    val |= st.fifo_size << 0;
    *val_out = val;
}

#define V_NV902D_SET_MME_DATA_FIFO_CONFIG(val, args...) { \
    UNUSED uint32_t FIFO_SIZE_SIZE_0KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_0KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_4KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_4KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_8KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_8KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_12KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_12KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_16KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_16KB; \
    struct nv_nv902d_SET_MME_DATA_FIFO_CONFIG __data = { .fifo_size = (args) }; \
    __NV902D_SET_MME_DATA_FIFO_CONFIG(&val, __data); \
}

#define VA_NV902D_SET_MME_DATA_FIFO_CONFIG V_NV902D_SET_MME_DATA_FIFO_CONFIG

#define P_NV902D_SET_MME_DATA_FIFO_CONFIG(push, args...) do { \
    UNUSED uint32_t FIFO_SIZE_SIZE_0KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_0KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_4KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_4KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_8KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_8KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_12KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_12KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_16KB = NV902D_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_16KB; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MME_DATA_FIFO_CONFIG(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MME_DATA_FIFO_CONFIG, nvk_p_ret); \
} while(0)

struct nv_nv902d_RENDER_SOLID_PRIM_MODE {
    uint32_t v;
};

static inline void
__NV902D_RENDER_SOLID_PRIM_MODE(uint32_t *val_out, struct nv_nv902d_RENDER_SOLID_PRIM_MODE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 3));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_RENDER_SOLID_PRIM_MODE(val, args...) { \
    UNUSED uint32_t V_POINTS = NV902D_RENDER_SOLID_PRIM_MODE_V_POINTS; \
    UNUSED uint32_t V_LINES = NV902D_RENDER_SOLID_PRIM_MODE_V_LINES; \
    UNUSED uint32_t V_POLYLINE = NV902D_RENDER_SOLID_PRIM_MODE_V_POLYLINE; \
    UNUSED uint32_t V_TRIANGLES = NV902D_RENDER_SOLID_PRIM_MODE_V_TRIANGLES; \
    UNUSED uint32_t V_RECTS = NV902D_RENDER_SOLID_PRIM_MODE_V_RECTS; \
    struct nv_nv902d_RENDER_SOLID_PRIM_MODE __data = { .v = (args) }; \
    __NV902D_RENDER_SOLID_PRIM_MODE(&val, __data); \
}

#define VA_NV902D_RENDER_SOLID_PRIM_MODE V_NV902D_RENDER_SOLID_PRIM_MODE

#define P_NV902D_RENDER_SOLID_PRIM_MODE(push, args...) do { \
    UNUSED uint32_t V_POINTS = NV902D_RENDER_SOLID_PRIM_MODE_V_POINTS; \
    UNUSED uint32_t V_LINES = NV902D_RENDER_SOLID_PRIM_MODE_V_LINES; \
    UNUSED uint32_t V_POLYLINE = NV902D_RENDER_SOLID_PRIM_MODE_V_POLYLINE; \
    UNUSED uint32_t V_TRIANGLES = NV902D_RENDER_SOLID_PRIM_MODE_V_TRIANGLES; \
    UNUSED uint32_t V_RECTS = NV902D_RENDER_SOLID_PRIM_MODE_V_RECTS; \
    uint32_t nvk_p_ret; \
    V_NV902D_RENDER_SOLID_PRIM_MODE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_RENDER_SOLID_PRIM_MODE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR_FORMAT {
    uint32_t v;
};

static inline void
__NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT(uint32_t *val_out, struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT(val, args...) { \
    UNUSED uint32_t V_RF32_GF32_BF32_AF32 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t V_RF16_GF16_BF16_AF16 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t V_RF32_GF32 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_RF32_GF32; \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_A8B8G8R8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A2B10G10R10 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_X8R8G8B8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8B8G8R8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_R5G6B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_X1R5G5B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_Y8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Y8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Y32; \
    UNUSED uint32_t V_Z1R5G5B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_O8R8G8B8; \
    struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR_FORMAT __data = { .v = (args) }; \
    __NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT(&val, __data); \
}

#define VA_NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT V_NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT

#define P_NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT(push, args...) do { \
    UNUSED uint32_t V_RF32_GF32_BF32_AF32 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t V_RF16_GF16_BF16_AF16 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t V_RF32_GF32 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_RF32_GF32; \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_A8B8G8R8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A2B10G10R10 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_X8R8G8B8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8B8G8R8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_R5G6B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_X1R5G5B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_Y8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Y8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Y32; \
    UNUSED uint32_t V_Z1R5G5B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_O8R8G8B8; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_SOLID_PRIM_COLOR_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR {
    uint32_t v;
};

static inline void
__NV902D_SET_RENDER_SOLID_PRIM_COLOR(uint32_t *val_out, struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_SOLID_PRIM_COLOR(val, args...) { \
    struct nv_nv902d_SET_RENDER_SOLID_PRIM_COLOR __data = { .v = (args) }; \
    __NV902D_SET_RENDER_SOLID_PRIM_COLOR(&val, __data); \
}

#define VA_NV902D_SET_RENDER_SOLID_PRIM_COLOR V_NV902D_SET_RENDER_SOLID_PRIM_COLOR

#define P_NV902D_SET_RENDER_SOLID_PRIM_COLOR(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_SOLID_PRIM_COLOR(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_SOLID_PRIM_COLOR, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS {
    uint32_t xmaj__xinc__yinc;
    uint32_t xmaj__xdec__yinc;
    uint32_t ymaj__xinc__yinc;
    uint32_t ymaj__xdec__yinc;
};

static inline void
__NV902D_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS(uint32_t *val_out, struct nv_nv902d_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS st)
{
    uint32_t val = 0;
    
    assert(st.xmaj__xinc__yinc < (1ULL << 1));
    val |= st.xmaj__xinc__yinc << 0;
    
    assert(st.xmaj__xdec__yinc < (1ULL << 1));
    val |= st.xmaj__xdec__yinc << 4;
    
    assert(st.ymaj__xinc__yinc < (1ULL << 1));
    val |= st.ymaj__xinc__yinc << 8;
    
    assert(st.ymaj__xdec__yinc < (1ULL << 1));
    val |= st.ymaj__xdec__yinc << 12;
    *val_out = val;
}

#define V_NV902D_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS(val, args...) { \
    struct nv_nv902d_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS __data = args; \
    __NV902D_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS(&val, __data); \
}

#define VA_NV902D_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS V_NV902D_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS

#define P_NV902D_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_RENDER_SOLID_LINE_TIE_BREAK_BITS, nvk_p_ret); \
} while(0)

struct nv_nv902d_RENDER_SOLID_PRIM_POINT_X_Y {
    uint32_t x;
    uint32_t y;
};

static inline void
__NV902D_RENDER_SOLID_PRIM_POINT_X_Y(uint32_t *val_out, struct nv_nv902d_RENDER_SOLID_PRIM_POINT_X_Y st)
{
    uint32_t val = 0;
    
    assert(st.x < (1ULL << 16));
    val |= st.x << 0;
    
    assert(st.y < (1ULL << 16));
    val |= st.y << 16;
    *val_out = val;
}

#define V_NV902D_RENDER_SOLID_PRIM_POINT_X_Y(val, args...) { \
    struct nv_nv902d_RENDER_SOLID_PRIM_POINT_X_Y __data = args; \
    __NV902D_RENDER_SOLID_PRIM_POINT_X_Y(&val, __data); \
}

#define VA_NV902D_RENDER_SOLID_PRIM_POINT_X_Y V_NV902D_RENDER_SOLID_PRIM_POINT_X_Y

#define P_NV902D_RENDER_SOLID_PRIM_POINT_X_Y(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_RENDER_SOLID_PRIM_POINT_X_Y(nvk_p_ret, args); \
    nv_push_val(push, NV902D_RENDER_SOLID_PRIM_POINT_X_Y, nvk_p_ret); \
} while(0)

struct nv_nv902d_RENDER_SOLID_PRIM_POINT_SET_X {
    uint32_t v;
};

static inline void
__NV902D_RENDER_SOLID_PRIM_POINT_SET_X(uint32_t *val_out, struct nv_nv902d_RENDER_SOLID_PRIM_POINT_SET_X st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_RENDER_SOLID_PRIM_POINT_SET_X(val, args...) { \
    struct nv_nv902d_RENDER_SOLID_PRIM_POINT_SET_X __data = { .v = (args) }; \
    __NV902D_RENDER_SOLID_PRIM_POINT_SET_X(&val, __data); \
}

#define VA_NV902D_RENDER_SOLID_PRIM_POINT_SET_X(i) V_NV902D_RENDER_SOLID_PRIM_POINT_SET_X

#define P_NV902D_RENDER_SOLID_PRIM_POINT_SET_X(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_RENDER_SOLID_PRIM_POINT_SET_X(nvk_p_ret, args); \
    nv_push_val(push, NV902D_RENDER_SOLID_PRIM_POINT_SET_X(idx), nvk_p_ret); \
} while(0)

struct nv_nv902d_RENDER_SOLID_PRIM_POINT_Y {
    uint32_t v;
};

static inline void
__NV902D_RENDER_SOLID_PRIM_POINT_Y(uint32_t *val_out, struct nv_nv902d_RENDER_SOLID_PRIM_POINT_Y st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_RENDER_SOLID_PRIM_POINT_Y(val, args...) { \
    struct nv_nv902d_RENDER_SOLID_PRIM_POINT_Y __data = { .v = (args) }; \
    __NV902D_RENDER_SOLID_PRIM_POINT_Y(&val, __data); \
}

#define VA_NV902D_RENDER_SOLID_PRIM_POINT_Y(i) V_NV902D_RENDER_SOLID_PRIM_POINT_Y

#define P_NV902D_RENDER_SOLID_PRIM_POINT_Y(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_RENDER_SOLID_PRIM_POINT_Y(nvk_p_ret, args); \
    nv_push_val(push, NV902D_RENDER_SOLID_PRIM_POINT_Y(idx), nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_DATA_TYPE {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_DATA_TYPE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE(val, args...) { \
    UNUSED uint32_t V_COLOR = NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE_V_COLOR; \
    UNUSED uint32_t V_INDEX = NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE_V_INDEX; \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_DATA_TYPE __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE V_NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE

#define P_NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE(push, args...) do { \
    UNUSED uint32_t V_COLOR = NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE_V_COLOR; \
    UNUSED uint32_t V_INDEX = NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE_V_INDEX; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_DATA_TYPE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_COLOR_FORMAT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_COLOR_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT(val, args...) { \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_A8B8G8R8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A2B10G10R10 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_X8R8G8B8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8B8G8R8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_R5G6B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_X1R5G5B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_Y8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Y8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Y32; \
    UNUSED uint32_t V_Z1R5G5B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_O8R8G8B8; \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_COLOR_FORMAT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT V_NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT

#define P_NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT(push, args...) do { \
    UNUSED uint32_t V_A8R8G8B8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A2R10G10B10 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_A8B8G8R8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A2B10G10R10 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_X8R8G8B8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8B8G8R8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_R5G6B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_X1R5G5B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_Y8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Y8; \
    UNUSED uint32_t V_Y16 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Y16; \
    UNUSED uint32_t V_Y32 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Y32; \
    UNUSED uint32_t V_Z1R5G5B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_O8R8G8B8; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_COLOR_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_INDEX_FORMAT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_INDEX_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 2));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT(val, args...) { \
    UNUSED uint32_t V_I1 = NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT_V_I1; \
    UNUSED uint32_t V_I4 = NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT_V_I4; \
    UNUSED uint32_t V_I8 = NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT_V_I8; \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_INDEX_FORMAT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT V_NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT

#define P_NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT(push, args...) do { \
    UNUSED uint32_t V_I1 = NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT_V_I1; \
    UNUSED uint32_t V_I4 = NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT_V_I4; \
    UNUSED uint32_t V_I8 = NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT_V_I8; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_INDEX_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_MONO_FORMAT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_MONO_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT(val, args...) { \
    UNUSED uint32_t V_CGA6_M1 = NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT_V_CGA6_M1; \
    UNUSED uint32_t V_LE_M1 = NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT_V_LE_M1; \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_MONO_FORMAT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT V_NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT

#define P_NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT(push, args...) do { \
    UNUSED uint32_t V_CGA6_M1 = NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT_V_CGA6_M1; \
    UNUSED uint32_t V_LE_M1 = NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT_V_LE_M1; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_MONO_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_WRAP {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_WRAP(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_WRAP st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 2));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_WRAP(val, args...) { \
    UNUSED uint32_t V_WRAP_PIXEL = NV902D_SET_PIXELS_FROM_CPU_WRAP_V_WRAP_PIXEL; \
    UNUSED uint32_t V_WRAP_BYTE = NV902D_SET_PIXELS_FROM_CPU_WRAP_V_WRAP_BYTE; \
    UNUSED uint32_t V_WRAP_DWORD = NV902D_SET_PIXELS_FROM_CPU_WRAP_V_WRAP_DWORD; \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_WRAP __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_WRAP(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_WRAP V_NV902D_SET_PIXELS_FROM_CPU_WRAP

#define P_NV902D_SET_PIXELS_FROM_CPU_WRAP(push, args...) do { \
    UNUSED uint32_t V_WRAP_PIXEL = NV902D_SET_PIXELS_FROM_CPU_WRAP_V_WRAP_PIXEL; \
    UNUSED uint32_t V_WRAP_BYTE = NV902D_SET_PIXELS_FROM_CPU_WRAP_V_WRAP_BYTE; \
    UNUSED uint32_t V_WRAP_DWORD = NV902D_SET_PIXELS_FROM_CPU_WRAP_V_WRAP_DWORD; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_WRAP(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_WRAP, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_COLOR0 {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_COLOR0(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_COLOR0 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_COLOR0(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_COLOR0 __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_COLOR0(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_COLOR0 V_NV902D_SET_PIXELS_FROM_CPU_COLOR0

#define P_NV902D_SET_PIXELS_FROM_CPU_COLOR0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_COLOR0(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_COLOR0, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_COLOR1 {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_COLOR1(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_COLOR1 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_COLOR1(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_COLOR1 __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_COLOR1(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_COLOR1 V_NV902D_SET_PIXELS_FROM_CPU_COLOR1

#define P_NV902D_SET_PIXELS_FROM_CPU_COLOR1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_COLOR1(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_COLOR1, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_MONO_OPACITY {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_MONO_OPACITY st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY(val, args...) { \
    UNUSED uint32_t V_TRANSPARENT = NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY_V_TRANSPARENT; \
    UNUSED uint32_t V_OPAQUE = NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY_V_OPAQUE; \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_MONO_OPACITY __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY V_NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY

#define P_NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY(push, args...) do { \
    UNUSED uint32_t V_TRANSPARENT = NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY_V_TRANSPARENT; \
    UNUSED uint32_t V_OPAQUE = NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY_V_OPAQUE; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_MONO_OPACITY, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_SRC_WIDTH {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_SRC_WIDTH(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_SRC_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_SRC_WIDTH(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_SRC_WIDTH __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_SRC_WIDTH(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_SRC_WIDTH V_NV902D_SET_PIXELS_FROM_CPU_SRC_WIDTH

#define P_NV902D_SET_PIXELS_FROM_CPU_SRC_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_SRC_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_SRC_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_SRC_HEIGHT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_SRC_HEIGHT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_SRC_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_SRC_HEIGHT(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_SRC_HEIGHT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_SRC_HEIGHT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_SRC_HEIGHT V_NV902D_SET_PIXELS_FROM_CPU_SRC_HEIGHT

#define P_NV902D_SET_PIXELS_FROM_CPU_SRC_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_SRC_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_SRC_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_DX_DU_FRAC {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_DX_DU_FRAC(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_DX_DU_FRAC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_DX_DU_FRAC(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_DX_DU_FRAC __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_DX_DU_FRAC(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_DX_DU_FRAC V_NV902D_SET_PIXELS_FROM_CPU_DX_DU_FRAC

#define P_NV902D_SET_PIXELS_FROM_CPU_DX_DU_FRAC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_DX_DU_FRAC(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_DX_DU_FRAC, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_DX_DU_INT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_DX_DU_INT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_DX_DU_INT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_DX_DU_INT(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_DX_DU_INT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_DX_DU_INT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_DX_DU_INT V_NV902D_SET_PIXELS_FROM_CPU_DX_DU_INT

#define P_NV902D_SET_PIXELS_FROM_CPU_DX_DU_INT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_DX_DU_INT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_DX_DU_INT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_DY_DV_FRAC {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_DY_DV_FRAC(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_DY_DV_FRAC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_DY_DV_FRAC(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_DY_DV_FRAC __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_DY_DV_FRAC(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_DY_DV_FRAC V_NV902D_SET_PIXELS_FROM_CPU_DY_DV_FRAC

#define P_NV902D_SET_PIXELS_FROM_CPU_DY_DV_FRAC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_DY_DV_FRAC(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_DY_DV_FRAC, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_DY_DV_INT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_DY_DV_INT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_DY_DV_INT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_DY_DV_INT(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_DY_DV_INT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_DY_DV_INT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_DY_DV_INT V_NV902D_SET_PIXELS_FROM_CPU_DY_DV_INT

#define P_NV902D_SET_PIXELS_FROM_CPU_DY_DV_INT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_DY_DV_INT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_DY_DV_INT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_X0_FRAC {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_DST_X0_FRAC(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_X0_FRAC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_DST_X0_FRAC(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_X0_FRAC __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_DST_X0_FRAC(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_DST_X0_FRAC V_NV902D_SET_PIXELS_FROM_CPU_DST_X0_FRAC

#define P_NV902D_SET_PIXELS_FROM_CPU_DST_X0_FRAC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_DST_X0_FRAC(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_DST_X0_FRAC, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_X0_INT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_DST_X0_INT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_X0_INT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_DST_X0_INT(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_X0_INT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_DST_X0_INT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_DST_X0_INT V_NV902D_SET_PIXELS_FROM_CPU_DST_X0_INT

#define P_NV902D_SET_PIXELS_FROM_CPU_DST_X0_INT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_DST_X0_INT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_DST_X0_INT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_Y0_FRAC {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_DST_Y0_FRAC(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_Y0_FRAC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_FRAC(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_Y0_FRAC __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_DST_Y0_FRAC(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_FRAC V_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_FRAC

#define P_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_FRAC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_FRAC(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_DST_Y0_FRAC, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_Y0_INT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_CPU_DST_Y0_INT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_Y0_INT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_INT(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_CPU_DST_Y0_INT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_CPU_DST_Y0_INT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_INT V_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_INT

#define P_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_INT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_CPU_DST_Y0_INT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_CPU_DST_Y0_INT, nvk_p_ret); \
} while(0)

struct nv_nv902d_PIXELS_FROM_CPU_DATA {
    uint32_t v;
};

static inline void
__NV902D_PIXELS_FROM_CPU_DATA(uint32_t *val_out, struct nv_nv902d_PIXELS_FROM_CPU_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_PIXELS_FROM_CPU_DATA(val, args...) { \
    struct nv_nv902d_PIXELS_FROM_CPU_DATA __data = { .v = (args) }; \
    __NV902D_PIXELS_FROM_CPU_DATA(&val, __data); \
}

#define VA_NV902D_PIXELS_FROM_CPU_DATA V_NV902D_PIXELS_FROM_CPU_DATA

#define P_NV902D_PIXELS_FROM_CPU_DATA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_PIXELS_FROM_CPU_DATA(nvk_p_ret, args); \
    nv_push_val(push, NV902D_PIXELS_FROM_CPU_DATA, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_BIG_ENDIAN_CONTROL {
    uint32_t x32_swap_1;
    uint32_t x32_swap_4;
    uint32_t x32_swap_8;
    uint32_t x32_swap_16;
    uint32_t x16_swap_1;
    uint32_t x16_swap_4;
    uint32_t x16_swap_8;
    uint32_t x16_swap_16;
    uint32_t x8_swap_1;
    uint32_t x8_swap_4;
    uint32_t x8_swap_8;
    uint32_t x8_swap_16;
    uint32_t i1_x8_cga6_swap_1;
    uint32_t i1_x8_cga6_swap_4;
    uint32_t i1_x8_cga6_swap_8;
    uint32_t i1_x8_cga6_swap_16;
    uint32_t i1_x8_le_swap_1;
    uint32_t i1_x8_le_swap_4;
    uint32_t i1_x8_le_swap_8;
    uint32_t i1_x8_le_swap_16;
    uint32_t i4_swap_1;
    uint32_t i4_swap_4;
    uint32_t i4_swap_8;
    uint32_t i4_swap_16;
    uint32_t i8_swap_1;
    uint32_t i8_swap_4;
    uint32_t i8_swap_8;
    uint32_t i8_swap_16;
    uint32_t override;
};

static inline void
__NV902D_SET_BIG_ENDIAN_CONTROL(uint32_t *val_out, struct nv_nv902d_SET_BIG_ENDIAN_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.x32_swap_1 < (1ULL << 1));
    val |= st.x32_swap_1 << 0;
    
    assert(st.x32_swap_4 < (1ULL << 1));
    val |= st.x32_swap_4 << 1;
    
    assert(st.x32_swap_8 < (1ULL << 1));
    val |= st.x32_swap_8 << 2;
    
    assert(st.x32_swap_16 < (1ULL << 1));
    val |= st.x32_swap_16 << 3;
    
    assert(st.x16_swap_1 < (1ULL << 1));
    val |= st.x16_swap_1 << 4;
    
    assert(st.x16_swap_4 < (1ULL << 1));
    val |= st.x16_swap_4 << 5;
    
    assert(st.x16_swap_8 < (1ULL << 1));
    val |= st.x16_swap_8 << 6;
    
    assert(st.x16_swap_16 < (1ULL << 1));
    val |= st.x16_swap_16 << 7;
    
    assert(st.x8_swap_1 < (1ULL << 1));
    val |= st.x8_swap_1 << 8;
    
    assert(st.x8_swap_4 < (1ULL << 1));
    val |= st.x8_swap_4 << 9;
    
    assert(st.x8_swap_8 < (1ULL << 1));
    val |= st.x8_swap_8 << 10;
    
    assert(st.x8_swap_16 < (1ULL << 1));
    val |= st.x8_swap_16 << 11;
    
    assert(st.i1_x8_cga6_swap_1 < (1ULL << 1));
    val |= st.i1_x8_cga6_swap_1 << 12;
    
    assert(st.i1_x8_cga6_swap_4 < (1ULL << 1));
    val |= st.i1_x8_cga6_swap_4 << 13;
    
    assert(st.i1_x8_cga6_swap_8 < (1ULL << 1));
    val |= st.i1_x8_cga6_swap_8 << 14;
    
    assert(st.i1_x8_cga6_swap_16 < (1ULL << 1));
    val |= st.i1_x8_cga6_swap_16 << 15;
    
    assert(st.i1_x8_le_swap_1 < (1ULL << 1));
    val |= st.i1_x8_le_swap_1 << 16;
    
    assert(st.i1_x8_le_swap_4 < (1ULL << 1));
    val |= st.i1_x8_le_swap_4 << 17;
    
    assert(st.i1_x8_le_swap_8 < (1ULL << 1));
    val |= st.i1_x8_le_swap_8 << 18;
    
    assert(st.i1_x8_le_swap_16 < (1ULL << 1));
    val |= st.i1_x8_le_swap_16 << 19;
    
    assert(st.i4_swap_1 < (1ULL << 1));
    val |= st.i4_swap_1 << 20;
    
    assert(st.i4_swap_4 < (1ULL << 1));
    val |= st.i4_swap_4 << 21;
    
    assert(st.i4_swap_8 < (1ULL << 1));
    val |= st.i4_swap_8 << 22;
    
    assert(st.i4_swap_16 < (1ULL << 1));
    val |= st.i4_swap_16 << 23;
    
    assert(st.i8_swap_1 < (1ULL << 1));
    val |= st.i8_swap_1 << 24;
    
    assert(st.i8_swap_4 < (1ULL << 1));
    val |= st.i8_swap_4 << 25;
    
    assert(st.i8_swap_8 < (1ULL << 1));
    val |= st.i8_swap_8 << 26;
    
    assert(st.i8_swap_16 < (1ULL << 1));
    val |= st.i8_swap_16 << 27;
    
    assert(st.override < (1ULL << 1));
    val |= st.override << 28;
    *val_out = val;
}

#define V_NV902D_SET_BIG_ENDIAN_CONTROL(val, args...) { \
    struct nv_nv902d_SET_BIG_ENDIAN_CONTROL __data = args; \
    __NV902D_SET_BIG_ENDIAN_CONTROL(&val, __data); \
}

#define VA_NV902D_SET_BIG_ENDIAN_CONTROL V_NV902D_SET_BIG_ENDIAN_CONTROL

#define P_NV902D_SET_BIG_ENDIAN_CONTROL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_BIG_ENDIAN_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_BIG_ENDIAN_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 3));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE(val, args...) { \
    UNUSED uint32_t V_AUTO = NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V_AUTO; \
    UNUSED uint32_t V_SHAPE_8X8 = NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V_SHAPE_8X8; \
    UNUSED uint32_t V_SHAPE_16X4 = NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V_SHAPE_16X4; \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE V_NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE

#define P_NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE(push, args...) do { \
    UNUSED uint32_t V_AUTO = NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V_AUTO; \
    UNUSED uint32_t V_SHAPE_8X8 = NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V_SHAPE_8X8; \
    UNUSED uint32_t V_SHAPE_16X4 = NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V_SHAPE_16X4; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 10));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE V_NV902D_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE

#define P_NV902D_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_CORRAL_SIZE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP(val, args...) { \
    UNUSED uint32_t V_FALSE = NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP_V_FALSE; \
    UNUSED uint32_t V_TRUE = NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP_V_TRUE; \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP V_NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP

#define P_NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP(push, args...) do { \
    UNUSED uint32_t V_FALSE = NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP_V_FALSE; \
    UNUSED uint32_t V_TRUE = NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE {
    uint32_t origin;
    uint32_t filter;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE st)
{
    uint32_t val = 0;
    
    assert(st.origin < (1ULL << 1));
    val |= st.origin << 0;
    
    assert(st.filter < (1ULL << 1));
    val |= st.filter << 4;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE(val, args...) { \
    UNUSED uint32_t ORIGIN_CENTER = NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_ORIGIN_CENTER; \
    UNUSED uint32_t ORIGIN_CORNER = NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_ORIGIN_CORNER; \
    UNUSED uint32_t FILTER_POINT = NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_FILTER_POINT; \
    UNUSED uint32_t FILTER_BILINEAR = NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_FILTER_BILINEAR; \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE __data = args; \
    __NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE V_NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE

#define P_NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE(push, args...) do { \
    UNUSED uint32_t ORIGIN_CENTER = NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_ORIGIN_CENTER; \
    UNUSED uint32_t ORIGIN_CORNER = NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_ORIGIN_CORNER; \
    UNUSED uint32_t FILTER_POINT = NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_FILTER_POINT; \
    UNUSED uint32_t FILTER_BILINEAR = NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_FILTER_BILINEAR; \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_SAMPLE_MODE, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_X0 {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_DST_X0(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_X0 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_DST_X0(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_X0 __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_DST_X0(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_DST_X0 V_NV902D_SET_PIXELS_FROM_MEMORY_DST_X0

#define P_NV902D_SET_PIXELS_FROM_MEMORY_DST_X0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_DST_X0(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_DST_X0, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_Y0 {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_DST_Y0(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_Y0 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_DST_Y0(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_Y0 __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_DST_Y0(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_DST_Y0 V_NV902D_SET_PIXELS_FROM_MEMORY_DST_Y0

#define P_NV902D_SET_PIXELS_FROM_MEMORY_DST_Y0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_DST_Y0(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_DST_Y0, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_WIDTH {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_DST_WIDTH(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_DST_WIDTH(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_WIDTH __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_DST_WIDTH(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_DST_WIDTH V_NV902D_SET_PIXELS_FROM_MEMORY_DST_WIDTH

#define P_NV902D_SET_PIXELS_FROM_MEMORY_DST_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_DST_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_DST_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_HEIGHT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_DST_HEIGHT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_DST_HEIGHT(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DST_HEIGHT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_DST_HEIGHT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_DST_HEIGHT V_NV902D_SET_PIXELS_FROM_MEMORY_DST_HEIGHT

#define P_NV902D_SET_PIXELS_FROM_MEMORY_DST_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_DST_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_DST_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC V_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC

#define P_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_FRAC, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DU_DX_INT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_INT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DU_DX_INT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_INT(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DU_DX_INT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_INT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_INT V_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_INT

#define P_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_INT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_INT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_DU_DX_INT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC V_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC

#define P_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_FRAC, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DV_DY_INT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_INT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DV_DY_INT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_INT(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_DV_DY_INT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_INT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_INT V_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_INT

#define P_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_INT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_INT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_DV_DY_INT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC V_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC

#define P_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SRC_X0_INT {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_INT(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SRC_X0_INT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_INT(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SRC_X0_INT __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_INT(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_INT V_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_INT

#define P_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_INT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_INT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_SRC_X0_INT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC {
    uint32_t v;
};

static inline void
__NV902D_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC(uint32_t *val_out, struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC(val, args...) { \
    struct nv_nv902d_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC __data = { .v = (args) }; \
    __NV902D_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC(&val, __data); \
}

#define VA_NV902D_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC V_NV902D_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC

#define P_NV902D_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC, nvk_p_ret); \
} while(0)

struct nv_nv902d_PIXELS_FROM_MEMORY_SRC_Y0_INT {
    uint32_t v;
};

static inline void
__NV902D_PIXELS_FROM_MEMORY_SRC_Y0_INT(uint32_t *val_out, struct nv_nv902d_PIXELS_FROM_MEMORY_SRC_Y0_INT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_PIXELS_FROM_MEMORY_SRC_Y0_INT(val, args...) { \
    struct nv_nv902d_PIXELS_FROM_MEMORY_SRC_Y0_INT __data = { .v = (args) }; \
    __NV902D_PIXELS_FROM_MEMORY_SRC_Y0_INT(&val, __data); \
}

#define VA_NV902D_PIXELS_FROM_MEMORY_SRC_Y0_INT V_NV902D_PIXELS_FROM_MEMORY_SRC_Y0_INT

#define P_NV902D_PIXELS_FROM_MEMORY_SRC_Y0_INT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_PIXELS_FROM_MEMORY_SRC_Y0_INT(nvk_p_ret, args); \
    nv_push_val(push, NV902D_PIXELS_FROM_MEMORY_SRC_Y0_INT, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON00 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON00(uint32_t *val_out, struct nv_nv902d_SET_FALCON00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON00(val, args...) { \
    struct nv_nv902d_SET_FALCON00 __data = { .v = (args) }; \
    __NV902D_SET_FALCON00(&val, __data); \
}

#define VA_NV902D_SET_FALCON00 V_NV902D_SET_FALCON00

#define P_NV902D_SET_FALCON00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON00(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON00, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON01 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON01(uint32_t *val_out, struct nv_nv902d_SET_FALCON01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON01(val, args...) { \
    struct nv_nv902d_SET_FALCON01 __data = { .v = (args) }; \
    __NV902D_SET_FALCON01(&val, __data); \
}

#define VA_NV902D_SET_FALCON01 V_NV902D_SET_FALCON01

#define P_NV902D_SET_FALCON01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON01(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON01, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON02 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON02(uint32_t *val_out, struct nv_nv902d_SET_FALCON02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON02(val, args...) { \
    struct nv_nv902d_SET_FALCON02 __data = { .v = (args) }; \
    __NV902D_SET_FALCON02(&val, __data); \
}

#define VA_NV902D_SET_FALCON02 V_NV902D_SET_FALCON02

#define P_NV902D_SET_FALCON02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON02(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON02, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON03 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON03(uint32_t *val_out, struct nv_nv902d_SET_FALCON03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON03(val, args...) { \
    struct nv_nv902d_SET_FALCON03 __data = { .v = (args) }; \
    __NV902D_SET_FALCON03(&val, __data); \
}

#define VA_NV902D_SET_FALCON03 V_NV902D_SET_FALCON03

#define P_NV902D_SET_FALCON03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON03(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON03, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON04 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON04(uint32_t *val_out, struct nv_nv902d_SET_FALCON04 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON04(val, args...) { \
    struct nv_nv902d_SET_FALCON04 __data = { .v = (args) }; \
    __NV902D_SET_FALCON04(&val, __data); \
}

#define VA_NV902D_SET_FALCON04 V_NV902D_SET_FALCON04

#define P_NV902D_SET_FALCON04(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON04(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON04, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON05 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON05(uint32_t *val_out, struct nv_nv902d_SET_FALCON05 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON05(val, args...) { \
    struct nv_nv902d_SET_FALCON05 __data = { .v = (args) }; \
    __NV902D_SET_FALCON05(&val, __data); \
}

#define VA_NV902D_SET_FALCON05 V_NV902D_SET_FALCON05

#define P_NV902D_SET_FALCON05(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON05(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON05, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON06 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON06(uint32_t *val_out, struct nv_nv902d_SET_FALCON06 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON06(val, args...) { \
    struct nv_nv902d_SET_FALCON06 __data = { .v = (args) }; \
    __NV902D_SET_FALCON06(&val, __data); \
}

#define VA_NV902D_SET_FALCON06 V_NV902D_SET_FALCON06

#define P_NV902D_SET_FALCON06(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON06(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON06, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON07 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON07(uint32_t *val_out, struct nv_nv902d_SET_FALCON07 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON07(val, args...) { \
    struct nv_nv902d_SET_FALCON07 __data = { .v = (args) }; \
    __NV902D_SET_FALCON07(&val, __data); \
}

#define VA_NV902D_SET_FALCON07 V_NV902D_SET_FALCON07

#define P_NV902D_SET_FALCON07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON07(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON07, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON08 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON08(uint32_t *val_out, struct nv_nv902d_SET_FALCON08 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON08(val, args...) { \
    struct nv_nv902d_SET_FALCON08 __data = { .v = (args) }; \
    __NV902D_SET_FALCON08(&val, __data); \
}

#define VA_NV902D_SET_FALCON08 V_NV902D_SET_FALCON08

#define P_NV902D_SET_FALCON08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON08(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON08, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON09 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON09(uint32_t *val_out, struct nv_nv902d_SET_FALCON09 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON09(val, args...) { \
    struct nv_nv902d_SET_FALCON09 __data = { .v = (args) }; \
    __NV902D_SET_FALCON09(&val, __data); \
}

#define VA_NV902D_SET_FALCON09 V_NV902D_SET_FALCON09

#define P_NV902D_SET_FALCON09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON09(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON09, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON10 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON10(uint32_t *val_out, struct nv_nv902d_SET_FALCON10 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON10(val, args...) { \
    struct nv_nv902d_SET_FALCON10 __data = { .v = (args) }; \
    __NV902D_SET_FALCON10(&val, __data); \
}

#define VA_NV902D_SET_FALCON10 V_NV902D_SET_FALCON10

#define P_NV902D_SET_FALCON10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON10(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON10, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON11 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON11(uint32_t *val_out, struct nv_nv902d_SET_FALCON11 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON11(val, args...) { \
    struct nv_nv902d_SET_FALCON11 __data = { .v = (args) }; \
    __NV902D_SET_FALCON11(&val, __data); \
}

#define VA_NV902D_SET_FALCON11 V_NV902D_SET_FALCON11

#define P_NV902D_SET_FALCON11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON11(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON11, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON12 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON12(uint32_t *val_out, struct nv_nv902d_SET_FALCON12 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON12(val, args...) { \
    struct nv_nv902d_SET_FALCON12 __data = { .v = (args) }; \
    __NV902D_SET_FALCON12(&val, __data); \
}

#define VA_NV902D_SET_FALCON12 V_NV902D_SET_FALCON12

#define P_NV902D_SET_FALCON12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON12(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON12, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON13 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON13(uint32_t *val_out, struct nv_nv902d_SET_FALCON13 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON13(val, args...) { \
    struct nv_nv902d_SET_FALCON13 __data = { .v = (args) }; \
    __NV902D_SET_FALCON13(&val, __data); \
}

#define VA_NV902D_SET_FALCON13 V_NV902D_SET_FALCON13

#define P_NV902D_SET_FALCON13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON13(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON13, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON14 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON14(uint32_t *val_out, struct nv_nv902d_SET_FALCON14 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON14(val, args...) { \
    struct nv_nv902d_SET_FALCON14 __data = { .v = (args) }; \
    __NV902D_SET_FALCON14(&val, __data); \
}

#define VA_NV902D_SET_FALCON14 V_NV902D_SET_FALCON14

#define P_NV902D_SET_FALCON14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON14(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON14, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON15 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON15(uint32_t *val_out, struct nv_nv902d_SET_FALCON15 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON15(val, args...) { \
    struct nv_nv902d_SET_FALCON15 __data = { .v = (args) }; \
    __NV902D_SET_FALCON15(&val, __data); \
}

#define VA_NV902D_SET_FALCON15 V_NV902D_SET_FALCON15

#define P_NV902D_SET_FALCON15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON15(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON15, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON16 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON16(uint32_t *val_out, struct nv_nv902d_SET_FALCON16 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON16(val, args...) { \
    struct nv_nv902d_SET_FALCON16 __data = { .v = (args) }; \
    __NV902D_SET_FALCON16(&val, __data); \
}

#define VA_NV902D_SET_FALCON16 V_NV902D_SET_FALCON16

#define P_NV902D_SET_FALCON16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON16(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON16, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON17 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON17(uint32_t *val_out, struct nv_nv902d_SET_FALCON17 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON17(val, args...) { \
    struct nv_nv902d_SET_FALCON17 __data = { .v = (args) }; \
    __NV902D_SET_FALCON17(&val, __data); \
}

#define VA_NV902D_SET_FALCON17 V_NV902D_SET_FALCON17

#define P_NV902D_SET_FALCON17(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON17(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON17, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON18 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON18(uint32_t *val_out, struct nv_nv902d_SET_FALCON18 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON18(val, args...) { \
    struct nv_nv902d_SET_FALCON18 __data = { .v = (args) }; \
    __NV902D_SET_FALCON18(&val, __data); \
}

#define VA_NV902D_SET_FALCON18 V_NV902D_SET_FALCON18

#define P_NV902D_SET_FALCON18(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON18(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON18, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON19 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON19(uint32_t *val_out, struct nv_nv902d_SET_FALCON19 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON19(val, args...) { \
    struct nv_nv902d_SET_FALCON19 __data = { .v = (args) }; \
    __NV902D_SET_FALCON19(&val, __data); \
}

#define VA_NV902D_SET_FALCON19 V_NV902D_SET_FALCON19

#define P_NV902D_SET_FALCON19(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON19(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON19, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON20 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON20(uint32_t *val_out, struct nv_nv902d_SET_FALCON20 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON20(val, args...) { \
    struct nv_nv902d_SET_FALCON20 __data = { .v = (args) }; \
    __NV902D_SET_FALCON20(&val, __data); \
}

#define VA_NV902D_SET_FALCON20 V_NV902D_SET_FALCON20

#define P_NV902D_SET_FALCON20(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON20(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON20, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON21 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON21(uint32_t *val_out, struct nv_nv902d_SET_FALCON21 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON21(val, args...) { \
    struct nv_nv902d_SET_FALCON21 __data = { .v = (args) }; \
    __NV902D_SET_FALCON21(&val, __data); \
}

#define VA_NV902D_SET_FALCON21 V_NV902D_SET_FALCON21

#define P_NV902D_SET_FALCON21(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON21(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON21, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON22 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON22(uint32_t *val_out, struct nv_nv902d_SET_FALCON22 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON22(val, args...) { \
    struct nv_nv902d_SET_FALCON22 __data = { .v = (args) }; \
    __NV902D_SET_FALCON22(&val, __data); \
}

#define VA_NV902D_SET_FALCON22 V_NV902D_SET_FALCON22

#define P_NV902D_SET_FALCON22(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON22(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON22, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON23 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON23(uint32_t *val_out, struct nv_nv902d_SET_FALCON23 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON23(val, args...) { \
    struct nv_nv902d_SET_FALCON23 __data = { .v = (args) }; \
    __NV902D_SET_FALCON23(&val, __data); \
}

#define VA_NV902D_SET_FALCON23 V_NV902D_SET_FALCON23

#define P_NV902D_SET_FALCON23(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON23(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON23, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON24 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON24(uint32_t *val_out, struct nv_nv902d_SET_FALCON24 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON24(val, args...) { \
    struct nv_nv902d_SET_FALCON24 __data = { .v = (args) }; \
    __NV902D_SET_FALCON24(&val, __data); \
}

#define VA_NV902D_SET_FALCON24 V_NV902D_SET_FALCON24

#define P_NV902D_SET_FALCON24(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON24(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON24, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON25 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON25(uint32_t *val_out, struct nv_nv902d_SET_FALCON25 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON25(val, args...) { \
    struct nv_nv902d_SET_FALCON25 __data = { .v = (args) }; \
    __NV902D_SET_FALCON25(&val, __data); \
}

#define VA_NV902D_SET_FALCON25 V_NV902D_SET_FALCON25

#define P_NV902D_SET_FALCON25(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON25(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON25, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON26 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON26(uint32_t *val_out, struct nv_nv902d_SET_FALCON26 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON26(val, args...) { \
    struct nv_nv902d_SET_FALCON26 __data = { .v = (args) }; \
    __NV902D_SET_FALCON26(&val, __data); \
}

#define VA_NV902D_SET_FALCON26 V_NV902D_SET_FALCON26

#define P_NV902D_SET_FALCON26(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON26(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON26, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON27 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON27(uint32_t *val_out, struct nv_nv902d_SET_FALCON27 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON27(val, args...) { \
    struct nv_nv902d_SET_FALCON27 __data = { .v = (args) }; \
    __NV902D_SET_FALCON27(&val, __data); \
}

#define VA_NV902D_SET_FALCON27 V_NV902D_SET_FALCON27

#define P_NV902D_SET_FALCON27(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON27(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON27, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON28 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON28(uint32_t *val_out, struct nv_nv902d_SET_FALCON28 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON28(val, args...) { \
    struct nv_nv902d_SET_FALCON28 __data = { .v = (args) }; \
    __NV902D_SET_FALCON28(&val, __data); \
}

#define VA_NV902D_SET_FALCON28 V_NV902D_SET_FALCON28

#define P_NV902D_SET_FALCON28(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON28(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON28, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON29 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON29(uint32_t *val_out, struct nv_nv902d_SET_FALCON29 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON29(val, args...) { \
    struct nv_nv902d_SET_FALCON29 __data = { .v = (args) }; \
    __NV902D_SET_FALCON29(&val, __data); \
}

#define VA_NV902D_SET_FALCON29 V_NV902D_SET_FALCON29

#define P_NV902D_SET_FALCON29(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON29(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON29, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON30 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON30(uint32_t *val_out, struct nv_nv902d_SET_FALCON30 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON30(val, args...) { \
    struct nv_nv902d_SET_FALCON30 __data = { .v = (args) }; \
    __NV902D_SET_FALCON30(&val, __data); \
}

#define VA_NV902D_SET_FALCON30 V_NV902D_SET_FALCON30

#define P_NV902D_SET_FALCON30(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON30(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON30, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_FALCON31 {
    uint32_t v;
};

static inline void
__NV902D_SET_FALCON31(uint32_t *val_out, struct nv_nv902d_SET_FALCON31 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_FALCON31(val, args...) { \
    struct nv_nv902d_SET_FALCON31 __data = { .v = (args) }; \
    __NV902D_SET_FALCON31(&val, __data); \
}

#define VA_NV902D_SET_FALCON31 V_NV902D_SET_FALCON31

#define P_NV902D_SET_FALCON31(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_FALCON31(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_FALCON31, nvk_p_ret); \
} while(0)

struct nv_nv902d_MME_DMA_WRITE_METHOD_BARRIER {
    uint32_t v;
};

static inline void
__NV902D_MME_DMA_WRITE_METHOD_BARRIER(uint32_t *val_out, struct nv_nv902d_MME_DMA_WRITE_METHOD_BARRIER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NV902D_MME_DMA_WRITE_METHOD_BARRIER(val, args...) { \
    struct nv_nv902d_MME_DMA_WRITE_METHOD_BARRIER __data = { .v = (args) }; \
    __NV902D_MME_DMA_WRITE_METHOD_BARRIER(&val, __data); \
}

#define VA_NV902D_MME_DMA_WRITE_METHOD_BARRIER V_NV902D_MME_DMA_WRITE_METHOD_BARRIER

#define P_NV902D_MME_DMA_WRITE_METHOD_BARRIER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_MME_DMA_WRITE_METHOD_BARRIER(nvk_p_ret, args); \
    nv_push_val(push, NV902D_MME_DMA_WRITE_METHOD_BARRIER, nvk_p_ret); \
} while(0)

struct nv_nv902d_SET_MME_SHADOW_SCRATCH {
    uint32_t v;
};

static inline void
__NV902D_SET_MME_SHADOW_SCRATCH(uint32_t *val_out, struct nv_nv902d_SET_MME_SHADOW_SCRATCH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_SET_MME_SHADOW_SCRATCH(val, args...) { \
    struct nv_nv902d_SET_MME_SHADOW_SCRATCH __data = { .v = (args) }; \
    __NV902D_SET_MME_SHADOW_SCRATCH(&val, __data); \
}

#define VA_NV902D_SET_MME_SHADOW_SCRATCH(i) V_NV902D_SET_MME_SHADOW_SCRATCH

#define P_NV902D_SET_MME_SHADOW_SCRATCH(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_SET_MME_SHADOW_SCRATCH(nvk_p_ret, args); \
    nv_push_val(push, NV902D_SET_MME_SHADOW_SCRATCH(idx), nvk_p_ret); \
} while(0)

struct nv_nv902d_CALL_MME_MACRO {
    uint32_t v;
};

static inline void
__NV902D_CALL_MME_MACRO(uint32_t *val_out, struct nv_nv902d_CALL_MME_MACRO st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_CALL_MME_MACRO(val, args...) { \
    struct nv_nv902d_CALL_MME_MACRO __data = { .v = (args) }; \
    __NV902D_CALL_MME_MACRO(&val, __data); \
}

#define VA_NV902D_CALL_MME_MACRO(i) V_NV902D_CALL_MME_MACRO

#define P_NV902D_CALL_MME_MACRO(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_CALL_MME_MACRO(nvk_p_ret, args); \
    nv_push_val(push, NV902D_CALL_MME_MACRO(idx), nvk_p_ret); \
} while(0)

struct nv_nv902d_CALL_MME_DATA {
    uint32_t v;
};

static inline void
__NV902D_CALL_MME_DATA(uint32_t *val_out, struct nv_nv902d_CALL_MME_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NV902D_CALL_MME_DATA(val, args...) { \
    struct nv_nv902d_CALL_MME_DATA __data = { .v = (args) }; \
    __NV902D_CALL_MME_DATA(&val, __data); \
}

#define VA_NV902D_CALL_MME_DATA(i) V_NV902D_CALL_MME_DATA

#define P_NV902D_CALL_MME_DATA(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NV902D_CALL_MME_DATA(nvk_p_ret, args); \
    nv_push_val(push, NV902D_CALL_MME_DATA(idx), nvk_p_ret); \
} while(0)


const char *P_PARSE_NV902D_MTHD(uint16_t idx);
void P_DUMP_NV902D_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix);
