/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "org.freedesktop.NetworkManager.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_flags,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_iface,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_connection,
        const gchar *arg_device,
        const gchar *arg_specific_object,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_connection,
        const gchar *arg_device,
        const gchar *arg_specific_object,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_STRING_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantStringStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_connection,
        const gchar *arg_device,
        const gchar *arg_specific_object,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantStringStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantStringStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_variant (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_sleep,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_level,
        const gchar *arg_domains,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_UINT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedUintUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_devices,
        guint arg_rollback_timeout,
        guint arg_flags,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedUintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedUintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_checkpoint,
        guint arg_add_timeout,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.NetworkManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NMDBusManager
 * @title: NMDBusManager
 * @short_description: Generated C code for the org.freedesktop.NetworkManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-NetworkManager.top_of_page">org.freedesktop.NetworkManager</link> D-Bus interface in C.
 */

enum
{
  NMDBUS__MANAGER_CHECK_PERMISSIONS,
  NMDBUS__MANAGER_STATE_CHANGED,
  NMDBUS__MANAGER_DEVICE_ADDED,
  NMDBUS__MANAGER_DEVICE_REMOVED,
};

static unsigned NMDBUS__MANAGER_SIGNALS[4] = { 0 };

/* ---- Introspection data for org.freedesktop.NetworkManager ---- */

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_reload_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_reload_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_reload_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_reload =
{
  {
    -1,
    (gchar *) "Reload",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_reload_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reload",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_get_devices_OUT_ARG_devices =
{
  {
    -1,
    (gchar *) "devices",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_get_devices_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_get_devices_OUT_ARG_devices.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_get_devices =
{
  {
    -1,
    (gchar *) "GetDevices",
    NULL,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_get_devices_OUT_ARG_pointers,
    NULL
  },
  "handle-get-devices",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_get_all_devices_OUT_ARG_devices =
{
  {
    -1,
    (gchar *) "devices",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_get_all_devices_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_get_all_devices_OUT_ARG_devices.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _nmdbus_manager_method_get_all_devices_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "impl_manager_get_all_devices",
  NULL
};

static const GDBusAnnotationInfo * const _nmdbus_manager_method_get_all_devices_annotation_info_pointers[] =
{
  &_nmdbus_manager_method_get_all_devices_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_get_all_devices =
{
  {
    -1,
    (gchar *) "GetAllDevices",
    NULL,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_get_all_devices_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_nmdbus_manager_method_get_all_devices_annotation_info_pointers
  },
  "handle-get-all-devices",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_get_device_by_ip_iface_IN_ARG_iface =
{
  {
    -1,
    (gchar *) "iface",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_get_device_by_ip_iface_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_get_device_by_ip_iface_IN_ARG_iface.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_get_device_by_ip_iface_OUT_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_get_device_by_ip_iface_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_get_device_by_ip_iface_OUT_ARG_device.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_get_device_by_ip_iface =
{
  {
    -1,
    (gchar *) "GetDeviceByIpIface",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_get_device_by_ip_iface_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_get_device_by_ip_iface_OUT_ARG_pointers,
    NULL
  },
  "handle-get-device-by-ip-iface",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_activate_connection_IN_ARG_connection =
{
  {
    -1,
    (gchar *) "connection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_activate_connection_IN_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_activate_connection_IN_ARG_specific_object =
{
  {
    -1,
    (gchar *) "specific_object",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_activate_connection_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_activate_connection_IN_ARG_connection.parent_struct,
  &_nmdbus_manager_method_info_activate_connection_IN_ARG_device.parent_struct,
  &_nmdbus_manager_method_info_activate_connection_IN_ARG_specific_object.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_activate_connection_OUT_ARG_active_connection =
{
  {
    -1,
    (gchar *) "active_connection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_activate_connection_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_activate_connection_OUT_ARG_active_connection.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_activate_connection =
{
  {
    -1,
    (gchar *) "ActivateConnection",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_activate_connection_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_activate_connection_OUT_ARG_pointers,
    NULL
  },
  "handle-activate-connection",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection_IN_ARG_connection =
{
  {
    -1,
    (gchar *) "connection",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection_IN_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection_IN_ARG_specific_object =
{
  {
    -1,
    (gchar *) "specific_object",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_add_and_activate_connection_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_add_and_activate_connection_IN_ARG_connection.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection_IN_ARG_device.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection_IN_ARG_specific_object.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection_OUT_ARG_active_connection =
{
  {
    -1,
    (gchar *) "active_connection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_add_and_activate_connection_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_add_and_activate_connection_OUT_ARG_path.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection_OUT_ARG_active_connection.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_add_and_activate_connection =
{
  {
    -1,
    (gchar *) "AddAndActivateConnection",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_add_and_activate_connection_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_add_and_activate_connection_OUT_ARG_pointers,
    NULL
  },
  "handle-add-and-activate-connection",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_connection =
{
  {
    -1,
    (gchar *) "connection",
    (gchar *) "a{sa{sv}}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_specific_object =
{
  {
    -1,
    (gchar *) "specific_object",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_connection.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_device.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_specific_object.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection2_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection2_OUT_ARG_active_connection =
{
  {
    -1,
    (gchar *) "active_connection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_add_and_activate_connection2_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_add_and_activate_connection2_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_add_and_activate_connection2_OUT_ARG_path.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection2_OUT_ARG_active_connection.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection2_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_add_and_activate_connection2 =
{
  {
    -1,
    (gchar *) "AddAndActivateConnection2",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_add_and_activate_connection2_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_add_and_activate_connection2_OUT_ARG_pointers,
    NULL
  },
  "handle-add-and-activate-connection2",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_deactivate_connection_IN_ARG_active_connection =
{
  {
    -1,
    (gchar *) "active_connection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_deactivate_connection_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_deactivate_connection_IN_ARG_active_connection.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_deactivate_connection =
{
  {
    -1,
    (gchar *) "DeactivateConnection",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_deactivate_connection_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-deactivate-connection",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_sleep_IN_ARG_sleep =
{
  {
    -1,
    (gchar *) "sleep",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_sleep_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_sleep_IN_ARG_sleep.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_sleep =
{
  {
    -1,
    (gchar *) "Sleep",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_sleep_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-sleep",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_enable_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_enable_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_enable_IN_ARG_enable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_enable =
{
  {
    -1,
    (gchar *) "Enable",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_enable_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enable",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_get_permissions_OUT_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_get_permissions_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_get_permissions_OUT_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_get_permissions =
{
  {
    -1,
    (gchar *) "GetPermissions",
    NULL,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_get_permissions_OUT_ARG_pointers,
    NULL
  },
  "handle-get-permissions",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_set_logging_IN_ARG_level =
{
  {
    -1,
    (gchar *) "level",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_set_logging_IN_ARG_domains =
{
  {
    -1,
    (gchar *) "domains",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_set_logging_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_set_logging_IN_ARG_level.parent_struct,
  &_nmdbus_manager_method_info_set_logging_IN_ARG_domains.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_set_logging =
{
  {
    -1,
    (gchar *) "SetLogging",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_set_logging_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-logging",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_get_logging_OUT_ARG_level =
{
  {
    -1,
    (gchar *) "level",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_get_logging_OUT_ARG_domains =
{
  {
    -1,
    (gchar *) "domains",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_get_logging_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_get_logging_OUT_ARG_level.parent_struct,
  &_nmdbus_manager_method_info_get_logging_OUT_ARG_domains.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_get_logging =
{
  {
    -1,
    (gchar *) "GetLogging",
    NULL,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_get_logging_OUT_ARG_pointers,
    NULL
  },
  "handle-get-logging",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_check_connectivity_OUT_ARG_connectivity =
{
  {
    -1,
    (gchar *) "connectivity",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_check_connectivity_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_check_connectivity_OUT_ARG_connectivity.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_check_connectivity =
{
  {
    -1,
    (gchar *) "CheckConnectivity",
    NULL,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_check_connectivity_OUT_ARG_pointers,
    NULL
  },
  "handle-check-connectivity",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_state_OUT_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_state_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_state_OUT_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_state =
{
  {
    -1,
    (gchar *) "state",
    NULL,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_state_OUT_ARG_pointers,
    NULL
  },
  "handle-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_checkpoint_create_IN_ARG_devices =
{
  {
    -1,
    (gchar *) "devices",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_checkpoint_create_IN_ARG_rollback_timeout =
{
  {
    -1,
    (gchar *) "rollback_timeout",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_checkpoint_create_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_checkpoint_create_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_checkpoint_create_IN_ARG_devices.parent_struct,
  &_nmdbus_manager_method_info_checkpoint_create_IN_ARG_rollback_timeout.parent_struct,
  &_nmdbus_manager_method_info_checkpoint_create_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_checkpoint_create_OUT_ARG_checkpoint =
{
  {
    -1,
    (gchar *) "checkpoint",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_checkpoint_create_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_checkpoint_create_OUT_ARG_checkpoint.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_checkpoint_create =
{
  {
    -1,
    (gchar *) "CheckpointCreate",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_checkpoint_create_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_checkpoint_create_OUT_ARG_pointers,
    NULL
  },
  "handle-checkpoint-create",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_checkpoint_destroy_IN_ARG_checkpoint =
{
  {
    -1,
    (gchar *) "checkpoint",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_checkpoint_destroy_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_checkpoint_destroy_IN_ARG_checkpoint.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_checkpoint_destroy =
{
  {
    -1,
    (gchar *) "CheckpointDestroy",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_checkpoint_destroy_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-checkpoint-destroy",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_checkpoint_rollback_IN_ARG_checkpoint =
{
  {
    -1,
    (gchar *) "checkpoint",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_checkpoint_rollback_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_checkpoint_rollback_IN_ARG_checkpoint.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_checkpoint_rollback_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "a{su}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_checkpoint_rollback_OUT_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_checkpoint_rollback_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_checkpoint_rollback =
{
  {
    -1,
    (gchar *) "CheckpointRollback",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_checkpoint_rollback_IN_ARG_pointers,
    (GDBusArgInfo **) &_nmdbus_manager_method_info_checkpoint_rollback_OUT_ARG_pointers,
    NULL
  },
  "handle-checkpoint-rollback",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_checkpoint_adjust_rollback_timeout_IN_ARG_checkpoint =
{
  {
    -1,
    (gchar *) "checkpoint",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_method_info_checkpoint_adjust_rollback_timeout_IN_ARG_add_timeout =
{
  {
    -1,
    (gchar *) "add_timeout",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_method_info_checkpoint_adjust_rollback_timeout_IN_ARG_pointers[] =
{
  &_nmdbus_manager_method_info_checkpoint_adjust_rollback_timeout_IN_ARG_checkpoint.parent_struct,
  &_nmdbus_manager_method_info_checkpoint_adjust_rollback_timeout_IN_ARG_add_timeout.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_manager_method_info_checkpoint_adjust_rollback_timeout =
{
  {
    -1,
    (gchar *) "CheckpointAdjustRollbackTimeout",
    (GDBusArgInfo **) &_nmdbus_manager_method_info_checkpoint_adjust_rollback_timeout_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-checkpoint-adjust-rollback-timeout",
  FALSE
};

static const GDBusMethodInfo * const _nmdbus_manager_method_info_pointers[] =
{
  &_nmdbus_manager_method_info_reload.parent_struct,
  &_nmdbus_manager_method_info_get_devices.parent_struct,
  &_nmdbus_manager_method_info_get_all_devices.parent_struct,
  &_nmdbus_manager_method_info_get_device_by_ip_iface.parent_struct,
  &_nmdbus_manager_method_info_activate_connection.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection.parent_struct,
  &_nmdbus_manager_method_info_add_and_activate_connection2.parent_struct,
  &_nmdbus_manager_method_info_deactivate_connection.parent_struct,
  &_nmdbus_manager_method_info_sleep.parent_struct,
  &_nmdbus_manager_method_info_enable.parent_struct,
  &_nmdbus_manager_method_info_get_permissions.parent_struct,
  &_nmdbus_manager_method_info_set_logging.parent_struct,
  &_nmdbus_manager_method_info_get_logging.parent_struct,
  &_nmdbus_manager_method_info_check_connectivity.parent_struct,
  &_nmdbus_manager_method_info_state.parent_struct,
  &_nmdbus_manager_method_info_checkpoint_create.parent_struct,
  &_nmdbus_manager_method_info_checkpoint_destroy.parent_struct,
  &_nmdbus_manager_method_info_checkpoint_rollback.parent_struct,
  &_nmdbus_manager_method_info_checkpoint_adjust_rollback_timeout.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_manager_signal_info_check_permissions =
{
  {
    -1,
    (gchar *) "CheckPermissions",
    NULL,
    NULL
  },
  "check-permissions"
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_signal_info_state_changed_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_signal_info_state_changed_ARG_pointers[] =
{
  &_nmdbus_manager_signal_info_state_changed_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_manager_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_nmdbus_manager_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_signal_info_device_added_ARG_device_path =
{
  {
    -1,
    (gchar *) "device_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_signal_info_device_added_ARG_pointers[] =
{
  &_nmdbus_manager_signal_info_device_added_ARG_device_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_manager_signal_info_device_added =
{
  {
    -1,
    (gchar *) "DeviceAdded",
    (GDBusArgInfo **) &_nmdbus_manager_signal_info_device_added_ARG_pointers,
    NULL
  },
  "device-added"
};

static const _ExtendedGDBusArgInfo _nmdbus_manager_signal_info_device_removed_ARG_device_path =
{
  {
    -1,
    (gchar *) "device_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_manager_signal_info_device_removed_ARG_pointers[] =
{
  &_nmdbus_manager_signal_info_device_removed_ARG_device_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_manager_signal_info_device_removed =
{
  {
    -1,
    (gchar *) "DeviceRemoved",
    (GDBusArgInfo **) &_nmdbus_manager_signal_info_device_removed_ARG_pointers,
    NULL
  },
  "device-removed"
};

static const GDBusSignalInfo * const _nmdbus_manager_signal_info_pointers[] =
{
  &_nmdbus_manager_signal_info_check_permissions.parent_struct,
  &_nmdbus_manager_signal_info_state_changed.parent_struct,
  &_nmdbus_manager_signal_info_device_added.parent_struct,
  &_nmdbus_manager_signal_info_device_removed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_devices =
{
  {
    -1,
    (gchar *) "Devices",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "devices",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_all_devices =
{
  {
    -1,
    (gchar *) "AllDevices",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "all-devices",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_checkpoints =
{
  {
    -1,
    (gchar *) "Checkpoints",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "checkpoints",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_networking_enabled =
{
  {
    -1,
    (gchar *) "NetworkingEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "networking-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_wireless_enabled =
{
  {
    -1,
    (gchar *) "WirelessEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "wireless-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_wireless_hardware_enabled =
{
  {
    -1,
    (gchar *) "WirelessHardwareEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "wireless-hardware-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_wwan_enabled =
{
  {
    -1,
    (gchar *) "WwanEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "wwan-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_wwan_hardware_enabled =
{
  {
    -1,
    (gchar *) "WwanHardwareEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "wwan-hardware-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_wimax_enabled =
{
  {
    -1,
    (gchar *) "WimaxEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "wimax-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_wimax_hardware_enabled =
{
  {
    -1,
    (gchar *) "WimaxHardwareEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "wimax-hardware-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_radio_flags =
{
  {
    -1,
    (gchar *) "RadioFlags",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "radio-flags",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_active_connections =
{
  {
    -1,
    (gchar *) "ActiveConnections",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active-connections",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_primary_connection =
{
  {
    -1,
    (gchar *) "PrimaryConnection",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "primary-connection",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_primary_connection_type =
{
  {
    -1,
    (gchar *) "PrimaryConnectionType",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "primary-connection-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_metered =
{
  {
    -1,
    (gchar *) "Metered",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "metered",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_activating_connection =
{
  {
    -1,
    (gchar *) "ActivatingConnection",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "activating-connection",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_startup =
{
  {
    -1,
    (gchar *) "Startup",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "startup",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_version_info =
{
  {
    -1,
    (gchar *) "VersionInfo",
    (gchar *) "au",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version-info",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_capabilities =
{
  {
    -1,
    (gchar *) "Capabilities",
    (gchar *) "au",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "capabilities",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_connectivity =
{
  {
    -1,
    (gchar *) "Connectivity",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "connectivity",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_connectivity_check_available =
{
  {
    -1,
    (gchar *) "ConnectivityCheckAvailable",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "connectivity-check-available",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_connectivity_check_enabled =
{
  {
    -1,
    (gchar *) "ConnectivityCheckEnabled",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "connectivity-check-enabled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_connectivity_check_uri =
{
  {
    -1,
    (gchar *) "ConnectivityCheckUri",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "connectivity-check-uri",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_manager_property_info_global_dns_configuration =
{
  {
    -1,
    (gchar *) "GlobalDnsConfiguration",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "global-dns-configuration",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nmdbus_manager_property_info_pointers[] =
{
  &_nmdbus_manager_property_info_devices.parent_struct,
  &_nmdbus_manager_property_info_all_devices.parent_struct,
  &_nmdbus_manager_property_info_checkpoints.parent_struct,
  &_nmdbus_manager_property_info_networking_enabled.parent_struct,
  &_nmdbus_manager_property_info_wireless_enabled.parent_struct,
  &_nmdbus_manager_property_info_wireless_hardware_enabled.parent_struct,
  &_nmdbus_manager_property_info_wwan_enabled.parent_struct,
  &_nmdbus_manager_property_info_wwan_hardware_enabled.parent_struct,
  &_nmdbus_manager_property_info_wimax_enabled.parent_struct,
  &_nmdbus_manager_property_info_wimax_hardware_enabled.parent_struct,
  &_nmdbus_manager_property_info_radio_flags.parent_struct,
  &_nmdbus_manager_property_info_active_connections.parent_struct,
  &_nmdbus_manager_property_info_primary_connection.parent_struct,
  &_nmdbus_manager_property_info_primary_connection_type.parent_struct,
  &_nmdbus_manager_property_info_metered.parent_struct,
  &_nmdbus_manager_property_info_activating_connection.parent_struct,
  &_nmdbus_manager_property_info_startup.parent_struct,
  &_nmdbus_manager_property_info_version.parent_struct,
  &_nmdbus_manager_property_info_version_info.parent_struct,
  &_nmdbus_manager_property_info_capabilities.parent_struct,
  &_nmdbus_manager_property_info_state.parent_struct,
  &_nmdbus_manager_property_info_connectivity.parent_struct,
  &_nmdbus_manager_property_info_connectivity_check_available.parent_struct,
  &_nmdbus_manager_property_info_connectivity_check_enabled.parent_struct,
  &_nmdbus_manager_property_info_connectivity_check_uri.parent_struct,
  &_nmdbus_manager_property_info_global_dns_configuration.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nmdbus_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.NetworkManager",
    (GDBusMethodInfo **) &_nmdbus_manager_method_info_pointers,
    (GDBusSignalInfo **) &_nmdbus_manager_signal_info_pointers,
    (GDBusPropertyInfo **) &_nmdbus_manager_property_info_pointers,
    NULL
  },
  "manager",
};


/**
 * nmdbus_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-NetworkManager.top_of_page">org.freedesktop.NetworkManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nmdbus_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nmdbus_manager_interface_info.parent_struct;
}

/**
 * nmdbus_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NMDBusManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nmdbus_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "devices");
  g_object_class_override_property (klass, property_id_begin++, "all-devices");
  g_object_class_override_property (klass, property_id_begin++, "checkpoints");
  g_object_class_override_property (klass, property_id_begin++, "networking-enabled");
  g_object_class_override_property (klass, property_id_begin++, "wireless-enabled");
  g_object_class_override_property (klass, property_id_begin++, "wireless-hardware-enabled");
  g_object_class_override_property (klass, property_id_begin++, "wwan-enabled");
  g_object_class_override_property (klass, property_id_begin++, "wwan-hardware-enabled");
  g_object_class_override_property (klass, property_id_begin++, "wimax-enabled");
  g_object_class_override_property (klass, property_id_begin++, "wimax-hardware-enabled");
  g_object_class_override_property (klass, property_id_begin++, "radio-flags");
  g_object_class_override_property (klass, property_id_begin++, "active-connections");
  g_object_class_override_property (klass, property_id_begin++, "primary-connection");
  g_object_class_override_property (klass, property_id_begin++, "primary-connection-type");
  g_object_class_override_property (klass, property_id_begin++, "metered");
  g_object_class_override_property (klass, property_id_begin++, "activating-connection");
  g_object_class_override_property (klass, property_id_begin++, "startup");
  g_object_class_override_property (klass, property_id_begin++, "version");
  g_object_class_override_property (klass, property_id_begin++, "version-info");
  g_object_class_override_property (klass, property_id_begin++, "capabilities");
  g_object_class_override_property (klass, property_id_begin++, "state");
  g_object_class_override_property (klass, property_id_begin++, "connectivity");
  g_object_class_override_property (klass, property_id_begin++, "connectivity-check-available");
  g_object_class_override_property (klass, property_id_begin++, "connectivity-check-enabled");
  g_object_class_override_property (klass, property_id_begin++, "connectivity-check-uri");
  g_object_class_override_property (klass, property_id_begin++, "global-dns-configuration");
  return property_id_begin - 1;
}


inline static void
nmdbus_manager_signal_marshal_check_permissions (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_signal_marshal_state_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_signal_marshal_device_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_signal_marshal_device_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_reload (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_get_devices (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_get_all_devices (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_get_device_by_ip_iface (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_activate_connection (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_add_and_activate_connection (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_add_and_activate_connection2 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_STRING_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_deactivate_connection (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_sleep (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_enable (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_get_permissions (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_set_logging (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_get_logging (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_check_connectivity (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_state (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_checkpoint_create (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_checkpoint_destroy (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_checkpoint_rollback (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
nmdbus_manager_method_marshal_checkpoint_adjust_rollback_timeout (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * NMDBusManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager.top_of_page">org.freedesktop.NetworkManager</link>.
 */

/**
 * NMDBusManagerIface:
 * @parent_iface: The parent interface.
 * @handle_activate_connection: Handler for the #NMDBusManager::handle-activate-connection signal.
 * @handle_add_and_activate_connection: Handler for the #NMDBusManager::handle-add-and-activate-connection signal.
 * @handle_add_and_activate_connection2: Handler for the #NMDBusManager::handle-add-and-activate-connection2 signal.
 * @handle_check_connectivity: Handler for the #NMDBusManager::handle-check-connectivity signal.
 * @handle_checkpoint_create: Handler for the #NMDBusManager::handle-checkpoint-create signal.
 * @handle_checkpoint_destroy: Handler for the #NMDBusManager::handle-checkpoint-destroy signal.
 * @handle_checkpoint_rollback: Handler for the #NMDBusManager::handle-checkpoint-rollback signal.
 * @handle_deactivate_connection: Handler for the #NMDBusManager::handle-deactivate-connection signal.
 * @handle_enable: Handler for the #NMDBusManager::handle-enable signal.
 * @handle_get_all_devices: Handler for the #NMDBusManager::handle-get-all-devices signal.
 * @handle_get_device_by_ip_iface: Handler for the #NMDBusManager::handle-get-device-by-ip-iface signal.
 * @handle_get_devices: Handler for the #NMDBusManager::handle-get-devices signal.
 * @handle_get_logging: Handler for the #NMDBusManager::handle-get-logging signal.
 * @handle_get_permissions: Handler for the #NMDBusManager::handle-get-permissions signal.
 * @handle_reload: Handler for the #NMDBusManager::handle-reload signal.
 * @handle_set_logging: Handler for the #NMDBusManager::handle-set-logging signal.
 * @handle_sleep: Handler for the #NMDBusManager::handle-sleep signal.
 * @handle_state: Handler for the #NMDBusManager::handle-state signal.
 * @get_activating_connection: Getter for the #NMDBusManager:activating-connection property.
 * @get_active_connections: Getter for the #NMDBusManager:active-connections property.
 * @get_all_devices: Getter for the #NMDBusManager:all-devices property.
 * @get_capabilities: Getter for the #NMDBusManager:capabilities property.
 * @get_checkpoints: Getter for the #NMDBusManager:checkpoints property.
 * @get_connectivity: Getter for the #NMDBusManager:connectivity property.
 * @get_connectivity_check_available: Getter for the #NMDBusManager:connectivity-check-available property.
 * @get_connectivity_check_enabled: Getter for the #NMDBusManager:connectivity-check-enabled property.
 * @get_connectivity_check_uri: Getter for the #NMDBusManager:connectivity-check-uri property.
 * @get_devices: Getter for the #NMDBusManager:devices property.
 * @get_global_dns_configuration: Getter for the #NMDBusManager:global-dns-configuration property.
 * @get_metered: Getter for the #NMDBusManager:metered property.
 * @get_networking_enabled: Getter for the #NMDBusManager:networking-enabled property.
 * @get_primary_connection: Getter for the #NMDBusManager:primary-connection property.
 * @get_primary_connection_type: Getter for the #NMDBusManager:primary-connection-type property.
 * @get_startup: Getter for the #NMDBusManager:startup property.
 * @get_state: Getter for the #NMDBusManager:state property.
 * @get_version: Getter for the #NMDBusManager:version property.
 * @get_version_info: Getter for the #NMDBusManager:version-info property.
 * @get_wimax_enabled: Getter for the #NMDBusManager:wimax-enabled property.
 * @get_wimax_hardware_enabled: Getter for the #NMDBusManager:wimax-hardware-enabled property.
 * @get_wireless_enabled: Getter for the #NMDBusManager:wireless-enabled property.
 * @get_wireless_hardware_enabled: Getter for the #NMDBusManager:wireless-hardware-enabled property.
 * @get_wwan_enabled: Getter for the #NMDBusManager:wwan-enabled property.
 * @get_wwan_hardware_enabled: Getter for the #NMDBusManager:wwan-hardware-enabled property.
 * @check_permissions: Handler for the #NMDBusManager::check-permissions signal.
 * @device_added: Handler for the #NMDBusManager::device-added signal.
 * @device_removed: Handler for the #NMDBusManager::device-removed signal.
 * @state_changed: Handler for the #NMDBusManager::state-changed signal.
 * @handle_checkpoint_adjust_rollback_timeout: Handler for the #NMDBusManager::handle-checkpoint-adjust-rollback-timeout signal.
 * @get_radio_flags: Getter for the #NMDBusManager:radio-flags property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager.top_of_page">org.freedesktop.NetworkManager</link>.
 */

typedef NMDBusManagerIface NMDBusManagerInterface;
G_DEFINE_INTERFACE (NMDBusManager, nmdbus_manager, G_TYPE_OBJECT)

static void
nmdbus_manager_default_init (NMDBusManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NMDBusManager::handle-reload:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Reload">Reload()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_reload() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reload",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_reload),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_reload,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * NMDBusManager::handle-get-devices:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetDevices">GetDevices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_get_devices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-devices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_get_devices),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_get_devices,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusManager::handle-get-all-devices:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetAllDevices">GetAllDevices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_get_all_devices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-all-devices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_get_all_devices),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_get_all_devices,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusManager::handle-get-device-by-ip-iface:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_iface: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetDeviceByIpIface">GetDeviceByIpIface()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_get_device_by_ip_iface() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-device-by-ip-iface",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_get_device_by_ip_iface),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_get_device_by_ip_iface,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * NMDBusManager::handle-activate-connection:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connection: Argument passed by remote caller.
   * @arg_device: Argument passed by remote caller.
   * @arg_specific_object: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.ActivateConnection">ActivateConnection()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_activate_connection() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate-connection",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_activate_connection),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_activate_connection,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * NMDBusManager::handle-add-and-activate-connection:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connection: Argument passed by remote caller.
   * @arg_device: Argument passed by remote caller.
   * @arg_specific_object: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.AddAndActivateConnection">AddAndActivateConnection()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_add_and_activate_connection() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-and-activate-connection",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_add_and_activate_connection),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_add_and_activate_connection,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * NMDBusManager::handle-add-and-activate-connection2:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connection: Argument passed by remote caller.
   * @arg_device: Argument passed by remote caller.
   * @arg_specific_object: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.AddAndActivateConnection2">AddAndActivateConnection2()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_add_and_activate_connection2() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-and-activate-connection2",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_add_and_activate_connection2),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_add_and_activate_connection2,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * NMDBusManager::handle-deactivate-connection:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_active_connection: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.DeactivateConnection">DeactivateConnection()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_deactivate_connection() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-deactivate-connection",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_deactivate_connection),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_deactivate_connection,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * NMDBusManager::handle-sleep:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_sleep: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Sleep">Sleep()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_sleep() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-sleep",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_sleep),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_sleep,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * NMDBusManager::handle-enable:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_enable: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Enable">Enable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_enable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_enable),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_enable,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * NMDBusManager::handle-get-permissions:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetPermissions">GetPermissions()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_get_permissions() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-permissions",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_get_permissions),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_get_permissions,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusManager::handle-set-logging:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_level: Argument passed by remote caller.
   * @arg_domains: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.SetLogging">SetLogging()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_set_logging() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-logging",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_set_logging),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_set_logging,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * NMDBusManager::handle-get-logging:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetLogging">GetLogging()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_get_logging() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-logging",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_get_logging),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_get_logging,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusManager::handle-check-connectivity:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckConnectivity">CheckConnectivity()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_check_connectivity() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-check-connectivity",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_check_connectivity),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_check_connectivity,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusManager::handle-state:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.state">state()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_state),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_state,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusManager::handle-checkpoint-create:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_devices: Argument passed by remote caller.
   * @arg_rollback_timeout: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointCreate">CheckpointCreate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_checkpoint_create() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-checkpoint-create",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_checkpoint_create),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_checkpoint_create,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * NMDBusManager::handle-checkpoint-destroy:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_checkpoint: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointDestroy">CheckpointDestroy()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_checkpoint_destroy() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-checkpoint-destroy",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_checkpoint_destroy),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_checkpoint_destroy,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * NMDBusManager::handle-checkpoint-rollback:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_checkpoint: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointRollback">CheckpointRollback()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_checkpoint_rollback() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-checkpoint-rollback",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_checkpoint_rollback),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_checkpoint_rollback,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * NMDBusManager::handle-checkpoint-adjust-rollback-timeout:
   * @object: A #NMDBusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_checkpoint: Argument passed by remote caller.
   * @arg_add_timeout: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointAdjustRollbackTimeout">CheckpointAdjustRollbackTimeout()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_manager_complete_checkpoint_adjust_rollback_timeout() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 1.12
   */
  g_signal_new ("handle-checkpoint-adjust-rollback-timeout",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusManagerIface, handle_checkpoint_adjust_rollback_timeout),
    g_signal_accumulator_true_handled,
    NULL,
      nmdbus_manager_method_marshal_checkpoint_adjust_rollback_timeout,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * NMDBusManager::check-permissions:
   * @object: A #NMDBusManager.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager.CheckPermissions">"CheckPermissions"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  NMDBUS__MANAGER_SIGNALS[NMDBUS__MANAGER_CHECK_PERMISSIONS] =
    g_signal_new ("check-permissions",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (NMDBusManagerIface, check_permissions),
      NULL,
      NULL,
      nmdbus_manager_signal_marshal_check_permissions,
      G_TYPE_NONE,
      0);

  /**
   * NMDBusManager::state-changed:
   * @object: A #NMDBusManager.
   * @arg_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  NMDBUS__MANAGER_SIGNALS[NMDBUS__MANAGER_STATE_CHANGED] =
    g_signal_new ("state-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (NMDBusManagerIface, state_changed),
      NULL,
      NULL,
      nmdbus_manager_signal_marshal_state_changed,
      G_TYPE_NONE,
      1, G_TYPE_UINT);

  /**
   * NMDBusManager::device-added:
   * @object: A #NMDBusManager.
   * @arg_device_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager.DeviceAdded">"DeviceAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  NMDBUS__MANAGER_SIGNALS[NMDBUS__MANAGER_DEVICE_ADDED] =
    g_signal_new ("device-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (NMDBusManagerIface, device_added),
      NULL,
      NULL,
      nmdbus_manager_signal_marshal_device_added,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * NMDBusManager::device-removed:
   * @object: A #NMDBusManager.
   * @arg_device_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager.DeviceRemoved">"DeviceRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  NMDBUS__MANAGER_SIGNALS[NMDBUS__MANAGER_DEVICE_REMOVED] =
    g_signal_new ("device-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (NMDBusManagerIface, device_removed),
      NULL,
      NULL,
      nmdbus_manager_signal_marshal_device_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * NMDBusManager:devices:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.Devices">"Devices"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("devices", "Devices", "Devices", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:all-devices:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.AllDevices">"AllDevices"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("all-devices", "AllDevices", "AllDevices", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:checkpoints:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.Checkpoints">"Checkpoints"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("checkpoints", "Checkpoints", "Checkpoints", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:networking-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.NetworkingEnabled">"NetworkingEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("networking-enabled", "NetworkingEnabled", "NetworkingEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:wireless-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.WirelessEnabled">"WirelessEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("wireless-enabled", "WirelessEnabled", "WirelessEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:wireless-hardware-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.WirelessHardwareEnabled">"WirelessHardwareEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("wireless-hardware-enabled", "WirelessHardwareEnabled", "WirelessHardwareEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:wwan-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.WwanEnabled">"WwanEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("wwan-enabled", "WwanEnabled", "WwanEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:wwan-hardware-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.WwanHardwareEnabled">"WwanHardwareEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("wwan-hardware-enabled", "WwanHardwareEnabled", "WwanHardwareEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:wimax-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.WimaxEnabled">"WimaxEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("wimax-enabled", "WimaxEnabled", "WimaxEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:wimax-hardware-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.WimaxHardwareEnabled">"WimaxHardwareEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("wimax-hardware-enabled", "WimaxHardwareEnabled", "WimaxHardwareEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:radio-flags:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.RadioFlags">"RadioFlags"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   *
   * Since: 1.38
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("radio-flags", "RadioFlags", "RadioFlags", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:active-connections:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.ActiveConnections">"ActiveConnections"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("active-connections", "ActiveConnections", "ActiveConnections", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:primary-connection:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.PrimaryConnection">"PrimaryConnection"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("primary-connection", "PrimaryConnection", "PrimaryConnection", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:primary-connection-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.PrimaryConnectionType">"PrimaryConnectionType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("primary-connection-type", "PrimaryConnectionType", "PrimaryConnectionType", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:metered:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.Metered">"Metered"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("metered", "Metered", "Metered", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:activating-connection:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.ActivatingConnection">"ActivatingConnection"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("activating-connection", "ActivatingConnection", "ActivatingConnection", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:startup:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.Startup">"Startup"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("startup", "Startup", "Startup", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("version", "Version", "Version", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:version-info:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.VersionInfo">"VersionInfo"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("version-info", "VersionInfo", "VersionInfo", G_VARIANT_TYPE ("au"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:capabilities:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.Capabilities">"Capabilities"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("capabilities", "Capabilities", "Capabilities", G_VARIANT_TYPE ("au"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("state", "State", "State", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:connectivity:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.Connectivity">"Connectivity"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("connectivity", "Connectivity", "Connectivity", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:connectivity-check-available:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckAvailable">"ConnectivityCheckAvailable"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("connectivity-check-available", "ConnectivityCheckAvailable", "ConnectivityCheckAvailable", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:connectivity-check-enabled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckEnabled">"ConnectivityCheckEnabled"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("connectivity-check-enabled", "ConnectivityCheckEnabled", "ConnectivityCheckEnabled", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:connectivity-check-uri:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckUri">"ConnectivityCheckUri"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("connectivity-check-uri", "ConnectivityCheckUri", "ConnectivityCheckUri", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusManager:global-dns-configuration:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager.GlobalDnsConfiguration">"GlobalDnsConfiguration"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("global-dns-configuration", "GlobalDnsConfiguration", "GlobalDnsConfiguration", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nmdbus_manager_get_devices: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Devices">"Devices"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_devices() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nmdbus_manager_get_devices (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_devices (object);
}

/**
 * nmdbus_manager_dup_devices: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Devices">"Devices"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nmdbus_manager_dup_devices (NMDBusManager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "devices", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_devices: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Devices">"Devices"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_devices (NMDBusManager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "devices", value, NULL);
}

/**
 * nmdbus_manager_get_all_devices: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.AllDevices">"AllDevices"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_all_devices() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nmdbus_manager_get_all_devices (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_all_devices (object);
}

/**
 * nmdbus_manager_dup_all_devices: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.AllDevices">"AllDevices"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nmdbus_manager_dup_all_devices (NMDBusManager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "all-devices", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_all_devices: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.AllDevices">"AllDevices"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_all_devices (NMDBusManager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "all-devices", value, NULL);
}

/**
 * nmdbus_manager_get_checkpoints: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Checkpoints">"Checkpoints"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_checkpoints() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nmdbus_manager_get_checkpoints (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_checkpoints (object);
}

/**
 * nmdbus_manager_dup_checkpoints: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Checkpoints">"Checkpoints"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nmdbus_manager_dup_checkpoints (NMDBusManager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "checkpoints", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_checkpoints: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Checkpoints">"Checkpoints"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_checkpoints (NMDBusManager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "checkpoints", value, NULL);
}

/**
 * nmdbus_manager_get_networking_enabled: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.NetworkingEnabled">"NetworkingEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_networking_enabled (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_networking_enabled (object);
}

/**
 * nmdbus_manager_set_networking_enabled: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.NetworkingEnabled">"NetworkingEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_networking_enabled (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "networking-enabled", value, NULL);
}

/**
 * nmdbus_manager_get_wireless_enabled: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WirelessEnabled">"WirelessEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_wireless_enabled (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_wireless_enabled (object);
}

/**
 * nmdbus_manager_set_wireless_enabled: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WirelessEnabled">"WirelessEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
nmdbus_manager_set_wireless_enabled (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "wireless-enabled", value, NULL);
}

/**
 * nmdbus_manager_get_wireless_hardware_enabled: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WirelessHardwareEnabled">"WirelessHardwareEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_wireless_hardware_enabled (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_wireless_hardware_enabled (object);
}

/**
 * nmdbus_manager_set_wireless_hardware_enabled: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WirelessHardwareEnabled">"WirelessHardwareEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_wireless_hardware_enabled (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "wireless-hardware-enabled", value, NULL);
}

/**
 * nmdbus_manager_get_wwan_enabled: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WwanEnabled">"WwanEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_wwan_enabled (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_wwan_enabled (object);
}

/**
 * nmdbus_manager_set_wwan_enabled: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WwanEnabled">"WwanEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
nmdbus_manager_set_wwan_enabled (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "wwan-enabled", value, NULL);
}

/**
 * nmdbus_manager_get_wwan_hardware_enabled: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WwanHardwareEnabled">"WwanHardwareEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_wwan_hardware_enabled (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_wwan_hardware_enabled (object);
}

/**
 * nmdbus_manager_set_wwan_hardware_enabled: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WwanHardwareEnabled">"WwanHardwareEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_wwan_hardware_enabled (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "wwan-hardware-enabled", value, NULL);
}

/**
 * nmdbus_manager_get_wimax_enabled: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WimaxEnabled">"WimaxEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_wimax_enabled (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_wimax_enabled (object);
}

/**
 * nmdbus_manager_set_wimax_enabled: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WimaxEnabled">"WimaxEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
nmdbus_manager_set_wimax_enabled (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "wimax-enabled", value, NULL);
}

/**
 * nmdbus_manager_get_wimax_hardware_enabled: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WimaxHardwareEnabled">"WimaxHardwareEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_wimax_hardware_enabled (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_wimax_hardware_enabled (object);
}

/**
 * nmdbus_manager_set_wimax_hardware_enabled: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.WimaxHardwareEnabled">"WimaxHardwareEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_wimax_hardware_enabled (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "wimax-hardware-enabled", value, NULL);
}

/**
 * nmdbus_manager_get_radio_flags: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.RadioFlags">"RadioFlags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 *
 * Since: 1.38
 */
guint 
nmdbus_manager_get_radio_flags (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), 0);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_radio_flags (object);
}

/**
 * nmdbus_manager_set_radio_flags: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.RadioFlags">"RadioFlags"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 *
 * Since: 1.38
 */
void
nmdbus_manager_set_radio_flags (NMDBusManager *object, guint value)
{
  g_object_set (G_OBJECT (object), "radio-flags", value, NULL);
}

/**
 * nmdbus_manager_get_active_connections: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ActiveConnections">"ActiveConnections"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_active_connections() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nmdbus_manager_get_active_connections (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_active_connections (object);
}

/**
 * nmdbus_manager_dup_active_connections: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ActiveConnections">"ActiveConnections"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nmdbus_manager_dup_active_connections (NMDBusManager *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "active-connections", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_active_connections: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ActiveConnections">"ActiveConnections"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_active_connections (NMDBusManager *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "active-connections", value, NULL);
}

/**
 * nmdbus_manager_get_primary_connection: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.PrimaryConnection">"PrimaryConnection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_primary_connection() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_manager_get_primary_connection (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_primary_connection (object);
}

/**
 * nmdbus_manager_dup_primary_connection: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.PrimaryConnection">"PrimaryConnection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_manager_dup_primary_connection (NMDBusManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "primary-connection", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_primary_connection: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.PrimaryConnection">"PrimaryConnection"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_primary_connection (NMDBusManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "primary-connection", value, NULL);
}

/**
 * nmdbus_manager_get_primary_connection_type: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.PrimaryConnectionType">"PrimaryConnectionType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_primary_connection_type() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_manager_get_primary_connection_type (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_primary_connection_type (object);
}

/**
 * nmdbus_manager_dup_primary_connection_type: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.PrimaryConnectionType">"PrimaryConnectionType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_manager_dup_primary_connection_type (NMDBusManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "primary-connection-type", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_primary_connection_type: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.PrimaryConnectionType">"PrimaryConnectionType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_primary_connection_type (NMDBusManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "primary-connection-type", value, NULL);
}

/**
 * nmdbus_manager_get_metered: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Metered">"Metered"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_manager_get_metered (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), 0);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_metered (object);
}

/**
 * nmdbus_manager_set_metered: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Metered">"Metered"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_metered (NMDBusManager *object, guint value)
{
  g_object_set (G_OBJECT (object), "metered", value, NULL);
}

/**
 * nmdbus_manager_get_activating_connection: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ActivatingConnection">"ActivatingConnection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_activating_connection() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_manager_get_activating_connection (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_activating_connection (object);
}

/**
 * nmdbus_manager_dup_activating_connection: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ActivatingConnection">"ActivatingConnection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_manager_dup_activating_connection (NMDBusManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "activating-connection", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_activating_connection: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ActivatingConnection">"ActivatingConnection"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_activating_connection (NMDBusManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "activating-connection", value, NULL);
}

/**
 * nmdbus_manager_get_startup: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Startup">"Startup"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_startup (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_startup (object);
}

/**
 * nmdbus_manager_set_startup: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Startup">"Startup"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_startup (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "startup", value, NULL);
}

/**
 * nmdbus_manager_get_version: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_manager_get_version (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_version (object);
}

/**
 * nmdbus_manager_dup_version: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_manager_dup_version (NMDBusManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "version", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_version: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_version (NMDBusManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * nmdbus_manager_get_version_info: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.VersionInfo">"VersionInfo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_version_info() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_manager_get_version_info (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_version_info (object);
}

/**
 * nmdbus_manager_dup_version_info: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.VersionInfo">"VersionInfo"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_manager_dup_version_info (NMDBusManager *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "version-info", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_version_info: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.VersionInfo">"VersionInfo"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_version_info (NMDBusManager *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "version-info", value, NULL);
}

/**
 * nmdbus_manager_get_capabilities: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Capabilities">"Capabilities"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_capabilities() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_manager_get_capabilities (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_capabilities (object);
}

/**
 * nmdbus_manager_dup_capabilities: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Capabilities">"Capabilities"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_manager_dup_capabilities (NMDBusManager *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "capabilities", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_capabilities: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Capabilities">"Capabilities"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_capabilities (NMDBusManager *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "capabilities", value, NULL);
}

/**
 * nmdbus_manager_get_state: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_manager_get_state (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), 0);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_state (object);
}

/**
 * nmdbus_manager_set_state: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_state (NMDBusManager *object, guint value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * nmdbus_manager_get_connectivity: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Connectivity">"Connectivity"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_manager_get_connectivity (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), 0);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_connectivity (object);
}

/**
 * nmdbus_manager_set_connectivity: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.Connectivity">"Connectivity"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_connectivity (NMDBusManager *object, guint value)
{
  g_object_set (G_OBJECT (object), "connectivity", value, NULL);
}

/**
 * nmdbus_manager_get_connectivity_check_available: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckAvailable">"ConnectivityCheckAvailable"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_connectivity_check_available (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_connectivity_check_available (object);
}

/**
 * nmdbus_manager_set_connectivity_check_available: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckAvailable">"ConnectivityCheckAvailable"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_connectivity_check_available (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "connectivity-check-available", value, NULL);
}

/**
 * nmdbus_manager_get_connectivity_check_enabled: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckEnabled">"ConnectivityCheckEnabled"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_manager_get_connectivity_check_enabled (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), FALSE);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_connectivity_check_enabled (object);
}

/**
 * nmdbus_manager_set_connectivity_check_enabled: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckEnabled">"ConnectivityCheckEnabled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
nmdbus_manager_set_connectivity_check_enabled (NMDBusManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "connectivity-check-enabled", value, NULL);
}

/**
 * nmdbus_manager_get_connectivity_check_uri: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckUri">"ConnectivityCheckUri"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_connectivity_check_uri() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_manager_get_connectivity_check_uri (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_connectivity_check_uri (object);
}

/**
 * nmdbus_manager_dup_connectivity_check_uri: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckUri">"ConnectivityCheckUri"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_manager_dup_connectivity_check_uri (NMDBusManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "connectivity-check-uri", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_connectivity_check_uri: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.ConnectivityCheckUri">"ConnectivityCheckUri"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_manager_set_connectivity_check_uri (NMDBusManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "connectivity-check-uri", value, NULL);
}

/**
 * nmdbus_manager_get_global_dns_configuration: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.GlobalDnsConfiguration">"GlobalDnsConfiguration"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_manager_dup_global_dns_configuration() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_manager_get_global_dns_configuration (NMDBusManager *object)
{
  g_return_val_if_fail (NMDBUS_IS_MANAGER (object), NULL);

  return NMDBUS_MANAGER_GET_IFACE (object)->get_global_dns_configuration (object);
}

/**
 * nmdbus_manager_dup_global_dns_configuration: (skip)
 * @object: A #NMDBusManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager.GlobalDnsConfiguration">"GlobalDnsConfiguration"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_manager_dup_global_dns_configuration (NMDBusManager *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "global-dns-configuration", &value, NULL);
  return value;
}

/**
 * nmdbus_manager_set_global_dns_configuration: (skip)
 * @object: A #NMDBusManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager.GlobalDnsConfiguration">"GlobalDnsConfiguration"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
nmdbus_manager_set_global_dns_configuration (NMDBusManager *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "global-dns-configuration", value, NULL);
}

/**
 * nmdbus_manager_emit_check_permissions:
 * @object: A #NMDBusManager.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager.CheckPermissions">"CheckPermissions"</link> D-Bus signal.
 */
void
nmdbus_manager_emit_check_permissions (
    NMDBusManager *object)
{
  g_signal_emit (object, NMDBUS__MANAGER_SIGNALS[NMDBUS__MANAGER_CHECK_PERMISSIONS], 0);
}

/**
 * nmdbus_manager_emit_state_changed:
 * @object: A #NMDBusManager.
 * @arg_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
nmdbus_manager_emit_state_changed (
    NMDBusManager *object,
    guint arg_state)
{
  g_signal_emit (object, NMDBUS__MANAGER_SIGNALS[NMDBUS__MANAGER_STATE_CHANGED], 0, arg_state);
}

/**
 * nmdbus_manager_emit_device_added:
 * @object: A #NMDBusManager.
 * @arg_device_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager.DeviceAdded">"DeviceAdded"</link> D-Bus signal.
 */
void
nmdbus_manager_emit_device_added (
    NMDBusManager *object,
    const gchar *arg_device_path)
{
  g_signal_emit (object, NMDBUS__MANAGER_SIGNALS[NMDBUS__MANAGER_DEVICE_ADDED], 0, arg_device_path);
}

/**
 * nmdbus_manager_emit_device_removed:
 * @object: A #NMDBusManager.
 * @arg_device_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager.DeviceRemoved">"DeviceRemoved"</link> D-Bus signal.
 */
void
nmdbus_manager_emit_device_removed (
    NMDBusManager *object,
    const gchar *arg_device_path)
{
  g_signal_emit (object, NMDBUS__MANAGER_SIGNALS[NMDBUS__MANAGER_DEVICE_REMOVED], 0, arg_device_path);
}

/**
 * nmdbus_manager_call_reload:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Reload">Reload()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_reload_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_reload_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_reload (
    NMDBusManager *proxy,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reload",
    g_variant_new ("(u)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_reload_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_reload().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_reload().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_reload_finish (
    NMDBusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_reload_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Reload">Reload()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_reload() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_reload_sync (
    NMDBusManager *proxy,
    guint arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reload",
    g_variant_new ("(u)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_devices:
 * @proxy: A #NMDBusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetDevices">GetDevices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_get_devices_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_get_devices_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_get_devices (
    NMDBusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetDevices",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_get_devices_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_get_devices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_get_devices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_devices_finish (
    NMDBusManager *proxy,
    gchar ***out_devices,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_devices_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetDevices">GetDevices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_get_devices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_devices_sync (
    NMDBusManager *proxy,
    gchar ***out_devices,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetDevices",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_all_devices:
 * @proxy: A #NMDBusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetAllDevices">GetAllDevices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_get_all_devices_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_get_all_devices_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_get_all_devices (
    NMDBusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAllDevices",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_get_all_devices_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_get_all_devices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_get_all_devices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_all_devices_finish (
    NMDBusManager *proxy,
    gchar ***out_devices,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_all_devices_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetAllDevices">GetAllDevices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_get_all_devices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_all_devices_sync (
    NMDBusManager *proxy,
    gchar ***out_devices,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAllDevices",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_device_by_ip_iface:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_iface: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetDeviceByIpIface">GetDeviceByIpIface()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_get_device_by_ip_iface_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_get_device_by_ip_iface_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_get_device_by_ip_iface (
    NMDBusManager *proxy,
    const gchar *arg_iface,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetDeviceByIpIface",
    g_variant_new ("(s)",
                   arg_iface),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_get_device_by_ip_iface_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_device: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_get_device_by_ip_iface().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_get_device_by_ip_iface().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_device_by_ip_iface_finish (
    NMDBusManager *proxy,
    gchar **out_device,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_device_by_ip_iface_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_iface: Argument to pass with the method invocation.
 * @out_device: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetDeviceByIpIface">GetDeviceByIpIface()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_get_device_by_ip_iface() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_device_by_ip_iface_sync (
    NMDBusManager *proxy,
    const gchar *arg_iface,
    gchar **out_device,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetDeviceByIpIface",
    g_variant_new ("(s)",
                   arg_iface),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_activate_connection:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_specific_object: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.ActivateConnection">ActivateConnection()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_activate_connection_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_activate_connection_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_activate_connection (
    NMDBusManager *proxy,
    const gchar *arg_connection,
    const gchar *arg_device,
    const gchar *arg_specific_object,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ActivateConnection",
    g_variant_new ("(ooo)",
                   arg_connection,
                   arg_device,
                   arg_specific_object),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_activate_connection_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_active_connection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_activate_connection().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_activate_connection().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_activate_connection_finish (
    NMDBusManager *proxy,
    gchar **out_active_connection,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_active_connection);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_activate_connection_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_specific_object: Argument to pass with the method invocation.
 * @out_active_connection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.ActivateConnection">ActivateConnection()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_activate_connection() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_activate_connection_sync (
    NMDBusManager *proxy,
    const gchar *arg_connection,
    const gchar *arg_device,
    const gchar *arg_specific_object,
    gchar **out_active_connection,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ActivateConnection",
    g_variant_new ("(ooo)",
                   arg_connection,
                   arg_device,
                   arg_specific_object),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_active_connection);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_add_and_activate_connection:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_specific_object: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.AddAndActivateConnection">AddAndActivateConnection()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_add_and_activate_connection_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_add_and_activate_connection_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_add_and_activate_connection (
    NMDBusManager *proxy,
    GVariant *arg_connection,
    const gchar *arg_device,
    const gchar *arg_specific_object,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddAndActivateConnection",
    g_variant_new ("(@a{sa{sv}}oo)",
                   arg_connection,
                   arg_device,
                   arg_specific_object),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_add_and_activate_connection_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_active_connection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_add_and_activate_connection().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_add_and_activate_connection().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_add_and_activate_connection_finish (
    NMDBusManager *proxy,
    gchar **out_path,
    gchar **out_active_connection,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(oo)",
                 out_path,
                 out_active_connection);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_add_and_activate_connection_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_specific_object: Argument to pass with the method invocation.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_active_connection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.AddAndActivateConnection">AddAndActivateConnection()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_add_and_activate_connection() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_add_and_activate_connection_sync (
    NMDBusManager *proxy,
    GVariant *arg_connection,
    const gchar *arg_device,
    const gchar *arg_specific_object,
    gchar **out_path,
    gchar **out_active_connection,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddAndActivateConnection",
    g_variant_new ("(@a{sa{sv}}oo)",
                   arg_connection,
                   arg_device,
                   arg_specific_object),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(oo)",
                 out_path,
                 out_active_connection);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_add_and_activate_connection2:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_specific_object: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.AddAndActivateConnection2">AddAndActivateConnection2()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_add_and_activate_connection2_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_add_and_activate_connection2_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_add_and_activate_connection2 (
    NMDBusManager *proxy,
    GVariant *arg_connection,
    const gchar *arg_device,
    const gchar *arg_specific_object,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddAndActivateConnection2",
    g_variant_new ("(@a{sa{sv}}oo@a{sv})",
                   arg_connection,
                   arg_device,
                   arg_specific_object,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_add_and_activate_connection2_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_active_connection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_add_and_activate_connection2().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_add_and_activate_connection2().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_add_and_activate_connection2_finish (
    NMDBusManager *proxy,
    gchar **out_path,
    gchar **out_active_connection,
    GVariant **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(oo@a{sv})",
                 out_path,
                 out_active_connection,
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_add_and_activate_connection2_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_connection: Argument to pass with the method invocation.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_specific_object: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_active_connection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.AddAndActivateConnection2">AddAndActivateConnection2()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_add_and_activate_connection2() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_add_and_activate_connection2_sync (
    NMDBusManager *proxy,
    GVariant *arg_connection,
    const gchar *arg_device,
    const gchar *arg_specific_object,
    GVariant *arg_options,
    gchar **out_path,
    gchar **out_active_connection,
    GVariant **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddAndActivateConnection2",
    g_variant_new ("(@a{sa{sv}}oo@a{sv})",
                   arg_connection,
                   arg_device,
                   arg_specific_object,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(oo@a{sv})",
                 out_path,
                 out_active_connection,
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_deactivate_connection:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_active_connection: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.DeactivateConnection">DeactivateConnection()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_deactivate_connection_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_deactivate_connection_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_deactivate_connection (
    NMDBusManager *proxy,
    const gchar *arg_active_connection,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeactivateConnection",
    g_variant_new ("(o)",
                   arg_active_connection),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_deactivate_connection_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_deactivate_connection().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_deactivate_connection().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_deactivate_connection_finish (
    NMDBusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_deactivate_connection_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_active_connection: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.DeactivateConnection">DeactivateConnection()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_deactivate_connection() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_deactivate_connection_sync (
    NMDBusManager *proxy,
    const gchar *arg_active_connection,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeactivateConnection",
    g_variant_new ("(o)",
                   arg_active_connection),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_sleep:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_sleep: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Sleep">Sleep()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_sleep_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_sleep_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_sleep (
    NMDBusManager *proxy,
    gboolean arg_sleep,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Sleep",
    g_variant_new ("(b)",
                   arg_sleep),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_sleep_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_sleep().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_sleep().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_sleep_finish (
    NMDBusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_sleep_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_sleep: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Sleep">Sleep()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_sleep() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_sleep_sync (
    NMDBusManager *proxy,
    gboolean arg_sleep,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Sleep",
    g_variant_new ("(b)",
                   arg_sleep),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_enable:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Enable">Enable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_enable_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_enable_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_enable (
    NMDBusManager *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_enable_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_enable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_enable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_enable_finish (
    NMDBusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_enable_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Enable">Enable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_enable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_enable_sync (
    NMDBusManager *proxy,
    gboolean arg_enable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("(b)",
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_permissions:
 * @proxy: A #NMDBusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetPermissions">GetPermissions()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_get_permissions_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_get_permissions_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_get_permissions (
    NMDBusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetPermissions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_get_permissions_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_permissions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_get_permissions().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_get_permissions().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_permissions_finish (
    NMDBusManager *proxy,
    GVariant **out_permissions,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{ss})",
                 out_permissions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_permissions_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @out_permissions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetPermissions">GetPermissions()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_get_permissions() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_permissions_sync (
    NMDBusManager *proxy,
    GVariant **out_permissions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetPermissions",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{ss})",
                 out_permissions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_set_logging:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_level: Argument to pass with the method invocation.
 * @arg_domains: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.SetLogging">SetLogging()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_set_logging_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_set_logging_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_set_logging (
    NMDBusManager *proxy,
    const gchar *arg_level,
    const gchar *arg_domains,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLogging",
    g_variant_new ("(ss)",
                   arg_level,
                   arg_domains),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_set_logging_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_set_logging().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_set_logging().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_set_logging_finish (
    NMDBusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_set_logging_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_level: Argument to pass with the method invocation.
 * @arg_domains: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.SetLogging">SetLogging()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_set_logging() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_set_logging_sync (
    NMDBusManager *proxy,
    const gchar *arg_level,
    const gchar *arg_domains,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLogging",
    g_variant_new ("(ss)",
                   arg_level,
                   arg_domains),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_logging:
 * @proxy: A #NMDBusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetLogging">GetLogging()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_get_logging_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_get_logging_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_get_logging (
    NMDBusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetLogging",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_get_logging_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_level: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_domains: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_get_logging().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_get_logging().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_logging_finish (
    NMDBusManager *proxy,
    gchar **out_level,
    gchar **out_domains,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_level,
                 out_domains);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_get_logging_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @out_level: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_domains: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetLogging">GetLogging()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_get_logging() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_get_logging_sync (
    NMDBusManager *proxy,
    gchar **out_level,
    gchar **out_domains,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetLogging",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_level,
                 out_domains);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_check_connectivity:
 * @proxy: A #NMDBusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckConnectivity">CheckConnectivity()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_check_connectivity_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_check_connectivity_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_check_connectivity (
    NMDBusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CheckConnectivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_check_connectivity_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_connectivity: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_check_connectivity().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_check_connectivity().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_check_connectivity_finish (
    NMDBusManager *proxy,
    guint *out_connectivity,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_connectivity);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_check_connectivity_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @out_connectivity: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckConnectivity">CheckConnectivity()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_check_connectivity() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_check_connectivity_sync (
    NMDBusManager *proxy,
    guint *out_connectivity,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CheckConnectivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_connectivity);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_state:
 * @proxy: A #NMDBusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.state">state()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_state_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_state_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_state (
    NMDBusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "state",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_state_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_state_finish (
    NMDBusManager *proxy,
    guint *out_state,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_state_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.state">state()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_state_sync (
    NMDBusManager *proxy,
    guint *out_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "state",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_checkpoint_create:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_devices: Argument to pass with the method invocation.
 * @arg_rollback_timeout: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointCreate">CheckpointCreate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_checkpoint_create_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_checkpoint_create_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_checkpoint_create (
    NMDBusManager *proxy,
    const gchar *const *arg_devices,
    guint arg_rollback_timeout,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CheckpointCreate",
    g_variant_new ("(^aouu)",
                   arg_devices,
                   arg_rollback_timeout,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_checkpoint_create_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_checkpoint: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_checkpoint_create().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_checkpoint_create().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_checkpoint_create_finish (
    NMDBusManager *proxy,
    gchar **out_checkpoint,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_checkpoint);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_checkpoint_create_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_devices: Argument to pass with the method invocation.
 * @arg_rollback_timeout: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_checkpoint: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointCreate">CheckpointCreate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_checkpoint_create() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_checkpoint_create_sync (
    NMDBusManager *proxy,
    const gchar *const *arg_devices,
    guint arg_rollback_timeout,
    guint arg_flags,
    gchar **out_checkpoint,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CheckpointCreate",
    g_variant_new ("(^aouu)",
                   arg_devices,
                   arg_rollback_timeout,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_checkpoint);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_checkpoint_destroy:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_checkpoint: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointDestroy">CheckpointDestroy()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_checkpoint_destroy_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_checkpoint_destroy_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_checkpoint_destroy (
    NMDBusManager *proxy,
    const gchar *arg_checkpoint,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CheckpointDestroy",
    g_variant_new ("(o)",
                   arg_checkpoint),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_checkpoint_destroy_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_checkpoint_destroy().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_checkpoint_destroy().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_checkpoint_destroy_finish (
    NMDBusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_checkpoint_destroy_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_checkpoint: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointDestroy">CheckpointDestroy()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_checkpoint_destroy() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_checkpoint_destroy_sync (
    NMDBusManager *proxy,
    const gchar *arg_checkpoint,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CheckpointDestroy",
    g_variant_new ("(o)",
                   arg_checkpoint),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_checkpoint_rollback:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_checkpoint: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointRollback">CheckpointRollback()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_checkpoint_rollback_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_checkpoint_rollback_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_manager_call_checkpoint_rollback (
    NMDBusManager *proxy,
    const gchar *arg_checkpoint,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CheckpointRollback",
    g_variant_new ("(o)",
                   arg_checkpoint),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_checkpoint_rollback_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_checkpoint_rollback().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_checkpoint_rollback().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_checkpoint_rollback_finish (
    NMDBusManager *proxy,
    GVariant **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{su})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_checkpoint_rollback_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_checkpoint: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointRollback">CheckpointRollback()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_checkpoint_rollback() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_manager_call_checkpoint_rollback_sync (
    NMDBusManager *proxy,
    const gchar *arg_checkpoint,
    GVariant **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CheckpointRollback",
    g_variant_new ("(o)",
                   arg_checkpoint),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{su})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_checkpoint_adjust_rollback_timeout:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_checkpoint: Argument to pass with the method invocation.
 * @arg_add_timeout: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointAdjustRollbackTimeout">CheckpointAdjustRollbackTimeout()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_call_checkpoint_adjust_rollback_timeout_finish() to get the result of the operation.
 *
 * See nmdbus_manager_call_checkpoint_adjust_rollback_timeout_sync() for the synchronous, blocking version of this method.
 *
 * Since: 1.12
 */
void
nmdbus_manager_call_checkpoint_adjust_rollback_timeout (
    NMDBusManager *proxy,
    const gchar *arg_checkpoint,
    guint arg_add_timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CheckpointAdjustRollbackTimeout",
    g_variant_new ("(ou)",
                   arg_checkpoint,
                   arg_add_timeout),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_manager_call_checkpoint_adjust_rollback_timeout_finish:
 * @proxy: A #NMDBusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_call_checkpoint_adjust_rollback_timeout().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_manager_call_checkpoint_adjust_rollback_timeout().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 1.12
 */
gboolean
nmdbus_manager_call_checkpoint_adjust_rollback_timeout_finish (
    NMDBusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_call_checkpoint_adjust_rollback_timeout_sync:
 * @proxy: A #NMDBusManagerProxy.
 * @arg_checkpoint: Argument to pass with the method invocation.
 * @arg_add_timeout: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointAdjustRollbackTimeout">CheckpointAdjustRollbackTimeout()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_call_checkpoint_adjust_rollback_timeout() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 1.12
 */
gboolean
nmdbus_manager_call_checkpoint_adjust_rollback_timeout_sync (
    NMDBusManager *proxy,
    const gchar *arg_checkpoint,
    guint arg_add_timeout,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CheckpointAdjustRollbackTimeout",
    g_variant_new ("(ou)",
                   arg_checkpoint,
                   arg_add_timeout),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_manager_complete_reload:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Reload">Reload()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_reload (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_manager_complete_get_devices:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @devices: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetDevices">GetDevices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_get_devices (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *devices)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   devices));
}

/**
 * nmdbus_manager_complete_get_all_devices:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @devices: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetAllDevices">GetAllDevices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_get_all_devices (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *devices)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   devices));
}

/**
 * nmdbus_manager_complete_get_device_by_ip_iface:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @device: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetDeviceByIpIface">GetDeviceByIpIface()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_get_device_by_ip_iface (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *device)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   device));
}

/**
 * nmdbus_manager_complete_activate_connection:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @active_connection: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.ActivateConnection">ActivateConnection()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_activate_connection (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *active_connection)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   active_connection));
}

/**
 * nmdbus_manager_complete_add_and_activate_connection:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 * @active_connection: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.AddAndActivateConnection">AddAndActivateConnection()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_add_and_activate_connection (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path,
    const gchar *active_connection)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(oo)",
                   path,
                   active_connection));
}

/**
 * nmdbus_manager_complete_add_and_activate_connection2:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 * @active_connection: Parameter to return.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.AddAndActivateConnection2">AddAndActivateConnection2()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_add_and_activate_connection2 (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path,
    const gchar *active_connection,
    GVariant *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(oo@a{sv})",
                   path,
                   active_connection,
                   result));
}

/**
 * nmdbus_manager_complete_deactivate_connection:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.DeactivateConnection">DeactivateConnection()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_deactivate_connection (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_manager_complete_sleep:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Sleep">Sleep()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_sleep (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_manager_complete_enable:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.Enable">Enable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_enable (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_manager_complete_get_permissions:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @permissions: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetPermissions">GetPermissions()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_get_permissions (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *permissions)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{ss})",
                   permissions));
}

/**
 * nmdbus_manager_complete_set_logging:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.SetLogging">SetLogging()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_set_logging (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_manager_complete_get_logging:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @level: Parameter to return.
 * @domains: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.GetLogging">GetLogging()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_get_logging (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *level,
    const gchar *domains)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(ss)",
                   level,
                   domains));
}

/**
 * nmdbus_manager_complete_check_connectivity:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @connectivity: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckConnectivity">CheckConnectivity()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_check_connectivity (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint connectivity)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   connectivity));
}

/**
 * nmdbus_manager_complete_state:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @state: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.state">state()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_state (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint state)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   state));
}

/**
 * nmdbus_manager_complete_checkpoint_create:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @checkpoint: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointCreate">CheckpointCreate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_checkpoint_create (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *checkpoint)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   checkpoint));
}

/**
 * nmdbus_manager_complete_checkpoint_destroy:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointDestroy">CheckpointDestroy()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_checkpoint_destroy (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * nmdbus_manager_complete_checkpoint_rollback:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointRollback">CheckpointRollback()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_manager_complete_checkpoint_rollback (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{su})",
                   result));
}

/**
 * nmdbus_manager_complete_checkpoint_adjust_rollback_timeout:
 * @object: A #NMDBusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager.CheckpointAdjustRollbackTimeout">CheckpointAdjustRollbackTimeout()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 1.12
 */
void
nmdbus_manager_complete_checkpoint_adjust_rollback_timeout (
    NMDBusManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NMDBusManagerProxy:
 *
 * The #NMDBusManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusManagerProxy.
 */

struct _NMDBusManagerProxyPrivate
{
  GData *qdata;
};

static void nmdbus_manager_proxy_iface_init (NMDBusManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusManagerProxy, nmdbus_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NMDBusManagerProxy)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_MANAGER, nmdbus_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusManagerProxy, nmdbus_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_MANAGER, nmdbus_manager_proxy_iface_init))

#endif
static void
nmdbus_manager_proxy_finalize (GObject *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nmdbus_manager_proxy_parent_class)->finalize (object);
}

static void
nmdbus_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 26);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nmdbus_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.NetworkManager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nmdbus_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 26);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.NetworkManager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nmdbus_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nmdbus_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nmdbus_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NMDBUS_TYPE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nmdbus_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
nmdbus_manager_proxy_get_devices (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Devices");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Devices");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Devices", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
nmdbus_manager_proxy_get_all_devices (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "AllDevices");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AllDevices");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "AllDevices", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
nmdbus_manager_proxy_get_checkpoints (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Checkpoints");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Checkpoints");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Checkpoints", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_networking_enabled (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NetworkingEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_wireless_enabled (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WirelessEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_wireless_hardware_enabled (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WirelessHardwareEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_wwan_enabled (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WwanEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_wwan_hardware_enabled (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WwanHardwareEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_wimax_enabled (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WimaxEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_wimax_hardware_enabled (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WimaxHardwareEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_manager_proxy_get_radio_flags (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RadioFlags");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
nmdbus_manager_proxy_get_active_connections (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "ActiveConnections");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActiveConnections");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "ActiveConnections", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_manager_proxy_get_primary_connection (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PrimaryConnection");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_manager_proxy_get_primary_connection_type (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PrimaryConnectionType");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_manager_proxy_get_metered (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Metered");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_manager_proxy_get_activating_connection (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActivatingConnection");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_startup (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Startup");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_manager_proxy_get_version (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
nmdbus_manager_proxy_get_version_info (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "VersionInfo");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
nmdbus_manager_proxy_get_capabilities (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Capabilities");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static guint 
nmdbus_manager_proxy_get_state (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "State");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_manager_proxy_get_connectivity (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Connectivity");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_connectivity_check_available (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConnectivityCheckAvailable");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_manager_proxy_get_connectivity_check_enabled (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConnectivityCheckEnabled");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_manager_proxy_get_connectivity_check_uri (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ConnectivityCheckUri");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
nmdbus_manager_proxy_get_global_dns_configuration (NMDBusManager *object)
{
  NMDBusManagerProxy *proxy = NMDBUS_MANAGER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "GlobalDnsConfiguration");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
nmdbus_manager_proxy_init (NMDBusManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nmdbus_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NMDBUS_TYPE_MANAGER_PROXY, NMDBusManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nmdbus_manager_interface_info ());
}

static void
nmdbus_manager_proxy_class_init (NMDBusManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nmdbus_manager_proxy_finalize;
  gobject_class->get_property = nmdbus_manager_proxy_get_property;
  gobject_class->set_property = nmdbus_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nmdbus_manager_proxy_g_signal;
  proxy_class->g_properties_changed = nmdbus_manager_proxy_g_properties_changed;

  nmdbus_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusManagerProxyPrivate));
#endif
}

static void
nmdbus_manager_proxy_iface_init (NMDBusManagerIface *iface)
{
  iface->get_devices = nmdbus_manager_proxy_get_devices;
  iface->get_all_devices = nmdbus_manager_proxy_get_all_devices;
  iface->get_checkpoints = nmdbus_manager_proxy_get_checkpoints;
  iface->get_networking_enabled = nmdbus_manager_proxy_get_networking_enabled;
  iface->get_wireless_enabled = nmdbus_manager_proxy_get_wireless_enabled;
  iface->get_wireless_hardware_enabled = nmdbus_manager_proxy_get_wireless_hardware_enabled;
  iface->get_wwan_enabled = nmdbus_manager_proxy_get_wwan_enabled;
  iface->get_wwan_hardware_enabled = nmdbus_manager_proxy_get_wwan_hardware_enabled;
  iface->get_wimax_enabled = nmdbus_manager_proxy_get_wimax_enabled;
  iface->get_wimax_hardware_enabled = nmdbus_manager_proxy_get_wimax_hardware_enabled;
  iface->get_radio_flags = nmdbus_manager_proxy_get_radio_flags;
  iface->get_active_connections = nmdbus_manager_proxy_get_active_connections;
  iface->get_primary_connection = nmdbus_manager_proxy_get_primary_connection;
  iface->get_primary_connection_type = nmdbus_manager_proxy_get_primary_connection_type;
  iface->get_metered = nmdbus_manager_proxy_get_metered;
  iface->get_activating_connection = nmdbus_manager_proxy_get_activating_connection;
  iface->get_startup = nmdbus_manager_proxy_get_startup;
  iface->get_version = nmdbus_manager_proxy_get_version;
  iface->get_version_info = nmdbus_manager_proxy_get_version_info;
  iface->get_capabilities = nmdbus_manager_proxy_get_capabilities;
  iface->get_state = nmdbus_manager_proxy_get_state;
  iface->get_connectivity = nmdbus_manager_proxy_get_connectivity;
  iface->get_connectivity_check_available = nmdbus_manager_proxy_get_connectivity_check_available;
  iface->get_connectivity_check_enabled = nmdbus_manager_proxy_get_connectivity_check_enabled;
  iface->get_connectivity_check_uri = nmdbus_manager_proxy_get_connectivity_check_uri;
  iface->get_global_dns_configuration = nmdbus_manager_proxy_get_global_dns_configuration;
}

/**
 * nmdbus_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager.top_of_page">org.freedesktop.NetworkManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_proxy_new_finish() to get the result of the operation.
 *
 * See nmdbus_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager", NULL);
}

/**
 * nmdbus_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_manager_proxy_new().
 *
 * Returns: (transfer full) (type NMDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusManager *
nmdbus_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_MANAGER (ret);
  else
    return NULL;
}

/**
 * nmdbus_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager.top_of_page">org.freedesktop.NetworkManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusManager *
nmdbus_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager", NULL);
  if (ret != NULL)
    return NMDBUS_MANAGER (ret);
  else
    return NULL;
}


/**
 * nmdbus_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nmdbus_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nmdbus_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager", NULL);
}

/**
 * nmdbus_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NMDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusManager *
nmdbus_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_MANAGER (ret);
  else
    return NULL;
}

/**
 * nmdbus_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nmdbus_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusManager *
nmdbus_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager", NULL);
  if (ret != NULL)
    return NMDBUS_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NMDBusManagerSkeleton:
 *
 * The #NMDBusManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusManagerSkeleton.
 */

struct _NMDBusManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nmdbus_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NMDBUS_TYPE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nmdbus_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nmdbus_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nmdbus_manager_skeleton_vtable =
{
  _nmdbus_manager_skeleton_handle_method_call,
  _nmdbus_manager_skeleton_handle_get_property,
  _nmdbus_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nmdbus_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nmdbus_manager_interface_info ();
}

static GDBusInterfaceVTable *
nmdbus_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nmdbus_manager_skeleton_vtable;
}

static GVariant *
nmdbus_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nmdbus_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nmdbus_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nmdbus_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nmdbus_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nmdbus_manager_emit_changed (gpointer user_data);

static void
nmdbus_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nmdbus_manager_emit_changed (skeleton);
}

static void
_nmdbus_manager_on_signal_check_permissions (
    NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager", "CheckPermissions",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_manager_on_signal_state_changed (
    NMDBusManager *object,
    guint arg_state)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_manager_on_signal_device_added (
    NMDBusManager *object,
    const gchar *arg_device_path)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_device_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager", "DeviceAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_manager_on_signal_device_removed (
    NMDBusManager *object,
    const gchar *arg_device_path)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_device_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager", "DeviceRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void nmdbus_manager_skeleton_iface_init (NMDBusManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusManagerSkeleton, nmdbus_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NMDBusManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_MANAGER, nmdbus_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusManagerSkeleton, nmdbus_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_MANAGER, nmdbus_manager_skeleton_iface_init))

#endif
static void
nmdbus_manager_skeleton_finalize (GObject *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 26; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nmdbus_manager_skeleton_parent_class)->finalize (object);
}

static void
nmdbus_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 26);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nmdbus_manager_emit_changed (gpointer user_data)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.NetworkManager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nmdbus_manager_schedule_emit_changed (NMDBusManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nmdbus_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nmdbus_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nmdbus_manager_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nmdbus_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 26);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_manager_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nmdbus_manager_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nmdbus_manager_skeleton_init (NMDBusManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nmdbus_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NMDBUS_TYPE_MANAGER_SKELETON, NMDBusManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 26);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[15], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[16], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[17], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[18], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[19], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[20], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[21], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[22], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[23], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[24], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[25], G_TYPE_VARIANT);
}

static const gchar *const *
nmdbus_manager_skeleton_get_devices (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
nmdbus_manager_skeleton_get_all_devices (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
nmdbus_manager_skeleton_get_checkpoints (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_networking_enabled (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_wireless_enabled (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_wireless_hardware_enabled (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_wwan_enabled (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_wwan_hardware_enabled (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_wimax_enabled (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_wimax_hardware_enabled (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_manager_skeleton_get_radio_flags (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
nmdbus_manager_skeleton_get_active_connections (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_manager_skeleton_get_primary_connection (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_manager_skeleton_get_primary_connection_type (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_manager_skeleton_get_metered (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_manager_skeleton_get_activating_connection (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[15]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_startup (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[16]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_manager_skeleton_get_version (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[17]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nmdbus_manager_skeleton_get_version_info (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[18]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nmdbus_manager_skeleton_get_capabilities (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[19]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_manager_skeleton_get_state (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[20]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_manager_skeleton_get_connectivity (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[21]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_connectivity_check_available (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[22]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_manager_skeleton_get_connectivity_check_enabled (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[23]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_manager_skeleton_get_connectivity_check_uri (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[24]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nmdbus_manager_skeleton_get_global_dns_configuration (NMDBusManager *object)
{
  NMDBusManagerSkeleton *skeleton = NMDBUS_MANAGER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[25]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nmdbus_manager_skeleton_class_init (NMDBusManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nmdbus_manager_skeleton_finalize;
  gobject_class->get_property = nmdbus_manager_skeleton_get_property;
  gobject_class->set_property = nmdbus_manager_skeleton_set_property;
  gobject_class->notify       = nmdbus_manager_skeleton_notify;


  nmdbus_manager_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nmdbus_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nmdbus_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nmdbus_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nmdbus_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusManagerSkeletonPrivate));
#endif
}

static void
nmdbus_manager_skeleton_iface_init (NMDBusManagerIface *iface)
{
  iface->check_permissions = _nmdbus_manager_on_signal_check_permissions;
  iface->state_changed = _nmdbus_manager_on_signal_state_changed;
  iface->device_added = _nmdbus_manager_on_signal_device_added;
  iface->device_removed = _nmdbus_manager_on_signal_device_removed;
  iface->get_devices = nmdbus_manager_skeleton_get_devices;
  iface->get_all_devices = nmdbus_manager_skeleton_get_all_devices;
  iface->get_checkpoints = nmdbus_manager_skeleton_get_checkpoints;
  iface->get_networking_enabled = nmdbus_manager_skeleton_get_networking_enabled;
  iface->get_wireless_enabled = nmdbus_manager_skeleton_get_wireless_enabled;
  iface->get_wireless_hardware_enabled = nmdbus_manager_skeleton_get_wireless_hardware_enabled;
  iface->get_wwan_enabled = nmdbus_manager_skeleton_get_wwan_enabled;
  iface->get_wwan_hardware_enabled = nmdbus_manager_skeleton_get_wwan_hardware_enabled;
  iface->get_wimax_enabled = nmdbus_manager_skeleton_get_wimax_enabled;
  iface->get_wimax_hardware_enabled = nmdbus_manager_skeleton_get_wimax_hardware_enabled;
  iface->get_radio_flags = nmdbus_manager_skeleton_get_radio_flags;
  iface->get_active_connections = nmdbus_manager_skeleton_get_active_connections;
  iface->get_primary_connection = nmdbus_manager_skeleton_get_primary_connection;
  iface->get_primary_connection_type = nmdbus_manager_skeleton_get_primary_connection_type;
  iface->get_metered = nmdbus_manager_skeleton_get_metered;
  iface->get_activating_connection = nmdbus_manager_skeleton_get_activating_connection;
  iface->get_startup = nmdbus_manager_skeleton_get_startup;
  iface->get_version = nmdbus_manager_skeleton_get_version;
  iface->get_version_info = nmdbus_manager_skeleton_get_version_info;
  iface->get_capabilities = nmdbus_manager_skeleton_get_capabilities;
  iface->get_state = nmdbus_manager_skeleton_get_state;
  iface->get_connectivity = nmdbus_manager_skeleton_get_connectivity;
  iface->get_connectivity_check_available = nmdbus_manager_skeleton_get_connectivity_check_available;
  iface->get_connectivity_check_enabled = nmdbus_manager_skeleton_get_connectivity_check_enabled;
  iface->get_connectivity_check_uri = nmdbus_manager_skeleton_get_connectivity_check_uri;
  iface->get_global_dns_configuration = nmdbus_manager_skeleton_get_global_dns_configuration;
}

/**
 * nmdbus_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager.top_of_page">org.freedesktop.NetworkManager</link>.
 *
 * Returns: (transfer full) (type NMDBusManagerSkeleton): The skeleton object.
 */
NMDBusManager *
nmdbus_manager_skeleton_new (void)
{
  return NMDBUS_MANAGER (g_object_new (NMDBUS_TYPE_MANAGER_SKELETON, NULL));
}

