/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "org.freedesktop.NetworkManager.Device.IPTunnel.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.NetworkManager.Device.IPTunnel
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NMDBusDeviceIPTunnel
 * @title: NMDBusDeviceIPTunnel
 * @short_description: Generated C code for the org.freedesktop.NetworkManager.Device.IPTunnel D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-IPTunnel.top_of_page">org.freedesktop.NetworkManager.Device.IPTunnel</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.NetworkManager.Device.IPTunnel ---- */

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_mode =
{
  {
    -1,
    (gchar *) "Mode",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "mode",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_parent =
{
  {
    -1,
    (gchar *) "Parent",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "parent",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_local =
{
  {
    -1,
    (gchar *) "Local",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "local",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_remote =
{
  {
    -1,
    (gchar *) "Remote",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "remote",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_ttl =
{
  {
    -1,
    (gchar *) "Ttl",
    (gchar *) "y",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "ttl",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_tos =
{
  {
    -1,
    (gchar *) "Tos",
    (gchar *) "y",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tos",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_path_mtu_discovery =
{
  {
    -1,
    (gchar *) "PathMtuDiscovery",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "path-mtu-discovery",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_input_key =
{
  {
    -1,
    (gchar *) "InputKey",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "input-key",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_output_key =
{
  {
    -1,
    (gchar *) "OutputKey",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "output-key",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_encapsulation_limit =
{
  {
    -1,
    (gchar *) "EncapsulationLimit",
    (gchar *) "y",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "encapsulation-limit",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_flow_label =
{
  {
    -1,
    (gchar *) "FlowLabel",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "flow-label",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_fw_mark =
{
  {
    -1,
    (gchar *) "FwMark",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "fw-mark",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_iptunnel_property_info_flags =
{
  {
    -1,
    (gchar *) "Flags",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "flags",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nmdbus_device_iptunnel_property_info_pointers[] =
{
  &_nmdbus_device_iptunnel_property_info_mode.parent_struct,
  &_nmdbus_device_iptunnel_property_info_parent.parent_struct,
  &_nmdbus_device_iptunnel_property_info_local.parent_struct,
  &_nmdbus_device_iptunnel_property_info_remote.parent_struct,
  &_nmdbus_device_iptunnel_property_info_ttl.parent_struct,
  &_nmdbus_device_iptunnel_property_info_tos.parent_struct,
  &_nmdbus_device_iptunnel_property_info_path_mtu_discovery.parent_struct,
  &_nmdbus_device_iptunnel_property_info_input_key.parent_struct,
  &_nmdbus_device_iptunnel_property_info_output_key.parent_struct,
  &_nmdbus_device_iptunnel_property_info_encapsulation_limit.parent_struct,
  &_nmdbus_device_iptunnel_property_info_flow_label.parent_struct,
  &_nmdbus_device_iptunnel_property_info_fw_mark.parent_struct,
  &_nmdbus_device_iptunnel_property_info_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nmdbus_device_iptunnel_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.NetworkManager.Device.IPTunnel",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_nmdbus_device_iptunnel_property_info_pointers,
    NULL
  },
  "device-iptunnel",
};


/**
 * nmdbus_device_iptunnel_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-IPTunnel.top_of_page">org.freedesktop.NetworkManager.Device.IPTunnel</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nmdbus_device_iptunnel_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nmdbus_device_iptunnel_interface_info.parent_struct;
}

/**
 * nmdbus_device_iptunnel_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NMDBusDeviceIPTunnel interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nmdbus_device_iptunnel_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "mode");
  g_object_class_override_property (klass, property_id_begin++, "parent");
  g_object_class_override_property (klass, property_id_begin++, "local");
  g_object_class_override_property (klass, property_id_begin++, "remote");
  g_object_class_override_property (klass, property_id_begin++, "ttl");
  g_object_class_override_property (klass, property_id_begin++, "tos");
  g_object_class_override_property (klass, property_id_begin++, "path-mtu-discovery");
  g_object_class_override_property (klass, property_id_begin++, "input-key");
  g_object_class_override_property (klass, property_id_begin++, "output-key");
  g_object_class_override_property (klass, property_id_begin++, "encapsulation-limit");
  g_object_class_override_property (klass, property_id_begin++, "flow-label");
  g_object_class_override_property (klass, property_id_begin++, "fw-mark");
  g_object_class_override_property (klass, property_id_begin++, "flags");
  return property_id_begin - 1;
}



/**
 * NMDBusDeviceIPTunnel:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-IPTunnel.top_of_page">org.freedesktop.NetworkManager.Device.IPTunnel</link>.
 */

/**
 * NMDBusDeviceIPTunnelIface:
 * @parent_iface: The parent interface.
 * @get_encapsulation_limit: Getter for the #NMDBusDeviceIPTunnel:encapsulation-limit property.
 * @get_flags: Getter for the #NMDBusDeviceIPTunnel:flags property.
 * @get_flow_label: Getter for the #NMDBusDeviceIPTunnel:flow-label property.
 * @get_fw_mark: Getter for the #NMDBusDeviceIPTunnel:fw-mark property.
 * @get_input_key: Getter for the #NMDBusDeviceIPTunnel:input-key property.
 * @get_local: Getter for the #NMDBusDeviceIPTunnel:local property.
 * @get_mode: Getter for the #NMDBusDeviceIPTunnel:mode property.
 * @get_output_key: Getter for the #NMDBusDeviceIPTunnel:output-key property.
 * @get_parent: Getter for the #NMDBusDeviceIPTunnel:parent property.
 * @get_path_mtu_discovery: Getter for the #NMDBusDeviceIPTunnel:path-mtu-discovery property.
 * @get_remote: Getter for the #NMDBusDeviceIPTunnel:remote property.
 * @get_tos: Getter for the #NMDBusDeviceIPTunnel:tos property.
 * @get_ttl: Getter for the #NMDBusDeviceIPTunnel:ttl property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-IPTunnel.top_of_page">org.freedesktop.NetworkManager.Device.IPTunnel</link>.
 */

typedef NMDBusDeviceIPTunnelIface NMDBusDeviceIPTunnelInterface;
G_DEFINE_INTERFACE (NMDBusDeviceIPTunnel, nmdbus_device_iptunnel, G_TYPE_OBJECT)

static void
nmdbus_device_iptunnel_default_init (NMDBusDeviceIPTunnelIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * NMDBusDeviceIPTunnel:mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Mode">"Mode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("mode", "Mode", "Mode", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:parent:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Parent">"Parent"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("parent", "Parent", "Parent", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:local:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Local">"Local"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("local", "Local", "Local", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:remote:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Remote">"Remote"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("remote", "Remote", "Remote", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:ttl:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Ttl">"Ttl"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uchar ("ttl", "Ttl", "Ttl", 0, 255, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:tos:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Tos">"Tos"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uchar ("tos", "Tos", "Tos", 0, 255, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:path-mtu-discovery:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.PathMtuDiscovery">"PathMtuDiscovery"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("path-mtu-discovery", "PathMtuDiscovery", "PathMtuDiscovery", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:input-key:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.InputKey">"InputKey"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("input-key", "InputKey", "InputKey", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:output-key:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.OutputKey">"OutputKey"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("output-key", "OutputKey", "OutputKey", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:encapsulation-limit:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.EncapsulationLimit">"EncapsulationLimit"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uchar ("encapsulation-limit", "EncapsulationLimit", "EncapsulationLimit", 0, 255, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:flow-label:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.FlowLabel">"FlowLabel"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("flow-label", "FlowLabel", "FlowLabel", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:fw-mark:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.FwMark">"FwMark"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("fw-mark", "FwMark", "FwMark", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceIPTunnel:flags:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Flags">"Flags"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("flags", "Flags", "Flags", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nmdbus_device_iptunnel_get_mode: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Mode">"Mode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_iptunnel_get_mode (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), 0);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_mode (object);
}

/**
 * nmdbus_device_iptunnel_set_mode: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Mode">"Mode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_mode (NMDBusDeviceIPTunnel *object, guint value)
{
  g_object_set (G_OBJECT (object), "mode", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_parent: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Parent">"Parent"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_iptunnel_dup_parent() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_iptunnel_get_parent (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), NULL);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_parent (object);
}

/**
 * nmdbus_device_iptunnel_dup_parent: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Parent">"Parent"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_iptunnel_dup_parent (NMDBusDeviceIPTunnel *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "parent", &value, NULL);
  return value;
}

/**
 * nmdbus_device_iptunnel_set_parent: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Parent">"Parent"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_parent (NMDBusDeviceIPTunnel *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "parent", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_local: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Local">"Local"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_iptunnel_dup_local() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_iptunnel_get_local (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), NULL);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_local (object);
}

/**
 * nmdbus_device_iptunnel_dup_local: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Local">"Local"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_iptunnel_dup_local (NMDBusDeviceIPTunnel *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "local", &value, NULL);
  return value;
}

/**
 * nmdbus_device_iptunnel_set_local: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Local">"Local"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_local (NMDBusDeviceIPTunnel *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "local", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_remote: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Remote">"Remote"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_iptunnel_dup_remote() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_iptunnel_get_remote (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), NULL);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_remote (object);
}

/**
 * nmdbus_device_iptunnel_dup_remote: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Remote">"Remote"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_iptunnel_dup_remote (NMDBusDeviceIPTunnel *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "remote", &value, NULL);
  return value;
}

/**
 * nmdbus_device_iptunnel_set_remote: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Remote">"Remote"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_remote (NMDBusDeviceIPTunnel *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "remote", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_ttl: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Ttl">"Ttl"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guchar 
nmdbus_device_iptunnel_get_ttl (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), '\0');

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_ttl (object);
}

/**
 * nmdbus_device_iptunnel_set_ttl: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Ttl">"Ttl"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_ttl (NMDBusDeviceIPTunnel *object, guchar value)
{
  g_object_set (G_OBJECT (object), "ttl", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_tos: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Tos">"Tos"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guchar 
nmdbus_device_iptunnel_get_tos (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), '\0');

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_tos (object);
}

/**
 * nmdbus_device_iptunnel_set_tos: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Tos">"Tos"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_tos (NMDBusDeviceIPTunnel *object, guchar value)
{
  g_object_set (G_OBJECT (object), "tos", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_path_mtu_discovery: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.PathMtuDiscovery">"PathMtuDiscovery"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
nmdbus_device_iptunnel_get_path_mtu_discovery (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), FALSE);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_path_mtu_discovery (object);
}

/**
 * nmdbus_device_iptunnel_set_path_mtu_discovery: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.PathMtuDiscovery">"PathMtuDiscovery"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_path_mtu_discovery (NMDBusDeviceIPTunnel *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "path-mtu-discovery", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_input_key: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.InputKey">"InputKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_iptunnel_dup_input_key() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_iptunnel_get_input_key (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), NULL);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_input_key (object);
}

/**
 * nmdbus_device_iptunnel_dup_input_key: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.InputKey">"InputKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_iptunnel_dup_input_key (NMDBusDeviceIPTunnel *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "input-key", &value, NULL);
  return value;
}

/**
 * nmdbus_device_iptunnel_set_input_key: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.InputKey">"InputKey"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_input_key (NMDBusDeviceIPTunnel *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "input-key", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_output_key: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.OutputKey">"OutputKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_iptunnel_dup_output_key() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_iptunnel_get_output_key (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), NULL);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_output_key (object);
}

/**
 * nmdbus_device_iptunnel_dup_output_key: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.OutputKey">"OutputKey"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_iptunnel_dup_output_key (NMDBusDeviceIPTunnel *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "output-key", &value, NULL);
  return value;
}

/**
 * nmdbus_device_iptunnel_set_output_key: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.OutputKey">"OutputKey"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_output_key (NMDBusDeviceIPTunnel *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "output-key", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_encapsulation_limit: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.EncapsulationLimit">"EncapsulationLimit"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guchar 
nmdbus_device_iptunnel_get_encapsulation_limit (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), '\0');

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_encapsulation_limit (object);
}

/**
 * nmdbus_device_iptunnel_set_encapsulation_limit: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.EncapsulationLimit">"EncapsulationLimit"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_encapsulation_limit (NMDBusDeviceIPTunnel *object, guchar value)
{
  g_object_set (G_OBJECT (object), "encapsulation-limit", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_flow_label: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.FlowLabel">"FlowLabel"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_iptunnel_get_flow_label (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), 0);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_flow_label (object);
}

/**
 * nmdbus_device_iptunnel_set_flow_label: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.FlowLabel">"FlowLabel"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_flow_label (NMDBusDeviceIPTunnel *object, guint value)
{
  g_object_set (G_OBJECT (object), "flow-label", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_fw_mark: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.FwMark">"FwMark"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_iptunnel_get_fw_mark (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), 0);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_fw_mark (object);
}

/**
 * nmdbus_device_iptunnel_set_fw_mark: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.FwMark">"FwMark"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_fw_mark (NMDBusDeviceIPTunnel *object, guint value)
{
  g_object_set (G_OBJECT (object), "fw-mark", value, NULL);
}

/**
 * nmdbus_device_iptunnel_get_flags: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Flags">"Flags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_iptunnel_get_flags (NMDBusDeviceIPTunnel *object)
{
  g_return_val_if_fail (NMDBUS_IS_DEVICE_IPTUNNEL (object), 0);

  return NMDBUS_DEVICE_IPTUNNEL_GET_IFACE (object)->get_flags (object);
}

/**
 * nmdbus_device_iptunnel_set_flags: (skip)
 * @object: A #NMDBusDeviceIPTunnel.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-IPTunnel.Flags">"Flags"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_iptunnel_set_flags (NMDBusDeviceIPTunnel *object, guint value)
{
  g_object_set (G_OBJECT (object), "flags", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * NMDBusDeviceIPTunnelProxy:
 *
 * The #NMDBusDeviceIPTunnelProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusDeviceIPTunnelProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusDeviceIPTunnelProxy.
 */

struct _NMDBusDeviceIPTunnelProxyPrivate
{
  GData *qdata;
};

static void nmdbus_device_iptunnel_proxy_iface_init (NMDBusDeviceIPTunnelIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceIPTunnelProxy, nmdbus_device_iptunnel_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NMDBusDeviceIPTunnelProxy)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE_IPTUNNEL, nmdbus_device_iptunnel_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceIPTunnelProxy, nmdbus_device_iptunnel_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE_IPTUNNEL, nmdbus_device_iptunnel_proxy_iface_init))

#endif
static void
nmdbus_device_iptunnel_proxy_finalize (GObject *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nmdbus_device_iptunnel_proxy_parent_class)->finalize (object);
}

static void
nmdbus_device_iptunnel_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_device_iptunnel_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nmdbus_device_iptunnel_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.NetworkManager.Device.IPTunnel: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nmdbus_device_iptunnel_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_device_iptunnel_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.NetworkManager.Device.IPTunnel", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nmdbus_device_iptunnel_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nmdbus_device_iptunnel_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nmdbus_device_iptunnel_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NMDBUS_TYPE_DEVICE_IPTUNNEL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_DEVICE_IPTUNNEL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nmdbus_device_iptunnel_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_iptunnel_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_iptunnel_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
nmdbus_device_iptunnel_proxy_get_mode (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Mode");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_iptunnel_proxy_get_parent (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Parent");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_iptunnel_proxy_get_local (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Local");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_iptunnel_proxy_get_remote (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Remote");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guchar 
nmdbus_device_iptunnel_proxy_get_ttl (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  guchar value = '\0';
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Ttl");
  if (variant != NULL)
    {
      value = g_variant_get_byte (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guchar 
nmdbus_device_iptunnel_proxy_get_tos (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  guchar value = '\0';
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Tos");
  if (variant != NULL)
    {
      value = g_variant_get_byte (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
nmdbus_device_iptunnel_proxy_get_path_mtu_discovery (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PathMtuDiscovery");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_iptunnel_proxy_get_input_key (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "InputKey");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_iptunnel_proxy_get_output_key (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OutputKey");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guchar 
nmdbus_device_iptunnel_proxy_get_encapsulation_limit (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  guchar value = '\0';
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EncapsulationLimit");
  if (variant != NULL)
    {
      value = g_variant_get_byte (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_iptunnel_proxy_get_flow_label (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FlowLabel");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_iptunnel_proxy_get_fw_mark (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FwMark");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_iptunnel_proxy_get_flags (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelProxy *proxy = NMDBUS_DEVICE_IPTUNNEL_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Flags");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
nmdbus_device_iptunnel_proxy_init (NMDBusDeviceIPTunnelProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nmdbus_device_iptunnel_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NMDBUS_TYPE_DEVICE_IPTUNNEL_PROXY, NMDBusDeviceIPTunnelProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nmdbus_device_iptunnel_interface_info ());
}

static void
nmdbus_device_iptunnel_proxy_class_init (NMDBusDeviceIPTunnelProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nmdbus_device_iptunnel_proxy_finalize;
  gobject_class->get_property = nmdbus_device_iptunnel_proxy_get_property;
  gobject_class->set_property = nmdbus_device_iptunnel_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nmdbus_device_iptunnel_proxy_g_signal;
  proxy_class->g_properties_changed = nmdbus_device_iptunnel_proxy_g_properties_changed;

  nmdbus_device_iptunnel_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusDeviceIPTunnelProxyPrivate));
#endif
}

static void
nmdbus_device_iptunnel_proxy_iface_init (NMDBusDeviceIPTunnelIface *iface)
{
  iface->get_mode = nmdbus_device_iptunnel_proxy_get_mode;
  iface->get_parent = nmdbus_device_iptunnel_proxy_get_parent;
  iface->get_local = nmdbus_device_iptunnel_proxy_get_local;
  iface->get_remote = nmdbus_device_iptunnel_proxy_get_remote;
  iface->get_ttl = nmdbus_device_iptunnel_proxy_get_ttl;
  iface->get_tos = nmdbus_device_iptunnel_proxy_get_tos;
  iface->get_path_mtu_discovery = nmdbus_device_iptunnel_proxy_get_path_mtu_discovery;
  iface->get_input_key = nmdbus_device_iptunnel_proxy_get_input_key;
  iface->get_output_key = nmdbus_device_iptunnel_proxy_get_output_key;
  iface->get_encapsulation_limit = nmdbus_device_iptunnel_proxy_get_encapsulation_limit;
  iface->get_flow_label = nmdbus_device_iptunnel_proxy_get_flow_label;
  iface->get_fw_mark = nmdbus_device_iptunnel_proxy_get_fw_mark;
  iface->get_flags = nmdbus_device_iptunnel_proxy_get_flags;
}

/**
 * nmdbus_device_iptunnel_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-IPTunnel.top_of_page">org.freedesktop.NetworkManager.Device.IPTunnel</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_iptunnel_proxy_new_finish() to get the result of the operation.
 *
 * See nmdbus_device_iptunnel_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_device_iptunnel_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_DEVICE_IPTUNNEL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device.IPTunnel", NULL);
}

/**
 * nmdbus_device_iptunnel_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_iptunnel_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_device_iptunnel_proxy_new().
 *
 * Returns: (transfer full) (type NMDBusDeviceIPTunnelProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDeviceIPTunnel *
nmdbus_device_iptunnel_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_DEVICE_IPTUNNEL (ret);
  else
    return NULL;
}

/**
 * nmdbus_device_iptunnel_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-IPTunnel.top_of_page">org.freedesktop.NetworkManager.Device.IPTunnel</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_iptunnel_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusDeviceIPTunnelProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDeviceIPTunnel *
nmdbus_device_iptunnel_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_DEVICE_IPTUNNEL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device.IPTunnel", NULL);
  if (ret != NULL)
    return NMDBUS_DEVICE_IPTUNNEL (ret);
  else
    return NULL;
}


/**
 * nmdbus_device_iptunnel_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nmdbus_device_iptunnel_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_iptunnel_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nmdbus_device_iptunnel_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_device_iptunnel_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_DEVICE_IPTUNNEL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device.IPTunnel", NULL);
}

/**
 * nmdbus_device_iptunnel_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_iptunnel_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_device_iptunnel_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NMDBusDeviceIPTunnelProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDeviceIPTunnel *
nmdbus_device_iptunnel_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_DEVICE_IPTUNNEL (ret);
  else
    return NULL;
}

/**
 * nmdbus_device_iptunnel_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nmdbus_device_iptunnel_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_iptunnel_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusDeviceIPTunnelProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDeviceIPTunnel *
nmdbus_device_iptunnel_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_DEVICE_IPTUNNEL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device.IPTunnel", NULL);
  if (ret != NULL)
    return NMDBUS_DEVICE_IPTUNNEL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NMDBusDeviceIPTunnelSkeleton:
 *
 * The #NMDBusDeviceIPTunnelSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusDeviceIPTunnelSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusDeviceIPTunnelSkeleton.
 */

struct _NMDBusDeviceIPTunnelSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nmdbus_device_iptunnel_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NMDBUS_TYPE_DEVICE_IPTUNNEL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_DEVICE_IPTUNNEL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nmdbus_device_iptunnel_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_iptunnel_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nmdbus_device_iptunnel_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_iptunnel_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nmdbus_device_iptunnel_skeleton_vtable =
{
  _nmdbus_device_iptunnel_skeleton_handle_method_call,
  _nmdbus_device_iptunnel_skeleton_handle_get_property,
  _nmdbus_device_iptunnel_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nmdbus_device_iptunnel_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nmdbus_device_iptunnel_interface_info ();
}

static GDBusInterfaceVTable *
nmdbus_device_iptunnel_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nmdbus_device_iptunnel_skeleton_vtable;
}

static GVariant *
nmdbus_device_iptunnel_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nmdbus_device_iptunnel_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nmdbus_device_iptunnel_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nmdbus_device_iptunnel_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nmdbus_device_iptunnel_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.Device.IPTunnel", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nmdbus_device_iptunnel_emit_changed (gpointer user_data);

static void
nmdbus_device_iptunnel_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nmdbus_device_iptunnel_emit_changed (skeleton);
}

static void nmdbus_device_iptunnel_skeleton_iface_init (NMDBusDeviceIPTunnelIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceIPTunnelSkeleton, nmdbus_device_iptunnel_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NMDBusDeviceIPTunnelSkeleton)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE_IPTUNNEL, nmdbus_device_iptunnel_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceIPTunnelSkeleton, nmdbus_device_iptunnel_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE_IPTUNNEL, nmdbus_device_iptunnel_skeleton_iface_init))

#endif
static void
nmdbus_device_iptunnel_skeleton_finalize (GObject *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  guint n;
  for (n = 0; n < 13; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nmdbus_device_iptunnel_skeleton_parent_class)->finalize (object);
}

static void
nmdbus_device_iptunnel_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nmdbus_device_iptunnel_emit_changed (gpointer user_data)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.NetworkManager.Device.IPTunnel",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nmdbus_device_iptunnel_schedule_emit_changed (NMDBusDeviceIPTunnelSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nmdbus_device_iptunnel_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nmdbus_device_iptunnel_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nmdbus_device_iptunnel_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nmdbus_device_iptunnel_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_device_iptunnel_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nmdbus_device_iptunnel_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nmdbus_device_iptunnel_skeleton_init (NMDBusDeviceIPTunnelSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nmdbus_device_iptunnel_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NMDBUS_TYPE_DEVICE_IPTUNNEL_SKELETON, NMDBusDeviceIPTunnelSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 13);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_UCHAR);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_UCHAR);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_UCHAR);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_UINT);
}

static guint 
nmdbus_device_iptunnel_skeleton_get_mode (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_iptunnel_skeleton_get_parent (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_iptunnel_skeleton_get_local (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_iptunnel_skeleton_get_remote (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guchar 
nmdbus_device_iptunnel_skeleton_get_ttl (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  guchar value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uchar (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guchar 
nmdbus_device_iptunnel_skeleton_get_tos (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  guchar value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uchar (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
nmdbus_device_iptunnel_skeleton_get_path_mtu_discovery (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_iptunnel_skeleton_get_input_key (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_iptunnel_skeleton_get_output_key (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guchar 
nmdbus_device_iptunnel_skeleton_get_encapsulation_limit (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  guchar value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uchar (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_iptunnel_skeleton_get_flow_label (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_iptunnel_skeleton_get_fw_mark (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_iptunnel_skeleton_get_flags (NMDBusDeviceIPTunnel *object)
{
  NMDBusDeviceIPTunnelSkeleton *skeleton = NMDBUS_DEVICE_IPTUNNEL_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nmdbus_device_iptunnel_skeleton_class_init (NMDBusDeviceIPTunnelSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nmdbus_device_iptunnel_skeleton_finalize;
  gobject_class->get_property = nmdbus_device_iptunnel_skeleton_get_property;
  gobject_class->set_property = nmdbus_device_iptunnel_skeleton_set_property;
  gobject_class->notify       = nmdbus_device_iptunnel_skeleton_notify;


  nmdbus_device_iptunnel_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nmdbus_device_iptunnel_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nmdbus_device_iptunnel_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nmdbus_device_iptunnel_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nmdbus_device_iptunnel_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusDeviceIPTunnelSkeletonPrivate));
#endif
}

static void
nmdbus_device_iptunnel_skeleton_iface_init (NMDBusDeviceIPTunnelIface *iface)
{
  iface->get_mode = nmdbus_device_iptunnel_skeleton_get_mode;
  iface->get_parent = nmdbus_device_iptunnel_skeleton_get_parent;
  iface->get_local = nmdbus_device_iptunnel_skeleton_get_local;
  iface->get_remote = nmdbus_device_iptunnel_skeleton_get_remote;
  iface->get_ttl = nmdbus_device_iptunnel_skeleton_get_ttl;
  iface->get_tos = nmdbus_device_iptunnel_skeleton_get_tos;
  iface->get_path_mtu_discovery = nmdbus_device_iptunnel_skeleton_get_path_mtu_discovery;
  iface->get_input_key = nmdbus_device_iptunnel_skeleton_get_input_key;
  iface->get_output_key = nmdbus_device_iptunnel_skeleton_get_output_key;
  iface->get_encapsulation_limit = nmdbus_device_iptunnel_skeleton_get_encapsulation_limit;
  iface->get_flow_label = nmdbus_device_iptunnel_skeleton_get_flow_label;
  iface->get_fw_mark = nmdbus_device_iptunnel_skeleton_get_fw_mark;
  iface->get_flags = nmdbus_device_iptunnel_skeleton_get_flags;
}

/**
 * nmdbus_device_iptunnel_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-IPTunnel.top_of_page">org.freedesktop.NetworkManager.Device.IPTunnel</link>.
 *
 * Returns: (transfer full) (type NMDBusDeviceIPTunnelSkeleton): The skeleton object.
 */
NMDBusDeviceIPTunnel *
nmdbus_device_iptunnel_skeleton_new (void)
{
  return NMDBUS_DEVICE_IPTUNNEL (g_object_new (NMDBUS_TYPE_DEVICE_IPTUNNEL_SKELETON, NULL));
}

