// This file is generated by kconfig_compiler_kf6 from soundthemesettings.kcfg.
// All changes you do to this file will be lost.
#ifndef SOUNDTHEMESETTINGS_H
#define SOUNDTHEMESETTINGS_H

#include <qglobal.h>
#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class SoundThemeSettings : public KConfigSkeleton
{
  Q_OBJECT
  public:

    SoundThemeSettings( QObject *parent = nullptr );
    ~SoundThemeSettings() override;

    /**
      Set Theme
    */
    void setTheme( const QString & v )
    {
      if (v != mTheme && !isThemeImmutable()) {
        mTheme = v;
        Q_EMIT themeChanged();
      }
    }

    Q_PROPERTY(QString theme READ theme WRITE setTheme NOTIFY themeChanged)
    Q_PROPERTY(bool isThemeImmutable READ isThemeImmutable CONSTANT)
    /**
      Get Theme
    */
    QString theme() const
    {
      return mTheme;
    }

    /**
      Is Theme Immutable
    */
    bool isThemeImmutable() const
    {
      return isImmutable( QStringLiteral( "theme" ) );
    }

    /**
      Get Theme default value
    */
    QString defaultThemeValue() const
    {
        return defaultThemeValue_helper();
    }

    /**
      Set Enable
    */
    void setSoundsEnabled( bool v )
    {
      if (v != mSoundsEnabled && !isSoundsEnabledImmutable()) {
        mSoundsEnabled = v;
        Q_EMIT soundsEnabledChanged();
      }
    }

    Q_PROPERTY(bool soundsEnabled READ soundsEnabled WRITE setSoundsEnabled NOTIFY soundsEnabledChanged)
    Q_PROPERTY(bool isSoundsEnabledImmutable READ isSoundsEnabledImmutable CONSTANT)
    /**
      Get Enable
    */
    bool soundsEnabled() const
    {
      return mSoundsEnabled;
    }

    /**
      Is Enable Immutable
    */
    bool isSoundsEnabledImmutable() const
    {
      return isImmutable( QStringLiteral( "soundsEnabled" ) );
    }

    /**
      Get Enable default value
    */
    bool defaultSoundsEnabledValue() const
    {
        return defaultSoundsEnabledValue_helper();
    }


    enum {
      signalThemeChanged = 1,
      signalSoundsEnabledChanged = 2
    };

  Q_SIGNALS:
    void themeChanged();

    void soundsEnabledChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:

    // Sounds
    QString mTheme;
    QString defaultThemeValue_helper() const;
    bool mSoundsEnabled;
    bool defaultSoundsEnabledValue_helper() const;

  private:
};

#endif

