// This file is generated by kconfig_compiler_kf6 from cursorthemesettings.kcfg.
// All changes you do to this file will be lost.
#ifndef CURSORTHEMESETTINGS_H
#define CURSORTHEMESETTINGS_H

#include <qglobal.h>
#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class CursorThemeSettings : public KConfigSkeleton
{
  Q_OBJECT
  public:

    CursorThemeSettings( QObject *parent = nullptr );
    ~CursorThemeSettings() override;

    /**
      Set Name of the current cursor theme
    */
    void setCursorTheme( const QString & v )
    {
      if (v != mCursorTheme && !isCursorThemeImmutable()) {
        mCursorTheme = v;
        Q_EMIT cursorThemeChanged();
      }
    }

    Q_PROPERTY(QString cursorTheme READ cursorTheme WRITE setCursorTheme NOTIFY cursorThemeChanged)
    Q_PROPERTY(bool isCursorThemeImmutable READ isCursorThemeImmutable CONSTANT)
    /**
      Get Name of the current cursor theme
    */
    QString cursorTheme() const
    {
      return mCursorTheme;
    }

    /**
      Is Name of the current cursor theme Immutable
    */
    bool isCursorThemeImmutable() const
    {
      return isImmutable( QStringLiteral( "cursorTheme" ) );
    }

    /**
      Get Name of the current cursor theme default value
    */
    QString defaultCursorThemeValue() const
    {
        return defaultCursorThemeValue_helper();
    }

    /**
      Set Current cursor size
    */
    void setCursorSize( int v )
    {
      if (v != mCursorSize && !isCursorSizeImmutable()) {
        mCursorSize = v;
        Q_EMIT cursorSizeChanged();
      }
    }

    Q_PROPERTY(int cursorSize READ cursorSize WRITE setCursorSize NOTIFY cursorSizeChanged)
    Q_PROPERTY(bool isCursorSizeImmutable READ isCursorSizeImmutable CONSTANT)
    /**
      Get Current cursor size
    */
    int cursorSize() const
    {
      return mCursorSize;
    }

    /**
      Is Current cursor size Immutable
    */
    bool isCursorSizeImmutable() const
    {
      return isImmutable( QStringLiteral( "cursorSize" ) );
    }

    /**
      Get Current cursor size default value
    */
    int defaultCursorSizeValue() const
    {
        return defaultCursorSizeValue_helper();
    }


    enum {
      signalCursorThemeChanged = 1,
      signalCursorSizeChanged = 2
    };

  Q_SIGNALS:
    void cursorThemeChanged();

    void cursorSizeChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:

    // Mouse
    QString mCursorTheme;
    QString defaultCursorThemeValue_helper() const;
    int mCursorSize;
    int defaultCursorSizeValue_helper() const;

  private:
};

#endif

