// This file is generated by kconfig_compiler_kf6 from touchpadparameters.kcfg.
// All changes you do to this file will be lost.
#ifndef TOUCHPADPARAMETERS_H
#define TOUCHPADPARAMETERS_H

#include "touchpadparametersbase.h"

#include <qglobal.h>
#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class TouchpadParameters : public TouchpadParametersBase
{
  public:
    enum Button { NoButton, LeftButton, MiddleButton, RightButton };
    enum EnumTapAction { OneFingerTap, TwoFingerTap, ThreeFingerTap, LTCorner, LBCorner, RTCorner, RBCorner };
    static const char* const EnumTapActionToString[];
    enum Edge { AllEdges, TopEdge, TopRightCorner, RightEdge, BottomRightCorner, BottomEdge, BottomLeftCorner, LeftEdge, TopLeftCorner };

    TouchpadParameters( );
    ~TouchpadParameters() override;

    /**
      Set Tapping
    */
    void setTapping( bool v )
    {
      if (!isTappingImmutable())
        mTapping = v;
    }

    /**
      Get Tapping
    */
    bool tapping() const
    {
      return mTapping;
    }

    /**
      Is Tapping Immutable
    */
    bool isTappingImmutable() const
    {
      return isImmutable( QStringLiteral( "Tapping" ) );
    }

    /**
      Set $(TapAction)Button
    */
    void setButton( int i, Button v )
    {
      if (!isButtonImmutable( i ))
        mButton[i] = v;
    }

    /**
      Get $(TapAction)Button
    */
    Button button( int i ) const
    {
      return static_cast<Button>(mButton[i]);
    }

    /**
      Is $(TapAction)Button Immutable
    */
    bool isButtonImmutable( int i ) const
    {
      return isImmutable( QStringLiteral( "%1Button" ).arg( QLatin1String( EnumTapActionToString[i] ) ) );
    }

    /**
      Set VertEdgeScroll
    */
    void setVertEdgeScroll( bool v )
    {
      if (!isVertEdgeScrollImmutable())
        mVertEdgeScroll = v;
    }

    /**
      Get VertEdgeScroll
    */
    bool vertEdgeScroll() const
    {
      return mVertEdgeScroll;
    }

    /**
      Is VertEdgeScroll Immutable
    */
    bool isVertEdgeScrollImmutable() const
    {
      return isImmutable( QStringLiteral( "VertEdgeScroll" ) );
    }

    /**
      Set VertTwoFingerScroll
    */
    void setVertTwoFingerScroll( bool v )
    {
      if (!isVertTwoFingerScrollImmutable())
        mVertTwoFingerScroll = v;
    }

    /**
      Get VertTwoFingerScroll
    */
    bool vertTwoFingerScroll() const
    {
      return mVertTwoFingerScroll;
    }

    /**
      Is VertTwoFingerScroll Immutable
    */
    bool isVertTwoFingerScrollImmutable() const
    {
      return isImmutable( QStringLiteral( "VertTwoFingerScroll" ) );
    }

    /**
      Set HorizEdgeScroll
    */
    void setHorizEdgeScroll( bool v )
    {
      if (!isHorizEdgeScrollImmutable())
        mHorizEdgeScroll = v;
    }

    /**
      Get HorizEdgeScroll
    */
    bool horizEdgeScroll() const
    {
      return mHorizEdgeScroll;
    }

    /**
      Is HorizEdgeScroll Immutable
    */
    bool isHorizEdgeScrollImmutable() const
    {
      return isImmutable( QStringLiteral( "HorizEdgeScroll" ) );
    }

    /**
      Set HorizTwoFingerScroll
    */
    void setHorizTwoFingerScroll( bool v )
    {
      if (!isHorizTwoFingerScrollImmutable())
        mHorizTwoFingerScroll = v;
    }

    /**
      Get HorizTwoFingerScroll
    */
    bool horizTwoFingerScroll() const
    {
      return mHorizTwoFingerScroll;
    }

    /**
      Is HorizTwoFingerScroll Immutable
    */
    bool isHorizTwoFingerScrollImmutable() const
    {
      return isImmutable( QStringLiteral( "HorizTwoFingerScroll" ) );
    }

    /**
      Set MinSpeed
    */
    void setMinSpeed( double v )
    {
      if (v < 0)
      {
        qDebug() << "setMinSpeed: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 255)
      {
        qDebug() << "setMinSpeed: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isMinSpeedImmutable())
        mMinSpeed = v;
    }

    /**
      Get MinSpeed
    */
    double minSpeed() const
    {
      return mMinSpeed;
    }

    /**
      Is MinSpeed Immutable
    */
    bool isMinSpeedImmutable() const
    {
      return isImmutable( QStringLiteral( "MinSpeed" ) );
    }

    /**
      Set MaxSpeed
    */
    void setMaxSpeed( double v )
    {
      if (v < 0)
      {
        qDebug() << "setMaxSpeed: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 255)
      {
        qDebug() << "setMaxSpeed: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isMaxSpeedImmutable())
        mMaxSpeed = v;
    }

    /**
      Get MaxSpeed
    */
    double maxSpeed() const
    {
      return mMaxSpeed;
    }

    /**
      Is MaxSpeed Immutable
    */
    bool isMaxSpeedImmutable() const
    {
      return isImmutable( QStringLiteral( "MaxSpeed" ) );
    }

    /**
      Set AccelFactor
    */
    void setAccelFactor( double v )
    {
      if (v < 0)
      {
        qDebug() << "setAccelFactor: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1)
      {
        qDebug() << "setAccelFactor: value " << v << " is greater than the maximum value of 1";
        v = 1;
      }

      if (!isAccelFactorImmutable())
        mAccelFactor = v;
    }

    /**
      Get AccelFactor
    */
    double accelFactor() const
    {
      return mAccelFactor;
    }

    /**
      Is AccelFactor Immutable
    */
    bool isAccelFactorImmutable() const
    {
      return isImmutable( QStringLiteral( "AccelFactor" ) );
    }

    /**
      Set HorizHysteresis
    */
    void setHorizHysteresis( int v )
    {
      if (v < 0)
      {
        qDebug() << "setHorizHysteresis: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 100)
      {
        qDebug() << "setHorizHysteresis: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (!isHorizHysteresisImmutable())
        mHorizHysteresis = v;
    }

    /**
      Get HorizHysteresis
    */
    int horizHysteresis() const
    {
      return mHorizHysteresis;
    }

    /**
      Is HorizHysteresis Immutable
    */
    bool isHorizHysteresisImmutable() const
    {
      return isImmutable( QStringLiteral( "HorizHysteresis" ) );
    }

    /**
      Set VertHysteresis
    */
    void setVertHysteresis( int v )
    {
      if (v < 0)
      {
        qDebug() << "setVertHysteresis: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 100)
      {
        qDebug() << "setVertHysteresis: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (!isVertHysteresisImmutable())
        mVertHysteresis = v;
    }

    /**
      Get VertHysteresis
    */
    int vertHysteresis() const
    {
      return mVertHysteresis;
    }

    /**
      Is VertHysteresis Immutable
    */
    bool isVertHysteresisImmutable() const
    {
      return isImmutable( QStringLiteral( "VertHysteresis" ) );
    }

    /**
      Set TapAndDragGesture
    */
    void setTapAndDragGesture( bool v )
    {
      if (!isTapAndDragGestureImmutable())
        mTapAndDragGesture = v;
    }

    /**
      Get TapAndDragGesture
    */
    bool tapAndDragGesture() const
    {
      return mTapAndDragGesture;
    }

    /**
      Is TapAndDragGesture Immutable
    */
    bool isTapAndDragGestureImmutable() const
    {
      return isImmutable( QStringLiteral( "TapAndDragGesture" ) );
    }

    /**
      Set LockedDrags
    */
    void setLockedDrags( bool v )
    {
      if (!isLockedDragsImmutable())
        mLockedDrags = v;
    }

    /**
      Get LockedDrags
    */
    bool lockedDrags() const
    {
      return mLockedDrags;
    }

    /**
      Is LockedDrags Immutable
    */
    bool isLockedDragsImmutable() const
    {
      return isImmutable( QStringLiteral( "LockedDrags" ) );
    }

    /**
      Set LockedDragTimeout
    */
    void setLockedDragTimeout( int v )
    {
      if (v < 0)
      {
        qDebug() << "setLockedDragTimeout: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 30000)
      {
        qDebug() << "setLockedDragTimeout: value " << v << " is greater than the maximum value of 30000";
        v = 30000;
      }

      if (!isLockedDragTimeoutImmutable())
        mLockedDragTimeout = v;
    }

    /**
      Get LockedDragTimeout
    */
    int lockedDragTimeout() const
    {
      return mLockedDragTimeout;
    }

    /**
      Is LockedDragTimeout Immutable
    */
    bool isLockedDragTimeoutImmutable() const
    {
      return isImmutable( QStringLiteral( "LockedDragTimeout" ) );
    }

    /**
      Set VertScrollDelta
    */
    void setVertScrollDelta( double v )
    {
      if (v < 0)
      {
        qDebug() << "setVertScrollDelta: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1000)
      {
        qDebug() << "setVertScrollDelta: value " << v << " is greater than the maximum value of 1000";
        v = 1000;
      }

      if (!isVertScrollDeltaImmutable())
        mVertScrollDelta = v;
    }

    /**
      Get VertScrollDelta
    */
    double vertScrollDelta() const
    {
      return mVertScrollDelta;
    }

    /**
      Is VertScrollDelta Immutable
    */
    bool isVertScrollDeltaImmutable() const
    {
      return isImmutable( QStringLiteral( "VertScrollDelta" ) );
    }

    /**
      Set InvertVertScroll
    */
    void setInvertVertScroll( bool v )
    {
      if (!isInvertVertScrollImmutable())
        mInvertVertScroll = v;
    }

    /**
      Get InvertVertScroll
    */
    bool invertVertScroll() const
    {
      return mInvertVertScroll;
    }

    /**
      Is InvertVertScroll Immutable
    */
    bool isInvertVertScrollImmutable() const
    {
      return isImmutable( QStringLiteral( "InvertVertScroll" ) );
    }

    /**
      Set HorizScrollDelta
    */
    void setHorizScrollDelta( double v )
    {
      if (v < 0)
      {
        qDebug() << "setHorizScrollDelta: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1000)
      {
        qDebug() << "setHorizScrollDelta: value " << v << " is greater than the maximum value of 1000";
        v = 1000;
      }

      if (!isHorizScrollDeltaImmutable())
        mHorizScrollDelta = v;
    }

    /**
      Get HorizScrollDelta
    */
    double horizScrollDelta() const
    {
      return mHorizScrollDelta;
    }

    /**
      Is HorizScrollDelta Immutable
    */
    bool isHorizScrollDeltaImmutable() const
    {
      return isImmutable( QStringLiteral( "HorizScrollDelta" ) );
    }

    /**
      Set InvertHorizScroll
    */
    void setInvertHorizScroll( bool v )
    {
      if (!isInvertHorizScrollImmutable())
        mInvertHorizScroll = v;
    }

    /**
      Get InvertHorizScroll
    */
    bool invertHorizScroll() const
    {
      return mInvertHorizScroll;
    }

    /**
      Is InvertHorizScroll Immutable
    */
    bool isInvertHorizScrollImmutable() const
    {
      return isImmutable( QStringLiteral( "InvertHorizScroll" ) );
    }

    /**
      Set CornerCoasting
    */
    void setCornerCoasting( bool v )
    {
      if (!isCornerCoastingImmutable())
        mCornerCoasting = v;
    }

    /**
      Get CornerCoasting
    */
    bool cornerCoasting() const
    {
      return mCornerCoasting;
    }

    /**
      Is CornerCoasting Immutable
    */
    bool isCornerCoastingImmutable() const
    {
      return isImmutable( QStringLiteral( "CornerCoasting" ) );
    }

    /**
      Set CoastingSpeed
    */
    void setCoastingSpeed( double v )
    {
      if (v < 0.1)
      {
        qDebug() << "setCoastingSpeed: value " << v << " is less than the minimum value of 0.1";
        v = 0.1;
      }

      if (v > 255)
      {
        qDebug() << "setCoastingSpeed: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isCoastingSpeedImmutable())
        mCoastingSpeed = v;
    }

    /**
      Get CoastingSpeed
    */
    double coastingSpeed() const
    {
      return mCoastingSpeed;
    }

    /**
      Is CoastingSpeed Immutable
    */
    bool isCoastingSpeedImmutable() const
    {
      return isImmutable( QStringLiteral( "CoastingSpeed" ) );
    }

    /**
      Set CoastingFriction
    */
    void setCoastingFriction( double v )
    {
      if (v < 0)
      {
        qDebug() << "setCoastingFriction: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 255)
      {
        qDebug() << "setCoastingFriction: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isCoastingFrictionImmutable())
        mCoastingFriction = v;
    }

    /**
      Get CoastingFriction
    */
    double coastingFriction() const
    {
      return mCoastingFriction;
    }

    /**
      Is CoastingFriction Immutable
    */
    bool isCoastingFrictionImmutable() const
    {
      return isImmutable( QStringLiteral( "CoastingFriction" ) );
    }

    /**
      Set Coasting
    */
    void setCoasting( bool v )
    {
      if (!isCoastingImmutable())
        mCoasting = v;
    }

    /**
      Get Coasting
    */
    bool coasting() const
    {
      return mCoasting;
    }

    /**
      Is Coasting Immutable
    */
    bool isCoastingImmutable() const
    {
      return isImmutable( QStringLiteral( "Coasting" ) );
    }

    /**
      Set FingerHigh
    */
    void setFingerHigh( int v )
    {
      if (v < 0)
      {
        qDebug() << "setFingerHigh: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 255)
      {
        qDebug() << "setFingerHigh: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isFingerHighImmutable())
        mFingerHigh = v;
    }

    /**
      Get FingerHigh
    */
    int fingerHigh() const
    {
      return mFingerHigh;
    }

    /**
      Is FingerHigh Immutable
    */
    bool isFingerHighImmutable() const
    {
      return isImmutable( QStringLiteral( "FingerHigh" ) );
    }

    /**
      Set FingerLow
    */
    void setFingerLow( int v )
    {
      if (v < 0)
      {
        qDebug() << "setFingerLow: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 255)
      {
        qDebug() << "setFingerLow: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isFingerLowImmutable())
        mFingerLow = v;
    }

    /**
      Get FingerLow
    */
    int fingerLow() const
    {
      return mFingerLow;
    }

    /**
      Is FingerLow Immutable
    */
    bool isFingerLowImmutable() const
    {
      return isImmutable( QStringLiteral( "FingerLow" ) );
    }

    /**
      Set PalmDetect
    */
    void setPalmDetect( bool v )
    {
      if (!isPalmDetectImmutable())
        mPalmDetect = v;
    }

    /**
      Get PalmDetect
    */
    bool palmDetect() const
    {
      return mPalmDetect;
    }

    /**
      Is PalmDetect Immutable
    */
    bool isPalmDetectImmutable() const
    {
      return isImmutable( QStringLiteral( "PalmDetect" ) );
    }

    /**
      Set PalmMinZ
    */
    void setPalmMinZ( int v )
    {
      if (v < 0)
      {
        qDebug() << "setPalmMinZ: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 255)
      {
        qDebug() << "setPalmMinZ: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isPalmMinZImmutable())
        mPalmMinZ = v;
    }

    /**
      Get PalmMinZ
    */
    int palmMinZ() const
    {
      return mPalmMinZ;
    }

    /**
      Is PalmMinZ Immutable
    */
    bool isPalmMinZImmutable() const
    {
      return isImmutable( QStringLiteral( "PalmMinZ" ) );
    }

    /**
      Set PalmMinWidth
    */
    void setPalmMinWidth( int v )
    {
      if (v < 0)
      {
        qDebug() << "setPalmMinWidth: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 15)
      {
        qDebug() << "setPalmMinWidth: value " << v << " is greater than the maximum value of 15";
        v = 15;
      }

      if (!isPalmMinWidthImmutable())
        mPalmMinWidth = v;
    }

    /**
      Get PalmMinWidth
    */
    int palmMinWidth() const
    {
      return mPalmMinWidth;
    }

    /**
      Is PalmMinWidth Immutable
    */
    bool isPalmMinWidthImmutable() const
    {
      return isImmutable( QStringLiteral( "PalmMinWidth" ) );
    }

    /**
      Set MaxTapTime
    */
    void setMaxTapTime( int v )
    {
      if (v < 0)
      {
        qDebug() << "setMaxTapTime: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1000)
      {
        qDebug() << "setMaxTapTime: value " << v << " is greater than the maximum value of 1000";
        v = 1000;
      }

      if (!isMaxTapTimeImmutable())
        mMaxTapTime = v;
    }

    /**
      Get MaxTapTime
    */
    int maxTapTime() const
    {
      return mMaxTapTime;
    }

    /**
      Is MaxTapTime Immutable
    */
    bool isMaxTapTimeImmutable() const
    {
      return isImmutable( QStringLiteral( "MaxTapTime" ) );
    }

    /**
      Set MaxDoubleTapTime
    */
    void setMaxDoubleTapTime( int v )
    {
      if (v < 0)
      {
        qDebug() << "setMaxDoubleTapTime: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1000)
      {
        qDebug() << "setMaxDoubleTapTime: value " << v << " is greater than the maximum value of 1000";
        v = 1000;
      }

      if (!isMaxDoubleTapTimeImmutable())
        mMaxDoubleTapTime = v;
    }

    /**
      Get MaxDoubleTapTime
    */
    int maxDoubleTapTime() const
    {
      return mMaxDoubleTapTime;
    }

    /**
      Is MaxDoubleTapTime Immutable
    */
    bool isMaxDoubleTapTimeImmutable() const
    {
      return isImmutable( QStringLiteral( "MaxDoubleTapTime" ) );
    }

    /**
      Set SingleTapTimeout
    */
    void setSingleTapTimeout( int v )
    {
      if (v < 0)
      {
        qDebug() << "setSingleTapTimeout: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1000)
      {
        qDebug() << "setSingleTapTimeout: value " << v << " is greater than the maximum value of 1000";
        v = 1000;
      }

      if (!isSingleTapTimeoutImmutable())
        mSingleTapTimeout = v;
    }

    /**
      Get SingleTapTimeout
    */
    int singleTapTimeout() const
    {
      return mSingleTapTimeout;
    }

    /**
      Is SingleTapTimeout Immutable
    */
    bool isSingleTapTimeoutImmutable() const
    {
      return isImmutable( QStringLiteral( "SingleTapTimeout" ) );
    }

    /**
      Set MaxTapMove
    */
    void setMaxTapMove( double v )
    {
      if (v < 0)
      {
        qDebug() << "setMaxTapMove: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 1000)
      {
        qDebug() << "setMaxTapMove: value " << v << " is greater than the maximum value of 1000";
        v = 1000;
      }

      if (!isMaxTapMoveImmutable())
        mMaxTapMove = v;
    }

    /**
      Get MaxTapMove
    */
    double maxTapMove() const
    {
      return mMaxTapMove;
    }

    /**
      Is MaxTapMove Immutable
    */
    bool isMaxTapMoveImmutable() const
    {
      return isImmutable( QStringLiteral( "MaxTapMove" ) );
    }

    /**
      Set PressureMotionMinZ
    */
    void setPressureMotionMinZ( int v )
    {
      if (v < 1)
      {
        qDebug() << "setPressureMotionMinZ: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 255)
      {
        qDebug() << "setPressureMotionMinZ: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isPressureMotionMinZImmutable())
        mPressureMotionMinZ = v;
    }

    /**
      Get PressureMotionMinZ
    */
    int pressureMotionMinZ() const
    {
      return mPressureMotionMinZ;
    }

    /**
      Is PressureMotionMinZ Immutable
    */
    bool isPressureMotionMinZImmutable() const
    {
      return isImmutable( QStringLiteral( "PressureMotionMinZ" ) );
    }

    /**
      Set PressureMotionMaxZ
    */
    void setPressureMotionMaxZ( int v )
    {
      if (v < 1)
      {
        qDebug() << "setPressureMotionMaxZ: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 255)
      {
        qDebug() << "setPressureMotionMaxZ: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isPressureMotionMaxZImmutable())
        mPressureMotionMaxZ = v;
    }

    /**
      Get PressureMotionMaxZ
    */
    int pressureMotionMaxZ() const
    {
      return mPressureMotionMaxZ;
    }

    /**
      Is PressureMotionMaxZ Immutable
    */
    bool isPressureMotionMaxZImmutable() const
    {
      return isImmutable( QStringLiteral( "PressureMotionMaxZ" ) );
    }

    /**
      Set PressureMotionMinFactor
    */
    void setPressureMotionMinFactor( double v )
    {
      if (v < 0)
      {
        qDebug() << "setPressureMotionMinFactor: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 10)
      {
        qDebug() << "setPressureMotionMinFactor: value " << v << " is greater than the maximum value of 10";
        v = 10;
      }

      if (!isPressureMotionMinFactorImmutable())
        mPressureMotionMinFactor = v;
    }

    /**
      Get PressureMotionMinFactor
    */
    double pressureMotionMinFactor() const
    {
      return mPressureMotionMinFactor;
    }

    /**
      Is PressureMotionMinFactor Immutable
    */
    bool isPressureMotionMinFactorImmutable() const
    {
      return isImmutable( QStringLiteral( "PressureMotionMinFactor" ) );
    }

    /**
      Set PressureMotionMaxFactor
    */
    void setPressureMotionMaxFactor( double v )
    {
      if (v < 0)
      {
        qDebug() << "setPressureMotionMaxFactor: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 10)
      {
        qDebug() << "setPressureMotionMaxFactor: value " << v << " is greater than the maximum value of 10";
        v = 10;
      }

      if (!isPressureMotionMaxFactorImmutable())
        mPressureMotionMaxFactor = v;
    }

    /**
      Get PressureMotionMaxFactor
    */
    double pressureMotionMaxFactor() const
    {
      return mPressureMotionMaxFactor;
    }

    /**
      Is PressureMotionMaxFactor Immutable
    */
    bool isPressureMotionMaxFactorImmutable() const
    {
      return isImmutable( QStringLiteral( "PressureMotionMaxFactor" ) );
    }

    /**
      Set CircularScrolling
    */
    void setCircularScrolling( bool v )
    {
      if (!isCircularScrollingImmutable())
        mCircularScrolling = v;
    }

    /**
      Get CircularScrolling
    */
    bool circularScrolling() const
    {
      return mCircularScrolling;
    }

    /**
      Is CircularScrolling Immutable
    */
    bool isCircularScrollingImmutable() const
    {
      return isImmutable( QStringLiteral( "CircularScrolling" ) );
    }

    /**
      Set CircScrollDelta
    */
    void setCircScrollDelta( double v )
    {
      if (v < 0)
      {
        qDebug() << "setCircScrollDelta: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 45)
      {
        qDebug() << "setCircScrollDelta: value " << v << " is greater than the maximum value of 45";
        v = 45;
      }

      if (!isCircScrollDeltaImmutable())
        mCircScrollDelta = v;
    }

    /**
      Get CircScrollDelta
    */
    double circScrollDelta() const
    {
      return mCircScrollDelta;
    }

    /**
      Is CircScrollDelta Immutable
    */
    bool isCircScrollDeltaImmutable() const
    {
      return isImmutable( QStringLiteral( "CircScrollDelta" ) );
    }

    /**
      Set CircScrollTrigger
    */
    void setCircScrollTrigger( Edge v )
    {
      if (!isCircScrollTriggerImmutable())
        mCircScrollTrigger = v;
    }

    /**
      Get CircScrollTrigger
    */
    Edge circScrollTrigger() const
    {
      return static_cast<Edge>(mCircScrollTrigger);
    }

    /**
      Is CircScrollTrigger Immutable
    */
    bool isCircScrollTriggerImmutable() const
    {
      return isImmutable( QStringLiteral( "CircScrollTrigger" ) );
    }

  protected:

    // parameters
    bool mTapping;
    int mButton[7];
    bool mVertEdgeScroll;
    bool mVertTwoFingerScroll;
    bool mHorizEdgeScroll;
    bool mHorizTwoFingerScroll;
    double mMinSpeed;
    double mMaxSpeed;
    double mAccelFactor;
    int mHorizHysteresis;
    int mVertHysteresis;
    bool mTapAndDragGesture;
    bool mLockedDrags;
    int mLockedDragTimeout;
    double mVertScrollDelta;
    bool mInvertVertScroll;
    double mHorizScrollDelta;
    bool mInvertHorizScroll;
    bool mCornerCoasting;
    double mCoastingSpeed;
    double mCoastingFriction;
    bool mCoasting;
    int mFingerHigh;
    int mFingerLow;
    bool mPalmDetect;
    int mPalmMinZ;
    int mPalmMinWidth;
    int mMaxTapTime;
    int mMaxDoubleTapTime;
    int mSingleTapTimeout;
    double mMaxTapMove;
    int mPressureMotionMinZ;
    int mPressureMotionMaxZ;
    double mPressureMotionMinFactor;
    double mPressureMotionMaxFactor;
    bool mCircularScrolling;
    double mCircScrollDelta;
    int mCircScrollTrigger;

  private:
};

#endif

