// ui/gfx/mojom/display_color_spaces.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"







namespace gfx {
namespace mojom {
class DisplayColorSpacesDataView;



}  // namespace mojom
}  // namespace gfx

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::DisplayColorSpacesDataView> {
  using Data = ::gfx::mojom::internal::DisplayColorSpaces_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx {
namespace mojom {


enum class ContentColorUsage : int32_t {
  
  kSRGB = 0,
  
  kWideColorGamut = 1,
  
  kHDR = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ContentColorUsage value);
inline bool IsKnownEnumValue(ContentColorUsage value) {
  return internal::ContentColorUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DisplayColorSpacesDataView {
 public:
  DisplayColorSpacesDataView() {}

  DisplayColorSpacesDataView(
      internal::DisplayColorSpaces_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetColorSpacesDataView(
      mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadColorSpaces(UserType* output) {
    
    auto* pointer = data_->color_spaces.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>>(
        pointer, output, context_);
  }
  inline void GetBufferFormatsDataView(
      mojo::ArrayDataView<::gfx::mojom::BufferFormat>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBufferFormats(UserType* output) {
    
    auto* pointer = data_->buffer_formats.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::BufferFormat>>(
        pointer, output, context_);
  }
  float sdr_white_level() const {
    return data_->sdr_white_level;
  }
 private:
  internal::DisplayColorSpaces_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace gfx

namespace std {

template <>
struct hash<::gfx::mojom::ContentColorUsage>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::ContentColorUsage> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::gfx::mojom::ContentColorUsage, ::gfx::mojom::ContentColorUsage> {
  static ::gfx::mojom::ContentColorUsage ToMojom(::gfx::mojom::ContentColorUsage input) { return input; }
  static bool FromMojom(::gfx::mojom::ContentColorUsage input, ::gfx::mojom::ContentColorUsage* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::ContentColorUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::ContentColorUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::gfx::mojom::ContentColorUsage>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::DisplayColorSpacesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::DisplayColorSpacesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gfx::mojom::internal::DisplayColorSpaces_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::color_spaces(input)) in_color_spaces = Traits::color_spaces(input);
    typename decltype((*output)->color_spaces)::BaseType::BufferWriter
        color_spaces_writer;
    const mojo::internal::ContainerValidateParams color_spaces_validate_params(
        6, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>>(
        in_color_spaces, buffer, &color_spaces_writer, &color_spaces_validate_params,
        context);
    (*output)->color_spaces.Set(
        color_spaces_writer.is_null() ? nullptr : color_spaces_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->color_spaces.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_spaces in DisplayColorSpaces struct");
    decltype(Traits::buffer_formats(input)) in_buffer_formats = Traits::buffer_formats(input);
    typename decltype((*output)->buffer_formats)::BaseType::BufferWriter
        buffer_formats_writer;
    const mojo::internal::ContainerValidateParams buffer_formats_validate_params(
        6, ::gfx::mojom::internal::BufferFormat_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::BufferFormat>>(
        in_buffer_formats, buffer, &buffer_formats_writer, &buffer_formats_validate_params,
        context);
    (*output)->buffer_formats.Set(
        buffer_formats_writer.is_null() ? nullptr : buffer_formats_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->buffer_formats.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buffer_formats in DisplayColorSpaces struct");
    (*output)->sdr_white_level = Traits::sdr_white_level(input);
  }

  static bool Deserialize(::gfx::mojom::internal::DisplayColorSpaces_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::DisplayColorSpacesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx {
namespace mojom {

inline void DisplayColorSpacesDataView::GetColorSpacesDataView(
    mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>* output) {
  auto pointer = data_->color_spaces.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>(pointer, context_);
}
inline void DisplayColorSpacesDataView::GetBufferFormatsDataView(
    mojo::ArrayDataView<::gfx::mojom::BufferFormat>* output) {
  auto pointer = data_->buffer_formats.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::BufferFormat>(pointer, context_);
}



}  // namespace mojom
}  // namespace gfx

#endif  // UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_SHARED_H_