// ui/accessibility/mojom/ax_action_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/accessibility/mojom/ax_action_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace ax {
namespace mojom {
class AXActionDataDataView;



}  // namespace mojom
}  // namespace ax

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXActionDataDataView> {
  using Data = ::ax::mojom::internal::AXActionData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax {
namespace mojom {


class AXActionDataDataView {
 public:
  AXActionDataDataView() {}

  AXActionDataDataView(
      internal::AXActionData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAction(UserType* output) const {
    auto data_value = data_->action;
    return mojo::internal::Deserialize<::ax::mojom::Action>(
        data_value, output);
  }

  ::ax::mojom::Action action() const {
    return static_cast<::ax::mojom::Action>(data_->action);
  }
  inline void GetTargetTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTargetTreeId(UserType* output) {
    
    auto* pointer = !data_->target_tree_id.is_null() ? &data_->target_tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, context_);
  }
  inline void GetSourceExtensionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSourceExtensionId(UserType* output) {
    
    auto* pointer = data_->source_extension_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  int32_t target_node_id() const {
    return data_->target_node_id;
  }
  int32_t request_id() const {
    return data_->request_id;
  }
  int32_t flags() const {
    return data_->flags;
  }
  int32_t anchor_node_id() const {
    return data_->anchor_node_id;
  }
  int32_t anchor_offset() const {
    return data_->anchor_offset;
  }
  int32_t focus_node_id() const {
    return data_->focus_node_id;
  }
  int32_t focus_offset() const {
    return data_->focus_offset;
  }
  int32_t custom_action_id() const {
    return data_->custom_action_id;
  }
  inline void GetTargetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTargetRect(UserType* output) {
    
    auto* pointer = data_->target_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  inline void GetTargetPointDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTargetPoint(UserType* output) {
    
    auto* pointer = data_->target_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, context_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHitTestEventToFire(UserType* output) const {
    auto data_value = data_->hit_test_event_to_fire;
    return mojo::internal::Deserialize<::ax::mojom::Event>(
        data_value, output);
  }

  ::ax::mojom::Event hit_test_event_to_fire() const {
    return static_cast<::ax::mojom::Event>(data_->hit_test_event_to_fire);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHorizontalScrollAlignment(UserType* output) const {
    auto data_value = data_->horizontal_scroll_alignment;
    return mojo::internal::Deserialize<::ax::mojom::ScrollAlignment>(
        data_value, output);
  }

  ::ax::mojom::ScrollAlignment horizontal_scroll_alignment() const {
    return static_cast<::ax::mojom::ScrollAlignment>(data_->horizontal_scroll_alignment);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVerticalScrollAlignment(UserType* output) const {
    auto data_value = data_->vertical_scroll_alignment;
    return mojo::internal::Deserialize<::ax::mojom::ScrollAlignment>(
        data_value, output);
  }

  ::ax::mojom::ScrollAlignment vertical_scroll_alignment() const {
    return static_cast<::ax::mojom::ScrollAlignment>(data_->vertical_scroll_alignment);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScrollBehavior(UserType* output) const {
    auto data_value = data_->scroll_behavior;
    return mojo::internal::Deserialize<::ax::mojom::ScrollBehavior>(
        data_value, output);
  }

  ::ax::mojom::ScrollBehavior scroll_behavior() const {
    return static_cast<::ax::mojom::ScrollBehavior>(data_->scroll_behavior);
  }
 private:
  internal::AXActionData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace ax

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXActionDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXActionDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::ax::mojom::internal::AXActionData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::ax::mojom::Action>(
        Traits::action(input), &(*output)->action);
    decltype(Traits::target_tree_id(input)) in_target_tree_id = Traits::target_tree_id(input);
    typename decltype((*output)->target_tree_id)::BufferWriter target_tree_id_writer;
    target_tree_id_writer.AllocateInline(buffer, &(*output)->target_tree_id);
    mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
        in_target_tree_id, buffer, &target_tree_id_writer, true, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->target_tree_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_tree_id in AXActionData struct");
    decltype(Traits::source_extension_id(input)) in_source_extension_id = Traits::source_extension_id(input);
    typename decltype((*output)->source_extension_id)::BaseType::BufferWriter
        source_extension_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_source_extension_id, buffer, &source_extension_id_writer, context);
    (*output)->source_extension_id.Set(
        source_extension_id_writer.is_null() ? nullptr : source_extension_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->source_extension_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_extension_id in AXActionData struct");
    (*output)->target_node_id = Traits::target_node_id(input);
    (*output)->request_id = Traits::request_id(input);
    (*output)->flags = Traits::flags(input);
    (*output)->anchor_node_id = Traits::anchor_node_id(input);
    (*output)->anchor_offset = Traits::anchor_offset(input);
    (*output)->focus_node_id = Traits::focus_node_id(input);
    (*output)->focus_offset = Traits::focus_offset(input);
    (*output)->custom_action_id = Traits::custom_action_id(input);
    decltype(Traits::target_rect(input)) in_target_rect = Traits::target_rect(input);
    typename decltype((*output)->target_rect)::BaseType::BufferWriter
        target_rect_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_target_rect, buffer, &target_rect_writer, context);
    (*output)->target_rect.Set(
        target_rect_writer.is_null() ? nullptr : target_rect_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->target_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_rect in AXActionData struct");
    decltype(Traits::target_point(input)) in_target_point = Traits::target_point(input);
    typename decltype((*output)->target_point)::BaseType::BufferWriter
        target_point_writer;
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_target_point, buffer, &target_point_writer, context);
    (*output)->target_point.Set(
        target_point_writer.is_null() ? nullptr : target_point_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->target_point.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_point in AXActionData struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in AXActionData struct");
    mojo::internal::Serialize<::ax::mojom::Event>(
        Traits::hit_test_event_to_fire(input), &(*output)->hit_test_event_to_fire);
    mojo::internal::Serialize<::ax::mojom::ScrollAlignment>(
        Traits::horizontal_scroll_alignment(input), &(*output)->horizontal_scroll_alignment);
    mojo::internal::Serialize<::ax::mojom::ScrollAlignment>(
        Traits::vertical_scroll_alignment(input), &(*output)->vertical_scroll_alignment);
    mojo::internal::Serialize<::ax::mojom::ScrollBehavior>(
        Traits::scroll_behavior(input), &(*output)->scroll_behavior);
  }

  static bool Deserialize(::ax::mojom::internal::AXActionData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXActionDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax {
namespace mojom {

inline void AXActionDataDataView::GetTargetTreeIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->target_tree_id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, context_);
}
inline void AXActionDataDataView::GetSourceExtensionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source_extension_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void AXActionDataDataView::GetTargetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->target_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void AXActionDataDataView::GetTargetPointDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->target_point.Get();
  *output = ::gfx::mojom::PointDataView(pointer, context_);
}
inline void AXActionDataDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_ACTION_DATA_MOJOM_SHARED_H_