// third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SHARED_INTERNAL_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "third_party/blink/public/mojom/v8_cache_options.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace blink {
namespace mojom {
namespace internal {
class WebPreferences_Data;

struct PointerType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct HoverType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct PreferredColorScheme_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct EditingBehavior_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ImageAnimationPolicy_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ViewportStyle_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct AutoplayPolicy_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct EffectiveConnectionType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) WebPreferences_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebPreferences_Data));
      new (data()) WebPreferences_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebPreferences_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebPreferences_Data>(index_);
    }
    WebPreferences_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> standard_font_family_map;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> fixed_font_family_map;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> serif_font_family_map;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> sans_serif_font_family_map;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> cursive_font_family_map;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> fantasy_font_family_map;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> pictograph_font_family_map;
  int32_t default_font_size;
  int32_t default_fixed_font_size;
  int32_t minimum_font_size;
  int32_t minimum_logical_font_size;
  mojo::internal::Pointer<mojo::internal::String_Data> default_encoding;
  uint8_t context_menu_on_mouse_up : 1;
  uint8_t javascript_enabled : 1;
  uint8_t web_security_enabled : 1;
  uint8_t loads_images_automatically : 1;
  uint8_t images_enabled : 1;
  uint8_t plugins_enabled : 1;
  uint8_t dom_paste_enabled : 1;
  uint8_t shrinks_standalone_images_to_fit : 1;
  uint8_t text_areas_are_resizable : 1;
  uint8_t allow_scripts_to_close_windows : 1;
  uint8_t remote_fonts_enabled : 1;
  uint8_t javascript_can_access_clipboard : 1;
  uint8_t xslt_enabled : 1;
  uint8_t dns_prefetching_enabled : 1;
  uint8_t data_saver_enabled : 1;
  uint8_t data_saver_holdback_web_api_enabled : 1;
  uint8_t local_storage_enabled : 1;
  uint8_t databases_enabled : 1;
  uint8_t application_cache_enabled : 1;
  uint8_t tabs_to_links : 1;
  uint8_t disable_ipc_flooding_protection : 1;
  uint8_t hyperlink_auditing_enabled : 1;
  uint8_t allow_universal_access_from_file_urls : 1;
  uint8_t allow_file_access_from_file_urls : 1;
  uint8_t webgl1_enabled : 1;
  uint8_t webgl2_enabled : 1;
  uint8_t pepper_3d_enabled : 1;
  uint8_t flash_3d_enabled : 1;
  uint8_t flash_stage3d_enabled : 1;
  uint8_t flash_stage3d_baseline_enabled : 1;
  uint8_t privileged_webgl_extensions_enabled : 1;
  uint8_t webgl_errors_to_console_enabled : 1;
  uint8_t hide_scrollbars : 1;
  uint8_t accelerated_2d_canvas_enabled : 1;
  uint8_t new_canvas_2d_api_enabled : 1;
  uint8_t antialiased_2d_canvas_disabled : 1;
  uint8_t antialiased_clips_2d_canvas_enabled : 1;
  uint8_t accelerated_filters_enabled : 1;
  uint8_t deferred_filters_enabled : 1;
  uint8_t container_culling_enabled : 1;
  uint8_t allow_running_insecure_content : 1;
  uint8_t disable_reading_from_canvas : 1;
  uint8_t strict_mixed_content_checking : 1;
  uint8_t strict_powerful_feature_restrictions : 1;
  uint8_t allow_geolocation_on_insecure_origins : 1;
  uint8_t strictly_block_blockable_mixed_content : 1;
  uint8_t block_mixed_plugin_content : 1;
  uint8_t password_echo_enabled : 1;
  uint8_t should_clear_document_background : 1;
  uint8_t enable_scroll_animator : 1;
  uint8_t prefers_reduced_motion : 1;
  uint8_t touch_event_feature_detection_enabled : 1;
  uint8_t enable_error_page : 1;
  uint8_t dont_send_key_events_to_javascript : 1;
  uint8_t barrel_button_for_drag_enabled : 1;
  uint8_t sync_xhr_in_documents_enabled : 1;
  uint8_t supports_multiple_windows : 1;
  uint8_t viewport_enabled : 1;
  uint8_t viewport_meta_enabled : 1;
  uint8_t shrinks_viewport_contents_to_fit : 1;
  uint8_t smooth_scroll_for_find_enabled : 1;
  uint8_t main_frame_resizes_are_orientation_changes : 1;
  uint8_t initialize_at_minimum_page_scale : 1;
  uint8_t smart_insert_delete_enabled : 1;
  int32_t pointer_events_max_touch_points;
  int32_t available_pointer_types;
  int32_t primary_pointer_type;
  int32_t available_hover_types;
  int32_t primary_hover_type;
  int32_t number_of_cpu_cores;
  int32_t editing_behavior;
  int32_t viewport_style;
  uint8_t spatial_navigation_enabled : 1;
  uint8_t navigate_on_drag_drop : 1;
  uint8_t record_whole_document : 1;
  uint8_t cookie_enabled : 1;
  uint8_t accelerated_video_decode_enabled : 1;
  uint8_t user_gesture_required_for_presentation : 1;
  uint8_t text_tracks_enabled : 1;
  uint8_t immersive_mode_enabled : 1;
  uint8_t double_tap_to_zoom_enabled : 1;
  uint8_t fullscreen_supported : 1;
  uint8_t text_autosizing_enabled : 1;
  uint8_t force_dark_mode_enabled : 1;
  uint8_t hide_download_ui : 1;
  uint8_t presentation_receiver : 1;
  uint8_t media_controls_enabled : 1;
  uint8_t do_not_update_selection_on_mutating_selection_range : 1;
  uint8_t picture_in_picture_enabled : 1;
  uint8_t translate_service_available : 1;
  uint8_t lazy_load_enabled : 1;
  uint8_t allow_mixed_content_upgrades : 1;
  uint8_t always_show_focus : 1;
  uint8_t touch_drag_drop_enabled : 1;
  uint8_t pad105_[1];
  int32_t v8_cache_options;
  int32_t animation_policy;
  float text_track_margin_percentage;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_background_color;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_text_color;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_text_size;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_text_shadow;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_font_family;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_font_style;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_font_variant;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_window_color;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_window_padding;
  mojo::internal::Pointer<mojo::internal::String_Data> text_track_window_radius;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> web_app_scope;
  float default_minimum_page_scale_factor;
  float default_maximum_page_scale_factor;
  int32_t autoplay_policy;
  int32_t preferred_color_scheme;
  int32_t low_priority_iframes_threshold;
  int32_t network_quality_estimator_web_holdback;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, int32_t>> lazy_frame_loading_distance_thresholds_px;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, int32_t>> lazy_image_loading_distance_thresholds_px;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, int32_t>> lazy_image_first_k_fully_load;

 private:
  WebPreferences_Data();
  ~WebPreferences_Data() = delete;
};
static_assert(sizeof(WebPreferences_Data) == 280,
              "Bad sizeof(WebPreferences_Data)");
// Used by WebPreferences::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct WebPreferences_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  WebPreferences_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~WebPreferences_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    WebPreferences_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    WebPreferences_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SHARED_INTERNAL_H_